// NOTE: This file is generated automatically and any manual changes to it will be overwritten
//
// Copyright 2024 Canonical Ltd.
// Licensed under the LGPLv3 with static-linking exception.
// See LICENCE file for details.

package guids

import (
	"github.com/canonical/go-efilib"
)

var guidToNameMap map[efi.GUID]string

func init() {
	guidToNameMap = map[efi.GUID]string{
		efi.GUID{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}: "ZeroGuid",
		efi.GUID{0x00, 0x00, 0x00, 0x00, 0xd6, 0x0e, 0x09, 0x4e, 0xbb, 0xf9, 0x28, 0x32, 0x5d, 0xb6, 0xba, 0x30}: "BSODDxeRuntime",
		efi.GUID{0x00, 0x04, 0x1f, 0xd3, 0x16, 0x7d, 0x16, 0x43, 0xbf, 0x88, 0x60, 0x65, 0x88, 0x3b, 0x40, 0x2b}: "EfiPchInfoProtocolGuid",
		efi.GUID{0x00, 0x05, 0x66, 0xce, 0x4d, 0x82, 0xe0, 0x11, 0xac, 0x72, 0x00, 0x02, 0xa5, 0xd5, 0xc5, 0x1b}: "HdLcdGraphicsDxe",
		efi.GUID{0x00, 0x06, 0x76, 0x6b, 0x5a, 0x8e, 0x45, 0x49, 0xab, 0x9c, 0x57, 0x32, 0xfa, 0x90, 0xa0, 0xb3}: "FjLanCapsuleDxe",
		efi.GUID{0x00, 0x09, 0x38, 0x7c, 0x96, 0x1b, 0x15, 0x46, 0x97, 0x8e, 0x89, 0xe0, 0x2e, 0x2c, 0x89, 0xd0}: "DebugDriverDxe",
		efi.GUID{0x00, 0x0b, 0xb2, 0xb9, 0xe5, 0x2f, 0x45, 0x84, 0xac, 0xc5, 0x8e, 0x29, 0xef, 0x01, 0xa3, 0xe6}: "AppleMemoryTest",
		efi.GUID{0x00, 0x1a, 0x46, 0x30, 0xec, 0xde, 0xf1, 0x4e, 0xb7, 0xb2, 0x6c, 0xa9, 0x51, 0x1b, 0x59, 0x82}: "AmiAgesaAcpi",
		efi.GUID{0x00, 0x1b, 0x87, 0x9a, 0x16, 0x1c, 0x61, 0x4f, 0x8d, 0x2c, 0x93, 0xb6, 0x65, 0x4b, 0x5a, 0xd6}: "FdtClientDxe",
		efi.GUID{0x00, 0x1c, 0x59, 0x3e, 0x4a, 0x9e, 0xdf, 0x11, 0x92, 0x44, 0x00, 0x02, 0xa5, 0xd5, 0xc5, 0x1b}: "EfiMmcHostProtocolGuid",
		efi.GUID{0x00, 0x1e, 0x79, 0x67, 0x05, 0x0c, 0xe7, 0x4a, 0xa9, 0x21, 0xfc, 0x40, 0x57, 0x22, 0x16, 0x53}: "TxtOneTouchDxe",
		efi.GUID{0x00, 0x23, 0xf1, 0x33, 0xf2, 0xfb, 0xe6, 0x45, 0xb6, 0xb7, 0x79, 0xaf, 0x60, 0x29, 0xc7, 0xd4}: "CmosButtonLoadDefaultsPei",
		efi.GUID{0x00, 0x27, 0x80, 0x38, 0x8a, 0x86, 0x4e, 0x4b, 0x81, 0xd4, 0x4f, 0x1b, 0xdc, 0xcf, 0xb4, 0x6f}: "EfiExtendedSalSst",
		efi.GUID{0x00, 0x2e, 0xc9, 0xd6, 0xab, 0x1f, 0x75, 0x47, 0x83, 0x10, 0x3a, 0xc1, 0xd7, 0x74, 0xc3, 0xcd}: "GenesysInit",
		efi.GUID{0x00, 0x2e, 0xfe, 0x2d, 0xe9, 0x2c, 0x22, 0x41, 0x9b, 0x1f, 0xdc, 0x5a, 0x64, 0x54, 0xc8, 0xad}: "FixedFlashInfo",
		efi.GUID{0x00, 0x2f, 0x51, 0xc0, 0x81, 0x01, 0xc0, 0x48, 0x8b, 0x71, 0x90, 0x50, 0x4b, 0x8f, 0x99, 0x1e}: "EfiBootNameLabel",
		efi.GUID{0x00, 0x31, 0x34, 0xea, 0x37, 0x1a, 0x39, 0x42, 0xa3, 0xcb, 0xb9, 0x22, 0x40, 0xb9, 0x35, 0xcf}: "SdioSmm",
		efi.GUID{0x00, 0x31, 0x7a, 0x07, 0x67, 0x16, 0xfa, 0x45, 0xb9, 0x8c, 0x37, 0x65, 0x1b, 0x50, 0x73, 0xee}: "TpmSmbiosDxe",
		efi.GUID{0x00, 0x37, 0x21, 0x96, 0x86, 0xab, 0x97, 0x43, 0x9d, 0x57, 0xab, 0xc7, 0xfe, 0x75, 0x47, 0x8c}: "MpmMoselleDxe",
		efi.GUID{0x00, 0x37, 0x68, 0x07, 0x6b, 0x03, 0x0b, 0x44, 0x8e, 0xba, 0x63, 0x7f, 0x9e, 0xcb, 0x3d, 0xeb}: "SioSmbusAccessSmm",
		efi.GUID{0x00, 0x37, 0x9a, 0xc4, 0x75, 0xa1, 0x51, 0x44, 0xba, 0xe1, 0x3e, 0x5f, 0x91, 0xd0, 0xd4, 0x6a}: "DellAmdCbsApcbUpdateSmm",
		efi.GUID{0x00, 0x37, 0xfc, 0x7f, 0x5e, 0x7c, 0x3f, 0x42, 0xa0, 0x4b, 0x32, 0xe9, 0xf1, 0x6a, 0x67, 0x27}: "SuperMPeiPrococol",
		efi.GUID{0x00, 0x3f, 0xb0, 0x13, 0xb8, 0x18, 0xda, 0x48, 0x8b, 0x1c, 0xb2, 0x90, 0xc6, 0x9b, 0xaa, 0xfe}: "EzFileBrowser",
		efi.GUID{0x00, 0x4b, 0x8f, 0x21, 0xf0, 0xe4, 0xad, 0x4c, 0x8a, 0x90, 0x57, 0x7b, 0x83, 0x3d, 0x01, 0x28}: "BixbyDxeDxe",
		efi.GUID{0x00, 0x52, 0x97, 0xc4, 0xf1, 0x64, 0xb6, 0x4f, 0x97, 0x73, 0xf6, 0xa9, 0xf8, 0x9d, 0x98, 0x5e}: "SaPegDataVariable",
		efi.GUID{0x00, 0x5b, 0xf0, 0xe2, 0x8b, 0x40, 0x2b, 0x4a, 0x91, 0x4b, 0xf3, 0x33, 0x0b, 0x31, 0x2f, 0x5e}: "SpeakerInit",
		efi.GUID{0x00, 0x63, 0xe8, 0x55, 0xb2, 0xf0, 0xaa, 0x44, 0xa5, 0xa4, 0xea, 0xee, 0xce, 0x2e, 0x98, 0x3b}: "PlatformToDriverDxe",
		efi.GUID{0x00, 0x67, 0xc9, 0x64, 0x4c, 0x6b, 0x0c, 0x48, 0xa3, 0xe1, 0xb8, 0xbd, 0xe8, 0xf6, 0x02, 0xb2}: "AmiPeiAfterMrcGuid",
		efi.GUID{0x00, 0x79, 0xfa, 0x63, 0xd2, 0x6d, 0xb3, 0x4b, 0x99, 0x76, 0x87, 0x0f, 0xe2, 0x7a, 0x53, 0xc2}: "BackButtonSmall",
		efi.GUID{0x00, 0x7b, 0x8f, 0xac, 0x5b, 0xc6, 0x68, 0x45, 0x88, 0x06, 0x9d, 0xea, 0x9e, 0x5f, 0x10, 0x85}: "DellStatusCodeHandlerSmm",
		efi.GUID{0x00, 0x86, 0xc5, 0x16, 0x4b, 0x55, 0x87, 0x45, 0x8c, 0x62, 0xa4, 0x09, 0x97, 0xcf, 0xe2, 0x06}: "ASRockNetSmtpBin",
		efi.GUID{0x00, 0x96, 0x8c, 0x4b, 0x58, 0x99, 0x3d, 0x44, 0xbe, 0x30, 0xf4, 0xb7, 0xa7, 0xe5, 0x34, 0x63}: "DxeSmartPowerOn",
		efi.GUID{0x00, 0x99, 0xdc, 0xe6, 0xf6, 0xcc, 0x2b, 0x45, 0x85, 0xfa, 0xc7, 0xf1, 0xe5, 0x2f, 0x01, 0x52}: "SlotDataUpdateDxeNeonCityEPECB",
		efi.GUID{0x00, 0x99, 0xf0, 0x7e, 0x97, 0x73, 0xc0, 0x45, 0x9c, 0xa6, 0x69, 0x83, 0x24, 0x39, 0x18, 0x70}: "DellAutoOsRecoveryDxe",
		efi.GUID{0x00, 0xa6, 0xbd, 0x57, 0xff, 0xd3, 0x59, 0x4a, 0x84, 0xcf, 0xcc, 0xb5, 0x3c, 0x94, 0x1a, 0xab}: "CrbSmbiosType4",
		efi.GUID{0x00, 0xae, 0x2f, 0xa8, 0x01, 0xdb, 0x37, 0x47, 0xa6, 0xda, 0x7a, 0x2e, 0x1a, 0x75, 0xc2, 0x03}: "SmbiosDataUpdateDxeSierra",
		efi.GUID{0x00, 0xb2, 0xf5, 0x4c, 0xb8, 0x68, 0xa5, 0x4c, 0x9e, 0xec, 0xb2, 0x3e, 0x3f, 0x50, 0x02, 0x9a}: "EfiPciIoProtocolGuid",
		efi.GUID{0x00, 0xb7, 0xf8, 0xe9, 0x13, 0x7e, 0x36, 0x47, 0x88, 0xda, 0x82, 0x62, 0x4a, 0xcd, 0xec, 0xdd}: "SystemInventoryInfoSmm",
		efi.GUID{0x00, 0xc6, 0x11, 0xc3, 0xe9, 0x84, 0x1e, 0x4f, 0xbf, 0x44, 0xbf, 0x36, 0xe3, 0x41, 0x51, 0x58}: "LenovoMailBoxPei",
		efi.GUID{0x00, 0xc9, 0x76, 0x9c, 0x8c, 0x1e, 0xe0, 0x11, 0x87, 0x66, 0x00, 0x02, 0xa5, 0xd5, 0xc5, 0x1b}: "L2X0CacheLibNull",
		efi.GUID{0x00, 0xcb, 0xeb, 0xec, 0xc8, 0xd9, 0xe4, 0x11, 0xaf, 0x3d, 0x8c, 0xdc, 0xd4, 0x26, 0xc9, 0x73}: "HttpBootDxe",
		efi.GUID{0x00, 0xd6, 0x95, 0xdc, 0xca, 0xb0, 0xec, 0x43, 0x87, 0x1a, 0x97, 0x6b, 0x8a, 0x55, 0xcc, 0xe0}: "NvramHdrInfo",
		efi.GUID{0x00, 0xd9, 0x0d, 0x58, 0x5d, 0x38, 0xd7, 0x11, 0x88, 0x3a, 0x00, 0x50, 0x04, 0x73, 0xd4, 0xeb}: "Uhcd",
		efi.GUID{0x00, 0xd9, 0xa6, 0x1a, 0xd1, 0x89, 0x21, 0x4c, 0x9c, 0x50, 0xed, 0xc7, 0x39, 0x0a, 0x67, 0xc3}: "SlotDataUpdateDxeNeonCityFPGA",
		efi.GUID{0x00, 0xdc, 0xea, 0x41, 0xb2, 0x8d, 0xfe, 0x4b, 0xb0, 0xea, 0xcb, 0xaa, 0xe7, 0xf4, 0xd3, 0x1b}: "SetupModifyProtocol",
		efi.GUID{0x00, 0xe7, 0xda, 0xb3, 0x77, 0x2a, 0xa4, 0x4e, 0xaf, 0x79, 0x32, 0x97, 0xb4, 0x84, 0xbe, 0x61}: "AmiMeasurePcioprom",
		efi.GUID{0x00, 0xed, 0x23, 0x3c, 0xb9, 0x56, 0x3d, 0x4b, 0x96, 0xb6, 0x44, 0xdb, 0x8f, 0xaf, 0x2e, 0x6b}: "BCVersion",
		efi.GUID{0x00, 0xee, 0xb0, 0xde, 0xdf, 0x18, 0x5c, 0x41, 0xaf, 0x03, 0x74, 0xd0, 0x9b, 0x0a, 0xad, 0x87}: "JedecNvDimm",
		efi.GUID{0x00, 0xf2, 0x64, 0x4a, 0x9c, 0xf9, 0xf3, 0x42, 0x80, 0xc7, 0x0d, 0x91, 0xe2, 0xd3, 0xeb, 0x5d}: "SioGpioControlDxe",
		efi.GUID{0x00, 0xf3, 0x9b, 0x1f, 0xfb, 0x67, 0xee, 0x46, 0xb6, 0xe7, 0x2b, 0x6f, 0x65, 0x90, 0x53, 0x1c}: "HpCertificateManagerDriverWmiSmm",
		efi.GUID{0x00, 0xf6, 0xcc, 0x17, 0xa4, 0x3a, 0xf7, 0x4f, 0x82, 0xd0, 0x19, 0xcb, 0xeb, 0x78, 0xf4, 0x43}: "MePolicyHelper",
		efi.GUID{0x00, 0xf8, 0x3b, 0xb6, 0x67, 0xf2, 0x55, 0x4f, 0x92, 0x17, 0xe9, 0x7f, 0xb3, 0xb6, 0x98, 0x46}: "DynamicPageCount",
		efi.GUID{0x01, 0x03, 0xcb, 0x08, 0x02, 0xf7, 0x88, 0x4f, 0xa1, 0xa2, 0xb5, 0x1c, 0x2d, 0x99, 0xe8, 0x0c}: "SioCashDrawerPei",
		efi.GUID{0x01, 0x12, 0x57, 0x2a, 0x66, 0x49, 0xf6, 0x47, 0x8b, 0x86, 0xf3, 0x1e, 0x41, 0xf3, 0x2f, 0x10}: "EfiEventLegacyBootGuid",
		efi.GUID{0x01, 0x18, 0x6a, 0xdf, 0xf8, 0x70, 0x2a, 0x4e, 0x86, 0x31, 0x62, 0xe2, 0x97, 0x56, 0x56, 0x09}: "DxeSioEmi",
		efi.GUID{0x01, 0x18, 0xcb, 0xfd, 0x03, 0xa3, 0x30, 0x44, 0x94, 0x81, 0x28, 0xf2, 0x98, 0xc0, 0x1e, 0xc9}: "SmcSwSmiFlashProtocol",
		efi.GUID{0x01, 0x20, 0xa9, 0xd2, 0xad, 0x22, 0xb9, 0x43, 0xbe, 0xbc, 0x1b, 0x15, 0x21, 0x00, 0xd8, 0xcc}: "EfiPeiPlatformTypeWolfPassPpi",
		efi.GUID{0x01, 0x24, 0x6b, 0xe3, 0x51, 0x22, 0x13, 0x4b, 0xaf, 0x67, 0xa1, 0xb2, 0xec, 0x56, 0x1e, 0x36}: "DellSimulatedECSmm",
		efi.GUID{0x01, 0x26, 0x62, 0xfc, 0xc2, 0x83, 0x56, 0x4c, 0x9a, 0x4d, 0xe7, 0x86, 0x42, 0xdf, 0x69, 0xb1}: "FjSysmanTeutatesPowerStateBin",
		efi.GUID{0x01, 0x26, 0x71, 0xbd, 0x2f, 0x08, 0x59, 0x4c, 0x86, 0x77, 0x2c, 0x8a, 0x3c, 0x29, 0x79, 0x48}: "LoadFileOnFv2",
		efi.GUID{0x01, 0x2b, 0x30, 0x05, 0x98, 0xe8, 0x4e, 0x49, 0x9f, 0xb1, 0x9e, 0x02, 0xdc, 0x5d, 0x7c, 0xcc}: "EcMudPei",
		efi.GUID{0x01, 0x34, 0xf8, 0x9d, 0xa9, 0xc0, 0xbd, 0x4f, 0xbe, 0x58, 0x98, 0x64, 0x93, 0x83, 0x7b, 0xe8}: "FjFlashMapSmm",
		efi.GUID{0x01, 0x3b, 0x40, 0x5c, 0x30, 0x8c, 0x68, 0x4e, 0x96, 0xa0, 0x55, 0x61, 0x2f, 0x9c, 0x32, 0xb9}: "AsusEcDxeBs",
		efi.GUID{0x01, 0x40, 0x64, 0xbe, 0xd4, 0xe7, 0xb1, 0x48, 0xb0, 0x96, 0x8b, 0xa0, 0x47, 0xbc, 0x7a, 0xe7}: "EfiHtBistHob",
		efi.GUID{0x01, 0x40, 0xc9, 0xca, 0x11, 0x56, 0x40, 0x44, 0x9b, 0x21, 0xf5, 0x4b, 0x70, 0x0a, 0x1d, 0x34}: "DellSmmSystemSioProtocol",
		efi.GUID{0x01, 0x42, 0x84, 0x4b, 0xe9, 0x6f, 0xd1, 0x41, 0xb4, 0x6f, 0xdf, 0xfc, 0x34, 0xe4, 0x92, 0xa2}: "EfiDprRegsProgrammed",
		efi.GUID{0x01, 0x43, 0xf9, 0xfc, 0x63, 0x97, 0x64, 0x4a, 0xaa, 0x84, 0x78, 0x92, 0xc4, 0x71, 0x23, 0x67}: "IpSecDxe",
		efi.GUID{0x01, 0x4c, 0x54, 0xc1, 0xa4, 0x92, 0x98, 0x41, 0x8a, 0x84, 0x77, 0x85, 0x83, 0xc2, 0x36, 0x21}: "EfiPxeDhcp4CallbackProtocol",
		efi.GUID{0x01, 0x53, 0x0b, 0x8f, 0x9b, 0xc7, 0xf1, 0x44, 0x8f, 0xd3, 0x26, 0xd7, 0x3e, 0x31, 0x67, 0x00}: "PowerMgmtSmm",
		efi.GUID{0x01, 0x54, 0xf7, 0x12, 0x15, 0x54, 0xf3, 0x4f, 0xa9, 0x81, 0xa3, 0x9b, 0xee, 0x9f, 0x36, 0x9e}: "SerialRecovery",
		efi.GUID{0x01, 0x58, 0xb6, 0xcd, 0x4d, 0x49, 0x2e, 0x47, 0xa6, 0xa8, 0xaf, 0xf5, 0xb7, 0x6e, 0x8d, 0x1f}: "DellTxtConfigPei",
		efi.GUID{0x01, 0x5d, 0x12, 0x69, 0x51, 0xf9, 0xe9, 0x47, 0x95, 0x83, 0xef, 0x6a, 0x27, 0xaf, 0x70, 0x3e}: "SpiAccessDxe",
		efi.GUID{0x01, 0x5e, 0xf9, 0x14, 0x62, 0xd5, 0x2e, 0x43, 0x84, 0x4a, 0x95, 0xa4, 0x39, 0x05, 0x10, 0x7e}: "GuidBase",
		efi.GUID{0x01, 0x63, 0xe3, 0x87, 0x06, 0x04, 0xdb, 0x44, 0xaa, 0xf3, 0x9e, 0x0e, 0x59, 0x1f, 0x37, 0x25}: "VConfig",
		efi.GUID{0x01, 0x67, 0x65, 0x73, 0x3a, 0xd1, 0xab, 0x47, 0xb0, 0xee, 0x48, 0x49, 0x53, 0x7c, 0xdf, 0xac}: "SgxEarlyInitPeimSPR",
		efi.GUID{0x01, 0x79, 0x89, 0x80, 0xf6, 0x91, 0xfe, 0x4e, 0x95, 0x79, 0x33, 0x53, 0xa0, 0xc0, 0x2d, 0xab}: "SDMediaDevice",
		efi.GUID{0x01, 0x7e, 0x3e, 0x07, 0x11, 0x26, 0x85, 0x4e, 0xb8, 0x96, 0xa3, 0xb6, 0x76, 0x7c, 0xba, 0x00}: "AmiTsePasswordPromptEnterGuid",
		efi.GUID{0x01, 0x83, 0xde, 0xda, 0x29, 0xcb, 0xd5, 0x4f, 0x81, 0x48, 0x56, 0xfd, 0x24, 0x6c, 0x5b, 0x88}: "UefiApplicationEntryPoint",
		efi.GUID{0x01, 0x9a, 0x39, 0x11, 0x23, 0x04, 0xcc, 0x49, 0x83, 0x68, 0x85, 0x29, 0x15, 0x33, 0xc3, 0x5d}: "FprSynapticsMetallicaDriver",
		efi.GUID{0x01, 0xa6, 0x68, 0x04, 0x35, 0xc5, 0xfd, 0x46, 0xa9, 0x5d, 0xbb, 0xab, 0x99, 0x1b, 0x17, 0x8c}: "EfiPowerOnHobGuid",
		efi.GUID{0x01, 0xa7, 0x39, 0x46, 0xf9, 0x74, 0x35, 0x46, 0xb1, 0x26, 0x9f, 0xf0, 0x48, 0xd6, 0xb0, 0xd0}: "AmiTseOemPortingVar17",
		efi.GUID{0x01, 0xab, 0xf8, 0x26, 0xcd, 0xd3, 0x9c, 0x48, 0x98, 0x4f, 0xdf, 0xde, 0xf7, 0x68, 0x39, 0x5b}: "PeiStatusCodeMemoryPpi",
		efi.GUID{0x01, 0xac, 0x2d, 0xe4, 0x60, 0x22, 0x0b, 0x4d, 0xad, 0xf9, 0x86, 0xd3, 0x88, 0x83, 0x96, 0xfd}: "FjMacPei",
		efi.GUID{0x01, 0xba, 0x17, 0x73, 0x4c, 0xc3, 0xe2, 0x4d, 0xbb, 0x19, 0x1a, 0xd8, 0xa6, 0x12, 0xa1, 0xa4}: "FjVariableAccessServicesSmm",
		efi.GUID{0x01, 0xbe, 0x6b, 0x45, 0xd0, 0x99, 0xea, 0x45, 0xbb, 0x5f, 0x16, 0xd8, 0x4b, 0xed, 0xc5, 0x59}: "EfiRestExServiceBindingProtocol",
		efi.GUID{0x01, 0xbf, 0xae, 0x70, 0xa0, 0x9e, 0xd8, 0x48, 0xae, 0x17, 0x3a, 0x18, 0x4b, 0x12, 0xdb, 0xfe}: "TseDefaultBootOrder",
		efi.GUID{0x01, 0xc9, 0x3a, 0x53, 0x15, 0xa1, 0x06, 0x48, 0x9c, 0x4e, 0xbd, 0x6d, 0x72, 0xc7, 0xab, 0xde}: "UpdateErrorInfo",
		efi.GUID{0x01, 0xd9, 0x8e, 0x09, 0xbf, 0xc6, 0x20, 0x4d, 0x91, 0xe2, 0xa3, 0x9f, 0x0c, 0x08, 0x4a, 0x8d}: "QuickSpi",
		efi.GUID{0x01, 0xe1, 0x05, 0xe3, 0x3a, 0x91, 0x51, 0x4a, 0x8e, 0x0e, 0xb4, 0x61, 0x8c, 0x5d, 0xb3, 0x26}: "DellDxePchGpioControl",
		efi.GUID{0x01, 0xf0, 0x08, 0x1f, 0x83, 0xac, 0xd3, 0x43, 0x99, 0x6b, 0x47, 0xfa, 0xe1, 0x53, 0xcb, 0x2a}: "DisableAbtSetup",
		efi.GUID{0x01, 0xf5, 0x26, 0xd3, 0x17, 0x4d, 0x44, 0x6e, 0xc8, 0x40, 0x20, 0x84, 0x26, 0xf9, 0x0c, 0xec}: "Pca9535aPei",
		efi.GUID{0x01, 0xf8, 0xdd, 0x74, 0xdc, 0xa7, 0x10, 0x44, 0x9d, 0xf8, 0xc0, 0x8e, 0x6d, 0x9f, 0xd6, 0xbb}: "FpgaCapsule",
		efi.GUID{0x01, 0xfa, 0xbf, 0xae, 0xdc, 0x7e, 0xff, 0x49, 0x8d, 0x88, 0xcb, 0x84, 0x8c, 0x5e, 0x86, 0x70}: "SiPolicyPpiGuid",
		efi.GUID{0x01, 0xfd, 0x8a, 0x8b, 0x32, 0x8a, 0x49, 0x42, 0x98, 0x00, 0xfa, 0xbc, 0x2b, 0x10, 0x84, 0xe5}: "BluetoothSmm",
		efi.GUID{0x02, 0x03, 0x9c, 0xf9, 0x56, 0x92, 0x50, 0x40, 0xb4, 0x1d, 0xf2, 0x4b, 0x87, 0xf7, 0x02, 0xd2}: "KeyboardLayouts",
		efi.GUID{0x02, 0x0d, 0xab, 0x39, 0x44, 0xc2, 0xdc, 0x40, 0xb3, 0x91, 0x5a, 0x6e, 0xc2, 0xcc, 0xfc, 0x1c}: "FidoDxe",
		efi.GUID{0x02, 0x1c, 0x75, 0xf5, 0x78, 0x53, 0x9a, 0x46, 0x85, 0x14, 0x07, 0x56, 0x2d, 0x50, 0x57, 0xa6}: "CheckWakeUp",
		efi.GUID{0x02, 0x24, 0x3b, 0xc5, 0x73, 0x00, 0x8c, 0x4c, 0xb4, 0xed, 0x99, 0xf3, 0x62, 0x74, 0x2d, 0x24}: "CrbSdev",
		efi.GUID{0x02, 0x2d, 0x5c, 0x8f, 0x2b, 0xaf, 0xde, 0x49, 0xb8, 0xd8, 0xdf, 0x90, 0x13, 0x0a, 0x25, 0x12}: "FlashMeDxe",
		efi.GUID{0x02, 0x2e, 0x5a, 0x8f, 0x8c, 0x53, 0x59, 0x4d, 0xb9, 0x20, 0xc4, 0x78, 0x6a, 0xcb, 0xc5, 0x52}: "Ahci",
		efi.GUID{0x02, 0x35, 0x5d, 0x5f, 0x4b, 0x8a, 0xca, 0x40, 0x88, 0xa2, 0x23, 0x05, 0x42, 0x7a, 0x13, 0x1a}: "SaPegDataHob",
		efi.GUID{0x02, 0x51, 0xd7, 0x5a, 0x4c, 0x5b, 0xa9, 0x44, 0xa7, 0xd6, 0xda, 0x92, 0x5b, 0xbc, 0x49, 0xa5}: "EhciSmm",
		efi.GUID{0x02, 0x52, 0xe6, 0x1b, 0x18, 0x93, 0x2d, 0x49, 0xa5, 0x51, 0x08, 0xdf, 0x2b, 0xd6, 0x0a, 0xee}: "AmtPlatformPolicy",
		efi.GUID{0x02, 0x54, 0x88, 0xa6, 0x22, 0xd0, 0x0e, 0x4b, 0xa5, 0x09, 0x47, 0x11, 0xb9, 0x0f, 0x2a, 0x39}: "ReportStatusCodeRouterSmm",
		efi.GUID{0x02, 0x57, 0xbd, 0x7c, 0xe3, 0xc8, 0x7e, 0x4f, 0xba, 0x08, 0xec, 0x7e, 0xf1, 0xbb, 0x2d, 0x67}: "IrqTableInfo",
		efi.GUID{0x02, 0x59, 0xa6, 0x4a, 0xd3, 0x3e, 0xb3, 0x43, 0xa5, 0x2b, 0xfc, 0x1d, 0x6c, 0x07, 0x7a, 0xe4}: "AhciBusPei",
		efi.GUID{0x02, 0x6a, 0x53, 0x5c, 0xfe, 0xbd, 0x47, 0x4f, 0xbf, 0x72, 0x18, 0xff, 0x5d, 0xea, 0xf8, 0xe9}: "FchSandstonePei",
		efi.GUID{0x02, 0x73, 0x42, 0xe6, 0x37, 0x1b, 0x55, 0x4b, 0x8d, 0xd5, 0xf4, 0x3a, 0x2f, 0x01, 0x8d, 0xe2}: "AmdCpmModernStandbyInitPei",
		efi.GUID{0x02, 0x78, 0x19, 0x2a, 0x69, 0xe4, 0xa7, 0x4f, 0xa3, 0x7b, 0x2d, 0x68, 0x1b, 0xcf, 0x41, 0x6f}: "TrackPointElan",
		efi.GUID{0x02, 0x78, 0x36, 0xd5, 0x73, 0xb8, 0x0f, 0x4c, 0xb5, 0x44, 0x31, 0xb7, 0xcc, 0xf5, 0xc5, 0x55}: "CmosManagerHob",
		efi.GUID{0x02, 0x7d, 0x11, 0xd8, 0xa6, 0x94, 0xd4, 0x11, 0x9a, 0x3a, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d}: "EfiPeiTransferControl",
		efi.GUID{0x02, 0x87, 0x7f, 0x5c, 0x8f, 0x83, 0xdf, 0x43, 0x91, 0xe6, 0x78, 0x33, 0xb6, 0xf2, 0xa0, 0x67}: "DxeCoreReportStatusCodeLibFromHob",
		efi.GUID{0x02, 0x87, 0xc6, 0x61, 0x7e, 0x4d, 0x43, 0x4f, 0x8d, 0xef, 0xa7, 0x43, 0x05, 0xce, 0x74, 0xc5}: "PeiSmmControlPpiGuid",
		efi.GUID{0x02, 0x87, 0xcc, 0xcc, 0x68, 0xbd, 0xb1, 0x45, 0x82, 0x37, 0xc7, 0xdd, 0x00, 0x4c, 0xdb, 0x37}: "DellSmBiosStrucD2",
		efi.GUID{0x02, 0x94, 0xa3, 0xed, 0x75, 0xf3, 0x96, 0x44, 0x92, 0xd3, 0x83, 0xb4, 0x3c, 0xb8, 0xa7, 0x6a}: "SmBiosMemory",
		efi.GUID{0x02, 0x99, 0xd6, 0x42, 0xe7, 0x10, 0x07, 0x49, 0xad, 0x3b, 0x46, 0xa5, 0xbf, 0x25, 0xa1, 0xa0}: "NvmeUnlockPei",
		efi.GUID{0x02, 0xa1, 0xc5, 0x02, 0xea, 0x58, 0x53, 0x4e, 0x8b, 0xe1, 0x6e, 0xd1, 0xac, 0xaa, 0x70, 0x8a}: "AmdMemoryHobInfoPeim",
		efi.GUID{0x02, 0xa3, 0x6b, 0xa1, 0x14, 0x65, 0x87, 0x42, 0xbe, 0xe3, 0x62, 0x23, 0xb7, 0xde, 0x2c, 0x21}: "NVRAMID",
		efi.GUID{0x02, 0xab, 0x30, 0x70, 0x4d, 0xb0, 0xbe, 0x4a, 0x88, 0x01, 0x20, 0x20, 0x1d, 0x0c, 0x56, 0x6a}: "ASUSFancyStart",
		efi.GUID{0x02, 0xaf, 0xb5, 0x63, 0xc8, 0x29, 0xa1, 0x47, 0x90, 0xfb, 0x55, 0xd3, 0x31, 0xfe, 0x47, 0x91}: "AmdHotPlugSspSmm",
		efi.GUID{0x02, 0xb8, 0x66, 0xc1, 0x0f, 0x19, 0xfe, 0x4b, 0xb8, 0xcd, 0xee, 0x53, 0x97, 0x1a, 0x06, 0x3c}: "PeiMeCore",
		efi.GUID{0x02, 0xbb, 0xfd, 0x6c, 0x4b, 0xdb, 0x87, 0x4c, 0xbe, 0x13, 0xb4, 0xe7, 0x9e, 0x68, 0xce, 0x51}: "CbsBasePei",
		efi.GUID{0x02, 0xbc, 0x21, 0x92, 0x2e, 0x8f, 0xca, 0x4c, 0xba, 0x89, 0xea, 0x6f, 0x91, 0xa4, 0x17, 0x5e}: "CsmLoader",
		efi.GUID{0x02, 0xc4, 0x2e, 0xea, 0xd5, 0x2f, 0x5f, 0x47, 0x92, 0x2c, 0x98, 0xea, 0xe0, 0x37, 0x63, 0x12}: "SystemLegacyBiosDxe",
		efi.GUID{0x02, 0xc5, 0x7c, 0x34, 0x6c, 0xeb, 0xa0, 0x44, 0x94, 0x98, 0x60, 0x58, 0x88, 0xc9, 0x4e, 0x0d}: "HandleStatusInSMM",
		efi.GUID{0x02, 0xcb, 0x7c, 0x9c, 0x54, 0x91, 0x64, 0x48, 0x9e, 0x4b, 0xdc, 0x04, 0x87, 0xe3, 0x76, 0x60}: "DhcpDummyDxe",
		efi.GUID{0x02, 0xcf, 0x1a, 0x72, 0x77, 0x4d, 0x2a, 0x4c, 0xb3, 0xdc, 0x27, 0x0b, 0x7b, 0xa9, 0xe4, 0xb0}: "FspNonVolatileStorageHobGuid",
		efi.GUID{0x02, 0xd1, 0x7d, 0xc7, 0xb4, 0x1d, 0x97, 0x49, 0xae, 0x37, 0x4e, 0x8c, 0x52, 0x1e, 0xf5, 0x67}: "AmiProcessTcgSetupGuid",
		efi.GUID{0x02, 0xe2, 0xa0, 0x1c, 0x9e, 0xfe, 0x76, 0x47, 0x9f, 0xaa, 0x57, 0x0c, 0x19, 0x61, 0x7a, 0x06}: "EfiPciCallbackProtocol",
		efi.GUID{0x02, 0xe4, 0xa8, 0x03, 0xb7, 0x2a, 0xb3, 0x46, 0xb5, 0x91, 0x74, 0x03, 0x83, 0x79, 0x6b, 0x82}: "AmdMemChanXLatDummyPei",
		efi.GUID{0x02, 0xe7, 0x11, 0xff, 0x23, 0x89, 0xcc, 0x47, 0xad, 0x30, 0xd9, 0xe0, 0xe2, 0x40, 0xdd, 0x10}: "AAFTblDxe",
		efi.GUID{0x03, 0x00, 0xb8, 0x93, 0xb3, 0x9f, 0xd4, 0x11, 0x9a, 0x3a, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d}: "IsaSerialDxe",
		efi.GUID{0x03, 0x0a, 0x6d, 0x6b, 0x5d, 0xfd, 0x10, 0x4e, 0x97, 0x74, 0x2d, 0x3e, 0xaa, 0x62, 0xeb, 0x61}: "SklRaidDriver",
		efi.GUID{0x03, 0x10, 0xde, 0xda, 0x31, 0x1b, 0xe4, 0x4f, 0x85, 0x57, 0x26, 0xfc, 0xef, 0xc7, 0x82, 0x75}: "InjectorKext",
		efi.GUID{0x03, 0x11, 0xe0, 0x90, 0x84, 0xf7, 0x20, 0x40, 0x91, 0xac, 0xc5, 0x1e, 0x8b, 0xf5, 0x53, 0xb2}: "LenovoWmaPciDxe",
		efi.GUID{0x03, 0x14, 0xdd, 0xe5, 0x22, 0xd6, 0x4e, 0xc2, 0x84, 0x88, 0xc7, 0x1b, 0x17, 0xf5, 0xe8, 0x02}: "EfiAdapterInformationProtocolGuid",
		efi.GUID{0x03, 0x14, 0xf6, 0x2d, 0x80, 0xc1, 0xa5, 0x45, 0xa2, 0x2b, 0x1a, 0x3d, 0xb8, 0x8f, 0xe9, 0xba}: "DellGenericSioDxe",
		efi.GUID{0x03, 0x15, 0xbd, 0x1d, 0x60, 0x0a, 0x30, 0x42, 0xaa, 0xa3, 0x80, 0x16, 0xd8, 0xc3, 0xde, 0x2f}: "EfiSmmIpmiTransportProtocol",
		efi.GUID{0x03, 0x17, 0xcd, 0xf9, 0x08, 0x81, 0xcd, 0x45, 0x93, 0x84, 0x5b, 0x24, 0x7b, 0x8c, 0xaf, 0xf5}: "SerialIoDxe",
		efi.GUID{0x03, 0x1f, 0x68, 0x11, 0x8b, 0x6b, 0xad, 0x4c, 0x83, 0xe7, 0x58, 0x8a, 0x64, 0xbc, 0x64, 0xea}: "FjPowerOverEthernetD2927",
		efi.GUID{0x03, 0x21, 0xc6, 0xc7, 0x52, 0x5e, 0xbf, 0x41, 0x82, 0x0a, 0x2b, 0x2c, 0x21, 0xa8, 0x98, 0x25}: "BdatDxe",
		efi.GUID{0x03, 0x25, 0x05, 0xff, 0xf9, 0x1a, 0xeb, 0x4a, 0x83, 0xc4, 0xc2, 0xd4, 0xce, 0xb1, 0x0c, 0xa3}: "PhoenixEfiSmmSwSmiProtocolGuid",
		efi.GUID{0x03, 0x32, 0x4c, 0x44, 0xb1, 0xf8, 0xa7, 0x42, 0xab, 0xe9, 0x2e, 0x58, 0x02, 0x5b, 0xe1, 0x2a}: "FpdtPerformanceProtocol",
		efi.GUID{0x03, 0x37, 0x26, 0xd1, 0xc0, 0xd6, 0x54, 0x43, 0xa7, 0xbe, 0x9b, 0x63, 0x5e, 0xc9, 0x9c, 0x4a}: "TpmToollessFwUpd",
		efi.GUID{0x03, 0x37, 0xfc, 0xd1, 0x91, 0x65, 0xe9, 0x4a, 0xa7, 0x95, 0xc5, 0x62, 0x8c, 0xcf, 0x52, 0x36}: "DellSmmNbProtocol",
		efi.GUID{0x03, 0x40, 0x2c, 0x0c, 0x51, 0x65, 0xea, 0x4e, 0xb0, 0x06, 0x0f, 0xec, 0xb4, 0xbb, 0x30, 0x0b}: "RTL8111E",
		efi.GUID{0x03, 0x5a, 0x6c, 0xc0, 0x4c, 0x70, 0xd6, 0x45, 0x80, 0x8e, 0x4d, 0x9e, 0x86, 0x78, 0x97, 0xd3}: "AppleEffaceableLocker",
		efi.GUID{0x03, 0x64, 0x79, 0x99, 0x03, 0xcf, 0xec, 0x42, 0xa8, 0x17, 0x71, 0x83, 0x41, 0x1d, 0x79, 0xe2}: "PchSmbusDxe",
		efi.GUID{0x03, 0x66, 0x98, 0x65, 0xbc, 0x43, 0xbf, 0x4a, 0x94, 0xd8, 0x5a, 0x58, 0x84, 0x73, 0x81, 0xa6}: "SiliconPolicyDxe",
		efi.GUID{0x03, 0x67, 0x78, 0x8b, 0xc7, 0xe8, 0xea, 0x4b, 0x8f, 0x07, 0xcd, 0xf9, 0x91, 0xb9, 0x09, 0x99}: "AmdPspDxeV2Rv",
		efi.GUID{0x03, 0x68, 0xd4, 0x28, 0x46, 0x76, 0xfe, 0x4d, 0x90, 0xed, 0x85, 0x75, 0x58, 0x4e, 0xd6, 0xe6}: "AmtDxePolicyInit",
		efi.GUID{0x03, 0x6a, 0x50, 0xaa, 0x54, 0x4a, 0x2b, 0x49, 0x8f, 0x2b, 0x9a, 0xd9, 0xa9, 0x49, 0x35, 0x8a}: "UfsBootLunIdHobGuid",
		efi.GUID{0x03, 0x6b, 0x56, 0x25, 0x77, 0xb5, 0xbf, 0x4c, 0x95, 0x8c, 0xed, 0x66, 0x3e, 0xa2, 0x43, 0x80}: "EfiSmmGpiDispatch2ProtocolGuid",
		efi.GUID{0x03, 0x71, 0xb0, 0xbe, 0xf9, 0x05, 0x5d, 0x4b, 0x89, 0xaf, 0x29, 0x47, 0x1d, 0x59, 0x3c, 0xd5}: "S5Charging",
		efi.GUID{0x03, 0x7b, 0x83, 0x4b, 0x87, 0x65, 0x19, 0x4d, 0xb8, 0x2b, 0xed, 0xfa, 0xd8, 0x36, 0xc0, 0xa0}: "SecMain",
		efi.GUID{0x03, 0x92, 0x32, 0x67, 0xa6, 0xba, 0xca, 0x49, 0xb3, 0xc2, 0x37, 0x84, 0xeb, 0x51, 0x70, 0x17}: "KvmPlatformDxe",
		efi.GUID{0x03, 0xa5, 0x3d, 0xac, 0xe7, 0x65, 0x53, 0x41, 0x96, 0xfc, 0x87, 0x07, 0xfb, 0x75, 0x94, 0xfb}: "ASUSBIOSInfo",
		efi.GUID{0x03, 0xae, 0x2c, 0xd3, 0xfe, 0xff, 0x67, 0x4f, 0xbb, 0xf9, 0x7c, 0xb8, 0x51, 0xc4, 0x58, 0x0e}: "SmcFeatureSupportFlags",
		efi.GUID{0x03, 0xb9, 0x2d, 0xbe, 0xc2, 0xb7, 0xbc, 0x4a, 0x8f, 0x64, 0xb0, 0x6e, 0x70, 0x5d, 0x27, 0xe7}: "PostWave",
		efi.GUID{0x03, 0xbe, 0x24, 0x59, 0xd8, 0x9d, 0xab, 0x4b, 0x80, 0x8f, 0xc2, 0x1c, 0xab, 0xfe, 0x0b, 0x4b}: "DellErrorHandlerPei",
		efi.GUID{0x03, 0xc1, 0x67, 0x84, 0xf6, 0x6f, 0x66, 0x4d, 0x86, 0xf6, 0xe1, 0x12, 0x4c, 0x11, 0x1e, 0x94}: "DellHotKeyHandlerSmm",
		efi.GUID{0x03, 0xc1, 0x67, 0x84, 0xf6, 0x6f, 0x66, 0x4d, 0x86, 0xf6, 0xe1, 0x12, 0x4c, 0x11, 0x1e, 0x95}: "NbLegUsbPolicyload",
		efi.GUID{0x03, 0xd3, 0x22, 0x8d, 0xd5, 0x69, 0xc9, 0x40, 0xa7, 0x1e, 0x5c, 0x38, 0xc9, 0x51, 0xfc, 0x18}: "LegacyUsbIrqSolutionWADxe",
		efi.GUID{0x03, 0xdb, 0x8a, 0xe9, 0xb9, 0xb8, 0xf8, 0x4a, 0xba, 0x20, 0x26, 0xe9, 0x11, 0x4c, 0xbc, 0xe5}: "EfiUserCredential2ProtocolGuid",
		efi.GUID{0x03, 0xe6, 0xc4, 0x03, 0x28, 0xac, 0xd3, 0x11, 0x9a, 0x2d, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d}: "EfiPxeBaseCodeProtocolGuid",
		efi.GUID{0x03, 0xe9, 0x82, 0xc2, 0xe5, 0x24, 0x18, 0x44, 0xa9, 0x78, 0xa7, 0x41, 0x92, 0x49, 0xc9, 0xb0}: "SmmTxtConfigLock",
		efi.GUID{0x03, 0xec, 0x06, 0x99, 0x8e, 0xdd, 0xe4, 0x42, 0x9e, 0xc0, 0xd3, 0x3f, 0x77, 0x39, 0x72, 0x66}: "OemWorkaroundDxe",
		efi.GUID{0x03, 0xf3, 0xb5, 0xdb, 0x4d, 0x21, 0xc4, 0x41, 0xbe, 0xa3, 0xa1, 0xb5, 0x6a, 0x42, 0xda, 0x8b}: "IsaAcpiDriver",
		efi.GUID{0x04, 0x00, 0xb8, 0x93, 0xb3, 0x9f, 0xd4, 0x11, 0x9a, 0x3a, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d}: "PciBusDxe",
		efi.GUID{0x04, 0x04, 0x44, 0x6c, 0x74, 0x5f, 0xb8, 0x44, 0xcc, 0xe4, 0x4b, 0x04, 0x88, 0x30, 0xcc, 0xfc}: "LockLegacyResourcesDxe",
		efi.GUID{0x04, 0x04, 0xe7, 0x21, 0x72, 0xdf, 0x22, 0x41, 0xb0, 0x30, 0x28, 0x13, 0x06, 0xeb, 0x7b, 0xe3}: "VbtEdpTypeCGuid",
		efi.GUID{0x04, 0x12, 0x1d, 0x1a, 0x85, 0xe3, 0x43, 0x49, 0xa8, 0x92, 0x53, 0x34, 0xce, 0x38, 0x09, 0xac}: "DellCsmOemRom",
		efi.GUID{0x04, 0x1a, 0xb0, 0xd5, 0xd8, 0x24, 0xb9, 0x44, 0xa3, 0x90, 0x88, 0x8d, 0x66, 0x9a, 0x1c, 0xbf}: "HpAmdXhciSmm",
		efi.GUID{0x04, 0x24, 0xea, 0xfe, 0x2e, 0x75, 0x6e, 0x4e, 0x82, 0x3c, 0x87, 0x7d, 0x84, 0x8c, 0xb1, 0x2b}: "AsfSecureBootDxe",
		efi.GUID{0x04, 0x25, 0x4f, 0x05, 0xbc, 0xe2, 0x41, 0x46, 0x83, 0xfc, 0x50, 0x25, 0x88, 0xfe, 0x1f, 0x28}: "CpuInitDxe",
		efi.GUID{0x04, 0x2a, 0xe9, 0xef, 0xd0, 0xf5, 0x44, 0x4e, 0x87, 0x57, 0x25, 0xb3, 0xaf, 0xa3, 0xbf, 0xff}: "RSTeSataRaidEfi",
		efi.GUID{0x04, 0x31, 0xca, 0x7c, 0x1d, 0x2a, 0x84, 0x4e, 0x9c, 0x7c, 0x44, 0xb9, 0x7a, 0x23, 0x40, 0x12}: "HpSioSecurityPei",
		efi.GUID{0x04, 0x39, 0x0b, 0x31, 0x28, 0x07, 0x77, 0x49, 0xa9, 0x0c, 0x06, 0xb8, 0xec, 0xd8, 0x5a, 0x9f}: "A01DxeInstallHook",
		efi.GUID{0x04, 0x3e, 0xfd, 0x89, 0x47, 0xd6, 0xd1, 0x42, 0x89, 0x72, 0xa6, 0x15, 0x6f, 0xc3, 0xa0, 0xdd}: "LockLegacyResourcesPortingDxe",
		efi.GUID{0x04, 0x3f, 0xf7, 0x06, 0xc0, 0x36, 0xbc, 0x4c, 0xa3, 0xb0, 0x9f, 0x16, 0xfb, 0x60, 0x33, 0x50}: "OemPxeLoader",
		efi.GUID{0x04, 0x46, 0xbe, 0xf1, 0xb3, 0x24, 0xa5, 0x4d, 0x8b, 0xbf, 0xe8, 0x7a, 0x6c, 0x04, 0x6c, 0x93}: "CbsSetupDxeMDN",
		efi.GUID{0x04, 0x4d, 0x69, 0x4e, 0x8b, 0x31, 0x89, 0x4f, 0xa3, 0xb3, 0xba, 0x35, 0x60, 0xfd, 0x38, 0x9e}: "HddSetupVarDefaults",
		efi.GUID{0x04, 0x4e, 0x9a, 0xd3, 0x2d, 0xc4, 0x41, 0x49, 0xbf, 0xbd, 0x28, 0x6d, 0xf4, 0x8b, 0x30, 0x4b}: "MeLockStatusSmm",
		efi.GUID{0x04, 0x51, 0x62, 0x3e, 0x20, 0x19, 0xb1, 0x44, 0xae, 0x2c, 0x1b, 0xda, 0x57, 0xed, 0x73, 0xea}: "KtiRas",
		efi.GUID{0x04, 0x55, 0x99, 0x70, 0xaa, 0xd7, 0xba, 0x4b, 0x80, 0x3a, 0xa3, 0xa9, 0xc7, 0x29, 0xa3, 0x7e}: "DellSmmDpstProtocol",
		efi.GUID{0x04, 0x55, 0xbd, 0x45, 0xa8, 0x94, 0x01, 0x43, 0xb2, 0x11, 0xb0, 0xae, 0x4f, 0x56, 0xe9, 0xae}: "ThermalSMM",
		efi.GUID{0x04, 0x57, 0x84, 0xce, 0x83, 0x16, 0x38, 0x4d, 0xa4, 0xf9, 0x7d, 0x0b, 0x50, 0x77, 0x57, 0x93}: "EfiPlatformBootModeGuid",
		efi.GUID{0x04, 0x59, 0xbf, 0xed, 0x1a, 0x49, 0x63, 0x43, 0xa5, 0x6e, 0xff, 0x57, 0x3d, 0xe5, 0x6a, 0x70}: "EmulatedEepromDxe",
		efi.GUID{0x04, 0x5e, 0xff, 0xd0, 0x07, 0x1d, 0x1d, 0x49, 0x97, 0x0e, 0xe2, 0x20, 0xa3, 0xb7, 0x96, 0x11}: "AmdNbioGfxRVPei",
		efi.GUID{0x04, 0x74, 0xe0, 0xee, 0xee, 0x26, 0xc9, 0x43, 0x90, 0x71, 0x4e, 0x48, 0x00, 0x8c, 0x46, 0x91}: "EfiWheaSupportProtocolGuid",
		efi.GUID{0x04, 0x77, 0x78, 0x86, 0xed, 0x8f, 0xe3, 0x11, 0xb3, 0xff, 0xf3, 0x3b, 0x73, 0xac, 0xfe, 0xc2}: "TcpFastbootTransportDxe",
		efi.GUID{0x04, 0x7c, 0xcc, 0x26, 0x9d, 0x4e, 0xed, 0x4f, 0xaf, 0xba, 0xcb, 0xf2, 0x33, 0x34, 0xdc, 0x0d}: "AmtWrapperDxe",
		efi.GUID{0x04, 0x80, 0x0e, 0x14, 0xe1, 0x16, 0xe1, 0x4d, 0xa3, 0x52, 0xc6, 0xef, 0x51, 0x11, 0x0e, 0xcf}: "ArmSmcLibNull",
		efi.GUID{0x04, 0x89, 0x7d, 0x83, 0x31, 0x22, 0x58, 0x45, 0x8f, 0x70, 0xee, 0x72, 0x79, 0x0b, 0xab, 0x9c}: "ClientronLanDevInfoDxe",
		efi.GUID{0x04, 0x8b, 0x8d, 0x55, 0x4e, 0x1c, 0x82, 0x47, 0xbb, 0x99, 0xaf, 0xf9, 0x03, 0x07, 0x4c, 0x26}: "AmdCpmPciHotPlugDxe",
		efi.GUID{0x04, 0x96, 0x93, 0x8c, 0x00, 0x07, 0x15, 0x44, 0x9d, 0x62, 0x11, 0x61, 0xdb, 0x81, 0x64, 0xa6}: "AmiTcgPlatformProtocolguid",
		efi.GUID{0x04, 0x9d, 0x82, 0x3a, 0x62, 0x39, 0xdf, 0x42, 0x91, 0x37, 0xb1, 0xd3, 0x54, 0xae, 0xa4, 0xab}: "OemDxeGetBoardData",
		efi.GUID{0x04, 0xa0, 0x0d, 0xe4, 0xab, 0xce, 0xcd, 0x43, 0xb4, 0xa8, 0x98, 0x49, 0x7b, 0xf3, 0x39, 0x87}: "DellDashPolicyProtocol",
		efi.GUID{0x04, 0xa0, 0x98, 0x68, 0x24, 0x3d, 0x38, 0x4f, 0x85, 0x07, 0xdc, 0x22, 0x6b, 0x3d, 0x90, 0xca}: "SpsPeiPostMem",
		efi.GUID{0x04, 0xa3, 0xda, 0x52, 0xb3, 0xde, 0x9b, 0x44, 0xaf, 0xb8, 0xa8, 0x8a, 0x54, 0xf2, 0x8f, 0x95}: "OhciPei",
		efi.GUID{0x04, 0xb1, 0xa2, 0xed, 0x10, 0x7a, 0x19, 0x45, 0xb0, 0xa1, 0xeb, 0xa5, 0xc5, 0x2a, 0xcf, 0xce}: "AmiTseOemPortingVar1Guid",
		efi.GUID{0x04, 0xbd, 0x61, 0xf7, 0x5e, 0x6e, 0x37, 0x4e, 0x94, 0xf4, 0x46, 0x99, 0x97, 0x2b, 0x24, 0x3d}: "AmdMemStpSp6Pei",
		efi.GUID{0x04, 0xbd, 0xb4, 0x53, 0x8c, 0x09, 0x11, 0x4a, 0xb6, 0x5a, 0xa0, 0x2b, 0x33, 0xc9, 0x8c, 0x08}: "HSPfTPMAcpi",
		efi.GUID{0x04, 0xc6, 0x8b, 0x41, 0x5e, 0xf1, 0x43, 0x48, 0x85, 0xd0, 0x2d, 0x24, 0x80, 0xb7, 0xe4, 0x88}: "EfiMpstNodeData",
		efi.GUID{0x04, 0xc7, 0x8a, 0x6a, 0x89, 0xe5, 0xd0, 0x4d, 0x8e, 0xe0, 0x31, 0xf8, 0x7f, 0xbe, 0x33, 0x23}: "DxeTouchPanelInit",
		efi.GUID{0x04, 0xc8, 0xbc, 0x51, 0x8a, 0x42, 0x6a, 0x4a, 0xb3, 0x52, 0xe4, 0x84, 0x4a, 0xed, 0x91, 0x05}: "NtfsPei",
		efi.GUID{0x04, 0xca, 0x2e, 0x98, 0x92, 0x04, 0xf0, 0x4a, 0x9c, 0x6e, 0x35, 0x4a, 0x3b, 0xea, 0xc9, 0xff}: "HpCoreBootOrder",
		efi.GUID{0x04, 0xcd, 0xb2, 0xe7, 0x14, 0x4b, 0xc2, 0x44, 0xb7, 0x48, 0xce, 0xaf, 0x2b, 0x66, 0x4a, 0xb0}: "EdkiiPeiVariablePpi",
		efi.GUID{0x04, 0xcf, 0xcd, 0x97, 0x8e, 0x4c, 0xfe, 0x42, 0x80, 0x15, 0x11, 0xcc, 0x8a, 0x6e, 0x9d, 0x81}: "Tpm2DeviceLibRouterPei",
		efi.GUID{0x04, 0xd3, 0x13, 0x24, 0x41, 0xaa, 0x79, 0x40, 0xa8, 0x1e, 0x31, 0xb8, 0xd7, 0xc3, 0xfd, 0x6b}: "GpioV2PpiInitPei",
		efi.GUID{0x04, 0xdb, 0xa6, 0xb0, 0x0f, 0x8a, 0x4f, 0x4f, 0x9c, 0x45, 0xc3, 0x34, 0x45, 0x15, 0xa5, 0x83}: "FjGabiFlashCoreAbstractionSmm",
		efi.GUID{0x04, 0xe4, 0x07, 0x78, 0x81, 0x82, 0xf1, 0x4f, 0x84, 0x57, 0x0b, 0x54, 0xba, 0xbe, 0x26, 0x3f}: "HitachiH8s2113Dxe",
		efi.GUID{0x04, 0xe6, 0x22, 0x09, 0xec, 0xf5, 0xef, 0x42, 0x98, 0x0d, 0xa3, 0x5e, 0x9a, 0x2b, 0x18, 0x44}: "IpSecConfig",
		efi.GUID{0x05, 0x04, 0x32, 0xd8, 0xed, 0x3c, 0x6c, 0x40, 0xb9, 0x3c, 0x43, 0x3a, 0x58, 0xc6, 0xd1, 0xfa}: "SecureBIOCameraSonix",
		efi.GUID{0x05, 0x05, 0x28, 0x38, 0x24, 0x43, 0x30, 0x61, 0x73, 0x0d, 0xa0, 0x95, 0x2b, 0x0f, 0x32, 0x9e}: "S5MaxPowerSavingsPortingSmm",
		efi.GUID{0x05, 0x08, 0xac, 0x02, 0x5f, 0x15, 0x3a, 0x47, 0xa3, 0x02, 0x0d, 0x89, 0xd6, 0xe1, 0xe6, 0xcc}: "AsusSLP2",
		efi.GUID{0x05, 0x0a, 0x3d, 0xcd, 0x24, 0x9e, 0x7c, 0x43, 0xa8, 0x91, 0x1e, 0xe0, 0x53, 0xdb, 0x76, 0x38}: "EdkiiVariableLockProtocolGuid",
		efi.GUID{0x05, 0x0d, 0x4a, 0xad, 0x6d, 0x80, 0xe4, 0x4f, 0x96, 0xad, 0x3b, 0xd6, 0x2d, 0x8c, 0x4c, 0xe0}: "DellDoSiodiagLedDxe",
		efi.GUID{0x05, 0x10, 0x61, 0xb7, 0x26, 0x1f, 0xba, 0x45, 0xa3, 0xdb, 0x01, 0xf3, 0x9d, 0xdb, 0x27, 0x85}: "BootMode",
		efi.GUID{0x05, 0x17, 0x8f, 0xab, 0xb6, 0x7e, 0x08, 0x4d, 0xa9, 0xb3, 0x91, 0x8b, 0xde, 0x24, 0xf4, 0x79}: "UpdatePcdPei",
		efi.GUID{0x05, 0x1a, 0x14, 0xde, 0x40, 0xfa, 0x2d, 0x43, 0x96, 0x31, 0x5e, 0x3e, 0x99, 0x0f, 0x44, 0xd5}: "SlotDataUpdateDxeNeonCityEPRP",
		efi.GUID{0x05, 0x21, 0x29, 0x1d, 0x53, 0x26, 0xe5, 0x11, 0xb4, 0x6f, 0xb8, 0xe8, 0x56, 0x2c, 0xba, 0xfa}: "AppleCapsuleRuntimeDxe",
		efi.GUID{0x05, 0x2d, 0x00, 0x72, 0x57, 0x2c, 0xb4, 0x48, 0xb9, 0xdd, 0xd2, 0xf1, 0x90, 0x35, 0xa4, 0x4b}: "HpDtSmm",
		efi.GUID{0x05, 0x33, 0xa2, 0xb2, 0x55, 0x94, 0x9c, 0x48, 0xaa, 0x81, 0x21, 0xdb, 0x48, 0xc4, 0x1e, 0xab}: "LenovoAoacDxe",
		efi.GUID{0x05, 0x3d, 0x63, 0xf5, 0xdc, 0xa7, 0x2d, 0x4a, 0x83, 0x71, 0xa6, 0xb8, 0x42, 0x78, 0x56, 0x3b}: "FchKeithMdnSmmInit",
		efi.GUID{0x05, 0x3f, 0x89, 0xd0, 0x6d, 0xb0, 0x61, 0x41, 0xb9, 0x47, 0x9b, 0xe9, 0xb8, 0x5a, 0xc3, 0xa1}: "SnpNt32Dxe",
		efi.GUID{0x05, 0x4f, 0x2f, 0x3e, 0xfa, 0x26, 0x0f, 0x49, 0xac, 0x3b, 0x35, 0x1b, 0xaf, 0x08, 0xb2, 0x8d}: "ArmaniSxCallback",
		efi.GUID{0x05, 0x57, 0x18, 0x6e, 0xad, 0xe3, 0xef, 0x45, 0x83, 0xc1, 0xf1, 0xf9, 0x56, 0x7a, 0xf3, 0x96}: "DisconnectKbd",
		efi.GUID{0x05, 0x5a, 0x9e, 0x2b, 0x6f, 0x68, 0x72, 0x4e, 0xaf, 0x0a, 0x2d, 0x7b, 0xaa, 0x61, 0xe9, 0x18}: "AmdNbioPcieRVPei",
		efi.GUID{0x05, 0x5a, 0xc5, 0xa4, 0xd4, 0x88, 0xcb, 0x44, 0x8d, 0xc7, 0xb3, 0xc0, 0x92, 0x80, 0x2e, 0x22}: "FchSmbusPei",
		efi.GUID{0x05, 0x63, 0xdd, 0xfe, 0xd7, 0xe2, 0xd5, 0x4e, 0x9f, 0xaa, 0xda, 0x08, 0x0e, 0x33, 0x6c, 0x22}: "PeiUsb2HostControllerPpiGuid",
		efi.GUID{0x05, 0x64, 0x2f, 0xca, 0x53, 0x49, 0x00, 0x4c, 0x9c, 0x46, 0xd1, 0x86, 0x83, 0xa9, 0x00, 0x3f}: "SmmKbcDriver",
		efi.GUID{0x05, 0x71, 0x4b, 0x11, 0xc9, 0x6c, 0x3c, 0x45, 0xba, 0xdc, 0x16, 0xdf, 0x22, 0x7b, 0xb4, 0xef}: "TrEESmm",
		efi.GUID{0x05, 0x7e, 0xc9, 0x3a, 0x17, 0xf2, 0xbd, 0x4e, 0xb1, 0x34, 0x8f, 0xda, 0x26, 0xe8, 0x57, 0x69}: "DebugDxe",
		efi.GUID{0x05, 0x81, 0x8b, 0xc1, 0x89, 0xab, 0xde, 0x44, 0x8d, 0x37, 0x50, 0xb3, 0x1f, 0xae, 0x5d, 0x1e}: "SgTpvAcpiTables",
		efi.GUID{0x05, 0x8f, 0xfc, 0xef, 0x26, 0xb5, 0xb5, 0x4e, 0xb3, 0x6b, 0x8c, 0xd8, 0x89, 0x92, 0x3c, 0x0c}: "LegacyRegion",
		efi.GUID{0x05, 0x97, 0xd1, 0x20, 0x9d, 0xe5, 0x62, 0x43, 0x99, 0x56, 0xfa, 0x53, 0x3a, 0xff, 0x24, 0x29}: "SetBoardId",
		efi.GUID{0x05, 0x98, 0x81, 0x63, 0xbb, 0x67, 0xef, 0x46, 0xaa, 0x8d, 0x15, 0x24, 0xa1, 0x9a, 0x01, 0xe4}: "SmallLogo",
		efi.GUID{0x05, 0x98, 0x81, 0x63, 0xdd, 0xdd, 0xef, 0x46, 0xaa, 0x8d, 0x15, 0x24, 0xa1, 0x9a, 0x01, 0xe4}: "SmallLogo",
		efi.GUID{0x05, 0xa6, 0xdd, 0x3f, 0x6e, 0xa7, 0x46, 0x4f, 0xad, 0x29, 0x12, 0xf4, 0x53, 0x1b, 0x3d, 0x08}: "EfiMpServiceProtocolGuid",
		efi.GUID{0x05, 0xa9, 0xc5, 0xe9, 0x92, 0x62, 0x00, 0x4e, 0xbe, 0xdd, 0xda, 0x6a, 0xf6, 0x53, 0x13, 0x8e}: "FjvProSupport",
		efi.GUID{0x05, 0xb0, 0xcb, 0x29, 0x72, 0xc9, 0xf3, 0x49, 0x96, 0x0f, 0x29, 0x2e, 0x22, 0x02, 0xce, 0xcd}: "FspNotifyPhasePeim",
		efi.GUID{0x05, 0xb6, 0x5c, 0x91, 0x96, 0x0e, 0x75, 0x4c, 0xb7, 0x24, 0x53, 0xdc, 0xba, 0xe7, 0xad, 0xb5}: "DellDxeDiagLeds",
		efi.GUID{0x05, 0xbc, 0x15, 0x05, 0x59, 0x29, 0x91, 0x4e, 0x89, 0xc6, 0x6b, 0x3a, 0x3f, 0x1f, 0xcb, 0x65}: "TCG_MPDriver",
		efi.GUID{0x05, 0xc0, 0xe4, 0x15, 0xc0, 0x52, 0x4c, 0x44, 0x8c, 0x94, 0x56, 0xff, 0xa0, 0x4c, 0x7b, 0x36}: "SmuV12Dxe",
		efi.GUID{0x05, 0xc6, 0xa4, 0x43, 0x6d, 0xc6, 0x3e, 0x47, 0xa0, 0x6a, 0x37, 0xe9, 0x14, 0x3f, 0xc4, 0x39}: "PcRtc",
		efi.GUID{0x05, 0xd8, 0x1b, 0xa8, 0x8c, 0x26, 0xaa, 0x45, 0x8b, 0xdd, 0x0b, 0x8e, 0xb9, 0x2a, 0x53, 0x41}: "SmmFlash",
		efi.GUID{0x05, 0xe5, 0xd7, 0xa0, 0xd4, 0x5d, 0x59, 0x44, 0xa4, 0xd3, 0x36, 0x11, 0x95, 0x63, 0xc4, 0xf9}: "DellAudioPei",
		efi.GUID{0x05, 0xe6, 0xdd, 0x5b, 0x07, 0xb1, 0x9e, 0x41, 0x95, 0x10, 0xaa, 0x3c, 0x43, 0x4e, 0xbb, 0xe4}: "LegacyBiosPlatform",
		efi.GUID{0x05, 0xf8, 0xa2, 0x9f, 0x86, 0x3d, 0xbc, 0x42, 0xa9, 0xc3, 0x2b, 0x26, 0xa5, 0xdf, 0x09, 0xf9}: "LenovoPchConfig",
		efi.GUID{0x06, 0x0f, 0x60, 0xaa, 0xf5, 0x26, 0x8f, 0x42, 0xb4, 0xf1, 0x91, 0x3b, 0xef, 0x6e, 0x4d, 0xbb}: "FspWrapperExtractGuidedPeim",
		efi.GUID{0x06, 0x17, 0x1d, 0xd8, 0x6f, 0xbe, 0x34, 0x47, 0xb2, 0xaf, 0xf8, 0x85, 0xff, 0xdc, 0xb1, 0x6d}: "AsixUsbEthernetDxe",
		efi.GUID{0x06, 0x1a, 0xf0, 0x8d, 0xd5, 0x9b, 0xf7, 0x4b, 0xb0, 0x21, 0xdb, 0x4f, 0xd9, 0xcc, 0xf4, 0x5b}: "EfiHashAlgorithmSha224Guid",
		efi.GUID{0x06, 0x1b, 0x38, 0x83, 0xea, 0x2e, 0xf3, 0x4c, 0x9b, 0x5f, 0xd7, 0x5b, 0x9b, 0x5c, 0x93, 0xde}: "GetServByPort",
		efi.GUID{0x06, 0x1c, 0xa4, 0xdc, 0x2b, 0xfd, 0xe4, 0x41, 0xbb, 0xe7, 0x94, 0x64, 0x44, 0xdb, 0x0b, 0xd9}: "SystemFindFvPei",
		efi.GUID{0x06, 0x1e, 0xb3, 0xa8, 0x68, 0x70, 0x87, 0x5d, 0xa1, 0xa6, 0x10, 0x75, 0x4a, 0x09, 0xb9, 0x2d}: "FTPMSmm",
		efi.GUID{0x06, 0x1f, 0x52, 0x56, 0x62, 0x0a, 0x22, 0x48, 0x99, 0x63, 0xdf, 0x01, 0x9d, 0x72, 0xc7, 0xe1}: "PchSmmSpiProtocol",
		efi.GUID{0x06, 0x22, 0x29, 0x41, 0x69, 0x40, 0xa6, 0x42, 0xac, 0x38, 0xc4, 0xa5, 0xc1, 0x23, 0xc6, 0xe5}: "BaseTraceHubLibNull",
		efi.GUID{0x06, 0x33, 0x1f, 0x8e, 0xcc, 0xc9, 0xe6, 0x46, 0x83, 0xbc, 0x59, 0x28, 0xb0, 0xdd, 0x03, 0x6e}: "OpalDeviceService",
		efi.GUID{0x06, 0x37, 0x13, 0x72, 0x22, 0xa9, 0xf1, 0x43, 0x9c, 0x75, 0x58, 0x1d, 0x9a, 0xe8, 0xf6, 0x66}: "AmdNbioSmuV9Pei",
		efi.GUID{0x06, 0x39, 0x86, 0x9e, 0x0f, 0xa4, 0x75, 0x48, 0x97, 0x7f, 0x5b, 0x93, 0xff, 0x23, 0x7f, 0xc6}: "TerminalDxe",
		efi.GUID{0x06, 0x3b, 0x01, 0xd4, 0x7d, 0xab, 0x9c, 0x4b, 0x89, 0xd5, 0x6e, 0xf6, 0x1f, 0x50, 0x7e, 0xca}: "AsrockAmdSetupDxeRN",
		efi.GUID{0x06, 0x3b, 0xd6, 0xd1, 0x7f, 0x13, 0x5a, 0x4f, 0x8c, 0x25, 0x28, 0xda, 0xdf, 0xa1, 0xe9, 0x88}: "FjPasswordSkipDmi",
		efi.GUID{0x06, 0x40, 0xb3, 0x11, 0x5b, 0xd8, 0x0a, 0x4d, 0xa2, 0x90, 0xd5, 0xa5, 0x71, 0x31, 0x0e, 0xf7}: "PcdProtocolGuid",
		efi.GUID{0x06, 0x41, 0xa5, 0x73, 0x88, 0x8c, 0xa9, 0x4b, 0xb0, 0x8e, 0xfd, 0x87, 0x9a, 0x16, 0x82, 0xca}: "NvdimmCommon",
		efi.GUID{0x06, 0x46, 0x87, 0xac, 0x27, 0x87, 0xa0, 0x41, 0xbc, 0xcd, 0x43, 0xa4, 0x23, 0x74, 0x66, 0xdd}: "EneUpdDXE",
		efi.GUID{0x06, 0x47, 0x0d, 0x33, 0xa0, 0xf2, 0x4f, 0x4e, 0xa3, 0x69, 0xb6, 0x6f, 0xa8, 0xd5, 0x43, 0x85}: "EfiHiiConfigAccessProtocolGuid",
		efi.GUID{0x06, 0x47, 0x1d, 0xfc, 0xfb, 0x88, 0xb0, 0x42, 0x98, 0xb0, 0xa4, 0xb2, 0xe6, 0x07, 0xeb, 0xaa}: "LibErr",
		efi.GUID{0x06, 0x47, 0xab, 0x6d, 0x57, 0x5d, 0xdb, 0x4b, 0x9a, 0x0e, 0x39, 0x3a, 0x41, 0x78, 0xd1, 0x3e}: "TiOnlySmm",
		efi.GUID{0x06, 0x49, 0x73, 0x42, 0xd7, 0xea, 0x98, 0x4a, 0xad, 0xbe, 0x58, 0xbd, 0xa5, 0xcb, 0x64, 0xce}: "EcKeyPei",
		efi.GUID{0x06, 0x49, 0xb2, 0xe5, 0x08, 0xcf, 0xcd, 0x4d, 0x9e, 0xe3, 0x0d, 0x16, 0x3f, 0xca, 0x34, 0xbf}: "DellTcg2Dxe",
		efi.GUID{0x06, 0x51, 0x07, 0x25, 0x37, 0xf5, 0xd4, 0x4b, 0xaf, 0xa5, 0xcf, 0xf0, 0xe6, 0xf3, 0xb2, 0xa6}: "AmdFabricRvDxe",
		efi.GUID{0x06, 0x52, 0x25, 0xac, 0xf9, 0xdc, 0x37, 0x48, 0x83, 0x53, 0x72, 0xbb, 0xbc, 0x0a, 0xc8, 0x49}: "OzmosisTheme",
		efi.GUID{0x06, 0x52, 0x31, 0xfd, 0xfc, 0x9e, 0xaf, 0x43, 0x88, 0x45, 0x4c, 0x75, 0x28, 0x66, 0x7c, 0xac}: "OemSMIEE",
		efi.GUID{0x06, 0x52, 0xb9, 0x01, 0x66, 0xcd, 0x0d, 0x4c, 0xa8, 0x67, 0xed, 0x42, 0x96, 0x0e, 0x07, 0xdc}: "SystemFirmwareDeviceSmmProtocol",
		efi.GUID{0x06, 0x53, 0x51, 0xca, 0xce, 0x00, 0x32, 0x40, 0x87, 0x4e, 0x11, 0xb7, 0x55, 0xff, 0x68, 0x66}: "DataHubStdErrDxe",
		efi.GUID{0x06, 0x53, 0x86, 0x7f, 0x0d, 0x83, 0xc2, 0x4d, 0x8e, 0x9a, 0xb7, 0x85, 0x6f, 0x92, 0x5a, 0x0a}: "SupplicantDriver",
		efi.GUID{0x06, 0x5c, 0x5f, 0xa0, 0x82, 0x17, 0xaa, 0x48, 0x96, 0x2a, 0x86, 0xa0, 0x89, 0x20, 0x22, 0xb6}: "ASM1061Dxe",
		efi.GUID{0x06, 0x5d, 0xcc, 0xf2, 0x85, 0x89, 0xdb, 0x11, 0xbb, 0x19, 0x00, 0x40, 0xd0, 0x2b, 0x18, 0x35}: "EfiUnixConsole",
		efi.GUID{0x06, 0x65, 0xe1, 0x1f, 0xc5, 0x5c, 0x89, 0x4d, 0xb8, 0xfb, 0x6e, 0xb5, 0xe1, 0x34, 0x88, 0x7d}: "DxeWhea",
		efi.GUID{0x06, 0x6a, 0xd2, 0x7d, 0x42, 0x99, 0xa8, 0x41, 0xb9, 0xcf, 0x09, 0xde, 0x46, 0xd5, 0xd2, 0x19}: "BBSManagerDxe",
		efi.GUID{0x06, 0x6b, 0xeb, 0x3b, 0xce, 0x09, 0x86, 0x43, 0x88, 0x84, 0xf3, 0x23, 0xad, 0xd0, 0x4f, 0x1f}: "GlobeTile",
		efi.GUID{0x06, 0x6c, 0xeb, 0x77, 0x48, 0xfd, 0x8b, 0x48, 0xa1, 0xb3, 0xae, 0x0a, 0x70, 0x80, 0x13, 0x69}: "CryptoDXE",
		efi.GUID{0x06, 0x70, 0xb3, 0x07, 0x02, 0x93, 0x8e, 0x40, 0xb4, 0x16, 0xb5, 0x24, 0xd1, 0x10, 0xdd, 0x7f}: "AppleHidInterface",
		efi.GUID{0x06, 0x71, 0xf4, 0xad, 0xf8, 0x5c, 0x02, 0x4d, 0xbc, 0xf9, 0xba, 0xcc, 0xc7, 0xd3, 0x16, 0x2b}: "CrbSmbiosDxe",
		efi.GUID{0x06, 0x82, 0x37, 0x59, 0x1b, 0x86, 0x80, 0x43, 0xa3, 0x49, 0x2f, 0x2f, 0x4f, 0x03, 0x0c, 0x4b}: "DashBiosManagerSmm",
		efi.GUID{0x06, 0x88, 0xe7, 0x75, 0x8f, 0xc6, 0x39, 0x48, 0x8a, 0x68, 0xb2, 0x90, 0x84, 0x82, 0x06, 0x59}: "ExStatusCodeHandlerPei",
		efi.GUID{0x06, 0x8d, 0xa5, 0x53, 0x27, 0xac, 0x8c, 0x4d, 0xb5, 0xe9, 0xf0, 0x8a, 0x80, 0x65, 0x41, 0x70}: "EfiExtendedSalStallServicesProtocolGuid",
		efi.GUID{0x06, 0x95, 0x9a, 0x9f, 0x97, 0x55, 0x15, 0x45, 0xba, 0xb6, 0x8b, 0xcd, 0xe7, 0x84, 0xba, 0x87}: "UniversalPayloadAcpiTable",
		efi.GUID{0x06, 0x9a, 0xa4, 0xb1, 0x30, 0xb6, 0xf5, 0x4b, 0x85, 0xbd, 0x09, 0x97, 0xce, 0x64, 0x2d, 0x49}: "TouchDriver",
		efi.GUID{0x06, 0x9e, 0x6d, 0x6d, 0x22, 0x71, 0x87, 0x45, 0x88, 0xc5, 0xbd, 0x3d, 0x13, 0xc7, 0xe8, 0xc4}: "AmdMemAm4RnPei",
		efi.GUID{0x06, 0x9f, 0x55, 0xa5, 0x15, 0x64, 0x59, 0x47, 0x88, 0x69, 0xde, 0x15, 0xf9, 0xcd, 0x9c, 0x9b}: "IffsGlobalNvsAreaProtocol",
		efi.GUID{0x06, 0xa3, 0x34, 0x18, 0x70, 0x0d, 0x0e, 0x47, 0x90, 0x1f, 0x23, 0x70, 0xff, 0x30, 0xdd, 0xab}: "DxeSpiNorFlash",
		efi.GUID{0x06, 0xa8, 0xb9, 0xa4, 0x74, 0xb5, 0x54, 0x43, 0xbf, 0xc7, 0x05, 0x21, 0x7d, 0xc0, 0xfa, 0xf4}: "FlashHookSmm",
		efi.GUID{0x06, 0xb1, 0x1d, 0xd7, 0x2d, 0xe3, 0x25, 0x42, 0xbf, 0xf4, 0xde, 0x6d, 0x77, 0x87, 0x17, 0x61}: "PowerMgmtInitDoneProtocolGuid",
		efi.GUID{0x06, 0xb1, 0x65, 0x00, 0x27, 0xeb, 0x3c, 0x4a, 0x85, 0x1c, 0xec, 0x77, 0xd5, 0x1e, 0xdc, 0xd6}: "AbsoluteActivateDxe",
		efi.GUID{0x06, 0xb5, 0xd3, 0x74, 0x9c, 0xee, 0xed, 0x47, 0xb7, 0x49, 0x41, 0x26, 0x14, 0x01, 0xda, 0x78}: "QNCInitDxe",
		efi.GUID{0x06, 0xb5, 0xf2, 0x30, 0x94, 0x3f, 0x11, 0x4a, 0x85, 0xd2, 0xeb, 0xf6, 0x0b, 0x35, 0xf5, 0x94}: "ArmaniSmbiosUpdate",
		efi.GUID{0x06, 0xbd, 0xdc, 0x9e, 0x78, 0x3c, 0x22, 0x48, 0xbd, 0x6e, 0xa6, 0x84, 0x7f, 0x75, 0x31, 0xc4}: "FastBootTseHook",
		efi.GUID{0x06, 0xc0, 0x7b, 0x31, 0x56, 0x90, 0xc8, 0x42, 0xa1, 0xc1, 0x92, 0xa1, 0xaa, 0xbb, 0xc9, 0xee}: "AmdCcxZenZpSmm",
		efi.GUID{0x06, 0xd0, 0x2f, 0x13, 0x15, 0x29, 0xea, 0x40, 0xb7, 0x79, 0x0f, 0x0d, 0xdd, 0x01, 0x46, 0x5f}: "PxeDriverRtk",
		efi.GUID{0x06, 0xd0, 0xe6, 0x64, 0x2a, 0xe6, 0x1e, 0x48, 0x8f, 0x5a, 0x3f, 0x76, 0xc9, 0x18, 0x47, 0x41}: "AmdSmmCommunication",
		efi.GUID{0x06, 0xd3, 0xc9, 0x88, 0x00, 0x09, 0xb5, 0x4e, 0x82, 0x60, 0x3e, 0x2d, 0xbe, 0xda, 0x1f, 0x89}: "PeiPostScriptTablePpiGuid",
		efi.GUID{0x06, 0xdf, 0x59, 0x6e, 0xd3, 0x62, 0xb0, 0x40, 0x82, 0xb5, 0x17, 0x5c, 0xf8, 0x4a, 0x94, 0xe4}: "OEMPEI",
		efi.GUID{0x06, 0xe4, 0x19, 0xf0, 0x9c, 0x8c, 0xe5, 0x11, 0x87, 0x97, 0x00, 0x1a, 0xca, 0x00, 0xbf, 0xc4}: "BfbFs",
		efi.GUID{0x06, 0xe6, 0x98, 0x60, 0x2c, 0x47, 0x51, 0x4f, 0x8a, 0x40, 0x24, 0x37, 0x6d, 0x2c, 0x66, 0xb7}: "System",
		efi.GUID{0x06, 0xe7, 0xe0, 0xe3, 0xe7, 0x86, 0xa1, 0x44, 0xbf, 0x05, 0xec, 0xc4, 0x2a, 0xe9, 0x99, 0x9e}: "CbsBasePeiRN",
		efi.GUID{0x06, 0xed, 0xaf, 0xdb, 0x39, 0xa4, 0x66, 0x41, 0xb0, 0x51, 0xc1, 0xc5, 0x33, 0x9b, 0xc3, 0xba}: "AmdNbioIOAPICPei",
		efi.GUID{0x06, 0xf0, 0xf6, 0xf0, 0xb4, 0xda, 0xb2, 0x44, 0xa7, 0xa1, 0x0f, 0x72, 0xee, 0xdc, 0xa7, 0x16}: "AcpiPlatform",
		efi.GUID{0x06, 0xf2, 0x66, 0x3b, 0x86, 0x63, 0x17, 0x41, 0xa7, 0xfd, 0xf5, 0xb8, 0x43, 0xa2, 0x6a, 0x6f}: "HpNetworkFeatureByteKillDxe",
		efi.GUID{0x06, 0xf4, 0x20, 0x59, 0x68, 0x58, 0xf5, 0x44, 0xa9, 0xb9, 0x6d, 0x40, 0x31, 0x48, 0x1c, 0xc9}: "LenovoOemSecPei",
		efi.GUID{0x06, 0xfa, 0xe9, 0xd9, 0xe0, 0x0f, 0xc3, 0x41, 0x96, 0xfb, 0x83, 0x42, 0x5a, 0x33, 0x94, 0xf8}: "EfiExtendedSalBaseServicesProtocolGuid",
		efi.GUID{0x07, 0x07, 0xe0, 0xee, 0x34, 0x67, 0x1b, 0x49, 0xad, 0xb3, 0xc1, 0x68, 0x26, 0x5a, 0xb5, 0xb5}: "DellUsbMassStorageSmm",
		efi.GUID{0x07, 0x07, 0xfe, 0x9b, 0x74, 0x81, 0x8a, 0x4b, 0xa5, 0xf5, 0x55, 0x6f, 0xb1, 0x0e, 0x88, 0x43}: "RTCWakeup",
		efi.GUID{0x07, 0x23, 0x5b, 0x40, 0x39, 0x68, 0x52, 0x4d, 0xae, 0xb9, 0xbe, 0xce, 0x64, 0x25, 0x28, 0x00}: "ArmFvpDxe",
		efi.GUID{0x07, 0x33, 0x17, 0x4e, 0xdb, 0x92, 0x4f, 0x4a, 0x9a, 0x8e, 0x86, 0xa8, 0x56, 0x49, 0xb4, 0x05}: "EfiAdminPasswordHob",
		efi.GUID{0x07, 0x40, 0xdb, 0xe6, 0x3b, 0x11, 0x05, 0x46, 0x8f, 0x5f, 0x66, 0x8d, 0x73, 0x64, 0xc8, 0x07}: "SmmInt15Service",
		efi.GUID{0x07, 0x41, 0x78, 0xb7, 0x3c, 0x97, 0x57, 0x49, 0x90, 0x5e, 0x54, 0x45, 0x5a, 0x47, 0xe0, 0x7d}: "AmdNbioPcieDxe",
		efi.GUID{0x07, 0x42, 0xc7, 0xd7, 0x31, 0xa8, 0x26, 0x4a, 0xb1, 0xf5, 0xd1, 0x93, 0x06, 0x5c, 0xe8, 0xb6}: "EfiAdapterInfoMediaStateGuid",
		efi.GUID{0x07, 0x44, 0x5e, 0x65, 0x9c, 0xc7, 0xb7, 0x42, 0xbe, 0x2c, 0x9e, 0x1a, 0x26, 0x6b, 0x08, 0xa3}: "AmdFabricRsSmm",
		efi.GUID{0x07, 0x44, 0x7f, 0x33, 0xee, 0x5a, 0x83, 0x4b, 0xb2, 0xa7, 0x4e, 0xad, 0xca, 0x30, 0x88, 0xcd}: "EfiHiiUserCredentialFormsetGuid",
		efi.GUID{0x07, 0x47, 0x75, 0xe6, 0x1a, 0x8f, 0x46, 0x45, 0xb9, 0xc6, 0xb1, 0x36, 0xd3, 0x46, 0xdb, 0xf7}: "DellBattPolicy",
		efi.GUID{0x07, 0x53, 0x3e, 0xff, 0xd0, 0x9f, 0xc9, 0x48, 0x85, 0xf1, 0x8a, 0xd5, 0x6c, 0x70, 0x1e, 0x01}: "EfiCertSha384Guid",
		efi.GUID{0x07, 0x55, 0x6c, 0x4f, 0x2f, 0x23, 0x87, 0x47, 0xb9, 0x5e, 0x72, 0xf8, 0x62, 0x49, 0x0c, 0xb1}: "EventExitBootServicesFailedGuid",
		efi.GUID{0x07, 0x56, 0xb7, 0x85, 0xce, 0xf7, 0x1e, 0x47, 0xb7, 0xe4, 0x2a, 0xea, 0x5f, 0x72, 0x32, 0xee}: "EfiUserInfoAccessSetupAdminGuid",
		efi.GUID{0x07, 0x59, 0x5b, 0xbb, 0x8e, 0x5f, 0xad, 0x42, 0x91, 0x5d, 0x5d, 0x98, 0xb5, 0x2e, 0xd6, 0x97}: "PlatformStage2",
		efi.GUID{0x07, 0x59, 0xb8, 0x3a, 0xcd, 0x33, 0x6c, 0x4d, 0x93, 0xa5, 0x9b, 0xe7, 0xe5, 0x79, 0xbf, 0x95}: "FjNetworkServices",
		efi.GUID{0x07, 0x5a, 0x3d, 0xe0, 0xcd, 0xcd, 0xd1, 0x4a, 0xa8, 0x29, 0x0b, 0x5a, 0x4a, 0xa6, 0xd6, 0x2b}: "BiosConnectProfileLoaderDaSmm",
		efi.GUID{0x07, 0x66, 0x80, 0x01, 0x5b, 0x24, 0xa8, 0x47, 0x95, 0x2a, 0xdc, 0x8c, 0x5c, 0x6a, 0x53, 0x16}: "OemDeviceDetect",
		efi.GUID{0x07, 0x6c, 0x88, 0xca, 0xdf, 0xac, 0xa6, 0x41, 0xa5, 0x01, 0xcb, 0xc5, 0x3d, 0xd4, 0x00, 0x8d}: "DellPeiReportFv",
		efi.GUID{0x07, 0x70, 0xd4, 0xb6, 0x45, 0x14, 0xdc, 0x41, 0xbc, 0x8c, 0x8a, 0xc3, 0x4d, 0x7f, 0xb2, 0x36}: "HpMMIOHConfigDxe",
		efi.GUID{0x07, 0x71, 0x6f, 0x5b, 0x3c, 0xbb, 0x60, 0x46, 0x92, 0xcd, 0x54, 0x26, 0x90, 0x28, 0x0b, 0xbd}: "BootDiscoveryPolicyMgrFormset",
		efi.GUID{0x07, 0x73, 0x07, 0xa6, 0x97, 0xb2, 0x51, 0x40, 0x9a, 0xc0, 0xa0, 0xdc, 0x81, 0x47, 0xe6, 0x01}: "menu_locked",
		efi.GUID{0x07, 0x7e, 0x33, 0x02, 0xf2, 0x2c, 0xbe, 0x46, 0xbc, 0xf7, 0x83, 0x49, 0x45, 0xfc, 0xce, 0xb9}: "EfiUnbootablePartitionGuid",
		efi.GUID{0x07, 0x7f, 0xd4, 0xd6, 0x45, 0x14, 0x6c, 0x41, 0xbc, 0x8c, 0x89, 0xc3, 0x4d, 0x7c, 0xb2, 0x10}: "HpFirstBootOptimizerDxe",
		efi.GUID{0x07, 0x97, 0x9e, 0x65, 0xd6, 0xd2, 0x66, 0x4a, 0x9e, 0x38, 0x4e, 0x84, 0x0b, 0x32, 0x45, 0xc5}: "OemAfterSmbiosDxe",
		efi.GUID{0x07, 0x98, 0x33, 0xb4, 0xac, 0x7c, 0xba, 0x49, 0x9f, 0xb7, 0x62, 0x31, 0xc6, 0x22, 0xf2, 0x70}: "BeginStickyBootButton",
		efi.GUID{0x07, 0xa1, 0xee, 0x02, 0xdb, 0x98, 0x0e, 0x40, 0x98, 0x30, 0x46, 0x0a, 0x15, 0x42, 0xd7, 0x99}: "Ip6ConfigNvDataGuid",
		efi.GUID{0x07, 0xaa, 0x39, 0x42, 0xe8, 0x8d, 0x67, 0x4c, 0xa9, 0x71, 0xc6, 0xf3, 0xf5, 0x6d, 0x7f, 0x93}: "RfTlsCertificates",
		efi.GUID{0x07, 0xb1, 0x78, 0x8a, 0xdd, 0x0f, 0xc8, 0x4c, 0xb7, 0xba, 0xdc, 0x3e, 0x13, 0xcb, 0x85, 0x24}: "PeiCpuIoPei",
		efi.GUID{0x07, 0xb3, 0x78, 0x75, 0x5b, 0xb2, 0xf9, 0x44, 0x89, 0x2e, 0x20, 0x9b, 0x0e, 0x39, 0x93, 0xc6}: "Emul6064MsInputProtocolGuid",
		efi.GUID{0x07, 0xc0, 0xb2, 0xf4, 0xa1, 0x94, 0xd5, 0x4c, 0xa7, 0x10, 0xf4, 0x14, 0x1f, 0xce, 0xbc, 0xa0}: "AmiTseOemTSEVarGuid",
		efi.GUID{0x07, 0xc6, 0x00, 0x89, 0xaa, 0xc0, 0x8e, 0x47, 0xaf, 0x00, 0x65, 0x87, 0x0b, 0xc9, 0x51, 0xfd}: "SetupStatusDxe",
		efi.GUID{0x07, 0xca, 0x0d, 0x91, 0x94, 0x1f, 0xe7, 0x4e, 0xaf, 0x2f, 0xff, 0x72, 0xf3, 0x15, 0x43, 0x53}: "EfiSmmBaseHelperReadyProtocolGuid",
		efi.GUID{0x07, 0xd0, 0xf2, 0xc4, 0xfd, 0x37, 0x2d, 0x42, 0xb6, 0x3d, 0x7e, 0xd7, 0x38, 0x86, 0xe6, 0xca}: "IdeRController",
		efi.GUID{0x07, 0xdf, 0xd4, 0x4d, 0x78, 0x32, 0x6f, 0x40, 0xb5, 0xde, 0xec, 0x7e, 0xec, 0xc6, 0x50, 0xe1}: "CrbPxeUefiDriver",
		efi.GUID{0x07, 0xe3, 0x68, 0xdc, 0x8c, 0x6c, 0x97, 0x49, 0xb3, 0x2f, 0x3f, 0x73, 0xc3, 0x81, 0xb7, 0x69}: "DellSmmTagsProtocol",
		efi.GUID{0x07, 0xec, 0x21, 0xe1, 0x42, 0x9c, 0xee, 0x45, 0xb0, 0xb6, 0xff, 0xf8, 0xef, 0x03, 0xc5, 0x21}: "AppleRtcRam",
		efi.GUID{0x07, 0xec, 0x9c, 0xc8, 0xee, 0xc4, 0x0c, 0x44, 0xbf, 0xc5, 0xa2, 0x2f, 0x43, 0x37, 0x2f, 0x22}: "DellDashConfig",
		efi.GUID{0x07, 0xf0, 0x7c, 0xf2, 0xc7, 0x4a, 0x74, 0x4b, 0xb2, 0xd0, 0x73, 0x16, 0x1c, 0x24, 0x14, 0x62}: "FjMfgNvmeIdentifyCheckDxe",
		efi.GUID{0x08, 0x03, 0x00, 0x6d, 0x13, 0xc9, 0xdb, 0x40, 0xad, 0x40, 0xb3, 0x09, 0x4f, 0xb0, 0xf7, 0x56}: "AmdCcxXvDxe",
		efi.GUID{0x08, 0x12, 0x67, 0xa1, 0x69, 0x72, 0x1b, 0x4e, 0xba, 0xda, 0xce, 0x0f, 0x51, 0x84, 0x4c, 0x2a}: "PlatformTcoReset",
		efi.GUID{0x08, 0x17, 0x87, 0x1f, 0x41, 0x15, 0x1f, 0x46, 0x91, 0xd5, 0x4a, 0x90, 0x85, 0x2d, 0xc9, 0x13}: "FjGabiNvramMergeSmm",
		efi.GUID{0x08, 0x26, 0xc2, 0x0b, 0xc5, 0xec, 0xb9, 0x47, 0xa0, 0x38, 0x4f, 0x0a, 0x68, 0x37, 0x2e, 0x44}: "DellDeviceNameConfig",
		efi.GUID{0x08, 0x28, 0xcb, 0x0b, 0xa5, 0xfe, 0x47, 0x60, 0x9a, 0x60, 0x87, 0x67, 0xa4, 0x6a, 0x72, 0xa1}: "AppleUdp4Dxe",
		efi.GUID{0x08, 0x2d, 0x95, 0xdc, 0x2b, 0xc6, 0xc6, 0x41, 0xba, 0xc7, 0x70, 0xed, 0x05, 0x4f, 0x91, 0xe5}: "Pkcs7VerifyDxe",
		efi.GUID{0x08, 0x30, 0x44, 0xed, 0x06, 0x3f, 0xdb, 0x46, 0x92, 0x7e, 0x7a, 0xb2, 0xf0, 0x2a, 0xf9, 0xd9}: "ApplePciCameraDxe",
		efi.GUID{0x08, 0x35, 0x0a, 0x89, 0x16, 0xe8, 0xcf, 0x41, 0xb7, 0xe6, 0xed, 0x28, 0xe5, 0xbb, 0x5c, 0x28}: "AmtCompatiblity",
		efi.GUID{0x08, 0x3b, 0xb9, 0xac, 0xdc, 0x5c, 0x8f, 0x4a, 0x93, 0xd4, 0x06, 0xe3, 0x42, 0xdf, 0x18, 0x2e}: "PchPeiInitPpiGuid",
		efi.GUID{0x08, 0x40, 0x7b, 0x40, 0x5b, 0xbf, 0xdf, 0x11, 0x95, 0x47, 0xcf, 0x16, 0xe0, 0xd7, 0x20, 0x85}: "PL111LcdGraphicsDxe",
		efi.GUID{0x08, 0x42, 0xca, 0x79, 0xa1, 0xbb, 0x9a, 0x4a, 0x84, 0x56, 0xe1, 0xe6, 0x6a, 0x81, 0x48, 0x4e}: "Legacy8259",
		efi.GUID{0x08, 0x4c, 0x32, 0x1c, 0x94, 0xeb, 0x15, 0x47, 0x91, 0x80, 0xf5, 0xa4, 0x53, 0xc5, 0x72, 0x69}: "OemGOPCallBack",
		efi.GUID{0x08, 0x65, 0x41, 0x52, 0x1c, 0x18, 0x99, 0x48, 0x8c, 0xca, 0xe0, 0x20, 0xa2, 0xbd, 0x3f, 0x18}: "ODMSMM",
		efi.GUID{0x08, 0x71, 0x28, 0x71, 0x58, 0xbf, 0xea, 0x41, 0xb7, 0x1c, 0xb3, 0x62, 0x2d, 0xeb, 0xca, 0x9d}: "DellSmmSbGeneric",
		efi.GUID{0x08, 0x7a, 0x79, 0x91, 0x61, 0xb8, 0xa6, 0x49, 0xa2, 0x71, 0x7e, 0xca, 0x11, 0xd7, 0x90, 0x25}: "MemTestPei",
		efi.GUID{0x08, 0x81, 0x19, 0xaf, 0x2b, 0x86, 0x46, 0x4b, 0xaa, 0xb8, 0xb0, 0xb3, 0x4d, 0x3a, 0xde, 0x0f}: "WifiPxeControl",
		efi.GUID{0x08, 0x88, 0x09, 0xeb, 0xc1, 0x8f, 0xb1, 0x4f, 0xab, 0x66, 0x26, 0x78, 0x46, 0x33, 0xb7, 0x45}: "UltraFunctionTable",
		efi.GUID{0x08, 0x8f, 0x3d, 0x91, 0x30, 0x01, 0x85, 0x4e, 0xb5, 0x8e, 0x38, 0x9c, 0xa5, 0x66, 0xc1, 0xec}: "DellDeviceDetectionDxe",
		efi.GUID{0x08, 0x90, 0x26, 0x35, 0x21, 0xcf, 0x7c, 0x4a, 0xa5, 0x8c, 0x5c, 0xbf, 0x2b, 0xde, 0x4a, 0xa6}: "EmulatedEepromSmm",
		efi.GUID{0x08, 0x9e, 0xfd, 0xbd, 0x13, 0x31, 0x59, 0x42, 0x86, 0xed, 0x58, 0xdd, 0x83, 0x05, 0x35, 0xd8}: "StorageFlushDxe",
		efi.GUID{0x08, 0x9f, 0x79, 0x9c, 0x2e, 0x21, 0xa0, 0x49, 0x9c, 0xf1, 0xc4, 0xfd, 0xb0, 0x13, 0x0f, 0xcc}: "DellBeepErrorCodePei",
		efi.GUID{0x08, 0xa6, 0x8c, 0x87, 0x3f, 0x29, 0x2e, 0x48, 0x83, 0xa9, 0x50, 0xa4, 0x84, 0xb5, 0xd4, 0xed}: "EDockSmm",
		efi.GUID{0x08, 0xb0, 0x65, 0x30, 0x9b, 0x5e, 0xa9, 0x47, 0x9f, 0xe0, 0x00, 0x1c, 0xda, 0x3c, 0x5f, 0x68}: "CcgxFwUpdate",
		efi.GUID{0x08, 0xb7, 0x40, 0xaa, 0x73, 0x90, 0x36, 0x44, 0xb5, 0xfe, 0xd2, 0x2d, 0x7a, 0xbb, 0xa5, 0xc4}: "MemoryDiagnosticDxe",
		efi.GUID{0x08, 0xb8, 0x76, 0x1b, 0x0a, 0xb9, 0xa4, 0x42, 0xb0, 0xa0, 0xbe, 0x61, 0xb1, 0x21, 0xe1, 0x14}: "FjTpmMisc",
		efi.GUID{0x08, 0xc0, 0x96, 0x53, 0xf9, 0xd8, 0x76, 0x4d, 0xb6, 0x0e, 0x9f, 0x9a, 0xab, 0xa2, 0x92, 0x4a}: "LenovoStartupMenuDxe",
		efi.GUID{0x08, 0xc3, 0x4a, 0x59, 0x19, 0x88, 0x84, 0x42, 0xb6, 0x61, 0xb7, 0x57, 0x08, 0x81, 0xcc, 0x0f}: "RfSecureBoot",
		efi.GUID{0x08, 0xd0, 0x02, 0x63, 0x9b, 0x7f, 0x30, 0x4f, 0x87, 0xac, 0x60, 0xc9, 0xfe, 0xf5, 0xda, 0x4e}: "EfiShellProtocolGuid",
		efi.GUID{0x08, 0xd1, 0xfb, 0xf2, 0x85, 0x89, 0xdb, 0x11, 0xb0, 0x6a, 0x00, 0x40, 0xd0, 0x2b, 0x18, 0x35}: "MiscSubclass",
		efi.GUID{0x08, 0xde, 0x14, 0x09, 0x4d, 0x43, 0x9f, 0x4f, 0x93, 0xb3, 0x6f, 0xa4, 0x8a, 0xea, 0xf7, 0xe0}: "DellSpiPartMicron",
		efi.GUID{0x08, 0xe2, 0x89, 0x4f, 0x44, 0xe1, 0x04, 0x48, 0x9e, 0xc8, 0x0f, 0x89, 0x4f, 0x7e, 0x36, 0xd7}: "EfiPeiSectionExtractionPpiGuid",
		efi.GUID{0x08, 0xf4, 0x57, 0xe5, 0xc2, 0x3b, 0xce, 0x48, 0xa9, 0xe1, 0x40, 0xa3, 0xa9, 0x0e, 0xc1, 0xc7}: "USBControllerPei",
		efi.GUID{0x08, 0xf4, 0x7a, 0x9d, 0xa3, 0x64, 0xf4, 0x4a, 0x83, 0xc9, 0x2d, 0x10, 0x95, 0xf7, 0x00, 0xd1}: "CpuMpPei",
		efi.GUID{0x08, 0xf8, 0xa6, 0x6b, 0x7f, 0x52, 0x86, 0x41, 0x9c, 0x30, 0x67, 0x04, 0x99, 0xbd, 0x92, 0xd1}: "DellSmmComputraceAcpiMode",
		efi.GUID{0x08, 0xfb, 0x84, 0xd6, 0x0e, 0x8b, 0xaf, 0x4c, 0x8c, 0xff, 0x1e, 0xa3, 0x86, 0x27, 0x98, 0x09}: "HybridGraphicsSmm",
		efi.GUID{0x09, 0x0d, 0x2e, 0x61, 0x11, 0x5d, 0x16, 0x45, 0x82, 0xee, 0x6d, 0xd6, 0x05, 0xfe, 0x26, 0x5f}: "DellTxtDxe",
		efi.GUID{0x09, 0x0d, 0x30, 0xd3, 0x0f, 0xb7, 0x15, 0x43, 0x97, 0x85, 0xfe, 0x37, 0x20, 0x9e, 0xfd, 0xcb}: "HddSecurityBdsCall",
		efi.GUID{0x09, 0x15, 0xf6, 0x8e, 0x0b, 0x89, 0xf2, 0x4f, 0xb3, 0x52, 0x1c, 0x0e, 0x9c, 0xdd, 0xec, 0x8b}: "I2CLibPei",
		efi.GUID{0x09, 0x25, 0xb1, 0x5d, 0x50, 0x45, 0x47, 0x43, 0x96, 0xb3, 0x73, 0xc0, 0xff, 0x6e, 0x86, 0x9f}: "EfiRedfishDiscoverProtocol",
		efi.GUID{0x09, 0x28, 0x52, 0x80, 0x26, 0xd9, 0x50, 0x4d, 0x8e, 0x71, 0x1e, 0x89, 0x7a, 0xb2, 0x9e, 0x1d}: "FjPowerDeliveryCapsuleDxe",
		efi.GUID{0x09, 0x2d, 0x44, 0x32, 0x11, 0x1d, 0x27, 0x4e, 0x8a, 0xab, 0x90, 0xfe, 0x6a, 0xcb, 0x04, 0x89}: "SystemFormBrowserCoreDxe",
		efi.GUID{0x09, 0x32, 0x02, 0x80, 0x86, 0x63, 0x1d, 0x4c, 0x90, 0x9b, 0x63, 0x50, 0x6a, 0x21, 0x46, 0xff}: "HWM_SetupDXE",
		efi.GUID{0x09, 0x34, 0xb2, 0x19, 0xbd, 0x85, 0xb0, 0x44, 0x89, 0x7f, 0xec, 0xfe, 0x8a, 0xa7, 0xa1, 0x45}: "SmbiosElogType15",
		efi.GUID{0x09, 0x37, 0x12, 0x19, 0x70, 0xf7, 0xaa, 0x4f, 0x85, 0x8e, 0x3b, 0xd5, 0xfb, 0x18, 0x46, 0x4d}: "OemSmi",
		efi.GUID{0x09, 0x39, 0x07, 0x7a, 0x74, 0x6d, 0x73, 0x4c, 0x9f, 0x05, 0x3e, 0x0b, 0x05, 0x5c, 0xa6, 0x23}: "PlatformSioInitDxe",
		efi.GUID{0x09, 0x41, 0xa2, 0xac, 0x7a, 0x6c, 0xec, 0x4c, 0x91, 0x33, 0x5f, 0xb9, 0xd8, 0x27, 0x49, 0x10}: "IntelLtsxFit",
		efi.GUID{0x09, 0x46, 0x65, 0xd8, 0xf3, 0xf6, 0xe9, 0x44, 0xb8, 0xed, 0x20, 0xa9, 0x82, 0x98, 0x18, 0xc8}: "DellIoExpanderSmm",
		efi.GUID{0x09, 0x53, 0xdc, 0xfb, 0x95, 0xbf, 0xb5, 0x44, 0xa8, 0xae, 0xe0, 0x59, 0x3e, 0x05, 0x22, 0xbf}: "BackupBiosUpdate",
		efi.GUID{0x09, 0x6d, 0xe3, 0xc3, 0x94, 0x82, 0x97, 0x4b, 0xa8, 0x57, 0xd5, 0x28, 0x8f, 0xe3, 0x3e, 0x28}: "EfiBiosIdGuid",
		efi.GUID{0x09, 0x71, 0xaf, 0xea, 0x2d, 0xec, 0x30, 0x4a, 0xbf, 0x4f, 0x62, 0x14, 0x08, 0x63, 0x0e, 0x4c}: "FlashOemHooKSmm",
		efi.GUID{0x09, 0x71, 0xec, 0x9b, 0x7a, 0x6d, 0x3a, 0x41, 0x8e, 0x4b, 0x01, 0x9c, 0xed, 0x05, 0x03, 0xe1}: "AmiBoardInfoSectionGuid",
		efi.GUID{0x09, 0x76, 0xd3, 0x6a, 0xf9, 0xa9, 0x87, 0x45, 0x90, 0x23, 0x78, 0x20, 0xe1, 0x0f, 0x5b, 0x7a}: "HiiLayoutPkgDxe",
		efi.GUID{0x09, 0x76, 0xe4, 0x0c, 0x04, 0x0e, 0xe5, 0x4e, 0xa1, 0x92, 0xf4, 0x10, 0xa1, 0x99, 0x5e, 0x0a}: "b57undix64",
		efi.GUID{0x09, 0x77, 0x31, 0x37, 0x19, 0x3b, 0x6a, 0x44, 0xb1, 0x84, 0x63, 0x02, 0x7e, 0x14, 0xaf, 0x01}: "DeviceGuardProtocolOverride",
		efi.GUID{0x09, 0x78, 0x16, 0xb8, 0x3a, 0xe7, 0x87, 0x43, 0x83, 0x23, 0x0a, 0xfe, 0x83, 0xd3, 0x07, 0x4f}: "SmmAslSmiProtocol",
		efi.GUID{0x09, 0x81, 0xed, 0x2d, 0x55, 0x23, 0xf8, 0x41, 0xa6, 0x57, 0xd6, 0x08, 0xd5, 0xcc, 0x10, 0x22}: "SdxcDxe",
		efi.GUID{0x09, 0x8c, 0x59, 0xb4, 0x08, 0xda, 0x75, 0x5f, 0xa9, 0x56, 0x2c, 0xff, 0x90, 0x1b, 0x1c, 0x24}: "MonacoFont",
		efi.GUID{0x09, 0x94, 0x15, 0x97, 0x5f, 0xce, 0x1c, 0x4c, 0xbd, 0xae, 0x7b, 0xd6, 0x98, 0x1c, 0x2c, 0x11}: "SmcSetPowerStatus",
		efi.GUID{0x09, 0x94, 0x15, 0x97, 0x5f, 0xce, 0x1c, 0x4c, 0xbd, 0xae, 0x7b, 0xd6, 0x98, 0x1c, 0x2c, 0x4f}: "SmcOpromCtl",
		efi.GUID{0x09, 0x9a, 0x1c, 0x82, 0x1a, 0x54, 0xf6, 0x40, 0x9f, 0x43, 0x0a, 0xd1, 0x93, 0xa1, 0x2c, 0xfe}: "EdkiiMemoryProfileGuid",
		efi.GUID{0x09, 0x9a, 0x73, 0x45, 0x5e, 0x04, 0xb5, 0x40, 0x9f, 0xa2, 0xf7, 0xf6, 0x6c, 0xb3, 0x55, 0x51}: "DisplayDetectDxe",
		efi.GUID{0x09, 0x9f, 0x15, 0xce, 0x96, 0xd8, 0x58, 0x40, 0xb5, 0xbb, 0x1a, 0xe6, 0xea, 0xb0, 0x0e, 0x01}: "OemPowerModeDxe",
		efi.GUID{0x09, 0xa3, 0x87, 0xae, 0x97, 0xfc, 0x55, 0x4e, 0x94, 0xdd, 0xbb, 0x1b, 0x06, 0x1c, 0xe8, 0x4a}: "FjSystemConfigurationRt",
		efi.GUID{0x09, 0xad, 0x44, 0x3e, 0x8b, 0xd8, 0x52, 0x4c, 0xb4, 0x1b, 0xb8, 0xc0, 0x05, 0x36, 0x47, 0x4a}: "LenovoSystemCryptSvcRt",
		efi.GUID{0x09, 0xad, 0xae, 0xba, 0xa0, 0x02, 0x31, 0x41, 0x9e, 0x0d, 0xbc, 0x52, 0x9e, 0xf0, 0xff, 0x2a}: "EfiTcgMpDriverHobGuid",
		efi.GUID{0x09, 0xb2, 0xbc, 0x3b, 0xc8, 0x26, 0xa9, 0x4b, 0xad, 0x25, 0xb9, 0x5b, 0x45, 0xa0, 0x4d, 0x26}: "BatteryState3",
		efi.GUID{0x09, 0xb6, 0xb8, 0xb8, 0x6c, 0x0b, 0x8c, 0x4b, 0xa7, 0x31, 0xde, 0x03, 0xa6, 0xc3, 0xf3, 0xdc}: "ScBiosWriteProtect",
		efi.GUID{0x09, 0xc0, 0x24, 0xe4, 0x92, 0xcd, 0xec, 0x4f, 0x80, 0x29, 0xd7, 0x9d, 0x3f, 0x1c, 0xf3, 0xde}: "IntelIchReset",
		efi.GUID{0x09, 0xc3, 0xb6, 0x89, 0x85, 0xf7, 0x1f, 0x42, 0xa0, 0x3c, 0x38, 0xa8, 0x00, 0x34, 0x52, 0x01}: "AmdCpmUartDxe",
		efi.GUID{0x09, 0xc7, 0x00, 0x2b, 0x2f, 0x78, 0x79, 0x48, 0xa5, 0x9a, 0x8e, 0x2f, 0xce, 0x22, 0x71, 0xf8}: "AmdCdmaDsmDxe",
		efi.GUID{0x09, 0xc8, 0x6b, 0x1b, 0x86, 0xc9, 0x37, 0x49, 0x93, 0x4f, 0x1e, 0xa5, 0x86, 0x22, 0xfe, 0x50}: "AmiTseBootOrderChangeGuid",
		efi.GUID{0x09, 0xd6, 0x71, 0x9e, 0x24, 0x6d, 0xfd, 0x47, 0xb5, 0x72, 0x61, 0x40, 0xf8, 0xd9, 0xc2, 0xa4}: "PchTcoSmiDispatchProtocol",
		efi.GUID{0x09, 0xdc, 0xc5, 0x32, 0x93, 0xe4, 0x04, 0x4e, 0xa3, 0x88, 0x57, 0x4d, 0xee, 0x0c, 0xee, 0x7b}: "FjRandomNumberSmm",
		efi.GUID{0x09, 0xdc, 0xe0, 0xbe, 0x48, 0xb0, 0x6d, 0x47, 0xa0, 0xbb, 0xac, 0xf9, 0xb4, 0xf6, 0x5c, 0x41}: "DellUsbKbPei",
		efi.GUID{0x0a, 0x07, 0xe1, 0x82, 0x08, 0xb8, 0x26, 0x4f, 0xa8, 0xe9, 0xac, 0xdc, 0xdf, 0xf2, 0x72, 0x1a}: "Rtk8153UsbUndiDxe",
		efi.GUID{0x0a, 0x08, 0xc3, 0xdd, 0x40, 0x27, 0xc2, 0x4e, 0x9a, 0xa5, 0xa0, 0xad, 0xef, 0xd6, 0xff, 0x9c}: "EfiIioSystemProtocol",
		efi.GUID{0x0a, 0x0d, 0x1f, 0xce, 0x92, 0x2e, 0xba, 0x4e, 0xa1, 0x71, 0xad, 0x89, 0x12, 0x5c, 0xee, 0x87}: "ValidateExtendedBiosRegionPostMem",
		efi.GUID{0x0a, 0x12, 0x27, 0x6e, 0x10, 0xa5, 0xac, 0x48, 0xbd, 0x66, 0x70, 0x83, 0xda, 0x4d, 0x59, 0x4f}: "CmosWarningPEI",
		efi.GUID{0x0a, 0x16, 0x16, 0xee, 0xbe, 0xe8, 0xa6, 0x47, 0x82, 0x0a, 0xc6, 0x90, 0x0d, 0xb0, 0x25, 0x0a}: "EfiPeiMpServicesPpiGuid",
		efi.GUID{0x0a, 0x2e, 0xe2, 0x50, 0x03, 0x41, 0x99, 0x99, 0x9b, 0xe0, 0xaa, 0x8c, 0xec, 0xbc, 0xe6, 0x94}: "AmdRasApeiDxe",
		efi.GUID{0x0a, 0x31, 0xc0, 0x25, 0x9e, 0xcb, 0xe0, 0x47, 0xcb, 0xc0, 0xf7, 0xf4, 0x5e, 0x55, 0xac, 0x9f}: "DellMfgBootListConfigDxe",
		efi.GUID{0x0a, 0x33, 0xa9, 0x07, 0x47, 0xf3, 0xd4, 0x11, 0x9a, 0x49, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d}: "LegacyMetronome",
		efi.GUID{0x0a, 0x38, 0xbe, 0x29, 0xc0, 0xfb, 0x2b, 0x46, 0xa6, 0xc2, 0x5c, 0x5a, 0x07, 0x6c, 0xaf, 0xde}: "ProjectPEI",
		efi.GUID{0x0a, 0x40, 0xf9, 0xef, 0x95, 0xad, 0x5b, 0x47, 0x86, 0x8f, 0xc7, 0xaf, 0xc3, 0x13, 0xba, 0x72}: "AmiPeiCreateDummyRcHob",
		efi.GUID{0x0a, 0x41, 0xbd, 0x61, 0xf6, 0x69, 0x6f, 0x43, 0x94, 0x37, 0x16, 0xb4, 0xf3, 0x10, 0x8f, 0x3b}: "StaticSkuDataDxeHedtCRB",
		efi.GUID{0x0a, 0x48, 0x5b, 0x1b, 0x45, 0x2b, 0xae, 0x48, 0xaa, 0x0a, 0xd8, 0x2b, 0x92, 0xa7, 0x73, 0x8b}: "AppAdapterSgx3v0",
		efi.GUID{0x0a, 0x55, 0x83, 0x1c, 0x5b, 0x7e, 0x30, 0x4a, 0x9e, 0x93, 0xe2, 0x15, 0x37, 0x71, 0xaa, 0x25}: "FjDmiCpu",
		efi.GUID{0x0a, 0x57, 0x74, 0x5b, 0xb1, 0x03, 0x5e, 0x4f, 0x8a, 0xdb, 0xfb, 0x7b, 0xb1, 0x94, 0xd7, 0xcc}: "NVMeInfoSmm",
		efi.GUID{0x0a, 0x63, 0x73, 0xae, 0x2d, 0x02, 0x84, 0x48, 0xa6, 0x96, 0xf7, 0x28, 0xcb, 0xf5, 0x3a, 0xef}: "SetupItemLinkageSmm",
		efi.GUID{0x0a, 0x67, 0x76, 0xce, 0xc0, 0x55, 0x4b, 0x48, 0x96, 0x2e, 0x84, 0xa2, 0xf6, 0x52, 0x10, 0xa6}: "MEMPATCHPEI",
		efi.GUID{0x0a, 0x68, 0xf5, 0x86, 0x5c, 0x15, 0xc8, 0x4b, 0xac, 0x77, 0x57, 0x38, 0x48, 0xe2, 0xad, 0x3d}: "AmiTreePpiGuid",
		efi.GUID{0x0a, 0x6e, 0xe6, 0x80, 0xd1, 0xcc, 0xfa, 0x43, 0xa7, 0xb1, 0x2d, 0x5e, 0xe0, 0xf1, 0x39, 0x10}: "PciRootBridge",
		efi.GUID{0x0a, 0x78, 0x98, 0x1c, 0x7d, 0xc6, 0x9b, 0x4d, 0xa9, 0xd8, 0x4a, 0xc0, 0x48, 0x7a, 0x6d, 0x6e}: "PcdRecoveryPei",
		efi.GUID{0x0a, 0x78, 0xbf, 0xdb, 0x37, 0x13, 0xa8, 0x49, 0x9b, 0x73, 0x39, 0x02, 0xd6, 0x04, 0x7b, 0xd8}: "H19DisplayHook",
		efi.GUID{0x0a, 0x7e, 0xe6, 0x4d, 0x2c, 0x16, 0x99, 0x49, 0xa5, 0xb8, 0xba, 0x0e, 0x5d, 0x43, 0x28, 0x4c}: "CmosChecksum",
		efi.GUID{0x0a, 0x7f, 0x85, 0x42, 0xf2, 0x13, 0x21, 0x4b, 0x8a, 0x23, 0x53, 0xd3, 0xf7, 0x14, 0xb8, 0x40}: "SystemCapsuleRt",
		efi.GUID{0x0a, 0x84, 0x97, 0x7a, 0xf6, 0xf3, 0xec, 0x49, 0x92, 0x8a, 0x36, 0xd9, 0x0a, 0x76, 0xd6, 0xa5}: "RecoveryFchInitPei",
		efi.GUID{0x0a, 0x8d, 0xbc, 0x6c, 0xce, 0x7a, 0xc5, 0x40, 0x92, 0xe5, 0xf0, 0xda, 0x0a, 0x8a, 0x86, 0x9e}: "FjRealtekLanDriverSetup",
		efi.GUID{0x0a, 0x90, 0xf9, 0x55, 0xb0, 0xbf, 0x30, 0x4b, 0x83, 0xee, 0x7f, 0x43, 0x7f, 0xaf, 0xae, 0x33}: "LenovoDriveEraseSmm",
		efi.GUID{0x0a, 0x96, 0xb1, 0x27, 0x02, 0xee, 0xa8, 0x47, 0x87, 0xb0, 0x12, 0x22, 0xf1, 0x19, 0x25, 0x7f}: "FchTaishanPei",
		efi.GUID{0x0a, 0x9f, 0x6f, 0x24, 0xe3, 0x11, 0x9a, 0x45, 0xae, 0x06, 0x37, 0x2b, 0xdc, 0x4d, 0xe8, 0x06}: "LenovoSystemStatusCodeGenericRt",
		efi.GUID{0x0a, 0xa1, 0x33, 0x3c, 0x7e, 0x91, 0x25, 0x49, 0xa2, 0xc4, 0x8b, 0x54, 0x5b, 0xf1, 0x0a, 0x82}: "HddPwSmm",
		efi.GUID{0x0a, 0xa5, 0x24, 0x0a, 0x48, 0xc1, 0xb6, 0x42, 0x93, 0x02, 0x8e, 0xd3, 0x1d, 0x33, 0x4e, 0x73}: "ASRockNetFtp",
		efi.GUID{0x0a, 0xa9, 0x98, 0xeb, 0xee, 0x42, 0x36, 0x4a, 0x8d, 0xcc, 0xaf, 0xa7, 0x22, 0xc9, 0xca, 0xb3}: "AmiTcgPkgTokenSpaceGuid",
		efi.GUID{0x0a, 0xab, 0xca, 0x4d, 0x90, 0x19, 0x52, 0x43, 0x8d, 0x2f, 0x2d, 0x8f, 0x13, 0x55, 0x98, 0xa5}: "EslTcp4ServiceGuid",
		efi.GUID{0x0a, 0xad, 0x28, 0xa4, 0x34, 0x50, 0x37, 0x4e, 0x8f, 0x9d, 0xdb, 0x2c, 0xe7, 0x2a, 0x59, 0xb3}: "SmbiosOverride",
		efi.GUID{0x0a, 0xbe, 0xab, 0xb3, 0x28, 0x8b, 0x46, 0x44, 0xbb, 0x2c, 0x44, 0x09, 0xbc, 0xc7, 0x5f, 0xd9}: "AsusGpnvDxe",
		efi.GUID{0x0a, 0xc0, 0x29, 0xf4, 0x40, 0x96, 0xb3, 0x46, 0x95, 0x44, 0xf8, 0xf8, 0x6a, 0x28, 0xf3, 0x0f}: "PlatformConfigChangeProtocolGuid",
		efi.GUID{0x0a, 0xc0, 0x98, 0x9c, 0x9b, 0x2e, 0x96, 0x48, 0x95, 0xc8, 0xac, 0x64, 0x35, 0x82, 0x84, 0xe5}: "AmiDxeHashInterfaceguid",
		efi.GUID{0x0a, 0xc8, 0x2f, 0x65, 0x4e, 0x68, 0xb6, 0x40, 0x86, 0xac, 0x71, 0x01, 0x48, 0xe2, 0xc5, 0x40}: "ObjMgr",
		efi.GUID{0x0a, 0xc8, 0xb6, 0xd2, 0xfe, 0xfa, 0x12, 0x45, 0x83, 0x5d, 0x50, 0xd1, 0x36, 0x54, 0x0a, 0xaa}: "MultiConfigUpdateDxe",
		efi.GUID{0x0a, 0xc9, 0xdc, 0xfb, 0xa2, 0xa7, 0x50, 0x4d, 0xaf, 0x79, 0x88, 0x0a, 0x51, 0x3c, 0x53, 0x87}: "QCAWIFI",
		efi.GUID{0x0a, 0xca, 0x47, 0x8a, 0x01, 0xb2, 0xef, 0x46, 0x88, 0x83, 0x54, 0xd4, 0x55, 0x7a, 0x93, 0xa0}: "DisplayLogoDxe",
		efi.GUID{0x0a, 0xcc, 0x45, 0x1b, 0x6a, 0x15, 0x8a, 0x42, 0xaf, 0x62, 0x49, 0x86, 0x4d, 0xa0, 0xe6, 0xe6}: "AprioriPei",
		efi.GUID{0x0a, 0xcd, 0xdb, 0x16, 0x77, 0xed, 0x2c, 0x44, 0xa4, 0xab, 0x3d, 0xca, 0xde, 0x37, 0x8a, 0x1c}: "ThunderboltNhi",
		efi.GUID{0x0a, 0xcf, 0x85, 0x6d, 0x5f, 0x4a, 0xb0, 0x49, 0xba, 0xfd, 0xa9, 0x09, 0x92, 0x67, 0x7f, 0xf7}: "WinbondWpcn381u",
		efi.GUID{0x0a, 0xd9, 0x74, 0xb6, 0xda, 0x9b, 0x0d, 0x41, 0xa2, 0x6c, 0x14, 0xd6, 0xaf, 0xfe, 0xbd, 0x6e}: "CompalCMFCDxe",
		efi.GUID{0x0a, 0xd9, 0x74, 0xb6, 0xda, 0x9b, 0x0d, 0x41, 0xa2, 0x6c, 0x14, 0xd6, 0xaf, 0xfe, 0xbd, 0x6f}: "CompalEDIDDxe",
		efi.GUID{0x0a, 0xdb, 0x6c, 0x3d, 0x1f, 0x5b, 0xa3, 0x43, 0xa4, 0x3b, 0x44, 0x12, 0x67, 0xf9, 0xda, 0xb5}: "AmiSmbiosCpuInfoProtocol",
		efi.GUID{0x0a, 0xe3, 0x0f, 0x56, 0x0c, 0x76, 0xfa, 0x46, 0x98, 0x9a, 0x20, 0x6f, 0x48, 0xc1, 0x7c, 0x80}: "UsbHubTuningDxe",
		efi.GUID{0x0a, 0xef, 0x26, 0x8f, 0x7f, 0x4f, 0x4b, 0x4e, 0x98, 0x02, 0x8c, 0x22, 0xb7, 0x00, 0xff, 0xac}: "EnglishDxe",
		efi.GUID{0x0a, 0xf1, 0x3a, 0x90, 0xe0, 0xbd, 0xce, 0x46, 0xa0, 0x61, 0x8d, 0xbf, 0xf2, 0xd2, 0x42, 0x69}: "Kb902xFlashDxe",
		efi.GUID{0x0a, 0xf7, 0xc2, 0xe6, 0x04, 0xb6, 0x77, 0x48, 0x85, 0xba, 0xde, 0xec, 0x89, 0xe1, 0x17, 0xeb}: "PchInitVariableGuid",
		efi.GUID{0x0a, 0xf9, 0xb0, 0x7a, 0xf8, 0xbd, 0x10, 0x40, 0xa4, 0x34, 0x43, 0x29, 0xfb, 0x61, 0x33, 0x0d}: "SmBusPei",
		efi.GUID{0x0b, 0x07, 0xb7, 0xc7, 0xa8, 0xe5, 0x86, 0x4b, 0x91, 0x10, 0xbd, 0xca, 0x10, 0x95, 0xf4, 0x96}: "PeiFspHobProcessLibSample",
		efi.GUID{0x0b, 0x14, 0x96, 0x60, 0xaa, 0xf2, 0xb5, 0x4f, 0x95, 0x0d, 0xd8, 0xfe, 0x83, 0x35, 0x64, 0xdc}: "AmdDashDxe",
		efi.GUID{0x0b, 0x17, 0x3e, 0x24, 0xbb, 0x83, 0x43, 0x4e, 0x84, 0x0a, 0xf9, 0xec, 0x85, 0x7f, 0xd7, 0x83}: "FjGabiPostFlash",
		efi.GUID{0x0b, 0x1b, 0x4d, 0xc7, 0xb1, 0x91, 0x4a, 0x48, 0xa0, 0x38, 0xfe, 0x7a, 0x08, 0x47, 0xaa, 0x07}: "DualBiosDxe",
		efi.GUID{0x0b, 0x1e, 0xd4, 0x0f, 0xdf, 0xc4, 0x4b, 0x4b, 0x86, 0x3d, 0x17, 0xc0, 0xdb, 0xd6, 0xef, 0x56}: "SbSmi",
		efi.GUID{0x0b, 0x29, 0x15, 0x52, 0xe9, 0x7f, 0xd4, 0x44, 0x8d, 0xdb, 0x25, 0x11, 0x66, 0xee, 0xbe, 0x7f}: "OemMonotonicDxe",
		efi.GUID{0x0b, 0x29, 0x53, 0xa3, 0x7d, 0x86, 0xd3, 0x4c, 0xa8, 0x1b, 0x4b, 0x7e, 0x5e, 0x10, 0x0e, 0x16}: "EfiPlatformTxtPolicyData",
		efi.GUID{0x0b, 0x2e, 0xf3, 0x5c, 0xdf, 0x8e, 0x44, 0x2e, 0x9c, 0xda, 0x93, 0x20, 0x5e, 0x99, 0xec, 0x1c}: "EmuThunkProtocolGuid",
		efi.GUID{0x0b, 0x32, 0x37, 0x4a, 0xb3, 0x3f, 0x65, 0x43, 0x97, 0x30, 0x9e, 0x89, 0xc6, 0x00, 0x39, 0x5d}: "SmmDispatcher",
		efi.GUID{0x0b, 0x39, 0x99, 0x66, 0x2b, 0xdd, 0x2f, 0x43, 0xbe, 0xb2, 0x8c, 0x7d, 0x6a, 0x2c, 0x0c, 0xfc}: "HpPlatformPeiServices",
		efi.GUID{0x0b, 0x3a, 0x22, 0xc2, 0xd3, 0x80, 0x35, 0x4c, 0x89, 0x1f, 0xbd, 0x0c, 0xc4, 0xe9, 0x90, 0xf0}: "LenovoSystemFvFileLoader",
		efi.GUID{0x0b, 0x3c, 0x84, 0x89, 0x01, 0x57, 0xf6, 0x4f, 0xa4, 0x73, 0x65, 0x75, 0x99, 0x04, 0xf7, 0x35}: "EfiBmcAcpiSwChildPolicyProtocol",
		efi.GUID{0x0b, 0x4a, 0xe9, 0x27, 0x3c, 0x6e, 0x4b, 0x4b, 0xb8, 0x76, 0x17, 0x6a, 0xe5, 0x21, 0xce, 0x60}: "DellHotSosDxe",
		efi.GUID{0x0b, 0x4c, 0x58, 0x98, 0xd6, 0x49, 0xaf, 0x4b, 0xb5, 0x42, 0xec, 0xee, 0x25, 0x82, 0x40, 0x9c}: "ASUSBackup",
		efi.GUID{0x0b, 0x50, 0x64, 0xe7, 0x98, 0xe3, 0xb7, 0x4a, 0xbb, 0xbc, 0x99, 0xa8, 0xe6, 0x83, 0x68, 0x1f}: "MeSmbiosDxe",
		efi.GUID{0x0b, 0x55, 0xa5, 0x85, 0x76, 0x3e, 0xe4, 0x42, 0x88, 0x26, 0xf9, 0x87, 0x99, 0x83, 0xde, 0x69}: "DellOA3",
		efi.GUID{0x0b, 0x5b, 0x7f, 0xd1, 0xec, 0xab, 0x0b, 0x4c, 0x9e, 0x4c, 0x80, 0xab, 0xfa, 0xad, 0x03, 0x79}: "PTDxeInit",
		efi.GUID{0x0b, 0x60, 0x80, 0xd7, 0x7e, 0x69, 0xb7, 0x43, 0x9d, 0x6e, 0x30, 0xf7, 0x42, 0x89, 0x1a, 0x72}: "OemACPIDriverSmm",
		efi.GUID{0x0b, 0x6f, 0xdb, 0x0f, 0x81, 0x55, 0x99, 0x49, 0xaf, 0x7d, 0xa5, 0x71, 0xe3, 0x13, 0x1b, 0xd2}: "FjGabiDeviceFirmwareApiSmm",
		efi.GUID{0x0b, 0x72, 0xff, 0xe0, 0x40, 0x01, 0xfe, 0x43, 0x95, 0x28, 0x7a, 0x78, 0x13, 0x57, 0xe4, 0x2e}: "UsbOhciDxe",
		efi.GUID{0x0b, 0x79, 0x24, 0x0b, 0x79, 0x6c, 0xe4, 0x4c, 0x8e, 0x09, 0x38, 0x64, 0xc4, 0x9b, 0xe2, 0x56}: "SioWdtSmi",
		efi.GUID{0x0b, 0x82, 0x44, 0xfd, 0xab, 0xf1, 0xc0, 0x41, 0xae, 0x4e, 0x0c, 0x55, 0x55, 0x6e, 0xb9, 0xbd}: "SMBiosFlashData",
		efi.GUID{0x0b, 0x83, 0x00, 0x1e, 0xa5, 0x8b, 0x24, 0x4d, 0x86, 0x09, 0xe7, 0x49, 0x94, 0xe1, 0x3a, 0x39}: "Common_LilyPei",
		efi.GUID{0x0b, 0x8d, 0xb1, 0x8b, 0x93, 0x91, 0xc5, 0x4d, 0xbd, 0xa0, 0x7b, 0xea, 0x37, 0x35, 0xdc, 0x34}: "FjUsbHub",
		efi.GUID{0x0b, 0x9a, 0x43, 0x5f, 0xd8, 0x45, 0x82, 0x46, 0xa4, 0xf4, 0xf0, 0x57, 0x6b, 0x51, 0x34, 0x41}: "EfiSmmCpuIoGuid",
		efi.GUID{0x0b, 0x9b, 0x83, 0x75, 0x99, 0x0a, 0x33, 0x42, 0x8a, 0xa4, 0x38, 0x66, 0xf6, 0xce, 0xf4, 0xb3}: "FpgaSocketVariable",
		efi.GUID{0x0b, 0xa6, 0xbd, 0x55, 0x0f, 0x1d, 0xd5, 0x42, 0x9f, 0x09, 0x2d, 0x3d, 0x30, 0x67, 0xb8, 0x99}: "EarlyDevices",
		efi.GUID{0x0b, 0xa7, 0x5e, 0x8d, 0xeb, 0x02, 0xd8, 0x48, 0xbe, 0xab, 0x45, 0x97, 0x78, 0xc5, 0xde, 0x1f}: "SmmConfidentialMem",
		efi.GUID{0x0b, 0xa7, 0x93, 0xcc, 0x27, 0xec, 0xc5, 0x49, 0x8b, 0x34, 0x13, 0x93, 0x1e, 0xfe, 0xd6, 0xe2}: "EfiAlertStandardFormatProtocolGuid",
		efi.GUID{0x0b, 0xa8, 0x9c, 0xbd, 0x0e, 0x94, 0x55, 0x4b, 0x88, 0xa4, 0xbb, 0x3a, 0x3c, 0xc9, 0x98, 0x63}: "DellStatusServiceSmmInit",
		efi.GUID{0x0b, 0xaa, 0x4b, 0x6d, 0x31, 0xf4, 0x70, 0x43, 0xaf, 0x19, 0x99, 0xd6, 0x20, 0x92, 0x39, 0xf6}: "BiosGuardServices",
		efi.GUID{0x0b, 0xba, 0xf6, 0x2d, 0x92, 0x70, 0x0d, 0x44, 0xbd, 0x04, 0xfb, 0x09, 0x1e, 0xc3, 0xf3, 0xc1}: "EdkiiPlatformSpecificResetHandlerProtocol",
		efi.GUID{0x0b, 0xbc, 0xad, 0x7a, 0xb8, 0x45, 0x94, 0x46, 0xbb, 0x98, 0xa9, 0x91, 0x96, 0x17, 0x99, 0xd8}: "FlashInterfacePei",
		efi.GUID{0x0b, 0xc7, 0xae, 0x7b, 0xe0, 0x57, 0x76, 0x4c, 0x8e, 0x87, 0x2f, 0x9e, 0x28, 0x08, 0x83, 0x43}: "EfiVT100PlusGuid",
		efi.GUID{0x0b, 0xc7, 0xc4, 0x2c, 0x12, 0x03, 0xd7, 0x4c, 0xbf, 0xc2, 0xa7, 0xa8, 0x9c, 0x88, 0xc0, 0x8a}: "DriveLockDxe",
		efi.GUID{0x0b, 0xca, 0xa4, 0x98, 0xe1, 0x7f, 0xb0, 0x48, 0xb6, 0x8d, 0x23, 0xeb, 0x0e, 0x25, 0x9c, 0x13}: "ScsiPassThruAtapi",
		efi.GUID{0x0b, 0xd1, 0xcd, 0x38, 0x7d, 0x76, 0x6e, 0x4f, 0xa7, 0x44, 0x67, 0xee, 0x1d, 0xfe, 0x2f, 0xa5}: "PeiTxtMemoryUnlockedPpi",
		efi.GUID{0x0b, 0xd2, 0x87, 0xe2, 0x97, 0xd8, 0x1e, 0x4e, 0xa5, 0xd9, 0x97, 0x77, 0x63, 0x93, 0x6a, 0x04}: "EfiPchS3SupportProtocolGuid",
		efi.GUID{0x0b, 0xd5, 0x00, 0xaa, 0x11, 0x49, 0x8f, 0x42, 0xb9, 0x1a, 0xa5, 0x9d, 0xdb, 0x13, 0xe2, 0x4c}: "EdkiiSmmCpuRendezvousProtocol",
		efi.GUID{0x0b, 0xd5, 0xa5, 0x8d, 0x9c, 0xa3, 0xf7, 0x4f, 0xab, 0x4f, 0x74, 0x26, 0xa1, 0x45, 0xd0, 0xe4}: "RandomNumberGen",
		efi.GUID{0x0b, 0xe6, 0xda, 0x5e, 0xb0, 0xa9, 0x46, 0x42, 0x91, 0xdc, 0xe9, 0x7a, 0x4e, 0x4a, 0xdb, 0x2e}: "Armani_PowerReportSmm",
		efi.GUID{0x0b, 0xf0, 0x1d, 0xee, 0xfe, 0xb4, 0x62, 0x47, 0xa3, 0x30, 0x1e, 0x8a, 0xb4, 0xd9, 0x14, 0x9d}: "ExtfTable",
		efi.GUID{0x0b, 0xf6, 0xc4, 0x61, 0x95, 0x81, 0x9c, 0x45, 0x8b, 0xa1, 0xb7, 0xb0, 0x1b, 0x64, 0xdc, 0xef}: "PlatformS3SaveDxe",
		efi.GUID{0x0b, 0xf9, 0x7d, 0x5b, 0x93, 0x2b, 0x93, 0x44, 0xab, 0xaa, 0x48, 0x05, 0xbf, 0x00, 0x8a, 0xea}: "HpDmarSetup",
		efi.GUID{0x0c, 0x02, 0x1e, 0x70, 0x77, 0xe9, 0x7e, 0x4b, 0x89, 0xfb, 0x5c, 0x3a, 0x50, 0x3c, 0x4c, 0x5d}: "ThinkCenterHWDiag",
		efi.GUID{0x0c, 0x02, 0xf1, 0xf9, 0x31, 0xcc, 0x03, 0x42, 0x88, 0x50, 0xee, 0xc0, 0x7a, 0x52, 0xa5, 0xb5}: "SecPchLibFsp",
		efi.GUID{0x0c, 0x03, 0xa7, 0xc7, 0xd8, 0xc3, 0xee, 0x45, 0xbe, 0xd9, 0x5d, 0x9e, 0x76, 0x76, 0x29, 0x53}: "MouseDriver",
		efi.GUID{0x0c, 0x0d, 0x06, 0x47, 0x2b, 0xbb, 0xd2, 0x42, 0x9a, 0x85, 0x4d, 0xf1, 0xa2, 0xbf, 0xdf, 0xe2}: "BoardDxe",
		efi.GUID{0x0c, 0x13, 0x37, 0x31, 0xa7, 0xd0, 0x7e, 0x46, 0x9e, 0x8f, 0x51, 0x38, 0x16, 0xf1, 0x59, 0xd8}: "OpromUpdateDxeNeonCityEPRP",
		efi.GUID{0x0c, 0x15, 0x41, 0x05, 0x3b, 0xe3, 0xaf, 0x4d, 0xa2, 0x63, 0x02, 0xe4, 0xbb, 0x4b, 0xf1, 0xcf}: "SecurityErrorHandlingDxe",
		efi.GUID{0x0c, 0x1d, 0x0c, 0x41, 0x6f, 0x65, 0x69, 0x47, 0x8d, 0xfb, 0x90, 0xf9, 0xa0, 0x30, 0x3e, 0x9f}: "IconFireWireHD",
		efi.GUID{0x0c, 0x1e, 0x6c, 0x70, 0xfc, 0x44, 0x12, 0x40, 0x9b, 0x71, 0x3d, 0xbf, 0xec, 0x76, 0x2f, 0x35}: "PlatformFlashSmm",
		efi.GUID{0x0c, 0x28, 0x80, 0xe3, 0x35, 0x4c, 0xa3, 0x4a, 0xb9, 0x61, 0x7a, 0xe4, 0x89, 0xa2, 0xb9, 0x26}: "AmiSmbiosDynamicDataGuid",
		efi.GUID{0x0c, 0x32, 0x0d, 0xb6, 0xae, 0x25, 0xcf, 0x4d, 0xb8, 0x48, 0x19, 0x6a, 0x7e, 0x55, 0x97, 0x2f}: "KeepCriticalData",
		efi.GUID{0x0c, 0x3d, 0xe8, 0x47, 0xf4, 0x2a, 0x8d, 0x46, 0x91, 0x91, 0x9c, 0xe4, 0x68, 0xc1, 0x8e, 0x9e}: "DellSmmPchGpioControl",
		efi.GUID{0x0c, 0x4a, 0x35, 0x11, 0x1e, 0x78, 0xa1, 0x44, 0xa7, 0x87, 0xc0, 0x17, 0x8c, 0x8d, 0x57, 0x0f}: "P2sbConfigGuid",
		efi.GUID{0x0c, 0x4a, 0x5a, 0xd8, 0x73, 0x2e, 0x91, 0x44, 0x92, 0xe1, 0xdc, 0xef, 0xc3, 0x88, 0x2a, 0x68}: "DellPhysicalPresence",
		efi.GUID{0x0c, 0x4b, 0xc7, 0xa2, 0x8f, 0xf3, 0xf6, 0x42, 0xa1, 0x47, 0x37, 0x90, 0x13, 0xed, 0x92, 0xed}: "OEMIP3SMBIOS",
		efi.GUID{0x0c, 0x4d, 0x42, 0x45, 0xaf, 0xe6, 0xf2, 0x4a, 0xad, 0x99, 0xfa, 0x77, 0x16, 0x87, 0x42, 0xd1}: "SmartTimer",
		efi.GUID{0x0c, 0x4d, 0x7f, 0xf2, 0xe4, 0x70, 0x3b, 0x41, 0xa5, 0x37, 0xff, 0x39, 0xa2, 0x19, 0x9a, 0xa5}: "CbsSetupDxeRN",
		efi.GUID{0x0c, 0x55, 0x67, 0xba, 0x28, 0x36, 0x37, 0x41, 0xa5, 0x3e, 0x42, 0x66, 0x0e, 0x08, 0x16, 0x04}: "MePlatformPolicy",
		efi.GUID{0x0c, 0x56, 0xfc, 0x40, 0xd9, 0xc5, 0x19, 0x42, 0x89, 0x63, 0x46, 0x60, 0x5a, 0xb2, 0x57, 0x0a}: "FjSysmanFwUpdaterBin",
		efi.GUID{0x0c, 0x59, 0x55, 0x27, 0x3c, 0x6f, 0xfa, 0x42, 0x9e, 0xa4, 0xa3, 0xba, 0x54, 0x3c, 0xda, 0x25}: "EfiDebugSupportProtocolGuid",
		efi.GUID{0x0c, 0x5e, 0x47, 0xe1, 0x46, 0x17, 0x02, 0x48, 0x86, 0x2e, 0x01, 0x1c, 0x2c, 0x2d, 0x9d, 0x86}: "EfiRuntimeCryptProtocolGuid",
		efi.GUID{0x0c, 0x5e, 0x4d, 0x9c, 0x12, 0x1c, 0xc5, 0x4b, 0x83, 0xd4, 0xe6, 0x71, 0xbd, 0xd6, 0x1e, 0x40}: "DellServiceOsInterfaceSmm",
		efi.GUID{0x0c, 0x61, 0x74, 0x60, 0xc6, 0x93, 0x50, 0x4a, 0x9a, 0xaa, 0x09, 0x27, 0xde, 0x7c, 0x69, 0x75}: "FirewireDeviceDxe",
		efi.GUID{0x0c, 0x69, 0x73, 0xfc, 0x4a, 0x8d, 0x8c, 0x4f, 0xb7, 0xf5, 0xba, 0x24, 0x1f, 0x31, 0x6e, 0x28}: "CpuInitDxe",
		efi.GUID{0x0c, 0x74, 0x51, 0x98, 0xe0, 0x22, 0x0d, 0x44, 0x90, 0x90, 0xef, 0x2d, 0x71, 0xc2, 0x51, 0xc9}: "AmiCmosAccessDxeProtocolGuid",
		efi.GUID{0x0c, 0x7a, 0xa2, 0x89, 0xa6, 0x33, 0x6a, 0x42, 0xa4, 0x33, 0x43, 0xeb, 0xc7, 0xba, 0x5a, 0x5e}: "RaidOptionSetup",
		efi.GUID{0x0c, 0x7e, 0x92, 0xd0, 0xa5, 0xfe, 0x69, 0x45, 0x8a, 0xc0, 0x33, 0xc8, 0xf6, 0x0e, 0x50, 0x73}: "NvmeRstPassword",
		efi.GUID{0x0c, 0x81, 0xf0, 0x68, 0xdc, 0x1d, 0x07, 0x44, 0xbd, 0x65, 0x87, 0x21, 0x01, 0x40, 0x7a, 0xb7}: "AmdCpmManageabilitySmm",
		efi.GUID{0x0c, 0x8e, 0xdf, 0xfe, 0x47, 0xe1, 0xe3, 0x11, 0x99, 0x03, 0xb8, 0xe8, 0x56, 0x2c, 0xba, 0xfa}: "EfiBootManagerPolicyProtocolGuid",
		efi.GUID{0x0c, 0x97, 0xcb, 0xd2, 0x22, 0x86, 0xe1, 0x46, 0x90, 0x83, 0xdb, 0x2e, 0xa2, 0x0c, 0xa6, 0xe3}: "SystemSecureFlashBootModePei",
		efi.GUID{0x0c, 0xa6, 0x4c, 0x11, 0x65, 0xd9, 0x13, 0x4c, 0xbe, 0xf7, 0xc4, 0x06, 0x22, 0x48, 0xe1, 0xfa}: "EcIoDxe",
		efi.GUID{0x0c, 0xa9, 0x75, 0x89, 0x8c, 0x23, 0xa8, 0x4f, 0x9e, 0xf1, 0x03, 0xc6, 0xc3, 0x59, 0xca, 0x39}: "AmdCpmDiscreteUSB4Peim",
		efi.GUID{0x0c, 0xac, 0x5d, 0xd4, 0xe8, 0x4f, 0x04, 0x43, 0xff, 0xff, 0xff, 0xff, 0x17, 0x45, 0xbe, 0x1a}: "XnotePopNoiseSmm",
		efi.GUID{0x0c, 0xb0, 0xd5, 0x6f, 0x26, 0xd4, 0x83, 0x42, 0x98, 0x87, 0x6c, 0xf5, 0xcf, 0x1c, 0xb1, 0xfe}: "EfiUserManagerProtocolGuid",
		efi.GUID{0x0c, 0xb6, 0x6b, 0x5b, 0xaf, 0x5a, 0x17, 0x42, 0x98, 0x25, 0x09, 0x33, 0xd8, 0x32, 0x85, 0x88}: "Ax88772",
		efi.GUID{0x0c, 0xbe, 0x1b, 0x32, 0x60, 0x35, 0xdf, 0x4b, 0x83, 0x10, 0x23, 0x5c, 0xd7, 0xc1, 0x73, 0xc0}: "RomHoleReplacementPpi",
		efi.GUID{0x0c, 0xc2, 0x2f, 0xf2, 0xf4, 0x8c, 0xeb, 0x45, 0x8e, 0x06, 0xad, 0x4e, 0x50, 0xb9, 0x5d, 0xd3}: "EfiHiiDriverHealthFormsetGuid",
		efi.GUID{0x0c, 0xc7, 0x26, 0xcd, 0x9d, 0xf6, 0x9c, 0x41, 0xae, 0x25, 0x50, 0xe8, 0x44, 0xd1, 0xda, 0xe8}: "RtkMAPT",
		efi.GUID{0x0c, 0xc9, 0xe2, 0xe0, 0xad, 0xf1, 0x59, 0x47, 0x8e, 0xa9, 0x5b, 0x4e, 0x77, 0x05, 0x76, 0xcd}: "AmdNbioPcieZPDxe",
		efi.GUID{0x0c, 0xcb, 0x88, 0x63, 0x3a, 0xcd, 0x1e, 0x4d, 0xb2, 0x6c, 0x4d, 0x82, 0x3d, 0x8b, 0x4b, 0xdf}: "PciExpressDxe",
		efi.GUID{0x0c, 0xd1, 0x83, 0x66, 0x6e, 0xcf, 0x14, 0x49, 0xb5, 0xb4, 0xab, 0x8e, 0xd7, 0x37, 0x0e, 0xd7}: "AmiValidBootImageCertTblGuid",
		efi.GUID{0x0c, 0xd4, 0x67, 0x5f, 0x06, 0x1d, 0x3e, 0x4e, 0x8b, 0x4a, 0xd2, 0x71, 0x3f, 0x46, 0xe1, 0xdc}: "EfiSmtpProtocol",
		efi.GUID{0x0c, 0xd7, 0x73, 0x49, 0x94, 0x1a, 0x2a, 0x41, 0xa3, 0xe1, 0x2a, 0x4c, 0x98, 0x78, 0x2b, 0xfa}: "OemDisplayRule",
		efi.GUID{0x0c, 0xdc, 0x71, 0x05, 0xb8, 0xd3, 0x2c, 0x42, 0xa9, 0xef, 0xac, 0x44, 0x64, 0x83, 0xbd, 0xfe}: "VisualCSM",
		efi.GUID{0x0c, 0xdf, 0x04, 0x55, 0x4d, 0xf5, 0x5f, 0x46, 0x92, 0x00, 0xf0, 0x38, 0x3d, 0xba, 0x1b, 0xc3}: "DualMeFlashExe",
		efi.GUID{0x0c, 0xec, 0x76, 0xc0, 0x28, 0x70, 0x99, 0x43, 0xa0, 0x72, 0x71, 0xee, 0x5c, 0x44, 0x8b, 0x9f}: "EfiCustomModeEnableGuid",
		efi.GUID{0x0c, 0xec, 0xbd, 0x5c, 0x0c, 0xbd, 0x3b, 0x4c, 0x8c, 0x83, 0x8f, 0xeb, 0x11, 0x04, 0xba, 0x69}: "Cf9Reset",
		efi.GUID{0x0c, 0xf1, 0xa0, 0xac, 0xc9, 0x04, 0x4e, 0x4c, 0x9d, 0x7b, 0xb7, 0xa0, 0x97, 0xf5, 0xe1, 0xec}: "LenovoEn25Qh64FlashPartDxe",
		efi.GUID{0x0c, 0xf4, 0xc9, 0x51, 0x43, 0x52, 0x73, 0x44, 0xb2, 0x65, 0xb3, 0xc8, 0xff, 0xaf, 0xf9, 0xfa}: "Crc32SectionExtractDxe",
		efi.GUID{0x0c, 0xf6, 0x21, 0xd5, 0x65, 0x7d, 0xf2, 0x4f, 0x99, 0xc6, 0x12, 0xa2, 0x96, 0x04, 0x0c, 0x57}: "DellCommonBoardInitDxe",
		efi.GUID{0x0c, 0xf6, 0x70, 0x01, 0x40, 0x1d, 0x51, 0x46, 0x95, 0x6d, 0xf0, 0xbd, 0x98, 0x79, 0xd5, 0x27}: "Virtio10",
		efi.GUID{0x0c, 0xfa, 0xb4, 0x97, 0x7e, 0x4d, 0xd0, 0xc2, 0x67, 0x8e, 0xfb, 0x92, 0xe9, 0x6d, 0x2c, 0xc2}: "NfitBindingProtocol",
		efi.GUID{0x0d, 0x02, 0x2b, 0x73, 0xda, 0xdf, 0x5d, 0x42, 0x94, 0x70, 0x4b, 0xbf, 0x2f, 0x1b, 0x00, 0x7c}: "DellQueryStdPcdValues",
		efi.GUID{0x0d, 0x04, 0x07, 0x18, 0x34, 0x59, 0xa2, 0x41, 0xa0, 0x88, 0x8e, 0x0f, 0x77, 0x7f, 0x71, 0xab}: "NvramDxe",
		efi.GUID{0x0d, 0x0b, 0xc7, 0x03, 0xe6, 0x67, 0x16, 0x5c, 0x8e, 0x57, 0x31, 0x2d, 0xf2, 0x46, 0xa9, 0x61}: "BootChimeAudio",
		efi.GUID{0x0d, 0x19, 0x7e, 0xaa, 0x21, 0xbe, 0x09, 0x44, 0x8e, 0x67, 0xa2, 0xcd, 0x0f, 0x61, 0xe1, 0x70}: "UniversalPayloadSerialPortInfo",
		efi.GUID{0x0d, 0x1f, 0xc6, 0x88, 0xa9, 0xdf, 0x87, 0x40, 0x86, 0x87, 0x62, 0x6a, 0x8b, 0x01, 0x0e, 0x0c}: "PasswordLockSmall",
		efi.GUID{0x0d, 0x24, 0x7a, 0x2b, 0xad, 0xd5, 0xd6, 0x4f, 0xbe, 0x1c, 0xdf, 0xa4, 0x41, 0x5f, 0x55, 0x26}: "DtPlatformFormSet",
		efi.GUID{0x0d, 0x26, 0xbc, 0x5c, 0xc0, 0xcd, 0xcb, 0x4b, 0x9f, 0x74, 0x0a, 0x3e, 0xa8, 0x16, 0x09, 0x05}: "FjKbcEmiSmm",
		efi.GUID{0x0d, 0x28, 0xd1, 0x23, 0xf0, 0x43, 0x13, 0x47, 0x90, 0xb2, 0x0e, 0x5e, 0x42, 0x21, 0xaf, 0x4c}: "BatteryState1",
		efi.GUID{0x0d, 0x30, 0xff, 0x9b, 0x47, 0xd6, 0x0e, 0x48, 0x9f, 0xf3, 0x20, 0x06, 0xd3, 0xd7, 0xcc, 0xc6}: "DellMultiDisplayDxe",
		efi.GUID{0x0d, 0x35, 0x96, 0x68, 0xf1, 0xc3, 0x4c, 0x4a, 0xb4, 0x2d, 0x44, 0x8d, 0x57, 0x28, 0x96, 0xc7}: "DellBootMenuFlashBin",
		efi.GUID{0x0d, 0x3a, 0x5b, 0xa4, 0x55, 0x2e, 0x03, 0x4c, 0xad, 0x9c, 0x27, 0xd4, 0x82, 0x0b, 0x50, 0x7e}: "EfiUgaSplashProtocol",
		efi.GUID{0x0d, 0x3c, 0x71, 0x9a, 0x53, 0x20, 0xac, 0x44, 0x9d, 0x4a, 0xe7, 0x93, 0x3c, 0x42, 0x05, 0xa9}: "EcIoDxe",
		efi.GUID{0x0d, 0x3f, 0x0f, 0x82, 0x08, 0x4d, 0x35, 0x6c, 0x85, 0x8a, 0xd9, 0x8e, 0xf4, 0x2c, 0x05, 0x1d}: "AmdPlatformRasSspDxe",
		efi.GUID{0x0d, 0x4e, 0x3d, 0xb0, 0x56, 0x51, 0xab, 0x44, 0xbe, 0xdb, 0x96, 0x75, 0xa3, 0xd5, 0x7d, 0x41}: "PhPlatformSiSmmCodeCheckDxe",
		efi.GUID{0x0d, 0x56, 0x2f, 0x38, 0xa9, 0x17, 0x87, 0x48, 0xbd, 0x9c, 0xeb, 0x43, 0x9c, 0x1c, 0xc4, 0x82}: "RaidDriver",
		efi.GUID{0x0d, 0x63, 0xa8, 0x0b, 0xf9, 0xb1, 0xed, 0x4c, 0x88, 0x7d, 0xdd, 0x01, 0x3a, 0x0c, 0x6b, 0x4a}: "UsbTypeCChargingPei",
		efi.GUID{0x0d, 0x6f, 0xe2, 0x58, 0xac, 0xcb, 0xba, 0x4b, 0xb7, 0x0f, 0x18, 0x22, 0x14, 0x15, 0x66, 0x5a}: "VirtioRngDxe",
		efi.GUID{0x0d, 0x7a, 0x57, 0x44, 0x1a, 0x36, 0xb2, 0x45, 0xb3, 0x3d, 0xbb, 0x9e, 0xe6, 0x0d, 0x5a, 0x4f}: "ArmRealViewEbPkgTokenSpaceGuid",
		efi.GUID{0x0d, 0x7e, 0xc8, 0xbc, 0xd6, 0x86, 0x4d, 0x4d, 0x80, 0x40, 0x2d, 0x98, 0x3d, 0x36, 0x8b, 0xd1}: "EmuGopDxe",
		efi.GUID{0x0d, 0x80, 0xe6, 0xc7, 0x66, 0x95, 0x43, 0x11, 0x81, 0xa8, 0xb8, 0xc5, 0x66, 0xaf, 0x35, 0x56}: "SNP",
		efi.GUID{0x0d, 0x81, 0x22, 0x71, 0xd3, 0xcc, 0x09, 0x4b, 0xa0, 0xab, 0x8d, 0x10, 0x76, 0x45, 0xc9, 0x78}: "DellMonotonicCounterSmm",
		efi.GUID{0x0d, 0x83, 0x7a, 0x68, 0xfb, 0x55, 0x5a, 0x41, 0x95, 0x20, 0x18, 0x27, 0x89, 0x35, 0x32, 0x84}: "SetupExit",
		efi.GUID{0x0d, 0x84, 0x96, 0x48, 0xbb, 0x46, 0x2b, 0x41, 0xa3, 0x0a, 0xa6, 0x2a, 0xbf, 0xb3, 0x68, 0x2f}: "SpsAcpiSsdt",
		efi.GUID{0x0d, 0x89, 0x7a, 0xe0, 0xc3, 0x7c, 0x42, 0xd0, 0xa7, 0x4b, 0x12, 0xf1, 0x17, 0xdd, 0xdf, 0x15}: "AppleGraphicsConsole",
		efi.GUID{0x0d, 0x8b, 0x00, 0x0c, 0x6a, 0x59, 0xd1, 0x42, 0x80, 0x9c, 0xd2, 0xe7, 0xb6, 0x49, 0x17, 0x7e}: "HwErrorHandler",
		efi.GUID{0x0d, 0x90, 0x7c, 0xd7, 0xc7, 0xa1, 0xc5, 0x41, 0xb9, 0x89, 0x0c, 0x3d, 0x37, 0xfc, 0xa4, 0x32}: "AmtWrapperDxe",
		efi.GUID{0x0d, 0x92, 0xbb, 0x7e, 0xaf, 0x1a, 0xd9, 0x46, 0xb2, 0xaf, 0x54, 0x1e, 0x1d, 0xce, 0x14, 0x8b}: "EdkiiPlatformHasDeviceTree",
		efi.GUID{0x0d, 0x93, 0x1e, 0xb1, 0x82, 0xa0, 0xe2, 0x42, 0xa7, 0xf2, 0xc6, 0x37, 0x67, 0xa4, 0xd3, 0xe7}: "SI_BoardDxe",
		efi.GUID{0x0d, 0x98, 0xb4, 0x24, 0x4d, 0x3f, 0x29, 0x45, 0xb3, 0x26, 0xcb, 0xe8, 0x7e, 0x35, 0x01, 0x3c}: "AmdDmarControlPei",
		efi.GUID{0x0d, 0x9a, 0xa7, 0xd4, 0x7d, 0xb6, 0x83, 0x4e, 0x8e, 0xfb, 0x45, 0x59, 0x24, 0x37, 0x29, 0x34}: "DellTerminalPlatformPolicy",
		efi.GUID{0x0d, 0xa5, 0x90, 0x5e, 0x55, 0x69, 0x49, 0x4a, 0x90, 0x32, 0xda, 0x38, 0x12, 0xf8, 0xe8, 0xe5}: "AmiSmbiosProtocolGuid",
		efi.GUID{0x0d, 0xab, 0xc0, 0x02, 0xf0, 0xd5, 0xad, 0x4c, 0xa4, 0xbf, 0x0c, 0xc4, 0x0a, 0x55, 0x4b, 0xbd}: "HpInitNVSWksSmm",
		efi.GUID{0x0d, 0xc8, 0xc1, 0xcd, 0xd3, 0xe6, 0x42, 0x4a, 0x92, 0x29, 0x75, 0xf3, 0xbe, 0xfc, 0xf1, 0x09}: "PciOutOfResourceSetupPage",
		efi.GUID{0x0d, 0xd2, 0xa4, 0x6d, 0x2d, 0x89, 0xdf, 0x4e, 0x97, 0xa7, 0xfe, 0xa2, 0xd8, 0x8e, 0x26, 0xd7}: "HotKeyPei",
		efi.GUID{0x0d, 0xd2, 0xca, 0x58, 0x1f, 0xd5, 0x85, 0xb3, 0x7f, 0x84, 0xe8, 0x29, 0xca, 0x2f, 0x7c, 0x3a}: "EcGpioControl2Smm",
		efi.GUID{0x0d, 0xda, 0x8c, 0x36, 0x31, 0xcf, 0x9b, 0x4b, 0x8c, 0xf6, 0xe7, 0xd1, 0xbf, 0xff, 0x15, 0x7e}: "EfiConsoleLock",
		efi.GUID{0x0d, 0xdb, 0xee, 0x8b, 0x1a, 0xa3, 0x61, 0x03, 0xa3, 0x12, 0x5d, 0xc8, 0x57, 0x4c, 0x65, 0xf1}: "AzaliaPolicyPei",
		efi.GUID{0x0d, 0xdd, 0xaa, 0x80, 0x53, 0x80, 0xa7, 0x4b, 0x94, 0x1b, 0x36, 0xf4, 0x8b, 0xb2, 0x30, 0x01}: "DellSystemPwSmm",
		efi.GUID{0x0d, 0xe0, 0x95, 0x4f, 0x84, 0x6b, 0xd1, 0x40, 0xb2, 0xa2, 0xfd, 0xf7, 0x18, 0x53, 0x71, 0x83}: "WlanPei",
		efi.GUID{0x0d, 0xe0, 0xde, 0x5f, 0x40, 0xda, 0x5a, 0x40, 0xb9, 0x2e, 0xcf, 0x4a, 0x80, 0xea, 0x8f, 0x76}: "AmiCcidPresence",
		efi.GUID{0x0d, 0xf1, 0x89, 0xbf, 0x05, 0xb2, 0x4f, 0x47, 0x96, 0xe3, 0x7a, 0x7b, 0xb1, 0xb4, 0xa4, 0x07}: "VgaClassDxe",
		efi.GUID{0x0d, 0xf5, 0x18, 0xc1, 0x1d, 0x39, 0xf4, 0x45, 0xb3, 0xd3, 0x11, 0xbc, 0x93, 0x1a, 0xa5, 0x6d}: "DsdtAsl",
		efi.GUID{0x0d, 0xf6, 0x59, 0x12, 0x54, 0xb7, 0x8e, 0x46, 0xa7, 0x89, 0x4d, 0xb8, 0x5d, 0x55, 0xe8, 0x7e}: "EfiSwapAddressRangeProtocolGuid",
		efi.GUID{0x0d, 0xfc, 0x3f, 0x2c, 0xb4, 0x0a, 0x75, 0x4d, 0xb8, 0xee, 0x00, 0x86, 0xd7, 0x6b, 0x8a, 0x0c}: "CxlPostMemInit",
		efi.GUID{0x0e, 0x07, 0x0b, 0x52, 0xad, 0x83, 0x35, 0x41, 0xad, 0x62, 0x07, 0xdf, 0xbd, 0x66, 0x39, 0x6a}: "Armani_BatteryInfoDxe",
		efi.GUID{0x0e, 0x08, 0xa6, 0x82, 0xcb, 0x07, 0x41, 0x48, 0xa9, 0x4e, 0xd3, 0x40, 0xfd, 0x0c, 0x52, 0x84}: "NvmeInfoDxe",
		efi.GUID{0x0e, 0x0e, 0xbf, 0x2c, 0x45, 0xb4, 0xbe, 0x48, 0xab, 0xdd, 0xb0, 0x9a, 0x71, 0x30, 0x3f, 0xc5}: "FjRtcWakeupSmm",
		efi.GUID{0x0e, 0x10, 0xb1, 0x37, 0x66, 0x4c, 0x44, 0x9b, 0xd7, 0x36, 0x9b, 0xbb, 0xf1, 0x69, 0xce, 0x2f}: "xGbEI2cMasterDxe",
		efi.GUID{0x0e, 0x17, 0xc6, 0xf3, 0x8d, 0x8b, 0xbc, 0x46, 0xbc, 0x11, 0xd7, 0xbe, 0xbf, 0x1f, 0x69, 0x4d}: "TheftRecoveryDxe",
		efi.GUID{0x0e, 0x19, 0x8c, 0xc6, 0x5e, 0xf9, 0xbc, 0x4a, 0xaa, 0x01, 0xd6, 0x5f, 0x34, 0x4d, 0x91, 0xf9}: "LGImageRecovery",
		efi.GUID{0x0e, 0x1f, 0xa1, 0xf6, 0xbe, 0x0c, 0x0c, 0x44, 0xbd, 0x85, 0x49, 0xfb, 0x59, 0x56, 0x86, 0xea}: "LegacyUcrDxe",
		efi.GUID{0x0e, 0x29, 0x21, 0x38, 0xdd, 0xb8, 0x21, 0x48, 0x81, 0x82, 0x03, 0x61, 0xde, 0x51, 0x60, 0x9d}: "AmdCpmOemAcpi",
		efi.GUID{0x0e, 0x2b, 0x2a, 0x20, 0x31, 0x9a, 0x12, 0x48, 0xb2, 0x91, 0x87, 0x47, 0xdf, 0x15, 0x24, 0x39}: "Ps2MouseDxe",
		efi.GUID{0x0e, 0x2c, 0x5b, 0xad, 0x80, 0xf4, 0x12, 0x49, 0x87, 0x5b, 0x61, 0x82, 0xf0, 0x56, 0xc5, 0xd1}: "DellStatusDetectPei",
		efi.GUID{0x0e, 0x32, 0xf7, 0x3a, 0x0e, 0xde, 0x8c, 0x40, 0xaf, 0x25, 0x1c, 0x00, 0xe4, 0xaf, 0x2a, 0xd2}: "WyseThinClientSmm",
		efi.GUID{0x0e, 0x34, 0x86, 0x26, 0x5c, 0x66, 0x7f, 0x42, 0x88, 0x19, 0x05, 0xba, 0x54, 0xf0, 0x30, 0xf5}: "IdeController2",
		efi.GUID{0x0e, 0x36, 0xd2, 0x9f, 0x48, 0x6b, 0xd5, 0x11, 0x8e, 0x71, 0x00, 0x90, 0x27, 0x07, 0xb3, 0x5e}: "PciHostBridge1",
		efi.GUID{0x0e, 0x3c, 0xb5, 0xe9, 0x91, 0x04, 0x76, 0x46, 0x97, 0x2f, 0x9d, 0x15, 0xdd, 0x63, 0x4d, 0xb3}: "DellBatman2Dxe",
		efi.GUID{0x0e, 0x42, 0xa9, 0x12, 0x6a, 0x54, 0x4b, 0x48, 0x85, 0xe7, 0x6f, 0x6b, 0x27, 0xbf, 0x9b, 0x40}: "FjCapsuleResetHookSmm",
		efi.GUID{0x0e, 0x43, 0xfe, 0xbd, 0x2a, 0x8f, 0xb0, 0x4d, 0x99, 0x91, 0x6f, 0x85, 0x65, 0x94, 0x77, 0x7e}: "SystemEhciDxe",
		efi.GUID{0x0e, 0x4e, 0x7d, 0x5f, 0x6d, 0x3d, 0xbc, 0x42, 0xa9, 0x42, 0x0e, 0x91, 0xe8, 0x3e, 0x3c, 0x31}: "EfiPeiTcgLogHobGuid",
		efi.GUID{0x0e, 0x50, 0xf7, 0x3e, 0x55, 0xcf, 0x4f, 0x47, 0x8e, 0x7e, 0x00, 0x9e, 0x0e, 0xac, 0xec, 0xd2}: "AmiUsbSmmProtocolGuid",
		efi.GUID{0x0e, 0x55, 0x77, 0x1e, 0x29, 0xe4, 0xa9, 0x4f, 0xbe, 0xbf, 0xb5, 0x15, 0xac, 0xf7, 0xd9, 0x19}: "Ip6",
		efi.GUID{0x0e, 0x57, 0x33, 0xdb, 0x0c, 0x91, 0x69, 0x46, 0xa9, 0x34, 0xdc, 0x26, 0xbd, 0x30, 0x48, 0x36}: "PchMctp",
		efi.GUID{0x0e, 0x5f, 0x72, 0x72, 0xd9, 0x5c, 0x97, 0x49, 0x85, 0x30, 0x08, 0xd4, 0x64, 0xc1, 0xfc, 0x46}: "XnoteCapsulePolicyDxe",
		efi.GUID{0x0e, 0x66, 0x2e, 0xd6, 0x61, 0x65, 0xdb, 0x45, 0xa8, 0x38, 0x86, 0x09, 0xbb, 0xa5, 0xff, 0x37}: "Cf9Reset",
		efi.GUID{0x0e, 0x69, 0x3f, 0xfd, 0xb0, 0xb4, 0x68, 0x4d, 0x89, 0xdb, 0x19, 0xa1, 0xa3, 0x31, 0x8f, 0x90}: "MICROCODE",
		efi.GUID{0x0e, 0x72, 0x5a, 0x53, 0xc0, 0x06, 0xb9, 0x4b, 0xb5, 0x63, 0x45, 0x22, 0x16, 0xab, 0xbe, 0xd4}: "HdLcdArmVExpress",
		efi.GUID{0x0e, 0x79, 0xbb, 0x4f, 0xe9, 0x71, 0xff, 0x42, 0x9f, 0x8c, 0x46, 0x9c, 0x4f, 0xd0, 0xa0, 0x4a}: "OpromCallback",
		efi.GUID{0x0e, 0x7c, 0x53, 0x2a, 0x9c, 0x5d, 0xd3, 0x45, 0xa6, 0xce, 0x3a, 0xd0, 0x2d, 0x3e, 0x3b, 0x53}: "ReserveMem",
		efi.GUID{0x0e, 0x91, 0xc1, 0xf2, 0xc9, 0xf5, 0x72, 0x4b, 0xb2, 0x43, 0x6d, 0x59, 0x09, 0x6a, 0x79, 0xf0}: "EfiI2cSlaveProtocolGuid",
		efi.GUID{0x0e, 0x92, 0xd9, 0xca, 0xf5, 0x0c, 0x6b, 0x4c, 0xb9, 0x2b, 0xcc, 0x0a, 0x4e, 0x19, 0x55, 0x7c}: "FjSysmanAmphionSmm",
		efi.GUID{0x0e, 0x96, 0x92, 0x8f, 0x80, 0x28, 0x59, 0x46, 0xb8, 0x57, 0x91, 0x5a, 0x89, 0x01, 0xbd, 0xc8}: "Ip6Dxe",
		efi.GUID{0x0e, 0x9c, 0xf5, 0xea, 0x46, 0xbd, 0x3a, 0x41, 0x9a, 0xe9, 0xdd, 0x9f, 0x6d, 0x1a, 0x92, 0x7d}: "SmbiosDxe",
		efi.GUID{0x0e, 0xa1, 0xa4, 0xfb, 0x31, 0x89, 0xe0, 0x4b, 0xb1, 0xeb, 0x92, 0xa1, 0x32, 0x6f, 0x64, 0xbe}: "AcerHwConfigDxe",
		efi.GUID{0x0e, 0xa4, 0x07, 0x50, 0xe0, 0xa5, 0xf7, 0x44, 0x86, 0xae, 0x66, 0x2f, 0x9a, 0x91, 0xda, 0x26}: "FvOnFv2Thunk",
		efi.GUID{0x0e, 0xa8, 0x06, 0x0e, 0x26, 0xd7, 0xaf, 0x4b, 0xa0, 0xcf, 0x21, 0x12, 0x60, 0xfe, 0x69, 0xd8}: "OemSSIDUpdate",
		efi.GUID{0x0e, 0xb1, 0x26, 0x18, 0xe1, 0xec, 0xd1, 0x4b, 0xb3, 0x51, 0xbc, 0x46, 0x9d, 0x17, 0xfc, 0x59}: "DellPlatformSwSmi",
		efi.GUID{0x0e, 0xb8, 0xc8, 0xf2, 0x85, 0x89, 0xdb, 0x11, 0x93, 0xf1, 0x00, 0x40, 0xd0, 0x2b, 0x18, 0x35}: "EfiUnixUga",
		efi.GUID{0x0e, 0xbf, 0xee, 0xc8, 0x10, 0x0e, 0xf7, 0x47, 0x81, 0xbd, 0x39, 0xdb, 0x75, 0xca, 0x93, 0x9f}: "EfiGenericFruProtocol",
		efi.GUID{0x0e, 0xc0, 0x74, 0x50, 0x8b, 0x69, 0x63, 0x47, 0x91, 0xe6, 0x41, 0x66, 0x3f, 0x6c, 0xc7, 0xc9}: "PBSPeiInitPei",
		efi.GUID{0x0e, 0xc7, 0x8d, 0x1a, 0x6d, 0x1d, 0x33, 0x4e, 0xbf, 0x0a, 0x7f, 0xe6, 0xcd, 0x38, 0x74, 0x4e}: "SiInitPch",
		efi.GUID{0x0e, 0xc9, 0xde, 0xea, 0xbe, 0xc2, 0x96, 0x4b, 0xa1, 0x61, 0x55, 0x23, 0x68, 0x22, 0xc0, 0xbb}: "AdlinkBSCDxe",
		efi.GUID{0x0e, 0xcc, 0x5e, 0x34, 0xb6, 0x0c, 0x75, 0x4b, 0xbb, 0x57, 0x1b, 0x12, 0x9c, 0x47, 0x33, 0x3e}: "EfiPlatformToDriverConfigurationClpGuid",
		efi.GUID{0x0e, 0xce, 0x53, 0x9c, 0x9f, 0x0e, 0x20, 0x4f, 0xb1, 0xa1, 0x15, 0x0e, 0x43, 0x49, 0xd7, 0x77}: "Tpm12PPILockOverrideguid",
		efi.GUID{0x0e, 0xd0, 0x40, 0xaa, 0x9b, 0x5b, 0xad, 0x4d, 0xa4, 0x87, 0xfc, 0x1b, 0xcb, 0xef, 0x81, 0x70}: "SgPeiInitPpi",
		efi.GUID{0x0e, 0xd5, 0x43, 0x5c, 0x1d, 0x31, 0x81, 0x44, 0x86, 0xe3, 0x38, 0x42, 0x54, 0x9e, 0xdc, 0x1c}: "AmdHotPlugRsSmm",
		efi.GUID{0x0e, 0xd9, 0x83, 0x69, 0xf7, 0x3e, 0x09, 0x4d, 0x8f, 0x36, 0x63, 0xae, 0x0c, 0x59, 0xcf, 0xf2}: "DellDiagSmm",
		efi.GUID{0x0e, 0xe2, 0xed, 0x6e, 0x32, 0x8f, 0xe2, 0x4f, 0xbe, 0xb7, 0x7a, 0x00, 0xf3, 0xcc, 0xdb, 0xc3}: "OpromUpdateDxeLightningRidgeEXRP",
		efi.GUID{0x0e, 0xf2, 0xbe, 0x07, 0x47, 0x5e, 0x69, 0x4a, 0xb2, 0x28, 0x27, 0xc6, 0xc8, 0x70, 0xea, 0xe1}: "AmdSocFp7r2PhxDxe",
		efi.GUID{0x0e, 0xfd, 0xf5, 0x6d, 0x76, 0x40, 0xb9, 0x41, 0x96, 0xb5, 0x10, 0xe4, 0xc9, 0x72, 0x0b, 0xb3}: "OemApControlDxe",
		efi.GUID{0x0f, 0x08, 0x4d, 0x74, 0xf3, 0xed, 0xf4, 0x4f, 0x98, 0x70, 0xa2, 0xda, 0x5b, 0xa5, 0xf0, 0xe6}: "PlatformDefaultSettings",
		efi.GUID{0x0f, 0x2c, 0x61, 0x4c, 0xc9, 0x2c, 0x75, 0x42, 0x94, 0x84, 0xc7, 0x3f, 0xa6, 0x6c, 0xa9, 0x87}: "FjMacAddressPassThroughDriverBin",
		efi.GUID{0x0f, 0x4a, 0xd5, 0x42, 0xa8, 0xec, 0xd4, 0x49, 0x99, 0x7b, 0xef, 0x3f, 0xbe, 0x3b, 0x5b, 0xc0}: "OemDxeUpdateRx",
		efi.GUID{0x0f, 0x53, 0xce, 0x0e, 0xdd, 0x7b, 0x05, 0x44, 0x9e, 0xb9, 0x61, 0xc9, 0x86, 0x8d, 0x8a, 0xbd}: "AaeonSmbiosDxe",
		efi.GUID{0x0f, 0x5e, 0x12, 0xd5, 0x26, 0x12, 0x4f, 0x44, 0xa2, 0x18, 0x00, 0x85, 0x99, 0x6e, 0xd5, 0xda}: "Smbus",
		efi.GUID{0x0f, 0x60, 0x05, 0x8b, 0x47, 0x4e, 0xed, 0x46, 0xbd, 0xb0, 0x44, 0x11, 0x5d, 0x46, 0x5d, 0x08}: "UpSmbiosData",
		efi.GUID{0x0f, 0x63, 0xe3, 0xd7, 0xca, 0x55, 0xdf, 0x43, 0x80, 0x35, 0xf4, 0xfb, 0x07, 0x74, 0xd0, 0xd9}: "TmFifoDxe",
		efi.GUID{0x0f, 0x66, 0x62, 0x74, 0xbd, 0x1c, 0xda, 0x48, 0xad, 0x11, 0x91, 0x71, 0x79, 0x13, 0x83, 0x1c}: "EfiPciOptionRomTableGuid",
		efi.GUID{0x0f, 0x66, 0x8a, 0x86, 0xf8, 0x47, 0x88, 0x40, 0xa4, 0xc0, 0xc5, 0x5f, 0xf8, 0xdb, 0x0c, 0x96}: "LEMPhyPresenceSet12",
		efi.GUID{0x0f, 0x6e, 0xfb, 0x10, 0x7f, 0x53, 0xd2, 0x41, 0x92, 0x14, 0x7d, 0x00, 0xee, 0xbf, 0xd6, 0xa9}: "LnvSyncMFGDone2BiosGuard",
		efi.GUID{0x0f, 0x70, 0x01, 0x71, 0xc9, 0xa1, 0xe7, 0x44, 0xb6, 0x8d, 0x01, 0xfc, 0xeb, 0xc9, 0xc0, 0x4a}: "FchBixbyEarlyLink",
		efi.GUID{0x0f, 0x73, 0x6f, 0x1d, 0x55, 0x5a, 0x78, 0x40, 0x86, 0x9b, 0xe0, 0xa1, 0x83, 0x24, 0xbd, 0xc8}: "TemplateSec",
		efi.GUID{0x0f, 0x76, 0xc3, 0x2e, 0xfc, 0xb7, 0xc7, 0x4f, 0xb8, 0xb4, 0xcf, 0x37, 0x1c, 0x96, 0x28, 0xff}: "ThunderboltXDomainDevice",
		efi.GUID{0x0f, 0x77, 0x77, 0x36, 0xb2, 0xef, 0xb2, 0x43, 0xb8, 0xae, 0xb3, 0x02, 0xe9, 0x60, 0x48, 0x82}: "AmiTseEventBeforeBootGuid",
		efi.GUID{0x0f, 0x89, 0x6d, 0x4a, 0xc3, 0x93, 0x6d, 0x4b, 0xa6, 0x7d, 0x5f, 0x2c, 0x4d, 0xce, 0x34, 0x7b}: "RuntimeSmm",
		efi.GUID{0x0f, 0x8c, 0xc8, 0x8a, 0x20, 0x62, 0x43, 0xf2, 0x8e, 0x27, 0x56, 0xe1, 0x7c, 0xc5, 0x03, 0xdb}: "AppleNetLoadFile2",
		efi.GUID{0x0f, 0x96, 0x92, 0x8f, 0x80, 0x28, 0x59, 0x46, 0xb8, 0x57, 0x91, 0x5a, 0x89, 0x01, 0xbd, 0xc8}: "Ip4Dxe",
		efi.GUID{0x0f, 0x9d, 0xb7, 0xf0, 0x2b, 0xce, 0x48, 0xd1, 0x9a, 0xce, 0xf2, 0x04, 0xe9, 0x39, 0x3c, 0xaa}: "Tcp4",
		efi.GUID{0x0f, 0x9f, 0x8e, 0x35, 0xc0, 0xdd, 0xd1, 0x42, 0x95, 0x7b, 0xdb, 0xf1, 0x14, 0x97, 0xec, 0xd8}: "EcCommunication",
		efi.GUID{0x0f, 0xa6, 0xd9, 0x6a, 0x15, 0x58, 0x7c, 0x4c, 0x8a, 0x10, 0x50, 0x53, 0xd2, 0xbf, 0x7a, 0x1b}: "EfiSerialTerminalDeviceType",
		efi.GUID{0x0f, 0xa8, 0x8e, 0x74, 0xb4, 0x96, 0x15, 0x43, 0xa2, 0x77, 0x28, 0xac, 0xed, 0x33, 0x68, 0x30}: "RklComp",
		efi.GUID{0x0f, 0xa9, 0x06, 0x7f, 0x0d, 0xae, 0x87, 0x48, 0x82, 0xc0, 0xfe, 0xc7, 0xf4, 0xf6, 0x8b, 0x29}: "EmmcBlockIoPei",
		efi.GUID{0x0f, 0xab, 0x13, 0x37, 0xa0, 0x97, 0xac, 0x44, 0x8a, 0xcc, 0xf2, 0xb1, 0x45, 0x27, 0xf9, 0x55}: "TccPolicyUpdateDxe",
		efi.GUID{0x0f, 0xad, 0x66, 0xf8, 0xbb, 0x1f, 0x52, 0x4d, 0x81, 0x3d, 0x7e, 0xb9, 0x5e, 0x2f, 0x19, 0xd4}: "menu_mid_right",
		efi.GUID{0x0f, 0xb2, 0x05, 0x5f, 0x56, 0x4a, 0x31, 0xc2, 0xfa, 0x0b, 0xa7, 0xb1, 0xf1, 0x10, 0x04, 0x1d}: "EfiRegexSyntaxTypePosixExtendedGuid",
		efi.GUID{0x0f, 0xb3, 0xda, 0x73, 0x9c, 0x3f, 0x60, 0x41, 0xb0, 0x64, 0x43, 0x9c, 0xe1, 0x6c, 0x3e, 0xde}: "SystemBootManagerDxe",
		efi.GUID{0x0f, 0xbd, 0x07, 0x73, 0x7a, 0x8b, 0xa5, 0x4b, 0x9a, 0xf6, 0x39, 0x97, 0xd1, 0xe3, 0x27, 0x86}: "AmdNbioSmuV10Pei",
		efi.GUID{0x0f, 0xc2, 0x66, 0x23, 0x5a, 0xe1, 0xe3, 0x11, 0x8b, 0xf1, 0xe4, 0x11, 0x5b, 0x28, 0xbc, 0x50}: "HttpDxe",
		efi.GUID{0x0f, 0xcf, 0x19, 0x6f, 0x80, 0x72, 0xc2, 0x44, 0xb7, 0xa5, 0x0a, 0x57, 0x5c, 0x47, 0xe1, 0x6e}: "EcLabProductionModeDxe",
		efi.GUID{0x0f, 0xcf, 0xe9, 0x05, 0xe3, 0x4b, 0xf4, 0x87, 0x72, 0x65, 0xb7, 0x96, 0xa7, 0x69, 0x59, 0xc3}: "S5MaxPowerSavingsSmm",
		efi.GUID{0x0f, 0xd3, 0x5e, 0x6e, 0x52, 0xec, 0x36, 0x41, 0x8a, 0x41, 0x3f, 0x43, 0x24, 0x21, 0x8e, 0x41}: "DeviceIoOnPciRootBridgeIoThunk",
		efi.GUID{0x0f, 0xd8, 0xe9, 0x2a, 0xb2, 0x3f, 0x95, 0x40, 0xb7, 0xb1, 0xe9, 0x31, 0x57, 0xb9, 0x46, 0xb6}: "EfiHashAlgorithmSha1Guid",
		efi.GUID{0x0f, 0xdf, 0x52, 0x66, 0x0e, 0xe8, 0xa1, 0x4b, 0x8c, 0x3f, 0x2a, 0x4e, 0x5b, 0x56, 0x32, 0x4a}: "SioSmiWdtDispatcher",
		efi.GUID{0x0f, 0xdf, 0xa5, 0x9e, 0x5c, 0xa3, 0xc1, 0x48, 0xba, 0xc9, 0xf6, 0x34, 0x52, 0xb4, 0x7c, 0x3e}: "LenovoSystemCapsuleRt",
		efi.GUID{0x0f, 0xdf, 0xc9, 0x51, 0xb9, 0x21, 0x15, 0x10, 0x91, 0x51, 0x12, 0x87, 0x2f, 0x03, 0x2a, 0x51}: "HardwareHealthManagementPei",
		efi.GUID{0x0f, 0xdf, 0xc9, 0x5e, 0xb9, 0x9f, 0xd5, 0x4c, 0x9b, 0xae, 0x12, 0x87, 0x2f, 0x03, 0x2a, 0x6a}: "PeiIpmiUsb",
		efi.GUID{0x0f, 0xe4, 0x59, 0xe8, 0x24, 0xcc, 0xb7, 0x41, 0xb5, 0xa5, 0x68, 0x58, 0x22, 0xaa, 0xbc, 0xc6}: "UserApplicationBin",
		efi.GUID{0x0f, 0xe6, 0x90, 0x9e, 0x1e, 0xfd, 0x01, 0x4b, 0xba, 0x6e, 0x9f, 0xde, 0x5a, 0x02, 0xe6, 0x0b}: "DellConnectionMgr",
		efi.GUID{0x0f, 0xe9, 0x35, 0x46, 0x32, 0x24, 0x85, 0x43, 0x8b, 0x1f, 0x5f, 0xe1, 0xb3, 0xc9, 0x77, 0x47}: "SetupConfigUpdateDxeBigPineKey",
		efi.GUID{0x0f, 0xe9, 0xad, 0xb5, 0x14, 0xdc, 0xa7, 0x47, 0x80, 0x02, 0xe8, 0x72, 0x38, 0xaa, 0xe9, 0x30}: "LEMEfiNvmExpressPassThruProtocolHook",
		efi.GUID{0x0f, 0xf2, 0x5c, 0x5e, 0x3f, 0xb6, 0xe1, 0x11, 0x83, 0x5e, 0x38, 0x60, 0x77, 0xf1, 0x1e, 0x9d}: "I2cTouchPanelDxe",
		efi.GUID{0x0f, 0xf2, 0xb4, 0xba, 0x81, 0x09, 0x5f, 0x4b, 0xa0, 0x47, 0x6e, 0xf8, 0x3b, 0xee, 0xab, 0x3c}: "EhciPei",
		efi.GUID{0x0f, 0xf4, 0xf0, 0x23, 0x6d, 0x68, 0xe4, 0x45, 0xb2, 0x6e, 0x11, 0xf9, 0xf2, 0x65, 0xcf, 0x66}: "BatteryInfoDxe",
		efi.GUID{0x0f, 0xf4, 0xf0, 0x23, 0x6d, 0x68, 0xe4, 0x45, 0xb2, 0x8e, 0x11, 0xf9, 0xf2, 0x45, 0xcf, 0x62}: "MpmBatteryInfoDxe",
		efi.GUID{0x0f, 0xf7, 0x02, 0x6c, 0xbc, 0x9f, 0x44, 0x4a, 0xac, 0x19, 0xc6, 0x48, 0xa7, 0xaa, 0x55, 0x41}: "FjKbcEmiDxe",
		efi.GUID{0x0f, 0xfa, 0x58, 0x77, 0xab, 0x2c, 0x84, 0x46, 0x94, 0x9f, 0xc2, 0x05, 0x06, 0x33, 0x95, 0x39}: "DellProfileManager",
		efi.GUID{0x0f, 0xff, 0xaa, 0xd3, 0x22, 0xcb, 0x92, 0x47, 0x89, 0x6c, 0x80, 0x2c, 0x2e, 0x93, 0x83, 0xba}: "WifiManagerApp",
		efi.GUID{0x10, 0x00, 0x92, 0xfa, 0x85, 0x67, 0x41, 0x49, 0xb6, 0xec, 0x49, 0x8c, 0x57, 0x9f, 0x16, 0x0a}: "VirtioDeviceProtocolGuid",
		efi.GUID{0x10, 0x01, 0xa7, 0x29, 0x62, 0x77, 0x11, 0x42, 0xae, 0x88, 0xfa, 0xb1, 0x9b, 0x76, 0x65, 0xbe}: "MebxMenu",
		efi.GUID{0x10, 0x0b, 0xc1, 0x27, 0x4a, 0x11, 0x71, 0x4d, 0x8c, 0x58, 0xd6, 0x7e, 0xd0, 0xf2, 0x0d, 0x89}: "OemVGA",
		efi.GUID{0x10, 0x0e, 0x0e, 0xd3, 0x9b, 0x51, 0x39, 0x4e, 0xad, 0x47, 0xdc, 0x3c, 0xe2, 0x66, 0xa8, 0xae}: "FjGabiNvramMergeDxe",
		efi.GUID{0x10, 0x15, 0xb5, 0x7e, 0x9b, 0x72, 0x2e, 0x48, 0xaa, 0x28, 0xc9, 0xeb, 0x6a, 0x7f, 0xb8, 0x37}: "SioSxIntruderDxe",
		efi.GUID{0x10, 0x25, 0x75, 0xa8, 0x3e, 0xd8, 0x0a, 0x40, 0x85, 0xde, 0xfd, 0x15, 0x87, 0x88, 0x2a, 0xfe}: "DellLomConfig",
		efi.GUID{0x10, 0x29, 0x64, 0x1f, 0x7b, 0x3d, 0x27, 0x46, 0x8d, 0x18, 0xdc, 0x62, 0x67, 0x1e, 0x05, 0x54}: "BiosReservedMemoryPolicyPpiGuid",
		efi.GUID{0x10, 0x29, 0xbc, 0x8b, 0xe8, 0x04, 0x50, 0x44, 0xa6, 0xcd, 0x34, 0x9e, 0x5d, 0x4d, 0x76, 0x5b}: "DellRuntimeAcpiDxe",
		efi.GUID{0x10, 0x34, 0x36, 0xb6, 0x56, 0xfd, 0x85, 0x4d, 0xa9, 0xc4, 0xd7, 0x04, 0x1c, 0x0b, 0x51, 0xca}: "FjMfgSetPostPassedGpioDxe",
		efi.GUID{0x10, 0x34, 0xd1, 0x09, 0x18, 0x27, 0x3a, 0x46, 0x8b, 0x15, 0xda, 0x93, 0xc3, 0xca, 0x0a, 0x64}: "UsbCdcEcm",
		efi.GUID{0x10, 0x38, 0xb3, 0xcf, 0x87, 0x6e, 0x84, 0x42, 0xb2, 0x03, 0xa6, 0x6a, 0xbe, 0x07, 0xf6, 0xe8}: "EfiHeciProtocolGuid",
		efi.GUID{0x10, 0x41, 0xaf, 0x30, 0x8e, 0xa5, 0xf7, 0x4e, 0x8c, 0x75, 0xb7, 0x25, 0x93, 0x9b, 0x3b, 0x9f}: "AmdCpmDisplayFeatureSmm",
		efi.GUID{0x10, 0x42, 0x53, 0x2a, 0x80, 0x92, 0xd8, 0x41, 0xae, 0x79, 0xca, 0xda, 0x01, 0xa2, 0xb1, 0x27}: "EfiDriverHealthProtocolGuid",
		efi.GUID{0x10, 0x46, 0x60, 0xf3, 0x52, 0xdd, 0xed, 0x4b, 0x8f, 0x76, 0xab, 0xc9, 0x28, 0x4c, 0xd0, 0x40}: "UltrasoundHpdCheck",
		efi.GUID{0x10, 0x4d, 0x72, 0xfd, 0x1d, 0x6c, 0xeb, 0x4c, 0xac, 0x39, 0x69, 0x39, 0x00, 0x66, 0x9c, 0xe1}: "Supplicant",
		efi.GUID{0x10, 0x51, 0xf2, 0xcb, 0xff, 0x18, 0xe3, 0x4e, 0x97, 0x35, 0xe2, 0x47, 0x74, 0x36, 0xff, 0x3f}: "XnotePlatformInfoSmm",
		efi.GUID{0x10, 0x58, 0x60, 0x21, 0xb3, 0x54, 0x09, 0x41, 0x8a, 0xff, 0x3b, 0x3f, 0xbf, 0x4a, 0xf0, 0x40}: "DellPasswordPolicyDxeProtocol",
		efi.GUID{0x10, 0x59, 0x06, 0x33, 0x56, 0xfe, 0xab, 0x49, 0xb0, 0x3d, 0xed, 0x1a, 0xff, 0x65, 0xb5, 0x96}: "DeviceImageInterface",
		efi.GUID{0x10, 0x5e, 0xb3, 0x77, 0x21, 0xac, 0xfb, 0x4d, 0xb0, 0x94, 0xdd, 0xa8, 0x87, 0x8a, 0x65, 0x21}: "ASM1061Pei",
		efi.GUID{0x10, 0x60, 0x37, 0x8c, 0x00, 0x24, 0x7d, 0x4d, 0xb4, 0x7b, 0x9d, 0x85, 0x1d, 0xf3, 0xc9, 0xd1}: "PchMeUma",
		efi.GUID{0x10, 0x60, 0xce, 0x54, 0x6d, 0x2a, 0xaa, 0x42, 0xb1, 0xe2, 0xfd, 0x97, 0xde, 0x9c, 0x4d, 0xa8}: "AppleDebugSupportFireWireInit",
		efi.GUID{0x10, 0x6a, 0x6c, 0x85, 0xb8, 0xf3, 0x2e, 0x4c, 0xa2, 0x73, 0x78, 0x68, 0xc0, 0x9b, 0xe8, 0xea}: "MmcMediaDevice",
		efi.GUID{0x10, 0x6b, 0x86, 0x68, 0xda, 0x73, 0xea, 0x45, 0xa8, 0x08, 0x15, 0xa5, 0x7d, 0x94, 0x7f, 0x98}: "WatchdogRuntimeDxe",
		efi.GUID{0x10, 0x6e, 0x79, 0x94, 0xf6, 0x7c, 0x20, 0x4a, 0xa3, 0xa0, 0x4c, 0xf1, 0xa8, 0x34, 0x1a, 0x16}: "menu_dots",
		efi.GUID{0x10, 0x76, 0xb4, 0xd4, 0x1c, 0xbc, 0x0b, 0x48, 0xbd, 0x23, 0xcb, 0x03, 0x1b, 0x7a, 0xa0, 0xa2}: "BiosPowerOn",
		efi.GUID{0x10, 0x85, 0x00, 0x8e, 0xb1, 0x9b, 0x7d, 0x45, 0x9f, 0x70, 0x89, 0x7a, 0xba, 0x86, 0x5d, 0xb9}: "EfiLegacyBiosExtProtocolGuid",
		efi.GUID{0x10, 0x8d, 0x7e, 0xfa, 0x12, 0x13, 0x98, 0x4b, 0x9a, 0x3b, 0x3b, 0x5b, 0x13, 0xa2, 0x5d, 0xb0}: "PsmiHandlerBufferGuid",
		efi.GUID{0x10, 0x91, 0x81, 0x22, 0x6f, 0x7f, 0x52, 0x48, 0xb4, 0xbb, 0x13, 0xa7, 0x70, 0x14, 0x9b, 0x0c}: "FpgaFormSet",
		efi.GUID{0x10, 0x9d, 0x4b, 0xbf, 0xec, 0x13, 0xdd, 0x43, 0x88, 0x80, 0xe9, 0x0b, 0x71, 0x8f, 0x27, 0xde}: "EmbeddedDeviceGuid",
		efi.GUID{0x10, 0xa8, 0x7f, 0xac, 0xe5, 0x44, 0xa6, 0x4c, 0x9d, 0x17, 0x77, 0x8c, 0xc5, 0xb0, 0x34, 0xeb}: "AsrockAmdSetupDxeRv",
		efi.GUID{0x10, 0xb1, 0xcf, 0xfa, 0xfd, 0x7b, 0xfb, 0x4e, 0x87, 0x3e, 0x88, 0xb6, 0xb2, 0x3b, 0x97, 0xea}: "PhDefEfiVar",
		efi.GUID{0x10, 0xb8, 0x91, 0x4c, 0x8d, 0xa2, 0xbc, 0x4b, 0xbd, 0xf0, 0x30, 0xa9, 0xc6, 0xc7, 0xee, 0xc2}: "OemLOGO",
		efi.GUID{0x10, 0xbb, 0xcc, 0x6f, 0x6e, 0x6d, 0x6e, 0x6a, 0x9c, 0x2b, 0x2b, 0x62, 0x5f, 0xff, 0x85, 0x66}: "RtErrorLogging",
		efi.GUID{0x10, 0xc7, 0x59, 0xd7, 0xea, 0x49, 0x26, 0x4d, 0x9f, 0x7c, 0xde, 0x10, 0x64, 0x87, 0x6e, 0x2f}: "FpgaSocketHob",
		efi.GUID{0x10, 0xce, 0x4e, 0x4a, 0xeb, 0x61, 0xc4, 0x4f, 0x88, 0x39, 0xf7, 0xcf, 0xdd, 0x96, 0x20, 0x74}: "IccPei",
		efi.GUID{0x10, 0xd1, 0x37, 0x9e, 0xba, 0x80, 0x24, 0x4f, 0xb8, 0xfa, 0x2a, 0x1d, 0x25, 0x39, 0xe5, 0x13}: "EmulatedEepromPei",
		efi.GUID{0x10, 0xeb, 0x0a, 0x63, 0x06, 0x21, 0x34, 0x42, 0x9d, 0xb3, 0x83, 0x6a, 0x36, 0x63, 0xf5, 0x0d}: "BaseCacheAsRamLibNull",
		efi.GUID{0x10, 0xf8, 0x85, 0xd9, 0xed, 0x69, 0x58, 0x4e, 0xff, 0xff, 0xff, 0xff, 0x4e, 0xd8, 0xd2, 0xdc}: "XnoteSystemPolicyPei",
		efi.GUID{0x10, 0xfa, 0x30, 0xff, 0x1d, 0xee, 0x5d, 0x45, 0x97, 0x1f, 0x34, 0xb9, 0x7d, 0x20, 0x67, 0x9c}: "PlatformMemoryConfigurationPei",
		efi.GUID{0x11, 0x07, 0xfd, 0xf8, 0xc1, 0xca, 0x2f, 0x49, 0xaf, 0xc6, 0xaf, 0xf5, 0xda, 0x4d, 0x01, 0xb1}: "FpkConfigUpdateNeonCityEPRP",
		efi.GUID{0x11, 0x0b, 0x99, 0xa2, 0x5c, 0xf0, 0x82, 0x41, 0x97, 0x03, 0xbb, 0x02, 0x27, 0x5d, 0xb8, 0xf9}: "SmcNvdimmSmmProtocol",
		efi.GUID{0x11, 0x0c, 0x0e, 0x32, 0xfe, 0xb5, 0x20, 0x4c, 0xb8, 0xa8, 0x81, 0x5a, 0x20, 0x70, 0x0c, 0xef}: "AppleIpAgentDxe",
		efi.GUID{0x11, 0x0d, 0x1b, 0xda, 0xa7, 0xd1, 0xc4, 0x46, 0x9d, 0xc9, 0xf3, 0x71, 0x48, 0x75, 0xc6, 0xeb}: "VarCheckPolicyLibMmiHandler",
		efi.GUID{0x11, 0x12, 0x59, 0xe7, 0x96, 0x2a, 0xd8, 0x4f, 0xbb, 0x84, 0x08, 0x38, 0x77, 0x23, 0xda, 0x26}: "PlatformVTdInfoSamplePei",
		efi.GUID{0x11, 0x1b, 0xcd, 0x5f, 0x81, 0x29, 0xb8, 0x4e, 0x8e, 0x03, 0x4a, 0x0b, 0x54, 0x48, 0xdf, 0x5b}: "HpRemoteDiagnosticsDriverWmiSmm",
		efi.GUID{0x11, 0x27, 0x5f, 0x9a, 0x7f, 0xb9, 0x5e, 0x4d, 0xb1, 0x11, 0x26, 0x56, 0x52, 0xd4, 0x45, 0x87}: "WolPwrControlSmm",
		efi.GUID{0x11, 0x3a, 0xc6, 0x67, 0x9d, 0xf8, 0x00, 0x45, 0x82, 0x70, 0xd9, 0xdb, 0x25, 0x1e, 0xb2, 0xaf}: "Ps2KeyboardPei",
		efi.GUID{0x11, 0x40, 0x70, 0xeb, 0x02, 0x14, 0xd3, 0x11, 0x8e, 0x77, 0x00, 0xa0, 0xc9, 0x69, 0x72, 0x3b}: "EfiMtcGuid",
		efi.GUID{0x11, 0x44, 0x73, 0xc6, 0xda, 0x2d, 0x32, 0x46, 0xa5, 0x92, 0x92, 0x0f, 0x24, 0xd6, 0xed, 0x21}: "AmiAtaPassThruInitProtocolGuid",
		efi.GUID{0x11, 0x50, 0x70, 0xd3, 0x19, 0xbc, 0xf7, 0x4a, 0xbe, 0x16, 0xf6, 0x80, 0x30, 0x37, 0x8c, 0x15}: "EfiIntelFrameworkModulePkgTokenSpaceGuid",
		efi.GUID{0x11, 0x52, 0xfd, 0x28, 0x77, 0x37, 0x13, 0x4a, 0x9a, 0x2e, 0x66, 0xa7, 0x34, 0x1d, 0x15, 0xe4}: "FjClearsureDxe",
		efi.GUID{0x11, 0x53, 0x56, 0x17, 0x71, 0x4b, 0x40, 0x43, 0x88, 0xaa, 0xdc, 0x9f, 0x44, 0x22, 0xe5, 0x3a}: "SmmBiosGuardProtocol",
		efi.GUID{0x11, 0x66, 0xbb, 0x4c, 0x08, 0x36, 0x2b, 0x49, 0x92, 0xa7, 0xdd, 0x92, 0xfd, 0x6f, 0xe4, 0xfe}: "OEMBOARDPei",
		efi.GUID{0x11, 0x6b, 0xd4, 0x8d, 0x03, 0x04, 0x4c, 0x4b, 0xb3, 0x72, 0x70, 0x41, 0xcb, 0x15, 0x18, 0x34}: "DellFlashUpdate2Pei",
		efi.GUID{0x11, 0x71, 0x37, 0x1c, 0x7e, 0xe0, 0x33, 0x4b, 0x9b, 0x5b, 0x30, 0x81, 0x7d, 0x1f, 0x1b, 0xe3}: "DellIntrusionDetectSmm",
		efi.GUID{0x11, 0x76, 0xb0, 0xd9, 0xd7, 0x4e, 0xbf, 0x38, 0xb3, 0x04, 0x42, 0x11, 0x6e, 0x7c, 0x96, 0x6a}: "OSRecovery",
		efi.GUID{0x11, 0x77, 0x52, 0xe0, 0xf7, 0x50, 0x72, 0x46, 0xb8, 0x68, 0x6a, 0x44, 0x7e, 0xf5, 0x45, 0x13}: "PatchDevice",
		efi.GUID{0x11, 0x7f, 0xa4, 0x8d, 0x15, 0xaa, 0xc8, 0x48, 0xb0, 0xa7, 0x23, 0xee, 0x48, 0x52, 0x08, 0x6b}: "A01WMISmmHandler",
		efi.GUID{0x11, 0x82, 0xc5, 0xfe, 0x25, 0x60, 0xb7, 0x45, 0x9d, 0xcf, 0xdb, 0x21, 0xa4, 0x33, 0xbb, 0x78}: "MmcSetPowerOffTypePei",
		efi.GUID{0x11, 0x84, 0x26, 0xf9, 0xac, 0x99, 0x1f, 0x4f, 0xb2, 0xd7, 0x58, 0x04, 0xed, 0x5b, 0x8e, 0x1e}: "OemLogoScale",
		efi.GUID{0x11, 0x84, 0x9c, 0x3c, 0xd3, 0xa0, 0x00, 0x4a, 0x97, 0x9c, 0xf3, 0xa9, 0xff, 0x55, 0x6c, 0xf7}: "AsusBiosPeiCrashFree",
		efi.GUID{0x11, 0x89, 0xea, 0x09, 0x0d, 0xbe, 0x30, 0x42, 0xa0, 0x03, 0xed, 0xc6, 0x93, 0xb4, 0x8e, 0x11}: "VlvPeiInitPpiGuid",
		efi.GUID{0x11, 0x8f, 0x16, 0xc9, 0x60, 0x0c, 0x8c, 0x4a, 0xa4, 0x1f, 0x1b, 0x22, 0x89, 0x31, 0x5f, 0x4e}: "EcRotEnterRecoveryPei",
		efi.GUID{0x11, 0xa6, 0xe8, 0x58, 0x19, 0xab, 0xdc, 0x47, 0x98, 0x50, 0x39, 0x85, 0xde, 0x8d, 0xf1, 0xfd}: "PsmiMapHobGuid",
		efi.GUID{0x11, 0xa8, 0x0e, 0xee, 0xd9, 0xfb, 0x77, 0x47, 0xb9, 0x5a, 0xba, 0x4f, 0x71, 0x10, 0x1f, 0x74}: "PeiHeciPpiGuid",
		efi.GUID{0x11, 0xae, 0x4e, 0xb7, 0xee, 0xaa, 0x6a, 0x47, 0xab, 0x0f, 0x35, 0x10, 0x63, 0xd6, 0x78, 0x25}: "MeUpdate",
		efi.GUID{0x11, 0xb3, 0x23, 0xba, 0x3d, 0x34, 0xe6, 0x11, 0x91, 0x85, 0x58, 0x20, 0xb1, 0xd6, 0x52, 0x99}: "EfiHttpBootCallbackProtocolGuid",
		efi.GUID{0x11, 0xc3, 0x6a, 0xaf, 0xc3, 0x84, 0xd2, 0x11, 0x8e, 0x3c, 0x00, 0xa0, 0xc9, 0x69, 0x72, 0x3b}: "EfiDeviceIoProtocolGuid",
		efi.GUID{0x11, 0xc8, 0x50, 0xb7, 0xc2, 0x02, 0xed, 0x4b, 0x99, 0xb2, 0x8c, 0x69, 0x60, 0x08, 0x0d, 0x45}: "IrqBoardInfoOverride",
		efi.GUID{0x11, 0xcf, 0x41, 0xb9, 0x48, 0xe6, 0x1c, 0x40, 0x92, 0xa1, 0x34, 0x2a, 0x70, 0xc6, 0xb7, 0x42}: "DellSmbVersionManifest",
		efi.GUID{0x11, 0xd1, 0x9f, 0x19, 0x85, 0x07, 0x32, 0x41, 0xa9, 0xb3, 0x1f, 0x66, 0x57, 0x3f, 0x00, 0x60}: "GenericComponentsSmm",
		efi.GUID{0x11, 0xea, 0x3a, 0x6a, 0xc2, 0x2c, 0x66, 0x4b, 0xb4, 0xd3, 0xa8, 0x77, 0x9d, 0x60, 0x87, 0xc1}: "SystemSecureBiosPei",
		efi.GUID{0x11, 0xf6, 0x44, 0x19, 0xcc, 0xfb, 0xbc, 0x40, 0x88, 0xc8, 0x85, 0x0d, 0x0f, 0xe5, 0x14, 0xe3}: "WCN6855",
		efi.GUID{0x11, 0xf7, 0x9b, 0x6d, 0x0d, 0xa9, 0xf9, 0x42, 0xa3, 0xfb, 0xdd, 0x08, 0xb6, 0xe8, 0x90, 0x37}: "SLP20EncryptedOEMPublicKeyVariableGuid",
		efi.GUID{0x11, 0xfd, 0xa7, 0x3a, 0x5f, 0xcc, 0xec, 0x11, 0x95, 0xe0, 0xe0, 0x2b, 0xe9, 0x42, 0x45, 0x81}: "DellLegacyBeep",
		efi.GUID{0x12, 0x02, 0x36, 0x54, 0x31, 0xbd, 0x3b, 0x40, 0xa9, 0x83, 0xc5, 0xe4, 0x72, 0x04, 0x9e, 0x40}: "OneTimeFlagsPeiInit",
		efi.GUID{0x12, 0x02, 0xfc, 0xab, 0x44, 0x93, 0x9c, 0x43, 0x86, 0x53, 0x69, 0x92, 0x34, 0xcf, 0xad, 0x03}: "AmdCpmWwanInitDxe",
		efi.GUID{0x12, 0x09, 0x8c, 0xd1, 0x25, 0x68, 0x8f, 0x4e, 0x8d, 0x5a, 0xaf, 0x7e, 0xed, 0xb2, 0xe5, 0xbc}: "LpssConfigGuid",
		efi.GUID{0x12, 0x0a, 0x9a, 0x7b, 0xf8, 0x42, 0x4c, 0x4d, 0x82, 0xb6, 0x32, 0xf0, 0xca, 0x19, 0x53, 0xf4}: "AmiBoardInfoFileGuid",
		efi.GUID{0x12, 0x0d, 0x2c, 0xcb, 0x6a, 0x8e, 0x12, 0x4b, 0x94, 0xf4, 0x1b, 0xc4, 0x9e, 0xc4, 0x60, 0xb1}: "AmiHstiPkgTokenSpaceGuid",
		efi.GUID{0x12, 0x0e, 0x24, 0x2f, 0x4d, 0xe1, 0x5c, 0x47, 0x83, 0xb0, 0xef, 0xff, 0x22, 0xd7, 0x7b, 0xe7}: "EfiKmsFormatSha512512Guid",
		efi.GUID{0x12, 0x0f, 0x96, 0xdf, 0xce, 0x05, 0x18, 0x4e, 0xb9, 0x26, 0x00, 0xaf, 0xc9, 0xf3, 0x1c, 0x7e}: "PeiSioEmi",
		efi.GUID{0x12, 0x15, 0xf7, 0xd0, 0x32, 0x9e, 0xc9, 0x4c, 0xa5, 0xa3, 0xad, 0x67, 0x9a, 0x06, 0x67, 0xb8}: "FlashProtectionConfigGuid",
		efi.GUID{0x12, 0x19, 0x4d, 0xca, 0x15, 0xc4, 0x86, 0x46, 0x86, 0x15, 0xa0, 0x82, 0x3d, 0x8c, 0x4f, 0x27}: "Cf9ResetSmm",
		efi.GUID{0x12, 0x1c, 0x44, 0x48, 0xea, 0x74, 0xbd, 0x4f, 0xbd, 0x1f, 0x19, 0x9c, 0xf3, 0x9c, 0x5b, 0xe4}: "Kb902xFlashSmm",
		efi.GUID{0x12, 0x29, 0x04, 0x99, 0x2a, 0x12, 0xd4, 0x11, 0xbd, 0x0d, 0x00, 0x80, 0xc7, 0x3c, 0x88, 0x81}: "EfiWinNtMemory",
		efi.GUID{0x12, 0x2b, 0x6c, 0x35, 0x24, 0x31, 0x51, 0x44, 0xbf, 0x66, 0xb5, 0x02, 0xd8, 0x8a, 0x00, 0x74}: "XhciDxe",
		efi.GUID{0x12, 0x30, 0x02, 0xfd, 0xf4, 0x19, 0x35, 0x42, 0xad, 0xcf, 0xd9, 0x24, 0xdb, 0xe2, 0x46, 0xfe}: "StaticSkuDataDxeLightningRidgeEXECB1",
		efi.GUID{0x12, 0x32, 0x12, 0x7b, 0xae, 0x02, 0x43, 0x4c, 0x82, 0x0e, 0x90, 0xc0, 0x7e, 0x08, 0x52, 0x42}: "FjGpioGeminilakePei",
		efi.GUID{0x12, 0x32, 0x46, 0xbd, 0x1b, 0x70, 0x34, 0x4e, 0xbe, 0xc1, 0xf3, 0xfb, 0x76, 0x02, 0xf8, 0xaa}: "IsaHostControllerDxe",
		efi.GUID{0x12, 0x37, 0xf5, 0x73, 0x64, 0x2a, 0x86, 0x4b, 0x96, 0x1d, 0xc2, 0x5b, 0x63, 0xdf, 0x19, 0x8c}: "AmdNbioIOMMURVDxe",
		efi.GUID{0x12, 0x39, 0x93, 0xcb, 0x8f, 0xdf, 0x05, 0x43, 0xb1, 0xf9, 0x7b, 0x44, 0xfa, 0x11, 0x39, 0x5c}: "AcpiPlatform",
		efi.GUID{0x12, 0x39, 0xbb, 0xbc, 0xfa, 0x29, 0x25, 0x4b, 0xb6, 0x19, 0x3c, 0x0d, 0x73, 0x9f, 0xef, 0x51}: "DellHotKeyHandlerDxe",
		efi.GUID{0x12, 0x48, 0x16, 0x36, 0x23, 0xa0, 0xe5, 0x44, 0xbd, 0x85, 0x05, 0xbf, 0x3c, 0x77, 0x00, 0xaa}: "EfiFindFvPpiGuid",
		efi.GUID{0x12, 0x4d, 0x73, 0xc0, 0x27, 0x79, 0x2b, 0x43, 0x98, 0x6b, 0xa7, 0xe3, 0xa3, 0x5b, 0xa0, 0x05}: "LightPciBusPciBusDxe",
		efi.GUID{0x12, 0x52, 0xe6, 0x70, 0xad, 0xf3, 0x5f, 0x49, 0xb3, 0xa1, 0x7a, 0x63, 0x54, 0x2e, 0xd7, 0xd5}: "DellTcgPei2",
		efi.GUID{0x12, 0x57, 0x2e, 0x3b, 0x64, 0x7f, 0x6c, 0x4e, 0x9d, 0x18, 0x63, 0xa6, 0x86, 0x7c, 0xc7, 0x44}: "AmdSocFp7r2RmbPei",
		efi.GUID{0x12, 0x63, 0x20, 0x3c, 0xb6, 0xb8, 0x6f, 0x49, 0xbc, 0xfa, 0x2f, 0x64, 0x5e, 0xf4, 0xac, 0xde}: "TransparentUnlockWmiSmm",
		efi.GUID{0x12, 0x68, 0xa9, 0x99, 0x30, 0x47, 0x90, 0x42, 0x8b, 0xfe, 0x7b, 0x4e, 0x51, 0x4f, 0xf9, 0x3b}: "EfiGlobalVariableControl",
		efi.GUID{0x12, 0x6d, 0x07, 0xae, 0x6e, 0xf6, 0xd5, 0x4d, 0x88, 0x25, 0x86, 0xc8, 0x20, 0xa2, 0x1c, 0xaf}: "DualBiosSmi",
		efi.GUID{0x12, 0x6d, 0x84, 0xba, 0xac, 0x59, 0x18, 0x4e, 0x88, 0xff, 0xe0, 0x46, 0x87, 0x55, 0x24, 0x16}: "SmiCallback",
		efi.GUID{0x12, 0x79, 0xa7, 0x2e, 0xa8, 0x80, 0x47, 0x49, 0xbe, 0x69, 0xcd, 0xd0, 0x0a, 0xfb, 0xe5, 0x56}: "EdkiiNonDiscoverableUfsDeviceGuid",
		efi.GUID{0x12, 0x7b, 0x64, 0x0f, 0xa2, 0x5f, 0x5e, 0x4b, 0x9d, 0x61, 0x2a, 0xb3, 0xc5, 0x1f, 0x22, 0x4e}: "BctBaseSmmSSP",
		efi.GUID{0x12, 0x83, 0xc7, 0x52, 0xdc, 0x8e, 0x33, 0x42, 0x98, 0xf2, 0x1a, 0x1a, 0xa5, 0xe3, 0x88, 0xa5}: "EfiNvmExpressPassThruProtocolGuid",
		efi.GUID{0x12, 0x84, 0x47, 0xff, 0xc3, 0x38, 0x70, 0x47, 0x85, 0xf6, 0x5d, 0x07, 0x6c, 0x62, 0x12, 0x5f}: "TargetDiskModeUI",
		efi.GUID{0x12, 0x86, 0x06, 0xc6, 0xe0, 0xb6, 0xa3, 0x48, 0xbb, 0x92, 0x60, 0xe4, 0xa4, 0xf8, 0x9e, 0xdf}: "UefiPciSegmentLibPciRootBridgeIo",
		efi.GUID{0x12, 0x88, 0x04, 0x9f, 0x46, 0xa5, 0x85, 0x4c, 0xa5, 0xcf, 0xa0, 0x78, 0x54, 0x23, 0x70, 0x5d}: "SystemConfigUpdate",
		efi.GUID{0x12, 0x8d, 0x2b, 0xb4, 0xcb, 0x2a, 0x9a, 0x49, 0xa9, 0x20, 0xdd, 0x5b, 0xe6, 0xcf, 0x09, 0xb1}: "WdtProtocol",
		efi.GUID{0x12, 0x9a, 0x5d, 0x70, 0x81, 0x62, 0x05, 0x4b, 0xbb, 0x64, 0xc9, 0xfe, 0x38, 0x64, 0x9c, 0xdf}: "SetupMenuDxe",
		efi.GUID{0x12, 0x9a, 0xa6, 0xc1, 0x53, 0x86, 0xde, 0x4f, 0xa2, 0x15, 0x48, 0xfc, 0xd9, 0x52, 0x88, 0xc3}: "PlatformSetupDxe",
		efi.GUID{0x12, 0x9b, 0xa7, 0x0f, 0x9a, 0x71, 0xec, 0x41, 0x8c, 0x57, 0x7c, 0x24, 0xf4, 0x77, 0x11, 0x62}: "VerifyHpRomSignature",
		efi.GUID{0x12, 0x9d, 0xba, 0x9c, 0x29, 0xa0, 0x66, 0x43, 0xab, 0x1e, 0x17, 0x2b, 0x81, 0x91, 0x47, 0x57}: "OntarioGenericVBios",
		efi.GUID{0x12, 0xa5, 0x6c, 0x82, 0x10, 0xcf, 0xc9, 0x4a, 0xb1, 0x87, 0xbe, 0x01, 0x49, 0x66, 0x31, 0xbd}: "EfiCertSha1Guid",
		efi.GUID{0x12, 0xa5, 0xe9, 0x24, 0x25, 0x3a, 0xba, 0x4c, 0xa0, 0xae, 0x67, 0xc0, 0x53, 0xbd, 0xf3, 0xb6}: "DxeVideoTextOut",
		efi.GUID{0x12, 0xb2, 0x77, 0x89, 0x43, 0x0a, 0x48, 0x40, 0x99, 0x3b, 0xb3, 0x9a, 0xc7, 0xb0, 0xfe, 0x21}: "gear9",
		efi.GUID{0x12, 0xbd, 0xc2, 0x3b, 0x2e, 0xad, 0xd5, 0x11, 0x87, 0xdd, 0x00, 0x06, 0x29, 0x45, 0xc3, 0xb9}: "CpuStatusCodeDataTypeExceptionHandlerGuid",
		efi.GUID{0x12, 0xc0, 0xae, 0xa3, 0x26, 0x9a, 0xa5, 0x4a, 0x98, 0x6c, 0x00, 0x44, 0x23, 0xe4, 0x39, 0x75}: "SnapshotLite",
		efi.GUID{0x12, 0xc0, 0xeb, 0x63, 0x65, 0x0d, 0x56, 0x4d, 0x85, 0xe7, 0xf5, 0xa7, 0xf4, 0x02, 0x27, 0x30}: "KEMhLpcDecodeDxe",
		efi.GUID{0x12, 0xc3, 0xec, 0xee, 0x36, 0xff, 0x21, 0x4e, 0x9c, 0x5f, 0x0b, 0x20, 0x8c, 0xdc, 0x02, 0xfa}: "FjDTPMAutoConfigDriver",
		efi.GUID{0x12, 0xc7, 0x8d, 0x15, 0x5a, 0xf1, 0xdc, 0x44, 0x93, 0xbb, 0x16, 0x75, 0x04, 0x5b, 0xe0, 0x66}: "HashLibBaseCryptoRouterDxe",
		efi.GUID{0x12, 0xcb, 0x1c, 0xc1, 0x7a, 0xc1, 0x66, 0x42, 0xb4, 0x7d, 0x18, 0xfd, 0x10, 0x18, 0x11, 0xea}: "HdpBackupToNvram",
		efi.GUID{0x12, 0xcd, 0x1e, 0xb7, 0x1e, 0xe0, 0x0b, 0x44, 0xaa, 0x52, 0x4d, 0x6e, 0x59, 0xd4, 0x5b, 0x3c}: "DellSecurityConfig",
		efi.GUID{0x12, 0xd6, 0x2f, 0x78, 0xf3, 0x46, 0xa2, 0x47, 0x83, 0xd9, 0x8f, 0xdb, 0x86, 0xe6, 0xfe, 0xd1}: "FjGabiMiscAbstractionSmm",
		efi.GUID{0x12, 0xd6, 0xa0, 0x2b, 0xad, 0xc3, 0x49, 0x42, 0x91, 0x5d, 0xaa, 0x0e, 0x87, 0x09, 0x48, 0x5f}: "SdioDriver",
		efi.GUID{0x12, 0xe5, 0x22, 0x30, 0x4a, 0xb9, 0x12, 0x4f, 0x80, 0x6d, 0x7e, 0xf1, 0x17, 0x78, 0x99, 0xd8}: "PciHotPlug",
		efi.GUID{0x12, 0xee, 0xda, 0x27, 0x8e, 0x48, 0x98, 0x4e, 0xad, 0xcf, 0x38, 0xad, 0xc1, 0x0a, 0x6b, 0x68}: "H19ServiceBodySmm",
		efi.GUID{0x12, 0xf1, 0xc4, 0x67, 0x85, 0x33, 0x55, 0x4e, 0x9c, 0x5b, 0xc0, 0x5b, 0x71, 0x7c, 0x42, 0x28}: "EfiSmmSwapAddressRangeProtocolGuid",
		efi.GUID{0x12, 0xf9, 0x03, 0x07, 0x8d, 0xbf, 0x2a, 0x4e, 0xbe, 0x07, 0xab, 0x27, 0x25, 0x25, 0xc5, 0x92}: "EfiSmmPeiMmramMemoryReserve",
		efi.GUID{0x12, 0xf9, 0xa4, 0x81, 0x2f, 0xe7, 0xed, 0x44, 0x89, 0x31, 0x16, 0xa9, 0xfe, 0x96, 0x50, 0xe0}: "KbcEmulDxe",
		efi.GUID{0x13, 0x03, 0xa3, 0x58, 0xd7, 0x70, 0x01, 0x42, 0x82, 0x12, 0x99, 0x57, 0x65, 0xb3, 0x52, 0x7f}: "DriveOptionSwitch",
		efi.GUID{0x13, 0x0b, 0xa5, 0x07, 0x39, 0x75, 0xcb, 0x41, 0xb9, 0x24, 0x9e, 0x72, 0xb8, 0x70, 0xc6, 0xd3}: "UsbVhcDxe",
		efi.GUID{0x13, 0x10, 0x92, 0x4f, 0x71, 0x4f, 0x6c, 0x4c, 0xbc, 0xf8, 0x41, 0x9b, 0x2b, 0x80, 0x19, 0x32}: "SetupBrowser",
		efi.GUID{0x13, 0x11, 0x06, 0x6a, 0x54, 0xfe, 0x07, 0x4a, 0xa2, 0x8e, 0x0a, 0x69, 0x35, 0x9e, 0xb0, 0x69}: "SgTpvACPI",
		efi.GUID{0x13, 0x17, 0x6d, 0x16, 0xa0, 0x23, 0x6a, 0x4f, 0x98, 0x21, 0xac, 0xd9, 0x4f, 0x77, 0xbd, 0xe3}: "SbSocBixbyPei",
		efi.GUID{0x13, 0x18, 0x95, 0xb1, 0xfa, 0x0c, 0x8e, 0x41, 0xb3, 0x12, 0x33, 0x36, 0x8d, 0x59, 0x02, 0xeb}: "SystemPwSmm",
		efi.GUID{0x13, 0x19, 0xd5, 0x48, 0x40, 0xf3, 0x98, 0x47, 0x83, 0xd7, 0x5c, 0xab, 0x3d, 0x5c, 0x6d, 0xa7}: "AppleEffaceableBCENOR",
		efi.GUID{0x13, 0x1e, 0x27, 0x51, 0xe3, 0x7d, 0xaf, 0x43, 0x8b, 0xc2, 0x71, 0xad, 0x3b, 0x82, 0x43, 0x25}: "ShellMapGuid",
		efi.GUID{0x13, 0x28, 0xcf, 0x3f, 0x38, 0xf1, 0x1c, 0x41, 0xbf, 0xc4, 0xdb, 0xe5, 0xb9, 0x49, 0x98, 0x22}: "ODMEMUSBLAN",
		efi.GUID{0x13, 0x42, 0x23, 0x72, 0xd7, 0x0f, 0xa1, 0x48, 0xa5, 0x9f, 0xb4, 0x1b, 0xc1, 0x07, 0xfb, 0xcd}: "ACPIOSFRVariableGuid",
		efi.GUID{0x13, 0x52, 0x24, 0x7c, 0x5e, 0x34, 0xef, 0x44, 0x9f, 0xd3, 0x7b, 0x6d, 0xa9, 0x2a, 0xa4, 0x99}: "UsbPortDisableOverrideDxe",
		efi.GUID{0x13, 0x5d, 0xa9, 0x27, 0xfb, 0x15, 0x2e, 0x4a, 0x91, 0xe2, 0xc7, 0x84, 0xbf, 0x0d, 0x20, 0xd3}: "PersistenceConfigDxe",
		efi.GUID{0x13, 0x60, 0xa0, 0x66, 0xbc, 0xae, 0x1f, 0x4a, 0xa0, 0x1a, 0xaa, 0x3a, 0x74, 0xf9, 0x88, 0x36}: "HeciAccessSmm",
		efi.GUID{0x13, 0x67, 0x8e, 0x33, 0x95, 0x02, 0x05, 0x4c, 0xa0, 0xbb, 0xd9, 0x45, 0xa4, 0x59, 0x5f, 0x11}: "CbsBaseDxeSSP",
		efi.GUID{0x13, 0x75, 0x23, 0xb9, 0x44, 0x6c, 0x11, 0x44, 0xa9, 0x90, 0x21, 0xe5, 0x56, 0xe0, 0x5a, 0xde}: "EfiKmsFormatGeneric3072Guid",
		efi.GUID{0x13, 0x7e, 0x27, 0xaf, 0x21, 0x3f, 0xb2, 0x40, 0x94, 0x52, 0x43, 0x50, 0x3b, 0xad, 0x06, 0x70}: "BixbyPei",
		efi.GUID{0x13, 0x86, 0x7e, 0xdc, 0xbb, 0xc4, 0xb0, 0x4d, 0x84, 0x62, 0x13, 0x51, 0x13, 0x57, 0xab, 0xe2}: "EfiKmsFormatAesxts256Guid",
		efi.GUID{0x13, 0x86, 0xf4, 0x57, 0x0a, 0x30, 0x01, 0x41, 0xa7, 0x6d, 0x4f, 0x73, 0xc5, 0x33, 0xb5, 0xb8}: "PriorBootDxe",
		efi.GUID{0x13, 0x87, 0x14, 0x44, 0x38, 0x61, 0x90, 0x48, 0xa1, 0x5b, 0x5f, 0xf6, 0x0c, 0x03, 0xf8, 0x7b}: "EcSureStartRAPDataTransferSmm",
		efi.GUID{0x13, 0x87, 0x40, 0x2d, 0x23, 0x40, 0x24, 0x43, 0xb8, 0xea, 0x53, 0xc0, 0x2a, 0x83, 0xd9, 0x41}: "PeCoffExtraActionLibSmm",
		efi.GUID{0x13, 0x9b, 0xed, 0xe6, 0xaf, 0x31, 0x92, 0x4c, 0xa5, 0x61, 0xd4, 0x7b, 0x2f, 0xa9, 0x94, 0xf7}: "FastBootHandlerDxe",
		efi.GUID{0x13, 0xa4, 0x88, 0xd0, 0x70, 0x0a, 0x17, 0x42, 0xba, 0x55, 0x9a, 0x3c, 0xb6, 0x5c, 0x41, 0xb3}: "ExitPmAuthProtocolGuid",
		efi.GUID{0x13, 0xa4, 0xf6, 0x55, 0x0f, 0x28, 0xe3, 0x41, 0x93, 0x94, 0x65, 0x80, 0xf2, 0x9d, 0xd7, 0xd0}: "DellSmmBbsmanagerLegacy",
		efi.GUID{0x13, 0xad, 0x1c, 0x8c, 0x7d, 0x16, 0x6f, 0x48, 0x8b, 0x20, 0x12, 0xff, 0x6d, 0x13, 0x05, 0xcc}: "FjPowerButtonDxe",
		efi.GUID{0x13, 0xaf, 0x77, 0xa4, 0x7d, 0x87, 0x60, 0x40, 0xba, 0xa1, 0x25, 0xd1, 0xbe, 0xa0, 0x8a, 0xd3}: "EfiKmsFormatRsasha2562048Guid",
		efi.GUID{0x13, 0xb3, 0x94, 0xe8, 0xca, 0x54, 0xb2, 0x4b, 0x8c, 0xdd, 0x85, 0x1e, 0x8a, 0xc9, 0x02, 0x7c}: "AmiDebugportHob",
		efi.GUID{0x13, 0xb6, 0x04, 0x84, 0x35, 0xea, 0x6f, 0x46, 0xbc, 0x7b, 0x9f, 0x51, 0xc9, 0x65, 0x19, 0x8e}: "AsusBackDoorPW",
		efi.GUID{0x13, 0xba, 0x18, 0x3d, 0xb1, 0xd9, 0xd4, 0x4d, 0xb9, 0x16, 0xd3, 0x07, 0x96, 0x53, 0x9e, 0xd8}: "EdkiiUfsHcPlatformProtocol",
		efi.GUID{0x13, 0xbc, 0xfe, 0x53, 0x34, 0xc5, 0x3e, 0x48, 0x8d, 0xa0, 0x96, 0x8e, 0x6f, 0xfd, 0x18, 0xd0}: "SecureBIOCameraSunplus",
		efi.GUID{0x13, 0xbf, 0x7c, 0x34, 0x36, 0x9c, 0x36, 0x4e, 0x91, 0xf9, 0x5b, 0xc7, 0x6e, 0x50, 0x42, 0xd1}: "MacAddressPassThrough",
		efi.GUID{0x13, 0xd0, 0x61, 0x4c, 0xa5, 0xec, 0x85, 0x47, 0x96, 0x25, 0xb2, 0x67, 0xa0, 0x0e, 0x77, 0x21}: "LenovoTrustedDeviceSetupUIDxe",
		efi.GUID{0x13, 0xd0, 0xf5, 0x2b, 0x75, 0x4e, 0xfc, 0x45, 0xac, 0xb4, 0x92, 0x47, 0x14, 0x5c, 0x17, 0x43}: "GigUndiDxe",
		efi.GUID{0x13, 0xe2, 0x14, 0x82, 0x0c, 0x18, 0x22, 0x48, 0xa2, 0x36, 0xcd, 0xca, 0x43, 0xf4, 0x3c, 0x88}: "CbsSetupSmmMdn",
		efi.GUID{0x13, 0xec, 0xa8, 0x5c, 0xde, 0x18, 0xe6, 0x48, 0xb0, 0x37, 0x67, 0xa2, 0x77, 0x2f, 0x3e, 0xbb}: "Tcg2Pei_",
		efi.GUID{0x14, 0x00, 0xf1, 0x2d, 0x21, 0xcf, 0x80, 0x42, 0x8c, 0x3f, 0xe5, 0x39, 0xb8, 0xee, 0x51, 0x50}: "PpmPolicyInitDxe",
		efi.GUID{0x14, 0x07, 0x15, 0xed, 0x30, 0xdf, 0x7d, 0x40, 0xb2, 0x4a, 0x4b, 0x74, 0x2f, 0xd5, 0xce, 0xa2}: "DuetConsoleOutConfigGuid",
		efi.GUID{0x14, 0x0e, 0x45, 0x49, 0xa1, 0x2b, 0xe9, 0x40, 0x97, 0x55, 0x6f, 0xe3, 0x27, 0xf8, 0xe0, 0x22}: "DeviceChangeDxe",
		efi.GUID{0x14, 0x11, 0xbc, 0xa5, 0x64, 0x6f, 0xde, 0x4e, 0xb8, 0x63, 0x3e, 0x83, 0xed, 0x7c, 0x83, 0xb1}: "EfiPlatformMemoryErrorSectionGuid",
		efi.GUID{0x14, 0x13, 0xb6, 0x7b, 0xb5, 0x11, 0x33, 0x48, 0xbc, 0xad, 0xb1, 0x60, 0x1c, 0xa0, 0x88, 0xc9}: "SmbiosType0",
		efi.GUID{0x14, 0x20, 0xff, 0x4f, 0x86, 0x20, 0xe6, 0x4e, 0x9b, 0x58, 0x88, 0x6d, 0x19, 0x67, 0x86, 0x1c}: "SecPeiDxeTimerLibUefiCpu",
		efi.GUID{0x14, 0x23, 0xe1, 0x1c, 0xbc, 0xaf, 0xf0, 0x11, 0x8a, 0x3e, 0xab, 0x44, 0xb8, 0xee, 0x31, 0x20}: "PpmPolicyInitDxe",
		efi.GUID{0x14, 0x31, 0x56, 0x8a, 0xf2, 0x70, 0xdc, 0x4a, 0x9a, 0x47, 0x19, 0x42, 0x4d, 0xfb, 0xe8, 0x2c}: "CrbPciePei",
		efi.GUID{0x14, 0x34, 0x83, 0x82, 0xf4, 0xc8, 0x62, 0x4b, 0xab, 0x6a, 0xe4, 0xd5, 0xda, 0xab, 0x13, 0x0f}: "HwmInitDxe",
		efi.GUID{0x14, 0x36, 0xeb, 0xc4, 0x86, 0x49, 0xb9, 0x42, 0x8c, 0x0d, 0x9f, 0xe1, 0x18, 0x27, 0x89, 0x08}: "CrystalRidge",
		efi.GUID{0x14, 0x37, 0x81, 0x94, 0x0a, 0xe1, 0x98, 0x47, 0x99, 0x09, 0x8c, 0x90, 0x4f, 0x66, 0xb4, 0xd9}: "NvmExpressPei",
		efi.GUID{0x14, 0x37, 0xda, 0xdb, 0xbf, 0x78, 0xff, 0x43, 0xb3, 0x0b, 0x4b, 0xd3, 0xdb, 0xc0, 0x1b, 0x54}: "PsmiMotBufferGuid",
		efi.GUID{0x14, 0x3d, 0xed, 0xf2, 0x85, 0x89, 0xdb, 0x11, 0xb0, 0x57, 0x00, 0x40, 0xd0, 0x2b, 0x18, 0x35}: "PeiUnixAutoscanPpi",
		efi.GUID{0x14, 0x42, 0x92, 0xaa, 0xcb, 0xdf, 0xee, 0x4b, 0xaa, 0x33, 0xfa, 0xe9, 0x72, 0x9a, 0xf0, 0x00}: "A01ODMSmmServiceDriver",
		efi.GUID{0x14, 0x50, 0x6e, 0xb7, 0x63, 0xeb, 0xeb, 0x47, 0x89, 0x15, 0x68, 0x6f, 0xcc, 0x38, 0x20, 0xb9}: "AmdNbioBaseCZPei",
		efi.GUID{0x14, 0x51, 0xe7, 0x7c, 0x72, 0x82, 0xaf, 0x45, 0xb5, 0x36, 0x76, 0x1b, 0xd3, 0x88, 0x52, 0xce}: "Slp21PubKey",
		efi.GUID{0x14, 0x5b, 0xc0, 0x52, 0x98, 0x0b, 0x6c, 0x49, 0xbc, 0x3b, 0x04, 0xb5, 0x02, 0x11, 0xd6, 0x80}: "PeiCore",
		efi.GUID{0x14, 0x61, 0x18, 0x14, 0x90, 0xb9, 0x34, 0x47, 0x89, 0x8e, 0x5f, 0x86, 0xfa, 0xe4, 0x97, 0x84}: "DellHwmIoDxe",
		efi.GUID{0x14, 0x65, 0x4b, 0x29, 0xcb, 0xcf, 0xf4, 0x4c, 0x88, 0x51, 0x3f, 0x35, 0x33, 0x0e, 0xae, 0x60}: "RmtcPEI",
		efi.GUID{0x14, 0x67, 0x49, 0x1b, 0x85, 0x76, 0x2c, 0x40, 0xa5, 0xba, 0x37, 0xb8, 0x11, 0x3d, 0x4e, 0x74}: "DellFreeFallSensorSmm",
		efi.GUID{0x14, 0x6e, 0xa6, 0x16, 0xa3, 0x40, 0x0c, 0x4a, 0xb5, 0x69, 0x1c, 0x68, 0x22, 0x37, 0x33, 0x45}: "AmdSocFp7r2PhxPei",
		efi.GUID{0x14, 0x74, 0x71, 0xa7, 0x16, 0xc6, 0x77, 0x49, 0x94, 0x20, 0x84, 0x47, 0x12, 0xa7, 0x35, 0xbf}: "EfiCertTypeRsa2048Sha256Guid",
		efi.GUID{0x14, 0x8e, 0x95, 0xdc, 0x7e, 0xca, 0x9c, 0x47, 0xa6, 0x56, 0x2c, 0xb9, 0x5f, 0x8a, 0x16, 0x9b}: "RpmcDxe",
		efi.GUID{0x14, 0x93, 0x8a, 0x73, 0xc1, 0x82, 0x92, 0x45, 0x8f, 0xf7, 0xc1, 0xbd, 0xf1, 0xb2, 0x0e, 0xd4}: "ShellTftpHiiGuid",
		efi.GUID{0x14, 0x9e, 0xb6, 0xe9, 0x08, 0xae, 0x59, 0x44, 0x8c, 0xf6, 0x6e, 0xdd, 0x19, 0xa3, 0x9d, 0xd5}: "AmdNbioIOMMURNPei",
		efi.GUID{0x14, 0xa6, 0x10, 0xa5, 0x92, 0x21, 0xdf, 0x11, 0xaf, 0x29, 0x27, 0x54, 0xe8, 0x6b, 0x35, 0x94}: "PciExpressHostBridge",
		efi.GUID{0x14, 0xa6, 0x26, 0x3e, 0xf7, 0x09, 0x6a, 0x48, 0xa8, 0x8f, 0xa9, 0x9b, 0xf1, 0x5e, 0x1f, 0xa1}: "LenovoPcdInit",
		efi.GUID{0x14, 0xa9, 0x51, 0x81, 0x37, 0x24, 0xd0, 0x41, 0xa4, 0x10, 0x14, 0xdf, 0x75, 0xf9, 0xbe, 0x70}: "SystemMassStorageEventDxe",
		efi.GUID{0x14, 0xae, 0x2b, 0xe9, 0xfd, 0x3d, 0x70, 0x4c, 0x9f, 0xe6, 0x38, 0x99, 0xf3, 0x6c, 0x78, 0x46}: "PLEDSMM",
		efi.GUID{0x14, 0xae, 0xa0, 0xff, 0xd1, 0x0f, 0x69, 0x41, 0xb8, 0x7d, 0x58, 0xfb, 0x8c, 0x34, 0x65, 0x56}: "FjLoadRtd3Table",
		efi.GUID{0x14, 0xbb, 0xe1, 0x87, 0x5c, 0x4d, 0x4e, 0x7c, 0xa9, 0x0e, 0xe1, 0x41, 0x56, 0x87, 0xd0, 0x62}: "EmuTimer",
		efi.GUID{0x14, 0xc3, 0xbb, 0x56, 0x42, 0xb4, 0x5a, 0x4d, 0xba, 0x5c, 0xd8, 0x42, 0xda, 0xfd, 0xbb, 0x24}: "PlatformInitAdvancedPreMem",
		efi.GUID{0x14, 0xc8, 0x26, 0x64, 0x1a, 0x60, 0x16, 0x41, 0x9e, 0x9f, 0xbf, 0x9d, 0x6f, 0x8f, 0x25, 0x4f}: "DellFlashUpdateDxe",
		efi.GUID{0x14, 0xd2, 0xc5, 0x69, 0x93, 0xf9, 0x34, 0x4c, 0x90, 0x11, 0xa0, 0x67, 0x87, 0xe5, 0xc9, 0x56}: "FjSxEnterResumeDispatchSmm",
		efi.GUID{0x14, 0xd3, 0xc6, 0xa0, 0xb1, 0x97, 0xb5, 0x4f, 0xad, 0xce, 0x05, 0x13, 0x8a, 0x2b, 0x5d, 0x00}: "FjHddEraseDxe",
		efi.GUID{0x14, 0xda, 0x55, 0x9a, 0x45, 0xd8, 0x3d, 0x4b, 0x92, 0xdc, 0x33, 0x21, 0x43, 0xcc, 0x5c, 0x1c}: "HDAudioDxe",
		efi.GUID{0x14, 0xdd, 0x03, 0x09, 0xa0, 0x2c, 0x8a, 0x45, 0xb5, 0xeb, 0x0c, 0x0c, 0xa3, 0x0d, 0x78, 0x5c}: "AmiSmbiosBoardProtocolGuid",
		efi.GUID{0x14, 0xe2, 0xb8, 0x38, 0x68, 0x14, 0xb7, 0x4b, 0x95, 0xb1, 0x74, 0x59, 0x1e, 0x4c, 0x6e, 0x1d}: "AttemptUsbFirstHotkeyInfoHob",
		efi.GUID{0x14, 0xef, 0x00, 0x4d, 0xe0, 0xc4, 0x6b, 0x42, 0x81, 0xb7, 0x30, 0xa0, 0x0a, 0x14, 0xaa, 0xd6}: "NandFlash",
		efi.GUID{0x14, 0xf0, 0xbf, 0xf8, 0xfb, 0x18, 0xf9, 0x4e, 0xb1, 0x0c, 0xae, 0x22, 0x73, 0x8d, 0xbe, 0xed}: "DxePlatformSeCPolicyGuid",
		efi.GUID{0x14, 0xf1, 0x87, 0x54, 0xe6, 0x45, 0x34, 0x4d, 0x95, 0xe5, 0xc7, 0xcf, 0x09, 0xe8, 0xae, 0xa9}: "FjNvramVariablesAccessReferencePei",
		efi.GUID{0x14, 0xf6, 0xb7, 0xef, 0x8b, 0xbc, 0xdd, 0x4d, 0xb0, 0x9a, 0x22, 0x07, 0x9f, 0xc1, 0x51, 0x2f}: "TbtDxe",
		efi.GUID{0x14, 0xf9, 0x19, 0xc3, 0xa4, 0x34, 0x45, 0x48, 0x98, 0xc1, 0x16, 0x89, 0xb9, 0x8c, 0x2c, 0x13}: "FjSlp1Support",
		efi.GUID{0x14, 0xfa, 0x1e, 0x6b, 0xb8, 0x06, 0x27, 0x41, 0x97, 0x5a, 0x5b, 0x2d, 0xcf, 0x53, 0x92, 0xe2}: "SmcPostMsgHotKey_DXE",
		efi.GUID{0x14, 0xfb, 0xe9, 0x31, 0xe2, 0x51, 0xe9, 0x46, 0x9f, 0x81, 0xf2, 0xca, 0x52, 0xfc, 0xb2, 0xb4}: "DellDiagsSmmProtocol",
		efi.GUID{0x14, 0xfd, 0xd9, 0xf7, 0x35, 0x93, 0x89, 0x43, 0x80, 0xc5, 0x33, 0x4d, 0x6a, 0xbf, 0xcc, 0xed}: "ArmVirtPrePiUniCoreRelocatable",
		efi.GUID{0x15, 0x00, 0x87, 0xf8, 0x94, 0x69, 0x98, 0x4b, 0x95, 0xa2, 0xbd, 0x56, 0xda, 0x91, 0xc0, 0x7f}: "EfiMemoryMap",
		efi.GUID{0x15, 0x0b, 0xc8, 0x4b, 0x5d, 0x25, 0x58, 0x48, 0x80, 0x72, 0x51, 0xd6, 0xd9, 0x8c, 0xf9, 0x0e}: "SetHostName",
		efi.GUID{0x15, 0x13, 0x5d, 0xf6, 0x05, 0x5b, 0x4f, 0x44, 0xad, 0xf1, 0x7c, 0x1f, 0x05, 0x68, 0x58, 0x52}: "TpmVendorInfineon",
		efi.GUID{0x15, 0x19, 0xb7, 0x8c, 0x1f, 0x53, 0xf5, 0x4a, 0x82, 0xbf, 0xa0, 0x91, 0x40, 0x81, 0x7b, 0xaa}: "FLASHMAPBIN",
		efi.GUID{0x15, 0x1a, 0x47, 0xe0, 0xdc, 0x76, 0x03, 0x42, 0x8b, 0x27, 0x6d, 0xb4, 0xf8, 0xba, 0x64, 0x4a}: "UbaConfigDatabaseDxe",
		efi.GUID{0x15, 0x20, 0x03, 0x75, 0x56, 0xd1, 0x3e, 0x42, 0xbf, 0xa3, 0x7a, 0x65, 0xab, 0xa4, 0x71, 0x05}: "EfiI2cBusConfigurationManagementProtocolGuid",
		efi.GUID{0x15, 0x20, 0x9a, 0x85, 0x7b, 0x3c, 0x4e, 0x4f, 0x84, 0x7f, 0x7a, 0xa8, 0x8c, 0x87, 0x14, 0xa5}: "ConfigChangePromptSmm",
		efi.GUID{0x15, 0x21, 0x25, 0xfd, 0xaf, 0x77, 0x9d, 0x4d, 0xa2, 0x59, 0x81, 0xdd, 0x98, 0x78, 0x0e, 0x18}: "UpdateTCMFlag",
		efi.GUID{0x15, 0x26, 0x89, 0x77, 0x7a, 0x7c, 0xef, 0x4a, 0xa3, 0x20, 0x2a, 0x0c, 0x15, 0xc4, 0x4b, 0x95}: "BiosRegionLock",
		efi.GUID{0x15, 0x29, 0x0c, 0xf3, 0x82, 0x57, 0x6a, 0x4e, 0xa8, 0x46, 0x05, 0xba, 0xbc, 0xe7, 0xb6, 0xa0}: "EfiI2cAcpiProtocolGuid",
		efi.GUID{0x15, 0x2f, 0x27, 0x52, 0x2f, 0xc2, 0x53, 0x4b, 0x83, 0x0a, 0xfb, 0xef, 0x9c, 0x3f, 0x64, 0x3b}: "RealtekLan",
		efi.GUID{0x15, 0x32, 0x79, 0x11, 0x3a, 0xcd, 0x2a, 0x42, 0xa2, 0x29, 0x24, 0x94, 0x17, 0x28, 0x2d, 0xfa}: "FchDxeMmio",
		efi.GUID{0x15, 0x45, 0x5a, 0xb5, 0x95, 0x58, 0xa8, 0x4e, 0x84, 0x5b, 0x75, 0xb7, 0x48, 0x0f, 0x65, 0x02}: "SmmControl2OnSmmControlThunk",
		efi.GUID{0x15, 0x4e, 0xc8, 0xda, 0xf5, 0xc3, 0xf1, 0x40, 0x81, 0x84, 0x8d, 0xe8, 0xda, 0x91, 0xfe, 0x0e}: "SbSocMatissePei",
		efi.GUID{0x15, 0x4e, 0xc8, 0xda, 0xf5, 0xc3, 0xf1, 0x40, 0x81, 0x84, 0x8d, 0xe8, 0xda, 0x91, 0xfe, 0x11}: "SbSocRenoirPei",
		efi.GUID{0x15, 0x56, 0xee, 0xea, 0xfd, 0x0c, 0xfc, 0x45, 0x87, 0x69, 0xa0, 0xd8, 0x56, 0x95, 0xaf, 0x85}: "EdkiiNonDiscoverableEhciDeviceGuid",
		efi.GUID{0x15, 0x59, 0xf7, 0x4d, 0x88, 0x6c, 0xf4, 0x4e, 0x99, 0x5d, 0x83, 0x4d, 0x86, 0x6d, 0xbd, 0x20}: "CpuSetAgesaPcd",
		efi.GUID{0x15, 0x5c, 0x24, 0x4e, 0xe1, 0x66, 0xc4, 0x47, 0x92, 0xb0, 0x0f, 0x57, 0x27, 0x59, 0x17, 0x20}: "UnlockNextHddUserPassword",
		efi.GUID{0x15, 0x5c, 0xdf, 0x20, 0x32, 0x5e, 0xd7, 0x42, 0xbb, 0x67, 0x33, 0x90, 0xa0, 0xe5, 0x1f, 0xfd}: "HpErrorLoggingPei",
		efi.GUID{0x15, 0x69, 0x11, 0x51, 0x4b, 0xc3, 0x8e, 0x4d, 0x86, 0xdb, 0x6a, 0x70, 0xf2, 0xe6, 0x0d, 0xaa}: "NVMe",
		efi.GUID{0x15, 0x69, 0x11, 0x51, 0x4b, 0xc3, 0x8e, 0x4d, 0x86, 0xdb, 0x6a, 0x70, 0xf2, 0xe6, 0x0d, 0xac}: "IOBufferCopyController",
		efi.GUID{0x15, 0x82, 0x75, 0x28, 0x0d, 0x0d, 0x36, 0x41, 0xa8, 0xc8, 0x68, 0xab, 0x67, 0x11, 0xdf, 0x46}: "EcFwUpdateDxe",
		efi.GUID{0x15, 0x84, 0x36, 0xcf, 0xfd, 0x2c, 0x57, 0x47, 0x80, 0x3f, 0x6e, 0x27, 0x3d, 0x91, 0x23, 0xee}: "AcerLidPei",
		efi.GUID{0x15, 0x88, 0x94, 0x4f, 0xb9, 0xb4, 0xcb, 0x43, 0x8a, 0x33, 0x90, 0xe0, 0x60, 0xb3, 0x49, 0x55}: "EfiUdp6ProtocolGuid",
		efi.GUID{0x15, 0x88, 0xcd, 0x2d, 0xcb, 0x74, 0xed, 0x4b, 0xa4, 0x85, 0x4b, 0x39, 0x28, 0xbf, 0x50, 0xee}: "RsaBmcCommands",
		efi.GUID{0x15, 0x91, 0xee, 0xcf, 0x9f, 0xf1, 0x3e, 0x45, 0xa0, 0xe8, 0x97, 0xde, 0xcd, 0x36, 0x82, 0x8c}: "H19DisplayMsgInBlackScreen",
		efi.GUID{0x15, 0x92, 0x78, 0x6b, 0x63, 0xb0, 0xfd, 0x45, 0x86, 0x8a, 0x66, 0x8a, 0x49, 0xf0, 0x0e, 0xc6}: "TXTWrapperPei",
		efi.GUID{0x15, 0x98, 0x1f, 0x33, 0x94, 0x9d, 0x26, 0x4a, 0x9c, 0xd2, 0xde, 0x37, 0x7b, 0x5e, 0x9a, 0x08}: "TbtRetimerCapsule2Dxe",
		efi.GUID{0x15, 0xa4, 0xaa, 0x1f, 0xa9, 0xf8, 0x33, 0x4a, 0xb4, 0x34, 0xa7, 0x81, 0x1f, 0xbe, 0xc1, 0x45}: "SaveConfigMemData",
		efi.GUID{0x15, 0xb1, 0xc3, 0x21, 0x0b, 0x4e, 0x0c, 0x47, 0x85, 0xc7, 0xe1, 0x05, 0xa5, 0x75, 0xc9, 0x7b}: "EdkiiEmbeddedGpioPpi",
		efi.GUID{0x15, 0xb4, 0xdd, 0x46, 0x44, 0x52, 0xc7, 0x49, 0x93, 0x74, 0xf0, 0xe2, 0x98, 0xe7, 0xd3, 0x86}: "EdkiiHttpTlsCipherList",
		efi.GUID{0x15, 0xb7, 0xb5, 0xe7, 0x83, 0x11, 0x33, 0x45, 0xbe, 0x76, 0x56, 0xa6, 0xd7, 0xce, 0xb0, 0x2e}: "AmiPeiPciEnumerationPpi",
		efi.GUID{0x15, 0xb8, 0xe6, 0xda, 0x7d, 0x87, 0x97, 0x45, 0xa6, 0x37, 0xcf, 0xcf, 0xcc, 0xc4, 0x31, 0xed}: "PlatformStatusCodeHandlerDxe",
		efi.GUID{0x15, 0xbb, 0x37, 0xf7, 0x19, 0x50, 0x16, 0x4a, 0x9d, 0xd9, 0x8f, 0xd3, 0x4e, 0x43, 0x1e, 0xad}: "SmbiosDataUpdateDxeGlacier",
		efi.GUID{0x15, 0xbd, 0x2f, 0x0a, 0x25, 0x1c, 0x7e, 0x40, 0x89, 0x15, 0x60, 0xc5, 0x65, 0x2b, 0xc2, 0xaa}: "SystemFirmwareUpdateDxe",
		efi.GUID{0x15, 0xc0, 0xba, 0x91, 0x26, 0x3a, 0xff, 0x40, 0x9f, 0x3e, 0xc3, 0xf4, 0xfe, 0x9d, 0x24, 0xf9}: "SystemSmbiosAddedValueDxe",
		efi.GUID{0x15, 0xc3, 0x8f, 0xf0, 0x4f, 0xcc, 0x8c, 0x4d, 0xb3, 0x4c, 0xb0, 0x30, 0xc4, 0xe7, 0xb9, 0x19}: "EfiCrystalRidgeSmm",
		efi.GUID{0x15, 0xca, 0xe5, 0x79, 0x2d, 0x7a, 0x37, 0x4f, 0xa6, 0x3b, 0xd1, 0xc7, 0xbb, 0xca, 0x47, 0xad}: "AhciPei",
		efi.GUID{0x15, 0xcc, 0x0b, 0x28, 0xd7, 0x2c, 0x7c, 0x46, 0x96, 0x47, 0x1b, 0x30, 0x30, 0x7d, 0x7e, 0xd5}: "AmiFriVariable",
		efi.GUID{0x15, 0xd1, 0x30, 0xa0, 0xdd, 0x54, 0x7b, 0x44, 0x90, 0x64, 0xf2, 0x06, 0x88, 0x3d, 0x7c, 0xcc}: "PeiTpmInitializationDonePpiGuid",
		efi.GUID{0x15, 0xdd, 0x07, 0x33, 0xba, 0x23, 0x46, 0x45, 0xa0, 0x04, 0xfc, 0xbc, 0xc4, 0x7d, 0x4a, 0x49}: "SiliconPolicyPeiPreMem",
		efi.GUID{0x15, 0xe2, 0x3b, 0x8d, 0xf6, 0xd6, 0x64, 0x42, 0xbe, 0xa6, 0x28, 0x07, 0x3f, 0xb1, 0x3a, 0xaa}: "ChipsetSmmThunk",
		efi.GUID{0x15, 0xe2, 0x3b, 0x8d, 0xf6, 0xd6, 0x64, 0x42, 0xbe, 0xa6, 0x28, 0x07, 0x3f, 0xb1, 0x3a, 0xea}: "SmmThunk",
		efi.GUID{0x15, 0xe4, 0x78, 0xc1, 0x49, 0x6e, 0x9a, 0x46, 0xb7, 0x3d, 0xf6, 0xc5, 0xeb, 0x41, 0x01, 0xeb}: "AmdSpiRomProtectDxe",
		efi.GUID{0x15, 0xe7, 0x1a, 0x8d, 0x82, 0x7f, 0x9d, 0x44, 0xa2, 0x6c, 0x62, 0xac, 0x65, 0x0a, 0xf7, 0x3f}: "Int15PanelType",
		efi.GUID{0x15, 0xeb, 0x1d, 0x33, 0x4b, 0x45, 0xd8, 0x48, 0x9b, 0x74, 0x70, 0xd0, 0x1f, 0x3f, 0x35, 0x56}: "UefiDriverEntryPoint",
		efi.GUID{0x16, 0x00, 0x3a, 0x9f, 0x55, 0xae, 0x88, 0x42, 0x82, 0x9d, 0xd2, 0x2f, 0xd3, 0x44, 0xc3, 0x47}: "AmiBoardInfo",
		efi.GUID{0x16, 0x00, 0x3a, 0x9f, 0x55, 0xae, 0x88, 0x42, 0x82, 0x9d, 0xd5, 0x5f, 0xd3, 0xaa, 0xc3, 0x47}: "AmiBoardInfo2",
		efi.GUID{0x16, 0x00, 0x7f, 0xe1, 0xe6, 0xe0, 0x01, 0x4b, 0xab, 0x59, 0x79, 0x7a, 0x26, 0x99, 0x90, 0x1b}: "AaeonHiManager",
		efi.GUID{0x16, 0x02, 0x3f, 0x42, 0xd9, 0xfb, 0xbd, 0x4a, 0xa6, 0x3c, 0x60, 0xa4, 0x59, 0x1a, 0x37, 0xc2}: "FjIbvTraceAbstractionPpi",
		efi.GUID{0x16, 0x08, 0x28, 0x0b, 0xe7, 0x52, 0x51, 0x4e, 0xaa, 0x57, 0x11, 0xbd, 0x41, 0xcb, 0xef, 0xc3}: "EfiPciHotplugDevice",
		efi.GUID{0x16, 0x08, 0x2e, 0xdb, 0x8e, 0x71, 0x1a, 0x4b, 0x91, 0xaf, 0xf2, 0x28, 0x6f, 0xab, 0x08, 0xbf}: "FchBixbySsdt",
		efi.GUID{0x16, 0x09, 0x7f, 0xea, 0xc8, 0xb5, 0x3f, 0x49, 0xa0, 0x06, 0x56, 0x5c, 0xc2, 0x04, 0x10, 0x44}: "FspS3Notify",
		efi.GUID{0x16, 0x18, 0x1c, 0xab, 0x42, 0xd5, 0x6f, 0x4e, 0x9b, 0x1e, 0x8e, 0xcd, 0x92, 0x53, 0xe2, 0xe7}: "ArmGlobalVariablePpiGuid",
		efi.GUID{0x16, 0x1a, 0x07, 0xdd, 0x16, 0xcf, 0xd3, 0x4a, 0xa0, 0x1e, 0x5b, 0x15, 0x68, 0x0c, 0xdf, 0xf0}: "KEMhUuid",
		efi.GUID{0x16, 0x20, 0xe8, 0x9b, 0xfd, 0x23, 0xce, 0x4e, 0x82, 0x6a, 0x55, 0xa6, 0x83, 0xa2, 0x5f, 0x0c}: "SioFlexIoSmbiosDxe",
		efi.GUID{0x16, 0x23, 0x54, 0x8c, 0xe5, 0xa1, 0x01, 0x40, 0x89, 0xe7, 0x15, 0xed, 0xff, 0x12, 0x57, 0x7d}: "gear11",
		efi.GUID{0x16, 0x33, 0x76, 0xf7, 0x04, 0x8c, 0xd8, 0x41, 0xa8, 0x7d, 0x45, 0xb7, 0x3c, 0x13, 0xc4, 0x3c}: "BltLibSample",
		efi.GUID{0x16, 0x35, 0xe3, 0xce, 0xe3, 0x58, 0xdb, 0x47, 0xbb, 0x3f, 0x27, 0x58, 0xb5, 0xa7, 0x6c, 0x28}: "FirmwareVersionInfoDxe",
		efi.GUID{0x16, 0x36, 0xcf, 0xdd, 0x75, 0x32, 0x64, 0x41, 0x98, 0xb6, 0xfe, 0x85, 0x70, 0x7f, 0xfe, 0x7d}: "EfiVariableInfoGuid",
		efi.GUID{0x16, 0x3b, 0xbe, 0x66, 0x6c, 0x4e, 0xf6, 0x4b, 0xa4, 0xe8, 0xf8, 0x79, 0xb8, 0xac, 0xf1, 0x6d}: "DellSecurityAuditDisplayConfig",
		efi.GUID{0x16, 0x3d, 0x9e, 0xe1, 0x11, 0xbc, 0xe4, 0x11, 0x9c, 0xaa, 0xc2, 0x05, 0x1d, 0x5d, 0x46, 0xb0}: "EfiArmProcessorErrorSectionGuid",
		efi.GUID{0x16, 0x3e, 0x75, 0x1e, 0xef, 0xdc, 0xd0, 0x47, 0x9a, 0x38, 0x7a, 0xde, 0xcd, 0xb9, 0x83, 0xed}: "TcmLegX16FileGuid",
		efi.GUID{0x16, 0x41, 0x0a, 0xf7, 0xf6, 0xfd, 0xfb, 0x45, 0x93, 0xcd, 0x84, 0xcd, 0xdd, 0x73, 0xdf, 0xd4}: "EfiPeiPlatformTypeLightningRidgeExecB1Ppi",
		efi.GUID{0x16, 0x46, 0x33, 0x81, 0xce, 0x86, 0xc2, 0x49, 0xb6, 0xf9, 0x18, 0x04, 0xe6, 0x1c, 0x73, 0xf6}: "LenovoIgdCustomize",
		efi.GUID{0x16, 0x54, 0x08, 0x77, 0x37, 0xe1, 0xa0, 0x44, 0x89, 0xf3, 0x0c, 0x7d, 0xa7, 0xf2, 0xf5, 0x2a}: "OemNecTseEsaSwitch",
		efi.GUID{0x16, 0x5d, 0x40, 0xd1, 0xfc, 0x7a, 0x95, 0x46, 0xbb, 0x12, 0x41, 0x45, 0x9d, 0x36, 0x95, 0xa2}: "EfiNetworkStackSetupGuid",
		efi.GUID{0x16, 0x6d, 0xb0, 0xd5, 0xa1, 0x2e, 0xef, 0x4d, 0x98, 0xd0, 0xa0, 0x5d, 0x40, 0x72, 0x84, 0x17}: "EfiWatchdogTimerDriverProtocolGuid",
		efi.GUID{0x16, 0x75, 0xa2, 0xec, 0x6c, 0x30, 0x28, 0x4e, 0x8c, 0x94, 0x4e, 0x52, 0x10, 0x96, 0x69, 0x5e}: "DxeSiPolicyProtocolGuid",
		efi.GUID{0x16, 0x7d, 0x52, 0xa3, 0xcc, 0xe6, 0xf5, 0x42, 0xba, 0xdb, 0xbf, 0x3d, 0xe1, 0x77, 0x74, 0x2b}: "UsbCbiDxe",
		efi.GUID{0x16, 0x7e, 0x62, 0x7a, 0x9d, 0x67, 0x14, 0x48, 0x8f, 0x82, 0xee, 0xaf, 0x38, 0x81, 0xf0, 0x98}: "BatteryState6",
		efi.GUID{0x16, 0x9f, 0x25, 0xff, 0xd1, 0x18, 0x98, 0x42, 0x8d, 0xd2, 0xbd, 0x87, 0xff, 0x28, 0x94, 0xa9}: "PchResetPeim",
		efi.GUID{0x16, 0x9f, 0xa0, 0x1e, 0x28, 0x1a, 0x5b, 0x43, 0x8e, 0x8e, 0x8a, 0xb7, 0xc1, 0xde, 0x04, 0xd3}: "FjHiiString",
		efi.GUID{0x16, 0xa2, 0x7f, 0xfa, 0xb5, 0x4d, 0xdd, 0xd8, 0x64, 0xd9, 0xfa, 0x8d, 0x53, 0x9a, 0x5a, 0xcd}: "PiAst2500Dxe",
		efi.GUID{0x16, 0xa9, 0x95, 0x0c, 0x06, 0xa0, 0xd4, 0x11, 0xbc, 0xfa, 0x00, 0x80, 0xc7, 0x3c, 0x88, 0x81}: "WinNtThunkDxe",
		efi.GUID{0x16, 0xaa, 0x13, 0xdf, 0xb9, 0xb7, 0xa0, 0x42, 0xa3, 0x99, 0x00, 0xee, 0x6c, 0x81, 0xa8, 0x5a}: "DxeBoardInit",
		efi.GUID{0x16, 0xab, 0xed, 0xe0, 0x82, 0xc4, 0x15, 0x40, 0xae, 0x70, 0x64, 0xbd, 0xfc, 0xaa, 0x89, 0xab}: "DellBiosConnectDownloadMgr",
		efi.GUID{0x16, 0xae, 0x78, 0x55, 0xc9, 0xf1, 0x8f, 0x4e, 0xb1, 0x29, 0xba, 0x07, 0xf8, 0xfc, 0xf8, 0x4a}: "IdeSetupProtocol",
		efi.GUID{0x16, 0xaf, 0xf4, 0x3b, 0x7c, 0xab, 0x43, 0x4b, 0x89, 0x8d, 0xab, 0x26, 0xac, 0x5d, 0xdc, 0x6c}: "SecSMIFlash",
		efi.GUID{0x16, 0xb0, 0x0d, 0x4f, 0x4d, 0x30, 0x82, 0x4e, 0x85, 0x51, 0x7d, 0x2f, 0x39, 0x43, 0x6d, 0x24}: "EmulatedEepromSmm",
		efi.GUID{0x16, 0xb5, 0x4f, 0x9c, 0x1e, 0x3a, 0x47, 0xd8, 0xa1, 0xa1, 0x70, 0x58, 0xb6, 0x98, 0x67, 0x32}: "EfiEmuSystemConfig",
		efi.GUID{0x16, 0xc6, 0x9b, 0x58, 0x4f, 0xbb, 0xed, 0x47, 0x92, 0xf7, 0x93, 0x39, 0x3c, 0x69, 0x7e, 0x25}: "AmiSbSmiProtocol",
		efi.GUID{0x16, 0xd6, 0x47, 0x4b, 0xd6, 0xa8, 0x52, 0x45, 0x9d, 0x44, 0xcc, 0xad, 0x2e, 0x0f, 0x4c, 0xf9}: "IScsiConfigGuid",
		efi.GUID{0x16, 0xdd, 0xf7, 0x8a, 0x42, 0x23, 0x87, 0x49, 0x94, 0x26, 0x66, 0x04, 0xa2, 0x07, 0xe2, 0x4b}: "HddStandBy",
		efi.GUID{0x16, 0xdd, 0xf7, 0x8a, 0x42, 0x23, 0x87, 0x49, 0x94, 0x26, 0x66, 0x04, 0xa2, 0x07, 0xe2, 0x6a}: "PasswordSeverityDxe",
		efi.GUID{0x16, 0xdf, 0x38, 0xdc, 0x80, 0x82, 0xc1, 0x49, 0xb2, 0x53, 0xd7, 0xdb, 0xb3, 0x01, 0xcf, 0x71}: "SystemNUserPasswordCredentialDxe",
		efi.GUID{0x16, 0xdf, 0x38, 0xdc, 0x80, 0x82, 0xc1, 0x49, 0xb2, 0x53, 0xd7, 0xdb, 0xb3, 0x01, 0xcf, 0x78}: "UserCredentialPwdDxe",
		efi.GUID{0x16, 0xe1, 0x13, 0xe8, 0x99, 0xc0, 0x21, 0x4d, 0x9c, 0x34, 0xa5, 0x52, 0xd5, 0xe9, 0xa5, 0xd0}: "AmiPeiMrcDefault",
		efi.GUID{0x16, 0xe4, 0x0c, 0x15, 0x63, 0xee, 0xb6, 0x46, 0x8b, 0xa3, 0x73, 0x22, 0xbb, 0xe0, 0x46, 0x37}: "SaPlatformPolicyPpi",
		efi.GUID{0x16, 0xe7, 0x19, 0x7f, 0x9c, 0x41, 0x79, 0x4e, 0x8e, 0x37, 0xc2, 0xbd, 0x84, 0xeb, 0x65, 0x28}: "PeiSpiSoftStrapsPpi",
		efi.GUID{0x16, 0xe8, 0xf3, 0x46, 0xca, 0x66, 0x62, 0x40, 0x8a, 0x6c, 0x62, 0x3b, 0xfc, 0x90, 0xdd, 0x8e}: "FjSmbiosProducerDxe",
		efi.GUID{0x16, 0xeb, 0x41, 0x4b, 0xf1, 0x9e, 0xa8, 0x4c, 0x8d, 0xf2, 0x84, 0x85, 0x46, 0x7b, 0xa9, 0x77}: "KEMhDisp",
		efi.GUID{0x16, 0xec, 0x11, 0x4f, 0x2c, 0xe5, 0x68, 0x4c, 0xa3, 0x4d, 0xc8, 0x3f, 0x4a, 0x45, 0x3f, 0xf9}: "XnoteEspPeim",
		efi.GUID{0x16, 0xef, 0x17, 0x59, 0x23, 0xf7, 0xb9, 0x4b, 0xa6, 0x4b, 0xd8, 0xc5, 0x32, 0xf4, 0xd8, 0xb5}: "EfiUserCredentialClassHandprintGuid",
		efi.GUID{0x16, 0xf8, 0x90, 0x00, 0xa1, 0x86, 0x38, 0x46, 0x97, 0xc8, 0x4d, 0x1b, 0xd7, 0x9e, 0x7e, 0x5f}: "SmcPeiReportStatusConOut",
		efi.GUID{0x16, 0xfa, 0x9b, 0x11, 0x1b, 0x91, 0x1f, 0x4f, 0xb1, 0xb2, 0x69, 0xf4, 0x3b, 0x75, 0x94, 0x48}: "DellPcdUpdatePei",
		efi.GUID{0x16, 0xfe, 0x49, 0x4a, 0x32, 0xf4, 0x93, 0x4b, 0xa7, 0x22, 0x93, 0x24, 0x32, 0xa2, 0x0b, 0xcf}: "EFI",
		efi.GUID{0x17, 0x00, 0x8d, 0x27, 0x07, 0x1f, 0x5e, 0x4f, 0xa3, 0xec, 0x21, 0xd0, 0x4d, 0xcc, 0x3a, 0x6f}: "IncompatiblePciDevice",
		efi.GUID{0x17, 0x08, 0xdf, 0xd6, 0x8a, 0x24, 0xf1, 0x41, 0xa1, 0xd3, 0x59, 0xe5, 0x37, 0x18, 0x7d, 0x10}: "DellTcg2Smm",
		efi.GUID{0x17, 0x0a, 0x10, 0x71, 0xea, 0x76, 0xbd, 0x48, 0x82, 0x63, 0x1a, 0x31, 0xb2, 0x95, 0x24, 0x38}: "DellSystemPolicy3",
		efi.GUID{0x17, 0x0c, 0xf1, 0xb9, 0xa0, 0x6c, 0xb5, 0x40, 0x9b, 0x44, 0x62, 0x53, 0xcf, 0xc7, 0xd2, 0x4b}: "GdbDebugAgent",
		efi.GUID{0x17, 0x22, 0xf0, 0xe9, 0x93, 0x20, 0x70, 0x44, 0x8a, 0x54, 0x5c, 0x2c, 0xff, 0xe7, 0x3e, 0xcb}: "EfiSpiSmmHcProtocolGuid",
		efi.GUID{0x17, 0x2f, 0xc4, 0xb9, 0x79, 0x81, 0x98, 0x6e, 0xb2, 0xb7, 0x21, 0x86, 0x5b, 0x1a, 0xca, 0x3e}: "FTPMDxe",
		efi.GUID{0x17, 0x38, 0xcb, 0xca, 0xe6, 0x81, 0x7e, 0x49, 0x87, 0xff, 0xc8, 0xfa, 0x8f, 0x24, 0xec, 0x28}: "SgACPI",
		efi.GUID{0x17, 0x38, 0xfe, 0xed, 0x61, 0x86, 0xb2, 0x42, 0xa3, 0xf6, 0x94, 0x8f, 0xa7, 0xae, 0xa2, 0x0b}: "DxeThunderbolt",
		efi.GUID{0x17, 0x3c, 0x1c, 0xc9, 0x74, 0xfc, 0xe5, 0x46, 0xbd, 0xbe, 0x6f, 0x48, 0x6a, 0x5a, 0x9f, 0x3c}: "AmiRomLayoutFfsFileGuid",
		efi.GUID{0x17, 0x43, 0x79, 0x5e, 0x7e, 0xa0, 0xdf, 0x45, 0x94, 0xbb, 0x1c, 0x99, 0x7d, 0x62, 0x32, 0xca}: "AmiFwRecoveryCapsule",
		efi.GUID{0x17, 0x47, 0xc4, 0x89, 0xe4, 0x7e, 0x7b, 0x48, 0x8f, 0x5c, 0x8e, 0x60, 0x95, 0x56, 0xa9, 0x0f}: "VideoInitDoneSent",
		efi.GUID{0x17, 0x53, 0x33, 0x8b, 0x90, 0xb4, 0x75, 0x4c, 0x93, 0xdf, 0xc6, 0x82, 0x01, 0x34, 0x67, 0x58}: "FjSetupControlDxe",
		efi.GUID{0x17, 0x5a, 0xab, 0x74, 0xd7, 0x82, 0x2b, 0x47, 0xb2, 0xcc, 0x22, 0xcb, 0x82, 0x58, 0x44, 0xc4}: "FjDeviceInfoBaseDriver",
		efi.GUID{0x17, 0x65, 0x9a, 0xc1, 0xe4, 0x3f, 0xd8, 0x49, 0x94, 0xb6, 0xc4, 0xd7, 0x73, 0x50, 0xaa, 0x44}: "FlashUtilityDxe",
		efi.GUID{0x17, 0x69, 0x8c, 0x73, 0xf0, 0x71, 0x45, 0x4d, 0xab, 0x68, 0x91, 0x74, 0x41, 0x36, 0xae, 0xea}: "AppleIpAgent",
		efi.GUID{0x17, 0x73, 0xe1, 0x79, 0xbb, 0x1c, 0x25, 0x4a, 0x98, 0x84, 0x91, 0xe0, 0x41, 0xc0, 0x5c, 0x2e}: "DellSmmMfgBootListPolicyProtocol",
		efi.GUID{0x17, 0x7a, 0xab, 0x54, 0x08, 0xad, 0x86, 0x4f, 0x83, 0xc2, 0x4c, 0xf3, 0x98, 0xeb, 0xc0, 0xad}: "AsusPostErrDxe",
		efi.GUID{0x17, 0x7d, 0xd7, 0x2b, 0x71, 0x37, 0x74, 0x49, 0x86, 0x44, 0xf9, 0x9c, 0xf5, 0xb2, 0x66, 0xa7}: "IntelGigabitLanPolicyProtocol",
		efi.GUID{0x17, 0x7d, 0xd7, 0x2b, 0x71, 0x37, 0x74, 0x49, 0x86, 0x44, 0xf9, 0x9c, 0xf5, 0xb2, 0x66, 0xa8}: "Intel_10gLanPolicyProtocol",
		efi.GUID{0x17, 0x80, 0xa1, 0x50, 0xad, 0x37, 0x43, 0x87, 0xbc, 0xf2, 0xdf, 0x1a, 0x8f, 0xf1, 0x2f, 0xab}: "EmuReset",
		efi.GUID{0x17, 0x84, 0x26, 0x2b, 0xd4, 0xcf, 0x29, 0x4c, 0x85, 0xfc, 0x49, 0x59, 0x30, 0x0e, 0x49, 0x69}: "BcmCvUsbSmall",
		efi.GUID{0x17, 0x86, 0x9d, 0xca, 0x52, 0xd6, 0x3b, 0x40, 0xb6, 0xc5, 0xba, 0x47, 0x57, 0x01, 0x16, 0xad}: "TxtPei",
		efi.GUID{0x17, 0x92, 0xc9, 0x6e, 0xbb, 0x69, 0xd6, 0x4a, 0x9b, 0x4e, 0x8f, 0x4a, 0xb9, 0xaf, 0x72, 0xb9}: "ResetTesting",
		efi.GUID{0x17, 0x9a, 0x3f, 0x4e, 0xa9, 0xac, 0xf3, 0x42, 0xa8, 0xcc, 0xe7, 0x34, 0x0f, 0xb6, 0xdb, 0x6e}: "MemTopology",
		efi.GUID{0x17, 0x9c, 0x50, 0x02, 0x0b, 0xdd, 0x15, 0x49, 0x81, 0xf6, 0x1d, 0xe4, 0xba, 0x95, 0x4b, 0x14}: "FanTableSmm",
		efi.GUID{0x17, 0xa1, 0x8f, 0x0d, 0x39, 0x12, 0xd6, 0x4c, 0xad, 0x0a, 0x33, 0x16, 0x63, 0x82, 0x4b, 0x13}: "DellOnboardNicPei",
		efi.GUID{0x17, 0xa7, 0xa1, 0x29, 0xe9, 0x36, 0xe0, 0x49, 0xb3, 0x81, 0xea, 0x3b, 0x5f, 0xf7, 0x09, 0x42}: "LenovoSystemStatusCodePort80Rt",
		efi.GUID{0x17, 0xb1, 0xc2, 0xda, 0xfb, 0xb5, 0x64, 0x49, 0xa3, 0x12, 0x0d, 0xcc, 0x77, 0x06, 0x1b, 0x9b}: "Font",
		efi.GUID{0x17, 0xb8, 0xf8, 0x9f, 0x4c, 0xd1, 0x43, 0x4a, 0x93, 0x14, 0x12, 0x3d, 0xa3, 0x96, 0x0a, 0xd6}: "AmdMemAm4ZpPei",
		efi.GUID{0x17, 0xb9, 0xf8, 0x9f, 0x4c, 0xd1, 0x43, 0x4a, 0x93, 0x14, 0x12, 0x3d, 0xa3, 0x96, 0x0a, 0xd6}: "AmdMemAm4Dxe",
		efi.GUID{0x17, 0xba, 0x87, 0x5f, 0x7d, 0x95, 0x3d, 0x43, 0x9e, 0x15, 0xc0, 0xe7, 0xc8, 0x79, 0x88, 0x99}: "AmiDigitalSignatureProtocolGuid",
		efi.GUID{0x17, 0xc0, 0xce, 0xb5, 0xcb, 0x74, 0x10, 0x4e, 0xba, 0xc3, 0x92, 0x4a, 0x4c, 0xc6, 0x29, 0xc8}: "AmiTseOemPortingVar7",
		efi.GUID{0x17, 0xc2, 0x37, 0x11, 0xbc, 0xb5, 0x9a, 0x4e, 0xb3, 0x28, 0x1e, 0x7b, 0xcd, 0x53, 0x05, 0x20}: "DellThermalDebugSmmDriver",
		efi.GUID{0x17, 0xc7, 0x3d, 0x2a, 0x36, 0x6c, 0x55, 0x4f, 0x9d, 0x2e, 0xca, 0x5a, 0x73, 0xd6, 0x2f, 0x17}: "DellTokenHandlerProtocol",
		efi.GUID{0x17, 0xca, 0x26, 0xa2, 0x07, 0x79, 0x77, 0x4e, 0x88, 0x07, 0x5d, 0x48, 0x78, 0xa3, 0x8f, 0xa7}: "HpDiagnosticsPorting",
		efi.GUID{0x17, 0xca, 0xd8, 0xe0, 0x76, 0x42, 0x86, 0x43, 0xbb, 0x79, 0x48, 0xcb, 0x81, 0x3d, 0x3c, 0x4f}: "EmbeddedTokenSpaceGuid",
		efi.GUID{0x17, 0xce, 0x8e, 0x1f, 0xa5, 0x87, 0x96, 0x41, 0xb2, 0x65, 0x4f, 0x01, 0xfb, 0xf9, 0xaa, 0x2d}: "FjGabiLogoHandlerDxeBin",
		efi.GUID{0x17, 0xdd, 0xeb, 0x1c, 0x25, 0x13, 0xbb, 0x42, 0x8a, 0x7a, 0x22, 0x85, 0x7c, 0xf1, 0x0a, 0x5e}: "AmdFabricRsDxe",
		efi.GUID{0x17, 0xed, 0x43, 0x52, 0x42, 0x67, 0x4c, 0x48, 0x89, 0x22, 0xf2, 0xfd, 0xb1, 0xdc, 0x27, 0x25}: "WmiSensorHandler",
		efi.GUID{0x17, 0xf4, 0x7a, 0x4e, 0x00, 0xc2, 0x0a, 0x40, 0x9d, 0x18, 0x86, 0x5a, 0xda, 0xd3, 0x08, 0x96}: "AmiDddtPresentFlagHob",
		efi.GUID{0x17, 0xf7, 0x01, 0x79, 0x24, 0xfe, 0x8b, 0x4c, 0x87, 0xad, 0xc0, 0x5f, 0x35, 0x66, 0x07, 0x47}: "OemIp3Smi",
		efi.GUID{0x17, 0xf9, 0xc8, 0xdc, 0x0b, 0x08, 0x0b, 0x40, 0xa3, 0x1c, 0x03, 0x6f, 0x13, 0x73, 0xf0, 0x48}: "CertificateStorageDxe",
		efi.GUID{0x18, 0x11, 0x7c, 0xa5, 0xfc, 0x6a, 0xd2, 0x46, 0xba, 0xe6, 0x92, 0x92, 0x62, 0xd3, 0xeb, 0x1e}: "EfiDxeSystemBoardProtocol",
		efi.GUID{0x18, 0x24, 0xa2, 0x6b, 0x04, 0x47, 0x07, 0x45, 0xad, 0xc4, 0x36, 0x4b, 0x86, 0x67, 0xe5, 0x86}: "LoadSecureWipeImage",
		efi.GUID{0x18, 0x27, 0x4b, 0x6a, 0xf3, 0xca, 0x51, 0x4d, 0xbd, 0x91, 0x9e, 0xb1, 0xd6, 0x22, 0x9f, 0x57}: "PasswordEncodeProtocol",
		efi.GUID{0x18, 0x47, 0x73, 0x94, 0xbc, 0x0b, 0xfb, 0x47, 0x96, 0xa5, 0xee, 0x7a, 0x5a, 0xe6, 0xa2, 0xad}: "Dhcp4Dxe",
		efi.GUID{0x18, 0x48, 0x2e, 0x72, 0x4e, 0x34, 0x21, 0x44, 0x88, 0xcd, 0x49, 0x1c, 0xb9, 0x08, 0xc1, 0x42}: "DellSetupCfgPolicies",
		efi.GUID{0x18, 0x4e, 0x92, 0x95, 0x1c, 0x77, 0xa9, 0x42, 0xb8, 0x85, 0xbe, 0xdd, 0xb6, 0x0d, 0x2d, 0x38}: "LenovoSmmKeyboardConfigProtocol",
		efi.GUID{0x18, 0x54, 0x40, 0x3e, 0x8c, 0x0d, 0x1a, 0x4f, 0xb0, 0x55, 0xbe, 0xf9, 0x08, 0x41, 0x46, 0x8d}: "TcoWdtHob",
		efi.GUID{0x18, 0x56, 0xec, 0x77, 0x01, 0x21, 0x12, 0x41, 0x86, 0xb1, 0x2f, 0x75, 0x2a, 0xe1, 0x0f, 0x1a}: "EcSecureFlashDxe",
		efi.GUID{0x18, 0x60, 0xb1, 0xaa, 0x9d, 0x67, 0x61, 0x44, 0xba, 0x20, 0xe7, 0x0c, 0xf7, 0x86, 0x6a, 0x9b}: "EfiSystemTypeFru",
		efi.GUID{0x18, 0x64, 0xd5, 0x2b, 0x1e, 0x46, 0x5a, 0x54, 0x8e, 0x24, 0xa0, 0xbc, 0x15, 0xd4, 0x05, 0x25}: "AsfUi",
		efi.GUID{0x18, 0x67, 0x8a, 0x54, 0xc0, 0x6b, 0xa9, 0x45, 0xb4, 0xe9, 0x6f, 0x63, 0xb0, 0xe1, 0xdd, 0x43}: "RtkUndiDxeClientron",
		efi.GUID{0x18, 0x72, 0xf3, 0x13, 0xdf, 0x70, 0xdd, 0x45, 0x88, 0x83, 0xd4, 0xe6, 0xf5, 0xbe, 0x42, 0x55}: "NvidiaGpuAcpitables",
		efi.GUID{0x18, 0x76, 0x35, 0x54, 0x06, 0xe1, 0x6c, 0x40, 0xa5, 0xce, 0xad, 0x7a, 0x1b, 0xa3, 0xcc, 0xcd}: "ExternalUsbPortConfigDxe",
		efi.GUID{0x18, 0x88, 0x53, 0x4a, 0xe0, 0x5a, 0xb2, 0x4e, 0xb2, 0xeb, 0x48, 0x8b, 0x23, 0x65, 0x70, 0x22}: "FvMainCompact",
		efi.GUID{0x18, 0x97, 0x21, 0x8a, 0xf5, 0x4e, 0x61, 0x47, 0x91, 0xc8, 0xc0, 0xf0, 0x4b, 0xda, 0x9e, 0x56}: "EfiDhcp4ProtocolGuid",
		efi.GUID{0x18, 0xa8, 0x62, 0x2f, 0x72, 0x4a, 0x40, 0xcd, 0x90, 0xb9, 0xff, 0x00, 0xda, 0xab, 0xee, 0x7b}: "EmuThunk",
		efi.GUID{0x18, 0xa8, 0xe1, 0x70, 0xe1, 0x0b, 0x49, 0x44, 0xbf, 0xd4, 0x9e, 0xf6, 0x8c, 0x7f, 0x02, 0xa8}: "ReFlash",
		efi.GUID{0x18, 0xb0, 0x2f, 0x23, 0x08, 0xf3, 0x81, 0x40, 0xb2, 0x80, 0x81, 0x2e, 0x61, 0x64, 0x12, 0x3b}: "PasswordMgrDxe",
		efi.GUID{0x18, 0xb4, 0x6e, 0x29, 0xc8, 0xc4, 0x05, 0x4e, 0xab, 0x59, 0x39, 0xe8, 0xaf, 0x56, 0xf0, 0x0a}: "EdkiiSmmExitBootServicesProtocolGuid",
		efi.GUID{0x18, 0xb6, 0xe5, 0x77, 0x12, 0x26, 0x28, 0x4c, 0xbc, 0xdf, 0xa2, 0xb1, 0x4d, 0x8a, 0x3e, 0xfe}: "IFlashDxe",
		efi.GUID{0x18, 0xba, 0x59, 0x08, 0xd7, 0x7d, 0xd7, 0x4e, 0xa8, 0x8e, 0x10, 0x9c, 0x63, 0x91, 0x7b, 0xdd}: "EfiPlatformMemtestProtocol",
		efi.GUID{0x18, 0xbb, 0x7d, 0xc8, 0xdd, 0x9a, 0xd5, 0x41, 0x80, 0xd7, 0x4c, 0x8d, 0x79, 0x5a, 0xd9, 0x42}: "DellSmmEventSmm",
		efi.GUID{0x18, 0xbf, 0x4b, 0x0d, 0xcc, 0xc2, 0x23, 0x4c, 0xbd, 0x63, 0xbf, 0xda, 0xd4, 0xc7, 0x10, 0xd0}: "Tcg2Acpi",
		efi.GUID{0x18, 0xc3, 0xae, 0x2a, 0x4b, 0xe8, 0x0b, 0x4e, 0xbf, 0x41, 0xac, 0x65, 0xf1, 0x7e, 0x9e, 0x2f}: "AmiTseOemPortingVar14",
		efi.GUID{0x18, 0xc6, 0x27, 0x2d, 0xcd, 0x7d, 0xf5, 0x41, 0xbb, 0x10, 0x21, 0x16, 0x6b, 0xe7, 0xe1, 0x43}: "BiosAc",
		efi.GUID{0x18, 0xca, 0x6b, 0x05, 0x19, 0x2f, 0xee, 0x41, 0x84, 0xea, 0x83, 0x74, 0x6c, 0xb5, 0x06, 0x9a}: "CrystalRidgeSMM",
		efi.GUID{0x18, 0xcb, 0xa8, 0x31, 0x76, 0x5c, 0x68, 0x46, 0x83, 0x9d, 0x9f, 0xe8, 0x04, 0xb4, 0x19, 0xbb}: "CrbLastFfsPei",
		efi.GUID{0x18, 0xd7, 0x08, 0x7d, 0xec, 0x48, 0x52, 0x4c, 0x91, 0x9d, 0x40, 0x7e, 0x5b, 0x1a, 0x94, 0xe4}: "IntelGigabitLan",
		efi.GUID{0x18, 0xd8, 0x9b, 0x99, 0xf7, 0x7d, 0x9a, 0x4a, 0xa5, 0x02, 0x9b, 0x75, 0x03, 0x3e, 0x6a, 0x0f}: "EsrtDxe",
		efi.GUID{0x18, 0xd9, 0xc6, 0xa0, 0xee, 0x8d, 0xbb, 0x41, 0x9d, 0x92, 0x67, 0x53, 0xa5, 0x72, 0xb6, 0x52}: "EfiTpmStateInitHub",
		efi.GUID{0x18, 0xda, 0xbe, 0x27, 0x2b, 0xae, 0xc2, 0x43, 0xaf, 0x6b, 0x74, 0x95, 0x24, 0x41, 0xde, 0x28}: "MonitorKeyDxe",
		efi.GUID{0x18, 0xdd, 0x5f, 0x21, 0x50, 0xbd, 0xeb, 0x4f, 0x89, 0x0b, 0x58, 0xca, 0x0b, 0x47, 0x39, 0xe9}: "EfiSioProtocolGuid",
		efi.GUID{0x18, 0xdf, 0x0c, 0xb7, 0xe2, 0xcf, 0x3c, 0x45, 0xaf, 0x07, 0x31, 0xca, 0xc6, 0x34, 0x5a, 0x16}: "HpCommonSmm",
		efi.GUID{0x18, 0xe1, 0x17, 0x82, 0x58, 0x10, 0x9b, 0x4c, 0x93, 0x6e, 0x5b, 0x30, 0x27, 0xc2, 0x39, 0x4b}: "PchLpcDxe",
		efi.GUID{0x18, 0xe5, 0x41, 0x68, 0x6f, 0x1d, 0x75, 0x4b, 0xb4, 0xd1, 0xcf, 0x19, 0x0d, 0xc5, 0x6b, 0x01}: "PegaHotkeyHook",
		efi.GUID{0x18, 0xe7, 0xa5, 0x30, 0xca, 0x39, 0x1c, 0x44, 0xbe, 0xd3, 0xf4, 0xa3, 0xa9, 0x31, 0x45, 0x8d}: "FchProm21SmmInit",
		efi.GUID{0x18, 0xe8, 0xae, 0xb1, 0x59, 0xb9, 0x7b, 0x48, 0xa7, 0x95, 0x16, 0xc2, 0xa5, 0x4c, 0xb3, 0x6e}: "DellPeiMain",
		efi.GUID{0x18, 0xed, 0xd2, 0x3b, 0x72, 0x9d, 0x08, 0x42, 0x9d, 0x8a, 0x4b, 0xe2, 0x74, 0xe6, 0xed, 0x69}: "CapsuleUpdateApp",
		efi.GUID{0x18, 0xf8, 0x41, 0x64, 0x62, 0x63, 0x44, 0x4e, 0xb5, 0x70, 0x7d, 0xba, 0x31, 0xdd, 0x24, 0x53}: "EfiVariableWriteArchProtocolGuid",
		efi.GUID{0x18, 0xf8, 0x9c, 0x34, 0xba, 0xc0, 0x43, 0x4c, 0x92, 0x9a, 0xc8, 0xa1, 0xb1, 0xb3, 0xd2, 0x55}: "InternalTpm2DeviceInterfaceGuid",
		efi.GUID{0x18, 0xfa, 0x1f, 0x44, 0x14, 0x87, 0x1e, 0x42, 0x8c, 0x95, 0x58, 0x70, 0x80, 0x79, 0x6f, 0xee}: "AmiSmmDebuServiceProtocolGuid",
		efi.GUID{0x18, 0xfd, 0x9a, 0x89, 0xe8, 0x75, 0x8b, 0x40, 0xa4, 0x1a, 0x6e, 0x2e, 0x7e, 0xcd, 0xf4, 0x54}: "EfiExtendedSalMtcServicesProtocolGuid",
		efi.GUID{0x18, 0xfe, 0x98, 0x62, 0xef, 0xd5, 0xb7, 0x42, 0xbb, 0x0c, 0x29, 0x53, 0x28, 0x3f, 0x57, 0x04}: "SleepSmi",
		efi.GUID{0x18, 0xfe, 0x98, 0x62, 0xef, 0xd5, 0xb7, 0x42, 0xbb, 0x0c, 0x29, 0x53, 0x28, 0x56, 0x98, 0x42}: "ResetSmi",
		efi.GUID{0x19, 0x00, 0x38, 0x7f, 0x51, 0xb9, 0xbd, 0x4b, 0xbe, 0xdf, 0x8d, 0xd7, 0xa6, 0x21, 0xd7, 0x73}: "OemNvDriverTypeDxe",
		efi.GUID{0x19, 0x01, 0x0d, 0x49, 0x48, 0x44, 0x0d, 0x44, 0x8f, 0x5c, 0xf5, 0x8f, 0xb5, 0x3e, 0xe0, 0x57}: "PolicyInitDxe",
		efi.GUID{0x19, 0x04, 0xb7, 0x56, 0x03, 0x71, 0x0e, 0x4d, 0x83, 0xf4, 0xf3, 0x54, 0x6b, 0xd2, 0x1e, 0x40}: "EzFileExplorerLite",
		efi.GUID{0x19, 0x0d, 0xf4, 0x1c, 0xad, 0xee, 0x73, 0x4c, 0x93, 0xdb, 0xbb, 0xb8, 0xb6, 0xac, 0xf9, 0x29}: "SystemNUserUserManagerDxe",
		efi.GUID{0x19, 0x14, 0xd6, 0x3b, 0xb8, 0x4b, 0x21, 0x49, 0x92, 0xc8, 0xba, 0x84, 0xa7, 0xa3, 0x59, 0x1f}: "ResetDateTimeDxe",
		efi.GUID{0x19, 0x1e, 0xd8, 0x2a, 0x9b, 0x2e, 0xaa, 0x44, 0xb4, 0xac, 0x9e, 0x21, 0x65, 0x32, 0x2e, 0x1c}: "EfiUsbLegacyStack",
		efi.GUID{0x19, 0x27, 0x0c, 0x96, 0xde, 0x4f, 0x4a, 0x7e, 0x44, 0xc6, 0x26, 0xa6, 0xb2, 0xef, 0xe9, 0xb2}: "SmmNvmExpressCsm",
		efi.GUID{0x19, 0x33, 0x4c, 0x14, 0x75, 0x5f, 0x9f, 0x4a, 0xa9, 0x39, 0x88, 0x2a, 0x7a, 0xb2, 0x99, 0x79}: "FjM2WlanEnableDisableDxe",
		efi.GUID{0x19, 0x37, 0x53, 0xd1, 0xb1, 0x20, 0x4d, 0x40, 0xb9, 0x70, 0xce, 0x13, 0x14, 0x8d, 0xc0, 0xcd}: "PxeDriverRtkLan",
		efi.GUID{0x19, 0x37, 0xc7, 0xf6, 0x4c, 0xf3, 0x9c, 0x47, 0xb3, 0x2f, 0x27, 0x7f, 0xcb, 0xbc, 0xfe, 0x4f}: "DelBootOption",
		efi.GUID{0x19, 0x3e, 0x89, 0xaa, 0x41, 0xa6, 0x19, 0x48, 0xad, 0x23, 0x01, 0x1b, 0x7c, 0x24, 0x25, 0x0d}: "IT8728SioAcBackSmm",
		efi.GUID{0x19, 0x4c, 0x5e, 0x65, 0x7b, 0x9d, 0x91, 0x44, 0xad, 0x10, 0xa4, 0x9f, 0xf3, 0x55, 0xc0, 0x0a}: "FastBootOptionBds",
		efi.GUID{0x19, 0x4f, 0x79, 0x85, 0xbb, 0x3b, 0x92, 0x43, 0xbb, 0x3c, 0x06, 0xe3, 0xeb, 0x45, 0xe3, 0x87}: "D01HookAcpiProtocol",
		efi.GUID{0x19, 0x4f, 0xc1, 0x4c, 0x26, 0xc6, 0xb6, 0x4a, 0x9d, 0xea, 0xca, 0x6c, 0x01, 0xfd, 0x10, 0xcd}: "AsusHeader",
		efi.GUID{0x19, 0x59, 0xf7, 0x40, 0xdb, 0x0c, 0xb2, 0x4d, 0xa0, 0xfb, 0x68, 0x81, 0xce, 0x7e, 0x97, 0x70}: "UsbMouseAbsolutePointerDxe",
		efi.GUID{0x19, 0x60, 0x44, 0x15, 0x70, 0x91, 0x6a, 0x43, 0xa9, 0x81, 0xcc, 0x75, 0x21, 0xe9, 0xd7, 0xf9}: "Usb4PlatformPei",
		efi.GUID{0x19, 0x61, 0x0f, 0x82, 0x09, 0x9f, 0x95, 0x4c, 0x85, 0xba, 0x8a, 0xeb, 0xc2, 0x1d, 0x4e, 0x89}: "FjPowerButtonStatePei",
		efi.GUID{0x19, 0x6c, 0xe0, 0xfa, 0x1c, 0x0f, 0xd3, 0x47, 0x83, 0x2d, 0xe3, 0xb9, 0xc2, 0x5a, 0xd0, 0x20}: "aDefaultPei",
		efi.GUID{0x19, 0x73, 0xec, 0x35, 0x3b, 0x05, 0xb8, 0x45, 0x85, 0x23, 0x86, 0x66, 0xa6, 0x62, 0x12, 0x2c}: "LogoDxe",
		efi.GUID{0x19, 0x7a, 0x65, 0xe2, 0xd8, 0x7c, 0x89, 0x53, 0x98, 0xbc, 0x6e, 0x20, 0x1b, 0xbf, 0x4f, 0x70}: "MonacoFont2x",
		efi.GUID{0x19, 0x86, 0xac, 0x71, 0x0c, 0xb7, 0x74, 0x49, 0x93, 0x07, 0xf6, 0x46, 0xe7, 0x3c, 0xcc, 0xfa}: "PlainPasswordTransfer",
		efi.GUID{0x19, 0x8c, 0xeb, 0x8b, 0xec, 0x3f, 0xab, 0x4f, 0xa3, 0x78, 0xc9, 0x03, 0xe8, 0x90, 0xfc, 0xae}: "AmiEventLogsFormset",
		efi.GUID{0x19, 0x8f, 0xb1, 0xaa, 0x14, 0xfe, 0x66, 0x46, 0x86, 0x04, 0x87, 0xff, 0x6d, 0x66, 0x2c, 0x9a}: "EfiSpiSmmNorFlashProtocolGuid",
		efi.GUID{0x19, 0x8f, 0xb4, 0x8e, 0x92, 0xcc, 0x31, 0x40, 0x8d, 0x3d, 0xee, 0x47, 0x3c, 0xcc, 0x87, 0xeb}: "SystemPrivateKey",
		efi.GUID{0x19, 0x91, 0x04, 0xfb, 0x72, 0xac, 0x9f, 0x45, 0x86, 0x5a, 0x64, 0x1d, 0xc1, 0x3c, 0x93, 0x1d}: "OemLOGO",
		efi.GUID{0x19, 0x93, 0x10, 0x0c, 0x49, 0xc1, 0x0e, 0x45, 0xa3, 0xe3, 0xb9, 0xba, 0xdd, 0x9d, 0xc3, 0xa4}: "EfiPeiMmConfigurationPpi",
		efi.GUID{0x19, 0xa0, 0x02, 0x4e, 0xb1, 0x85, 0xc9, 0x4e, 0x9a, 0x38, 0xb7, 0xdf, 0x05, 0x08, 0x39, 0x7c}: "OemMFGDonePcd",
		efi.GUID{0x19, 0xab, 0xc3, 0x95, 0xc2, 0x59, 0x18, 0x44, 0xa3, 0x5f, 0xca, 0xb8, 0x72, 0x4f, 0x80, 0x28}: "USRATraceLibNull",
		efi.GUID{0x19, 0xad, 0xfb, 0x79, 0xe1, 0xf9, 0x08, 0x4d, 0xb7, 0xbc, 0x35, 0x84, 0x53, 0x19, 0x5e, 0x41}: "AmiTpmRollbackSmmProtocolGuid",
		efi.GUID{0x19, 0xb5, 0xc7, 0x9f, 0x22, 0x35, 0x71, 0x4a, 0xbe, 0xb6, 0xf9, 0x9f, 0x5b, 0x2d, 0xbf, 0x92}: "VgaConfigurationReadyToBoot",
		efi.GUID{0x19, 0xbb, 0x59, 0x98, 0x7c, 0x40, 0x8b, 0x4f, 0xbc, 0xe1, 0xf8, 0xda, 0x65, 0x65, 0xf4, 0xa5}: "AndroidBootImgProtocol",
		efi.GUID{0x19, 0xbb, 0xf3, 0xf3, 0x20, 0x64, 0xc9, 0x45, 0x88, 0x19, 0xb6, 0x06, 0xa7, 0xf2, 0x0e, 0x50}: "DellPStateControlProtocol",
		efi.GUID{0x19, 0xc7, 0x62, 0xf9, 0x1e, 0x6c, 0x75, 0x4a, 0x86, 0x29, 0x38, 0x15, 0x76, 0x22, 0xa9, 0x06}: "AddressTranslationDxe",
		efi.GUID{0x19, 0xca, 0xbd, 0x7c, 0x76, 0x47, 0x97, 0xa9, 0x7c, 0xa7, 0x56, 0xd5, 0x34, 0x3f, 0x29, 0x04}: "EarlyOneTimeFlags",
		efi.GUID{0x19, 0xcc, 0x4c, 0xe7, 0xf9, 0xbf, 0x2e, 0x44, 0x9d, 0xa5, 0x6a, 0x86, 0x62, 0x62, 0xf1, 0x79}: "DellCoreServiceHWIDNvs",
		efi.GUID{0x19, 0xce, 0xfb, 0x0f, 0x4c, 0x32, 0x90, 0x46, 0xa0, 0x09, 0x98, 0xc6, 0xae, 0x2e, 0xb1, 0x86}: "RecoveryOnFatUsbDiskGuid",
		efi.GUID{0x19, 0xd6, 0xd1, 0x1d, 0xb8, 0xf9, 0x3e, 0x46, 0x86, 0x81, 0xd1, 0xdc, 0x7c, 0x07, 0xb7, 0x2c}: "EdkiiNonDiscoverableSdhciDeviceGuid",
		efi.GUID{0x19, 0xdd, 0x29, 0x3a, 0x84, 0x2c, 0x70, 0x4a, 0x9a, 0x01, 0xfb, 0xdd, 0xaf, 0xfb, 0x64, 0x61}: "DellMemoryS4",
		efi.GUID{0x19, 0xdd, 0xd8, 0x29, 0x36, 0xc8, 0xd9, 0x45, 0x8f, 0x05, 0x32, 0x2c, 0x27, 0x12, 0x9c, 0x2a}: "SecureVariable",
		efi.GUID{0x19, 0xe4, 0x94, 0x5b, 0x95, 0xc7, 0x4d, 0x41, 0xa0, 0xd4, 0xb8, 0x0a, 0x87, 0x7b, 0xe5, 0xfe}: "FspSecCoreT",
		efi.GUID{0x1a, 0x04, 0xa5, 0xb7, 0xba, 0x78, 0xe3, 0x49, 0xb7, 0x3b, 0x54, 0xc7, 0x57, 0x81, 0x1f, 0xb6}: "IdeBusPei",
		efi.GUID{0x1a, 0x0e, 0xaf, 0x18, 0xb4, 0xcd, 0xc2, 0x48, 0xb1, 0x11, 0x14, 0xcb, 0x07, 0x04, 0x17, 0xbf}: "SyncCBSconfigPei",
		efi.GUID{0x1a, 0x17, 0x10, 0xcf, 0xf0, 0x57, 0x0a, 0x47, 0x90, 0xe0, 0x62, 0xd9, 0x5f, 0x21, 0x3f, 0x9b}: "HpBeepDeviceDefaults",
		efi.GUID{0x1a, 0x18, 0xee, 0x1c, 0x5c, 0xdf, 0x91, 0x43, 0xbc, 0xa8, 0xcd, 0xe5, 0xa5, 0xa1, 0xa0, 0xba}: "OemHooks",
		efi.GUID{0x1a, 0x21, 0x15, 0x29, 0xf7, 0x3c, 0x4d, 0x4b, 0xb4, 0x48, 0x02, 0xdd, 0xbd, 0x2b, 0xf8, 0x7c}: "CustomLogoWmiDriver",
		efi.GUID{0x1a, 0x2b, 0x92, 0xa3, 0xe4, 0x35, 0x32, 0x41, 0x9c, 0xed, 0x91, 0xd3, 0x8d, 0x71, 0x71, 0xd8}: "FpgaSocketPkgList",
		efi.GUID{0x1a, 0x33, 0xba, 0xf2, 0x85, 0x89, 0xdb, 0x11, 0xa4, 0x06, 0x00, 0x40, 0xd0, 0x2b, 0x18, 0x35}: "EmuVirtualDisksGuid",
		efi.GUID{0x1a, 0x34, 0x79, 0x98, 0x7e, 0x19, 0xf6, 0x4c, 0x9b, 0xda, 0x48, 0x39, 0x2f, 0x85, 0x04, 0x5f}: "LEMProductTYpe",
		efi.GUID{0x1a, 0x44, 0x33, 0xa8, 0xa0, 0x0c, 0x32, 0x40, 0x85, 0x9a, 0x3c, 0xff, 0x7b, 0x66, 0x46, 0xa7}: "DellImageServerDxe",
		efi.GUID{0x1a, 0x49, 0xd7, 0x80, 0xd9, 0xf7, 0x9d, 0x47, 0xa8, 0xf7, 0x1b, 0x39, 0x3b, 0x02, 0xed, 0x66}: "FastBootRuntime",
		efi.GUID{0x1a, 0x4e, 0x98, 0x05, 0xbb, 0xd8, 0x8a, 0x5d, 0xa8, 0xe6, 0x90, 0xe6, 0xfb, 0x2a, 0xb7, 0xda}: "AlertUI",
		efi.GUID{0x1a, 0x50, 0x4c, 0x1c, 0xdc, 0x8c, 0x1f, 0x4d, 0x86, 0x39, 0x27, 0xe9, 0x04, 0x94, 0x94, 0xc1}: "HpCommonAcpiArea",
		efi.GUID{0x1a, 0x55, 0x63, 0x33, 0x17, 0xb7, 0x18, 0x49, 0x93, 0xb9, 0xeb, 0xe6, 0xaf, 0xa5, 0x75, 0x86}: "FjGabiFlashCommonMeRegionCtrlDxe",
		efi.GUID{0x1a, 0x57, 0x3a, 0x29, 0x08, 0x33, 0x3f, 0x44, 0x9f, 0x36, 0x39, 0xdc, 0xfd, 0xbf, 0x3b, 0x83}: "DellEcIoDxe",
		efi.GUID{0x1a, 0x5d, 0xca, 0x31, 0x11, 0xd5, 0x31, 0x49, 0xb7, 0x82, 0xae, 0x6b, 0x2b, 0x17, 0x8c, 0xd7}: "EfiIfrFrameworkGuid",
		efi.GUID{0x1a, 0x68, 0xc9, 0x58, 0x56, 0x69, 0xfa, 0x41, 0xb0, 0xaa, 0xa3, 0x24, 0x6d, 0x88, 0x0e, 0x9a}: "DellWmiSmm",
		efi.GUID{0x1a, 0x79, 0x95, 0xc0, 0x01, 0x30, 0xb2, 0x47, 0x80, 0xc9, 0xea, 0xc7, 0x31, 0x9f, 0x2f, 0xa4}: "EfiFirmwarePerformanceGuid",
		efi.GUID{0x1a, 0x7d, 0xad, 0xbd, 0x48, 0x4c, 0x75, 0x4c, 0xb5, 0xbc, 0xd0, 0x02, 0xd1, 0x7f, 0x63, 0x97}: "AhciRecovery",
		efi.GUID{0x1a, 0x7e, 0xb2, 0x60, 0x5e, 0xd6, 0xb0, 0x4d, 0xb2, 0xbb, 0xc1, 0x6f, 0xa7, 0x1e, 0x44, 0xab}: "PdmWindowSpinGuid",
		efi.GUID{0x1a, 0x86, 0xfe, 0x71, 0x50, 0x54, 0xb6, 0x48, 0xbf, 0xb0, 0xb9, 0x35, 0x22, 0x61, 0x6f, 0x99}: "TPS65950",
		efi.GUID{0x1a, 0x8a, 0x3b, 0x82, 0x01, 0x6d, 0xa6, 0x45, 0x80, 0x98, 0x20, 0xdd, 0xd1, 0xc7, 0xb3, 0xd0}: "PlatformLtDxeLibNull",
		efi.GUID{0x1a, 0xa5, 0x6d, 0x78, 0xa5, 0x86, 0xc5, 0x47, 0xbf, 0x8d, 0x04, 0x87, 0x7b, 0xe4, 0x72, 0x60}: "AmiPciExpressGen3LibNull",
		efi.GUID{0x1a, 0xab, 0x63, 0xd4, 0x4a, 0xf0, 0xf0, 0x4e, 0xaa, 0xa2, 0xcc, 0x3d, 0x03, 0xb2, 0x5a, 0xf0}: "DxeSioHwmIo",
		efi.GUID{0x1a, 0xb1, 0x4d, 0xdb, 0x5c, 0x0e, 0xb5, 0x40, 0x8e, 0x46, 0x17, 0xd0, 0x44, 0x86, 0xa2, 0x1b}: "LenovoMx25L64XflashPartSmm",
		efi.GUID{0x1a, 0xb7, 0xcd, 0x11, 0x09, 0xaa, 0x1b, 0x4b, 0xbc, 0x58, 0xf9, 0x98, 0x38, 0xa4, 0x98, 0x0d}: "fTPMTisPei",
		efi.GUID{0x1a, 0xba, 0xf1, 0x2e, 0x36, 0xc8, 0x50, 0x4a, 0xbf, 0x89, 0x52, 0x5f, 0xf2, 0x9f, 0xf7, 0x87}: "Mxm30Pei",
		efi.GUID{0x1a, 0xbc, 0x08, 0x9a, 0x61, 0x75, 0x68, 0x4a, 0x88, 0x75, 0xc0, 0x97, 0x7c, 0x91, 0x57, 0x3c}: "NetBootUI",
		efi.GUID{0x1a, 0xc1, 0x8d, 0xe6, 0xf4, 0xa5, 0xc3, 0x4a, 0xaa, 0x2e, 0x29, 0xe2, 0x98, 0xbf, 0xf6, 0x45}: "BCP",
		efi.GUID{0x1a, 0xc4, 0x10, 0xf3, 0xf2, 0xf0, 0xe6, 0x49, 0x8a, 0xf5, 0x4b, 0x2f, 0x6e, 0xb4, 0x95, 0xb5}: "LenovoSetupStartupDxeGui",
		efi.GUID{0x1a, 0xca, 0xe8, 0x39, 0x69, 0x7a, 0x73, 0x4a, 0x83, 0x4a, 0xd0, 0x63, 0x81, 0x93, 0x32, 0x86}: "UsbPei",
		efi.GUID{0x1a, 0xd0, 0x8c, 0x2e, 0xb7, 0xbd, 0xb4, 0x40, 0x83, 0x76, 0xe7, 0xc2, 0x6e, 0xac, 0x21, 0xff}: "PciPlatform",
		efi.GUID{0x1a, 0xd1, 0xca, 0x7c, 0xa4, 0xef, 0x82, 0x4f, 0xbd, 0xe7, 0x7d, 0x07, 0xff, 0x90, 0xb2, 0x80}: "BootOrderWmi",
		efi.GUID{0x1a, 0xd2, 0x65, 0x5f, 0x67, 0x88, 0xd3, 0x45, 0xa4, 0x1a, 0x52, 0x6f, 0x9f, 0xe2, 0xc5, 0x98}: "SystemImageDecoderDxe",
		efi.GUID{0x1a, 0xd3, 0x3f, 0x11, 0x8b, 0xbe, 0x8b, 0x41, 0xb0, 0x34, 0x7e, 0xaf, 0xe5, 0xc6, 0x0c, 0x99}: "EsaInterfacesForTseProtocolGuid",
		efi.GUID{0x1a, 0xd7, 0xde, 0x96, 0xe7, 0xb9, 0xad, 0x4e, 0x96, 0x2c, 0x01, 0x69, 0x3c, 0xed, 0x2a, 0x64}: "I2CPeiInitGuid",
		efi.GUID{0x1a, 0xe5, 0x5b, 0x23, 0xd5, 0xd4, 0xef, 0x49, 0x9c, 0x46, 0xd3, 0x13, 0x05, 0x6b, 0x74, 0x01}: "UsbPolicySmm",
		efi.GUID{0x1a, 0xe6, 0x4f, 0x65, 0xda, 0x2e, 0x49, 0x47, 0xa7, 0x6a, 0x56, 0xed, 0x7a, 0xde, 0x1c, 0xbe}: "CmosPei",
		efi.GUID{0x1a, 0xe8, 0xf6, 0x61, 0xba, 0x7b, 0x7f, 0x4a, 0xb9, 0xf2, 0xb0, 0xa3, 0xb5, 0xd4, 0x61, 0xc5}: "DellFileExplorerDxe",
		efi.GUID{0x1b, 0x04, 0xa5, 0xb7, 0xba, 0x78, 0xe3, 0x48, 0xb6, 0x3b, 0x44, 0xc7, 0x57, 0x81, 0x13, 0xb6}: "FloppyPeimPei",
		efi.GUID{0x1b, 0x09, 0x5e, 0xb1, 0x0e, 0xc9, 0x0d, 0x4f, 0x81, 0xe4, 0xbb, 0x32, 0xa2, 0xda, 0x68, 0xfa}: "OemCloudBootInterfaceDxe",
		efi.GUID{0x1b, 0x0a, 0xde, 0xfe, 0xa2, 0xbc, 0x9f, 0x4a, 0xbb, 0x2b, 0xd9, 0xfd, 0x7d, 0xec, 0x2e, 0x9f}: "StatusCodeRuntimeDxe",
		efi.GUID{0x1b, 0x13, 0xe9, 0xbf, 0x64, 0x0f, 0x0f, 0x4d, 0x94, 0xa4, 0x0d, 0x83, 0x0d, 0xb9, 0x28, 0xa3}: "MeSmmProtocolThunk",
		efi.GUID{0x1b, 0x18, 0xb1, 0xb5, 0xee, 0xac, 0xc7, 0x4c, 0x86, 0x6f, 0x9d, 0x8d, 0xfd, 0x27, 0xb3, 0x99}: "LenovoEventLogVariableStoreDxe",
		efi.GUID{0x1b, 0x19, 0x0e, 0x95, 0x24, 0x85, 0x51, 0x4f, 0x80, 0xa1, 0x5c, 0x4f, 0x1b, 0x03, 0xf3, 0x5c}: "PeiSha256HashPpiGuid",
		efi.GUID{0x1b, 0x19, 0x68, 0x5a, 0x97, 0x9b, 0x52, 0x47, 0x99, 0x46, 0xe3, 0x6a, 0x5d, 0xa9, 0x42, 0xb1}: "EfiPrimaryStandardErrorDevice",
		efi.GUID{0x1b, 0x19, 0xd3, 0xc5, 0xd5, 0x27, 0x73, 0x48, 0x8d, 0xf2, 0x62, 0x81, 0x36, 0x99, 0x1a, 0x21}: "UserIdentifyManager",
		efi.GUID{0x1b, 0x23, 0x29, 0x00, 0xef, 0x72, 0xa5, 0x4f, 0xbd, 0x37, 0x70, 0x18, 0xa0, 0x46, 0xfb, 0x0d}: "LenovoMultipleKeyboardService",
		efi.GUID{0x1b, 0x2d, 0xbe, 0xeb, 0x47, 0x16, 0xda, 0x4b, 0xab, 0x9a, 0x78, 0x63, 0xe3, 0x96, 0xd4, 0x1a}: "EfiActiveBiosProtocolGuid",
		efi.GUID{0x1b, 0x30, 0x2d, 0x2b, 0x3d, 0xea, 0x37, 0x42, 0x8b, 0x52, 0x93, 0x35, 0xa7, 0xa0, 0x30, 0xba}: "IioCfgUpdateDxeCLX64L",
		efi.GUID{0x1b, 0x3b, 0x91, 0x05, 0x0c, 0xdb, 0x79, 0x46, 0x94, 0xb1, 0xf8, 0xaa, 0x09, 0xb4, 0xa9, 0x71}: "FjPcieCardReaderRTS5250",
		efi.GUID{0x1b, 0x3b, 0xf4, 0xd6, 0x21, 0x0f, 0x2b, 0x46, 0xb8, 0xb7, 0xa0, 0x33, 0xc3, 0xeb, 0x42, 0x61}: "BaseMemoryLibOptPei",
		efi.GUID{0x1b, 0x3d, 0x7a, 0xf8, 0xc3, 0xb0, 0xb6, 0x44, 0xb4, 0x70, 0xf4, 0xf4, 0xc0, 0x9c, 0x11, 0x0c}: "AsusQuickVgaPei",
		efi.GUID{0x1b, 0x4b, 0xe7, 0x34, 0x94, 0x87, 0x02, 0x44, 0xaa, 0x43, 0x99, 0xb5, 0x24, 0x9b, 0x1c, 0xfd}: "DellSbSmm",
		efi.GUID{0x1b, 0x4e, 0x49, 0xd6, 0x6f, 0xe0, 0xb5, 0x4a, 0xb6, 0x4d, 0x48, 0xb2, 0x5a, 0xa9, 0xeb, 0x33}: "SmmCpuPlatformHookLibNull",
		efi.GUID{0x1b, 0x5a, 0xfb, 0x34, 0xcd, 0xe3, 0x93, 0x48, 0x94, 0x03, 0x0a, 0x39, 0xba, 0x62, 0xfd, 0xa0}: "SvSmmSupport",
		efi.GUID{0x1b, 0x62, 0x5d, 0x43, 0x41, 0x3c, 0x36, 0x45, 0xb0, 0xc6, 0xaf, 0x67, 0x05, 0x9f, 0xc4, 0xbe}: "CrashLogDxe",
		efi.GUID{0x1b, 0x65, 0xbd, 0x3f, 0x0b, 0x5f, 0xaf, 0x47, 0xbe, 0x25, 0xae, 0x35, 0xc6, 0x3c, 0x8d, 0x5c}: "AmiCpmWrapperPei",
		efi.GUID{0x1b, 0x65, 0xbd, 0x3f, 0x0b, 0x5f, 0xaf, 0x47, 0xbe, 0x25, 0xae, 0x35, 0xc6, 0x3c, 0x8d, 0x5d}: "AmiCpmWrapperPei",
		efi.GUID{0x1b, 0x66, 0x98, 0x13, 0xb6, 0x1e, 0x7b, 0x41, 0x84, 0x8e, 0xcc, 0xc3, 0x88, 0x52, 0x60, 0x99}: "IntelUndiDxe",
		efi.GUID{0x1b, 0x67, 0xce, 0x7d, 0x23, 0xc2, 0x6a, 0x44, 0xa7, 0x05, 0xed, 0x63, 0x7a, 0xaf, 0x67, 0x71}: "EdkiiCryptoPpi",
		efi.GUID{0x1b, 0x71, 0xdb, 0x83, 0xac, 0xad, 0xb3, 0x46, 0xbb, 0xff, 0x5e, 0x6e, 0x28, 0xcf, 0xfb, 0xd2}: "DellWlanSmm",
		efi.GUID{0x1b, 0x7b, 0xe6, 0xef, 0x77, 0xbc, 0xb9, 0x4b, 0xa5, 0x70, 0x7f, 0x8d, 0xd8, 0x58, 0x50, 0x6d}: "ICE30plusPEI",
		efi.GUID{0x1b, 0x7f, 0x5c, 0xfe, 0x56, 0xe2, 0xa8, 0x47, 0x8f, 0x1e, 0x94, 0x78, 0x10, 0x7c, 0x78, 0x75}: "AmtInitDxe",
		efi.GUID{0x1b, 0x8b, 0x29, 0x71, 0xaa, 0x26, 0xd8, 0x44, 0x87, 0xcd, 0x91, 0xa0, 0x87, 0xc3, 0x48, 0x1a}: "SmbiosDataUpdateDxeLightningRidgeEXECB3",
		efi.GUID{0x1b, 0x92, 0x35, 0xb8, 0x04, 0xfd, 0x2e, 0x41, 0x97, 0x48, 0x98, 0x89, 0x88, 0x1b, 0x75, 0xb2}: "AmiI2cHid",
		efi.GUID{0x1b, 0x93, 0x2e, 0xec, 0x81, 0x32, 0xa5, 0x48, 0x81, 0x07, 0xdf, 0x8a, 0x8b, 0xed, 0x3c, 0x5d}: "PlatformGOPPolicyGuid",
		efi.GUID{0x1b, 0x93, 0x99, 0xa7, 0xb0, 0xfd, 0xb2, 0x40, 0x8a, 0x25, 0xd2, 0x6b, 0x58, 0x88, 0x53, 0x79}: "AmdSocAm4BrPei",
		efi.GUID{0x1b, 0x94, 0x21, 0xf9, 0x8e, 0x70, 0xcd, 0x4b, 0x98, 0xfa, 0x52, 0x5e, 0x4a, 0x9d, 0xcd, 0x55}: "RtkUsbUndiDriver",
		efi.GUID{0x1b, 0x98, 0x24, 0xe7, 0x75, 0x28, 0x8a, 0x4c, 0x9f, 0x9a, 0x02, 0xae, 0xc1, 0x96, 0x50, 0x16}: "AsusModuleToIntSmmWrapper",
		efi.GUID{0x1b, 0xa0, 0xb4, 0xfb, 0x7e, 0x94, 0x82, 0x4d, 0xb2, 0x7d, 0x1e, 0x20, 0x7c, 0x07, 0x00, 0x53}: "BaseCacheAsRamLibNull",
		efi.GUID{0x1b, 0xa9, 0x4b, 0xb1, 0xd9, 0xcc, 0xf9, 0x4c, 0x8f, 0xf3, 0xbd, 0x15, 0x9d, 0xde, 0x76, 0x0c}: "FjScrtyBootService",
		efi.GUID{0x1b, 0xab, 0xb8, 0x32, 0xe3, 0x07, 0x42, 0x4b, 0x8e, 0xe7, 0x02, 0x90, 0x2a, 0x29, 0x3b, 0xcc}: "AmdFchWheaDxe",
		efi.GUID{0x1b, 0xac, 0x14, 0xad, 0x15, 0xda, 0xe5, 0x4c, 0xa7, 0xe2, 0x1f, 0x54, 0x37, 0xed, 0xb4, 0xb3}: "SmbiosMemory",
		efi.GUID{0x1b, 0xac, 0x4a, 0x2d, 0xa5, 0x91, 0xd5, 0x4c, 0x9b, 0x5c, 0xb4, 0x0f, 0x5d, 0x28, 0x51, 0xa1}: "SpiFlashInfo",
		efi.GUID{0x1b, 0xb1, 0xa5, 0xdb, 0x86, 0x86, 0xdd, 0x43, 0x88, 0x50, 0x85, 0x4f, 0xd3, 0xd4, 0xb2, 0x44}: "AsusFirstBootSetting",
		efi.GUID{0x1b, 0xbe, 0x0f, 0x5f, 0x73, 0x16, 0xd2, 0x4f, 0x9b, 0xdd, 0x31, 0xd7, 0x90, 0x9d, 0x51, 0x61}: "AmdNbioBaseRnPei",
		efi.GUID{0x1b, 0xc7, 0xa4, 0x53, 0x81, 0xb5, 0x70, 0x41, 0x91, 0xb3, 0x8d, 0xb8, 0x7a, 0x4b, 0x5c, 0x46}: "EfiFvbExtensionProtocol",
		efi.GUID{0x1b, 0xca, 0x5d, 0xa8, 0x8f, 0x19, 0x14, 0x4e, 0xa6, 0x73, 0x87, 0x42, 0x64, 0x68, 0x7e, 0x85}: "DataSink",
		efi.GUID{0x1b, 0xd3, 0xd3, 0x0a, 0xd8, 0xb3, 0x06, 0x45, 0xae, 0x71, 0x2e, 0xf1, 0x10, 0x06, 0xd9, 0x0f}: "UefiAcpiBoardInfoGuid",
		efi.GUID{0x1b, 0xd6, 0x4e, 0xfb, 0x22, 0x20, 0x8a, 0x42, 0x87, 0x15, 0x9d, 0x8f, 0x02, 0x9d, 0xda, 0x4c}: "RtkUndiDxe",
		efi.GUID{0x1b, 0xd7, 0xe1, 0x9f, 0x91, 0x3f, 0x03, 0x41, 0xae, 0x62, 0x3f, 0xee, 0xca, 0x4d, 0x2b, 0xaa}: "SpiFlash",
		efi.GUID{0x1b, 0xe0, 0x41, 0xdb, 0xb0, 0xa8, 0x15, 0x4e, 0xb6, 0x19, 0x44, 0x63, 0x97, 0x5b, 0x35, 0x7b}: "SetupDataChecksumErr",
		efi.GUID{0x1b, 0xe2, 0xe9, 0xe7, 0x10, 0xaa, 0xf8, 0x46, 0x9e, 0x48, 0x93, 0x0d, 0x2d, 0x88, 0xf6, 0x6b}: "FjSysmanAmphionSmmFjFext",
		efi.GUID{0x1b, 0xe6, 0x4f, 0x65, 0xdb, 0x2e, 0x40, 0x47, 0xa7, 0x6b, 0x56, 0xed, 0x7a, 0xde, 0x1c, 0xbf}: "PowerLossFun",
		efi.GUID{0x1b, 0xff, 0x35, 0xf9, 0xf0, 0xaf, 0xf3, 0x40, 0xb7, 0x7a, 0xb7, 0x95, 0xa7, 0xa7, 0xd7, 0x14}: "DellPhysicalPresenceSmm",
		efi.GUID{0x1c, 0x1a, 0x1c, 0xbd, 0xec, 0x04, 0xed, 0x47, 0x8a, 0xb7, 0xd1, 0x93, 0x19, 0xc6, 0x41, 0x38}: "FastBoot",
		efi.GUID{0x1c, 0x1d, 0xea, 0x9b, 0x30, 0xd1, 0xff, 0x42, 0xbb, 0xfb, 0x1b, 0x9d, 0xa3, 0x93, 0x3d, 0xdd}: "SecureBioXhci",
		efi.GUID{0x1c, 0x21, 0xc9, 0xa9, 0x14, 0x7b, 0xa9, 0x4d, 0xa1, 0x4f, 0x3a, 0xf7, 0x45, 0x1c, 0xc0, 0xf8}: "BiosUpdateExtendedPlatformPolicySmm",
		efi.GUID{0x1c, 0x21, 0xcb, 0xa4, 0x43, 0x3e, 0x75, 0x47, 0xbf, 0x1a, 0x8c, 0xec, 0xe3, 0x6e, 0x79, 0x3b}: "AaeonLanByPassPkg",
		efi.GUID{0x1c, 0x27, 0x80, 0x24, 0xc6, 0x09, 0x36, 0x4f, 0xad, 0x75, 0x5e, 0x13, 0x90, 0xbd, 0x99, 0x29}: "QNCSmmDispatcher",
		efi.GUID{0x1c, 0x28, 0x59, 0xb8, 0xfa, 0x16, 0xa8, 0x45, 0x92, 0x01, 0x1c, 0x38, 0x30, 0xa9, 0x73, 0xbd}: "GecUpdateSMI",
		efi.GUID{0x1c, 0x34, 0x33, 0x6c, 0x4c, 0xba, 0xb4, 0x4d, 0x9b, 0xd6, 0x63, 0x56, 0x97, 0x1d, 0xec, 0xef}: "FjDisableManufacturingMode",
		efi.GUID{0x1c, 0x36, 0x1e, 0x2d, 0x3f, 0x7b, 0x15, 0x4d, 0x8b, 0x1f, 0x66, 0xe5, 0x51, 0xfa, 0xbd, 0xc7}: "SaLateInitSmm",
		efi.GUID{0x1c, 0x3c, 0xc7, 0x87, 0x29, 0x15, 0xf5, 0x4e, 0xa3, 0xfa, 0x08, 0xd7, 0x3e, 0xf8, 0xc8, 0x27}: "DellSmmSioDash",
		efi.GUID{0x1c, 0x3e, 0x93, 0xae, 0x47, 0xcc, 0x38, 0x4e, 0x8f, 0x0e, 0xe2, 0xf6, 0x1d, 0x26, 0x05, 0xdf}: "EfiPeiSmmCommunicationPpiGuid",
		efi.GUID{0x1c, 0x41, 0xc9, 0xe4, 0x68, 0x12, 0x4c, 0x40, 0x9e, 0x90, 0x25, 0x73, 0xef, 0x04, 0xf4, 0x3f}: "StaticSkuDataDxeNeonCityEPECB",
		efi.GUID{0x1c, 0x4b, 0x6a, 0x38, 0xe4, 0xdd, 0xc5, 0x4f, 0x9b, 0x03, 0x9c, 0x92, 0x8f, 0xcc, 0x6f, 0xd2}: "gear1",
		efi.GUID{0x1c, 0x52, 0x6a, 0x2e, 0x97, 0xf6, 0x2d, 0x40, 0x97, 0x74, 0x98, 0xb2, 0xb7, 0xe1, 0x40, 0xf3}: "PlatformType",
		efi.GUID{0x1c, 0x5c, 0x75, 0x93, 0x15, 0xbe, 0x5a, 0x4d, 0xbf, 0x95, 0x5f, 0x97, 0x53, 0x85, 0x3c, 0xb6}: "FileSelectUIDxe",
		efi.GUID{0x1c, 0x63, 0xa4, 0x41, 0x02, 0xbb, 0xaf, 0x45, 0xbe, 0xdd, 0xae, 0xdc, 0x56, 0xe5, 0x3e, 0x79}: "SuperMPei",
		efi.GUID{0x1c, 0x65, 0x8d, 0xc4, 0x0e, 0x9d, 0xe7, 0x4c, 0xad, 0x39, 0xed, 0xd1, 0xab, 0x83, 0x6b, 0x30}: "AmiTseAfterFirstBootOptionGuid",
		efi.GUID{0x1c, 0x68, 0x6a, 0x21, 0x51, 0x9e, 0x5f, 0x41, 0x9a, 0xda, 0xcb, 0x9f, 0xbc, 0xd0, 0x5f, 0x5d}: "DellFlashIoDxe",
		efi.GUID{0x1c, 0x68, 0x97, 0xda, 0xe3, 0xa9, 0x09, 0x42, 0xa9, 0xd5, 0xf9, 0xe9, 0x81, 0x52, 0xf3, 0x9a}: "ClearChassisIntrusion",
		efi.GUID{0x1c, 0x6b, 0x86, 0x75, 0x5f, 0x3f, 0x01, 0x4c, 0x92, 0x9d, 0xce, 0xa4, 0x0f, 0x1f, 0x67, 0x10}: "FjIbvSfuPolicyAbstractionSmmProtocol",
		efi.GUID{0x1c, 0x6c, 0x9b, 0x98, 0xe1, 0x6f, 0x4e, 0xd6, 0xa2, 0x92, 0x13, 0x13, 0xc4, 0x10, 0xf0, 0xf2}: "Ip4Config",
		efi.GUID{0x1c, 0x71, 0xad, 0x1b, 0x51, 0xd4, 0x41, 0x42, 0xb1, 0xf3, 0x85, 0x37, 0x81, 0x2e, 0x0c, 0x70}: "EfiMeBiosExtensionSetup",
		efi.GUID{0x1c, 0x72, 0x6e, 0x84, 0x36, 0xe0, 0x2f, 0x4f, 0x90, 0xa6, 0x80, 0x94, 0x91, 0x7f, 0xb0, 0x77}: "NvmePciHcPei",
		efi.GUID{0x1c, 0x78, 0xcc, 0x6f, 0xa7, 0x27, 0x8e, 0x4a, 0xb4, 0xd1, 0xe7, 0x0f, 0x23, 0x5f, 0x4f, 0xcf}: "PlatformPciDxe",
		efi.GUID{0x1c, 0x82, 0xab, 0x87, 0xb8, 0x79, 0xf6, 0x4e, 0xa9, 0x13, 0x21, 0xd2, 0x20, 0x63, 0xf5, 0x5f}: "AcpiPlatform",
		efi.GUID{0x1c, 0x82, 0xaf, 0x51, 0xaf, 0xad, 0xbc, 0x4a, 0x9f, 0xbf, 0x26, 0xcd, 0x52, 0x45, 0xba, 0x22}: "DellSmmGpioControlProtocol",
		efi.GUID{0x1c, 0x86, 0x5f, 0xbc, 0xed, 0x86, 0x7e, 0x41, 0xbb, 0x7b, 0x6c, 0x02, 0x6b, 0xcd, 0x75, 0x5b}: "EfiFrbCodeProtocol",
		efi.GUID{0x1c, 0x86, 0x5f, 0xbc, 0xed, 0x86, 0x7e, 0x41, 0xbb, 0x7b, 0x6c, 0x02, 0x6b, 0xdc, 0x65, 0x23}: "EfiSelStatusCodeProtocol",
		efi.GUID{0x1c, 0x8b, 0x7a, 0x66, 0x97, 0x9c, 0x2a, 0x4b, 0xae, 0x7e, 0x56, 0x87, 0x72, 0xfe, 0x45, 0xf3}: "BaseResetSystemLibNull",
		efi.GUID{0x1c, 0x95, 0x3d, 0xe3, 0xe8, 0xeb, 0x4c, 0x47, 0xaf, 0xaa, 0x21, 0xac, 0x65, 0xaa, 0x76, 0x8f}: "LEMBootModeFlagDxe",
		efi.GUID{0x1c, 0xa0, 0x7e, 0x01, 0x88, 0x49, 0xd9, 0x4c, 0x8a, 0x6c, 0x34, 0x80, 0xe3, 0x86, 0xa3, 0x25}: "LegacyStr",
		efi.GUID{0x1c, 0xa1, 0x84, 0x42, 0xc1, 0x18, 0x10, 0x4c, 0xb2, 0xd9, 0x58, 0x6a, 0x01, 0x60, 0xa5, 0x23}: "EfiPeiPlatformTypeLightningRidgeExecB4Ppi",
		efi.GUID{0x1c, 0xa6, 0xe4, 0x79, 0x73, 0xed, 0x12, 0x43, 0x94, 0xfe, 0xe3, 0xe7, 0x56, 0x33, 0x62, 0xa9}: "PrintDxe",
		efi.GUID{0x1c, 0xab, 0x69, 0x61, 0x5f, 0xb0, 0x9c, 0x4d, 0xaf, 0xea, 0x19, 0x29, 0x11, 0xe4, 0x1c, 0xe2}: "AmdPspSmmV2",
		efi.GUID{0x1c, 0xbd, 0x95, 0xb2, 0xe3, 0x63, 0xe3, 0x48, 0xb2, 0x65, 0xf7, 0xdf, 0xa2, 0x07, 0x01, 0x23}: "AmiMultiLanSupportProtocolGuid",
		efi.GUID{0x1c, 0xc1, 0x6e, 0x99, 0x97, 0x53, 0x73, 0x4e, 0xb5, 0x8f, 0x82, 0x7e, 0x52, 0x90, 0x6d, 0xef}: "EfiVectorHandoffTableGuid",
		efi.GUID{0x1c, 0xc1, 0xff, 0x87, 0xab, 0xd0, 0x12, 0x4d, 0xa7, 0x79, 0x0a, 0x54, 0x74, 0x05, 0x07, 0x59}: "OemProtocol",
		efi.GUID{0x1c, 0xc5, 0x35, 0x72, 0x80, 0x0c, 0xab, 0x4c, 0x87, 0xac, 0x3b, 0x08, 0x4a, 0x63, 0x04, 0xb1}: "OvmfPlatformConfigGuid",
		efi.GUID{0x1c, 0xc5, 0x93, 0x54, 0xc8, 0x79, 0x2e, 0x4c, 0x97, 0x58, 0x1d, 0xb5, 0xb5, 0x2b, 0x13, 0xb7}: "DellSmmNbDockProtocol",
		efi.GUID{0x1c, 0xce, 0x97, 0x66, 0xb6, 0xd9, 0x35, 0x45, 0xb6, 0x61, 0x8b, 0x73, 0x1b, 0xff, 0x04, 0x08}: "SmbiosType2",
		efi.GUID{0x1c, 0xe6, 0x4f, 0x65, 0xdc, 0x2e, 0x41, 0x47, 0xa7, 0x6c, 0x56, 0xed, 0x7a, 0xde, 0x1c, 0xb0}: "RTCSingleWakeUpInPei",
		efi.GUID{0x1c, 0xe6, 0x98, 0xd3, 0x9c, 0x2a, 0x6d, 0x4a, 0xb2, 0x65, 0x47, 0x69, 0x6c, 0xf9, 0xe4, 0x42}: "ASUSFS2",
		efi.GUID{0x1c, 0xee, 0x7c, 0x09, 0xf0, 0xa7, 0xcb, 0x40, 0xab, 0x0d, 0xf0, 0x77, 0x4a, 0xe9, 0x0e, 0x2b}: "FjSetupPower",
		efi.GUID{0x1c, 0xf2, 0x58, 0x50, 0x34, 0xbc, 0xd4, 0x11, 0xbd, 0x18, 0x00, 0x80, 0xc7, 0x3c, 0x88, 0x81}: "Fat2",
		efi.GUID{0x1c, 0xf2, 0xba, 0x4b, 0xad, 0x98, 0x1e, 0x42, 0xb5, 0x3c, 0x9e, 0xc2, 0xe8, 0xa8, 0x7a, 0x29}: "AmdPlatformRasRsPei",
		efi.GUID{0x1c, 0xf7, 0xa0, 0x6e, 0x4a, 0x61, 0x7e, 0x43, 0x8f, 0x49, 0x24, 0x3a, 0xd4, 0xe8, 0x32, 0x68}: "Emul6064TrapProtocolGuid",
		efi.GUID{0x1c, 0xf8, 0x05, 0x5a, 0x65, 0xc4, 0x6f, 0x4c, 0x92, 0x46, 0xbf, 0xcc, 0x37, 0x53, 0x4b, 0x88}: "BatteryInfo",
		efi.GUID{0x1d, 0x10, 0x85, 0xfb, 0x22, 0xf4, 0x8c, 0x4c, 0x82, 0xc4, 0xef, 0x4d, 0xcd, 0x05, 0xe1, 0xbf}: "SmcSmBios",
		efi.GUID{0x1d, 0x12, 0xbe, 0xfd, 0xb4, 0x3e, 0x95, 0x4f, 0xa2, 0x94, 0xb3, 0x79, 0x4d, 0x17, 0x7f, 0xeb}: "DellECZPODD",
		efi.GUID{0x1d, 0x17, 0x7f, 0x72, 0xc0, 0x99, 0xf7, 0x42, 0x8d, 0x1a, 0xa6, 0x13, 0x90, 0xaf, 0x5b, 0xb1}: "AbsoluteDxe",
		efi.GUID{0x1d, 0x3a, 0x3f, 0xd0, 0x8e, 0x08, 0xc8, 0x46, 0xa9, 0xfb, 0x82, 0x09, 0x77, 0x0f, 0x2c, 0xe2}: "ChipsetPlatformLibServicesDxe",
		efi.GUID{0x1d, 0x3e, 0xe9, 0x2f, 0x04, 0x1d, 0x8f, 0x43, 0xa0, 0xf9, 0xa8, 0x4d, 0x78, 0x1a, 0x7c, 0x57}: "EF_Allocator",
		efi.GUID{0x1d, 0x3f, 0xf2, 0x6f, 0x7c, 0x87, 0x1b, 0x4b, 0x93, 0xfc, 0xf1, 0x42, 0xb2, 0xee, 0xa6, 0xa7}: "EfiGopDisplayBrightnessProtocolGuid",
		efi.GUID{0x1d, 0x4a, 0x7d, 0x30, 0xd8, 0xdd, 0x2f, 0x4e, 0xac, 0x68, 0xd8, 0xb2, 0x13, 0xc1, 0x98, 0xfe}: "BiosAuditLogHandlerDxe",
		efi.GUID{0x1d, 0x59, 0x13, 0x42, 0xef, 0xce, 0x5f, 0x42, 0x91, 0x5b, 0xae, 0x45, 0x59, 0x68, 0x0f, 0x62}: "XnoteSystemSetupDxe",
		efi.GUID{0x1d, 0x5d, 0x8c, 0xa5, 0x2b, 0xc2, 0x45, 0x48, 0x90, 0xbc, 0x8c, 0x94, 0xfc, 0xe9, 0x64, 0x57}: "FastBootOption",
		efi.GUID{0x1d, 0x61, 0xee, 0xee, 0x8f, 0xf7, 0xb9, 0x4f, 0xb8, 0x68, 0x55, 0x90, 0x7f, 0x16, 0x92, 0x80}: "PlatformInitPreMem",
		efi.GUID{0x1d, 0x63, 0x5c, 0x3c, 0x95, 0x79, 0x15, 0x44, 0x8b, 0x16, 0x9f, 0x4a, 0x8a, 0xd3, 0x6f, 0xcf}: "Int10ToSmi",
		efi.GUID{0x1d, 0x66, 0xae, 0x25, 0x52, 0x36, 0x67, 0x47, 0xa8, 0x00, 0x2c, 0x3d, 0x03, 0xf4, 0x09, 0x7a}: "Armani_ProductInfoSmm",
		efi.GUID{0x1d, 0x6a, 0x0f, 0x2e, 0x8e, 0xb0, 0x6d, 0x45, 0x88, 0x15, 0x77, 0xae, 0xf3, 0x9d, 0x49, 0x41}: "OemSlic",
		efi.GUID{0x1d, 0x6d, 0x21, 0x6b, 0x32, 0x5d, 0xfd, 0x41, 0x96, 0x98, 0x6f, 0x8e, 0x58, 0x19, 0x94, 0x54}: "FlashInfoSmm",
		efi.GUID{0x1d, 0x71, 0x9c, 0x86, 0x9c, 0x64, 0xfe, 0x44, 0x8b, 0x9e, 0x2c, 0xbb, 0x29, 0x11, 0xc3, 0xe6}: "EfiPeiDelayedDispatchPpi",
		efi.GUID{0x1d, 0x74, 0xc4, 0x87, 0xf4, 0xce, 0xa1, 0x48, 0x89, 0xaa, 0x7f, 0x86, 0xef, 0xa0, 0xa2, 0x1a}: "MediaCapsuleEarly",
		efi.GUID{0x1d, 0x75, 0xc9, 0x90, 0x74, 0xfa, 0xa6, 0x4e, 0x8c, 0x4b, 0xf4, 0x4d, 0x2b, 0xe8, 0xcd, 0x48}: "FmpDxe",
		efi.GUID{0x1d, 0x76, 0xe4, 0x39, 0x39, 0xff, 0x03, 0x46, 0xb7, 0xa6, 0xb5, 0xa5, 0xce, 0xe1, 0xc9, 0xf2}: "Lily_RTLWlanDxe",
		efi.GUID{0x1d, 0x79, 0xe6, 0xc1, 0x5b, 0xf3, 0xef, 0x43, 0x92, 0x0a, 0xbe, 0x06, 0xba, 0x7f, 0x86, 0xa1}: "AmiTcgPlatformPpiBeforeMem",
		efi.GUID{0x1d, 0x7b, 0x4d, 0xa7, 0x93, 0x03, 0xd7, 0x40, 0x9a, 0xb2, 0x0a, 0xe3, 0x6c, 0xf3, 0xf1, 0xe8}: "TraceHubPostCodeHandlerPei",
		efi.GUID{0x1d, 0x7b, 0x7d, 0x8f, 0x1c, 0x0e, 0x98, 0x4c, 0xb1, 0x2e, 0x4e, 0xc9, 0x9c, 0x40, 0x81, 0xac}: "EmptyApplication",
		efi.GUID{0x1d, 0x85, 0x24, 0xae, 0x14, 0xe4, 0x62, 0x40, 0x95, 0x9d, 0x5f, 0x43, 0xea, 0x99, 0x36, 0x3c}: "DellAudioDxe",
		efi.GUID{0x1d, 0x8b, 0xbf, 0x3b, 0x2d, 0x4b, 0x02, 0x86, 0x6c, 0xc2, 0xc7, 0x81, 0xba, 0xce, 0xba, 0xc8}: "Pca9535aDxe",
		efi.GUID{0x1d, 0x8d, 0x84, 0x24, 0x37, 0xa6, 0xdd, 0x45, 0x97, 0x4f, 0xbe, 0xba, 0x03, 0x40, 0xff, 0x96}: "RemotePlatformErase",
		efi.GUID{0x1d, 0x91, 0xfa, 0xdc, 0xeb, 0x26, 0x9f, 0x46, 0xa2, 0x20, 0x38, 0xb7, 0xdc, 0x46, 0x12, 0x20}: "EfiMemoryAttributesTableGuid",
		efi.GUID{0x1d, 0x93, 0x23, 0x47, 0xad, 0xf8, 0xbf, 0x45, 0xac, 0x1f, 0x92, 0x9f, 0x7b, 0xa8, 0x8e, 0x7f}: "ValidateExtendedBiosRegionDxe",
		efi.GUID{0x1d, 0x9a, 0x74, 0x5f, 0x00, 0x95, 0xce, 0x48, 0xa4, 0x1f, 0xd0, 0xf2, 0xf7, 0x1d, 0xef, 0x8c}: "AmdSocAm4BrDxe",
		efi.GUID{0x1d, 0x9e, 0x1e, 0x9d, 0xbe, 0xb7, 0xe4, 0x4a, 0xb6, 0xa2, 0x0b, 0x05, 0x54, 0x4a, 0x41, 0x22}: "Mctp",
		efi.GUID{0x1d, 0xa0, 0x4a, 0x73, 0xec, 0x95, 0xb7, 0x45, 0xa2, 0x3a, 0x2d, 0x86, 0xd8, 0xfd, 0xeb, 0xb6}: "AmiTcgStorageSecurityInitProtocol",
		efi.GUID{0x1d, 0xa7, 0x04, 0x92, 0x50, 0x20, 0xb7, 0x4a, 0xad, 0x42, 0x74, 0x9c, 0xf9, 0xad, 0xb4, 0xeb}: "Lpc47N20x",
		efi.GUID{0x1d, 0xb3, 0x87, 0xbb, 0x66, 0xf3, 0xe9, 0x47, 0x88, 0x5e, 0xe8, 0x16, 0xb0, 0x9b, 0x97, 0xb6}: "DellAlertStandardFormatSmm",
		efi.GUID{0x1d, 0xbd, 0x8f, 0x60, 0xe1, 0x15, 0xc4, 0x40, 0x94, 0x43, 0x66, 0x2e, 0xcc, 0x0c, 0x07, 0xaa}: "DxeOemDriver",
		efi.GUID{0x1d, 0xc8, 0x65, 0xf6, 0xde, 0xef, 0x5f, 0x4b, 0x88, 0xe8, 0x21, 0x60, 0xb7, 0x48, 0xd2, 0xb4}: "DellVideoConfigPei",
		efi.GUID{0x1d, 0xd9, 0xdb, 0x00, 0xe9, 0x55, 0x0f, 0x42, 0x96, 0x39, 0x5e, 0x9f, 0x84, 0x37, 0xb4, 0x4f}: "EfiExtendedSalStatusCodeServicesProtocolGuid",
		efi.GUID{0x1d, 0xdc, 0xa2, 0x46, 0x2a, 0x6d, 0x58, 0x45, 0xbc, 0x0e, 0x86, 0xb4, 0xb5, 0x4b, 0x42, 0x36}: "OemCustomizeCsm16Config",
		efi.GUID{0x1d, 0xdc, 0xd7, 0xbf, 0xf1, 0x24, 0xd9, 0x40, 0x82, 0xe7, 0x2e, 0x09, 0xbb, 0x6b, 0x4e, 0xbe}: "EfiDriverConfiguration2ProtocolGuid",
		efi.GUID{0x1d, 0xdf, 0x8c, 0x2f, 0xe6, 0x80, 0xf0, 0x4f, 0x95, 0xdb, 0x2c, 0x3e, 0x07, 0x1a, 0x17, 0x74}: "000_X64",
		efi.GUID{0x1d, 0xe6, 0x17, 0xa8, 0x9a, 0x04, 0x09, 0x45, 0xbe, 0xb0, 0x79, 0xfc, 0xa7, 0x69, 0x62, 0x35}: "PlatformDriOverrideDxe",
		efi.GUID{0x1d, 0xe9, 0x91, 0x32, 0xd9, 0xc5, 0xb7, 0x42, 0xb3, 0xb1, 0x8e, 0xc5, 0x4b, 0x03, 0xf0, 0x43}: "OemPeiSample",
		efi.GUID{0x1d, 0xef, 0xe6, 0x1d, 0x01, 0xdb, 0x27, 0x4c, 0xad, 0x29, 0xc5, 0x82, 0x88, 0x7e, 0x2e, 0x18}: "OemSataInitDxe",
		efi.GUID{0x1d, 0xf1, 0x78, 0xd1, 0x16, 0x87, 0x8e, 0x41, 0xa1, 0x31, 0x96, 0x7d, 0x2a, 0xc4, 0x28, 0x43}: "EdkiiMicrocodePatchHob",
		efi.GUID{0x1e, 0x04, 0xea, 0x49, 0x52, 0x67, 0xca, 0x42, 0xb0, 0xb1, 0x73, 0x44, 0xfe, 0x25, 0x46, 0xb7}: "ArmTimerDxe",
		efi.GUID{0x1e, 0x06, 0x24, 0xba, 0x32, 0xb5, 0x75, 0x43, 0xa5, 0xe4, 0x99, 0xc1, 0xca, 0xe4, 0x5d, 0x18}: "EcSecureFlashPei",
		efi.GUID{0x1e, 0x08, 0x87, 0x89, 0xeb, 0xda, 0xa9, 0x44, 0x8b, 0xef, 0xa1, 0x95, 0xb2, 0x2d, 0x94, 0x17}: "BasePciLibPciExpress",
		efi.GUID{0x1e, 0x09, 0x82, 0x4e, 0xa1, 0x32, 0x89, 0x46, 0x8a, 0x00, 0xcd, 0xe4, 0x1e, 0xd6, 0x3c, 0xdd}: "SioDxeInit",
		efi.GUID{0x1e, 0x0b, 0xac, 0x67, 0xc2, 0x54, 0xa6, 0x41, 0xb5, 0x7e, 0xc2, 0xa3, 0x21, 0x41, 0x6a, 0xbc}: "ActiveBios2",
		efi.GUID{0x1e, 0x19, 0xc0, 0xcd, 0x91, 0x18, 0x19, 0x41, 0x81, 0x7e, 0x0b, 0x6a, 0x36, 0x85, 0xa5, 0x11}: "LenovoSystemBusIsaRtcSmm",
		efi.GUID{0x1e, 0x1b, 0xa7, 0x27, 0xee, 0x73, 0xd6, 0x43, 0xac, 0xe3, 0x52, 0x1a, 0x2d, 0xc5, 0xd0, 0x92}: "RepublishSecPpiPpi",
		efi.GUID{0x1e, 0x20, 0xba, 0x91, 0x21, 0x16, 0xfc, 0x46, 0x82, 0x5a, 0xb0, 0x36, 0x3e, 0xca, 0xd4, 0xbc}: "DellPbaFpDxe",
		efi.GUID{0x1e, 0x22, 0x6c, 0xd2, 0x30, 0x24, 0x8a, 0x4c, 0x91, 0x70, 0x3f, 0xcb, 0x45, 0x00, 0x41, 0x3f}: "TcgEvent2EntryHobGuid",
		efi.GUID{0x1e, 0x25, 0x37, 0xf5, 0xaa, 0x54, 0x6f, 0x4b, 0xa2, 0x04, 0x4d, 0x57, 0x7f, 0x6d, 0x50, 0xc8}: "SpiInitPei",
		efi.GUID{0x1e, 0x2e, 0xdc, 0xfd, 0xa9, 0x33, 0xa6, 0x40, 0xa2, 0x32, 0x21, 0xd6, 0x4b, 0x36, 0x22, 0xe8}: "SmiVariableInstallInt15Dxe",
		efi.GUID{0x1e, 0x38, 0x48, 0x09, 0x3d, 0x0b, 0xa9, 0x43, 0x8e, 0x03, 0xf2, 0x48, 0x9f, 0x2b, 0x9e, 0x2e}: "FchSmmDispatcher",
		efi.GUID{0x1e, 0x38, 0xa4, 0xca, 0x0c, 0x75, 0x70, 0x47, 0xb8, 0x70, 0x7a, 0x23, 0xb4, 0xe4, 0x21, 0x30}: "EfiHashAlgorithmSha512Guid",
		efi.GUID{0x1e, 0x48, 0xa2, 0x26, 0x24, 0x44, 0xa2, 0x46, 0x99, 0x43, 0xcc, 0x40, 0x39, 0xea, 0xd8, 0xf8}: "S3Save",
		efi.GUID{0x1e, 0x4d, 0x7d, 0x8c, 0xad, 0x98, 0xee, 0x4c, 0x84, 0x83, 0xdd, 0x70, 0x05, 0x00, 0x25, 0x44}: "ProjectPEI",
		efi.GUID{0x1e, 0x55, 0xbb, 0xb5, 0xa7, 0xf2, 0xb9, 0x43, 0x81, 0x3a, 0xf7, 0x7d, 0xd8, 0x09, 0x00, 0xf5}: "HpCertificateManagerDriver",
		efi.GUID{0x1e, 0x69, 0xed, 0xdd, 0x95, 0x04, 0xdb, 0x45, 0xad, 0xff, 0xd6, 0x84, 0x52, 0xc9, 0xa5, 0xa4}: "Float",
		efi.GUID{0x1e, 0x73, 0xed, 0x38, 0x1b, 0x6a, 0x1b, 0x44, 0xbf, 0x97, 0xa7, 0x85, 0x4c, 0x4a, 0x2b, 0x7f}: "EgsFhfPolicyOverridePei",
		efi.GUID{0x1e, 0x7c, 0x16, 0xcd, 0x0b, 0x6e, 0xb3, 0x42, 0x82, 0xf6, 0xe3, 0xe9, 0x06, 0x19, 0x98, 0x10}: "FspReadyForNotifyPhasePpi",
		efi.GUID{0x1e, 0x7f, 0x63, 0xfc, 0xda, 0x50, 0x13, 0x40, 0x92, 0x4d, 0xc5, 0x31, 0xf1, 0xdf, 0xf3, 0x8b}: "GopConfig",
		efi.GUID{0x1e, 0x8b, 0x84, 0xa6, 0xa6, 0x73, 0x9c, 0x42, 0x9b, 0x1c, 0xc9, 0x52, 0x86, 0x07, 0x72, 0x5d}: "BoardDPTF",
		efi.GUID{0x1e, 0x8d, 0x53, 0x55, 0xc5, 0xb4, 0xd5, 0x4b, 0xb5, 0x94, 0x9b, 0x5b, 0xa9, 0x77, 0x4f, 0x1e}: "AodSetupDxe",
		efi.GUID{0x1e, 0x95, 0xfa, 0x67, 0xa2, 0x4f, 0x4e, 0x9f, 0xa6, 0x58, 0x4d, 0xbd, 0x95, 0x4a, 0xc2, 0x2e}: "HpSmbiosDxe",
		efi.GUID{0x1e, 0xa9, 0x2b, 0x44, 0xa8, 0xb0, 0x9f, 0x49, 0x94, 0xf7, 0x2e, 0x92, 0x2c, 0x9a, 0xae, 0x0d}: "AodDxe",
		efi.GUID{0x1e, 0xa9, 0xca, 0xd0, 0xe4, 0x2d, 0x0d, 0x4b, 0xb3, 0xdc, 0x09, 0xc6, 0x7e, 0x85, 0x4e, 0x34}: "BiosSnp16",
		efi.GUID{0x1e, 0xab, 0x78, 0x83, 0x47, 0x41, 0x0a, 0x40, 0x8d, 0x84, 0xe3, 0xde, 0x98, 0x1c, 0x04, 0x53}: "TamperResistantBoot",
		efi.GUID{0x1e, 0xaf, 0xee, 0xa7, 0x9f, 0x96, 0xee, 0x40, 0xa2, 0x1e, 0x18, 0x56, 0xf5, 0xe6, 0xd4, 0x1c}: "InstallMSDMTable",
		efi.GUID{0x1e, 0xb1, 0x97, 0x8a, 0x8e, 0xee, 0xe2, 0x11, 0xb6, 0x64, 0x04, 0x7d, 0x7b, 0x99, 0xe0, 0x97}: "AcpiOverride",
		efi.GUID{0x1e, 0xcb, 0xfd, 0x09, 0x8b, 0xe0, 0x64, 0x4b, 0x89, 0x0c, 0x70, 0xe3, 0x17, 0x4b, 0xe0, 0x7a}: "FpgaErrorRecord",
		efi.GUID{0x1e, 0xd0, 0xb8, 0x71, 0x64, 0xd7, 0xc6, 0x4b, 0x9d, 0x02, 0x00, 0x07, 0xf8, 0x38, 0x2f, 0x54}: "FjCmosAccessRt",
		efi.GUID{0x1e, 0xd1, 0x72, 0x2a, 0x76, 0x73, 0xf6, 0x40, 0x9c, 0x68, 0x23, 0xfa, 0x2f, 0xe3, 0x63, 0xf1}: "EfiEbcSimpleDebuggerProtocolGuid",
		efi.GUID{0x1e, 0xd8, 0x04, 0x91, 0xb6, 0x05, 0x54, 0x47, 0xa2, 0xde, 0x7d, 0xb3, 0x42, 0xfe, 0x54, 0x96}: "DellAcpiSharedMemDxe",
		efi.GUID{0x1e, 0xde, 0x26, 0x6b, 0xf2, 0x3d, 0x1d, 0x4a, 0x9b, 0x7f, 0xb8, 0x16, 0xb8, 0xc9, 0x08, 0x72}: "ComputraceSmm",
		efi.GUID{0x1e, 0xe1, 0xc0, 0xa6, 0x9e, 0x92, 0xb3, 0x42, 0x90, 0xcc, 0x4f, 0x77, 0x8e, 0x03, 0xff, 0x57}: "PkpubKey",
		efi.GUID{0x1e, 0xe4, 0x5d, 0x30, 0x19, 0xea, 0x20, 0x4d, 0x9a, 0x93, 0x0e, 0x0d, 0xd4, 0x2a, 0x3f, 0x67}: "Mec5107Pei",
		efi.GUID{0x1e, 0xf4, 0x7e, 0x9a, 0x40, 0xc1, 0xd1, 0x4b, 0xb8, 0x84, 0x1e, 0x11, 0x24, 0x0b, 0x4c, 0xe6}: "PeiPlatformMemorySizePpi",
		efi.GUID{0x1f, 0x16, 0x43, 0x3b, 0xb4, 0xae, 0xec, 0x43, 0x9e, 0x1b, 0x80, 0x50, 0x17, 0x1b, 0x48, 0x99}: "BiosGuardRecoveryHook",
		efi.GUID{0x1f, 0x23, 0x6c, 0xfe, 0x90, 0xc4, 0xb2, 0x41, 0x8a, 0x85, 0x82, 0x6f, 0xc7, 0x76, 0x4a, 0xf0}: "FjVariableSmm",
		efi.GUID{0x1f, 0x24, 0x32, 0xa7, 0x3d, 0x38, 0x9c, 0x4d, 0x8a, 0xe1, 0x8e, 0x09, 0x83, 0x75, 0x89, 0xd7}: "XenBusRootDeviceGuid",
		efi.GUID{0x1f, 0x28, 0x4f, 0xaf, 0x9f, 0x51, 0x39, 0x4a, 0x81, 0x82, 0x4b, 0x05, 0x3d, 0x42, 0x98, 0x74}: "DellTpmBusConfigDxe",
		efi.GUID{0x1f, 0x2f, 0x4f, 0x50, 0xeb, 0xe7, 0xf9, 0x46, 0xaa, 0x07, 0x06, 0x06, 0xf3, 0x11, 0xaa, 0x1a}: "SmmPlatform",
		efi.GUID{0x1f, 0x38, 0xc6, 0xdb, 0x54, 0x55, 0x14, 0x4d, 0x8f, 0xfd, 0x76, 0xd7, 0x87, 0xb8, 0xac, 0xbf}: "IpmiProtocolGuid",
		efi.GUID{0x1f, 0x3c, 0xf0, 0x80, 0xbd, 0x89, 0x40, 0x42, 0x93, 0xa8, 0xac, 0x99, 0xe9, 0xa9, 0x29, 0xfc}: "DellPowerOffConfig",
		efi.GUID{0x1f, 0x45, 0x26, 0x4e, 0x89, 0x19, 0x2e, 0x4e, 0x8d, 0x79, 0x68, 0x94, 0x7f, 0xe8, 0x78, 0xbb}: "SDCardReadOnlyMode",
		efi.GUID{0x1f, 0x50, 0x87, 0xfc, 0x07, 0xf7, 0xa2, 0x49, 0xb6, 0x76, 0x77, 0x71, 0x7d, 0xd9, 0x04, 0xdc}: "SmiCpuDecode",
		efi.GUID{0x1f, 0x54, 0x11, 0xda, 0x41, 0x53, 0x63, 0x47, 0x83, 0x86, 0x38, 0x63, 0x94, 0x39, 0x73, 0xb2}: "I2cInitializeDxe",
		efi.GUID{0x1f, 0x54, 0x89, 0x91, 0x0c, 0xac, 0x68, 0x43, 0x90, 0x62, 0x70, 0xe1, 0x95, 0x7c, 0x34, 0x45}: "EfiVirtualLockstep",
		efi.GUID{0x1f, 0x5a, 0xf4, 0x62, 0x63, 0xb2, 0x59, 0x41, 0xa8, 0xbd, 0xf5, 0x44, 0x27, 0x22, 0x6c, 0xb3}: "TypeAAh",
		efi.GUID{0x1f, 0x69, 0xe7, 0x12, 0xee, 0x1e, 0xd4, 0x4e, 0x87, 0x93, 0x69, 0xe2, 0x80, 0x1d, 0x60, 0x2a}: "LenovoFpPba",
		efi.GUID{0x1f, 0x69, 0xe7, 0x12, 0xee, 0x1e, 0xd4, 0x4e, 0x87, 0x93, 0x69, 0xe2, 0x80, 0x1d, 0x61, 0x23}: "AsixPxe",
		efi.GUID{0x1f, 0x6a, 0xde, 0x7e, 0x8e, 0x54, 0x3e, 0x45, 0xa9, 0x5c, 0x66, 0x93, 0x9f, 0xe0, 0x29, 0x5c}: "SwitchableGraphicsPei",
		efi.GUID{0x1f, 0x6c, 0xa2, 0xd1, 0xf5, 0xab, 0x06, 0x48, 0xbb, 0x24, 0x68, 0xd3, 0x17, 0xe0, 0x71, 0xd5}: "AppleEpidCertificate",
		efi.GUID{0x1f, 0x75, 0x9f, 0x38, 0x38, 0x18, 0x88, 0x43, 0x83, 0x90, 0xcd, 0x81, 0x54, 0xbd, 0x27, 0xf8}: "EfiFirmwareVolumeProtocolGuid",
		efi.GUID{0x1f, 0x7d, 0x9a, 0x57, 0x66, 0xc1, 0x0d, 0x4d, 0xad, 0xdb, 0xb2, 0x0b, 0x8b, 0x76, 0x8b, 0x72}: "TmeInitDxe",
		efi.GUID{0x1f, 0x88, 0x72, 0xcd, 0xb5, 0x45, 0xeb, 0x4f, 0x98, 0xc8, 0x31, 0x3d, 0xa8, 0x11, 0x74, 0x62}: "EfiI2cMasterProtocolGuid",
		efi.GUID{0x1f, 0x95, 0xb5, 0xad, 0xb9, 0xe8, 0xb1, 0x42, 0x9b, 0xfe, 0x39, 0xd7, 0xb5, 0x54, 0x84, 0xc8}: "HpRuntimeBiosUpdateCheckSmm",
		efi.GUID{0x1f, 0x9b, 0x65, 0xb1, 0x4e, 0xf7, 0x66, 0x48, 0x9d, 0x66, 0x29, 0x30, 0x90, 0x03, 0x91, 0xa5}: "FwBlockService",
		efi.GUID{0x1f, 0xa2, 0xcb, 0x32, 0x08, 0xf3, 0xbc, 0x4c, 0x9a, 0xb5, 0xf5, 0xa3, 0x69, 0x9f, 0x04, 0x4a}: "EfiUserCredentialClassFingerprintGuid",
		efi.GUID{0x1f, 0xb7, 0xc2, 0xbf, 0xbf, 0xac, 0x54, 0x4e, 0x9b, 0x19, 0xb6, 0xee, 0xb4, 0x00, 0x50, 0x7b}: "AmdCpmPmfDxe",
		efi.GUID{0x1f, 0xbc, 0x37, 0xca, 0x27, 0xa3, 0xe9, 0x4a, 0x82, 0x8a, 0x8c, 0x40, 0xd8, 0x50, 0x6a, 0x17}: "EfiDns6ProtocolGuid",
		efi.GUID{0x1f, 0xc0, 0x93, 0xcf, 0x16, 0x1a, 0xfc, 0x4d, 0xb8, 0xbc, 0x9c, 0x4d, 0xaf, 0x67, 0xc1, 0x04}: "EfiEventNotificationTypePcieGuid",
		efi.GUID{0x1f, 0xc3, 0x4d, 0xdb, 0x07, 0xf3, 0x6a, 0x4d, 0xa3, 0x47, 0x18, 0x0f, 0xd2, 0x7e, 0xc1, 0x0a}: "MsiTouchPanel",
		efi.GUID{0x1f, 0xc9, 0x64, 0xf0, 0x8c, 0x18, 0x56, 0x4f, 0xb7, 0xfd, 0x30, 0xa9, 0xb8, 0x6a, 0x29, 0xf3}: "EfiCpuTypeFru",
		efi.GUID{0x1f, 0xcc, 0x06, 0x29, 0xca, 0x09, 0x57, 0x44, 0x9a, 0x4f, 0xc2, 0x12, 0xc5, 0x45, 0xd3, 0xd3}: "AppleEpidGroupPublicKeysRl",
		efi.GUID{0x1f, 0xce, 0xb2, 0x4f, 0x3a, 0x1a, 0xe3, 0x42, 0xbd, 0x0c, 0x7b, 0x84, 0xf9, 0x54, 0x18, 0x9a}: "AcpiCallbacksSmm",
		efi.GUID{0x1f, 0xcf, 0x62, 0xa0, 0x73, 0x84, 0xa3, 0x4a, 0x87, 0x93, 0x60, 0x0b, 0xc4, 0xff, 0xa9, 0xa9}: "EfiLegacySredirProtocolGuid",
		efi.GUID{0x1f, 0xcf, 0x62, 0xa0, 0x73, 0x84, 0xa3, 0x4a, 0x87, 0x93, 0x60, 0x0b, 0xc4, 0xff, 0xe9, 0xa8}: "CsmDxe",
		efi.GUID{0x1f, 0xd2, 0xf7, 0x44, 0x6f, 0xc3, 0x66, 0x47, 0xbc, 0x5b, 0xc7, 0x2e, 0x97, 0xe6, 0x89, 0x7b}: "Fip006Dxe",
		efi.GUID{0x1f, 0xda, 0x34, 0x84, 0xeb, 0x5c, 0x2e, 0x40, 0xa9, 0x3c, 0x03, 0x8c, 0xbe, 0x0f, 0x3f, 0x0e}: "OemActivation3Smm",
		efi.GUID{0x1f, 0xde, 0xe4, 0xa0, 0x01, 0xed, 0x9a, 0x41, 0x95, 0x7d, 0x23, 0x79, 0x03, 0x10, 0x8b, 0xa8}: "EfiNgnCfgCur",
		efi.GUID{0x1f, 0xe5, 0x1e, 0xa9, 0xf0, 0x0f, 0x6c, 0x4a, 0xa6, 0xf4, 0x92, 0x14, 0x30, 0x3a, 0xed, 0xf7}: "MeEsrtUpdate",
		efi.GUID{0x1f, 0xe7, 0xdb, 0x59, 0x08, 0x75, 0xd3, 0x49, 0x90, 0x08, 0x08, 0xff, 0x60, 0xf4, 0x7b, 0x82}: "WOLPlatformPortingSmm",
		efi.GUID{0x1f, 0xea, 0xe9, 0x7f, 0x24, 0x42, 0x7b, 0x4c, 0x9f, 0x44, 0xfe, 0xc1, 0x72, 0x8e, 0x7d, 0xa1}: "FjDevInfo",
		efi.GUID{0x1f, 0xf8, 0x0d, 0xc4, 0x36, 0x74, 0x61, 0x46, 0xb6, 0x45, 0xa9, 0x33, 0xb5, 0xd2, 0xf3, 0xc1}: "AsusFWUpdateInterface",
		efi.GUID{0x1f, 0xfe, 0x6b, 0x19, 0xfc, 0x51, 0xe6, 0x43, 0x8e, 0x14, 0xd4, 0x21, 0x55, 0x2b, 0xf0, 0xc7}: "FjFlashMapRt",
		efi.GUID{0x20, 0x0a, 0x48, 0x7f, 0x19, 0x7a, 0x64, 0x47, 0xa5, 0xca, 0x4e, 0x9b, 0x8a, 0xec, 0xaf, 0x1e}: "PchPciBus",
		efi.GUID{0x20, 0x11, 0xfb, 0x50, 0xb7, 0x0f, 0x1c, 0x4b, 0x9c, 0xee, 0x07, 0x1b, 0x97, 0x70, 0x38, 0x27}: "LGSetupPreservePolicyRuntime",
		efi.GUID{0x20, 0x1b, 0xea, 0x6a, 0x84, 0x63, 0x5f, 0x4b, 0xab, 0xac, 0x77, 0x6a, 0x11, 0x69, 0x8d, 0xed}: "LegacyBiosReverseThunk",
		efi.GUID{0x20, 0x1d, 0xd9, 0x63, 0xf8, 0xed, 0xa3, 0x48, 0x87, 0xa9, 0xd6, 0x52, 0x68, 0x11, 0xdb, 0x1f}: "Armani_PowerReportDxe",
		efi.GUID{0x20, 0x1e, 0x96, 0x55, 0xd9, 0xb0, 0x53, 0x45, 0x99, 0x48, 0xe3, 0xec, 0xf0, 0xbe, 0x08, 0x89}: "PlatformConfigPei",
		efi.GUID{0x20, 0x22, 0x95, 0x10, 0x32, 0xaa, 0xdf, 0x11, 0xa4, 0x38, 0x00, 0x02, 0xa5, 0xd5, 0xc5, 0x1b}: "PL35xSmc",
		efi.GUID{0x20, 0x27, 0x64, 0x68, 0xbb, 0x69, 0xc7, 0x4b, 0x98, 0xcf, 0x5c, 0x31, 0xee, 0x74, 0xaf, 0xfb}: "PeiWakeOnLan",
		efi.GUID{0x20, 0x2b, 0x7a, 0x00, 0x83, 0x83, 0xd2, 0x4c, 0xaf, 0x81, 0x29, 0x94, 0x47, 0x34, 0x34, 0xd8}: "UsbOcUpdateDxeBigPineKey",
		efi.GUID{0x20, 0x36, 0x68, 0xa5, 0x98, 0x79, 0xb2, 0x4b, 0xa3, 0x77, 0x1c, 0x1e, 0x31, 0xe1, 0xe2, 0x15}: "TcgDxe",
		efi.GUID{0x20, 0x3d, 0x7f, 0x8f, 0x23, 0x98, 0xdd, 0x42, 0x9f, 0xf7, 0x53, 0xda, 0xc9, 0x3e, 0xf4, 0x07}: "CsrPseudoOffsetInitPeim",
		efi.GUID{0x20, 0x3e, 0x84, 0x8b, 0x32, 0x81, 0x52, 0x48, 0x90, 0xcc, 0x55, 0x1a, 0x4e, 0x4a, 0x7f, 0x1c}: "EfiDevicePathToTextProtocolGuid",
		efi.GUID{0x20, 0x4b, 0x2f, 0xc6, 0x1e, 0x68, 0xdf, 0x11, 0x8f, 0x0d, 0x00, 0x02, 0xa5, 0xd5, 0xc5, 0x1b}: "PciHostBridge",
		efi.GUID{0x20, 0x4c, 0xf8, 0x0e, 0x78, 0xd1, 0x0b, 0x49, 0x9f, 0xcd, 0x12, 0x27, 0x39, 0xfa, 0xae, 0xfc}: "FchSmmDiagDispatcher",
		efi.GUID{0x20, 0x4f, 0xe9, 0xc8, 0x50, 0xd8, 0x27, 0x4c, 0xbf, 0x03, 0xa7, 0x80, 0x55, 0x08, 0x4e, 0x07}: "SystemBiosSelfHealingDxe",
		efi.GUID{0x20, 0x54, 0x7e, 0x8b, 0x71, 0x1b, 0x2a, 0x44, 0x99, 0x16, 0xc1, 0x3a, 0x4f, 0xe0, 0x24, 0x82}: "SmbiosDataUpdateDxeLightningRidgeEXRP",
		efi.GUID{0x20, 0x55, 0x73, 0x69, 0x83, 0xda, 0x4a, 0x44, 0x93, 0xdc, 0xbd, 0xdd, 0x59, 0xe5, 0x91, 0x82}: "Heci3Smm",
		efi.GUID{0x20, 0x57, 0x2b, 0x71, 0x64, 0x7d, 0x52, 0x4f, 0xff, 0xff, 0xff, 0xff, 0x99, 0x46, 0xcf, 0x56}: "PxeOnDemandDxe",
		efi.GUID{0x20, 0x59, 0x01, 0x88, 0x9b, 0x2b, 0x2e, 0x4b, 0x84, 0x0c, 0xad, 0x76, 0xbc, 0x6c, 0x3a, 0xbf}: "AmdNbioDxe",
		efi.GUID{0x20, 0x5c, 0x69, 0xb0, 0xfc, 0xf9, 0x72, 0x43, 0x80, 0x0f, 0x63, 0xb0, 0x6f, 0xb5, 0x2a, 0x4f}: "OemIp3Dxe",
		efi.GUID{0x20, 0x61, 0xcf, 0x46, 0xde, 0x9b, 0xb1, 0x49, 0x9d, 0x59, 0xd3, 0x5e, 0x35, 0x5b, 0xf8, 0x50}: "OdometerResetSmm",
		efi.GUID{0x20, 0x66, 0x30, 0x9a, 0x06, 0xf5, 0xc6, 0x46, 0xa0, 0x95, 0x30, 0xf7, 0x50, 0x40, 0xae, 0x79}: "SystemAhciPeimPei",
		efi.GUID{0x20, 0x6f, 0x0f, 0xd1, 0xda, 0x1e, 0x9e, 0x4d, 0x9d, 0x9b, 0x0f, 0x13, 0x06, 0xc7, 0xa7, 0x13}: "HpFileAccess",
		efi.GUID{0x20, 0x70, 0x5c, 0xfc, 0x48, 0x1a, 0x98, 0x41, 0x9b, 0xe2, 0xea, 0xd5, 0xab, 0xc8, 0xcf, 0x2f}: "BdsDxe",
		efi.GUID{0x20, 0x77, 0xec, 0x60, 0x2b, 0x51, 0x90, 0x44, 0x9f, 0xd1, 0xa3, 0x36, 0x76, 0x9a, 0xe0, 0x1f}: "SmmControlPei",
		efi.GUID{0x20, 0x79, 0x73, 0xc9, 0xad, 0xc2, 0xc3, 0x41, 0xb1, 0x33, 0x0f, 0x9c, 0x25, 0x1b, 0x67, 0x43}: "PeiDebugDispatchPpiGuid",
		efi.GUID{0x20, 0x7a, 0x14, 0xa1, 0x44, 0x31, 0x8d, 0x4f, 0x82, 0x95, 0xb4, 0x83, 0x11, 0xc8, 0xe4, 0xa4}: "ArmJunoTokenSpaceGuid",
		efi.GUID{0x20, 0x7d, 0xcf, 0x44, 0xf6, 0xdf, 0x09, 0x42, 0x9a, 0x1f, 0xf6, 0xcd, 0x5f, 0x5c, 0xe8, 0x8b}: "LenovoVariableInitSmm",
		efi.GUID{0x20, 0x7e, 0x34, 0x37, 0x3d, 0x5c, 0xb7, 0x47, 0xb2, 0x33, 0x1e, 0x35, 0x3a, 0x7e, 0x01, 0x45}: "AppleHttpClient",
		efi.GUID{0x20, 0x83, 0xe9, 0x0b, 0x34, 0x56, 0xab, 0x4a, 0xb2, 0xb7, 0xfc, 0xbc, 0x97, 0x77, 0x15, 0x1e}: "FjTerraSmm",
		efi.GUID{0x20, 0x84, 0x4a, 0x5e, 0xc0, 0xfe, 0xd3, 0x40, 0x98, 0xae, 0xc4, 0xca, 0x45, 0x50, 0x2b, 0x93}: "ODMDiagDxeProtocol",
		efi.GUID{0x20, 0x84, 0x98, 0x82, 0x67, 0x74, 0x90, 0x44, 0x90, 0x59, 0xfe, 0xb4, 0x48, 0xdd, 0x19, 0x63}: "MeConfig",
		efi.GUID{0x20, 0x92, 0xfa, 0x7d, 0x45, 0x51, 0xcb, 0x42, 0xa8, 0x15, 0x08, 0x65, 0xc1, 0xb9, 0x52, 0xf9}: "FidoUsbDxe",
		efi.GUID{0x20, 0x95, 0x5f, 0xc3, 0x91, 0x57, 0x67, 0x46, 0xad, 0xe4, 0x1c, 0xfd, 0xa8, 0x37, 0x72, 0x2d}: "AmiSmiVariableDxeDriverStarted",
		efi.GUID{0x20, 0x9c, 0xcd, 0x7e, 0xb9, 0x68, 0x6f, 0x4a, 0xb5, 0x15, 0xd6, 0x4f, 0xf5, 0x00, 0xb1, 0x09}: "FsRecovery",
		efi.GUID{0x20, 0xa8, 0x89, 0x33, 0x27, 0x4a, 0xa9, 0x4f, 0xad, 0xbd, 0x39, 0xab, 0x18, 0x07, 0x8f, 0xa7}: "AmdSb900PeiSmbus",
		efi.GUID{0x20, 0xaa, 0x1e, 0xd3, 0x36, 0x84, 0x34, 0x4e, 0x9a, 0x06, 0xc4, 0x7c, 0x78, 0xe1, 0x9f, 0x18}: "SIOBasicIODxe",
		efi.GUID{0x20, 0xaf, 0xbd, 0x3e, 0x67, 0x66, 0xd8, 0x40, 0xb4, 0xee, 0xf5, 0x99, 0x9a, 0xc1, 0xb7, 0x1f}: "EfiSecHobDataPpiGuid",
		efi.GUID{0x20, 0xb1, 0x04, 0x76, 0x5c, 0xa5, 0x36, 0x4a, 0xa9, 0xf6, 0x42, 0x0e, 0x5a, 0xda, 0x99, 0x5c}: "MpmAsfPei",
		efi.GUID{0x20, 0xb1, 0xc8, 0x4e, 0x07, 0x83, 0xe0, 0x11, 0xbc, 0x91, 0x00, 0x02, 0xa5, 0xd5, 0xc5, 0x1b}: "PL011Uart",
		efi.GUID{0x20, 0xb4, 0x99, 0xa7, 0x9b, 0xf7, 0xf0, 0x44, 0xa1, 0x67, 0xbc, 0x3f, 0x99, 0xdd, 0x61, 0x66}: "CbsBaseDxeSTP",
		efi.GUID{0x20, 0xc0, 0xc0, 0x81, 0x9e, 0xe9, 0x06, 0x44, 0x96, 0x56, 0x5e, 0x68, 0x6a, 0x0e, 0x0c, 0xc3}: "FjTpm",
		efi.GUID{0x20, 0xc2, 0x7c, 0x5b, 0x83, 0xe1, 0x1c, 0x48, 0x87, 0xf4, 0x27, 0xa9, 0x2d, 0x8d, 0xb8, 0x8f}: "SiInitPreMemFsp",
		efi.GUID{0x20, 0xc6, 0x64, 0x4a, 0xef, 0x1c, 0xa0, 0x40, 0xbe, 0x1c, 0xee, 0xd6, 0xb2, 0x0e, 0xcc, 0xe9}: "MrcHealthDataInit",
		efi.GUID{0x20, 0xc7, 0x3d, 0x84, 0x1e, 0xab, 0xcb, 0x42, 0x93, 0x57, 0x8a, 0x00, 0x78, 0xf3, 0x56, 0x1b}: "EfiSmmControl2ProtocolGuid",
		efi.GUID{0x20, 0xc8, 0x03, 0xb7, 0x3d, 0x4d, 0x58, 0x46, 0x8e, 0xed, 0x5b, 0x2f, 0x9d, 0xe5, 0x47, 0x11}: "efi_pop_LF_pressed",
		efi.GUID{0x20, 0xcb, 0x6a, 0x88, 0xc0, 0x78, 0x88, 0x4f, 0x9d, 0x3c, 0xba, 0xdc, 0xe3, 0x7e, 0xda, 0x47}: "LenovoN25Q064FlashPartDxe",
		efi.GUID{0x20, 0xd0, 0xa0, 0x37, 0xd1, 0xcc, 0xdd, 0x11, 0xad, 0x8b, 0x08, 0x00, 0x20, 0x0c, 0x9a, 0x66}: "SystemIdeAtaAtapiPassThruDxe",
		efi.GUID{0x20, 0xd3, 0x54, 0x23, 0xb3, 0x3e, 0x81, 0x4c, 0x99, 0xf4, 0xcc, 0x4a, 0xe1, 0x43, 0x46, 0x3e}: "EfiEdkCompatibilityPkgTokenSpaceGuid",
		efi.GUID{0x20, 0xf2, 0xa5, 0x7f, 0x11, 0x9f, 0xb5, 0x49, 0x85, 0xa2, 0x04, 0x5a, 0xac, 0x34, 0x7d, 0x27}: "BackupService",
		efi.GUID{0x20, 0xf7, 0x53, 0x49, 0x6d, 0x00, 0xf5, 0x41, 0x99, 0x0d, 0x0a, 0xc7, 0x74, 0x2a, 0xbb, 0x60}: "IntelGigabitLan",
		efi.GUID{0x20, 0xf7, 0x53, 0x49, 0x6d, 0x00, 0xf5, 0x41, 0x99, 0x0d, 0x0a, 0xc7, 0x74, 0x2a, 0xbb, 0x61}: "Intel10GLan",
		efi.GUID{0x20, 0xf8, 0x6d, 0x36, 0x6d, 0x5d, 0x84, 0x48, 0x96, 0x11, 0xe3, 0xe5, 0x95, 0x09, 0x0d, 0x9e}: "TpmFmpUefiDrv",
		efi.GUID{0x21, 0x03, 0x33, 0x4d, 0x5f, 0x02, 0xac, 0x4a, 0x90, 0xd8, 0x5e, 0xd9, 0x00, 0x17, 0x3b, 0x63}: "EfiDriverDiagnostics2ProtocolGuid",
		efi.GUID{0x21, 0x10, 0x3d, 0x6d, 0xfc, 0xe7, 0xc2, 0x42, 0xb3, 0x01, 0xec, 0xe9, 0xdb, 0x19, 0x82, 0x87}: "SystemSpeakerPei",
		efi.GUID{0x21, 0x15, 0x94, 0xdb, 0xa7, 0x4e, 0x87, 0x4c, 0xa7, 0x11, 0x35, 0x4d, 0xb5, 0xd6, 0xd7, 0xe6}: "OemSmbiosConfigDxe",
		efi.GUID{0x21, 0x20, 0xc6, 0xb2, 0x80, 0x9e, 0x50, 0x42, 0xb5, 0x67, 0x89, 0x6e, 0xa8, 0x36, 0x0a, 0xd1}: "DellFlashRecoveryImagePei",
		efi.GUID{0x21, 0x28, 0xa6, 0x6d, 0xaf, 0x54, 0x36, 0x48, 0x8e, 0xf0, 0x89, 0x05, 0xef, 0x9b, 0xd7, 0x33}: "AmdCpmModernStandbyFeatureDxe",
		efi.GUID{0x21, 0x2b, 0xf6, 0x5b, 0x18, 0x41, 0xe8, 0x48, 0xaa, 0xe0, 0x46, 0xea, 0x19, 0x61, 0x5c, 0x04}: "H19PlatformServiceSmm",
		efi.GUID{0x21, 0x33, 0xd0, 0xac, 0x7e, 0x77, 0x3d, 0x4d, 0xb1, 0xc8, 0x20, 0xcf, 0xd8, 0x88, 0x20, 0xc9}: "EfiRngAlgorithmX931AesGuid",
		efi.GUID{0x21, 0x47, 0xed, 0x66, 0x98, 0x3c, 0x3e, 0x4d, 0x81, 0xe3, 0xd0, 0x3d, 0xd3, 0x9a, 0x72, 0x54}: "EfiUdp6ServiceBindingProtocolGuid",
		efi.GUID{0x21, 0x4e, 0x6b, 0xe6, 0x5c, 0xd7, 0xfd, 0x45, 0xaf, 0x53, 0x4c, 0xd5, 0x91, 0x8b, 0x5f, 0xeb}: "SbRecoveryDeviceDxe",
		efi.GUID{0x21, 0x52, 0xa2, 0xf1, 0x8b, 0xa9, 0x89, 0x41, 0x85, 0xf2, 0x0b, 0xa2, 0x26, 0xa3, 0x70, 0xda}: "FTP_DXE",
		efi.GUID{0x21, 0x5b, 0x4e, 0x96, 0x00, 0x60, 0xd2, 0x23, 0x9e, 0x39, 0x01, 0xa0, 0xc9, 0x69, 0x72, 0x3b}: "SioIoProtocol",
		efi.GUID{0x21, 0x5b, 0x4e, 0x96, 0x59, 0x64, 0xd2, 0x11, 0x8e, 0x39, 0x00, 0xa0, 0xc9, 0x69, 0x72, 0x3b}: "EfiBlockIoProtocolGuid",
		efi.GUID{0x21, 0x60, 0x5e, 0x61, 0x3d, 0x60, 0x24, 0x41, 0xb7, 0xea, 0xc4, 0x8a, 0x37, 0x37, 0xba, 0xcd}: "BiosKnobsDataBin",
		efi.GUID{0x21, 0x62, 0x8a, 0x8a, 0x40, 0xe2, 0x09, 0x4e, 0xab, 0xc3, 0xb1, 0xdf, 0x36, 0x09, 0xb0, 0x27}: "AmdNbioPcieDxe",
		efi.GUID{0x21, 0x65, 0x84, 0xb9, 0x99, 0xff, 0x53, 0x49, 0x8f, 0xa2, 0x85, 0xc9, 0xad, 0xcc, 0xe5, 0xaf}: "PeiGfxDriver",
		efi.GUID{0x21, 0x73, 0xe8, 0xcc, 0x2f, 0x96, 0x46, 0x44, 0x93, 0xee, 0xc2, 0x91, 0xf1, 0x86, 0x12, 0xa7}: "OhciSmm",
		efi.GUID{0x21, 0x7c, 0xed, 0xe3, 0xb8, 0x9d, 0xc7, 0x47, 0x8e, 0x7d, 0x7d, 0xb9, 0x7f, 0xe2, 0x06, 0x3e}: "DellSmmCircBuff",
		efi.GUID{0x21, 0x7d, 0x6f, 0xac, 0x04, 0x37, 0x4d, 0x4d, 0xac, 0xed, 0xfe, 0x32, 0xc6, 0xaa, 0xaf, 0xf4}: "DTbtPeiPreMem",
		efi.GUID{0x21, 0x7f, 0xb3, 0x36, 0x04, 0x9d, 0xb5, 0x44, 0x95, 0xec, 0x4d, 0xe4, 0xcb, 0x2f, 0xe6, 0xfb}: "menu_locked_selected",
		efi.GUID{0x21, 0x80, 0xe9, 0x00, 0xfe, 0xf4, 0xcc, 0x46, 0xab, 0x2d, 0x89, 0x4c, 0x37, 0x3a, 0xfa, 0x01}: "DxeEnhancedSpeedstepProtocol",
		efi.GUID{0x21, 0x85, 0xe1, 0x93, 0x52, 0x9e, 0xeb, 0x4e, 0xa2, 0x30, 0x7c, 0x24, 0xb2, 0xec, 0x03, 0xe8}: "LenovoMfgDoneDxe",
		efi.GUID{0x21, 0x8a, 0xcc, 0x30, 0x76, 0x04, 0x80, 0x4c, 0xb5, 0xc5, 0xb2, 0x69, 0x47, 0xe1, 0x89, 0x1d}: "XhciDebugger",
		efi.GUID{0x21, 0x9a, 0xc9, 0x05, 0x0f, 0xc7, 0xd2, 0x4a, 0x8a, 0x5f, 0x35, 0xdf, 0x33, 0x43, 0xf5, 0x1e}: "EfiDevicePathFromTextProtocolGuid",
		efi.GUID{0x21, 0x9d, 0xcd, 0xe1, 0xc2, 0x0f, 0x8d, 0x43, 0x97, 0x03, 0x04, 0xe6, 0x6d, 0x96, 0x1e, 0x57}: "EfiExtendedSalPalServicesProtocolGuid",
		efi.GUID{0x21, 0xaa, 0x2c, 0x46, 0x14, 0x76, 0x03, 0x45, 0x83, 0x6e, 0x8a, 0xb6, 0xf4, 0x66, 0x23, 0x31}: "Enter_Setup",
		efi.GUID{0x21, 0xac, 0x1a, 0x13, 0x45, 0x21, 0xe6, 0x49, 0xa3, 0xe1, 0xa9, 0x7b, 0xce, 0x09, 0x00, 0x20}: "AcpiSpcr",
		efi.GUID{0x21, 0xae, 0x62, 0x51, 0xed, 0x17, 0xb7, 0x45, 0xaa, 0x9d, 0xe6, 0x69, 0xa3, 0xa3, 0x35, 0x25}: "DellStorageAgentSmmProtocol",
		efi.GUID{0x21, 0xb2, 0xc7, 0x47, 0x2a, 0xc4, 0xd2, 0x11, 0x8e, 0x57, 0x00, 0xa0, 0xc9, 0x69, 0x72, 0x3b}: "EfiShellEnvironment2Guid",
		efi.GUID{0x21, 0xc3, 0x07, 0xc0, 0x7e, 0xe8, 0xb4, 0x46, 0xa5, 0xb5, 0xc3, 0x3e, 0x84, 0x5d, 0x89, 0xeb}: "WarmBootDxe",
		efi.GUID{0x21, 0xc4, 0xf7, 0xf1, 0xdf, 0x96, 0x8a, 0x4c, 0xaf, 0x91, 0x62, 0xa3, 0xc9, 0xae, 0xd3, 0x10}: "EfiTxtLockConfig",
		efi.GUID{0x21, 0xc6, 0xae, 0x88, 0x0a, 0x2e, 0x80, 0x42, 0xbf, 0xce, 0x8a, 0xc7, 0xe3, 0x1e, 0x77, 0x4f}: "BH611FJ1",
		efi.GUID{0x21, 0xca, 0x5d, 0x24, 0x7b, 0xfb, 0xd3, 0x11, 0x8f, 0x01, 0x00, 0xa0, 0xc9, 0x69, 0x72, 0x3b}: "EfiPxeBaseCodeCallbackProtocolGuid",
		efi.GUID{0x21, 0xd0, 0x80, 0xae, 0x8e, 0x61, 0xd4, 0x11, 0xbc, 0xd7, 0x00, 0x80, 0xc7, 0x3c, 0x88, 0x81}: "EfiDataHubProtocolGuid",
		efi.GUID{0x21, 0xda, 0x61, 0xb7, 0xec, 0x76, 0xb0, 0x4a, 0x99, 0xe8, 0x4d, 0xc2, 0x51, 0xb7, 0x2c, 0xb5}: "DellSmmEcProtocol",
		efi.GUID{0x21, 0xdc, 0x0a, 0xc3, 0xa5, 0x4a, 0x13, 0x43, 0xa7, 0xe7, 0x53, 0x39, 0x5b, 0x42, 0xbe, 0xab}: "AmdCpmDisplayFeatureSmmBr",
		efi.GUID{0x21, 0xe5, 0x7f, 0x93, 0xae, 0x95, 0x1a, 0x4d, 0x89, 0x29, 0x48, 0xbc, 0xd9, 0x0a, 0xd3, 0x1a}: "EfiIp6ConfigProtocolGuid",
		efi.GUID{0x21, 0xec, 0xd1, 0x11, 0x68, 0xe5, 0xb0, 0x4e, 0x8e, 0x1d, 0xa0, 0x80, 0x97, 0x72, 0xb6, 0x06}: "DellEnhancedVersionProtocol",
		efi.GUID{0x21, 0xf3, 0xbe, 0x5c, 0x75, 0x9b, 0x20, 0x31, 0x88, 0xcd, 0x5d, 0x12, 0x34, 0x12, 0xcb, 0xcd}: "ATIPwrXSmi",
		efi.GUID{0x21, 0xf6, 0x0c, 0xf1, 0x02, 0x15, 0x30, 0x41, 0xa8, 0x60, 0xd3, 0x00, 0x45, 0x9e, 0x2c, 0x08}: "MEbxInvokeDxe",
		efi.GUID{0x21, 0xfa, 0xc6, 0x1c, 0x9d, 0x4a, 0xb4, 0x46, 0x9e, 0xbf, 0x9e, 0x42, 0xf5, 0xd0, 0x44, 0xf2}: "FjCapsuleResetHookSmm",
		efi.GUID{0x21, 0xfd, 0xc9, 0xdb, 0xd8, 0xfa, 0xb0, 0x45, 0x9e, 0x78, 0x27, 0x15, 0x88, 0x67, 0xcc, 0x93}: "BdsAllDriversConnectedProtocolGuid",
		efi.GUID{0x22, 0x17, 0xa8, 0xb1, 0xc3, 0x50, 0xa6, 0x4a, 0x8b, 0xbf, 0xdd, 0x0d, 0x83, 0x98, 0x91, 0x34}: "HhmSmm",
		efi.GUID{0x22, 0x1e, 0xfd, 0xed, 0xbf, 0xc6, 0x06, 0x4b, 0xa4, 0xb2, 0x5a, 0xe0, 0x50, 0xc8, 0x4a, 0x37}: "USBControllerSmm",
		efi.GUID{0x22, 0x25, 0x9f, 0x9d, 0x2c, 0x24, 0x9b, 0x43, 0xa9, 0xac, 0x24, 0x8d, 0xfe, 0x24, 0x46, 0x39}: "FcclSmbios",
		efi.GUID{0x22, 0x27, 0xc8, 0x32, 0x56, 0xa7, 0xd4, 0x43, 0x9b, 0xb5, 0xe0, 0x7e, 0x0b, 0x14, 0x95, 0xf7}: "DellFmpTpm",
		efi.GUID{0x22, 0x29, 0x2a, 0x20, 0x27, 0x8c, 0x43, 0x49, 0x98, 0x55, 0x26, 0x18, 0x0b, 0xf9, 0xf1, 0x13}: "VariableInfo",
		efi.GUID{0x22, 0x2b, 0x87, 0x2b, 0x11, 0x6c, 0xfd, 0x4d, 0x99, 0x4a, 0x96, 0xbc, 0x13, 0x92, 0x0a, 0x43}: "fTPMTcg2Smm",
		efi.GUID{0x22, 0x2e, 0xb7, 0x9d, 0x62, 0x92, 0x18, 0x4a, 0x8f, 0xe0, 0x85, 0xe0, 0x3d, 0xfa, 0x96, 0x73}: "SmmCpuSync2Protocol",
		efi.GUID{0x22, 0x34, 0x67, 0xf8, 0xde, 0x16, 0x9c, 0x44, 0x87, 0x28, 0xab, 0x03, 0x61, 0xdb, 0xf9, 0xf0}: "LegacyInterruptHookDxe",
		efi.GUID{0x22, 0x3b, 0x1a, 0x91, 0x01, 0x83, 0xd8, 0x4c, 0x83, 0x5b, 0xcc, 0x70, 0x82, 0x6d, 0x58, 0x29}: "AmdiGpuVbsWA",
		efi.GUID{0x22, 0x4e, 0x23, 0x72, 0x17, 0x8a, 0x30, 0x4e, 0xae, 0xc5, 0xf3, 0xb3, 0x39, 0x7e, 0x66, 0x91}: "SxCallback",
		efi.GUID{0x22, 0x4e, 0x6b, 0xa7, 0x0a, 0xb5, 0x1d, 0x40, 0x8b, 0x35, 0x51, 0x24, 0xb0, 0xba, 0x41, 0x04}: "TcgPeiPolicyGuid",
		efi.GUID{0x22, 0x52, 0x7a, 0x89, 0x8b, 0x97, 0xab, 0x49, 0xba, 0xa0, 0xfc, 0x52, 0x3f, 0xb9, 0x26, 0x02}: "FjThermalSmm",
		efi.GUID{0x22, 0x55, 0x97, 0x5e, 0x6f, 0x17, 0x2d, 0x4e, 0xbb, 0x25, 0x64, 0xad, 0xcc, 0x77, 0x92, 0xa4}: "BaseDebugDeviceLibNull",
		efi.GUID{0x22, 0x5b, 0x4e, 0x96, 0x59, 0x64, 0xd2, 0x11, 0x8e, 0x39, 0x00, 0xa0, 0xc9, 0x69, 0x72, 0x3b}: "EfiSimpleFileSystemProtocolGuid",
		efi.GUID{0x22, 0x64, 0x1e, 0x42, 0x00, 0xeb, 0xd9, 0x4e, 0xa5, 0x8e, 0xd0, 0x16, 0x66, 0xcb, 0x3d, 0xae}: "SmbiosDataUpdateDxeFischerLakeRP",
		efi.GUID{0x22, 0x6a, 0xe5, 0xb2, 0xe7, 0xdf, 0x50, 0x48, 0x97, 0xae, 0x10, 0xe7, 0x61, 0x12, 0xde, 0x05}: "BatteryInfoDxe",
		efi.GUID{0x22, 0x7a, 0x7c, 0xad, 0x5d, 0x5f, 0x64, 0x48, 0xa8, 0xef, 0x2b, 0x78, 0xad, 0x0a, 0x52, 0xd8}: "DellUsbExtDxe",
		efi.GUID{0x22, 0x7c, 0xe9, 0xbd, 0xeb, 0xd8, 0x25, 0x46, 0xbc, 0x36, 0x77, 0x34, 0x57, 0xae, 0x25, 0xdb}: "AMDGenericGop",
		efi.GUID{0x22, 0x7e, 0x6f, 0x65, 0x01, 0x57, 0x41, 0x43, 0xa9, 0xa7, 0x99, 0xa5, 0xd4, 0x0a, 0x52, 0x45}: "AmdFabricSspDxe",
		efi.GUID{0x22, 0x7e, 0x91, 0xff, 0x28, 0xa2, 0x8d, 0x44, 0xbd, 0xaa, 0x68, 0xef, 0xcc, 0xdd, 0xa5, 0xd3}: "TxtDxe",
		efi.GUID{0x22, 0x83, 0x89, 0x32, 0xa1, 0x2d, 0x4a, 0x47, 0xba, 0xaa, 0xf3, 0xf7, 0xcf, 0x56, 0x94, 0x70}: "HardwareInterrupt2Protocol",
		efi.GUID{0x22, 0x89, 0x0d, 0xd2, 0xf8, 0xa2, 0x80, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xdc, 0x89, 0x3c, 0x8d}: "XnotePlatformResetSmm",
		efi.GUID{0x22, 0x9e, 0x31, 0x60, 0x47, 0x75, 0xc6, 0x4b, 0xb3, 0x93, 0xfb, 0xa7, 0x40, 0x9f, 0x4e, 0x25}: "OemReadyToBoot",
		efi.GUID{0x22, 0x9f, 0x7b, 0xfc, 0xf6, 0x2a, 0xdc, 0x4b, 0x9b, 0x94, 0x38, 0x64, 0x6f, 0x1e, 0x08, 0x30}: "AsusIoSecInterface",
		efi.GUID{0x22, 0xa8, 0xa5, 0xea, 0xce, 0xea, 0x8b, 0x48, 0xb1, 0x87, 0x11, 0xab, 0xc8, 0xe7, 0x2e, 0x69}: "AmdMemS3BlackListPei",
		efi.GUID{0x22, 0xaf, 0x03, 0xf3, 0x04, 0x68, 0x4b, 0x49, 0xa2, 0x8a, 0xa0, 0x3b, 0xe7, 0xd5, 0xc7, 0x42}: "CsmRt32Asm",
		efi.GUID{0x22, 0xb0, 0x3c, 0x3b, 0x14, 0x26, 0x94, 0x49, 0x87, 0x8e, 0xc7, 0x38, 0xce, 0x85, 0xf6, 0xed}: "ApobDummyPei",
		efi.GUID{0x22, 0xbc, 0x82, 0x5f, 0xe1, 0x85, 0x9d, 0x48, 0x93, 0xa1, 0x42, 0xbb, 0xd6, 0x64, 0xb4, 0x34}: "IioCfgUpdateDxeLightningRidgeEXECB1",
		efi.GUID{0x22, 0xc5, 0x27, 0xe2, 0xfe, 0xd5, 0x53, 0x4a, 0x87, 0xb1, 0x0f, 0xbe, 0x57, 0x0f, 0x98, 0xe9}: "ObservableProtocolGuid",
		efi.GUID{0x22, 0xd1, 0xda, 0x9e, 0x4b, 0x90, 0x50, 0x41, 0x9a, 0xc6, 0xb9, 0x46, 0x53, 0x75, 0x04, 0x53}: "AcChargeBeepSMI",
		efi.GUID{0x22, 0xdb, 0x6e, 0xc5, 0x78, 0x3d, 0x05, 0x47, 0xa2, 0x22, 0xbd, 0xd6, 0xbd, 0x15, 0x4d, 0xa0}: "TpmClearOnRollbackSmm",
		efi.GUID{0x22, 0xe2, 0x7f, 0x5d, 0xd3, 0xb0, 0x0f, 0x40, 0xb0, 0x92, 0x56, 0x57, 0x62, 0x3b, 0xd0, 0xbe}: "BootBlockProtectionDxe",
		efi.GUID{0x22, 0xe3, 0x16, 0x09, 0x40, 0x37, 0xce, 0x31, 0xad, 0x62, 0xbd, 0x17, 0x2c, 0xec, 0xca, 0x36}: "AsrockRaidSetup",
		efi.GUID{0x22, 0xe3, 0x66, 0x0a, 0x40, 0x37, 0xce, 0x4c, 0xad, 0x62, 0xbd, 0x17, 0x2c, 0xec, 0xca, 0x35}: "ScsiDisk",
		efi.GUID{0x22, 0xe8, 0x91, 0xa3, 0x44, 0x70, 0xf4, 0x4c, 0xbe, 0x5b, 0x34, 0x5e, 0x44, 0xb8, 0x62, 0x7c}: "SgPlatformPolicyPpi",
		efi.GUID{0x22, 0xec, 0xa0, 0x38, 0xe7, 0xfb, 0x11, 0x49, 0x8b, 0xc1, 0x17, 0x6e, 0x0d, 0x6c, 0x1d, 0xbd}: "IsaAcpi",
		efi.GUID{0x22, 0xec, 0xbc, 0x0d, 0xbe, 0x0a, 0xf4, 0x4b, 0xbf, 0xee, 0xa0, 0x4d, 0x1c, 0xa6, 0xf6, 0x43}: "PlatformInitDxeHedt",
		efi.GUID{0x22, 0xf6, 0xc8, 0x75, 0x90, 0x80, 0x17, 0x40, 0x85, 0x0c, 0x3f, 0xa4, 0x0b, 0x02, 0x79, 0x84}: "SmcMemMapOut",
		efi.GUID{0x23, 0x02, 0x5a, 0x38, 0x0f, 0xc2, 0x20, 0x49, 0x84, 0xde, 0xa0, 0x1f, 0xc9, 0x11, 0xe9, 0x22}: "DBGP",
		efi.GUID{0x23, 0x0b, 0x2c, 0x31, 0xf2, 0x93, 0x6e, 0x46, 0x96, 0x1b, 0x6d, 0x58, 0x4d, 0x0d, 0x26, 0xee}: "ExpansionSlotConfigSmm",
		efi.GUID{0x23, 0x0c, 0xa0, 0x0f, 0xca, 0xca, 0x15, 0x55, 0x6a, 0xd3, 0xb7, 0xd8, 0x75, 0x40, 0xdf, 0xa3}: "BLSeedTest",
		efi.GUID{0x23, 0x1e, 0xb9, 0x10, 0xba, 0x11, 0xb5, 0x4c, 0x90, 0x12, 0xaf, 0x50, 0x16, 0x00, 0x5d, 0xd3}: "SelfHealingDetectCorruptionDxe",
		efi.GUID{0x23, 0x26, 0xc2, 0x10, 0x6f, 0xdb, 0x21, 0x47, 0xaa, 0x30, 0x4c, 0x12, 0xaf, 0x42, 0x30, 0xa7}: "IdeRecovery",
		efi.GUID{0x23, 0x26, 0xc2, 0x10, 0x6f, 0xdb, 0x21, 0x47, 0xaa, 0x30, 0x9c, 0x12, 0xaf, 0x42, 0x30, 0xf8}: "ExtRecovery",
		efi.GUID{0x23, 0x31, 0xda, 0x5e, 0x40, 0x08, 0xf7, 0x45, 0xad, 0xab, 0x13, 0xa6, 0x55, 0xef, 0x3b, 0xb7}: "DellAcpiConfig",
		efi.GUID{0x23, 0x3f, 0x09, 0x40, 0x0c, 0x63, 0x26, 0x46, 0x9c, 0x48, 0x40, 0x37, 0x3b, 0x19, 0xcb, 0xbe}: "EfiKmsFormatGeneric2048Guid",
		efi.GUID{0x23, 0x41, 0xbc, 0x7b, 0x5e, 0x5d, 0x1c, 0x4c, 0x95, 0xd1, 0x30, 0xeb, 0xa4, 0x87, 0x01, 0xca}: "S4SlpDelaySmm",
		efi.GUID{0x23, 0x44, 0x0c, 0xf4, 0x5f, 0x45, 0x67, 0x45, 0xa1, 0x11, 0x6f, 0x81, 0x13, 0x3c, 0xe9, 0xbb}: "OledInit",
		efi.GUID{0x23, 0x4d, 0xa4, 0x91, 0xcc, 0x5d, 0x25, 0x44, 0x91, 0xe6, 0x42, 0xda, 0x61, 0x64, 0x0b, 0xa7}: "AsusBootDeviceSkip",
		efi.GUID{0x23, 0x4f, 0xa4, 0xb1, 0xcc, 0xed, 0x25, 0x44, 0xa1, 0xe6, 0x22, 0xda, 0x61, 0x64, 0x0b, 0xa7}: "AsusESALaunchDetect",
		efi.GUID{0x23, 0x53, 0x1c, 0x6b, 0x7e, 0x29, 0x20, 0x47, 0xb9, 0x59, 0x56, 0xd6, 0xf3, 0x0f, 0xee, 0x00}: "YieldingDelayDxe",
		efi.GUID{0x23, 0x56, 0x41, 0x41, 0x74, 0xa0, 0x69, 0x43, 0x98, 0xc8, 0x37, 0x07, 0x70, 0xae, 0xd4, 0x2b}: "AmdMemSmbiosV2RsPei",
		efi.GUID{0x23, 0x5c, 0xb7, 0x76, 0x4f, 0xfe, 0x17, 0x4e, 0xa2, 0xad, 0x1a, 0x65, 0x3d, 0xbb, 0x49, 0x4a}: "EfiExtendedSalLockServicesProtocol",
		efi.GUID{0x23, 0x7b, 0xab, 0x39, 0x4e, 0x81, 0x89, 0x42, 0x9b, 0xd9, 0x67, 0xeb, 0x02, 0x5c, 0x35, 0xdf}: "PowerManagementDxe2",
		efi.GUID{0x23, 0x9a, 0x06, 0x9a, 0x6f, 0x83, 0xdf, 0x41, 0xaf, 0x02, 0xf1, 0x4b, 0xec, 0x97, 0xde, 0x72}: "FmpDxe",
		efi.GUID{0x23, 0x9a, 0x83, 0xc9, 0x0e, 0x4b, 0x5e, 0x46, 0x8f, 0x29, 0x14, 0xa5, 0x01, 0x0c, 0xa7, 0xdf}: "PerDisCptInRomPostFlag",
		efi.GUID{0x23, 0x9b, 0x00, 0xcf, 0xb9, 0x17, 0xee, 0x43, 0xbb, 0x69, 0x43, 0x93, 0xca, 0x18, 0x6b, 0x1c}: "LEMDeviceGuardInit",
		efi.GUID{0x23, 0x9b, 0x4d, 0x3b, 0xac, 0x95, 0xf6, 0x44, 0x9f, 0xcd, 0x0e, 0x95, 0x94, 0x58, 0x6c, 0x72}: "BdsLibStringPackageGuid",
		efi.GUID{0x23, 0x9c, 0x55, 0x5e, 0xaa, 0x1f, 0xe1, 0x4a, 0x8d, 0x4a, 0xc6, 0xcf, 0x02, 0x6c, 0x76, 0x6f}: "FirmwareIdGuid",
		efi.GUID{0x23, 0xa1, 0xff, 0xfb, 0x40, 0x45, 0x39, 0x44, 0xa9, 0x01, 0x88, 0x99, 0xaa, 0xbc, 0xde, 0xf0}: "SyncMSR",
		efi.GUID{0x23, 0xa2, 0x8c, 0x34, 0x7b, 0x63, 0x30, 0x44, 0xba, 0xf3, 0x1c, 0xe5, 0xd3, 0x22, 0xb3, 0xfd}: "SetupBoot",
		efi.GUID{0x23, 0xa2, 0x9d, 0x9a, 0x17, 0xb1, 0x99, 0x47, 0xa0, 0x70, 0x4d, 0x2c, 0xfc, 0xb1, 0xc4, 0x42}: "F75111PeiPkg",
		efi.GUID{0x23, 0xa2, 0xaf, 0x61, 0xc8, 0x8a, 0x40, 0x44, 0x9a, 0xb5, 0x76, 0x2b, 0x1b, 0xf0, 0x51, 0x56}: "Mtftp4Dxe",
		efi.GUID{0x23, 0xa5, 0xf5, 0x5d, 0x36, 0x30, 0x1a, 0x4e, 0x83, 0xe3, 0x35, 0xd7, 0x55, 0xeb, 0x40, 0x81}: "D01ODMWmiDxe",
		efi.GUID{0x23, 0xa6, 0x0a, 0x33, 0xe7, 0x79, 0x7c, 0x46, 0x81, 0xaa, 0xde, 0x9e, 0xe0, 0xf9, 0x6a, 0x52}: "SmmThunk",
		efi.GUID{0x23, 0xb2, 0xa9, 0x52, 0xb8, 0xfa, 0x24, 0x4a, 0xae, 0xa6, 0x46, 0x1a, 0x59, 0xbd, 0x3f, 0x33}: "AmdSmbiosDxe",
		efi.GUID{0x23, 0xb2, 0xc7, 0x47, 0x2a, 0xc4, 0xd2, 0x11, 0x8e, 0x57, 0x00, 0xa0, 0xc9, 0x69, 0x72, 0x3b}: "EfiShellInterfaceGuid",
		efi.GUID{0x23, 0xb5, 0xef, 0xf1, 0x59, 0x3d, 0x88, 0x48, 0xbb, 0x71, 0xea, 0xa5, 0xa9, 0x66, 0x28, 0xfa}: "SecurityStubDxe",
		efi.GUID{0x23, 0xbe, 0x07, 0x61, 0xaa, 0x5b, 0xc9, 0x4f, 0x8f, 0xc9, 0xf2, 0xae, 0xa7, 0x7b, 0x07, 0xa7}: "FireWireOhci",
		efi.GUID{0x23, 0xbe, 0xd0, 0xdc, 0x86, 0x95, 0xf4, 0x40, 0xb6, 0x43, 0x06, 0x52, 0x2c, 0xed, 0x4e, 0xde}: "EfiPeiSecurity2PpiGuid",
		efi.GUID{0x23, 0xbf, 0x03, 0xd9, 0xde, 0xe1, 0xf0, 0x4d, 0x8b, 0x96, 0x73, 0xb6, 0xf2, 0xc2, 0xb7, 0x97}: "DevFwUpd",
		efi.GUID{0x23, 0xd1, 0xc5, 0x6a, 0xe5, 0xc6, 0xba, 0x41, 0x9b, 0xe3, 0xa0, 0x37, 0x1e, 0xe5, 0x4b, 0x78}: "SetupConfigUpdateDxeNeonCityFPGA",
		efi.GUID{0x23, 0xe7, 0x6a, 0x32, 0x32, 0xae, 0x89, 0x45, 0x98, 0xb8, 0xca, 0xc2, 0x3c, 0xdc, 0xc1, 0xb1}: "PcAtChipsetPkgTokenSpaceGuid",
		efi.GUID{0x23, 0xf1, 0xa9, 0xe8, 0xdf, 0x07, 0xe2, 0x46, 0x9b, 0xf6, 0xc5, 0x93, 0xca, 0xf0, 0x6a, 0x62}: "HardwareHealthManagementDxe",
		efi.GUID{0x23, 0xfe, 0xb7, 0xce, 0xa1, 0x21, 0x5c, 0x4b, 0x8e, 0x92, 0x2e, 0x7b, 0x52, 0xa9, 0x50, 0x76}: "Legacy8259",
		efi.GUID{0x24, 0x07, 0x74, 0x31, 0x96, 0x5f, 0xca, 0x48, 0xaa, 0x0f, 0x33, 0x2a, 0xca, 0x6b, 0x9a, 0x75}: "SpcrAcpiDxe",
		efi.GUID{0x24, 0x0a, 0x6e, 0x7f, 0xfd, 0xdb, 0xdf, 0x43, 0x97, 0x55, 0x02, 0x92, 0xd7, 0xd3, 0xdd, 0x48}: "IsaFloppyPei",
		efi.GUID{0x24, 0x13, 0xd4, 0x5d, 0x1e, 0xe8, 0x82, 0x45, 0xa4, 0x5a, 0xbf, 0x8e, 0x53, 0xa9, 0x15, 0x48}: "OdmDxeGNVS",
		efi.GUID{0x24, 0x18, 0xc4, 0x8e, 0x58, 0x66, 0x55, 0x4b, 0x93, 0x64, 0x77, 0x1a, 0x06, 0x58, 0xf5, 0xe2}: "WarmResetFlagShell",
		efi.GUID{0x24, 0x24, 0x88, 0x01, 0xb1, 0x63, 0x30, 0x4e, 0x90, 0xe8, 0x4c, 0x2c, 0x34, 0x4e, 0x89, 0xc0}: "RecoveryCpuInitPei",
		efi.GUID{0x24, 0x2a, 0x42, 0x7a, 0xf1, 0x0c, 0x7d, 0x40, 0xaa, 0xf1, 0x6a, 0x74, 0xc0, 0x10, 0x3b, 0x98}: "SystemUsbHidPointerDxe",
		efi.GUID{0x24, 0x38, 0x51, 0xf5, 0x68, 0xba, 0x45, 0x01, 0xae, 0xd9, 0xe0, 0xa8, 0x9f, 0xab, 0x40, 0xb9}: "DpcDxe",
		efi.GUID{0x24, 0x45, 0x96, 0xda, 0xe5, 0xd0, 0x32, 0x4c, 0x90, 0xd0, 0x01, 0x00, 0x21, 0xcf, 0xb2, 0xdc}: "PMBUSDXE",
		efi.GUID{0x24, 0x46, 0x50, 0x00, 0x59, 0x8a, 0xeb, 0x4e, 0xbd, 0x0f, 0x6b, 0x36, 0xe9, 0x61, 0x28, 0xe0}: "FpNvStorage",
		efi.GUID{0x24, 0x48, 0x22, 0x71, 0x22, 0x6c, 0xd7, 0x45, 0x9c, 0x1a, 0x9e, 0x7c, 0xbf, 0xf1, 0x89, 0x24}: "NCT6106DSECPeiInit",
		efi.GUID{0x24, 0x4a, 0xa5, 0x67, 0x4f, 0x3f, 0x48, 0x40, 0x87, 0x87, 0x3e, 0x5a, 0xa2, 0xa0, 0xb7, 0xd2}: "SAPolicy",
		efi.GUID{0x24, 0x4c, 0x84, 0x75, 0xfe, 0xa8, 0x31, 0x43, 0x8d, 0x0b, 0x55, 0x4c, 0x46, 0x06, 0x00, 0x9b}: "RTKUSB",
		efi.GUID{0x24, 0x52, 0x84, 0x0a, 0x75, 0x86, 0x41, 0x42, 0x8a, 0xe9, 0x4d, 0x94, 0xc9, 0x3d, 0xeb, 0x90}: "PauseKey",
		efi.GUID{0x24, 0x54, 0x65, 0xdf, 0x25, 0x00, 0x4f, 0x4d, 0x82, 0xb0, 0x6d, 0xac, 0x25, 0x8b, 0xa8, 0x79}: "NetworkOffLineLockerProtocol",
		efi.GUID{0x24, 0x73, 0x6e, 0x05, 0x18, 0xa7, 0x5b, 0x46, 0x9a, 0x84, 0x22, 0x8f, 0x06, 0x64, 0x2b, 0x4f}: "DxePlatform",
		efi.GUID{0x24, 0x74, 0xff, 0xa1, 0x1a, 0x7a, 0x8e, 0x47, 0xa9, 0xe4, 0x92, 0xf3, 0x57, 0xd1, 0x28, 0x32}: "LoaderMemoryMapInfo",
		efi.GUID{0x24, 0x7f, 0x32, 0xfa, 0xe2, 0x2d, 0x60, 0x4b, 0x87, 0x1a, 0x43, 0x6b, 0xc9, 0x06, 0x05, 0xd4}: "LEMComputraceApiDxe",
		efi.GUID{0x24, 0x80, 0x52, 0xfa, 0xa6, 0x59, 0x89, 0x46, 0xbe, 0xa0, 0xb5, 0x55, 0xd8, 0x7d, 0x7d, 0xbe}: "FpgaFvDataLibDxe",
		efi.GUID{0x24, 0x8b, 0x4d, 0xf6, 0x12, 0x1f, 0xa4, 0x47, 0x91, 0xad, 0x5e, 0xfc, 0x61, 0x36, 0xb7, 0x36}: "LEMDiskRelatedProtocolNull",
		efi.GUID{0x24, 0x8f, 0x42, 0xe7, 0x0c, 0xef, 0xe4, 0x4a, 0xb5, 0x21, 0x9d, 0x24, 0x74, 0x94, 0x90, 0x0e}: "OnBrdDevOprom",
		efi.GUID{0x24, 0xa8, 0x0c, 0x47, 0x87, 0xf6, 0x48, 0x41, 0x88, 0x5e, 0x46, 0x31, 0x12, 0x41, 0xc2, 0x01}: "PchEhciPei",
		efi.GUID{0x24, 0xaa, 0xb0, 0x12, 0x37, 0xac, 0xf2, 0x43, 0xa8, 0x4e, 0x3c, 0xca, 0x64, 0x37, 0xbf, 0x6d}: "AmdLegacyInterrupt",
		efi.GUID{0x24, 0xac, 0x93, 0xbc, 0xaa, 0xbb, 0xde, 0x49, 0x8e, 0xb5, 0x23, 0x96, 0xf8, 0x79, 0x29, 0xe0}: "AmdNbioAlibRMBDxe",
		efi.GUID{0x24, 0xac, 0xf1, 0x96, 0x21, 0x2b, 0xfa, 0x45, 0xa0, 0xb5, 0x67, 0x01, 0x0c, 0x95, 0xe9, 0xd8}: "AhciMmioSmm",
		efi.GUID{0x24, 0xb7, 0x20, 0x2c, 0x03, 0xc9, 0x5d, 0x43, 0xa5, 0xe5, 0x28, 0x99, 0xe2, 0x91, 0xd9, 0x4e}: "AmdCpmPmfBoardDxe",
		efi.GUID{0x24, 0xb7, 0x37, 0x3b, 0xf7, 0x4a, 0x35, 0x4a, 0x97, 0xb3, 0xd2, 0xfb, 0x8f, 0x4f, 0x56, 0x3c}: "DellStopShipConfig",
		efi.GUID{0x24, 0xb7, 0x8e, 0x8f, 0x9e, 0x13, 0x32, 0x4a, 0xa3, 0xd0, 0xf7, 0xd3, 0x76, 0xe5, 0xb9, 0x08}: "RecoveryDeviceMap",
		efi.GUID{0x24, 0xbb, 0x83, 0x43, 0x0f, 0x2e, 0xab, 0x47, 0x89, 0x55, 0xb9, 0xee, 0x71, 0x0a, 0xce, 0x52}: "FjLanRtl8111xSmm",
		efi.GUID{0x24, 0xbc, 0x73, 0x69, 0xf4, 0x57, 0xb0, 0x46, 0x87, 0x66, 0xc0, 0x25, 0xab, 0xb9, 0x7a, 0xa4}: "NvmeShutdownNotificationDxe",
		efi.GUID{0x24, 0xc7, 0x26, 0x1b, 0xd4, 0xc7, 0xe6, 0x4d, 0xb0, 0xb1, 0xc6, 0x22, 0xbc, 0x29, 0x37, 0xff}: "SmartCoverPortingDxe",
		efi.GUID{0x24, 0xd0, 0x18, 0x3d, 0x2f, 0xea, 0xdd, 0x4e, 0x9f, 0xe3, 0x67, 0x2a, 0x37, 0xdb, 0x80, 0x2d}: "OsTransparentUpdate",
		efi.GUID{0x24, 0xd3, 0x94, 0x9d, 0x45, 0x0d, 0x7d, 0x40, 0x93, 0x37, 0x73, 0x4c, 0xf9, 0x2c, 0x0e, 0xf2}: "KeyboardConfig",
		efi.GUID{0x24, 0xd5, 0x95, 0xe9, 0x97, 0x6b, 0xbf, 0x41, 0x8c, 0xe3, 0xd7, 0xc8, 0x89, 0x74, 0x22, 0x46}: "H19ReadBackDefaultData",
		efi.GUID{0x24, 0xd6, 0xfb, 0xc1, 0xea, 0x27, 0xd1, 0x40, 0xaa, 0x48, 0x94, 0xc3, 0xdc, 0x5c, 0x7e, 0x0d}: "SbPei",
		efi.GUID{0x24, 0xdf, 0xec, 0x37, 0x53, 0x84, 0x6a, 0x47, 0xab, 0x58, 0xf4, 0xcf, 0x8b, 0xfe, 0x67, 0x42}: "LenovoPhxGopDxe",
		efi.GUID{0x24, 0xe3, 0x2d, 0x39, 0x62, 0xe9, 0x7a, 0x4a, 0xb6, 0x2d, 0x10, 0x41, 0x4a, 0xf6, 0xb9, 0xc8}: "HousingMonitoringDxe",
		efi.GUID{0x24, 0xe4, 0x58, 0x9f, 0x6b, 0xb9, 0xa5, 0x45, 0xad, 0xdc, 0xd2, 0xfe, 0x39, 0x4a, 0x99, 0xd9}: "AmiPeiEndMemoryDetect",
		efi.GUID{0x24, 0xe6, 0xc4, 0x03, 0x28, 0xac, 0xd3, 0x11, 0x9a, 0x2d, 0x00, 0x90, 0x29, 0x3f, 0xc1, 0x4d}: "EfiPxeDhcp4Protocol",
		efi.GUID{0x24, 0xe8, 0xac, 0xa9, 0x86, 0x44, 0xe6, 0x44, 0x91, 0x5a, 0x8f, 0xba, 0xed, 0x07, 0x99, 0xb9}: "SetupDataProviderDxe",
		efi.GUID{0x24, 0xea, 0x97, 0x2e, 0x66, 0x58, 0x40, 0x42, 0xa8, 0x91, 0xd2, 0x0a, 0xfc, 0x60, 0x74, 0xff}: "AmdFabricZpSmm",
		efi.GUID{0x24, 0xec, 0x17, 0x93, 0xb0, 0x7c, 0x0e, 0x4d, 0x8b, 0x32, 0x2e, 0xd9, 0x20, 0x9c, 0xd8, 0xaf}: "EfiPaddingRsassaPkcs1V1P5Guid",
		efi.GUID{0x25, 0x01, 0xd7, 0x86, 0xa3, 0xba, 0x96, 0x42, 0xa6, 0x2f, 0x60, 0x2b, 0xeb, 0xbb, 0x90, 0x81}: "DxeIpl",
		efi.GUID{0x25, 0x03, 0xf3, 0x9c, 0x5c, 0xdc, 0x56, 0x45, 0xa8, 0xb0, 0x74, 0x21, 0x5c, 0x5f, 0x7f, 0xc4}: "HeciPei",
		efi.GUID{0x25, 0x19, 0x8e, 0x01, 0xa2, 0xd6, 0x2a, 0x4a, 0x89, 0x58, 0x81, 0x76, 0x10, 0xa1, 0x5a, 0xdf}: "PeiS3LibNull",
		efi.GUID{0x25, 0x1b, 0x14, 0x54, 0x23, 0xd6, 0xb8, 0x42, 0xa2, 0x49, 0x3c, 0x2b, 0xb7, 0x39, 0xac, 0x4c}: "DummyDriverDxe",
		efi.GUID{0x25, 0x1b, 0xe6, 0x3f, 0xbd, 0xd0, 0x07, 0x49, 0x9c, 0xe0, 0xf5, 0x28, 0x57, 0x18, 0x82, 0x4e}: "It8587eFlashDxe",
		efi.GUID{0x25, 0x1f, 0xb6, 0x35, 0xf2, 0xab, 0x11, 0x4a, 0xa2, 0xd4, 0x23, 0x9c, 0xa4, 0x75, 0x34, 0x9c}: "AmdCpmVRMOverride",
		efi.GUID{0x25, 0x24, 0xd9, 0x9d, 0x37, 0x67, 0xcd, 0x45, 0x82, 0x9c, 0x1a, 0xc2, 0xcd, 0x20, 0xc8, 0x73}: "LenovoAt24Rf08EepromPei",
		efi.GUID{0x25, 0x24, 0xfa, 0x76, 0x6f, 0x08, 0x33, 0x4e, 0x8d, 0xff, 0x4e, 0x7d, 0x96, 0x1a, 0x67, 0xdc}: "FjSiidRt",
		efi.GUID{0x25, 0x2d, 0xba, 0x9e, 0xe3, 0xbb, 0xc2, 0x4a, 0xa2, 0xc6, 0xc8, 0x7f, 0x44, 0xa1, 0x27, 0x8c}: "PasswordUI",
		efi.GUID{0x25, 0x33, 0x86, 0x88, 0x03, 0xc8, 0x9b, 0x46, 0x99, 0x04, 0x6f, 0xb2, 0xe3, 0x3f, 0x00, 0x70}: "AssetIDOnS3",
		efi.GUID{0x25, 0x48, 0x9d, 0x8f, 0x7d, 0x79, 0xfc, 0x48, 0x84, 0x71, 0x84, 0x50, 0x25, 0x79, 0x2e, 0xf6}: "EdkiiS3SmmInitDone",
		efi.GUID{0x25, 0x4d, 0xf3, 0x01, 0xe2, 0x4d, 0xad, 0x23, 0x3f, 0xf3, 0x36, 0x35, 0x3f, 0xf3, 0x23, 0xf1}: "EfiPeiPcdPpiGuid",
		efi.GUID{0x25, 0x4e, 0x37, 0x7e, 0x01, 0x8e, 0xee, 0x4f, 0x87, 0xf2, 0x39, 0x0c, 0x23, 0xc6, 0x06, 0xcd}: "PlatformAcpiTable",
		efi.GUID{0x25, 0x56, 0x2d, 0x63, 0x3d, 0xb7, 0xb8, 0x43, 0xaf, 0x30, 0x8d, 0x22, 0x5d, 0x96, 0x16, 0x8e}: "BasePalLibNull",
		efi.GUID{0x25, 0x5b, 0xc3, 0x96, 0x9b, 0x31, 0xbd, 0x4a, 0x9f, 0x6b, 0x02, 0xed, 0x49, 0xbc, 0xbd, 0x1e}: "GuiPwdPrompt",
		efi.GUID{0x25, 0x5c, 0xc8, 0x74, 0xdd, 0x09, 0x7d, 0x49, 0x9f, 0x71, 0x91, 0xc1, 0x72, 0x28, 0x3e, 0xd4}: "SioFanMapDxe",
		efi.GUID{0x25, 0x62, 0x43, 0x4a, 0xb5, 0xa1, 0xe1, 0x48, 0x82, 0x8c, 0x4e, 0x8e, 0x62, 0x5f, 0x3e, 0xd6}: "FjGabiEntrySmm",
		efi.GUID{0x25, 0x63, 0x92, 0x1a, 0x64, 0x27, 0xc8, 0x47, 0x9e, 0x1c, 0x4f, 0x83, 0xb1, 0x72, 0x33, 0x36}: "VirtualEcDxe",
		efi.GUID{0x25, 0x64, 0xf6, 0x53, 0xf2, 0x21, 0xf3, 0x45, 0x99, 0xd5, 0xec, 0xae, 0x1e, 0x21, 0x66, 0x3a}: "H19TpmDetection",
		efi.GUID{0x25, 0x71, 0x52, 0x11, 0xb2, 0x78, 0x3e, 0x4d, 0xa0, 0xdf, 0x41, 0xe7, 0x5c, 0x22, 0x1f, 0x5a}: "CpuS3",
		efi.GUID{0x25, 0x74, 0x0f, 0xa2, 0x87, 0xbc, 0xd1, 0x47, 0x94, 0x5c, 0x63, 0x76, 0x03, 0x32, 0x35, 0x84}: "PlatformConfigTool",
		efi.GUID{0x25, 0x74, 0x25, 0xfb, 0x55, 0x8c, 0xe8, 0x4d, 0x82, 0x38, 0xf5, 0x39, 0x06, 0xaa, 0x5b, 0x94}: "IrqBoardInfoRvpDt",
		efi.GUID{0x25, 0x81, 0xb3, 0xbd, 0x63, 0x4d, 0xf4, 0x49, 0x82, 0x12, 0x61, 0xcf, 0x5a, 0x19, 0x0a, 0xf8}: "EfiUserInfoAccessSetupRestrictedGuid",
		efi.GUID{0x25, 0x87, 0x4d, 0xf8, 0xdf, 0x5a, 0xd2, 0x48, 0x88, 0x19, 0x1b, 0x03, 0x31, 0xae, 0xb7, 0x19}: "DRYPEI",
		efi.GUID{0x25, 0x8a, 0xc9, 0xbb, 0xb0, 0x89, 0x4b, 0x47, 0xac, 0x85, 0x8e, 0x52, 0x4e, 0xb3, 0x3e, 0x25}: "PchSmiRegister",
		efi.GUID{0x25, 0x95, 0xbb, 0x7b, 0xba, 0x97, 0x16, 0x45, 0xb6, 0x60, 0x1b, 0x0e, 0xb7, 0x87, 0x44, 0xa5}: "DellSmBiosStrucD0",
		efi.GUID{0x25, 0xa7, 0xe7, 0x35, 0xd2, 0x8d, 0xac, 0x4c, 0x80, 0x11, 0x33, 0xcd, 0xa8, 0x10, 0x90, 0x56}: "EfiJsonCapsuleDataTable",
		efi.GUID{0x25, 0xb2, 0x17, 0x34, 0x6a, 0x91, 0xf5, 0x49, 0x9a, 0xf5, 0xc9, 0xc7, 0xbf, 0x93, 0x7e, 0xa2}: "EfiMemoryMapDataHobBdat",
		efi.GUID{0x25, 0xb2, 0x1a, 0x6b, 0x47, 0x2e, 0x61, 0x4a, 0x8f, 0xf5, 0xb8, 0xea, 0x42, 0xee, 0x3e, 0xa8}: "SecureFlashDxe",
		efi.GUID{0x25, 0xb2, 0x63, 0xf3, 0x2c, 0x4d, 0x52, 0x43, 0x80, 0xcd, 0x8e, 0xa4, 0x28, 0x0f, 0x8d, 0xc0}: "OemEdidFromGop",
		efi.GUID{0x25, 0xb2, 0xa1, 0x9f, 0x46, 0x33, 0x1b, 0x46, 0xa0, 0x69, 0xed, 0x01, 0xb6, 0x73, 0xd2, 0x40}: "EfiI2cBusProtocolGuid",
		efi.GUID{0x25, 0xb3, 0x3d, 0x64, 0x52, 0xa2, 0xd5, 0x4b, 0xb5, 0x63, 0xce, 0xa7, 0x3d, 0x64, 0xad, 0xa8}: "FjSystemDataFvDriverDxe",
		efi.GUID{0x25, 0xc8, 0x38, 0x31, 0xed, 0x83, 0x4a, 0x06, 0xa6, 0x2a, 0xcd, 0x13, 0x67, 0x4e, 0x3f, 0x89}: "AppleDhcp4",
		efi.GUID{0x25, 0xce, 0xe2, 0x0d, 0x6a, 0x44, 0xa7, 0x45, 0xbf, 0xc9, 0x37, 0xda, 0x26, 0x34, 0x4b, 0x37}: "EfiPeiDeviceRecoveryModulePpiGuid",
		efi.GUID{0x25, 0xd2, 0xd0, 0x59, 0xd7, 0x38, 0x28, 0x48, 0xa7, 0xf9, 0x1a, 0xb9, 0xbb, 0xf3, 0x97, 0xa0}: "MAPS_SerialPortControlSmm",
		efi.GUID{0x25, 0xd6, 0x61, 0xeb, 0x5d, 0x1b, 0x45, 0x4f, 0xa2, 0xa0, 0x93, 0x1e, 0xf7, 0x28, 0x0b, 0x48}: "SmartAssetTagInfoDxe",
		efi.GUID{0x25, 0xd7, 0x84, 0xcc, 0x1e, 0xda, 0xa7, 0x46, 0x9e, 0x75, 0x4b, 0xac, 0xf1, 0xfd, 0x39, 0x02}: "SystemFontDxe",
		efi.GUID{0x25, 0xda, 0xf1, 0x9a, 0x6c, 0xf0, 0xbb, 0x43, 0xbe, 0x88, 0x83, 0x45, 0x50, 0xbf, 0x76, 0x5b}: "DellGSetConfig",
		efi.GUID{0x25, 0xdc, 0xec, 0xf6, 0x79, 0x20, 0x5a, 0x47, 0xb0, 0xe8, 0xf4, 0x8b, 0x8f, 0xa5, 0xc2, 0x0a}: "DellSTMicroTpmFwMgmtDxe",
		efi.GUID{0x25, 0xe1, 0xea, 0x45, 0x1d, 0x2a, 0xe0, 0x44, 0x99, 0x53, 0x7a, 0xb7, 0xf1, 0x98, 0x88, 0xaf}: "DellDashPolicyVer3Protocol",
		efi.GUID{0x25, 0xe2, 0x3c, 0xcc, 0xe0, 0xd9, 0xb1, 0x4a, 0xad, 0x66, 0xb8, 0x57, 0xc2, 0xd1, 0x6d, 0x2e}: "FchKeithSsdt",
		efi.GUID{0x25, 0xfe, 0x01, 0x89, 0xd3, 0x27, 0x15, 0x48, 0xa6, 0x3d, 0x35, 0x85, 0x1c, 0x4f, 0x50, 0xef}: "FjGabiPostFlashAbstraction",
		efi.GUID{0x26, 0x09, 0x2a, 0x33, 0x9b, 0x42, 0x24, 0x46, 0x92, 0x11, 0xa3, 0x6b, 0x23, 0xdf, 0x03, 0x89}: "OhciPei",
		efi.GUID{0x26, 0x0b, 0x16, 0x6c, 0x4c, 0xe0, 0x98, 0x40, 0xa6, 0xac, 0xc8, 0xc7, 0xb6, 0x47, 0x1a, 0x86}: "SetupConfigUpdateDxeLightningRidgeEXECB2",
		efi.GUID{0x26, 0x0d, 0x0a, 0x59, 0xe5, 0x06, 0x20, 0x4d, 0x8a, 0x82, 0x59, 0xea, 0x1b, 0x34, 0x98, 0x2d}: "UniversalPayloadSmbiosTable",
		efi.GUID{0x26, 0x0f, 0xeb, 0x30, 0x0a, 0xfc, 0xd2, 0x4f, 0xb9, 0xc9, 0x75, 0x1e, 0xa2, 0xbb, 0x19, 0x80}: "DataSource",
		efi.GUID{0x26, 0x12, 0xb8, 0xa7, 0x2b, 0xfe, 0xb3, 0x43, 0x9b, 0xc7, 0x6b, 0x24, 0xb5, 0x92, 0x0d, 0xbf}: "DellAcLossPei",
		efi.GUID{0x26, 0x16, 0xc4, 0xc1, 0x4c, 0x50, 0x92, 0x40, 0xac, 0xa9, 0x41, 0xf9, 0x36, 0x93, 0x43, 0x28}: "EfiCertSha256Guid",
		efi.GUID{0x26, 0x18, 0xba, 0x93, 0xfb, 0xdf, 0xdd, 0x45, 0x82, 0xa7, 0xe7, 0xdc, 0xaa, 0x3b, 0xbd, 0xf3}: "SmmVariableWriteGuid",
		efi.GUID{0x26, 0x1a, 0x26, 0xca, 0x18, 0x77, 0x9b, 0x4b, 0x8a, 0x07, 0x51, 0x78, 0xb1, 0xae, 0x3a, 0x02}: "DiskIoDxe",
		efi.GUID{0x26, 0x1a, 0xf1, 0xd9, 0x9c, 0x24, 0xac, 0x46, 0x9c, 0xb5, 0xe4, 0xf7, 0x7e, 0x03, 0x5c, 0x90}: "NetworkRecoveryNameLabel",
		efi.GUID{0x26, 0x1d, 0x57, 0xc0, 0x76, 0x61, 0xe9, 0x11, 0x86, 0x47, 0xd6, 0x63, 0xbd, 0x87, 0x3d, 0x93}: "DebugInfo",
		efi.GUID{0x26, 0x21, 0x3b, 0x11, 0x8a, 0xfc, 0xe3, 0x11, 0xbd, 0x6c, 0xb8, 0xe8, 0x56, 0x2c, 0xba, 0xfa}: "EfiBootManagerPolicyConnectAllGuid",
		efi.GUID{0x26, 0x22, 0x9c, 0x73, 0x64, 0x32, 0x54, 0x44, 0x99, 0x1c, 0x8d, 0xc4, 0x4a, 0x73, 0xd6, 0xaf}: "ProjectPeiDriver",
		efi.GUID{0x26, 0x25, 0x73, 0xb0, 0xc8, 0x38, 0x40, 0x4b, 0x88, 0x77, 0x61, 0xc7, 0xb0, 0x6a, 0xac, 0x45}: "EfiCpuIoProtocolGuid",
		efi.GUID{0x26, 0x2d, 0x42, 0x61, 0xec, 0x81, 0xff, 0x47, 0xb6, 0xcf, 0x93, 0x9e, 0xae, 0xe7, 0x3f, 0xba}: "StatusCodeDxe",
		efi.GUID{0x26, 0x30, 0xc5, 0x6f, 0xdc, 0x4a, 0xed, 0x41, 0x80, 0xa6, 0xb8, 0x92, 0x34, 0x71, 0xde, 0x34}: "FjSystemConfigurationSmm",
		efi.GUID{0x26, 0x34, 0x23, 0x46, 0x4e, 0x74, 0x63, 0x47, 0x95, 0x8d, 0x44, 0xb1, 0x20, 0x0b, 0x32, 0x0a}: "AmdMemoryHobInfoPeim",
		efi.GUID{0x26, 0x3a, 0x0c, 0x95, 0xc2, 0xe0, 0x1c, 0x49, 0xb6, 0xb2, 0x03, 0x74, 0xf5, 0xc7, 0x3b, 0x96}: "SmmChildDispatcher2",
		efi.GUID{0x26, 0x3c, 0x81, 0x8a, 0x97, 0x02, 0x08, 0x46, 0x97, 0x5a, 0x2d, 0x74, 0x42, 0x04, 0xc7, 0x46}: "LenovoTamperSmm",
		efi.GUID{0x26, 0x4b, 0x43, 0xe5, 0xdf, 0xae, 0xde, 0x43, 0x89, 0x35, 0xd1, 0xc4, 0x85, 0xa9, 0x12, 0xb9}: "EfiPeiPlatformTypeOpalCityFpgaPpi",
		efi.GUID{0x26, 0x4c, 0xe2, 0x94, 0xfa, 0x80, 0x7d, 0x42, 0x80, 0xfb, 0xe3, 0x74, 0xe9, 0xe9, 0xbf, 0x85}: "Dhcp6Dxe",
		efi.GUID{0x26, 0x4d, 0xb4, 0x6e, 0x39, 0x1d, 0xeb, 0x4f, 0xa9, 0x93, 0x4d, 0xaa, 0xfb, 0x5f, 0x8d, 0x85}: "HybridDriver",
		efi.GUID{0x26, 0x52, 0x74, 0x3e, 0x18, 0x98, 0xb6, 0x45, 0xa2, 0xac, 0xd7, 0xcd, 0x0e, 0x8b, 0xa2, 0xbc}: "EfiUsb2HcProtocolGuid",
		efi.GUID{0x26, 0x59, 0x9d, 0x6a, 0x27, 0xeb, 0x3e, 0x47, 0x82, 0xe3, 0x22, 0x3b, 0x12, 0xcc, 0xaa, 0x12}: "FjGabiFlashCoreAbstractionDxe",
		efi.GUID{0x26, 0x62, 0x48, 0x24, 0xc2, 0xf8, 0xf5, 0x41, 0xb9, 0xdd, 0x78, 0x3e, 0x9e, 0x56, 0xde, 0xa0}: "EfiMmioDeviceProtocolGuid",
		efi.GUID{0x26, 0x87, 0xa1, 0xf1, 0x79, 0xfd, 0xf5, 0x4d, 0xa3, 0x26, 0xe2, 0x0b, 0x8c, 0xc4, 0x6b, 0x06}: "DellBootScriptSmiHandler",
		efi.GUID{0x26, 0x88, 0x33, 0xeb, 0x1b, 0x68, 0x95, 0x42, 0xb3, 0x56, 0x2b, 0x36, 0x4c, 0x75, 0x7b, 0x09}: "EfiFtp4ProtocolGuid",
		efi.GUID{0x26, 0x92, 0xb4, 0x88, 0x3f, 0xa6, 0x05, 0x45, 0x9d, 0x3c, 0xb5, 0xa6, 0x7b, 0x84, 0x61, 0x33}: "FrameworkSmmStatusCodeOnPiSmmStatusCodeThunk",
		efi.GUID{0x26, 0x96, 0x14, 0x10, 0x83, 0x55, 0x64, 0x43, 0x82, 0x2f, 0xa4, 0x59, 0xb8, 0x12, 0x13, 0x02}: "SystemFirmwareDeviceDxe",
		efi.GUID{0x26, 0x98, 0x64, 0x99, 0x2b, 0x95, 0xd5, 0x4e, 0x92, 0xa8, 0x4e, 0xd6, 0x9b, 0x71, 0x7f, 0xe3}: "AaeonGpnvSmm",
		efi.GUID{0x26, 0x9b, 0xc6, 0xd2, 0xe1, 0x82, 0x1b, 0x4a, 0xad, 0x35, 0xed, 0x02, 0x61, 0xb9, 0xf3, 0x47}: "MemoryInitPei",
		efi.GUID{0x26, 0xa8, 0x26, 0x98, 0x4e, 0x00, 0x97, 0x41, 0xb1, 0x79, 0x9f, 0x48, 0x9a, 0xf1, 0xe3, 0xc9}: "SystemBoardInfo",
		efi.GUID{0x26, 0xaa, 0x69, 0xe4, 0x68, 0x92, 0xb0, 0x4e, 0xa0, 0x87, 0xdd, 0x4c, 0xee, 0x37, 0x40, 0x4b}: "SecuritySelectDxe",
		efi.GUID{0x26, 0xad, 0xfa, 0xbd, 0x7f, 0x4d, 0xa6, 0x44, 0x87, 0x19, 0x37, 0x5e, 0xcb, 0x4a, 0xa4, 0x07}: "DellPxeBaseRom",
		efi.GUID{0x26, 0xaf, 0xb0, 0x70, 0x47, 0xf8, 0xb6, 0x4b, 0xaa, 0xb9, 0xcd, 0xe8, 0x4f, 0xc6, 0x14, 0x31}: "EdkiiIoMmuPpi",
		efi.GUID{0x26, 0xb1, 0xb4, 0xe9, 0x13, 0x4e, 0xf5, 0x41, 0x9e, 0x4c, 0x9b, 0xf8, 0x8b, 0x3c, 0x1b, 0x0c}: "KbdConfig",
		efi.GUID{0x26, 0xbd, 0x47, 0xe8, 0xc5, 0x1d, 0xe0, 0x4d, 0xbf, 0x2f, 0x25, 0x4f, 0x61, 0xa5, 0xb4, 0xda}: "GfxInitPei",
		efi.GUID{0x26, 0xc0, 0x0c, 0x06, 0x0d, 0x4c, 0xda, 0x4d, 0x8f, 0x41, 0x59, 0x5f, 0xef, 0x00, 0xa5, 0x02}: "MemoryStatusCodeRecordGuid",
		efi.GUID{0x26, 0xc3, 0x21, 0x1e, 0x40, 0x0d, 0xf2, 0x40, 0x9f, 0x02, 0x3a, 0x9b, 0x78, 0x38, 0xaa, 0x6b}: "AmiIpmiPkgTokenSpace",
		efi.GUID{0x26, 0xca, 0x1a, 0x82, 0xea, 0x29, 0x93, 0x49, 0x83, 0x9f, 0x59, 0x7f, 0xc0, 0x21, 0x70, 0x8d}: "AbsoluteAbtInstaller",
		efi.GUID{0x26, 0xd3, 0x85, 0x4d, 0xe0, 0x58, 0xfd, 0x43, 0x9f, 0x63, 0x58, 0xdf, 0x46, 0x78, 0x9b, 0x7f}: "PciResourceAlloc",
		efi.GUID{0x26, 0xd8, 0x4c, 0x8f, 0xa0, 0xa5, 0x93, 0x4e, 0x95, 0x22, 0xcf, 0xb0, 0xab, 0x72, 0x92, 0x6c}: "SataController",
		efi.GUID{0x26, 0xe9, 0xbe, 0x78, 0x2f, 0x69, 0xfd, 0x48, 0x9e, 0xdb, 0x01, 0x42, 0x2e, 0xf0, 0xd7, 0xab}: "EfiEventMemoryMapChangeGuid",
		efi.GUID{0x26, 0xe9, 0xd1, 0xaa, 0xb8, 0x23, 0x3a, 0x4c, 0x8b, 0x44, 0x0c, 0x9a, 0x03, 0x16, 0x64, 0xf2}: "FmpDxe",
		efi.GUID{0x26, 0xeb, 0x58, 0x79, 0x98, 0xc0, 0xec, 0x46, 0xb5, 0xb7, 0xbe, 0x9f, 0xf1, 0x3f, 0x8e, 0x32}: "DellBoardPolicyPei",
		efi.GUID{0x26, 0xfd, 0x30, 0xee, 0x24, 0x15, 0xa2, 0x4c, 0xb5, 0x6d, 0x34, 0x58, 0x30, 0xdc, 0x9c, 0xdb}: "LenovoFingerprintCp",
		efi.GUID{0x27, 0x03, 0x27, 0x27, 0xec, 0xd3, 0x37, 0x42, 0x97, 0x4d, 0xd7, 0x1a, 0xbb, 0x2e, 0xbf, 0xea}: "FjMasterPasswordDxe",
		efi.GUID{0x27, 0x14, 0x20, 0x8e, 0x3a, 0x46, 0x24, 0x4d, 0xa0, 0xf4, 0x25, 0xa8, 0x75, 0xf6, 0x1b, 0xaa}: "DellModBayConfig",
		efi.GUID{0x27, 0x14, 0x9a, 0x0d, 0x2a, 0xe0, 0x7d, 0x43, 0x92, 0x6b, 0xaa, 0x52, 0x1f, 0xd7, 0x22, 0xba}: "EfiPciLanInfoGuid",
		efi.GUID{0x27, 0x1f, 0xaa, 0xc6, 0x97, 0x55, 0x02, 0x48, 0x9f, 0x63, 0xd6, 0x28, 0x36, 0x59, 0x86, 0x35}: "SaPolicyProtocol",
		efi.GUID{0x27, 0x24, 0x1d, 0x35, 0x2c, 0x26, 0x0b, 0x4a, 0x87, 0x4c, 0x23, 0x70, 0x3b, 0x4a, 0xa8, 0x8d}: "AmdNbioBaseZPDxe",
		efi.GUID{0x27, 0x2d, 0x2e, 0x7c, 0xbd, 0xe8, 0x5c, 0x4f, 0xa5, 0x69, 0xaf, 0x65, 0xb7, 0x7a, 0xa5, 0x5d}: "DellPttSetupDxe",
		efi.GUID{0x27, 0x2f, 0x45, 0x26, 0xde, 0x45, 0x94, 0x4a, 0x80, 0x7a, 0x0e, 0x6f, 0xdc, 0x1c, 0xb9, 0x62}: "EmuPeiGateDxe",
		efi.GUID{0x27, 0x33, 0x4a, 0xe5, 0x45, 0xa3, 0x68, 0x40, 0x88, 0x42, 0x70, 0xac, 0x0d, 0x51, 0x98, 0x55}: "Tpm2DeviceLibDTpm",
		efi.GUID{0x27, 0x36, 0xa9, 0x9c, 0x5b, 0xb6, 0x24, 0x43, 0xa2, 0x02, 0xc0, 0xb4, 0x61, 0x76, 0x45, 0x43}: "EfiPeiSmbus2PpiGuid",
		efi.GUID{0x27, 0x38, 0xc0, 0x5d, 0xcb, 0xc9, 0x83, 0x4c, 0xb1, 0x5f, 0x6e, 0xaf, 0xbf, 0x86, 0x47, 0x6c}: "AppleUartDxe",
		efi.GUID{0x27, 0x47, 0xe3, 0x21, 0x81, 0x38, 0xee, 0x4d, 0x80, 0x20, 0xd8, 0x90, 0x8a, 0x98, 0x03, 0x11}: "EpuHwModeDxe",
		efi.GUID{0x27, 0x51, 0xc4, 0xb8, 0x9d, 0x8a, 0x62, 0x43, 0xb2, 0x0a, 0x6c, 0x00, 0x12, 0xcb, 0x14, 0x30}: "PlatformSecureVariableSmm",
		efi.GUID{0x27, 0x55, 0xc7, 0x15, 0x2a, 0x30, 0x72, 0x48, 0xbb, 0xed, 0x47, 0x30, 0xa0, 0xab, 0xff, 0xca}: "LegacyBootEvent",
		efi.GUID{0x27, 0x5a, 0x62, 0x9e, 0x40, 0x48, 0xcc, 0x47, 0xa6, 0xb5, 0x1e, 0x93, 0x11, 0xcf, 0xc6, 0x0e}: "Pkpub",
		efi.GUID{0x27, 0x5c, 0x67, 0x1c, 0xb1, 0x6f, 0x70, 0x41, 0x94, 0xe7, 0x3d, 0xff, 0xe8, 0xbe, 0xad, 0xba}: "LaunchPad3Drv",
		efi.GUID{0x27, 0x60, 0xf0, 0x0b, 0xa4, 0x29, 0x7d, 0x44, 0x8f, 0xa4, 0xd8, 0xa2, 0x89, 0xf1, 0xdd, 0xdc}: "CxlManager",
		efi.GUID{0x27, 0x66, 0xcb, 0x2a, 0x02, 0xdf, 0x23, 0x4e, 0xb4, 0xf9, 0x6a, 0x93, 0xfa, 0x6e, 0x9d, 0xa6}: "EfiSataControllerProtocol",
		efi.GUID{0x27, 0x6d, 0x60, 0x9f, 0x18, 0xe2, 0x12, 0x41, 0x83, 0x4b, 0x8a, 0xbc, 0xe9, 0x50, 0xb1, 0xfb}: "SmbiosRpTable",
		efi.GUID{0x27, 0x6d, 0x70, 0x17, 0xfe, 0x83, 0x70, 0x47, 0x87, 0x5f, 0x4c, 0xef, 0x4c, 0xb8, 0xf6, 0x3d}: "AmiAhciPlatformPolicyProtocolGuid",
		efi.GUID{0x27, 0x75, 0x3d, 0x78, 0xee, 0x85, 0x95, 0x4a, 0xa9, 0x09, 0x03, 0xf7, 0x45, 0xe4, 0xe9, 0x1d}: "TimerSmiDxe",
		efi.GUID{0x27, 0x79, 0x54, 0xfb, 0xec, 0xda, 0x84, 0x48, 0xa1, 0x2e, 0x94, 0x10, 0x9f, 0xed, 0xf1, 0x8c}: "gear3",
		efi.GUID{0x27, 0x7b, 0x36, 0xd8, 0x08, 0x7a, 0xc5, 0x4a, 0xad, 0x1f, 0xc9, 0x3c, 0x3e, 0x94, 0x22, 0x5e}: "AodSmmRv",
		efi.GUID{0x27, 0x81, 0x1d, 0x7f, 0x69, 0xeb, 0xdd, 0x44, 0xa8, 0x8a, 0xed, 0x37, 0xbd, 0xb9, 0x7d, 0xb3}: "OemBadgingSmm",
		efi.GUID{0x27, 0x87, 0x78, 0xfc, 0xd0, 0xc2, 0x9c, 0x46, 0xbd, 0x03, 0x5a, 0xea, 0x03, 0x32, 0x3c, 0x67}: "GlobeMask",
		efi.GUID{0x27, 0x8b, 0xf5, 0x42, 0xc3, 0x5d, 0xa7, 0x4f, 0x84, 0x4d, 0x5a, 0x7d, 0xbf, 0xf0, 0x64, 0x32}: "Enquire",
		efi.GUID{0x27, 0x8d, 0x1f, 0x8d, 0xc2, 0x31, 0x5b, 0x4b, 0xb7, 0x36, 0x4b, 0xb5, 0xb4, 0xa2, 0x5f, 0xba}: "ASRGetDLSiteWrapper",
		efi.GUID{0x27, 0x94, 0xba, 0x6f, 0xf4, 0xb3, 0xae, 0x4a, 0xba, 0xf3, 0xc9, 0x72, 0x88, 0x51, 0x29, 0x94}: "LegacyUsbIrqSolutionWASmm",
		efi.GUID{0x27, 0x9a, 0x7e, 0xbd, 0xc5, 0xd6, 0x6a, 0x41, 0xb2, 0x45, 0x5f, 0x50, 0x7d, 0x95, 0xb2, 0xbd}: "WinNtBusDriverDxe",
		efi.GUID{0x27, 0xa2, 0xe8, 0xd3, 0x05, 0xe9, 0x7e, 0x40, 0x8f, 0x8f, 0xfe, 0xd3, 0x2f, 0xb2, 0xf9, 0x3b}: "DellUsbSmmCore",
		efi.GUID{0x27, 0xb3, 0xab, 0x0c, 0xfe, 0x11, 0x6b, 0x41, 0xae, 0x80, 0x2d, 0xe5, 0xdf, 0x60, 0xf7, 0x7d}: "IioPolicyHob",
		efi.GUID{0x27, 0xb8, 0xcb, 0xf4, 0xaf, 0xb4, 0xef, 0x4e, 0xb5, 0x12, 0xf3, 0xf8, 0x72, 0xf6, 0x7d, 0x7a}: "FjWakeEventDxe",
		efi.GUID{0x27, 0xbb, 0x53, 0xad, 0x96, 0xf6, 0x13, 0x42, 0xac, 0xbb, 0xae, 0xfa, 0x2f, 0x4b, 0x8b, 0xdc}: "OemModelIDDxe",
		efi.GUID{0x27, 0xbf, 0xd4, 0x4e, 0x92, 0x40, 0xe9, 0x42, 0x80, 0x7d, 0x52, 0x7b, 0x1d, 0x00, 0xc9, 0xbd}: "EfiHobMemoryAllocStackGuid",
		efi.GUID{0x27, 0xc7, 0xd8, 0x34, 0x83, 0xfa, 0xde, 0x4f, 0xbf, 0x51, 0x02, 0x42, 0x6e, 0x45, 0x33, 0xdb}: "FjGpnvPei",
		efi.GUID{0x27, 0xc8, 0x10, 0x48, 0x73, 0xb3, 0xc6, 0x47, 0xb5, 0x3e, 0xaa, 0xd3, 0x0e, 0x19, 0x7c, 0xa1}: "LEMPostFlagSMMProtocol",
		efi.GUID{0x27, 0xd3, 0x94, 0x9f, 0x18, 0x0b, 0x45, 0x42, 0x8f, 0xf2, 0x83, 0x2e, 0x30, 0x0d, 0x2c, 0xef}: "WifiConfig",
		efi.GUID{0x27, 0xe0, 0x2c, 0xfb, 0xe9, 0x10, 0x0a, 0x4f, 0xa7, 0xa9, 0x1b, 0x9d, 0x9c, 0xbd, 0x6d, 0xcc}: "RecoveryLedBlink",
		efi.GUID{0x27, 0xe0, 0x59, 0x59, 0xb0, 0xba, 0x42, 0x43, 0xaa, 0x4b, 0x8f, 0x73, 0xf0, 0x17, 0xb4, 0x85}: "OemRuntimeFunction",
		efi.GUID{0x27, 0xe3, 0xd1, 0x91, 0x5a, 0xfe, 0xb8, 0x49, 0xab, 0x65, 0x0e, 0xce, 0x2d, 0xdb, 0x45, 0xec}: "EdkiiDynamicTableFactoryProtocol",
		efi.GUID{0x27, 0xe4, 0x68, 0x55, 0xfc, 0x68, 0x3d, 0x4f, 0xac, 0x74, 0xca, 0x55, 0x52, 0x31, 0xcc, 0x68}: "LinuxEfiInitrdMedia",
		efi.GUID{0x27, 0xed, 0xf5, 0xbe, 0x93, 0x4e, 0xf8, 0x40, 0xae, 0x11, 0x6b, 0x41, 0xe1, 0xd4, 0xbc, 0xa9}: "AbtEraseDxe",
		efi.GUID{0x27, 0xf6, 0xeb, 0x28, 0xf1, 0x9b, 0x19, 0x47, 0xa6, 0x76, 0x4a, 0xf8, 0x36, 0x2f, 0xeb, 0x23}: "RTS5242Dxe",
		efi.GUID{0x27, 0xfa, 0x9c, 0x09, 0x4f, 0x13, 0x9a, 0x44, 0xaf, 0x4a, 0xd2, 0x9c, 0x44, 0x1c, 0xb5, 0x21}: "AsusAmlBuffDxe",
		efi.GUID{0x28, 0x07, 0xee, 0xa4, 0xd7, 0xe5, 0xc5, 0x4a, 0xb2, 0x1e, 0x65, 0x8e, 0xd8, 0x57, 0xe8, 0x34}: "ArmMpCoreInfoGuid",
		efi.GUID{0x28, 0x0a, 0x97, 0x47, 0x4a, 0x8f, 0xb2, 0x4c, 0x91, 0xde, 0xbf, 0x34, 0x41, 0x53, 0x18, 0x9a}: "AmiCspFlashLibNull",
		efi.GUID{0x28, 0x0c, 0xcb, 0xcc, 0x24, 0x4b, 0xd5, 0x11, 0x9a, 0x5a, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d}: "GraphicsConsoleDxe",
		efi.GUID{0x28, 0x11, 0x59, 0x2a, 0xc7, 0x6c, 0xb1, 0x42, 0x8a, 0xf0, 0x58, 0x93, 0x3b, 0x68, 0x2d, 0xbb}: "EfiExtendedSalMcaServicesProtocolGuid",
		efi.GUID{0x28, 0x19, 0x5a, 0xca, 0x23, 0x65, 0x9d, 0x40, 0xa9, 0xfe, 0x5d, 0xcc, 0x87, 0x38, 0x72, 0x22}: "TrEEPei",
		efi.GUID{0x28, 0x1b, 0x5f, 0xc7, 0x73, 0xb2, 0x0d, 0x4f, 0x98, 0x38, 0x95, 0x2b, 0x70, 0xe6, 0xb9, 0xb4}: "UsbCardReaderSmm",
		efi.GUID{0x28, 0x24, 0xda, 0xae, 0x22, 0x9a, 0x37, 0x46, 0x9b, 0x21, 0x54, 0x5e, 0x28, 0xfb, 0xb8, 0x29}: "EfiEblAddCommandProtocolGuid",
		efi.GUID{0x28, 0x28, 0xaf, 0x64, 0xfd, 0x82, 0xb7, 0x49, 0xbb, 0xd9, 0x7b, 0x02, 0xba, 0xb7, 0x2c, 0xd5}: "DellEDiagsSmm",
		efi.GUID{0x28, 0x2d, 0x9f, 0x85, 0x94, 0x28, 0xf7, 0x4e, 0xa0, 0x5c, 0xf8, 0xbf, 0xc7, 0x92, 0x2d, 0xb7}: "HidSimplePointer",
		efi.GUID{0x28, 0x2e, 0x7a, 0xfc, 0x78, 0xef, 0x72, 0x44, 0x8b, 0x17, 0xb8, 0xbb, 0x00, 0x24, 0x61, 0x6e}: "UefiRaid",
		efi.GUID{0x28, 0x3a, 0x67, 0xce, 0x0d, 0x80, 0x4a, 0x4b, 0x83, 0x16, 0x26, 0x61, 0xf9, 0xb3, 0xd9, 0xc6}: "DimmTsInfo",
		efi.GUID{0x28, 0x51, 0x15, 0x68, 0x86, 0xab, 0x7c, 0x43, 0xb2, 0x35, 0x4f, 0x86, 0x09, 0x39, 0xa5, 0x6c}: "TouchDriver",
		efi.GUID{0x28, 0x51, 0x45, 0x68, 0x86, 0xab, 0x7c, 0x43, 0xb2, 0x35, 0x4f, 0x86, 0x09, 0x39, 0xa5, 0x7c}: "TouchDriver",
		efi.GUID{0x28, 0x55, 0x50, 0x1c, 0xd7, 0x32, 0x70, 0x4d, 0x88, 0x18, 0x9a, 0x48, 0x9b, 0x41, 0x4a, 0xba}: "PcieErrorLog",
		efi.GUID{0x28, 0x5a, 0x70, 0x48, 0x4e, 0xff, 0x73, 0x45, 0x81, 0x64, 0xa0, 0x26, 0x96, 0x3d, 0x80, 0x1f}: "LenovoCapsuleUpdateVariable",
		efi.GUID{0x28, 0x6a, 0x5e, 0xc9, 0x95, 0xfb, 0xf2, 0x49, 0xae, 0x01, 0xf3, 0x81, 0x66, 0xfd, 0x45, 0x24}: "OemServicesDriver",
		efi.GUID{0x28, 0x6c, 0x2a, 0xec, 0x86, 0x22, 0xed, 0x44, 0x91, 0x6b, 0x24, 0x3a, 0xb5, 0x25, 0x35, 0x46}: "SLP20MarkerVariableGuid",
		efi.GUID{0x28, 0x71, 0xba, 0x79, 0xef, 0xd5, 0x41, 0x4b, 0x91, 0x2c, 0x5f, 0x80, 0xdc, 0x9e, 0x1b, 0x24}: "AmdMemoryHobInfoPeimRs",
		efi.GUID{0x28, 0x73, 0x2a, 0xc1, 0x1f, 0xf8, 0xd2, 0x11, 0xba, 0x4b, 0x00, 0xa0, 0xc9, 0x3e, 0xc9, 0x3b}: "EfiPartTypeSystemPartGuid",
		efi.GUID{0x28, 0x75, 0x17, 0x45, 0x6a, 0x7c, 0x5c, 0x4b, 0x9c, 0x56, 0x1a, 0x65, 0xbb, 0x5f, 0xc4, 0x34}: "AmdCcxVhRnPei",
		efi.GUID{0x28, 0x8c, 0x06, 0xc3, 0x79, 0x35, 0x70, 0x46, 0xb3, 0x8d, 0x2e, 0x21, 0xad, 0x05, 0x79, 0x93}: "PlatformHiiAdvancedDxe",
		efi.GUID{0x28, 0x95, 0xf0, 0x89, 0x3a, 0xc3, 0xfb, 0x47, 0xba, 0x19, 0xfa, 0xde, 0x80, 0xa3, 0x9f, 0x76}: "DxePlatformDxe",
		efi.GUID{0x28, 0xa1, 0x58, 0x3e, 0xc8, 0x55, 0x64, 0x41, 0xff, 0xff, 0xff, 0xff, 0x38, 0xa0, 0x56, 0x39}: "XnotePlatformPolicyRtDxe",
		efi.GUID{0x28, 0xa1, 0xf3, 0xad, 0x6d, 0x41, 0x60, 0x40, 0x8d, 0xdf, 0x30, 0xa1, 0xd7, 0xaa, 0xb6, 0x99}: "EfiSmmIchnDispatch2ProtocolGuid",
		efi.GUID{0x28, 0xa9, 0x95, 0x0c, 0x06, 0xa0, 0xd4, 0x11, 0xbc, 0xfa, 0x00, 0x80, 0xc7, 0x3c, 0x88, 0x81}: "EfiWinNtVirtualDisksGuid",
		efi.GUID{0x28, 0xad, 0xbe, 0x13, 0x8d, 0x48, 0x12, 0x91, 0x5b, 0x0e, 0x40, 0xb6, 0x7e, 0xdd, 0x80, 0x0c}: "AmdRasSmm",
		efi.GUID{0x28, 0xb8, 0xb2, 0xd2, 0x26, 0x08, 0xa7, 0x48, 0xb3, 0xdf, 0x98, 0x3c, 0x00, 0x60, 0x24, 0xf0}: "EfiStatusCodeRuntimeProtocolGuid",
		efi.GUID{0x28, 0xbe, 0xfd, 0xc0, 0x64, 0x4e, 0xab, 0x44, 0x9f, 0x7e, 0xf3, 0x31, 0x40, 0xe4, 0xfa, 0x2f}: "FanTableDxe",
		efi.GUID{0x28, 0xbf, 0xdd, 0x6c, 0xac, 0x89, 0x01, 0x4e, 0x96, 0x92, 0x61, 0x6b, 0x8a, 0x10, 0x09, 0xc8}: "FvFileLoaderOnLoadFileThunk",
		efi.GUID{0x28, 0xd0, 0x9f, 0xb8, 0xc6, 0xd4, 0xb7, 0x4b, 0xbc, 0xa4, 0x17, 0xd8, 0xc9, 0x45, 0xdc, 0x23}: "DellVideoDeviceSmm",
		efi.GUID{0x28, 0xd3, 0xde, 0x79, 0xce, 0x7f, 0x09, 0x49, 0x9a, 0xfd, 0xd6, 0x61, 0x76, 0xaf, 0x97, 0xa6}: "OobRx",
		efi.GUID{0x28, 0xd7, 0xa8, 0xa0, 0x2d, 0xbc, 0x3f, 0x48, 0xb5, 0x83, 0x28, 0x48, 0x9b, 0x77, 0xc8, 0xf6}: "FprSynapticsPrometheusDriver",
		efi.GUID{0x28, 0xd9, 0xec, 0x13, 0xab, 0x87, 0x60, 0x44, 0xbb, 0xe0, 0xb5, 0x20, 0xf9, 0xeb, 0x1d, 0x32}: "IconNetBoot",
		efi.GUID{0x28, 0xe1, 0x43, 0x9e, 0x4d, 0xc7, 0xf4, 0x42, 0x8c, 0x0c, 0x48, 0x11, 0x67, 0x4a, 0x17, 0xb5}: "EfiMonitorKeyFilterProtocol",
		efi.GUID{0x29, 0x0e, 0x3b, 0xda, 0xa7, 0x2d, 0xa7, 0x48, 0xae, 0x98, 0xb2, 0x10, 0x93, 0xdb, 0xbc, 0x2b}: "RecoveryImageReadWrite",
		efi.GUID{0x29, 0x10, 0x8c, 0xe3, 0x8f, 0xe3, 0xb9, 0x45, 0x8f, 0x0d, 0xe2, 0xe6, 0x0b, 0xc9, 0xb2, 0x62}: "DisplayEngineGuid",
		efi.GUID{0x29, 0x12, 0x69, 0x65, 0xe4, 0x3c, 0x47, 0x41, 0xac, 0xca, 0xe5, 0x58, 0xa2, 0x3a, 0xd1, 0xaa}: "PciePortControl",
		efi.GUID{0x29, 0x15, 0x0e, 0x47, 0x9e, 0xb7, 0x32, 0x4e, 0xa0, 0xfe, 0x6a, 0x15, 0x6d, 0x29, 0xf9, 0xb2}: "EfiBootScriptSaveProtocolGuid",
		efi.GUID{0x29, 0x18, 0xab, 0x01, 0xcd, 0xce, 0xfa, 0x4c, 0xa1, 0x8c, 0xea, 0x75, 0xd6, 0x6f, 0x3e, 0x74}: "IntelMebxProtocol",
		efi.GUID{0x29, 0x1a, 0x9b, 0x76, 0x83, 0xc0, 0x0a, 0x45, 0x8c, 0x96, 0xd7, 0x50, 0xfa, 0xf4, 0x53, 0x0e}: "LenovoCertAuthDxe",
		efi.GUID{0x29, 0x22, 0xe9, 0xbd, 0xa5, 0xf9, 0x97, 0x48, 0x81, 0xe4, 0x8b, 0xab, 0x67, 0x92, 0xa3, 0x95}: "DellDtLegUsbPolicy",
		efi.GUID{0x29, 0x26, 0x7f, 0x01, 0x3e, 0x2d, 0xa9, 0x4e, 0x9e, 0x59, 0x88, 0xda, 0x4d, 0x98, 0xc0, 0x27}: "SpiProtectionPei",
		efi.GUID{0x29, 0x35, 0xf6, 0xf4, 0x1e, 0x28, 0x40, 0x40, 0xa3, 0x13, 0xc1, 0xd6, 0x76, 0x63, 0x84, 0xbe}: "AmiHddSecurityProtocolGuid",
		efi.GUID{0x29, 0x38, 0x80, 0xd8, 0x73, 0x03, 0x75, 0x44, 0x97, 0x67, 0x46, 0x1e, 0xde, 0xa2, 0x88, 0x13}: "CsmInt10HookSmm",
		efi.GUID{0x29, 0x3a, 0xd9, 0xa3, 0x1b, 0x50, 0x6e, 0x4f, 0x86, 0x9a, 0x6f, 0xd4, 0xbc, 0xef, 0x90, 0xa7}: "DellSmbFactDefault",
		efi.GUID{0x29, 0x45, 0x8f, 0x66, 0xd0, 0x63, 0xb5, 0x4b, 0xb6, 0x5d, 0x6f, 0xbb, 0x9d, 0x36, 0xa4, 0x4a}: "QemuBootOrder",
		efi.GUID{0x29, 0x45, 0xa0, 0x98, 0x91, 0x13, 0xea, 0x4f, 0xae, 0xed, 0x2d, 0xce, 0x76, 0xa6, 0x3e, 0x14}: "DustFilter",
		efi.GUID{0x29, 0x56, 0x01, 0x1c, 0xcf, 0x00, 0x3d, 0x47, 0xbe, 0x1c, 0x35, 0x61, 0x02, 0x4f, 0x05, 0x69}: "AdlSemaDxe",
		efi.GUID{0x29, 0x58, 0x65, 0x7d, 0xdd, 0x26, 0x42, 0x43, 0x96, 0xad, 0x04, 0x89, 0x94, 0x77, 0xc3, 0xfa}: "SpiSmmStub",
		efi.GUID{0x29, 0x59, 0x5e, 0xce, 0xa3, 0xc7, 0x02, 0x46, 0xad, 0x9e, 0xc9, 0xda, 0xf9, 0x4e, 0xbf, 0xcf}: "EfiIpSecConfigProtocolGuid",
		efi.GUID{0x29, 0x5f, 0x52, 0x5b, 0x7d, 0x82, 0xa3, 0x4c, 0xbe, 0xb5, 0x89, 0x54, 0xb5, 0x6c, 0x05, 0x73}: "EfiSmBmcVariable",
		efi.GUID{0x29, 0x64, 0x12, 0xf8, 0x88, 0x7b, 0xd2, 0x4a, 0x98, 0xc4, 0x40, 0x2c, 0xbe, 0x26, 0xf9, 0xa8}: "IdentityAndAuthManagerDxe",
		efi.GUID{0x29, 0x71, 0xc8, 0xc9, 0xac, 0xdf, 0xde, 0x48, 0x85, 0x81, 0x73, 0x63, 0xa9, 0x0e, 0x10, 0x1d}: "UFSProvisioningTool",
		efi.GUID{0x29, 0x77, 0x31, 0xeb, 0xaa, 0x1f, 0x31, 0x49, 0xbf, 0x83, 0x31, 0xed, 0xbd, 0xf6, 0x1e, 0x99}: "ErrorControl",
		efi.GUID{0x29, 0x88, 0xc3, 0x8e, 0x9f, 0xa5, 0xe3, 0x40, 0xba, 0xd0, 0x85, 0xf8, 0x15, 0xa1, 0x57, 0xd1}: "DellServiceResetSmm",
		efi.GUID{0x29, 0x91, 0x69, 0x7a, 0xa0, 0xda, 0x24, 0x42, 0x86, 0x29, 0x73, 0x38, 0xde, 0x5d, 0x45, 0xed}: "TpmDriver",
		efi.GUID{0x29, 0x94, 0x3a, 0xa0, 0x70, 0xc5, 0xf9, 0x4e, 0x9e, 0x00, 0xc7, 0xa6, 0x73, 0x97, 0x6e, 0x5f}: "SmmControlDxe",
		efi.GUID{0x29, 0x97, 0xcc, 0xde, 0xcf, 0x74, 0xe7, 0x42, 0x86, 0x72, 0xb9, 0x4b, 0x7e, 0xf4, 0xa4, 0xc5}: "ApobRmbPei",
		efi.GUID{0x29, 0x98, 0x11, 0xf7, 0x4a, 0x31, 0x7f, 0x4e, 0x88, 0x53, 0x44, 0xaa, 0x79, 0xa7, 0xcb, 0x43}: "PspFactoryReset",
		efi.GUID{0x29, 0x9c, 0x4e, 0xbd, 0x5c, 0x85, 0xd8, 0x4b, 0x81, 0x73, 0x3f, 0x10, 0xb6, 0x17, 0xf2, 0x50}: "FjDisableDefaultConfigOrMfgModeBin",
		efi.GUID{0x29, 0x9c, 0xfa, 0xea, 0x4e, 0xd8, 0xbf, 0x42, 0xb1, 0x9a, 0x6d, 0x97, 0x34, 0xef, 0x4a, 0xbb}: "HpJpeg",
		efi.GUID{0x29, 0xa0, 0x76, 0x8a, 0x48, 0xf9, 0x56, 0x4a, 0x93, 0xd0, 0x2e, 0x2b, 0xc2, 0xab, 0xdb, 0x4b}: "OemACRecoveryPei",
		efi.GUID{0x29, 0xa1, 0xb9, 0x9a, 0xfa, 0xb8, 0x45, 0x40, 0xbb, 0x05, 0x48, 0xdb, 0xce, 0x72, 0x4f, 0x82}: "HWMINIT",
		efi.GUID{0x29, 0xae, 0x77, 0xad, 0x20, 0x4c, 0xdd, 0x4f, 0x85, 0x04, 0x81, 0x76, 0x61, 0x9b, 0x67, 0x6a}: "AmiHddSecurityEndProtocolGuid",
		efi.GUID{0x29, 0xb2, 0xbb, 0x8d, 0xe3, 0x87, 0xbc, 0x4c, 0xb2, 0xf7, 0x6a, 0x54, 0xc8, 0x30, 0xd1, 0x66}: "HpCableDetect",
		efi.GUID{0x29, 0xb9, 0xf4, 0xe9, 0x33, 0xee, 0x70, 0x4b, 0x8e, 0x90, 0x17, 0xd2, 0x83, 0xaf, 0x50, 0x8c}: "LibSoftfloat",
		efi.GUID{0x29, 0xbc, 0xfa, 0xf8, 0xab, 0x6c, 0xeb, 0x48, 0x80, 0x2d, 0xff, 0x2e, 0xf6, 0xa3, 0xdf, 0x87}: "HpCableDetect",
		efi.GUID{0x29, 0xc5, 0x28, 0x0d, 0xd4, 0x87, 0x98, 0x42, 0x8a, 0x54, 0x40, 0xf2, 0x2a, 0x9f, 0xe2, 0x4a}: "DellDaHddProtection",
		efi.GUID{0x29, 0xc8, 0xbc, 0xa6, 0x9f, 0x88, 0xb5, 0x4e, 0xa4, 0x90, 0x1b, 0x4c, 0x1a, 0xaf, 0x78, 0x9c}: "SetupConfigUpdateDxeEVB",
		efi.GUID{0x29, 0xd2, 0xab, 0xcc, 0xc4, 0x51, 0xe7, 0x4d, 0xae, 0x2f, 0x3a, 0xaf, 0x71, 0xf9, 0xec, 0xe5}: "SystemSetupAdvancedDxe",
		efi.GUID{0x29, 0xd3, 0x61, 0x4c, 0x46, 0x77, 0xb4, 0x40, 0x98, 0xd0, 0x54, 0x51, 0x4a, 0x41, 0xac, 0x22}: "PublicWmi",
		efi.GUID{0x29, 0xd5, 0x77, 0x36, 0x6f, 0x32, 0x03, 0x46, 0xa9, 0x26, 0xea, 0xac, 0xe0, 0x1d, 0xcb, 0xb0}: "EfiPciExpressBaseAddressGuid",
		efi.GUID{0x29, 0xd6, 0xfb, 0xf1, 0xea, 0x22, 0xd1, 0x40, 0xaa, 0x48, 0x94, 0xc3, 0xdc, 0x5c, 0x7e, 0x0d}: "SbSocBristolPei",
		efi.GUID{0x29, 0xda, 0x9c, 0x68, 0xa8, 0x29, 0xf6, 0x42, 0x93, 0xfc, 0x46, 0xba, 0x5f, 0x18, 0x06, 0x51}: "ImagePasswordProceed",
		efi.GUID{0x29, 0xdf, 0xd9, 0x3a, 0x01, 0x45, 0x8d, 0x47, 0xb1, 0xf8, 0x7f, 0x7f, 0xe7, 0x0e, 0x50, 0xf3}: "EfiUdp4ProtocolGuid",
		efi.GUID{0x29, 0xdf, 0xdb, 0xf1, 0xea, 0x12, 0xd1, 0x20, 0x2c, 0x48, 0x84, 0xc3, 0xdc, 0x5c, 0x7e, 0x0d}: "SbSocRavenPei",
		efi.GUID{0x29, 0xdf, 0xdb, 0xf1, 0xea, 0xa2, 0xd1, 0x90, 0x2a, 0x48, 0x94, 0xc3, 0xdc, 0x5c, 0x7e, 0x0d}: "SbSocSummitPei",
		efi.GUID{0x29, 0xf6, 0x44, 0xbd, 0xe7, 0xea, 0x98, 0x41, 0x87, 0xf1, 0x39, 0xfa, 0xb0, 0xfd, 0x71, 0x7e}: "FspEventEndOfFirmwareGuid",
		efi.GUID{0x29, 0xf9, 0x78, 0x35, 0x84, 0x71, 0x75, 0x42, 0xb9, 0x41, 0xaa, 0xa9, 0x06, 0xc8, 0x85, 0x4f}: "WlanSuplct",
		efi.GUID{0x2a, 0x00, 0x68, 0x8b, 0x7b, 0x81, 0x61, 0x03, 0xba, 0xba, 0x63, 0x41, 0xa4, 0x4e, 0xa0, 0x52}: "DPTFPolicy",
		efi.GUID{0x2a, 0x1a, 0x6a, 0x7d, 0x25, 0x6b, 0xda, 0x48, 0xbe, 0x80, 0xb8, 0xc8, 0x8e, 0xf9, 0xad, 0x56}: "DymanicUpdateBiosSizeInfo",
		efi.GUID{0x2a, 0x23, 0xd4, 0x9b, 0xb0, 0xe5, 0x8c, 0x41, 0x9a, 0xbd, 0xb0, 0xb8, 0x57, 0x4f, 0x13, 0x8c}: "EcStorageAgentPei",
		efi.GUID{0x2a, 0x2c, 0x5d, 0x85, 0x68, 0x8a, 0x83, 0x47, 0xae, 0xc0, 0xcc, 0xd9, 0x95, 0xcb, 0xa5, 0x69}: "FchKeithMdnSsdt",
		efi.GUID{0x2a, 0x3b, 0xd4, 0x37, 0xa0, 0x43, 0xea, 0x4a, 0xab, 0x79, 0xe4, 0xfe, 0xf5, 0x3c, 0x0f, 0x12}: "MicroCodepointerGuid",
		efi.GUID{0x2a, 0x3d, 0xe3, 0xdb, 0x10, 0x6b, 0x77, 0x4e, 0xbe, 0xf8, 0xc8, 0x29, 0xf2, 0x9c, 0x8a, 0x85}: "DellUsbBusDxe",
		efi.GUID{0x2a, 0x50, 0x88, 0x95, 0x70, 0x53, 0xe3, 0x11, 0x86, 0x31, 0xd7, 0xc5, 0x95, 0x13, 0x64, 0xc8}: "AndroidFastbootApp",
		efi.GUID{0x2a, 0x56, 0xd6, 0xfc, 0x3a, 0x25, 0xd7, 0x40, 0x87, 0xde, 0x28, 0xcf, 0xf2, 0x58, 0x98, 0xc6}: "InsideHT",
		efi.GUID{0x2a, 0x60, 0xf9, 0x45, 0x75, 0x34, 0x1e, 0x4d, 0x9f, 0xe9, 0xba, 0xc9, 0x9f, 0x42, 0xad, 0x49}: "AppleBacklightController",
		efi.GUID{0x2a, 0x63, 0x26, 0xc0, 0x3c, 0x07, 0x4a, 0x44, 0xad, 0x9c, 0x5e, 0x96, 0x3f, 0xeb, 0xbc, 0x0f}: "FchSmmDispatcher",
		efi.GUID{0x2a, 0x6c, 0x0d, 0xf1, 0xd6, 0xa2, 0x96, 0x4d, 0xa2, 0x12, 0x2b, 0x4f, 0x60, 0x05, 0xf3, 0x89}: "LenovoSecureBootConfigDxe",
		efi.GUID{0x2a, 0x75, 0x28, 0x86, 0xb7, 0x6c, 0x14, 0x48, 0x96, 0xfc, 0x24, 0xa8, 0x15, 0xac, 0x22, 0x26}: "EfiHashAlgorithmSha256NoPadGuid",
		efi.GUID{0x2a, 0x7f, 0x0e, 0xb0, 0x0a, 0x45, 0xd9, 0x47, 0x93, 0x72, 0x17, 0x2e, 0xcd, 0x15, 0xb7, 0x44}: "FjS5P",
		efi.GUID{0x2a, 0x87, 0x26, 0xb3, 0xc2, 0x4d, 0xb3, 0x4d, 0x88, 0xb2, 0xf6, 0xc4, 0x47, 0x5f, 0x8c, 0x91}: "CpuConfigGuid",
		efi.GUID{0x2a, 0x8b, 0xa8, 0x52, 0xfd, 0x65, 0x51, 0x49, 0x8b, 0x25, 0x06, 0xfb, 0x65, 0x98, 0x12, 0x8b}: "DellSpiPartEon",
		efi.GUID{0x2a, 0x8e, 0x1c, 0xd1, 0xd1, 0x3c, 0x3c, 0x44, 0xac, 0x09, 0x63, 0x52, 0x6d, 0xe7, 0xe1, 0x70}: "SmmSupervisorBinRelease",
		efi.GUID{0x2a, 0x93, 0x20, 0x65, 0x30, 0x3c, 0xa7, 0x48, 0x9e, 0x9d, 0x4d, 0xd1, 0x0c, 0xd4, 0x9d, 0x4c}: "EcLabProductionModeSmm",
		efi.GUID{0x2a, 0x9e, 0x73, 0x51, 0x22, 0xa0, 0x73, 0x4d, 0xad, 0xb9, 0x91, 0xf0, 0xc9, 0xbc, 0x71, 0x42}: "MpServicesOnFrameworkMpServicesThunk",
		efi.GUID{0x2a, 0xae, 0xc2, 0x39, 0xac, 0x33, 0xea, 0x32, 0x3c, 0xa5, 0x9b, 0x12, 0xea, 0x56, 0x45, 0x40}: "AcerToolsProcess",
		efi.GUID{0x2a, 0xb0, 0x3a, 0xf8, 0x44, 0x2b, 0x99, 0x47, 0xa2, 0x1f, 0x85, 0xe7, 0xf2, 0xe8, 0xa3, 0x2c}: "KEMhMfgMode",
		efi.GUID{0x2a, 0xb5, 0x20, 0xf9, 0x21, 0xb4, 0x09, 0x45, 0xbd, 0x00, 0xb7, 0x5f, 0xd9, 0x56, 0x27, 0x75}: "AcerCF9Hook",
		efi.GUID{0x2a, 0xb5, 0x61, 0x2d, 0xef, 0x69, 0x7d, 0x49, 0x83, 0x17, 0x55, 0x74, 0xae, 0xc8, 0x9b, 0xe4}: "FirmwarePassword",
		efi.GUID{0x2a, 0xb7, 0xd3, 0x13, 0x47, 0x80, 0xb8, 0x47, 0xa4, 0xc4, 0x4e, 0x81, 0x4f, 0x6b, 0x25, 0xa1}: "DnxDxe",
		efi.GUID{0x2a, 0xba, 0xd6, 0xd9, 0x25, 0x82, 0x9b, 0x46, 0xb3, 0x6e, 0x3b, 0x34, 0xeb, 0xe8, 0x05, 0xcf}: "StatusCodeHandlerRuntimeDxeUsb",
		efi.GUID{0x2a, 0xbd, 0x16, 0x12, 0x5e, 0xc0, 0x6d, 0x4c, 0x91, 0xe7, 0xeb, 0x8e, 0x37, 0xad, 0x3b, 0x7a}: "aDefaultDXE",
		efi.GUID{0x2a, 0xc6, 0x2e, 0x65, 0x15, 0xdc, 0x73, 0x4b, 0xb6, 0xbd, 0xda, 0xa1, 0x3b, 0xf1, 0xd8, 0x8c}: "Cf9ResetSmm",
		efi.GUID{0x2a, 0xcc, 0x7f, 0xb9, 0x7f, 0x47, 0x39, 0x49, 0xae, 0xc7, 0xef, 0x42, 0x36, 0xd8, 0x8e, 0x3b}: "SureStartPcdDxe",
		efi.GUID{0x2a, 0xd1, 0x29, 0x20, 0x83, 0x0a, 0x77, 0x42, 0x86, 0xa2, 0x71, 0x29, 0x05, 0x20, 0x1a, 0xe7}: "SpiWmi",
		efi.GUID{0x2a, 0xd1, 0xed, 0x94, 0x9b, 0x41, 0x7f, 0x44, 0x94, 0x34, 0x9b, 0x3b, 0x70, 0x78, 0x39, 0x03}: "PlatformDxe",
		efi.GUID{0x2a, 0xd4, 0x4c, 0xe9, 0xad, 0x3a, 0xa0, 0x4e, 0x9b, 0x09, 0x94, 0x58, 0x91, 0xc6, 0x0c, 0xcd}: "DxeIoLibCpuIo",
		efi.GUID{0x2a, 0xd7, 0x9b, 0x2d, 0x38, 0xb2, 0xff, 0x4b, 0x9b, 0xb9, 0xb5, 0x1e, 0x0d, 0x4d, 0x55, 0x3c}: "SlotDataUpdateDxeLightningRidgeEXECB3",
		efi.GUID{0x2a, 0xdb, 0xae, 0x8a, 0xbb, 0xa6, 0xc6, 0x47, 0x94, 0xce, 0x1b, 0x80, 0x96, 0x42, 0x3f, 0x2a}: "EfiSocketServiceBindingProtocolGuid",
		efi.GUID{0x2a, 0xe5, 0x10, 0x92, 0x9e, 0x72, 0x17, 0x48, 0x85, 0xc8, 0xf4, 0x55, 0x00, 0xce, 0x24, 0xc6}: "PchLpcSmm",
		efi.GUID{0x2a, 0xec, 0xf7, 0x01, 0x6e, 0x8f, 0x51, 0x4c, 0x94, 0xc2, 0xde, 0x0e, 0x1c, 0x22, 0x3f, 0x73}: "RasAcpi",
		efi.GUID{0x2a, 0xed, 0x19, 0x98, 0x01, 0xd2, 0x19, 0x35, 0x87, 0xdb, 0x61, 0xc6, 0x16, 0xe1, 0x15, 0x07}: "FmpDxe",
		efi.GUID{0x2a, 0xf6, 0xe3, 0xde, 0x0f, 0x3b, 0x8b, 0x44, 0x81, 0xf9, 0x4a, 0xfd, 0x54, 0x65, 0x15, 0xb9}: "SiliconNvsDataPei",
		efi.GUID{0x2a, 0xf8, 0x39, 0xc9, 0x01, 0x35, 0x57, 0x46, 0x82, 0x56, 0xfd, 0x4c, 0x22, 0x88, 0x87, 0x2f}: "HpErrorLoggingSmm",
		efi.GUID{0x2b, 0x00, 0xd8, 0xa7, 0x3b, 0x92, 0xc0, 0x41, 0x88, 0x4c, 0x3f, 0xc3, 0x79, 0x52, 0x03, 0xfa}: "SystemVariableStoreProtocol",
		efi.GUID{0x2b, 0x03, 0x5b, 0x80, 0x00, 0x6a, 0xf5, 0x46, 0x85, 0x01, 0xcb, 0x88, 0xa2, 0x1d, 0x53, 0x21}: "BcmDhd",
		efi.GUID{0x2b, 0x0c, 0xa5, 0x0e, 0x0d, 0x4c, 0xa3, 0x4c, 0x97, 0xc1, 0x00, 0x14, 0xdb, 0x75, 0x44, 0x73}: "UefiLegacyBootMarker",
		efi.GUID{0x2b, 0x12, 0x54, 0x9a, 0xe4, 0xf5, 0xd8, 0x40, 0xae, 0x61, 0xa7, 0x1e, 0x40, 0x6e, 0xd4, 0x49}: "ChaosKeyDxe",
		efi.GUID{0x2b, 0x14, 0x78, 0xda, 0xa5, 0xe4, 0x33, 0x48, 0xb2, 0x0b, 0x67, 0x23, 0x00, 0x79, 0x47, 0xcb}: "FjLanI219LmSmm",
		efi.GUID{0x2b, 0x15, 0x5e, 0x14, 0xde, 0x3d, 0xb4, 0x4e, 0x99, 0xa7, 0x77, 0x08, 0x3c, 0x2b, 0xcb, 0xec}: "DellFmpMcu",
		efi.GUID{0x2b, 0x15, 0xbc, 0x2c, 0x8a, 0xb4, 0x60, 0x40, 0xb0, 0x09, 0xdc, 0xb9, 0x37, 0x9e, 0x50, 0x15}: "RcPolicyOverridePei",
		efi.GUID{0x2b, 0x15, 0xe8, 0x95, 0x98, 0x1b, 0x11, 0x4f, 0x8a, 0x77, 0xdb, 0x26, 0x58, 0x3e, 0xbc, 0x42}: "AmiPeiSbInitPolicyGuid",
		efi.GUID{0x2b, 0x1a, 0x9d, 0x73, 0xa1, 0xfb, 0x4a, 0x40, 0x87, 0x84, 0x25, 0xcf, 0xa5, 0x7b, 0xea, 0xcd}: "HddAcousticDynamicSetup",
		efi.GUID{0x2b, 0x23, 0xad, 0x86, 0x3a, 0xd3, 0x5c, 0x46, 0xbf, 0x5f, 0x41, 0x37, 0x0b, 0xa9, 0x2f, 0xe2}: "EfiMiniShellFile",
		efi.GUID{0x2b, 0x23, 0xd0, 0x28, 0x6c, 0xd2, 0x5f, 0x4b, 0x94, 0xff, 0xb1, 0x34, 0x0f, 0xc1, 0x60, 0xb8}: "AmdCpuIdentifyPei",
		efi.GUID{0x2b, 0x29, 0x58, 0x9e, 0x68, 0x7c, 0x7d, 0x49, 0xa0, 0xce, 0x65, 0x00, 0xfd, 0x9f, 0x1b, 0x95}: "EdkiiWorkingBlockSignatureGuid",
		efi.GUID{0x2b, 0x2e, 0xaa, 0xfe, 0xac, 0x53, 0x5e, 0x4d, 0xae, 0x10, 0x1e, 0xfd, 0x5d, 0xa4, 0xa2, 0xba}: "BeagleBoardPciEmulation",
		efi.GUID{0x2b, 0x37, 0xc2, 0xb0, 0x93, 0x93, 0xbc, 0x4c, 0x9c, 0xaf, 0x53, 0x91, 0x3c, 0x9d, 0xce, 0x29}: "FlashDeviceFvbRuntimeDxe",
		efi.GUID{0x2b, 0x41, 0x46, 0x28, 0x0f, 0xf5, 0x5b, 0x4a, 0x8c, 0x8b, 0x76, 0x64, 0x43, 0x24, 0xaa, 0x66}: "FchSmbusDxe",
		efi.GUID{0x2b, 0x44, 0xbb, 0x97, 0xfe, 0xf9, 0xe3, 0x45, 0x8a, 0x28, 0x43, 0x9e, 0xed, 0xcd, 0x18, 0x13}: "DualBiosPei",
		efi.GUID{0x2b, 0x4e, 0xb1, 0x16, 0xd9, 0xda, 0x18, 0x46, 0xac, 0xe2, 0x7d, 0x32, 0x4a, 0x26, 0xf9, 0xa0}: "FjGpioResetPDPei",
		efi.GUID{0x2b, 0x50, 0x87, 0xdd, 0xde, 0xcb, 0xa4, 0x48, 0xa8, 0x96, 0xf5, 0x21, 0xe0, 0x74, 0x5c, 0xc0}: "AppAdapterTdx3v0",
		efi.GUID{0x2b, 0x5e, 0x8b, 0xed, 0x22, 0x66, 0x14, 0x4d, 0x90, 0x69, 0x9b, 0xde, 0xc5, 0x4c, 0x94, 0x91}: "TcgPwdTseHook",
		efi.GUID{0x2b, 0x66, 0x79, 0x54, 0xe4, 0x6a, 0xe8, 0x49, 0xa6, 0xbd, 0x6d, 0xe4, 0xb6, 0x25, 0x81, 0x1f}: "KeyboardDxe",
		efi.GUID{0x2b, 0x66, 0xfa, 0xf9, 0x61, 0x83, 0xf0, 0x4d, 0xa4, 0x19, 0x78, 0x1e, 0xb0, 0x24, 0xb2, 0xb7}: "LenovoTpmProvisionDxe",
		efi.GUID{0x2b, 0x6f, 0xb3, 0xd3, 0x51, 0xd5, 0xd4, 0x11, 0x9a, 0x46, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d}: "EfiConsoleInDeviceGuid",
		efi.GUID{0x2b, 0x77, 0x73, 0x72, 0xaa, 0x6d, 0x2f, 0x4e, 0x90, 0x63, 0x6c, 0x95, 0xfd, 0xa9, 0x31, 0xbf}: "AdlSemaPei",
		efi.GUID{0x2b, 0x77, 0x7a, 0x10, 0xe1, 0xd5, 0xd4, 0x11, 0x9a, 0x46, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d}: "EfiDriverConfigurationProtocolGuid",
		efi.GUID{0x2b, 0x82, 0x92, 0xad, 0xc8, 0x30, 0xb1, 0x49, 0x8a, 0xf3, 0x63, 0xcc, 0xdf, 0x19, 0xb0, 0x7f}: "DxeSmmIoLibSmm",
		efi.GUID{0x2b, 0x83, 0x7b, 0x2a, 0xe0, 0x3e, 0xc2, 0x44, 0x8f, 0x3a, 0x9f, 0xd4, 0x31, 0x83, 0xb8, 0x53}: "DellFmpPfat",
		efi.GUID{0x2b, 0x84, 0xef, 0xf4, 0xd1, 0xe3, 0x1a, 0x41, 0x86, 0xdc, 0xf4, 0xbf, 0x1f, 0xba, 0x9e, 0x40}: "Platform_AcerPortingSmm",
		efi.GUID{0x2b, 0x8b, 0x05, 0x2e, 0xc1, 0xed, 0x31, 0x44, 0x87, 0xd9, 0xc6, 0xc4, 0xea, 0x10, 0x2b, 0xe3}: "ScNvsAreaProtocolGuid",
		efi.GUID{0x2b, 0x90, 0x6e, 0x2a, 0xf3, 0xf1, 0x75, 0x42, 0xbc, 0x7b, 0x40, 0xfd, 0x4b, 0x54, 0x81, 0xe7}: "FlashUpdBootModePpiGuid",
		efi.GUID{0x2b, 0x90, 0xb7, 0x39, 0x77, 0x23, 0x73, 0x4f, 0x98, 0x35, 0xb3, 0x51, 0x28, 0xab, 0xb8, 0xd1}: "AppleUpdateMTRR",
		efi.GUID{0x2b, 0x91, 0x9a, 0x9a, 0x53, 0x5f, 0x86, 0x45, 0x88, 0x20, 0x70, 0x44, 0x85, 0xa2, 0x9d, 0x21}: "MePlatformReset",
		efi.GUID{0x2b, 0x94, 0x65, 0xbb, 0x1f, 0x52, 0xc3, 0x4e, 0xba, 0xf9, 0xa9, 0x25, 0x40, 0xcf, 0x60, 0xd2}: "SataController",
		efi.GUID{0x2b, 0xa1, 0x87, 0x8b, 0x38, 0xf4, 0xc0, 0x49, 0x8a, 0x7b, 0x8d, 0x16, 0xa1, 0xfd, 0xac, 0xd4}: "Rt8111FPciUndiDxe",
		efi.GUID{0x2b, 0xa6, 0x72, 0xf8, 0x51, 0x31, 0x39, 0x4f, 0x80, 0x5e, 0x57, 0x02, 0xce, 0x1f, 0x75, 0x04}: "MsiPtpTouchPad",
		efi.GUID{0x2b, 0xb4, 0xfd, 0x45, 0x95, 0x1f, 0x53, 0x4a, 0x9b, 0xa4, 0x1c, 0x8b, 0xfb, 0x8b, 0xcb, 0x01}: "DellGpeConfig",
		efi.GUID{0x2b, 0xbe, 0xf8, 0xd2, 0x98, 0x98, 0x4d, 0x41, 0xa7, 0x6a, 0x20, 0xa5, 0xc8, 0xde, 0x77, 0xe0}: "TouchPad_Elan",
		efi.GUID{0x2b, 0xc5, 0x93, 0x0e, 0x73, 0x4b, 0x32, 0x5c, 0x86, 0xd5, 0x69, 0x25, 0x0a, 0x0b, 0xa7, 0x23}: "AppleThemeFileNames",
		efi.GUID{0x2b, 0xce, 0xb3, 0x39, 0xd0, 0x82, 0x7e, 0x4c, 0xb9, 0x49, 0xd5, 0xe6, 0x51, 0x81, 0xb9, 0x8a}: "IshFwLayout",
		efi.GUID{0x2b, 0xd3, 0x59, 0x8d, 0x55, 0xc6, 0xe9, 0x4a, 0x9b, 0x15, 0xf2, 0x59, 0x04, 0x99, 0x2a, 0x43}: "EfiAbsolutePointerProtocolGuid",
		efi.GUID{0x2b, 0xe4, 0x76, 0xfb, 0x77, 0xea, 0xf3, 0x48, 0xa6, 0x1d, 0x20, 0x8f, 0xf0, 0x53, 0x5f, 0x92}: "TrEEPpVendorLibNull",
		efi.GUID{0x2b, 0xe5, 0x4e, 0x19, 0xfe, 0x02, 0x8d, 0x41, 0xaa, 0x10, 0x2e, 0x61, 0xe5, 0x1c, 0xb8, 0x94}: "DellMonotonicCounter",
		efi.GUID{0x2c, 0x06, 0xf4, 0xe1, 0x3b, 0x99, 0x72, 0x49, 0x9a, 0x6a, 0x3e, 0xb6, 0x8a, 0xec, 0x54, 0x03}: "RtkUndiDxe",
		efi.GUID{0x2c, 0x1b, 0xf3, 0x6a, 0xbe, 0x03, 0xc1, 0x46, 0xb1, 0x2d, 0xea, 0x4a, 0x36, 0xdf, 0xa7, 0x4c}: "EdkiiPeiNvmExpressPassThruPpi",
		efi.GUID{0x2c, 0x21, 0x73, 0xe2, 0xd9, 0x11, 0x28, 0x47, 0xb1, 0xac, 0xb6, 0xee, 0x50, 0x83, 0xee, 0xd6}: "TbtRetimerCapsule1Dxe",
		efi.GUID{0x2c, 0x27, 0x5f, 0xc3, 0xc2, 0x97, 0x5a, 0x46, 0xa2, 0x16, 0x69, 0x6b, 0x66, 0x8a, 0x8c, 0xfe}: "UserProfileManagerGuid",
		efi.GUID{0x2c, 0x31, 0xae, 0xb5, 0x8a, 0xbc, 0xb1, 0x43, 0x9c, 0x62, 0xeb, 0xb8, 0x26, 0xdd, 0x5d, 0x07}: "GrubFile",
		efi.GUID{0x2c, 0x32, 0x7d, 0x2e, 0x5c, 0x0e, 0xdf, 0x11, 0xa0, 0xde, 0x1b, 0xf2, 0xa4, 0x4e, 0xdc, 0x7e}: "VmwExtCfgDevDxe",
		efi.GUID{0x2c, 0x40, 0x52, 0xc9, 0xa8, 0xf2, 0x0f, 0x41, 0x96, 0xf7, 0x2c, 0x78, 0x9b, 0xe0, 0xe0, 0xa1}: "LenovoTamperDxe",
		efi.GUID{0x2c, 0x50, 0x27, 0x97, 0x4e, 0x03, 0x2b, 0x47, 0x8e, 0x1b, 0x67, 0xbb, 0x28, 0xc6, 0xcf, 0xdb}: "DebugAgentDxe",
		efi.GUID{0x2c, 0x52, 0x11, 0x50, 0x0e, 0x7b, 0xcb, 0x4a, 0x8e, 0x30, 0x9b, 0x1d, 0x13, 0x3c, 0xf2, 0xe0}: "FmpAuthenticationLibNull",
		efi.GUID{0x2c, 0x56, 0x84, 0xc1, 0x64, 0x68, 0xa3, 0x40, 0xa0, 0x81, 0xc8, 0xd3, 0x5e, 0x82, 0xb9, 0x20}: "WinCeGuid",
		efi.GUID{0x2c, 0x56, 0x84, 0xcd, 0x64, 0x68, 0xa3, 0x40, 0xa0, 0x81, 0xc8, 0xd3, 0x5e, 0x82, 0xb9, 0x20}: "CspLibDxe",
		efi.GUID{0x2c, 0x57, 0x76, 0x67, 0x56, 0xfe, 0xca, 0x42, 0x9b, 0x93, 0x3d, 0x09, 0x60, 0xe7, 0x58, 0x3a}: "IconBrokenBoot",
		efi.GUID{0x2c, 0x59, 0x63, 0xdb, 0xcc, 0xb8, 0xc8, 0x44, 0x91, 0x8c, 0x51, 0xf5, 0x34, 0x59, 0x8a, 0x5a}: "PchResetProtocolGuid",
		efi.GUID{0x2c, 0x5a, 0x8a, 0xde, 0x88, 0xd7, 0xfb, 0x47, 0xa0, 0xb5, 0x20, 0xca, 0x8e, 0x58, 0xdf, 0xec}: "DellSystemIdConfigPei",
		efi.GUID{0x2c, 0x62, 0x86, 0x23, 0x1a, 0xfc, 0x5b, 0x4b, 0xae, 0x3a, 0xc8, 0x1f, 0xb3, 0x0a, 0xf1, 0x28}: "FjDxeLeg",
		efi.GUID{0x2c, 0x67, 0x5b, 0x52, 0x8f, 0x8c, 0x61, 0x03, 0xae, 0x8e, 0x56, 0x5e, 0xe0, 0xf5, 0x63, 0xb8}: "MemInfoDxe",
		efi.GUID{0x2c, 0x67, 0x73, 0xba, 0xd3, 0xa5, 0xd4, 0x11, 0xbd, 0x00, 0x00, 0x80, 0xc7, 0x3c, 0x88, 0x81}: "EfiWinNtConsoleGuid",
		efi.GUID{0x2c, 0x6d, 0x81, 0xea, 0xe5, 0xce, 0x02, 0x4f, 0x99, 0xb5, 0xd3, 0x90, 0x5c, 0xbb, 0xd0, 0x77}: "EfiHiiNewProtocol",
		efi.GUID{0x2c, 0x6f, 0xb3, 0xd3, 0x51, 0xd5, 0xd4, 0x11, 0x9a, 0x46, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d}: "EfiConsoleOutDeviceGuid",
		efi.GUID{0x2c, 0x70, 0x0e, 0xf5, 0x53, 0x86, 0xde, 0x4c, 0xbb, 0xce, 0x43, 0xb4, 0xd5, 0x5b, 0x34, 0xb8}: "EfiMiscSubclassDriver",
		efi.GUID{0x2c, 0x77, 0x7a, 0x10, 0xe1, 0xd5, 0xd4, 0x11, 0x9a, 0x46, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d}: "EfiComponentNameProtocolGuid",
		efi.GUID{0x2c, 0x7d, 0x67, 0x5a, 0xb2, 0xda, 0xf1, 0x46, 0xa4, 0xfc, 0xc3, 0x25, 0x50, 0x45, 0x80, 0x7a}: "StringMarshalDxe",
		efi.GUID{0x2c, 0x80, 0xfd, 0x9c, 0xa1, 0x09, 0xd6, 0x43, 0x82, 0x17, 0xaa, 0x49, 0xc1, 0xf9, 0x0d, 0x2c}: "Mebx",
		efi.GUID{0x2c, 0x81, 0x9e, 0x23, 0x4a, 0xad, 0x5a, 0x4d, 0x8b, 0xb9, 0x16, 0x91, 0x31, 0xc3, 0x44, 0xbf}: "AmdIdsDebugPrintPei",
		efi.GUID{0x2c, 0x82, 0xd4, 0xbd, 0x9b, 0x5a, 0x73, 0x46, 0x9a, 0xda, 0x50, 0xca, 0xc7, 0x24, 0x6f, 0xce}: "FjFlashServiceDxe",
		efi.GUID{0x2c, 0x84, 0xd8, 0xfa, 0xc7, 0x7d, 0x2f, 0x47, 0xa6, 0xa7, 0x1c, 0xa1, 0xf0, 0x73, 0x64, 0x4f}: "AmdMemoryHobInfoPeim",
		efi.GUID{0x2c, 0x88, 0x22, 0xd1, 0x73, 0xda, 0x8b, 0x43, 0xa6, 0xb3, 0xe0, 0x7b, 0x7d, 0x18, 0xdb, 0x6f}: "FastBootSmi",
		efi.GUID{0x2c, 0x88, 0x74, 0x13, 0x94, 0xb9, 0xdb, 0x48, 0x8d, 0x1b, 0x93, 0xe8, 0x17, 0x54, 0x1f, 0xbd}: "CertificateStorageDxe",
		efi.GUID{0x2c, 0x8c, 0xaa, 0x8d, 0x2b, 0x5e, 0x58, 0x41, 0x8a, 0xdf, 0x5f, 0xac, 0xfc, 0x0e, 0x9b, 0x77}: "AcerLID",
		efi.GUID{0x2c, 0x94, 0xc7, 0x39, 0x72, 0xc2, 0x12, 0x49, 0x9f, 0xe4, 0x57, 0xf6, 0x95, 0xcf, 0x54, 0x42}: "AmtBoot",
		efi.GUID{0x2c, 0x97, 0x53, 0x82, 0xe7, 0x9c, 0x39, 0x45, 0x87, 0xec, 0xa2, 0x48, 0xa4, 0x80, 0x84, 0xc7}: "AddressTranslationDsm",
		efi.GUID{0x2c, 0x98, 0x5a, 0x38, 0x49, 0x2f, 0x43, 0x40, 0xa5, 0x1e, 0x49, 0x01, 0x02, 0x5c, 0x8b, 0x6b}: "PrePiExtractGuidedSectionData",
		efi.GUID{0x2c, 0x9d, 0x16, 0x35, 0x26, 0x24, 0xcc, 0x45, 0x8a, 0xf4, 0x5b, 0x61, 0x8b, 0xc9, 0xa0, 0x0a}: "EfiHeci2PmProtocolGuid",
		efi.GUID{0x2c, 0x9e, 0x74, 0xf3, 0x39, 0x51, 0x7a, 0x4e, 0xb5, 0x3a, 0x4f, 0x50, 0x80, 0xb6, 0x8b, 0x8f}: "PciSerialDxe",
		efi.GUID{0x2c, 0xa2, 0xa8, 0x17, 0x65, 0x83, 0x40, 0x45, 0x98, 0x66, 0xda, 0xf6, 0xda, 0xbe, 0xab, 0xef}: "McBankErrorInjection",
		efi.GUID{0x2c, 0xa8, 0x72, 0x6e, 0xa5, 0x14, 0x02, 0x4f, 0xa3, 0x77, 0x4a, 0x42, 0x3b, 0xb1, 0x81, 0x7f}: "WindowsNameLabel",
		efi.GUID{0x2c, 0xbe, 0x2d, 0x92, 0x8c, 0x52, 0x84, 0x44, 0xff, 0xff, 0xff, 0xff, 0xcf, 0xda, 0xd2, 0x19}: "XnoteSystemPolicySmm",
		efi.GUID{0x2c, 0xd0, 0x8d, 0x30, 0x2b, 0x09, 0x23, 0x41, 0xa2, 0xaf, 0x3e, 0xf4, 0x44, 0x0a, 0x6b, 0x4a}: "AmiResetTypeVariable",
		efi.GUID{0x2c, 0xd1, 0xd3, 0x88, 0x7b, 0x5b, 0x7e, 0x49, 0xa2, 0x7b, 0x1c, 0xb6, 0x5d, 0x42, 0xbf, 0x0f}: "BrightnessHardwareGopDxe",
		efi.GUID{0x2c, 0xe4, 0x22, 0x96, 0x38, 0x8e, 0x08, 0x4a, 0x9e, 0x8f, 0x54, 0xf7, 0x84, 0x65, 0x2f, 0x6b}: "AcpiTableDxe",
		efi.GUID{0x2c, 0xe4, 0x22, 0xa6, 0x38, 0x8e, 0x08, 0x4a, 0x9e, 0x8f, 0x54, 0xf7, 0x84, 0x65, 0x2f, 0x6b}: "SystemAcpiOA30Dxe",
		efi.GUID{0x2c, 0xe6, 0x27, 0x47, 0x17, 0xdf, 0x00, 0x40, 0x89, 0xe3, 0x7a, 0xee, 0x74, 0xaf, 0xec, 0x63}: "FjGabiEntrySmiDispatcherDxe",
		efi.GUID{0x2c, 0xed, 0x5c, 0x60, 0x3b, 0x58, 0x71, 0x41, 0x93, 0x11, 0xaa, 0x6e, 0x14, 0x6b, 0x1a, 0x4b}: "I2cMasterDxe",
		efi.GUID{0x2c, 0xef, 0x25, 0x8d, 0x15, 0x20, 0x6e, 0x41, 0xb8, 0xaa, 0x23, 0x69, 0xfe, 0xcd, 0x4b, 0xda}: "CTA9x4ArmVExpressLibSec",
		efi.GUID{0x2c, 0xf0, 0x65, 0xae, 0xe9, 0xee, 0xac, 0x4a, 0x8c, 0x73, 0x47, 0xaa, 0x4d, 0x7c, 0xf2, 0xbe}: "LenovoFmpDxe",
		efi.GUID{0x2c, 0xf6, 0xf2, 0x8c, 0x9b, 0xbc, 0x21, 0x48, 0x80, 0x8d, 0xec, 0x9e, 0xc4, 0x21, 0xa1, 0xa0}: "EfiPartitionInfoProtocolGuid",
		efi.GUID{0x2c, 0xfc, 0x5c, 0x2e, 0xc0, 0x9c, 0x78, 0x4d, 0xbe, 0xaf, 0xd8, 0x4c, 0xbf, 0x20, 0xd1, 0xc8}: "efi_pop_LF",
		efi.GUID{0x2c, 0xfd, 0xf6, 0x28, 0xf2, 0xef, 0xf0, 0x42, 0x9e, 0x9f, 0xca, 0xc8, 0x75, 0x09, 0xdc, 0x46}: "OemSmi",
		efi.GUID{0x2d, 0x01, 0xea, 0x87, 0xad, 0xcb, 0xc1, 0x44, 0x84, 0x31, 0x61, 0x19, 0x3a, 0x06, 0x09, 0x41}: "PeriodicSmiControl",
		efi.GUID{0x2d, 0x05, 0xf6, 0x8c, 0x53, 0x81, 0x5f, 0x43, 0xab, 0xa4, 0x11, 0x4b, 0x6a, 0x3f, 0xb5, 0x3d}: "DellAhciSmm",
		efi.GUID{0x2d, 0x09, 0xe5, 0xd6, 0xb2, 0xc7, 0x72, 0x48, 0xaf, 0x66, 0xfd, 0xc0, 0xe6, 0xf9, 0x5e, 0x78}: "EfiSystemNvDataHob",
		efi.GUID{0x2d, 0x0e, 0x68, 0x4b, 0x63, 0x0d, 0x62, 0x4f, 0xb9, 0x30, 0x7a, 0xe9, 0x95, 0xb9, 0xb3, 0xa3}: "SmBusDxe",
		efi.GUID{0x2d, 0x13, 0x66, 0x95, 0x78, 0xc6, 0x4b, 0x48, 0x9b, 0x56, 0xd4, 0xcf, 0x3f, 0x4f, 0x69, 0x0f}: "MetroMsgDxe",
		efi.GUID{0x2d, 0x2c, 0xce, 0x09, 0x83, 0x4d, 0xb8, 0x44, 0x97, 0xd0, 0x10, 0x85, 0xeb, 0x54, 0x90, 0xb8}: "AsrockRaidLoader",
		efi.GUID{0x2d, 0x2c, 0xd9, 0x19, 0x89, 0xf0, 0x7c, 0x4b, 0xab, 0xe6, 0x33, 0x3a, 0x12, 0x05, 0xed, 0x89}: "AmiSmmMultiPlatformProtocol",
		efi.GUID{0x2d, 0x37, 0x49, 0x1b, 0xbd, 0xcb, 0xd3, 0x44, 0x84, 0x2c, 0x8e, 0x90, 0x03, 0x90, 0xda, 0x8c}: "H19BatteryControl",
		efi.GUID{0x2d, 0x37, 0x9a, 0x7a, 0x87, 0x34, 0x2e, 0x40, 0xb4, 0x89, 0x5f, 0xc5, 0x51, 0xa4, 0x3b, 0xd1}: "X11DPHDxeDriver",
		efi.GUID{0x2d, 0x4c, 0xb9, 0x46, 0x5d, 0xaf, 0x15, 0x49, 0x81, 0x4d, 0x15, 0x93, 0x23, 0xae, 0x78, 0x0a}: "PowerButtonHandler",
		efi.GUID{0x2d, 0x57, 0x85, 0xbc, 0x97, 0xf2, 0x9c, 0x4d, 0x93, 0xfe, 0xdd, 0x92, 0x26, 0xc1, 0x45, 0x91}: "DellSetupSerrDxe",
		efi.GUID{0x2d, 0x5d, 0x75, 0x27, 0xdf, 0x83, 0x16, 0x49, 0xbd, 0xfe, 0x4f, 0xf3, 0xcd, 0x65, 0x79, 0x65}: "POSTCODE0A_RGBKBCTRL_DXE",
		efi.GUID{0x2d, 0x60, 0xe9, 0xc6, 0x0d, 0xc0, 0x50, 0x42, 0xb2, 0x4d, 0xfe, 0x32, 0x4b, 0x8d, 0xa4, 0x0b}: "AcerPortingDxe",
		efi.GUID{0x2d, 0x62, 0x4d, 0x0a, 0xf4, 0x01, 0x74, 0x49, 0xb3, 0xf5, 0x2b, 0xfe, 0x98, 0x88, 0xef, 0x92}: "SLP20OEMPublicKeyVariableGuid",
		efi.GUID{0x2d, 0x65, 0x27, 0xfd, 0x58, 0xf7, 0xfc, 0x4e, 0xb1, 0xa9, 0x28, 0x3e, 0xfe, 0x51, 0xf4, 0xe9}: "MeFwCapsulePei",
		efi.GUID{0x2d, 0x6f, 0x05, 0x2c, 0x3b, 0x99, 0x54, 0x4a, 0x8a, 0xdd, 0x84, 0xac, 0xe5, 0xd9, 0xcc, 0xe7}: "HpAcpiCore",
		efi.GUID{0x2d, 0x6f, 0xb3, 0xd3, 0x51, 0xd5, 0xd4, 0x11, 0x9a, 0x46, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d}: "EfiStandardErrorDeviceGuid",
		efi.GUID{0x2d, 0x76, 0x6a, 0x12, 0x58, 0x57, 0xca, 0x4f, 0x85, 0x31, 0x20, 0x1a, 0x7f, 0x57, 0xf8, 0x50}: "LenovoSetupStartupDxe",
		efi.GUID{0x2d, 0x77, 0xa9, 0x46, 0x58, 0xd2, 0x10, 0x42, 0x90, 0x17, 0x87, 0x99, 0xc5, 0x74, 0x66, 0xba}: "SwitchDellSystemID",
		efi.GUID{0x2d, 0x7d, 0xf6, 0xd3, 0xca, 0x67, 0xb6, 0x4f, 0x96, 0x54, 0x77, 0xe8, 0x29, 0x01, 0x46, 0x9c}: "VirtualDev",
		efi.GUID{0x2d, 0x87, 0x06, 0x90, 0x86, 0x3a, 0xae, 0x4b, 0xa2, 0xf0, 0xe5, 0x27, 0xb9, 0xd7, 0x11, 0x9e}: "IntelLanUefiDriver",
		efi.GUID{0x2d, 0x8d, 0x1b, 0xb5, 0x8b, 0xd2, 0xd5, 0x4f, 0x98, 0x72, 0x88, 0x8b, 0x99, 0xf8, 0xa2, 0x92}: "LEMEventLogProtocolSmm",
		efi.GUID{0x2d, 0x92, 0x96, 0xf4, 0x2f, 0x17, 0xbc, 0x4b, 0xa1, 0xeb, 0x0e, 0xeb, 0x94, 0x9c, 0x34, 0x86}: "EfiAlternateFvBlock",
		efi.GUID{0x2d, 0x99, 0xf3, 0x76, 0x9e, 0x52, 0xfe, 0x4e, 0x8b, 0xbe, 0x8e, 0x1e, 0xd4, 0x32, 0xc2, 0x23}: "AmiMeasurePciopromGuid",
		efi.GUID{0x2d, 0x9c, 0x27, 0x58, 0x19, 0xfb, 0x6e, 0x46, 0xb4, 0x2e, 0xcd, 0x43, 0x70, 0x16, 0xdc, 0x25}: "AmiTseDriverHealthCtrl",
		efi.GUID{0x2d, 0xa2, 0x06, 0x3f, 0x02, 0xcd, 0xea, 0x4e, 0xb2, 0x94, 0xd6, 0x87, 0x1d, 0xf1, 0x25, 0x5d}: "LenovoVariableSmmProtocol",
		efi.GUID{0x2d, 0xb5, 0x8c, 0xe3, 0x4d, 0xa7, 0xdb, 0x45, 0xa8, 0xd0, 0x29, 0x0c, 0x9b, 0x21, 0xbb, 0xf2}: "UserProfileManager",
		efi.GUID{0x2d, 0xb6, 0xdf, 0x0a, 0x74, 0xff, 0x4c, 0x48, 0x89, 0x44, 0xf8, 0x5c, 0x4b, 0xea, 0x87, 0xa8}: "AmiEfiKeycodeProtocolGuid",
		efi.GUID{0x2d, 0xb7, 0x79, 0x45, 0xc4, 0x7e, 0xd4, 0x4d, 0x84, 0x86, 0x08, 0x3c, 0x86, 0xb1, 0x82, 0xa7}: "IScsi4Dxe",
		efi.GUID{0x2d, 0xbc, 0x6e, 0x6e, 0xab, 0x77, 0xcf, 0x46, 0xb2, 0xa7, 0xcc, 0x96, 0x8b, 0x0e, 0x8a, 0xf3}: "mAmiTcgInterfaceVarGuid",
		efi.GUID{0x2d, 0xbc, 0xb2, 0x63, 0x5d, 0xdf, 0x9b, 0x41, 0x87, 0x3c, 0x2c, 0x78, 0xa6, 0x60, 0x4a, 0x7a}: "SgDxePolicyInit",
		efi.GUID{0x2d, 0xc4, 0xf0, 0x66, 0x0e, 0x0d, 0x23, 0x4c, 0x93, 0xc0, 0x2d, 0x52, 0x95, 0xdc, 0x5e, 0x21}: "BiosGuardHob",
		efi.GUID{0x2d, 0xc5, 0x62, 0xe0, 0xdc, 0x78, 0xc5, 0x4c, 0xb2, 0x46, 0xb1, 0x34, 0x97, 0xa8, 0x12, 0x3c}: "PeiDxePostCodeLibReportStatusCode",
		efi.GUID{0x2d, 0xd6, 0x27, 0x95, 0xc0, 0xa1, 0xc5, 0x44, 0xa9, 0x0f, 0xa1, 0x16, 0x87, 0x70, 0x11, 0x27}: "PlatformInitPostMem",
		efi.GUID{0x2d, 0xd6, 0xad, 0x59, 0xc0, 0xa1, 0xc5, 0x44, 0xa9, 0x0f, 0xa1, 0x16, 0x87, 0x70, 0x46, 0x8c}: "PlatformInit",
		efi.GUID{0x2d, 0xdd, 0x6d, 0xd3, 0x66, 0x1c, 0x10, 0x42, 0xb7, 0x7a, 0x2f, 0xd9, 0xf9, 0x20, 0xe5, 0x1f}: "ASUS_EUPSxSMI",
		efi.GUID{0x2d, 0xdf, 0xee, 0x27, 0x9e, 0x46, 0x8c, 0x47, 0x80, 0x5e, 0x99, 0x3c, 0xcf, 0xb5, 0xc0, 0xc1}: "CrbPxeLoader",
		efi.GUID{0x2d, 0xe0, 0xc2, 0x4d, 0xfb, 0xd5, 0x30, 0x43, 0xbd, 0x53, 0x53, 0x79, 0x73, 0x47, 0xdf, 0x01}: "HwmFanDxe",
		efi.GUID{0x2d, 0xe9, 0xb0, 0xf7, 0x47, 0xab, 0x1d, 0x4a, 0x8b, 0xde, 0x41, 0xe5, 0x29, 0xeb, 0x5a, 0x70}: "H19UnlockPswd",
		efi.GUID{0x2d, 0xf6, 0x36, 0xb3, 0x35, 0x41, 0x55, 0x4a, 0xae, 0x4e, 0x49, 0x71, 0xbb, 0xf0, 0x88, 0x5d}: "RealTimeClock",
		efi.GUID{0x2d, 0xfa, 0x17, 0xed, 0x9a, 0x60, 0x8d, 0x4e, 0x99, 0xf6, 0x9c, 0x0c, 0xbb, 0xdd, 0x8c, 0x2f}: "TbtPei",
		efi.GUID{0x2d, 0xfb, 0x83, 0x11, 0xbd, 0xdf, 0xcd, 0x40, 0x94, 0x5b, 0x3f, 0xa6, 0x30, 0x87, 0x9b, 0xcd}: "FjEvteServicesDxe",
		efi.GUID{0x2d, 0xfd, 0x48, 0x58, 0xaf, 0xd6, 0x4b, 0x47, 0x82, 0x75, 0x95, 0xdd, 0xe7, 0x0a, 0xe8, 0x23}: "SmramCpuDataHeaderGuid",
		efi.GUID{0x2e, 0x03, 0xdf, 0x22, 0xb2, 0xb7, 0xec, 0x43, 0xb9, 0x03, 0xbc, 0xe4, 0x19, 0x0a, 0xed, 0x43}: "RstPeim32",
		efi.GUID{0x2e, 0x06, 0xa0, 0x1b, 0x79, 0xc7, 0x82, 0x45, 0x85, 0x66, 0x33, 0x6a, 0xe8, 0xf7, 0x8f, 0x09}: "SecCore_VolumeTopFile",
		efi.GUID{0x2e, 0x13, 0xca, 0x69, 0x2c, 0x06, 0x7f, 0x4d, 0xbe, 0x7f, 0x9b, 0x0b, 0x84, 0x46, 0xc8, 0x88}: "PhLegacyRegionSmm",
		efi.GUID{0x2e, 0x1c, 0x7d, 0xf5, 0x79, 0x38, 0xdf, 0x11, 0x91, 0x18, 0x93, 0x1b, 0x1e, 0x0f, 0x29, 0xb0}: "VmwLogRuntimeDxe",
		efi.GUID{0x2e, 0x20, 0xe1, 0x80, 0x97, 0x26, 0x64, 0x42, 0x9c, 0xc9, 0x80, 0x76, 0x2c, 0x3e, 0x58, 0x63}: "RecoveryFormSet",
		efi.GUID{0x2e, 0x25, 0x68, 0xb2, 0x1a, 0x54, 0x07, 0x49, 0x95, 0x42, 0x6a, 0xc8, 0x19, 0x6c, 0x5d, 0x2d}: "AmdNbioPcieZPPei",
		efi.GUID{0x2e, 0x32, 0x64, 0xc4, 0xc4, 0x3d, 0xad, 0x49, 0xb9, 0xfd, 0xaf, 0x1b, 0x56, 0xb2, 0x24, 0x9b}: "HwAssetDxe",
		efi.GUID{0x2e, 0x47, 0x76, 0x9e, 0x4a, 0xdb, 0xb7, 0x44, 0x99, 0x7c, 0x3a, 0x35, 0x60, 0xb0, 0x37, 0xb2}: "AcerLidSmm",
		efi.GUID{0x2e, 0x50, 0xd3, 0xb3, 0x82, 0xcb, 0x17, 0x40, 0xab, 0x34, 0x2f, 0x17, 0xd2, 0xd7, 0x03, 0x5f}: "PepBccdSmm",
		efi.GUID{0x2e, 0x53, 0xa2, 0x55, 0x7a, 0x29, 0xfd, 0x4a, 0x90, 0xbf, 0x13, 0x9b, 0xff, 0x5b, 0xb4, 0xd7}: "LenovoSystemAcpiTablesPei",
		efi.GUID{0x2e, 0x53, 0xfc, 0x1b, 0x8a, 0xf4, 0xbe, 0x4e, 0xb2, 0xfb, 0x2b, 0x28, 0x6d, 0x70, 0xa6, 0xeb}: "IconUsbHD",
		efi.GUID{0x2e, 0x57, 0x65, 0xac, 0xa7, 0xf3, 0x9c, 0x4d, 0x93, 0xfe, 0x22, 0xa2, 0x21, 0xc1, 0x45, 0x91}: "DellSetupDMASupportDxe",
		efi.GUID{0x2e, 0x58, 0x0f, 0x4f, 0x6b, 0x6d, 0xc0, 0x4b, 0x90, 0x88, 0x18, 0x19, 0xba, 0xaf, 0x82, 0xd8}: "SystemBiosSelfHealingTestPei",
		efi.GUID{0x2e, 0x5a, 0xcb, 0x77, 0xc8, 0x59, 0x0e, 0x49, 0xb6, 0x9d, 0xa3, 0x86, 0x2b, 0xe5, 0xb3, 0xa0}: "EobonPriorityMap",
		efi.GUID{0x2e, 0x67, 0x46, 0xb2, 0xa8, 0x71, 0x3e, 0x45, 0xa0, 0xf2, 0x95, 0xde, 0xcd, 0x7a, 0x1b, 0x86}: "H19ComputraceSmm",
		efi.GUID{0x2e, 0x6a, 0x84, 0x41, 0xaa, 0x7a, 0x98, 0x44, 0xbc, 0x26, 0xb5, 0xac, 0xd4, 0x9f, 0x92, 0xe1}: "DellSmbBootPriority",
		efi.GUID{0x2e, 0x72, 0x44, 0xfc, 0x13, 0x18, 0x9f, 0x41, 0x9f, 0xdd, 0xc3, 0xfb, 0x64, 0x4c, 0xec, 0x8c}: "DellErrorHandlerDxe",
		efi.GUID{0x2e, 0x72, 0x8e, 0x79, 0xb2, 0x15, 0x13, 0x4e, 0x8a, 0xe9, 0x6b, 0xa3, 0x0f, 0xf7, 0xf1, 0x67}: "IntelSmbiosDataHobGuid",
		efi.GUID{0x2e, 0x7f, 0xc1, 0x28, 0x7b, 0x4b, 0x08, 0x47, 0x88, 0x5f, 0x47, 0x84, 0x09, 0x2c, 0x62, 0x54}: "ExBootItemDispatcher",
		efi.GUID{0x2e, 0x83, 0xdf, 0x4c, 0x87, 0x14, 0xb5, 0x4e, 0xbc, 0xba, 0xfe, 0x6d, 0x38, 0x49, 0xc7, 0x4d}: "PdSolutionPei",
		efi.GUID{0x2e, 0x85, 0x7c, 0xd5, 0x9f, 0x80, 0xcf, 0x45, 0xa3, 0x77, 0xd7, 0x7b, 0xc0, 0xcb, 0x78, 0xee}: "HddSmart",
		efi.GUID{0x2e, 0x8a, 0x63, 0xa9, 0x62, 0x88, 0x9c, 0x43, 0xba, 0x51, 0x03, 0x21, 0x61, 0xf6, 0xfe, 0x31}: "BayhubSecureErase",
		efi.GUID{0x2e, 0xb3, 0x77, 0x7d, 0xb2, 0xba, 0xc7, 0x4c, 0x83, 0x78, 0x75, 0x50, 0x51, 0x3f, 0x3f, 0xca}: "UsbOcUpdateDxeLightningRidgeEXECB4",
		efi.GUID{0x2e, 0xc8, 0x6a, 0x73, 0x16, 0x42, 0xf1, 0x42, 0x8e, 0xde, 0x91, 0xec, 0x63, 0xd0, 0xec, 0x43}: "FjSysmanSetupHooks",
		efi.GUID{0x2e, 0xcf, 0xdf, 0x52, 0xe5, 0x5b, 0x76, 0x43, 0xbc, 0x22, 0x14, 0xf7, 0x88, 0xa4, 0xa4, 0x25}: "AmdNbioEarlyPhaseRVPei",
		efi.GUID{0x2e, 0xd1, 0x7e, 0xab, 0x78, 0x1d, 0x35, 0x46, 0xab, 0x87, 0x23, 0xf0, 0x0a, 0x91, 0x1e, 0xc7}: "RomLayoutDxe",
		efi.GUID{0x2e, 0xe4, 0x68, 0x55, 0x33, 0xdd, 0x6c, 0x4f, 0x86, 0x7f, 0x7e, 0x73, 0x45, 0x11, 0x04, 0xfe}: "StaticSkuDataDxeLightningRidgeEXECB4",
		efi.GUID{0x2e, 0xed, 0x82, 0x92, 0xce, 0xf8, 0x47, 0xca, 0xaf, 0x50, 0x35, 0x42, 0x33, 0x2f, 0x7d, 0x53}: "AppleDnsResolver",
		efi.GUID{0x2e, 0xf6, 0x49, 0xe4, 0x26, 0xa7, 0xd2, 0x48, 0x94, 0x2b, 0x78, 0x72, 0xbf, 0x90, 0x06, 0x7d}: "PciSerialDxe",
		efi.GUID{0x2e, 0xfb, 0xd7, 0xf2, 0xe7, 0xff, 0x21, 0x43, 0xa4, 0xf5, 0xdb, 0xb4, 0x37, 0x0b, 0x96, 0x3b}: "SubcomponentMeasureEvent",
		efi.GUID{0x2f, 0x03, 0xb4, 0x9d, 0xb3, 0xf8, 0x58, 0x47, 0xb8, 0x8e, 0x12, 0x47, 0x08, 0xbd, 0xb9, 0xc0}: "DellAutoBifurcateDxe",
		efi.GUID{0x2f, 0x0d, 0x5b, 0x65, 0xf1, 0xbc, 0x1e, 0x4b, 0x9a, 0x6a, 0xa2, 0xe8, 0x91, 0xbb, 0x50, 0xe4}: "BiosGuardFirmwareVersionPeim",
		efi.GUID{0x2f, 0x15, 0x4b, 0xb7, 0x71, 0x52, 0x8b, 0x49, 0xa4, 0xa2, 0x57, 0x22, 0xcb, 0xbe, 0xc6, 0x14}: "DellPolyFuseStringPolicySmm",
		efi.GUID{0x2f, 0x19, 0x9f, 0xda, 0xe4, 0xba, 0x20, 0x4f, 0x8c, 0x6c, 0x55, 0xc1, 0xac, 0xde, 0x80, 0xb0}: "menu_checked",
		efi.GUID{0x2f, 0x22, 0xd7, 0xf0, 0x43, 0xfd, 0x5d, 0x4a, 0xb8, 0xbf, 0xa2, 0x59, 0xc8, 0x7a, 0xe3, 0xb2}: "FlashDeviceLibDxe",
		efi.GUID{0x2f, 0x2d, 0x9d, 0xeb, 0x88, 0x2d, 0xd3, 0x11, 0x9a, 0x16, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d}: "EfiMpsTableGuid",
		efi.GUID{0x2f, 0x5a, 0x73, 0xc7, 0xf5, 0x88, 0x82, 0x48, 0xae, 0x63, 0xfa, 0xac, 0x8c, 0x8b, 0x86, 0xb3}: "EfiVAminiPortProtocolGuid",
		efi.GUID{0x2f, 0x61, 0xeb, 0xe1, 0x6c, 0x1c, 0x5d, 0x48, 0x9d, 0x06, 0x65, 0x08, 0x44, 0x88, 0x15, 0x69}: "EfiSignedCapsulePkgTokenSpaceGuid",
		efi.GUID{0x2f, 0x74, 0x10, 0x1a, 0x80, 0xfa, 0x79, 0x4b, 0x9d, 0xa6, 0x35, 0x70, 0x58, 0xcc, 0x39, 0x7b}: "ArrowCursor",
		efi.GUID{0x2f, 0x77, 0x04, 0xb9, 0xa1, 0xf8, 0x47, 0x41, 0x82, 0xff, 0x56, 0xca, 0xf2, 0xd6, 0xe0, 0x42}: "PlatformSecureBiosPei",
		efi.GUID{0x2f, 0x7c, 0x71, 0xae, 0x42, 0x1a, 0x2b, 0x4f, 0x88, 0x61, 0x78, 0xb7, 0x9c, 0xa0, 0x7e, 0x07}: "FV_MAIN_NESTED",
		efi.GUID{0x2f, 0x7e, 0x87, 0x21, 0x6e, 0xf8, 0x8a, 0x4e, 0x9c, 0x9b, 0xd7, 0xb1, 0x52, 0xdd, 0x40, 0xd8}: "EfiPeiPlatformTypeNeonCityEpecbPpi",
		efi.GUID{0x2f, 0x89, 0xae, 0x50, 0x1c, 0xe0, 0xbc, 0x46, 0x9e, 0x47, 0x06, 0x4e, 0x25, 0x03, 0x77, 0x6b}: "NICIdm",
		efi.GUID{0x2f, 0x8f, 0x48, 0xe7, 0xdd, 0xa9, 0x34, 0x40, 0xeb, 0x46, 0x53, 0x8f, 0x71, 0xdc, 0x7b, 0x9d}: "HpPcieRedriverPei",
		efi.GUID{0x2f, 0x9f, 0x2f, 0xe6, 0x95, 0x48, 0xb5, 0x4a, 0x12, 0x34, 0x39, 0x9d, 0x0d, 0x9c, 0x12, 0x34}: "ComputraceDxe",
		efi.GUID{0x2f, 0xa9, 0x95, 0x0c, 0x06, 0xa0, 0xd4, 0x11, 0xbc, 0xfa, 0x00, 0x80, 0xc7, 0x3c, 0x88, 0x81}: "EfiWinNtPhysicalDisksGuid",
		efi.GUID{0x2f, 0xaf, 0xf7, 0xb1, 0x07, 0x28, 0x8c, 0x47, 0xa8, 0x93, 0x2b, 0xf4, 0xdd, 0xd1, 0xf6, 0x2b}: "PeiVariableAuth",
		efi.GUID{0x2f, 0xb2, 0x56, 0xda, 0x79, 0x83, 0x2f, 0x4f, 0xb3, 0x28, 0x22, 0x1c, 0x01, 0x82, 0xc6, 0xf5}: "NearTdpLockOc",
		efi.GUID{0x2f, 0xb4, 0x04, 0x49, 0xc0, 0x9f, 0x2e, 0x4c, 0xbb, 0x3f, 0xa2, 0xab, 0x35, 0x12, 0x35, 0x30}: "DebugAgentLibNull",
		efi.GUID{0x2f, 0xbc, 0x5b, 0x5e, 0x01, 0xe0, 0xae, 0x4f, 0x94, 0xe5, 0xd4, 0x13, 0xe9, 0xca, 0x22, 0x38}: "FjSystemDataDriverSmm",
		efi.GUID{0x2f, 0xc2, 0x2e, 0x51, 0xf1, 0xcf, 0x01, 0x41, 0xbe, 0x42, 0x6f, 0xa7, 0x9b, 0xc5, 0x03, 0x74}: "HpLibArchiveWorker",
		efi.GUID{0x2f, 0xc3, 0x2c, 0x37, 0x3a, 0x5c, 0x56, 0x4c, 0x8e, 0x20, 0x9f, 0x06, 0xac, 0x89, 0xe8, 0xd6}: "AcerPortingSmm",
		efi.GUID{0x2f, 0xd3, 0xfb, 0x08, 0x7f, 0x86, 0x2b, 0x45, 0xb1, 0x34, 0x70, 0x51, 0x61, 0xf7, 0x33, 0x33}: "LenovoCryptServiceSmm",
		efi.GUID{0x2f, 0xd4, 0x7d, 0x3e, 0x7e, 0xa6, 0x4f, 0x4d, 0xbc, 0x02, 0x2b, 0x5a, 0x6e, 0xc8, 0xda, 0xe9}: "SetupVariablePei",
		efi.GUID{0x2f, 0xdc, 0xc5, 0x24, 0xe2, 0x53, 0xca, 0x40, 0x9e, 0xd6, 0xa5, 0xd9, 0xa4, 0x9f, 0x46, 0x3b}: "EfiHashAlgorithmSha1NoPadGuid",
		efi.GUID{0x2f, 0xdf, 0x9b, 0x36, 0x9f, 0xd8, 0x18, 0x4b, 0x94, 0xa4, 0x63, 0x14, 0x22, 0x0a, 0x1a, 0x61}: "RhProxySsdt",
		efi.GUID{0x2f, 0xe2, 0x81, 0x70, 0xc6, 0xca, 0x53, 0x40, 0x94, 0x68, 0x67, 0x57, 0x82, 0xcf, 0x88, 0xe5}: "EfiEventDxeDispatchGuid",
		efi.GUID{0x2f, 0xe2, 0xc1, 0x62, 0x7a, 0xbf, 0x2e, 0x46, 0xa0, 0x37, 0xbf, 0x97, 0xbb, 0xc3, 0xad, 0xf9}: "EzConfigDxe",
		efi.GUID{0x2f, 0xeb, 0xd0, 0x4b, 0x2d, 0x3a, 0x2e, 0x44, 0x82, 0x2d, 0x75, 0x35, 0x16, 0xf7, 0x54, 0x24}: "PchInitDxeTgl",
		efi.GUID{0x2f, 0xee, 0x2b, 0xab, 0xa6, 0xc1, 0x99, 0x43, 0x85, 0x3d, 0xc0, 0x7c, 0x77, 0x4f, 0xfd, 0x0d}: "EfiLpcWpce791PolicyProtocolGuid",
		efi.GUID{0x2f, 0xf7, 0x00, 0x27, 0xea, 0xe0, 0x67, 0x47, 0x9a, 0x1e, 0xd1, 0x72, 0xf0, 0x70, 0x47, 0x78}: "PeiSelStatusCode",
		efi.GUID{0x2f, 0xf7, 0x45, 0x21, 0xf1, 0xe6, 0x40, 0x44, 0xa8, 0x28, 0x59, 0xdc, 0x9a, 0xab, 0x5f, 0x89}: "EmmcDxe",
		efi.GUID{0x2f, 0xfd, 0x6a, 0x31, 0x25, 0x8f, 0x42, 0x46, 0xb0, 0xcc, 0x41, 0x1f, 0x67, 0xfc, 0x0c, 0x47}: "AaeonPowerModePei",
		efi.GUID{0x30, 0x0f, 0xd4, 0x29, 0xbf, 0xe8, 0x03, 0x48, 0x88, 0xa6, 0x42, 0x47, 0xa2, 0x9a, 0x53, 0x18}: "AmdVersionDxe",
		efi.GUID{0x30, 0x10, 0xd1, 0x16, 0xba, 0x71, 0x5e, 0x4e, 0xa9, 0xf9, 0xb4, 0x75, 0xa5, 0x49, 0x04, 0x8a}: "EfiRedirElogProtocol",
		efi.GUID{0x30, 0x12, 0x6b, 0x31, 0x00, 0x05, 0x92, 0x45, 0x8c, 0x09, 0xea, 0xba, 0x0f, 0xb6, 0xb0, 0x78}: "SmmPcieSataController",
		efi.GUID{0x30, 0x12, 0x6b, 0x31, 0x00, 0x05, 0x92, 0x45, 0x8c, 0x09, 0xea, 0xba, 0x0f, 0xb6, 0xb0, 0x7f}: "SmmHddSecurity",
		efi.GUID{0x30, 0x12, 0x71, 0xb3, 0x04, 0xca, 0x11, 0x4f, 0x9a, 0x84, 0x2d, 0x81, 0x11, 0xf8, 0xaa, 0x83}: "EcBlockSmm",
		efi.GUID{0x30, 0x17, 0xe4, 0x8e, 0x91, 0xcd, 0x40, 0xfe, 0xa8, 0x3a, 0xf6, 0x0f, 0x1e, 0xcb, 0x49, 0x2d}: "IcnsConvert",
		efi.GUID{0x30, 0x19, 0x8f, 0x21, 0xab, 0x10, 0xb3, 0x43, 0x9c, 0x66, 0xb9, 0x84, 0x83, 0xa1, 0xae, 0x9d}: "OpalBlockSidDxe",
		efi.GUID{0x30, 0x1e, 0x5b, 0xc3, 0xf0, 0x30, 0x14, 0x4f, 0xb6, 0x03, 0x28, 0x55, 0x6f, 0x14, 0xf8, 0x74}: "DellDtDevCountsDxe",
		efi.GUID{0x30, 0x20, 0xa7, 0x65, 0x2e, 0xb0, 0xf3, 0x4b, 0x84, 0x24, 0xba, 0x5f, 0x2f, 0xc5, 0x6d, 0xe7}: "LenovoSetupUnderOsSmm",
		efi.GUID{0x30, 0x28, 0xfe, 0xab, 0x5b, 0x85, 0x98, 0x4a, 0x94, 0xd6, 0xee, 0xb2, 0x3d, 0x1e, 0xbf, 0x45}: "AmdIdsDebugPrintDxe",
		efi.GUID{0x30, 0x2d, 0x6d, 0xf2, 0x7a, 0x81, 0xe0, 0x45, 0xb7, 0x03, 0xe6, 0xc8, 0x83, 0x7a, 0x88, 0x21}: "SmbiosType24",
		efi.GUID{0x30, 0x2d, 0x9d, 0xeb, 0x88, 0x2d, 0xd3, 0x11, 0x9a, 0x16, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d}: "EfiAcpi10TableGuid",
		efi.GUID{0x30, 0x33, 0x6c, 0xa4, 0x36, 0xbe, 0x77, 0x49, 0x9d, 0x24, 0xa7, 0xcf, 0x92, 0xee, 0xf0, 0xfe}: "PxeDhcp4Dxe",
		efi.GUID{0x30, 0x42, 0x19, 0x2c, 0xb6, 0x54, 0x95, 0x4c, 0xb8, 0x09, 0x87, 0x7e, 0x83, 0x30, 0x93, 0x58}: "ASUSGamingBoard",
		efi.GUID{0x30, 0x44, 0xca, 0x25, 0x5d, 0x49, 0xef, 0x42, 0x81, 0x57, 0x4d, 0x0a, 0xe2, 0x12, 0x48, 0x62}: "HidAbsolutePointer",
		efi.GUID{0x30, 0x45, 0x6b, 0x2a, 0x99, 0x90, 0x37, 0x49, 0x8f, 0xe7, 0xf1, 0x68, 0xef, 0xe0, 0x9c, 0x89}: "DellBoardConnectorMapPolicy",
		efi.GUID{0x30, 0x51, 0xba, 0x33, 0x55, 0x22, 0x02, 0x48, 0x90, 0x19, 0xc8, 0x75, 0xd5, 0xd6, 0x6e, 0x77}: "OpalBlockSidWmi",
		efi.GUID{0x30, 0x53, 0x26, 0x77, 0xb0, 0x9f, 0xa5, 0x4a, 0x8e, 0x37, 0x35, 0x06, 0x47, 0x28, 0xf5, 0xc3}: "IioCfgUpdateDxeSierra",
		efi.GUID{0x30, 0x68, 0x6e, 0xb2, 0x9f, 0x62, 0x3f, 0x44, 0xbe, 0x20, 0xd2, 0x6e, 0x50, 0x2c, 0x25, 0xbc}: "AmdFchHwmSmm",
		efi.GUID{0x30, 0x6d, 0xaf, 0xf5, 0xde, 0x2e, 0x26, 0x40, 0x8e, 0x71, 0x74, 0xef, 0x7f, 0x36, 0xd3, 0x63}: "DellDfuPersistentEventDxe",
		efi.GUID{0x30, 0x6e, 0x05, 0x0a, 0xc9, 0xb2, 0xf3, 0x44, 0xff, 0xff, 0xff, 0xff, 0x94, 0xa5, 0x24, 0xa6}: "XnotePowerButtonSmiHandler",
		efi.GUID{0x30, 0x7a, 0x25, 0x7c, 0xba, 0xf8, 0x4a, 0x40, 0x84, 0x76, 0x66, 0x6f, 0x9e, 0x19, 0xbc, 0x56}: "GabiSettingItemCallbackDxe",
		efi.GUID{0x30, 0x7f, 0x09, 0xd8, 0xab, 0xc9, 0x76, 0x4d, 0x8d, 0x87, 0x89, 0x0c, 0xa4, 0x13, 0x65, 0x7a}: "ElkhartLakeDxe",
		efi.GUID{0x30, 0x85, 0xdd, 0xc7, 0xd8, 0x96, 0xdd, 0x40, 0xbe, 0x88, 0xcb, 0xdf, 0x44, 0x6c, 0x64, 0x74}: "Stibp",
		efi.GUID{0x30, 0x8d, 0x0e, 0xe5, 0x12, 0x1f, 0x42, 0x46, 0xa7, 0x9a, 0x39, 0x87, 0x0d, 0xf7, 0x03, 0x61}: "SioSmbusAccessPei",
		efi.GUID{0x30, 0x8e, 0xf9, 0x4b, 0xe0, 0x17, 0xe9, 0x11, 0xb5, 0x6e, 0x08, 0x00, 0x20, 0x0c, 0x9a, 0x66}: "ThermalSensors",
		efi.GUID{0x30, 0x94, 0x56, 0x48, 0x5f, 0x48, 0xcc, 0x4a, 0xa1, 0x84, 0xb3, 0x5d, 0x11, 0xcb, 0x75, 0x60}: "AmdCpmUcsiDxe",
		efi.GUID{0x30, 0x97, 0x19, 0x12, 0x13, 0x7d, 0x92, 0x4c, 0x97, 0xd5, 0x15, 0x62, 0x51, 0x5a, 0x1e, 0x48}: "OemThermalPolicy",
		efi.GUID{0x30, 0x9c, 0x28, 0x54, 0x54, 0x4d, 0xa4, 0x4b, 0x8d, 0x06, 0x1c, 0x6b, 0x9b, 0x2d, 0xc2, 0x3d}: "CpPcHotkeyData",
		efi.GUID{0x30, 0xa1, 0x19, 0x5c, 0x47, 0xa4, 0xd8, 0x4d, 0xbf, 0xd4, 0x1c, 0xa7, 0xe2, 0x21, 0x0a, 0x5c}: "FastbootDxe",
		efi.GUID{0x30, 0xa5, 0x40, 0xb5, 0x78, 0x69, 0xa7, 0x4d, 0x91, 0xcb, 0x72, 0x07, 0xd7, 0x64, 0xd2, 0x62}: "FastBootVariableGuid",
		efi.GUID{0x30, 0xac, 0xc6, 0x49, 0x72, 0xf1, 0xa4, 0x4e, 0x85, 0x99, 0x39, 0x25, 0x85, 0x5b, 0x4d, 0x47}: "DellDiagLedSmm",
		efi.GUID{0x30, 0xb2, 0xb0, 0xa1, 0xdc, 0x67, 0x1e, 0x43, 0xa9, 0x4a, 0xa9, 0x6a, 0xf1, 0xeb, 0xe6, 0x37}: "Tpm2DeviceLibTcg2",
		efi.GUID{0x30, 0xb3, 0xd3, 0xf2, 0x85, 0x89, 0xdb, 0x11, 0x8a, 0xa3, 0x00, 0x40, 0xd0, 0x2b, 0x18, 0x35}: "EfiUnixCpuModel",
		efi.GUID{0x30, 0xb5, 0x79, 0xb5, 0x97, 0xc7, 0x39, 0x48, 0x88, 0x3e, 0xef, 0xca, 0xbd, 0x77, 0x56, 0xe9}: "VerbTable",
		efi.GUID{0x30, 0xba, 0x8a, 0x91, 0x8d, 0x3d, 0xb5, 0x4b, 0xb8, 0x49, 0x45, 0xcc, 0x4f, 0xc7, 0xde, 0x7c}: "Dptf",
		efi.GUID{0x30, 0xbb, 0x88, 0xf0, 0x92, 0xda, 0xff, 0x4b, 0xab, 0xbc, 0x73, 0xe4, 0x21, 0x77, 0xa4, 0x3d}: "DellSataPortNumMapPolicy",
		efi.GUID{0x30, 0xbc, 0x65, 0xb0, 0xa8, 0xe7, 0x02, 0x45, 0xb6, 0x53, 0x5d, 0x7a, 0x95, 0x4d, 0x23, 0x14}: "DellLegacyBootInfoDxe",
		efi.GUID{0x30, 0xbd, 0x5a, 0x3d, 0x75, 0x41, 0xce, 0x87, 0x6d, 0x64, 0xd2, 0xad, 0xe5, 0x23, 0xc4, 0xbb}: "EfiVirtualCdGuid",
		efi.GUID{0x30, 0xc0, 0xa1, 0xa6, 0x56, 0xf9, 0x9e, 0x4a, 0x95, 0x40, 0xd0, 0xe8, 0x1d, 0x2e, 0x33, 0xf2}: "LenovoSmBiosHole",
		efi.GUID{0x30, 0xc8, 0xab, 0x91, 0xfc, 0x16, 0x9e, 0x4d, 0xa1, 0x89, 0x5f, 0xc8, 0xbb, 0x41, 0x14, 0x02}: "AmiSmmDigitalSignatureProtocolGuid",
		efi.GUID{0x30, 0xce, 0x39, 0x07, 0x1a, 0x2e, 0x9a, 0x44, 0xb5, 0x75, 0xfd, 0x64, 0xf1, 0xb4, 0x32, 0x1d}: "SystemSetupCapsuleFromInternetDxe",
		efi.GUID{0x30, 0xd5, 0xdb, 0x80, 0x4c, 0xb7, 0x11, 0x4f, 0x8c, 0x03, 0x41, 0x86, 0x65, 0x53, 0x28, 0x31}: "EfiMemoryConfigDataGuid",
		efi.GUID{0x30, 0xdc, 0xf0, 0xf2, 0x85, 0x89, 0xdb, 0x11, 0xa1, 0x5b, 0x00, 0x40, 0xd0, 0x2b, 0x18, 0x35}: "UnixFwhPpi",
		efi.GUID{0x30, 0xdd, 0xca, 0x12, 0x07, 0x60, 0x83, 0x4c, 0x89, 0xd7, 0xff, 0x23, 0x7f, 0x7b, 0x94, 0x7a}: "SetupCompleteRedrawGuid",
		efi.GUID{0x30, 0xdd, 0xce, 0x0e, 0xec, 0x67, 0x70, 0x45, 0x9e, 0xfb, 0x30, 0x8d, 0xe5, 0x3e, 0xe9, 0x3d}: "AmiTseOemPortingVar23",
		efi.GUID{0x30, 0xe4, 0xe0, 0x2c, 0x3d, 0xa8, 0x45, 0x40, 0x90, 0x40, 0xd6, 0xbf, 0x6e, 0xc8, 0x63, 0x00}: "CustomLogoDxe",
		efi.GUID{0x30, 0xe7, 0x0e, 0xb0, 0xcd, 0x80, 0x78, 0x41, 0x92, 0x7d, 0x37, 0x8a, 0x75, 0xf9, 0xa3, 0xd1}: "RTLWifiDriver",
		efi.GUID{0x30, 0xe8, 0x4d, 0x37, 0xc5, 0x81, 0xc8, 0x4c, 0xb2, 0xab, 0x28, 0xf0, 0xab, 0x73, 0x71, 0x0b}: "SmmCpuFeaturesLibStm",
		efi.GUID{0x30, 0xf1, 0x64, 0x70, 0x6e, 0x84, 0xe2, 0x4c, 0x83, 0xc1, 0x4b, 0xbc, 0xbc, 0xbf, 0x1a, 0xe5}: "AppleBootPolicy",
		efi.GUID{0x31, 0x03, 0x97, 0x49, 0xfa, 0xe3, 0x37, 0x46, 0x9a, 0xbc, 0x3b, 0x78, 0x68, 0x67, 0x69, 0x70}: "AcpiPlatform",
		efi.GUID{0x31, 0x05, 0x6e, 0xed, 0x15, 0xf7, 0x3d, 0x4a, 0x9b, 0x12, 0xc1, 0xca, 0x5e, 0xf6, 0x98, 0xa2}: "IntelFsp2PkgTokenSpaceGuid",
		efi.GUID{0x31, 0x10, 0x5b, 0x29, 0xb5, 0xf0, 0xf4, 0x44, 0xa7, 0x5e, 0x1c, 0xd2, 0x14, 0x5c, 0x4d, 0x18}: "BreakpointCallbackDxe",
		efi.GUID{0x31, 0x14, 0x73, 0xa9, 0x68, 0xd9, 0x77, 0x42, 0xb7, 0x52, 0xa3, 0xa9, 0xa6, 0xae, 0x18, 0x98}: "PeiIpmiPpiGuid",
		efi.GUID{0x31, 0x16, 0xfd, 0x39, 0xcb, 0x64, 0x0c, 0x41, 0x87, 0x4d, 0x24, 0x0f, 0x88, 0xae, 0xd5, 0xf1}: "IGD",
		efi.GUID{0x31, 0x1a, 0x6b, 0xa4, 0x66, 0xad, 0x05, 0x49, 0x92, 0xf6, 0x2b, 0x46, 0x59, 0xdc, 0x30, 0x63}: "EfiExtendedSalPciServicesProtocolGuid",
		efi.GUID{0x31, 0x1d, 0x03, 0x69, 0x0a, 0xfc, 0xee, 0x4c, 0x98, 0x03, 0xf5, 0x30, 0x15, 0xc4, 0x20, 0x8d}: "RealtekGopLoader",
		efi.GUID{0x31, 0x22, 0x74, 0xeb, 0x20, 0xaa, 0x04, 0x4a, 0xa8, 0x79, 0x89, 0xd8, 0x08, 0x54, 0xb2, 0x66}: "SmbiosType11",
		efi.GUID{0x31, 0x22, 0x92, 0x4d, 0x16, 0x4f, 0x8f, 0x46, 0xa7, 0x71, 0xa1, 0xe5, 0xc2, 0x97, 0x13, 0xc9}: "OemDisplayRule",
		efi.GUID{0x31, 0x25, 0x38, 0xaf, 0xe6, 0x52, 0xc4, 0x4c, 0xb2, 0x47, 0xdb, 0x8e, 0x32, 0x0c, 0xbb, 0xa3}: "SmbiosDMIEditBoard",
		efi.GUID{0x31, 0x26, 0x1b, 0xfa, 0xc4, 0x91, 0xf0, 0x43, 0xba, 0x91, 0xaf, 0xbf, 0xc7, 0x45, 0x20, 0x87}: "DellEnhancedVersionDxe",
		efi.GUID{0x31, 0x2b, 0x44, 0x5b, 0x54, 0x1f, 0x16, 0x46, 0xa6, 0xcc, 0x3c, 0xec, 0x4d, 0xb3, 0xa3, 0x4b}: "SraSmmStub",
		efi.GUID{0x31, 0x2d, 0x9d, 0xeb, 0x88, 0x2d, 0xd3, 0x11, 0x9a, 0x16, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d}: "EfiSmbiosTableGuid",
		efi.GUID{0x31, 0x2f, 0x85, 0x73, 0x34, 0x98, 0xc7, 0x4e, 0x97, 0xee, 0x41, 0xe5, 0x84, 0xdc, 0x3c, 0x49}: "LEMComputraceApiSmm",
		efi.GUID{0x31, 0x3b, 0xb0, 0x43, 0x7f, 0x05, 0x1f, 0x4f, 0x9b, 0x53, 0xc3, 0xa5, 0x4f, 0x56, 0x55, 0x86}: "SystemEventPei",
		efi.GUID{0x31, 0x40, 0x74, 0x68, 0x08, 0x86, 0x25, 0x4b, 0xbb, 0xa1, 0xdb, 0x4e, 0xa3, 0x19, 0xd6, 0xea}: "OememDxe",
		efi.GUID{0x31, 0x42, 0x56, 0x7a, 0x0d, 0x24, 0xdb, 0x4b, 0x8b, 0x87, 0x8f, 0x58, 0x9a, 0x98, 0x8e, 0x13}: "SystemVspBcpRuntimeDxe",
		efi.GUID{0x31, 0x45, 0x46, 0x08, 0x99, 0x4c, 0x4c, 0x4c, 0xa8, 0x87, 0x8d, 0x8b, 0xa4, 0xbb, 0xb0, 0x63}: "Ps2MouseDxe",
		efi.GUID{0x31, 0x4e, 0x5e, 0x7f, 0xb1, 0x81, 0xe5, 0x47, 0x9e, 0x21, 0x1e, 0x4b, 0x5b, 0xc2, 0xf6, 0x1d}: "EdkiiPeiFirmwareVolumeInfoStoredHashFvPpi",
		efi.GUID{0x31, 0x56, 0x3e, 0xde, 0x1b, 0x46, 0xf4, 0xb4, 0x06, 0x25, 0x61, 0xb5, 0x8b, 0x87, 0x87, 0xe1}: "HpCmosHandleLoadDefaults",
		efi.GUID{0x31, 0x57, 0x68, 0xee, 0xf3, 0xcf, 0xe7, 0x4e, 0x93, 0x88, 0x7e, 0x63, 0xfc, 0x5a, 0x59, 0xb0}: "PlatformEarlyInit",
		efi.GUID{0x31, 0x58, 0xb0, 0x48, 0x98, 0x32, 0xcc, 0x49, 0x86, 0xcd, 0x30, 0x20, 0xd9, 0x53, 0x81, 0xe7}: "ConfigDataUpdater",
		efi.GUID{0x31, 0x5e, 0xd3, 0xed, 0xb9, 0x07, 0xd2, 0x11, 0x83, 0xa3, 0x00, 0xa0, 0xc9, 0x1f, 0xad, 0xcf}: "BootObjectAuthorizationParmsetGuid",
		efi.GUID{0x31, 0x66, 0xed, 0x76, 0xfe, 0x44, 0xd2, 0x4e, 0x8b, 0x5d, 0x1b, 0x53, 0x55, 0xbb, 0x25, 0xe8}: "LogoDxe",
		efi.GUID{0x31, 0x71, 0x24, 0x8d, 0x5e, 0x38, 0x1f, 0x49, 0xba, 0x68, 0x8d, 0xe9, 0x55, 0x30, 0xb3, 0xa6}: "EfiSetupVariableDefault",
		efi.GUID{0x31, 0x76, 0x4e, 0xfd, 0x58, 0x35, 0x24, 0x4c, 0xad, 0xd3, 0xc4, 0x7e, 0xbe, 0xab, 0x92, 0x67}: "HpSmmVariableProtocol",
		efi.GUID{0x31, 0x79, 0xc3, 0xb9, 0x69, 0xf0, 0x8c, 0x41, 0x9e, 0x19, 0x31, 0xb0, 0xbc, 0x03, 0x18, 0x87}: "LenovoPostValidatorPei",
		efi.GUID{0x31, 0x88, 0xac, 0x37, 0x51, 0x80, 0x65, 0x44, 0x75, 0x4c, 0xe9, 0x92, 0xae, 0x14, 0x00, 0xa7}: "HpRtxXhciDxe",
		efi.GUID{0x31, 0x92, 0xdd, 0xdf, 0xd7, 0xf5, 0x8d, 0x4c, 0x8b, 0xe8, 0x6e, 0xad, 0x87, 0x32, 0x40, 0xf3}: "DellRuntimeSmbiosProtocol",
		efi.GUID{0x31, 0xa7, 0xf6, 0x3a, 0x9a, 0x3e, 0xa8, 0x46, 0x91, 0x0d, 0xdb, 0x4e, 0xcf, 0x37, 0x46, 0x4d}: "InitXnoteSetupHiddenMenuDxe",
		efi.GUID{0x31, 0xaa, 0x95, 0x3b, 0x93, 0x37, 0x4b, 0x43, 0x86, 0x67, 0xc8, 0x07, 0x08, 0x92, 0xe0, 0x5e}: "EfiIp4ConfigProtocolGuid",
		efi.GUID{0x31, 0xb1, 0xf0, 0xf9, 0x46, 0xf3, 0x16, 0x4f, 0x80, 0xdd, 0xf9, 0x41, 0x07, 0x2b, 0x3a, 0x7d}: "IffsPersistentData",
		efi.GUID{0x31, 0xb4, 0xec, 0x48, 0x72, 0xfb, 0xc0, 0x45, 0xa9, 0x22, 0xf4, 0x58, 0xfe, 0x04, 0x0b, 0xd5}: "EfiEdidOverrideProtocolGuid",
		efi.GUID{0x31, 0xbc, 0x8c, 0xb2, 0x64, 0xfd, 0x4e, 0x40, 0x83, 0xdf, 0xed, 0x16, 0x2a, 0xf7, 0x6b, 0x4b}: "CertificateBasedAuthenticationDxe",
		efi.GUID{0x31, 0xc0, 0x74, 0x68, 0x60, 0x82, 0x25, 0x4b, 0xbb, 0xa1, 0xdc, 0x4e, 0xa3, 0x19, 0xd6, 0xea}: "OemDxe",
		efi.GUID{0x31, 0xcb, 0xa3, 0x53, 0x97, 0x7e, 0x12, 0x45, 0xb2, 0xeb, 0xbf, 0xa0, 0xab, 0x8f, 0xd7, 0x5a}: "DeviceDetect",
		efi.GUID{0x31, 0xdd, 0x2b, 0x8c, 0xc6, 0x8f, 0x74, 0x4c, 0xa5, 0xb1, 0xe9, 0x67, 0xe5, 0x1c, 0xa4, 0x82}: "AsusFnLockOption",
		efi.GUID{0x31, 0xde, 0x0f, 0x51, 0x2d, 0x69, 0x86, 0x4d, 0x8d, 0xb7, 0x7f, 0x46, 0x0c, 0x0a, 0x7b, 0x7e}: "PprVlsErrorLogListener",
		efi.GUID{0x31, 0xe2, 0x12, 0x8d, 0x67, 0xc6, 0xd1, 0x4f, 0x98, 0xf2, 0x24, 0x49, 0xa7, 0xe7, 0xb2, 0xe5}: "EfiSmmControlProtocolGuid",
		efi.GUID{0x31, 0xe2, 0x86, 0x23, 0xcf, 0xa9, 0x52, 0x4f, 0x94, 0x6a, 0x6f, 0x6b, 0x6c, 0x13, 0x3b, 0x46}: "DellSmBiosTableLoaderDxe",
		efi.GUID{0x31, 0xe6, 0xe1, 0x3c, 0x08, 0x70, 0x7c, 0x47, 0xad, 0xa7, 0x5d, 0xcf, 0xc7, 0xc1, 0x49, 0x4b}: "EdkiiPeiFirmwareVolumeInfoPrehashedFvPpi",
		efi.GUID{0x31, 0xea, 0xd5, 0xee, 0xe2, 0x38, 0x3d, 0x46, 0xb6, 0x23, 0x2c, 0x57, 0x70, 0x2b, 0x8a, 0x1c}: "SectionExtractionPei",
		efi.GUID{0x31, 0xf8, 0x59, 0xdf, 0x89, 0x66, 0xb5, 0x45, 0xa4, 0xd9, 0x3e, 0x66, 0x0d, 0x56, 0x57, 0x3e}: "LenovoBootOptionProtocol",
		efi.GUID{0x31, 0xfd, 0x13, 0xe8, 0xce, 0xd8, 0xdf, 0x4d, 0x8a, 0x9f, 0x24, 0xd5, 0xca, 0xc6, 0x4f, 0xcf}: "AdlinkGetBoardInfo",
		efi.GUID{0x31, 0xff, 0xd5, 0x18, 0x47, 0x7a, 0x4d, 0x42, 0xb5, 0x00, 0x7d, 0x79, 0x2d, 0x3e, 0x33, 0xac}: "DellDtDiagSmm",
		efi.GUID{0x32, 0x05, 0x49, 0xda, 0x5f, 0xda, 0xc9, 0x43, 0xa0, 0xce, 0x6a, 0x2e, 0x05, 0x91, 0x93, 0x50}: "AfuCapsuleOnDiskDxe",
		efi.GUID{0x32, 0x05, 0x82, 0x67, 0x13, 0x76, 0xd3, 0x4d, 0x9e, 0xd7, 0x3d, 0x9b, 0xe3, 0xa7, 0xda, 0x63}: "Aint13",
		efi.GUID{0x32, 0x08, 0x1d, 0x2b, 0x84, 0x21, 0x8f, 0x4c, 0xa9, 0x0d, 0x8e, 0x4a, 0xf9, 0xde, 0x5b, 0xcd}: "BootModePeim",
		efi.GUID{0x32, 0x0c, 0x64, 0x44, 0xd7, 0x33, 0xb0, 0x4f, 0xb1, 0xf9, 0x6c, 0x7b, 0x23, 0x2e, 0x99, 0x4d}: "SpsPei",
		efi.GUID{0x32, 0x0c, 0x64, 0x44, 0xd7, 0x33, 0xb0, 0x4f, 0xb1, 0xf9, 0x6c, 0x7b, 0x23, 0x2e, 0x99, 0x4e}: "SpsMeSec",
		efi.GUID{0x32, 0x10, 0x83, 0x09, 0xa3, 0x6f, 0x84, 0x44, 0xaf, 0x4f, 0x0a, 0x00, 0x0a, 0x8d, 0x3a, 0x82}: "PL180MciDxe",
		efi.GUID{0x32, 0x1d, 0xad, 0x5e, 0x8a, 0xc3, 0x08, 0x45, 0x8d, 0xcf, 0x0b, 0x99, 0x18, 0x95, 0x7a, 0x4c}: "AmdMemoryHobInfoPeim",
		efi.GUID{0x32, 0x20, 0x55, 0xf3, 0x85, 0x89, 0xdb, 0x11, 0x84, 0x29, 0x00, 0x40, 0xd0, 0x2b, 0x18, 0x35}: "RealTimeClock",
		efi.GUID{0x32, 0x2d, 0x9d, 0xeb, 0x88, 0x2d, 0xd3, 0x11, 0x9a, 0x16, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d}: "EfiSalSystemTableGuid",
		efi.GUID{0x32, 0x32, 0xb9, 0x43, 0xbe, 0xaf, 0xd4, 0x11, 0xbd, 0x0f, 0x00, 0x80, 0xc7, 0x3c, 0x88, 0x81}: "PartitionDxe",
		efi.GUID{0x32, 0x3f, 0xc3, 0x35, 0x61, 0x8c, 0x2d, 0x45, 0x8d, 0x14, 0x9b, 0x5f, 0x53, 0xa2, 0xdf, 0xc0}: "SmmSpiInitilized",
		efi.GUID{0x32, 0x43, 0x27, 0x6b, 0xab, 0x01, 0xc3, 0x4a, 0xb3, 0xae, 0x1d, 0xe3, 0xc6, 0x5a, 0xc3, 0xac}: "PmemResetNotifySmm",
		efi.GUID{0x32, 0x49, 0x18, 0xc5, 0xa5, 0xdb, 0xdb, 0x46, 0xa5, 0xba, 0xcc, 0x0b, 0xda, 0x9c, 0x14, 0x35}: "EfiHashProtocolGuid",
		efi.GUID{0x32, 0x4a, 0x7e, 0x6d, 0x73, 0x9a, 0xba, 0x46, 0x94, 0xa1, 0x5f, 0x2f, 0x25, 0xef, 0x3e, 0x29}: "EfiMemRasProtocol",
		efi.GUID{0x32, 0x4c, 0x9d, 0x02, 0xe8, 0x51, 0x66, 0x48, 0xbf, 0x51, 0xfd, 0x0e, 0xd9, 0xa2, 0xdc, 0x55}: "DellBiosDimmLocation",
		efi.GUID{0x32, 0x57, 0xf5, 0x57, 0x55, 0xcf, 0xc7, 0x43, 0xb6, 0x6b, 0x21, 0x6c, 0xe2, 0x28, 0x28, 0x88}: "MonoStatusCodePei",
		efi.GUID{0x32, 0x5a, 0x59, 0x66, 0x77, 0x18, 0xe1, 0x4a, 0x87, 0x48, 0x80, 0x96, 0x66, 0xed, 0xad, 0xc7}: "AppleVTdDxe",
		efi.GUID{0x32, 0x5a, 0x88, 0xbf, 0xcf, 0x2a, 0x5d, 0x49, 0xa7, 0xba, 0xd3, 0xf9, 0x2f, 0xa9, 0x62, 0x89}: "DellXhciDxe",
		efi.GUID{0x32, 0x61, 0x64, 0x3c, 0x96, 0xed, 0xf0, 0x4e, 0x93, 0xed, 0xb2, 0x09, 0xae, 0x6e, 0x72, 0x7f}: "ManufactureDxeToolBin",
		efi.GUID{0x32, 0x64, 0xa9, 0xef, 0x33, 0xde, 0xd2, 0x4d, 0xae, 0xe6, 0x32, 0x8c, 0x33, 0xdf, 0x77, 0x7a}: "EfiHashAlgorithmSha384Guid",
		efi.GUID{0x32, 0x65, 0x2b, 0x53, 0x99, 0x64, 0x8d, 0x42, 0xac, 0xb1, 0xf6, 0xf7, 0x79, 0xc9, 0x4d, 0xf9}: "AuthvarMailboxVariable",
		efi.GUID{0x32, 0x6d, 0xb2, 0xe1, 0x4f, 0x41, 0xdb, 0x46, 0x9a, 0xee, 0x42, 0x00, 0x77, 0xf3, 0x5d, 0xbe}: "AsrockAmdcpuDxe",
		efi.GUID{0x32, 0x76, 0x3b, 0x14, 0x1b, 0xb8, 0xb7, 0x4c, 0xab, 0xd3, 0xb6, 0x25, 0xa5, 0xb9, 0xbf, 0xfe}: "EfiExtScsiPassThruProtocolGuid",
		efi.GUID{0x32, 0x76, 0xfe, 0x18, 0xc8, 0xf5, 0x63, 0x4e, 0x8d, 0xe8, 0x17, 0xa5, 0x5c, 0x59, 0x13, 0xbd}: "StandaloneSmmPkgTokenSpace",
		efi.GUID{0x32, 0x89, 0x49, 0x9e, 0xbc, 0x4a, 0xaf, 0x45, 0xa3, 0x4d, 0x02, 0x47, 0x78, 0x7b, 0xe7, 0xc6}: "EfiDiskInfoAhciInterfaceGuid",
		efi.GUID{0x32, 0x8f, 0x4e, 0xac, 0xee, 0x1c, 0x93, 0x44, 0x9e, 0xf0, 0xaa, 0xd8, 0x77, 0x3f, 0x83, 0x23}: "RTS5229",
		efi.GUID{0x32, 0x91, 0xca, 0x67, 0x15, 0x44, 0x15, 0x48, 0xb2, 0xe0, 0xdb, 0xdf, 0x68, 0x78, 0x78, 0x71}: "OemMedinaEC",
		efi.GUID{0x32, 0x99, 0x74, 0x3b, 0xe6, 0x2d, 0x21, 0x40, 0xa6, 0x39, 0x57, 0x53, 0x53, 0x6a, 0x4f, 0xcf}: "AsusSensor",
		efi.GUID{0x32, 0xa1, 0xaf, 0x81, 0x94, 0x8d, 0x01, 0x41, 0xa5, 0x38, 0x83, 0x3c, 0x05, 0xd1, 0x45, 0xd9}: "BoardSelectDxe",
		efi.GUID{0x32, 0xa3, 0xe6, 0x9f, 0x1f, 0x1a, 0xe3, 0x43, 0xbd, 0x25, 0xf7, 0x89, 0x1c, 0x6f, 0xc7, 0x4a}: "EfiBmcSelfTestLogProtocol",
		efi.GUID{0x32, 0xa8, 0x00, 0x20, 0x74, 0xc6, 0x6a, 0x48, 0x81, 0xbe, 0xcb, 0x46, 0x70, 0xa4, 0xf7, 0xfd}: "DellRebootDxe",
		efi.GUID{0x32, 0xb1, 0x68, 0x3d, 0x52, 0x26, 0xfd, 0x47, 0xb2, 0xe9, 0xb4, 0x17, 0x12, 0x2b, 0x5a, 0x6d}: "DellCommonBoardInitSmm",
		efi.GUID{0x32, 0xb2, 0x88, 0x26, 0x02, 0x9c, 0x12, 0x4c, 0xbe, 0x1f, 0x85, 0x7c, 0x0f, 0xf2, 0xaa, 0xe3}: "TcgDxeplatform",
		efi.GUID{0x32, 0xb4, 0xaa, 0xd8, 0xcc, 0x93, 0xd2, 0x48, 0x9f, 0x34, 0x34, 0x96, 0xca, 0xf9, 0x21, 0x85}: "SmartFanCtrlDXE",
		efi.GUID{0x32, 0xb8, 0x06, 0x4d, 0x87, 0x69, 0xf2, 0x40, 0xb7, 0x6d, 0xd1, 0x70, 0xb4, 0x2d, 0xb1, 0x82}: "TrEEPhysicalPresenceDxe",
		efi.GUID{0x32, 0xba, 0x5a, 0xf6, 0xfd, 0x76, 0xc6, 0x49, 0xa1, 0xc4, 0xcd, 0x7f, 0xad, 0xf9, 0x66, 0x59}: "AmiReportFvLibCompatibility",
		efi.GUID{0x32, 0xc0, 0xb5, 0x96, 0x4c, 0xdf, 0x6e, 0x4b, 0x82, 0x32, 0x43, 0x8d, 0xcf, 0x44, 0x8d, 0x0e}: "NullMemoryTestDxe",
		efi.GUID{0x32, 0xc2, 0x8a, 0x69, 0xa6, 0x28, 0xec, 0x40, 0x94, 0xaa, 0x7d, 0x30, 0x2d, 0xbf, 0x56, 0x67}: "PdrCapsule",
		efi.GUID{0x32, 0xc3, 0x35, 0x05, 0x4d, 0x6d, 0x89, 0x4d, 0x94, 0x68, 0xf3, 0x62, 0x7b, 0xb3, 0x86, 0xce}: "H19MpmRuntimeDxe",
		efi.GUID{0x32, 0xc4, 0x0a, 0x22, 0x43, 0x1d, 0xe5, 0x49, 0xa7, 0x4f, 0x4c, 0x9d, 0xa6, 0x7a, 0xd2, 0x3b}: "HotPlugDevice",
		efi.GUID{0x32, 0xd5, 0x74, 0xf1, 0x57, 0xd2, 0xe0, 0x4f, 0x92, 0xa3, 0xb6, 0x64, 0xe8, 0xbb, 0xc8, 0xed}: "HpCoreErrorCodeHandlerPei",
		efi.GUID{0x32, 0xe2, 0x9b, 0x7d, 0x3d, 0x0d, 0xc1, 0x47, 0xb4, 0x5c, 0x34, 0x4c, 0x5b, 0x51, 0x52, 0xad}: "FjClearsureSmm",
		efi.GUID{0x32, 0xf0, 0xa8, 0xae, 0x01, 0x46, 0x89, 0x01, 0x24, 0x11, 0x6c, 0x8e, 0x30, 0x27, 0xee, 0x8e}: "DellDataWipeDxe",
		efi.GUID{0x32, 0xf4, 0x98, 0xc4, 0xb7, 0xb8, 0xbf, 0x44, 0x86, 0xd3, 0x7b, 0x36, 0xf2, 0xec, 0x13, 0x90}: "IFWIVersionHobGuid",
		efi.GUID{0x32, 0xf9, 0xd1, 0xc4, 0x1f, 0x82, 0x44, 0x47, 0xbf, 0x06, 0x6d, 0x30, 0xf7, 0x73, 0x0f, 0x8d}: "Ps2KeyboardDxe",
		efi.GUID{0x33, 0x02, 0xd8, 0x85, 0x1b, 0xb3, 0xf2, 0x40, 0x81, 0x31, 0x03, 0x44, 0x05, 0xfc, 0x59, 0x36}: "SmbiosType133",
		efi.GUID{0x33, 0x03, 0x39, 0x17, 0xe6, 0x4c, 0xa8, 0x48, 0xaf, 0xb9, 0x0e, 0xf5, 0x5b, 0x66, 0x6b, 0x74}: "RunTimeAcpiDxe",
		efi.GUID{0x33, 0x03, 0xc4, 0x02, 0xd5, 0xce, 0xba, 0x45, 0x88, 0x36, 0xb4, 0x7e, 0x4c, 0x36, 0x48, 0x9e}: "PlatformFanControl",
		efi.GUID{0x33, 0x0d, 0x2b, 0xfe, 0x3d, 0x13, 0x53, 0x42, 0xa9, 0x7c, 0x08, 0xf1, 0x41, 0x04, 0x4d, 0x85}: "OemRealtekWlanUndi",
		efi.GUID{0x33, 0x0f, 0xd1, 0x5c, 0x3b, 0xb7, 0x5f, 0x46, 0xa8, 0x9b, 0x7a, 0x88, 0x11, 0x37, 0xd4, 0x16}: "H19ServiceBodyDxe",
		efi.GUID{0x33, 0x11, 0x7a, 0xbc, 0x66, 0x4c, 0xba, 0xc6, 0xb4, 0xd8, 0xeb, 0x9f, 0xef, 0xb9, 0xf1, 0x46}: "AmdSocSp3r3CpPei",
		efi.GUID{0x33, 0x12, 0x2d, 0x2e, 0x5e, 0x43, 0x6f, 0xf5, 0x7c, 0xc3, 0x34, 0x8c, 0xe6, 0x60, 0xd1, 0xcf}: "SystemErrorEventsDxe",
		efi.GUID{0x33, 0x12, 0xaa, 0x56, 0x07, 0x74, 0x58, 0x40, 0x9e, 0x17, 0x88, 0xde, 0x13, 0x8e, 0xa1, 0x5d}: "AmdCcxZen3CznDxe",
		efi.GUID{0x33, 0x28, 0x1b, 0x46, 0xa5, 0x3d, 0x56, 0x45, 0x95, 0xf2, 0xba, 0x50, 0x61, 0x31, 0x05, 0x1b}: "ExtCfgDevDrvDxe",
		efi.GUID{0x33, 0x2e, 0x97, 0x9f, 0x91, 0x9b, 0x94, 0x4a, 0x85, 0x40, 0x5a, 0x00, 0x64, 0x0c, 0x27, 0x71}: "POSTCODE0A_RGBKBCTRL_SMM",
		efi.GUID{0x33, 0x34, 0x8d, 0x9a, 0xe8, 0x9f, 0xb6, 0x42, 0x87, 0x0b, 0x1e, 0x31, 0xc8, 0x4e, 0xbe, 0x3b}: "BootScriptExecutorImageGuid",
		efi.GUID{0x33, 0x34, 0xd9, 0xfa, 0xb9, 0x76, 0x82, 0x44, 0x45, 0x67, 0x3b, 0xea, 0xce, 0xa9, 0xb3, 0x5d}: "A01WMISmmCallback",
		efi.GUID{0x33, 0x35, 0x03, 0x4a, 0x70, 0xd5, 0xf6, 0x43, 0xba, 0x84, 0x61, 0xcb, 0xa7, 0x01, 0x65, 0xf8}: "DellUefiClass3ConfigPei",
		efi.GUID{0x33, 0x3a, 0x87, 0xad, 0xe5, 0x61, 0xde, 0x45, 0xbb, 0x73, 0x84, 0xf8, 0x46, 0x1f, 0xb9, 0xef}: "DellHddSecurity",
		efi.GUID{0x33, 0x3c, 0x98, 0x3c, 0x22, 0x7d, 0x0e, 0x5e, 0xaa, 0x5b, 0xa7, 0xcd, 0x24, 0xa3, 0x1b, 0x54}: "Tcg2FTPMSmm",
		efi.GUID{0x33, 0x3d, 0xd2, 0x56, 0xd7, 0x07, 0xf9, 0x48, 0x81, 0xd6, 0x7e, 0xd5, 0x99, 0x1e, 0xce, 0x88}: "OpaPlatCfgNvVar",
		efi.GUID{0x33, 0x40, 0x74, 0x68, 0x08, 0x86, 0x25, 0x4b, 0xbb, 0xa1, 0xdb, 0x4e, 0xa3, 0x19, 0xd6, 0xea}: "ModernStandby",
		efi.GUID{0x33, 0x43, 0xac, 0x43, 0x2c, 0x47, 0x91, 0x4b, 0x8c, 0x5c, 0x52, 0xa8, 0xb4, 0x37, 0x42, 0x56}: "IioCfgUpdateDxeNeonCityFPGA",
		efi.GUID{0x33, 0x52, 0x6e, 0x0b, 0x5c, 0xa6, 0xc9, 0x44, 0x94, 0x07, 0xd9, 0xab, 0x83, 0xbf, 0xc8, 0xbd}: "EfiCertSha224Guid",
		efi.GUID{0x33, 0x52, 0xfc, 0x8c, 0xc6, 0x23, 0xe3, 0x49, 0x8a, 0x2d, 0x7e, 0x58, 0x1a, 0xb3, 0x05, 0xba}: "EdbCfg",
		efi.GUID{0x33, 0x53, 0x7a, 0x6d, 0xe0, 0x52, 0x10, 0x49, 0x9d, 0xe7, 0x91, 0xcd, 0xb0, 0x63, 0x95, 0xf6}: "XnoteFlashCommunicationSmm",
		efi.GUID{0x33, 0x56, 0x97, 0x54, 0x45, 0x09, 0x9c, 0x4d, 0x97, 0xc2, 0xe0, 0xcc, 0x64, 0x69, 0xa5, 0xa3}: "MeLibPei",
		efi.GUID{0x33, 0x62, 0x69, 0xbb, 0x1f, 0x9d, 0xc5, 0x4a, 0xb0, 0x57, 0x41, 0xdd, 0xad, 0x3b, 0x0c, 0xc1}: "OemAcpiMode",
		efi.GUID{0x33, 0x67, 0x17, 0xc1, 0x9f, 0x15, 0xd5, 0x42, 0xbc, 0xb9, 0x32, 0x06, 0x60, 0xb1, 0x73, 0x10}: "UbaConfigDatabasePpi",
		efi.GUID{0x33, 0x6d, 0x36, 0xce, 0x57, 0xb0, 0x03, 0x4c, 0x85, 0x61, 0xca, 0xf1, 0x77, 0x38, 0xb6, 0x6f}: "WdtAppDxe",
		efi.GUID{0x33, 0x8d, 0xa2, 0x9e, 0x75, 0x01, 0x88, 0x47, 0xbe, 0xa8, 0x69, 0x50, 0x51, 0x60, 0x30, 0xa5}: "SmBusPei",
		efi.GUID{0x33, 0x93, 0x93, 0xdf, 0xfc, 0x42, 0x2a, 0x4b, 0xa5, 0x9e, 0xbb, 0xae, 0x82, 0x81, 0xfe, 0xef}: "EdkiiBootManagerMenuFile",
		efi.GUID{0x33, 0x94, 0x25, 0x78, 0x6d, 0x7b, 0xb3, 0x4d, 0x9a, 0xe8, 0x36, 0xc4, 0xc2, 0xc3, 0xa1, 0x7d}: "MeInfoSetup",
		efi.GUID{0x33, 0x9d, 0xaf, 0x0f, 0xb7, 0xe3, 0xde, 0x49, 0x9b, 0x04, 0x3a, 0x8b, 0x1e, 0x73, 0x2a, 0xfd}: "Armani_BatteryInfoSmm",
		efi.GUID{0x33, 0x9f, 0x72, 0x0f, 0xc1, 0x25, 0xa7, 0x41, 0x86, 0xb2, 0x23, 0xa7, 0x37, 0xa9, 0x18, 0x23}: "IntelSnbGopVbt",
		efi.GUID{0x33, 0xa7, 0xe9, 0xb6, 0x75, 0xeb, 0xb6, 0x41, 0xb3, 0x0c, 0x00, 0x9b, 0xcf, 0x38, 0x01, 0xc8}: "BasePostCodeLibPort80",
		efi.GUID{0x33, 0xb1, 0x9d, 0x27, 0xc6, 0xb4, 0x34, 0x4a, 0x9b, 0xe3, 0xc9, 0x83, 0x26, 0xdc, 0x27, 0xdc}: "LEMHddSecurityEndProtocolHook",
		efi.GUID{0x33, 0xb5, 0x6f, 0x71, 0xbd, 0x26, 0xac, 0x4b, 0x98, 0x20, 0x22, 0x9b, 0xd5, 0xa7, 0xd3, 0x00}: "FprGoodixMocPrometheusDriver",
		efi.GUID{0x33, 0xba, 0x03, 0x5f, 0x6b, 0x8c, 0x24, 0x4c, 0xaa, 0x2e, 0x14, 0xa2, 0x65, 0x7b, 0xd4, 0x54}: "EfiUserCredentialClassSmartCardGuid",
		efi.GUID{0x33, 0xbe, 0xbd, 0xaa, 0xdc, 0xdb, 0xd3, 0x43, 0xaf, 0xe3, 0xab, 0x37, 0xf9, 0xb4, 0x67, 0x82}: "LEMCBMRDxe",
		efi.GUID{0x33, 0xbf, 0x05, 0xac, 0x5a, 0x99, 0xd4, 0x4e, 0xaa, 0xb8, 0xef, 0x7a, 0xe8, 0x0f, 0x5c, 0xb0}: "UefiCpuPkgTokenSpaceGuid",
		efi.GUID{0x33, 0xc3, 0x8d, 0x3f, 0xd5, 0xcc, 0x58, 0x4e, 0xb8, 0xcf, 0x7b, 0x9a, 0x8f, 0x31, 0xea, 0x96}: "AmiTseOemPortingVar29",
		efi.GUID{0x33, 0xcb, 0x0b, 0x02, 0xa7, 0x7e, 0x48, 0x4e, 0x9a, 0xf8, 0x1b, 0x6a, 0xc5, 0x2c, 0xe8, 0x3f}: "MeBackDoorSMI",
		efi.GUID{0x33, 0xcc, 0x0d, 0x43, 0x69, 0x31, 0xb9, 0x44, 0xb4, 0x30, 0x23, 0xfc, 0xab, 0x91, 0x02, 0xe6}: "CheckEthernetState",
		efi.GUID{0x33, 0xd1, 0xed, 0x94, 0x9b, 0x41, 0x7f, 0x44, 0x94, 0x34, 0x9b, 0x3b, 0x70, 0x88, 0x39, 0x03}: "ModernStandbyResouceCheck",
		efi.GUID{0x33, 0xd2, 0x8f, 0x97, 0xa8, 0x09, 0xa0, 0x4f, 0x98, 0xe2, 0xd4, 0xb6, 0x2c, 0x20, 0x32, 0x51}: "WarmResetFlagOS",
		efi.GUID{0x33, 0xd5, 0x32, 0xed, 0xe6, 0x99, 0x09, 0x42, 0x9c, 0xc0, 0x2d, 0x72, 0xcd, 0xd9, 0x98, 0xa7}: "EfiSmmVariableProtocolGuid",
		efi.GUID{0x33, 0xde, 0xa6, 0x02, 0xa9, 0x3e, 0x17, 0x4c, 0x8e, 0xa2, 0x56, 0x81, 0xcc, 0x7a, 0xfd, 0xed}: "VMDDxeEfi",
		efi.GUID{0x33, 0xe6, 0x93, 0x1e, 0x5a, 0xd6, 0x9e, 0x45, 0xab, 0x84, 0x93, 0xd9, 0xec, 0x26, 0x6d, 0x18}: "EfiTapeIoProtocolGuid",
		efi.GUID{0x33, 0xf5, 0x93, 0x24, 0x5c, 0xa2, 0x65, 0x4e, 0xb2, 0x6c, 0xcf, 0x4d, 0xd6, 0xb7, 0x90, 0x3b}: "SctMilestoneTaskSmm",
		efi.GUID{0x33, 0xf9, 0x40, 0x65, 0x5f, 0x42, 0x4b, 0x46, 0xb4, 0xad, 0xb9, 0x3a, 0x6e, 0xd0, 0xa8, 0xf5}: "OcInit",
		efi.GUID{0x34, 0x05, 0xa9, 0xae, 0x02, 0xa6, 0xe2, 0x46, 0xb3, 0xe5, 0x1f, 0x01, 0xda, 0x26, 0x64, 0xbb}: "OemVMDHiddenSlot",
		efi.GUID{0x34, 0x0d, 0xf1, 0x55, 0x05, 0x4f, 0x6a, 0x42, 0x9a, 0x72, 0x61, 0x3e, 0xa8, 0x54, 0x4d, 0xe0}: "AmdCpmPmfBoardPeim",
		efi.GUID{0x34, 0x12, 0x3a, 0x01, 0x4e, 0xdb, 0x23, 0x31, 0xce, 0xa6, 0x9a, 0x31, 0x98, 0x2c, 0xae, 0x96}: "DiskSanitizer",
		efi.GUID{0x34, 0x12, 0x87, 0x78, 0x87, 0x87, 0x78, 0x78, 0xa1, 0x9b, 0x0b, 0xe6, 0x1b, 0x23, 0x31, 0x87}: "DeviceWa",
		efi.GUID{0x34, 0x12, 0xda, 0x22, 0xb3, 0x1d, 0x56, 0x4d, 0x86, 0x46, 0xfd, 0x78, 0x5a, 0x59, 0x33, 0x7e}: "AmiDfciPlatform",
		efi.GUID{0x34, 0x17, 0x5d, 0x49, 0xd3, 0x05, 0x0f, 0x40, 0xaf, 0x35, 0xc8, 0xbc, 0xd3, 0xb8, 0x5c, 0xc3}: "DellSmmSysBootDevicesPolicyProtocol",
		efi.GUID{0x34, 0x2a, 0x93, 0xe3, 0x29, 0x57, 0x24, 0x4f, 0x9f, 0xb1, 0xd7, 0x40, 0x9b, 0x45, 0x6a, 0x15}: "OemBadgingSupport",
		efi.GUID{0x34, 0x2c, 0xe3, 0x11, 0xb5, 0x60, 0x91, 0x49, 0x8d, 0xea, 0x63, 0xd3, 0xe8, 0xc8, 0x76, 0xde}: "UsbRndisDriverSrc",
		efi.GUID{0x34, 0x2d, 0xbd, 0xcd, 0x33, 0x0e, 0xa8, 0x46, 0xa6, 0xe8, 0x38, 0xae, 0x30, 0x89, 0x9f, 0xa1}: "EzTpmUpdIfxFwDrv",
		efi.GUID{0x34, 0x32, 0x4d, 0xd3, 0xba, 0x38, 0x8b, 0x42, 0x9a, 0xcd, 0x84, 0xe8, 0x30, 0xa8, 0x07, 0x85}: "AmiModulePkgTokenSpaceGuid",
		efi.GUID{0x34, 0x3c, 0xe8, 0x56, 0x51, 0x14, 0x85, 0x42, 0x89, 0x0d, 0xe1, 0xf1, 0x7e, 0xbd, 0x9c, 0x44}: "MeFirmwareRevisionCheck",
		efi.GUID{0x34, 0x49, 0x5c, 0xe1, 0x6c, 0x05, 0x6c, 0x46, 0x9e, 0xce, 0xff, 0x86, 0xc0, 0x74, 0x2b, 0x57}: "OemWorkaroundPei",
		efi.GUID{0x34, 0x4a, 0x86, 0x62, 0x33, 0x47, 0xc8, 0x4d, 0x9c, 0xc3, 0xf8, 0x6e, 0xdd, 0x0b, 0x32, 0x76}: "ThunderboltSmm",
		efi.GUID{0x34, 0x4d, 0x59, 0x82, 0xdc, 0x85, 0xd4, 0x49, 0x99, 0x2e, 0x23, 0x8e, 0x62, 0x2f, 0x61, 0x52}: "OemSmmSample",
		efi.GUID{0x34, 0x57, 0x97, 0xb1, 0xc2, 0x77, 0x27, 0x48, 0x96, 0x17, 0x91, 0x48, 0x83, 0xf3, 0xb5, 0x78}: "ATFHobPeim",
		efi.GUID{0x34, 0x59, 0xef, 0x99, 0x22, 0x78, 0xc4, 0x49, 0x83, 0xa4, 0x50, 0xc1, 0xaf, 0xbc, 0xbe, 0x00}: "MeCapsule",
		efi.GUID{0x34, 0x6a, 0x4a, 0x53, 0x78, 0xcf, 0x56, 0x4a, 0xbe, 0xdb, 0xcb, 0x49, 0xa8, 0xd8, 0x06, 0x0c}: "RTCWakeup",
		efi.GUID{0x34, 0x6d, 0x8e, 0xc3, 0x7f, 0x5a, 0xf9, 0x4b, 0xbe, 0x57, 0x94, 0xdd, 0x30, 0x38, 0x02, 0x76}: "EfiPccardSsProtocol",
		efi.GUID{0x34, 0x75, 0x9e, 0xdd, 0x62, 0x77, 0x98, 0x46, 0x8c, 0x14, 0xf5, 0x85, 0x17, 0xa6, 0x25, 0xaa}: "EfiSimpleTextInputExProtocolGuid",
		efi.GUID{0x34, 0x7a, 0x73, 0xb3, 0x8c, 0x62, 0xcf, 0x43, 0x9a, 0x65, 0xc2, 0x35, 0x77, 0x2f, 0x18, 0x19}: "FjScrtyRuntimeService",
		efi.GUID{0x34, 0x7a, 0xc8, 0xb9, 0xc6, 0x3f, 0xa9, 0x41, 0xaa, 0x66, 0xcd, 0x01, 0x1f, 0x75, 0xcb, 0x80}: "LenovoCustomizedLogoDxe",
		efi.GUID{0x34, 0x83, 0x57, 0x50, 0xfd, 0xfc, 0xca, 0x4d, 0xb3, 0xaf, 0x47, 0xdd, 0x76, 0xe9, 0x46, 0xcf}: "AmdNbioDxe",
		efi.GUID{0x34, 0x85, 0x73, 0xb3, 0x51, 0x90, 0xd1, 0x40, 0x93, 0x33, 0x91, 0x28, 0x4a, 0x59, 0x90, 0xce}: "AmiPciHotPlugLibNull",
		efi.GUID{0x34, 0x87, 0x6b, 0x7d, 0x54, 0xb7, 0x3f, 0x44, 0xb5, 0x88, 0x77, 0x43, 0x84, 0x3a, 0xd3, 0xf1}: "AmiSmbiosMemoryInfoHob",
		efi.GUID{0x34, 0x90, 0x68, 0x17, 0x1b, 0xf1, 0x8b, 0x46, 0x8c, 0xc4, 0xe1, 0x14, 0xc7, 0x7f, 0x41, 0xb1}: "AsusPTTDxe",
		efi.GUID{0x34, 0xa2, 0x24, 0x7d, 0xc2, 0xa8, 0x18, 0x47, 0xbf, 0x60, 0xa2, 0xef, 0x07, 0x0f, 0x41, 0x4e}: "OpalPasswordSmm",
		efi.GUID{0x34, 0xa8, 0x7e, 0x52, 0xb5, 0xeb, 0xec, 0x44, 0xaa, 0x27, 0xbc, 0x0f, 0xdc, 0xc0, 0x22, 0x6c}: "FjSecureServicesDxe",
		efi.GUID{0x34, 0xab, 0x72, 0xd4, 0x21, 0x8e, 0x43, 0x43, 0x8b, 0xff, 0x01, 0xec, 0xde, 0x29, 0x23, 0x75}: "DellThrottlingDriver",
		efi.GUID{0x34, 0xb4, 0x08, 0xe0, 0x73, 0x0e, 0x0c, 0x44, 0x86, 0x12, 0xa1, 0x43, 0xf6, 0xa0, 0x7b, 0xcb}: "Recovery",
		efi.GUID{0x34, 0xba, 0x10, 0x13, 0xb4, 0xd7, 0x80, 0x4a, 0xa6, 0x45, 0x8c, 0x04, 0x17, 0xc6, 0xaa, 0x55}: "AmiMemoryInfoConfig",
		efi.GUID{0x34, 0xc3, 0x34, 0x18, 0x84, 0x6f, 0x47, 0x41, 0xb7, 0x2e, 0x16, 0xa1, 0xaf, 0x7b, 0xef, 0x02}: "AsusPEFirmwareBiosGuardVS2015Bin",
		efi.GUID{0x34, 0xcf, 0x8d, 0x83, 0x7b, 0x90, 0x55, 0x4d, 0x9a, 0x4b, 0xa0, 0xef, 0x71, 0x67, 0xb5, 0xf4}: "NvramPei",
		efi.GUID{0x34, 0xd1, 0x2b, 0x7d, 0x0d, 0x50, 0x42, 0x4f, 0xae, 0xe2, 0x26, 0xac, 0xcf, 0xb6, 0xcb, 0x1d}: "LibStdio",
		efi.GUID{0x34, 0xd7, 0xb1, 0x55, 0xe1, 0xc5, 0xdb, 0x49, 0x96, 0x47, 0xb1, 0x6a, 0xfb, 0x0e, 0x30, 0x5b}: "EfiHash2ProtocolGuid",
		efi.GUID{0x34, 0xda, 0xb6, 0xd6, 0x7b, 0x91, 0x11, 0x45, 0xb1, 0x47, 0x40, 0x76, 0x53, 0xbf, 0x39, 0x1a}: "FjEvtControlDxe",
		efi.GUID{0x34, 0xe4, 0xeb, 0x0f, 0xaf, 0xa6, 0x66, 0x41, 0xbc, 0x2f, 0xde, 0x2c, 0x59, 0x52, 0xc8, 0x7d}: "DellAbsoluteDxe",
		efi.GUID{0x34, 0xe8, 0x0f, 0x7f, 0x27, 0x07, 0x40, 0x46, 0x95, 0xe9, 0x9b, 0x1c, 0x05, 0x6f, 0x87, 0xb8}: "CypressCCGx",
		efi.GUID{0x34, 0xec, 0xd5, 0xc0, 0xe4, 0x13, 0x3b, 0x40, 0x96, 0x43, 0x54, 0xaa, 0x7f, 0x72, 0x25, 0x9d}: "SystemSecureFlashAuthenticationSmm",
		efi.GUID{0x34, 0xf7, 0x3b, 0xbb, 0x40, 0xd6, 0xf5, 0x4c, 0xaf, 0xea, 0xca, 0x8c, 0xfa, 0x60, 0x20, 0xd1}: "ASUS_USBFLASHBACK",
		efi.GUID{0x34, 0xfa, 0xb9, 0x86, 0x89, 0xf8, 0xdc, 0x4d, 0xae, 0xc7, 0x40, 0xd2, 0x86, 0xec, 0x61, 0x81}: "I2cTouchScreenDxe",
		efi.GUID{0x34, 0xfd, 0x8c, 0xfc, 0x25, 0x4d, 0x8c, 0x47, 0x83, 0xf0, 0x03, 0x09, 0xc9, 0x3f, 0xfb, 0xa4}: "AmdCcxVhDxe",
		efi.GUID{0x35, 0x0c, 0x96, 0x6f, 0xed, 0xff, 0x78, 0x47, 0x99, 0xa1, 0x4d, 0x99, 0x8c, 0xe5, 0x19, 0xb9}: "AmdNbioSmuV10Dxe",
		efi.GUID{0x35, 0x12, 0x20, 0x1d, 0x40, 0x2f, 0xbc, 0x4f, 0x86, 0x50, 0x85, 0x02, 0x09, 0x2d, 0x62, 0xab}: "LenovoEaiaDxe",
		efi.GUID{0x35, 0x17, 0x0b, 0x0f, 0xa0, 0x87, 0x93, 0x41, 0xb2, 0x66, 0x53, 0x8c, 0x38, 0xaf, 0x48, 0xce}: "EfiIfrTianoGuid",
		efi.GUID{0x35, 0x1f, 0x8d, 0xd3, 0x0b, 0x89, 0xca, 0x43, 0xbf, 0x9b, 0x96, 0x33, 0x7b, 0x86, 0xb0, 0x6b}: "TypeADh",
		efi.GUID{0x35, 0x25, 0x99, 0xcb, 0x13, 0x87, 0xde, 0x4a, 0x94, 0xf2, 0x5d, 0x32, 0xcc, 0xab, 0x8c, 0x5e}: "PostIbbVerificationCollectorPei",
		efi.GUID{0x35, 0x26, 0x98, 0xf3, 0x06, 0x77, 0x42, 0x48, 0x84, 0x0f, 0x64, 0x79, 0xb4, 0x86, 0x58, 0x66}: "DellSimpleBootFlagDxe",
		efi.GUID{0x35, 0x2b, 0x8c, 0x6f, 0xf4, 0xfe, 0x8d, 0x44, 0x82, 0x56, 0xe1, 0x1b, 0x19, 0xd6, 0x10, 0x77}: "EfiSecPlatformInformationPpiGuid",
		efi.GUID{0x35, 0x2c, 0x07, 0xd9, 0x8f, 0xeb, 0xad, 0x43, 0xa2, 0x20, 0x34, 0xd4, 0x0e, 0x2a, 0x82, 0x85}: "EfiSmmSpiProtocolGuid",
		efi.GUID{0x35, 0x30, 0x30, 0x73, 0xd0, 0xd6, 0xb5, 0x46, 0x8e, 0xca, 0x13, 0x9e, 0xe2, 0x87, 0xc0, 0x00}: "RaidDriver",
		efi.GUID{0x35, 0x35, 0xfb, 0x33, 0x5e, 0xf1, 0x17, 0x4c, 0xb3, 0x03, 0x5e, 0xb9, 0x45, 0x95, 0xec, 0xb6}: "SmmLockBox",
		efi.GUID{0x35, 0x37, 0xb1, 0x41, 0x0a, 0x0e, 0x67, 0x4f, 0x96, 0xd1, 0xb1, 0x5d, 0xa2, 0x82, 0x05, 0xfa}: "SIOBasicIODXE",
		efi.GUID{0x35, 0x3a, 0x22, 0xde, 0x1c, 0x93, 0x12, 0x4c, 0x8e, 0x47, 0x73, 0xb7, 0xa6, 0x5c, 0x2b, 0x7a}: "AmdPspRomArmor2Smm",
		efi.GUID{0x35, 0x42, 0xd1, 0x4f, 0xa1, 0x47, 0x50, 0xe3, 0x12, 0x3f, 0x75, 0x92, 0x53, 0x06, 0x27, 0x9d}: "AmdSocAm4RnDxe",
		efi.GUID{0x35, 0x48, 0x5a, 0xd8, 0x82, 0x5a, 0x94, 0x48, 0xac, 0x02, 0x70, 0x6f, 0x43, 0xd5, 0x97, 0x8e}: "EdkiiConfigurationManagerProtocol",
		efi.GUID{0x35, 0x48, 0xee, 0xb7, 0xce, 0x84, 0x15, 0x4b, 0xbf, 0x52, 0x2d, 0x11, 0x57, 0x4c, 0xe4, 0x70}: "HardwareSignatureEntry",
		efi.GUID{0x35, 0x78, 0x20, 0xd6, 0xe3, 0xb7, 0xf8, 0x4f, 0xb2, 0x76, 0xcd, 0xe3, 0xe5, 0x22, 0x06, 0xbc}: "SmbiosDataUpdateDxeLightningRidgeEXECB1",
		efi.GUID{0x35, 0x78, 0x5d, 0x69, 0x47, 0x8d, 0x11, 0x4c, 0xab, 0x22, 0xfa, 0x8a, 0xcc, 0xe7, 0xae, 0x7a}: "EdkiiPlatformSpecificResetFilterProtocol",
		efi.GUID{0x35, 0x82, 0x2e, 0xea, 0xbd, 0x37, 0xfd, 0x4f, 0x85, 0x71, 0x55, 0x6d, 0x4a, 0xae, 0x3e, 0xd8}: "UsbTypeCSxIndicatorsSMM",
		efi.GUID{0x35, 0x82, 0xa1, 0x65, 0x96, 0x50, 0x32, 0x40, 0x8c, 0x63, 0x21, 0x4f, 0x02, 0x49, 0xce, 0x8d}: "BaseMemoryLibSse2",
		efi.GUID{0x35, 0x82, 0xd2, 0xac, 0x5b, 0x07, 0xb5, 0x48, 0x98, 0xa1, 0xda, 0x04, 0xfc, 0xaf, 0x84, 0xf3}: "SiInitDxe",
		efi.GUID{0x35, 0x9e, 0x16, 0x24, 0x54, 0x24, 0x40, 0x49, 0x92, 0xbc, 0x82, 0x32, 0x1a, 0x2c, 0x75, 0x62}: "VlvInitPeim",
		efi.GUID{0x35, 0xa2, 0x24, 0x0d, 0x12, 0x9c, 0x6c, 0x44, 0x8e, 0xcb, 0xef, 0xc1, 0xf5, 0x28, 0x02, 0x09}: "DellJpegDecoder",
		efi.GUID{0x35, 0xa3, 0xde, 0xac, 0xb9, 0x34, 0xd0, 0x4f, 0xa4, 0xb8, 0xfa, 0x4d, 0xd0, 0xf7, 0x39, 0x58}: "SmuV12DxeCZN",
		efi.GUID{0x35, 0xa8, 0x81, 0xb9, 0xe8, 0x6e, 0x4c, 0x4f, 0xae, 0x0b, 0x21, 0x0a, 0xa0, 0xbf, 0xbf, 0x01}: "RngDxe",
		efi.GUID{0x35, 0xa9, 0x95, 0x0c, 0x06, 0xa0, 0xd4, 0x11, 0xbc, 0xfa, 0x00, 0x80, 0xc7, 0x3c, 0x88, 0x81}: "EfiWinNtFileSystemGuid",
		efi.GUID{0x35, 0xac, 0xd8, 0x11, 0x8a, 0xfb, 0xd1, 0x44, 0x8d, 0x09, 0x0b, 0x56, 0x06, 0xd3, 0x21, 0xb9}: "DSDT",
		efi.GUID{0x35, 0xb0, 0x9b, 0xa8, 0xe2, 0xb7, 0xcf, 0x42, 0xb2, 0x7d, 0xc1, 0xa5, 0x0f, 0xcb, 0xc1, 0xca}: "DellUnzipDriver",
		efi.GUID{0x35, 0xb5, 0x06, 0xfc, 0x1f, 0x5e, 0x62, 0x45, 0x9f, 0x25, 0x0a, 0x3b, 0x9a, 0xdb, 0x63, 0xc3}: "EfiIa32X64ErrorTypeTlbCheckGuid",
		efi.GUID{0x35, 0xba, 0xe8, 0xe3, 0x1f, 0x54, 0xf1, 0x4e, 0xbf, 0xb8, 0x75, 0xf0, 0x2a, 0x26, 0xcc, 0x75}: "HybridGraphicsPei",
		efi.GUID{0x35, 0xce, 0x1c, 0x95, 0xd4, 0xa7, 0x05, 0x49, 0x89, 0xfd, 0xfc, 0x9b, 0xc3, 0xb5, 0x6b, 0x83}: "ClientCore",
		efi.GUID{0x35, 0xdd, 0x4d, 0x2f, 0xc0, 0xf8, 0xd2, 0x46, 0xb0, 0xe3, 0xa7, 0x01, 0x36, 0x0d, 0x74, 0x99}: "PcieLaneDXE",
		efi.GUID{0x35, 0xdd, 0x5f, 0xfe, 0xa4, 0xa0, 0x6c, 0x45, 0xaf, 0x66, 0x03, 0x13, 0x7a, 0x55, 0x99, 0xff}: "RaidResourcePei",
		efi.GUID{0x35, 0xe4, 0xb6, 0x63, 0xbc, 0x32, 0xc6, 0x49, 0x81, 0xbd, 0xb7, 0xa1, 0xa0, 0xfe, 0x1a, 0x6c}: "PeiSmbusPolicyPpiGuid",
		efi.GUID{0x35, 0xe7, 0x0b, 0xe2, 0x59, 0xe0, 0xd5, 0x4c, 0xa9, 0x27, 0xff, 0x7d, 0x52, 0x8e, 0xc6, 0x50}: "DescriptorUpdate",
		efi.GUID{0x35, 0xee, 0x60, 0x7b, 0x08, 0xc7, 0x2b, 0x4c, 0x90, 0x94, 0x47, 0x8d, 0xc1, 0x63, 0x35, 0x8f}: "FjSysmanYggdrasilPei",
		efi.GUID{0x35, 0xf1, 0xf5, 0x42, 0x50, 0x3f, 0x19, 0x43, 0x98, 0xa2, 0x3b, 0x22, 0xdf, 0x55, 0x9d, 0x20}: "SmbiosMemory",
		efi.GUID{0x35, 0xf9, 0xfb, 0xfd, 0x6d, 0x65, 0xa7, 0x4e, 0x9d, 0xd3, 0xb7, 0xfb, 0x42, 0x49, 0x7d, 0x78}: "DellSecurityAuditDisplaySmm",
		efi.GUID{0x36, 0x06, 0x2f, 0xbb, 0xdd, 0xb0, 0x9b, 0x48, 0xad, 0xb6, 0x60, 0x6f, 0xe3, 0xa4, 0x72, 0x58}: "CpuHotAdd",
		efi.GUID{0x36, 0x10, 0x81, 0xc3, 0x0b, 0x71, 0x39, 0x4e, 0x8c, 0xf1, 0x0a, 0xf9, 0xbe, 0x3a, 0x81, 0x98}: "TimerDxe",
		efi.GUID{0x36, 0x19, 0x4a, 0x51, 0x6e, 0x2c, 0x7f, 0x43, 0xb0, 0x68, 0x04, 0xcb, 0x15, 0xf5, 0x3a, 0xf9}: "AmdRasRsDxe",
		efi.GUID{0x36, 0x29, 0x21, 0x86, 0x76, 0x0e, 0xc8, 0x41, 0xa0, 0x3a, 0x2a, 0xf2, 0xfc, 0x1c, 0x39, 0xe2}: "EfiRscHandlerProtocolGuid",
		efi.GUID{0x36, 0x29, 0x23, 0x36, 0x76, 0x0e, 0xc8, 0x31, 0xa1, 0x3a, 0x3a, 0xf2, 0xfc, 0x1c, 0x39, 0x32}: "AmiDebuServiceProtocolGuid",
		efi.GUID{0x36, 0x29, 0xcc, 0x96, 0x9b, 0x0e, 0x16, 0x40, 0xb6, 0xa9, 0xbb, 0xcd, 0x35, 0x00, 0xa4, 0xe9}: "OemGigaLanDriverDxe",
		efi.GUID{0x36, 0x2d, 0xcd, 0xc0, 0x1b, 0xa8, 0x0d, 0x45, 0xa5, 0x02, 0x37, 0x67, 0xdf, 0xa2, 0x98, 0x26}: "EfiPlatformTypeNeonCityEprpProtocol",
		efi.GUID{0x36, 0x31, 0x2f, 0x75, 0x16, 0x4e, 0xdc, 0x4f, 0xa2, 0x2a, 0xe5, 0xf4, 0x68, 0x12, 0xf4, 0xca}: "EfiShellParametersProtocolGuid",
		efi.GUID{0x36, 0x34, 0x44, 0xc1, 0x54, 0xb9, 0xba, 0x43, 0x82, 0x78, 0xc1, 0xe4, 0x42, 0xc2, 0x15, 0x39}: "DellFlashWriteProtect",
		efi.GUID{0x36, 0x39, 0x8f, 0x01, 0x40, 0x3a, 0x9d, 0x45, 0x9c, 0x82, 0x3f, 0x1f, 0x78, 0xa9, 0x01, 0x64}: "DellControlVaultDxe",
		efi.GUID{0x36, 0x4a, 0x50, 0x92, 0x7e, 0x24, 0x21, 0x4e, 0xa8, 0x0c, 0x72, 0xfe, 0x49, 0xfa, 0x63, 0x8d}: "BrightnessHardwareVbiosAtiSmm",
		efi.GUID{0x36, 0x4e, 0x87, 0x4f, 0x36, 0x47, 0x2f, 0x33, 0xb7, 0x5a, 0xba, 0x87, 0x53, 0x21, 0x7c, 0xd9}: "SioSmiDispatcher",
		efi.GUID{0x36, 0x55, 0x60, 0x6e, 0x0a, 0xa3, 0x56, 0x4d, 0x93, 0x9e, 0x1c, 0x37, 0x3f, 0x79, 0x8d, 0x7b}: "TcgLockDownVar",
		efi.GUID{0x36, 0x6c, 0x9a, 0xa1, 0x53, 0x70, 0x2c, 0x4e, 0x8b, 0xd0, 0xe8, 0x28, 0x62, 0x30, 0xe4, 0x73}: "PciHostBridgeLibNull",
		efi.GUID{0x36, 0x85, 0x0f, 0xa9, 0xf8, 0x4a, 0xd6, 0x45, 0xb5, 0x8d, 0xd2, 0x25, 0xfd, 0x1c, 0x06, 0xd9}: "FjI2cTouchPanelDxe",
		efi.GUID{0x36, 0x86, 0xc1, 0xd2, 0xe5, 0x40, 0xb5, 0x4e, 0xa3, 0x1b, 0x36, 0x69, 0x5f, 0xd4, 0x2c, 0x87}: "EfiShellEnvironment2ExtGuid",
		efi.GUID{0x36, 0x88, 0x2d, 0x82, 0x77, 0x24, 0x8c, 0x4f, 0x93, 0x30, 0x2f, 0x86, 0x95, 0xeb, 0xe4, 0xf9}: "FjSkylakeRtcBattery",
		efi.GUID{0x36, 0x88, 0x43, 0x87, 0x8d, 0xad, 0x3e, 0x4e, 0x92, 0x49, 0x89, 0x51, 0x20, 0xa6, 0x72, 0x40}: "DebugCommunicationLibUsb",
		efi.GUID{0x36, 0x8a, 0xb4, 0x0d, 0x54, 0x4e, 0x9c, 0xea, 0x9b, 0x09, 0x1e, 0xa5, 0xbe, 0x3a, 0x66, 0x0b}: "EfiRestProtocolGuid",
		efi.GUID{0x36, 0x95, 0x1e, 0x48, 0xd8, 0xa9, 0xd7, 0x4a, 0xb2, 0xbd, 0x27, 0xbd, 0x10, 0xe4, 0x8d, 0x05}: "AmdDashPei",
		efi.GUID{0x36, 0x96, 0xde, 0x0d, 0x21, 0x83, 0xdf, 0x4e, 0x9f, 0x14, 0x0b, 0xfc, 0xa3, 0xb4, 0x73, 0xf5}: "DellIntrusionDetectSmm",
		efi.GUID{0x36, 0xa3, 0xad, 0x89, 0x55, 0x44, 0xe0, 0x11, 0xb7, 0xe6, 0xa8, 0x01, 0xe0, 0xd7, 0x20, 0x85}: "InitResetArch",
		efi.GUID{0x36, 0xa4, 0x34, 0xcc, 0x78, 0xec, 0x30, 0x43, 0x96, 0xcb, 0x1a, 0xd2, 0x21, 0x6c, 0xf8, 0x7b}: "InputmodulesApp",
		efi.GUID{0x36, 0xa9, 0x5d, 0x40, 0x37, 0x37, 0x0b, 0x5b, 0x8e, 0x3f, 0xe6, 0x17, 0x2a, 0x56, 0x85, 0x92}: "RecoverBiosUiDxe",
		efi.GUID{0x36, 0xa9, 0x5d, 0x40, 0x37, 0x37, 0x0c, 0x4c, 0x8e, 0x3f, 0xe6, 0x17, 0x2a, 0x56, 0x85, 0x92}: "FileExplorerDxe",
		efi.GUID{0x36, 0xaa, 0x1b, 0xcc, 0xeb, 0x11, 0xcc, 0x45, 0x9a, 0xdc, 0x75, 0x65, 0xe2, 0x73, 0xac, 0x70}: "PnpSmm",
		efi.GUID{0x36, 0xab, 0x31, 0x08, 0xd0, 0xd5, 0x80, 0x42, 0xbe, 0xd2, 0xa7, 0xe2, 0x7e, 0x9f, 0xef, 0xc9}: "HpSioInitPei",
		efi.GUID{0x36, 0xae, 0x58, 0x0d, 0xaf, 0x31, 0xf3, 0x4c, 0xa7, 0x4d, 0x74, 0x89, 0x1a, 0x15, 0x97, 0xf2}: "AssetIDDxe",
		efi.GUID{0x36, 0xb2, 0x12, 0xce, 0xe5, 0x17, 0xb4, 0x47, 0x96, 0xae, 0xc8, 0x5b, 0xba, 0xc1, 0xe5, 0xbf}: "SmcAssetInfo",
		efi.GUID{0x36, 0xb2, 0x7d, 0x19, 0x56, 0xf8, 0x24, 0x49, 0x90, 0xf8, 0xcd, 0xf1, 0x2f, 0xb8, 0x75, 0xf3}: "Microcode",
		efi.GUID{0x36, 0xbc, 0x0e, 0x4d, 0xd7, 0x88, 0x2c, 0x49, 0xaf, 0x46, 0x67, 0x7b, 0xa2, 0x1f, 0x6d, 0x81}: "SetupConfigUpdateDxeCLX64L",
		efi.GUID{0x36, 0xc1, 0xc5, 0xcc, 0xd3, 0xac, 0x51, 0x42, 0x9b, 0xdc, 0xf6, 0x63, 0xcd, 0x22, 0x97, 0xb7}: "AppleAudioDecoder",
		efi.GUID{0x36, 0xc5, 0x03, 0x2c, 0x94, 0x45, 0x15, 0x45, 0x9e, 0x7a, 0xd3, 0xd2, 0x04, 0xfe, 0x13, 0x63}: "EfiFileExplorerProtocolGuid",
		efi.GUID{0x36, 0xd6, 0x68, 0xa3, 0x77, 0x4c, 0x50, 0x4b, 0xaa, 0xe8, 0xf9, 0x9e, 0x2d, 0xa4, 0x04, 0x40}: "PnpRuntimeDxe",
		efi.GUID{0x36, 0xd7, 0xe5, 0xc2, 0x71, 0x07, 0xac, 0x42, 0xb9, 0x9f, 0x1b, 0x7f, 0x1c, 0xa5, 0x61, 0x0a}: "FileAccessPei",
		efi.GUID{0x36, 0xdc, 0x99, 0x61, 0x14, 0xe1, 0x0d, 0x4e, 0x80, 0x99, 0x99, 0xa0, 0xbd, 0x80, 0xa9, 0x71}: "DxePlatformSgPolicy",
		efi.GUID{0x36, 0xde, 0x00, 0xbc, 0x5c, 0x93, 0x77, 0x45, 0x8d, 0xc5, 0x48, 0x7f, 0x06, 0xb6, 0xdd, 0x12}: "DellSystemUsbPortConfigPei",
		efi.GUID{0x36, 0xde, 0xa6, 0xc9, 0xff, 0xfd, 0xaf, 0x4f, 0x83, 0x43, 0x85, 0xd9, 0xe3, 0x47, 0x0f, 0x43}: "NvmeInt13",
		efi.GUID{0x36, 0xe2, 0xde, 0x5b, 0xb5, 0x0c, 0x86, 0x4d, 0xa6, 0x08, 0xee, 0x7b, 0x0c, 0x5f, 0x29, 0x56}: "LenovoSecureErrorManagerDxe",
		efi.GUID{0x36, 0xe3, 0xbe, 0xcb, 0x82, 0x26, 0xd6, 0x4c, 0x81, 0x8b, 0x0a, 0x0d, 0x96, 0x7e, 0x5a, 0x67}: "EfiClpProtocol",
		efi.GUID{0x36, 0xf1, 0x6d, 0x53, 0x96, 0xbd, 0x1e, 0x4e, 0xad, 0xf5, 0x6b, 0x63, 0x7c, 0x13, 0x90, 0x63}: "UuidDxe",
		efi.GUID{0x36, 0xf4, 0x82, 0xad, 0xc5, 0x75, 0xa9, 0x4a, 0x92, 0x93, 0xc5, 0x55, 0x0a, 0x7f, 0xf9, 0x71}: "EdkiiDebugPrintErrorLevel",
		efi.GUID{0x36, 0xfb, 0x86, 0x6d, 0x90, 0xba, 0x2c, 0x47, 0xb5, 0x83, 0x3f, 0xbe, 0xd3, 0xfb, 0x20, 0x9a}: "FspHobGuid",
		efi.GUID{0x36, 0xfd, 0xf8, 0x20, 0x00, 0x6d, 0xfb, 0x40, 0xb7, 0x04, 0xd1, 0x2c, 0x15, 0x3c, 0x62, 0xeb}: "CcEventEntryHob",
		efi.GUID{0x37, 0x08, 0x61, 0x14, 0x97, 0x4e, 0x27, 0x44, 0x96, 0xe0, 0x21, 0xd9, 0xb2, 0x95, 0x69, 0x96}: "EsalVariableDxeSal",
		efi.GUID{0x37, 0x0a, 0xc2, 0x99, 0x2a, 0x04, 0xe2, 0x46, 0x80, 0xf4, 0xe4, 0x02, 0x7f, 0xdb, 0xc8, 0x6f}: "PlatformSmm",
		efi.GUID{0x37, 0x0e, 0xf3, 0xde, 0xec, 0x7a, 0x69, 0x4f, 0x91, 0xa2, 0xcf, 0x09, 0x9e, 0x27, 0x29, 0xf2}: "PciTableInit",
		efi.GUID{0x37, 0x10, 0xde, 0x8d, 0xe5, 0x94, 0x84, 0x4b, 0x86, 0x11, 0x27, 0x9a, 0x00, 0x4b, 0xa8, 0xf5}: "PspP2Cmbox",
		efi.GUID{0x37, 0x11, 0xe9, 0xd4, 0xf4, 0x43, 0x56, 0x4e, 0xb9, 0x89, 0xd3, 0xd0, 0xe7, 0xb1, 0x69, 0x55}: "InstallHookDxe",
		efi.GUID{0x37, 0x17, 0x84, 0x82, 0xfd, 0x79, 0xc2, 0x4a, 0xa9, 0x48, 0x2e, 0x5c, 0x94, 0xe8, 0x0e, 0x63}: "DashManagementPei",
		efi.GUID{0x37, 0x1d, 0x76, 0x71, 0xb2, 0x32, 0xcd, 0x45, 0xa7, 0xd0, 0xb0, 0xfe, 0xdd, 0x93, 0xe8, 0xcf}: "EfiDirectedIoDMArErrorSectionGuid",
		efi.GUID{0x37, 0x1f, 0xd1, 0xeb, 0x7e, 0x17, 0x16, 0x42, 0xa9, 0x8e, 0x56, 0xc7, 0x7a, 0xdc, 0xea, 0xbe}: "XnoteFlashCommunicationDxe",
		efi.GUID{0x37, 0x22, 0xb7, 0x35, 0x26, 0x39, 0x4a, 0xcf, 0xa7, 0xf3, 0x14, 0x49, 0xf9, 0xe0, 0xe4, 0xbd}: "EmuSimpleFileSystem",
		efi.GUID{0x37, 0x31, 0x81, 0x09, 0xa5, 0xb2, 0x62, 0x44, 0x8a, 0x2a, 0x48, 0xf7, 0x7e, 0xca, 0x31, 0xbf}: "SmbiosDataUpdateDxeExpertWorkStationRP",
		efi.GUID{0x37, 0x39, 0x1a, 0xad, 0x66, 0xa6, 0x2b, 0x4e, 0x9a, 0x35, 0x89, 0x42, 0xa6, 0x09, 0x93, 0x1c}: "PowerFailureRecoveryDxe",
		efi.GUID{0x37, 0x39, 0xff, 0x6d, 0xf2, 0xf9, 0xeb, 0x41, 0xa1, 0xd4, 0x59, 0xd6, 0xe5, 0xd9, 0x64, 0x0a}: "NvmePassThruOverride",
		efi.GUID{0x37, 0x3d, 0x4c, 0x20, 0x3f, 0xd8, 0xab, 0x49, 0x88, 0x3f, 0x9b, 0x5d, 0x6c, 0x64, 0x77, 0x62}: "FspTempRamExitGuid",
		efi.GUID{0x37, 0x42, 0xaa, 0x5d, 0x31, 0x00, 0x0b, 0x4b, 0x96, 0x7c, 0x74, 0x47, 0x71, 0x29, 0xd6, 0xf0}: "H19CheckPointMultiThreaing",
		efi.GUID{0x37, 0x52, 0x22, 0x9d, 0x01, 0xfa, 0x4c, 0x46, 0xa9, 0x49, 0xba, 0xab, 0xc0, 0x2d, 0x31, 0xd0}: "StatusCodeHandlerPei",
		efi.GUID{0x37, 0x54, 0x70, 0x38, 0x97, 0x56, 0x15, 0x47, 0x85, 0xc6, 0x29, 0x93, 0x30, 0x73, 0xc2, 0x12}: "SystemBoardPpi",
		efi.GUID{0x37, 0x5d, 0xb6, 0x9b, 0xa8, 0x8c, 0x89, 0x47, 0xbe, 0x45, 0xee, 0x18, 0x53, 0x6e, 0xe0, 0x89}: "UsbOcUpdateDxeNeonCityEPECB",
		efi.GUID{0x37, 0x69, 0xb7, 0x8b, 0x61, 0xec, 0x48, 0x4e, 0xb3, 0x97, 0x66, 0x67, 0xda, 0x24, 0x34, 0x86}: "FjDtPlatformSetupServicesDxe",
		efi.GUID{0x37, 0x6f, 0xa6, 0x2f, 0x93, 0x8d, 0x23, 0x40, 0xb6, 0xa2, 0xbc, 0x50, 0x49, 0xac, 0xcf, 0x0b}: "DellPasswordPolicySmmProtocol",
		efi.GUID{0x37, 0x7b, 0x19, 0x77, 0xfb, 0xa0, 0x7c, 0x48, 0x9c, 0xdf, 0xfc, 0x36, 0x17, 0x9b, 0x73, 0xde}: "DellStatusCodeHandlerDxe",
		efi.GUID{0x37, 0x82, 0x17, 0x1c, 0x97, 0x68, 0x9e, 0x45, 0x9d, 0x36, 0x67, 0xce, 0x8e, 0xf9, 0x4f, 0x76}: "EfiKmsFormatMd5sha128Guid",
		efi.GUID{0x37, 0x85, 0x9d, 0x8c, 0x79, 0x94, 0xf4, 0x40, 0x8c, 0x82, 0x70, 0xd1, 0xef, 0x5f, 0x73, 0x53}: "UsbOcUpdateDxeLightningRidgeEXECB2",
		efi.GUID{0x37, 0x88, 0xd1, 0x6f, 0xe6, 0x36, 0xec, 0x46, 0x8f, 0x61, 0x67, 0x30, 0xe3, 0xe2, 0x3d, 0x50}: "JhiDxe",
		efi.GUID{0x37, 0x96, 0x13, 0xb7, 0x14, 0xc1, 0x7c, 0x44, 0xb7, 0x3e, 0xcd, 0xbc, 0xd3, 0x07, 0xbe, 0xbb}: "WinCSMDxe",
		efi.GUID{0x37, 0x96, 0x96, 0xb8, 0xde, 0x81, 0xaf, 0x43, 0xbc, 0x9a, 0x24, 0xd9, 0x89, 0x13, 0xf2, 0xf6}: "HandleParsingHiiGuid",
		efi.GUID{0x37, 0x9e, 0x49, 0x30, 0x01, 0xfc, 0xd6, 0x4d, 0x8e, 0x07, 0x2e, 0x38, 0x53, 0xde, 0xbe, 0x60}: "AmdLegacyInterrupt",
		efi.GUID{0x37, 0xa5, 0xce, 0xe0, 0xb0, 0xfd, 0x30, 0x4d, 0x8c, 0x1c, 0x9b, 0x03, 0x59, 0xa4, 0x59, 0x8f}: "FjNuvotonNct5581Pei",
		efi.GUID{0x37, 0xa6, 0x11, 0x67, 0x2b, 0x2c, 0xea, 0x48, 0xbd, 0x29, 0x88, 0xe8, 0xa2, 0xf8, 0x0b, 0x93}: "DellFingerPrintReader",
		efi.GUID{0x37, 0xad, 0x24, 0xd8, 0xb9, 0x7a, 0x17, 0x48, 0xbd, 0x53, 0xdb, 0xab, 0x77, 0x9a, 0x3c, 0x83}: "DellAdvSysMgmtConfigSmm",
		efi.GUID{0x37, 0xad, 0x29, 0xb1, 0x38, 0x3f, 0x4b, 0x44, 0xe4, 0x25, 0x9a, 0xa9, 0x91, 0xa8, 0x18, 0x93}: "HpOsToUefiInterface",
		efi.GUID{0x37, 0xaf, 0x96, 0x82, 0x83, 0xd1, 0x16, 0x44, 0xb3, 0xb6, 0x19, 0xd2, 0xa8, 0x0a, 0xd4, 0xa8}: "EbcDebugger",
		efi.GUID{0x37, 0xb6, 0x86, 0x27, 0x93, 0x5e, 0x57, 0x4e, 0xb1, 0xd4, 0xb6, 0x9d, 0x8d, 0x49, 0x65, 0x80}: "FjSysmanTeutatesSmmFjFextBin",
		efi.GUID{0x37, 0xb7, 0xa3, 0xc9, 0x41, 0x88, 0x9e, 0x49, 0x81, 0x4c, 0x46, 0x30, 0x54, 0xc7, 0xc7, 0xa3}: "FjPowerOverEthernet",
		efi.GUID{0x37, 0xb9, 0x30, 0xa6, 0xb3, 0x3a, 0x63, 0x42, 0x85, 0xb1, 0xa6, 0x3e, 0x98, 0xf2, 0x99, 0x49}: "PcieErrorHandler",
		efi.GUID{0x37, 0xc5, 0x14, 0x87, 0x4b, 0x6d, 0x47, 0x42, 0xaa, 0x6c, 0x29, 0xe8, 0x49, 0x5f, 0x91, 0x00}: "FspNotifyDxe",
		efi.GUID{0x37, 0xcf, 0x25, 0xe4, 0x5b, 0xe5, 0xd7, 0x43, 0xb2, 0xc6, 0xcd, 0xb9, 0xee, 0x8d, 0x25, 0xa5}: "RasClvRankSparingProtocol",
		efi.GUID{0x37, 0xda, 0xc9, 0x2e, 0x35, 0xee, 0xe9, 0x4d, 0x86, 0xc5, 0x6d, 0x9a, 0x81, 0xdc, 0x38, 0xa7}: "AmdSevDxe",
		efi.GUID{0x37, 0xdb, 0x13, 0x67, 0xc7, 0x20, 0x23, 0x4e, 0xbd, 0x42, 0xc5, 0xb3, 0x00, 0xa6, 0xae, 0x32}: "SmmPBDispatch2OnSmmPBDispatchThunk",
		efi.GUID{0x37, 0xdc, 0x05, 0xbc, 0xa0, 0x9d, 0x50, 0x40, 0x97, 0x28, 0xf3, 0x4d, 0xdb, 0x01, 0xe2, 0x00}: "BiosRegionLockEntry",
		efi.GUID{0x37, 0xdc, 0x05, 0xbc, 0xa0, 0x9d, 0x50, 0x40, 0x97, 0x28, 0xf3, 0x4d, 0xdb, 0x01, 0xe3, 0x01}: "SpiLockSmi",
		efi.GUID{0x37, 0xe1, 0xc7, 0x5e, 0xe2, 0x3f, 0x1e, 0x44, 0xa3, 0x36, 0xf6, 0x57, 0x26, 0x87, 0x33, 0xa6}: "DeviceBlacklist",
		efi.GUID{0x37, 0xe3, 0x7b, 0xba, 0xfb, 0x6c, 0xbb, 0x4d, 0xb2, 0x6c, 0x21, 0xec, 0x2f, 0xc1, 0x60, 0x73}: "SecCore",
		efi.GUID{0x37, 0xe5, 0x2d, 0xed, 0x23, 0x78, 0xb1, 0x4c, 0xb6, 0x87, 0x85, 0xba, 0x9b, 0xbe, 0xf0, 0xb4}: "RaidRom",
		efi.GUID{0x37, 0xec, 0xac, 0x0c, 0x9b, 0xb7, 0x78, 0x4a, 0xb3, 0xc5, 0xea, 0x61, 0xea, 0xf6, 0x98, 0x0d}: "BiosInitToFactorySupport",
		efi.GUID{0x37, 0xef, 0xde, 0x89, 0xd8, 0x31, 0x9c, 0x46, 0x95, 0xb6, 0x01, 0x69, 0xbc, 0x86, 0x6c, 0xfb}: "EfiIpProtocol",
		efi.GUID{0x37, 0xf0, 0x86, 0x8c, 0xe9, 0x50, 0xfb, 0x4c, 0x9d, 0xdb, 0x90, 0x3f, 0x08, 0x4f, 0x3a, 0x40}: "FjIbvNvramGateReferenceDxe",
		efi.GUID{0x37, 0xf7, 0x01, 0x15, 0x6d, 0xc5, 0x21, 0x47, 0x98, 0x8f, 0x74, 0x37, 0xf3, 0xd2, 0x2f, 0xd9}: "H19SmmReadyToLockHook",
		efi.GUID{0x37, 0xf9, 0x3f, 0xca, 0x46, 0xd6, 0x36, 0x49, 0x90, 0xe8, 0x1b, 0x95, 0x06, 0x49, 0xb3, 0x89}: "EfiSocketPciResourceData",
		efi.GUID{0x37, 0xfb, 0xa6, 0x78, 0x27, 0x8f, 0xa4, 0x40, 0x9c, 0x4e, 0x9f, 0xc9, 0xe4, 0x38, 0xd5, 0xe2}: "AmiTseOemPortingVar8",
		efi.GUID{0x38, 0x05, 0x92, 0xa9, 0xa4, 0x40, 0x35, 0x43, 0x9d, 0x71, 0x1e, 0xf5, 0x46, 0xae, 0xfb, 0x27}: "DellSfpPei",
		efi.GUID{0x38, 0x13, 0x8d, 0xf3, 0x7a, 0xaf, 0xb6, 0x4f, 0x91, 0xdb, 0x1a, 0x9c, 0x21, 0x83, 0x57, 0x0d}: "WdtPpi",
		efi.GUID{0x38, 0x17, 0x66, 0x68, 0x0d, 0xd7, 0xa1, 0x4b, 0xbf, 0xce, 0x7d, 0xba, 0xbe, 0x14, 0xfb, 0x9c}: "FileExplorer",
		efi.GUID{0x38, 0x18, 0xfd, 0x96, 0x96, 0x44, 0xe7, 0x4a, 0xbe, 0x7c, 0x85, 0x15, 0x29, 0x6b, 0xfb, 0xed}: "HpDiagnosticsPortingSetupConfigSmm",
		efi.GUID{0x38, 0x1e, 0x0b, 0x97, 0x01, 0x97, 0xaa, 0x47, 0x88, 0xa5, 0x56, 0x6a, 0x9f, 0x23, 0x22, 0x64}: "AcerGnvsSmm",
		efi.GUID{0x38, 0x29, 0x31, 0xe9, 0x6b, 0xe5, 0x14, 0x46, 0xa2, 0x52, 0xcf, 0x7d, 0x2f, 0x37, 0x7e, 0x26}: "AmiTcgPlatformPeiBeforeMem",
		efi.GUID{0x38, 0x2f, 0x16, 0xf7, 0x88, 0x60, 0x42, 0x48, 0xb0, 0xed, 0xc1, 0x43, 0xda, 0xd3, 0x9e, 0xfb}: "PTUpdatePCD",
		efi.GUID{0x38, 0x36, 0xf9, 0xb9, 0xf5, 0x35, 0x7d, 0x44, 0xb9, 0x08, 0xa2, 0xb8, 0x52, 0xaa, 0x0b, 0x89}: "LenovoSmbiosTcgDxe",
		efi.GUID{0x38, 0x40, 0xbf, 0x36, 0x02, 0xc9, 0x8e, 0x42, 0x96, 0xeb, 0xdf, 0xe3, 0xb4, 0x68, 0x16, 0x7f}: "FchSmbusDxe",
		efi.GUID{0x38, 0x46, 0xb5, 0xa9, 0x79, 0x4f, 0x69, 0x43, 0xbc, 0xa3, 0x44, 0xb2, 0xb5, 0x93, 0xac, 0xb8}: "OemSmi",
		efi.GUID{0x38, 0x47, 0xa7, 0xe2, 0x34, 0x89, 0xf5, 0x48, 0x84, 0x12, 0x99, 0xe9, 0x48, 0xc8, 0xdc, 0x1b}: "SmbiosDmiEdit",
		efi.GUID{0x38, 0x56, 0x93, 0xe8, 0x37, 0x74, 0xbc, 0x46, 0xad, 0xb5, 0x31, 0x53, 0x82, 0x0f, 0xd6, 0xce}: "RTKUndiDxe",
		efi.GUID{0x38, 0x6d, 0xa7, 0x7e, 0x7a, 0xc5, 0x2d, 0x41, 0xaf, 0x1d, 0xd5, 0x8b, 0xee, 0x2b, 0x85, 0xb1}: "LenovoVproPetAlert",
		efi.GUID{0x38, 0x70, 0x84, 0xc5, 0x75, 0xff, 0x74, 0x40, 0x9e, 0x4c, 0xc3, 0x6a, 0x2e, 0xb3, 0x98, 0xa5}: "LibTime",
		efi.GUID{0x38, 0x81, 0xda, 0x4d, 0xcd, 0x47, 0x19, 0x40, 0x91, 0x78, 0x11, 0x50, 0x03, 0x43, 0x1b, 0x21}: "SWSMI_Shadow",
		efi.GUID{0x38, 0x88, 0xa8, 0xd4, 0xf4, 0xeb, 0xd7, 0x48, 0x9d, 0x97, 0xce, 0x67, 0x89, 0xfd, 0xe0, 0xb7}: "CryptoPkgTest",
		efi.GUID{0x38, 0x8d, 0x14, 0x71, 0x25, 0x59, 0x21, 0x40, 0x91, 0xab, 0xcb, 0x25, 0x2a, 0xf7, 0x45, 0x31}: "AcerPDDockPXE",
		efi.GUID{0x38, 0x9d, 0x18, 0xbe, 0x63, 0xc9, 0xcf, 0x41, 0xb6, 0x95, 0xd9, 0x0e, 0x9e, 0x54, 0x5a, 0x13}: "UfsBlockIoPei",
		efi.GUID{0x38, 0x9d, 0x83, 0x79, 0x05, 0xdd, 0x9c, 0x48, 0xb3, 0xef, 0xf2, 0x7b, 0xda, 0x08, 0xe5, 0x72}: "AmiAgesaSxSmi",
		efi.GUID{0x38, 0x9e, 0xfd, 0xa7, 0x05, 0xc0, 0xad, 0x45, 0x8b, 0x65, 0xf1, 0x3c, 0xf6, 0xa1, 0xfd, 0x79}: "AmdUnbXvPei",
		efi.GUID{0x38, 0xa2, 0x3f, 0x91, 0x16, 0x7b, 0x72, 0x4b, 0xa5, 0xf0, 0x81, 0x5e, 0x7d, 0x2c, 0x8c, 0x1f}: "AmiTseOemPortingVar24",
		efi.GUID{0x38, 0xa3, 0x64, 0xe3, 0x42, 0x28, 0x57, 0x4f, 0xa7, 0xc7, 0xcd, 0xc8, 0xcf, 0xdf, 0x6c, 0xd7}: "AppleEvent",
		efi.GUID{0x38, 0xa9, 0x3d, 0xce, 0xd6, 0x6a, 0x8a, 0x45, 0x88, 0x31, 0x6b, 0x0a, 0x03, 0xdf, 0x6c, 0x86}: "Pentium4Base",
		efi.GUID{0x38, 0xa9, 0xa7, 0x36, 0x62, 0x3e, 0xd6, 0x47, 0xb3, 0x95, 0x3d, 0x3f, 0xe1, 0x35, 0xf3, 0xd1}: "OneTimeFlagPeiInit",
		efi.GUID{0x38, 0xab, 0x7d, 0xb2, 0x14, 0x98, 0x06, 0x4e, 0xa5, 0xa2, 0x65, 0xae, 0x9a, 0x14, 0x25, 0x8f}: "AmiIntSmmCommProtocol",
		efi.GUID{0x38, 0xb9, 0x5e, 0x9d, 0x44, 0x9a, 0x68, 0x45, 0x81, 0x92, 0xc1, 0x56, 0x3b, 0xeb, 0xaa, 0x01}: "LenovoIsscDxe",
		efi.GUID{0x38, 0xbc, 0xe8, 0x8c, 0x5d, 0x80, 0x2d, 0x44, 0x8d, 0xb0, 0x47, 0x92, 0x75, 0xcb, 0x1b, 0xf2}: "SystemErrorLogDxe",
		efi.GUID{0x38, 0xbe, 0xf9, 0x7b, 0x8d, 0x9b, 0x62, 0x4d, 0xad, 0x06, 0x68, 0x05, 0xbe, 0xed, 0x98, 0x52}: "FjFlexIoDetectionViaI2C",
		efi.GUID{0x38, 0xc7, 0x30, 0x6b, 0x91, 0xa3, 0xd4, 0x11, 0x9a, 0x3b, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d}: "EfiPlatformDriverOverrideProtocolGuid",
		efi.GUID{0x38, 0xca, 0x02, 0x44, 0x8f, 0x80, 0x79, 0x42, 0xbc, 0xec, 0x5b, 0xaf, 0x8d, 0x59, 0x09, 0x2f}: "EfiSocketCommonRcVariable",
		efi.GUID{0x38, 0xd8, 0x81, 0x7f, 0x1d, 0xf9, 0x44, 0x4c, 0x85, 0x52, 0x8f, 0xb9, 0x12, 0x12, 0x2f, 0xdd}: "GopDxe",
		efi.GUID{0x38, 0xd9, 0xe4, 0x9c, 0x87, 0x9c, 0xd0, 0x41, 0x9e, 0x55, 0x34, 0x92, 0x3f, 0xaf, 0x8b, 0x4f}: "AmiPeiNbInitPolicyGuid",
		efi.GUID{0x38, 0xdd, 0x3e, 0xb1, 0x4c, 0x68, 0xed, 0x41, 0xa3, 0x05, 0xd7, 0xb7, 0xe3, 0x24, 0x97, 0xdf}: "Smbios",
		efi.GUID{0x38, 0xe4, 0xba, 0x14, 0x05, 0x5c, 0x3e, 0x48, 0xaf, 0xdb, 0xd8, 0x83, 0x25, 0xcc, 0x0e, 0x93}: "DellKeyManagementServiceSmm",
		efi.GUID{0x38, 0xef, 0x3d, 0x6a, 0x45, 0x0a, 0x07, 0x41, 0xa7, 0x4e, 0xab, 0xf2, 0xb8, 0xea, 0xed, 0x86}: "MemorySubClass",
		efi.GUID{0x38, 0xf0, 0x95, 0xf4, 0xe6, 0x71, 0xdb, 0x49, 0x9a, 0x80, 0xb2, 0xe9, 0x8f, 0x7b, 0xa7, 0x18}: "PeiDbgModuleLocator",
		efi.GUID{0x38, 0xf8, 0x0c, 0xa8, 0x8e, 0x83, 0x39, 0x47, 0xb4, 0x9e, 0xd9, 0x7d, 0x20, 0xdd, 0xe9, 0x8f}: "GpioControlPei",
		efi.GUID{0x38, 0xfa, 0x11, 0xc8, 0xc8, 0x42, 0x79, 0x45, 0xa9, 0xbb, 0x60, 0xe9, 0x4e, 0xdd, 0xfb, 0x34}: "AmiTseSetupGuid",
		efi.GUID{0x38, 0xfb, 0x82, 0xc1, 0xe4, 0x0f, 0xec, 0x4b, 0x92, 0x70, 0xa2, 0x73, 0xe1, 0xef, 0x2c, 0x80}: "AmdXgbeWorkaroundDxe",
		efi.GUID{0x38, 0xfd, 0x73, 0x83, 0x8b, 0xd9, 0x8a, 0x4c, 0x85, 0x1e, 0x2e, 0x93, 0x96, 0x74, 0x8a, 0xf3}: "TxeFwDowngradeDxe",
		efi.GUID{0x39, 0x03, 0x44, 0x94, 0x93, 0xcc, 0x06, 0x45, 0xb4, 0xc6, 0xee, 0x8d, 0x0f, 0x4c, 0xa1, 0x91}: "EdkiiNonDiscoverableAmbaDeviceGuid",
		efi.GUID{0x39, 0x03, 0x71, 0xd5, 0x67, 0xa4, 0x76, 0x4f, 0xb0, 0x53, 0x4f, 0x14, 0xc2, 0xf5, 0xc9, 0x99}: "FjDtPlatformDiagnosticsDxe",
		efi.GUID{0x39, 0x1f, 0x9e, 0x09, 0x02, 0x01, 0xc3, 0x43, 0x8c, 0xec, 0x8e, 0x89, 0x7b, 0x65, 0x62, 0xf7}: "EventLogSmm",
		efi.GUID{0x39, 0x30, 0xf5, 0x0e, 0x38, 0x3a, 0xd1, 0x42, 0xbc, 0xec, 0xce, 0x96, 0x6e, 0x87, 0x06, 0x1a}: "PeiFrb",
		efi.GUID{0x39, 0x35, 0xdd, 0x87, 0x67, 0x06, 0xb7, 0x4b, 0x9f, 0xb2, 0x47, 0xd3, 0xc5, 0x0b, 0x02, 0x1b}: "PhoenixDesktopMessageProtocolGuid",
		efi.GUID{0x39, 0x39, 0xe3, 0x92, 0x33, 0xa1, 0x30, 0x4c, 0x6e, 0x13, 0x11, 0x65, 0xda, 0x59, 0xa8, 0xa4}: "DeviceBlacklistDefaultsSmm",
		efi.GUID{0x39, 0x3b, 0xdd, 0x83, 0xaf, 0x7c, 0xac, 0x4f, 0xa5, 0x42, 0xe0, 0x50, 0xb7, 0x67, 0xe3, 0xa7}: "VirtioPciDeviceDxe",
		efi.GUID{0x39, 0x3b, 0xf2, 0xc8, 0x5c, 0xc9, 0x18, 0x43, 0x92, 0x33, 0x53, 0xfb, 0x3a, 0xc4, 0x45, 0x92}: "VariableVsr",
		efi.GUID{0x39, 0x46, 0x14, 0x57, 0xd1, 0x7b, 0x72, 0x4e, 0xb9, 0x7b, 0xd8, 0xa8, 0xc3, 0xae, 0x2a, 0x9e}: "PlatformFlashSmm",
		efi.GUID{0x39, 0x48, 0x7b, 0x14, 0xbe, 0x5d, 0x3f, 0x41, 0x91, 0x7f, 0xdf, 0xeb, 0x68, 0x7c, 0x63, 0x12}: "PchResetPeim",
		efi.GUID{0x39, 0x5b, 0x21, 0x0c, 0x5d, 0x42, 0xe0, 0x42, 0xa1, 0xb4, 0x36, 0x7d, 0x57, 0x49, 0x56, 0xec}: "FjDmiSystemData",
		efi.GUID{0x39, 0x60, 0xef, 0x98, 0x0b, 0x13, 0x84, 0x47, 0x91, 0x25, 0xb7, 0x23, 0x12, 0x8f, 0x16, 0x39}: "FjNuvotonNct5581Dxe",
		efi.GUID{0x39, 0x61, 0x05, 0x67, 0x96, 0xce, 0x88, 0x46, 0xb7, 0xe7, 0x73, 0x80, 0x3e, 0xa5, 0x28, 0xfa}: "ConfigChangePromptDxe",
		efi.GUID{0x39, 0x62, 0x27, 0xcc, 0xe5, 0xd6, 0xd4, 0x41, 0xac, 0x30, 0x36, 0x79, 0x4e, 0x52, 0xb9, 0x8b}: "FujInSmm",
		efi.GUID{0x39, 0x64, 0xf3, 0xa5, 0x52, 0xbd, 0xfb, 0x49, 0xb1, 0x58, 0x7f, 0x66, 0x88, 0x95, 0x2b, 0xea}: "OemSpecialLogoSupport",
		efi.GUID{0x39, 0x6a, 0xc8, 0x50, 0x94, 0xc1, 0x03, 0x4b, 0x8b, 0x4e, 0x22, 0xce, 0x46, 0x3b, 0xb2, 0xa0}: "DellSmmDiagLeds",
		efi.GUID{0x39, 0x72, 0x59, 0x22, 0x07, 0x61, 0x44, 0xdf, 0xad, 0x3f, 0x5f, 0x05, 0x3e, 0x92, 0x22, 0x2e}: "EmuSnpDxe",
		efi.GUID{0x39, 0x77, 0x7f, 0x3d, 0x84, 0xa0, 0xa9, 0x4f, 0x9a, 0x83, 0x6b, 0x4b, 0x0e, 0x2c, 0xd6, 0x38}: "SATADxeConfiguration",
		efi.GUID{0x39, 0x89, 0xa4, 0x30, 0xf9, 0xc8, 0x18, 0x40, 0xbe, 0xd7, 0x9f, 0x92, 0x28, 0xf1, 0x67, 0x81}: "BatteryHealthControlDxe",
		efi.GUID{0x39, 0x8a, 0xa8, 0x28, 0x84, 0xdd, 0x3f, 0x48, 0x9b, 0xef, 0xba, 0x11, 0x68, 0xc2, 0xf8, 0x50}: "UbaInitPei",
		efi.GUID{0x39, 0x8d, 0x14, 0x11, 0x26, 0x59, 0x22, 0x40, 0x91, 0xac, 0xcb, 0x25, 0x2a, 0xf7, 0x45, 0x30}: "Usb_Lan_RT8152B",
		efi.GUID{0x39, 0x8d, 0x14, 0x71, 0x26, 0x59, 0x22, 0x40, 0x91, 0xac, 0xcb, 0x25, 0x2a, 0xf7, 0x45, 0x30}: "AsusEzFlash",
		efi.GUID{0x39, 0x8d, 0x14, 0x71, 0x26, 0x59, 0x22, 0x40, 0x91, 0xac, 0xcb, 0x25, 0x2a, 0xf7, 0x45, 0x32}: "AcerDockIIPXE",
		efi.GUID{0x39, 0x91, 0x09, 0x66, 0x1f, 0xc9, 0xd5, 0x4d, 0x88, 0xec, 0x57, 0x07, 0xde, 0x68, 0x81, 0xa4}: "HpFBCacheDxe",
		efi.GUID{0x39, 0x9b, 0xcf, 0x6e, 0xd7, 0x9d, 0x75, 0x41, 0xb6, 0x57, 0xca, 0xb9, 0x43, 0x75, 0x98, 0xde}: "AlwaysPublishInt13ForCdrom",
		efi.GUID{0x39, 0x9c, 0x03, 0xf1, 0x99, 0x92, 0xfe, 0x41, 0x87, 0x99, 0x5e, 0xaf, 0xb6, 0x68, 0xee, 0x6c}: "AmdRasRnApeiDxe",
		efi.GUID{0x39, 0xa1, 0x50, 0xb8, 0xbb, 0xba, 0x91, 0x4d, 0x9f, 0x27, 0x72, 0xd2, 0xef, 0x01, 0xbf, 0x3a}: "VbtMipiJdiGuid",
		efi.GUID{0x39, 0xa7, 0x5c, 0xe4, 0xa3, 0x88, 0xe7, 0x48, 0x87, 0xe0, 0x9f, 0xbe, 0x6c, 0x38, 0x30, 0x59}: "AmiSMMUserCredServices",
		efi.GUID{0x39, 0xab, 0x56, 0xa3, 0xc4, 0x35, 0xda, 0x35, 0xb3, 0x7a, 0xf8, 0xea, 0x9e, 0x8b, 0x36, 0xa3}: "EfiStatusCodeDataTypeProgressCode",
		efi.GUID{0x39, 0xb3, 0x24, 0x95, 0x02, 0x57, 0x07, 0x4d, 0x87, 0xe3, 0x47, 0xab, 0xa1, 0x0e, 0x0c, 0x1e}: "SmbiosMemory",
		efi.GUID{0x39, 0xba, 0x5e, 0xb4, 0x3e, 0xd5, 0x94, 0x4a, 0xa8, 0x39, 0xd5, 0x01, 0x63, 0x3a, 0x59, 0x18}: "SystemNvmeAspiLegacySmm",
		efi.GUID{0x39, 0xbd, 0x32, 0x07, 0xb0, 0xd6, 0x39, 0x40, 0xb6, 0xc2, 0x96, 0x54, 0x46, 0x6d, 0xe5, 0x25}: "MeudError",
		efi.GUID{0x39, 0xc3, 0x46, 0xcf, 0x51, 0x06, 0x7a, 0x40, 0x8e, 0x85, 0xd0, 0xd7, 0x27, 0x31, 0xcc, 0xd5}: "RequestPOPOnReset",
		efi.GUID{0x39, 0xd8, 0xa1, 0x20, 0x3d, 0x85, 0x67, 0x40, 0xb6, 0x9c, 0x55, 0x2a, 0x0d, 0x05, 0xc1, 0xaa}: "DellFormBrowser",
		efi.GUID{0x39, 0xdc, 0x0b, 0x32, 0xa0, 0x3f, 0xa9, 0x4b, 0xbf, 0x2d, 0xb3, 0x3f, 0x72, 0xba, 0x9c, 0xa1}: "AmiTpmSupportTypeProtocolguid",
		efi.GUID{0x39, 0xdf, 0x94, 0xb4, 0xf8, 0xa5, 0xa1, 0x48, 0xb2, 0xd0, 0xef, 0x52, 0x3a, 0xd9, 0x1c, 0x55}: "PeiPolicyInit",
		efi.GUID{0x39, 0xe7, 0x65, 0x10, 0xc2, 0x23, 0x3f, 0x49, 0xb1, 0xad, 0xdc, 0x6d, 0x8d, 0xf7, 0x7c, 0xf4}: "HpGenSwSmi",
		efi.GUID{0x39, 0xe9, 0xb5, 0x60, 0xcf, 0x0f, 0x27, 0x42, 0xba, 0x83, 0x6b, 0xbe, 0xd4, 0x5b, 0xc0, 0xe3}: "EfiBootStateGuid",
		efi.GUID{0x39, 0xed, 0x34, 0xd4, 0xdd, 0x8e, 0xf8, 0x4f, 0x91, 0xbf, 0x4b, 0x11, 0xaf, 0xe8, 0x54, 0x71}: "SwapAddressRangeDxe",
		efi.GUID{0x39, 0xed, 0xd6, 0x30, 0xbd, 0x28, 0x0c, 0x4c, 0xa7, 0x99, 0x63, 0x05, 0xa4, 0xfe, 0x8a, 0x6a}: "WatchDogTableDxe",
		efi.GUID{0x3a, 0x01, 0xc9, 0x0f, 0x68, 0x05, 0xa9, 0x4b, 0x9b, 0x7e, 0xc9, 0xc3, 0x90, 0xa6, 0x60, 0x9b}: "EfiLegacyRegionProtocolGuid",
		efi.GUID{0x3a, 0x09, 0x6b, 0x34, 0x02, 0x90, 0x99, 0x4e, 0xa2, 0xf2, 0x27, 0xa1, 0x6c, 0x3d, 0xcd, 0x89}: "OemModifyOpRegion",
		efi.GUID{0x3a, 0x0c, 0x8a, 0x9b, 0x86, 0x51, 0x55, 0x4b, 0x89, 0xf4, 0xca, 0xfd, 0xe6, 0x13, 0xda, 0xb1}: "BootScriptHidePei",
		efi.GUID{0x3a, 0x0d, 0xc5, 0xf1, 0xe4, 0x58, 0x04, 0x41, 0x91, 0x76, 0x00, 0xcd, 0xf8, 0xbc, 0x4b, 0xb2}: "H2ODisplayEngineLocalTextDxe",
		efi.GUID{0x3a, 0x19, 0x7b, 0xc2, 0x76, 0xd0, 0xc6, 0x4a, 0x8d, 0xa1, 0x7a, 0xc6, 0x7b, 0x4a, 0xca, 0x06}: "ProjectPei",
		efi.GUID{0x3a, 0x1a, 0x7e, 0x8f, 0x57, 0x96, 0xf0, 0x44, 0xb9, 0xe6, 0x4e, 0xf7, 0x4b, 0x22, 0xd5, 0x43}: "EfiTraceHubDebugLibX64",
		efi.GUID{0x3a, 0x22, 0x96, 0xb7, 0x76, 0x37, 0x10, 0x40, 0xba, 0xbd, 0x7e, 0x13, 0x8f, 0x91, 0x67, 0xfc}: "PlatformSecureUpdatePei",
		efi.GUID{0x3a, 0x39, 0x51, 0x0e, 0x65, 0xe8, 0x3e, 0x4c, 0x8c, 0x5f, 0x44, 0x2f, 0xe0, 0x91, 0x46, 0xa5}: "DellSmmVariableProtocol",
		efi.GUID{0x3a, 0x3f, 0xc8, 0x74, 0xe3, 0x5e, 0xb7, 0x4e, 0xb9, 0x45, 0x70, 0x2b, 0x83, 0x9f, 0xb1, 0xa6}: "DxePlatform",
		efi.GUID{0x3a, 0x41, 0x15, 0xd8, 0x6d, 0xd9, 0xa6, 0x40, 0x9f, 0x9f, 0x88, 0xe0, 0x9e, 0x36, 0xfa, 0x49}: "PsdsAcpiDxe",
		efi.GUID{0x3a, 0x42, 0x48, 0x35, 0x2c, 0x2b, 0x93, 0x43, 0x98, 0x26, 0xb2, 0x02, 0x95, 0x9d, 0x23, 0x62}: "AbtCryptoDriver",
		efi.GUID{0x3a, 0x47, 0x4d, 0x19, 0xf6, 0x01, 0xae, 0x48, 0x94, 0x29, 0xfd, 0x39, 0x58, 0x13, 0xbe, 0x47}: "AdlinkNxpPei",
		efi.GUID{0x3a, 0x4b, 0x2b, 0xb7, 0xe2, 0x1b, 0xbb, 0x44, 0x9e, 0xdb, 0xb6, 0x21, 0x5f, 0x11, 0x36, 0x82}: "FjIfSecureBootAndRaid",
		efi.GUID{0x3a, 0x53, 0x6c, 0x16, 0x1e, 0x8f, 0x34, 0x4d, 0xa6, 0x0e, 0x0f, 0x68, 0xd8, 0xd6, 0x13, 0x08}: "OemKey",
		efi.GUID{0x3a, 0x56, 0x61, 0xb4, 0xa3, 0xcb, 0x96, 0x43, 0x90, 0x51, 0x7f, 0x8b, 0x10, 0x9f, 0x60, 0xc5}: "AsusDxeSmmNvram",
		efi.GUID{0x3a, 0x58, 0x20, 0x4d, 0x65, 0x77, 0x7a, 0x4e, 0x8a, 0x67, 0xdc, 0xde, 0x74, 0xee, 0x3e, 0xc5}: "HttpBootConfigGuid",
		efi.GUID{0x3a, 0x59, 0x69, 0x03, 0x9b, 0xba, 0x7d, 0x45, 0xb4, 0x6f, 0x31, 0xd8, 0x3a, 0x96, 0xd6, 0xfe}: "DehSmmProtocolVer3",
		efi.GUID{0x3a, 0x5a, 0x4d, 0x82, 0x92, 0xaf, 0x0c, 0x4c, 0x9f, 0x19, 0x19, 0x52, 0x6d, 0xca, 0x4a, 0xbb}: "FspmArchConfigPpi",
		efi.GUID{0x3a, 0x5e, 0xaf, 0x3e, 0xb2, 0xe4, 0xe6, 0x48, 0xa9, 0xf1, 0xb7, 0x5c, 0xf2, 0x04, 0xbc, 0xc8}: "PeiBoardConfigInit",
		efi.GUID{0x3a, 0x61, 0x6c, 0xdd, 0x77, 0x5a, 0x4f, 0x4b, 0xa6, 0x1e, 0x3b, 0xdd, 0x2a, 0xe2, 0x1d, 0x81}: "PerfTuneProtocol",
		efi.GUID{0x3a, 0x62, 0xdf, 0x0d, 0x60, 0x9f, 0xf2, 0x4a, 0xb5, 0xc7, 0xef, 0xe4, 0xa6, 0x37, 0x29, 0x0e}: "FjDtDiagnosticsDxe",
		efi.GUID{0x3a, 0x66, 0x0e, 0x3d, 0x72, 0xdc, 0x89, 0x44, 0x87, 0xc5, 0xe4, 0x9e, 0xe7, 0x73, 0xa4, 0x52}: "IffsPpi",
		efi.GUID{0x3a, 0x69, 0x99, 0x8a, 0x2d, 0xf4, 0x2b, 0x44, 0xb3, 0x69, 0xdd, 0xd6, 0x78, 0x0d, 0xa7, 0x10}: "PlatformHstiSetupDxe",
		efi.GUID{0x3a, 0x6a, 0x09, 0x40, 0x2a, 0x5c, 0xbc, 0x4f, 0xae, 0xf7, 0x54, 0x75, 0xdd, 0x7a, 0xb3, 0x34}: "BasePcdLibNull",
		efi.GUID{0x3a, 0x72, 0x1d, 0x02, 0x1c, 0x50, 0x1e, 0x4d, 0xb7, 0x92, 0x0d, 0x3c, 0x46, 0x51, 0xb8, 0x48}: "OemWwanSmm",
		efi.GUID{0x3a, 0x73, 0xad, 0x07, 0xdb, 0x0d, 0x44, 0x42, 0xbd, 0x82, 0x07, 0x1f, 0x39, 0xe2, 0xa4, 0x20}: "PlatformSmm",
		efi.GUID{0x3a, 0x74, 0xa9, 0x2e, 0xd9, 0x23, 0x5e, 0x42, 0x87, 0x2c, 0xf6, 0x15, 0xaa, 0x19, 0x57, 0x88}: "AppleRemovableMediaProtocol",
		efi.GUID{0x3a, 0x79, 0xca, 0x0d, 0x96, 0xea, 0xd8, 0x42, 0xbd, 0x7b, 0xdc, 0x7f, 0x68, 0x4e, 0x38, 0xc1}: "LegacyRomLayout",
		efi.GUID{0x3a, 0x89, 0xed, 0x76, 0xf9, 0xb2, 0x7d, 0x4c, 0xa0, 0x5f, 0x1e, 0xa1, 0x70, 0xec, 0xf6, 0xcd}: "IntelGraphicsPeim",
		efi.GUID{0x3a, 0x8d, 0xf9, 0x0e, 0x33, 0x3e, 0x7a, 0x49, 0xa4, 0x01, 0x77, 0xbe, 0x3e, 0xb7, 0x4f, 0x38}: "EfiAcpiS3ContextGuid",
		efi.GUID{0x3a, 0x93, 0x2d, 0xa6, 0x93, 0x92, 0x9f, 0x4d, 0x9a, 0x16, 0xce, 0x81, 0x99, 0x4c, 0xc4, 0xf2}: "AppleDebugSupport",
		efi.GUID{0x3a, 0x93, 0xd7, 0xfa, 0x21, 0x6c, 0x34, 0x42, 0xa4, 0x34, 0x0a, 0x8a, 0x0d, 0x2b, 0x07, 0x81}: "EfiIsaHcServiceBindingProtocolGuid",
		efi.GUID{0x3a, 0x96, 0xd2, 0x32, 0x5d, 0xfe, 0x30, 0x4f, 0xb6, 0x33, 0x6e, 0x5d, 0xc5, 0x58, 0x03, 0xcc}: "EfiUsbFunctionIoProtocolGuid",
		efi.GUID{0x3a, 0x98, 0x81, 0x95, 0x63, 0x36, 0xf0, 0x46, 0x83, 0xec, 0x8a, 0x05, 0x06, 0xeb, 0x63, 0xe7}: "BiosInfoChecker",
		efi.GUID{0x3a, 0x9d, 0xa3, 0xbd, 0x1b, 0x45, 0x50, 0x43, 0x82, 0x66, 0x81, 0xab, 0x10, 0xfa, 0x05, 0x23}: "PeiDxeDebugLibReportStatusCode",
		efi.GUID{0x3a, 0xa6, 0x7a, 0x3a, 0xb9, 0x88, 0x0b, 0x41, 0x80, 0xc0, 0xc9, 0x7f, 0x14, 0x6b, 0x6d, 0xf8}: "FjUtilSmm",
		efi.GUID{0x3a, 0xaa, 0x33, 0x8d, 0x58, 0xac, 0x2d, 0x4c, 0x99, 0x66, 0xf1, 0x8a, 0xb8, 0xc1, 0x13, 0x93}: "LegacyUsbDxe",
		efi.GUID{0x3a, 0xb1, 0xca, 0x72, 0x3d, 0x8e, 0x49, 0x4c, 0x96, 0x7e, 0x48, 0x7a, 0x1c, 0x29, 0x1e, 0x51}: "DellTagsSmm",
		efi.GUID{0x3a, 0xb4, 0x71, 0xf7, 0xc2, 0xa5, 0xa8, 0x45, 0x82, 0x54, 0xcb, 0xc0, 0x82, 0x50, 0xda, 0x15}: "BoardInitDxe",
		efi.GUID{0x3a, 0xc0, 0x86, 0x7d, 0xf6, 0xb1, 0x0f, 0x4f, 0xab, 0x43, 0x81, 0xd9, 0x25, 0xf1, 0x94, 0x81}: "WarmResetFlagDxe",
		efi.GUID{0x3a, 0xc3, 0x24, 0x39, 0x5e, 0x12, 0xa8, 0x40, 0x84, 0x50, 0x38, 0xc6, 0x67, 0x1e, 0x02, 0x1d}: "AmdNbioPei",
		efi.GUID{0x3a, 0xc9, 0x0c, 0x91, 0xb7, 0xf2, 0x30, 0x46, 0x88, 0x4d, 0x62, 0x5d, 0x57, 0x0f, 0xac, 0xf6}: "IshCapsuleDxe",
		efi.GUID{0x3a, 0xce, 0xec, 0x77, 0x98, 0x73, 0x04, 0x4c, 0x98, 0x1d, 0xd7, 0x78, 0xe7, 0x93, 0xe0, 0xf9}: "TransferNvramPasswordToSmram",
		efi.GUID{0x3a, 0xcf, 0x2b, 0x3f, 0x76, 0x78, 0x5b, 0x47, 0xb9, 0x7d, 0xef, 0xae, 0x8b, 0xef, 0x75, 0xfc}: "AmdNbioGfxRNPei",
		efi.GUID{0x3a, 0xd9, 0x1b, 0x50, 0xa9, 0xf1, 0x4c, 0x4f, 0xa9, 0x46, 0x78, 0x67, 0xdf, 0x97, 0x55, 0x37}: "LenovoEn25Qh64FlashPartSmm",
		efi.GUID{0x3a, 0xda, 0x96, 0xb3, 0xb2, 0x52, 0xd6, 0x4c, 0xa8, 0x9a, 0x13, 0xe7, 0xc4, 0xae, 0x97, 0x90}: "AmiTcgStorageSecurityProtocol",
		efi.GUID{0x3a, 0xe2, 0x9f, 0x51, 0x3d, 0x7c, 0xa9, 0x40, 0x9f, 0x65, 0xb9, 0x11, 0xea, 0x19, 0x30, 0xe1}: "HpLegacyFlashWrapper",
		efi.GUID{0x3a, 0xee, 0x7f, 0xf6, 0xe2, 0xdb, 0x28, 0x42, 0x97, 0x32, 0xb4, 0xdd, 0x1e, 0x5f, 0xf6, 0xaf}: "BoardInfoSmmProtocol",
		efi.GUID{0x3a, 0xf4, 0xce, 0x22, 0x2b, 0xed, 0x95, 0x47, 0xaf, 0x0d, 0x91, 0x8f, 0xf8, 0x5b, 0x35, 0x73}: "ServiceBodyDxe",
		efi.GUID{0x3a, 0xf5, 0xc0, 0x1e, 0xe0, 0xfd, 0x76, 0x45, 0x8f, 0x25, 0x7a, 0x1a, 0x41, 0x0f, 0x58, 0xeb}: "StatusCodePei",
		efi.GUID{0x3b, 0x02, 0x39, 0x48, 0x12, 0x4c, 0xb2, 0x4e, 0xb2, 0xb8, 0xc9, 0x1b, 0x42, 0xd8, 0x78, 0xa0}: "IsctAcpi",
		efi.GUID{0x3b, 0x09, 0xa2, 0xa8, 0xfa, 0xfe, 0xc1, 0x43, 0x8e, 0x62, 0xce, 0x52, 0x68, 0x47, 0x26, 0x5e}: "AmitcEfiOsVariableGuid",
		efi.GUID{0x3b, 0x1f, 0x02, 0xa8, 0x49, 0xb6, 0x18, 0x4c, 0x82, 0x70, 0xa7, 0x96, 0xac, 0xcf, 0x32, 0xe1}: "EfiEmmcWpHobGuid",
		efi.GUID{0x3b, 0x20, 0x08, 0x87, 0x48, 0x89, 0x51, 0x4e, 0xbe, 0xe7, 0x8c, 0x1b, 0x56, 0xee, 0xc9, 0xcd}: "FjPvCredentialProviderDxe",
		efi.GUID{0x3b, 0x20, 0xc0, 0x94, 0xc9, 0x54, 0x6e, 0x41, 0xa6, 0xe0, 0x47, 0xe8, 0xd4, 0x78, 0x69, 0x01}: "EfiPeiPlatformTypeLightningRidgeExecB3Ppi",
		efi.GUID{0x3b, 0x21, 0x35, 0xd6, 0x34, 0x53, 0xb3, 0x46, 0xae, 0x37, 0x8d, 0x43, 0x6d, 0xd3, 0xd5, 0x23}: "OemNvme",
		efi.GUID{0x3b, 0x27, 0x0c, 0x93, 0x75, 0xa8, 0x13, 0x47, 0x93, 0x73, 0xf1, 0x2e, 0x84, 0x83, 0xe1, 0x25}: "IntelGigabitLan_I210",
		efi.GUID{0x3b, 0x28, 0x89, 0xb5, 0x57, 0x0c, 0x00, 0x46, 0x9a, 0xc8, 0x49, 0x3f, 0x5a, 0xb9, 0xd3, 0x33}: "DataAccessHandler",
		efi.GUID{0x3b, 0x2f, 0xee, 0xca, 0x91, 0x31, 0xa0, 0x4d, 0xad, 0x10, 0xa5, 0xc0, 0x7e, 0x63, 0x6c, 0xd1}: "LibString",
		efi.GUID{0x3b, 0x32, 0x84, 0xa4, 0x47, 0xff, 0x2a, 0x42, 0xad, 0xab, 0x8d, 0x1e, 0x1b, 0xc1, 0x38, 0x60}: "HpS3ConfigDxe",
		efi.GUID{0x3b, 0x36, 0xaf, 0x15, 0x41, 0x7c, 0x1a, 0x4d, 0x80, 0x0d, 0x8b, 0xce, 0xe4, 0x73, 0xff, 0x3b}: "AdlMiscellaneous",
		efi.GUID{0x3b, 0x50, 0xaf, 0xd1, 0xb9, 0x68, 0xc9, 0x4f, 0xae, 0x87, 0xdf, 0xb7, 0x2f, 0x21, 0xb3, 0xf1}: "DellFmpMe",
		efi.GUID{0x3b, 0x58, 0x6e, 0x39, 0xdd, 0xd2, 0xf6, 0x45, 0x86, 0xe8, 0x11, 0x98, 0x85, 0x77, 0x7c, 0xde}: "AtaLegacySmm",
		efi.GUID{0x3b, 0x5d, 0x45, 0x9f, 0x8a, 0x2b, 0x06, 0x4c, 0x96, 0x0b, 0xa7, 0x1b, 0x97, 0x14, 0xb9, 0xcd}: "StatusCodeDxe",
		efi.GUID{0x3b, 0x68, 0x8f, 0x8b, 0x76, 0xf3, 0xa0, 0x4b, 0xb8, 0xd7, 0xb4, 0xbb, 0xd3, 0x03, 0x19, 0xcc}: "AtSha204aDxe",
		efi.GUID{0x3b, 0x68, 0xeb, 0x22, 0xd2, 0x1a, 0xe9, 0x4b, 0xae, 0x1c, 0xc4, 0xf1, 0xf2, 0x81, 0xbd, 0xf7}: "PoweronFromKeyboardPortDxe",
		efi.GUID{0x3b, 0x6a, 0x24, 0x65, 0xef, 0x33, 0x7e, 0x4f, 0xb6, 0x57, 0xa4, 0xa6, 0x33, 0xf1, 0x30, 0xb0}: "LenovoSystemVariableSmm",
		efi.GUID{0x3b, 0x6b, 0x27, 0x97, 0xd1, 0x9f, 0xc0, 0x4a, 0xb8, 0xc1, 0xd3, 0x46, 0xdb, 0x41, 0x46, 0xf5}: "DefaultsManagerWmi",
		efi.GUID{0x3b, 0x6f, 0xb4, 0xd3, 0x41, 0xd4, 0x44, 0x12, 0x9a, 0x12, 0x00, 0x12, 0x27, 0x3f, 0xc1, 0x4d}: "EfiXenInfoGuid",
		efi.GUID{0x3b, 0x96, 0x65, 0x05, 0xfd, 0x3d, 0x12, 0x47, 0x9c, 0xfd, 0x61, 0x4c, 0x5e, 0xdb, 0xe5, 0x92}: "MsiBoardPei",
		efi.GUID{0x3b, 0xa4, 0x67, 0xbb, 0xae, 0xc7, 0x99, 0x42, 0xa2, 0x75, 0x75, 0x26, 0xdc, 0x69, 0x77, 0x35}: "PlatformStatusCodeHandlerPei2",
		efi.GUID{0x3b, 0xab, 0xee, 0x00, 0x19, 0x47, 0x2d, 0x43, 0xa2, 0xdc, 0xc9, 0x7a, 0x2c, 0x62, 0xbf, 0xdd}: "DellPermDevConfigPei",
		efi.GUID{0x3b, 0xb3, 0xd5, 0xc5, 0x59, 0x37, 0xd1, 0x4c, 0x95, 0x5f, 0x0d, 0x1e, 0x77, 0x19, 0xe4, 0x9e}: "MFGRTC",
		efi.GUID{0x3b, 0xc6, 0xf2, 0x08, 0xde, 0x08, 0xcd, 0x4c, 0x86, 0x70, 0xac, 0xfe, 0x64, 0x4a, 0x1c, 0x48}: "PchS3Support",
		efi.GUID{0x3b, 0xc7, 0x2e, 0x13, 0x25, 0x30, 0xbf, 0x4f, 0xb1, 0x93, 0x8a, 0xcb, 0x50, 0xef, 0xbd, 0x89}: "QFlash",
		efi.GUID{0x3b, 0xc7, 0x2e, 0x13, 0x26, 0xbd, 0xbf, 0x4f, 0xb1, 0x93, 0x8a, 0xcb, 0x50, 0xef, 0xbd, 0x89}: "UserDefSetupDxe",
		efi.GUID{0x3b, 0xd5, 0x17, 0x63, 0x71, 0x07, 0xb9, 0x42, 0xb6, 0xa8, 0xd0, 0x6f, 0xdc, 0x2d, 0xae, 0x96}: "FjWirelessLanSmm",
		efi.GUID{0x3b, 0xe9, 0x06, 0x69, 0x3b, 0x60, 0x0f, 0x4a, 0x86, 0x92, 0x83, 0x20, 0x04, 0xaa, 0xf2, 0xdb}: "PchSmmPeriodicTimerControl",
		efi.GUID{0x3b, 0xf1, 0xd4, 0x0a, 0x97, 0xd1, 0xec, 0x44, 0xff, 0xff, 0xff, 0xff, 0x62, 0xc8, 0xc6, 0x89}: "XnoteVariableDxe",
		efi.GUID{0x3b, 0xfc, 0x68, 0x38, 0x45, 0x7e, 0xa7, 0x43, 0x90, 0x6c, 0x4b, 0xa4, 0x7d, 0xe1, 0x75, 0x4d}: "EfiSmmFaultTolerantWriteProtocolGuid",
		efi.GUID{0x3c, 0x02, 0xe3, 0x43, 0xdc, 0x13, 0xa6, 0x4b, 0x99, 0xcb, 0xaf, 0x6f, 0x9e, 0xcf, 0x8b, 0x73}: "H19DeviceFwUpdateHook",
		efi.GUID{0x3c, 0x19, 0x7d, 0x3c, 0x2c, 0x68, 0x14, 0x4c, 0xa6, 0x8f, 0x55, 0x2d, 0xea, 0x4f, 0x43, 0x7e}: "PcdDataBaseSignatureGuid",
		efi.GUID{0x3c, 0x1c, 0x8a, 0xe3, 0x8c, 0x92, 0xf7, 0x4b, 0xb6, 0xc1, 0x7f, 0x0e, 0xf1, 0x63, 0xfa, 0xa5}: "FlashDeviceLibRuntimeSmm",
		efi.GUID{0x3c, 0x1f, 0xb1, 0xc7, 0xe9, 0x89, 0x5f, 0x44, 0xa9, 0x72, 0x67, 0x1b, 0x8b, 0x17, 0x58, 0x0d}: "DellSmbStrucB2Config",
		efi.GUID{0x3c, 0x20, 0xb0, 0xce, 0x91, 0xde, 0xce, 0x4e, 0xa9, 0x5f, 0x02, 0x17, 0xe9, 0x59, 0xe1, 0x91}: "SystemSecureFlashAuthenticationDxe",
		efi.GUID{0x3c, 0x26, 0xa8, 0x0b, 0xbd, 0xa8, 0xad, 0x4a, 0xb4, 0x02, 0x6a, 0x6a, 0xf2, 0xf7, 0xe7, 0x7d}: "BlockDeviceCapsuleGuid",
		efi.GUID{0x3c, 0x27, 0x34, 0xa1, 0x29, 0x04, 0x93, 0x4b, 0xa3, 0x0c, 0x30, 0x5d, 0x5e, 0xc2, 0x2d, 0xb5}: "KEMhGpioAccDxe",
		efi.GUID{0x3c, 0x29, 0x81, 0x63, 0xfe, 0x7a, 0xd9, 0x49, 0xaf, 0xfa, 0x4b, 0x8f, 0x87, 0x9a, 0x9b, 0xcc}: "DellAutoRtcResetPei",
		efi.GUID{0x3c, 0x2a, 0x70, 0xa2, 0xfd, 0x62, 0x2d, 0x40, 0xb8, 0xc3, 0x1d, 0x18, 0xf6, 0xc6, 0xfd, 0xe5}: "AodSetupDxe",
		efi.GUID{0x3c, 0x2f, 0x1b, 0x0e, 0x5f, 0xdd, 0xce, 0x44, 0x8d, 0x37, 0x5a, 0xec, 0x2b, 0x33, 0x9b, 0x5c}: "BiosConnectSOSLauncher",
		efi.GUID{0x3c, 0x42, 0x19, 0xa2, 0xfe, 0x92, 0xae, 0x41, 0x96, 0x5c, 0x2e, 0xff, 0xc6, 0x01, 0x86, 0x70}: "PdSolutionSmm",
		efi.GUID{0x3c, 0x42, 0xec, 0xb6, 0xd2, 0x21, 0x0d, 0x49, 0x85, 0xc6, 0xdd, 0x58, 0x64, 0xea, 0xa6, 0x74}: "PeiBaseMemoryTestPpiGuid",
		efi.GUID{0x3c, 0x44, 0x22, 0xe6, 0x4e, 0x28, 0x47, 0x4b, 0xa9, 0x84, 0xfd, 0x66, 0xb4, 0x82, 0xda, 0xc0}: "BootManagerPolicyDxe",
		efi.GUID{0x3c, 0x5d, 0x62, 0xb1, 0x2d, 0x9d, 0x0d, 0x4e, 0xb8, 0x64, 0x8a, 0x76, 0x3e, 0xe4, 0xec, 0x50}: "TcpDxe",
		efi.GUID{0x3c, 0x66, 0xc2, 0xb8, 0xfd, 0xf9, 0x2a, 0x45, 0xab, 0xd8, 0x20, 0x55, 0x6f, 0xe2, 0xae, 0x65}: "BiosAuditLogHandlerPei",
		efi.GUID{0x3c, 0x67, 0x16, 0xc5, 0x71, 0x6c, 0x0e, 0x4f, 0x83, 0xb5, 0x57, 0xfc, 0x66, 0x23, 0x76, 0xec}: "LibPosix",
		efi.GUID{0x3c, 0x68, 0xab, 0xce, 0x56, 0xec, 0x2d, 0x4a, 0xa9, 0x06, 0x40, 0x53, 0xfa, 0x4e, 0x9c, 0x16}: "EfiTemporaryRamDonePpiGuid",
		efi.GUID{0x3c, 0x70, 0x10, 0xf1, 0x16, 0x9d, 0xca, 0x40, 0x25, 0x0a, 0x27, 0x00, 0xca, 0x53, 0x4f, 0x87}: "DellMfgBootListConfigSmm",
		efi.GUID{0x3c, 0x73, 0xe2, 0xfc, 0x04, 0x88, 0x93, 0x42, 0xac, 0x52, 0x56, 0x2d, 0x2d, 0x72, 0x9d, 0x2a}: "AmiSetupFormSetVar",
		efi.GUID{0x3c, 0x80, 0xff, 0xe5, 0x51, 0xde, 0xc7, 0x4c, 0xa8, 0xdb, 0x39, 0x54, 0x98, 0x15, 0xa8, 0x86}: "DellUsbMassStorageDxe",
		efi.GUID{0x3c, 0x88, 0x62, 0x99, 0x25, 0xc0, 0xbb, 0x4e, 0xb6, 0x99, 0x4e, 0xa4, 0xd1, 0x47, 0xc8, 0xa8}: "AmiTxtTcgPeim",
		efi.GUID{0x3c, 0xab, 0x82, 0x2c, 0x34, 0xa7, 0x7e, 0x4c, 0xa7, 0x90, 0xf3, 0x79, 0xbb, 0xf8, 0x8f, 0x9b}: "PlatformMilestoneHookSmm",
		efi.GUID{0x3c, 0xab, 0xea, 0xa3, 0x3a, 0xba, 0x24, 0x45, 0x9d, 0xc7, 0x7e, 0x33, 0x99, 0x96, 0xf4, 0x96}: "ASUSRT",
		efi.GUID{0x3c, 0xb0, 0xcb, 0xbd, 0x5e, 0x54, 0xc1, 0x43, 0x8a, 0xa8, 0xf0, 0x58, 0xc4, 0xfa, 0x81, 0xa8}: "DxeGpioControl",
		efi.GUID{0x3c, 0xb7, 0xad, 0x82, 0x05, 0xe0, 0x07, 0x4e, 0x97, 0x6d, 0xf7, 0xf7, 0x53, 0x14, 0xec, 0x4f}: "FchSmmDispatcher",
		efi.GUID{0x3c, 0xba, 0xbe, 0xfd, 0xc5, 0xb4, 0x76, 0x4f, 0xb8, 0x0a, 0x3d, 0x1f, 0x8d, 0xa6, 0x29, 0x73}: "DellFlashPowerConfigSmm",
		efi.GUID{0x3c, 0xd1, 0x0a, 0x5e, 0x4b, 0x01, 0x21, 0x49, 0x99, 0x66, 0xac, 0xde, 0xb0, 0x4f, 0x3c, 0xc7}: "RemapIommuPei",
		efi.GUID{0x3c, 0xd1, 0x1c, 0xec, 0x56, 0x56, 0x2b, 0x4d, 0x85, 0x32, 0x97, 0x4c, 0xc0, 0x30, 0xef, 0x1b}: "BiosGuardUpdateProtectRegion",
		efi.GUID{0x3c, 0xe3, 0x99, 0x0f, 0x0c, 0xca, 0xa2, 0x4a, 0x88, 0x7d, 0xb5, 0x7e, 0xc9, 0x05, 0x02, 0x78}: "SaveMemoryConfig",
		efi.GUID{0x3c, 0xec, 0xcb, 0x74, 0x90, 0x81, 0xa0, 0x42, 0x9c, 0x02, 0xd1, 0xc5, 0xad, 0xc7, 0x06, 0xd7}: "AppleAirport",
		efi.GUID{0x3c, 0xee, 0x79, 0xb0, 0xa6, 0x37, 0xe6, 0x47, 0xbf, 0x8a, 0x94, 0xa7, 0xe8, 0x5c, 0x41, 0xae}: "MFTSmm",
		efi.GUID{0x3d, 0x03, 0xc6, 0x92, 0x85, 0xa6, 0x41, 0xbb, 0xaa, 0x2f, 0x6f, 0x6e, 0x2c, 0xd3, 0x74, 0xa2}: "AppleSmbios",
		efi.GUID{0x3d, 0x07, 0x42, 0x98, 0xd9, 0x95, 0x49, 0x9f, 0xbd, 0x3f, 0x2e, 0x29, 0x52, 0x51, 0x25, 0xdf}: "EmuBusDriver",
		efi.GUID{0x3d, 0x0e, 0x82, 0x7c, 0xf7, 0xc3, 0xc1, 0x42, 0xa0, 0x22, 0x7f, 0xe4, 0x34, 0xa8, 0x7d, 0xfb}: "FvNetworkDxe",
		efi.GUID{0x3d, 0x0f, 0x89, 0x83, 0x47, 0xb7, 0x4d, 0x4f, 0x8c, 0x21, 0x12, 0x90, 0x87, 0x59, 0xa5, 0x3f}: "HstiIhvProviderDxeEGS",
		efi.GUID{0x3d, 0x17, 0x88, 0x69, 0xc9, 0xb7, 0xbe, 0x47, 0xbd, 0xdf, 0x25, 0x5a, 0x18, 0x67, 0x69, 0x13}: "UefiDriverPolicyDXE",
		efi.GUID{0x3d, 0x1a, 0x75, 0x96, 0xf4, 0x72, 0xa6, 0x41, 0xa7, 0x94, 0xed, 0x5d, 0x0e, 0x67, 0xae, 0x6b}: "EfiCcMeasurementProtocol",
		efi.GUID{0x3d, 0x1e, 0x9a, 0xdb, 0xcb, 0x45, 0xbb, 0x4a, 0x85, 0x3b, 0xe5, 0x38, 0x7f, 0xdb, 0x2e, 0x2d}: "EfiLegacyBiosProtocolGuid",
		efi.GUID{0x3d, 0x21, 0x61, 0x52, 0x3d, 0x3a, 0x1e, 0x44, 0xb3, 0xaf, 0x21, 0xd3, 0xf7, 0xa4, 0xca, 0x17}: "EfiScsiBusProtocol",
		efi.GUID{0x3d, 0x26, 0xff, 0xfd, 0x68, 0x5f, 0x91, 0x45, 0x87, 0xba, 0xb7, 0x68, 0xf4, 0x45, 0xa9, 0xaf}: "Tcg2Dxe",
		efi.GUID{0x3d, 0x35, 0x35, 0xb8, 0x49, 0x40, 0x0b, 0x41, 0x8f, 0x18, 0x4c, 0x74, 0x9c, 0x4c, 0x7a, 0x78}: "DxeSleepEvent",
		efi.GUID{0x3d, 0x54, 0xe4, 0xf3, 0x35, 0xcf, 0xef, 0x6c, 0x35, 0xc4, 0x4f, 0xe6, 0x34, 0x4d, 0xfc, 0x54}: "EfiFormCallbackProtocolGuid",
		efi.GUID{0x3d, 0x55, 0x4d, 0xce, 0xf4, 0x7f, 0x27, 0x45, 0xa3, 0x8c, 0x04, 0x11, 0x13, 0x8d, 0x7b, 0x97}: "FjUsbTypecPwrLimitCtrlSx",
		efi.GUID{0x3d, 0x58, 0xd6, 0xfe, 0x18, 0x24, 0x60, 0x47, 0xac, 0x96, 0xb5, 0xe1, 0x8f, 0x0a, 0x63, 0x26}: "SmmCorePlatformHookLibNull",
		efi.GUID{0x3d, 0x59, 0xce, 0x31, 0x8a, 0x10, 0x5d, 0x48, 0xad, 0xb2, 0x78, 0xf2, 0x1f, 0x29, 0x66, 0xbe}: "EfiLegacyInterruptProtocolGuid",
		efi.GUID{0x3d, 0x5a, 0x94, 0x84, 0xc8, 0x49, 0x59, 0x40, 0x8f, 0x34, 0x6a, 0x45, 0x32, 0xd3, 0x2a, 0x47}: "VariableEditSmm",
		efi.GUID{0x3d, 0x63, 0x12, 0x71, 0x0a, 0x59, 0x4e, 0x43, 0x8f, 0x99, 0x80, 0xeb, 0xae, 0xe1, 0x31, 0x70}: "LenovoVariableChkDxe",
		efi.GUID{0x3d, 0x64, 0x94, 0xf8, 0x49, 0xc4, 0xd1, 0x42, 0x8e, 0xa8, 0x85, 0xbd, 0xd8, 0xc6, 0x5b, 0xde}: "EfiPeiMemoryDiscoveredPpiGuid",
		efi.GUID{0x3d, 0x66, 0x3d, 0xa7, 0x91, 0xa4, 0x78, 0x42, 0x9a, 0x69, 0x95, 0x21, 0xbe, 0x33, 0x79, 0xf2}: "ArmVeTimerDxe",
		efi.GUID{0x3d, 0x67, 0xbb, 0x42, 0xf3, 0x09, 0x2e, 0x4e, 0x9f, 0xee, 0xd0, 0x81, 0x13, 0x1d, 0xed, 0x5b}: "BootScriptSaveDxe",
		efi.GUID{0x3d, 0x72, 0x12, 0x38, 0x48, 0x7e, 0x29, 0x4e, 0xbc, 0x27, 0xf5, 0xa3, 0x9a, 0xc9, 0x4e, 0xf1}: "ItkDataVarGuid",
		efi.GUID{0x3d, 0x82, 0xf0, 0xcd, 0x05, 0x0d, 0xf2, 0x40, 0xa4, 0x24, 0x97, 0x8b, 0xcd, 0x27, 0x01, 0x56}: "FlexIoPortConfigDxe",
		efi.GUID{0x3d, 0x93, 0x05, 0x1f, 0x2e, 0xff, 0x36, 0x42, 0xbe, 0x92, 0x56, 0x68, 0x2d, 0x3e, 0x8f, 0xb4}: "FdCapsule",
		efi.GUID{0x3d, 0x9f, 0x60, 0x31, 0x94, 0x4c, 0xf0, 0x4f, 0xb7, 0xe4, 0x5b, 0x6c, 0xa2, 0x30, 0x2d, 0xb3}: "GlobalAcpiNvs",
		efi.GUID{0x3d, 0xa9, 0x95, 0x0c, 0x06, 0xa0, 0xd4, 0x11, 0xbc, 0xfa, 0x00, 0x80, 0xc7, 0x3c, 0x88, 0x81}: "EfiWinNtSerialPortGuid",
		efi.GUID{0x3d, 0xaa, 0xe5, 0xf9, 0x61, 0x9d, 0xc6, 0x48, 0x83, 0x48, 0x24, 0xda, 0x25, 0x92, 0x42, 0x11}: "EmulatedEepromPei",
		efi.GUID{0x3d, 0xac, 0x1c, 0x1e, 0x60, 0x84, 0xda, 0x4e, 0x97, 0x91, 0x6d, 0x1b, 0x2d, 0xa7, 0x5e, 0x21}: "NvmeSmartFeature",
		efi.GUID{0x3d, 0xad, 0x95, 0xac, 0x66, 0x43, 0xbf, 0x44, 0x9a, 0x62, 0xe4, 0xb2, 0x9d, 0x7a, 0x22, 0x06}: "SmmAccess2Dxe",
		efi.GUID{0x3d, 0xb8, 0x6b, 0x2d, 0xa2, 0x84, 0x4a, 0x40, 0xb4, 0xca, 0x3e, 0x7a, 0xc0, 0xef, 0xb3, 0xd2}: "BootOptionPolicyDxe",
		efi.GUID{0x3d, 0xb9, 0x8f, 0x8e, 0x87, 0x6f, 0xf8, 0x4c, 0x9a, 0x9e, 0xdf, 0x5b, 0x89, 0x8d, 0x22, 0x3a}: "MaintenanceLed",
		efi.GUID{0x3d, 0xcb, 0xb9, 0x5c, 0xa4, 0x31, 0x0c, 0x48, 0x94, 0x98, 0x29, 0xd2, 0x69, 0xba, 0xcf, 0xba}: "EdkiiPeiMpServices2Ppi",
		efi.GUID{0x3d, 0xce, 0xc5, 0xf6, 0x68, 0x26, 0x2a, 0x40, 0x95, 0x2e, 0x27, 0x07, 0x86, 0x15, 0x0d, 0xfb}: "SwSmi534D3220",
		efi.GUID{0x3d, 0xd1, 0xde, 0x80, 0x21, 0xb8, 0x24, 0x48, 0xa0, 0xdd, 0x52, 0xca, 0x96, 0x8c, 0x3a, 0x04}: "AmdCpmOemGpioDxe",
		efi.GUID{0x3d, 0xd6, 0x66, 0xa1, 0x15, 0x38, 0xa2, 0x4f, 0xba, 0xb6, 0x55, 0x5d, 0x96, 0xba, 0x51, 0x6f}: "FjMemoryInfo2",
		efi.GUID{0x3d, 0xe1, 0xbc, 0xab, 0x5a, 0xe2, 0x9f, 0x4d, 0xa1, 0xf9, 0x2f, 0x77, 0x10, 0x78, 0x68, 0x92}: "Platform",
		efi.GUID{0x3d, 0xe3, 0x30, 0x1e, 0x54, 0x18, 0x7a, 0x43, 0xbd, 0x68, 0xfc, 0x15, 0x53, 0xaa, 0x8b, 0xe4}: "CseEmmcSelectPpiGuid",
		efi.GUID{0x3d, 0xe4, 0x7c, 0x5f, 0x5a, 0x56, 0x20, 0x44, 0xb4, 0xf8, 0x22, 0xec, 0xa7, 0x24, 0x57, 0x55}: "AmiDbrFileGuid",
		efi.GUID{0x3d, 0xe5, 0x1b, 0x23, 0xe3, 0xb6, 0xd8, 0x44, 0xa8, 0xd5, 0xe0, 0x56, 0x6e, 0x55, 0x66, 0x3d}: "EsrtOverrideDxe",
		efi.GUID{0x3d, 0xe7, 0xbc, 0xa2, 0x22, 0x5b, 0xc7, 0x4f, 0x80, 0xf5, 0xf1, 0xa9, 0xd2, 0x6e, 0xd7, 0x58}: "WheaErrorInj2",
		efi.GUID{0x3d, 0xed, 0x17, 0x7b, 0x92, 0x38, 0xb4, 0x43, 0xb5, 0xe5, 0xdf, 0x80, 0x2b, 0x4f, 0x48, 0x55}: "SureStartPoliciesSmm",
		efi.GUID{0x3d, 0xf9, 0x80, 0xd0, 0xe8, 0xc0, 0xd6, 0x47, 0x92, 0x01, 0x6b, 0x0e, 0xf6, 0xe2, 0x8e, 0x1a}: "RfTrustedModules",
		efi.GUID{0x3e, 0x26, 0x23, 0x72, 0x5d, 0x03, 0x95, 0x44, 0x81, 0xae, 0x7d, 0xde, 0xbc, 0xd8, 0x61, 0x6f}: "SystemAudioDeviceSmm",
		efi.GUID{0x3e, 0x32, 0x0b, 0xc5, 0x75, 0x90, 0x2a, 0x4f, 0xac, 0x8e, 0xd2, 0x59, 0x6a, 0x10, 0x85, 0xcc}: "EfiSmmIchnDispatchProtocolGuid",
		efi.GUID{0x3e, 0x33, 0xa1, 0xe5, 0xb4, 0xe1, 0x55, 0x4d, 0xce, 0xeb, 0x35, 0xc3, 0xef, 0x13, 0x34, 0x43}: "EfiFormBrowserProtocolGuid",
		efi.GUID{0x3e, 0x3b, 0x8a, 0x2e, 0x6c, 0xf2, 0xea, 0x11, 0xbd, 0xe5, 0x67, 0x26, 0xad, 0x8f, 0x88, 0xbd}: "BootProgressPeim",
		efi.GUID{0x3e, 0x58, 0x2a, 0x47, 0xcf, 0x70, 0x5a, 0x46, 0xbb, 0x77, 0x53, 0xad, 0xfc, 0xdb, 0x58, 0x83}: "OCMR_DXE",
		efi.GUID{0x3e, 0x5a, 0x95, 0x7f, 0xb5, 0xaf, 0x22, 0x41, 0xb9, 0x25, 0x4b, 0x11, 0x71, 0xf6, 0x93, 0xf5}: "AmiBlockIoWriteProtectionProtocolGuid",
		efi.GUID{0x3e, 0x6c, 0x69, 0x7e, 0x5d, 0x5c, 0x64, 0x4a, 0x96, 0x50, 0xe7, 0x92, 0xfa, 0xd2, 0x41, 0x28}: "AdlDriverSmm",
		efi.GUID{0x3e, 0x6e, 0x0c, 0x7e, 0x0f, 0xc8, 0xd1, 0x47, 0x8a, 0xda, 0x55, 0x49, 0x26, 0xb2, 0xb6, 0xb3}: "GenericMemoryTestDxe",
		efi.GUID{0x3e, 0x6e, 0x28, 0x3f, 0xea, 0x16, 0x5e, 0x4e, 0xa2, 0xad, 0x63, 0x64, 0x4f, 0x1a, 0xc3, 0xc7}: "PeiConsoleOutConsplitter",
		efi.GUID{0x3e, 0x74, 0x62, 0xd3, 0x68, 0xcd, 0x00, 0x45, 0xaa, 0x93, 0xc5, 0x96, 0x38, 0x3a, 0xe3, 0x1b}: "FjPasswordCtrlPei",
		efi.GUID{0x3e, 0x7f, 0x10, 0x70, 0x8f, 0xad, 0x2c, 0x44, 0xa3, 0x11, 0x74, 0x95, 0x09, 0x7f, 0x35, 0xf8}: "CountrySupport",
		efi.GUID{0x3e, 0x84, 0x6a, 0x5f, 0x88, 0xd1, 0xa3, 0x41, 0xba, 0x3c, 0xa8, 0x3d, 0x89, 0x97, 0xdc, 0x7f}: "BootPriority",
		efi.GUID{0x3e, 0x85, 0x6f, 0x1d, 0x06, 0x00, 0xd8, 0x40, 0x9b, 0x4b, 0x79, 0x61, 0x8a, 0x57, 0x33, 0xb0}: "AmiTseOemPortingVar3Guid",
		efi.GUID{0x3e, 0x85, 0x9a, 0xef, 0xf3, 0x2d, 0xed, 0x48, 0x91, 0xe5, 0x62, 0x32, 0x66, 0x8c, 0x4d, 0xb1}: "CbsSetupSmmPhx",
		efi.GUID{0x3e, 0x8a, 0xa2, 0xd4, 0xf2, 0xdc, 0xcf, 0x43, 0xa2, 0xb7, 0xf3, 0x57, 0x2a, 0x7c, 0xab, 0x09}: "EfiIobaseHob",
		efi.GUID{0x3e, 0x91, 0xf7, 0x1f, 0x90, 0xd8, 0x60, 0x43, 0xac, 0x75, 0xb8, 0xd8, 0x38, 0x4b, 0xd1, 0xe0}: "AmdSmmControl",
		efi.GUID{0x3e, 0x98, 0x07, 0xe8, 0x66, 0xd3, 0xc9, 0x40, 0x84, 0x6a, 0x0e, 0xd7, 0xe6, 0x02, 0x2c, 0x96}: "DellTagsConfig",
		efi.GUID{0x3e, 0x9f, 0x96, 0x6a, 0x1f, 0xed, 0xfe, 0x41, 0xa9, 0x32, 0x43, 0x99, 0x4b, 0x05, 0x54, 0x8f}: "SocWdtSmm",
		efi.GUID{0x3e, 0xa2, 0xd0, 0x16, 0x9c, 0xc0, 0x7d, 0x40, 0xa1, 0x4a, 0xad, 0x05, 0x8f, 0xdd, 0x0c, 0xa1}: "ACPI",
		efi.GUID{0x3e, 0xa6, 0xcd, 0x40, 0x70, 0x3f, 0x25, 0x4b, 0xa5, 0x0c, 0x49, 0xdb, 0xd7, 0xee, 0x34, 0x3f}: "SmbiosType132",
		efi.GUID{0x3e, 0xa9, 0xa9, 0x95, 0x6e, 0xa8, 0x26, 0x49, 0xaa, 0xef, 0x99, 0x18, 0xe7, 0x72, 0xd9, 0x87}: "EfiEraseBlockProtocolGuid",
		efi.GUID{0x3e, 0xab, 0x0c, 0x5f, 0x20, 0xf8, 0xd3, 0x4f, 0xb5, 0xf1, 0x45, 0x68, 0xad, 0xa0, 0xac, 0xc6}: "PiSmmCommunicationPei",
		efi.GUID{0x3e, 0xab, 0xc5, 0x35, 0x7a, 0xb7, 0x0c, 0x45, 0x88, 0x54, 0x15, 0x9b, 0x2f, 0x0d, 0x32, 0xa5}: "Ich7MSmmDispatcher",
		efi.GUID{0x3e, 0xb1, 0x81, 0x0b, 0x95, 0xe5, 0x35, 0x4d, 0x9e, 0x7b, 0xa3, 0xc8, 0x5e, 0x01, 0xa2, 0x3f}: "HhmDxe",
		efi.GUID{0x3e, 0xb7, 0x12, 0x1d, 0xde, 0x7d, 0x10, 0x49, 0x93, 0xc5, 0x2b, 0xdb, 0x04, 0x1c, 0x68, 0x49}: "FjIbvBiosPasswordAbstractionDxeProtocol",
		efi.GUID{0x3e, 0xb9, 0x1b, 0xee, 0xc5, 0x54, 0x17, 0x4b, 0x94, 0x96, 0xa2, 0x00, 0x85, 0x95, 0x05, 0x61}: "SmmUsbDispatch2OnSmmUsbDispatchThunk",
		efi.GUID{0x3e, 0xc4, 0xfc, 0x54, 0x89, 0xaa, 0x33, 0x43, 0x9a, 0x85, 0xcd, 0xea, 0x24, 0x05, 0x1e, 0x9e}: "EfiSupplicantProtocolGuid",
		efi.GUID{0x3e, 0xc7, 0x80, 0xc2, 0xca, 0x15, 0xda, 0x11, 0xb0, 0xca, 0x00, 0x10, 0x83, 0xff, 0xca, 0x4d}: "EfiAuthenticationChapLocalGuid",
		efi.GUID{0x3e, 0xca, 0x67, 0xea, 0x54, 0x1f, 0x6b, 0x43, 0x97, 0x88, 0xd4, 0xeb, 0x29, 0xc3, 0x42, 0x67}: "Early16550UartBaseAddress",
		efi.GUID{0x3e, 0xdb, 0xeb, 0x18, 0xc2, 0x95, 0x25, 0x47, 0xab, 0x63, 0x74, 0xb4, 0x78, 0xc4, 0x75, 0xde}: "AmdCpmSocAm4RvDxe",
		efi.GUID{0x3e, 0xe0, 0xfa, 0x5d, 0x19, 0x9c, 0x96, 0x49, 0x85, 0xbf, 0x65, 0x29, 0x7b, 0xd4, 0x13, 0x7f}: "PlatformVTdSampleDxe",
		efi.GUID{0x3e, 0xe3, 0xfa, 0x51, 0x59, 0x9c, 0x26, 0x49, 0x85, 0x7f, 0x65, 0x99, 0x7b, 0xd4, 0x13, 0x7f}: "VariablePolicyStubDxe",
		efi.GUID{0x3e, 0xe8, 0x7b, 0x70, 0xf6, 0x0b, 0xa5, 0x40, 0xbe, 0x64, 0x34, 0xc0, 0x3a, 0xa0, 0xb8, 0xe2}: "EfiSmbusArpMapGuid",
		efi.GUID{0x3e, 0xe9, 0x59, 0x47, 0x44, 0x8f, 0x8f, 0x44, 0x88, 0xa1, 0xbd, 0x97, 0xfc, 0x47, 0xbe, 0xa5}: "AmdPspP2CmboxV2",
		efi.GUID{0x3e, 0xf2, 0x29, 0x90, 0xee, 0xe1, 0xd1, 0x40, 0x93, 0x82, 0x36, 0xdd, 0x61, 0xa6, 0x3e, 0xaa}: "NCT6686DPeiInit",
		efi.GUID{0x3e, 0xf2, 0x29, 0x90, 0xee, 0xe1, 0xd1, 0x40, 0x93, 0x82, 0x36, 0xdd, 0x61, 0xa6, 0x79, 0x1d}: "NCT6791DPeiInit",
		efi.GUID{0x3e, 0xf2, 0x29, 0x90, 0xee, 0xe1, 0xd1, 0x40, 0x93, 0x82, 0x36, 0xdd, 0x61, 0xa8, 0x18, 0x66}: "F81966PeiInit",
		efi.GUID{0x3e, 0xf2, 0x29, 0xa2, 0xff, 0xe1, 0xd1, 0x40, 0x93, 0x82, 0x36, 0xdd, 0x61, 0xa6, 0x3e, 0xaa}: "AltModePei",
		efi.GUID{0x3e, 0xf7, 0x16, 0x19, 0x24, 0xc8, 0x91, 0x4f, 0xac, 0x9c, 0xbf, 0x1f, 0xd2, 0x8e, 0x44, 0x31}: "DellServiceMenu",
		efi.GUID{0x3f, 0x09, 0xf9, 0x27, 0x7a, 0x52, 0xab, 0x42, 0xae, 0x55, 0x5c, 0x56, 0xda, 0x8d, 0x9a, 0xb8}: "BootOrderDefaultSettings",
		efi.GUID{0x3f, 0x18, 0x34, 0x10, 0x0a, 0xaf, 0x16, 0x47, 0xbe, 0x0e, 0x4c, 0xb5, 0x31, 0x9d, 0x61, 0x93}: "PciHotPlugNonRpDxe",
		efi.GUID{0x3f, 0x2e, 0x2b, 0x26, 0x2d, 0xda, 0x81, 0x4b, 0x8d, 0x1d, 0xf9, 0x38, 0xe8, 0x51, 0xfd, 0xed}: "SmcBoardInfoVariable",
		efi.GUID{0x3f, 0x54, 0x66, 0x71, 0x35, 0x3e, 0xa2, 0x41, 0x91, 0x18, 0x57, 0x7b, 0xba, 0x62, 0xc6, 0x93}: "AmdAgesaParameterGroupPei",
		efi.GUID{0x3f, 0x62, 0x5a, 0xc6, 0x68, 0x27, 0x00, 0x47, 0xbe, 0x2c, 0x1d, 0x8b, 0xa2, 0xc4, 0x39, 0x98}: "Inside",
		efi.GUID{0x3f, 0x64, 0x1f, 0xe5, 0x3c, 0x5f, 0xfd, 0x4c, 0x91, 0x26, 0x46, 0x87, 0x30, 0x5f, 0x18, 0xda}: "ReadyToPxeBootGuid",
		efi.GUID{0x3f, 0x66, 0xce, 0x35, 0x2d, 0x29, 0x63, 0x47, 0x80, 0xf5, 0x05, 0xc9, 0x33, 0xf6, 0xea, 0x15}: "RequiredUefiVarPeim",
		efi.GUID{0x3f, 0x6c, 0x22, 0x08, 0xf8, 0xbb, 0x1b, 0x43, 0x87, 0x5e, 0x73, 0x61, 0x44, 0x4a, 0x23, 0xf9}: "AmdMemSmbiosV2RnPei",
		efi.GUID{0x3f, 0x6d, 0xd9, 0x19, 0x6a, 0x6a, 0xd2, 0x47, 0xb1, 0x95, 0x7b, 0x24, 0x32, 0xda, 0x3b, 0xe2}: "AddBootOption",
		efi.GUID{0x3f, 0x6e, 0xa8, 0xd1, 0x07, 0x07, 0x35, 0x4c, 0x83, 0xcd, 0xdc, 0x2c, 0x29, 0xc8, 0x91, 0xa3}: "EdkiiNvVarStoreFormatted",
		efi.GUID{0x3f, 0x70, 0x1c, 0x71, 0x85, 0xc2, 0x10, 0x4b, 0xa3, 0xb0, 0x36, 0xec, 0xbd, 0x3c, 0x8b, 0xe2}: "EfiCapsuleVendorGuid",
		efi.GUID{0x3f, 0x73, 0x5f, 0xf3, 0x35, 0x52, 0x7b, 0x4d, 0x83, 0xfa, 0x97, 0x78, 0x0c, 0xeb, 0xcb, 0x20}: "Ping6",
		efi.GUID{0x3f, 0x73, 0xc0, 0x4f, 0xd2, 0x6f, 0x1b, 0x49, 0xa8, 0x90, 0x53, 0x74, 0x52, 0x1b, 0xf4, 0x8f}: "AmiBoardInfo2ProtocolGuid",
		efi.GUID{0x3f, 0x78, 0xfc, 0x25, 0xad, 0x41, 0xa1, 0x4b, 0xb1, 0x90, 0x6d, 0x4b, 0x3f, 0xb6, 0xcc, 0x5b}: "ThunderboltDxe",
		efi.GUID{0x3f, 0x79, 0xb6, 0x9f, 0x08, 0x70, 0x63, 0x49, 0xae, 0xd6, 0x35, 0xaf, 0xb2, 0x65, 0xdf, 0x60}: "FjGpioGeminilakeSmm",
		efi.GUID{0x3f, 0x7c, 0x78, 0xf7, 0xd5, 0x0c, 0x36, 0x45, 0x93, 0x54, 0x06, 0x70, 0xee, 0x22, 0xd7, 0xfd}: "AmdCpmModernStandbyAcpiTableInstall",
		efi.GUID{0x3f, 0x80, 0x8e, 0xb1, 0xd2, 0xf4, 0xdc, 0x49, 0x9c, 0x10, 0x64, 0x31, 0x74, 0xf5, 0x6b, 0x97}: "Usb_Lan_Ax88179",
		efi.GUID{0x3f, 0x83, 0x74, 0xe9, 0xae, 0xa4, 0x39, 0x4e, 0xbe, 0x37, 0x8b, 0x67, 0x80, 0xdf, 0xad, 0x01}: "Int15PanelFitting",
		efi.GUID{0x3f, 0x85, 0x1b, 0x39, 0x88, 0xf4, 0x9b, 0x47, 0xa3, 0xd6, 0x87, 0x07, 0x66, 0xc7, 0xa3, 0x8f}: "CryptoSmm",
		efi.GUID{0x3f, 0x88, 0x86, 0x29, 0xe0, 0x88, 0xd0, 0x48, 0x4b, 0x82, 0x20, 0xc2, 0x69, 0x48, 0xdd, 0xac}: "TxtInfoHob",
		efi.GUID{0x3f, 0x8a, 0x0f, 0xcc, 0xea, 0x3d, 0x76, 0x43, 0x96, 0x79, 0x54, 0x26, 0xba, 0x0a, 0x90, 0x7e}: "PkVar",
		efi.GUID{0x3f, 0x8d, 0x7c, 0x44, 0x9f, 0x42, 0x5d, 0x40, 0xbd, 0xc6, 0x35, 0xd7, 0x5f, 0x3d, 0xc0, 0x82}: "OFCRuntimeDxe",
		efi.GUID{0x3f, 0x9d, 0x19, 0x8e, 0x74, 0x3a, 0x2b, 0x49, 0x8c, 0xb3, 0x93, 0xd6, 0x68, 0xd8, 0x7d, 0x07}: "IsRecovery",
		efi.GUID{0x3f, 0x9e, 0xeb, 0x34, 0x18, 0x93, 0xe7, 0x4c, 0x99, 0xad, 0x9e, 0x72, 0x89, 0x03, 0x8c, 0x52}: "WifiBootDevAuthList",
		efi.GUID{0x3f, 0xa7, 0x7a, 0xb8, 0xb3, 0xdc, 0x33, 0x45, 0x83, 0x98, 0x6c, 0x12, 0x84, 0x27, 0x28, 0x40}: "ReserveMemFlagVariable",
		efi.GUID{0x3f, 0xb5, 0xd5, 0x09, 0xb0, 0xf4, 0x59, 0x4f, 0xa0, 0xb1, 0x7b, 0x57, 0xd3, 0x5c, 0x0e, 0x05}: "NicIp4ConfigNvDataGuid",
		efi.GUID{0x3f, 0xbb, 0x55, 0x8e, 0x48, 0x11, 0xa5, 0x4e, 0xbd, 0xb6, 0x42, 0x5e, 0x45, 0x84, 0xff, 0x78}: "DefaultUpdate",
		efi.GUID{0x3f, 0xbd, 0x68, 0xfa, 0xd7, 0x8a, 0x41, 0x4d, 0x8c, 0xd9, 0x2e, 0x72, 0xfb, 0x38, 0x7a, 0xd7}: "SctMilestoneTaskDxe",
		efi.GUID{0x3f, 0xbe, 0x20, 0x3e, 0xb0, 0xf9, 0x0b, 0x46, 0xb4, 0x3d, 0xec, 0xc3, 0x49, 0x7d, 0x7b, 0xc7}: "DellSoftTAADxe",
		efi.GUID{0x3f, 0xbf, 0xa4, 0x53, 0xa4, 0x82, 0x58, 0x47, 0x8a, 0x08, 0x7e, 0xdd, 0x2e, 0xdf, 0xf2, 0xb5}: "PlatformEmmcController",
		efi.GUID{0x3f, 0xc8, 0xdd, 0x24, 0x06, 0x9f, 0xab, 0x44, 0xb6, 0x96, 0x60, 0xfe, 0x7d, 0xf2, 0xc9, 0x48}: "RstVmdPeim",
		efi.GUID{0x3f, 0xcb, 0x15, 0xfb, 0x73, 0xd3, 0xa1, 0x45, 0xb9, 0xb1, 0x00, 0x79, 0xd4, 0xe9, 0xd6, 0xb2}: "menu_seperator",
		efi.GUID{0x3f, 0xcf, 0xa4, 0xaf, 0x71, 0xaf, 0x30, 0x4c, 0xa4, 0xfb, 0x29, 0x10, 0xe7, 0x71, 0xf9, 0xb0}: "AmiNvmeControllerProtocolGuid",
		efi.GUID{0x3f, 0xe3, 0x76, 0x47, 0x47, 0xdb, 0x9a, 0x47, 0xa2, 0x5f, 0xa1, 0xcd, 0x0a, 0xfa, 0xb3, 0x8b}: "EfiKmsFormatAesxts128Guid",
		efi.GUID{0x3f, 0xe4, 0xeb, 0x4f, 0x6e, 0x25, 0x82, 0x4c, 0xa2, 0x0a, 0xbc, 0x0d, 0x03, 0xc7, 0x21, 0x85}: "PTN3460CfgPei",
		efi.GUID{0x3f, 0xe7, 0xb2, 0x9c, 0x25, 0x73, 0xf4, 0x40, 0xa4, 0x84, 0x65, 0x9b, 0xb3, 0x44, 0xc3, 0xcd}: "SgxPolicyStatusGuid",
		efi.GUID{0x3f, 0xec, 0x18, 0x56, 0xef, 0xa4, 0xed, 0x4e, 0x87, 0x59, 0x64, 0xee, 0xb7, 0x80, 0xb4, 0xbe}: "DellSetupD4Smm",
		efi.GUID{0x3f, 0xf5, 0xba, 0x29, 0x3e, 0xaa, 0x94, 0x45, 0xff, 0xff, 0xff, 0xff, 0x85, 0xa7, 0x37, 0x9c}: "XnotePlatformInfoDxe",
		efi.GUID{0x3f, 0xfc, 0x81, 0x33, 0x91, 0x87, 0xe5, 0x41, 0x88, 0x71, 0xa9, 0x60, 0xa4, 0xed, 0x24, 0xb7}: "MemoryInit",
		efi.GUID{0x3f, 0xfd, 0xcb, 0xad, 0xf8, 0x95, 0xe9, 0x4e, 0x9f, 0x1a, 0x6d, 0xa8, 0x26, 0x86, 0x2d, 0x4d}: "DiagnosticTestBIOSInterfaceSmm",
		efi.GUID{0x40, 0x16, 0xdf, 0x6b, 0xc1, 0xff, 0x89, 0x4c, 0xba, 0x76, 0x8d, 0xab, 0x23, 0x0e, 0x75, 0x0c}: "AsusModuleToIntPeiWrapper",
		efi.GUID{0x40, 0x17, 0x44, 0xe3, 0x41, 0x3b, 0x90, 0x4c, 0x9c, 0x9d, 0x96, 0x40, 0x56, 0xc7, 0x41, 0x7d}: "DxePciLibEsal",
		efi.GUID{0x40, 0x19, 0xb6, 0xd4, 0xab, 0x73, 0xa5, 0x48, 0x9e, 0x26, 0x53, 0xa4, 0xca, 0x4a, 0x2c, 0x37}: "DellDiagsSmm",
		efi.GUID{0x40, 0x19, 0xd7, 0x27, 0xf7, 0xd1, 0xf2, 0x40, 0xaa, 0x19, 0x18, 0xc2, 0xb0, 0x56, 0x44, 0x62}: "FjSysmanAmphionS3Resume",
		efi.GUID{0x40, 0x23, 0x49, 0x0f, 0xb3, 0x21, 0x23, 0x4e, 0x91, 0x40, 0x8c, 0x14, 0x47, 0x62, 0x92, 0xcd}: "SetupRepSetSmm",
		efi.GUID{0x40, 0x29, 0xfe, 0x15, 0x26, 0xb4, 0x9a, 0x47, 0xa0, 0x02, 0x54, 0x54, 0xa3, 0x4c, 0x7a, 0x6e}: "FlashMapBin",
		efi.GUID{0x40, 0x33, 0x3a, 0x04, 0xd0, 0x7c, 0x38, 0x43, 0xb7, 0xfe, 0x7a, 0x6a, 0xeb, 0x79, 0x0a, 0x28}: "HidKeyboardDxe",
		efi.GUID{0x40, 0x33, 0xbc, 0x5b, 0x22, 0x61, 0x25, 0x49, 0xbb, 0x48, 0x44, 0x33, 0x38, 0x99, 0xff, 0xec}: "AsusSecuredCorePC",
		efi.GUID{0x40, 0x3e, 0xa7, 0x37, 0x38, 0x4e, 0x36, 0x4e, 0x90, 0x45, 0xe9, 0xfc, 0xbc, 0xb7, 0x3b, 0xfe}: "FjRecoveryFlashDisplay",
		efi.GUID{0x40, 0x5b, 0x40, 0x72, 0xda, 0x38, 0xba, 0x4a, 0x92, 0x83, 0xca, 0x83, 0x21, 0xc2, 0x3e, 0x63}: "FvReportPei",
		efi.GUID{0x40, 0x63, 0xc4, 0xfe, 0x99, 0xca, 0xfe, 0x49, 0xbc, 0xca, 0xd0, 0x9f, 0xa6, 0x06, 0x4a, 0x4a}: "MrcHooksServicesPpi",
		efi.GUID{0x40, 0x67, 0x4f, 0xfa, 0x5a, 0xb9, 0xf9, 0x43, 0x90, 0xb5, 0x78, 0xd8, 0x14, 0x7c, 0x02, 0x19}: "LenovoSlp2Smm",
		efi.GUID{0x40, 0x6a, 0xf3, 0x4c, 0x26, 0x57, 0x67, 0x4a, 0xa9, 0x4c, 0x2c, 0xc8, 0x78, 0x22, 0xe7, 0x60}: "HpDtDxe",
		efi.GUID{0x40, 0x75, 0xec, 0xdf, 0xed, 0xb6, 0x5c, 0x42, 0x88, 0x3f, 0x9d, 0x8f, 0x3c, 0x85, 0x38, 0x4b}: "MemRas",
		efi.GUID{0x40, 0x76, 0x1b, 0xfc, 0x66, 0x34, 0x06, 0x4c, 0xb1, 0xcc, 0x1c, 0x93, 0x53, 0x94, 0xb5, 0xc2}: "PchSerialGpio",
		efi.GUID{0x40, 0x79, 0xd1, 0x19, 0x8d, 0xba, 0xa7, 0x4f, 0xa7, 0x04, 0xf3, 0x3d, 0x9f, 0xaf, 0xab, 0x9d}: "LibStringlist",
		efi.GUID{0x40, 0x81, 0xa8, 0xe4, 0x28, 0x8e, 0x1d, 0x46, 0x91, 0xbc, 0xa9, 0x0f, 0xf0, 0x15, 0x71, 0x7c}: "UsbOcUpdateDxeLightningRidgeEXRP",
		efi.GUID{0x40, 0x82, 0x4e, 0x8a, 0xf8, 0x74, 0x24, 0x40, 0xae, 0x2b, 0xb3, 0x92, 0x21, 0xc9, 0xfa, 0x59}: "NvOptimusSMM",
		efi.GUID{0x40, 0x84, 0x48, 0x86, 0xbb, 0x41, 0xc7, 0x42, 0x93, 0xac, 0x45, 0x0f, 0xbf, 0x77, 0x66, 0xbf}: "SystemBootMenuDxe",
		efi.GUID{0x40, 0x89, 0x2f, 0x3d, 0x50, 0xa8, 0x43, 0x45, 0xb2, 0x94, 0x9b, 0x0b, 0xd0, 0xe7, 0x50, 0xc7}: "HstiDxe",
		efi.GUID{0x40, 0x96, 0x19, 0xc2, 0xc0, 0x29, 0x0a, 0x4f, 0x99, 0x0c, 0x71, 0xbf, 0x9b, 0x14, 0x43, 0x0d}: "DellSfpDxe",
		efi.GUID{0x40, 0x9d, 0xc7, 0x60, 0xfa, 0x74, 0xc4, 0x4d, 0xa6, 0x54, 0x14, 0xc3, 0x2e, 0x2e, 0x21, 0x7c}: "FjFirmwareOnlineUpdate",
		efi.GUID{0x40, 0xa3, 0x47, 0x51, 0x75, 0x1b, 0xf4, 0x43, 0xba, 0x0f, 0x46, 0x39, 0x3d, 0x69, 0x7f, 0xd4}: "FjGabiSettingsSmm",
		efi.GUID{0x40, 0xa8, 0x09, 0x10, 0x25, 0xc6, 0xb3, 0x42, 0xa9, 0x4b, 0xb9, 0x0f, 0x99, 0x1b, 0x1b, 0x1a}: "NhltInstallTable",
		efi.GUID{0x40, 0xa9, 0x95, 0x0c, 0x06, 0xa0, 0xd4, 0x11, 0xbc, 0xfa, 0x00, 0x80, 0xc7, 0x3c, 0x88, 0x81}: "WinNtBusDriverDxe",
		efi.GUID{0x40, 0xab, 0xbe, 0x40, 0xce, 0xce, 0x09, 0x49, 0xb1, 0x33, 0x20, 0xa4, 0x13, 0xae, 0x19, 0xe9}: "CpuMpDxe",
		efi.GUID{0x40, 0xb3, 0x23, 0xaf, 0xb4, 0x97, 0x85, 0x46, 0x8d, 0x4f, 0xa3, 0xf2, 0x81, 0x69, 0xb2, 0x1d}: "EdkiiVarCheckProtocolGuid",
		efi.GUID{0x40, 0xb5, 0xdb, 0x03, 0x86, 0xe1, 0x15, 0x46, 0x8a, 0x7f, 0xa4, 0x27, 0x86, 0x3b, 0x4e, 0x56}: "PoofAnimationState1",
		efi.GUID{0x40, 0xc3, 0x48, 0x14, 0x02, 0x02, 0x11, 0x47, 0x9c, 0x4b, 0x2d, 0x06, 0x3a, 0xa6, 0x47, 0x5b}: "ProgressBarEmptyLeftEndcap",
		efi.GUID{0x40, 0xcf, 0xee, 0x66, 0x12, 0x63, 0x1a, 0x4a, 0xa8, 0x3a, 0xb3, 0xb2, 0xf8, 0xd8, 0xa7, 0x1a}: "LenovoVariableDxe",
		efi.GUID{0x40, 0xd2, 0x8a, 0xf2, 0xb8, 0x3d, 0x09, 0x48, 0xb6, 0xf9, 0x68, 0x41, 0x12, 0x9f, 0xb2, 0x3a}: "FjNvramVariablesAccessReferenceSmm",
		efi.GUID{0x40, 0xda, 0xf8, 0xed, 0xd1, 0xaa, 0xdf, 0x11, 0xa1, 0xf4, 0x00, 0x02, 0xa5, 0xd5, 0xc5, 0x1b}: "PL341Dmc",
		efi.GUID{0x40, 0xe1, 0x19, 0xb2, 0xfc, 0xdf, 0xe3, 0x11, 0xb9, 0x56, 0x00, 0x22, 0x68, 0x1e, 0x69, 0x06}: "DnsDxe",
		efi.GUID{0x40, 0xec, 0x35, 0x47, 0xb8, 0xf0, 0x02, 0x41, 0xa4, 0xc1, 0x2e, 0x83, 0xb6, 0xb0, 0xc0, 0xbd}: "FchHuashanDxe",
		efi.GUID{0x40, 0xec, 0xa2, 0xc0, 0xa9, 0x7c, 0xf7, 0x4f, 0xa1, 0x7c, 0x08, 0xb8, 0x1d, 0x70, 0xde, 0x80}: "ECSmmFramework",
		efi.GUID{0x40, 0xf0, 0xe4, 0xd9, 0xd0, 0xb4, 0x26, 0x4c, 0x84, 0x00, 0xb1, 0xd9, 0x1b, 0x75, 0x6b, 0x77}: "IteOnlyPei",
		efi.GUID{0x40, 0xf1, 0x50, 0x06, 0x9a, 0x43, 0x4f, 0x2d, 0x98, 0x07, 0xc9, 0x26, 0x69, 0x33, 0x93, 0x99}: "AppleEvent",
		efi.GUID{0x40, 0xfd, 0x55, 0x85, 0x0b, 0x14, 0x3c, 0x4f, 0x90, 0x5e, 0x3b, 0xf3, 0x78, 0xa0, 0x99, 0xfa}: "EfiActiveManagementProtocol",
		efi.GUID{0x41, 0x02, 0x39, 0x93, 0x4d, 0x7d, 0x86, 0x49, 0x8a, 0x06, 0xd4, 0x6c, 0x98, 0x2f, 0x5e, 0xcd}: "CrystalRidgePeim",
		efi.GUID{0x41, 0x02, 0x5b, 0xe0, 0x68, 0x2f, 0xb4, 0x4d, 0x8a, 0xdf, 0x57, 0x60, 0xde, 0x2e, 0x15, 0x70}: "TpmFwUpdateDxe",
		efi.GUID{0x41, 0x12, 0x54, 0xe4, 0x97, 0x88, 0x1a, 0x41, 0x91, 0xf8, 0x7d, 0x7e, 0x45, 0x83, 0x71, 0x46}: "BaseSerialPortLibNull",
		efi.GUID{0x41, 0x1c, 0xaa, 0xfb, 0x48, 0xed, 0xaa, 0x4e, 0x98, 0xad, 0x7a, 0x3f, 0x95, 0xb4, 0x79, 0x15}: "InstallD01MsftDxe",
		efi.GUID{0x41, 0x1f, 0x81, 0x10, 0x7e, 0x03, 0xbe, 0x4e, 0x98, 0x72, 0x77, 0x1d, 0x76, 0x46, 0xff, 0xfa}: "LEMSAPAMLock",
		efi.GUID{0x41, 0x2e, 0x64, 0xb8, 0x50, 0xd3, 0xff, 0x4b, 0x9d, 0xec, 0x49, 0x40, 0xf1, 0x5c, 0xd6, 0xe5}: "nfa765x64",
		efi.GUID{0x41, 0x2e, 0xb0, 0x9f, 0x22, 0x2f, 0x41, 0x4f, 0xb9, 0x26, 0x85, 0x0b, 0x7d, 0x7c, 0x2a, 0x5b}: "DellAutoBifurcateSiDxe",
		efi.GUID{0x41, 0x3a, 0x7c, 0xc7, 0xab, 0x61, 0x43, 0x41, 0x98, 0x3e, 0x33, 0x39, 0x28, 0x06, 0x28, 0xe5}: "EdkiiCpuFeaturesInitDone",
		efi.GUID{0x41, 0x44, 0xc1, 0xb7, 0xa2, 0xac, 0x7f, 0x4f, 0x8a, 0xb1, 0x47, 0xb9, 0xc8, 0x86, 0x35, 0xa9}: "DashIoCfgSmm",
		efi.GUID{0x41, 0x4f, 0xeb, 0x88, 0x74, 0xe5, 0x44, 0x41, 0x9c, 0x93, 0x79, 0x48, 0x5b, 0x11, 0x09, 0x10}: "DellCoreServiceHWIDDxe",
		efi.GUID{0x41, 0x52, 0x92, 0x48, 0xed, 0xd2, 0xd4, 0x46, 0x8a, 0x87, 0xa1, 0x8d, 0x15, 0x3c, 0x28, 0x02}: "SmmOemEeprom",
		efi.GUID{0x41, 0x53, 0x81, 0xed, 0x7f, 0xe6, 0xc4, 0x46, 0x9d, 0xed, 0xaa, 0x14, 0x22, 0x28, 0x03, 0xc4}: "WakeOnLanSmm",
		efi.GUID{0x41, 0x59, 0x01, 0xa0, 0xa1, 0x01, 0x46, 0x41, 0xb1, 0x01, 0xb1, 0xbb, 0x05, 0xd8, 0x63, 0x1c}: "EfiEvPpi",
		efi.GUID{0x41, 0x5d, 0x74, 0x4f, 0x98, 0x55, 0xf0, 0x4c, 0x8a, 0x0a, 0x92, 0x38, 0x13, 0xdf, 0x95, 0x54}: "SmmUsbMassStorage",
		efi.GUID{0x41, 0x5d, 0x74, 0x4f, 0x98, 0x55, 0xf0, 0x4c, 0x8a, 0x0a, 0x92, 0x38, 0x13, 0xdf, 0x95, 0x55}: "M2Smm",
		efi.GUID{0x41, 0x5d, 0x74, 0x4f, 0x98, 0x55, 0xf0, 0x4c, 0x8a, 0x0a, 0x92, 0x38, 0x13, 0xdf, 0x95, 0x56}: "SmmCsm",
		efi.GUID{0x41, 0x6b, 0x96, 0xf0, 0x3f, 0xc2, 0xb9, 0x41, 0x96, 0x04, 0x0f, 0xf7, 0xe1, 0x11, 0x96, 0x5a}: "EdkiiPlatformHasAcpi",
		efi.GUID{0x41, 0x85, 0x2d, 0x50, 0xbe, 0x01, 0xb3, 0x4f, 0x89, 0x86, 0x3f, 0x99, 0x16, 0x54, 0x81, 0x64}: "DellTpmSmm",
		efi.GUID{0x41, 0x8b, 0x44, 0x08, 0x83, 0x7f, 0xbe, 0x49, 0x82, 0xa7, 0x0e, 0x84, 0x79, 0x0a, 0xb1, 0x33}: "LePassKeyDeviceManager",
		efi.GUID{0x41, 0x8e, 0xcc, 0xa9, 0xc1, 0x4b, 0x1a, 0x4d, 0x8e, 0x0c, 0xc7, 0x21, 0xdd, 0xfc, 0xe8, 0x81}: "H19VariableLock",
		efi.GUID{0x41, 0x92, 0x11, 0x17, 0x53, 0x11, 0x0d, 0x97, 0x65, 0x09, 0x75, 0xdc, 0xdf, 0xa4, 0x17, 0x74}: "SbSocRavenDxe",
		efi.GUID{0x41, 0x92, 0x28, 0x6c, 0x40, 0xe2, 0x3f, 0x48, 0x9e, 0x3e, 0x87, 0x2c, 0x03, 0x96, 0xb5, 0x99}: "FlashSmiSmm",
		efi.GUID{0x41, 0x94, 0x11, 0xa7, 0x53, 0xe1, 0x0d, 0x97, 0x55, 0x08, 0x75, 0xdc, 0xdf, 0xa4, 0x19, 0x74}: "SbSocSummitDxe",
		efi.GUID{0x41, 0x95, 0xb1, 0x45, 0x75, 0xe8, 0xf7, 0x48, 0xab, 0x36, 0xa6, 0x46, 0xbd, 0x4a, 0xd4, 0x5b}: "HpPlatformInfoDxe",
		efi.GUID{0x41, 0x9a, 0x4c, 0x8c, 0x56, 0xbf, 0x27, 0x46, 0x9e, 0x0a, 0xc8, 0x38, 0x6d, 0x66, 0x11, 0x5c}: "EfiTcgPlatformProtocolGuid",
		efi.GUID{0x41, 0x9c, 0x44, 0xea, 0x36, 0x82, 0x97, 0x4b, 0x9f, 0xf9, 0x08, 0x4e, 0x4b, 0xa7, 0x00, 0x20}: "ProgressBarEmptyMiddle",
		efi.GUID{0x41, 0x9c, 0x70, 0x4b, 0x66, 0x20, 0x84, 0x46, 0xa9, 0x2a, 0xcf, 0xae, 0x7c, 0x75, 0x63, 0xfc}: "UpdateMsrSmi",
		efi.GUID{0x41, 0x9d, 0x98, 0x0c, 0xb4, 0xf4, 0x44, 0x42, 0x9d, 0x7f, 0xe9, 0xff, 0xb4, 0x16, 0x32, 0x73}: "FastBootOption",
		efi.GUID{0x41, 0xa1, 0xdd, 0x05, 0xfa, 0x2d, 0xbb, 0x48, 0xb0, 0x9d, 0xd9, 0x22, 0x34, 0x49, 0x47, 0xfe}: "ApobZpRvPei",
		efi.GUID{0x41, 0xa8, 0x9b, 0x4c, 0x69, 0x0a, 0x67, 0x45, 0x9e, 0x37, 0x42, 0xcb, 0xf5, 0xf7, 0xf2, 0x69}: "OemGlobalNvsDxe",
		efi.GUID{0x41, 0xa9, 0xd9, 0x4c, 0xf5, 0xce, 0x40, 0x49, 0x9c, 0x1c, 0xc5, 0xc3, 0x3c, 0x27, 0x02, 0x4b}: "ODMPowerLedProtocol",
		efi.GUID{0x41, 0xad, 0xa3, 0x3c, 0xc5, 0x6d, 0x38, 0x43, 0x9c, 0x0f, 0x5c, 0x6a, 0x25, 0xd2, 0xf5, 0x97}: "HpBcuPreserveDataDxe",
		efi.GUID{0x41, 0xc1, 0x33, 0xb7, 0x8f, 0xe8, 0x86, 0x47, 0x94, 0xaf, 0x8b, 0x87, 0xbc, 0x48, 0x67, 0xfe}: "PttSsdtAcpiTableGuid",
		efi.GUID{0x41, 0xc7, 0x74, 0x5b, 0x5f, 0x4a, 0x8e, 0x4a, 0xb6, 0x89, 0xd8, 0x04, 0xab, 0x43, 0x68, 0xfd}: "DxeRealtekCrcInit",
		efi.GUID{0x41, 0xc7, 0x74, 0xcc, 0x5f, 0x4a, 0x8e, 0x4a, 0xb6, 0x89, 0xd8, 0x04, 0xab, 0x43, 0x68, 0xcc}: "DxeNotifyEC",
		efi.GUID{0x41, 0xc9, 0xce, 0xa8, 0x87, 0xcd, 0xb7, 0x4a, 0x98, 0x0c, 0x4c, 0x77, 0xc3, 0x3b, 0xf3, 0xba}: "ImcErrorHandler",
		efi.GUID{0x41, 0xcc, 0x2a, 0x1e, 0x6a, 0xe2, 0x3d, 0x48, 0xaf, 0xc7, 0xa0, 0x56, 0xc3, 0x4e, 0x08, 0x7b}: "EfiPlatformInfoGuid",
		efi.GUID{0x41, 0xcc, 0x2a, 0x1e, 0x6a, 0xe2, 0x3d, 0x48, 0xaf, 0xc7, 0xa0, 0x56, 0xc3, 0x4e, 0x08, 0x7c}: "EfiNorthPeakGuid",
		efi.GUID{0x41, 0xd0, 0x26, 0xd3, 0x31, 0xbd, 0x01, 0x4c, 0xb5, 0xa8, 0x62, 0x8b, 0xe8, 0x7f, 0x06, 0x53}: "EfiSmmFirmwareVolumeBlockProtocolGuid",
		efi.GUID{0x41, 0xd3, 0xf8, 0x49, 0x9b, 0x33, 0x88, 0x4e, 0xa1, 0xcc, 0x7f, 0xfd, 0x00, 0x34, 0x3c, 0x59}: "DellS3ResumeStatusCodePei",
		efi.GUID{0x41, 0xda, 0x99, 0x33, 0x44, 0xce, 0xdd, 0x4f, 0x8d, 0x32, 0xe5, 0x78, 0x38, 0x1f, 0xeb, 0xe0}: "menu_bottom_right",
		efi.GUID{0x41, 0xde, 0x05, 0x1b, 0x3b, 0xc9, 0xb4, 0x4b, 0xad, 0x47, 0x2a, 0x78, 0xac, 0x0f, 0xc9, 0xe4}: "HstiProtocolGuid",
		efi.GUID{0x41, 0xde, 0xbf, 0xaf, 0x6e, 0x2e, 0x62, 0x42, 0xba, 0x65, 0x62, 0xb9, 0x23, 0x6e, 0x54, 0x95}: "EfiTimestampProtocolGuid",
		efi.GUID{0x41, 0xee, 0x4d, 0x02, 0xe7, 0x33, 0xd3, 0x11, 0x9d, 0x69, 0x00, 0x08, 0xc7, 0x81, 0xf3, 0x9f}: "EfiPartTypeLegacyMbrGuid",
		efi.GUID{0x41, 0xf0, 0x59, 0x2d, 0xa4, 0x53, 0xd0, 0x40, 0xa6, 0xcd, 0x84, 0x4d, 0xc0, 0xdf, 0xef, 0x17}: "SmmS3SaveState",
		efi.GUID{0x41, 0xff, 0x7d, 0xd8, 0xe5, 0x21, 0xa6, 0x44, 0x97, 0x8b, 0x80, 0x78, 0x6a, 0xb9, 0x72, 0x29}: "DellPermanentDevicePolicySmm",
		efi.GUID{0x42, 0x00, 0xe7, 0x24, 0xc5, 0xd5, 0x60, 0x42, 0x8c, 0x39, 0x0a, 0xd3, 0xaa, 0x32, 0xe9, 0x3d}: "EfiSmmEndOfDxeProtocolGuid",
		efi.GUID{0x42, 0x04, 0x61, 0xa3, 0x9f, 0xe6, 0xf3, 0x4d, 0x82, 0xca, 0x23, 0x60, 0xc4, 0x03, 0x1a, 0x23}: "ReportStatusCodeRouterPei",
		efi.GUID{0x42, 0x0b, 0x36, 0xb2, 0x73, 0x71, 0x0a, 0x42, 0x86, 0x96, 0x46, 0xca, 0x6b, 0xab, 0x10, 0x60}: "MeasuredFvHobGuid",
		efi.GUID{0x42, 0x10, 0x31, 0xff, 0x7a, 0x1c, 0x69, 0x47, 0x80, 0x85, 0x93, 0x68, 0x61, 0x79, 0xe4, 0x37}: "MeIgnitionDxe",
		efi.GUID{0x42, 0x11, 0xb0, 0xbf, 0x61, 0x30, 0xa4, 0x48, 0x92, 0x2f, 0x9d, 0x24, 0x6e, 0x20, 0x11, 0x20}: "AmiTcgResetVarHobGuid",
		efi.GUID{0x42, 0x14, 0x5e, 0x32, 0xe1, 0x9b, 0x8b, 0x49, 0xb0, 0x07, 0xbf, 0x4c, 0x38, 0xbd, 0xb0, 0xec}: "FpgaInitPpi",
		efi.GUID{0x42, 0x2c, 0x82, 0x11, 0xe4, 0x79, 0xc9, 0x48, 0x9f, 0x73, 0x70, 0x0d, 0x35, 0x56, 0xb0, 0xc0}: "MyAsusAutoInstallItem",
		efi.GUID{0x42, 0x32, 0xa8, 0xe4, 0xee, 0xde, 0x2e, 0xf1, 0x15, 0xff, 0x01, 0x02, 0x03, 0x6c, 0xc3, 0xce}: "OneKeyLabel",
		efi.GUID{0x42, 0x35, 0x00, 0xee, 0x56, 0xf1, 0x27, 0x49, 0x84, 0x55, 0xf6, 0x76, 0x20, 0x52, 0xe3, 0x2f}: "SiInitDxe",
		efi.GUID{0x42, 0x43, 0x17, 0x49, 0x08, 0x71, 0x9b, 0x40, 0x8b, 0xbe, 0x65, 0xfd, 0xa8, 0x53, 0x89, 0xf5}: "SmiHandlerProfile",
		efi.GUID{0x42, 0x43, 0x9c, 0xb3, 0x6d, 0xf6, 0xc6, 0x40, 0x85, 0xb4, 0xb5, 0x29, 0xde, 0x7b, 0x6a, 0x64}: "UpdateRandomNum",
		efi.GUID{0x42, 0x4b, 0x9f, 0x58, 0x05, 0xa9, 0xe0, 0x11, 0x82, 0x64, 0x08, 0x00, 0x20, 0x0c, 0x9a, 0x66}: "SctMilestoneTaskProtocol",
		efi.GUID{0x42, 0x51, 0x96, 0x30, 0x5a, 0xfc, 0x6e, 0x4e, 0x94, 0xdb, 0xbb, 0xa4, 0x41, 0xb3, 0x68, 0x51}: "AmiPciOpromDataProtocol",
		efi.GUID{0x42, 0x54, 0xf7, 0x04, 0x93, 0xa5, 0x81, 0x42, 0xbd, 0x4b, 0x09, 0x59, 0x35, 0xb7, 0xd2, 0xf8}: "wifi_1bar",
		efi.GUID{0x42, 0x55, 0xf2, 0xc5, 0x79, 0x2a, 0x26, 0x4a, 0x81, 0xbb, 0x4e, 0xa6, 0x32, 0x33, 0xb3, 0x09}: "EdkiiNonDiscoverableNvmeDeviceGuid",
		efi.GUID{0x42, 0x69, 0x0d, 0x82, 0x3f, 0xb1, 0x91, 0x4b, 0xaf, 0x2c, 0x77, 0x40, 0x25, 0xd8, 0x4a, 0x22}: "DellAutoBifurcateSiSmm",
		efi.GUID{0x42, 0x6c, 0x35, 0xf8, 0xa6, 0x4b, 0x6f, 0x70, 0x59, 0xe9, 0xa9, 0xb1, 0xaf, 0xf2, 0xbc, 0xd8}: "AmdPlatformRasSspSmm",
		efi.GUID{0x42, 0x6c, 0x74, 0xe0, 0xf9, 0xd3, 0x8b, 0x4f, 0xb2, 0x11, 0x14, 0x10, 0x95, 0x7b, 0x9f, 0xf5}: "BootOption",
		efi.GUID{0x42, 0x6e, 0x60, 0x1c, 0x67, 0xf2, 0x2f, 0x4a, 0x95, 0xea, 0xa0, 0x81, 0xb6, 0x2e, 0x3f, 0x4b}: "H19CheckPointHddService",
		efi.GUID{0x42, 0x73, 0x04, 0xa1, 0xba, 0xbd, 0xae, 0x4d, 0xa6, 0x7a, 0x40, 0x97, 0x9b, 0x65, 0xc7, 0xf8}: "EfiSocketPowermanagementVar",
		efi.GUID{0x42, 0x86, 0xd8, 0xf9, 0x37, 0x07, 0xbc, 0x49, 0x81, 0xb5, 0x68, 0x89, 0xcd, 0x57, 0xd9, 0xea}: "SmbiosDxe",
		efi.GUID{0x42, 0x88, 0x0d, 0x7c, 0xd7, 0xb2, 0x06, 0x4e, 0x86, 0x3d, 0xf8, 0x42, 0x18, 0x01, 0x3b, 0xc7}: "LenovoPttPolicyDxe",
		efi.GUID{0x42, 0x91, 0x67, 0x43, 0xc4, 0x87, 0xad, 0x44, 0xaf, 0x02, 0xb4, 0x7f, 0x78, 0x2d, 0x6c, 0xf3}: "PeiIpmiLibIpmiPpi",
		efi.GUID{0x42, 0x95, 0x6d, 0xfb, 0x2d, 0x61, 0x45, 0x4f, 0x87, 0x2f, 0x5c, 0xff, 0x52, 0xe9, 0x3d, 0xcf}: "EfiPeiRecoveryModulePpiGuid",
		efi.GUID{0x42, 0x97, 0xb9, 0xb3, 0x07, 0xbe, 0xe9, 0x4c, 0xa1, 0xaf, 0xb3, 0x6a, 0xd9, 0x3d, 0x74, 0xb4}: "FjIbvNvramGateReferenceSmm",
		efi.GUID{0x42, 0x9d, 0xab, 0xa2, 0x7a, 0x96, 0xb3, 0x45, 0x95, 0x07, 0x28, 0xcc, 0xc7, 0x02, 0x1f, 0x51}: "UnknownBoot",
		efi.GUID{0x42, 0x9d, 0xd5, 0xbf, 0x0f, 0xfe, 0x51, 0x42, 0xb7, 0x72, 0x4b, 0x09, 0x8a, 0x1a, 0xec, 0x85}: "ActiveBios",
		efi.GUID{0x42, 0xa0, 0x61, 0x23, 0xda, 0xf0, 0x06, 0x40, 0xb3, 0xc1, 0x3a, 0x13, 0x0f, 0xae, 0x8d, 0xf0}: "I2cTouchPanel",
		efi.GUID{0x42, 0xa3, 0xd5, 0x9f, 0x77, 0x71, 0x37, 0x48, 0x95, 0xa5, 0x34, 0xe0, 0x80, 0xa8, 0x32, 0x8c}: "TxtDxe",
		efi.GUID{0x42, 0xa6, 0x4a, 0x03, 0xb0, 0x91, 0x60, 0x41, 0xa0, 0xf7, 0xd3, 0x1a, 0x28, 0xe0, 0x13, 0xcb}: "H19DisplayControl",
		efi.GUID{0x42, 0xaa, 0x0d, 0xc4, 0x1d, 0x6e, 0x6f, 0x4f, 0x96, 0xf0, 0x5e, 0x17, 0xbc, 0x8a, 0x1d, 0x4b}: "AmiHeciDeliverRuntimeDxe",
		efi.GUID{0x42, 0xb4, 0xd7, 0xe2, 0x13, 0x84, 0xb8, 0x45, 0x92, 0x8c, 0xc7, 0x7d, 0xee, 0xe2, 0x5d, 0x4a}: "FjGpioAbstractionReferencePei",
		efi.GUID{0x42, 0xb7, 0xf0, 0x0a, 0xec, 0x63, 0xbd, 0x45, 0x8d, 0xb6, 0x71, 0xad, 0x7f, 0x2f, 0xe8, 0xe8}: "ShellDriver1HiiGuid",
		efi.GUID{0x42, 0xb8, 0xc2, 0xd2, 0xb0, 0x46, 0x66, 0x44, 0x88, 0xb8, 0x5a, 0x82, 0x85, 0xe9, 0xce, 0xc2}: "IScsiFontSupport",
		efi.GUID{0x42, 0xbe, 0xaa, 0xc1, 0xa8, 0x2c, 0x61, 0x43, 0xb3, 0x7a, 0x14, 0x66, 0x52, 0x0e, 0x96, 0x0e}: "FjNvsAreaRt",
		efi.GUID{0x42, 0xc0, 0x0c, 0x50, 0x00, 0xe3, 0x59, 0x47, 0x92, 0x11, 0x86, 0x8b, 0x9a, 0xd0, 0xe2, 0x07}: "FjUIDxe",
		efi.GUID{0x42, 0xc0, 0xb6, 0x12, 0x62, 0x7c, 0x66, 0x46, 0xa4, 0x72, 0x89, 0xed, 0x51, 0x33, 0xa9, 0x8c}: "FjIbvInterexchangeDataStorageProtocolSmm",
		efi.GUID{0x42, 0xc5, 0x43, 0xe1, 0xc4, 0x4f, 0xd9, 0x4d, 0x99, 0xf2, 0x75, 0x71, 0x5c, 0x44, 0xe4, 0x1c}: "IePolicyInitDxe",
		efi.GUID{0x42, 0xc5, 0x87, 0xbd, 0xff, 0x9c, 0x4a, 0x4d, 0xa8, 0x90, 0x02, 0xb6, 0xaf, 0x98, 0x6f, 0x34}: "PeiOverClock",
		efi.GUID{0x42, 0xc5, 0x88, 0x1d, 0xf7, 0x9d, 0x4a, 0x42, 0xaa, 0x90, 0x02, 0xb6, 0x1f, 0x28, 0x69, 0x38}: "WdtPei",
		efi.GUID{0x42, 0xcf, 0xb6, 0x6d, 0x3c, 0x0a, 0xc9, 0x4b, 0x97, 0xdb, 0x9c, 0xed, 0x03, 0xb7, 0xf1, 0x8d}: "DellHotKeySmmProtocol",
		efi.GUID{0x42, 0xd3, 0xae, 0x37, 0x52, 0x1f, 0xa3, 0x44, 0x8d, 0xba, 0xef, 0x2b, 0xdd, 0xf4, 0x71, 0xd5}: "GabiSettingAbstractionSmm",
		efi.GUID{0x42, 0xd6, 0x3a, 0x61, 0x48, 0x6a, 0x88, 0x4e, 0x90, 0x05, 0x28, 0x76, 0x93, 0x60, 0xbe, 0x73}: "LenovoSplash2Protocol",
		efi.GUID{0x42, 0xda, 0x37, 0x4d, 0x0c, 0x3a, 0xda, 0x4e, 0xb9, 0xeb, 0xbc, 0x0e, 0x1d, 0xb4, 0x71, 0x3b}: "PpisNeededByDxeCorePei",
		efi.GUID{0x42, 0xe7, 0xd7, 0x9f, 0xb4, 0xac, 0x6b, 0x4c, 0x9d, 0x16, 0x91, 0xb3, 0x63, 0x85, 0x82, 0x53}: "HeciControlDxe",
		efi.GUID{0x42, 0xe9, 0x8d, 0x65, 0xce, 0x03, 0xa3, 0x43, 0x89, 0x1d, 0x46, 0x42, 0x3c, 0x53, 0x45, 0xbc}: "DellMfgSmm",
		efi.GUID{0x42, 0xf3, 0x1f, 0xaa, 0x68, 0x89, 0x70, 0x4c, 0x88, 0x2b, 0x9e, 0x46, 0xde, 0x9e, 0x4e, 0x78}: "OemSsidDataUpdateDxe",
		efi.GUID{0x42, 0xf7, 0xdf, 0x59, 0x58, 0x78, 0xb0, 0x42, 0x8d, 0x5b, 0x12, 0xc2, 0xad, 0x00, 0x3d, 0x6c}: "MrcOemHooksPpi",
		efi.GUID{0x42, 0xfc, 0x2b, 0x7f, 0xde, 0x9b, 0x9d, 0x4e, 0xbe, 0x83, 0x1b, 0xb7, 0x52, 0xdf, 0x0c, 0x3a}: "SystemBiosSelfHealingPei",
		efi.GUID{0x42, 0xfe, 0x49, 0x71, 0x1e, 0x01, 0x93, 0x4e, 0x98, 0xd8, 0xd2, 0x48, 0x69, 0xb7, 0x03, 0x1f}: "I2cMasterPeim",
		efi.GUID{0x42, 0xfe, 0x8c, 0xb3, 0xa2, 0xf0, 0xa5, 0x40, 0x8f, 0x95, 0xea, 0xe7, 0x1d, 0x32, 0xb5, 0xd3}: "RtHooks",
		efi.GUID{0x43, 0x02, 0x31, 0x46, 0x03, 0x7b, 0x32, 0x41, 0xbe, 0x44, 0x22, 0x43, 0xfa, 0xca, 0x7c, 0xdd}: "CMDB",
		efi.GUID{0x43, 0x05, 0xb9, 0xed, 0x1b, 0x66, 0xbd, 0x4c, 0x92, 0x78, 0xd8, 0x8b, 0x4c, 0x60, 0x8b, 0xe9}: "DellIntrusionDetectDxe",
		efi.GUID{0x43, 0x13, 0x1f, 0x27, 0xd6, 0x20, 0x14, 0x4e, 0x9b, 0x62, 0x3c, 0x02, 0x97, 0xf5, 0x6f, 0x07}: "SmmPowerManagement",
		efi.GUID{0x43, 0x16, 0xb2, 0x6d, 0x1a, 0x24, 0xc9, 0x4c, 0x82, 0xdd, 0x46, 0xa1, 0xe4, 0x84, 0x5e, 0xcc}: "StrongPasswordPoliciesSync",
		efi.GUID{0x43, 0x24, 0x64, 0xd7, 0xb7, 0x87, 0x32, 0x48, 0x96, 0x07, 0x0e, 0x1e, 0xa8, 0x1c, 0x1d, 0x86}: "AmiRomLayoutHob",
		efi.GUID{0x43, 0x35, 0xf6, 0x56, 0xfb, 0xa9, 0x32, 0x44, 0xaa, 0x6d, 0x44, 0x82, 0x70, 0x05, 0xb7, 0x4a}: "Lily_RTLWlanbin",
		efi.GUID{0x43, 0x3b, 0x0f, 0x0c, 0xde, 0x44, 0x07, 0x49, 0xb4, 0x78, 0x22, 0x5f, 0x6f, 0x62, 0x89, 0xdc}: "UsbKeyboardLayoutPackageGuid",
		efi.GUID{0x43, 0x3f, 0xb1, 0xfa, 0x42, 0xbf, 0x0e, 0x45, 0xb6, 0x95, 0xa3, 0x54, 0x79, 0xa9, 0xd6, 0x42}: "DellPowerOffPolicy",
		efi.GUID{0x43, 0x48, 0x7d, 0x78, 0xac, 0x68, 0x28, 0x4c, 0xbe, 0x53, 0xba, 0xc2, 0x72, 0xba, 0xec, 0xf9}: "DellVariable2RuntimeDxe",
		efi.GUID{0x43, 0x4b, 0x11, 0xbc, 0xb4, 0x8c, 0xc6, 0x4f, 0x86, 0x2f, 0xfe, 0x22, 0x6b, 0xad, 0x05, 0x0e}: "HpRpsuSetupDxe",
		efi.GUID{0x43, 0x53, 0x68, 0xc1, 0x19, 0xee, 0xaf, 0x4b, 0xb4, 0x7d, 0x5c, 0x99, 0x5d, 0xf7, 0xfa, 0x2f}: "StaticSkuDataDxeEVB",
		efi.GUID{0x43, 0x57, 0xa0, 0xb5, 0x71, 0x9b, 0x9b, 0x48, 0xa0, 0xed, 0xa0, 0xeb, 0x39, 0x50, 0xd2, 0x3b}: "SecPeiDxeTimerLibCpu",
		efi.GUID{0x43, 0x59, 0x68, 0x92, 0x10, 0xd8, 0xff, 0x47, 0xa1, 0x12, 0xcc, 0x84, 0x90, 0x77, 0x6a, 0x1f}: "CORE_PEI",
		efi.GUID{0x43, 0x62, 0x42, 0x4d, 0x19, 0xbb, 0x62, 0x4f, 0x9d, 0x37, 0xa6, 0xd9, 0x2d, 0xcc, 0x26, 0x28}: "SmbiosOverride",
		efi.GUID{0x43, 0x63, 0x1e, 0x6f, 0xb6, 0xdc, 0x09, 0x41, 0xa5, 0xb6, 0x20, 0xf5, 0x33, 0x80, 0x62, 0x29}: "RtkUefiLan",
		efi.GUID{0x43, 0x77, 0xd5, 0x3d, 0x56, 0xca, 0x9a, 0x42, 0xb6, 0x4f, 0x77, 0xde, 0x88, 0xf8, 0xac, 0xf6}: "RecoveryBackup",
		efi.GUID{0x43, 0x83, 0x27, 0x9e, 0xa3, 0x9b, 0x8c, 0x4e, 0x8d, 0x54, 0x5d, 0xf0, 0x4a, 0x99, 0xaf, 0xf8}: "AsusTCG2InfoSetupItem",
		efi.GUID{0x43, 0x88, 0xe3, 0x6f, 0x00, 0x65, 0xc2, 0x42, 0xa5, 0x35, 0x77, 0x69, 0xde, 0xa5, 0x6a, 0xa4}: "FpgaLoaderPeim",
		efi.GUID{0x43, 0x8f, 0xe5, 0xb4, 0x0a, 0x73, 0xd7, 0x46, 0xb1, 0x5f, 0x1e, 0x06, 0x20, 0x3e, 0xfc, 0x28}: "BxtRefCodePkgTokenSpaceGuid",
		efi.GUID{0x43, 0x90, 0x43, 0x8c, 0xca, 0x85, 0x7a, 0x46, 0x96, 0xf1, 0xcb, 0x14, 0xf4, 0xd0, 0xdc, 0xda}: "LegacyRegionDxe",
		efi.GUID{0x43, 0x99, 0xb7, 0x5d, 0x75, 0xda, 0x5e, 0x41, 0x92, 0x82, 0x74, 0x47, 0x1a, 0xa2, 0xcf, 0xaa}: "CmosWarningPageUp",
		efi.GUID{0x43, 0x9a, 0x1c, 0x08, 0x1f, 0x43, 0x5d, 0x47, 0xb8, 0x4c, 0x93, 0xad, 0x67, 0x14, 0xb8, 0x0c}: "DiskIdm",
		efi.GUID{0x43, 0x9b, 0x14, 0xc5, 0x85, 0xae, 0x53, 0x4f, 0x99, 0x82, 0xb9, 0x43, 0x35, 0xd3, 0xa9, 0xe7}: "EfiRngAlgorithmSp80090Hmac256Guid",
		efi.GUID{0x43, 0x9e, 0x7a, 0xa3, 0x77, 0x90, 0x39, 0x45, 0x9b, 0x90, 0xbd, 0x71, 0x9b, 0x03, 0x2b, 0x23}: "SpiControllerDxe",
		efi.GUID{0x43, 0xae, 0xe2, 0x90, 0xae, 0x90, 0x79, 0x46, 0x6e, 0xdf, 0xbe, 0xa8, 0x1d, 0x4d, 0xc8, 0xac}: "HpRtcInitPei",
		efi.GUID{0x43, 0xb2, 0xd4, 0xdf, 0x30, 0x04, 0x9d, 0x42, 0x82, 0x9a, 0xca, 0x2b, 0xab, 0x3f, 0xe7, 0xa6}: "AuthenticatedBiosInterfaceSmm",
		efi.GUID{0x43, 0xc2, 0x51, 0x4f, 0xee, 0x7c, 0x44, 0x41, 0x8e, 0xed, 0x23, 0x4a, 0xc2, 0xda, 0xbd, 0x53}: "EfiPeiPlatformTypeLightningRidgeEX8S1NPpi",
		efi.GUID{0x43, 0xcf, 0xfc, 0xc7, 0x59, 0x58, 0xbe, 0x4a, 0xbc, 0xb5, 0x4c, 0x16, 0x26, 0xed, 0x8b, 0x03}: "DellPeiDiagLeds",
		efi.GUID{0x43, 0xd0, 0x6f, 0x16, 0x13, 0xea, 0x48, 0x48, 0xbb, 0x3c, 0x6f, 0xa2, 0x95, 0xb9, 0x46, 0x27}: "DellVariable2Smm",
		efi.GUID{0x43, 0xd0, 0xf4, 0x6c, 0x22, 0x2d, 0xf0, 0x4f, 0xaa, 0xb0, 0xc5, 0xf9, 0x32, 0x84, 0x74, 0x00}: "SataDeviceFeatureDxe",
		efi.GUID{0x43, 0xd3, 0xde, 0x20, 0xfa, 0xe5, 0xc2, 0x49, 0xb2, 0x0f, 0xc1, 0x87, 0x98, 0x74, 0x3d, 0x41}: "OemPowerMgmtSmm",
		efi.GUID{0x43, 0xd6, 0x87, 0xec, 0xa4, 0xeb, 0xb5, 0x4b, 0xa1, 0xe5, 0x3f, 0x3e, 0x36, 0xb2, 0x0d, 0xa9}: "EfiSetupVariableGuid",
		efi.GUID{0x43, 0xe0, 0x8f, 0x97, 0xaf, 0xd7, 0x2e, 0x42, 0x8a, 0x92, 0x2b, 0x48, 0xe4, 0x63, 0xbd, 0xe6}: "EfiKmsFormatGeneric512Guid",
		efi.GUID{0x43, 0xe0, 0xc8, 0xa9, 0x6a, 0xb6, 0xb9, 0x42, 0xa4, 0x8f, 0x98, 0xb2, 0x34, 0x91, 0xeb, 0xab}: "Cf9Reset",
		efi.GUID{0x43, 0xf4, 0x54, 0xca, 0xf2, 0x1e, 0xab, 0x4d, 0x9e, 0x7e, 0x6d, 0xb7, 0xb7, 0x20, 0xb5, 0x87}: "EfiPccardCsProtocol",
		efi.GUID{0x43, 0xf7, 0xd3, 0xde, 0x2c, 0xce, 0xa6, 0x4b, 0x92, 0xa2, 0xff, 0xce, 0x2a, 0x6d, 0x72, 0xd9}: "PeiServicesTablePointerLibIdt",
		efi.GUID{0x43, 0xf8, 0x0c, 0x3b, 0x4d, 0x5a, 0xd7, 0x41, 0xb4, 0x2e, 0x12, 0x3b, 0x30, 0x84, 0xcf, 0x88}: "SmmSpdAccess",
		efi.GUID{0x43, 0xfe, 0xce, 0x8a, 0xa5, 0xd9, 0x1d, 0x47, 0xb8, 0x02, 0x98, 0x79, 0x86, 0x2a, 0xc3, 0xbc}: "FchSmbusDxe",
		efi.GUID{0x43, 0xff, 0x92, 0x3d, 0x3f, 0x19, 0xbe, 0x46, 0xb0, 0xe1, 0xb8, 0x20, 0x12, 0x4b, 0xf6, 0xd9}: "FjGabiNvramAbstractionSmm",
		efi.GUID{0x44, 0x03, 0xc8, 0x15, 0x80, 0xf9, 0xf5, 0x4b, 0xaa, 0xa0, 0xbf, 0xbe, 0x02, 0x7a, 0xef, 0x16}: "LenovoEcService",
		efi.GUID{0x44, 0x04, 0x3e, 0x36, 0x24, 0xdf, 0x98, 0x45, 0x87, 0xd6, 0x0a, 0x8b, 0xb0, 0xb3, 0x1f, 0xca}: "CommonElogSmm",
		efi.GUID{0x44, 0x0b, 0xbe, 0x43, 0x4b, 0x87, 0xad, 0x4e, 0xb0, 0x9c, 0x24, 0x1a, 0x4f, 0xbd, 0x7e, 0xb3}: "EfiKmsFormatGeneric1024Guid",
		efi.GUID{0x44, 0x15, 0xfd, 0xf2, 0x94, 0x97, 0x2c, 0x4a, 0x99, 0x2e, 0xe5, 0xbb, 0xcf, 0x20, 0xe3, 0x94}: "EfiSmbios3TableGuid",
		efi.GUID{0x44, 0x19, 0xdf, 0xb7, 0xe5, 0xc9, 0x3c, 0x47, 0xbf, 0xcb, 0x34, 0xef, 0x81, 0x55, 0xb3, 0x73}: "HpM2IoExpanderSmm",
		efi.GUID{0x44, 0x1e, 0x4d, 0x7a, 0x31, 0x45, 0xb0, 0x41, 0xa0, 0xc5, 0xb1, 0x9e, 0xd7, 0xa1, 0xb0, 0x97}: "SureStartPoliciesDxe",
		efi.GUID{0x44, 0x1e, 0xad, 0x31, 0x60, 0x9d, 0x15, 0x4b, 0xb6, 0x0e, 0x8e, 0x70, 0xbe, 0x15, 0x63, 0x23}: "UpekFingerPrintDevice",
		efi.GUID{0x44, 0x1f, 0xc9, 0xcb, 0xbc, 0xa4, 0x5b, 0x4a, 0x86, 0x96, 0x70, 0x34, 0x51, 0xd0, 0xb0, 0x53}: "ReserveBootGuardFvMainHashKey",
		efi.GUID{0x44, 0x27, 0x76, 0x84, 0xa7, 0xff, 0x28, 0x42, 0xb4, 0x30, 0x87, 0xae, 0x0c, 0x2c, 0x3b, 0xe7}: "EmulatedEepromSmm",
		efi.GUID{0x44, 0x30, 0x7b, 0x13, 0xd7, 0xf6, 0x3e, 0x47, 0xa6, 0x25, 0x9f, 0xb9, 0x25, 0x05, 0xc1, 0x80}: "EfiSpiBusProtocolGuid",
		efi.GUID{0x44, 0x3b, 0x8d, 0x9f, 0x15, 0xa1, 0x87, 0x46, 0x87, 0xea, 0x2c, 0x29, 0xbe, 0xb0, 0x92, 0xad}: "DellMemorySlotConfigSmm",
		efi.GUID{0x44, 0x45, 0xc5, 0xdf, 0x16, 0x25, 0xa5, 0x47, 0xb2, 0x88, 0x29, 0xf1, 0x00, 0xae, 0xfd, 0x01}: "HpCheckpointFlowControlCsbPrivate",
		efi.GUID{0x44, 0x48, 0x13, 0x97, 0x5e, 0x24, 0xab, 0x48, 0xbe, 0x0c, 0x07, 0x11, 0x4f, 0x63, 0xc9, 0xe5}: "CrbPxePei",
		efi.GUID{0x44, 0x4b, 0xee, 0x2d, 0x8e, 0xc0, 0x60, 0x4e, 0x9a, 0xeb, 0xa1, 0x1e, 0x2a, 0xda, 0xa4, 0xb5}: "FchPeiAux",
		efi.GUID{0x44, 0x51, 0x1f, 0x47, 0x37, 0x60, 0x52, 0x49, 0x8b, 0x01, 0xcf, 0xf5, 0x86, 0xfd, 0xe6, 0xb3}: "AmiTseOemPortingVar26",
		efi.GUID{0x44, 0x52, 0xad, 0x19, 0x6b, 0xfd, 0x5c, 0x4e, 0x82, 0x6a, 0x41, 0x46, 0x46, 0xd6, 0xda, 0x6a}: "EfiGlkVariableGuid",
		efi.GUID{0x44, 0x56, 0xad, 0x0f, 0xdf, 0x7b, 0x75, 0x4a, 0xb5, 0x68, 0x28, 0x7a, 0xe2, 0xeb, 0xd3, 0xa6}: "SmcSwSmiFlashSmm",
		efi.GUID{0x44, 0x5d, 0x07, 0xfe, 0xf1, 0xd9, 0xa1, 0x4d, 0xae, 0x6a, 0x82, 0x50, 0x55, 0x3c, 0xde, 0x66}: "AmiTseOemPortingVar25",
		efi.GUID{0x44, 0x5d, 0x88, 0x05, 0x88, 0x95, 0x8e, 0x42, 0x9e, 0xb0, 0x1c, 0xa7, 0xe5, 0x4c, 0xa9, 0x6b}: "TdxPostMem",
		efi.GUID{0x44, 0x66, 0xe7, 0x55, 0xa5, 0x78, 0x82, 0x4a, 0xa9, 0x00, 0x71, 0x26, 0xa5, 0x79, 0x88, 0x92}: "HeciInit",
		efi.GUID{0x44, 0x6e, 0xaf, 0x55, 0x6a, 0x08, 0x1e, 0x49, 0x82, 0x9a, 0x7d, 0x95, 0x50, 0x25, 0x39, 0xf5}: "RtSmmOemDriver",
		efi.GUID{0x44, 0x70, 0x33, 0xa0, 0x9c, 0x94, 0x3e, 0x42, 0xb5, 0x81, 0xda, 0xe2, 0xad, 0x43, 0x55, 0x34}: "VbtInfoGuid",
		efi.GUID{0x44, 0x7b, 0x6c, 0x39, 0x26, 0x85, 0xae, 0x42, 0xb5, 0xd4, 0x3f, 0x0a, 0xfd, 0x89, 0x01, 0x7e}: "H19MPMSmm",
		efi.GUID{0x44, 0x80, 0x01, 0x29, 0xc2, 0x0e, 0x50, 0x46, 0x89, 0x1f, 0x08, 0x13, 0x79, 0x78, 0x63, 0xb7}: "MeLock",
		efi.GUID{0x44, 0x91, 0x63, 0x65, 0x92, 0xd4, 0x28, 0x43, 0xa4, 0x98, 0xf4, 0xb5, 0x54, 0x5e, 0x4a, 0x30}: "IffsPartitionStatusProtocol",
		efi.GUID{0x44, 0x97, 0x04, 0x02, 0xd9, 0x32, 0x38, 0x43, 0xa6, 0x4b, 0xfd, 0xc4, 0x2c, 0x83, 0x6f, 0x9a}: "FchDxe",
		efi.GUID{0x44, 0x97, 0x04, 0x02, 0xd9, 0x32, 0x38, 0x43, 0xcc, 0xcb, 0xfd, 0xc4, 0x2c, 0x83, 0x6f, 0x9c}: "FchPromontoryPlusDxe",
		efi.GUID{0x44, 0x97, 0x50, 0x77, 0x07, 0x75, 0x5c, 0x4b, 0xbf, 0x6c, 0x3b, 0xab, 0x83, 0x65, 0x2f, 0x4d}: "BctBaseSmmRV",
		efi.GUID{0x44, 0x9f, 0x54, 0x99, 0xbb, 0x49, 0x20, 0x48, 0xb9, 0xd2, 0x90, 0x13, 0x29, 0x41, 0x2d, 0x67}: "IdeController",
		efi.GUID{0x44, 0xa8, 0xd6, 0xb8, 0x11, 0xab, 0x4f, 0x45, 0xb2, 0xaf, 0x2d, 0x8b, 0xcf, 0x6f, 0x4d, 0xca}: "PeripheralDxeInit",
		efi.GUID{0x44, 0xb4, 0xfc, 0x42, 0x81, 0xb8, 0xd8, 0x49, 0xa6, 0xe9, 0x5a, 0x16, 0x95, 0xfc, 0x9f, 0x3e}: "SysPassword",
		efi.GUID{0x44, 0xbb, 0x0f, 0x63, 0xde, 0x65, 0xbd, 0x43, 0xb5, 0x03, 0x8d, 0xe5, 0x91, 0x45, 0x36, 0xb5}: "FchProm21GpioPei",
		efi.GUID{0x44, 0xbd, 0xe2, 0x7e, 0xa0, 0x3d, 0xd4, 0x11, 0x9a, 0x38, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d}: "EfiIsaIoProtocolGuid",
		efi.GUID{0x44, 0xbf, 0x67, 0xbd, 0xb8, 0xca, 0x1b, 0x4a, 0xa3, 0xf9, 0xfc, 0x3c, 0xe2, 0xd0, 0xe7, 0x64}: "DellUsbMassStorageDxe",
		efi.GUID{0x44, 0xc1, 0x69, 0x90, 0x7e, 0x0a, 0xef, 0x41, 0x9c, 0x07, 0x41, 0x8b, 0xca, 0x9b, 0xf9, 0x39}: "AcpiDebugSmm",
		efi.GUID{0x44, 0xc3, 0xbb, 0x67, 0xbc, 0x84, 0x5c, 0x4e, 0xb4, 0xdf, 0xf5, 0xe4, 0xa0, 0x0e, 0x1f, 0x3a}: "SdHostDriver",
		efi.GUID{0x44, 0xca, 0x42, 0x23, 0x35, 0x3b, 0x34, 0x4a, 0x99, 0x5b, 0xce, 0xde, 0xeb, 0x1a, 0x95, 0x76}: "Intel945Uga",
		efi.GUID{0x44, 0xcc, 0x73, 0xb2, 0x2a, 0xe6, 0xdc, 0x41, 0x9c, 0xad, 0xbd, 0xb4, 0x23, 0x54, 0x59, 0xd8}: "UnicodeCollationDxe",
		efi.GUID{0x44, 0xcd, 0x6c, 0xc4, 0x65, 0xd3, 0x2c, 0x4c, 0x9b, 0xdc, 0x42, 0xe6, 0x1b, 0x57, 0xe2, 0x3f}: "FjI2CProtocol",
		efi.GUID{0x44, 0xce, 0xd9, 0xc9, 0x8d, 0x70, 0x27, 0x4e, 0xb9, 0x89, 0xe3, 0x5a, 0x33, 0x99, 0x9c, 0x28}: "DellSmmMultiPlatform",
		efi.GUID{0x44, 0xd6, 0xa0, 0x04, 0x99, 0x55, 0x0a, 0x43, 0xa4, 0xe1, 0xc8, 0xfe, 0xe8, 0xcb, 0xf4, 0x6a}: "SmbiosType142",
		efi.GUID{0x44, 0xd7, 0xfb, 0x22, 0x98, 0xca, 0x6d, 0x4f, 0x98, 0x82, 0x95, 0x42, 0x01, 0x31, 0x2d, 0xa0}: "H2OVarCheckRuntimeDxe",
		efi.GUID{0x44, 0xdb, 0xa6, 0x3c, 0x14, 0x86, 0xca, 0x4d, 0x8b, 0x95, 0xa3, 0x5e, 0xfd, 0x51, 0x77, 0x9e}: "DxeCheckCMOSHealth",
		efi.GUID{0x44, 0xde, 0xad, 0xb0, 0x85, 0x29, 0xfe, 0x40, 0x94, 0x84, 0x1b, 0x08, 0x77, 0x29, 0x31, 0xee}: "WheaERST",
		efi.GUID{0x44, 0xe5, 0xa9, 0x5d, 0x2d, 0xdc, 0x70, 0x46, 0xa3, 0xd5, 0x98, 0x52, 0x36, 0xd5, 0xde, 0x45}: "DellHotSosSmmDriver",
		efi.GUID{0x44, 0xea, 0xe5, 0x0c, 0xd3, 0xbe, 0xca, 0x49, 0xae, 0xcc, 0xb5, 0x0a, 0xb9, 0xc5, 0xb0, 0xe9}: "DellRecoverySiDxe",
		efi.GUID{0x44, 0xfe, 0x82, 0x16, 0x7a, 0xbd, 0x07, 0x44, 0xb7, 0xc7, 0xdc, 0xa3, 0x7c, 0xa3, 0x92, 0x2d}: "EfiTlsConfigurationProtocolGuid",
		efi.GUID{0x45, 0x02, 0x3e, 0x09, 0xa6, 0xbd, 0xc7, 0x48, 0xa0, 0xb4, 0xc3, 0xc9, 0xbf, 0xb8, 0x7c, 0x79}: "WLANDxe",
		efi.GUID{0x45, 0x12, 0xaf, 0x30, 0x8e, 0xa5, 0xf7, 0x4e, 0x8c, 0x75, 0xb7, 0x25, 0x93, 0x9b, 0x3b, 0x9f}: "AmdCpmInitSmm",
		efi.GUID{0x45, 0x18, 0xdf, 0x9d, 0xca, 0xe5, 0x2b, 0x45, 0xb1, 0x05, 0x17, 0xc8, 0x7f, 0xe2, 0x93, 0xe0}: "SceBootOrderSaveRestore",
		efi.GUID{0x45, 0x1e, 0xcb, 0x2a, 0xa4, 0xdf, 0xf3, 0x4f, 0x8f, 0x81, 0x91, 0xf7, 0xd7, 0x87, 0xd2, 0x2d}: "SystemUsbMemoryManagerSmm",
		efi.GUID{0x45, 0x24, 0x57, 0x30, 0x9b, 0x4c, 0x26, 0x47, 0xb0, 0x80, 0xd9, 0xae, 0xa2, 0xb0, 0x3d, 0xf1}: "PspPei",
		efi.GUID{0x45, 0x2c, 0xe6, 0xaf, 0xc9, 0x75, 0x6e, 0x49, 0xa2, 0x3d, 0xda, 0x7b, 0x51, 0x20, 0x9b, 0x72}: "CbsBaseDxeMDN",
		efi.GUID{0x45, 0x2e, 0x56, 0x4b, 0xb2, 0x2e, 0x5c, 0x4e, 0xbf, 0x2d, 0x57, 0x63, 0xf4, 0x30, 0x4d, 0xfb}: "UsbMassStorageSmm",
		efi.GUID{0x45, 0x32, 0x3e, 0xf8, 0x27, 0x21, 0x4f, 0x47, 0x88, 0x19, 0x97, 0x4f, 0xdc, 0x13, 0x9c, 0xe4}: "FjSysmanProtocol",
		efi.GUID{0x45, 0x33, 0x9f, 0x54, 0x83, 0x8b, 0x08, 0x4f, 0xa4, 0xdc, 0x34, 0xbf, 0x55, 0x02, 0x8a, 0x0f}: "ClientCorePeiPreMem",
		efi.GUID{0x45, 0x35, 0x6f, 0x10, 0x88, 0xb7, 0xb5, 0x4c, 0x9d, 0x2a, 0xce, 0x0c, 0xdb, 0x20, 0x8d, 0xf5}: "EfiHiiThunkProducerGuid",
		efi.GUID{0x45, 0x36, 0xb5, 0x8c, 0xff, 0x72, 0xa9, 0x42, 0x8e, 0xca, 0x0d, 0x7e, 0xc3, 0xd7, 0x26, 0xc9}: "EcRotUnlockEcPei",
		efi.GUID{0x45, 0x37, 0xa8, 0x3a, 0x54, 0x94, 0x7a, 0x4f, 0xa7, 0xc0, 0x90, 0xdb, 0xd0, 0x2f, 0xab, 0x8e}: "BdsConnectDriversProtocolGuid",
		efi.GUID{0x45, 0x3b, 0xb8, 0x4d, 0xa8, 0x9c, 0xed, 0x41, 0x9f, 0xc7, 0xc3, 0xfc, 0x00, 0x26, 0x7b, 0x8e}: "CountryCode",
		efi.GUID{0x45, 0x3c, 0x11, 0xc0, 0x38, 0x16, 0x3e, 0x4f, 0xbc, 0x29, 0x95, 0xcd, 0x8f, 0xb7, 0x20, 0x05}: "OemNvemDetectDxe",
		efi.GUID{0x45, 0x49, 0x32, 0x59, 0x44, 0xec, 0x0d, 0x4c, 0xb1, 0xcd, 0x9d, 0xb1, 0x39, 0xdf, 0x07, 0x0c}: "EfiIScsiInitiatorNameProtocolGuid",
		efi.GUID{0x45, 0x5f, 0x8a, 0x25, 0xd5, 0x00, 0x5b, 0x48, 0x84, 0xdb, 0x0b, 0x6d, 0x4a, 0xab, 0x5e, 0x2f}: "TbtSsdt",
		efi.GUID{0x45, 0x64, 0x78, 0x77, 0xac, 0x99, 0x2e, 0x4c, 0x9f, 0xf1, 0x99, 0x09, 0x65, 0x77, 0x05, 0x30}: "NCT3933Smm",
		efi.GUID{0x45, 0x69, 0x85, 0x67, 0xbf, 0xc6, 0x6a, 0x47, 0x92, 0x5d, 0xeb, 0xd1, 0xcd, 0x2e, 0xae, 0x11}: "KEMrJtagDxe",
		efi.GUID{0x45, 0x6c, 0x91, 0xb8, 0x80, 0x06, 0xfa, 0x40, 0xb8, 0x8f, 0x89, 0xf9, 0xd4, 0x2e, 0xec, 0x51}: "FchSmbusDxe",
		efi.GUID{0x45, 0x6c, 0xe9, 0x8a, 0x98, 0x97, 0xe5, 0x45, 0xa9, 0x52, 0x14, 0x3b, 0x63, 0x30, 0xa5, 0x40}: "ClientronSmbiosUpdateDxe",
		efi.GUID{0x45, 0x70, 0xf3, 0xd6, 0xa2, 0x3d, 0xa0, 0x4a, 0x97, 0x77, 0x1d, 0xf7, 0xd9, 0xfc, 0x61, 0xc9}: "iMRRaid",
		efi.GUID{0x45, 0x71, 0x98, 0xe9, 0x5b, 0xb0, 0x87, 0x47, 0xb9, 0x18, 0x5b, 0xeb, 0x86, 0xc4, 0xab, 0x6f}: "TamperEventS0Protect",
		efi.GUID{0x45, 0x72, 0x6a, 0x42, 0xbf, 0x6c, 0x9a, 0x49, 0x94, 0xce, 0x02, 0xed, 0x69, 0xaf, 0xc9, 0x93}: "MemoryDiagnosticBios",
		efi.GUID{0x45, 0x74, 0x41, 0x3d, 0x37, 0x1f, 0xd8, 0x46, 0xbc, 0x1f, 0xd0, 0x70, 0x14, 0x34, 0x49, 0x74}: "AhciPciHcPei",
		efi.GUID{0x45, 0x77, 0x3a, 0xa9, 0x4c, 0xfc, 0x35, 0x44, 0x8b, 0x60, 0xb5, 0xbc, 0x3b, 0x7e, 0x91, 0x35}: "WheaLastBootError",
		efi.GUID{0x45, 0x87, 0x0c, 0xff, 0x70, 0x32, 0x39, 0x44, 0xb7, 0x4f, 0x3e, 0x45, 0xf8, 0xc7, 0x70, 0x64}: "IntelGopDriver",
		efi.GUID{0x45, 0x89, 0x65, 0xba, 0xe1, 0xde, 0xb3, 0x42, 0x9f, 0xa4, 0xbb, 0x6b, 0x22, 0xfb, 0x03, 0xe4}: "efi_pop_mid",
		efi.GUID{0x45, 0x89, 0x8c, 0x14, 0xa2, 0xf4, 0x86, 0x45, 0xa5, 0x08, 0x42, 0xf5, 0x47, 0x0b, 0x2d, 0x47}: "DellSpdSmbusAccessDxe",
		efi.GUID{0x45, 0x97, 0x22, 0xf9, 0x1c, 0x98, 0x07, 0x4e, 0x9f, 0xc6, 0x78, 0x95, 0x45, 0xcb, 0x88, 0x18}: "AcpiSupportDxe",
		efi.GUID{0x45, 0x98, 0x63, 0xbf, 0x46, 0xd0, 0xf9, 0x43, 0xad, 0xbc, 0xd0, 0x08, 0x6a, 0xe2, 0x58, 0x71}: "DellSmmThermalDebugProtocol",
		efi.GUID{0x45, 0x98, 0xce, 0x52, 0xf4, 0x5a, 0xe2, 0x43, 0xba, 0xfd, 0x23, 0x08, 0x12, 0x54, 0x7a, 0xc2}: "PlatformGpioProtocolGuid",
		efi.GUID{0x45, 0x99, 0x43, 0x5b, 0x33, 0x43, 0x9f, 0x41, 0x8d, 0x88, 0x84, 0xc6, 0x95, 0x62, 0xe2, 0xf6}: "EfiPlatformTypeCrescentCityProtocol",
		efi.GUID{0x45, 0x9a, 0xbe, 0xaa, 0x45, 0xb3, 0xd2, 0x49, 0x88, 0xef, 0x6a, 0xd0, 0xb8, 0x5e, 0xd7, 0xe6}: "AmiRomLayoutProtocolGuid",
		efi.GUID{0x45, 0xa0, 0x01, 0x84, 0x70, 0x6f, 0x05, 0x45, 0x84, 0x71, 0x70, 0x15, 0xb4, 0x03, 0x55, 0xe3}: "UsbBusPei",
		efi.GUID{0x45, 0xa6, 0x79, 0x0d, 0x91, 0x1d, 0xa6, 0x40, 0xa8, 0x1f, 0x61, 0xe6, 0x98, 0x2b, 0x32, 0xb4}: "EfiNt32PkgTokenSpaceGuid",
		efi.GUID{0x45, 0xae, 0x62, 0xd4, 0x5a, 0xff, 0x48, 0x44, 0xa4, 0x74, 0xb9, 0x86, 0xe2, 0xa0, 0xd5, 0xb1}: "G3WakeupDxe",
		efi.GUID{0x45, 0xb4, 0x05, 0xe4, 0x80, 0xb5, 0x7f, 0x4c, 0x9c, 0x1d, 0xf2, 0x26, 0xb8, 0x1f, 0x74, 0xdd}: "BiosPowerSave",
		efi.GUID{0x45, 0xba, 0x77, 0x68, 0x87, 0x7e, 0x9f, 0x44, 0x98, 0x4f, 0xfd, 0x04, 0x50, 0x3d, 0x7a, 0x28}: "SmcSetPowerStatusSmm",
		efi.GUID{0x45, 0xd2, 0xe4, 0x78, 0x4d, 0xcd, 0x05, 0x4a, 0xa2, 0xba, 0x47, 0x43, 0xe8, 0x6c, 0xfc, 0xab}: "EfiSecurityPolicyProtocolGuid",
		efi.GUID{0x45, 0xd6, 0xef, 0x0c, 0x8e, 0x58, 0xd7, 0x4e, 0x99, 0x43, 0x05, 0x48, 0x08, 0xcd, 0x75, 0x72}: "SiFirmwareVersionDxe",
		efi.GUID{0x45, 0xdd, 0x82, 0xf2, 0x7b, 0xca, 0xec, 0x40, 0x96, 0x18, 0x99, 0x38, 0x1c, 0x08, 0xf4, 0x09}: "OpaPlatCfg",
		efi.GUID{0x45, 0xe3, 0x7a, 0x92, 0x7b, 0xbb, 0x4f, 0x43, 0x8d, 0x29, 0x71, 0xbe, 0x0d, 0x12, 0xab, 0x2c}: "AmdFabricZpDxe",
		efi.GUID{0x45, 0xe3, 0xad, 0x9a, 0x64, 0xe0, 0x55, 0x43, 0xa8, 0x15, 0x87, 0x45, 0x64, 0xdc, 0xa7, 0x60}: "AccessPoint80211",
		efi.GUID{0x45, 0xe5, 0x3c, 0x84, 0x06, 0x9f, 0x0f, 0x41, 0xba, 0x6c, 0x31, 0x1d, 0x66, 0xad, 0x64, 0x3a}: "MFGDoneSync2Setup",
		efi.GUID{0x45, 0xf1, 0x0c, 0xd6, 0x7c, 0xf9, 0x85, 0x40, 0xa7, 0x3d, 0x8d, 0x39, 0x97, 0x57, 0xdf, 0xe9}: "AmiCpmWrapperDxe",
		efi.GUID{0x45, 0xf1, 0x0c, 0xd6, 0x7c, 0xf9, 0x85, 0x40, 0xa7, 0x3d, 0x8d, 0x39, 0x97, 0x57, 0xdf, 0xea}: "AmiCpmWrapperDxe",
		efi.GUID{0x45, 0xf3, 0x13, 0x45, 0x25, 0x0a, 0xc4, 0x42, 0x81, 0x14, 0x3a, 0x26, 0xba, 0x6c, 0xf5, 0x70}: "PlatformVTdInfoSamplePei",
		efi.GUID{0x45, 0xf6, 0xf8, 0x47, 0xeb, 0x8d, 0x04, 0x43, 0xbe, 0xe5, 0xba, 0x87, 0xd6, 0xc6, 0x80, 0xe9}: "DellTcg2Pei",
		efi.GUID{0x45, 0xfc, 0xde, 0xa6, 0xdc, 0x18, 0xc9, 0x41, 0xb2, 0xa8, 0xd0, 0x08, 0x9d, 0xe0, 0x8d, 0xd3}: "UfsPassThruDxe",
		efi.GUID{0x45, 0xfd, 0x61, 0x3a, 0xa0, 0x69, 0xad, 0x42, 0xb2, 0x61, 0x24, 0xda, 0x45, 0x1b, 0xf4, 0x42}: "ForceRecovery",
		efi.GUID{0x45, 0xfe, 0x1c, 0x71, 0xef, 0xde, 0xf5, 0x4c, 0xa0, 0x94, 0xe8, 0x52, 0x27, 0x61, 0xce, 0xd6}: "PdHostInterfaceTiSmm",
		efi.GUID{0x45, 0xfe, 0x34, 0x68, 0xee, 0x4a, 0xc6, 0x4f, 0xbc, 0xb5, 0xff, 0x45, 0xb7, 0xa8, 0x71, 0xe2}: "BeagleBoardTokenSpaceGuid",
		efi.GUID{0x45, 0xff, 0x84, 0xf0, 0xfa, 0xf9, 0x9e, 0x4e, 0x8d, 0xff, 0xe2, 0xd7, 0x80, 0xd2, 0x2c, 0xc2}: "EfiCpuRasProtocol",
		efi.GUID{0x46, 0x0d, 0x3e, 0xe0, 0x63, 0x52, 0x45, 0x48, 0xb0, 0xa4, 0x58, 0xd5, 0x7b, 0x31, 0x77, 0xe2}: "UbaConfigDatabaseProtocol",
		efi.GUID{0x46, 0x1b, 0xd5, 0x38, 0x75, 0xd2, 0x5c, 0x47, 0xa9, 0x51, 0x80, 0xa7, 0xe1, 0xcf, 0x38, 0xb1}: "AmdCpmSensorFusionDxe",
		efi.GUID{0x46, 0x25, 0x2f, 0x88, 0x1f, 0xef, 0x90, 0x40, 0x9f, 0x9c, 0x93, 0x84, 0x5a, 0xd7, 0x84, 0x1c}: "SmBusControllerIdentifier",
		efi.GUID{0x46, 0x27, 0x09, 0xc0, 0x7b, 0xb6, 0x02, 0x4d, 0xff, 0xff, 0xff, 0xff, 0x78, 0xe0, 0x38, 0xd1}: "XnoteAcpiPlatformDxe",
		efi.GUID{0x46, 0x29, 0xed, 0x94, 0xea, 0x24, 0xdf, 0x11, 0xaf, 0x40, 0x43, 0x00, 0xb0, 0xd2, 0xba, 0x57}: "LegacyMemoryAllocatorDxe",
		efi.GUID{0x46, 0x49, 0x6f, 0xbf, 0x69, 0xf3, 0xe9, 0x47, 0x90, 0x84, 0x23, 0x0c, 0x7f, 0x9e, 0x73, 0x7a}: "BCdpfLauncher",
		efi.GUID{0x46, 0x4e, 0xb6, 0xc8, 0x19, 0x98, 0xab, 0x45, 0x87, 0x5d, 0x09, 0xdf, 0xda, 0x6d, 0x8b, 0x1b}: "Firewire",
		efi.GUID{0x46, 0x52, 0x59, 0x9a, 0x53, 0x6f, 0x26, 0x45, 0xb8, 0x56, 0x3c, 0x06, 0x67, 0xf4, 0xda, 0x67}: "LEMAllDriversConnectedEventHook",
		efi.GUID{0x46, 0x5f, 0x14, 0xe8, 0x86, 0xb6, 0x68, 0x40, 0xa2, 0xfa, 0x13, 0xa5, 0x8c, 0xb3, 0x8b, 0xe6}: "ManufacturingModeSmm",
		efi.GUID{0x46, 0x61, 0x4e, 0x23, 0xc6, 0x1f, 0x08, 0x45, 0x82, 0x31, 0x12, 0x94, 0xcc, 0x28, 0xda, 0x4c}: "FjGrasscarryLaunch",
		efi.GUID{0x46, 0x75, 0x1a, 0x01, 0x4e, 0xdb, 0x19, 0x41, 0xa2, 0x16, 0x9a, 0x31, 0x67, 0xb6, 0xaf, 0x56}: "ComputraceDxe",
		efi.GUID{0x46, 0x7c, 0xa9, 0x4e, 0x91, 0x74, 0xfd, 0x4d, 0xb4, 0x42, 0x74, 0x70, 0x10, 0xf3, 0xce, 0x5f}: "Main",
		efi.GUID{0x46, 0x7c, 0xa9, 0x4e, 0x91, 0x74, 0xfd, 0x4d, 0xb5, 0x42, 0x74, 0x70, 0x10, 0xf3, 0xce, 0x7f}: "HpNetworkTransferWorker",
		efi.GUID{0x46, 0x84, 0x95, 0x16, 0xb7, 0x19, 0x0b, 0x48, 0xb0, 0x47, 0x74, 0x85, 0xad, 0x3f, 0x71, 0x6d}: "FdtHobGuid",
		efi.GUID{0x46, 0x87, 0x0c, 0xff, 0x70, 0x32, 0x39, 0x44, 0xb7, 0x4f, 0x3e, 0x45, 0xf8, 0xc8, 0x75, 0x66}: "gMXMsigned",
		efi.GUID{0x46, 0x87, 0x0c, 0xff, 0x70, 0x32, 0x39, 0x44, 0xb7, 0x4f, 0x3e, 0x45, 0xf8, 0xc8, 0xa5, 0x88}: "gMXMsignedN16M2",
		efi.GUID{0x46, 0x87, 0x0c, 0xff, 0x70, 0x32, 0x39, 0x44, 0xb7, 0x4f, 0x3e, 0x45, 0xf8, 0xc8, 0xa5, 0x89}: "gMXMsignedN16E",
		efi.GUID{0x46, 0x89, 0xef, 0x18, 0xf5, 0x68, 0xe6, 0x49, 0xb2, 0x02, 0xce, 0x90, 0xc3, 0xee, 0xf1, 0xc9}: "IchSmmDispatcherDxe",
		efi.GUID{0x46, 0x8c, 0xb6, 0x39, 0xfb, 0xf7, 0x1b, 0x44, 0xb6, 0xec, 0x16, 0xb0, 0xf6, 0x98, 0x21, 0xf3}: "EfiCapsuleReportGuid",
		efi.GUID{0x46, 0x8c, 0xb8, 0x7e, 0xff, 0x22, 0xbd, 0x4c, 0x8f, 0xe7, 0x49, 0x53, 0x83, 0xfa, 0xb1, 0xe4}: "PciBoardDxeInit",
		efi.GUID{0x46, 0x91, 0x41, 0x46, 0x6e, 0x3d, 0x3c, 0x47, 0xa3, 0xaa, 0x22, 0xab, 0x40, 0x4f, 0x19, 0x7c}: "FjDxeServicesTableDxe",
		efi.GUID{0x46, 0x92, 0x4e, 0x9a, 0x53, 0xd5, 0xd5, 0x11, 0x87, 0xe2, 0x00, 0x06, 0x29, 0x45, 0xc3, 0xb9}: "EfiStatusCodeDataTypeDebugGuid",
		efi.GUID{0x46, 0x92, 0x72, 0x21, 0xf1, 0x5d, 0xa1, 0x46, 0xa5, 0xc6, 0x24, 0x84, 0xbc, 0xd7, 0x06, 0xfb}: "LEMSetVariablePreInit",
		efi.GUID{0x46, 0x94, 0x47, 0x82, 0x71, 0x53, 0xf7, 0x44, 0x87, 0xbf, 0xc8, 0x08, 0xbc, 0x9a, 0x99, 0x25}: "SplashPei",
		efi.GUID{0x46, 0xa0, 0x01, 0x84, 0x70, 0x6f, 0x05, 0x45, 0x84, 0x71, 0x70, 0x15, 0xb4, 0x03, 0x55, 0xe3}: "UsbBotPei",
		efi.GUID{0x46, 0xa4, 0x33, 0x41, 0x9b, 0x3e, 0x3e, 0x46, 0x98, 0x2d, 0x0b, 0x7a, 0x09, 0xb1, 0xf1, 0x38}: "FjShutdownLogDxe",
		efi.GUID{0x46, 0xae, 0xf9, 0xc2, 0x37, 0x34, 0xef, 0x4f, 0x9c, 0xb1, 0x9a, 0x56, 0x8b, 0x28, 0x2f, 0xee}: "FspSecCoreM",
		efi.GUID{0x46, 0xb0, 0x71, 0xcc, 0x07, 0xcf, 0xae, 0x4d, 0xae, 0xad, 0x70, 0x46, 0x84, 0x5b, 0xcd, 0x8a}: "LenovoVideoInitDxe",
		efi.GUID{0x46, 0xb7, 0x13, 0x6e, 0xdd, 0x80, 0xdc, 0x4e, 0xb1, 0x78, 0xd2, 0x5b, 0xd4, 0x83, 0x8f, 0xba}: "HwmThermalSmm",
		efi.GUID{0x46, 0xb8, 0xb2, 0x90, 0x6d, 0xca, 0x6e, 0x4d, 0xa8, 0xd3, 0xc1, 0x40, 0xa8, 0xe1, 0x10, 0xac}: "SystemFirmwareDescriptor",
		efi.GUID{0x46, 0xca, 0xdf, 0x05, 0x1f, 0x14, 0xdf, 0x11, 0x85, 0x08, 0xe3, 0x8c, 0x08, 0x91, 0xc4, 0xe2}: "HfsPlusDxe",
		efi.GUID{0x46, 0xcf, 0x27, 0xf8, 0x8f, 0x8a, 0xf9, 0x43, 0xbd, 0x99, 0x0e, 0x7f, 0x52, 0x06, 0x90, 0x7d}: "FjSysmanTeutatesSmmWatchdog",
		efi.GUID{0x46, 0xe3, 0xee, 0x56, 0x0c, 0x50, 0x36, 0x49, 0x95, 0x1a, 0x2d, 0xa5, 0xf0, 0xff, 0x39, 0xbb}: "DellGrasslakeConfig",
		efi.GUID{0x46, 0xe8, 0xd6, 0x00, 0xc7, 0x49, 0x17, 0x45, 0xac, 0x79, 0xa7, 0x0e, 0x8b, 0xc0, 0x55, 0x3c}: "AmdMemChanXLatSspPei",
		efi.GUID{0x46, 0xec, 0x94, 0x28, 0x7a, 0xc6, 0x56, 0x42, 0x87, 0xde, 0x34, 0xa7, 0x41, 0xd8, 0x59, 0x82}: "Mct",
		efi.GUID{0x46, 0xf7, 0x4d, 0x63, 0x4b, 0x6f, 0x84, 0x46, 0x93, 0xe6, 0x52, 0x66, 0x53, 0xe7, 0xc3, 0x5a}: "OemThermalPolicy",
		efi.GUID{0x46, 0xf8, 0x84, 0x02, 0xb7, 0x2c, 0x60, 0x49, 0x8d, 0xb2, 0x47, 0xaa, 0x71, 0x51, 0x3a, 0xd5}: "menu_selection",
		efi.GUID{0x46, 0xfa, 0x06, 0x1b, 0x5b, 0xe6, 0x57, 0x42, 0x88, 0x55, 0x58, 0x28, 0xb7, 0x59, 0x1e, 0x61}: "FingerPrintHDDPasswordChecking",
		efi.GUID{0x47, 0x03, 0x83, 0xe3, 0x44, 0x48, 0xf1, 0x49, 0x95, 0x70, 0x18, 0xaa, 0x37, 0x7b, 0x71, 0x1c}: "AppleDiagnosticVault",
		efi.GUID{0x47, 0x0d, 0x51, 0x15, 0xdc, 0xfa, 0xf4, 0x41, 0x8b, 0x9d, 0xfc, 0x32, 0x3c, 0x82, 0x1f, 0xe2}: "VerboseDisableCursor",
		efi.GUID{0x47, 0x10, 0x50, 0x68, 0x1f, 0x11, 0xd2, 0x4b, 0xaa, 0x33, 0x6c, 0x1e, 0xce, 0x27, 0x12, 0x59}: "ApplePlatformInitDxe",
		efi.GUID{0x47, 0x10, 0xe5, 0x9a, 0xb9, 0xe0, 0x50, 0x4a, 0x9e, 0x72, 0x84, 0xe3, 0x59, 0xd2, 0x01, 0x89}: "OpromUpdateDxeLightningRidgeEXECB2",
		efi.GUID{0x47, 0x12, 0x73, 0xbe, 0xa2, 0x5f, 0x5b, 0x4d, 0x9d, 0xb6, 0x53, 0x85, 0xcc, 0xcd, 0x59, 0xe1}: "UsbOcUpdateDxeLightningRidgeEXECB3",
		efi.GUID{0x47, 0x21, 0xa0, 0x28, 0xd6, 0x19, 0x1c, 0x49, 0xaf, 0xef, 0xdb, 0x35, 0x1b, 0xf4, 0x61, 0x24}: "DiagnosticsJumper",
		efi.GUID{0x47, 0x27, 0x94, 0x9b, 0x4e, 0x15, 0x29, 0x4d, 0xa4, 0x36, 0xbf, 0x71, 0x00, 0xc8, 0xb5, 0x3b}: "Ip4Config2NvDataGuid",
		efi.GUID{0x47, 0x2d, 0xb9, 0x02, 0x27, 0x52, 0x18, 0x4c, 0x9f, 0xf5, 0x88, 0x85, 0x50, 0xc3, 0x95, 0xb9}: "MktmeLateInit",
		efi.GUID{0x47, 0x35, 0xf4, 0xa7, 0xf1, 0x1f, 0xcc, 0x4b, 0x94, 0x25, 0xa0, 0x82, 0x90, 0x9b, 0xcd, 0x0d}: "SystemSureBootDxe",
		efi.GUID{0x47, 0x36, 0xf0, 0xb4, 0xc2, 0x68, 0xe7, 0x49, 0x4a, 0x4a, 0xeb, 0xa3, 0x99, 0xf5, 0x5e, 0xb2}: "HpLinuxRepsetWrapperWks",
		efi.GUID{0x47, 0x38, 0x0c, 0x52, 0xa0, 0x71, 0xe7, 0x40, 0xa8, 0x95, 0x8c, 0x89, 0x97, 0xc3, 0x34, 0x55}: "AmdMemFeatPei",
		efi.GUID{0x47, 0x43, 0xb3, 0x54, 0x78, 0xc4, 0x65, 0x48, 0x84, 0x15, 0x74, 0x2e, 0x51, 0x55, 0xb2, 0x04}: "UefiRestNetwork",
		efi.GUID{0x47, 0x47, 0x37, 0x28, 0xff, 0x76, 0xb3, 0x41, 0x97, 0x40, 0x38, 0x1e, 0xfa, 0xef, 0x13, 0xbc}: "PspPlatform",
		efi.GUID{0x47, 0x56, 0x69, 0xd4, 0x01, 0x7d, 0x96, 0x4d, 0xac, 0x7e, 0xbb, 0x90, 0xee, 0xe2, 0x9e, 0xb9}: "H2OCryptoServicesPostMemPei",
		efi.GUID{0x47, 0x5b, 0x77, 0xe2, 0x53, 0xd4, 0xe3, 0x4e, 0xad, 0xa7, 0x39, 0x1a, 0x1b, 0x05, 0xac, 0x17}: "PciSioSerialDxe",
		efi.GUID{0x47, 0x61, 0xd4, 0x1e, 0xe3, 0x76, 0x71, 0x41, 0xbc, 0xe5, 0x42, 0xd3, 0x68, 0xd2, 0x6a, 0xa6}: "DebugPortTableDxe",
		efi.GUID{0x47, 0x6f, 0xea, 0xe2, 0x78, 0xe6, 0xfa, 0x47, 0x8c, 0x1b, 0x02, 0xa0, 0x3e, 0x82, 0x5c, 0x6e}: "TcgMorLockSmm",
		efi.GUID{0x47, 0x72, 0x45, 0x29, 0x7e, 0x97, 0xaa, 0x46, 0x92, 0xe0, 0x46, 0xe1, 0x0e, 0x24, 0x92, 0x25}: "AsusPeiGopVideo",
		efi.GUID{0x47, 0x72, 0x8d, 0x97, 0xea, 0x98, 0x14, 0x4a, 0xbf, 0x98, 0x32, 0xa3, 0x5f, 0x34, 0x56, 0x6b}: "AcpiPowerButton",
		efi.GUID{0x47, 0x76, 0x00, 0xe3, 0x8f, 0x79, 0x48, 0xff, 0xac, 0x61, 0xe0, 0xb8, 0xd1, 0xb6, 0x63, 0x27}: "PlatformDataRegion",
		efi.GUID{0x47, 0x87, 0x57, 0xd1, 0x2c, 0x1a, 0x72, 0x49, 0x8d, 0x56, 0x3c, 0x8b, 0x93, 0xed, 0x25, 0xa5}: "StaticSkuDataDxeXPV",
		efi.GUID{0x47, 0x8e, 0xfd, 0x69, 0x61, 0xa1, 0x50, 0x45, 0xb0, 0x1a, 0x55, 0x94, 0xce, 0xb2, 0xb2, 0xb2}: "IdeBusDxe",
		efi.GUID{0x47, 0x96, 0x2a, 0x82, 0x79, 0x54, 0xf0, 0x44, 0xac, 0x85, 0x88, 0x69, 0x07, 0x4d, 0x76, 0xad}: "DellForeignKeyboardLayout",
		efi.GUID{0x47, 0x97, 0x9a, 0x66, 0x5e, 0xa6, 0x39, 0x4f, 0x8f, 0xd6, 0x95, 0x57, 0x57, 0x3b, 0xc9, 0xda}: "DellSystemIdPolicy",
		efi.GUID{0x47, 0x98, 0xc6, 0x94, 0xcf, 0xa0, 0x35, 0x46, 0xaa, 0x23, 0xd2, 0x66, 0x7b, 0xd7, 0xf7, 0x91}: "SdioBusInitProtocol",
		efi.GUID{0x47, 0xa2, 0x51, 0x15, 0x31, 0xbb, 0x93, 0x43, 0x8b, 0xb4, 0x10, 0x50, 0x9a, 0xe2, 0xf1, 0x8f}: "ChargeLedDebugPei",
		efi.GUID{0x47, 0xa4, 0x03, 0x69, 0x4f, 0xcb, 0xf6, 0x45, 0x89, 0xa2, 0x7e, 0x7e, 0x2f, 0x9e, 0xe1, 0x4c}: "InstallMsdm",
		efi.GUID{0x47, 0xab, 0x49, 0x45, 0x60, 0x6e, 0x93, 0x42, 0xb9, 0x1d, 0x31, 0xb6, 0x10, 0xad, 0x80, 0x56}: "EfiEsrtOperationProtocolGuid",
		efi.GUID{0x47, 0xad, 0x48, 0x73, 0x40, 0x2e, 0x46, 0x48, 0xb6, 0x58, 0xb9, 0x21, 0x34, 0x69, 0xc1, 0x30}: "DellEcPolicy2",
		efi.GUID{0x47, 0xb9, 0xae, 0xe1, 0x0f, 0x94, 0x35, 0x46, 0xa8, 0x7f, 0x81, 0x7a, 0xb5, 0x1b, 0x72, 0x61}: "DualDieRecoveryPei",
		efi.GUID{0x47, 0xba, 0x96, 0xa1, 0xd3, 0x8e, 0x88, 0x41, 0xa7, 0x65, 0xfa, 0x96, 0x4d, 0xd7, 0xed, 0x7a}: "LenovoSystemErrorLogDxe",
		efi.GUID{0x47, 0xba, 0xfa, 0x60, 0x9b, 0x41, 0x50, 0x4e, 0x85, 0xc7, 0x20, 0xe8, 0x6a, 0xee, 0x00, 0xfc}: "ASRockNetTcpWrapper",
		efi.GUID{0x47, 0xc3, 0x9d, 0xa7, 0xb4, 0xde, 0x4e, 0x4a, 0x84, 0x97, 0xca, 0x5f, 0x8e, 0x7f, 0x06, 0x01}: "DellImageServerSmm",
		efi.GUID{0x47, 0xc5, 0x87, 0xbd, 0xff, 0x93, 0x4a, 0x4f, 0xa8, 0x90, 0x02, 0xb1, 0xaf, 0x98, 0x6f, 0x34}: "OverclockInterface",
		efi.GUID{0x47, 0xc8, 0x93, 0x5e, 0x6d, 0x45, 0xb3, 0x40, 0xa6, 0xb4, 0x78, 0xb0, 0xc9, 0xcf, 0x7f, 0x20}: "EfiEapManagement2ProtocolGuid",
		efi.GUID{0x47, 0xca, 0xd7, 0xd7, 0x3b, 0x66, 0x8d, 0x48, 0xae, 0xe3, 0x6a, 0x35, 0xdc, 0xb8, 0x9e, 0x2a}: "SbGlobalSmiControl",
		efi.GUID{0x47, 0xcc, 0xcb, 0x63, 0xba, 0x65, 0x19, 0x4c, 0x9f, 0xc0, 0x0a, 0xd8, 0x1c, 0x9d, 0xb8, 0x18}: "SleepStateSmi",
		efi.GUID{0x47, 0xd4, 0xf8, 0x44, 0x21, 0xa0, 0xaa, 0x46, 0x98, 0x11, 0x12, 0xc1, 0xea, 0x02, 0x11, 0x9d}: "BiosConnectLauncher",
		efi.GUID{0x47, 0xdd, 0x3d, 0xc0, 0x0a, 0xdc, 0x19, 0x43, 0x9f, 0xec, 0x44, 0xb0, 0x78, 0xc2, 0x42, 0xe6}: "AmiTseOemPortingVar13",
		efi.GUID{0x47, 0xdf, 0xbe, 0xed, 0xa3, 0x6e, 0x12, 0x45, 0x83, 0xc1, 0x70, 0xf4, 0x76, 0x9d, 0x4b, 0xde}: "Capsule_A_fvi",
		efi.GUID{0x47, 0xe1, 0x79, 0xf4, 0x25, 0xa1, 0xd4, 0x11, 0xbc, 0xfc, 0x00, 0x80, 0xc7, 0x3c, 0x88, 0x81}: "WinNtBlockIoDxe",
		efi.GUID{0x47, 0xec, 0xde, 0x5c, 0x38, 0x25, 0xe7, 0x11, 0xa4, 0x38, 0xb8, 0xe8, 0x56, 0x2c, 0xba, 0xfa}: "AppleVoiceOver",
		efi.GUID{0x47, 0xf0, 0x47, 0xb3, 0x8c, 0xaf, 0x0e, 0x49, 0xac, 0x07, 0x0a, 0xa9, 0xb7, 0xe5, 0x38, 0x58}: "EfiWinNtSystemConfigGuid",
		efi.GUID{0x47, 0xf5, 0xdd, 0xf4, 0xf9, 0x08, 0xb3, 0x40, 0x94, 0x08, 0x20, 0x23, 0xe8, 0xdb, 0x88, 0x74}: "CPURDRAND",
		efi.GUID{0x47, 0xf8, 0xa4, 0x3f, 0xeb, 0xd8, 0xf4, 0x4d, 0xbd, 0x49, 0x10, 0x3a, 0x0a, 0x84, 0x7b, 0xbc}: "EfiKmsFormatMdc4128Guid",
		efi.GUID{0x48, 0x10, 0x23, 0xd3, 0xd7, 0xb7, 0xfc, 0x46, 0x80, 0xf8, 0x2f, 0x7b, 0x22, 0x95, 0x86, 0xc5}: "UTDMUIApp",
		efi.GUID{0x48, 0x19, 0xac, 0x53, 0xd0, 0x0e, 0x8a, 0x42, 0xb4, 0xdd, 0xd2, 0xff, 0xf2, 0xf5, 0x77, 0x6f}: "LenovoFlashProtectPei",
		efi.GUID{0x48, 0x1e, 0x4e, 0x07, 0x32, 0x81, 0xa1, 0x47, 0x8c, 0x2c, 0x3f, 0x14, 0xad, 0x9a, 0x66, 0xdc}: "EfiGlobalNvsAreaProtocolGuid",
		efi.GUID{0x48, 0x25, 0x09, 0x78, 0xcf, 0x48, 0x9b, 0x44, 0x9b, 0xdb, 0xf6, 0x38, 0x49, 0x85, 0x64, 0x60}: "AmiProtocolInternalHlxeGuid",
		efi.GUID{0x48, 0x29, 0x75, 0xe3, 0xa1, 0xb9, 0x70, 0x47, 0x90, 0xc4, 0xdf, 0x41, 0xc3, 0x89, 0x86, 0xbe}: "QemuVideoDxe",
		efi.GUID{0x48, 0x30, 0x6a, 0x13, 0x2a, 0x75, 0xf6, 0x4b, 0xa7, 0x57, 0x09, 0x36, 0x11, 0x95, 0x38, 0xed}: "UiStringPackGuid",
		efi.GUID{0x48, 0x31, 0xd3, 0xaf, 0x1f, 0xa9, 0x56, 0x42, 0x84, 0xa8, 0x2f, 0x89, 0x76, 0xce, 0x77, 0xaf}: "PowerReportDxe",
		efi.GUID{0x48, 0x31, 0xd3, 0xed, 0x1f, 0xa9, 0x57, 0x42, 0x84, 0xa8, 0x2f, 0x29, 0x76, 0xce, 0x79, 0xaf}: "LGPowerReportDxe",
		efi.GUID{0x48, 0x31, 0xd3, 0xed, 0x1f, 0xa9, 0x57, 0x42, 0x84, 0xa8, 0x2f, 0x29, 0x76, 0xce, 0x8a, 0xbe}: "LGEcCommunicationDxe",
		efi.GUID{0x48, 0x31, 0xd3, 0xed, 0x1f, 0xa9, 0x57, 0x42, 0x84, 0xa8, 0x3a, 0x1a, 0x76, 0xce, 0x8a, 0xbe}: "LGBdsFlowDxe",
		efi.GUID{0x48, 0x33, 0xda, 0x72, 0x1e, 0x8d, 0x55, 0x46, 0xaf, 0x88, 0x84, 0xed, 0x02, 0x5f, 0xb2, 0x68}: "FjGabiMiscellaneousSmm",
		efi.GUID{0x48, 0x36, 0xc5, 0x67, 0x56, 0xda, 0x26, 0x47, 0xae, 0x21, 0xfb, 0xa4, 0xd0, 0x46, 0x86, 0xb3}: "RsdpPlus",
		efi.GUID{0x48, 0x39, 0x2f, 0x4a, 0x0a, 0xc4, 0x9d, 0x46, 0x86, 0xe7, 0x4e, 0xdc, 0x54, 0x13, 0x3b, 0x46}: "FchKernDxe",
		efi.GUID{0x48, 0x45, 0x86, 0x76, 0x61, 0x02, 0x0e, 0x41, 0xa8, 0xb4, 0x01, 0x61, 0x5b, 0xfa, 0x3e, 0x0a}: "FwKeyHobPei",
		efi.GUID{0x48, 0x46, 0x4a, 0xdd, 0xe7, 0x2d, 0x65, 0x46, 0x96, 0x4d, 0x21, 0xd9, 0xef, 0x5f, 0xb4, 0x46}: "EfiCcFinalEventsTable",
		efi.GUID{0x48, 0x4e, 0x62, 0x04, 0x4e, 0xd2, 0x70, 0x46, 0xbd, 0xfd, 0x12, 0x4d, 0xd9, 0x2f, 0x3d, 0xad}: "PxeDriverI225",
		efi.GUID{0x48, 0x4e, 0x7d, 0x12, 0xc0, 0x85, 0xba, 0x4f, 0xb6, 0x78, 0xb1, 0x4e, 0x94, 0x92, 0xaa, 0xdf}: "FchKernPei",
		efi.GUID{0x48, 0x50, 0xa5, 0xda, 0x3f, 0xbc, 0xd9, 0x4d, 0x99, 0x9b, 0xf5, 0x8a, 0xbf, 0x2b, 0xbf, 0xcc}: "DxePlatform",
		efi.GUID{0x48, 0x55, 0x9d, 0x98, 0x40, 0xac, 0xf3, 0x45, 0xad, 0xf5, 0xd0, 0x5f, 0x94, 0xa8, 0x91, 0xae}: "EfiBmcLanProtocol",
		efi.GUID{0x48, 0x62, 0x2d, 0x54, 0x98, 0x41, 0x60, 0x49, 0x9f, 0x59, 0x23, 0x84, 0x64, 0x6d, 0x63, 0xb4}: "AmiOpromPolicyProtocolGuid",
		efi.GUID{0x48, 0x62, 0x57, 0x20, 0x1a, 0xc0, 0x9d, 0x43, 0x8c, 0xd6, 0x41, 0x8e, 0xaa, 0xbe, 0x0a, 0x29}: "RasClvAdddcProtocol",
		efi.GUID{0x48, 0x62, 0xeb, 0x15, 0x67, 0xfb, 0x90, 0x46, 0xb3, 0x68, 0x27, 0x0b, 0x73, 0xb6, 0xed, 0x2c}: "OemUniversalDxe",
		efi.GUID{0x48, 0x65, 0xea, 0xbc, 0x04, 0xe2, 0x86, 0x44, 0x8f, 0x2a, 0x36, 0xe1, 0x3c, 0x78, 0x38, 0xce}: "FpgaSocketSetup",
		efi.GUID{0x48, 0x67, 0xa7, 0xaa, 0x02, 0x36, 0x0a, 0x45, 0xb9, 0x05, 0x6a, 0x98, 0xa3, 0xe6, 0xd3, 0x63}: "ProjectDxe",
		efi.GUID{0x48, 0x74, 0xcd, 0xb1, 0x9c, 0x31, 0xaa, 0x41, 0x82, 0x1d, 0x3e, 0x60, 0x6b, 0xf6, 0xf9, 0x0d}: "SmcOemActivation",
		efi.GUID{0x48, 0x7a, 0x1b, 0xc1, 0x61, 0xba, 0xb4, 0x48, 0x91, 0x98, 0x48, 0x97, 0x2b, 0x53, 0x80, 0x07}: "SystemSdLegacySmm",
		efi.GUID{0x48, 0x89, 0x6f, 0xf1, 0x1f, 0xf8, 0x30, 0x4f, 0x91, 0xa6, 0x8f, 0x2f, 0x0f, 0xd5, 0x78, 0x82}: "MAPS_SIO_InterfacePei",
		efi.GUID{0x48, 0x8a, 0xd3, 0xc2, 0xac, 0xd3, 0xda, 0x43, 0xa4, 0x84, 0x17, 0xf9, 0x80, 0x86, 0x4d, 0xea}: "AmdHspFtpmPei",
		efi.GUID{0x48, 0x8c, 0xf9, 0x5c, 0xa3, 0xf2, 0x2a, 0x46, 0x90, 0xd6, 0x88, 0x37, 0x40, 0x0b, 0x4c, 0x09}: "ForceEfiBootDxe",
		efi.GUID{0x48, 0x90, 0x53, 0xcd, 0x6f, 0xf1, 0x86, 0x4f, 0xbd, 0x86, 0x6b, 0x72, 0x6b, 0xdc, 0x34, 0xf4}: "HpAcpiPlatform",
		efi.GUID{0x48, 0xb2, 0x0c, 0x47, 0xac, 0xe8, 0x3c, 0x47, 0xbb, 0x4f, 0x81, 0x06, 0x9a, 0x1f, 0xe6, 0xfd}: "SmmFaultTolerantWriteDxe",
		efi.GUID{0x48, 0xb7, 0x8d, 0xe8, 0x47, 0xa9, 0xcf, 0x46, 0xab, 0x6f, 0x5c, 0x99, 0xb6, 0xc6, 0xc4, 0xb8}: "RealtekGopDriver",
		efi.GUID{0x48, 0xbb, 0x66, 0x8a, 0x23, 0x6f, 0x09, 0x48, 0x93, 0x8d, 0x33, 0xac, 0xa6, 0xc4, 0x81, 0xae}: "FjPciPei",
		efi.GUID{0x48, 0xbe, 0x01, 0x03, 0x25, 0x7d, 0x3c, 0x44, 0xaa, 0x77, 0xd5, 0xe7, 0x53, 0xdb, 0x41, 0x6a}: "EfiRsaBmcCommandsProtocol",
		efi.GUID{0x48, 0xc0, 0x1f, 0x93, 0x1d, 0xc7, 0x55, 0x44, 0x89, 0x30, 0x47, 0x06, 0x30, 0xe3, 0x0e, 0xe5}: "SmmPerformanceExProtocolGuid",
		efi.GUID{0x48, 0xc5, 0x86, 0xa8, 0xdd, 0x0c, 0x2e, 0x4e, 0xb3, 0x64, 0xae, 0x95, 0x6a, 0xaa, 0x45, 0x54}: "SwSmi534D0540",
		efi.GUID{0x48, 0xd4, 0xcf, 0x5d, 0x4c, 0x79, 0xe9, 0x40, 0xbd, 0xe4, 0x4a, 0x92, 0x3a, 0x92, 0x53, 0xf8}: "OemNvramDxe",
		efi.GUID{0x48, 0xd4, 0xfc, 0xc1, 0x00, 0x63, 0x58, 0x44, 0xb8, 0x64, 0x28, 0xdf, 0x01, 0x53, 0x64, 0xbc}: "EfiPeiLoadedImagePpiGuid",
		efi.GUID{0x48, 0xd7, 0x08, 0x74, 0x8c, 0xfc, 0xe6, 0x4e, 0x92, 0x88, 0xc4, 0xbe, 0xc0, 0x92, 0xa4, 0x10}: "EfiPeiMasterBootModePpiGuid",
		efi.GUID{0x48, 0xdf, 0x67, 0xcf, 0x42, 0xf2, 0x81, 0x4d, 0xa8, 0x8b, 0x82, 0x83, 0x2c, 0x81, 0x08, 0xcd}: "AcerHwSupportDxe",
		efi.GUID{0x48, 0xee, 0xec, 0x82, 0x71, 0x95, 0x27, 0x44, 0x84, 0x85, 0x85, 0xa5, 0xa4, 0x5a, 0x0f, 0x39}: "DxeSmmReadyToLockOnExitPmAuthThunk",
		efi.GUID{0x48, 0xf7, 0xd7, 0xf7, 0xde, 0xcc, 0x1f, 0x48, 0x9b, 0x86, 0x2e, 0xf5, 0xed, 0xac, 0xc2, 0x1d}: "DellVideoConfigDxe",
		efi.GUID{0x49, 0x00, 0x53, 0xf1, 0x92, 0x12, 0x78, 0x4d, 0x9f, 0x26, 0xd3, 0xd5, 0x9d, 0x17, 0xe5, 0xe4}: "LenovoEcEkKeyDXE",
		efi.GUID{0x49, 0x06, 0xb4, 0xe2, 0xa4, 0xea, 0x4f, 0x43, 0x8b, 0xbc, 0x9f, 0xa4, 0xa8, 0x2e, 0x6a, 0xae}: "AmdSmmControl",
		efi.GUID{0x49, 0x0a, 0x22, 0x63, 0x09, 0x79, 0xd6, 0x44, 0xa6, 0xd0, 0xf3, 0x63, 0x4c, 0xc9, 0x21, 0xa6}: "OemPei",
		efi.GUID{0x49, 0x0a, 0x46, 0xb6, 0xc1, 0x0a, 0x4f, 0x48, 0xae, 0x58, 0xf1, 0x6e, 0xb2, 0x39, 0xdb, 0x3d}: "TpmBootFlowVariable",
		efi.GUID{0x49, 0x0b, 0xbf, 0x0d, 0x4c, 0x60, 0xd4, 0x40, 0x91, 0x21, 0x77, 0xac, 0x41, 0x94, 0x26, 0x26}: "FixedBootOrder",
		efi.GUID{0x49, 0x10, 0x30, 0x48, 0xdf, 0xef, 0xd4, 0x4d, 0x89, 0x62, 0xe2, 0x65, 0x86, 0x12, 0x3a, 0xdf}: "AmdMemoryHobInfoPeimRmb",
		efi.GUID{0x49, 0x19, 0xf5, 0x27, 0x77, 0x15, 0xf6, 0x4c, 0xb2, 0xe2, 0xae, 0x93, 0x92, 0xa4, 0xeb, 0xb7}: "BootPriority",
		efi.GUID{0x49, 0x30, 0x3f, 0x52, 0x9a, 0x81, 0x98, 0x49, 0x84, 0x05, 0x78, 0x48, 0xbc, 0x8c, 0x49, 0x42}: "BiosCfgTool",
		efi.GUID{0x49, 0x31, 0x13, 0x38, 0xf1, 0x14, 0x79, 0x41, 0xb1, 0x87, 0xef, 0xe7, 0xd3, 0xf7, 0x47, 0x9d}: "FjGabiFlashCommonMeRegionCtrlSmm",
		efi.GUID{0x49, 0x32, 0xd3, 0x7a, 0xc9, 0x4b, 0x31, 0x4d, 0x98, 0x55, 0x06, 0xd3, 0xa8, 0xc0, 0x52, 0xa0}: "WlanControllerSmm",
		efi.GUID{0x49, 0x34, 0x03, 0xce, 0x90, 0x3d, 0x44, 0x96, 0x86, 0x2e, 0x2d, 0x7d, 0x9a, 0xa3, 0xf0, 0x6a}: "BinConvert",
		efi.GUID{0x49, 0x36, 0x3c, 0xd9, 0xa5, 0x69, 0xc7, 0x43, 0x8c, 0xd3, 0x49, 0xd4, 0x17, 0x72, 0x45, 0x3a}: "FchPromontoryPlusGpioPei",
		efi.GUID{0x49, 0x36, 0x8b, 0x36, 0x04, 0xf2, 0xd0, 0x4c, 0x89, 0xa8, 0x09, 0x10, 0x77, 0xc0, 0x70, 0xfa}: "AcpiPlatform",
		efi.GUID{0x49, 0x3d, 0xfe, 0xb8, 0xf3, 0xdc, 0xbb, 0x4c, 0x80, 0x70, 0x47, 0xb4, 0xf5, 0xa3, 0x45, 0x59}: "GopDebugDxe",
		efi.GUID{0x49, 0x55, 0x9a, 0xf5, 0x79, 0xb8, 0x0c, 0x44, 0xa1, 0xf6, 0x38, 0xaf, 0x40, 0xf2, 0x77, 0x3e}: "PcieSataController",
		efi.GUID{0x49, 0x56, 0x80, 0x82, 0x47, 0x72, 0xa4, 0x4d, 0x86, 0x43, 0xc8, 0x14, 0x4d, 0x27, 0xe2, 0xe5}: "ProcMemErrReporting",
		efi.GUID{0x49, 0x59, 0x93, 0x35, 0x07, 0x1e, 0xde, 0x4f, 0xb2, 0xc2, 0x84, 0x48, 0xe0, 0x74, 0x32, 0x2a}: "FjPasswordInvalidHandler",
		efi.GUID{0x49, 0x60, 0xf0, 0x89, 0x97, 0xf2, 0x36, 0x44, 0x85, 0x40, 0xe0, 0xbf, 0x9e, 0x92, 0xb5, 0x6b}: "SdioRecovery",
		efi.GUID{0x49, 0x69, 0x2b, 0xdf, 0xaf, 0xb0, 0xb3, 0x42, 0xa7, 0x0a, 0x93, 0x5d, 0x48, 0x75, 0xe4, 0x80}: "OemRomIdVar",
		efi.GUID{0x49, 0x6f, 0x5b, 0x04, 0x02, 0x91, 0x90, 0x45, 0xa0, 0xa5, 0x35, 0x31, 0x1b, 0x0a, 0xef, 0xc3}: "EfiDpsdRSA1024AndSHA256SignatureVerificationProtocolGuid",
		efi.GUID{0x49, 0x73, 0xfe, 0xd0, 0xfb, 0x5f, 0x4c, 0x42, 0x93, 0xd6, 0xaa, 0xe9, 0xcf, 0xe4, 0xd9, 0x09}: "SmuV12PeiCZN",
		efi.GUID{0x49, 0x7c, 0xd2, 0xd6, 0xca, 0x66, 0xc7, 0x42, 0xbc, 0x51, 0x78, 0x83, 0x28, 0xb5, 0xe5, 0xd0}: "SwSmi534D0240",
		efi.GUID{0x49, 0x87, 0xe8, 0x10, 0xd1, 0x28, 0xa0, 0x49, 0xac, 0x9e, 0x03, 0x24, 0xe4, 0x02, 0x11, 0xa8}: "WMISwSmi",
		efi.GUID{0x49, 0x96, 0x00, 0xf3, 0xd6, 0x36, 0x64, 0x41, 0xaa, 0x05, 0xe7, 0x2d, 0xee, 0xa3, 0x72, 0x2f}: "EfiCseEndofServicesProtocolGuid",
		efi.GUID{0x49, 0x99, 0x09, 0x58, 0x8b, 0xc8, 0x17, 0x41, 0x81, 0xa9, 0xdb, 0x89, 0x49, 0x91, 0x7c, 0xd8}: "SpdDxe",
		efi.GUID{0x49, 0x9e, 0x81, 0x1a, 0xee, 0xd8, 0xcb, 0x48, 0x9a, 0x9c, 0x0a, 0xa0, 0xd2, 0x81, 0x0a, 0x38}: "DxePchPolicyUpdateProtocolGuid",
		efi.GUID{0x49, 0xa2, 0x0e, 0x29, 0x88, 0x6e, 0x3c, 0x42, 0xb0, 0xda, 0x75, 0xcd, 0xde, 0x79, 0x20, 0xcc}: "AmtPetAlertDxe",
		efi.GUID{0x49, 0xb0, 0x8d, 0x7b, 0xc7, 0xc7, 0x3b, 0x4d, 0x80, 0x9f, 0x92, 0x6d, 0xee, 0x47, 0xcc, 0xa2}: "SBSMI",
		efi.GUID{0x49, 0xb1, 0x0b, 0x98, 0x36, 0xf0, 0x49, 0x44, 0xbc, 0xf0, 0x58, 0xc2, 0x22, 0x07, 0xcb, 0xb1}: "FjNuvotonNct6796Dxe",
		efi.GUID{0x49, 0xb2, 0xb6, 0xd8, 0xf8, 0x77, 0x09, 0x48, 0xac, 0xe2, 0x59, 0x75, 0xda, 0x16, 0xaa, 0xf5}: "TouchPadDriver",
		efi.GUID{0x49, 0xba, 0x02, 0x66, 0xe4, 0x08, 0x28, 0x44, 0x96, 0x61, 0xd5, 0xe7, 0x15, 0x7f, 0x8a, 0x9d}: "AmdLegacyInterrupt",
		efi.GUID{0x49, 0xba, 0x7c, 0xc6, 0xc6, 0xb3, 0xba, 0x4c, 0x96, 0x71, 0xbf, 0x27, 0x88, 0x71, 0x21, 0x28}: "DellLegacyTcgSupport",
		efi.GUID{0x49, 0xba, 0xd1, 0x4f, 0x90, 0x8f, 0x1a, 0x47, 0xa2, 0xc9, 0x17, 0x3c, 0x7a, 0x73, 0x2f, 0xd0}: "SeCfTPMPolicyPpiGuid",
		efi.GUID{0x49, 0xc9, 0x94, 0xb8, 0xf8, 0xa1, 0xc1, 0x41, 0xa7, 0xc0, 0xdf, 0x52, 0x3a, 0xd9, 0x1c, 0x15}: "MrcPlatformHooksPeim",
		efi.GUID{0x49, 0xd9, 0xfd, 0x4e, 0x71, 0xe8, 0x21, 0x4a, 0x96, 0xb6, 0xb1, 0x61, 0xb2, 0x71, 0xb9, 0xbf}: "BiosIdentifiedInfo",
		efi.GUID{0x49, 0xe0, 0x91, 0x8c, 0xf9, 0x9b, 0x0e, 0x44, 0xbb, 0xad, 0x7d, 0xc5, 0xfc, 0x08, 0x2c, 0x02}: "DWMciDxe",
		efi.GUID{0x49, 0xec, 0x8f, 0xcd, 0x5d, 0xf2, 0x24, 0x4a, 0x8f, 0xb8, 0xef, 0x9c, 0xa5, 0x80, 0x67, 0xf0}: "SbSocRsPei",
		efi.GUID{0x49, 0xf0, 0xaf, 0xa1, 0xeb, 0xfd, 0x2a, 0x44, 0xb3, 0x20, 0x13, 0xab, 0x4c, 0xb7, 0x2b, 0xbc}: "EfiMdeModulePkgTokenSpaceGuid",
		efi.GUID{0x49, 0xf4, 0x1a, 0x30, 0xd7, 0xe0, 0xa3, 0x43, 0x8b, 0x1b, 0xbc, 0x16, 0x72, 0x5d, 0x37, 0x4b}: "DxeDebugDispatchProtocolGuid",
		efi.GUID{0x49, 0xf7, 0xd8, 0x01, 0x74, 0xfd, 0x70, 0x4f, 0xa3, 0x93, 0x6f, 0xed, 0x1d, 0x2c, 0x8d, 0x32}: "AsusWmiToProtocol",
		efi.GUID{0x49, 0xfd, 0xdc, 0x47, 0x10, 0xf1, 0xf8, 0x4e, 0x98, 0xd4, 0xd8, 0xc8, 0x88, 0x32, 0x70, 0xda}: "D01IhisiSmm",
		efi.GUID{0x4a, 0x0a, 0x70, 0x76, 0xc7, 0x25, 0x2f, 0x4b, 0xb1, 0x90, 0x8d, 0xab, 0xb2, 0xef, 0x21, 0x29}: "FchSmbusDxe",
		efi.GUID{0x4a, 0x0c, 0x7e, 0x78, 0x27, 0x4a, 0x91, 0x48, 0x94, 0x89, 0xaf, 0x50, 0x74, 0xc3, 0x6e, 0x89}: "EfiTraceHubStatusCodeHandleHeaderPpi",
		efi.GUID{0x4a, 0x0d, 0xff, 0xc1, 0xb0, 0x15, 0x8e, 0x49, 0x9b, 0x7e, 0x92, 0x4d, 0xc0, 0x31, 0x78, 0x49}: "semaProtocol",
		efi.GUID{0x4a, 0x10, 0x9b, 0xd2, 0x98, 0xbe, 0x4a, 0x46, 0x97, 0x71, 0x74, 0x6b, 0x9a, 0x07, 0xdc, 0xa1}: "FjSysmanWatchdogBin",
		efi.GUID{0x4a, 0x2c, 0x71, 0x5f, 0x9c, 0x8b, 0xe6, 0x4e, 0xad, 0xc6, 0xf4, 0x24, 0x1e, 0x2a, 0x41, 0x29}: "SmbiosType1",
		efi.GUID{0x4a, 0x2d, 0xcf, 0x42, 0xb4, 0x78, 0x80, 0x4b, 0x80, 0xf9, 0x96, 0xa8, 0x3a, 0x63, 0x0d, 0x70}: "UsbDeviceDxe",
		efi.GUID{0x4a, 0x31, 0x75, 0xe9, 0x64, 0x14, 0x1f, 0x41, 0x85, 0xe4, 0x04, 0x1d, 0x90, 0x3c, 0xb6, 0xc4}: "DellSmBiosStrucFan",
		efi.GUID{0x4a, 0x35, 0xef, 0x3c, 0x7a, 0x3b, 0x19, 0x45, 0xad, 0x70, 0x72, 0xa1, 0x34, 0x69, 0x83, 0x11}: "Ebl",
		efi.GUID{0x4a, 0x35, 0xf5, 0x8f, 0x4f, 0x63, 0x37, 0x46, 0xb3, 0xce, 0x4d, 0xf1, 0xce, 0x6b, 0x56, 0xfe}: "RtkUndi8111H",
		efi.GUID{0x4a, 0x38, 0x68, 0x91, 0x66, 0x5f, 0xf7, 0x4c, 0xae, 0xb6, 0x84, 0x5b, 0xde, 0xbd, 0x30, 0x12}: "PlatformFlashAccessLibDxe",
		efi.GUID{0x4a, 0x3a, 0x47, 0x9a, 0xeb, 0x4c, 0x5a, 0xb9, 0x41, 0x5e, 0x5b, 0xa0, 0xbc, 0x63, 0x9b, 0x2e}: "EfiRegexSyntaxTypeEcma262Guid",
		efi.GUID{0x4a, 0x3b, 0xe3, 0x5f, 0x10, 0xdc, 0xb5, 0x4e, 0x7e, 0x51, 0x36, 0x4c, 0x56, 0xd9, 0x11, 0xf4}: "D01SecureEraseDxe",
		efi.GUID{0x4a, 0x3d, 0x2a, 0xaa, 0xbb, 0xfd, 0x27, 0x4c, 0xbf, 0x42, 0x1c, 0x74, 0xf1, 0x74, 0x2e, 0x82}: "OemIp3Pei",
		efi.GUID{0x4a, 0x45, 0x2a, 0x84, 0xe5, 0x75, 0x8b, 0x40, 0x8b, 0x1c, 0x36, 0x42, 0x0e, 0x4e, 0x3f, 0x21}: "NvramSmi",
		efi.GUID{0x4a, 0x45, 0x78, 0x14, 0x84, 0x45, 0xca, 0x4c, 0xb0, 0xd2, 0x12, 0x0a, 0xce, 0x12, 0x9d, 0xbb}: "DellMfgModeSmmDriver",
		efi.GUID{0x4a, 0x57, 0x74, 0xe3, 0xdf, 0x2a, 0xdb, 0x43, 0xa7, 0x78, 0x88, 0xa7, 0x5f, 0xc0, 0x80, 0x26}: "DellSmbDaTokensConfig",
		efi.GUID{0x4a, 0x65, 0xb0, 0xb3, 0x9d, 0x96, 0x96, 0x40, 0x86, 0xcb, 0x27, 0xe2, 0x62, 0xa0, 0x20, 0x83}: "PeiCoreEntryPoint",
		efi.GUID{0x4a, 0x6d, 0x92, 0x29, 0x31, 0xe5, 0x0c, 0x49, 0xa5, 0x29, 0xc0, 0x5e, 0x8a, 0x1d, 0x60, 0xd3}: "FwhFlashLibNull",
		efi.GUID{0x4a, 0x72, 0x51, 0x53, 0x47, 0x7d, 0x34, 0x48, 0x9c, 0x59, 0x0d, 0xd0, 0x1f, 0x30, 0x5e, 0x16}: "FjSmmSupport",
		efi.GUID{0x4a, 0x77, 0xe3, 0x55, 0x45, 0xeb, 0xd2, 0x4f, 0xaa, 0xae, 0xb7, 0xde, 0xeb, 0x50, 0x4a, 0x0e}: "Tcg2Pei",
		efi.GUID{0x4a, 0x7f, 0x68, 0x05, 0xa7, 0x3c, 0x19, 0x4d, 0x9b, 0xc5, 0xe1, 0x80, 0xce, 0xa3, 0x56, 0x9f}: "AmiPlatformSecurityChipGuid",
		efi.GUID{0x4a, 0x82, 0xde, 0x06, 0xe2, 0xa4, 0x95, 0x42, 0xa3, 0xf6, 0x03, 0xb3, 0xfe, 0xf5, 0xb1, 0x09}: "LenovoSecurityVariableDxe",
		efi.GUID{0x4a, 0x89, 0xea, 0x09, 0x0d, 0xbe, 0x30, 0x42, 0xa0, 0x03, 0xed, 0xc6, 0x93, 0xb4, 0x8e, 0x95}: "PchInitPpiGuid",
		efi.GUID{0x4a, 0x8c, 0x94, 0x98, 0xf2, 0x70, 0x35, 0x40, 0x8e, 0x9f, 0x59, 0x27, 0x49, 0x3c, 0xfc, 0x07}: "FaultTolerantWriteSmmDxe",
		efi.GUID{0x4a, 0x8e, 0x76, 0x85, 0xdc, 0x6c, 0x4e, 0x44, 0x93, 0xdf, 0x93, 0x66, 0x85, 0xb5, 0xdf, 0xcc}: "VlvRefCodePkgTokenSpaceGuid",
		efi.GUID{0x4a, 0x94, 0x33, 0x6d, 0x75, 0xec, 0x55, 0x48, 0xa5, 0x4d, 0x80, 0x9c, 0x75, 0x24, 0x1f, 0x6c}: "BdsDxe",
		efi.GUID{0x4a, 0x9c, 0xc5, 0xcb, 0x3a, 0x38, 0xeb, 0x41, 0xa8, 0xee, 0x44, 0x98, 0xae, 0xa5, 0x67, 0xe4}: "FlashDriver",
		efi.GUID{0x4a, 0x9c, 0xee, 0x6c, 0xa0, 0xe2, 0x3d, 0x4f, 0xa9, 0x21, 0xce, 0x25, 0xf3, 0x28, 0xc4, 0xba}: "AsfSmm",
		efi.GUID{0x4a, 0xab, 0x10, 0x18, 0x14, 0x23, 0xf6, 0x4d, 0x81, 0xeb, 0x67, 0xc6, 0xec, 0x05, 0x85, 0x91}: "BootScriptTableBaseGuid",
		efi.GUID{0x4a, 0xab, 0x4c, 0x15, 0xb5, 0x52, 0xcd, 0x46, 0x99, 0xc3, 0x43, 0x68, 0xab, 0xba, 0xcf, 0xfd}: "MetronomeDxe",
		efi.GUID{0x4a, 0xab, 0xe6, 0xe5, 0x7d, 0x0d, 0x06, 0x4a, 0xa1, 0x64, 0x61, 0xe4, 0x7c, 0xce, 0x9b, 0x3b}: "DellAcpiPolicy",
		efi.GUID{0x4a, 0xac, 0xc3, 0x79, 0xc6, 0xde, 0xf1, 0x48, 0xaf, 0xfe, 0xe7, 0xb9, 0x5a, 0x1c, 0xcb, 0x32}: "PoofAnimationState2",
		efi.GUID{0x4a, 0xaf, 0xca, 0xf7, 0xdd, 0xb2, 0x1a, 0x43, 0x89, 0x64, 0x37, 0x5d, 0x7e, 0x71, 0xb9, 0xb1}: "SMBIOSTypeDAhCallingInterfaceSmm",
		efi.GUID{0x4a, 0xaf, 0xfd, 0x2f, 0xb5, 0xa9, 0xf6, 0x4e, 0xaa, 0x3b, 0xa8, 0x96, 0x11, 0xaa, 0xb2, 0x84}: "DellSpiPartPromJet",
		efi.GUID{0x4a, 0xb3, 0x4a, 0xf9, 0x69, 0x80, 0x9f, 0x4a, 0xad, 0x08, 0x95, 0x34, 0xef, 0x37, 0xd9, 0xbe}: "DellMeLocalFwUpdateDxe",
		efi.GUID{0x4a, 0xb3, 0xe4, 0x81, 0x8c, 0x26, 0xcc, 0x4f, 0x8e, 0x39, 0x1c, 0x1d, 0x3e, 0x6f, 0x6e, 0x69}: "HddReadyDXE",
		efi.GUID{0x4a, 0xb7, 0xab, 0xcc, 0x77, 0x60, 0xf7, 0x49, 0xa2, 0x91, 0x71, 0xeb, 0xb7, 0xa7, 0x03, 0x6c}: "OA1",
		efi.GUID{0x4a, 0xbb, 0xa0, 0x3f, 0x0b, 0x18, 0x58, 0x44, 0x9f, 0x12, 0x6e, 0xa6, 0x8f, 0x69, 0xe6, 0xcc}: "PxeRomB571699",
		efi.GUID{0x4a, 0xc4, 0x1a, 0x8f, 0x7e, 0xce, 0x29, 0x4e, 0x95, 0xbb, 0x92, 0xe3, 0x21, 0xbb, 0x15, 0x73}: "SecFspWrapperPlatformSecLibSample",
		efi.GUID{0x4a, 0xc7, 0xb9, 0xc5, 0x72, 0x6d, 0x19, 0x47, 0x99, 0xab, 0xc5, 0x9f, 0x19, 0x90, 0x91, 0xeb}: "SemihostFs",
		efi.GUID{0x4a, 0xc7, 0xc1, 0x2b, 0x2f, 0x12, 0xb2, 0x40, 0xb2, 0x23, 0x08, 0x2b, 0x74, 0x65, 0x22, 0x5d}: "FspWrapperTokenSpaceGuid",
		efi.GUID{0x4a, 0xc9, 0x99, 0x28, 0xb6, 0x1f, 0x1a, 0x4b, 0xb9, 0x6b, 0x83, 0x64, 0x97, 0x53, 0x03, 0xe0}: "Ps2MouseAbsolutePointerDxe",
		efi.GUID{0x4a, 0xc9, 0xaf, 0x04, 0xaf, 0x73, 0x2f, 0x43, 0xbe, 0xcb, 0xb7, 0x94, 0x56, 0x8a, 0xc9, 0x85}: "DellOnboardNicSmm",
		efi.GUID{0x4a, 0xda, 0x4d, 0xff, 0xe4, 0x64, 0xa4, 0x42, 0x96, 0xca, 0x3d, 0x4f, 0x2d, 0x43, 0x11, 0xa9}: "AmdPlatformCustomizeDxe",
		efi.GUID{0x4a, 0xdc, 0xa5, 0x12, 0xaa, 0x88, 0xda, 0x89, 0x89, 0xd0, 0xd4, 0x54, 0x71, 0x91, 0xe3, 0xf4}: "RstUefiDriverSupport",
		efi.GUID{0x4a, 0xdc, 0xc5, 0x3d, 0x4a, 0x82, 0xc5, 0x44, 0x89, 0xd0, 0xd4, 0x54, 0x71, 0x91, 0xe3, 0xf4}: "RstOneClickEnable",
		efi.GUID{0x4a, 0xe2, 0x2d, 0xb0, 0x94, 0x07, 0x4a, 0x43, 0xa8, 0xa0, 0x04, 0xa0, 0xf6, 0x8d, 0x85, 0x7a}: "N17PQ3Gop",
		efi.GUID{0x4a, 0xf6, 0xcb, 0xbc, 0x31, 0x52, 0x6e, 0x42, 0xae, 0x37, 0x4c, 0xc7, 0x0f, 0x15, 0x81, 0x3d}: "SetupLanguageDxe",
		efi.GUID{0x4a, 0xf8, 0xfb, 0xb1, 0x91, 0xc0, 0x80, 0x4a, 0xa7, 0x44, 0x23, 0x44, 0x2a, 0x2b, 0x7b, 0xdf}: "AmiChipsetPkgTokenSpaceGuid",
		efi.GUID{0x4a, 0xfb, 0x97, 0xb5, 0x27, 0x35, 0x82, 0x49, 0xa4, 0xe4, 0x8e, 0x21, 0x2c, 0x3c, 0xca, 0x9c}: "AcpiSdevAcpiTable",
		efi.GUID{0x4a, 0xfd, 0xa4, 0x25, 0x03, 0x97, 0xa9, 0x4b, 0xa1, 0x90, 0xb7, 0xc8, 0x4e, 0xfb, 0x3e, 0x57}: "FdtVariableGuid",
		efi.GUID{0x4a, 0xfe, 0xbc, 0x7a, 0xd2, 0xf5, 0x3a, 0x41, 0x98, 0x28, 0x25, 0x9e, 0x6b, 0x12, 0x8d, 0xc9}: "LcfcWorkaroundMfgDoneDxe",
		efi.GUID{0x4a, 0xff, 0x0f, 0xc3, 0xc6, 0x10, 0x0f, 0x4c, 0xa4, 0x54, 0xfd, 0x31, 0x9b, 0xaf, 0x6c, 0xe6}: "IntelBootGuardBootPolicy",
		efi.GUID{0x4b, 0x22, 0x5b, 0x51, 0x59, 0xb0, 0x0b, 0x46, 0x85, 0xc7, 0xc2, 0x86, 0x58, 0xf4, 0xb8, 0x98}: "LenovoHpmSmm",
		efi.GUID{0x4b, 0x2a, 0xb7, 0xfa, 0x7f, 0xe6, 0x51, 0x49, 0x84, 0x5c, 0xbe, 0x5d, 0x8f, 0x5a, 0xe6, 0x2f}: "AmdCcxZen3RmbDxe",
		efi.GUID{0x4b, 0x2d, 0x03, 0x71, 0x91, 0x4b, 0xc1, 0x4e, 0xad, 0x53, 0x81, 0x82, 0x7f, 0xb4, 0x31, 0x08}: "AmdCpmGpioInitDxe",
		efi.GUID{0x4b, 0x33, 0x96, 0xfd, 0x26, 0x2f, 0xbe, 0x42, 0xa9, 0x47, 0x7a, 0xef, 0xb4, 0xaf, 0x92, 0x91}: "IntelLanDriverPolicy",
		efi.GUID{0x4b, 0x37, 0x9f, 0x9e, 0x16, 0x8f, 0x30, 0x42, 0x98, 0x24, 0x58, 0x46, 0xee, 0x76, 0x6a, 0x97}: "EfiSecPlatformInformation2PpiGuid",
		efi.GUID{0x4b, 0x4c, 0x87, 0xa9, 0x9b, 0x59, 0x46, 0x4b, 0x81, 0x61, 0xfa, 0x4e, 0x72, 0xe5, 0x3b, 0xba}: "ShadowDownPei",
		efi.GUID{0x4b, 0x5a, 0xbb, 0x55, 0x3f, 0x3b, 0x2c, 0x44, 0xbf, 0x09, 0x0f, 0x87, 0xa6, 0x7e, 0x8e, 0xe7}: "BindingsDxe",
		efi.GUID{0x4b, 0x5c, 0x1b, 0x80, 0xe2, 0x6a, 0x65, 0x40, 0x9f, 0x72, 0x82, 0xca, 0x76, 0x0c, 0x2e, 0xca}: "EfiRsaTpmClearOwnership",
		efi.GUID{0x4b, 0x6c, 0x0a, 0x74, 0x13, 0x38, 0x05, 0x4a, 0x84, 0xb5, 0x9a, 0xee, 0x2b, 0xbe, 0x9f, 0x5e}: "FjFvFlashSmm",
		efi.GUID{0x4b, 0x6e, 0x11, 0xd5, 0xd6, 0xda, 0x22, 0x41, 0xa0, 0x96, 0x08, 0xd3, 0x39, 0xb7, 0xfa, 0x40}: "ProcessErrorCode",
		efi.GUID{0x4b, 0x76, 0x86, 0x6f, 0xe4, 0xbb, 0xa1, 0x49, 0xa5, 0xd2, 0x32, 0xe6, 0xa6, 0x86, 0x18, 0x34}: "FchSmmDiagDispatcher",
		efi.GUID{0x4b, 0x76, 0xdb, 0x0f, 0x69, 0xe6, 0x69, 0x4c, 0x83, 0xac, 0x5e, 0xdd, 0x99, 0xa2, 0x71, 0x1e}: "ReadOnlyVariableOnReadOnlyVariable2Thunk",
		efi.GUID{0x4b, 0x7d, 0x98, 0xd3, 0x1a, 0x97, 0x5f, 0x43, 0x8c, 0xaf, 0x49, 0x67, 0xeb, 0x62, 0x72, 0x41}: "SerialDxe",
		efi.GUID{0x4b, 0x87, 0xae, 0xee, 0xd3, 0x64, 0x23, 0x43, 0xb5, 0x82, 0x54, 0x5f, 0xb3, 0xc2, 0xeb, 0x5a}: "SmmBbsManagerInitNotifyProtocol",
		efi.GUID{0x4b, 0x8f, 0xb8, 0xb3, 0x42, 0x70, 0x8e, 0x48, 0xa2, 0x55, 0x66, 0xf9, 0x65, 0xe8, 0xd4, 0x35}: "PasswordPopupDxe",
		efi.GUID{0x4b, 0x93, 0x37, 0x67, 0x7e, 0xa2, 0x05, 0x4c, 0xad, 0x5b, 0x6a, 0xb8, 0x62, 0x73, 0x68, 0x0b}: "AmiNbMrcInfo",
		efi.GUID{0x4b, 0xa2, 0x7c, 0xea, 0xd5, 0xde, 0xad, 0x4d, 0xa3, 0x89, 0xbf, 0x82, 0x7e, 0x8f, 0x9b, 0x38}: "EfiPeiFirmwareVolumeInfo2PpiGuid",
		efi.GUID{0x4b, 0xae, 0xe2, 0x2d, 0x89, 0x74, 0x91, 0x4d, 0x9b, 0x63, 0x9b, 0x12, 0xcc, 0x56, 0x45, 0x40}: "A01ServiceBodyDxe",
		efi.GUID{0x4b, 0xaf, 0xd5, 0x3d, 0x25, 0x09, 0x81, 0x4c, 0x93, 0xac, 0x79, 0x17, 0x4c, 0x47, 0x82, 0xd8}: "NetworkBootConfigurationSmm",
		efi.GUID{0x4b, 0xb1, 0xd6, 0x00, 0xd0, 0x7d, 0x62, 0x40, 0x88, 0x21, 0xe5, 0xf9, 0x6a, 0x2a, 0x1b, 0x00}: "FspReservedMemoryResourceHobMiscGuid",
		efi.GUID{0x4b, 0xca, 0xe4, 0x3a, 0x5b, 0xb5, 0x11, 0x4c, 0x8f, 0xac, 0x7c, 0x95, 0xd7, 0x42, 0x3f, 0x68}: "BiosGuardInstallGuidSmm",
		efi.GUID{0x4b, 0xd1, 0x9d, 0xc7, 0x6d, 0xc6, 0xdd, 0x4a, 0xa5, 0xa1, 0xcb, 0xe3, 0xfd, 0xf2, 0xbd, 0x72}: "DisableCacheAsRamPei",
		efi.GUID{0x4b, 0xdb, 0x2c, 0xa9, 0xf1, 0x82, 0x0b, 0x4e, 0xa5, 0x16, 0x8a, 0x65, 0x5d, 0x37, 0x15, 0x24}: "VirtioNetDxe",
		efi.GUID{0x4b, 0xdb, 0xeb, 0x03, 0xba, 0x96, 0x40, 0x4f, 0x83, 0x29, 0x7f, 0x3a, 0xa8, 0x86, 0x57, 0x07}: "EcIoSmm",
		efi.GUID{0x4b, 0xdc, 0xa5, 0x12, 0xaa, 0x88, 0xda, 0x89, 0x89, 0xd0, 0xd4, 0x54, 0x71, 0x91, 0xe3, 0xf4}: "SdMmcOverride",
		efi.GUID{0x4b, 0xe1, 0xa7, 0x3b, 0x6d, 0x17, 0x2a, 0x4b, 0x94, 0x8a, 0xc8, 0x6f, 0xb0, 0x01, 0x94, 0x3c}: "EfiErrorHandlingProtocol",
		efi.GUID{0x4b, 0xf4, 0x08, 0x58, 0x01, 0xe5, 0x7f, 0x46, 0x88, 0x99, 0x67, 0x0b, 0x9a, 0xdb, 0xd0, 0x1c}: "RealtekLib",
		efi.GUID{0x4c, 0x05, 0x56, 0xaf, 0x1a, 0x8b, 0x9f, 0x40, 0xba, 0xf0, 0x89, 0x3c, 0xb9, 0x64, 0xaa, 0x4e}: "FjSysmanWatchdogPeiBin",
		efi.GUID{0x4c, 0x09, 0xbf, 0x56, 0xf6, 0x69, 0xdd, 0x49, 0x8c, 0x1c, 0x1e, 0xce, 0xff, 0x71, 0xc9, 0xe5}: "CsmRt32",
		efi.GUID{0x4c, 0x1b, 0x73, 0xf7, 0xa2, 0x58, 0xf4, 0x4d, 0x89, 0x80, 0x56, 0x45, 0xd3, 0x9e, 0xce, 0x58}: "PowerMgmtDxe",
		efi.GUID{0x4c, 0x1f, 0xe2, 0x28, 0x8f, 0xdc, 0x17, 0x4c, 0x8b, 0x9a, 0x92, 0xbc, 0xee, 0x68, 0x35, 0xd5}: "OemACPIDriverHookDxe",
		efi.GUID{0x4c, 0x29, 0x8d, 0x3c, 0xc3, 0x5f, 0x51, 0x44, 0xbb, 0x31, 0xc4, 0xc0, 0x32, 0x29, 0x5e, 0x6c}: "IdleLoopEventGuid",
		efi.GUID{0x4c, 0x29, 0xbd, 0x56, 0x88, 0x44, 0x6d, 0x4b, 0xa6, 0x37, 0xea, 0xf1, 0x59, 0xb4, 0x3b, 0xed}: "OpromUpdateDxeCLX64L",
		efi.GUID{0x4c, 0x43, 0x44, 0x90, 0xe8, 0x40, 0xa1, 0x47, 0xa3, 0xba, 0x85, 0x07, 0xf3, 0xc0, 0xe2, 0x56}: "CpuUncoreTokenSpace",
		efi.GUID{0x4c, 0x43, 0xf4, 0x57, 0x1b, 0xa0, 0x7f, 0x48, 0xa4, 0x26, 0xac, 0x7b, 0xe1, 0xd7, 0x9d, 0xa2}: "UefiHotkey",
		efi.GUID{0x4c, 0x4a, 0x36, 0x00, 0x0a, 0x6a, 0x08, 0x4f, 0x8f, 0xfd, 0x09, 0x37, 0xf3, 0xdb, 0xb1, 0x3e}: "IdeBusBoard",
		efi.GUID{0x4c, 0x58, 0x1d, 0x91, 0xf7, 0x35, 0x55, 0x49, 0xbe, 0xf9, 0xb4, 0x52, 0x76, 0x9d, 0xdc, 0x3a}: "DebugSupportDxe",
		efi.GUID{0x4c, 0x65, 0x3f, 0x82, 0x66, 0xd9, 0xa4, 0x45, 0xa4, 0xcc, 0x5f, 0xb6, 0x74, 0x1e, 0x34, 0xbe}: "AmdNbioEarlyPhaseRMBPei",
		efi.GUID{0x4c, 0x65, 0xf3, 0x5b, 0x7d, 0x7e, 0xba, 0x4f, 0x8b, 0xc6, 0x2a, 0xeb, 0xcd, 0x6f, 0x68, 0xeb}: "Apple80211",
		efi.GUID{0x4c, 0x6e, 0xdb, 0x2a, 0x83, 0xc9, 0x40, 0x41, 0xa1, 0x60, 0xfb, 0xc7, 0xd6, 0xb4, 0x50, 0xd9}: "AmdSocAm4SmDxe",
		efi.GUID{0x4c, 0x71, 0x56, 0x69, 0xc3, 0xac, 0x8f, 0x44, 0x86, 0xb6, 0x56, 0xad, 0x3a, 0x2e, 0xb1, 0xbd}: "AdditionalLenovoUI",
		efi.GUID{0x4c, 0x73, 0xcb, 0x54, 0x5c, 0x97, 0x74, 0x4a, 0x95, 0x56, 0x57, 0xae, 0x6d, 0x9a, 0x22, 0x29}: "TrackPointElan",
		efi.GUID{0x4c, 0x8b, 0xd8, 0x5f, 0x58, 0xb6, 0x50, 0x46, 0xb3, 0xce, 0xa5, 0x9b, 0xb9, 0x91, 0xbf, 0xd4}: "IgdPanelConfigGuid",
		efi.GUID{0x4c, 0x98, 0x9a, 0x8e, 0xe7, 0x57, 0xeb, 0x4b, 0xa6, 0x2b, 0x58, 0x98, 0x2e, 0x06, 0x20, 0xf1}: "DellNvmePwSmm",
		efi.GUID{0x4c, 0xa9, 0x4a, 0x3c, 0x3c, 0x71, 0xe9, 0x45, 0xb2, 0x5c, 0x83, 0xda, 0xed, 0x17, 0x80, 0xac}: "LoadEFINetworkStack",
		efi.GUID{0x4c, 0xad, 0x3c, 0xce, 0x43, 0x47, 0x82, 0x04, 0x59, 0x09, 0xf3, 0x85, 0x30, 0x71, 0x78, 0xc2}: "NvmeResetHookDxe",
		efi.GUID{0x4c, 0xb1, 0x5b, 0xce, 0xb6, 0xdf, 0xa1, 0x49, 0xa6, 0x14, 0x77, 0x80, 0x4a, 0xcb, 0xb4, 0x89}: "AmdCpmOemUpepDxe",
		efi.GUID{0x4c, 0xb2, 0x6a, 0x9e, 0x00, 0xf8, 0xb1, 0x42, 0x92, 0xa2, 0xb3, 0x52, 0xac, 0xb9, 0x70, 0x05}: "AutomaticPowerOn",
		efi.GUID{0x4c, 0xc1, 0x42, 0xc6, 0x9c, 0x0e, 0xef, 0x4a, 0x94, 0xa5, 0xa2, 0x13, 0xba, 0xa3, 0x5d, 0xe0}: "HstiResultDxe",
		efi.GUID{0x4c, 0xc1, 0x5b, 0xce, 0xb6, 0xdf, 0xa1, 0x49, 0xa6, 0x14, 0x77, 0x80, 0x4a, 0xcb, 0xb4, 0x89}: "AmdCpmOemPTDxe",
		efi.GUID{0x4c, 0xd2, 0x5f, 0x9d, 0xdf, 0x53, 0xac, 0x44, 0xa3, 0x36, 0xb4, 0x87, 0x9c, 0xdb, 0x29, 0xd9}: "AmdSpiRomProtectPei",
		efi.GUID{0x4c, 0xde, 0x3c, 0xfa, 0xc2, 0x87, 0x7d, 0x42, 0xae, 0xde, 0x7d, 0xd0, 0x96, 0xc8, 0x8c, 0x58}: "IscsiV4Private",
		efi.GUID{0x4c, 0xe0, 0x4e, 0x31, 0x06, 0x11, 0xc6, 0x4d, 0xac, 0xbc, 0xcf, 0x19, 0xc0, 0xdb, 0xc5, 0xcc}: "PlatformInitAdvancedPostMem",
		efi.GUID{0x4c, 0xe0, 0xe8, 0xa0, 0x5a, 0x9b, 0xbe, 0x43, 0x8b, 0x7d, 0xc9, 0x87, 0x60, 0x49, 0x2b, 0x68}: "SectionExtractionDxe",
		efi.GUID{0x4c, 0xe9, 0x83, 0xd0, 0x60, 0x65, 0xe4, 0x42, 0xb6, 0xd4, 0x2d, 0xf7, 0x5a, 0xdf, 0x6a, 0x2a}: "EfiDataHubStatusCodeRecordGuid",
		efi.GUID{0x4c, 0xe9, 0xb0, 0xca, 0x5f, 0xe1, 0xe3, 0x11, 0x91, 0x8d, 0xb8, 0xe8, 0x56, 0x2c, 0xba, 0xfa}: "EfiBootManagerPolicyConsoleGuid",
		efi.GUID{0x4c, 0xf2, 0x39, 0x77, 0xd7, 0x93, 0xd4, 0x11, 0x9a, 0x3a, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d}: "EfiHobListGuid",
		efi.GUID{0x4d, 0x04, 0xc3, 0x6a, 0x62, 0xe0, 0x23, 0x4f, 0xa6, 0x0b, 0x28, 0x67, 0x64, 0xdd, 0x09, 0xf5}: "DellSmbiosSmm",
		efi.GUID{0x4d, 0x0a, 0xd7, 0xad, 0x67, 0x10, 0xa3, 0x4f, 0xa6, 0x69, 0x94, 0xc8, 0x28, 0x77, 0xf1, 0x06}: "TpmNvmeSupport",
		efi.GUID{0x4d, 0x11, 0x53, 0x3a, 0x73, 0x56, 0xd9, 0x4d, 0xb5, 0xb3, 0xcb, 0x72, 0xc3, 0x47, 0x66, 0x9b}: "BFGSmm",
		efi.GUID{0x4d, 0x20, 0x85, 0xdf, 0xcf, 0x83, 0x32, 0x41, 0xb4, 0xfc, 0x9a, 0x75, 0xf2, 0xbc, 0x87, 0x4f}: "NonAmtNetworkControllerSmm",
		efi.GUID{0x4d, 0x2c, 0xec, 0x90, 0xbe, 0x28, 0x26, 0x47, 0xaf, 0x9b, 0x94, 0xbc, 0x6c, 0xbe, 0x17, 0xf2}: "NearTdpLockOcPeim",
		efi.GUID{0x4d, 0x31, 0xd0, 0xb0, 0xc3, 0x57, 0x53, 0x44, 0x94, 0x86, 0x18, 0x82, 0x2d, 0x8c, 0x81, 0xba}: "FmpDxe",
		efi.GUID{0x4d, 0x33, 0x89, 0x84, 0x19, 0x42, 0xa1, 0x4c, 0x9b, 0x42, 0x1d, 0x46, 0xb0, 0xb7, 0x58, 0x61}: "TcgPpVendorLibNull",
		efi.GUID{0x4d, 0x33, 0xb3, 0x44, 0x93, 0xa6, 0xae, 0x4a, 0xac, 0x8e, 0x01, 0xe1, 0x90, 0x4d, 0x9c, 0x75}: "AtaSmartFeature",
		efi.GUID{0x4d, 0x34, 0x8f, 0x22, 0xde, 0xb3, 0xbb, 0x43, 0xa4, 0xd7, 0xea, 0x20, 0x0b, 0x1b, 0x14, 0x82}: "EfiSmMonitorInitProtocolGuid",
		efi.GUID{0x4d, 0x37, 0x04, 0x1b, 0x9c, 0xfa, 0x0f, 0x42, 0xac, 0x62, 0xfe, 0xe6, 0xd4, 0x5e, 0x84, 0x43}: "FspDebugServicePei",
		efi.GUID{0x4d, 0x38, 0xce, 0x0d, 0x7c, 0x00, 0xa5, 0x4b, 0x94, 0xbd, 0x0f, 0x6e, 0xb6, 0x4d, 0x2a, 0xa9}: "PeiNtAutoScanPpiGuid",
		efi.GUID{0x4d, 0x39, 0x87, 0xbd, 0x5c, 0x46, 0xa9, 0x40, 0x96, 0x57, 0xfb, 0xed, 0x21, 0x78, 0x98, 0x60}: "BinConvert",
		efi.GUID{0x4d, 0x3d, 0xca, 0x0d, 0xda, 0x12, 0x28, 0x47, 0xbf, 0x7e, 0x86, 0xce, 0xb9, 0x28, 0xd0, 0x67}: "EfiNicIp4ConfigProtocol",
		efi.GUID{0x4d, 0x40, 0x15, 0xe5, 0xf5, 0x8d, 0x62, 0x45, 0xbc, 0xcb, 0x74, 0x94, 0x8d, 0x32, 0x81, 0x89}: "AmdCpmThunderboltDxe",
		efi.GUID{0x4d, 0x46, 0x2c, 0x91, 0xbf, 0xdd, 0xc0, 0x43, 0xb7, 0x25, 0xf1, 0xf6, 0x1e, 0xa4, 0x28, 0x75}: "AmdCpmOemRnInitPeim",
		efi.GUID{0x4d, 0x47, 0x85, 0x38, 0x95, 0x83, 0xab, 0x4a, 0x8a, 0xa4, 0x37, 0x43, 0xce, 0x28, 0x76, 0x46}: "FnWinKeySwap",
		efi.GUID{0x4d, 0x4f, 0xb1, 0x2c, 0x75, 0x5d, 0xed, 0x4f, 0xae, 0xa0, 0x4b, 0xc3, 0x6e, 0x08, 0x1a, 0xd5}: "DeepS3ConfigSmm",
		efi.GUID{0x4d, 0x5e, 0x13, 0x0e, 0x3e, 0xe6, 0xc6, 0x45, 0xa9, 0xa2, 0xe9, 0x36, 0x34, 0x77, 0xdd, 0xfc}: "AmdNbioBaseMdnDxe",
		efi.GUID{0x4d, 0x61, 0xdf, 0xdc, 0x0e, 0x93, 0xdf, 0x4f, 0xaf, 0xcd, 0xf4, 0xa8, 0xa4, 0x08, 0xe0, 0x77}: "EarlyVideoDxe",
		efi.GUID{0x4d, 0x65, 0x8d, 0x23, 0xad, 0xa6, 0xc8, 0x41, 0xa3, 0x1b, 0x67, 0xa3, 0x20, 0x86, 0x25, 0xc3}: "LenovoMx25L3206EflashPartSmm",
		efi.GUID{0x4d, 0x66, 0xee, 0x50, 0x03, 0x77, 0xc3, 0x42, 0x9e, 0x69, 0x8c, 0x89, 0xde, 0x70, 0xd1, 0xd5}: "SioInit",
		efi.GUID{0x4d, 0x69, 0x7e, 0x0b, 0x09, 0xb9, 0x97, 0x40, 0x9c, 0x03, 0x5e, 0x72, 0x84, 0x89, 0xf7, 0x09}: "HybridGraphicsConfigGuid",
		efi.GUID{0x4d, 0x71, 0xc1, 0x8b, 0xcb, 0xff, 0xc3, 0x41, 0x89, 0xdc, 0x6c, 0x74, 0xd0, 0x6d, 0x98, 0xea}: "EfiSmmPciRootBridgeIoProtocolGuid",
		efi.GUID{0x4d, 0x7e, 0xaf, 0x95, 0x5d, 0xc4, 0xff, 0x47, 0xae, 0xb2, 0xd9, 0xbc, 0x13, 0x46, 0x6b, 0x3f}: "AppleAhciController",
		efi.GUID{0x4d, 0x85, 0xcf, 0x6b, 0x2d, 0x13, 0xb2, 0x49, 0x81, 0x5c, 0xf0, 0x01, 0x51, 0xc7, 0xbb, 0xbb}: "FjRt8111EepromLess",
		efi.GUID{0x4d, 0x87, 0x1e, 0x18, 0x89, 0xc0, 0x99, 0x4c, 0x8e, 0xc2, 0x6d, 0x67, 0x61, 0x34, 0x82, 0x20}: "AmiPllOverVotageFlagHob",
		efi.GUID{0x4d, 0x8a, 0xcd, 0x12, 0xfd, 0x93, 0x1c, 0xe8, 0x72, 0xfc, 0xd9, 0x31, 0xeb, 0xbc, 0x04, 0xd4}: "DellTouchScreen",
		efi.GUID{0x4d, 0x91, 0x89, 0xca, 0x17, 0x23, 0x2e, 0x45, 0xb2, 0x45, 0x36, 0xc6, 0xfb, 0x77, 0xa9, 0xc6}: "SaSsdtAcpiTableStorageGuid",
		efi.GUID{0x4d, 0x92, 0xed, 0x3e, 0xc1, 0x2b, 0x76, 0x48, 0xb7, 0x69, 0xf3, 0x1f, 0x85, 0xab, 0x39, 0x7f}: "FjHddEraseApp",
		efi.GUID{0x4d, 0x95, 0x90, 0x13, 0x95, 0xda, 0x27, 0x42, 0x93, 0x28, 0x72, 0x82, 0xc2, 0x17, 0xda, 0xa8}: "EfiSmmBaseProtocolGuid",
		efi.GUID{0x4d, 0x97, 0x6d, 0xea, 0x75, 0xad, 0xed, 0x40, 0xbc, 0xdd, 0xfd, 0xa2, 0x97, 0xaa, 0x8f, 0x8a}: "ChipsetLibServicesDxe",
		efi.GUID{0x4d, 0x97, 0x95, 0x66, 0x8c, 0x96, 0x0b, 0x42, 0x80, 0xb9, 0x78, 0x70, 0xcd, 0x20, 0x11, 0x8f}: "PlatformSecLibNull",
		efi.GUID{0x4d, 0x9b, 0xe0, 0xac, 0x11, 0xce, 0x48, 0x4e, 0x8c, 0x9c, 0x8d, 0x69, 0x01, 0xf7, 0x07, 0x87}: "MeOptionsDxe",
		efi.GUID{0x4d, 0x9e, 0x0a, 0xc1, 0xb4, 0xbd, 0x1a, 0x4b, 0x82, 0xcc, 0xd9, 0x01, 0xf8, 0x6f, 0x57, 0x39}: "DellSmmDiagLeds",
		efi.GUID{0x4d, 0xa1, 0xca, 0x37, 0x72, 0x50, 0x53, 0x47, 0xac, 0xb2, 0xca, 0xda, 0x3e, 0x99, 0xa9, 0xe7}: "KeyBoardIdm",
		efi.GUID{0x4d, 0xa8, 0x33, 0x08, 0x39, 0x8a, 0x1f, 0x43, 0xbd, 0x1c, 0x30, 0x96, 0x5a, 0xae, 0x71, 0xdd}: "ProcessorStartup",
		efi.GUID{0x4d, 0xb4, 0xff, 0x05, 0x01, 0xee, 0xe1, 0x40, 0x98, 0x66, 0xfd, 0x27, 0xfd, 0x4f, 0xbe, 0x92}: "ThunderboltDeviceDxe",
		efi.GUID{0x4d, 0xbb, 0xa5, 0x22, 0x62, 0xf9, 0x33, 0x4d, 0x9c, 0xd6, 0xfd, 0xad, 0x39, 0xac, 0xd1, 0x53}: "PlatformBoardIdPei",
		efi.GUID{0x4d, 0xbf, 0x88, 0x8e, 0x15, 0x9f, 0x06, 0x42, 0xbb, 0xd5, 0x55, 0xd3, 0x68, 0xb6, 0x2a, 0xd1}: "NvmeRecoveryDxe",
		efi.GUID{0x4d, 0xc5, 0x9f, 0x3d, 0xe5, 0x19, 0xd0, 0x4a, 0xb9, 0x86, 0x02, 0xd6, 0x87, 0xd7, 0x60, 0xe5}: "ASRLOGODXE",
		efi.GUID{0x4d, 0xd0, 0x79, 0x72, 0xae, 0xaa, 0x4a, 0x99, 0x8a, 0x5c, 0x5a, 0xea, 0x41, 0xd1, 0xfe, 0x3a}: "AppleArpDxe",
		efi.GUID{0x4d, 0xe2, 0x9e, 0x8a, 0xe8, 0xda, 0x1f, 0x40, 0xa5, 0x91, 0x24, 0x1d, 0xf8, 0x48, 0x40, 0x7f}: "WwanSmm",
		efi.GUID{0x4d, 0xe3, 0x44, 0xf2, 0x43, 0x36, 0x3b, 0x4e, 0x9d, 0xa5, 0x8c, 0x69, 0x1c, 0xbd, 0xe0, 0xeb}: "MeUnlock",
		efi.GUID{0x4d, 0xe6, 0x09, 0x3a, 0xa9, 0x08, 0xd5, 0x42, 0x82, 0x34, 0x11, 0x27, 0xe6, 0xaf, 0x05, 0xeb}: "SioPowerButtonOverrideSmm",
		efi.GUID{0x4d, 0xea, 0x0e, 0x7d, 0xca, 0x74, 0x18, 0x41, 0x89, 0x8e, 0x96, 0x41, 0x81, 0xdc, 0x5d, 0x1b}: "SmmIpl",
		efi.GUID{0x4d, 0xef, 0x9c, 0x24, 0x90, 0x7b, 0xf1, 0x49, 0xb6, 0x7f, 0x20, 0x33, 0xf0, 0x94, 0x26, 0x23}: "DellTcg2Dxe",
		efi.GUID{0x4d, 0xf1, 0xca, 0x7d, 0x99, 0x14, 0x49, 0x41, 0x83, 0x64, 0x16, 0x73, 0xcd, 0x1c, 0xe7, 0x5c}: "PecNbDxe",
		efi.GUID{0x4d, 0xf3, 0x04, 0xb3, 0x7b, 0xb2, 0x2c, 0x45, 0x89, 0x31, 0xcf, 0x60, 0xa2, 0xf0, 0xd2, 0x68}: "FchProm21GpioDxe",
		efi.GUID{0x4d, 0xfb, 0x45, 0x23, 0x26, 0x0b, 0x14, 0x4a, 0xaa, 0x2e, 0xf7, 0xb9, 0x55, 0x15, 0x44, 0x95}: "StibpFeatureDxe",
		efi.GUID{0x4d, 0xfd, 0x41, 0x31, 0x02, 0xea, 0x70, 0x4a, 0x9b, 0xce, 0x97, 0xee, 0x83, 0x73, 0x19, 0xac}: "TrEEConfigDxe",
		efi.GUID{0x4e, 0x0b, 0xde, 0x35, 0xfb, 0x30, 0xc3, 0x46, 0xbd, 0x84, 0x1f, 0xdb, 0xa1, 0x58, 0xbb, 0x56}: "EdkiiPeiStorageSecurityCommandPpi",
		efi.GUID{0x4e, 0x0d, 0xb1, 0xd7, 0xe6, 0x67, 0x74, 0x4c, 0x83, 0xe9, 0xf9, 0xaf, 0x0a, 0xcc, 0x33, 0xcc}: "PchInitSmm",
		efi.GUID{0x4e, 0x0f, 0xab, 0xc8, 0xfe, 0x26, 0xf1, 0x40, 0x95, 0x79, 0xea, 0x8d, 0x30, 0xd5, 0x03, 0xa4}: "SystemFlashUpdateDriverDxe",
		efi.GUID{0x4e, 0x17, 0x73, 0xdb, 0x6a, 0xe4, 0x27, 0x49, 0x99, 0x47, 0xcf, 0x2d, 0xbe, 0xaf, 0x16, 0x81}: "PowerMgmtConfigGuid",
		efi.GUID{0x4e, 0x1b, 0x1d, 0xe5, 0xc3, 0x68, 0xd8, 0x41, 0x95, 0x6d, 0xba, 0x55, 0x44, 0x27, 0xc3, 0xa3}: "PcieLaneDXE",
		efi.GUID{0x4e, 0x1c, 0x7c, 0x12, 0x35, 0x91, 0xe3, 0x46, 0xb0, 0x06, 0xf9, 0x80, 0x8b, 0x05, 0x59, 0xa5}: "Slp20Markers",
		efi.GUID{0x4e, 0x1e, 0xe9, 0xac, 0x8e, 0x23, 0x8b, 0x4a, 0x9a, 0x4f, 0x87, 0xb7, 0xdc, 0x82, 0xc0, 0x66}: "CvpPeriphSpi",
		efi.GUID{0x4e, 0x24, 0x82, 0x01, 0x5d, 0xf9, 0xfc, 0x43, 0x91, 0xec, 0x60, 0x59, 0x4e, 0xf4, 0x75, 0x99}: "Lpc47m18xDxe",
		efi.GUID{0x4e, 0x28, 0xa9, 0x7f, 0xb3, 0x40, 0x7f, 0x41, 0xa2, 0xbb, 0x58, 0xea, 0xe1, 0x02, 0x63, 0x14}: "FjSystemResetDxe",
		efi.GUID{0x4e, 0x2a, 0xcc, 0x2f, 0x95, 0x69, 0x88, 0x46, 0x81, 0x2b, 0x6e, 0xc7, 0xe7, 0xa4, 0x1b, 0x51}: "RTL8152B_RTL8153_USB",
		efi.GUID{0x4e, 0x42, 0x1b, 0x27, 0xcc, 0xa4, 0x0e, 0x4e, 0x90, 0xa2, 0x7e, 0xa4, 0x84, 0x1f, 0x12, 0xf3}: "ExportHiiDb",
		efi.GUID{0x4e, 0x42, 0x6f, 0x12, 0x5b, 0xf4, 0x06, 0x44, 0x80, 0x1e, 0x2a, 0xac, 0xf4, 0x04, 0x16, 0x7f}: "AmiSetPhysicalPresenceGuid",
		efi.GUID{0x4e, 0x46, 0x83, 0x28, 0xa2, 0x3c, 0x4d, 0x4f, 0xb9, 0x03, 0x21, 0xa1, 0xe3, 0xf6, 0x14, 0x71}: "XhciControllerPei",
		efi.GUID{0x4e, 0x5b, 0xdc, 0x64, 0x79, 0x91, 0x18, 0x49, 0x89, 0x03, 0xd7, 0x5e, 0x1b, 0xc8, 0xb2, 0x63}: "Mec5107Dxe",
		efi.GUID{0x4e, 0x61, 0x16, 0x22, 0xbe, 0xcd, 0xe7, 0x46, 0xba, 0x61, 0x9b, 0xd2, 0xbc, 0x64, 0x03, 0x93}: "AmiPspFlashSmm",
		efi.GUID{0x4e, 0x6e, 0x8e, 0x0d, 0x29, 0xb0, 0x5f, 0x47, 0x91, 0x22, 0x60, 0xa3, 0xfe, 0xdb, 0xa8, 0xc0}: "DxeIoLibEsal",
		efi.GUID{0x4e, 0x7a, 0xf9, 0x69, 0x95, 0x13, 0x4a, 0x43, 0xa5, 0xd3, 0xff, 0x9c, 0xea, 0x28, 0x48, 0x85}: "DellDiagsConfig",
		efi.GUID{0x4e, 0x7c, 0xe4, 0xfc, 0xcc, 0x5e, 0x41, 0x4a, 0xb9, 0x0e, 0x0b, 0xab, 0x09, 0x96, 0x8d, 0x02}: "SystemSecureFlashSleepTrapSmm",
		efi.GUID{0x4e, 0x82, 0xa8, 0x25, 0xbf, 0x6b, 0xb2, 0x4f, 0xa2, 0x00, 0x84, 0xb0, 0xf7, 0xbe, 0xce, 0x6b}: "B57785",
		efi.GUID{0x4e, 0x87, 0x0f, 0x76, 0xcb, 0xb8, 0x5e, 0x40, 0xaa, 0x32, 0xa4, 0x6a, 0xe2, 0xf3, 0xd6, 0x80}: "VariableDefaultUpdate",
		efi.GUID{0x4e, 0x8e, 0xc7, 0x92, 0x94, 0xc9, 0x9e, 0x4f, 0x82, 0xab, 0xaf, 0x1d, 0xba, 0x68, 0x58, 0xc9}: "DellSmmComputrace",
		efi.GUID{0x4e, 0x98, 0x52, 0xed, 0xd7, 0x6e, 0x45, 0x44, 0x9d, 0x5d, 0x20, 0x0c, 0x32, 0x01, 0xf5, 0x1e}: "PlatformStage0",
		efi.GUID{0x4e, 0x99, 0xa2, 0x6f, 0x4f, 0x14, 0x4a, 0x40, 0xad, 0xc9, 0x31, 0xc3, 0xbc, 0x71, 0x96, 0xc9}: "DellGraphics3Drv",
		efi.GUID{0x4e, 0xaa, 0x8d, 0xc6, 0xb5, 0x7a, 0xe8, 0x41, 0xa9, 0x1d, 0x59, 0x54, 0x42, 0x10, 0x53, 0xf3}: "CbSupportDxe",
		efi.GUID{0x4e, 0xac, 0x08, 0x81, 0x11, 0x9f, 0x59, 0x4d, 0x85, 0x0e, 0xe2, 0x1a, 0x52, 0x2c, 0x59, 0xb2}: "BmAutoCreateBootOptionGuid",
		efi.GUID{0x4e, 0xb9, 0xc6, 0xcb, 0xaa, 0xde, 0x2c, 0x46, 0x84, 0x0c, 0x66, 0x98, 0x18, 0x0d, 0xe2, 0x92}: "QualcommDRS",
		efi.GUID{0x4e, 0xbe, 0x79, 0x03, 0x06, 0xd7, 0x7d, 0x43, 0xb0, 0x37, 0xed, 0xb8, 0x2f, 0xb7, 0x72, 0xa4}: "EfiDevicePathUtilitiesProtocolGuid",
		efi.GUID{0x4e, 0xbf, 0x3e, 0xb6, 0x96, 0xd1, 0xba, 0x40, 0xab, 0x63, 0x1f, 0xa9, 0xa6, 0x06, 0x8e, 0x84}: "LenovoOsOptDefaultDxe",
		efi.GUID{0x4e, 0xc0, 0x1f, 0xcc, 0x3d, 0x0b, 0x0e, 0x4e, 0xae, 0xd7, 0x58, 0x98, 0x54, 0x1e, 0x26, 0x83}: "CSMLinkerDxe",
		efi.GUID{0x4e, 0xd2, 0x75, 0xb3, 0x3a, 0x86, 0xc3, 0x2d, 0xc4, 0x29, 0x7d, 0xab, 0x73, 0x23, 0xab, 0x9b}: "SceBootOrderSaveRestore",
		efi.GUID{0x4e, 0xd5, 0xde, 0xb2, 0xcd, 0x47, 0x16, 0x84, 0x18, 0x18, 0xfb, 0xb2, 0x43, 0x80, 0x99, 0x84}: "AmdSocFp6RnDxe",
		efi.GUID{0x4e, 0xd5, 0xf8, 0xa9, 0x07, 0x11, 0x0a, 0x4f, 0xad, 0xd0, 0x45, 0x87, 0xe7, 0xa4, 0xa7, 0x35}: "IntelSiliconPkgTokenSpaceGuid",
		efi.GUID{0x4e, 0xda, 0xa0, 0xc1, 0x36, 0x28, 0x7d, 0x4b, 0xa5, 0xd2, 0xb6, 0x7a, 0x22, 0x42, 0x43, 0x8c}: "OemGpioEarlyInit",
		efi.GUID{0x4e, 0xee, 0xe1, 0xc8, 0x9d, 0x1b, 0x9d, 0x43, 0xb2, 0x04, 0x32, 0x8b, 0xb5, 0x97, 0x3f, 0x0a}: "SetDevPhyConnStatus",
		efi.GUID{0x4e, 0xf7, 0x8f, 0x2e, 0xa4, 0x8b, 0xd6, 0x4c, 0x81, 0x4f, 0xf9, 0x69, 0x62, 0xdd, 0xfe, 0x27}: "DellDiagUtilityProtocol",
		efi.GUID{0x4e, 0xf7, 0xda, 0xcb, 0xe8, 0xd6, 0x34, 0x49, 0xbb, 0x03, 0x27, 0xf3, 0x56, 0xd4, 0xb9, 0x1c}: "FjEarlyInitPei",
		efi.GUID{0x4f, 0x02, 0xa1, 0x7c, 0x17, 0xeb, 0xe5, 0x11, 0x9d, 0xba, 0x28, 0xd2, 0x44, 0x7c, 0x48, 0x29}: "TlsAuthConfigDxe",
		efi.GUID{0x4f, 0x06, 0x77, 0x29, 0x96, 0xab, 0xa9, 0x4f, 0x85, 0x45, 0xf9, 0xc4, 0x02, 0x51, 0xe0, 0x7f}: "EfiPlatformPolicyProtocolGuid",
		efi.GUID{0x4f, 0x0a, 0xc8, 0x98, 0x6b, 0xe1, 0x11, 0x4d, 0x93, 0x9a, 0xab, 0xe5, 0x61, 0x26, 0x03, 0x30}: "EdkiiCapsuleOnDiskName",
		efi.GUID{0x4f, 0x0e, 0x8c, 0xcb, 0xf7, 0x14, 0x5a, 0x4f, 0x8d, 0xad, 0x75, 0x2c, 0xb0, 0xb4, 0x20, 0x45}: "SystemStatusBarDxe",
		efi.GUID{0x4f, 0x1d, 0x1f, 0x22, 0x4c, 0x03, 0xea, 0x4b, 0xb2, 0xbb, 0xb7, 0xa9, 0x67, 0x2b, 0x06, 0xd7}: "CrbSmi",
		efi.GUID{0x4f, 0x1f, 0x78, 0x41, 0xcd, 0xa3, 0x50, 0x47, 0x8a, 0x2c, 0x21, 0x92, 0xb4, 0xdf, 0xe5, 0x2b}: "EfiPeiPlatformTypeHedtEvPpi",
		efi.GUID{0x4f, 0x21, 0x3d, 0x86, 0x20, 0x09, 0x7b, 0x43, 0x8c, 0xad, 0x88, 0xea, 0x83, 0xa2, 0x4e, 0x97}: "DatahubStatusCodeHandlerDxe",
		efi.GUID{0x4f, 0x23, 0xea, 0x22, 0x2a, 0xe7, 0xe4, 0x11, 0x91, 0xf9, 0x28, 0xd2, 0x44, 0x7c, 0x48, 0x29}: "HttpUtilitiesDxe",
		efi.GUID{0x4f, 0x24, 0xbf, 0x89, 0x69, 0xe5, 0x6f, 0x41, 0xb1, 0x10, 0x8a, 0xe5, 0xef, 0xd5, 0x17, 0x1c}: "DellDxePrereq",
		efi.GUID{0x4f, 0x2a, 0x98, 0x14, 0xed, 0xb0, 0xb8, 0x45, 0xa8, 0x11, 0x5a, 0x7a, 0x9b, 0xc2, 0x32, 0xdf}: "EfiHiiKeyBoardLayoutGuid",
		efi.GUID{0x4f, 0x42, 0x06, 0xe8, 0x25, 0xd4, 0x1a, 0x4b, 0xbc, 0x26, 0x5f, 0x69, 0x03, 0x89, 0xa1, 0x5a}: "PlatformMeHookPpi",
		efi.GUID{0x4f, 0x44, 0xf8, 0x67, 0x43, 0x87, 0xf1, 0x48, 0xa3, 0x28, 0x1e, 0xaa, 0xb8, 0x73, 0x60, 0x80}: "EfiCertRsa2048Sha1Guid",
		efi.GUID{0x4f, 0x46, 0x50, 0x14, 0x36, 0xeb, 0xc6, 0x4a, 0xac, 0xeb, 0xda, 0xac, 0xc8, 0xfc, 0x32, 0x18}: "BoardSelectPei",
		efi.GUID{0x4f, 0x46, 0x88, 0x57, 0x73, 0x37, 0x29, 0x4a, 0x8a, 0xf7, 0xe8, 0x1b, 0xbe, 0xe4, 0x19, 0xc3}: "ATAIdentify",
		efi.GUID{0x4f, 0x48, 0x20, 0x30, 0x82, 0x45, 0x6e, 0x40, 0xb2, 0x0f, 0x89, 0xea, 0xcc, 0x93, 0xdc, 0x6a}: "DellSmmLegacyRegionProtocol",
		efi.GUID{0x4f, 0x4b, 0x0f, 0xfa, 0xef, 0xd6, 0xe7, 0x40, 0xbc, 0x1b, 0x29, 0x24, 0x5c, 0xa0, 0x3b, 0xc2}: "FvbInitilized",
		efi.GUID{0x4f, 0x56, 0xe0, 0x29, 0x02, 0xb7, 0x52, 0x43, 0xa3, 0xa1, 0x15, 0xfa, 0xbd, 0x4a, 0x4e, 0x4a}: "IioCfgUpdateDxeLightningRidgeEXECB3",
		efi.GUID{0x4f, 0x57, 0x6d, 0x9f, 0x37, 0xca, 0xdb, 0x41, 0x8e, 0x4b, 0x78, 0x10, 0x6a, 0x33, 0x88, 0x13}: "SwSmi534D0C40",
		efi.GUID{0x4f, 0x5a, 0xa1, 0x88, 0x7d, 0x97, 0x82, 0x46, 0xb1, 0x7c, 0xda, 0x1f, 0x31, 0x6c, 0x1f, 0x32}: "RomLayout",
		efi.GUID{0x4f, 0x5d, 0x47, 0x77, 0x65, 0x79, 0x38, 0x40, 0xb9, 0x70, 0x86, 0x3f, 0xc7, 0x3e, 0x07, 0x61}: "BSDP",
		efi.GUID{0x4f, 0x60, 0xe5, 0x2c, 0x82, 0xa9, 0x2e, 0x4d, 0x8f, 0xd0, 0xd1, 0x60, 0x0c, 0x2e, 0x15, 0x15}: "PciDynamicSetup",
		efi.GUID{0x4f, 0x6b, 0x5d, 0xd9, 0xfa, 0x92, 0x78, 0x4e, 0x9c, 0x48, 0xc6, 0x8c, 0x08, 0x13, 0x68, 0x8e}: "OemLinkDellPwdLib",
		efi.GUID{0x4f, 0x6f, 0xd3, 0x9b, 0xdc, 0x08, 0xab, 0x4e, 0x86, 0x37, 0x2b, 0xc1, 0xbd, 0x5e, 0x0d, 0x95}: "EfiRasClvTester",
		efi.GUID{0x4f, 0x73, 0xe9, 0x14, 0x44, 0x36, 0x3f, 0x4f, 0xad, 0xfe, 0xab, 0x80, 0xbf, 0x5b, 0x48, 0xbc}: "SMBGlobalAcpiNvs",
		efi.GUID{0x4f, 0x7b, 0xf8, 0xf5, 0x3c, 0xcc, 0x8d, 0x40, 0x89, 0xe3, 0x61, 0xc5, 0x9c, 0x54, 0x07, 0xc4}: "SataConfigGuid",
		efi.GUID{0x4f, 0x7d, 0x8f, 0x22, 0x1c, 0x23, 0xaa, 0x6b, 0xbd, 0xcb, 0xbe, 0xa9, 0x87, 0x5b, 0x04, 0xd3}: "AmiCpmWrapperSmi",
		efi.GUID{0x4f, 0x8a, 0x66, 0x7b, 0xe1, 0x45, 0x26, 0x4a, 0x8d, 0xec, 0x81, 0xa4, 0xa1, 0xe5, 0x88, 0x88}: "PspDxe",
		efi.GUID{0x4f, 0x8f, 0x5f, 0x11, 0x99, 0x78, 0x54, 0x41, 0x9c, 0x1d, 0xb6, 0xe1, 0x2b, 0x32, 0x0b, 0xe1}: "EcCommunicationSmm",
		efi.GUID{0x4f, 0x92, 0x84, 0x07, 0x96, 0xe2, 0xd4, 0x11, 0x9a, 0x49, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d}: "EfiDriverDiagnosticsProtocolGuid",
		efi.GUID{0x4f, 0x98, 0x6f, 0xf5, 0x46, 0x38, 0xd8, 0x49, 0xaa, 0x0a, 0x23, 0xde, 0x27, 0xe3, 0x83, 0x86}: "RfAutoGen",
		efi.GUID{0x4f, 0x9d, 0x15, 0x6a, 0x6b, 0x6e, 0x23, 0x45, 0xae, 0xb5, 0xf7, 0xaf, 0x1c, 0x44, 0x4b, 0x0f}: "EfiPprVariable",
		efi.GUID{0x4f, 0x9d, 0x95, 0x48, 0x74, 0x45, 0x0e, 0x47, 0xaa, 0x4c, 0xcf, 0x14, 0x4d, 0x1c, 0x16, 0x78}: "InstallVerbtableDxe",
		efi.GUID{0x4f, 0xa3, 0x2b, 0x55, 0x9e, 0x94, 0x4d, 0x40, 0xb6, 0xe2, 0x02, 0xba, 0x73, 0x53, 0x43, 0x07}: "PlatformRasConfigSmm",
		efi.GUID{0x4f, 0xa4, 0xe6, 0xf0, 0x95, 0x71, 0xc3, 0x41, 0xac, 0x64, 0x54, 0xf2, 0x02, 0xcd, 0x0a, 0x21}: "SecureBootConfigDxe",
		efi.GUID{0x4f, 0xa5, 0x26, 0x66, 0x98, 0x7e, 0x45, 0x41, 0x8f, 0x8f, 0x8d, 0xb7, 0x0d, 0x3b, 0x04, 0xce}: "PartialMirrorHandler",
		efi.GUID{0x4f, 0xab, 0x97, 0x15, 0x42, 0xd5, 0xfe, 0x4e, 0x9a, 0xf7, 0xb2, 0x44, 0xec, 0x54, 0x4c, 0x0b}: "EdkiiPeiPciDevicePpi",
		efi.GUID{0x4f, 0xb3, 0xae, 0xb5, 0x47, 0x30, 0x55, 0x49, 0xb8, 0x80, 0xad, 0xd3, 0x6d, 0x86, 0xdc, 0x0f}: "EdkiiPayloadCommandLine",
		efi.GUID{0x4f, 0xbd, 0x01, 0x94, 0x00, 0x1a, 0x90, 0x49, 0xab, 0x56, 0xda, 0xf0, 0xe4, 0xe3, 0x48, 0xde}: "AmiHddSmartInitProtocolGuid",
		efi.GUID{0x4f, 0xbd, 0x1f, 0xbb, 0x30, 0x2e, 0x93, 0x47, 0x9b, 0xed, 0x74, 0xf6, 0x72, 0xbc, 0x8f, 0xfe}: "PchResetRuntime",
		efi.GUID{0x4f, 0xc1, 0xbc, 0x53, 0x4f, 0xc2, 0x4c, 0x43, 0xb2, 0x94, 0x8e, 0xd2, 0xd4, 0xcc, 0x18, 0x60}: "DataHubDxe",
		efi.GUID{0x4f, 0xc2, 0xd1, 0x59, 0xf1, 0x50, 0x1a, 0x40, 0xb1, 0x01, 0xf3, 0x3e, 0x0d, 0xae, 0xd4, 0x43}: "EfiGenericVariableGuid",
		efi.GUID{0x4f, 0xc6, 0xaa, 0x54, 0x72, 0x8a, 0x93, 0x40, 0x80, 0x51, 0xf4, 0xd2, 0x3c, 0x5d, 0x2a, 0x4a}: "SbSocBixbyDxe",
		efi.GUID{0x4f, 0xc8, 0xfa, 0x6e, 0xb0, 0x0a, 0x47, 0x47, 0x81, 0xbe, 0x85, 0x55, 0x62, 0x59, 0x04, 0x49}: "XenIoProtocolGuid",
		efi.GUID{0x4f, 0xcb, 0x2c, 0x1f, 0x17, 0xd8, 0x4e, 0x40, 0x98, 0xe7, 0x80, 0xe4, 0x85, 0x1f, 0xb3, 0x3e}: "GdbStub",
		efi.GUID{0x4f, 0xda, 0x3a, 0x9b, 0x56, 0xae, 0x24, 0x4c, 0x8d, 0xea, 0xf0, 0x3b, 0x75, 0x58, 0xae, 0x50}: "PcdPeim",
		efi.GUID{0x4f, 0xda, 0xb9, 0x60, 0x3d, 0x99, 0x1d, 0x41, 0xb4, 0x3a, 0x08, 0xb4, 0x1e, 0x7b, 0xec, 0x24}: "AsrockAmdSetupDxeMts",
		efi.GUID{0x4f, 0xdc, 0x83, 0xe6, 0xed, 0x09, 0x22, 0x4f, 0x86, 0x6b, 0x8e, 0x40, 0x46, 0x94, 0x7c, 0x6c}: "EfiDebugSerialIoProtocol",
		efi.GUID{0x4f, 0xeb, 0xda, 0xb0, 0xf7, 0x1e, 0xe4, 0x11, 0xbb, 0xcc, 0x78, 0xe7, 0xd1, 0xaf, 0x36, 0xd1}: "HpNetworkBiosUpdateDxeDriver",
		efi.GUID{0x4f, 0xf5, 0x15, 0x25, 0x77, 0x32, 0xda, 0x47, 0x86, 0xa5, 0x48, 0x45, 0x10, 0xdd, 0x08, 0xe1}: "AmdPspDxeV2Mdn",
		efi.GUID{0x4f, 0xfd, 0x29, 0xb1, 0x47, 0x3e, 0xaa, 0x4b, 0xb0, 0x50, 0x03, 0xcc, 0x41, 0x59, 0x9b, 0xaf}: "OemI2cDevices",
		efi.GUID{0x4f, 0xfe, 0xf1, 0x8a, 0x8d, 0xdb, 0xa4, 0x43, 0xaa, 0x5d, 0x4a, 0xde, 0x63, 0x2a, 0x0f, 0xe9}: "SmcPeiSerialTextOut",
		efi.GUID{0x50, 0x14, 0x94, 0x78, 0xab, 0x90, 0xb1, 0x4f, 0xb7, 0x5f, 0x58, 0x92, 0x14, 0xe2, 0x4a, 0x0c}: "FontPackageGuid",
		efi.GUID{0x50, 0x1c, 0x6f, 0x45, 0x0a, 0x75, 0x71, 0x46, 0x89, 0xed, 0xf5, 0x36, 0xa6, 0x8c, 0x6d, 0x9d}: "AsusSetupVariableItem",
		efi.GUID{0x50, 0x20, 0x53, 0x3d, 0xda, 0x5c, 0xd0, 0x4f, 0x87, 0x9e, 0x0f, 0x7f, 0x63, 0x0d, 0x5a, 0xfb}: "BrotliCustomDecompress",
		efi.GUID{0x50, 0x2b, 0x06, 0xd6, 0xca, 0x15, 0xda, 0x11, 0x92, 0x19, 0x00, 0x10, 0x83, 0xff, 0xca, 0x4d}: "EfiAuthenticationChapRadiusGuid",
		efi.GUID{0x50, 0x2e, 0xe3, 0xd8, 0xd2, 0x1d, 0x8a, 0x4f, 0x93, 0xa5, 0x25, 0x69, 0xc0, 0x3d, 0x0f, 0xc1}: "FchSmbusPei",
		efi.GUID{0x50, 0x3a, 0x3b, 0xca, 0x98, 0x56, 0x51, 0x45, 0x8b, 0x18, 0xce, 0xae, 0xef, 0x91, 0x7d, 0x50}: "DxeDebugCmdProtocolGuid",
		efi.GUID{0x50, 0x3f, 0xf2, 0xcc, 0xc1, 0xf7, 0x00, 0x4f, 0x8e, 0x70, 0x13, 0x64, 0x3c, 0x37, 0xe8, 0xb0}: "TBTRetimerFirmwareUpdateDxe",
		efi.GUID{0x50, 0x49, 0x2c, 0xe9, 0x83, 0xa4, 0x5a, 0x44, 0xb6, 0xa8, 0xb7, 0x02, 0x9c, 0xa9, 0x10, 0xaa}: "PlatformStage2",
		efi.GUID{0x50, 0x4a, 0xf5, 0x2a, 0x6d, 0xee, 0x12, 0x4f, 0xbc, 0xff, 0xf0, 0x23, 0x4f, 0xf5, 0x7c, 0xa0}: "RTSCallbackHandleSmm",
		efi.GUID{0x50, 0x4e, 0xc7, 0x91, 0x1d, 0x36, 0xda, 0x4c, 0xa1, 0x6b, 0xc9, 0x2b, 0xe4, 0xbf, 0x16, 0xee}: "AmiTcmSignalguid",
		efi.GUID{0x50, 0x4f, 0xb7, 0xab, 0x2d, 0xfd, 0x72, 0x40, 0xa3, 0x21, 0xca, 0xfc, 0x72, 0x97, 0x7e, 0xfa}: "SmmRelocatePei",
		efi.GUID{0x50, 0x50, 0xd7, 0xa0, 0xa7, 0x8d, 0x58, 0x4e, 0x9a, 0xd4, 0x00, 0xfb, 0x9e, 0x3d, 0xb2, 0xf0}: "AsusI2cDetect",
		efi.GUID{0x50, 0x53, 0x01, 0x41, 0x3b, 0xba, 0x16, 0x49, 0xb0, 0x43, 0x46, 0x15, 0x40, 0x8a, 0x87, 0xb3}: "OememSmiCore",
		efi.GUID{0x50, 0x56, 0x71, 0x7e, 0xe6, 0x10, 0x7b, 0x4b, 0x89, 0x6a, 0x4d, 0xc5, 0xfc, 0x74, 0x2b, 0xc5}: "LenovoModulesSmmThunkSmm",
		efi.GUID{0x50, 0x5d, 0x77, 0xf8, 0xbd, 0x8a, 0xdf, 0x4a, 0x92, 0xac, 0x85, 0x3e, 0x51, 0xf6, 0xc8, 0xdc}: "IoMmuAbsentProtocol",
		efi.GUID{0x50, 0x5e, 0xcf, 0xa7, 0xb4, 0xa5, 0xe2, 0x43, 0x9b, 0xc2, 0xe6, 0x4f, 0x9f, 0x74, 0xcf, 0x6e}: "OemPei",
		efi.GUID{0x50, 0x61, 0xdd, 0xb6, 0xb2, 0x70, 0xb4, 0x4d, 0xad, 0x9a, 0x3c, 0x7c, 0x2b, 0x04, 0xe5, 0x80}: "AsusEcDxeSmm",
		efi.GUID{0x50, 0x69, 0x47, 0xd6, 0x81, 0x24, 0xbb, 0x4c, 0x84, 0x00, 0x44, 0x25, 0x42, 0xc7, 0x66, 0xc8}: "ProcessorErrorHandler",
		efi.GUID{0x50, 0x6d, 0x04, 0x22, 0x90, 0xf3, 0x8c, 0x49, 0x92, 0xe5, 0x5b, 0xa4, 0xf8, 0xe7, 0xf8, 0xb6}: "SBSATAIDE",
		efi.GUID{0x50, 0x70, 0x88, 0x3c, 0xc8, 0x42, 0x58, 0x49, 0xa0, 0x8e, 0x49, 0x5d, 0x91, 0x0c, 0xf5, 0x15}: "InstallSdevDxe",
		efi.GUID{0x50, 0x70, 0x9a, 0xe7, 0x09, 0x81, 0xd1, 0x40, 0xb3, 0xc0, 0x2a, 0x3c, 0x74, 0xc4, 0x02, 0x04}: "AGI",
		efi.GUID{0x50, 0x7b, 0x77, 0x87, 0x29, 0x64, 0x8a, 0x4f, 0x8a, 0x62, 0xf5, 0xb1, 0x4f, 0x1f, 0x59, 0x48}: "FruCpuFeature3v0",
		efi.GUID{0x50, 0x80, 0x28, 0xa5, 0x28, 0x88, 0xc4, 0x46, 0x8f, 0x72, 0x1c, 0xd7, 0x35, 0xa5, 0x65, 0x20}: "Slp20Dxe",
		efi.GUID{0x50, 0x84, 0x7d, 0xfe, 0x6d, 0x44, 0x9e, 0x0f, 0xfb, 0xe7, 0xdb, 0xaf, 0xf5, 0xaf, 0x1f, 0xf0}: "AmdSocAm4VmrDxe",
		efi.GUID{0x50, 0x86, 0xb7, 0x34, 0xba, 0xb0, 0x8f, 0x42, 0x87, 0xb1, 0xa1, 0xac, 0x76, 0x2f, 0x7f, 0xbf}: "EfiHeciRuntimeProtocolGuid",
		efi.GUID{0x50, 0x8c, 0xfd, 0x4c, 0x68, 0x63, 0x98, 0x43, 0xa7, 0xc7, 0xec, 0xcc, 0x2c, 0x51, 0xe1, 0x52}: "CloudBmrDrv",
		efi.GUID{0x50, 0x8d, 0x35, 0xf3, 0xd4, 0x72, 0xc0, 0x46, 0x9b, 0xdc, 0xed, 0xc1, 0xda, 0xdf, 0xb5, 0x5f}: "DellSmmMemLibWrapper",
		efi.GUID{0x50, 0x92, 0x64, 0xb0, 0x2b, 0x51, 0xab, 0x41, 0x86, 0x08, 0xfe, 0x07, 0x57, 0x31, 0x1b, 0x8b}: "AmdPspPeiV2Ssp",
		efi.GUID{0x50, 0x9d, 0x6e, 0x1b, 0xe4, 0x12, 0x55, 0x4b, 0x81, 0xd9, 0x1a, 0xbf, 0xec, 0x59, 0xd4, 0xfc}: "WakeCtrlSmm",
		efi.GUID{0x50, 0x9e, 0xd1, 0x78, 0x62, 0x2b, 0x7f, 0x40, 0x9f, 0x49, 0xc6, 0x52, 0xa4, 0x12, 0x40, 0x02}: "VariableRegionInfoDxe",
		efi.GUID{0x50, 0x9f, 0x56, 0xcf, 0x44, 0xde, 0x54, 0x4f, 0xb4, 0xd7, 0xf4, 0xae, 0x25, 0xcd, 0xa5, 0x99}: "XenIoPciDxe",
		efi.GUID{0x50, 0x9f, 0xe5, 0xd1, 0xc3, 0xe8, 0x45, 0x45, 0xbf, 0x61, 0x11, 0xf0, 0x02, 0x23, 0x3c, 0x97}: "TxtPeiAp",
		efi.GUID{0x50, 0xa6, 0x5e, 0x60, 0x5c, 0xc6, 0xe1, 0x42, 0xba, 0x80, 0x91, 0xa5, 0x2a, 0xb6, 0x18, 0xc6}: "EfiEndOfPeiSignalPpiGuid",
		efi.GUID{0x50, 0xa6, 0x5f, 0xbc, 0xbb, 0xed, 0x0d, 0x4d, 0xb3, 0xa3, 0xd9, 0x89, 0x07, 0xf8, 0x47, 0xdf}: "PeiBlockIoPpiGuid",
		efi.GUID{0x50, 0xb2, 0xc1, 0x43, 0x52, 0xbf, 0xde, 0x4d, 0x82, 0x80, 0x57, 0xe0, 0xad, 0x61, 0x11, 0x7d}: "H19AmdDimmSpdAccess",
		efi.GUID{0x50, 0xb4, 0x14, 0x13, 0x56, 0xe8, 0x8e, 0x43, 0x81, 0x31, 0xcf, 0x82, 0x3c, 0xab, 0x35, 0x50}: "ExpansionSlotConfigPortingPei",
		efi.GUID{0x50, 0xbf, 0x6f, 0x07, 0x83, 0xef, 0x77, 0x4b, 0x91, 0x2c, 0xd5, 0xbb, 0x77, 0x07, 0x5a, 0xe3}: "CompalThermalDxe",
		efi.GUID{0x50, 0xc0, 0xd7, 0xd4, 0x73, 0xc2, 0xa0, 0x44, 0x84, 0x56, 0xab, 0xa6, 0x39, 0x9e, 0xaf, 0x4d}: "LenovoResetSystemToFactoryDefaultsDxe",
		efi.GUID{0x50, 0xc1, 0x7f, 0x71, 0xd9, 0xab, 0x14, 0x46, 0x80, 0x15, 0x0b, 0x33, 0x23, 0xea, 0xb9, 0x5c}: "AmiNvramSpdMap",
		efi.GUID{0x50, 0xc8, 0x1c, 0x9e, 0x31, 0x67, 0x48, 0x48, 0x87, 0x52, 0x66, 0x73, 0xc7, 0x00, 0x5e, 0xee}: "FspInitPreMem",
		efi.GUID{0x50, 0xca, 0x28, 0x4e, 0x82, 0xd5, 0xac, 0x44, 0xa1, 0x1f, 0xe3, 0xd5, 0x65, 0x26, 0xdb, 0x34}: "EdkiiPiSmmCommunicationRegionTableGuid",
		efi.GUID{0x50, 0xca, 0x98, 0x96, 0xbb, 0x54, 0x43, 0x4b, 0xb1, 0xcc, 0xec, 0x13, 0x38, 0xb7, 0xd7, 0x67}: "Mec5105InitPei",
		efi.GUID{0x50, 0xce, 0x49, 0xcb, 0x75, 0x3a, 0xde, 0x11, 0x8a, 0x39, 0x08, 0x00, 0x20, 0x0c, 0x9a, 0x66}: "PerfTuneSmm",
		efi.GUID{0x50, 0xdb, 0x00, 0xeb, 0x54, 0xc6, 0x0f, 0x46, 0x8d, 0x7a, 0x0e, 0x44, 0x4f, 0xd3, 0x2b, 0x45}: "DebugMaskPei",
		efi.GUID{0x50, 0xdd, 0x4a, 0xb3, 0xd4, 0x05, 0x99, 0x4c, 0xbc, 0x55, 0xf3, 0xf2, 0xf7, 0xf5, 0x2e, 0x1a}: "LegacyToEfi",
		efi.GUID{0x50, 0xe0, 0x01, 0x16, 0x0c, 0xbe, 0xb7, 0x41, 0x8f, 0x96, 0x9f, 0x48, 0xf7, 0x2b, 0x7e, 0x26}: "OnboardControllerCtrl",
		efi.GUID{0x50, 0xed, 0xaf, 0x54, 0x99, 0x59, 0x94, 0x45, 0x9b, 0x79, 0xf0, 0xaa, 0xa0, 0x9f, 0xa3, 0x2c}: "DashIoCfgDxe",
		efi.GUID{0x50, 0xef, 0xee, 0x54, 0xc0, 0x2e, 0xb8, 0x45, 0x80, 0xca, 0x9c, 0xb1, 0xab, 0x81, 0x95, 0x07}: "ApobRmbDxe",
		efi.GUID{0x50, 0xf3, 0x94, 0x73, 0x4d, 0x39, 0x8c, 0x48, 0xbb, 0x75, 0x0c, 0xab, 0x7b, 0x12, 0x0a, 0xc5}: "EdkiiDeviceIdentifierTypeUsb",
		efi.GUID{0x50, 0xf4, 0x48, 0xc4, 0xd2, 0xd9, 0xdf, 0x4b, 0xac, 0x47, 0x6e, 0xb2, 0xa2, 0x25, 0xd5, 0x4b}: "AmdOemRasRsDxe",
		efi.GUID{0x50, 0xfc, 0xb1, 0x88, 0x36, 0x45, 0x31, 0x49, 0xa8, 0xcd, 0xab, 0x54, 0xba, 0x41, 0x6a, 0xc0}: "VmdVrocWrapper",
		efi.GUID{0x50, 0xfe, 0xda, 0xe5, 0xcb, 0x10, 0xb5, 0x41, 0x9c, 0xb5, 0x27, 0x4e, 0x1c, 0xf1, 0xa8, 0xd7}: "Ip6BmcLanConfig",
		efi.GUID{0x51, 0x00, 0xd1, 0xaa, 0x94, 0x5d, 0x9f, 0x4b, 0xb7, 0x78, 0xe4, 0x55, 0x5e, 0xe3, 0xcc, 0xca}: "IioSmm",
		efi.GUID{0x51, 0x06, 0x76, 0xc6, 0x8d, 0xa3, 0x4f, 0x5f, 0xae, 0xaf, 0xf6, 0x66, 0x15, 0x49, 0xdf, 0x75}: "EmuBlockIo",
		efi.GUID{0x51, 0x07, 0x99, 0xfa, 0x95, 0x07, 0x5e, 0x4d, 0xab, 0x70, 0xa6, 0xf5, 0xa6, 0x77, 0x1a, 0xc9}: "GopPolicy",
		efi.GUID{0x51, 0x0a, 0xe6, 0x63, 0x7d, 0x49, 0x27, 0xd4, 0xc4, 0xa5, 0xb8, 0xab, 0xdc, 0x3a, 0xae, 0xb6}: "EfiRegexSyntaxTypePerlGuid",
		efi.GUID{0x51, 0x16, 0xd5, 0x50, 0xea, 0xe5, 0x7a, 0x4c, 0x9d, 0xef, 0x7c, 0xf8, 0xa6, 0x3a, 0xfc, 0x91}: "AmdPspDxeV2Phx",
		efi.GUID{0x51, 0x1e, 0x1e, 0x93, 0xdd, 0x83, 0x7f, 0x42, 0xb5, 0xe0, 0x5f, 0x25, 0xe2, 0xc5, 0x04, 0xa8}: "AdapterWarnings",
		efi.GUID{0x51, 0x1e, 0xb8, 0x68, 0x83, 0x25, 0x82, 0x45, 0x95, 0xdb, 0xc5, 0x72, 0x32, 0x36, 0xc4, 0xf1}: "NonSmmEmul6064TrapProtocolGuid",
		efi.GUID{0x51, 0x1f, 0x49, 0xc4, 0xb9, 0x66, 0x90, 0x45, 0x95, 0xe4, 0xe2, 0xb4, 0xad, 0x77, 0x77, 0x03}: "HeciSmm",
		efi.GUID{0x51, 0x24, 0x8a, 0x4c, 0x07, 0xc2, 0x5b, 0x40, 0x96, 0x94, 0x99, 0xea, 0x13, 0x25, 0x13, 0x41}: "EfiDebugMaskProtocolGuid",
		efi.GUID{0x51, 0x28, 0x17, 0x43, 0x7e, 0xcf, 0x45, 0x43, 0x9f, 0xe0, 0xd7, 0x01, 0x2b, 0xb1, 0x7b, 0x88}: "iFfsSmm",
		efi.GUID{0x51, 0x30, 0x46, 0x8d, 0x2f, 0x69, 0x24, 0x49, 0x9a, 0xec, 0x0a, 0x83, 0x3b, 0x1b, 0xa4, 0x9b}: "PxeRomAr8132",
		efi.GUID{0x51, 0x43, 0xd5, 0x66, 0x4b, 0x4c, 0x70, 0x44, 0x95, 0x99, 0xf1, 0x7a, 0x32, 0x75, 0x28, 0x71}: "AplRecoveryPei",
		efi.GUID{0x51, 0x45, 0x52, 0x13, 0x00, 0x56, 0xb4, 0x43, 0xa5, 0xdf, 0xf4, 0xb1, 0x94, 0x2f, 0x33, 0x9a}: "MeResiliencyPei",
		efi.GUID{0x51, 0x48, 0xdc, 0x26, 0x5f, 0x19, 0xe1, 0x4a, 0x9a, 0x19, 0xfb, 0xf8, 0x83, 0xbb, 0xb3, 0x5e}: "AmiAptioSigOwner",
		efi.GUID{0x51, 0x4d, 0x62, 0x76, 0x16, 0xe9, 0xa0, 0x46, 0x82, 0x4c, 0xab, 0x27, 0xe0, 0xaf, 0x3e, 0x77}: "SioSwSmi",
		efi.GUID{0x51, 0x4f, 0x44, 0xfe, 0x88, 0x52, 0xe6, 0x46, 0xb1, 0x71, 0x73, 0xc9, 0x1b, 0xde, 0x35, 0x8b}: "DellUefiClass3ConfigSmm",
		efi.GUID{0x51, 0x51, 0x25, 0xf5, 0x1f, 0xdd, 0xd9, 0x4b, 0xa3, 0x50, 0x23, 0x52, 0x00, 0x79, 0x87, 0x40}: "UpdateDsdtByAcpiSdtDxe",
		efi.GUID{0x51, 0x52, 0x47, 0x2b, 0xc6, 0x13, 0x47, 0x45, 0xb2, 0xf2, 0x40, 0x76, 0x2f, 0xef, 0x9b, 0x89}: "SystemBootMenuDxeGui",
		efi.GUID{0x51, 0x53, 0x90, 0x73, 0x4d, 0xeb, 0x37, 0x46, 0xa8, 0x3b, 0xd1, 0xbf, 0x6c, 0x1c, 0x48, 0xeb}: "TSEInvalidateBgrtStatusProtocolGuid",
		efi.GUID{0x51, 0x64, 0x3e, 0xe0, 0x7a, 0x29, 0xe9, 0x4f, 0xb1, 0xf7, 0x63, 0x9b, 0x70, 0x32, 0x7c, 0x52}: "EnhancePeiVariable",
		efi.GUID{0x51, 0x71, 0x32, 0x62, 0xc3, 0xaf, 0x87, 0x41, 0x89, 0xdd, 0x78, 0x8f, 0x0f, 0x16, 0xb6, 0xd5}: "MiscConfigPei",
		efi.GUID{0x51, 0x77, 0x28, 0x27, 0x7a, 0x86, 0xcd, 0x46, 0x91, 0xaf, 0x41, 0x6f, 0xf6, 0xae, 0x3d, 0xfe}: "DellSystemIdConfigDxe",
		efi.GUID{0x51, 0x7e, 0xa3, 0x71, 0xc8, 0xf3, 0x99, 0x4b, 0xb3, 0x35, 0xa6, 0x61, 0xca, 0x8a, 0xd1, 0x3a}: "AmdCpmOemInitDxe",
		efi.GUID{0x51, 0x7f, 0xbb, 0x25, 0x2c, 0x75, 0x1e, 0x49, 0xbc, 0xb1, 0x55, 0xea, 0x60, 0x8b, 0x31, 0x97}: "CertificateStorageSmm",
		efi.GUID{0x51, 0x81, 0x4e, 0xdb, 0xed, 0x57, 0xed, 0x4b, 0x88, 0x33, 0x67, 0x51, 0xb5, 0xd1, 0xa8, 0xd7}: "ConnectConInEventGuid",
		efi.GUID{0x51, 0x8c, 0x2f, 0x37, 0x3b, 0xc4, 0x2a, 0x47, 0x82, 0xaf, 0x54, 0xb5, 0xc3, 0x23, 0x4d, 0x7f}: "CpPcBiosIdFile",
		efi.GUID{0x51, 0x97, 0x35, 0xec, 0xb5, 0x1d, 0x8a, 0x4e, 0xb2, 0xe9, 0x7b, 0xa1, 0xfe, 0x9a, 0x91, 0x68}: "FmacDrv",
		efi.GUID{0x51, 0xa2, 0xaf, 0x61, 0xc8, 0x8a, 0x40, 0x44, 0x9a, 0xb5, 0x76, 0x2b, 0x1b, 0xf0, 0x51, 0x56}: "Mtftp6Dxe",
		efi.GUID{0x51, 0xb9, 0x27, 0x01, 0x40, 0xe8, 0x0a, 0x48, 0xa0, 0x83, 0x08, 0x7a, 0x9a, 0xe1, 0x73, 0x53}: "LEMSetVariableCtlSmm",
		efi.GUID{0x51, 0xbd, 0x08, 0xa7, 0x6f, 0xf5, 0xa2, 0x4d, 0x8f, 0x78, 0x14, 0x80, 0xcb, 0x2c, 0x1d, 0x84}: "SMSC5045PeiInit",
		efi.GUID{0x51, 0xc0, 0xba, 0xb1, 0xc2, 0xd5, 0xc1, 0x4a, 0xac, 0x7d, 0x9d, 0x2f, 0x51, 0x8a, 0x1e, 0x7b}: "AmdApcbSmmV3",
		efi.GUID{0x51, 0xce, 0xcf, 0x6e, 0x24, 0x57, 0x0c, 0x45, 0xa3, 0x8a, 0x58, 0x55, 0x3e, 0x95, 0x44, 0x22}: "SmmAccessPei",
		efi.GUID{0x51, 0xd1, 0x9c, 0x65, 0x74, 0xca, 0xac, 0x47, 0x80, 0xdf, 0x05, 0x5f, 0x35, 0xbd, 0xbf, 0x4b}: "ControllerDiscoverySmm",
		efi.GUID{0x51, 0xd6, 0xa3, 0x0e, 0xb4, 0x49, 0xd9, 0x47, 0xbd, 0xc3, 0xe4, 0xa3, 0x79, 0xf3, 0xde, 0x76}: "HwmInitSmm",
		efi.GUID{0x51, 0xda, 0x56, 0x5f, 0x43, 0x6e, 0x5e, 0x43, 0xa1, 0x67, 0xfa, 0x44, 0x15, 0xe8, 0xe6, 0xb8}: "FjGabiCoreDxeBin",
		efi.GUID{0x51, 0xdc, 0x21, 0xb9, 0xd4, 0x49, 0x14, 0x4c, 0x90, 0x89, 0x93, 0x1c, 0x2d, 0x6b, 0x92, 0xbe}: "AmdSocAm4RvPei",
		efi.GUID{0x51, 0xdd, 0x54, 0x01, 0x79, 0x90, 0x10, 0x4a, 0x89, 0x5c, 0x9c, 0x07, 0x72, 0x81, 0x57, 0x88}: "PlatformBootManagerStringPackGuid",
		efi.GUID{0x51, 0xe0, 0x2e, 0xfb, 0xf6, 0xa1, 0x6c, 0x4b, 0xa1, 0x37, 0x96, 0x1c, 0x41, 0xf2, 0xc5, 0xdd}: "TPMfirmwaredriver",
		efi.GUID{0x51, 0xe0, 0xf1, 0x2d, 0x6d, 0x90, 0xff, 0x4e, 0x86, 0x9d, 0x24, 0xe6, 0x53, 0x78, 0xfb, 0x9e}: "ConsoleInDevicesStartedProtocol",
		efi.GUID{0x51, 0xf2, 0x66, 0x9e, 0x7c, 0x72, 0x8c, 0x41, 0xbf, 0xd6, 0xc2, 0xb4, 0x25, 0x28, 0x18, 0xea}: "EfiHiiImageDecoderProtocolGuid",
		efi.GUID{0x51, 0xf4, 0xa1, 0xdc, 0x0f, 0x98, 0x1a, 0x47, 0x88, 0x82, 0x7a, 0x33, 0x12, 0x3d, 0xfe, 0x52}: "MemoryIdm",
		efi.GUID{0x51, 0xf9, 0x40, 0xe3, 0xd0, 0x0c, 0x18, 0x4e, 0xa0, 0xc7, 0x2e, 0x2f, 0xc9, 0xf6, 0xb0, 0x1b}: "FjGabiSettingsCoreAbstractionSmm",
		efi.GUID{0x52, 0x0a, 0xa9, 0x58, 0x9f, 0x92, 0xf8, 0x44, 0xac, 0x35, 0xa7, 0xe1, 0xab, 0x18, 0xac, 0x91}: "FPVARBAK",
		efi.GUID{0x52, 0x0b, 0x14, 0x9e, 0x36, 0xa6, 0x66, 0x4e, 0xa0, 0x60, 0x7d, 0xde, 0x15, 0x3b, 0x5e, 0x9b}: "HpTbtSetup",
		efi.GUID{0x52, 0x17, 0x33, 0xc4, 0xac, 0x8b, 0x2a, 0x4f, 0xa9, 0xc3, 0x41, 0x8a, 0xdf, 0xb0, 0x33, 0xc4}: "DellSpiPartWinbond",
		efi.GUID{0x52, 0x19, 0x3b, 0x41, 0x64, 0xd5, 0xeb, 0x4a, 0x8c, 0xda, 0x83, 0x53, 0x16, 0x15, 0x00, 0xbc}: "S3SaveSmm",
		efi.GUID{0x52, 0x22, 0x22, 0x13, 0x1b, 0x93, 0x52, 0x45, 0x95, 0x77, 0x68, 0x55, 0x61, 0x13, 0xaf, 0xd0}: "FjSmmPcieCardReaderRTS5250",
		efi.GUID{0x52, 0x27, 0x85, 0xb5, 0x52, 0xc4, 0x66, 0x46, 0xb1, 0x89, 0x03, 0xee, 0xe5, 0xe3, 0xa0, 0x7b}: "KEMoPLATFORMMENUDxe",
		efi.GUID{0x52, 0x38, 0x8c, 0x90, 0x1b, 0xb6, 0x26, 0x4f, 0xab, 0x66, 0xf7, 0x4f, 0x97, 0xe7, 0xdc, 0x1c}: "AmtBypass",
		efi.GUID{0x52, 0x43, 0xad, 0xe1, 0x10, 0x26, 0xd6, 0x4d, 0xbb, 0x8f, 0x8b, 0xb2, 0xb0, 0x33, 0x83, 0xa3}: "LenovoSystemScsiOpromPassThruDxe",
		efi.GUID{0x52, 0x46, 0x23, 0x45, 0xb3, 0x62, 0xf7, 0x4b, 0x38, 0x78, 0xb5, 0x4f, 0xc4, 0x4b, 0x53, 0x28}: "ForceLpmAspmDisable",
		efi.GUID{0x52, 0x49, 0x2c, 0x1b, 0x78, 0xd7, 0x64, 0x4b, 0xbd, 0xa1, 0x15, 0xa3, 0x6f, 0x5f, 0xa5, 0x45}: "Slp20PubKey",
		efi.GUID{0x52, 0x52, 0x82, 0x28, 0x11, 0x32, 0x2f, 0x35, 0x49, 0xce, 0x31, 0x25, 0x34, 0xc4, 0x14, 0x19}: "OdmGetPchCf9TrapHandleProtocol",
		efi.GUID{0x52, 0x56, 0x19, 0x33, 0x4f, 0x2c, 0x55, 0x4b, 0xb6, 0xcb, 0x63, 0xd3, 0xc3, 0x85, 0x98, 0xd3}: "PchHsUartDxe",
		efi.GUID{0x52, 0x57, 0x11, 0xde, 0x9d, 0xa7, 0x33, 0x4f, 0x84, 0x59, 0xa9, 0x52, 0x4a, 0x64, 0xfc, 0x52}: "SioFanMapSmm",
		efi.GUID{0x52, 0x5e, 0xd8, 0xf8, 0xf9, 0x00, 0xe4, 0x4d, 0xae, 0xec, 0x0a, 0xe7, 0x6b, 0xa6, 0xc2, 0x10}: "FjGpioCoffeeLakePei",
		efi.GUID{0x52, 0x62, 0x56, 0x5e, 0x6c, 0x4f, 0x1a, 0x07, 0x48, 0x5d, 0xc0, 0xb6, 0xcd, 0x6d, 0x05, 0xef}: "AmdPspP2CmboxV2SmmBuffer",
		efi.GUID{0x52, 0x6c, 0x29, 0x63, 0xcf, 0x01, 0xea, 0x4e, 0xa4, 0x7c, 0x78, 0x2a, 0x14, 0xda, 0x68, 0x94}: "SmramSaveInfoHandlerSmm",
		efi.GUID{0x52, 0x70, 0xe3, 0xa1, 0xd9, 0x80, 0x65, 0x4e, 0xa3, 0x17, 0x3e, 0x9a, 0x55, 0xc4, 0x3e, 0xc9}: "EfiIdeControllerInitProtocolGuid",
		efi.GUID{0x52, 0x73, 0x09, 0xed, 0x41, 0x90, 0x5a, 0x44, 0x80, 0xb6, 0xb2, 0x9d, 0x50, 0x9e, 0x88, 0x45}: "PchDmiTcVcPpi",
		efi.GUID{0x52, 0x75, 0x72, 0x47, 0x4b, 0xa5, 0x84, 0x4a, 0x8c, 0xc1, 0xbf, 0xf2, 0x3e, 0x23, 0x96, 0x36}: "Tcg2PlatformPei",
		efi.GUID{0x52, 0x84, 0x7c, 0xa7, 0x21, 0x08, 0x44, 0x45, 0xae, 0x47, 0x25, 0x74, 0x89, 0x85, 0x5f, 0x91}: "AmiPspNvramDxe",
		efi.GUID{0x52, 0x85, 0x78, 0xb4, 0x0a, 0x65, 0xd2, 0x43, 0xbf, 0xe4, 0x32, 0x4b, 0x4e, 0x1b, 0x43, 0x5d}: "ToBootEvent",
		efi.GUID{0x52, 0x9f, 0x35, 0x0e, 0xde, 0xc6, 0xa4, 0x4e, 0x9a, 0x05, 0x85, 0x7d, 0xe1, 0xb7, 0xd3, 0x20}: "FjWifi6eSupport",
		efi.GUID{0x52, 0xa5, 0x33, 0xa7, 0xe6, 0x26, 0x03, 0x48, 0x92, 0xde, 0x6c, 0x55, 0x43, 0xee, 0x54, 0xea}: "SlotDataUpdateDxeSierra",
		efi.GUID{0x52, 0xb1, 0x82, 0xfe, 0xc9, 0x96, 0x53, 0x4a, 0x95, 0xdc, 0x6e, 0x49, 0xc8, 0x50, 0x87, 0xc3}: "ControllerDiscoveryDxe",
		efi.GUID{0x52, 0xc8, 0xb7, 0x0f, 0xca, 0xad, 0x53, 0x48, 0x8d, 0x0f, 0xfb, 0xa7, 0x1b, 0x1c, 0xe1, 0x1a}: "EfiFormBrowserCompatibilityProtocolGuid",
		efi.GUID{0x52, 0xc8, 0xee, 0x3f, 0x4c, 0xf1, 0x7f, 0x4e, 0x97, 0xfd, 0x4c, 0x3a, 0x8c, 0x5b, 0xbe, 0xcc}: "FWkey",
		efi.GUID{0x52, 0xce, 0x5e, 0xa0, 0xa8, 0x15, 0x4e, 0x42, 0xbf, 0xd3, 0xfc, 0xf3, 0xd5, 0x66, 0xa0, 0x9c}: "AmtPolicyInitPei",
		efi.GUID{0x52, 0xd1, 0xf7, 0x3f, 0x86, 0xef, 0xc3, 0x47, 0x97, 0xb0, 0xce, 0xd9, 0xbb, 0x80, 0x9a, 0x67}: "ClvBootTimeTestExecution",
		efi.GUID{0x52, 0xd3, 0x91, 0xc4, 0x23, 0x76, 0x43, 0x48, 0xac, 0xcc, 0x27, 0x91, 0xa7, 0x57, 0x44, 0x21}: "DefaultdbFile2",
		efi.GUID{0x52, 0xd5, 0x2a, 0x6f, 0x66, 0xf0, 0xd6, 0x4e, 0xad, 0xa3, 0xd9, 0x2a, 0x3d, 0x8e, 0xa1, 0x6e}: "CcgOnlySmm",
		efi.GUID{0x52, 0xd6, 0x53, 0x9e, 0xe1, 0xd0, 0x06, 0x49, 0xa0, 0xcb, 0x31, 0x68, 0x5c, 0x32, 0xbf, 0xcc}: "DellNbEcPei",
		efi.GUID{0x52, 0xf3, 0x99, 0xd2, 0x4f, 0x09, 0x87, 0x4b, 0x8c, 0xd2, 0xc9, 0x4f, 0x9e, 0x0a, 0x44, 0xc3}: "DellRecoveryPei",
		efi.GUID{0x52, 0xfb, 0x9f, 0x2b, 0x13, 0x1b, 0x6f, 0x41, 0xa8, 0x7b, 0xbc, 0x93, 0x0d, 0xef, 0x92, 0xa8}: "TcgEventEntryHobGuid",
		efi.GUID{0x53, 0x0a, 0xb9, 0x59, 0x1b, 0x46, 0x50, 0x4c, 0xa7, 0x9f, 0xa3, 0x27, 0x73, 0xc3, 0x19, 0xae}: "IdeBusSrc",
		efi.GUID{0x53, 0x0b, 0x6c, 0x97, 0xe2, 0x45, 0x17, 0x4d, 0x83, 0x28, 0x8e, 0x8f, 0x5c, 0xa3, 0x00, 0x2a}: "OobEthDxe",
		efi.GUID{0x53, 0x0e, 0xc3, 0x83, 0x4c, 0x7a, 0x73, 0x42, 0xa6, 0x86, 0x65, 0xe9, 0xdc, 0x09, 0xd7, 0x5b}: "AcpiDebugTable",
		efi.GUID{0x53, 0x13, 0x0e, 0x8b, 0x8c, 0x35, 0x2f, 0x4e, 0x93, 0x45, 0xee, 0xbf, 0x1d, 0xab, 0x98, 0x9b}: "AsrockRtlandxe",
		efi.GUID{0x53, 0x15, 0x6a, 0x68, 0xd8, 0x4b, 0x94, 0x47, 0xaa, 0x27, 0x27, 0xf5, 0x73, 0x84, 0xa9, 0x90}: "DellEepromToNvs",
		efi.GUID{0x53, 0x1e, 0x2d, 0x7c, 0x65, 0xe5, 0xea, 0x47, 0x8a, 0x1e, 0xdc, 0x97, 0x45, 0x99, 0x26, 0xb0}: "OemServiceSmm",
		efi.GUID{0x53, 0x1f, 0xe2, 0x98, 0x0c, 0x59, 0xce, 0x43, 0x99, 0xc8, 0x63, 0x7b, 0x65, 0x80, 0xa5, 0xda}: "DellUsbExtSmm",
		efi.GUID{0x53, 0x29, 0x40, 0xef, 0x19, 0xb8, 0xc2, 0x4c, 0xa4, 0x4c, 0x4c, 0x9b, 0x4c, 0xfb, 0xc8, 0x89}: "AmiTseOemPortingVar2Guid",
		efi.GUID{0x53, 0x2b, 0x65, 0x62, 0xd9, 0x79, 0xf2, 0x4c, 0xb5, 0xaa, 0xad, 0x99, 0x81, 0x0a, 0x7f, 0x17}: "EfiHpIoxAccess",
		efi.GUID{0x53, 0x2f, 0x01, 0xe6, 0x95, 0x75, 0x9a, 0x40, 0x9f, 0xac, 0x30, 0xe0, 0x39, 0x0a, 0x2a, 0x69}: "DellSmbQuickSetSupportProt",
		efi.GUID{0x53, 0x38, 0x5e, 0x09, 0x3d, 0x2f, 0x61, 0x40, 0xbb, 0xdf, 0x0e, 0xc0, 0xd4, 0x78, 0xfd, 0x16}: "OemServiceDxe",
		efi.GUID{0x53, 0x3a, 0x14, 0xf1, 0xeb, 0xcb, 0x33, 0x48, 0xa4, 0xdc, 0x08, 0x26, 0xe0, 0x63, 0xec, 0x08}: "MeRegionUpdateVolume",
		efi.GUID{0x53, 0x45, 0x94, 0xd8, 0xdd, 0xc4, 0xf4, 0x41, 0x9b, 0x30, 0xe1, 0x39, 0x7c, 0xfb, 0x26, 0x7b}: "EfiNicIp4ConfigVariableGuid",
		efi.GUID{0x53, 0x47, 0xc1, 0xe0, 0xbe, 0xf9, 0xd2, 0x11, 0x9a, 0x0c, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d}: "EfiPcAnsiGuid",
		efi.GUID{0x53, 0x5b, 0x20, 0xe5, 0x58, 0x97, 0xab, 0x44, 0xa4, 0x4d, 0xdb, 0x3b, 0xe4, 0x1d, 0x67, 0x42}: "DellNbConfigPei",
		efi.GUID{0x53, 0x5d, 0xec, 0xb0, 0x81, 0x74, 0x21, 0x48, 0xac, 0x57, 0x69, 0xdd, 0xb2, 0x86, 0x8d, 0xe6}: "UndiLayer",
		efi.GUID{0x53, 0x5d, 0xfb, 0x01, 0xf9, 0x4f, 0xd9, 0x4a, 0xad, 0xf5, 0x7d, 0xc6, 0x36, 0x59, 0xa1, 0xb2}: "PeiPciEnumeration",
		efi.GUID{0x53, 0x61, 0xf4, 0x96, 0xa7, 0x97, 0x93, 0x47, 0xac, 0xc1, 0xfa, 0x19, 0xbf, 0x78, 0xea, 0x97}: "EdkiiPeCoffImageEmulatorProtocol",
		efi.GUID{0x53, 0x65, 0x78, 0xca, 0x6a, 0xac, 0xaa, 0x41, 0x9a, 0xb6, 0x53, 0x16, 0x30, 0x85, 0x0c, 0x92}: "ICE30plusPEI",
		efi.GUID{0x53, 0x66, 0x05, 0x69, 0xc6, 0x3f, 0x82, 0x43, 0x90, 0xec, 0xb5, 0xfa, 0xf7, 0x59, 0x9f, 0xd3}: "CnlHsioTuning",
		efi.GUID{0x53, 0x68, 0x45, 0x70, 0x0e, 0xd7, 0x6c, 0x49, 0xb6, 0xb1, 0xcf, 0x88, 0xa3, 0x0b, 0xe1, 0xa9}: "AmdVersionPei",
		efi.GUID{0x53, 0x6b, 0x9a, 0x14, 0xfa, 0xfa, 0xf9, 0x44, 0x8b, 0xaf, 0xf5, 0x0c, 0x68, 0xa0, 0x52, 0x36}: "ScInitDxe",
		efi.GUID{0x53, 0x6c, 0xcb, 0x4e, 0x41, 0xc6, 0x70, 0x43, 0x8c, 0xb2, 0x3b, 0x0e, 0x49, 0x6e, 0x83, 0x78}: "EfiExtendedSalVariableServicesProtocolGuid",
		efi.GUID{0x53, 0x71, 0xc2, 0xc7, 0xfd, 0xe7, 0x67, 0x4d, 0x96, 0x70, 0xcb, 0x21, 0x4e, 0xef, 0x0f, 0x0e}: "LEMBBRecoveryPostFlag",
		efi.GUID{0x53, 0x7a, 0xdc, 0xf7, 0x89, 0xd7, 0x49, 0x41, 0x9d, 0xec, 0xc1, 0x8f, 0x2f, 0x8c, 0xc3, 0xd3}: "SioPowerButtonOverrideDxe",
		efi.GUID{0x53, 0x7a, 0xdc, 0xf7, 0x89, 0xd7, 0x49, 0x48, 0x9d, 0xec, 0xc7, 0x8f, 0x2f, 0x8c, 0xc1, 0xd6}: "SmartCoverDxe",
		efi.GUID{0x53, 0x87, 0x5a, 0xfa, 0x0e, 0xa3, 0x73, 0x4c, 0x92, 0x65, 0x8f, 0xec, 0x0a, 0xc1, 0x18, 0xae}: "UsbHubEnableSmi",
		efi.GUID{0x53, 0x89, 0x79, 0x60, 0x91, 0x1e, 0xc9, 0x46, 0xb5, 0x21, 0x31, 0x66, 0x23, 0x42, 0x45, 0x22}: "WheaErrorLog",
		efi.GUID{0x53, 0x8a, 0x71, 0x70, 0x5e, 0xe0, 0xa4, 0x41, 0x84, 0x20, 0x37, 0x8b, 0xea, 0x75, 0x95, 0x1f}: "ClickBiosUiSimple",
		efi.GUID{0x53, 0x8b, 0xa8, 0x2c, 0x96, 0xd2, 0x80, 0x40, 0xa4, 0xa5, 0xca, 0xd9, 0xba, 0xe2, 0x4b, 0x09}: "LoadFixedAddressConfigurationTableGuid",
		efi.GUID{0x53, 0x93, 0x52, 0x8b, 0xcc, 0x1f, 0xc0, 0x4a, 0xa1, 0x21, 0x90, 0xbe, 0x9f, 0x9c, 0xbf, 0x7a}: "DellDiagsLegacy",
		efi.GUID{0x53, 0xa3, 0xed, 0x9e, 0x30, 0x29, 0xcb, 0x46, 0xa0, 0x23, 0x03, 0xe4, 0xe3, 0x58, 0xa9, 0x0c}: "FchPromontoryPlusSmmInit",
		efi.GUID{0x53, 0xa4, 0x99, 0x27, 0x10, 0xfc, 0x34, 0x43, 0x9e, 0x66, 0xd3, 0xd6, 0xef, 0x09, 0xd0, 0xee}: "AmiTseOemPortingVar5Guid",
		efi.GUID{0x53, 0xb1, 0x7e, 0x63, 0x4a, 0xdb, 0xf1, 0x42, 0x91, 0x01, 0xaa, 0xa0, 0xfe, 0x3e, 0xe1, 0x56}: "FjVgaSmm",
		efi.GUID{0x53, 0xb1, 0xd7, 0xb1, 0x8c, 0x11, 0xeb, 0x48, 0x98, 0x2c, 0xb5, 0x5f, 0xce, 0x99, 0xf6, 0xf4}: "GpnvErrorLoggingToken",
		efi.GUID{0x53, 0xb5, 0x25, 0x88, 0xa6, 0x85, 0x6a, 0x46, 0x98, 0x46, 0x0c, 0xc2, 0x3c, 0x5a, 0xea, 0x42}: "SystemSetupCapsuleUpdateDxe",
		efi.GUID{0x53, 0xb5, 0x41, 0x6b, 0x49, 0xa6, 0xd4, 0x11, 0xbd, 0x02, 0x00, 0x80, 0xc7, 0x3c, 0x88, 0x81}: "WinNtSerialIoDxe",
		efi.GUID{0x53, 0xb8, 0xbf, 0x9f, 0x98, 0x70, 0x29, 0x49, 0xb2, 0x62, 0x43, 0x53, 0x7d, 0x88, 0xa4, 0x14}: "SystemErrorCheckPEI",
		efi.GUID{0x53, 0xc0, 0xe0, 0x5a, 0xb3, 0xc2, 0x7d, 0x4e, 0xad, 0xd9, 0xfd, 0x3c, 0xeb, 0xc6, 0xd3, 0xd9}: "SlotDataUpdateDxeLightningRidgeEXRP",
		efi.GUID{0x53, 0xc6, 0x11, 0x5d, 0x54, 0x81, 0xc3, 0x4a, 0xa8, 0xc2, 0xfb, 0xa2, 0x89, 0x20, 0xfc, 0x90}: "VariableFlashInfoHob",
		efi.GUID{0x53, 0xc8, 0x92, 0x63, 0x10, 0xb6, 0x4e, 0x4a, 0x96, 0x44, 0x3d, 0xbf, 0x88, 0xae, 0x11, 0xee}: "NuvotonFwManagementDxe",
		efi.GUID{0x53, 0xd2, 0x37, 0x9e, 0xf8, 0xab, 0x85, 0x49, 0x8e, 0x23, 0xba, 0xca, 0x10, 0x39, 0x56, 0x13}: "OemSkuTokenSpace",
		efi.GUID{0x53, 0xd2, 0xd1, 0x1e, 0x2b, 0xe6, 0xc2, 0x47, 0xac, 0xc3, 0x50, 0xb8, 0x59, 0xcb, 0xd5, 0x11}: "Armani_BatteryHealthControlDxe",
		efi.GUID{0x53, 0xd5, 0xd2, 0x4f, 0xbd, 0xda, 0x17, 0x4c, 0xad, 0xc1, 0x32, 0xc8, 0xf3, 0xed, 0xaa, 0xd9}: "LcdShadowDxe",
		efi.GUID{0x53, 0xda, 0xe9, 0x0f, 0x3d, 0x04, 0x65, 0x42, 0xa9, 0x4d, 0xfd, 0x77, 0xfe, 0xde, 0x2e, 0xb4}: "TcgPlatformSetupPeiPolicy",
		efi.GUID{0x53, 0xed, 0xd6, 0xb0, 0x44, 0xb8, 0xf5, 0x43, 0xbd, 0x2f, 0x61, 0x09, 0x52, 0x64, 0xe7, 0x7e}: "PchSmiDispatcher",
		efi.GUID{0x53, 0xf8, 0x52, 0x76, 0x43, 0x62, 0x58, 0x43, 0x2b, 0xbd, 0x6f, 0x23, 0x5d, 0xca, 0x34, 0xab}: "DellSmmHwAccessInfo",
		efi.GUID{0x53, 0xff, 0x9a, 0x46, 0x25, 0xe6, 0x60, 0x44, 0x8f, 0x18, 0xaa, 0x22, 0x06, 0xda, 0xe5, 0xbe}: "DellDockSmm",
		efi.GUID{0x54, 0x01, 0xf9, 0x79, 0xf4, 0x83, 0x8c, 0x47, 0x80, 0xbf, 0x87, 0x8a, 0xc3, 0x2e, 0x0a, 0x2c}: "RTL8111EPV",
		efi.GUID{0x54, 0x0a, 0xdb, 0x10, 0xf9, 0xf6, 0xa2, 0x4c, 0xa7, 0x5e, 0xf9, 0xaa, 0xca, 0xe7, 0x09, 0x70}: "BiosGuardConfigGuid",
		efi.GUID{0x54, 0x15, 0x65, 0x57, 0x8f, 0xbe, 0x46, 0x45, 0x80, 0xc6, 0x36, 0x32, 0x3d, 0x52, 0x93, 0x5a}: "AmdPlatformRasRsDxe",
		efi.GUID{0x54, 0x16, 0xc4, 0xef, 0xad, 0x87, 0x1d, 0x46, 0xa5, 0xf2, 0xd7, 0x9b, 0x0c, 0x01, 0xc3, 0x1a}: "DellWmiBiosAttribSmm",
		efi.GUID{0x54, 0x22, 0x54, 0xc7, 0xf7, 0xa8, 0xba, 0x40, 0x9b, 0xb9, 0x39, 0x0d, 0x31, 0x97, 0x77, 0x75}: "OCMR_PEI",
		efi.GUID{0x54, 0x23, 0xce, 0x78, 0xbc, 0xcf, 0x43, 0x46, 0xae, 0xba, 0x07, 0xa2, 0x7f, 0xa8, 0x92, 0xbf}: "WdtPersistentData",
		efi.GUID{0x54, 0x3f, 0xe2, 0xf2, 0x85, 0x89, 0xdb, 0x11, 0xac, 0x79, 0x00, 0x40, 0xd0, 0x2b, 0x18, 0x35}: "EfiUnixIoProtocol",
		efi.GUID{0x54, 0x4d, 0x57, 0x7d, 0x64, 0xd3, 0x4a, 0x4d, 0x95, 0xe3, 0x49, 0x45, 0xdb, 0x7a, 0xd3, 0xee}: "ShellInstall1HiiGuid",
		efi.GUID{0x54, 0x52, 0x4d, 0x33, 0x60, 0x61, 0x4a, 0x4e, 0xa7, 0x8c, 0xe1, 0x5d, 0x3b, 0x3b, 0x33, 0x34}: "MmcHost",
		efi.GUID{0x54, 0x5d, 0x2c, 0x88, 0xad, 0x1d, 0x4a, 0x4f, 0x83, 0x16, 0x4b, 0xdf, 0x84, 0x1e, 0x09, 0xd0}: "EfiNorthPeakStatusCodeHandlePpi",
		efi.GUID{0x54, 0x62, 0xd5, 0xbd, 0x90, 0x68, 0x6d, 0x44, 0x91, 0x71, 0x3c, 0x37, 0x0a, 0x58, 0x4b, 0x2c}: "ITEAcPowerLossSmm",
		efi.GUID{0x54, 0x67, 0x80, 0xda, 0x95, 0xaf, 0x1b, 0x4e, 0xab, 0xc8, 0xfa, 0xb5, 0x69, 0xfc, 0x2b, 0x3f}: "DellErrorHandlerPei",
		efi.GUID{0x54, 0x6a, 0x01, 0x76, 0x59, 0x99, 0x5d, 0x49, 0xbb, 0x3e, 0xba, 0x35, 0xe2, 0x5a, 0x51, 0xcb}: "SystemSetupMainDxe",
		efi.GUID{0x54, 0x6d, 0x70, 0x54, 0x51, 0x22, 0xf6, 0x46, 0x90, 0xa8, 0xaf, 0xf0, 0xd4, 0xcd, 0x1e, 0x7d}: "WifiConnectionManagerDxe",
		efi.GUID{0x54, 0x74, 0xc5, 0x5e, 0xb9, 0xec, 0xb5, 0x49, 0x98, 0xc2, 0xfb, 0xf2, 0x02, 0x1b, 0xbe, 0x6e}: "OemPSU",
		efi.GUID{0x54, 0x7c, 0xcc, 0x95, 0x3a, 0xfb, 0xa7, 0x46, 0xbc, 0xb1, 0x3d, 0x68, 0xaa, 0x2b, 0xe5, 0x26}: "GnbDxe",
		efi.GUID{0x54, 0x7e, 0xc1, 0x88, 0xfe, 0xeb, 0x31, 0x45, 0xa9, 0x92, 0x58, 0x10, 0x29, 0xf5, 0x81, 0x26}: "FspPcdInit",
		efi.GUID{0x54, 0x93, 0x7f, 0xf2, 0x92, 0xa6, 0x27, 0x4d, 0xbe, 0xb5, 0x24, 0x08, 0xc6, 0xf4, 0x3b, 0x04}: "FjBatteryFuncsDxe",
		efi.GUID{0x54, 0x99, 0x4e, 0x87, 0xd4, 0x24, 0xe6, 0x43, 0x90, 0xa1, 0xc5, 0x77, 0x53, 0x40, 0xcf, 0x45}: "AmiPlatformInfoHob",
		efi.GUID{0x54, 0x99, 0x92, 0xba, 0xb0, 0x35, 0xd3, 0x4d, 0x90, 0xcd, 0x96, 0x34, 0xbd, 0x7e, 0x1c, 0xf1}: "ResetDxe",
		efi.GUID{0x54, 0x9e, 0x83, 0xbd, 0x54, 0xfe, 0x64, 0x4b, 0x9f, 0xa3, 0x0a, 0x80, 0x6b, 0x10, 0x42, 0xbc}: "HddDynamicSwitch",
		efi.GUID{0x54, 0xa1, 0x21, 0x58, 0x3c, 0x1e, 0xc0, 0x4e, 0x92, 0xc9, 0x2a, 0x66, 0xab, 0x2f, 0xf1, 0x86}: "FjNuvotonNct6796Smm",
		efi.GUID{0x54, 0xa5, 0x25, 0x03, 0xbe, 0x05, 0x6b, 0x46, 0xbc, 0x8c, 0x70, 0xbe, 0x3c, 0x9d, 0xaf, 0xb1}: "AmiTcg2InfoProtocolGuid",
		efi.GUID{0x54, 0xa5, 0x46, 0x55, 0x46, 0xc2, 0xd6, 0x46, 0x97, 0xe1, 0x25, 0x06, 0xd2, 0xd8, 0xb6, 0x74}: "AmiUpdateBoardIdHob",
		efi.GUID{0x54, 0xa6, 0x58, 0xd4, 0x4c, 0xf6, 0xdb, 0x49, 0xb8, 0xd1, 0x38, 0x21, 0x30, 0x6b, 0xf1, 0xf6}: "BaseMemoryLibMmx",
		efi.GUID{0x54, 0xa7, 0xd8, 0x98, 0x82, 0x84, 0xe2, 0x46, 0x82, 0x8c, 0xbb, 0x63, 0x2f, 0x34, 0xd9, 0xf7}: "DellHotSosDxeDriver",
		efi.GUID{0x54, 0xb0, 0x7a, 0x90, 0x2b, 0x71, 0xba, 0x41, 0x93, 0x0f, 0x2b, 0xbf, 0xb7, 0xf5, 0x7e, 0xcb}: "DellQuickSetSmm",
		efi.GUID{0x54, 0xbe, 0x5f, 0xfd, 0x35, 0x8c, 0x45, 0xb3, 0x8a, 0x0f, 0x7a, 0xc8, 0xa5, 0xfd, 0x05, 0x21}: "EmuSnpProtocolGuid",
		efi.GUID{0x54, 0xc0, 0x9f, 0xd9, 0x38, 0xcc, 0x82, 0x45, 0xb0, 0xa6, 0xf5, 0x33, 0x67, 0x8b, 0xaf, 0xa9}: "DellPeiPchGpioControl",
		efi.GUID{0x54, 0xc2, 0x20, 0x4f, 0xd0, 0x75, 0x7c, 0x43, 0x93, 0xab, 0xcd, 0x2f, 0x88, 0x79, 0x5e, 0x88}: "FjGabiIntrusionAbstraction",
		efi.GUID{0x54, 0xc4, 0xbb, 0x7a, 0x37, 0xf7, 0x22, 0x43, 0x93, 0x1c, 0xb1, 0xbb, 0x62, 0xa0, 0x1d, 0x6f}: "BootMonFs",
		efi.GUID{0x54, 0xc8, 0x2f, 0x68, 0xcb, 0xd0, 0x9f, 0x4c, 0xa8, 0xc4, 0xf4, 0xf9, 0x7a, 0x39, 0xef, 0x3e}: "OemProcMemInitLibPpi",
		efi.GUID{0x54, 0xcb, 0x06, 0xe7, 0xb8, 0x84, 0xbd, 0x40, 0x83, 0x2f, 0x7f, 0xb2, 0xd5, 0xcb, 0x87, 0xb3}: "FileExplorerLite",
		efi.GUID{0x54, 0xd5, 0x6c, 0x16, 0xae, 0x8a, 0x17, 0x46, 0x8f, 0xdd, 0xa2, 0xe3, 0xa5, 0xaf, 0xd8, 0x9e}: "SystemSetupSecurityDxe",
		efi.GUID{0x54, 0xe4, 0x04, 0x40, 0xa0, 0x89, 0xe3, 0x11, 0x89, 0xaa, 0x97, 0xef, 0x9d, 0x94, 0x2a, 0xbc}: "ArmVExpressFastBootDxe",
		efi.GUID{0x54, 0xe9, 0x95, 0xd9, 0xc1, 0xbb, 0x0f, 0x43, 0xad, 0x91, 0xb4, 0x4d, 0xcb, 0x3c, 0x6f, 0x35}: "EfiPcieErrorSectionGuid",
		efi.GUID{0x54, 0xf0, 0x0c, 0x6f, 0x6a, 0xae, 0x8c, 0x41, 0xa7, 0xce, 0x3c, 0x7a, 0x7c, 0xd7, 0x4e, 0xc0}: "LogoPcx",
		efi.GUID{0x54, 0xf1, 0x61, 0x9a, 0x83, 0x4a, 0xc5, 0xb8, 0x80, 0xde, 0x23, 0x9b, 0xff, 0x40, 0xd6, 0x6b}: "AmdRasDxe",
		efi.GUID{0x55, 0x1d, 0xb6, 0xd1, 0xe1, 0x88, 0x14, 0x4c, 0x89, 0x04, 0x9e, 0x7c, 0xea, 0x40, 0xad, 0x6f}: "Cf9Reset",
		efi.GUID{0x55, 0x26, 0x47, 0x91, 0xe0, 0x50, 0x81, 0x4d, 0x9a, 0xf6, 0x23, 0x9e, 0x6f, 0x43, 0x1b, 0x8c}: "H19StartupMenu",
		efi.GUID{0x55, 0x2f, 0x30, 0x35, 0xc3, 0x51, 0xde, 0x40, 0xb6, 0x8f, 0x1e, 0xf1, 0x44, 0xcc, 0xf1, 0xe8}: "LegacyUsbDxe",
		efi.GUID{0x55, 0x38, 0xa5, 0x7d, 0x30, 0xf6, 0x30, 0x4a, 0x9d, 0x85, 0x0e, 0x99, 0xdf, 0xd9, 0x2a, 0x06}: "EfiPlatformTypeLightningRidgeExecB4Protocol",
		efi.GUID{0x55, 0x3e, 0x96, 0x12, 0x26, 0x58, 0x9e, 0x46, 0xa9, 0x34, 0xa3, 0xcb, 0xb3, 0x07, 0x6e, 0xc5}: "DellSmmSbAcpi",
		efi.GUID{0x55, 0x40, 0xf0, 0x77, 0x04, 0x3e, 0x21, 0x48, 0xbe, 0xb0, 0xb2, 0xae, 0xe4, 0x98, 0x31, 0x98}: "FchSongshanI3cPei",
		efi.GUID{0x55, 0x43, 0xeb, 0x37, 0xc5, 0x1f, 0xe6, 0x42, 0x90, 0x39, 0xd5, 0x75, 0xd5, 0x05, 0x1c, 0x2c}: "HpFlashMeDxe",
		efi.GUID{0x55, 0x44, 0x14, 0xfd, 0x1b, 0x59, 0x1c, 0x4e, 0x80, 0xef, 0x29, 0x5b, 0x78, 0x3f, 0xc8, 0xd4}: "CrashLogSmm",
		efi.GUID{0x55, 0x48, 0xe4, 0x46, 0x60, 0xbd, 0xb7, 0x4a, 0xab, 0x0d, 0xa6, 0x79, 0xb9, 0x44, 0x7d, 0x77}: "EfiTcp6ProtocolGuid",
		efi.GUID{0x55, 0x4b, 0x15, 0xa8, 0x21, 0x20, 0x40, 0x4d, 0xae, 0x81, 0x2e, 0x23, 0xa0, 0x2d, 0xcc, 0x46}: "FtdiUsbSerialDxe",
		efi.GUID{0x55, 0x4e, 0x49, 0x4c, 0x49, 0x58, 0x42, 0x53, 0x45, 0x54, 0x54, 0x45, 0x52, 0x21, 0x21, 0x21}: "SlpSupport",
		efi.GUID{0x55, 0x57, 0x0d, 0x75, 0xc9, 0xa0, 0xd3, 0x42, 0xa3, 0x26, 0xb5, 0xd4, 0x65, 0x41, 0x35, 0x23}: "AppleSEPDxe",
		efi.GUID{0x55, 0x63, 0x1a, 0x85, 0x10, 0xce, 0x67, 0x4f, 0x9d, 0x13, 0x91, 0xb3, 0x28, 0x1a, 0x95, 0xd3}: "LenovoSystemOemActivationDxe",
		efi.GUID{0x55, 0x6c, 0xed, 0x01, 0x2e, 0x0d, 0x59, 0x48, 0xbb, 0x57, 0x30, 0x44, 0x73, 0x7a, 0x36, 0x79}: "PhConSplitterDxe",
		efi.GUID{0x55, 0x72, 0xc6, 0xa8, 0x29, 0xe0, 0x1a, 0x4b, 0x96, 0x8e, 0xec, 0xa6, 0xe9, 0xc1, 0x1c, 0x73}: "AmtSmbios",
		efi.GUID{0x55, 0x7e, 0x3b, 0xfd, 0x7b, 0xfa, 0x07, 0x4e, 0xae, 0x1d, 0x20, 0x8b, 0x81, 0xfb, 0x0b, 0xad}: "FvbRuntimeDxe",
		efi.GUID{0x55, 0x83, 0xf0, 0x1e, 0x36, 0x41, 0x3d, 0x44, 0xbe, 0x11, 0xb4, 0xcb, 0x99, 0x52, 0x4d, 0x80}: "HpWsCommonSmm",
		efi.GUID{0x55, 0x85, 0xac, 0xf4, 0x91, 0x3f, 0x68, 0x46, 0xac, 0x20, 0x95, 0x77, 0xe6, 0x90, 0x9d, 0xad}: "DecompressFspsDxe",
		efi.GUID{0x55, 0x90, 0xf2, 0xd4, 0xfb, 0xe1, 0xd4, 0x11, 0xbd, 0x0d, 0x00, 0x80, 0xc7, 0x3c, 0x88, 0x81}: "EfiWinNtCpuSpeed",
		efi.GUID{0x55, 0x92, 0x69, 0xf5, 0x5a, 0x11, 0x7d, 0x4f, 0xbb, 0x0c, 0x65, 0x8e, 0x9a, 0x1f, 0x42, 0xc6}: "PspfTpmLibNull",
		efi.GUID{0x55, 0x92, 0xba, 0x92, 0x19, 0x28, 0x79, 0x44, 0x86, 0x7a, 0x1c, 0x58, 0xf0, 0x72, 0xc5, 0xb2}: "TCG_MADriver",
		efi.GUID{0x55, 0x97, 0x2f, 0x97, 0x3e, 0xd7, 0x62, 0x43, 0xbf, 0x62, 0x2a, 0xa5, 0x6a, 0x8d, 0xa5, 0x11}: "DellCapsuleUpdateWrapper",
		efi.GUID{0x55, 0x98, 0xb5, 0x45, 0x0c, 0x50, 0x3b, 0x44, 0xb5, 0x04, 0x9a, 0xb4, 0xca, 0x29, 0xbc, 0x68}: "EfiPlatformTypeLightningRidgeEX8S1NProtocol",
		efi.GUID{0x55, 0x9d, 0xff, 0xdb, 0xb7, 0x89, 0xda, 0x46, 0xbd, 0xdf, 0x67, 0x7d, 0x3d, 0xc0, 0x24, 0x1d}: "EfiAcpiSupportProtocolGuid",
		efi.GUID{0x55, 0xa3, 0x62, 0x61, 0x41, 0xd6, 0x9f, 0x46, 0x82, 0xe5, 0xcf, 0xff, 0xf2, 0x72, 0x29, 0x73}: "TcrOverMarvellNotify",
		efi.GUID{0x55, 0xad, 0xe0, 0xca, 0xb7, 0x47, 0x03, 0x4e, 0xa7, 0x14, 0x95, 0xe1, 0x71, 0x1c, 0xc2, 0x79}: "BcpBootOrder",
		efi.GUID{0x55, 0xae, 0x0d, 0xa4, 0x33, 0x2f, 0xf5, 0x42, 0xb0, 0x64, 0xc8, 0xd6, 0x2c, 0xcf, 0x3b, 0x87}: "AppleSystemInitialization",
		efi.GUID{0x55, 0xb4, 0xc6, 0x33, 0xa9, 0x87, 0x8c, 0x4c, 0xa4, 0xf6, 0x6d, 0xb5, 0x08, 0xa6, 0x26, 0x0e}: "SkipScanRemovableDev",
		efi.GUID{0x55, 0xc1, 0xc4, 0x71, 0x4b, 0xd5, 0x59, 0x4d, 0xa2, 0xc1, 0xf9, 0xa5, 0x72, 0x3c, 0x65, 0xa8}: "EfiIsPlatformSupportWheaProtocolGuid",
		efi.GUID{0x55, 0xc4, 0x65, 0x68, 0x26, 0x86, 0xd8, 0x40, 0x90, 0xf4, 0xa6, 0x94, 0x60, 0xa4, 0xab, 0x5a}: "DcaHob",
		efi.GUID{0x55, 0xca, 0xff, 0x78, 0x69, 0x48, 0x93, 0x43, 0xbe, 0xe9, 0x72, 0xe5, 0x8b, 0xd3, 0xbe, 0x38}: "SystemFixedBusNumbersDxe",
		efi.GUID{0x55, 0xcb, 0xb0, 0x21, 0x30, 0x43, 0x43, 0x43, 0xaf, 0xf8, 0xa6, 0x80, 0x89, 0x12, 0x41, 0x18}: "DellServiceMenuConfig",
		efi.GUID{0x55, 0xcf, 0xaf, 0x37, 0x8c, 0x2e, 0x22, 0x47, 0xb9, 0x50, 0xb4, 0x8b, 0x91, 0x65, 0xc5, 0x6b}: "LenovoSetupMainDxe",
		efi.GUID{0x55, 0xd8, 0x23, 0x34, 0x19, 0x34, 0x5d, 0x4d, 0xb9, 0xea, 0x6c, 0x33, 0x9f, 0xac, 0xbb, 0xe6}: "HPWMI",
		efi.GUID{0x55, 0xda, 0xfa, 0xa5, 0xaf, 0x1c, 0x86, 0x44, 0x9c, 0xdb, 0x24, 0x01, 0x8e, 0x71, 0xe9, 0x52}: "PxeDriverDl",
		efi.GUID{0x55, 0xe1, 0xbd, 0x07, 0x6c, 0x61, 0x91, 0x42, 0xbd, 0x0b, 0x24, 0x41, 0x1f, 0x3b, 0xb9, 0x08}: "AmdRAIDCoreDxe",
		efi.GUID{0x55, 0xe7, 0x0b, 0x33, 0xed, 0xfb, 0x18, 0x4f, 0xb9, 0xa8, 0x49, 0x58, 0x56, 0xd3, 0xd7, 0xa1}: "EfiCpuHotAddDataProtocol",
		efi.GUID{0x55, 0xe9, 0x11, 0x4e, 0xca, 0xcc, 0xd4, 0x11, 0xbd, 0x0d, 0x00, 0x80, 0xc7, 0x3c, 0x88, 0x81}: "EfiWinNtGopGuid",
		efi.GUID{0x55, 0xef, 0xed, 0x07, 0xec, 0x24, 0xf3, 0x43, 0x8e, 0x3e, 0x8c, 0x08, 0x31, 0xe2, 0x1e, 0x68}: "EzTpmUpdStTpmFwUpdDrv",
		efi.GUID{0x55, 0xf0, 0x90, 0xd8, 0x3a, 0x87, 0x6e, 0x4e, 0xa7, 0x9f, 0x1b, 0x8d, 0xd2, 0x42, 0x7f, 0xe4}: "AmdNbioBaseRnDxe",
		efi.GUID{0x55, 0xf0, 0xab, 0x27, 0xb8, 0xb1, 0x26, 0x4c, 0x80, 0x48, 0x74, 0x8f, 0x37, 0xba, 0xa2, 0xdf}: "EfiEventExitBootServicesGuid",
		efi.GUID{0x55, 0xf5, 0x87, 0x03, 0xa8, 0x20, 0xc2, 0x4f, 0xbb, 0x94, 0xcd, 0x30, 0xda, 0x1b, 0x40, 0x08}: "EfiWindowsInt10Workaround",
		efi.GUID{0x56, 0x00, 0x9a, 0xa5, 0x41, 0x33, 0xb5, 0x44, 0x9c, 0x9c, 0x6d, 0x76, 0xf7, 0x67, 0x38, 0x17}: "SignOn",
		efi.GUID{0x56, 0x00, 0xaf, 0xda, 0xb5, 0x87, 0x84, 0x45, 0x85, 0x4c, 0xcf, 0x20, 0x7b, 0x36, 0x4c, 0xea}: "SwSmi534D0840",
		efi.GUID{0x56, 0x0a, 0xef, 0x78, 0xf0, 0x1c, 0x35, 0x45, 0xb5, 0xda, 0xf6, 0xfd, 0x2f, 0x40, 0x5a, 0x11}: "FmpDxe",
		efi.GUID{0x56, 0x10, 0x8c, 0xbd, 0x36, 0x9f, 0xec, 0x44, 0x92, 0xa8, 0xa6, 0x33, 0x7f, 0x81, 0x79, 0x86}: "EfiEdidActiveProtocolGuid",
		efi.GUID{0x56, 0x13, 0xb5, 0xd6, 0x90, 0x0c, 0xe6, 0x4e, 0xb3, 0xa7, 0x48, 0xaa, 0x74, 0xd4, 0xa7, 0x7a}: "SkipRegionAccessDxe",
		efi.GUID{0x56, 0x15, 0x89, 0xe6, 0x8f, 0x79, 0xc9, 0x4e, 0x9e, 0x48, 0xe1, 0x90, 0xb9, 0x01, 0x36, 0x4c}: "OemCheckErrors",
		efi.GUID{0x56, 0x20, 0xcd, 0xcc, 0x01, 0xd4, 0xef, 0x4d, 0x85, 0xb0, 0x1f, 0xa1, 0x1f, 0xf3, 0xb5, 0xe3}: "IioVvar",
		efi.GUID{0x56, 0x27, 0xf8, 0xae, 0xf2, 0x87, 0xf6, 0x4c, 0xbe, 0x80, 0xe5, 0x90, 0x55, 0x29, 0x5a, 0xa1}: "PEbiosinterface",
		efi.GUID{0x56, 0x2b, 0x7d, 0x3e, 0x47, 0x3f, 0xaa, 0x42, 0x8f, 0x6b, 0x22, 0xf5, 0x19, 0x81, 0x8d, 0xab}: "ScPcieSmiDispatchProtocolGuid",
		efi.GUID{0x56, 0x2c, 0xb2, 0x7a, 0x10, 0x25, 0xd2, 0x4f, 0xac, 0x18, 0x57, 0x39, 0x44, 0x19, 0xfb, 0xab}: "UsbOcUpdateDxeNeonCityFPGA",
		efi.GUID{0x56, 0x2c, 0xc0, 0xa5, 0xa7, 0x19, 0xb5, 0x43, 0xa0, 0xd0, 0x04, 0x51, 0x8a, 0x1c, 0xa6, 0x9e}: "AmdErrorPei",
		efi.GUID{0x56, 0x3a, 0xd9, 0x10, 0x64, 0x2d, 0xd3, 0x47, 0x82, 0x8d, 0x7a, 0x50, 0x66, 0x91, 0x52, 0x92}: "AmdRasBrApeiDxe",
		efi.GUID{0x56, 0x3c, 0x5b, 0xaf, 0xe6, 0x95, 0x34, 0x44, 0x93, 0x73, 0x39, 0xbb, 0x71, 0x8a, 0xcd, 0x00}: "DellFmpInterface",
		efi.GUID{0x56, 0x3e, 0x54, 0xb7, 0xd7, 0x08, 0x4f, 0x4c, 0xb5, 0xd6, 0x7e, 0x3a, 0xdf, 0xcb, 0x82, 0xc4}: "FjOemActivationSmm",
		efi.GUID{0x56, 0x3f, 0x84, 0x86, 0x5d, 0x67, 0xa5, 0x40, 0x95, 0x30, 0xbc, 0x85, 0x83, 0x72, 0xf1, 0x03}: "OsSelectionVariableGuid",
		efi.GUID{0x56, 0x40, 0xa7, 0xc1, 0x0e, 0x26, 0x71, 0x48, 0xa0, 0x31, 0xe6, 0x45, 0xa6, 0x5b, 0x6e, 0x11}: "EfiExtendedSalVirtualServicesProtocol",
		efi.GUID{0x56, 0x45, 0x67, 0x85, 0xb3, 0x04, 0x51, 0x41, 0x86, 0x12, 0x53, 0xc6, 0x28, 0x83, 0x5f, 0x34}: "H19DxeInstallHook",
		efi.GUID{0x56, 0x4f, 0xff, 0x73, 0x8e, 0xaa, 0x51, 0x44, 0xb3, 0x16, 0x36, 0x35, 0x36, 0x67, 0xad, 0x44}: "FspBootLoaderTolumHobGuid",
		efi.GUID{0x56, 0x53, 0xf7, 0x5f, 0xbd, 0x3e, 0x89, 0x45, 0xb8, 0xbb, 0xfe, 0xe7, 0xa3, 0x72, 0xe3, 0xf3}: "XnoteBatteryStatusDisplay",
		efi.GUID{0x56, 0x57, 0x04, 0x39, 0xa3, 0xfc, 0xbd, 0x49, 0x8d, 0xae, 0xc7, 0xba, 0xe8, 0x38, 0x9a, 0xff}: "Tcg2Dxe",
		efi.GUID{0x56, 0x67, 0x67, 0xbb, 0xa8, 0x99, 0xe0, 0x44, 0x81, 0x28, 0xae, 0x2b, 0xab, 0xad, 0x4c, 0x69}: "EcAuditLogDxe",
		efi.GUID{0x56, 0x6a, 0xda, 0x62, 0xfb, 0x13, 0x5a, 0x48, 0xa8, 0xda, 0xa3, 0xdd, 0x79, 0x12, 0xcb, 0x6b}: "AmiResetSystemEventGuid",
		efi.GUID{0x56, 0x7b, 0x25, 0x14, 0xa2, 0xbd, 0xaf, 0x4f, 0x8e, 0x4f, 0xc8, 0x85, 0xdf, 0x75, 0x58, 0x3c}: "IccPlatformDxe",
		efi.GUID{0x56, 0x7c, 0x70, 0x60, 0x72, 0x8b, 0x5b, 0x43, 0xab, 0x8f, 0x25, 0x1c, 0x9c, 0x0d, 0x2a, 0x34}: "BiosAuditLogSetupDxe",
		efi.GUID{0x56, 0x88, 0x38, 0xa9, 0x74, 0xf6, 0x2b, 0x4b, 0x98, 0xb8, 0x6f, 0x46, 0x30, 0x29, 0x71, 0x1c}: "SbSocRsDxe",
		efi.GUID{0x56, 0x8c, 0xc3, 0x0f, 0x0a, 0x50, 0x54, 0x46, 0x89, 0xa7, 0xf4, 0x3c, 0x1a, 0x38, 0x43, 0xf5}: "AmiPlatformInfoFfsFile",
		efi.GUID{0x56, 0x99, 0x30, 0x6b, 0x17, 0x66, 0x2b, 0x47, 0xbb, 0xc7, 0x2a, 0x09, 0xe5, 0x5e, 0x3e, 0x52}: "ProgressBarFullLeftEndcap",
		efi.GUID{0x56, 0x9a, 0xe2, 0xfd, 0x97, 0xc1, 0xe1, 0x4a, 0xbb, 0x98, 0x79, 0x2b, 0x2f, 0x09, 0x72, 0x5d}: "FspVariablePcd",
		efi.GUID{0x56, 0x9c, 0xeb, 0x62, 0x9c, 0xa7, 0x23, 0x44, 0xa7, 0xf0, 0x89, 0x1a, 0x34, 0x52, 0x08, 0xcd}: "IioDmiInitPeim",
		efi.GUID{0x56, 0xa0, 0x00, 0xe0, 0x65, 0x8e, 0x30, 0x47, 0xa6, 0xba, 0x6e, 0xd0, 0x8b, 0x8d, 0x28, 0x9c}: "FjSystemResetPei",
		efi.GUID{0x56, 0xa9, 0x59, 0xe1, 0x99, 0x32, 0xe9, 0x4e, 0x91, 0x76, 0x65, 0x18, 0x1a, 0x4e, 0x5e, 0x9f}: "AmiIdeBusInitProtocolGuid",
		efi.GUID{0x56, 0xaf, 0x4a, 0x75, 0x9b, 0x09, 0x0d, 0x44, 0x8d, 0xcd, 0x62, 0x6f, 0x4e, 0x2c, 0x52, 0xf4}: "RsaIScsiSupport",
		efi.GUID{0x56, 0xb3, 0xcf, 0xe2, 0xa9, 0x39, 0x7b, 0x49, 0xb6, 0xb1, 0x95, 0xb9, 0xd2, 0xeb, 0x28, 0x17}: "DellSlpConfig",
		efi.GUID{0x56, 0xb5, 0x06, 0x43, 0x3d, 0x2a, 0x5c, 0x45, 0xa5, 0xea, 0x16, 0xed, 0x45, 0x0b, 0xd5, 0x53}: "FjSystemResetPeiBin",
		efi.GUID{0x56, 0xb5, 0x82, 0x1e, 0xb6, 0x4e, 0x9f, 0x47, 0x95, 0x5a, 0x78, 0xa5, 0xfe, 0x0c, 0x0c, 0xb2}: "BroadcomWirelessDxe",
		efi.GUID{0x56, 0xb6, 0xa0, 0xad, 0x68, 0xad, 0x81, 0x42, 0x81, 0x3e, 0x5a, 0xda, 0x5a, 0x65, 0x58, 0x3f}: "EcRotClearVariable",
		efi.GUID{0x56, 0xbb, 0xae, 0x36, 0x8b, 0x1f, 0xc1, 0x4b, 0x8e, 0xfe, 0x40, 0x85, 0xa5, 0xd4, 0xc4, 0x0a}: "DellLegUsbMemSmm",
		efi.GUID{0x56, 0xc2, 0x80, 0x0c, 0x28, 0x34, 0x1c, 0x4d, 0xbb, 0xeb, 0x79, 0xfc, 0xc8, 0x12, 0xaf, 0xf6}: "RestorePasswordSMI",
		efi.GUID{0x56, 0xcf, 0x6b, 0x82, 0xc4, 0xba, 0xf4, 0x43, 0x8e, 0xa1, 0x8c, 0xdf, 0x0a, 0x12, 0x1a, 0xbd}: "LenovoTranslateService",
		efi.GUID{0x56, 0xd6, 0x96, 0x7c, 0x21, 0x6b, 0xa7, 0x45, 0x84, 0xd8, 0x50, 0x68, 0xee, 0xe1, 0xd4, 0x15}: "MAPS_SmartFanDxe",
		efi.GUID{0x56, 0xf8, 0x1a, 0xb5, 0x96, 0x71, 0x3c, 0x43, 0x88, 0x5e, 0xc7, 0xde, 0xc8, 0x38, 0x42, 0x66}: "Manufacture",
		efi.GUID{0x57, 0x06, 0xa2, 0x44, 0xb8, 0x10, 0x49, 0x40, 0xa1, 0x48, 0xac, 0xd8, 0x81, 0x2a, 0xf2, 0x57}: "Tcg2Smm",
		efi.GUID{0x57, 0x06, 0xad, 0x53, 0x74, 0x8a, 0x58, 0x43, 0x9f, 0x32, 0x04, 0xab, 0x4b, 0x5a, 0x0b, 0x92}: "SecureFlashEspFlagSmm",
		efi.GUID{0x57, 0x0b, 0xf8, 0x5f, 0x8f, 0x7f, 0xac, 0x48, 0xa1, 0xdd, 0x20, 0x74, 0x14, 0xf5, 0x03, 0xdb}: "WakeOnLanPei",
		efi.GUID{0x57, 0x0e, 0x40, 0x73, 0x67, 0xa4, 0xab, 0x45, 0x9f, 0x8c, 0xd2, 0x51, 0x9f, 0x76, 0xab, 0xa4}: "DeviceFwServiceDxe",
		efi.GUID{0x57, 0x0f, 0xe4, 0x5b, 0x68, 0xfa, 0x10, 0x46, 0xbb, 0xbf, 0xe9, 0xc5, 0xfc, 0xda, 0xd3, 0x65}: "GetPcdInfoProtocolGuid",
		efi.GUID{0x57, 0x14, 0xa0, 0xfe, 0x81, 0xe3, 0x35, 0x41, 0x94, 0x75, 0xc6, 0xaf, 0xd0, 0x07, 0x6c, 0x61}: "CryptoDxe",
		efi.GUID{0x57, 0x19, 0x36, 0xcd, 0xbe, 0xaf, 0x5e, 0x42, 0xa3, 0x58, 0x5f, 0x58, 0x89, 0xcf, 0xfe, 0x7b}: "EfiHiiOldProtocol",
		efi.GUID{0x57, 0x19, 0xce, 0x8d, 0x74, 0xd7, 0xda, 0x4f, 0xb9, 0x0f, 0x0b, 0x23, 0x1c, 0xb2, 0xe0, 0xcc}: "DellSmmServices",
		efi.GUID{0x57, 0x2f, 0xb5, 0xf1, 0xa6, 0x16, 0x22, 0x49, 0xb8, 0x1d, 0x65, 0x83, 0x84, 0x58, 0xfa, 0xb4}: "OemMfgPorting",
		efi.GUID{0x57, 0x4c, 0xfd, 0xdc, 0xfd, 0xaa, 0x92, 0x4d, 0xb5, 0x70, 0x04, 0xb1, 0x21, 0x2e, 0xd1, 0x5e}: "AmdCpmOemInitDxe",
		efi.GUID{0x57, 0x55, 0xfb, 0xdd, 0x2e, 0x3e, 0x69, 0x45, 0xb4, 0x59, 0xbe, 0xff, 0xe1, 0x89, 0xb8, 0xb0}: "AmiSmbiosFlashDataProtocolGuid",
		efi.GUID{0x57, 0x63, 0x7c, 0x0b, 0xf5, 0xa4, 0xb9, 0x48, 0xaa, 0x30, 0x0c, 0xe7, 0xf9, 0xe6, 0x6a, 0x72}: "RestoreVariablesSmi",
		efi.GUID{0x57, 0x68, 0xa1, 0x4c, 0xc5, 0xa0, 0x46, 0x4e, 0xbe, 0x0f, 0x98, 0xa4, 0xbb, 0x31, 0x4e, 0x5d}: "MemTest",
		efi.GUID{0x57, 0x68, 0xc2, 0xb4, 0xe5, 0x8f, 0xbe, 0x42, 0x96, 0x8b, 0x39, 0xf4, 0x5e, 0x92, 0x1d, 0x45}: "AppleDxePState",
		efi.GUID{0x57, 0x6b, 0x28, 0x88, 0x8e, 0x47, 0xbe, 0xec, 0x64, 0x07, 0xd8, 0xba, 0x02, 0xe7, 0x87, 0x3c}: "UsbPortConfigPortingDxe",
		efi.GUID{0x57, 0x70, 0xac, 0xf5, 0x50, 0x56, 0x6e, 0x46, 0xb6, 0x92, 0x76, 0xa4, 0x72, 0x23, 0xef, 0xb0}: "AcpiSmmPlatform",
		efi.GUID{0x57, 0x72, 0xcf, 0x80, 0xab, 0x87, 0xf9, 0x47, 0xa3, 0xfe, 0xd5, 0x0b, 0x76, 0xd8, 0x95, 0x41}: "PcdDxe",
		efi.GUID{0x57, 0x74, 0x07, 0x66, 0x51, 0x4e, 0xb6, 0x4b, 0x88, 0x9b, 0x1e, 0x8e, 0x19, 0x39, 0xa2, 0x14}: "SmmWakeOnLan",
		efi.GUID{0x57, 0x7c, 0x24, 0x78, 0xdb, 0x63, 0x08, 0x47, 0x99, 0xc2, 0xa8, 0xb4, 0xa9, 0xa6, 0x1f, 0x6b}: "EfiMtftp4ProtocolGuid",
		efi.GUID{0x57, 0x7f, 0xab, 0x48, 0x34, 0xdc, 0x6c, 0x4f, 0xa7, 0xd3, 0xb0, 0xb5, 0xb0, 0xa7, 0x43, 0x14}: "EfiIa32X64ErrorTypeMsCheckGuid",
		efi.GUID{0x57, 0x8f, 0x2e, 0xdd, 0x3f, 0x89, 0x35, 0x43, 0x8d, 0xea, 0x4b, 0x5c, 0x34, 0x3a, 0xe3, 0x98}: "FjDeviceInfoIntelLan",
		efi.GUID{0x57, 0x9a, 0xa2, 0x80, 0x37, 0xbf, 0x03, 0x44, 0xb7, 0xb0, 0xd6, 0x54, 0xe8, 0x4f, 0x8a, 0x6d}: "PchInitDxeEhl",
		efi.GUID{0x57, 0xa8, 0xe4, 0xe1, 0x70, 0xc9, 0x75, 0x40, 0xa4, 0xda, 0xe9, 0xc4, 0x1b, 0x69, 0xad, 0xfc}: "AmiTextOutProtocolGuid",
		efi.GUID{0x57, 0xab, 0xa8, 0x85, 0x44, 0x06, 0x10, 0x41, 0x85, 0x0f, 0x98, 0x13, 0x22, 0x04, 0x70, 0x70}: "EdkiiSmmLegacyBootProtocolGuid",
		efi.GUID{0x57, 0xaf, 0xec, 0x06, 0x95, 0x1a, 0xdd, 0x44, 0xae, 0x09, 0xab, 0x9b, 0x9b, 0xd6, 0x81, 0xe9}: "MpmAsfDxe",
		efi.GUID{0x57, 0xb3, 0x13, 0xbc, 0x0f, 0x3c, 0xc6, 0x40, 0x85, 0xa8, 0xd1, 0x8d, 0x26, 0x98, 0x98, 0xc1}: "OSDSMIfunctionDxe",
		efi.GUID{0x57, 0xb3, 0xf1, 0x07, 0x70, 0x42, 0x22, 0x41, 0xa3, 0x2a, 0x7e, 0xab, 0x3c, 0x01, 0x3b, 0xac}: "DfciManager",
		efi.GUID{0x57, 0xb6, 0xa7, 0x23, 0x7f, 0x07, 0xbc, 0x4a, 0xab, 0x7e, 0xb7, 0x0d, 0x8a, 0x38, 0x9d, 0xbe}: "DellVariableProtocol",
		efi.GUID{0x57, 0xb9, 0x97, 0x74, 0xc3, 0x20, 0x47, 0x4e, 0xa2, 0xc0, 0x59, 0x49, 0x66, 0xfd, 0x28, 0xfd}: "UefiDriverPolicyDXE",
		efi.GUID{0x57, 0xc1, 0xaa, 0x45, 0xb6, 0x93, 0xd6, 0x46, 0xaa, 0x9e, 0x4c, 0xf6, 0xc3, 0x29, 0x16, 0xa4}: "CRBSmm",
		efi.GUID{0x57, 0xc1, 0xc1, 0x0e, 0x5e, 0xdd, 0x6b, 0x42, 0x87, 0x64, 0x68, 0xc1, 0xda, 0x08, 0x8c, 0x49}: "OSDSMIFunctionPei",
		efi.GUID{0x57, 0xc2, 0x93, 0xf1, 0xb5, 0x3c, 0x90, 0x4d, 0xa6, 0x94, 0x2e, 0x37, 0x10, 0x82, 0xe1, 0x16}: "UpdateSerial_NUM",
		efi.GUID{0x57, 0xc3, 0x70, 0xa7, 0x93, 0xb6, 0x6d, 0x4e, 0xa6, 0xcf, 0xd2, 0x1c, 0x72, 0x8e, 0x55, 0x0b}: "EdkiiFormBrowserEx2ProtocolGuid",
		efi.GUID{0x57, 0xc4, 0x08, 0xae, 0x87, 0x57, 0x58, 0x46, 0x92, 0xc1, 0x91, 0x77, 0x41, 0x7f, 0xc0, 0xf8}: "OemPeiSetCstateSupport",
		efi.GUID{0x57, 0xc9, 0xaf, 0x6f, 0xe9, 0x08, 0x52, 0x42, 0x9c, 0x7f, 0xe8, 0x10, 0x85, 0x76, 0xaa, 0x11}: "SmartCoverSmm",
		efi.GUID{0x57, 0xd1, 0xf0, 0xb0, 0x8f, 0xad, 0xef, 0x45, 0xbf, 0xd6, 0xf5, 0x25, 0xaa, 0xbc, 0x30, 0x92}: "GabiSettingItemDefaultRestoreSmm",
		efi.GUID{0x57, 0xd2, 0xff, 0x7a, 0xd0, 0x51, 0x9a, 0x43, 0xa8, 0x9a, 0x85, 0xa3, 0x41, 0x93, 0x08, 0xe4}: "DellJSONParserDriver",
		efi.GUID{0x57, 0xe5, 0x4c, 0xac, 0xcd, 0xf5, 0x9e, 0x43, 0x96, 0x3c, 0x40, 0xf0, 0x96, 0x83, 0xda, 0xc5}: "AppleKeyMapAggregator",
		efi.GUID{0x57, 0xed, 0x1b, 0xf0, 0xbc, 0x04, 0x3f, 0x4f, 0x96, 0x60, 0xd6, 0xf2, 0xea, 0x22, 0x82, 0x59}: "EfiLegacySpiFlashProtocolGuid",
		efi.GUID{0x57, 0xef, 0x42, 0x3b, 0xd3, 0x16, 0xcb, 0x44, 0x86, 0x32, 0x9f, 0xdb, 0x06, 0xb4, 0x14, 0x51}: "MemoryInit",
		efi.GUID{0x57, 0xf2, 0x35, 0xde, 0xbf, 0x36, 0x71, 0x4f, 0x82, 0x70, 0x51, 0xcf, 0x53, 0x78, 0xb8, 0x6c}: "GraphicsConfiguration",
		efi.GUID{0x58, 0x0d, 0x74, 0xfc, 0xba, 0x59, 0x9b, 0x42, 0x99, 0xef, 0x62, 0x70, 0x51, 0x73, 0x7b, 0x76}: "ImageDecoder",
		efi.GUID{0x58, 0x0d, 0x74, 0xfc, 0xba, 0x59, 0x9b, 0x42, 0x99, 0xef, 0x62, 0x70, 0x51, 0x73, 0x7b, 0x78}: "AsusImageDecoder",
		efi.GUID{0x58, 0x0d, 0xdb, 0xe9, 0x8d, 0xd4, 0xf6, 0x47, 0x9c, 0x6e, 0x6f, 0x40, 0xe8, 0x6c, 0x7b, 0x41}: "PeiTpmInitializedPpiGuid",
		efi.GUID{0x58, 0x15, 0x34, 0x99, 0xa1, 0x39, 0xb9, 0x42, 0xa1, 0xb2, 0x1c, 0xa4, 0xf1, 0x72, 0x0f, 0x8e}: "AmiCommunicationPei",
		efi.GUID{0x58, 0x1b, 0x7a, 0x44, 0x3e, 0x8f, 0x58, 0x46, 0xab, 0xaa, 0x9e, 0x7b, 0x22, 0x80, 0xb9, 0x0a}: "NvramSmm",
		efi.GUID{0x58, 0x1c, 0xe8, 0x06, 0xd7, 0x4a, 0xbc, 0x44, 0x83, 0x90, 0xf1, 0x02, 0x65, 0xf7, 0x24, 0x80}: "PcdPpiGuid",
		efi.GUID{0x58, 0x29, 0x4e, 0x95, 0xb2, 0xeb, 0x87, 0x46, 0xb9, 0x8f, 0x84, 0x4d, 0xf4, 0xfa, 0xc6, 0x3a}: "CompalSsidSvidDxeProgram",
		efi.GUID{0x58, 0x2f, 0xab, 0x94, 0x38, 0x14, 0xf1, 0x4e, 0x91, 0x52, 0x18, 0x94, 0x1a, 0x3a, 0x0e, 0x68}: "EfiSecurity2ArchProtocolGuid",
		efi.GUID{0x58, 0x31, 0xe8, 0xc4, 0x62, 0xde, 0x33, 0x4a, 0xa3, 0x81, 0x75, 0xa4, 0xc0, 0xee, 0xd5, 0x68}: "PhysicalPresence",
		efi.GUID{0x58, 0x38, 0x2c, 0xf5, 0xf8, 0x5e, 0x41, 0x4d, 0x83, 0x4e, 0xc3, 0x9e, 0xef, 0x8a, 0x45, 0xa3}: "EfiSerialGpioProtocol",
		efi.GUID{0x58, 0x46, 0x93, 0xcb, 0xa4, 0xad, 0xe5, 0x40, 0x98, 0xce, 0x9b, 0x47, 0x6f, 0xa1, 0x08, 0xb4}: "DellPcdUpdateDxe",
		efi.GUID{0x58, 0x4b, 0x1a, 0x89, 0x0a, 0x44, 0x92, 0x47, 0xbe, 0xc5, 0x17, 0x3e, 0x2e, 0x3e, 0x67, 0x97}: "PostMessageDxe",
		efi.GUID{0x58, 0x4f, 0x35, 0x57, 0x10, 0xc3, 0x84, 0x48, 0xab, 0x1c, 0xd7, 0x70, 0x51, 0x0b, 0xa7, 0xd6}: "FanTuningPei",
		efi.GUID{0x58, 0x5c, 0x0e, 0x6f, 0xc2, 0xe5, 0xa9, 0x42, 0x92, 0x5c, 0xa0, 0xcf, 0x93, 0xa8, 0x62, 0x91}: "NvmeShutdownNotificationSmm",
		efi.GUID{0x58, 0x65, 0x66, 0x3a, 0xe3, 0x43, 0x25, 0x4d, 0x91, 0x69, 0xdb, 0x81, 0xf5, 0xdb, 0x42, 0xe1}: "PKeyFileX509Guid",
		efi.GUID{0x58, 0x66, 0x80, 0x30, 0x9c, 0x1e, 0x13, 0x4a, 0x97, 0x1e, 0x70, 0x7a, 0x69, 0xe9, 0x58, 0xc8}: "Int15MicrocodeSmm",
		efi.GUID{0x58, 0x69, 0xb3, 0xc8, 0xa7, 0x00, 0x78, 0x46, 0x83, 0xef, 0xe5, 0x52, 0x5a, 0x8c, 0xe4, 0xa4}: "OemFixedBootOrderIpmi",
		efi.GUID{0x58, 0x70, 0x69, 0xe3, 0x3e, 0xb7, 0x1a, 0x42, 0xbe, 0x3d, 0xc0, 0x80, 0x08, 0xd8, 0xa0, 0x05}: "SmbiosDataUpdateDxeArcherCityModular",
		efi.GUID{0x58, 0x74, 0xdc, 0xd2, 0xc1, 0xe6, 0x8e, 0x4c, 0xa3, 0x2b, 0x54, 0x52, 0x69, 0xdc, 0x63, 0x61}: "OemPeiSetAcLossAuto",
		efi.GUID{0x58, 0x89, 0x83, 0x53, 0xa0, 0x1c, 0x49, 0x46, 0xb9, 0x3c, 0x33, 0xf5, 0x1e, 0xe0, 0x85, 0xa7}: "EcRotSupportShowInSetup",
		efi.GUID{0x58, 0x8d, 0x39, 0xef, 0xfd, 0x9d, 0x03, 0x41, 0xbf, 0x94, 0x78, 0xc6, 0xf4, 0xfe, 0x71, 0x2f}: "EfiPeiResetPpiGuid",
		efi.GUID{0x58, 0x99, 0xd1, 0x7b, 0x71, 0xcf, 0xdd, 0x48, 0x95, 0x3c, 0x64, 0x05, 0x05, 0xc5, 0x2d, 0x4a}: "DellMultiFuncDevDxe",
		efi.GUID{0x58, 0x99, 0xd4, 0x4f, 0x9d, 0xf2, 0x19, 0x40, 0x80, 0xf6, 0x07, 0x00, 0x69, 0x9d, 0x95, 0x40}: "OemWwanSmm",
		efi.GUID{0x58, 0x9c, 0x0f, 0x52, 0x9d, 0x9f, 0xc6, 0x48, 0xa0, 0xa0, 0xd9, 0xfe, 0x6d, 0x8f, 0xde, 0x77}: "LenovoTdtAm",
		efi.GUID{0x58, 0xa2, 0x45, 0xbd, 0xbd, 0xc7, 0xf0, 0x4b, 0xb2, 0x54, 0xd0, 0xd4, 0x5e, 0x02, 0xf8, 0x77}: "DellCmosManagerDxeSrc",
		efi.GUID{0x58, 0xa2, 0xb0, 0x05, 0x8a, 0x30, 0x5e, 0x44, 0xb6, 0x69, 0xa8, 0x54, 0x54, 0x9d, 0x22, 0x5c}: "SmmCpuProtocol",
		efi.GUID{0x58, 0xad, 0xdc, 0xbf, 0x30, 0x36, 0x00, 0x43, 0xa2, 0xc6, 0x0d, 0xb4, 0x6c, 0xec, 0xa4, 0x82}: "OemGlobalNvsDxe",
		efi.GUID{0x58, 0xad, 0xdc, 0xbf, 0x30, 0x36, 0x01, 0x43, 0xa2, 0xc6, 0x0d, 0xb4, 0x6c, 0xec, 0xa4, 0x82}: "OemGlobalNvsSmm",
		efi.GUID{0x58, 0xae, 0xdc, 0xef, 0xe2, 0x13, 0xec, 0x4b, 0x9a, 0xed, 0x99, 0x2c, 0x8d, 0xcb, 0xdd, 0x9e}: "FjTriggerMebxDxe",
		efi.GUID{0x58, 0xb3, 0x17, 0xf6, 0xcf, 0x12, 0x4a, 0x41, 0xa0, 0x69, 0x60, 0x67, 0x7b, 0xda, 0x13, 0xb3}: "DxeIchPlatformPolicyProtocolGuid",
		efi.GUID{0x58, 0xb3, 0x17, 0xf6, 0xcf, 0x12, 0x4a, 0x41, 0xa0, 0x69, 0x60, 0x67, 0x7b, 0xda, 0x13, 0xb4}: "UsbPolicyGuid",
		efi.GUID{0x58, 0xb7, 0x4f, 0xc5, 0xc3, 0x5d, 0x68, 0x40, 0x89, 0x3a, 0x4e, 0x67, 0xf7, 0xcc, 0xf5, 0xd4}: "FjDmiFJJSpecific",
		efi.GUID{0x58, 0xb7, 0xc4, 0xa3, 0x8c, 0xfa, 0x75, 0x4a, 0x91, 0xe2, 0x80, 0x7e, 0xc3, 0xb3, 0xda, 0x34}: "DeepSleepDxe",
		efi.GUID{0x58, 0xb7, 0xec, 0x95, 0x7e, 0x62, 0x2e, 0x4a, 0xb7, 0xb8, 0xdc, 0x86, 0x3e, 0xfe, 0x34, 0x25}: "AmiDeviceGuardApi",
		efi.GUID{0x58, 0xbb, 0x55, 0x07, 0x62, 0x33, 0x3c, 0x4e, 0x8d, 0x4c, 0x8e, 0x0f, 0x28, 0x36, 0x6e, 0x21}: "EcGbeSmm",
		efi.GUID{0x58, 0xbc, 0x6e, 0x1e, 0xe2, 0x55, 0xe4, 0x4f, 0xa3, 0x96, 0xaa, 0x2c, 0x22, 0x8e, 0xe7, 0xe2}: "PhPlatformSiSmmCodeCheckSmm",
		efi.GUID{0x58, 0xbc, 0x8c, 0x8e, 0x4c, 0x83, 0xe3, 0x41, 0xb8, 0xca, 0xf0, 0x0c, 0xcf, 0x5a, 0x71, 0x7c}: "IccOverclockingProtocol",
		efi.GUID{0x58, 0xc1, 0x7c, 0x23, 0x32, 0x60, 0x32, 0x48, 0xb0, 0xba, 0x1f, 0x83, 0xc0, 0xfc, 0xa6, 0x09}: "CoreHotKeyProtocol",
		efi.GUID{0x58, 0xc2, 0x52, 0xe2, 0x39, 0xc8, 0xcf, 0x48, 0xa8, 0x5c, 0xe8, 0xf4, 0xc3, 0x23, 0x5b, 0xda}: "OemApVariable",
		efi.GUID{0x58, 0xc4, 0x9e, 0x33, 0x6a, 0x9b, 0xec, 0x4c, 0xa4, 0x7a, 0x71, 0x28, 0x73, 0x65, 0x32, 0x99}: "StdFlashLibNull",
		efi.GUID{0x58, 0xc5, 0x07, 0x79, 0x57, 0x4c, 0x0e, 0x48, 0x94, 0x39, 0x7f, 0x66, 0x84, 0x85, 0x29, 0x20}: "DellMeLocalFwUpdateDxe_ME130",
		efi.GUID{0x58, 0xc9, 0x33, 0x1c, 0xa4, 0xfe, 0x5f, 0x43, 0x93, 0xef, 0x0a, 0x9c, 0x14, 0xae, 0x87, 0xe4}: "DellMfgAuthentication",
		efi.GUID{0x58, 0xda, 0x76, 0x8f, 0x99, 0x1f, 0x75, 0x42, 0xa4, 0xec, 0x47, 0x56, 0x51, 0x5b, 0x1c, 0xe8}: "EfiBluetoothLeConfigProtocolGuid",
		efi.GUID{0x58, 0xe5, 0xf2, 0xe0, 0x3b, 0x99, 0xa9, 0x43, 0x88, 0xc8, 0xd5, 0x30, 0x8b, 0xce, 0xbb, 0xbe}: "EcStorageAgentSmm",
		efi.GUID{0x58, 0xea, 0xad, 0x5a, 0x8c, 0x00, 0x12, 0x4d, 0xaa, 0x0d, 0xc8, 0x58, 0x89, 0xaa, 0xa7, 0x3b}: "SbSetPcdPei",
		efi.GUID{0x58, 0xee, 0x35, 0x3a, 0x86, 0x82, 0x00, 0x4f, 0x9a, 0x5b, 0x1b, 0x6a, 0xb7, 0x68, 0x08, 0x15}: "amiFVhoblistguid",
		efi.GUID{0x58, 0xf1, 0xac, 0x25, 0x61, 0xdd, 0x64, 0x4e, 0x9a, 0x49, 0x55, 0x85, 0x1e, 0x9a, 0x26, 0xc7}: "CsmBlockIo",
		efi.GUID{0x59, 0x02, 0xfb, 0x34, 0x92, 0xbd, 0xcf, 0x41, 0x81, 0x1b, 0x17, 0xc9, 0xad, 0x60, 0x51, 0x8a}: "RemoteWakeUpPei",
		efi.GUID{0x59, 0x18, 0xa2, 0xe9, 0x2a, 0x00, 0x51, 0x47, 0x80, 0x31, 0xa0, 0xb5, 0xd1, 0x3e, 0xf7, 0x22}: "UsbPxeUndiDriver1",
		efi.GUID{0x59, 0x28, 0x6d, 0x45, 0x4b, 0xa8, 0x47, 0x4e, 0xa2, 0xee, 0x32, 0x76, 0xd8, 0x86, 0x99, 0x7d}: "EfiSmmSxDispatch2ProtocolGuid",
		efi.GUID{0x59, 0x2c, 0x50, 0xb8, 0x68, 0xb2, 0xe8, 0x4b, 0xad, 0xd6, 0x60, 0x1a, 0xfe, 0xaa, 0x4b, 0xc9}: "SpiKeyboard",
		efi.GUID{0x59, 0x37, 0x6c, 0x81, 0xe4, 0xdf, 0x44, 0x46, 0xaa, 0x17, 0x1f, 0x09, 0x0e, 0x02, 0xa5, 0x99}: "TiOnlyPei",
		efi.GUID{0x59, 0x4f, 0x94, 0xc3, 0x29, 0x40, 0xeb, 0xcc, 0xae, 0x0d, 0xd4, 0xa6, 0xb4, 0x79, 0x92, 0x4f}: "UsbPortConfigDxe",
		efi.GUID{0x59, 0x55, 0xf8, 0x27, 0x9f, 0x35, 0x25, 0x4b, 0x9b, 0x73, 0x3e, 0xe5, 0xde, 0x39, 0x91, 0x21}: "DellSmbusHcSmm",
		efi.GUID{0x59, 0x65, 0x22, 0x85, 0xef, 0x0d, 0xd8, 0x48, 0xa8, 0xc9, 0xb7, 0x46, 0xd6, 0xa4, 0xdf, 0x01}: "AmiMemoryErrorReportPpi",
		efi.GUID{0x59, 0x6a, 0x62, 0x3f, 0xd2, 0x87, 0xcf, 0x4f, 0xb5, 0xde, 0x9d, 0x12, 0xa8, 0xb2, 0xaf, 0x88}: "FeatureByte",
		efi.GUID{0x59, 0x6b, 0x0c, 0xa6, 0x59, 0xe4, 0x5d, 0x42, 0x9c, 0x69, 0x0b, 0xcc, 0x9c, 0xb2, 0x7d, 0x81}: "EfiGetPcdInfoPpiGuid",
		efi.GUID{0x59, 0x6d, 0x69, 0x97, 0x30, 0x74, 0xd9, 0x4c, 0xbc, 0x28, 0x19, 0xc7, 0x69, 0xfb, 0x04, 0xfd}: "DellHotSosPei",
		efi.GUID{0x59, 0x73, 0x74, 0x08, 0x88, 0xba, 0xf8, 0x42, 0x9d, 0x25, 0xf7, 0x1d, 0x93, 0xb6, 0xcd, 0x26}: "EcFlashSmm",
		efi.GUID{0x59, 0x7b, 0x3b, 0x0c, 0xe5, 0x28, 0x99, 0x4c, 0x85, 0xe5, 0xd0, 0x11, 0x6d, 0xbf, 0xaa, 0xf2}: "IsctWakeReason",
		efi.GUID{0x59, 0x80, 0xb9, 0x09, 0x74, 0x2d, 0xc5, 0x43, 0x97, 0x09, 0xad, 0x0a, 0x00, 0x51, 0x86, 0x7d}: "DellAhciDxe",
		efi.GUID{0x59, 0x83, 0xfc, 0xb7, 0x75, 0x51, 0x7c, 0x45, 0xb5, 0x91, 0x8a, 0xe8, 0xfd, 0xc4, 0x76, 0x05}: "UsbOcUpdateDxeEVB",
		efi.GUID{0x59, 0x92, 0xf1, 0x4d, 0x71, 0xdc, 0x46, 0x4d, 0xbe, 0xf1, 0x35, 0x7b, 0xb5, 0x78, 0xc4, 0x18}: "EfiPs2PolicyProtocolGuid",
		efi.GUID{0x59, 0x97, 0x59, 0xca, 0xa7, 0x90, 0xe4, 0x4f, 0xbc, 0x8b, 0x4b, 0x71, 0xc3, 0x50, 0xdc, 0xac}: "LibGen",
		efi.GUID{0x59, 0x97, 0xa7, 0x69, 0x73, 0x13, 0x67, 0x43, 0xa6, 0xc4, 0xc7, 0xf5, 0x9e, 0xfd, 0x98, 0x6e}: "FspReservedMemoryResourceHobGuid",
		efi.GUID{0x59, 0x98, 0x80, 0x63, 0x29, 0xf0, 0xc3, 0x41, 0x9f, 0x34, 0xee, 0xeb, 0x9e, 0xa7, 0x87, 0xa5}: "IioInit",
		efi.GUID{0x59, 0xae, 0x9e, 0x51, 0xd0, 0xc1, 0x1c, 0x4a, 0x8b, 0x21, 0xf0, 0x6b, 0x62, 0x0d, 0xad, 0x21}: "RedfishPlatformDxe",
		efi.GUID{0x59, 0xba, 0x17, 0xa0, 0xad, 0xdc, 0x3b, 0x47, 0xbb, 0xb3, 0x29, 0x4e, 0x9a, 0xf2, 0x0d, 0x34}: "OemPeiHook",
		efi.GUID{0x59, 0xbc, 0x28, 0xde, 0x28, 0x62, 0xbd, 0x41, 0xbd, 0xf6, 0xa3, 0xb9, 0xad, 0xb5, 0x8d, 0xa1}: "FramerworkEfiFirmwareVolumeBlockProtocolGuid",
		efi.GUID{0x59, 0xbc, 0xd8, 0x2e, 0x71, 0x06, 0xed, 0x49, 0xa8, 0x6f, 0x1b, 0x67, 0x60, 0xb3, 0x80, 0xa8}: "SmuV13Pei",
		efi.GUID{0x59, 0xc0, 0xc4, 0x51, 0xf0, 0x67, 0x3c, 0x4e, 0x9a, 0x55, 0xff, 0x42, 0xa8, 0x29, 0x1c, 0x8c}: "PeiSmbusLibSmbusPpi",
		efi.GUID{0x59, 0xc2, 0xf1, 0xf0, 0x3a, 0xfd, 0x6b, 0x44, 0xb2, 0xf2, 0x04, 0x93, 0x34, 0xd1, 0xbd, 0x23}: "AmdSocAm4CznPei",
		efi.GUID{0x59, 0xc4, 0x63, 0xff, 0x00, 0x34, 0xf9, 0x40, 0x85, 0xff, 0x54, 0xad, 0x78, 0x55, 0xf5, 0xb7}: "DellFmpLoader",
		efi.GUID{0x59, 0xcc, 0xbc, 0x28, 0x4d, 0x7f, 0xe3, 0x46, 0xbf, 0xe3, 0x84, 0x65, 0xcb, 0x52, 0x23, 0xa8}: "HpRpsuDetectDxe",
		efi.GUID{0x59, 0xd1, 0xa4, 0x70, 0x01, 0x1f, 0x03, 0x42, 0xa5, 0x98, 0x7c, 0x27, 0x94, 0x15, 0x1c, 0xe6}: "EfiOsBootOptionNames",
		efi.GUID{0x59, 0xd6, 0xe8, 0x73, 0xa2, 0xd2, 0x20, 0x47, 0x83, 0x16, 0xb9, 0xba, 0xd2, 0x1e, 0x5a, 0x29}: "CbsBaseDxeRN",
		efi.GUID{0x59, 0xd9, 0x23, 0xba, 0xcb, 0xef, 0x40, 0x43, 0xb0, 0xa9, 0xb3, 0x3f, 0x9c, 0xf0, 0x5c, 0xb8}: "PhPlatformPei",
		efi.GUID{0x59, 0xe2, 0xcc, 0xfc, 0xe1, 0x07, 0x7a, 0x41, 0xa7, 0x55, 0xe0, 0xf2, 0xcf, 0x39, 0x29, 0x5e}: "CpuInitDxe",
		efi.GUID{0x59, 0xe7, 0xd6, 0x20, 0x4a, 0x4c, 0xc0, 0x40, 0x95, 0x33, 0x2b, 0xf0, 0x06, 0x68, 0x50, 0xfd}: "EfiQuiesceProtocol",
		efi.GUID{0x59, 0xed, 0x7f, 0xd2, 0xb4, 0xab, 0xed, 0x4f, 0xbe, 0xad, 0x2a, 0x87, 0x8c, 0x7e, 0x4a, 0x7e}: "SmbiosMeasurementDxe",
		efi.GUID{0x59, 0xfc, 0xd0, 0x2a, 0x14, 0x23, 0xf3, 0x4b, 0x86, 0x33, 0x13, 0xfa, 0x22, 0xa6, 0x24, 0xa0}: "PlatformPei",
		efi.GUID{0x5a, 0x00, 0x73, 0xa6, 0xf6, 0x69, 0x97, 0x45, 0x8a, 0xf9, 0x7a, 0xac, 0xa0, 0x03, 0x92, 0x96}: "Int15BootDisplay",
		efi.GUID{0x5a, 0x09, 0x92, 0x37, 0x09, 0xe3, 0x1e, 0x4c, 0xaa, 0x01, 0x85, 0xf5, 0x65, 0x5a, 0x17, 0xf1}: "EfiSmmAccessProtocolGuid",
		efi.GUID{0x5a, 0x0f, 0x0e, 0x87, 0x81, 0x19, 0xf6, 0x45, 0xae, 0x26, 0x03, 0x91, 0x42, 0x5c, 0xc4, 0x6f}: "CpuCsrAccessSMM",
		efi.GUID{0x5a, 0x14, 0xdf, 0x19, 0xd4, 0xb1, 0x3f, 0x45, 0x85, 0x07, 0x38, 0x81, 0x66, 0x76, 0xd7, 0xf6}: "AtaBusDxe",
		efi.GUID{0x5a, 0x1c, 0x5d, 0x80, 0x12, 0xef, 0x0a, 0x49, 0x9e, 0x7b, 0x9f, 0x4a, 0xa2, 0xf9, 0x7e, 0x73}: "AmiPspNvramSmm",
		efi.GUID{0x5a, 0x1c, 0xcd, 0x9e, 0xf2, 0x90, 0x1b, 0x47, 0x84, 0x19, 0x1d, 0xb6, 0x2b, 0xd9, 0xcc, 0x27}: "FjImonCalibration",
		efi.GUID{0x5a, 0x1e, 0x9e, 0x5e, 0xbc, 0xd6, 0xc6, 0x4a, 0xa1, 0x61, 0x85, 0x4b, 0x7b, 0xb5, 0xe1, 0x0a}: "Realtek8153Lan",
		efi.GUID{0x5a, 0x20, 0x53, 0xc1, 0x98, 0xe8, 0x24, 0x4c, 0x86, 0x89, 0xa4, 0xb4, 0xbc, 0xc5, 0xc8, 0xa2}: "PeiCachePpiGuid",
		efi.GUID{0x5a, 0x31, 0x8c, 0x57, 0xcf, 0x68, 0x81, 0x4e, 0xb5, 0xc6, 0x22, 0xdb, 0x40, 0xd0, 0x10, 0xbc}: "EfiI2cMasterProtocolGuid",
		efi.GUID{0x5a, 0x34, 0xdd, 0x51, 0xfa, 0xb3, 0x19, 0x41, 0xb5, 0xd0, 0xc5, 0xfa, 0xd7, 0xf3, 0x7b, 0x31}: "DualBiosPei",
		efi.GUID{0x5a, 0x35, 0xad, 0xa3, 0xd0, 0x13, 0xcf, 0x4d, 0x9c, 0x21, 0x3d, 0x2c, 0x5f, 0x1b, 0xad, 0x5f}: "FboGroupForm",
		efi.GUID{0x5a, 0x3a, 0x5c, 0x22, 0x02, 0x59, 0x07, 0x43, 0x96, 0x8a, 0xaf, 0x8d, 0xef, 0xfe, 0x61, 0xe8}: "UsbPwrCtrlSmm",
		efi.GUID{0x5a, 0x3c, 0xcd, 0x9e, 0xf2, 0x90, 0x1b, 0x47, 0x84, 0x19, 0x1d, 0xb6, 0x2b, 0xd9, 0xcc, 0x27}: "SmscUSX2064",
		efi.GUID{0x5a, 0x3c, 0xcd, 0x9e, 0xf2, 0x90, 0x1b, 0x47, 0x84, 0x19, 0x1d, 0xb6, 0x3b, 0xd9, 0xcc, 0x27}: "FjSmbusProgram",
		efi.GUID{0x5a, 0x41, 0x0e, 0x71, 0x5b, 0x6a, 0xea, 0x4a, 0x97, 0x3f, 0x6d, 0xd3, 0xf9, 0xcb, 0x00, 0x56}: "PLEDPEI",
		efi.GUID{0x5a, 0x4e, 0xd7, 0xf2, 0x85, 0x89, 0xdb, 0x11, 0x97, 0x05, 0x00, 0x40, 0xd0, 0x2b, 0x18, 0x35}: "EfiUnixCpuSpeed",
		efi.GUID{0x5a, 0x53, 0xab, 0x77, 0xfc, 0x45, 0x4b, 0x62, 0x55, 0x60, 0xf7, 0xb2, 0x81, 0xd1, 0xf9, 0x6e}: "EfiVirtualDiskGuid",
		efi.GUID{0x5a, 0x55, 0x5f, 0xd2, 0xef, 0x30, 0xee, 0x49, 0x8f, 0xb5, 0xc7, 0x6b, 0x58, 0x17, 0xcc, 0x2a}: "AppleBootUI",
		efi.GUID{0x5a, 0x55, 0xd5, 0x5b, 0x5f, 0x83, 0x1a, 0x4f, 0xb3, 0xc2, 0x77, 0x77, 0xe6, 0xdc, 0xbf, 0xff}: "AMTConfigurationDxe",
		efi.GUID{0x5a, 0x57, 0x52, 0x55, 0x00, 0x7e, 0x61, 0x4d, 0xa3, 0xa4, 0xf7, 0x54, 0x73, 0x51, 0xb4, 0x9e}: "SmmBaseRuntime",
		efi.GUID{0x5a, 0x5c, 0x0e, 0xff, 0x43, 0xfa, 0x93, 0x45, 0xbe, 0x3f, 0x9d, 0x90, 0x2e, 0x03, 0x59, 0xa6}: "FchPromontoryPlusGpioDxe",
		efi.GUID{0x5a, 0x5e, 0x3c, 0x45, 0x2d, 0x48, 0xf0, 0x43, 0x87, 0xc9, 0x59, 0x41, 0xf3, 0xa3, 0x8a, 0xc2}: "EfiKmsFormatSha1160Guid",
		efi.GUID{0x5a, 0x5f, 0x6e, 0x29, 0x3e, 0x3f, 0x54, 0x4b, 0x83, 0x95, 0x98, 0xeb, 0xcc, 0x94, 0x07, 0xa6}: "AmiUsbCcid",
		efi.GUID{0x5a, 0x63, 0xbd, 0x6b, 0x3d, 0xb1, 0x06, 0x4a, 0x9f, 0x8f, 0x1f, 0xa0, 0x86, 0xd4, 0xec, 0x0f}: "EcMudSmm",
		efi.GUID{0x5a, 0x68, 0xe1, 0xe1, 0xbc, 0x7a, 0x0f, 0x45, 0x88, 0x2a, 0x4e, 0x69, 0x2c, 0xc6, 0xaf, 0x7e}: "FpgaConfigDataDxeNeonCityFPGA",
		efi.GUID{0x5a, 0x72, 0x52, 0xe3, 0x4a, 0xb8, 0xbc, 0x4e, 0xa9, 0x94, 0x22, 0x8e, 0x19, 0x22, 0x48, 0x16}: "SmcBMCSMI",
		efi.GUID{0x5a, 0x74, 0x83, 0x60, 0xfe, 0x36, 0x37, 0x4c, 0x85, 0x9a, 0x55, 0xb7, 0x73, 0xae, 0xc2, 0xd3}: "FchBixbyPei",
		efi.GUID{0x5a, 0x78, 0xc4, 0x63, 0x34, 0xca, 0x12, 0x40, 0xa3, 0xc8, 0x0b, 0x6a, 0x32, 0x4f, 0x55, 0x46}: "EfiRngAlgorithmX9313DesGuid",
		efi.GUID{0x5a, 0x85, 0x41, 0x83, 0x72, 0xf2, 0xfe, 0x4f, 0xbb, 0xee, 0xda, 0xea, 0xc5, 0xce, 0xdd, 0xc7}: "DellStorageAgentSmmRegister",
		efi.GUID{0x5a, 0x87, 0xd0, 0xe5, 0x47, 0xf6, 0x16, 0x4e, 0xbe, 0x4d, 0x95, 0x02, 0x40, 0x29, 0xcc, 0x44}: "MdesStatusCodeProtocol",
		efi.GUID{0x5a, 0x8a, 0xe5, 0x6c, 0x0a, 0x03, 0x59, 0x4b, 0xa6, 0x88, 0xd1, 0xd3, 0x7d, 0x7e, 0xa9, 0x85}: "TpmPlatformMeasurement",
		efi.GUID{0x5a, 0x94, 0x10, 0xff, 0xa3, 0x1e, 0xd8, 0x4b, 0xb7, 0x85, 0xb5, 0x25, 0xc5, 0xe1, 0x4e, 0xbb}: "NonAmtNetWorkController",
		efi.GUID{0x5a, 0x95, 0x87, 0x8f, 0xec, 0x85, 0x26, 0x48, 0xb4, 0xfe, 0x17, 0x3b, 0x91, 0x4a, 0xb3, 0x83}: "XhciSmm",
		efi.GUID{0x5a, 0x9b, 0xb0, 0x40, 0xef, 0xf0, 0x27, 0x46, 0x93, 0xd5, 0x27, 0xf0, 0x4b, 0x75, 0x4d, 0x05}: "AmtReadyToBootGuid",
		efi.GUID{0x5a, 0x9e, 0xe2, 0x8d, 0xba, 0xba, 0x96, 0x46, 0xb0, 0x7d, 0x33, 0xe8, 0x3d, 0x5a, 0xd8, 0x11}: "CbsBaseDxe",
		efi.GUID{0x5a, 0xa1, 0x4b, 0x11, 0x89, 0x61, 0x0d, 0x18, 0xbf, 0xc0, 0x20, 0x53, 0xb3, 0x48, 0x09, 0x49}: "EfiBoardSelectGuid",
		efi.GUID{0x5a, 0xae, 0x29, 0x52, 0x8e, 0xab, 0x93, 0x46, 0xa8, 0xfd, 0xb7, 0xd7, 0xcb, 0xce, 0x69, 0x4c}: "PTSataController",
		efi.GUID{0x5a, 0xb3, 0x69, 0xb4, 0x34, 0x09, 0x39, 0x40, 0x9a, 0x36, 0x73, 0x82, 0xc4, 0x28, 0xf8, 0x92}: "FjVariableRt",
		efi.GUID{0x5a, 0xb9, 0x9d, 0x0a, 0x4a, 0x0e, 0x16, 0x48, 0x86, 0x39, 0x5b, 0xe4, 0xff, 0xa9, 0xc9, 0x09}: "AmdFabricPhxSmm",
		efi.GUID{0x5a, 0xc0, 0xf5, 0xb9, 0xc4, 0xc8, 0x1c, 0x4d, 0x96, 0x6f, 0x19, 0x77, 0xef, 0x2c, 0xa5, 0x4d}: "AmdPlatformRasRnDxe",
		efi.GUID{0x5a, 0xcc, 0xbc, 0x28, 0x4e, 0x7f, 0xe4, 0x46, 0xbf, 0xe4, 0x84, 0x65, 0xcb, 0x52, 0x34, 0xb9}: "HpRpsuDetectPei",
		efi.GUID{0x5a, 0xcf, 0xf6, 0xc6, 0x85, 0xf0, 0x1e, 0x40, 0x84, 0x02, 0x00, 0x13, 0x4b, 0x66, 0x87, 0x03}: "FjFextPei",
		efi.GUID{0x5a, 0xd2, 0x5c, 0xdf, 0x55, 0x8e, 0xba, 0x46, 0x8c, 0xda, 0xbc, 0x7d, 0xb7, 0xbf, 0x9c, 0x64}: "MdesStatusCodeDxe",
		efi.GUID{0x5a, 0xde, 0x04, 0x40, 0xa5, 0x09, 0x0c, 0x4f, 0x94, 0xd7, 0x82, 0x32, 0x2e, 0x09, 0x6a, 0xa7}: "DxeCapsuleLibNull",
		efi.GUID{0x5a, 0xef, 0x8d, 0x15, 0x56, 0xf6, 0x9c, 0x41, 0xb0, 0x27, 0x7a, 0x31, 0x92, 0xc0, 0x79, 0xd2}: "ShellVariableGuid",
		efi.GUID{0x5a, 0xef, 0xce, 0x62, 0x7c, 0x1d, 0x43, 0x49, 0x9b, 0x3a, 0x95, 0xe2, 0x49, 0x4c, 0x89, 0x90}: "Emul6064KbdInputProtocolGuid",
		efi.GUID{0x5a, 0xf2, 0x6b, 0x28, 0xc3, 0xc2, 0x8c, 0x40, 0xb3, 0xb4, 0x25, 0xe6, 0x75, 0x8b, 0x73, 0x17}: "EfiTpmDeviceInstanceTpm20DtpmGuid",
		efi.GUID{0x5a, 0xf5, 0x23, 0xeb, 0x63, 0x78, 0xc2, 0x4a, 0x8d, 0x3d, 0x95, 0x65, 0x35, 0xde, 0x03, 0x75}: "EfiIncompatiblePciDeviceSupportProtocolGuid",
		efi.GUID{0x5b, 0x01, 0x57, 0x86, 0x43, 0xea, 0x0d, 0x44, 0x94, 0x9a, 0xaf, 0x3b, 0xe3, 0x65, 0xc0, 0xfc}: "IoMmuDxe",
		efi.GUID{0x5b, 0x02, 0x35, 0xf2, 0xa0, 0x85, 0xd8, 0x4a, 0x83, 0x9e, 0xa7, 0xfe, 0xdf, 0xd0, 0xcd, 0xe3}: "WatchRobotPei",
		efi.GUID{0x5b, 0x02, 0x35, 0xf2, 0xa0, 0x85, 0xd8, 0x4a, 0x83, 0x9e, 0xa7, 0xfe, 0xdf, 0xd0, 0xcd, 0xe4}: "PowerOnRobotPei",
		efi.GUID{0x5b, 0x02, 0xf1, 0x93, 0xd4, 0xb6, 0x2f, 0x4f, 0xa4, 0xa9, 0xa4, 0xab, 0xa0, 0xcf, 0x60, 0x4f}: "aDefaultDxe",
		efi.GUID{0x5b, 0x0d, 0x1b, 0x5f, 0x44, 0xdb, 0x81, 0x4b, 0xa6, 0x9d, 0x55, 0x3c, 0x59, 0x1a, 0xf0, 0x92}: "OCMR_DXE",
		efi.GUID{0x5b, 0x11, 0xfe, 0xaf, 0x89, 0x85, 0x6d, 0x45, 0xba, 0xb5, 0x8f, 0x2e, 0xda, 0x53, 0xae, 0xb7}: "ArmPlatformUpdateFdtEventGuid",
		efi.GUID{0x5b, 0x14, 0x7d, 0x12, 0x0d, 0x41, 0xd7, 0x4d, 0xbf, 0xaf, 0x15, 0xa3, 0xd3, 0xb6, 0x0b, 0x94}: "SetupRepSetDxe",
		efi.GUID{0x5b, 0x15, 0x8b, 0x4d, 0x59, 0xc0, 0x8f, 0x4c, 0x89, 0x26, 0x06, 0xfd, 0x43, 0x31, 0xdb, 0x8a}: "GetPcdInfoPpiGuid",
		efi.GUID{0x5b, 0x1a, 0xca, 0x97, 0x60, 0xb7, 0x1f, 0x4d, 0xa5, 0x4b, 0xd1, 0x90, 0x92, 0x03, 0x2c, 0x90}: "DebuggerTerminalVar",
		efi.GUID{0x5b, 0x20, 0x17, 0x3d, 0x49, 0x4c, 0xe2, 0x47, 0x81, 0x57, 0x86, 0x4c, 0xd3, 0xd8, 0x0d, 0xbd}: "FatPei",
		efi.GUID{0x5b, 0x20, 0xea, 0xf4, 0x45, 0x73, 0x2c, 0x45, 0x9d, 0x62, 0x53, 0xba, 0x6f, 0x3b, 0x89, 0x10}: "FmpAuthenticationLibPkcs7",
		efi.GUID{0x5b, 0x2c, 0x60, 0x0a, 0xa0, 0x05, 0xc4, 0x40, 0x91, 0x81, 0xed, 0xcd, 0x89, 0x1d, 0x00, 0x01}: "OememDxeBin",
		efi.GUID{0x5b, 0x2c, 0x60, 0x0a, 0xa0, 0x05, 0xc4, 0x40, 0x91, 0x81, 0xed, 0xcd, 0x89, 0x1d, 0x00, 0x02}: "OememSmiBin",
		efi.GUID{0x5b, 0x2c, 0x60, 0x0a, 0xa0, 0x05, 0xc4, 0x40, 0x91, 0x81, 0xed, 0xcd, 0x89, 0x1d, 0x00, 0x03}: "OememPeiBin",
		efi.GUID{0x5b, 0x31, 0x21, 0x92, 0xbb, 0x30, 0xb5, 0x46, 0x81, 0x3e, 0x1b, 0x1b, 0xf4, 0x71, 0x2b, 0xd3}: "Defaults",
		efi.GUID{0x5b, 0x3f, 0xd5, 0xa4, 0x16, 0xc2, 0x8a, 0x4c, 0x83, 0xd9, 0x39, 0x0b, 0x4a, 0x65, 0x6c, 0xd4}: "AmdSocFp7PhxDxe",
		efi.GUID{0x5b, 0x40, 0x20, 0x39, 0x97, 0xc8, 0xda, 0x44, 0x88, 0xf3, 0x4c, 0x49, 0x8a, 0x6f, 0xf7, 0x36}: "EfiSmmIchnDispatchExProtocolGuid",
		efi.GUID{0x5b, 0x41, 0x6a, 0xac, 0x4b, 0x84, 0x88, 0x42, 0xb6, 0x18, 0xd1, 0x4d, 0x61, 0x44, 0xdf, 0xe1}: "FjGpioAbstractionReference",
		efi.GUID{0x5b, 0x41, 0xb2, 0xc1, 0x28, 0x3d, 0x66, 0x47, 0xaa, 0xe8, 0xef, 0xbe, 0xf3, 0xbf, 0x14, 0x51}: "AmdSocSp6StpDxe",
		efi.GUID{0x5b, 0x42, 0x6d, 0xd0, 0xd7, 0xee, 0x61, 0x03, 0xaa, 0xd2, 0x8c, 0x43, 0x14, 0x09, 0x57, 0x2d}: "BootGuardRecoveryHookPei",
		efi.GUID{0x5b, 0x49, 0x4b, 0xa8, 0xf4, 0x79, 0xab, 0x40, 0x8b, 0x60, 0x65, 0x3f, 0x69, 0xdc, 0xd9, 0x44}: "AmiHeciDeliverProtocolGuid",
		efi.GUID{0x5b, 0x4c, 0x84, 0x6b, 0x75, 0x6b, 0xca, 0x42, 0x8e, 0x8e, 0x1c, 0xb9, 0x44, 0x12, 0xb5, 0x9b}: "TcgPeiplatform",
		efi.GUID{0x5b, 0x51, 0x6a, 0xac, 0x4b, 0x84, 0x88, 0x43, 0xb6, 0x18, 0xd1, 0x4d, 0x61, 0x44, 0xdf, 0xe1}: "FjGpioAbstractionReference",
		efi.GUID{0x5b, 0x54, 0x8c, 0x0e, 0xee, 0xa2, 0x0d, 0x47, 0x8e, 0x26, 0xbd, 0xa1, 0xa1, 0x3c, 0x0a, 0xa3}: "LastEnumLangGuid",
		efi.GUID{0x5b, 0x55, 0x5a, 0xec, 0x84, 0x63, 0x00, 0x4c, 0x86, 0x25, 0x2c, 0x17, 0x68, 0xb9, 0x5b, 0x38}: "LenovoMeConOutReady",
		efi.GUID{0x5b, 0x61, 0x7e, 0x3f, 0x45, 0x0d, 0x80, 0x4f, 0x88, 0xdc, 0x26, 0xb2, 0x34, 0x95, 0x85, 0x60}: "FitDiagnosticsLoader",
		efi.GUID{0x5b, 0x62, 0x3f, 0x5d, 0x9d, 0xa3, 0x0c, 0x41, 0x8d, 0x6a, 0x9c, 0x31, 0x05, 0x64, 0x06, 0xde}: "ODMServiceDxe",
		efi.GUID{0x5b, 0x72, 0x80, 0x86, 0x11, 0x3e, 0xb7, 0x46, 0xab, 0x11, 0x2b, 0x30, 0x18, 0x03, 0x86, 0xba}: "DustFilterWmi",
		efi.GUID{0x5b, 0x75, 0xb0, 0x75, 0xd9, 0xb0, 0x05, 0x42, 0xbb, 0xf7, 0x63, 0x28, 0x9f, 0xfb, 0x80, 0x45}: "ProjectSmm",
		efi.GUID{0x5b, 0x75, 0xce, 0xa5, 0x21, 0xea, 0x84, 0x48, 0x88, 0xc7, 0xc7, 0xd4, 0xb1, 0xae, 0x28, 0x37}: "ProgressBar",
		efi.GUID{0x5b, 0x79, 0x9b, 0xdc, 0xd9, 0xff, 0xe8, 0x44, 0xa3, 0x6d, 0x66, 0x37, 0x85, 0x2e, 0xb6, 0xe4}: "S5MaxPowerSavingsDxe",
		efi.GUID{0x5b, 0x86, 0x72, 0x22, 0xf6, 0xeb, 0x47, 0x40, 0xb0, 0x08, 0x78, 0x89, 0x49, 0x7f, 0x53, 0xbd}: "SuperMDriverProtocol",
		efi.GUID{0x5b, 0x8f, 0xdb, 0x2a, 0xd4, 0xc7, 0x7e, 0x4e, 0xbe, 0x2a, 0x23, 0x63, 0x4d, 0xf6, 0x68, 0xa1}: "MouseDriver",
		efi.GUID{0x5b, 0x90, 0x51, 0x0d, 0x7e, 0xb7, 0x2a, 0x45, 0xa2, 0xc0, 0xec, 0xa0, 0xcc, 0x8d, 0x51, 0x4a}: "EdkiiNonDiscoverableDeviceProtocolGuid",
		efi.GUID{0x5b, 0x9c, 0x2e, 0xd9, 0x6c, 0xbb, 0xee, 0x46, 0xb8, 0xe7, 0x6b, 0x0b, 0x3d, 0x4b, 0x2b, 0xbc}: "AsusBiosRecoveryDxe",
		efi.GUID{0x5b, 0x9f, 0xaf, 0xe1, 0xde, 0x7c, 0x98, 0x4f, 0x91, 0xed, 0x5e, 0x67, 0x86, 0x82, 0x82, 0xb8}: "AsusBbVideo",
		efi.GUID{0x5b, 0xaa, 0xf3, 0x4f, 0x5c, 0x10, 0x09, 0x44, 0x87, 0xcd, 0x59, 0xc1, 0x5b, 0x7f, 0xc5, 0xd8}: "DellGlobalNvsDxe",
		efi.GUID{0x5b, 0xad, 0xd3, 0x1f, 0x65, 0x5e, 0x5e, 0x48, 0x9e, 0xbd, 0x95, 0xb1, 0x4d, 0x6e, 0xcc, 0xc6}: "SetupConfigUpdateDxeXPV",
		efi.GUID{0x5b, 0xad, 0xd4, 0x84, 0x02, 0x17, 0x2e, 0x44, 0xbd, 0xd8, 0x57, 0xe1, 0x19, 0x61, 0x11, 0xe5}: "SmmAccessDxe2",
		efi.GUID{0x5b, 0xbc, 0x71, 0x04, 0xbe, 0x64, 0xbf, 0x43, 0x8f, 0xa1, 0x43, 0x5a, 0xf1, 0x16, 0x13, 0x84}: "CrystalRidgeMeasurement",
		efi.GUID{0x5b, 0xc5, 0x3a, 0xd3, 0xa6, 0x82, 0x8d, 0x44, 0x8d, 0x14, 0xdf, 0xe0, 0x81, 0x4d, 0x07, 0x92}: "DellSetupRollbackDxeDriver",
		efi.GUID{0x5b, 0xcf, 0xbe, 0xd4, 0x0d, 0x19, 0xdb, 0x46, 0x92, 0xcc, 0x3f, 0x5d, 0x74, 0x90, 0x4d, 0xda}: "SmmAccessDxe",
		efi.GUID{0x5b, 0xdb, 0x31, 0xd2, 0x9c, 0x4a, 0x92, 0x40, 0xa8, 0xc5, 0x9c, 0xa0, 0xbc, 0x7d, 0x6a, 0xa6}: "IffsInfoProtocol",
		efi.GUID{0x5b, 0xdd, 0x97, 0x21, 0xd9, 0xb8, 0x97, 0x48, 0x92, 0xf1, 0x18, 0xd7, 0x59, 0x03, 0xe6, 0xaf}: "HpSleepStateSmm",
		efi.GUID{0x5b, 0xe2, 0x35, 0xec, 0x25, 0x04, 0x35, 0x44, 0xa3, 0x4c, 0x96, 0xd7, 0x57, 0x03, 0xb8, 0x93}: "FjEndofPeiGPIOOverride",
		efi.GUID{0x5b, 0xe8, 0xd6, 0xfc, 0x8e, 0x4a, 0x26, 0x43, 0xa7, 0xab, 0x8e, 0x67, 0x22, 0x9d, 0xa8, 0xe3}: "AmdSocFp7PhxPei",
		efi.GUID{0x5b, 0xeb, 0x44, 0xac, 0x6b, 0x28, 0x41, 0x4a, 0xbf, 0x5c, 0xb7, 0x5b, 0x82, 0x86, 0x45, 0x4b}: "PchAnOddDetect",
		efi.GUID{0x5b, 0xeb, 0x96, 0x90, 0xd1, 0x59, 0xf8, 0x49, 0x86, 0x6c, 0x78, 0xd2, 0x46, 0x31, 0xa6, 0xb4}: "EndOfDxeBeforePciEnumEventGroupGuid",
		efi.GUID{0x5b, 0xed, 0x6f, 0x6f, 0x41, 0x37, 0x4b, 0x4d, 0x8a, 0xc7, 0xc7, 0x49, 0x14, 0x87, 0x4a, 0x77}: "SbCrisis",
		efi.GUID{0x5b, 0xfc, 0x1d, 0x1f, 0x64, 0x5c, 0xa3, 0x49, 0xa1, 0x4a, 0xac, 0x2d, 0x31, 0x38, 0xb5, 0x95}: "FjIbvAbstractionDxe",
		efi.GUID{0x5b, 0xfd, 0x73, 0xfb, 0xb5, 0xfa, 0xe8, 0x4e, 0x8e, 0x32, 0x48, 0x03, 0x5c, 0x20, 0x71, 0xab}: "Smbios248",
		efi.GUID{0x5b, 0xfe, 0xcb, 0x90, 0x84, 0x97, 0xa4, 0x44, 0x8c, 0xb8, 0xc6, 0x40, 0xae, 0xb9, 0xea, 0x1c}: "DellSystemUsbPortConfigSmm",
		efi.GUID{0x5b, 0xfe, 0xe1, 0x8b, 0x4e, 0x0b, 0xb4, 0x4a, 0xb7, 0x7b, 0x5e, 0x03, 0x40, 0x3d, 0xf5, 0x01}: "DellUsbTouchPanelDxe",
		efi.GUID{0x5c, 0x02, 0x31, 0xba, 0xa8, 0x4a, 0xae, 0x4c, 0x98, 0xca, 0xba, 0x12, 0xc6, 0xbc, 0x7d, 0x78}: "SmmControl2Dxe",
		efi.GUID{0x5c, 0x0e, 0x62, 0xa9, 0xa1, 0x5f, 0xb7, 0x40, 0x8b, 0x21, 0x50, 0xb6, 0x32, 0xf8, 0x8f, 0x38}: "EfiLoader",
		efi.GUID{0x5c, 0x19, 0x09, 0x9d, 0x6d, 0xeb, 0x7a, 0x45, 0x90, 0x7f, 0xc0, 0xe0, 0xb3, 0xa9, 0x77, 0x57}: "AsusGlobalVariable",
		efi.GUID{0x5c, 0x1b, 0x70, 0xf5, 0x4b, 0x01, 0xef, 0x4d, 0xa9, 0x14, 0xa5, 0x37, 0xbb, 0x49, 0xa8, 0x9c}: "ArmaniKeyboardLayouts",
		efi.GUID{0x5c, 0x25, 0x95, 0x47, 0x31, 0x70, 0x3c, 0x47, 0xaf, 0x8a, 0x8b, 0xc7, 0x70, 0x1a, 0xcc, 0xa5}: "fTPMAcpi",
		efi.GUID{0x5c, 0x2f, 0x45, 0x9c, 0x00, 0x62, 0xa6, 0x4a, 0x80, 0x68, 0xf4, 0x4b, 0x4f, 0x36, 0xd4, 0x1e}: "H2OKeyDescDxe",
		efi.GUID{0x5c, 0x36, 0x65, 0x05, 0xe1, 0x2f, 0x88, 0x4f, 0xb3, 0xbe, 0x62, 0x4c, 0x04, 0x62, 0x3a, 0x20}: "MicrocodeUpdateDxe",
		efi.GUID{0x5c, 0x59, 0x3a, 0x21, 0x12, 0xf5, 0x35, 0x49, 0x90, 0xe3, 0x2c, 0xea, 0xd0, 0x77, 0xc7, 0x21}: "DashDxe",
		efi.GUID{0x5c, 0x5a, 0x99, 0x73, 0xab, 0xc2, 0xcc, 0x48, 0xa4, 0x04, 0xe3, 0x9b, 0x38, 0x50, 0x5c, 0x56}: "PlatformRecoveryOrderGuid",
		efi.GUID{0x5c, 0x5b, 0xc2, 0x35, 0xd6, 0xbc, 0xc5, 0x4b, 0x94, 0x0f, 0xa2, 0x7c, 0xd8, 0xcc, 0xc2, 0xc3}: "FjGabiSetupSettingsHandlerSmm",
		efi.GUID{0x5c, 0x66, 0x21, 0xf8, 0x37, 0x01, 0x34, 0x4f, 0xa7, 0xa1, 0x57, 0xa0, 0xbd, 0x25, 0x6d, 0x62}: "IntelScLegacyInterrupt",
		efi.GUID{0x5c, 0x67, 0xd1, 0x81, 0xf6, 0x86, 0xdf, 0x48, 0xbd, 0x95, 0x9a, 0x6e, 0x4f, 0x09, 0x25, 0xc3}: "EdkiiVariablePolicyProtocol",
		efi.GUID{0x5c, 0x70, 0xcf, 0xda, 0xdf, 0x71, 0x7d, 0x49, 0xaa, 0xbe, 0x10, 0x18, 0x6b, 0x2e, 0x1d, 0xde}: "Recovery",
		efi.GUID{0x5c, 0x78, 0x29, 0x7c, 0xb9, 0x66, 0xfc, 0x49, 0xb7, 0x97, 0x1c, 0xa5, 0x55, 0x0e, 0xf2, 0x83}: "PeiUsbIoPpiGuid",
		efi.GUID{0x5c, 0x79, 0x0e, 0xef, 0x9a, 0x74, 0x41, 0x4b, 0xb9, 0x94, 0x7d, 0xdc, 0x6b, 0x59, 0x43, 0x88}: "UsbOcUpdateDxeNeonCityEPRP",
		efi.GUID{0x5c, 0x7e, 0xb3, 0x5d, 0xeb, 0x2e, 0xf8, 0x43, 0xad, 0xa0, 0x24, 0x37, 0x02, 0xd3, 0x94, 0x5d}: "DellSioConfigDxe",
		efi.GUID{0x5c, 0x87, 0x78, 0xe3, 0x82, 0x32, 0xa0, 0x48, 0xa9, 0xa8, 0xb1, 0xe4, 0xe1, 0x6b, 0xd5, 0x13}: "ChassisIntrusionS3",
		efi.GUID{0x5c, 0x89, 0x1d, 0x85, 0x12, 0x22, 0x81, 0x4d, 0x83, 0x16, 0x18, 0xd7, 0xc1, 0x3e, 0x5f, 0x60}: "AmdHspFtpmDxe",
		efi.GUID{0x5c, 0x89, 0xda, 0xb3, 0x27, 0x6a, 0x4c, 0x4c, 0x94, 0xe4, 0x23, 0x59, 0xbe, 0x25, 0x32, 0xf5}: "SecureEraseDxe",
		efi.GUID{0x5c, 0x8f, 0x50, 0xf5, 0xd7, 0x88, 0x6c, 0x42, 0xb1, 0xc4, 0x19, 0x8a, 0x02, 0x72, 0x40, 0x5c}: "UpdateD01AcpiTableHdr",
		efi.GUID{0x5c, 0x96, 0x85, 0x5b, 0x5d, 0x45, 0xc6, 0x4c, 0x9c, 0x4c, 0x7f, 0x08, 0x69, 0x67, 0xd2, 0xb0}: "PKeyFileSha256Guid",
		efi.GUID{0x5c, 0x9f, 0xff, 0x32, 0xb4, 0x56, 0x49, 0x41, 0x81, 0xa8, 0xe7, 0x48, 0x64, 0x5e, 0x95, 0x51}: "HpSioSecuritySmm",
		efi.GUID{0x5c, 0xa1, 0x22, 0xf1, 0x0b, 0xc1, 0x54, 0x4d, 0x8f, 0x48, 0x60, 0xf4, 0xf0, 0x6d, 0xd1, 0xad}: "LegacyBiosDxe",
		efi.GUID{0x5c, 0xa4, 0xb5, 0x28, 0x5d, 0xcc, 0x21, 0x42, 0x9d, 0xff, 0x86, 0xb0, 0xf4, 0x2d, 0xdc, 0x01}: "LenovoIvbGopDriver",
		efi.GUID{0x5c, 0xa7, 0xf6, 0xe8, 0xda, 0x3c, 0x00, 0x4b, 0x98, 0x37, 0x8c, 0xa2, 0xa1, 0xf3, 0x4e, 0xac}: "SpsDxe",
		efi.GUID{0x5c, 0xb2, 0x4d, 0x45, 0x06, 0xe5, 0x90, 0x4f, 0xa6, 0xdf, 0x69, 0xe0, 0x22, 0x3e, 0x3f, 0x2b}: "PramAddrDataGuid",
		efi.GUID{0x5c, 0xb9, 0x23, 0x50, 0x26, 0xdb, 0x9b, 0x42, 0xa6, 0x48, 0xbd, 0x47, 0x66, 0x4c, 0x80, 0x12}: "AmiMediaDevicePath",
		efi.GUID{0x5c, 0xbb, 0x9a, 0xde, 0x92, 0x2f, 0x52, 0x43, 0x9c, 0x56, 0xf5, 0x1b, 0xc9, 0xd5, 0xe5, 0x5a}: "DxeFramework",
		efi.GUID{0x5c, 0xbe, 0xa0, 0x40, 0xa6, 0xec, 0xf1, 0x45, 0xbf, 0xf5, 0x61, 0x9e, 0x26, 0x95, 0x1e, 0x5c}: "HstiDxeV2",
		efi.GUID{0x5c, 0xc3, 0xf8, 0x49, 0xef, 0xb9, 0x2a, 0x40, 0xab, 0x44, 0x87, 0x1c, 0x13, 0x9e, 0xb0, 0x0d}: "FastBootSetupDxe",
		efi.GUID{0x5c, 0xc9, 0xdb, 0xb1, 0xe7, 0x0e, 0x61, 0x42, 0xb2, 0x90, 0x5b, 0xf0, 0xa4, 0xdb, 0x95, 0x27}: "DellSmmRadioExecProtocol",
		efi.GUID{0x5c, 0xe0, 0xc7, 0x0b, 0x8a, 0xc8, 0x54, 0x42, 0xbc, 0xbb, 0xd4, 0x26, 0x38, 0xd2, 0x8a, 0xad}: "PlatformMilestoneSmm",
		efi.GUID{0x5c, 0xe6, 0x43, 0x32, 0xe3, 0x5c, 0xb7, 0x47, 0xb4, 0x06, 0x26, 0x8c, 0xf8, 0xc0, 0x89, 0x68}: "HpTimingData",
		efi.GUID{0x5c, 0xf9, 0x1b, 0x89, 0x03, 0xa9, 0xe7, 0x42, 0x8d, 0x5f, 0xb7, 0xf9, 0xb6, 0xc8, 0x83, 0x1c}: "PchLpcPei",
		efi.GUID{0x5d, 0x02, 0xcf, 0x77, 0x43, 0xd7, 0xe5, 0x4d, 0xac, 0x39, 0xae, 0x4a, 0x59, 0x10, 0x64, 0xb0}: "RestoreVariablesDxe",
		efi.GUID{0x5d, 0x09, 0x9a, 0x3c, 0xcb, 0xc3, 0x02, 0x43, 0x96, 0xe1, 0x71, 0x05, 0xa7, 0xc4, 0x6a, 0x69}: "AmdCcxZenRvDxe",
		efi.GUID{0x5d, 0x0d, 0x33, 0x25, 0x74, 0x54, 0xb8, 0x4e, 0x81, 0x92, 0xe6, 0xde, 0x3d, 0x5e, 0xd0, 0xb6}: "DellVariable2Smm",
		efi.GUID{0x5d, 0x1c, 0x82, 0x84, 0xfe, 0x1c, 0x2d, 0x4e, 0x81, 0x9d, 0x50, 0x19, 0x44, 0x8d, 0x17, 0x5c}: "SmmSxCallBack",
		efi.GUID{0x5d, 0x1e, 0xc8, 0x97, 0xa0, 0x8f, 0x6a, 0x48, 0xaa, 0xea, 0x0e, 0xfd, 0xf0, 0x90, 0xfe, 0x4f}: "SerialIo",
		efi.GUID{0x5d, 0x21, 0x26, 0x11, 0x9c, 0xb9, 0x09, 0x4b, 0x9c, 0xa8, 0x60, 0xc6, 0x11, 0xac, 0xe2, 0x9d}: "OemEcFeature",
		efi.GUID{0x5d, 0x21, 0x62, 0xa3, 0xb6, 0x75, 0x54, 0x4b, 0x80, 0xe5, 0x74, 0x34, 0x75, 0x18, 0x77, 0xf3}: "RtkUndiDxe",
		efi.GUID{0x5d, 0x2c, 0xe9, 0xff, 0x83, 0x2d, 0xe2, 0x44, 0xa4, 0xea, 0x29, 0x4d, 0x53, 0x99, 0x1d, 0xbc}: "HpChipsetSHUsbPortDisableSmm",
		efi.GUID{0x5d, 0x35, 0x9f, 0xe0, 0xe8, 0xda, 0x10, 0x49, 0xb1, 0x4a, 0x92, 0x78, 0x0f, 0xdc, 0xf7, 0xcb}: "EdkiiPlatformSpecificResetNotificationPpi",
		efi.GUID{0x5d, 0x41, 0x06, 0x49, 0x32, 0x4b, 0x28, 0x4d, 0x85, 0x57, 0x21, 0xc3, 0x90, 0xd7, 0x6a, 0x3c}: "DeleteUefiCaFromDb",
		efi.GUID{0x5d, 0x46, 0x10, 0x41, 0xf3, 0x5f, 0x4b, 0x4f, 0xb5, 0x80, 0x24, 0xed, 0x0d, 0x06, 0x74, 0x7a}: "SmbiosPlatformDxe",
		efi.GUID{0x5d, 0x55, 0xfb, 0x65, 0xca, 0x5c, 0xc3, 0x40, 0x99, 0x67, 0x22, 0x79, 0x88, 0x28, 0x8d, 0xd8}: "LenovoSupervisorPasswordManagerSmmProtocol",
		efi.GUID{0x5d, 0x5d, 0x73, 0x96, 0x95, 0x45, 0x83, 0x41, 0xb1, 0xd7, 0x93, 0x4c, 0xc4, 0x02, 0xaa, 0x95}: "ramdisk",
		efi.GUID{0x5d, 0x60, 0x5f, 0x5f, 0x83, 0x15, 0x2d, 0x4a, 0xa6, 0xb2, 0xeb, 0x12, 0xda, 0xb4, 0xa2, 0xb6}: "ShellBcfgHiiGuid",
		efi.GUID{0x5d, 0x6a, 0xbd, 0x54, 0xf2, 0x38, 0xbd, 0x44, 0x84, 0xab, 0x10, 0x8b, 0xe4, 0xf4, 0x59, 0x14}: "DellChassisConfigDxe",
		efi.GUID{0x5d, 0x6e, 0x0b, 0xe5, 0x9b, 0x35, 0xe0, 0x4b, 0xa0, 0xb0, 0x07, 0x15, 0xa3, 0x01, 0xa6, 0x06}: "EfiPeiSelPpi",
		efi.GUID{0x5d, 0x73, 0xd7, 0xe9, 0xe2, 0x06, 0xb7, 0x47, 0xb8, 0x56, 0x2a, 0x20, 0x13, 0x8f, 0xae, 0xa4}: "FchHuashanSmmInit",
		efi.GUID{0x5d, 0x76, 0x50, 0x8a, 0x82, 0x15, 0xeb, 0x41, 0x82, 0x89, 0x14, 0x09, 0x41, 0x9c, 0x24, 0xdd}: "LenovoMfgDoneSmm",
		efi.GUID{0x5d, 0x7d, 0x06, 0xea, 0xfd, 0x56, 0x00, 0x4b, 0xb7, 0x9a, 0x35, 0x2a, 0xff, 0x8f, 0x2b, 0xd6}: "UpdateSmbiosType41",
		efi.GUID{0x5d, 0x80, 0x4d, 0x0e, 0x6c, 0x74, 0xbc, 0x4e, 0x87, 0x95, 0x31, 0xa2, 0x86, 0xcc, 0xa6, 0x20}: "TcgPeiPolicyHobGuid",
		efi.GUID{0x5d, 0x8a, 0x7e, 0x49, 0x07, 0xc8, 0x0f, 0x42, 0x8d, 0x85, 0x47, 0xe7, 0x72, 0xc7, 0xe6, 0xe4}: "IwlTransDriver",
		efi.GUID{0x5d, 0x96, 0x18, 0x82, 0xc0, 0x20, 0xd6, 0x4d, 0x81, 0xa0, 0x84, 0x5c, 0x52, 0x27, 0x07, 0x43}: "LenovoSetupDateTimeDxe",
		efi.GUID{0x5d, 0x9d, 0x40, 0x95, 0x41, 0x0a, 0x58, 0x42, 0x8a, 0x99, 0x81, 0x0a, 0x22, 0x12, 0x6b, 0xbe}: "OemSmbios",
		efi.GUID{0x5d, 0x9d, 0xb7, 0x85, 0xad, 0xea, 0x85, 0x4a, 0xba, 0x28, 0x03, 0xd1, 0x36, 0x2e, 0x66, 0x8d}: "FchI2cMasterPei",
		efi.GUID{0x5d, 0xaa, 0xa7, 0x52, 0x23, 0x3b, 0x06, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xa9, 0x5d, 0xd8, 0x4e}: "XnoteSetupSecurityDxe",
		efi.GUID{0x5d, 0xad, 0xa2, 0x44, 0x2c, 0x61, 0xb3, 0x47, 0xb0, 0x6e, 0xc8, 0xf5, 0x0b, 0xfb, 0xf0, 0x7d}: "OpalExtraInfoVariableGuid",
		efi.GUID{0x5d, 0xaf, 0xfa, 0xf9, 0x48, 0xe8, 0x37, 0x45, 0x8a, 0x75, 0x0e, 0x3b, 0xd2, 0xde, 0xfb, 0x6a}: "UsbOcUpdateDxeXPV",
		efi.GUID{0x5d, 0xbb, 0x0a, 0xbd, 0x9f, 0xa2, 0x01, 0x40, 0xa3, 0xca, 0x98, 0x48, 0x5e, 0xf7, 0xf2, 0x24}: "AcpiSmmPlatform",
		efi.GUID{0x5d, 0xc0, 0xed, 0xa3, 0x18, 0xb6, 0xf6, 0x4f, 0x95, 0x52, 0x76, 0xd7, 0x88, 0x63, 0x43, 0xc8}: "OvmfLoadedX86LinuxKernelProtocol",
		efi.GUID{0x5d, 0xca, 0x46, 0xe6, 0x6b, 0x6d, 0x73, 0x47, 0x87, 0x9b, 0x8b, 0x4d, 0xa2, 0x77, 0x5e, 0x09}: "FchImcControl",
		efi.GUID{0x5d, 0xce, 0xe8, 0x0a, 0x48, 0xe4, 0x37, 0x44, 0xa8, 0xd7, 0xeb, 0xf5, 0xf1, 0x94, 0xf7, 0x31}: "EfiDxeIplPpiGuid",
		efi.GUID{0x5d, 0xd0, 0xee, 0x23, 0x93, 0x1b, 0x1a, 0x4a, 0x8e, 0x1b, 0x93, 0x1d, 0x69, 0xe3, 0x79, 0x52}: "Omap35xxBoardInterruptDxe",
		efi.GUID{0x5d, 0xd1, 0xef, 0x08, 0x55, 0xec, 0x23, 0x40, 0xb6, 0x48, 0x7b, 0xa4, 0x0d, 0xf7, 0xd0, 0x5d}: "PeiRamBootPei",
		efi.GUID{0x5d, 0xd3, 0xc2, 0x0a, 0x77, 0x1c, 0x33, 0x10, 0xa6, 0xf8, 0x7c, 0xa5, 0x5d, 0xf7, 0xd0, 0xaa}: "CpuPolicyPei",
		efi.GUID{0x5d, 0xd7, 0x7d, 0x83, 0x62, 0x98, 0x68, 0x4e, 0x87, 0xf9, 0x64, 0xf8, 0x55, 0xbb, 0x83, 0xec}: "HpNetworkFeatureByteKillSmm",
		efi.GUID{0x5d, 0xd9, 0x8d, 0x9e, 0x8b, 0x86, 0xa4, 0x41, 0x96, 0x6c, 0x10, 0x73, 0x38, 0xc2, 0x91, 0xbb}: "SmbiosDataUpdateDxeLightningRidgeEXECB2",
		efi.GUID{0x5d, 0xe1, 0xcb, 0x76, 0x00, 0x3c, 0x97, 0x45, 0x8f, 0x13, 0x62, 0x1d, 0x77, 0xe8, 0x79, 0xe1}: "AmtSaveMebxConfig",
		efi.GUID{0x5d, 0xf1, 0x33, 0xba, 0x00, 0x40, 0xc1, 0x45, 0x8e, 0x88, 0xf9, 0x16, 0x92, 0xd4, 0x57, 0xe3}: "MpInformationHob",
		efi.GUID{0x5d, 0xfd, 0x67, 0x51, 0xa2, 0xaa, 0xe1, 0x4f, 0x9d, 0x0d, 0x5c, 0xfc, 0xab, 0x36, 0xc1, 0x4c}: "LegacyRegion2OnLegacyRegionThunk",
		efi.GUID{0x5d, 0xff, 0xfd, 0x22, 0x58, 0xef, 0x45, 0x4e, 0xb5, 0x15, 0xa4, 0x10, 0x67, 0xd5, 0xc8, 0x0b}: "AssetQrCode",
		efi.GUID{0x5e, 0x0d, 0x27, 0x78, 0x50, 0x94, 0xae, 0x4f, 0x88, 0x18, 0xb9, 0x1e, 0xa3, 0x98, 0x64, 0xcd}: "ChipsetLibServicesSmm",
		efi.GUID{0x5e, 0x0d, 0x62, 0xcc, 0xcf, 0xfe, 0xd4, 0x49, 0xb5, 0x1b, 0x46, 0x1d, 0x52, 0x49, 0x46, 0x69}: "AutoEcud",
		efi.GUID{0x5e, 0x0e, 0x2e, 0x7c, 0x35, 0x7c, 0x11, 0x46, 0xbc, 0x93, 0x03, 0x60, 0x13, 0xed, 0xbe, 0x3d}: "AsusWmiAtkDxeSmmCoreBin",
		efi.GUID{0x5e, 0x0e, 0x90, 0x12, 0x8b, 0xb8, 0x6c, 0x44, 0xae, 0x19, 0x18, 0xa0, 0x85, 0x6b, 0x71, 0x7f}: "SioSmbusAccessDxe",
		efi.GUID{0x5e, 0x11, 0xab, 0xb2, 0xb6, 0xc8, 0x36, 0x40, 0xbf, 0x31, 0xe7, 0x4b, 0xd8, 0x92, 0x6c, 0xce}: "DxePlatformAmtPolicy",
		efi.GUID{0x5e, 0x18, 0xda, 0x7a, 0x10, 0x7e, 0x7c, 0x4f, 0xb2, 0xda, 0x26, 0xe9, 0x91, 0x02, 0xc8, 0x8d}: "AmdCpmDiscreteUSB4Dxe",
		efi.GUID{0x5e, 0x1f, 0x95, 0x22, 0x7b, 0x4f, 0x5b, 0x40, 0x8a, 0xda, 0xec, 0xdc, 0x43, 0x1c, 0x61, 0x6f}: "UefiWindowsInt10Workaround",
		efi.GUID{0x5e, 0x22, 0xcc, 0x18, 0x99, 0x87, 0x45, 0x49, 0x9f, 0x92, 0xeb, 0xb9, 0x64, 0x23, 0xd6, 0xc1}: "FjGabiFlashCommonGbeRegionCtrlSmm",
		efi.GUID{0x5e, 0x26, 0x44, 0x11, 0x49, 0xf0, 0xb9, 0x45, 0x87, 0x78, 0x75, 0x2f, 0x12, 0xa1, 0x36, 0x5a}: "IntelTechSetup",
		efi.GUID{0x5e, 0x27, 0xac, 0x30, 0x30, 0xbb, 0x84, 0x4b, 0xa1, 0xcd, 0x0a, 0xf1, 0x32, 0x2c, 0x89, 0xc0}: "PeiSpeakerInterfacePpiGuid",
		efi.GUID{0x5e, 0x32, 0xcc, 0x18, 0x99, 0x27, 0x45, 0x45, 0x9f, 0x92, 0xeb, 0xb9, 0xe4, 0x23, 0xd6, 0xc1}: "FjGabiFlashCommonEcRegionCtrlSmm",
		efi.GUID{0x5e, 0x41, 0x8b, 0x25, 0x8e, 0x3e, 0x82, 0x4b, 0x80, 0x67, 0x9e, 0xfc, 0x79, 0x49, 0xea, 0xc8}: "ResetSystemDxe",
		efi.GUID{0x5e, 0x44, 0x23, 0xe9, 0x1e, 0x2e, 0x42, 0x46, 0x8c, 0xb9, 0x23, 0x93, 0x20, 0xaa, 0x41, 0xe8}: "UsbOcUpdateDxeCLX64L",
		efi.GUID{0x5e, 0x48, 0x10, 0xc8, 0xec, 0xd0, 0x98, 0x4e, 0xaa, 0xb5, 0x12, 0x0c, 0x7e, 0x55, 0x44, 0x28}: "TdtAm",
		efi.GUID{0x5e, 0x4a, 0x22, 0xf3, 0xa3, 0x17, 0xc2, 0x47, 0xa3, 0x8b, 0x48, 0x14, 0x56, 0x86, 0x3c, 0x74}: "AmiSmmNvramUpdateProtocolGuid",
		efi.GUID{0x5e, 0x4f, 0xf7, 0x88, 0x98, 0xe9, 0x59, 0x4d, 0x44, 0xd8, 0x22, 0x5f, 0xef, 0x02, 0xfc, 0xe3}: "TiXio2001BridgeConfig",
		efi.GUID{0x5e, 0x5a, 0x52, 0xaf, 0x3e, 0x18, 0x09, 0x43, 0x9e, 0x49, 0xea, 0x22, 0xcf, 0x41, 0x2e, 0xae}: "MsiBoardECSmm",
		efi.GUID{0x5e, 0x60, 0xd3, 0x25, 0x2f, 0x52, 0x70, 0x45, 0xa1, 0x97, 0x56, 0xbd, 0xda, 0xcb, 0x5f, 0xed}: "BiosUpdatePlatformPolicyPei",
		efi.GUID{0x5e, 0x66, 0x89, 0x98, 0xb4, 0xa0, 0x41, 0x43, 0x97, 0x11, 0x2a, 0xb9, 0x82, 0x52, 0xd2, 0x82}: "FjUsbTypecPwrLimitCtrlDxe",
		efi.GUID{0x5e, 0x67, 0x95, 0xb7, 0x83, 0x75, 0x98, 0x4f, 0xac, 0x6a, 0xf9, 0xdd, 0xbb, 0xcc, 0x32, 0xe8}: "SystemFirmwareManagementRuntimeDxe",
		efi.GUID{0x5e, 0x6c, 0xe5, 0x70, 0x0c, 0x28, 0xb0, 0x44, 0xa4, 0x97, 0x09, 0x68, 0x1a, 0xbc, 0x37, 0x5e}: "DmiDataGuid",
		efi.GUID{0x5e, 0x6d, 0x77, 0xfd, 0xb7, 0xa7, 0x1c, 0x4c, 0x89, 0x6f, 0x61, 0x6a, 0xe4, 0x44, 0x43, 0x6c}: "MAPS_SerialPortControlDxe",
		efi.GUID{0x5e, 0x6d, 0xcb, 0x73, 0xe4, 0x2b, 0x4e, 0x43, 0xad, 0x6b, 0x4d, 0x7f, 0xb8, 0x70, 0x0c, 0x16}: "FjUsbCdcDxe",
		efi.GUID{0x5e, 0x71, 0x3c, 0x14, 0x03, 0xe9, 0x67, 0x46, 0xbf, 0x15, 0x03, 0xf5, 0xa5, 0x42, 0xf5, 0x8e}: "ClientronShowSystemInfoDxe",
		efi.GUID{0x5e, 0x79, 0x2b, 0xc9, 0xfc, 0xcd, 0x32, 0x49, 0x91, 0xb5, 0x00, 0xbb, 0xb5, 0xf0, 0xc9, 0x5e}: "FjIbvInterexchangeDataStorageProtocoDxe",
		efi.GUID{0x5e, 0x79, 0x9f, 0x0a, 0xfc, 0xb9, 0x17, 0x41, 0xbc, 0x4e, 0x13, 0x86, 0x95, 0xd1, 0x65, 0x62}: "AmdSocFp5RvDxe",
		efi.GUID{0x5e, 0x7a, 0x72, 0xe6, 0xcd, 0xcb, 0xc8, 0x44, 0xb3, 0x7f, 0x78, 0xbc, 0x3a, 0x0c, 0x16, 0xc8}: "X86EmulatorDxe",
		efi.GUID{0x5e, 0x7b, 0x0a, 0xe9, 0xb2, 0x37, 0xe4, 0x43, 0xb2, 0x81, 0x4c, 0x8e, 0x34, 0x90, 0x45, 0xe9}: "ReFlashSmm",
		efi.GUID{0x5e, 0x82, 0x85, 0x6a, 0x59, 0xc4, 0x08, 0x41, 0x9b, 0x81, 0x66, 0x02, 0x95, 0x34, 0x68, 0xe4}: "FjGenericItemStorageSmm",
		efi.GUID{0x5e, 0x85, 0x70, 0xad, 0xc5, 0x0c, 0xbf, 0x4a, 0x89, 0x79, 0xbe, 0x76, 0x2a, 0x94, 0x9e, 0xa3}: "IncompatiblePciDeviceSupport",
		efi.GUID{0x5e, 0x8c, 0x5e, 0x9f, 0x73, 0x03, 0x08, 0x4a, 0x8d, 0xb5, 0x1f, 0x91, 0x33, 0x16, 0xc5, 0xe4}: "LenovoSecuritySmiDispatchProtocol",
		efi.GUID{0x5e, 0x8e, 0x2b, 0xce, 0xa9, 0xcf, 0x18, 0x4f, 0x9a, 0xe1, 0xac, 0xea, 0xb6, 0x42, 0x89, 0x2c}: "DellOA30CtrlSmm",
		efi.GUID{0x5e, 0x8f, 0xd2, 0x4c, 0xbb, 0x4b, 0x02, 0x46, 0xac, 0xb8, 0x74, 0x1b, 0xaa, 0x7e, 0xb3, 0x13}: "AmiTseOemPortingVar19",
		efi.GUID{0x5e, 0x93, 0xa3, 0x82, 0x18, 0xba, 0x03, 0x47, 0xa7, 0xd7, 0x6d, 0x35, 0x6f, 0xfe, 0x26, 0xba}: "CameraSmm",
		efi.GUID{0x5e, 0x9e, 0x10, 0x9c, 0x38, 0xbf, 0x78, 0x4a, 0x9c, 0xac, 0x43, 0xde, 0x7e, 0x72, 0x6f, 0x9e}: "AmiMemoryAbsentOverrideGuid",
		efi.GUID{0x5e, 0xa1, 0xee, 0xde, 0x77, 0x4a, 0x13, 0x45, 0xba, 0x75, 0x71, 0xd2, 0x6f, 0xef, 0x78, 0xa1}: "SmmIoLibSmmCpuIo2",
		efi.GUID{0x5e, 0xb0, 0xb5, 0xe3, 0xb9, 0xe4, 0xd1, 0x4e, 0xbf, 0x0f, 0x36, 0xd4, 0xca, 0x7f, 0xe3, 0x65}: "MulitBoardPei",
		efi.GUID{0x5e, 0xc2, 0xe7, 0x1c, 0xe0, 0x02, 0xb8, 0x4c, 0x94, 0x10, 0x76, 0x6e, 0xee, 0x8b, 0x8a, 0x97}: "FjMfgTpmDxe",
		efi.GUID{0x5e, 0xc5, 0xad, 0x83, 0xe1, 0x24, 0x1a, 0x47, 0xbf, 0x47, 0x27, 0x2f, 0x49, 0xcd, 0x8f, 0x9a}: "FjGabiFlashCoreDxe",
		efi.GUID{0x5e, 0xcc, 0x0a, 0x8c, 0xc1, 0x28, 0x99, 0x45, 0x82, 0x38, 0x95, 0x58, 0xa9, 0xd7, 0xa4, 0x28}: "UsbTypeCPowerLimitPei",
		efi.GUID{0x5e, 0xd2, 0xd6, 0xf7, 0x43, 0x62, 0x5c, 0x4d, 0x9b, 0xa5, 0xc2, 0xdc, 0x48, 0xf0, 0x03, 0xb0}: "AmiFlashLibPei",
		efi.GUID{0x5e, 0xdc, 0x4b, 0xd3, 0x8a, 0x96, 0xf5, 0x40, 0xa4, 0x8c, 0xe5, 0x94, 0xf4, 0x5a, 0xe2, 0x11}: "VariableAuthSmm",
		efi.GUID{0x5e, 0xe2, 0xfa, 0x71, 0x27, 0x44, 0x48, 0x4c, 0xb7, 0x07, 0xfc, 0x5b, 0xf2, 0xf6, 0x74, 0x2e}: "RTKUndiDxe",
		efi.GUID{0x5e, 0xe3, 0x55, 0x17, 0x29, 0x3b, 0x3a, 0x4f, 0xad, 0x20, 0x80, 0x78, 0x81, 0x59, 0xda, 0x1f}: "LEMPasswordStoreProtocolSmm",
		efi.GUID{0x5e, 0xed, 0xb2, 0xc8, 0x0c, 0xb8, 0x09, 0x4c, 0xa3, 0x15, 0x3a, 0x53, 0xd2, 0x62, 0x5e, 0x1a}: "HpPlatformDxeServices",
		efi.GUID{0x5e, 0xef, 0x47, 0xb8, 0xb0, 0xa5, 0xdf, 0x45, 0xbe, 0xcd, 0x06, 0xca, 0x11, 0x3f, 0xbf, 0x7b}: "LanDriver",
		efi.GUID{0x5e, 0xef, 0x54, 0x25, 0xca, 0xc9, 0x48, 0x4a, 0x9d, 0x94, 0x24, 0x9e, 0xb1, 0xe8, 0x7c, 0x2d}: "LenovoCryptService",
		efi.GUID{0x5e, 0xfc, 0x0d, 0x5c, 0xcb, 0xb4, 0x84, 0x44, 0xb7, 0x68, 0x26, 0x0d, 0x71, 0x84, 0xfb, 0x58}: "AmdCcxZen4Smm",
		efi.GUID{0x5f, 0x04, 0x72, 0x65, 0xbf, 0xb1, 0x8e, 0x45, 0xbc, 0x02, 0x70, 0x67, 0x62, 0xc6, 0x09, 0xae}: "EfiHeciSmmRuntimeProtocolGuid",
		efi.GUID{0x5f, 0x0c, 0x4c, 0x83, 0xb3, 0xad, 0x72, 0x43, 0xae, 0xeb, 0x03, 0xe4, 0xe9, 0xe6, 0xc5, 0x91}: "IntelFspPkgTokenSpaceGuid",
		efi.GUID{0x5f, 0x0e, 0x32, 0xb5, 0x75, 0x08, 0xbc, 0x42, 0xa5, 0xb7, 0x15, 0xaf, 0x36, 0xce, 0x87, 0xcf}: "TcgDmarDxe",
		efi.GUID{0x5f, 0x19, 0x99, 0xc5, 0x5b, 0x9b, 0x10, 0x49, 0x93, 0x10, 0xa6, 0x10, 0x3f, 0x5e, 0xd3, 0xf6}: "POSTWarningDxe",
		efi.GUID{0x5f, 0x1e, 0xc7, 0x22, 0x2b, 0xb3, 0xe0, 0x44, 0xb7, 0x05, 0xb1, 0xad, 0xcf, 0xe7, 0x0c, 0x0c}: "SureStartPoliciesPei",
		efi.GUID{0x5f, 0x1f, 0x17, 0x5f, 0x85, 0x83, 0x86, 0x40, 0xa6, 0x9b, 0x1f, 0xcf, 0x06, 0xae, 0x4a, 0x3d}: "AmiOsPpiConfirmationOverrideGuid",
		efi.GUID{0x5f, 0x1f, 0x7b, 0x06, 0x26, 0xcf, 0xc5, 0x44, 0x85, 0x54, 0x93, 0xd7, 0x77, 0x91, 0x2d, 0x42}: "ConfidentialComputingSevSnpBlob",
		efi.GUID{0x5f, 0x25, 0xfc, 0x3d, 0x86, 0x9c, 0xbc, 0x48, 0x97, 0x2d, 0xe5, 0x22, 0x53, 0x37, 0x68, 0xdb}: "LenovoRebootCp",
		efi.GUID{0x5f, 0x29, 0xb9, 0xb6, 0xbf, 0xca, 0xec, 0x4c, 0xbb, 0x14, 0xfe, 0x42, 0x46, 0xf2, 0x17, 0x3a}: "iFfsDxe",
		efi.GUID{0x5f, 0x31, 0xeb, 0xcd, 0xd9, 0xc5, 0xf1, 0x40, 0x23, 0x14, 0x60, 0xcb, 0x26, 0x26, 0x2e, 0x4f}: "UefiSwitchMonitorDxe",
		efi.GUID{0x5f, 0x39, 0x8a, 0x6a, 0x07, 0x4c, 0xd1, 0x49, 0xb9, 0x4c, 0x22, 0xed, 0x50, 0xd4, 0x25, 0xf8}: "LenovoSecureKeyDxe",
		efi.GUID{0x5f, 0x3f, 0x8b, 0x79, 0xfe, 0xf5, 0xe7, 0x4a, 0x9e, 0x85, 0xd7, 0x16, 0x13, 0xd8, 0xcf, 0xfc}: "KEMaEAPI",
		efi.GUID{0x5f, 0x42, 0x4b, 0xc5, 0x79, 0xaa, 0xb4, 0x48, 0x98, 0x1f, 0x99, 0x8b, 0x3c, 0x4b, 0x64, 0x1c}: "TrEEConfigFormSetGuid",
		efi.GUID{0x5f, 0x42, 0xc0, 0xad, 0x54, 0xe9, 0x9c, 0x45, 0xba, 0xa4, 0x60, 0xfe, 0xd1, 0xc1, 0x16, 0x2a}: "VariableBackupRestoreDxe",
		efi.GUID{0x5f, 0x43, 0xd8, 0x85, 0x03, 0xa6, 0xad, 0x4d, 0xa2, 0x85, 0x72, 0x30, 0xd8, 0x4f, 0x9f, 0x69}: "AcerDiagnosticLogDxe",
		efi.GUID{0x5f, 0x44, 0x3a, 0x57, 0xb6, 0x4f, 0xd3, 0xc2, 0x2c, 0xc0, 0x5b, 0x9c, 0x77, 0x2c, 0xfb, 0x94}: "AmdRasSspApeiDxe",
		efi.GUID{0x5f, 0x48, 0x02, 0xf0, 0xb6, 0xb0, 0x3a, 0x4c, 0x9e, 0x7b, 0x54, 0xfa, 0xbd, 0x83, 0x07, 0x4d}: "EfiPlatformTypeLightningRidgeExecB2Protocol",
		efi.GUID{0x5f, 0x4b, 0x27, 0xac, 0x79, 0x4d, 0xd1, 0x48, 0x96, 0xdf, 0xfe, 0xe3, 0x54, 0xcf, 0x70, 0x83}: "EfiSerialPortTokenSpace",
		efi.GUID{0x5f, 0x64, 0x1e, 0x0b, 0x5c, 0x5e, 0xa1, 0x48, 0xff, 0xff, 0xff, 0xff, 0x58, 0x04, 0xe7, 0x47}: "XnotePlatformResetRuntimeDxe",
		efi.GUID{0x5f, 0x71, 0x46, 0x2a, 0x81, 0x35, 0x55, 0x4a, 0x8e, 0x73, 0x2b, 0x76, 0x9a, 0xaa, 0x30, 0xc5}: "RamDiskFormSetGuid",
		efi.GUID{0x5f, 0x76, 0x0d, 0x18, 0x89, 0xc4, 0x7a, 0x4f, 0x8a, 0x3f, 0x59, 0x60, 0x18, 0x49, 0x9e, 0xaf}: "DTbtDxe",
		efi.GUID{0x5f, 0x78, 0x0b, 0x5a, 0xcd, 0xc5, 0x05, 0x49, 0x92, 0x74, 0x86, 0x87, 0x37, 0xa5, 0x93, 0x88}: "IrstRemap",
		efi.GUID{0x5f, 0x83, 0x0d, 0x1c, 0xc5, 0xc0, 0x48, 0x48, 0xb4, 0x2b, 0x95, 0xfe, 0xdb, 0xcc, 0x81, 0x5c}: "GnbBristolRouting",
		efi.GUID{0x5f, 0x83, 0x67, 0x00, 0x50, 0x9a, 0x3a, 0x43, 0x8c, 0xbb, 0x85, 0x20, 0x78, 0x19, 0x78, 0x14}: "EfiCpuCsrAccess",
		efi.GUID{0x5f, 0x94, 0x3c, 0x28, 0xf5, 0x3f, 0x88, 0x45, 0xad, 0x80, 0x86, 0xe8, 0x70, 0x8b, 0x94, 0x2c}: "DellSimulatedECPei",
		efi.GUID{0x5f, 0x96, 0xe8, 0x97, 0x61, 0xc7, 0x48, 0x4f, 0xb6, 0xe4, 0x9f, 0xfa, 0x9c, 0xb2, 0xa2, 0xd6}: "AmiDeploymentModeNvGuid",
		efi.GUID{0x5f, 0x98, 0xdb, 0xa8, 0x2c, 0xcb, 0x22, 0x48, 0xb8, 0xb1, 0x1c, 0x8e, 0x48, 0x12, 0x3f, 0xa5}: "FjGabiPasswordHandlerSmm",
		efi.GUID{0x5f, 0xa3, 0xb4, 0x2a, 0xaf, 0xc2, 0xcd, 0xab, 0xa2, 0x2b, 0x4a, 0xd3, 0xc5, 0x8b, 0x79, 0x60}: "LogDataDxe",
		efi.GUID{0x5f, 0xa4, 0xe5, 0xa0, 0x74, 0x53, 0xb3, 0x46, 0xb5, 0x1e, 0xd3, 0x10, 0xb2, 0xc4, 0x8a, 0xae}: "ProjectOwnPeiProtocol",
		efi.GUID{0x5f, 0xba, 0x43, 0x2a, 0x29, 0xac, 0xdc, 0x4f, 0x8a, 0x3b, 0x03, 0x28, 0xd0, 0x25, 0x6f, 0x8c}: "SocketDxe",
		efi.GUID{0x5f, 0xbb, 0x61, 0xfe, 0x67, 0x1b, 0x24, 0x4c, 0xb3, 0x46, 0x73, 0xdb, 0x42, 0xe8, 0x73, 0xe5}: "ArmHwDxe",
		efi.GUID{0x5f, 0xbe, 0x1f, 0x31, 0x5a, 0x65, 0x22, 0x4d, 0x82, 0x8d, 0x37, 0x32, 0x61, 0xc4, 0xc0, 0x6e}: "WakeOnLanPortingDxe",
		efi.GUID{0x5f, 0xbe, 0xae, 0x2a, 0x22, 0xbd, 0x05, 0x4e, 0xb7, 0x14, 0x1b, 0x2b, 0x23, 0x38, 0xcd, 0x6a}: "RecoveryControl",
		efi.GUID{0x5f, 0xc2, 0x5b, 0xc4, 0x37, 0x39, 0xc4, 0x4f, 0xac, 0x79, 0xbb, 0xe8, 0xbd, 0x3e, 0x5f, 0x97}: "AdlinkBSCSmm",
		efi.GUID{0x5f, 0xc4, 0x06, 0x68, 0xc4, 0x13, 0x74, 0x42, 0xb8, 0xa3, 0x05, 0x5e, 0xf6, 0x41, 0xa0, 0x60}: "DxeFileExplorerProtocol",
		efi.GUID{0x5f, 0xcc, 0x46, 0xbc, 0xf2, 0x13, 0xcf, 0x44, 0xa5, 0x98, 0xcc, 0xa3, 0x44, 0x4d, 0x4e, 0x2b}: "GpioExpanderPei",
		efi.GUID{0x5f, 0xda, 0x17, 0x47, 0x44, 0xe5, 0x15, 0x4b, 0x8d, 0x27, 0xba, 0xcc, 0x29, 0x2a, 0x83, 0x2f}: "AmdSocFp6CznPei",
		efi.GUID{0x5f, 0xde, 0xaf, 0x67, 0x16, 0xef, 0xb8, 0x47, 0xba, 0x19, 0xc2, 0x1b, 0x39, 0x07, 0xdb, 0xf1}: "MiscGaIoSmm",
		efi.GUID{0x5f, 0xe6, 0xad, 0x11, 0x6b, 0x95, 0x0e, 0x4d, 0xb3, 0x68, 0x86, 0xdb, 0xc9, 0x2f, 0x01, 0xaa}: "VariableSmiInt15Dxe",
		efi.GUID{0x5f, 0xee, 0xe4, 0xd5, 0x0a, 0x3e, 0x3c, 0x45, 0xa7, 0x25, 0xb6, 0x92, 0xbb, 0x06, 0x36, 0x5a}: "EfiExtendedSalElogServicesProtocol",
		efi.GUID{0x5f, 0xf3, 0xef, 0x3e, 0x7c, 0x14, 0xd1, 0x4c, 0xa2, 0x34, 0x92, 0xa0, 0x69, 0x70, 0x0d, 0xb6}: "EfiMemorySetup",
		efi.GUID{0x5f, 0xf9, 0x83, 0xbb, 0xbc, 0xed, 0x84, 0x48, 0xa5, 0x20, 0xcd, 0x42, 0xaf, 0x38, 0x8f, 0xae}: "BaseDebugLibSerialPort",
		efi.GUID{0x5f, 0xfc, 0x07, 0x48, 0xf5, 0xcb, 0x4a, 0x42, 0x86, 0x9f, 0xa6, 0x3a, 0x13, 0x37, 0x35, 0xbc}: "CvpCore",
		efi.GUID{0x60, 0x00, 0xaf, 0x17, 0x8c, 0xa9, 0x03, 0x4a, 0x90, 0xad, 0x6a, 0xbe, 0xd7, 0x50, 0x45, 0xbd}: "CbsBaseDxeRV",
		efi.GUID{0x60, 0x0a, 0xc6, 0xa8, 0x50, 0xa9, 0xcb, 0x48, 0xa6, 0x12, 0x7f, 0xa7, 0x32, 0xdf, 0x72, 0x43}: "OemRuntime",
		efi.GUID{0x60, 0x1c, 0x84, 0x2f, 0x1f, 0x1b, 0x07, 0x40, 0xbe, 0x6d, 0x75, 0x3c, 0xcb, 0xe0, 0x57, 0x40}: "ODMSMBIOSTypeCASmm",
		efi.GUID{0x60, 0x1d, 0x5c, 0xa9, 0x9f, 0xcb, 0xd8, 0x4b, 0xa0, 0x30, 0x3f, 0x1c, 0x4a, 0x18, 0x51, 0x56}: "SecureBootMod",
		efi.GUID{0x60, 0x20, 0xbe, 0xb1, 0xf0, 0x4e, 0xed, 0x49, 0xad, 0x8a, 0x2f, 0x72, 0x30, 0x57, 0x30, 0x34}: "OEMIp3ECPei",
		efi.GUID{0x60, 0x29, 0xbd, 0x1f, 0x30, 0x41, 0xe5, 0x41, 0x94, 0xac, 0xd2, 0xcf, 0x03, 0x7f, 0xb3, 0x7c}: "EfiAdapterInfoNetworkBootGuid",
		efi.GUID{0x60, 0x2b, 0xdc, 0x22, 0x40, 0xfe, 0xac, 0x42, 0xb0, 0x1f, 0x3a, 0xb1, 0xfa, 0xd9, 0xaa, 0xd8}: "EmuVariableFvbRuntimeDxe",
		efi.GUID{0x60, 0x2d, 0xef, 0x4e, 0x00, 0x0e, 0xde, 0x11, 0x8c, 0x30, 0x08, 0x00, 0x20, 0x0c, 0x9a, 0x66}: "SataController",
		efi.GUID{0x60, 0x3f, 0x5d, 0x66, 0x3e, 0xad, 0xad, 0x4c, 0x8e, 0x26, 0xdb, 0x46, 0xee, 0xe9, 0xf1, 0xb5}: "RnRConfig",
		efi.GUID{0x60, 0x41, 0xa8, 0x2e, 0xa0, 0xab, 0xdf, 0x11, 0x98, 0x96, 0x00, 0x02, 0xa5, 0xd5, 0xc5, 0x1b}: "PL301Axi",
		efi.GUID{0x60, 0x41, 0xad, 0x1b, 0x02, 0xce, 0xdd, 0x4b, 0x9d, 0x04, 0xdc, 0xf7, 0xd7, 0xb7, 0x2e, 0x0f}: "IioErrorHandler",
		efi.GUID{0x60, 0x4b, 0x79, 0xf3, 0x85, 0x89, 0xdb, 0x11, 0x8e, 0x53, 0x00, 0x40, 0xd0, 0x2b, 0x18, 0x35}: "Cpu",
		efi.GUID{0x60, 0x4b, 0xaa, 0xdc, 0x8f, 0x40, 0xad, 0x4b, 0x99, 0xb9, 0xb8, 0x80, 0xd4, 0xef, 0x09, 0x50}: "Tdt",
		efi.GUID{0x60, 0x52, 0xce, 0xee, 0x1f, 0x9e, 0x74, 0x4f, 0x9d, 0xbb, 0x50, 0x82, 0x57, 0xcb, 0xaa, 0xd1}: "LifeCycleState",
		efi.GUID{0x60, 0x5a, 0x4b, 0xf8, 0xf6, 0x67, 0x5c, 0x41, 0x9f, 0x6f, 0x2f, 0xd9, 0x4f, 0xc1, 0x9b, 0x12}: "DellChassisConfigPei",
		efi.GUID{0x60, 0x5c, 0x33, 0x11, 0x18, 0x26, 0xf4, 0x4a, 0xaf, 0x9f, 0x15, 0xbd, 0x35, 0xd0, 0x57, 0x7b}: "FjLidSmm",
		efi.GUID{0x60, 0x67, 0x1d, 0x22, 0xc0, 0x4a, 0x12, 0x4c, 0xba, 0x96, 0x9c, 0x63, 0xe4, 0xd9, 0xc1, 0xc8}: "HwmInitPei",
		efi.GUID{0x60, 0x68, 0x0d, 0x3c, 0x96, 0x73, 0x8a, 0x48, 0xbf, 0x52, 0x2d, 0x86, 0x47, 0xd3, 0x5b, 0x28}: "MeOptionsSmm",
		efi.GUID{0x60, 0x6b, 0x5e, 0xb0, 0x3f, 0x32, 0xcf, 0x4b, 0x9a, 0x2b, 0x5d, 0xbf, 0xb0, 0x73, 0x01, 0xef}: "AmdNbioEarlyPhaseRNPei",
		efi.GUID{0x60, 0x6f, 0xdc, 0xa9, 0x61, 0xf8, 0xd1, 0x47, 0x87, 0x51, 0xec, 0xaa, 0xe7, 0xd2, 0x72, 0x91}: "LibMath",
		efi.GUID{0x60, 0x73, 0xac, 0x5f, 0xf2, 0xd4, 0x9e, 0x4c, 0xa7, 0xed, 0xf2, 0x59, 0x5e, 0x67, 0x08, 0x89}: "SctIsaHcProtocolGuid",
		efi.GUID{0x60, 0x8b, 0x1a, 0x9d, 0xb0, 0x6c, 0xde, 0x11, 0x8e, 0x91, 0x00, 0x02, 0xa5, 0xd5, 0xc5, 0x1b}: "ThunderboltNhiDxe",
		efi.GUID{0x60, 0x97, 0x7e, 0x08, 0xb5, 0x1f, 0xf7, 0x49, 0x87, 0x9a, 0x85, 0x3d, 0x2b, 0x21, 0x4c, 0xc7}: "LenovoSlp2Dxe",
		efi.GUID{0x60, 0xa9, 0x91, 0x73, 0xd1, 0xcc, 0xdd, 0x11, 0xad, 0x8b, 0x08, 0x00, 0x20, 0x0c, 0x9a, 0x66}: "LenovoSystemIdeAtaAtapiPassThruSmm",
		efi.GUID{0x60, 0xaf, 0x69, 0x51, 0x5a, 0x8c, 0x43, 0x42, 0xb3, 0xe9, 0x56, 0xc5, 0x6d, 0x18, 0xee, 0x26}: "SmmIpmiProtocolGuid",
		efi.GUID{0x60, 0xb1, 0x92, 0x76, 0x91, 0x35, 0xaa, 0x47, 0xbd, 0xee, 0x65, 0x52, 0x97, 0x66, 0x2e, 0x76}: "UefiDMBMHooKInt13Protocol",
		efi.GUID{0x60, 0xb5, 0xff, 0x4e, 0x8b, 0xb2, 0x57, 0x4e, 0x9d, 0xad, 0x43, 0x44, 0xe3, 0x2e, 0xa3, 0xba}: "MiscSubclass",
		efi.GUID{0x60, 0xc3, 0xd4, 0xb9, 0xfb, 0xbc, 0x9b, 0x4f, 0x92, 0x98, 0x53, 0xc1, 0x36, 0x98, 0x22, 0x58}: "EfiFormBrowser2ProtocolGuid",
		efi.GUID{0x60, 0xcb, 0x92, 0x6c, 0xc1, 0x08, 0x49, 0x41, 0xbf, 0x94, 0x60, 0xb7, 0xc5, 0x20, 0x60, 0x11}: "MAPS_WatchDogTimerDXE",
		efi.GUID{0x60, 0xd4, 0xca, 0xbc, 0x7d, 0x4f, 0x51, 0x4e, 0x8a, 0x5d, 0x3b, 0xba, 0x23, 0x6d, 0x9e, 0xbb}: "AppleBootBeep",
		efi.GUID{0x60, 0xd7, 0xce, 0xa7, 0x1c, 0xc7, 0x1a, 0x4e, 0xac, 0xb1, 0x89, 0x60, 0x4d, 0x52, 0x16, 0xcb}: "EfiIioUdsProtocolGuid",
		efi.GUID{0x60, 0xde, 0xd7, 0x6b, 0xf7, 0x9e, 0x99, 0x48, 0x97, 0xd0, 0xab, 0xff, 0xfd, 0xe9, 0x70, 0xf2}: "EfiCryptoPkgTokenSpace",
		efi.GUID{0x60, 0xdf, 0x8b, 0x4c, 0x85, 0x20, 0x77, 0x45, 0x8a, 0x46, 0x96, 0xcb, 0x18, 0x09, 0x67, 0xbc}: "Tpm20Acpi",
		efi.GUID{0x60, 0xe0, 0xfd, 0xbd, 0x41, 0x7e, 0xae, 0x4e, 0xad, 0x9b, 0xe5, 0xbb, 0xa7, 0xa4, 0x8a, 0x3a}: "EfiDevicePathPropertyDatabase",
		efi.GUID{0x60, 0xe8, 0x24, 0x7e, 0x2c, 0xa6, 0x12, 0x43, 0x82, 0xf2, 0xe7, 0xb5, 0x8d, 0x05, 0x37, 0xc9}: "SceBootOrderSaveRestore",
		efi.GUID{0x60, 0xf0, 0x1f, 0xb3, 0x63, 0x83, 0xdf, 0x11, 0x83, 0x95, 0x08, 0x00, 0x20, 0x0c, 0x9a, 0x66}: "SystemAhciBusSmm",
		efi.GUID{0x60, 0xfc, 0x72, 0x2b, 0x4f, 0x6d, 0xd5, 0x42, 0x8f, 0xf0, 0xab, 0xef, 0xd5, 0xcd, 0xf8, 0x59}: "HDCPSwSmi",
		efi.GUID{0x61, 0x00, 0x71, 0x3e, 0x7a, 0x64, 0x03, 0x4c, 0xbe, 0x85, 0xfa, 0xd6, 0xcc, 0xfa, 0x5a, 0x18}: "PcPassword",
		efi.GUID{0x61, 0x08, 0xb3, 0x7f, 0x41, 0x89, 0x48, 0x47, 0x95, 0x3a, 0x2c, 0x59, 0xd9, 0x3f, 0x91, 0x71}: "BiosConnectUiManager",
		efi.GUID{0x61, 0x14, 0x72, 0xd3, 0x24, 0xfc, 0x3e, 0x44, 0xb4, 0x86, 0x72, 0x4c, 0x9b, 0x5a, 0x2f, 0x70}: "MemTestDxe",
		efi.GUID{0x61, 0x35, 0x1c, 0xdb, 0x9e, 0x4f, 0x48, 0x47, 0xa8, 0x07, 0xbc, 0xbe, 0x7f, 0xa9, 0x2f, 0xc9}: "EzConfig",
		efi.GUID{0x61, 0x40, 0x8a, 0x2b, 0x31, 0x91, 0x2a, 0x4d, 0xa2, 0x0b, 0xd8, 0x45, 0xd0, 0xeb, 0x1d, 0x83}: "Smbrun",
		efi.GUID{0x61, 0x41, 0x81, 0x0a, 0x67, 0xde, 0xe7, 0x46, 0xa8, 0x13, 0xb7, 0xf8, 0xf4, 0x89, 0xaf, 0xcd}: "UpdateSmbios",
		efi.GUID{0x61, 0x43, 0xda, 0x84, 0x8a, 0xee, 0x69, 0x47, 0x93, 0x68, 0x4f, 0x28, 0xa1, 0xc9, 0x20, 0x32}: "EfiBxtTokenSpaceGuid",
		efi.GUID{0x61, 0x4c, 0xe4, 0x7e, 0xda, 0xad, 0x27, 0x4d, 0xa4, 0xa3, 0xa5, 0x61, 0x5c, 0x16, 0xc6, 0x44}: "MemoryInit",
		efi.GUID{0x61, 0x50, 0xdd, 0xea, 0xef, 0x93, 0xcc, 0x4c, 0x84, 0x50, 0xf7, 0x8a, 0x7f, 0x08, 0x20, 0xf0}: "Tcg2ConfigPei",
		efi.GUID{0x61, 0x53, 0xb3, 0x58, 0x22, 0x89, 0xbc, 0x41, 0xb3, 0x13, 0xef, 0x7e, 0xd9, 0xad, 0xfd, 0xf7}: "SecMigrationPei",
		efi.GUID{0x61, 0x5d, 0x80, 0x46, 0xb8, 0x0b, 0x80, 0x46, 0xa9, 0xbe, 0xc9, 0x6c, 0x75, 0x1a, 0xb5, 0xa4}: "BaseIpmiLibNull",
		efi.GUID{0x61, 0x61, 0xd9, 0xfd, 0x65, 0x9e, 0x2b, 0x48, 0xb7, 0xbe, 0x4b, 0x2f, 0x40, 0x97, 0x44, 0x15}: "FjBootOptionDxe",
		efi.GUID{0x61, 0x65, 0x18, 0xb4, 0x67, 0x89, 0x13, 0x41, 0xbc, 0x5f, 0x28, 0x4b, 0x76, 0x70, 0xc4, 0xa0}: "DellDxeDelay",
		efi.GUID{0x61, 0x6e, 0xf3, 0xcb, 0xd3, 0x59, 0xe8, 0x11, 0x85, 0x18, 0xb0, 0x5a, 0xda, 0xeb, 0x78, 0x86}: "NvdimmLostPassphraserecoveryDxe",
		efi.GUID{0x61, 0x87, 0x19, 0x5c, 0xa8, 0x16, 0x69, 0x4e, 0x97, 0x2c, 0x89, 0xd6, 0x79, 0x54, 0xf8, 0x1d}: "EfiDriverSupportedEfiVersionProtocolGuid",
		efi.GUID{0x61, 0x8e, 0x1b, 0x2e, 0x16, 0x9d, 0x6b, 0x46, 0xa8, 0x02, 0x3b, 0x1e, 0x92, 0xea, 0x95, 0xec}: "CbsSetupDxeSTP",
		efi.GUID{0x61, 0x91, 0x65, 0xcb, 0x80, 0xb7, 0x06, 0x49, 0x91, 0x4a, 0xdb, 0x57, 0xd1, 0xdd, 0x54, 0x4a}: "EupControl",
		efi.GUID{0x61, 0x9a, 0xb2, 0x98, 0x7f, 0x82, 0x28, 0x4a, 0xb1, 0xae, 0x3b, 0x00, 0xa9, 0x78, 0x53, 0x7e}: "OemPeiSetSetupItemPcd",
		efi.GUID{0x61, 0x9d, 0x37, 0x7a, 0x84, 0x07, 0xdc, 0x40, 0xb2, 0x8e, 0xe9, 0x60, 0x07, 0xcf, 0x30, 0xf1}: "LegacyUsbSmm",
		efi.GUID{0x61, 0xa7, 0x99, 0xf7, 0xc3, 0x2f, 0x40, 0x42, 0x92, 0xf1, 0xfe, 0x45, 0x7d, 0xc2, 0xfb, 0xbd}: "SpdPlatformInfoSmm",
		efi.GUID{0x61, 0xab, 0x2e, 0xec, 0xb5, 0xef, 0x80, 0x4a, 0x83, 0x91, 0x87, 0x79, 0xc1, 0xc2, 0x50, 0x7a}: "PlatformSecureBiosSmm",
		efi.GUID{0x61, 0xaf, 0x89, 0x2e, 0x76, 0x6e, 0xe6, 0x42, 0x8f, 0x3e, 0xbc, 0xee, 0x83, 0xc9, 0x52, 0x6e}: "H19ServiceBodySmm",
		efi.GUID{0x61, 0xbd, 0x59, 0x97, 0x1e, 0xf1, 0xee, 0x4f, 0x90, 0x04, 0x1e, 0x8c, 0x88, 0xe7, 0x22, 0x23}: "gear10",
		efi.GUID{0x61, 0xca, 0xe9, 0x96, 0x2e, 0x6c, 0xf3, 0x4f, 0xb2, 0x65, 0xf2, 0x19, 0x04, 0xc4, 0x41, 0x81}: "CbsSetupSmmSTP",
		efi.GUID{0x61, 0xdd, 0x51, 0x99, 0xa0, 0x4e, 0x47, 0x4d, 0xf5, 0x40, 0x40, 0xb4, 0xe4, 0x45, 0x35, 0x07}: "DellTouchPadHid",
		efi.GUID{0x61, 0xdf, 0xe4, 0x8b, 0xca, 0x93, 0xd2, 0x11, 0xaa, 0x0d, 0x00, 0xe0, 0x98, 0x03, 0x2b, 0x8c}: "EfiGlobalVariableGuid",
		efi.GUID{0x61, 0xe7, 0xc5, 0x15, 0xd8, 0x58, 0x1a, 0x46, 0x91, 0x73, 0xca, 0xb0, 0x20, 0x91, 0x62, 0x64}: "VAminiPort",
		efi.GUID{0x61, 0xea, 0xa9, 0x71, 0x35, 0x5a, 0x5d, 0x4a, 0xac, 0xef, 0x9c, 0xf8, 0x6d, 0x6d, 0x67, 0xe0}: "EdkiiPeiCapsuleOnDiskPpi",
		efi.GUID{0x61, 0xea, 0xbd, 0x96, 0x64, 0xc3, 0x13, 0x45, 0xb6, 0xb3, 0x03, 0x7e, 0x9a, 0xd5, 0x4c, 0xe4}: "SetSsidSvidDxe",
		efi.GUID{0x61, 0xec, 0x33, 0x24, 0xbe, 0x17, 0x98, 0x4b, 0x89, 0x5c, 0x33, 0x39, 0x50, 0xc6, 0x23, 0x18}: "RtkUndiDxe_2057",
		efi.GUID{0x61, 0xed, 0x56, 0x64, 0x79, 0x35, 0xc9, 0x41, 0x8a, 0x26, 0x0a, 0x0b, 0xd6, 0x2b, 0x78, 0xfc}: "Ip4IScsiConfigGuid",
		efi.GUID{0x61, 0xf3, 0x09, 0xf1, 0x0c, 0x37, 0x9c, 0x4d, 0xb1, 0xab, 0x7c, 0xa2, 0xd4, 0xc8, 0xb3, 0xff}: "AmiCpuInfoProtocol",
		efi.GUID{0x61, 0xf5, 0x53, 0xa0, 0x6b, 0xf5, 0x40, 0x41, 0x89, 0x01, 0xb4, 0xcb, 0x5d, 0x70, 0x92, 0x9e}: "BootScriptThunkGuid",
		efi.GUID{0x61, 0xf6, 0x9b, 0x4e, 0x91, 0x48, 0xdf, 0xf0, 0x27, 0x18, 0x2e, 0xb4, 0x1e, 0xab, 0x5e, 0x43}: "CpuPowerManagementSmm",
		efi.GUID{0x61, 0xf7, 0x31, 0xb8, 0xbb, 0xac, 0xb7, 0x49, 0xa5, 0xd4, 0xef, 0x4b, 0x77, 0x50, 0x2a, 0x9e}: "SmbiosDataUpdateDxeBlizzard",
		efi.GUID{0x61, 0xff, 0x28, 0xee, 0x60, 0xb9, 0xeb, 0x47, 0xb6, 0xba, 0x1f, 0x5e, 0xfb, 0xda, 0xb4, 0x42}: "OemTpmTypeDxe",
		efi.GUID{0x62, 0x01, 0xd6, 0x0f, 0x35, 0xa2, 0xd3, 0x47, 0xbf, 0x7e, 0x73, 0x5e, 0x02, 0x7d, 0x48, 0xb2}: "AmdFabricRmbSmm",
		efi.GUID{0x62, 0x13, 0xe1, 0xb0, 0xda, 0x00, 0x11, 0x46, 0x8d, 0x7d, 0x10, 0xef, 0x25, 0x27, 0xf6, 0x53}: "VideoBiosDataBlock",
		efi.GUID{0x62, 0x17, 0x1b, 0xf8, 0x83, 0xb7, 0x64, 0x4e, 0xaa, 0xe3, 0xbe, 0x61, 0xb5, 0xa9, 0x03, 0x9f}: "AmdNbioBaseCZDxe",
		efi.GUID{0x62, 0x19, 0xb1, 0x72, 0x59, 0x57, 0x75, 0x49, 0xae, 0x95, 0xf8, 0xc3, 0xfe, 0x55, 0xef, 0x1d}: "PchSmbusSmm",
		efi.GUID{0x62, 0x1b, 0xff, 0xda, 0x7a, 0xa6, 0x11, 0x4e, 0x8b, 0x57, 0x49, 0x6b, 0x57, 0x2e, 0x07, 0x75}: "SystemLoadDefaultDxe",
		efi.GUID{0x62, 0x34, 0xcd, 0x81, 0x1a, 0x6a, 0xf8, 0x42, 0x82, 0x9b, 0x8d, 0x77, 0x48, 0x1d, 0xdb, 0x64}: "AmiPciExpressGen2LibNull",
		efi.GUID{0x62, 0x36, 0xbc, 0xdc, 0xda, 0x9c, 0x52, 0x4b, 0xa0, 0x4c, 0x82, 0xeb, 0x1d, 0x23, 0x48, 0xc7}: "EfiKmsFormatMd5128Guid",
		efi.GUID{0x62, 0x44, 0xba, 0x95, 0xf0, 0x7e, 0xa3, 0x49, 0x97, 0x02, 0x68, 0x96, 0xc3, 0x9e, 0x41, 0x4c}: "CbsSetupDxePHX",
		efi.GUID{0x62, 0x48, 0xa3, 0x1a, 0xd3, 0xc1, 0xd1, 0x49, 0x92, 0x81, 0x9f, 0x26, 0x15, 0x45, 0xc0, 0x9c}: "FjSystemDataFvDriverSmm",
		efi.GUID{0x62, 0x4c, 0x9e, 0x68, 0xbf, 0x70, 0xf3, 0x4c, 0x88, 0xbb, 0x33, 0xb3, 0x18, 0x26, 0x86, 0x70}: "EfiBlockIoCryptoAlgoAesCbcMsBitlockerGuid",
		efi.GUID{0x62, 0x4d, 0x8c, 0x34, 0xbd, 0xbf, 0x82, 0x48, 0x9e, 0xce, 0xc8, 0x0b, 0xb1, 0xc4, 0x78, 0x3b}: "HiiDatabase",
		efi.GUID{0x62, 0x4f, 0x14, 0x47, 0x23, 0xb4, 0x24, 0x45, 0xac, 0x6a, 0x90, 0x10, 0x6b, 0xaa, 0x89, 0xfb}: "AmiTpm20MeasureConfigurationInfoGuid",
		efi.GUID{0x62, 0x4f, 0x58, 0x27, 0x26, 0x1a, 0xba, 0x41, 0x85, 0xbe, 0x74, 0xc0, 0xee, 0xff, 0x46, 0xae}: "LANMacInfoDxe",
		efi.GUID{0x62, 0x54, 0x34, 0x1f, 0xa5, 0xce, 0xdd, 0x4a, 0x9c, 0x43, 0x5c, 0xa6, 0x72, 0x0b, 0x9d, 0xa6}: "IrqBoardInfoRvp",
		efi.GUID{0x62, 0x54, 0xee, 0x10, 0x07, 0xb2, 0x4f, 0x4a, 0xab, 0xd8, 0xcb, 0x52, 0x2e, 0xca, 0xa3, 0xa4}: "Udp4Dxe",
		efi.GUID{0x62, 0x58, 0x9a, 0x36, 0xde, 0x06, 0xc6, 0x49, 0xa2, 0xa5, 0x17, 0xb8, 0xa9, 0x66, 0x49, 0x84}: "TouchPad_Synaptics",
		efi.GUID{0x62, 0x62, 0xc7, 0x87, 0xf3, 0xf1, 0x52, 0x44, 0xb8, 0x05, 0x47, 0x43, 0x8a, 0x67, 0x93, 0xa7}: "SgDxePolicyInit",
		efi.GUID{0x62, 0x64, 0x91, 0x66, 0x93, 0x1f, 0x06, 0x4c, 0xab, 0x1f, 0xf0, 0xf6, 0x35, 0x83, 0xb9, 0x16}: "OemDptf",
		efi.GUID{0x62, 0x72, 0x84, 0x36, 0xfa, 0x75, 0x54, 0x45, 0xab, 0xab, 0xcc, 0x02, 0xdf, 0x68, 0x45, 0xd7}: "RtkWLanDriver",
		efi.GUID{0x62, 0x7c, 0x7e, 0xa2, 0x9f, 0x24, 0x7b, 0x4b, 0xbd, 0x5c, 0x80, 0x72, 0x02, 0x03, 0x5d, 0xec}: "DellFlashUpdatePei",
		efi.GUID{0x62, 0x7e, 0x98, 0x55, 0xf6, 0x1d, 0xd1, 0x41, 0x90, 0x62, 0x33, 0x4f, 0xca, 0xc3, 0xe5, 0x4d}: "GraphicsSplitter",
		efi.GUID{0x62, 0x7f, 0xdd, 0xe9, 0xec, 0x25, 0x9d, 0x4f, 0xa4, 0xab, 0xaa, 0xd2, 0x0b, 0xf5, 0x9a, 0x10}: "StatusCodePei",
		efi.GUID{0x62, 0x81, 0x00, 0x40, 0xd0, 0x93, 0xf2, 0x48, 0x80, 0xda, 0x7e, 0x32, 0xf4, 0xc9, 0x8f, 0x8b}: "Udp6Dxe",
		efi.GUID{0x62, 0x81, 0x8c, 0x3b, 0x8c, 0x18, 0xa4, 0x46, 0xae, 0xc9, 0xbe, 0x43, 0xf1, 0xd6, 0x56, 0x97}: "EfiFwDisplayCapsuleGuid",
		efi.GUID{0x62, 0x84, 0x76, 0xb2, 0xe4, 0x14, 0x8f, 0x4b, 0xaf, 0xb0, 0xb2, 0x74, 0xb3, 0x67, 0xba, 0xf0}: "LoadSetupDefaultDxe",
		efi.GUID{0x62, 0x91, 0x18, 0xab, 0xb5, 0x6d, 0xfc, 0x4e, 0xac, 0x59, 0xd0, 0xb3, 0xcc, 0x85, 0x11, 0x19}: "OemEarlyPei",
		efi.GUID{0x62, 0x91, 0xa7, 0xa6, 0x25, 0xe3, 0x30, 0x4c, 0xbc, 0xc3, 0x59, 0x37, 0x30, 0x64, 0xef, 0xb3}: "EfiTcoResetProtocolGuid",
		efi.GUID{0x62, 0x93, 0xd0, 0x17, 0x6c, 0x32, 0x20, 0x49, 0xa5, 0x0c, 0x76, 0xf8, 0xa1, 0x16, 0xa0, 0x93}: "SeCPolicyInitDxe",
		efi.GUID{0x62, 0x98, 0x1e, 0xc4, 0x78, 0xd0, 0x7d, 0x4e, 0x90, 0x62, 0x00, 0xe3, 0xfa, 0xc3, 0x4c, 0x19}: "AsusEcPei",
		efi.GUID{0x62, 0xa2, 0x22, 0xb1, 0x51, 0x35, 0x48, 0x4f, 0x88, 0x92, 0x55, 0xf6, 0xc0, 0x61, 0x42, 0x90}: "EfiFirmwareClassGuid",
		efi.GUID{0x62, 0xa6, 0xfd, 0x6a, 0xb0, 0xbf, 0xb8, 0x43, 0x98, 0x48, 0xb6, 0x7d, 0xcd, 0x45, 0x21, 0x57}: "EcdShellApp",
		efi.GUID{0x62, 0xa9, 0xa3, 0xa6, 0x91, 0xc5, 0x01, 0x47, 0x9d, 0x25, 0x73, 0xd0, 0x22, 0x6d, 0x89, 0xdc}: "PeiRamBootCacheRdy",
		efi.GUID{0x62, 0xac, 0x7e, 0xa9, 0x1a, 0x6f, 0x05, 0x4b, 0x8c, 0xfb, 0x65, 0xb1, 0xce, 0x7d, 0x6a, 0x3c}: "BiosVideoDxe",
		efi.GUID{0x62, 0xac, 0xf2, 0xf5, 0x32, 0x62, 0x5c, 0x44, 0xb3, 0x22, 0x59, 0x69, 0xa0, 0x83, 0x98, 0x0c}: "MAPS_SIO_InterfaceDxe",
		efi.GUID{0x62, 0xae, 0x57, 0x8e, 0xdc, 0x99, 0x12, 0x4f, 0xac, 0xb7, 0x21, 0x6e, 0x2d, 0xd0, 0x31, 0xad}: "DxeCrcInit",
		efi.GUID{0x62, 0xb1, 0x56, 0x43, 0xb2, 0xd0, 0xe1, 0x11, 0x89, 0x52, 0x44, 0x37, 0xe6, 0xa6, 0x0e, 0xa5}: "Lan9118Dxe",
		efi.GUID{0x62, 0xb1, 0x98, 0xfd, 0xba, 0x41, 0x9e, 0x4c, 0x98, 0x2e, 0x02, 0x36, 0x99, 0xde, 0x02, 0xf0}: "DellEcPolicy3",
		efi.GUID{0x62, 0xb2, 0x2b, 0xd5, 0x22, 0xf0, 0xec, 0x49, 0x86, 0xd2, 0x7a, 0x29, 0x3a, 0x7a, 0x05, 0x4b}: "PchAcpiSmiDispatchProtocol",
		efi.GUID{0x62, 0xb2, 0xf5, 0x31, 0x9e, 0x7d, 0xcc, 0x4f, 0x9b, 0xb8, 0x0e, 0x41, 0x5d, 0x0c, 0xd7, 0x48}: "BFGPei",
		efi.GUID{0x62, 0xb3, 0x72, 0xcd, 0x6f, 0x8a, 0x99, 0x46, 0xaf, 0x55, 0x03, 0xfd, 0x89, 0x24, 0xc5, 0x06}: "HpRpsuDefaultsAndWmi",
		efi.GUID{0x62, 0xc1, 0x4c, 0xaf, 0x1c, 0xd4, 0x5a, 0x45, 0xab, 0x45, 0x6d, 0xbc, 0xc1, 0xcd, 0x32, 0xf3}: "LpssDummyProtocolGuid",
		efi.GUID{0x62, 0xc8, 0x4f, 0xe4, 0xdf, 0x12, 0x4b, 0x4d, 0x95, 0x11, 0x93, 0x80, 0x25, 0x14, 0xaa, 0xf8}: "RomHoleReplacementProtocolSmm",
		efi.GUID{0x62, 0xc8, 0xdc, 0xd7, 0xa0, 0xa2, 0xda, 0x4c, 0xb1, 0x8e, 0x44, 0x77, 0xd2, 0xfe, 0x49, 0xe3}: "RadioExecSmm",
		efi.GUID{0x62, 0xcd, 0xe4, 0x9e, 0xa7, 0x7f, 0x83, 0x41, 0x90, 0x12, 0xf6, 0xc4, 0xcf, 0x6e, 0x2c, 0x7d}: "NVBIOSINFO",
		efi.GUID{0x62, 0xcf, 0xca, 0xe3, 0x62, 0x30, 0x1d, 0x4e, 0x97, 0x8e, 0x46, 0x80, 0x7a, 0xb9, 0x74, 0x7d}: "PlatformConfigChangeGuid",
		efi.GUID{0x62, 0xdd, 0x87, 0xba, 0x60, 0xab, 0xde, 0x46, 0x8f, 0xd8, 0x02, 0x35, 0x10, 0xd5, 0x2d, 0x11}: "gear12",
		efi.GUID{0x62, 0xdd, 0xaf, 0xb7, 0x29, 0x3e, 0xf9, 0x4f, 0x92, 0x36, 0x3a, 0xab, 0x2a, 0x8c, 0x82, 0xf2}: "AmdSmmControl",
		efi.GUID{0x62, 0xe9, 0xea, 0xe2, 0x92, 0xc4, 0xa4, 0x4c, 0xa1, 0x1f, 0x1a, 0x7c, 0xbb, 0x05, 0x0a, 0x41}: "English",
		efi.GUID{0x62, 0xed, 0x63, 0xfc, 0x9d, 0x94, 0xb0, 0x4f, 0xb7, 0x54, 0xd5, 0x58, 0xa6, 0x36, 0x7c, 0x56}: "EzFlashDxe",
		efi.GUID{0x62, 0xf7, 0xf9, 0x2e, 0x28, 0x43, 0x06, 0x84, 0x2a, 0x59, 0x62, 0xb9, 0x72, 0x9a, 0x60, 0x7b}: "DashUi",
		efi.GUID{0x62, 0xfe, 0x0a, 0x32, 0x93, 0xe5, 0xcb, 0x49, 0xa9, 0xf1, 0xd4, 0xc2, 0xf4, 0xaf, 0x01, 0x4c}: "EfiS3SmmSaveStateProtocolGuid",
		efi.GUID{0x63, 0x01, 0xea, 0xab, 0x72, 0xa4, 0x52, 0x41, 0x9a, 0x07, 0x2e, 0x95, 0x4c, 0x23, 0x0f, 0xf5}: "OemPei",
		efi.GUID{0x63, 0x02, 0x32, 0xba, 0xd4, 0xff, 0xa5, 0x4d, 0xa6, 0x17, 0xd8, 0x32, 0x19, 0x3e, 0x83, 0x5e}: "AmdRasRsServiceSmm",
		efi.GUID{0x63, 0x13, 0xcc, 0xee, 0x4b, 0x88, 0xe4, 0x4f, 0xa7, 0x63, 0xb3, 0x87, 0x95, 0x1b, 0x6d, 0xdd}: "SbSocMatisseDxe",
		efi.GUID{0x63, 0x14, 0xcb, 0xab, 0x75, 0x32, 0x96, 0x4b, 0x9c, 0xbb, 0xab, 0xbd, 0xff, 0x4a, 0xed, 0xbe}: "MultiLanguageDxe",
		efi.GUID{0x63, 0x14, 0xcd, 0x6e, 0x4a, 0x4a, 0x1b, 0x46, 0xaf, 0x5f, 0x5a, 0x33, 0xe3, 0xb2, 0x16, 0x2b}: "EfiPeiGraphicsPpiGuid",
		efi.GUID{0x63, 0x14, 0xea, 0x63, 0xfa, 0xfb, 0x8a, 0x42, 0xb9, 0x7f, 0xe2, 0x22, 0x75, 0x58, 0x52, 0xd7}: "HighMemDxe",
		efi.GUID{0x63, 0x18, 0xf6, 0xe4, 0x2c, 0xfe, 0x56, 0x4b, 0xa8, 0xf4, 0x08, 0x51, 0x9b, 0xc4, 0x39, 0xdf}: "VlanConfigDxe",
		efi.GUID{0x63, 0x1a, 0x55, 0x2e, 0xf8, 0xe2, 0x01, 0x44, 0xb6, 0x17, 0xec, 0xde, 0x23, 0x38, 0x46, 0x3c}: "PlatformMilestoneHookDxe",
		efi.GUID{0x63, 0x2e, 0x29, 0x57, 0xd0, 0x5b, 0x87, 0x47, 0xac, 0x14, 0x43, 0xe6, 0xb0, 0xa1, 0x51, 0x5b}: "OememSmi",
		efi.GUID{0x63, 0x30, 0x9b, 0x57, 0x14, 0x81, 0xcd, 0x4f, 0x9d, 0xf1, 0x0e, 0x45, 0x19, 0xaf, 0x77, 0x44}: "ShellResolution",
		efi.GUID{0x63, 0x30, 0xd7, 0x7c, 0x6e, 0x54, 0x09, 0x4c, 0xab, 0xd2, 0x11, 0xc6, 0xb0, 0x4a, 0xcc, 0x4e}: "SataPowerManagementSmm",
		efi.GUID{0x63, 0x34, 0xa4, 0x4e, 0x7c, 0x74, 0xeb, 0x46, 0x97, 0xfb, 0xb0, 0xe5, 0xc5, 0xf0, 0x53, 0x06}: "UsbMouseAbsolutePointerDxe",
		efi.GUID{0x63, 0x39, 0x75, 0xc5, 0x84, 0x3b, 0x95, 0x40, 0xbf, 0x78, 0xed, 0xda, 0xd3, 0xf9, 0xc9, 0xdd}: "EfiPciBusErrorSectionGuid",
		efi.GUID{0x63, 0x4b, 0x27, 0xc3, 0xe0, 0xad, 0x4c, 0x41, 0xbc, 0x43, 0x12, 0xab, 0x92, 0x6c, 0x63, 0x4b}: "IdeBusPei",
		efi.GUID{0x63, 0x4c, 0xf6, 0xe8, 0xa3, 0x03, 0xc9, 0x40, 0xad, 0x3f, 0xbc, 0x32, 0x0f, 0x85, 0x05, 0xc3}: "PlatformFirmwareVersionInfo",
		efi.GUID{0x63, 0x4e, 0x08, 0xb7, 0xb7, 0x46, 0x1a, 0x4d, 0x86, 0x77, 0xe3, 0x0b, 0x53, 0xdb, 0xf0, 0x50}: "EfiFrameworkDevicePath",
		efi.GUID{0x63, 0x4f, 0xa7, 0x21, 0x10, 0xca, 0xc6, 0x4d, 0xa4, 0xeb, 0x36, 0xc9, 0x3b, 0x9a, 0x06, 0x3a}: "PlatformFlashSmmProtocol",
		efi.GUID{0x63, 0x5a, 0x9e, 0x7c, 0x87, 0xb9, 0x5e, 0x43, 0xb1, 0x7f, 0x9e, 0x9c, 0xfa, 0x53, 0xf8, 0x80}: "SmmPlatform",
		efi.GUID{0x63, 0x75, 0xe3, 0xdb, 0xef, 0xaf, 0x41, 0x4b, 0xbd, 0xce, 0xb0, 0x1b, 0x6d, 0x1e, 0x86, 0x90}: "Tpm12DeviceLibInfineonI2c",
		efi.GUID{0x63, 0x76, 0xcc, 0xa2, 0x7c, 0x4d, 0x8a, 0x44, 0xaa, 0xb5, 0x4c, 0x03, 0x4b, 0x6f, 0xda, 0xb7}: "rmHwA5Guid",
		efi.GUID{0x63, 0x7d, 0x33, 0x5d, 0x77, 0x26, 0x68, 0x48, 0x82, 0x51, 0xb9, 0x7c, 0x6d, 0x1f, 0x0e, 0x90}: "YukonEthernet",
		efi.GUID{0x63, 0x88, 0xac, 0x45, 0xfa, 0xe3, 0x38, 0x4a, 0xa2, 0x3c, 0x00, 0xbc, 0xd1, 0x0c, 0xbd, 0x50}: "AmiNvramSmmCommunicationGuid",
		efi.GUID{0x63, 0x89, 0xa0, 0xec, 0xa3, 0x33, 0x8c, 0x40, 0x8f, 0xde, 0x7e, 0x67, 0xa5, 0x1f, 0x45, 0xab}: "D01UsttCallback",
		efi.GUID{0x63, 0x8b, 0xb0, 0x9b, 0x56, 0x77, 0x1d, 0x4d, 0xb7, 0xf6, 0xb9, 0xbc, 0x23, 0x71, 0xf3, 0x3f}: "SioEasyCleanWmiSmm",
		efi.GUID{0x63, 0x8c, 0xb9, 0xa1, 0x32, 0x70, 0xd7, 0x4e, 0x8c, 0xf2, 0x81, 0x69, 0xd2, 0x78, 0x8b, 0xa8}: "SpecificResetProtocolDxe",
		efi.GUID{0x63, 0x92, 0x1c, 0xd7, 0x64, 0x2e, 0xf9, 0x40, 0x82, 0xb8, 0xf2, 0x5b, 0x27, 0x06, 0x9d, 0x4f}: "EnePEI",
		efi.GUID{0x63, 0x92, 0x26, 0x67, 0xf1, 0x0a, 0xdd, 0x45, 0x93, 0xc8, 0x29, 0x99, 0x21, 0xd0, 0xe1, 0xe9}: "SmbiosUpdateDataProtocolGuid",
		efi.GUID{0x63, 0xa2, 0x22, 0xb1, 0x61, 0x36, 0x68, 0x4f, 0x99, 0x29, 0x78, 0xf8, 0xb0, 0xd6, 0x21, 0x80}: "EfiSystemResourceTableGuid",
		efi.GUID{0x63, 0xaa, 0xe3, 0xca, 0x6f, 0x67, 0xa3, 0x4d, 0xbd, 0x50, 0x6c, 0xc5, 0xed, 0xde, 0x9a, 0xad}: "EdkiiPeiNvmExpressHostControllerPpi",
		efi.GUID{0x63, 0xaf, 0x2d, 0x0e, 0x4f, 0x8a, 0x26, 0x40, 0xa8, 0x99, 0xde, 0x2d, 0x7f, 0x46, 0xe5, 0xec}: "TpvPei",
		efi.GUID{0x63, 0xb0, 0x92, 0xe4, 0x46, 0xe8, 0x10, 0x48, 0xa9, 0x68, 0x01, 0xbc, 0x24, 0x33, 0x97, 0x74}: "DellSmmEventProtocol",
		efi.GUID{0x63, 0xbf, 0x6d, 0x44, 0x02, 0x25, 0xda, 0x4c, 0xbc, 0xfa, 0x24, 0x65, 0xd2, 0xb0, 0xfe, 0x9d}: "EfiCertX509Sha512Guid",
		efi.GUID{0x63, 0xc1, 0x35, 0x3e, 0x74, 0x40, 0xdd, 0x45, 0x43, 0x1e, 0x23, 0x98, 0x9d, 0xd8, 0x6b, 0x32}: "EfiHttpUtilitiesProtocolGuid",
		efi.GUID{0x63, 0xc6, 0x56, 0xd2, 0x0f, 0x1e, 0x04, 0x47, 0xa7, 0x6a, 0x94, 0xce, 0xed, 0x7c, 0x16, 0xde}: "FjDtPlatformSmbiosDxe",
		efi.GUID{0x63, 0xca, 0xa2, 0x08, 0x65, 0x3b, 0x2c, 0x47, 0x87, 0x4e, 0x5e, 0x13, 0x8e, 0x94, 0x73, 0x24}: "AsusEcDxeRt",
		efi.GUID{0x63, 0xcc, 0x7c, 0x31, 0xe4, 0xfd, 0xce, 0x48, 0xba, 0x03, 0xd0, 0x8c, 0xd4, 0x55, 0x67, 0xcc}: "AtaDeviceDriverPei",
		efi.GUID{0x63, 0xcf, 0x69, 0x62, 0x37, 0x07, 0xbf, 0x46, 0x80, 0xad, 0x9a, 0x03, 0x5f, 0x76, 0x12, 0x7e}: "PowerFailureRecoverySmm",
		efi.GUID{0x63, 0xd2, 0x81, 0x0c, 0xe3, 0x7c, 0x61, 0x4f, 0xa1, 0x75, 0xfd, 0xa4, 0xfd, 0x24, 0x09, 0x85}: "HpAltModePei",
		efi.GUID{0x63, 0xd8, 0x04, 0x56, 0x24, 0xbf, 0x9b, 0x43, 0xbb, 0xf6, 0x63, 0x6d, 0x72, 0x03, 0x6e, 0x07}: "SpiUtil",
		efi.GUID{0x63, 0xde, 0x53, 0x13, 0x4a, 0xb7, 0xef, 0x4b, 0x80, 0xfd, 0x2c, 0x5c, 0xfa, 0x83, 0x04, 0x0b}: "GifDecoderDxe",
		efi.GUID{0x63, 0xe6, 0x62, 0xbb, 0x5d, 0x62, 0xb2, 0x40, 0xa0, 0x88, 0xbb, 0xe8, 0x36, 0x23, 0xa2, 0x45}: "EfiEapManagementProtocolGuid",
		efi.GUID{0x63, 0xe7, 0x1e, 0x6a, 0x7a, 0xd4, 0xb4, 0x43, 0xaa, 0xbe, 0xef, 0x1d, 0xe2, 0xab, 0x56, 0xfc}: "EfiHiiPackageListProtocolGuid",
		efi.GUID{0x63, 0xea, 0x0c, 0x9d, 0x5b, 0x74, 0x7d, 0x41, 0xbb, 0xa4, 0xe5, 0x19, 0x30, 0x61, 0xc9, 0x07}: "DxeFrb",
		efi.GUID{0x63, 0xea, 0x15, 0x10, 0x21, 0x74, 0x7d, 0x41, 0xbb, 0x51, 0xe5, 0x19, 0x30, 0x61, 0xc5, 0x51}: "DxeIpmiUsb",
		efi.GUID{0x63, 0xed, 0xe6, 0x58, 0x94, 0x16, 0x0b, 0x44, 0x93, 0x88, 0xe9, 0x8f, 0xed, 0x6b, 0x65, 0xaf}: "EfiSocketProtocolGuid",
		efi.GUID{0x63, 0xf2, 0x85, 0x6b, 0x84, 0xf5, 0xf8, 0x44, 0xbb, 0x5d, 0xf0, 0x2c, 0x40, 0x79, 0x5d, 0x8e}: "SmmTcgStorageSec",
		efi.GUID{0x64, 0x12, 0x3f, 0xa5, 0xb1, 0x54, 0x07, 0x47, 0x84, 0xf9, 0x32, 0xdc, 0xd5, 0x2f, 0xc5, 0x8c}: "FjExtSmm",
		efi.GUID{0x64, 0x13, 0x81, 0xe5, 0xda, 0xba, 0x1b, 0x4f, 0x9e, 0x3a, 0x67, 0x99, 0xc1, 0xa7, 0x6d, 0xb0}: "DellSetupChangesMngSmm",
		efi.GUID{0x64, 0x14, 0xf0, 0x83, 0xbd, 0x99, 0xe5, 0x45, 0xb3, 0x83, 0xaf, 0x63, 0x05, 0xd8, 0xe9, 0xe6}: "EfiUdp4ServiceBindingProtocolGuid",
		efi.GUID{0x64, 0x18, 0x35, 0xef, 0xf3, 0x16, 0x2f, 0x4a, 0xb5, 0x7d, 0x3b, 0x9b, 0x78, 0x5a, 0x62, 0x48}: "AmdCpmSocAm4RvPei",
		efi.GUID{0x64, 0x1b, 0x44, 0xe2, 0xf4, 0x7e, 0xfe, 0x41, 0xb3, 0xa3, 0x8c, 0xaa, 0x7f, 0x8d, 0x30, 0x17}: "PciPlatform",
		efi.GUID{0x64, 0x23, 0x8b, 0x2d, 0x65, 0xf4, 0x70, 0x4a, 0xb8, 0xab, 0xbb, 0xc7, 0x30, 0xde, 0xdd, 0xbf}: "LCDIdm",
		efi.GUID{0x64, 0x23, 0xbb, 0x42, 0x88, 0xf4, 0xde, 0x45, 0x93, 0x11, 0xe9, 0xe2, 0xcd, 0x37, 0xbd, 0x74}: "RtKbcDriver",
		efi.GUID{0x64, 0x30, 0xc3, 0xaa, 0xd0, 0x9e, 0x89, 0x4b, 0xa5, 0xad, 0x3e, 0xa7, 0x67, 0x96, 0x0b, 0x22}: "FaultTolerantWritePei",
		efi.GUID{0x64, 0x37, 0x9f, 0x11, 0xc2, 0xa7, 0x29, 0x43, 0xb2, 0x5c, 0xe6, 0x30, 0x5e, 0x74, 0x30, 0x49}: "DellSmmSecurityVault",
		efi.GUID{0x64, 0x47, 0xfa, 0xb2, 0x6e, 0x3b, 0xd3, 0x43, 0x91, 0xdf, 0x87, 0xd1, 0x5a, 0x3e, 0x56, 0x68}: "AmiAhciBusProtocolGuid",
		efi.GUID{0x64, 0x52, 0x1d, 0x12, 0x0f, 0x99, 0x16, 0x47, 0x80, 0x61, 0xc2, 0x14, 0x4a, 0x7d, 0x4d, 0x0d}: "DxeDgOpregionInit",
		efi.GUID{0x64, 0x57, 0xb3, 0xb5, 0x0c, 0x46, 0x06, 0x4a, 0x99, 0xfc, 0x77, 0xa1, 0x7c, 0x1b, 0x5c, 0xeb}: "EfiPciOverrideProtocolGuid",
		efi.GUID{0x64, 0x57, 0xfa, 0xb2, 0x6e, 0x3b, 0xd3, 0x43, 0x91, 0xdf, 0x87, 0xd1, 0x5a, 0x3e, 0x56, 0x68}: "AmiAhciSmmProtocolGuid",
		efi.GUID{0x64, 0x58, 0x26, 0xae, 0x5d, 0xcf, 0xa8, 0x41, 0x91, 0x3d, 0x71, 0xc1, 0x55, 0xe7, 0x64, 0x42}: "CpuIoPei",
		efi.GUID{0x64, 0x6d, 0x8e, 0x98, 0xf9, 0xd7, 0xab, 0x4e, 0x84, 0xc5, 0x29, 0xbf, 0x67, 0x7a, 0x6d, 0xac}: "PoweronFromKeyboardPortSmm",
		efi.GUID{0x64, 0x78, 0x28, 0x6b, 0x9c, 0x75, 0xc4, 0x42, 0xb4, 0x35, 0xa7, 0x4a, 0xb6, 0x94, 0xcd, 0x3b}: "SpecialBootStubDxe",
		efi.GUID{0x64, 0x7d, 0x1e, 0x71, 0x31, 0x11, 0x4b, 0x49, 0xa2, 0xd1, 0x84, 0x80, 0x6c, 0xd7, 0x2d, 0x53}: "EfiTcgTreeLogHobGuid",
		efi.GUID{0x64, 0x89, 0xff, 0x60, 0x06, 0xe9, 0xd0, 0x41, 0xaf, 0xed, 0xf2, 0x41, 0xe9, 0x74, 0xe0, 0x8e}: "EfiDxeSmmReadyToLockProtocolGuid",
		efi.GUID{0x64, 0x8c, 0x5f, 0x73, 0x96, 0xd6, 0xd0, 0x44, 0xbd, 0xf2, 0x44, 0x7f, 0xd0, 0x5a, 0x54, 0x06}: "EmbeddedExternalDeviceProtocolGuid",
		efi.GUID{0x64, 0x96, 0xc3, 0xc9, 0xdd, 0x96, 0x5c, 0x4c, 0xaf, 0xd7, 0xcd, 0x65, 0x76, 0x29, 0xcf, 0xb0}: "CpPlatFlashTokenSpace",
		efi.GUID{0x64, 0x98, 0xd8, 0x68, 0xa8, 0xc0, 0x0d, 0x49, 0xbe, 0x18, 0xc8, 0x3d, 0x67, 0x24, 0x09, 0x28}: "SmbiosDataUpdateDxeNeonCityFPGA",
		efi.GUID{0x64, 0x9e, 0x97, 0xa3, 0xe8, 0xac, 0xdc, 0x4d, 0xbc, 0x07, 0x4d, 0x66, 0xb8, 0xfd, 0x09, 0x77}: "EfiIpSec2ProtocolGuid",
		efi.GUID{0x64, 0xb9, 0xf8, 0x66, 0xf1, 0xa3, 0x7b, 0x49, 0xb2, 0x28, 0x26, 0xb8, 0x9e, 0xc3, 0xbd, 0xca}: "AmdDrtmControlPei",
		efi.GUID{0x64, 0xbc, 0xb1, 0x9d, 0xcd, 0xd6, 0x05, 0x40, 0x92, 0x3f, 0x94, 0x04, 0x5b, 0x3f, 0x1f, 0x73}: "SecureBioFw",
		efi.GUID{0x64, 0xc0, 0x40, 0xa3, 0x3c, 0x72, 0x9c, 0x4a, 0xa4, 0xdd, 0xd5, 0xb4, 0x7a, 0x26, 0xfb, 0xb0}: "EsrtManagementProtocolGuid",
		efi.GUID{0x64, 0xce, 0x02, 0xa7, 0x7a, 0xab, 0x8f, 0x49, 0xba, 0xe6, 0xce, 0x18, 0xbb, 0xae, 0x4c, 0x31}: "BrightnessHardwareVbiosSmm",
		efi.GUID{0x64, 0xd1, 0x35, 0xa0, 0xe5, 0x1f, 0xf8, 0x4d, 0xb5, 0xf6, 0x23, 0xf4, 0x2b, 0xfb, 0xec, 0x09}: "SeedProtocolDxe",
		efi.GUID{0x64, 0xd7, 0x7c, 0xce, 0xd9, 0xa1, 0xe5, 0x44, 0x98, 0x57, 0x14, 0xfe, 0xfa, 0xae, 0x96, 0xdd}: "PnpDxe",
		efi.GUID{0x64, 0xd8, 0x9c, 0x1b, 0x7c, 0xda, 0x3e, 0x48, 0x8d, 0x69, 0xd3, 0x5c, 0xb4, 0xad, 0x27, 0xc9}: "EfiWheaPlatformNonStandardErrorSection",
		efi.GUID{0x64, 0xd9, 0x21, 0x1f, 0x7d, 0x80, 0xf4, 0x49, 0xae, 0x4e, 0xf5, 0x26, 0x63, 0xd1, 0xa1, 0x6f}: "FjCryptoDESDxe",
		efi.GUID{0x64, 0xd9, 0xb2, 0x40, 0x11, 0xfe, 0xdc, 0x40, 0x82, 0x83, 0x2e, 0xfb, 0xda, 0x29, 0x53, 0x56}: "FmpDevicePkgTokenSpace",
		efi.GUID{0x64, 0xdd, 0x2a, 0x32, 0x21, 0xfb, 0x64, 0x45, 0xb1, 0x7f, 0x1e, 0x42, 0x91, 0x44, 0x64, 0x15}: "DellRadioUsbLocationsPolicy",
		efi.GUID{0x64, 0xe0, 0x4c, 0x65, 0x6b, 0x77, 0x59, 0x47, 0x98, 0xf5, 0xab, 0x0e, 0xdf, 0x69, 0x2d, 0x0e}: "AmdPspDxeV2Stp",
		efi.GUID{0x64, 0xee, 0xe7, 0xdf, 0xfd, 0xd4, 0x24, 0x44, 0xbf, 0x1f, 0x85, 0xda, 0x52, 0x42, 0x36, 0xfb}: "DellMfgModeDxeDriver",
		efi.GUID{0x64, 0xf8, 0xff, 0xf0, 0x54, 0x84, 0xe5, 0x46, 0x9f, 0x2b, 0xcf, 0x14, 0xf0, 0xa4, 0x1a, 0x48}: "WarmBootSmm",
		efi.GUID{0x64, 0xf9, 0x67, 0x21, 0x98, 0x72, 0x8f, 0x4a, 0x9a, 0x2a, 0xbf, 0xe4, 0x98, 0xd6, 0x00, 0xa8}: "HddReadySmi",
		efi.GUID{0x64, 0xfa, 0x44, 0x4f, 0xd6, 0xa8, 0x19, 0x4c, 0xb6, 0x1d, 0x63, 0x10, 0x9d, 0x77, 0xd3, 0xd2}: "AmiVerifyTcgVariablesGuid",
		efi.GUID{0x65, 0x06, 0x72, 0x00, 0xeb, 0x67, 0x99, 0x4a, 0xba, 0xf7, 0xd3, 0xc3, 0x3a, 0x1c, 0x7c, 0xc9}: "EfiTcp4ServiceBindingProtocolGuid",
		efi.GUID{0x65, 0x09, 0x2b, 0xd5, 0x1a, 0x68, 0xc6, 0x4d, 0x92, 0xc6, 0xb2, 0x0a, 0x30, 0x20, 0x85, 0x98}: "AAFTblPEI",
		efi.GUID{0x65, 0x27, 0xce, 0x3b, 0xd9, 0x74, 0xe2, 0x4f, 0x9f, 0xee, 0xe5, 0x79, 0xc0, 0x6f, 0x73, 0x6b}: "UsbOcUpdateDxeSierra",
		efi.GUID{0x65, 0x28, 0x38, 0xaa, 0xb0, 0x12, 0xe5, 0x44, 0xa7, 0x31, 0x6d, 0xef, 0x4d, 0xf3, 0x4c, 0xe7}: "LenovoPromptService",
		efi.GUID{0x65, 0x3a, 0x1d, 0x23, 0x42, 0x94, 0x07, 0x45, 0xa4, 0xe4, 0xe9, 0xd2, 0x17, 0x65, 0x78, 0xf1}: "DellSmBiosStrucB1",
		efi.GUID{0x65, 0x3e, 0xe3, 0x92, 0xf0, 0x20, 0x5d, 0x45, 0x9d, 0x71, 0x02, 0xc0, 0x9d, 0x50, 0x60, 0xae}: "PciPort",
		efi.GUID{0x65, 0x46, 0x7c, 0xfd, 0xbe, 0x34, 0x6b, 0x42, 0xb1, 0xf8, 0x3a, 0xb7, 0x53, 0xce, 0x44, 0xb0}: "PeiBootScriptDonePpi",
		efi.GUID{0x65, 0x49, 0x57, 0x91, 0xef, 0xa7, 0xc6, 0x4d, 0xad, 0x6a, 0x53, 0x56, 0xcc, 0x21, 0xc5, 0x00}: "DellBootLayerDxe",
		efi.GUID{0x65, 0x50, 0xf9, 0xfb, 0x7f, 0x42, 0xb3, 0x47, 0x80, 0x77, 0xd1, 0x3c, 0x60, 0x71, 0x09, 0x98}: "dbVar",
		efi.GUID{0x65, 0x57, 0x4e, 0xb3, 0x04, 0x2e, 0xaf, 0x4d, 0x86, 0x7f, 0x7f, 0x40, 0xbe, 0x6f, 0xc3, 0x3d}: "ExtFs",
		efi.GUID{0x65, 0x57, 0xc4, 0x6c, 0xe4, 0xcc, 0xfd, 0x42, 0xbc, 0x56, 0x01, 0x1a, 0xaa, 0xc6, 0xc9, 0xa8}: "EfiPeiReset2PpiGuid",
		efi.GUID{0x65, 0x58, 0xe7, 0x52, 0xa4, 0xf4, 0xfa, 0x4f, 0xa9, 0xf0, 0xd3, 0x04, 0x8e, 0xa7, 0x9f, 0x84}: "ThermalPei",
		efi.GUID{0x65, 0x59, 0xf0, 0xce, 0x99, 0xf3, 0xa0, 0x42, 0xa2, 0x26, 0xa3, 0xfe, 0x96, 0xaa, 0x94, 0x4e}: "RedfishHi",
		efi.GUID{0x65, 0x5b, 0x23, 0x5a, 0xa0, 0x4b, 0x97, 0x4a, 0x89, 0xa2, 0xc1, 0x27, 0xde, 0xa1, 0x93, 0xa2}: "AsusOnBoardDimm",
		efi.GUID{0x65, 0x5e, 0x2c, 0x80, 0x7b, 0xd4, 0x1b, 0x46, 0xa4, 0x56, 0x6c, 0x89, 0xc5, 0xcc, 0x3b, 0x30}: "SetVariableToWirelessDeviceDriver",
		efi.GUID{0x65, 0x5e, 0x2c, 0x80, 0x7b, 0xd4, 0x1b, 0x46, 0xa9, 0xd9, 0x6c, 0x89, 0xc5, 0xcc, 0x3a, 0x10}: "DxeRealtekMAC",
		efi.GUID{0x65, 0x5e, 0x2c, 0x88, 0x7b, 0xd3, 0x1b, 0x44, 0xa1, 0xd9, 0x6c, 0x89, 0xc5, 0xcc, 0x3a, 0xe1}: "UsbDonglePei",
		efi.GUID{0x65, 0x60, 0xa6, 0xdf, 0x19, 0xb4, 0xd3, 0x11, 0x9a, 0x2d, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d}: "EfiVT100Guid",
		efi.GUID{0x65, 0x61, 0x62, 0xf8, 0xeb, 0x6c, 0x4a, 0x92, 0xba, 0xfc, 0xf1, 0x3a, 0xb9, 0xd6, 0x57, 0x28}: "EmuSystemConfigGuid",
		efi.GUID{0x65, 0x69, 0x0f, 0x43, 0x69, 0x9a, 0xc5, 0x41, 0x93, 0xed, 0x8b, 0xf0, 0x64, 0x35, 0xc1, 0xc6}: "EdkiiPeiShadowMicrocodePpi",
		efi.GUID{0x65, 0x6d, 0x96, 0x0d, 0x25, 0x8f, 0x74, 0x45, 0x8e, 0xaf, 0x6c, 0x04, 0x63, 0xf3, 0x87, 0x42}: "UsbPortConfigSmm",
		efi.GUID{0x65, 0x7b, 0x8d, 0x37, 0xa9, 0x8d, 0x73, 0x47, 0xb6, 0xe4, 0xa4, 0x78, 0x26, 0xa8, 0x33, 0xe1}: "PcRtc",
		efi.GUID{0x65, 0x7b, 0x8d, 0x37, 0xa9, 0x8d, 0x73, 0x47, 0xb6, 0xe4, 0xa4, 0x78, 0x26, 0xa8, 0x33, 0xe2}: "PcRtcSmm",
		efi.GUID{0x65, 0x7d, 0x75, 0xc0, 0x84, 0x3f, 0x92, 0x25, 0xae, 0xb9, 0x33, 0xd1, 0x9b, 0xab, 0xcc, 0xf7}: "TmpDecFileHolder",
		efi.GUID{0x65, 0x7d, 0x85, 0xe0, 0x84, 0x5f, 0x92, 0x45, 0xae, 0x49, 0x33, 0xd4, 0x9b, 0xa6, 0xcc, 0xf7}: "MeSoftStrapUpdatePei",
		efi.GUID{0x65, 0x8c, 0x88, 0xed, 0x84, 0x2d, 0x95, 0x45, 0x90, 0x86, 0xa1, 0x5a, 0x1f, 0x66, 0xde, 0x2b}: "EnableLsiDecoding",
		efi.GUID{0x65, 0x8e, 0x46, 0x65, 0xf3, 0x77, 0xaa, 0x40, 0xa1, 0x49, 0x32, 0xf2, 0x23, 0xb0, 0xa3, 0xba}: "ControllerDiscoveryPei",
		efi.GUID{0x65, 0x9e, 0x49, 0xa8, 0xf6, 0xa6, 0xb0, 0x48, 0x96, 0xdb, 0x45, 0xc2, 0x66, 0x03, 0x0d, 0x83}: "SiInitPreMemFsp",
		efi.GUID{0x65, 0x9e, 0xd6, 0xaf, 0xb3, 0x1c, 0x2c, 0x47, 0xbe, 0x63, 0x0c, 0x98, 0xa2, 0xc0, 0x66, 0x5c}: "RAIDXpert2_F50_0x00",
		efi.GUID{0x65, 0xaa, 0xed, 0x4a, 0xf5, 0x00, 0xf8, 0x42, 0xb7, 0x37, 0xb6, 0xbd, 0x1a, 0x4b, 0x5c, 0x48}: "FlashUcAcmDxe",
		efi.GUID{0x65, 0xae, 0xfc, 0xba, 0x5c, 0x94, 0x6f, 0x46, 0xff, 0xff, 0xff, 0xff, 0x8b, 0x58, 0x77, 0xa4}: "XnoteReportStatusCodeSmm",
		efi.GUID{0x65, 0xb9, 0xa6, 0xae, 0xf5, 0xdc, 0x11, 0x43, 0xb4, 0xb8, 0x0f, 0x12, 0x46, 0x44, 0x94, 0xd2}: "BootScriptDataGuid",
		efi.GUID{0x65, 0xc6, 0xa1, 0xad, 0x8a, 0x7a, 0x7c, 0x46, 0x84, 0xea, 0x71, 0x72, 0xb2, 0xb6, 0x58, 0x62}: "FchSSSataD3ColdSmm",
		efi.GUID{0x65, 0xcf, 0x23, 0xe2, 0xce, 0xf6, 0x22, 0x41, 0xb3, 0xaf, 0x4b, 0xd1, 0x8a, 0xff, 0x40, 0xa1}: "CpuInfoProtocolGuid",
		efi.GUID{0x65, 0xdc, 0x1c, 0x23, 0x9e, 0x12, 0x70, 0x48, 0xa8, 0x82, 0x79, 0x24, 0x41, 0x27, 0xbd, 0xe3}: "SkipStoragePwdPrompt",
		efi.GUID{0x65, 0xe0, 0xab, 0x08, 0x59, 0xc3, 0x95, 0x4b, 0x8d, 0x59, 0xc1, 0xb5, 0x8e, 0xb6, 0x57, 0xb5}: "IntelLomSmm",
		efi.GUID{0x65, 0xe9, 0x85, 0x57, 0x57, 0x83, 0xa1, 0x48, 0xac, 0x12, 0xca, 0xf7, 0x7a, 0x35, 0xfc, 0x72}: "PlatformStatusCodeHandlerSmm",
		efi.GUID{0x65, 0xec, 0x17, 0xda, 0xe4, 0x21, 0xab, 0x49, 0xb8, 0xba, 0x1f, 0x8d, 0x02, 0x6d, 0xc1, 0x48}: "FjPortReplicatorSmm",
		efi.GUID{0x65, 0xec, 0x51, 0x10, 0xfc, 0xf6, 0xea, 0x41, 0xba, 0x51, 0x34, 0x4c, 0x37, 0xf6, 0x0c, 0xdf}: "BoardConfigInitPreMem",
		efi.GUID{0x65, 0xf1, 0xb6, 0x19, 0x55, 0x78, 0xe8, 0x42, 0xaa, 0x6f, 0x23, 0x61, 0xca, 0x87, 0xe0, 0x24}: "LenovoSmmVideoInt10",
		efi.GUID{0x65, 0xf1, 0xed, 0xe1, 0x23, 0x66, 0x54, 0x4b, 0xbd, 0x7a, 0xa0, 0x5e, 0x06, 0x42, 0x06, 0xb0}: "FjSignon",
		efi.GUID{0x66, 0x02, 0x8b, 0x8f, 0x75, 0xc2, 0x1a, 0x41, 0x87, 0xec, 0xaa, 0xd8, 0x1e, 0xb1, 0xf0, 0x26}: "FjMfgPowerOffDxe",
		efi.GUID{0x66, 0x0d, 0xe5, 0x28, 0xea, 0xa0, 0x44, 0x4a, 0x97, 0x7d, 0xd0, 0x73, 0x19, 0xb9, 0x30, 0x4a}: "HeciControlSmm",
		efi.GUID{0x66, 0x0e, 0x1d, 0x4a, 0x71, 0x52, 0x22, 0x4e, 0x83, 0xfe, 0x90, 0x92, 0x1b, 0x74, 0x82, 0x13}: "EfiDxeIpmiTransportProtocol",
		efi.GUID{0x66, 0x0f, 0xe7, 0x2c, 0x57, 0xac, 0x46, 0x43, 0xa9, 0x1f, 0x89, 0x28, 0x1a, 0x07, 0xfa, 0xd6}: "ErrorDisplayFramework",
		efi.GUID{0x66, 0x16, 0x6e, 0xfe, 0x1e, 0x59, 0xb8, 0x4a, 0x95, 0x31, 0x2b, 0xf6, 0x43, 0x3a, 0x39, 0x25}: "ApobRnDxe",
		efi.GUID{0x66, 0x27, 0xb8, 0x57, 0x6a, 0x59, 0xbd, 0x45, 0x81, 0x68, 0x27, 0xe2, 0xbf, 0x41, 0xef, 0x5c}: "DellPermanentDeviceSmm",
		efi.GUID{0x66, 0x3f, 0x3e, 0xd4, 0x5d, 0x1b, 0x23, 0x46, 0x97, 0x5f, 0x7f, 0x5e, 0xbe, 0xee, 0xf0, 0x2d}: "MtkWifiDriver",
		efi.GUID{0x66, 0x48, 0x54, 0x36, 0x93, 0x6d, 0x48, 0x7a, 0x88, 0xfb, 0x66, 0x95, 0x82, 0xd2, 0x51, 0x6b}: "ApplePlatformInfoDatabaseDxe",
		efi.GUID{0x66, 0x4f, 0x6b, 0xbe, 0x89, 0x5b, 0xc2, 0x4d, 0x91, 0x02, 0xa1, 0x78, 0xc8, 0x62, 0x1c, 0xf2}: "UefiBootMarkerProtocol",
		efi.GUID{0x66, 0x53, 0x1f, 0x93, 0xb9, 0xfb, 0x2c, 0x4c, 0x93, 0x62, 0xb5, 0x32, 0xcb, 0xeb, 0x4f, 0x66}: "ServiceResetDxe",
		efi.GUID{0x66, 0x57, 0xa1, 0xa7, 0x9b, 0x44, 0x93, 0xaa, 0x11, 0x4b, 0x71, 0xb4, 0x7b, 0xe1, 0x74, 0xca}: "DellDataWipeSmm",
		efi.GUID{0x66, 0x68, 0xf6, 0x3b, 0x8b, 0x3f, 0xd8, 0x4c, 0xb7, 0x4c, 0xb9, 0x94, 0x11, 0x1f, 0x53, 0x5f}: "FfsIntegrityCheckDxe",
		efi.GUID{0x66, 0x6d, 0xbe, 0xdc, 0x28, 0xd9, 0x38, 0x41, 0x80, 0x41, 0x35, 0x8f, 0x35, 0xcb, 0xcf, 0x80}: "IsaBusDxe",
		efi.GUID{0x66, 0x6e, 0x22, 0xab, 0xd8, 0x31, 0x13, 0x46, 0x87, 0x9d, 0xd2, 0xfa, 0xb6, 0x10, 0x26, 0x3c}: "EdkiiDynamicTablesPkgTokenSpace",
		efi.GUID{0x66, 0x73, 0xd5, 0x0f, 0x08, 0x47, 0xe0, 0x3e, 0x39, 0x2b, 0x14, 0xa8, 0x73, 0x78, 0x2a, 0x25}: "PciePowerManagementSmm",
		efi.GUID{0x66, 0x7c, 0x3a, 0x6c, 0x26, 0x3d, 0x1b, 0x4b, 0xb8, 0x03, 0x2d, 0x80, 0x12, 0x43, 0xbe, 0x29}: "AmdMbistRsPei",
		efi.GUID{0x66, 0x7e, 0x01, 0x63, 0x90, 0xd7, 0xe6, 0x4e, 0xa0, 0xac, 0x61, 0x92, 0xaa, 0x74, 0xac, 0xf7}: "UCR",
		efi.GUID{0x66, 0x84, 0x64, 0x0d, 0xbd, 0x36, 0xc6, 0x42, 0xb2, 0x87, 0x7c, 0x3b, 0xaa, 0x25, 0x75, 0xc0}: "LenovoSetupUnderOsDxe",
		efi.GUID{0x66, 0x87, 0x5b, 0x67, 0x03, 0x7f, 0x81, 0x41, 0x9b, 0xe1, 0x73, 0xbc, 0x45, 0xdf, 0xf7, 0x99}: "EfiIpmiCmosClearVariable",
		efi.GUID{0x66, 0x8b, 0x1c, 0x72, 0x6c, 0x42, 0x86, 0x4e, 0x8e, 0x99, 0x34, 0x57, 0xc4, 0x6a, 0xb0, 0xb9}: "SystemBiosSetupDxe",
		efi.GUID{0x66, 0x8b, 0x1d, 0xf5, 0x6a, 0xe7, 0xcf, 0x43, 0x98, 0x80, 0x3f, 0xae, 0x4d, 0x30, 0xf6, 0x87}: "SmmBbsManagerProtocol",
		efi.GUID{0x66, 0x8c, 0x62, 0xe1, 0x2d, 0x2a, 0xc5, 0x4d, 0xbd, 0x41, 0xb2, 0x0f, 0x35, 0x38, 0xaa, 0xf7}: "BootPicker",
		efi.GUID{0x66, 0x8c, 0xf6, 0xce, 0xab, 0x06, 0xb3, 0x4f, 0xa3, 0xed, 0x5f, 0xfa, 0x88, 0x5b, 0x57, 0x25}: "SmbiosBoard",
		efi.GUID{0x66, 0x92, 0x08, 0xf5, 0xa0, 0x1a, 0x53, 0x49, 0x97, 0xd8, 0x56, 0x2f, 0x8a, 0x73, 0xb5, 0x19}: "EfiUsbHcProtocolGuid",
		efi.GUID{0x66, 0xa4, 0x61, 0x3d, 0x40, 0xab, 0x9a, 0x40, 0xa6, 0x98, 0xf3, 0x62, 0xd4, 0x64, 0xb3, 0x8f}: "EfiEventNotificationTypeBootGuid",
		efi.GUID{0x66, 0xb0, 0x31, 0x3f, 0xa2, 0x82, 0x2a, 0x4b, 0xa6, 0xce, 0xab, 0x0f, 0x7d, 0xd0, 0x06, 0x6a}: "NVDimmMgmt",
		efi.GUID{0x66, 0xb0, 0xf3, 0x71, 0x6a, 0x93, 0x84, 0x4c, 0x92, 0x28, 0x23, 0x23, 0x0f, 0xd4, 0x7c, 0x79}: "ImagePasswordFill",
		efi.GUID{0x66, 0xb2, 0xa2, 0x00, 0xcf, 0xb5, 0xa8, 0x43, 0x85, 0x47, 0xcb, 0xeb, 0xfd, 0xec, 0x89, 0x4c}: "SmmSvcCallback",
		efi.GUID{0x66, 0xb8, 0x22, 0x38, 0x22, 0xe1, 0xbe, 0x43, 0x87, 0x7d, 0x4a, 0xc7, 0x72, 0x9d, 0x6e, 0x78}: "DellNbThermalProtocol",
		efi.GUID{0x66, 0xba, 0x10, 0x13, 0xb4, 0xd7, 0xb0, 0x77, 0xa6, 0x45, 0x8c, 0x88, 0x87, 0xc6, 0xaa, 0x29}: "AmiSvrMemoryInfoConfig",
		efi.GUID{0x66, 0xc0, 0x0f, 0x95, 0xc9, 0xec, 0xce, 0x4b, 0x82, 0xb1, 0xba, 0x7d, 0x68, 0xf4, 0x42, 0x83}: "AplSmbiosGetFlashData",
		efi.GUID{0x66, 0xc4, 0xc1, 0xb6, 0x8a, 0xe7, 0x02, 0x42, 0x80, 0x1a, 0xb7, 0x95, 0x0e, 0x95, 0x6e, 0x0b}: "ProjectDXE",
		efi.GUID{0x66, 0xd1, 0x5a, 0xb3, 0xba, 0xfc, 0x4d, 0x4d, 0x89, 0xc7, 0x4b, 0x47, 0x10, 0x4e, 0x3a, 0xfd}: "AppleSpiIoSkl",
		efi.GUID{0x66, 0xd3, 0xf6, 0xc8, 0xf1, 0xdd, 0x60, 0x49, 0x9d, 0x57, 0x82, 0xf2, 0x65, 0x5a, 0x12, 0x94}: "AodPei",
		efi.GUID{0x66, 0xd4, 0x41, 0x49, 0x42, 0x40, 0x49, 0x4c, 0x2b, 0x8b, 0x8c, 0x83, 0x83, 0x4c, 0x13, 0x79}: "PegaPeim",
		efi.GUID{0x66, 0xd5, 0xce, 0x1a, 0xed, 0x76, 0x18, 0x42, 0xbc, 0x81, 0x76, 0x7f, 0x1f, 0x97, 0x7a, 0x89}: "EfiNetworkInterfaceIdentifierProtocolGuid_31",
		efi.GUID{0x66, 0xdf, 0xec, 0x4e, 0x06, 0xc5, 0x58, 0x44, 0x9c, 0x0d, 0x70, 0x02, 0x18, 0x28, 0xfb, 0x31}: "SpiProtectionSmm",
		efi.GUID{0x66, 0xe0, 0xb5, 0x97, 0x44, 0x41, 0x2d, 0x42, 0xad, 0x2b, 0xc3, 0x1a, 0x6f, 0x6a, 0x1d, 0x2e}: "SmmOemDriver",
		efi.GUID{0x66, 0xe8, 0x93, 0xd9, 0x8f, 0x5c, 0xe7, 0x4d, 0xbe, 0x99, 0x45, 0x3e, 0x28, 0x4a, 0x43, 0xaf}: "WakeOnLanDxe",
		efi.GUID{0x66, 0xec, 0x88, 0x4a, 0x70, 0x05, 0xe2, 0x4a, 0xbb, 0xbc, 0x33, 0x5a, 0x5c, 0x9b, 0xc2, 0x87}: "CsrRegTableDxe",
		efi.GUID{0x66, 0xf7, 0x98, 0xb0, 0x7a, 0xb1, 0x05, 0x40, 0x83, 0x09, 0xeb, 0x23, 0xf1, 0x44, 0x8c, 0x15}: "AmiCmosBadFlagHob",
		efi.GUID{0x67, 0x00, 0xf7, 0x0b, 0x3b, 0xd5, 0xdf, 0x42, 0xb7, 0x70, 0xe9, 0x2c, 0x91, 0xc6, 0x14, 0x11}: "EfiTdtProtocolGuid",
		efi.GUID{0x67, 0x02, 0x6e, 0x4c, 0x7d, 0xc7, 0x0d, 0x41, 0x81, 0x00, 0x14, 0x95, 0x91, 0x1a, 0x98, 0x9d}: "MetronomeDxe",
		efi.GUID{0x67, 0x19, 0xe0, 0x0a, 0x3b, 0x8b, 0x72, 0x45, 0x85, 0xbd, 0xef, 0xd5, 0xc0, 0xf2, 0x51, 0xeb}: "AmdPspRomArmor3Smm",
		efi.GUID{0x67, 0x22, 0x88, 0x39, 0x96, 0xce, 0x37, 0x4f, 0xa3, 0xeb, 0x00, 0xb0, 0x3b, 0xa4, 0xfc, 0x55}: "EcSecureFlashSmm",
		efi.GUID{0x67, 0x38, 0x76, 0x6a, 0x86, 0x40, 0xec, 0x40, 0xa5, 0xac, 0x6d, 0x63, 0x02, 0x1e, 0xfe, 0xdc}: "DellSmbDaTokenCfgPolicyGuidVer2",
		efi.GUID{0x67, 0x39, 0x6f, 0xfc, 0xa8, 0xaa, 0xd7, 0x47, 0x83, 0x7f, 0xa1, 0xcd, 0x44, 0x2e, 0x75, 0x72}: "TcpDxe",
		efi.GUID{0x67, 0x39, 0xb1, 0x1b, 0x24, 0x8b, 0x1b, 0x41, 0x98, 0x28, 0x18, 0xd2, 0x85, 0xa9, 0xcc, 0x4d}: "AmiPpiGuid",
		efi.GUID{0x67, 0x3d, 0x5a, 0xce, 0x31, 0x68, 0xe0, 0x47, 0x94, 0x6e, 0xb3, 0x30, 0x0d, 0x02, 0xe0, 0xc6}: "HpDmarDxe",
		efi.GUID{0x67, 0x44, 0x0a, 0x29, 0x89, 0x9f, 0x1f, 0x4f, 0xa7, 0x3c, 0xe1, 0x0b, 0x9f, 0xaf, 0xbd, 0x1b}: "FjFlexIoDxe",
		efi.GUID{0x67, 0x4b, 0x4f, 0xc5, 0x27, 0xe5, 0x79, 0x43, 0xbf, 0x61, 0x19, 0x3c, 0x7a, 0x68, 0xc6, 0x61}: "menu_none",
		efi.GUID{0x67, 0x4b, 0xbf, 0x56, 0xcf, 0x8d, 0x4f, 0x42, 0x99, 0xa9, 0x0f, 0x44, 0xb7, 0xf8, 0xc9, 0x25}: "ODDBiosBootSupportDxe",
		efi.GUID{0x67, 0x59, 0x09, 0xb1, 0xf4, 0xfc, 0x53, 0x4c, 0xbc, 0x16, 0x7e, 0x3d, 0xf9, 0xc2, 0x47, 0xeb}: "StdFlashPeiLibNull",
		efi.GUID{0x67, 0x5d, 0x21, 0x37, 0xd0, 0xd2, 0x6b, 0x48, 0x97, 0x7d, 0xb5, 0xbd, 0x4d, 0xc3, 0x80, 0x10}: "Platform_AcerPortingDxe",
		efi.GUID{0x67, 0x61, 0xcc, 0x34, 0xe7, 0x7a, 0x3e, 0x40, 0x8a, 0xb2, 0x23, 0x83, 0x7f, 0x39, 0x8a, 0x30}: "PlatformInfo",
		efi.GUID{0x67, 0x6c, 0x05, 0x6a, 0x28, 0x31, 0x02, 0x41, 0x9e, 0xc7, 0x26, 0x5e, 0x73, 0xaa, 0xb8, 0x60}: "GopCardEnabler",
		efi.GUID{0x67, 0x79, 0x18, 0x61, 0x77, 0x9a, 0x9d, 0x41, 0xaa, 0xea, 0x64, 0xdd, 0x56, 0x19, 0x08, 0x15}: "AmiPeiSbOemPlatformPolicyOverridePpi",
		efi.GUID{0x67, 0x7a, 0xc7, 0x86, 0x97, 0x0b, 0x33, 0x46, 0xa1, 0x87, 0x49, 0x10, 0x4d, 0x06, 0x85, 0xc7}: "NuvotonFwManagementDxe",
		efi.GUID{0x67, 0x7b, 0xd9, 0x4c, 0xbb, 0x12, 0xc5, 0x4f, 0x8b, 0x2a, 0x58, 0x0a, 0xdb, 0x6a, 0x63, 0x68}: "AmiTseOemPortingVar12",
		efi.GUID{0x67, 0x7d, 0xd5, 0x70, 0x05, 0x7f, 0x4d, 0x49, 0xa0, 0x14, 0xb7, 0x5d, 0x73, 0x45, 0xb7, 0x00}: "StorageSecurityCommandDxe",
		efi.GUID{0x67, 0x7e, 0xba, 0x27, 0x4d, 0xd5, 0x83, 0x49, 0xbe, 0x18, 0x9d, 0xf0, 0x7d, 0x23, 0x89, 0xdc}: "SystemNvmeServiceOwnerDxe",
		efi.GUID{0x67, 0x7e, 0xe8, 0x47, 0xc0, 0xfb, 0x01, 0x4c, 0x90, 0x02, 0x4a, 0x0a, 0x6e, 0xcb, 0x92, 0xff}: "AmiTseOemPortingVar4Guid",
		efi.GUID{0x67, 0x7f, 0x86, 0x8a, 0xd8, 0x89, 0x34, 0x41, 0xbb, 0xbd, 0x64, 0xbb, 0xaa, 0x52, 0x56, 0xf5}: "AmdCpmI2cDxe",
		efi.GUID{0x67, 0x81, 0x4f, 0x73, 0x6b, 0x99, 0x5d, 0x4c, 0xbb, 0xa3, 0x81, 0x5a, 0x72, 0x16, 0x7f, 0xf8}: "BFGDxe",
		efi.GUID{0x67, 0x8a, 0x85, 0x70, 0xd5, 0xd4, 0x32, 0x46, 0xbf, 0x0e, 0xd1, 0x8e, 0x2c, 0x29, 0xc5, 0x50}: "DTBTPEI",
		efi.GUID{0x67, 0x90, 0xf4, 0x25, 0x5b, 0xa6, 0xf5, 0x48, 0xbb, 0xbe, 0x35, 0x41, 0x8c, 0x48, 0x88, 0x36}: "TcgDxeMainDxe",
		efi.GUID{0x67, 0xa2, 0x5c, 0x4a, 0x16, 0x40, 0x0f, 0x46, 0x80, 0xee, 0x7b, 0x4c, 0x3d, 0x77, 0xfd, 0x62}: "DellUserInterfaceDxe",
		efi.GUID{0x67, 0xa5, 0x24, 0x7d, 0xc2, 0xa8, 0x18, 0x47, 0xdc, 0x60, 0xa2, 0xef, 0x07, 0x0f, 0x41, 0x4e}: "SmmCrcInit",
		efi.GUID{0x67, 0xab, 0xf5, 0xdf, 0xc6, 0x23, 0x6f, 0x40, 0x99, 0xd4, 0xf5, 0x1b, 0x22, 0x04, 0x41, 0x13}: "SmmWifiToolDriver",
		efi.GUID{0x67, 0xb1, 0x57, 0xce, 0xe4, 0xb0, 0xe8, 0x41, 0xa8, 0x97, 0x5f, 0x4f, 0xeb, 0x78, 0x1d, 0x40}: "EdkiiSystemFmpCapsuleDriverFvFileGuid",
		efi.GUID{0x67, 0xb5, 0xc8, 0x9a, 0xdb, 0x5f, 0xe5, 0x46, 0x8b, 0x12, 0xac, 0xfc, 0x4b, 0x24, 0xc5, 0xec}: "OemDataRegionRestore",
		efi.GUID{0x67, 0xb6, 0xa3, 0x18, 0xaf, 0x14, 0xe7, 0x4a, 0x84, 0x0f, 0xcd, 0x63, 0x17, 0xea, 0x0c, 0xbd}: "NbRsRouting",
		efi.GUID{0x67, 0xc5, 0xec, 0xd3, 0xd5, 0x9f, 0xc1, 0x44, 0x86, 0xcf, 0x5d, 0xa7, 0xa2, 0x4f, 0x4b, 0x5d}: "EfiLpcWpc83627PolicyProtocolGuid",
		efi.GUID{0x67, 0xc7, 0x8b, 0x96, 0x1b, 0x03, 0x98, 0x47, 0xff, 0xff, 0xff, 0xff, 0x1e, 0xe8, 0x11, 0x20}: "XnotePlatformInfoPei",
		efi.GUID{0x67, 0xc8, 0x27, 0x3f, 0x20, 0x47, 0x37, 0x45, 0x8d, 0x0c, 0x20, 0xf3, 0x2f, 0xf3, 0x0c, 0x04}: "AmdMcaZen4Dxe",
		efi.GUID{0x67, 0xc8, 0xc1, 0x3b, 0x74, 0x22, 0xf8, 0x43, 0xa4, 0xba, 0x93, 0x9a, 0x5b, 0xd6, 0xd4, 0x73}: "DellBlockIo",
		efi.GUID{0x67, 0xd1, 0x05, 0x99, 0x73, 0x3d, 0x94, 0x4a, 0x83, 0x5f, 0x03, 0xaf, 0xa1, 0x65, 0x6a, 0xe6}: "FjFextSmm",
		efi.GUID{0x67, 0xdd, 0xf0, 0x7d, 0x91, 0x5b, 0x40, 0x4d, 0xa8, 0x35, 0x58, 0x01, 0x34, 0x57, 0x01, 0x0a}: "SmbiosDataUpdateDxeHedtCRB",
		efi.GUID{0x67, 0xe2, 0x3b, 0x97, 0x60, 0x09, 0xc7, 0x40, 0x98, 0x56, 0xfa, 0x73, 0xc9, 0x2a, 0x46, 0xba}: "DellServiceResetDxe",
		efi.GUID{0x67, 0xe5, 0xe1, 0x6c, 0xc9, 0x46, 0x0c, 0x42, 0xa1, 0x7e, 0x61, 0x5d, 0x02, 0xae, 0x55, 0x34}: "ATPowerDxe",
		efi.GUID{0x67, 0xe6, 0x4c, 0xcb, 0x8d, 0xed, 0x66, 0x4a, 0xb4, 0x37, 0xea, 0x6a, 0x97, 0x0f, 0x2e, 0x48}: "SmmResetSystem",
		efi.GUID{0x67, 0xe7, 0x8b, 0xfc, 0xf1, 0x89, 0x6e, 0x4d, 0x80, 0x99, 0x6f, 0x02, 0x1e, 0xbc, 0x87, 0xcc}: "AmiIrqDmaMaskVariable",
		efi.GUID{0x67, 0xe8, 0x75, 0x9b, 0x46, 0x27, 0xbe, 0x48, 0xb7, 0x06, 0xb1, 0xb9, 0x3a, 0x34, 0x86, 0x93}: "AsusModuleToIntDxeWrapper",
		efi.GUID{0x67, 0xec, 0x2a, 0x3a, 0xb8, 0x77, 0xae, 0x40, 0x92, 0x81, 0x03, 0x51, 0x9c, 0x9e, 0x7f, 0x08}: "LenovoAoacSmm",
		efi.GUID{0x67, 0xf8, 0x8b, 0xc1, 0x3b, 0x0b, 0x40, 0x4c, 0x81, 0x1d, 0x24, 0x21, 0x00, 0x66, 0x59, 0x12}: "SystemSdLegacyDxe",
		efi.GUID{0x67, 0xfc, 0x84, 0x05, 0xb9, 0x72, 0x46, 0x4d, 0xae, 0x3e, 0xad, 0x33, 0x04, 0x52, 0xd9, 0xb4}: "InputDeviceAggregatorDxe",
		efi.GUID{0x67, 0xfd, 0x9f, 0xaf, 0x10, 0xec, 0x8a, 0x48, 0x9d, 0xfc, 0x6c, 0xbf, 0x5e, 0xe2, 0x2c, 0x2e}: "EfiAcpiVariableGuid",
		efi.GUID{0x68, 0x0a, 0xb5, 0xab, 0xa7, 0x0c, 0x9f, 0x4c, 0x8d, 0xb4, 0x56, 0xc3, 0x4e, 0x01, 0xcb, 0x95}: "SystemFirmwareDeviceBlockDxe",
		efi.GUID{0x68, 0x0c, 0x2a, 0x67, 0xf0, 0x2b, 0xf9, 0x46, 0x93, 0xc3, 0xc4, 0xe7, 0xdc, 0x0f, 0xa5, 0x55}: "UsbCredentialProvider",
		efi.GUID{0x68, 0x14, 0xff, 0xf3, 0xba, 0x04, 0x66, 0x49, 0x9f, 0xb2, 0xe4, 0xa7, 0x90, 0x05, 0x46, 0x50}: "EfiCapsuleCrashLogVarGuid",
		efi.GUID{0x68, 0x15, 0x7d, 0x4c, 0x73, 0xcf, 0x76, 0x46, 0xa0, 0x79, 0x16, 0xf7, 0xf9, 0x60, 0x0c, 0xcc}: "LenovoSecuritySmiDispatch",
		efi.GUID{0x68, 0x19, 0x53, 0xd1, 0x38, 0xe1, 0x2e, 0x4e, 0x8f, 0x7e, 0x38, 0x33, 0x07, 0x16, 0x92, 0x76}: "EzFlashInterfaceAsusSignBin",
		efi.GUID{0x68, 0x1b, 0xa4, 0x1b, 0x5f, 0x46, 0x22, 0x4b, 0x84, 0x06, 0x2b, 0x82, 0x17, 0x3d, 0xae, 0x50}: "DellSpecialBootControlSmm",
		efi.GUID{0x68, 0x23, 0x1d, 0x68, 0x40, 0x45, 0xa9, 0x4f, 0x8c, 0x1d, 0x8b, 0x79, 0xdb, 0xf6, 0xb9, 0xae}: "HybridGraphicDxe",
		efi.GUID{0x68, 0x26, 0x6c, 0x60, 0xa4, 0xe9, 0xe7, 0x46, 0xa0, 0x6b, 0x3b, 0x9b, 0x7e, 0xe1, 0x5c, 0xa0}: "OemPxeBoot",
		efi.GUID{0x68, 0x28, 0x86, 0x5b, 0x74, 0x74, 0xf2, 0x4c, 0x81, 0xa1, 0x9f, 0xca, 0x12, 0xfe, 0xb5, 0xb0}: "FjSiidSmm",
		efi.GUID{0x68, 0x2c, 0x45, 0xca, 0x0c, 0xdf, 0xc9, 0x45, 0x82, 0xfb, 0xea, 0xe4, 0x2b, 0x31, 0x29, 0x46}: "EfiVLVTokenSpaceGuid",
		efi.GUID{0x68, 0x2d, 0x7e, 0x80, 0x3f, 0xb1, 0x0a, 0x49, 0xa2, 0xfb, 0x34, 0x6a, 0x39, 0x45, 0x99, 0x78}: "NCT6685DSmmDxe",
		efi.GUID{0x68, 0x2d, 0x7e, 0x80, 0x3f, 0xb1, 0x0a, 0x49, 0xa2, 0xfb, 0x34, 0x6a, 0x39, 0x45, 0x9d, 0x09}: "NCT6685DSmm",
		efi.GUID{0x68, 0x2d, 0x7e, 0x80, 0x3f, 0xb1, 0x0a, 0x49, 0xa2, 0xfb, 0x34, 0x6a, 0x39, 0x45, 0x9d, 0x0a}: "ECHeartbeatSmm",
		efi.GUID{0x68, 0x2e, 0x79, 0x4f, 0xc8, 0xe8, 0x4e, 0x79, 0xb1, 0xd8, 0x37, 0x03, 0xf3, 0xf2, 0xd5, 0xa5}: "EmulatorPkgTokenSpaceGuid",
		efi.GUID{0x68, 0x2e, 0xf3, 0x5c, 0x60, 0x76, 0x9b, 0x44, 0x80, 0xe6, 0x7e, 0xa3, 0x6e, 0x03, 0xf6, 0xa8}: "EfiUserCredentialClassUnknownGuid",
		efi.GUID{0x68, 0x30, 0x6b, 0x42, 0xc7, 0x3b, 0x73, 0x4b, 0xac, 0xe8, 0x32, 0x2f, 0x0d, 0x0a, 0x10, 0x5b}: "BatteryHealthControlSmm",
		efi.GUID{0x68, 0x30, 0x90, 0xb3, 0x82, 0x74, 0x24, 0x44, 0xba, 0x4b, 0x40, 0x5f, 0x8f, 0xd7, 0x65, 0x4e}: "SiPolicyHobGuid",
		efi.GUID{0x68, 0x34, 0xd7, 0x03, 0x39, 0x3d, 0x9e, 0x4c, 0x97, 0xf1, 0x1f, 0xa9, 0x25, 0xbd, 0x7d, 0x9e}: "SystemSecureVariableStorageDxe",
		efi.GUID{0x68, 0x42, 0xc2, 0x8e, 0x45, 0xe5, 0x42, 0x42, 0xb5, 0x36, 0x04, 0xf9, 0x4c, 0x88, 0x99, 0x69}: "BoardUpdatePolicyDxe",
		efi.GUID{0x68, 0x44, 0x7e, 0x1a, 0x55, 0x2f, 0x56, 0x4a, 0x90, 0x3c, 0x01, 0x26, 0x5e, 0xb7, 0x62, 0x2b}: "TcpDxe",
		efi.GUID{0x68, 0x4f, 0x2b, 0x0b, 0x66, 0x35, 0xfc, 0x40, 0xb7, 0xe6, 0xfa, 0x81, 0x99, 0x93, 0x84, 0x0a}: "OemUniWillVariableDxe",
		efi.GUID{0x68, 0x4f, 0xc9, 0x4a, 0x51, 0xe6, 0x38, 0x4b, 0xa1, 0xd8, 0x2d, 0x5d, 0xef, 0xfa, 0x0f, 0x60}: "HDAudioSmi",
		efi.GUID{0x68, 0x51, 0xf1, 0xd8, 0xa0, 0x57, 0xd5, 0x46, 0x90, 0x71, 0x2f, 0x3c, 0x23, 0xcb, 0x23, 0x6d}: "RpmcPei",
		efi.GUID{0x68, 0x58, 0x6a, 0x9e, 0xc0, 0x6b, 0x5d, 0x4f, 0xba, 0x8f, 0x48, 0x74, 0xd3, 0x1e, 0x41, 0xc9}: "DellUefiClass3ConfigDxe",
		efi.GUID{0x68, 0x60, 0xff, 0x6c, 0xd3, 0x4f, 0x79, 0x47, 0x95, 0xb8, 0x4d, 0xfc, 0x90, 0x72, 0x23, 0x71}: "PlatformVTdInfoSamplePei",
		efi.GUID{0x68, 0x62, 0x79, 0xf4, 0x6e, 0x1f, 0x3c, 0x47, 0x80, 0xb2, 0x7a, 0xfc, 0x3d, 0x2a, 0xc7, 0xdc}: "RtcWakeUpSmm",
		efi.GUID{0x68, 0x62, 0xa6, 0xf9, 0x9f, 0xc4, 0x29, 0x4d, 0x8d, 0x20, 0xfc, 0x1f, 0xb0, 0x4b, 0x82, 0xf4}: "IntelLanUefiDriverGpy215",
		efi.GUID{0x68, 0x67, 0x66, 0x67, 0x64, 0x9c, 0xaa, 0x4c, 0xba, 0xf4, 0xca, 0x3e, 0x4c, 0xb7, 0x69, 0x7a}: "EfiSmbSmmDaCiProtocolVer2",
		efi.GUID{0x68, 0x68, 0x4c, 0x54, 0x26, 0xaa, 0x94, 0x4b, 0xa4, 0x3d, 0x80, 0xa1, 0xbf, 0x4e, 0x65, 0xef}: "DellErrorHandlerSmm",
		efi.GUID{0x68, 0x6a, 0x21, 0x59, 0x64, 0x06, 0x93, 0x42, 0x82, 0xe6, 0x5d, 0xcf, 0x4f, 0x99, 0xa0, 0x6f}: "AmdCpmUcsiPeim",
		efi.GUID{0x68, 0x6d, 0x72, 0x11, 0x47, 0xf1, 0xdf, 0x48, 0xab, 0x16, 0x04, 0x89, 0x81, 0x8b, 0xd5, 0x70}: "AmiHpetTimer",
		efi.GUID{0x68, 0x73, 0xb9, 0x97, 0x31, 0x18, 0x4c, 0x43, 0xa9, 0xd8, 0xa2, 0x04, 0x40, 0xa9, 0x1c, 0x48}: "Vmxnet2Dxe",
		efi.GUID{0x68, 0x75, 0xca, 0xf7, 0x09, 0x5a, 0x2c, 0x4d, 0x8a, 0x9b, 0x75, 0x84, 0x68, 0x59, 0x2a, 0xe2}: "AmiNvramControlProtocolGuid",
		efi.GUID{0x68, 0x7f, 0x9b, 0x23, 0xe1, 0x26, 0x48, 0x4b, 0xb9, 0x66, 0x85, 0x33, 0x8a, 0xa7, 0xb6, 0x37}: "OemSioPei",
		efi.GUID{0x68, 0x87, 0xf4, 0xf2, 0x85, 0x89, 0xdb, 0x11, 0xb8, 0xda, 0x00, 0x40, 0xd0, 0x2b, 0x18, 0x35}: "UnixPeiLoadFile",
		efi.GUID{0x68, 0x88, 0xe9, 0xf2, 0x85, 0x89, 0xdb, 0x11, 0x9a, 0x59, 0x00, 0x40, 0xd0, 0x2b, 0x18, 0x35}: "EfiUnixThunkProtocol",
		efi.GUID{0x68, 0x8a, 0x9e, 0x92, 0xb6, 0x0f, 0x20, 0x4f, 0xac, 0x5e, 0xd2, 0x94, 0xc5, 0x0b, 0x1c, 0xbb}: "TcpConnect_DXE",
		efi.GUID{0x68, 0x91, 0xec, 0xe9, 0x65, 0x10, 0x90, 0x4f, 0x8c, 0x44, 0xc1, 0x41, 0x3a, 0xaa, 0xe4, 0x3f}: "ODMAdminPasswordCheckVariable",
		efi.GUID{0x68, 0x95, 0x0d, 0x17, 0x69, 0xc9, 0xa1, 0x4f, 0xa5, 0x33, 0xdb, 0x67, 0x79, 0xbf, 0xbe, 0x62}: "LenovoEn25Qh128FlashPartSmm",
		efi.GUID{0x68, 0x9c, 0x07, 0xeb, 0x05, 0x0b, 0x53, 0x4a, 0xb8, 0xd5, 0x01, 0xc9, 0x95, 0xd6, 0x6a, 0x23}: "AmdMemPprSmmDriver",
		efi.GUID{0x68, 0xa2, 0x27, 0xbf, 0x69, 0xf3, 0xa2, 0x43, 0xb2, 0x95, 0x24, 0x2d, 0xee, 0x7f, 0x3c, 0x29}: "DellPowerButtonDxe",
		efi.GUID{0x68, 0xaa, 0xba, 0x4e, 0x78, 0xec, 0xf4, 0x4a, 0xb5, 0xa8, 0x6e, 0x9a, 0x9e, 0xcc, 0xf3, 0xff}: "CombinedFWUpdate",
		efi.GUID{0x68, 0xad, 0x95, 0x3a, 0x35, 0xd7, 0x8a, 0x41, 0xaf, 0x10, 0x5a, 0xe5, 0x16, 0x55, 0x59, 0x94}: "AaeonLanByPassSmi",
		efi.GUID{0x68, 0xc1, 0xc0, 0x35, 0x07, 0x26, 0x51, 0x4e, 0xbb, 0x53, 0x44, 0x8e, 0x3e, 0xd1, 0xa8, 0x7f}: "PciBusNoEnumerationDxe",
		efi.GUID{0x68, 0xd7, 0x23, 0x9e, 0xf3, 0xd2, 0x66, 0x43, 0x9f, 0xc3, 0x3a, 0x7a, 0xba, 0x86, 0x43, 0x74}: "EfiVlanConfigProtocolGuid",
		efi.GUID{0x68, 0xd8, 0x7c, 0x3d, 0x2e, 0x07, 0x7e, 0x4a, 0x9c, 0x83, 0x1d, 0xce, 0x7c, 0x0d, 0xb0, 0xac}: "DG_GOP",
		efi.GUID{0x68, 0xdb, 0xda, 0x90, 0x68, 0xb8, 0x62, 0x4d, 0xa0, 0x7f, 0x09, 0xb3, 0xb6, 0x4d, 0xa0, 0x39}: "Mebx",
		efi.GUID{0x68, 0xe1, 0x70, 0xb6, 0x14, 0xbd, 0x33, 0x4d, 0x86, 0xb0, 0xe6, 0x32, 0x84, 0x84, 0x03, 0xf1}: "AmdMemoryHobInfoPeimV2",
		efi.GUID{0x68, 0xec, 0x53, 0x9f, 0xa7, 0x49, 0x4b, 0x7f, 0x88, 0xde, 0xc4, 0x1a, 0x96, 0xfd, 0xba, 0xa6}: "Ip4Dxe",
		efi.GUID{0x68, 0xec, 0x88, 0xbd, 0xe4, 0xeb, 0x7b, 0x4f, 0x93, 0x5a, 0x4f, 0x66, 0x66, 0x42, 0xe7, 0x5f}: "EfiAcpiEnDispatchProtocolGuid",
		efi.GUID{0x68, 0xee, 0xeb, 0x95, 0x45, 0xf6, 0x66, 0x48, 0x9b, 0xa9, 0x51, 0xd3, 0xee, 0xb3, 0xb6, 0x50}: "FmpDxe",
		efi.GUID{0x68, 0xf0, 0xf7, 0xe1, 0xe7, 0x97, 0x74, 0x4b, 0xbf, 0x0f, 0x62, 0x67, 0x45, 0xaf, 0x99, 0x34}: "DxeSpiNorFlashCommBuffer",
		efi.GUID{0x68, 0xf2, 0xd3, 0x82, 0x7a, 0x75, 0xcd, 0x44, 0xa8, 0x7d, 0x13, 0xfd, 0xa9, 0x72, 0xb9, 0x99}: "EfiPlatformTypeLightningRidgeExecB1Protocol",
		efi.GUID{0x68, 0xf5, 0xa6, 0xe6, 0xb5, 0x53, 0xa4, 0x45, 0x85, 0x9d, 0x43, 0xb8, 0xc6, 0xc3, 0x64, 0x5b}: "BiosDiags",
		efi.GUID{0x68, 0xfc, 0x96, 0x69, 0x40, 0xb0, 0x16, 0x46, 0xa8, 0x9c, 0x60, 0xb4, 0xc9, 0x5d, 0x7b, 0xe6}: "ProjectDxePriori",
		efi.GUID{0x69, 0x00, 0x99, 0x5b, 0xf3, 0xaa, 0xe8, 0x4c, 0x93, 0xae, 0x53, 0x3d, 0x0d, 0x30, 0xa5, 0x6b}: "OemSSID",
		efi.GUID{0x69, 0x14, 0x53, 0x53, 0x8e, 0x55, 0xf1, 0x4a, 0x80, 0x3a, 0xf9, 0x66, 0xf2, 0x7c, 0x57, 0x3b}: "BatteryState2",
		efi.GUID{0x69, 0x23, 0x77, 0x17, 0x62, 0xd2, 0x90, 0x4b, 0x9f, 0x31, 0xbd, 0xc4, 0x1f, 0x26, 0x63, 0xa5}: "mebx_main",
		efi.GUID{0x69, 0x27, 0xf0, 0x00, 0x45, 0xae, 0xcf, 0x41, 0xaa, 0x58, 0x63, 0x77, 0xb8, 0x7b, 0xa9, 0x9a}: "DeviceLayoutLoadPei",
		efi.GUID{0x69, 0x2c, 0x3c, 0xe8, 0xe2, 0x31, 0x57, 0x45, 0xa9, 0x6f, 0x0a, 0xda, 0xb9, 0xeb, 0x73, 0x53}: "SmbiosDataUpdateDxeNeonCityEPECB",
		efi.GUID{0x69, 0x31, 0x9c, 0x0c, 0x39, 0x6f, 0x9e, 0x40, 0x99, 0x0b, 0x5b, 0x8b, 0x48, 0xb9, 0xd2, 0xb9}: "SyncUpNvramToPostFlag",
		efi.GUID{0x69, 0x3d, 0x8a, 0xec, 0xdf, 0x6d, 0x08, 0x41, 0x94, 0x76, 0x73, 0x37, 0xfc, 0x52, 0x21, 0x36}: "EfiKmsFormatGeneric128Guid",
		efi.GUID{0x69, 0x4a, 0x55, 0xcd, 0x4d, 0xee, 0x4f, 0x40, 0x85, 0x5a, 0x84, 0xa6, 0xa3, 0x97, 0x55, 0xd7}: "AmiSriovLibNull",
		efi.GUID{0x69, 0x4c, 0x9a, 0x6e, 0xc6, 0x57, 0xcd, 0x4f, 0xb0, 0x83, 0x4f, 0x2c, 0x3b, 0xdb, 0x60, 0x51}: "FdtPlatformDxe",
		efi.GUID{0x69, 0x4f, 0x6c, 0x46, 0xe5, 0x2c, 0x63, 0x41, 0x99, 0xe7, 0x5a, 0x67, 0x3f, 0x9c, 0x43, 0x1c}: "VGAInformation",
		efi.GUID{0x69, 0x5a, 0x45, 0xdd, 0x75, 0xec, 0x6c, 0x45, 0x84, 0xd2, 0x95, 0xca, 0xe7, 0xd3, 0xc6, 0xd3}: "EslTcp6ServiceGuid",
		efi.GUID{0x69, 0x5a, 0x62, 0x6f, 0xb1, 0x7d, 0x7b, 0x4f, 0x94, 0xc2, 0x05, 0x6a, 0x78, 0x52, 0x52, 0xce}: "RsaInit",
		efi.GUID{0x69, 0x5a, 0xa3, 0x7a, 0x6c, 0x50, 0x4f, 0x44, 0xa7, 0xaf, 0x69, 0x4b, 0xf5, 0x6f, 0x71, 0xc8}: "EfiFirmwareVolumeDispatchProtocol",
		efi.GUID{0x69, 0x5b, 0x58, 0xb2, 0x63, 0xfb, 0x20, 0x42, 0x84, 0x4a, 0x8f, 0xbe, 0xa8, 0xbf, 0x01, 0xaf}: "PeiIoLibCpuIo",
		efi.GUID{0x69, 0x67, 0xcf, 0xda, 0xd5, 0xc3, 0xff, 0x4e, 0xa1, 0x81, 0xfa, 0x09, 0x88, 0xe1, 0xd9, 0xb4}: "AmdCpmModernStandbyInitDxe",
		efi.GUID{0x69, 0x67, 0xcf, 0xdc, 0xd5, 0xc3, 0xff, 0x4e, 0xa1, 0x81, 0xfa, 0x09, 0x88, 0xe1, 0xd9, 0xb4}: "AmdCpmMsCommonInitDxe",
		efi.GUID{0x69, 0x75, 0x04, 0xd6, 0x08, 0xc5, 0x8f, 0x49, 0xae, 0xc1, 0x72, 0xe7, 0x7d, 0xad, 0xe7, 0xac}: "AepLogWmiSmm",
		efi.GUID{0x69, 0x78, 0x9b, 0x63, 0x03, 0x43, 0xc6, 0x44, 0x89, 0xae, 0xad, 0xf4, 0xf1, 0x33, 0x33, 0x18}: "EcSecureFlashDxe",
		efi.GUID{0x69, 0x7f, 0xc1, 0x86, 0x91, 0x6a, 0x1a, 0x45, 0x86, 0xb6, 0xf9, 0x2e, 0xbc, 0x60, 0x28, 0x31}: "AthQCA9377Undi",
		efi.GUID{0x69, 0x88, 0x6b, 0x7d, 0x17, 0x83, 0xd1, 0x43, 0x9e, 0x4e, 0xad, 0xb0, 0xb0, 0xf5, 0x84, 0x07}: "FjMfgPostSatControlDxe",
		efi.GUID{0x69, 0x89, 0xbd, 0xb5, 0x78, 0x09, 0x4b, 0x41, 0xba, 0x9f, 0xc4, 0x6b, 0x0a, 0x95, 0xb7, 0x6b}: "DellReFlashSmm",
		efi.GUID{0x69, 0x8c, 0xce, 0x5b, 0xf2, 0x40, 0xc4, 0x87, 0x04, 0x7b, 0xce, 0xab, 0xf0, 0x09, 0xf7, 0xed}: "MctpSmbusSmm",
		efi.GUID{0x69, 0x8d, 0xf4, 0xf6, 0x1e, 0x0c, 0x3a, 0x4a, 0x80, 0xdd, 0xcc, 0x15, 0x47, 0x4f, 0xf5, 0x2a}: "DellDesktopPowerLEDDxe",
		efi.GUID{0x69, 0x91, 0xc8, 0xc7, 0x42, 0x1a, 0x5e, 0x4e, 0xb3, 0x4b, 0xe6, 0x83, 0x06, 0x71, 0xc9, 0xa6}: "AmdSb900Smm",
		efi.GUID{0x69, 0x9e, 0x66, 0xe5, 0xa9, 0x48, 0x5f, 0x2f, 0x68, 0x4c, 0x92, 0x89, 0xfc, 0xa7, 0x37, 0xe9}: "RasOemDimmMap",
		efi.GUID{0x69, 0xa3, 0x0d, 0x9d, 0x0b, 0x54, 0xf8, 0x46, 0x85, 0xa0, 0x2b, 0x5f, 0x2c, 0x30, 0x1e, 0x15}: "EfiTimeVariable",
		efi.GUID{0x69, 0xb9, 0x1b, 0xdd, 0x0d, 0xbe, 0x70, 0x4b, 0x9e, 0x13, 0x2e, 0xd2, 0xe1, 0x85, 0x42, 0x40}: "LenovoWufuEsrtDxe",
		efi.GUID{0x69, 0xb9, 0x38, 0x5a, 0x6a, 0xcd, 0x14, 0x48, 0x82, 0xe6, 0x55, 0x9f, 0x84, 0x0b, 0xbc, 0x58}: "ISPDxe",
		efi.GUID{0x69, 0xbb, 0x70, 0xe7, 0xb4, 0xbc, 0x04, 0x4d, 0x9e, 0x97, 0x23, 0xff, 0x94, 0x56, 0xfe, 0xac}: "SystemAccess",
		efi.GUID{0x69, 0xbc, 0xc3, 0xe2, 0x5c, 0x61, 0x5b, 0x4b, 0x8e, 0x5c, 0xa0, 0x33, 0xa9, 0xc2, 0x5e, 0xd6}: "Tcg800155PlatformIdEventHob",
		efi.GUID{0x69, 0xd7, 0x9c, 0xe5, 0x83, 0x50, 0x26, 0x4f, 0x90, 0x94, 0x6c, 0x91, 0x9f, 0x91, 0x6c, 0x4e}: "EdkiiAtaAtapiPolicyProtocol",
		efi.GUID{0x69, 0xd7, 0xad, 0xdb, 0x6a, 0xe8, 0x19, 0x48, 0x81, 0x20, 0xe9, 0x91, 0x79, 0x2c, 0x0b, 0xc1}: "VbtMipiAuoGuid",
		efi.GUID{0x69, 0xd7, 0xc9, 0x26, 0x67, 0x91, 0x37, 0x45, 0x82, 0x19, 0xd9, 0xf5, 0xfc, 0x23, 0x78, 0xbe}: "OemUsbTypeCDxe",
		efi.GUID{0x69, 0xde, 0xe7, 0x9f, 0xea, 0x0a, 0x0a, 0x47, 0xb5, 0x0a, 0x13, 0x98, 0x13, 0x64, 0x91, 0x89}: "KekVar",
		efi.GUID{0x69, 0xe1, 0x44, 0xb1, 0xb1, 0xaf, 0x26, 0x44, 0xb0, 0xec, 0x09, 0x97, 0x28, 0x90, 0x93, 0x42}: "MuxGraphicsSwitch",
		efi.GUID{0x69, 0xe7, 0x01, 0xed, 0x97, 0x0b, 0xe1, 0x48, 0x99, 0xea, 0xdf, 0x14, 0x4b, 0xd2, 0xff, 0x32}: "OememPeiSSID",
		efi.GUID{0x69, 0xf1, 0x83, 0x9d, 0xc4, 0x17, 0x7e, 0x4e, 0x90, 0xa7, 0x63, 0x81, 0xa5, 0xc2, 0x18, 0x31}: "ClientronSecureBootDxe",
		efi.GUID{0x69, 0xf2, 0x83, 0xe8, 0x02, 0x3d, 0x88, 0x4a, 0x9a, 0x11, 0xe2, 0x90, 0x76, 0xdc, 0xb7, 0x3e}: "FjMfgChangeBootOrderDxe",
		efi.GUID{0x69, 0xf4, 0xdc, 0xc9, 0xc4, 0xa7, 0xd5, 0x11, 0x87, 0xda, 0x00, 0x06, 0x29, 0x45, 0xc3, 0xb9}: "EfiStandardCallerId",
		efi.GUID{0x69, 0xf9, 0x39, 0xd7, 0x2d, 0xfb, 0xc2, 0x4b, 0xaf, 0xe7, 0x08, 0x13, 0x27, 0xd3, 0xfe, 0xde}: "ActiveManagement",
		efi.GUID{0x69, 0xfc, 0x84, 0x0e, 0xcc, 0x29, 0x6d, 0x4c, 0x92, 0xac, 0x6d, 0x47, 0x69, 0x21, 0x85, 0x0f}: "UpdateDriverDxe",
		efi.GUID{0x6a, 0x02, 0xd3, 0xe5, 0xa5, 0x1c, 0xf0, 0x40, 0x8f, 0xb6, 0x4b, 0x1a, 0xfa, 0x3c, 0x6e, 0xaa}: "AmiCmosAccessSmmProtocol",
		efi.GUID{0x6a, 0x03, 0x29, 0xc6, 0xf0, 0x2e, 0x74, 0x4a, 0x96, 0x42, 0xa9, 0xfe, 0x38, 0x84, 0x27, 0x5e}: "AmdFchHwmDxe",
		efi.GUID{0x6a, 0x0f, 0x5b, 0x33, 0xbd, 0xfc, 0x2a, 0x40, 0xb4, 0xbb, 0x0c, 0x3e, 0xed, 0xaa, 0xf9, 0xd3}: "EhciRouting",
		efi.GUID{0x6a, 0x11, 0xd9, 0x32, 0x15, 0xaf, 0x76, 0x49, 0x90, 0x8c, 0x2c, 0x6e, 0x05, 0xcb, 0x78, 0x9a}: "AmiMultiPlatformProtocol",
		efi.GUID{0x6a, 0x19, 0x4b, 0x29, 0xcc, 0xa3, 0x43, 0x4a, 0x85, 0x7f, 0xee, 0xc2, 0x61, 0x47, 0x85, 0x7b}: "Tpm2DeviceLibSeC",
		efi.GUID{0x6a, 0x1f, 0xb7, 0xf9, 0xb5, 0x5e, 0xd6, 0x42, 0x84, 0xff, 0x9e, 0x8a, 0x23, 0x89, 0x52, 0x6f}: "DellAutoRtcResetDxe",
		efi.GUID{0x6a, 0x22, 0x66, 0xf8, 0xa5, 0xea, 0x5a, 0x4f, 0xa9, 0x0a, 0x6c, 0xfb, 0xa5, 0x7c, 0x58, 0x8e}: "SmmPerformanceProtocolGuid",
		efi.GUID{0x6a, 0x25, 0x18, 0x28, 0xdb, 0x6b, 0x71, 0x48, 0x99, 0x3c, 0x95, 0x31, 0x58, 0x54, 0x01, 0x2e}: "EdidOverrideDxe",
		efi.GUID{0x6a, 0x25, 0xe3, 0x46, 0xc1, 0xe5, 0x2a, 0x4d, 0x82, 0x82, 0x50, 0x5a, 0xfb, 0x41, 0xce, 0x65}: "DuetFwh",
		efi.GUID{0x6a, 0x2c, 0x45, 0xca, 0x0c, 0xdf, 0xc9, 0x4d, 0x82, 0xfb, 0xea, 0xe2, 0xab, 0x31, 0x29, 0x46}: "EfiQuarkNcSocIdTokenSpaceGuid",
		efi.GUID{0x6a, 0x31, 0xfd, 0x30, 0x28, 0x67, 0x41, 0x2e, 0xa6, 0x90, 0x0d, 0x13, 0x33, 0xd8, 0xca, 0xc1}: "EmuGraphicsWindowProtocolGuid",
		efi.GUID{0x6a, 0x33, 0x08, 0xf2, 0xf4, 0xbf, 0x78, 0x46, 0xba, 0x4f, 0x34, 0x2c, 0x72, 0x37, 0x3c, 0x3a}: "FjOemIgcEsrtDxe",
		efi.GUID{0x6a, 0x3c, 0x67, 0xf7, 0x5c, 0x9c, 0x54, 0x4c, 0xb0, 0x86, 0xc6, 0xe0, 0xb7, 0xd0, 0x3d, 0xb8}: "AmdSmmControl",
		efi.GUID{0x6a, 0x40, 0x2e, 0x0b, 0x5b, 0xed, 0x68, 0x46, 0xbc, 0xd1, 0x2b, 0x1d, 0xb0, 0x18, 0x41, 0xfc}: "DellAcpiOemConfig",
		efi.GUID{0x6a, 0x40, 0xa6, 0x31, 0xdf, 0x6b, 0x46, 0x4e, 0xb2, 0xa2, 0xeb, 0xaa, 0x89, 0xc4, 0x09, 0x20}: "EfiHiiImageProtocolGuid",
		efi.GUID{0x6a, 0x43, 0x28, 0x7a, 0x13, 0xe1, 0x6a, 0x40, 0xaf, 0xf9, 0x0d, 0xbf, 0x7f, 0x64, 0x3e, 0x02}: "EfiTcgPrivateInterfaceGuid",
		efi.GUID{0x6a, 0x49, 0xee, 0x17, 0xe4, 0xd8, 0x9a, 0x4b, 0x94, 0xd1, 0xce, 0x82, 0x72, 0x30, 0x08, 0x50}: "EfiPeiBootInRecoveryModePpiGuid",
		efi.GUID{0x6a, 0x4a, 0xea, 0xde, 0x08, 0x93, 0x5b, 0x46, 0xad, 0x99, 0xb5, 0xbd, 0xa5, 0xb5, 0x55, 0x75}: "CompalThermalUtilitySmi",
		efi.GUID{0x6a, 0x4c, 0x98, 0x53, 0x4a, 0x1b, 0x74, 0x41, 0x95, 0x12, 0xa6, 0x5e, 0x5b, 0xc8, 0xb2, 0x78}: "PlatformStage1",
		efi.GUID{0x6a, 0x4e, 0x2c, 0xc1, 0x3d, 0xbc, 0x91, 0x4a, 0x82, 0x99, 0x7e, 0x0a, 0x4d, 0x5b, 0x52, 0x89}: "SmcOemID",
		efi.GUID{0x6a, 0x4e, 0x99, 0x9d, 0x12, 0x56, 0x9f, 0x4d, 0xae, 0x8f, 0x45, 0xce, 0x77, 0x1d, 0x57, 0xea}: "RTSCallbackHandleDxe",
		efi.GUID{0x6a, 0x58, 0x53, 0x06, 0xd4, 0x9e, 0x0c, 0x40, 0xa3, 0x42, 0x9e, 0xfa, 0xf9, 0x9c, 0xe5, 0x4e}: "SecuredCorePCDeviceIdentifier",
		efi.GUID{0x6a, 0x59, 0xe5, 0xba, 0xdf, 0x14, 0xfc, 0x40, 0x81, 0x0e, 0xbb, 0x24, 0x28, 0x00, 0x96, 0x00}: "HpCmosButton",
		efi.GUID{0x6a, 0x60, 0xf8, 0x41, 0x4c, 0xf7, 0x9d, 0x40, 0x94, 0x65, 0x52, 0x19, 0x55, 0x7c, 0xbc, 0x7d}: "DellFlashIoSmmProtocol",
		efi.GUID{0x6a, 0x71, 0x32, 0x8d, 0xdf, 0x60, 0xde, 0x4b, 0x86, 0x47, 0x3d, 0x17, 0x8c, 0xc8, 0x2b, 0x6c}: "DellMePlatformConfigDxe",
		efi.GUID{0x6a, 0x74, 0x79, 0xb9, 0x1f, 0x8c, 0x2b, 0x4a, 0x97, 0xe4, 0x78, 0xe9, 0x3a, 0x71, 0xa7, 0x0a}: "EfiBdatAccess",
		efi.GUID{0x6a, 0x76, 0x40, 0x57, 0x8e, 0x71, 0xc0, 0x4d, 0x99, 0x35, 0xc3, 0x6f, 0x7d, 0x3f, 0x88, 0x4f}: "DefaultdbxFile",
		efi.GUID{0x6a, 0x7e, 0xbd, 0xeb, 0xd0, 0x37, 0x7a, 0x41, 0x94, 0x10, 0xd1, 0x9a, 0x59, 0xbe, 0x34, 0x9f}: "DellBiosVersionNameDxe",
		efi.GUID{0x6a, 0x80, 0x62, 0x78, 0x71, 0x71, 0xa0, 0x47, 0x98, 0xa2, 0x12, 0xf3, 0x50, 0x5a, 0x1e, 0xf2}: "AtapiCommandSmm",
		efi.GUID{0x6a, 0x85, 0x3d, 0xae, 0x5d, 0x65, 0x8d, 0x47, 0x8e, 0x48, 0x16, 0x61, 0x31, 0x1a, 0xa3, 0xbf}: "HpEsrtDxe",
		efi.GUID{0x6a, 0x86, 0x8c, 0x62, 0xbb, 0x9c, 0x00, 0x4e, 0xbf, 0x85, 0x7a, 0x9e, 0x35, 0x0e, 0x08, 0x16}: "PegaSmiDxe",
		efi.GUID{0x6a, 0x88, 0x97, 0x8a, 0xe1, 0xee, 0xf8, 0x4b, 0xad, 0x20, 0x68, 0xf3, 0x98, 0xf9, 0x5b, 0x12}: "AMDPSPKvmMiscDxe",
		efi.GUID{0x6a, 0x8e, 0xb0, 0x80, 0xce, 0xc6, 0x0f, 0x43, 0x9c, 0x07, 0x52, 0xa9, 0x52, 0x6d, 0xb0, 0xf9}: "CompalWSMTDxe",
		efi.GUID{0x6a, 0xb5, 0x8a, 0x91, 0x5d, 0x36, 0xf5, 0x4e, 0xb7, 0x12, 0x45, 0x99, 0x4f, 0xcd, 0xde, 0x57}: "OdmEmDellSMBiosUpdate",
		efi.GUID{0x6a, 0xb6, 0x8e, 0xe0, 0x63, 0xf0, 0xb4, 0x4b, 0x9d, 0x11, 0x18, 0xf7, 0x7c, 0x22, 0x7b, 0xb7}: "HpPlatformSataPortConfigDxe",
		efi.GUID{0x6a, 0xba, 0x87, 0x2f, 0x04, 0x5c, 0x85, 0x43, 0xa7, 0x80, 0xf3, 0xbf, 0x78, 0xa9, 0x7b, 0xec}: "EfiBlockIoCryptoAlgoAesXtsGuid",
		efi.GUID{0x6a, 0xc1, 0x95, 0xd9, 0x06, 0xdf, 0x26, 0x4b, 0x9c, 0x5b, 0x24, 0x6f, 0xc7, 0x46, 0x46, 0x49}: "SystemAcpiSlp2Dxe",
		efi.GUID{0x6a, 0xc6, 0x81, 0x7c, 0x11, 0x4f, 0xab, 0x47, 0x82, 0xd3, 0x67, 0xc4, 0xd6, 0x35, 0xae, 0xd1}: "LegacyMebxLaunch",
		efi.GUID{0x6a, 0xd4, 0x13, 0x70, 0x31, 0xd6, 0xce, 0x4d, 0xab, 0xb7, 0x41, 0x76, 0x0e, 0x02, 0xc7, 0xc7}: "DellTpmBusConfigDxe",
		efi.GUID{0x6a, 0xd5, 0x6f, 0xac, 0x41, 0x3d, 0xfd, 0x4e, 0xa1, 0xb9, 0x87, 0x02, 0x93, 0x81, 0x1a, 0x28}: "PhMebxHotkey",
		efi.GUID{0x6a, 0xdb, 0x55, 0x01, 0x05, 0x3c, 0xf6, 0x46, 0x93, 0x41, 0xfe, 0xfa, 0x40, 0x85, 0xe6, 0x1e}: "FjPostScreenMfgErrorCheckDxe",
		efi.GUID{0x6a, 0xde, 0x29, 0x00, 0x24, 0xe0, 0xb8, 0x4e, 0xa9, 0x1d, 0x9f, 0x23, 0xaa, 0x1f, 0x4e, 0x92}: "NetworkStackSetupScreen",
		efi.GUID{0x6a, 0xde, 0x5b, 0x82, 0xe4, 0xe9, 0xc8, 0x4c, 0x9c, 0x2d, 0x09, 0xb2, 0x9c, 0x3b, 0xd4, 0x26}: "EfiCpPcPlatTokenSpace",
		efi.GUID{0x6a, 0xe1, 0x5d, 0xde, 0xe4, 0x75, 0xde, 0x42, 0x86, 0xd8, 0x30, 0x66, 0x6a, 0x08, 0xea, 0x93}: "DellUefiClass3ConfigPei",
		efi.GUID{0x6a, 0xe6, 0xcb, 0x56, 0x3c, 0xbf, 0xf9, 0x48, 0xb9, 0xde, 0x8d, 0xa4, 0x2f, 0x90, 0x60, 0x74}: "SbPcdPei",
		efi.GUID{0x6a, 0xe9, 0x6e, 0x28, 0x1f, 0x5b, 0x4a, 0x48, 0x96, 0x89, 0xcf, 0x77, 0x0d, 0xc8, 0x91, 0x85}: "SioShmLock",
		efi.GUID{0x6a, 0xee, 0xe8, 0xa0, 0x92, 0x0e, 0xd4, 0x44, 0x86, 0x1b, 0x0e, 0xaa, 0x4a, 0xca, 0x44, 0xa2}: "EfiKmsFormatAescbc128Guid",
		efi.GUID{0x6a, 0xf6, 0x1c, 0xe5, 0x79, 0x7d, 0xd0, 0x43, 0x9e, 0xe8, 0x0a, 0x20, 0x84, 0xbd, 0xea, 0xd4}: "AmdRasRnDxe",
		efi.GUID{0x6a, 0xfd, 0xdb, 0x1d, 0x23, 0x34, 0x2f, 0x46, 0x91, 0x50, 0xa7, 0xff, 0xa6, 0x6f, 0xf0, 0xca}: "StaticSkuDataDxeLightningRidgeEXRP",
		efi.GUID{0x6a, 0xff, 0x62, 0xc1, 0xa5, 0xf5, 0xb7, 0x4d, 0x9e, 0xcf, 0x80, 0xee, 0xc2, 0x50, 0x17, 0x68}: "UtilityPartitionDxe",
		efi.GUID{0x6b, 0x14, 0xa2, 0x57, 0x5f, 0x2f, 0xfe, 0x4b, 0x86, 0xb6, 0x30, 0x34, 0x71, 0xf2, 0xf4, 0x7c}: "FchShastaPei",
		efi.GUID{0x6b, 0x1a, 0x04, 0x05, 0xee, 0x4d, 0xbb, 0x47, 0x9e, 0x58, 0x59, 0x44, 0xd1, 0x87, 0x0e, 0xe5}: "UsbConfigGuid",
		efi.GUID{0x6b, 0x1e, 0xf5, 0xfc, 0x7f, 0x52, 0x8d, 0x43, 0xbe, 0x6d, 0xa6, 0xd1, 0x5f, 0x0c, 0xd9, 0x8b}: "EfiTraceHubStatusCodeHandleRuntimeDxe",
		efi.GUID{0x6b, 0x3e, 0x0a, 0xb6, 0xc4, 0x18, 0xe5, 0x46, 0xa2, 0x9a, 0xc9, 0xa1, 0x06, 0x65, 0xa2, 0x8e}: "EfiI2cIoProtocolGuid",
		efi.GUID{0x6b, 0x3f, 0xc5, 0xcc, 0x3a, 0xa0, 0xd8, 0x4e, 0x83, 0x9a, 0x03, 0xd9, 0x9c, 0x02, 0xb4, 0xe3}: "EfiNtLoadAsDllPpi",
		efi.GUID{0x6b, 0x46, 0xdd, 0x08, 0xfb, 0x69, 0x41, 0x4c, 0x90, 0xb2, 0x55, 0x11, 0x61, 0xc5, 0xec, 0xac}: "AmiAgesaChipsetDxe",
		efi.GUID{0x6b, 0x55, 0x1c, 0xcd, 0xbf, 0x62, 0xec, 0x4e, 0x8e, 0x73, 0x77, 0x31, 0xf8, 0xe8, 0x47, 0xb2}: "AmdCpmGpioInitSmm",
		efi.GUID{0x6b, 0x62, 0xd0, 0x96, 0xd5, 0x71, 0x01, 0x40, 0xac, 0x71, 0xe0, 0x5b, 0x10, 0x3b, 0xd4, 0x5d}: "F10App",
		efi.GUID{0x6b, 0x63, 0x58, 0x34, 0x94, 0x9a, 0xe7, 0x44, 0xbc, 0xa9, 0xf8, 0xdf, 0xa1, 0xf5, 0xd8, 0x94}: "LenovoSecureWipeLoader",
		efi.GUID{0x6b, 0x66, 0xcc, 0x0e, 0x62, 0x46, 0xf9, 0x47, 0x9d, 0xd5, 0xd0, 0x96, 0xff, 0x7d, 0xa4, 0x9e}: "PeiSecPerformancePpiGuid",
		efi.GUID{0x6b, 0x68, 0xc4, 0x27, 0xb8, 0x32, 0xec, 0x4b, 0xa4, 0x99, 0xc5, 0xba, 0x75, 0x63, 0x9f, 0xc9}: "RsaSmm",
		efi.GUID{0x6b, 0x69, 0x00, 0x91, 0x8f, 0x36, 0x9a, 0x4f, 0x98, 0x4a, 0xd6, 0x06, 0xe5, 0x78, 0xcc, 0xc1}: "SetupConfigUpdateDxeLightningRidgeEXRP",
		efi.GUID{0x6b, 0x69, 0xeb, 0xd6, 0xc3, 0x7e, 0x1b, 0x4d, 0xaa, 0x28, 0x67, 0x75, 0x74, 0x4c, 0x9e, 0xb5}: "TSEScreenMgmtProtocolGuid",
		efi.GUID{0x6b, 0x75, 0x69, 0x4a, 0x9b, 0x20, 0x57, 0x4d, 0x88, 0x10, 0x14, 0x2d, 0xac, 0x6b, 0xb7, 0xb5}: "FchSandstoneSmmInit",
		efi.GUID{0x6b, 0x83, 0xa9, 0x27, 0x74, 0xcd, 0xb2, 0x4d, 0x9a, 0x8e, 0x8a, 0x4f, 0xd5, 0x21, 0x80, 0xb7}: "NvmeDeviceService",
		efi.GUID{0x6b, 0x88, 0x15, 0x39, 0x33, 0xd8, 0x23, 0x4c, 0xb3, 0xed, 0x14, 0x53, 0xcc, 0xe7, 0xc5, 0xf2}: "IioCfgUpdateDxeLightningRidgeEXECB2",
		efi.GUID{0x6b, 0x93, 0x28, 0xba, 0x51, 0x40, 0xcf, 0x48, 0xa5, 0xcd, 0xb6, 0x3d, 0x7b, 0xfc, 0xa8, 0x4a}: "SmBusDxe",
		efi.GUID{0x6b, 0x93, 0x40, 0xa6, 0x4c, 0xf8, 0x97, 0x4b, 0x9f, 0x95, 0x2b, 0xfe, 0x78, 0xc1, 0xf0, 0xa1}: "KEMhHwmDxe",
		efi.GUID{0x6b, 0xa5, 0xfc, 0xfb, 0x36, 0xbb, 0x78, 0x4b, 0xaa, 0xab, 0xbe, 0x1b, 0x97, 0xec, 0x7c, 0xcb}: "EdkiiXtermR6",
		efi.GUID{0x6b, 0xaa, 0x5f, 0xdc, 0x33, 0xba, 0xcd, 0x49, 0x81, 0x46, 0xaf, 0x7d, 0x6d, 0xa3, 0x96, 0x87}: "AcpiOemNVSInitDxe",
		efi.GUID{0x6b, 0xb5, 0x74, 0x57, 0xb5, 0x40, 0xd6, 0x4f, 0x98, 0xf7, 0xd4, 0xd2, 0x7c, 0x86, 0xca, 0x49}: "FjGenericItemProtectedStorageDxe",
		efi.GUID{0x6b, 0xbe, 0x13, 0x00, 0x98, 0x21, 0xf1, 0x43, 0x93, 0xba, 0x2a, 0x7e, 0xd7, 0xb1, 0xe1, 0xcc}: "SystemUsbSwitchDxe",
		efi.GUID{0x6b, 0xd3, 0xaf, 0x19, 0x01, 0xf5, 0x46, 0x44, 0x9c, 0x9e, 0x04, 0x57, 0xdb, 0x6e, 0x78, 0x88}: "SetupItemLinkageDxe",
		efi.GUID{0x6b, 0xd9, 0xbd, 0xfa, 0xdd, 0x2d, 0x47, 0x47, 0x96, 0x12, 0xf9, 0xe7, 0x77, 0xc8, 0x4a, 0x38}: "SetupUtility",
		efi.GUID{0x6b, 0xe2, 0xfb, 0x82, 0xd4, 0x53, 0x8f, 0x44, 0x92, 0x4c, 0x7b, 0xe0, 0x12, 0x6e, 0xca, 0x4f}: "DellPxeUndiRom",
		efi.GUID{0x6b, 0xe4, 0x1c, 0x0d, 0xd9, 0x72, 0xa7, 0x4b, 0x95, 0xda, 0x23, 0x51, 0x18, 0x65, 0xe6, 0x61}: "CryptoPei",
		efi.GUID{0x6b, 0xe5, 0x4c, 0x16, 0xbc, 0x5e, 0x84, 0x49, 0xb0, 0xda, 0xc1, 0x2b, 0x4f, 0x21, 0xd2, 0xec}: "AmdRasRvSmm",
		efi.GUID{0x6b, 0xef, 0xec, 0x5f, 0xa4, 0x5f, 0x70, 0x45, 0x81, 0x63, 0x0c, 0xf7, 0x2a, 0x9c, 0x04, 0xc5}: "Ps2Main",
		efi.GUID{0x6b, 0xfd, 0x61, 0x8e, 0x8b, 0x7a, 0x4f, 0x40, 0xb8, 0x3f, 0xaa, 0x90, 0xa4, 0x7c, 0xab, 0xdf}: "SmmSmbiosElog",
		efi.GUID{0x6c, 0x04, 0x1a, 0xbc, 0xbd, 0x7d, 0xf2, 0x41, 0x94, 0xe5, 0xd7, 0x59, 0x55, 0x54, 0xca, 0xf4}: "SystemFirmwareReportDxe",
		efi.GUID{0x6c, 0x0f, 0xdd, 0x11, 0x9b, 0x20, 0xce, 0x47, 0x8a, 0x98, 0x41, 0x8c, 0x9b, 0x7c, 0xc7, 0x56}: "DxeSwSmi",
		efi.GUID{0x6c, 0x14, 0x73, 0x02, 0xc4, 0x96, 0xa1, 0x45, 0xa7, 0xaf, 0x78, 0xe0, 0x52, 0x4a, 0x0a, 0xe2}: "AmiBoardInfoProtocol",
		efi.GUID{0x6c, 0x19, 0x66, 0xdf, 0x8f, 0x95, 0x2f, 0x47, 0x93, 0x93, 0x71, 0x7d, 0x82, 0x11, 0x0a, 0xf6}: "AmiHashLogExtendExGuid",
		efi.GUID{0x6c, 0x21, 0x14, 0x13, 0x8d, 0xcb, 0x1c, 0x42, 0xb8, 0x54, 0x06, 0x23, 0x13, 0x86, 0xe6, 0x42}: "PlatformInfoDxe",
		efi.GUID{0x6c, 0x2e, 0x8a, 0x8c, 0x6c, 0xa5, 0x6c, 0x4a, 0x8c, 0x9b, 0xb4, 0xb6, 0xbb, 0x42, 0x08, 0xae}: "NvmeRaidDxe",
		efi.GUID{0x6c, 0x30, 0xe2, 0x12, 0xbd, 0x1e, 0x40, 0x31, 0xb9, 0x2e, 0xef, 0xa9, 0x09, 0x9e, 0x82, 0xd2}: "CacheManager",
		efi.GUID{0x6c, 0x31, 0xe6, 0x49, 0x1d, 0xcc, 0x78, 0x49, 0xb8, 0x89, 0xff, 0xaf, 0xc5, 0xc6, 0x1d, 0x0c}: "FjErrorDisplay",
		efi.GUID{0x6c, 0x35, 0x32, 0xdd, 0x4b, 0x43, 0x8e, 0x41, 0xb3, 0xf7, 0xe7, 0x22, 0x78, 0x25, 0xf7, 0x8e}: "UsbHubEnable",
		efi.GUID{0x6c, 0x46, 0xb2, 0x9d, 0x61, 0x4e, 0xce, 0x49, 0x9a, 0xfd, 0x78, 0x9a, 0xe7, 0x2c, 0x8f, 0x5d}: "HpLibArchiveDriver",
		efi.GUID{0x6c, 0x48, 0x4a, 0xb4, 0xb3, 0x8b, 0x7a, 0x45, 0xa8, 0xce, 0xf8, 0x9b, 0x17, 0x9c, 0x95, 0x04}: "DellEcIoPei",
		efi.GUID{0x6c, 0x66, 0x7c, 0x15, 0x74, 0x7c, 0x4a, 0x4e, 0xb6, 0x39, 0x7b, 0xba, 0x21, 0x48, 0x7c, 0xe1}: "QFanDXE",
		efi.GUID{0x6c, 0x76, 0x7f, 0x60, 0x55, 0x74, 0xbe, 0x42, 0x93, 0x0b, 0xe4, 0xd7, 0x6d, 0xb2, 0x72, 0x0f}: "EfiTrEEProtocolGuid",
		efi.GUID{0x6c, 0x7a, 0x45, 0x0a, 0x8e, 0x17, 0x8c, 0x43, 0xac, 0x96, 0xd9, 0xc0, 0xec, 0x52, 0xbe, 0x66}: "DellTcgPeiPolicy",
		efi.GUID{0x6c, 0x82, 0x3c, 0x8e, 0x9e, 0xb6, 0x56, 0x4f, 0x95, 0xab, 0x13, 0x24, 0xdd, 0x02, 0xe2, 0x8b}: "StdBoardPei",
		efi.GUID{0x6c, 0x87, 0x53, 0x66, 0xa1, 0xf6, 0xbb, 0x45, 0xa0, 0x27, 0x20, 0x45, 0x50, 0x93, 0xbc, 0x6d}: "SecPeiFspPlatformSecLibVlv2",
		efi.GUID{0x6c, 0x89, 0xb7, 0x92, 0x62, 0x33, 0xce, 0x46, 0x99, 0xb3, 0x4f, 0x5e, 0x3c, 0x34, 0xeb, 0x42}: "UniversalPayloadSmbios3Table",
		efi.GUID{0x6c, 0xae, 0x8c, 0x72, 0xfc, 0x1f, 0x9b, 0x44, 0x86, 0x81, 0xbb, 0x2a, 0x62, 0x1e, 0x00, 0x22}: "ContinueButtonSmall",
		efi.GUID{0x6c, 0xaf, 0x8f, 0x41, 0xcf, 0x2b, 0x41, 0x41, 0x89, 0x83, 0x9d, 0x33, 0xe1, 0xb6, 0x7b, 0x4c}: "SpiControllerSmm",
		efi.GUID{0x6c, 0xb4, 0xb9, 0x8e, 0x80, 0x8f, 0x6a, 0x4e, 0x9f, 0xbf, 0xec, 0x89, 0x2f, 0xba, 0x28, 0x07}: "SmmAccessPei",
		efi.GUID{0x6c, 0xb6, 0x93, 0xa9, 0xea, 0x22, 0xba, 0x46, 0xa2, 0x7a, 0x0a, 0x23, 0x35, 0x6d, 0x90, 0x1c}: "AmiHddTemperatureProtocol",
		efi.GUID{0x6c, 0xc0, 0x0c, 0xae, 0x67, 0x11, 0xc1, 0x48, 0x89, 0xa2, 0x90, 0x49, 0x9d, 0xf6, 0x8f, 0xc3}: "XnoteEsrtDxe",
		efi.GUID{0x6c, 0xc5, 0xcd, 0x33, 0xef, 0xb1, 0x21, 0x4b, 0x87, 0xe4, 0x22, 0x5f, 0x42, 0xc6, 0x7f, 0x4a}: "SystemProgressIndicator",
		efi.GUID{0x6c, 0xdb, 0xac, 0xfd, 0xbc, 0xac, 0x87, 0x4d, 0x8a, 0x59, 0x83, 0xf5, 0x39, 0xfc, 0x66, 0xfd}: "FanTuningDxe",
		efi.GUID{0x6c, 0xe3, 0x28, 0xf3, 0xb6, 0x23, 0x95, 0x4a, 0x85, 0x4b, 0x32, 0xe1, 0x95, 0x34, 0xcd, 0x75}: "SmmCommunicateHeaderGuid",
		efi.GUID{0x6c, 0xe5, 0xfa, 0x46, 0x1e, 0xac, 0xad, 0x4b, 0xb1, 0x52, 0x54, 0x9d, 0xce, 0x04, 0x2d, 0x80}: "BBSManagerLegacySmm",
		efi.GUID{0x6c, 0xf2, 0xfa, 0xae, 0x6d, 0xfb, 0xef, 0x4f, 0xaf, 0x7a, 0x9d, 0x78, 0xff, 0x20, 0x1f, 0xca}: "FirmwareUpdate",
		efi.GUID{0x6c, 0xf4, 0xcf, 0xbb, 0xd3, 0xc8, 0x13, 0x41, 0x89, 0x85, 0xb9, 0xd4, 0xf3, 0xb3, 0xf6, 0x4e}: "FspBootLoaderTemporaryMemoryGuid",
		efi.GUID{0x6c, 0xf5, 0x04, 0x51, 0x34, 0xaa, 0xe3, 0x47, 0xb4, 0xc1, 0x1b, 0xf3, 0x01, 0xc2, 0x07, 0x58}: "PdmDxe",
		efi.GUID{0x6c, 0xf7, 0x7b, 0x0b, 0x1a, 0x72, 0xfb, 0x44, 0xa7, 0x58, 0x52, 0xe1, 0x3c, 0xa4, 0x57, 0xf1}: "DellSpiPartMxic",
		efi.GUID{0x6c, 0xfa, 0xba, 0xda, 0x94, 0xf3, 0xab, 0x4d, 0x83, 0x5f, 0x80, 0x12, 0xfd, 0x73, 0x07, 0x66}: "LEMSetVariableCtl",
		efi.GUID{0x6d, 0x01, 0xe7, 0x84, 0xb8, 0x1e, 0x37, 0x46, 0xb0, 0x1e, 0x9e, 0xed, 0x01, 0x8c, 0x7a, 0xe0}: "BiosGuardNvs",
		efi.GUID{0x6d, 0x02, 0xe1, 0x7a, 0xfa, 0xc7, 0x67, 0x48, 0x9c, 0x14, 0xa0, 0x05, 0x34, 0xa6, 0xc5, 0x47}: "DMIRecovery",
		efi.GUID{0x6d, 0x09, 0xf6, 0x50, 0x98, 0x7c, 0x78, 0x4c, 0x9a, 0x1d, 0xc5, 0xa1, 0x83, 0x3b, 0x6a, 0x88}: "AmiTcgNvflagSample",
		efi.GUID{0x6d, 0x0b, 0x8b, 0xc8, 0xfc, 0x0d, 0xa7, 0x49, 0x9c, 0xb4, 0x49, 0x07, 0x4b, 0x4c, 0x3a, 0x78}: "EfiStorageSecurityCommandProtocolGuid",
		efi.GUID{0x6d, 0x12, 0xb7, 0x7e, 0x5e, 0xc4, 0xd0, 0x4b, 0x93, 0x57, 0x7f, 0x50, 0x7c, 0x5c, 0x9c, 0xf9}: "RomLayoutPei",
		efi.GUID{0x6d, 0x15, 0x34, 0x79, 0xce, 0xcf, 0x0e, 0x46, 0x92, 0xf5, 0xa0, 0x79, 0x09, 0xa5, 0x9e, 0xca}: "BiosGuardModule",
		efi.GUID{0x6d, 0x17, 0xd9, 0x8d, 0x87, 0xee, 0x0e, 0x4f, 0x8a, 0x84, 0x3f, 0x99, 0x83, 0x11, 0xf9, 0x30}: "Dhcp6Dxe",
		efi.GUID{0x6d, 0x1b, 0x57, 0xdc, 0x70, 0xd5, 0x62, 0x48, 0xa9, 0x5f, 0x29, 0x9b, 0x28, 0xfd, 0xc2, 0xd2}: "DellAdvSysMgmtConfigDxe",
		efi.GUID{0x6d, 0x29, 0xf5, 0x96, 0xf7, 0x05, 0x3c, 0x4f, 0x84, 0x67, 0xe4, 0x56, 0x89, 0x0e, 0x0c, 0xb5}: "EdkiiEndOfS3Resume",
		efi.GUID{0x6d, 0x2a, 0x90, 0x6f, 0xf1, 0x97, 0xdd, 0x42, 0xa7, 0x17, 0x8a, 0xdd, 0x61, 0x70, 0xc3, 0x65}: "AcpiUpdate",
		efi.GUID{0x6d, 0x2c, 0xc4, 0x3b, 0xec, 0xab, 0xba, 0x41, 0x8c, 0xcb, 0xd8, 0xe0, 0xef, 0x1c, 0xef, 0x85}: "PCHPolicy",
		efi.GUID{0x6d, 0x2c, 0xe7, 0x3f, 0x12, 0x36, 0x61, 0x40, 0x84, 0xaf, 0x80, 0xc5, 0xb7, 0xac, 0x6e, 0x25}: "PeiIpmiCmosClear",
		efi.GUID{0x6d, 0x38, 0x2c, 0x22, 0xbc, 0x5a, 0xb4, 0x4f, 0xb1, 0x24, 0xfb, 0xb8, 0x24, 0x88, 0xac, 0xf4}: "PlatformPei",
		efi.GUID{0x6d, 0x3a, 0x91, 0x54, 0xee, 0xf4, 0xdb, 0x4c, 0x84, 0x75, 0x74, 0x06, 0x2b, 0xfc, 0xec, 0xf5}: "NvramMailboxAddressVariable",
		efi.GUID{0x6d, 0x3b, 0xc9, 0x82, 0xed, 0x68, 0x0e, 0x44, 0xa8, 0x26, 0xbd, 0xc7, 0xae, 0xf8, 0xee, 0x0d}: "WirelessBluetoothDetect",
		efi.GUID{0x6d, 0x40, 0xc6, 0x33, 0x6b, 0x2f, 0xb5, 0x41, 0x87, 0x05, 0x52, 0xba, 0xfb, 0x63, 0x3c, 0x09}: "AlertStandardFormatDxe",
		efi.GUID{0x6d, 0x46, 0x3c, 0xf2, 0x4a, 0xd2, 0xe4, 0x46, 0xa9, 0x51, 0xa5, 0x8f, 0xbc, 0x5e, 0xce, 0x7f}: "KEMaEeepDxe",
		efi.GUID{0x6d, 0x56, 0x32, 0x4e, 0x9e, 0x8e, 0x52, 0x4f, 0x81, 0xd3, 0x5b, 0xb9, 0x71, 0x5f, 0x97, 0x27}: "OvmfPkKek1AppPrefix",
		efi.GUID{0x6d, 0x59, 0x96, 0xef, 0xd8, 0xf1, 0x76, 0x4b, 0x8a, 0xbe, 0x70, 0x0e, 0x03, 0xc1, 0xca, 0x74}: "HspAcpifTpmSmm",
		efi.GUID{0x6d, 0x69, 0x1c, 0x3e, 0xf0, 0xfc, 0xa7, 0x45, 0x85, 0xa7, 0xe8, 0x6c, 0x2a, 0x1c, 0x10, 0x80}: "UefiDevicePathLibOptionalDevicePathProtocol",
		efi.GUID{0x6d, 0x76, 0x79, 0xd5, 0xc0, 0x54, 0x51, 0x4a, 0xaa, 0x39, 0x41, 0x1e, 0x59, 0x98, 0x1d, 0xf2}: "UsbOcUpdateDxeBlizzard",
		efi.GUID{0x6d, 0x79, 0x41, 0xf5, 0x2e, 0xa6, 0x54, 0x49, 0xa7, 0x75, 0x95, 0x84, 0xf6, 0x1b, 0x9c, 0xdd}: "EfiTcgProtocolGuid",
		efi.GUID{0x6d, 0x83, 0xda, 0x2a, 0x3d, 0x0a, 0xd6, 0x43, 0xa2, 0x5a, 0x38, 0x45, 0xca, 0xd2, 0xd4, 0x00}: "EfiCpuTokenSpace",
		efi.GUID{0x6d, 0x84, 0x72, 0xfe, 0x19, 0x6c, 0x37, 0x42, 0x90, 0x52, 0x9c, 0x69, 0x3c, 0xf4, 0x09, 0xe3}: "AmdFabricSspPei",
		efi.GUID{0x6d, 0x8b, 0x98, 0xc0, 0xf6, 0xc3, 0x25, 0x4c, 0xb5, 0x65, 0xec, 0xb1, 0x16, 0x91, 0x24, 0x11}: "OemDisplayRule",
		efi.GUID{0x6d, 0x8d, 0xa5, 0xc4, 0x77, 0x36, 0xcb, 0x49, 0xa0, 0x0a, 0x94, 0x70, 0x76, 0x5f, 0xb5, 0x5e}: "AddPerfRecordProtocolGuid",
		efi.GUID{0x6d, 0x93, 0x96, 0x66, 0x37, 0x36, 0x7c, 0x46, 0x87, 0xcb, 0x14, 0xea, 0x82, 0x48, 0x94, 0x8c}: "SimpleTextInOutSerial",
		efi.GUID{0x6d, 0x94, 0xf9, 0x5d, 0x70, 0x81, 0xb5, 0x4f, 0x85, 0x4f, 0xa9, 0x88, 0x65, 0xf9, 0x87, 0x8f}: "gear5",
		efi.GUID{0x6d, 0x95, 0xd7, 0xde, 0x20, 0x7e, 0x20, 0x4f, 0x91, 0xa1, 0x19, 0x04, 0x39, 0xb0, 0x4d, 0x5b}: "SmbiosGetFlashData",
		efi.GUID{0x6d, 0x96, 0xcc, 0x3a, 0x33, 0x8e, 0xc6, 0x45, 0xb4, 0xfe, 0x62, 0x72, 0x4b, 0xcd, 0x15, 0xa9}: "AhciBusDxe",
		efi.GUID{0x6d, 0x99, 0xe7, 0x91, 0x81, 0x76, 0x7c, 0x47, 0xbd, 0xfe, 0xad, 0x11, 0x44, 0x7e, 0x66, 0xce}: "RealtekLomSmm",
		efi.GUID{0x6d, 0x9b, 0x45, 0x48, 0x45, 0x0e, 0xae, 0x46, 0xb5, 0xc4, 0xe7, 0x01, 0xa2, 0x5a, 0x0d, 0x6d}: "PlatformCrisis",
		efi.GUID{0x6d, 0xae, 0xf1, 0x99, 0xcd, 0xa4, 0xef, 0x43, 0x9a, 0x85, 0xb0, 0xfd, 0x4f, 0x6c, 0xc0, 0x91}: "LegacyBiosPlatform",
		efi.GUID{0x6d, 0xb1, 0xa7, 0x7a, 0x14, 0x0e, 0x51, 0x49, 0x8b, 0x85, 0x3f, 0x65, 0x72, 0xfc, 0xe2, 0x58}: "SystemErrorLogPei",
		efi.GUID{0x6d, 0xb8, 0x31, 0xfe, 0x7c, 0xec, 0x24, 0x4f, 0x82, 0x1a, 0x60, 0x3f, 0xf8, 0xbb, 0xa5, 0x68}: "OnBoardLanPxeDriver",
		efi.GUID{0x6d, 0xbd, 0xe1, 0x93, 0xc6, 0x6c, 0xfa, 0x4e, 0xa0, 0x47, 0x3c, 0x1e, 0xd9, 0xe9, 0x5f, 0x89}: "LenovoTpmConfigDxe",
		efi.GUID{0x6d, 0xc3, 0xce, 0x5a, 0xb3, 0x23, 0x4f, 0x4c, 0xa2, 0xb7, 0xb2, 0xbf, 0xd7, 0x2a, 0x05, 0x9e}: "ProcessorIdm",
		efi.GUID{0x6d, 0xc4, 0x57, 0x1a, 0x3e, 0xb9, 0x36, 0x40, 0x8f, 0x33, 0x11, 0x74, 0xca, 0x09, 0x18, 0x57}: "SystemDefaultVariableManagerPei",
		efi.GUID{0x6d, 0xdb, 0xce, 0x9b, 0xca, 0x13, 0x3e, 0x47, 0xb6, 0x05, 0x8a, 0x47, 0x68, 0x87, 0x29, 0xfa}: "ODMDXE",
		efi.GUID{0x6d, 0xdb, 0xda, 0xdc, 0x0b, 0x88, 0xb9, 0x4c, 0x9c, 0xc0, 0x50, 0x6c, 0x3e, 0x18, 0x2c, 0xb2}: "BackupBiosInfo",
		efi.GUID{0x6d, 0xdd, 0xe6, 0x69, 0x9e, 0xf0, 0x5f, 0x48, 0x96, 0x27, 0xeb, 0x70, 0xe9, 0xcf, 0xc8, 0x2a}: "UbaInitDxe",
		efi.GUID{0x6d, 0xdf, 0x72, 0xe4, 0x4f, 0x2b, 0xac, 0x44, 0x91, 0x65, 0xca, 0x2f, 0xcd, 0x5a, 0xb1, 0xf5}: "AmiCspFlashPeiLibNull",
		efi.GUID{0x6d, 0xe1, 0x81, 0x11, 0x11, 0xaf, 0x52, 0x4c, 0x84, 0x7e, 0x51, 0x6d, 0xd0, 0x9b, 0xd3, 0x76}: "DellCenturyRolloverSmm",
		efi.GUID{0x6d, 0xe3, 0x3f, 0x2b, 0x59, 0xbe, 0x10, 0x41, 0x8f, 0x42, 0x7b, 0xad, 0x91, 0x0c, 0x96, 0x63}: "SsidDxe",
		efi.GUID{0x6d, 0xe3, 0x8d, 0xdf, 0x41, 0xd2, 0x47, 0x49, 0x87, 0xf1, 0x36, 0xf9, 0xed, 0xe5, 0x45, 0xd8}: "ASUSFS",
		efi.GUID{0x6d, 0xe4, 0x07, 0x27, 0xd7, 0xdb, 0xc2, 0x41, 0x9c, 0x04, 0xc9, 0xfd, 0xb8, 0xba, 0xd8, 0x6c}: "JpegDecoderDxe",
		efi.GUID{0x6d, 0xed, 0x19, 0x85, 0x8a, 0x22, 0x7d, 0x4a, 0xa9, 0xe3, 0x6e, 0x24, 0xd9, 0x4f, 0xe2, 0x2f}: "AmdCpmAdaptiveS4Peim",
		efi.GUID{0x6d, 0xf3, 0x24, 0x86, 0xe0, 0x6d, 0xc3, 0x44, 0x83, 0x22, 0x74, 0xad, 0x41, 0x9d, 0x3a, 0x90}: "AmdErrorLogDxe",
		efi.GUID{0x6d, 0xf4, 0x4c, 0x17, 0x67, 0xb1, 0x6a, 0x4e, 0xb1, 0xcd, 0xd4, 0x1e, 0x24, 0xef, 0xa0, 0xf9}: "ASUSBackupSmm",
		efi.GUID{0x6d, 0xfe, 0xf9, 0xd4, 0x96, 0x16, 0x2a, 0x46, 0xac, 0x07, 0xc0, 0x09, 0xd1, 0xa0, 0x18, 0x9a}: "IdeConfigSetup",
		efi.GUID{0x6e, 0x06, 0x88, 0x13, 0x57, 0x3a, 0xfa, 0x4e, 0x98, 0xf3, 0xc1, 0x2f, 0x3a, 0x95, 0x8a, 0x29}: "EfiPeiSecurityPpiGuid",
		efi.GUID{0x6e, 0x0d, 0xd4, 0xca, 0x71, 0xc8, 0x98, 0x43, 0x91, 0x0d, 0x2d, 0x74, 0xee, 0x94, 0x71, 0x1a}: "AmiTseAfterTimeOutGuid",
		efi.GUID{0x6e, 0x0f, 0xf4, 0x13, 0xc1, 0x50, 0x73, 0x4b, 0xb1, 0xe2, 0x6e, 0x72, 0xd2, 0x1c, 0xb0, 0x4a}: "EfiUsbLegacyPlatformProtocolGuid",
		efi.GUID{0x6e, 0x10, 0xc2, 0x87, 0x90, 0x87, 0x9d, 0x45, 0xbd, 0x44, 0x2e, 0xf3, 0x2a, 0x68, 0xc3, 0xf9}: "IhisiServicesSmm",
		efi.GUID{0x6e, 0x10, 0xef, 0x95, 0x9f, 0x46, 0xd8, 0x41, 0xaf, 0xff, 0xca, 0x52, 0x92, 0xa4, 0xd9, 0x7c}: "AEPFreezeLockDxe",
		efi.GUID{0x6e, 0x13, 0x19, 0xd9, 0x5c, 0x86, 0x10, 0x4b, 0xb0, 0x99, 0x5d, 0x89, 0x7c, 0xfe, 0xde, 0x08}: "AmdCpmInitPeim",
		efi.GUID{0x6e, 0x17, 0xd9, 0x8d, 0x87, 0xee, 0x0e, 0x4f, 0x8a, 0x84, 0x3f, 0x99, 0x83, 0x11, 0xf9, 0x30}: "Dhcp4Dxe",
		efi.GUID{0x6e, 0x1a, 0x8d, 0x16, 0xa5, 0xf4, 0x8a, 0x44, 0x9e, 0x95, 0x79, 0x56, 0x61, 0xbb, 0x30, 0x67}: "ArmPciCpuIo2Dxe",
		efi.GUID{0x6e, 0x1b, 0x39, 0xff, 0xce, 0x07, 0x04, 0x49, 0xbf, 0xff, 0x12, 0xbe, 0x96, 0xd4, 0xac, 0xf1}: "FvbVariableStorageSmmRuntimeDxe",
		efi.GUID{0x6e, 0x20, 0xb9, 0xc0, 0xab, 0xb6, 0xf0, 0x4d, 0xb3, 0xd6, 0x28, 0x6a, 0xc7, 0x66, 0x98, 0xbd}: "DellD010AlegacyVideoRom",
		efi.GUID{0x6e, 0x23, 0x2f, 0xe2, 0x94, 0x50, 0xfd, 0x48, 0x80, 0x18, 0xcf, 0x46, 0xbb, 0x58, 0x45, 0x39}: "FjSystemResetSmm",
		efi.GUID{0x6e, 0x2f, 0x08, 0xfd, 0x91, 0x63, 0xbc, 0x4d, 0x86, 0xc3, 0xe3, 0x3c, 0xa1, 0x4f, 0x34, 0x53}: "HpPlatformFormsDxe",
		efi.GUID{0x6e, 0x31, 0x59, 0x7b, 0xdf, 0xe9, 0x5f, 0x43, 0x98, 0xcd, 0x57, 0x26, 0x64, 0x5b, 0xe8, 0x63}: "EfiHfiPcieGen3Protocol",
		efi.GUID{0x6e, 0x39, 0x18, 0x11, 0xcc, 0x54, 0x89, 0x43, 0xbf, 0xd1, 0x97, 0xd2, 0xae, 0x13, 0xe1, 0x2c}: "FjGabiCoreSmm",
		efi.GUID{0x6e, 0x3b, 0x15, 0x4a, 0xa1, 0x85, 0x82, 0x49, 0x98, 0xf4, 0x6a, 0x8c, 0xfc, 0xa4, 0xab, 0xa1}: "EfiExtendedSalSensorServicesProtocol",
		efi.GUID{0x6e, 0x3c, 0x7b, 0x70, 0xa6, 0x99, 0x17, 0x4e, 0x84, 0xa0, 0x40, 0x28, 0x4c, 0x1b, 0x3f, 0x38}: "LenovoPiSaveStateAccess",
		efi.GUID{0x6e, 0x43, 0xf7, 0x92, 0x95, 0x73, 0xa1, 0x4d, 0xa7, 0xbe, 0xf3, 0x52, 0xf0, 0xbc, 0xd7, 0x9c}: "LibContainer",
		efi.GUID{0x6e, 0x47, 0x08, 0x61, 0x45, 0x4c, 0xc0, 0x4e, 0xa7, 0xf2, 0x5c, 0x2b, 0x31, 0x70, 0xeb, 0x71}: "WlanSupplicantDriver",
		efi.GUID{0x6e, 0x47, 0x42, 0x29, 0x3e, 0x54, 0x04, 0x45, 0xa0, 0xd2, 0x0b, 0x21, 0x15, 0xe4, 0xa3, 0xc4}: "SwSmi534D0740",
		efi.GUID{0x6e, 0x47, 0x52, 0xbc, 0x7e, 0xf6, 0x01, 0x43, 0xb2, 0x62, 0x36, 0x9c, 0x48, 0x78, 0xaa, 0xc2}: "PlatformSeCHookProtocolGuid",
		efi.GUID{0x6e, 0x4f, 0xf0, 0x69, 0xcf, 0xbc, 0xf8, 0x45, 0x89, 0x4e, 0x2c, 0x68, 0x08, 0x8f, 0x94, 0xff}: "I2cKbDxe",
		efi.GUID{0x6e, 0x50, 0xc5, 0x13, 0x31, 0x82, 0x5e, 0x41, 0x9e, 0xbc, 0x88, 0xdd, 0x11, 0x5e, 0x38, 0x18}: "SmbiosElog",
		efi.GUID{0x6e, 0x53, 0x07, 0x67, 0xaf, 0x46, 0xd3, 0x42, 0x8f, 0x6c, 0x15, 0xf2, 0xf2, 0x02, 0xc2, 0x34}: "MXMdat",
		efi.GUID{0x6e, 0x61, 0x33, 0x78, 0x0d, 0xae, 0x4f, 0x59, 0x87, 0x0c, 0x80, 0xe6, 0x86, 0x82, 0xd5, 0x87}: "ThunkProtocolList",
		efi.GUID{0x6e, 0x63, 0xad, 0xd7, 0x97, 0xb9, 0x9b, 0x45, 0xbf, 0x3f, 0x88, 0x46, 0x89, 0x79, 0x80, 0xe1}: "EfiHiiProtocolGuid",
		efi.GUID{0x6e, 0x67, 0x4e, 0xb7, 0x2e, 0x3b, 0x3f, 0x48, 0x94, 0x58, 0xc3, 0x78, 0xfe, 0x0a, 0xc6, 0x9f}: "Tcm32FileGuid",
		efi.GUID{0x6e, 0x6c, 0x47, 0x5c, 0x09, 0xbb, 0xe1, 0x11, 0x86, 0xa7, 0x78, 0xe7, 0xd1, 0xaf, 0x36, 0xd1}: "HpNetworkTransferDriver",
		efi.GUID{0x6e, 0x6f, 0x99, 0xbd, 0x67, 0x77, 0x27, 0x48, 0x92, 0x08, 0xb1, 0xc2, 0x99, 0x00, 0x0e, 0x4a}: "PspResource",
		efi.GUID{0x6e, 0x74, 0xe5, 0x65, 0x14, 0x9c, 0x7d, 0x46, 0xb5, 0xb3, 0x93, 0x2a, 0x66, 0xd5, 0x9f, 0x79}: "XhciPei",
		efi.GUID{0x6e, 0x87, 0x76, 0x70, 0xc2, 0x80, 0xe6, 0x4e, 0xaa, 0xd2, 0x28, 0xb3, 0x49, 0xa6, 0x86, 0x5b}: "EfiCertX509Sha384Guid",
		efi.GUID{0x6e, 0x88, 0xb0, 0x75, 0x6a, 0xcd, 0x9f, 0x46, 0xae, 0x0b, 0x8c, 0xed, 0x90, 0x33, 0xd1, 0x99}: "EfiBpdtLibBp2DataGuid",
		efi.GUID{0x6e, 0x8b, 0x96, 0x06, 0x20, 0xf6, 0x8d, 0x4e, 0xa6, 0xa6, 0x52, 0x55, 0x23, 0x54, 0xdd, 0x75}: "LenovoDxeRicohInit",
		efi.GUID{0x6e, 0x8c, 0x43, 0x63, 0x1c, 0x97, 0x40, 0x4e, 0x8f, 0x0b, 0x11, 0x09, 0x45, 0x7b, 0xe3, 0x33}: "LenovoCpuInitPhnxDxe",
		efi.GUID{0x6e, 0x91, 0x64, 0x6f, 0x7a, 0x9f, 0x35, 0x4c, 0xb9, 0x52, 0xcd, 0x04, 0x1e, 0xfb, 0x05, 0xa3}: "DefaultKEKFile",
		efi.GUID{0x6e, 0x92, 0x71, 0x6f, 0xce, 0x60, 0x8d, 0x42, 0xaa, 0x58, 0xa3, 0xd9, 0xfb, 0x87, 0x94, 0x29}: "IfConfig6",
		efi.GUID{0x6e, 0x93, 0x87, 0x69, 0x34, 0xed, 0xdb, 0x44, 0xae, 0x97, 0x1f, 0xa5, 0xe4, 0xed, 0x21, 0x16}: "HelloWorld",
		efi.GUID{0x6e, 0x9f, 0x43, 0x69, 0x94, 0xfa, 0x28, 0x44, 0xae, 0x02, 0x1f, 0x5c, 0x22, 0xec, 0x72, 0xae}: "AdlinkMeConfig",
		efi.GUID{0x6e, 0xaa, 0x11, 0x2d, 0xb1, 0xea, 0xe1, 0x44, 0xa1, 0xe6, 0xe5, 0x11, 0xfc, 0xb0, 0x14, 0x98}: "QCASUPP",
		efi.GUID{0x6e, 0xab, 0x42, 0x55, 0x1e, 0x50, 0x60, 0x4d, 0x97, 0xdb, 0xed, 0x71, 0x75, 0x84, 0xbd, 0x1e}: "DellTcg2EarlyDxe",
		efi.GUID{0x6e, 0xb5, 0x28, 0x1f, 0x6a, 0xd2, 0xfd, 0x48, 0x9f, 0xac, 0x9e, 0x18, 0xa2, 0xc5, 0xbb, 0xdb}: "CnvUefiVariables",
		efi.GUID{0x6e, 0xb6, 0xf7, 0x28, 0x6b, 0xdf, 0x34, 0x4d, 0xa4, 0x20, 0x91, 0xca, 0x10, 0x8e, 0x9d, 0x00}: "SecureFlashAuthenticationPei",
		efi.GUID{0x6e, 0xbf, 0xba, 0xde, 0xe4, 0x49, 0x21, 0x4c, 0x84, 0x03, 0xa1, 0xfb, 0x8f, 0x80, 0x3a, 0x9d}: "FjSysmanAcpiStatesBin",
		efi.GUID{0x6e, 0xc0, 0x13, 0xde, 0x32, 0xf5, 0xda, 0x49, 0xa3, 0x19, 0x5f, 0x7d, 0xd0, 0xf6, 0x03, 0xc2}: "GopFirmwareVersionDxe",
		efi.GUID{0x6e, 0xc3, 0x72, 0x8c, 0xcc, 0xda, 0x81, 0x4e, 0x8d, 0x60, 0xff, 0xa6, 0x1d, 0x88, 0xff, 0x54}: "EfiPeiPlatformpeiExecutedPpi",
		efi.GUID{0x6e, 0xc9, 0x01, 0x26, 0x3b, 0x24, 0x09, 0x45, 0xab, 0x14, 0xdf, 0x22, 0x28, 0xe5, 0xb4, 0x01}: "DellSbSmm",
		efi.GUID{0x6e, 0xcf, 0x69, 0x04, 0x81, 0x1a, 0xff, 0x4f, 0xac, 0x00, 0x16, 0x08, 0x47, 0x2e, 0xa3, 0x07}: "MsdmUpdateSmm",
		efi.GUID{0x6e, 0xd3, 0x29, 0x79, 0x8a, 0x96, 0x4b, 0x4a, 0x87, 0xce, 0x23, 0x75, 0xb1, 0xc7, 0x31, 0x1d}: "DxePortingSample",
		efi.GUID{0x6e, 0xd6, 0x2a, 0x66, 0x2d, 0xf5, 0xf6, 0x47, 0xa3, 0x50, 0x48, 0x8d, 0xb9, 0xf8, 0xaf, 0x68}: "FirmwareUserInterface",
		efi.GUID{0x6e, 0xd8, 0x3f, 0xcb, 0xa3, 0x38, 0x03, 0x4c, 0x9a, 0x5c, 0x90, 0xcf, 0xa3, 0xa2, 0xab, 0x7a}: "EfiExtendedSalMcaLogServicesProtocolGuid",
		efi.GUID{0x6e, 0xdd, 0x7a, 0x1d, 0xda, 0xb2, 0x0b, 0x4b, 0xb2, 0x9f, 0x49, 0xcb, 0x42, 0xf4, 0x63, 0x56}: "EfiMemoryProducer",
		efi.GUID{0x6e, 0xde, 0x98, 0x5c, 0x69, 0xcb, 0x5f, 0x46, 0xb6, 0xb9, 0xf6, 0x61, 0xe2, 0x6e, 0x6f, 0x9d}: "LibGdtoa",
		efi.GUID{0x6e, 0xde, 0xf0, 0x44, 0x8c, 0x4d, 0x45, 0x40, 0xa8, 0xc7, 0x4d, 0xd1, 0x68, 0x85, 0x6b, 0x9e}: "EfiRngAlgorithmSp80090Ctr256Guid",
		efi.GUID{0x6e, 0xe4, 0x52, 0x9d, 0x7e, 0xf0, 0xe8, 0x44, 0x9a, 0x90, 0xf8, 0x57, 0x6c, 0x91, 0xc2, 0x11}: "BaseFspDebugLibSerialPort",
		efi.GUID{0x6e, 0xe5, 0xbe, 0xd9, 0xdc, 0x75, 0xd9, 0x49, 0xb4, 0xd7, 0xb5, 0x34, 0x21, 0x0f, 0x63, 0x7a}: "EfiCertDbGuid",
		efi.GUID{0x6e, 0xed, 0x1a, 0x53, 0xee, 0x3d, 0xeb, 0x45, 0x8d, 0xf1, 0xb7, 0x0a, 0xdb, 0x1f, 0x88, 0x5d}: "TrueTypeDecoderDxe",
		efi.GUID{0x6e, 0xfc, 0x81, 0xf2, 0xc4, 0xf4, 0x1c, 0x43, 0x96, 0x2b, 0x2f, 0x13, 0xae, 0x79, 0x84, 0xec}: "EfiSbPcieErrorLogDispatchProtocol",
		efi.GUID{0x6f, 0x02, 0x0b, 0x29, 0x05, 0x69, 0x12, 0x46, 0xba, 0x0f, 0xf6, 0x35, 0xdd, 0xe3, 0x52, 0x85}: "ErrorTriangle",
		efi.GUID{0x6f, 0x04, 0xa1, 0x95, 0xa7, 0x5e, 0x6d, 0x4c, 0x86, 0xa7, 0xaa, 0x91, 0xb7, 0x42, 0x1e, 0x68}: "CspFlashPeiLibNull",
		efi.GUID{0x6f, 0x12, 0x9f, 0x32, 0x9e, 0x29, 0xc5, 0x4b, 0x83, 0x10, 0x17, 0x9f, 0x10, 0xeb, 0x46, 0xc9}: "DellSmbProtocolAccess",
		efi.GUID{0x6f, 0x20, 0x79, 0x5a, 0xcb, 0xe6, 0x81, 0x4a, 0x8b, 0x8f, 0x70, 0xd1, 0xe2, 0x4b, 0xfa, 0x2f}: "OemASMediaUSBPortDisable",
		efi.GUID{0x6f, 0x21, 0xa3, 0xd1, 0xe5, 0x63, 0x31, 0x4f, 0x8d, 0x30, 0xff, 0x53, 0xf7, 0xca, 0xbf, 0x5c}: "MpCpuDxe",
		efi.GUID{0x6f, 0x29, 0x99, 0x51, 0x08, 0x28, 0xfa, 0x4a, 0x94, 0xc4, 0x99, 0xf6, 0xb0, 0x6c, 0x87, 0x1e}: "ACPIS4Smm",
		efi.GUID{0x6f, 0x2e, 0x70, 0x14, 0xfb, 0x73, 0xd5, 0x46, 0xbf, 0x5b, 0xf0, 0xad, 0x78, 0x1a, 0x17, 0xb7}: "AuthenticationPromptProtocol",
		efi.GUID{0x6f, 0x47, 0x44, 0xc1, 0x18, 0xf1, 0x84, 0x4c, 0xa9, 0x36, 0x41, 0x7c, 0x8a, 0xfb, 0xd4, 0x37}: "GenericUSBDebugger",
		efi.GUID{0x6f, 0x48, 0xb9, 0x6d, 0xf6, 0x6a, 0x90, 0x40, 0x98, 0x4d, 0x23, 0x84, 0x82, 0xce, 0x3e, 0xa4}: "BdatAccessHandler",
		efi.GUID{0x6f, 0x4b, 0xb0, 0xc5, 0xe8, 0x07, 0x63, 0x46, 0x93, 0x45, 0xbc, 0x72, 0xec, 0xcb, 0xb3, 0x97}: "FjNvramVariablesAccessReferenceDxe",
		efi.GUID{0x6f, 0x4f, 0xa1, 0x60, 0xb9, 0x55, 0xa3, 0x47, 0xb0, 0x67, 0x01, 0xa9, 0x30, 0x27, 0xf3, 0xfe}: "AppleMemoryTest",
		efi.GUID{0x6f, 0x5d, 0xcc, 0x77, 0xa8, 0xe1, 0xba, 0x4a, 0x8a, 0xe8, 0x1d, 0x92, 0xde, 0x3b, 0x50, 0xf1}: "OemNVME",
		efi.GUID{0x6f, 0x5e, 0x98, 0x17, 0x78, 0xe7, 0x94, 0x4d, 0xae, 0xfa, 0xc5, 0xdd, 0x2b, 0x77, 0xe1, 0x86}: "QemuFwCfgAcpiPlatform",
		efi.GUID{0x6f, 0x67, 0xcf, 0x01, 0x01, 0x6f, 0xa3, 0x4f, 0x97, 0x89, 0xb6, 0x32, 0x2d, 0x89, 0x03, 0x94}: "AmdCcxZen4Pei",
		efi.GUID{0x6f, 0x6c, 0x07, 0x42, 0xf3, 0x0c, 0xe1, 0x4a, 0xb3, 0xa8, 0x49, 0x78, 0x9c, 0xdd, 0x57, 0xdc}: "PSUDxe",
		efi.GUID{0x6f, 0x7b, 0x3b, 0x3b, 0xde, 0xa2, 0x1e, 0x4f, 0x9b, 0x84, 0xc6, 0xdd, 0xc1, 0xb3, 0x6d, 0x4b}: "OemSleepSmi",
		efi.GUID{0x6f, 0x7c, 0x56, 0x94, 0xa9, 0xf7, 0x29, 0x42, 0x13, 0x30, 0xfe, 0x11, 0xcc, 0xab, 0x3a, 0x11}: "AmiInternalUcodeHob",
		efi.GUID{0x6f, 0x7e, 0x1f, 0x41, 0x66, 0x46, 0xb2, 0x58, 0xd6, 0x9e, 0xd6, 0x80, 0xc0, 0xf6, 0x8b, 0xe2}: "SystemAcpiAddedValueDxe",
		efi.GUID{0x6f, 0x8c, 0x2d, 0x98, 0xf6, 0xf6, 0x35, 0x41, 0xa3, 0x09, 0xa4, 0x59, 0x3e, 0xa5, 0x64, 0x17}: "AmiInternalFactoryTdcTdpHob",
		efi.GUID{0x6f, 0x97, 0x18, 0x0a, 0xa6, 0x6c, 0x5b, 0x40, 0xaf, 0x4b, 0x27, 0xb8, 0xf7, 0xf6, 0xdb, 0x98}: "AmiUsbIadProtocol",
		efi.GUID{0x6f, 0x9b, 0xe8, 0x95, 0xdf, 0x73, 0xe1, 0x47, 0x8f, 0x9b, 0xde, 0x52, 0xbd, 0xd3, 0x7f, 0x53}: "OemPcdUpdate",
		efi.GUID{0x6f, 0xb3, 0x54, 0x7a, 0x45, 0xf7, 0x2c, 0x46, 0xb1, 0x1f, 0x16, 0xe0, 0x3e, 0x52, 0xb6, 0x17}: "AsusSpdTransfer",
		efi.GUID{0x6f, 0xbb, 0x03, 0xd3, 0x34, 0x74, 0xfd, 0x41, 0xbc, 0x8e, 0x09, 0x84, 0xa0, 0x3c, 0x9b, 0x7d}: "AmdCpmAcpPowerGatingDxe",
		efi.GUID{0x6f, 0xbb, 0x1a, 0x3c, 0x5a, 0x5a, 0x48, 0x4e, 0xbd, 0xf9, 0x5d, 0xed, 0xc5, 0x8e, 0x05, 0xab}: "FjGabiFtsSystemDataSmmBin",
		efi.GUID{0x6f, 0xbe, 0x8e, 0x85, 0x0f, 0x36, 0x5b, 0x41, 0xb7, 0xdc, 0x46, 0x3a, 0xae, 0xb0, 0x34, 0x12}: "TcgLegacy",
		efi.GUID{0x6f, 0xbe, 0xd1, 0xe0, 0x43, 0x1c, 0x4e, 0x41, 0xb5, 0x71, 0x73, 0xc8, 0xc3, 0x10, 0x5b, 0x18}: "UefiDriverAsix88179",
		efi.GUID{0x6f, 0xc1, 0x0e, 0x15, 0xb6, 0x0b, 0xa8, 0x42, 0xb6, 0x05, 0x79, 0x79, 0x4b, 0x89, 0xd1, 0x5b}: "DellEdiagsConfig",
		efi.GUID{0x6f, 0xc4, 0xa7, 0x14, 0x02, 0xbc, 0x47, 0x40, 0x9f, 0x18, 0xa5, 0xd7, 0x25, 0xd8, 0xbd, 0x19}: "EfiDFUResultGuid",
		efi.GUID{0x6f, 0xcf, 0x25, 0xbb, 0xd4, 0xf1, 0xd2, 0x11, 0x9a, 0x0c, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0xfd}: "EfiSerialIoProtocolGuid",
		efi.GUID{0x6f, 0xd2, 0x99, 0x45, 0x11, 0x1a, 0xb8, 0x49, 0xb9, 0x1f, 0x85, 0x87, 0x45, 0xcf, 0xf8, 0x24}: "AmiStandardDefaultsVariable",
		efi.GUID{0x6f, 0xd6, 0xa2, 0x24, 0xdd, 0xee, 0x86, 0x40, 0x90, 0x42, 0xf2, 0x6e, 0x47, 0x97, 0xee, 0x69}: "RootBridgesConnectedEventGroupGuid",
		efi.GUID{0x6f, 0xd6, 0xfc, 0xf1, 0x66, 0x89, 0x1e, 0x44, 0x90, 0x9c, 0x77, 0xf2, 0x11, 0xab, 0x9c, 0x3e}: "MERecoveryDxe",
		efi.GUID{0x6f, 0xd8, 0x91, 0x9c, 0xa2, 0xdd, 0x7d, 0x47, 0xb1, 0x22, 0x16, 0x60, 0xc5, 0x85, 0xcb, 0x9f}: "DellCpldUpdateDxe",
		efi.GUID{0x6f, 0xe4, 0x6a, 0xdb, 0x0b, 0xc2, 0xac, 0x45, 0x8e, 0x53, 0xed, 0x0b, 0x90, 0x01, 0x5e, 0x3c}: "AsusQualityIntSelfBin",
		efi.GUID{0x6f, 0xe9, 0x1d, 0xd6, 0xaa, 0x6a, 0x7a, 0x4b, 0xbf, 0x5e, 0xdd, 0xca, 0x93, 0x01, 0xde, 0xdd}: "DellHardwareFailureLogDxe",
		efi.GUID{0x6f, 0xec, 0x2e, 0x40, 0xfc, 0xd0, 0xfd, 0x4f, 0x99, 0x56, 0xfa, 0x98, 0x13, 0xea, 0x2d, 0x7a}: "AcerHwSupportSmm",
		efi.GUID{0x6f, 0xfb, 0x5d, 0x57, 0x09, 0x40, 0x5f, 0x49, 0xb2, 0x3e, 0xa6, 0xa0, 0x84, 0xce, 0xa5, 0x7b}: "Int40InterfaceSmm",
		efi.GUID{0x6f, 0xff, 0xdc, 0xc7, 0x2a, 0x6f, 0xc1, 0x4d, 0x91, 0xc6, 0xdf, 0x0b, 0xaf, 0xdb, 0xda, 0x46}: "VbtMipiSharpGuid",
		efi.GUID{0x70, 0x07, 0xc9, 0x7f, 0x89, 0x0e, 0x20, 0x4a, 0x81, 0x52, 0x6c, 0xb7, 0x77, 0xb5, 0x6f, 0x48}: "FlashInfoDxe",
		efi.GUID{0x70, 0x0a, 0x6e, 0xf7, 0xed, 0xb5, 0x38, 0x4c, 0xac, 0x9a, 0xe5, 0xf5, 0x4b, 0xf1, 0x6e, 0x34}: "DriverHealthFormSetGuid",
		efi.GUID{0x70, 0x22, 0x1d, 0x9f, 0x0f, 0x2e, 0x07, 0x4d, 0x94, 0x77, 0x58, 0x79, 0x89, 0xb8, 0xa3, 0x2c}: "InterWifiDriver",
		efi.GUID{0x70, 0x22, 0x1d, 0x9f, 0x0f, 0x2e, 0x07, 0x4d, 0x94, 0x77, 0x58, 0x79, 0x89, 0xb8, 0xa3, 0x2d}: "NetworkDevice",
		efi.GUID{0x70, 0x24, 0x75, 0x80, 0xde, 0x6e, 0x5d, 0x48, 0xac, 0x36, 0xdc, 0x1b, 0xa6, 0x60, 0x91, 0xee}: "LenovoSpecialSwSmi",
		efi.GUID{0x70, 0x37, 0x3a, 0xf4, 0x3d, 0x29, 0x34, 0x48, 0x8d, 0x5a, 0xda, 0xb7, 0x2f, 0x94, 0xd5, 0xe3}: "DefaultsManagerSmm",
		efi.GUID{0x70, 0x39, 0x78, 0x8c, 0x2a, 0xf0, 0x4d, 0x4a, 0xaf, 0x09, 0x87, 0x97, 0xa5, 0x1e, 0xec, 0x8d}: "PowerManagement",
		efi.GUID{0x70, 0x42, 0x2a, 0x7a, 0xba, 0x38, 0xc6, 0x45, 0xb5, 0x3c, 0xc8, 0x3b, 0x34, 0x2d, 0x5b, 0x15}: "TisPei",
		efi.GUID{0x70, 0x44, 0x23, 0x3c, 0xd3, 0x69, 0xe1, 0x42, 0xb3, 0x23, 0xc8, 0x09, 0x30, 0x0f, 0x39, 0x25}: "EfiPeiPlatformTypePurleyLbgepdvpPpi",
		efi.GUID{0x70, 0x45, 0x38, 0x06, 0x80, 0x16, 0x20, 0x46, 0x9d, 0x00, 0x6a, 0xd9, 0xe3, 0xcc, 0xb1, 0x9f}: "LenovoMtmFormatSmm",
		efi.GUID{0x70, 0x45, 0xa9, 0x12, 0x2f, 0xa2, 0x69, 0x40, 0xb5, 0x2e, 0xb7, 0x1e, 0xae, 0xe4, 0xe0, 0x6f}: "FjOemGlobalNVSDxe",
		efi.GUID{0x70, 0x46, 0x15, 0x3d, 0x15, 0x60, 0x25, 0x44, 0xb9, 0xc5, 0x80, 0x35, 0xe3, 0x4b, 0xe6, 0xfd}: "NvmExpressPei",
		efi.GUID{0x70, 0x51, 0x04, 0x14, 0x65, 0xca, 0xbc, 0x47, 0x9c, 0x15, 0x2d, 0xe3, 0x6d, 0x44, 0xae, 0xe9}: "SmcInBandDxe",
		efi.GUID{0x70, 0x5b, 0x0b, 0xae, 0x44, 0xd0, 0x56, 0x44, 0xba, 0x51, 0x97, 0x0e, 0x4c, 0x68, 0x70, 0xbf}: "EfiTraceHubStatusCodeHandleSmm",
		efi.GUID{0x70, 0x5b, 0x40, 0xaf, 0xa4, 0x23, 0xe9, 0x11, 0x96, 0xb9, 0xa0, 0xc5, 0x89, 0xef, 0x4e, 0x75}: "DellDiagUiManager",
		efi.GUID{0x70, 0x5d, 0xf0, 0xe9, 0x46, 0x99, 0xb9, 0x4a, 0xa7, 0xf7, 0x07, 0x0e, 0x92, 0xc4, 0x15, 0xbd}: "Int15BootTV",
		efi.GUID{0x70, 0x64, 0xf5, 0xb3, 0x41, 0x61, 0x21, 0x46, 0x8f, 0x19, 0x70, 0x4e, 0x57, 0x7a, 0xa9, 0xe8}: "DriverSampleInventoryGuid",
		efi.GUID{0x70, 0x7b, 0x41, 0x5b, 0x5f, 0x7f, 0x6f, 0x49, 0xa8, 0x03, 0x8a, 0x0a, 0x2c, 0xac, 0x34, 0xe3}: "EfiPlatformTypePurleyLbgepdvpProtocol",
		efi.GUID{0x70, 0x7f, 0xff, 0xc8, 0x85, 0x1b, 0x66, 0x4c, 0xa9, 0x83, 0x69, 0x69, 0x9f, 0x62, 0xe9, 0x1e}: "N19EP_GOP",
		efi.GUID{0x70, 0x8c, 0x49, 0xde, 0xda, 0x1e, 0x6b, 0x46, 0xab, 0xcf, 0xdd, 0x3a, 0xbc, 0x3d, 0x24, 0xb4}: "DummyMSOA",
		efi.GUID{0x70, 0x8d, 0x00, 0xe9, 0x4e, 0x2a, 0xea, 0x47, 0x8e, 0xc4, 0x72, 0xe2, 0x57, 0x67, 0xe5, 0xef}: "AmiBiosPpiFlaSManagementGuid",
		efi.GUID{0x70, 0x99, 0x8b, 0x3c, 0x0a, 0x87, 0xe4, 0x11, 0xb7, 0xc6, 0xb8, 0xe8, 0x56, 0x2c, 0xba, 0xfa}: "ChipsetGpioDxe",
		efi.GUID{0x70, 0x99, 0xe7, 0x73, 0x36, 0x49, 0x3b, 0x44, 0xb9, 0xa5, 0xe0, 0xb6, 0x1b, 0xc1, 0x28, 0x8e}: "PlatformVTdSampleDxe",
		efi.GUID{0x70, 0xa0, 0xee, 0xaa, 0x92, 0xc4, 0x69, 0x44, 0xb3, 0x78, 0xbb, 0xab, 0x20, 0x60, 0xa4, 0xa7}: "BiosAttributesMgr2Smm",
		efi.GUID{0x70, 0xa4, 0x97, 0x7e, 0xdb, 0xef, 0x02, 0x4d, 0x8f, 0xce, 0x61, 0x90, 0xd2, 0x7b, 0xa2, 0x96}: "EfiExtendedSalRtcServicesProtocolGuid",
		efi.GUID{0x70, 0xaa, 0xf7, 0x05, 0x4a, 0xa6, 0x2c, 0x43, 0x8c, 0xee, 0x4c, 0xde, 0xcb, 0x86, 0x71, 0xd7}: "A01ODMDxeDriver",
		efi.GUID{0x70, 0xb7, 0x8f, 0x12, 0x79, 0x5e, 0x76, 0x41, 0x9e, 0x51, 0x9b, 0xb2, 0x68, 0xa1, 0x7d, 0xd1}: "PciHostBridgeDxe",
		efi.GUID{0x70, 0xb7, 0x9e, 0x83, 0x64, 0x5c, 0xed, 0x4e, 0xa6, 0xd5, 0xec, 0x51, 0x5b, 0x2b, 0x2b, 0x23}: "PlatformVTdInfoSamplePei",
		efi.GUID{0x70, 0xba, 0x9f, 0xb0, 0x9f, 0x83, 0x79, 0x40, 0x92, 0x0b, 0x81, 0xd8, 0x96, 0x43, 0x61, 0xf6}: "AmdNbioSmuV8Pei",
		efi.GUID{0x70, 0xbd, 0x48, 0x8d, 0xa3, 0xc8, 0x06, 0x4c, 0x90, 0x1b, 0x74, 0x79, 0x46, 0xaa, 0xc3, 0x58}: "EfiIsaHcPpiGuid",
		efi.GUID{0x70, 0xbd, 0x69, 0x1b, 0xad, 0x9f, 0x0e, 0x4a, 0x8a, 0x3e, 0xdc, 0x15, 0xaa, 0x40, 0xfc, 0x56}: "LEMBIOSLock",
		efi.GUID{0x70, 0xcd, 0xa1, 0xd6, 0x33, 0x4b, 0x94, 0x49, 0xa6, 0xea, 0x37, 0x5f, 0x2c, 0xcc, 0x54, 0x37}: "EfiWheaElogFv",
		efi.GUID{0x70, 0xce, 0x46, 0x8d, 0x2d, 0xb6, 0xf7, 0x4c, 0x87, 0x5c, 0xbe, 0xc8, 0x01, 0x6d, 0x7d, 0x01}: "DellTcg2ConfigInfoTpm12",
		efi.GUID{0x70, 0xd1, 0xde, 0xdc, 0xad, 0x9a, 0x64, 0x4e, 0xbd, 0xd1, 0xf5, 0x5f, 0xa8, 0x6e, 0x75, 0xb1}: "ApobPhxDxe",
		efi.GUID{0x70, 0xd4, 0xdf, 0xee, 0x9a, 0x44, 0x15, 0x4b, 0x80, 0x38, 0xc8, 0x54, 0x87, 0xaf, 0x5e, 0x4c}: "HpCommonFlashInfoDxe",
		efi.GUID{0x70, 0xd7, 0xc8, 0x95, 0xa4, 0xe1, 0x22, 0x44, 0xb2, 0x63, 0xe3, 0x2f, 0x14, 0xfd, 0x81, 0x86}: "Ax88772b",
		efi.GUID{0x70, 0xdd, 0x9a, 0x69, 0x54, 0x85, 0x93, 0x49, 0x83, 0xf6, 0xd2, 0xcd, 0xc0, 0x81, 0xdd, 0x85}: "SerialCapsuleGuid",
		efi.GUID{0x70, 0xde, 0xfa, 0x8c, 0x06, 0x18, 0x0f, 0x44, 0xff, 0xff, 0xff, 0xff, 0xe7, 0xcb, 0x5d, 0xa6}: "XnotePlatformPolicyDxe",
		efi.GUID{0x70, 0xe4, 0xb1, 0x11, 0x5e, 0x25, 0xe3, 0x40, 0x95, 0x17, 0x30, 0x51, 0x3e, 0x3f, 0x14, 0xd3}: "GsensorExtendModeDXE",
		efi.GUID{0x70, 0xe7, 0x97, 0x09, 0x6e, 0x75, 0x39, 0x41, 0xbf, 0x3f, 0x7f, 0xc2, 0xa3, 0x08, 0x17, 0x7e}: "DellSmmS3",
		efi.GUID{0x70, 0xed, 0x31, 0xf2, 0x5a, 0x04, 0x73, 0x42, 0xa1, 0x56, 0xc3, 0x44, 0x74, 0x8f, 0x08, 0x3f}: "RtcLossOptionSmm",
		efi.GUID{0x70, 0xf0, 0xdf, 0xb1, 0x22, 0x13, 0xd9, 0x4c, 0xa5, 0xb0, 0xf5, 0x6b, 0xa2, 0xb5, 0x4e, 0x23}: "AmdNbioGfxMDNDxe",
		efi.GUID{0x70, 0xf3, 0x6b, 0x73, 0x8f, 0xe3, 0xf1, 0x4a, 0x85, 0x0f, 0x97, 0x36, 0x0e, 0xd2, 0x29, 0xa8}: "PlatformResetNotifySmm",
		efi.GUID{0x70, 0xf3, 0xdb, 0xcd, 0xa5, 0x3d, 0xd9, 0x46, 0x9d, 0x0a, 0xbf, 0xc1, 0x12, 0xec, 0x53, 0x16}: "OemSsid",
		efi.GUID{0x70, 0xf4, 0xe7, 0x30, 0xb3, 0x4e, 0x56, 0x48, 0x8c, 0x83, 0x31, 0x74, 0x1a, 0x20, 0xf8, 0x77}: "SdevTableDxe",
		efi.GUID{0x70, 0xf6, 0x5b, 0xb6, 0x37, 0xfc, 0x25, 0x42, 0xab, 0x85, 0xec, 0x96, 0x0a, 0x7a, 0x1e, 0xd9}: "UsraRegisterFilterLibNull",
		efi.GUID{0x70, 0xf7, 0x6f, 0xf3, 0xe1, 0xa7, 0xcf, 0x42, 0x9e, 0xd2, 0x56, 0xf0, 0xf2, 0x71, 0xf4, 0x4c}: "EfiManagedNetworkServiceBindingProtocolGuid",
		efi.GUID{0x70, 0xfa, 0xcd, 0x44, 0x7c, 0x2c, 0x91, 0x47, 0x9a, 0xa3, 0xea, 0xe8, 0x77, 0x7f, 0x0a, 0x8b}: "X11DPGPeiDriver",
		efi.GUID{0x70, 0xfb, 0x22, 0xb4, 0x35, 0xe8, 0x8d, 0x44, 0xa9, 0x21, 0xeb, 0xa4, 0x60, 0xe1, 0x05, 0xb6}: "SmmIpmiLibSmmIpmiProtocol",
		efi.GUID{0x70, 0xfd, 0x83, 0xa8, 0x7e, 0x4e, 0x17, 0x4b, 0x8e, 0xbb, 0xc5, 0x64, 0x6f, 0xf1, 0x54, 0xca}: "SpiMouseDxe",
		efi.GUID{0x71, 0x05, 0x93, 0xb3, 0xba, 0xbe, 0xc5, 0x4f, 0x92, 0x03, 0x94, 0x27, 0x24, 0x2e, 0x6a, 0x43}: "EfiBluetoothHcProtocolGuid",
		efi.GUID{0x71, 0x12, 0x41, 0xf8, 0x7d, 0x78, 0xd3, 0x4c, 0xb1, 0x42, 0x88, 0xa0, 0x9f, 0x93, 0xd8, 0xb4}: "FjFlashServiceSmm",
		efi.GUID{0x71, 0x17, 0x55, 0xdb, 0x49, 0x44, 0x87, 0x43, 0x90, 0x8d, 0xf7, 0x06, 0x85, 0xb1, 0xdc, 0xaf}: "PlatformMilestoneHookSmm",
		efi.GUID{0x71, 0x18, 0x81, 0x63, 0xd2, 0xcc, 0x42, 0x10, 0xaa, 0xcb, 0x5e, 0x5b, 0x88, 0xff, 0x6e, 0x68}: "DiagAccess",
		efi.GUID{0x71, 0x1b, 0x25, 0xef, 0xed, 0xce, 0x4e, 0x48, 0x82, 0xe3, 0x3a, 0x1f, 0x34, 0xf5, 0x12, 0xe2}: "EfiQuarkSCSocIdTokenSpaceGuid",
		efi.GUID{0x71, 0x1f, 0xdd, 0xf5, 0xe2, 0xc3, 0x3d, 0x47, 0x84, 0xd5, 0x34, 0x1a, 0x37, 0x40, 0x54, 0xaf}: "SystemFlashCommunicationDataProtocol",
		efi.GUID{0x71, 0x29, 0xa0, 0xc0, 0x5c, 0xc4, 0xa6, 0x47, 0xaa, 0xaa, 0x3f, 0x08, 0x9a, 0x7b, 0x7a, 0x50}: "DellRmtPlatSiDxe",
		efi.GUID{0x71, 0x36, 0xec, 0xcd, 0x6e, 0x81, 0xdc, 0x43, 0xa0, 0x02, 0xdc, 0xd6, 0x45, 0x22, 0x93, 0x38}: "I2cHostDxe",
		efi.GUID{0x71, 0x37, 0x1f, 0x68, 0x1d, 0x6f, 0xde, 0x42, 0x9a, 0xa2, 0xf8, 0x2b, 0xbc, 0xdb, 0xc5, 0xf9}: "WinNtFlashMapPei",
		efi.GUID{0x71, 0x39, 0x9a, 0xef, 0xa0, 0xc1, 0x93, 0x4a, 0xbd, 0x40, 0x5a, 0xa1, 0x65, 0xf2, 0xdc, 0x3a}: "ConsoleOutDevicesStartedProtocol",
		efi.GUID{0x71, 0x51, 0x34, 0xce, 0x0b, 0xba, 0xd2, 0x11, 0x8e, 0x4f, 0x00, 0xa0, 0xc9, 0x69, 0x72, 0x3b}: "EfiDiskIoProtocolGuid",
		efi.GUID{0x71, 0x58, 0x75, 0x07, 0x72, 0xca, 0xd1, 0x42, 0xaf, 0x0e, 0x5b, 0xeb, 0x97, 0x1f, 0x7e, 0x4c}: "RtcAlarmSmi",
		efi.GUID{0x71, 0x5d, 0x93, 0x4a, 0x9e, 0x7d, 0x23, 0x44, 0x80, 0xe5, 0xf8, 0xf8, 0xf4, 0x04, 0x3f, 0x9c}: "ReadyToBootNotifySmm",
		efi.GUID{0x71, 0x60, 0xe9, 0xa1, 0xdd, 0xc1, 0x95, 0x45, 0x80, 0xd8, 0x3d, 0x49, 0x7f, 0x7a, 0xb5, 0x27}: "OemMS",
		efi.GUID{0x71, 0x60, 0xe9, 0xa1, 0xdd, 0xc1, 0x95, 0x45, 0x80, 0xd8, 0x3d, 0x49, 0x7f, 0x7a, 0xb5, 0x77}: "LenovoWifiVariable",
		efi.GUID{0x71, 0x63, 0x28, 0x09, 0xf2, 0x5f, 0x65, 0x40, 0xb3, 0xd2, 0xb8, 0x1c, 0x88, 0x28, 0x98, 0xab}: "HpIcicleSmm",
		efi.GUID{0x71, 0x66, 0x92, 0xe3, 0x95, 0x45, 0x35, 0x4d, 0x89, 0x11, 0x29, 0x41, 0xbd, 0x77, 0xe4, 0x75}: "DellEcChipDetectPei",
		efi.GUID{0x71, 0x70, 0xa6, 0x8a, 0xec, 0x8b, 0xab, 0x47, 0x83, 0xc8, 0xcd, 0x0e, 0xb7, 0x23, 0xd0, 0x72}: "IdeBusDriverBindingProtocol",
		efi.GUID{0x71, 0x7b, 0x58, 0x27, 0xf9, 0x37, 0x48, 0x4a, 0xb5, 0x70, 0x58, 0xb6, 0xd1, 0x4f, 0x6d, 0xec}: "DellOromKbAccess",
		efi.GUID{0x71, 0x7b, 0x78, 0xd4, 0x78, 0xa8, 0xc9, 0x49, 0x97, 0xce, 0x96, 0x7d, 0xf2, 0x39, 0x9a, 0xaa}: "SmramRomHoleK0Protocol",
		efi.GUID{0x71, 0x88, 0x32, 0x49, 0x65, 0xfe, 0x86, 0x45, 0xa0, 0x13, 0x0a, 0xda, 0xae, 0xa1, 0xda, 0xff}: "FvbServicesRuntimeDxeRA",
		efi.GUID{0x71, 0x92, 0x75, 0xa9, 0xcd, 0x49, 0xbe, 0x49, 0x87, 0x64, 0x5d, 0xeb, 0xfb, 0xe6, 0x8f, 0x73}: "AmdResetManager",
		efi.GUID{0x71, 0x94, 0x6d, 0xbe, 0xbf, 0xc8, 0x35, 0x4b, 0xbe, 0xa7, 0x76, 0x87, 0xcd, 0xf7, 0xe1, 0x42}: "AmdMemFp7Pei",
		efi.GUID{0x71, 0x94, 0x98, 0x3d, 0xac, 0xcf, 0xb7, 0x46, 0x9b, 0x1c, 0x08, 0x43, 0x01, 0x09, 0x40, 0x2d}: "TxtOneTouch",
		efi.GUID{0x71, 0x94, 0xb5, 0x8b, 0x3c, 0x82, 0x11, 0x4a, 0xb6, 0x10, 0xce, 0x39, 0x85, 0x79, 0x3e, 0xb1}: "DellSystemPolicy",
		efi.GUID{0x71, 0x99, 0x03, 0x93, 0x45, 0x85, 0x04, 0x4b, 0xb4, 0x5e, 0x32, 0xeb, 0x83, 0x26, 0x04, 0x0e}: "EfiHiiPlatformSetupFormsetGuid",
		efi.GUID{0x71, 0x99, 0xe5, 0x28, 0x7e, 0x3f, 0x34, 0x4e, 0x8d, 0xed, 0x07, 0x45, 0x90, 0x7b, 0x48, 0x4d}: "FingerPrintBindingDriver",
		efi.GUID{0x71, 0xa1, 0xc6, 0xa8, 0x78, 0x54, 0x7c, 0x4a, 0x9e, 0xb6, 0x65, 0x5c, 0x6c, 0xcc, 0x4e, 0x3a}: "InsydeReportFvPei",
		efi.GUID{0x71, 0xa4, 0x4e, 0xdd, 0xd2, 0xd8, 0xe7, 0x4c, 0x86, 0xb3, 0x14, 0xaf, 0xec, 0xe7, 0x61, 0x41}: "KEMrWdtSmi",
		efi.GUID{0x71, 0xa9, 0x85, 0xd4, 0xdc, 0xb6, 0x1c, 0x4e, 0x87, 0x30, 0xc4, 0x45, 0x54, 0x60, 0xa6, 0xff}: "ResetDateTimePei",
		efi.GUID{0x71, 0xb1, 0x57, 0x0d, 0xd2, 0xa6, 0xc9, 0x49, 0x95, 0xad, 0xab, 0xc0, 0x25, 0x46, 0xe6, 0x05}: "DellSystemUsbPortConfigDxe",
		efi.GUID{0x71, 0xba, 0x92, 0xe2, 0x2c, 0x81, 0xb9, 0x42, 0x88, 0x5d, 0x3f, 0x05, 0x65, 0xb0, 0x98, 0xc7}: "SyncSetupCpt",
		efi.GUID{0x71, 0xbd, 0x66, 0xc8, 0x79, 0x7c, 0xf1, 0x4b, 0xa9, 0x3b, 0x06, 0x6b, 0x83, 0x0d, 0x8f, 0x9a}: "MpS3",
		efi.GUID{0x71, 0xc7, 0x85, 0x75, 0xe4, 0x3c, 0xfe, 0x41, 0xb7, 0x80, 0x84, 0x5c, 0xd8, 0x5b, 0xa4, 0x44}: "FirmwarePassword",
		efi.GUID{0x71, 0xdb, 0x8a, 0x7e, 0x5b, 0x9a, 0xc7, 0x4a, 0x82, 0xbe, 0xe8, 0x59, 0x82, 0x85, 0xdc, 0x14}: "LANWakeupDxe",
		efi.GUID{0x71, 0xdf, 0x26, 0x4c, 0xe7, 0xeb, 0xea, 0x4d, 0xb5, 0xe2, 0x0b, 0x59, 0x80, 0x43, 0x39, 0x08}: "GetAddrInfo",
		efi.GUID{0x71, 0xe8, 0x68, 0x88, 0xf1, 0xe4, 0xd3, 0x11, 0xbc, 0x22, 0x00, 0x80, 0xc7, 0x3c, 0x88, 0x81}: "EfiAcpi20TableGuid",
		efi.GUID{0x71, 0xf1, 0xfd, 0x03, 0x67, 0x1d, 0xce, 0x4a, 0xa9, 0x04, 0x3e, 0x36, 0xd3, 0x38, 0xfa, 0x74}: "SeCPlatformReadyToBootGuid",
		efi.GUID{0x71, 0xf8, 0x3a, 0xf8, 0xf4, 0x59, 0x2f, 0x43, 0x82, 0xe6, 0x31, 0xa5, 0x32, 0x89, 0x40, 0x99}: "ITEFwFmp",
		efi.GUID{0x71, 0xf8, 0xb7, 0xd3, 0x04, 0x3f, 0xd4, 0x48, 0xb9, 0xc1, 0x58, 0x71, 0x82, 0x5d, 0x00, 0xaa}: "GnbMatisseRouting",
		efi.GUID{0x71, 0xff, 0xaa, 0xa0, 0xda, 0x35, 0xee, 0x41, 0x86, 0x3f, 0xa2, 0x4f, 0x42, 0x9e, 0x59, 0xe4}: "IconSelected",
		efi.GUID{0x72, 0x10, 0xab, 0xd8, 0x45, 0x4b, 0x28, 0x48, 0x83, 0x7d, 0xa4, 0x21, 0x43, 0x77, 0x80, 0x2e}: "BCLANDXE",
		efi.GUID{0x72, 0x11, 0xd0, 0x4b, 0xd3, 0x54, 0x97, 0x4a, 0xb6, 0xa0, 0xda, 0x57, 0x47, 0x4c, 0xdf, 0x3c}: "FjGabiEntrySmmBin",
		efi.GUID{0x72, 0x15, 0x87, 0xcb, 0x1a, 0xc1, 0xb5, 0x47, 0xb4, 0x92, 0x67, 0x5e, 0xaf, 0xa7, 0x77, 0x27}: "EfiDiskInfoUsbInterfaceGuid",
		efi.GUID{0x72, 0x1e, 0xf4, 0xae, 0x5e, 0xd8, 0xa9, 0x4e, 0x98, 0x0b, 0x66, 0xe5, 0x82, 0x0d, 0xe1, 0x9e}: "LenovoSmartBootDxe",
		efi.GUID{0x72, 0x24, 0x7b, 0xa7, 0x82, 0xe2, 0x9f, 0x4e, 0xa2, 0x45, 0xc2, 0xc0, 0xe2, 0x7b, 0xbc, 0xc1}: "EfiBlockIo2ProtocolGuid",
		efi.GUID{0x72, 0x29, 0x1d, 0x0e, 0xaf, 0x65, 0xc1, 0x4a, 0xbf, 0xa3, 0xce, 0xf4, 0xab, 0x0c, 0x38, 0xfe}: "EfiCapsuleCrashGuid",
		efi.GUID{0x72, 0x2b, 0x61, 0xfe, 0x3c, 0x20, 0xb1, 0x47, 0x85, 0x60, 0xa6, 0x6d, 0x94, 0x6e, 0xb3, 0x71}: "setupdata",
		efi.GUID{0x72, 0x2c, 0xcd, 0x4d, 0xbd, 0xec, 0x47, 0x4f, 0x84, 0xbb, 0x2b, 0x3b, 0xd2, 0xbf, 0xf9, 0x0b}: "UsbCrisisEnumPei",
		efi.GUID{0x72, 0x2e, 0xfe, 0x3d, 0x6d, 0x9f, 0x50, 0x43, 0xba, 0x4f, 0x20, 0x33, 0x3b, 0x52, 0xb8, 0x76}: "AmiSyncSetupData",
		efi.GUID{0x72, 0x35, 0xd8, 0x92, 0x44, 0x3d, 0xe3, 0x40, 0x87, 0x18, 0x36, 0x44, 0x6b, 0x3e, 0xba, 0x2e}: "IdentifyAcpiTable",
		efi.GUID{0x72, 0x41, 0xad, 0x58, 0xab, 0x08, 0xb4, 0x4a, 0x99, 0xe6, 0x8a, 0xa2, 0xf2, 0xb3, 0x54, 0xde}: "AdlSioFunctionPei",
		efi.GUID{0x72, 0x44, 0x69, 0x2e, 0xf9, 0x97, 0x3e, 0x4d, 0x94, 0x0b, 0x36, 0x0a, 0x27, 0x31, 0xde, 0xbd}: "RegulatoryInfoSupportDxe",
		efi.GUID{0x72, 0x4e, 0xc1, 0xbe, 0x56, 0xa9, 0x76, 0x46, 0x87, 0xe7, 0xb0, 0x92, 0x08, 0x7f, 0x5f, 0x6c}: "FjIntrusion",
		efi.GUID{0x72, 0x54, 0x3c, 0x5c, 0xdc, 0x1a, 0xd8, 0x44, 0x93, 0xf5, 0x78, 0xb3, 0x1b, 0x95, 0x09, 0x31}: "aModelName",
		efi.GUID{0x72, 0x56, 0xee, 0x32, 0xf9, 0xc9, 0x26, 0x49, 0x82, 0x28, 0x0c, 0x4e, 0x3b, 0x0e, 0x69, 0xfe}: "AsusTopSwap",
		efi.GUID{0x72, 0x5b, 0xc9, 0x20, 0xe3, 0xf4, 0xb2, 0x4b, 0xa2, 0x89, 0x19, 0xdb, 0xfd, 0x23, 0xf5, 0x31}: "PlatformInit",
		efi.GUID{0x72, 0x5c, 0x27, 0x0d, 0xc6, 0x10, 0x8c, 0x4d, 0x8b, 0x2c, 0x66, 0x10, 0xe6, 0x9e, 0x34, 0x03}: "Uart16550SerialDxe",
		efi.GUID{0x72, 0x5f, 0xeb, 0xd9, 0xf5, 0x63, 0xc2, 0x4c, 0x9f, 0xcf, 0xbf, 0xec, 0xe1, 0x8f, 0xf0, 0xb6}: "OemThermalPolicySMM",
		efi.GUID{0x72, 0x64, 0x9e, 0x70, 0xcd, 0x1b, 0xbd, 0x43, 0x8b, 0x6b, 0xcd, 0x2d, 0x6d, 0x08, 0xb9, 0x67}: "AcpiAtd",
		efi.GUID{0x72, 0x70, 0xa9, 0x1d, 0xdc, 0xbd, 0x30, 0x4b, 0x99, 0xf1, 0x72, 0xa0, 0xb5, 0x6f, 0xff, 0x2a}: "EfiMonotonicCounterArchProtocolGuid",
		efi.GUID{0x72, 0x71, 0x58, 0xae, 0x15, 0xca, 0xe1, 0x48, 0x8b, 0xe1, 0x29, 0xdd, 0xf0, 0x5c, 0x6a, 0x1e}: "OemSpecVtdRmrr",
		efi.GUID{0x72, 0x71, 0x58, 0xae, 0x15, 0xcc, 0xe1, 0x48, 0x8b, 0xe0, 0x29, 0xdd, 0xf0, 0x5c, 0x6a, 0x1f}: "DxeSelStatusCode",
		efi.GUID{0x72, 0x71, 0x58, 0xae, 0x15, 0xcc, 0xe1, 0x48, 0x8b, 0xe1, 0x29, 0xdd, 0xf0, 0x5c, 0x6a, 0x1e}: "OemVtdRmrr",
		efi.GUID{0x72, 0x76, 0x2b, 0xbc, 0x8b, 0xa4, 0x58, 0x4d, 0xb3, 0x9e, 0xae, 0xe3, 0x70, 0x7b, 0x5a, 0x23}: "Tpm12DeviceLibDTpm",
		efi.GUID{0x72, 0x77, 0x63, 0x01, 0x22, 0xb0, 0x47, 0x40, 0xbd, 0x52, 0x35, 0x45, 0x4c, 0x1c, 0x6b, 0x9f}: "Armani_EcCommunicationSmm",
		efi.GUID{0x72, 0x78, 0x83, 0x3f, 0x07, 0x2a, 0x70, 0x44, 0xb8, 0xb7, 0x9a, 0xc1, 0x31, 0x36, 0x03, 0x14}: "VariableEditDxe",
		efi.GUID{0x72, 0x7b, 0xbc, 0x43, 0x61, 0xe9, 0x59, 0x4a, 0x85, 0x25, 0x6f, 0x30, 0xa2, 0x76, 0x62, 0x5f}: "EcMemMappingDxe",
		efi.GUID{0x72, 0x82, 0x60, 0xad, 0x7f, 0xd0, 0x64, 0x49, 0x80, 0x1e, 0x7b, 0xd3, 0xb7, 0x88, 0x86, 0x52}: "MonotonicCounterRuntimeDxe",
		efi.GUID{0x72, 0x85, 0x08, 0x17, 0x7f, 0x37, 0xef, 0x44, 0x8f, 0x4e, 0xb0, 0x9f, 0xff, 0x46, 0xa0, 0x70}: "Microcode",
		efi.GUID{0x72, 0x93, 0xe8, 0x3f, 0xcc, 0xc0, 0x6b, 0x46, 0xaa, 0x4a, 0xb7, 0x6d, 0xbb, 0xb1, 0x1b, 0xbb}: "DellPolicyDxe",
		efi.GUID{0x72, 0x94, 0x62, 0xea, 0xc6, 0xd7, 0x0e, 0x4c, 0x88, 0x20, 0x2b, 0x81, 0x1c, 0x7e, 0xe3, 0xaf}: "AmiTseOemPortingVar11",
		efi.GUID{0x72, 0x94, 0xb0, 0x25, 0x58, 0xf2, 0xea, 0x49, 0xa1, 0xce, 0x8a, 0x68, 0xf3, 0xa4, 0xa5, 0x4b}: "InitOemSetupVariable",
		efi.GUID{0x72, 0x95, 0xbf, 0xcb, 0xdc, 0x28, 0x12, 0x47, 0xaa, 0x9d, 0x0f, 0xf6, 0xe4, 0x02, 0x9b, 0xfc}: "AmiSystemCredentialManagement",
		efi.GUID{0x72, 0x9f, 0x5d, 0xd6, 0xce, 0x7b, 0x73, 0x4f, 0xa6, 0x73, 0x47, 0xaf, 0x44, 0x6a, 0x1a, 0x31}: "SmmRuntimeDxeReportStatusCodeLibFramework",
		efi.GUID{0x72, 0xa0, 0x0c, 0x2f, 0xc6, 0x99, 0xab, 0x43, 0x81, 0x0a, 0x52, 0x8c, 0x43, 0xc6, 0x8e, 0xef}: "AmdSmmControl",
		efi.GUID{0x72, 0xa1, 0xe9, 0xa4, 0x5b, 0x9d, 0xae, 0x47, 0xbf, 0xcf, 0x2c, 0x9f, 0xca, 0x6f, 0x0a, 0xdc}: "AmdSocSp3r3CglPei",
		efi.GUID{0x72, 0xa6, 0x38, 0x72, 0x5c, 0x75, 0xe2, 0x45, 0x84, 0xc1, 0x4c, 0x72, 0x0c, 0xb2, 0xa8, 0xd1}: "EcCloseShmApi",
		efi.GUID{0x72, 0xa9, 0x17, 0xad, 0x92, 0x58, 0x40, 0x44, 0xa7, 0x8b, 0x1b, 0xfe, 0x5f, 0x49, 0xb7, 0x09}: "AsusSetBiosLockDown",
		efi.GUID{0x72, 0xad, 0x6f, 0xa5, 0x64, 0xa2, 0x70, 0x43, 0x85, 0xc5, 0x00, 0x58, 0x46, 0x54, 0xdc, 0xe2}: "InstallVerbTablePei",
		efi.GUID{0x72, 0xb0, 0x2a, 0x59, 0x87, 0x39, 0xb3, 0x4d, 0x86, 0xb0, 0xeb, 0xd8, 0xd4, 0x3e, 0x4b, 0x76}: "AmdFabricRsPei",
		efi.GUID{0x72, 0xb3, 0x34, 0x0c, 0x22, 0x26, 0x13, 0x4a, 0xa4, 0x6e, 0xbf, 0xd0, 0xde, 0xb4, 0x8b, 0xff}: "I2cBusDxe",
		efi.GUID{0x72, 0xb9, 0x22, 0x20, 0xb9, 0xb1, 0x55, 0x4b, 0xa6, 0x03, 0x78, 0x51, 0xcb, 0x06, 0x2e, 0x34}: "LePassKeyDxe",
		efi.GUID{0x72, 0xbc, 0xe1, 0xdd, 0x5e, 0xd4, 0x09, 0x42, 0xab, 0x85, 0x14, 0x46, 0x2d, 0x2f, 0x50, 0x74}: "RomImageAddress",
		efi.GUID{0x72, 0xc1, 0x9f, 0xef, 0xb2, 0xa1, 0x93, 0x46, 0xb3, 0x27, 0x6d, 0x32, 0xfc, 0x41, 0x60, 0x42}: "EfiHiiDatabaseProtocolGuid",
		efi.GUID{0x72, 0xc3, 0xc4, 0x8c, 0x9a, 0xd6, 0x01, 0x42, 0xbc, 0x19, 0x07, 0x79, 0x9b, 0x69, 0x93, 0x69}: "CollectBootInfoProtocol",
		efi.GUID{0x72, 0xc9, 0xcf, 0x93, 0x9f, 0x6b, 0x31, 0x40, 0xa5, 0x42, 0xc7, 0x29, 0x9f, 0x12, 0x69, 0x24}: "FjNuvotonNct6796Pei",
		efi.GUID{0x72, 0xcb, 0x0d, 0x21, 0x14, 0xbc, 0x19, 0x4a, 0xa2, 0x9b, 0xf6, 0x96, 0xeb, 0x7d, 0xe1, 0x2b}: "EzSetup",
		efi.GUID{0x72, 0xce, 0xe2, 0xa7, 0x32, 0xdc, 0xc0, 0x4b, 0x9e, 0x35, 0xfe, 0xb3, 0x0a, 0xe5, 0xcc, 0x47}: "AmiEarlyBistPpi",
		efi.GUID{0x72, 0xe3, 0x9d, 0x36, 0x36, 0xab, 0xe1, 0x4c, 0x8e, 0x45, 0x88, 0x06, 0xb7, 0x6d, 0xd7, 0x0f}: "PspResource",
		efi.GUID{0x72, 0xef, 0xc1, 0xa5, 0x79, 0x93, 0x70, 0x43, 0xb4, 0xc7, 0x0f, 0x51, 0x26, 0xca, 0xc3, 0x8e}: "TrEEConfigPei",
		efi.GUID{0x72, 0xf5, 0xea, 0xa0, 0xd8, 0x69, 0x25, 0x48, 0xb1, 0xb0, 0x9e, 0xe3, 0xb4, 0xc6, 0x4f, 0xa7}: "ASUSGamingBoard",
		efi.GUID{0x72, 0xf7, 0x28, 0x14, 0x4a, 0xb6, 0x1e, 0x44, 0xb8, 0xc3, 0x9e, 0xbd, 0xd7, 0xf8, 0x93, 0xc7}: "QemuKernelLoaderFsMedia",
		efi.GUID{0x72, 0xfb, 0x96, 0xd0, 0x64, 0xa9, 0xe6, 0x4f, 0x9f, 0xbf, 0xfa, 0x83, 0xcc, 0xd9, 0x15, 0x49}: "FchSmbusDxe",
		efi.GUID{0x73, 0x05, 0x2b, 0xc0, 0x4e, 0x2b, 0x31, 0x4a, 0xa3, 0x1a, 0x94, 0x56, 0x7b, 0x50, 0x44, 0x2c}: "PchUsbPolicyPpiGuid",
		efi.GUID{0x73, 0x06, 0x3a, 0x97, 0xaa, 0x3a, 0x9c, 0x47, 0x97, 0x46, 0xdb, 0xd7, 0xde, 0xaa, 0xa0, 0xb4}: "DellHotKeysPolicy",
		efi.GUID{0x73, 0x14, 0x6a, 0x3a, 0xe0, 0x13, 0x95, 0x47, 0xba, 0x9f, 0x22, 0x89, 0x12, 0x77, 0xd7, 0x4d}: "HdpEraseUnitAppDxe",
		efi.GUID{0x73, 0x14, 0x6a, 0x3b, 0xe0, 0x13, 0x95, 0x47, 0xba, 0x9f, 0x22, 0x89, 0x12, 0x77, 0xd7, 0x4d}: "HdpEraseAppScreen",
		efi.GUID{0x73, 0x14, 0xd8, 0xec, 0x33, 0x05, 0x44, 0x48, 0xbc, 0x77, 0x48, 0xf0, 0xde, 0x27, 0x51, 0x9b}: "DellSmBiosStrucD8",
		efi.GUID{0x73, 0x26, 0xbc, 0x34, 0x6b, 0x25, 0xe2, 0x4b, 0x9c, 0x4c, 0x02, 0x5e, 0xe4, 0x84, 0xac, 0xae}: "DellXhciPei",
		efi.GUID{0x73, 0x26, 0xea, 0x47, 0x33, 0x25, 0x07, 0x4c, 0xaa, 0xba, 0x69, 0xce, 0x5a, 0x7c, 0x5d, 0x35}: "FspInit",
		efi.GUID{0x73, 0x2c, 0x58, 0xcc, 0x8f, 0xf4, 0x62, 0x4b, 0x83, 0xe8, 0xa5, 0x86, 0xb4, 0xc8, 0x8f, 0x84}: "AppleFirmwareFeatures",
		efi.GUID{0x73, 0x2f, 0x32, 0x53, 0x65, 0x39, 0xa7, 0x45, 0x8b, 0x54, 0x61, 0x97, 0x27, 0x44, 0x10, 0x2e}: "IntelUefiRaidDiskInfo",
		efi.GUID{0x73, 0x37, 0x87, 0x4e, 0x91, 0x83, 0x47, 0x4e, 0xb7, 0xf4, 0xca, 0xfb, 0xdc, 0xc4, 0xb2, 0x04}: "EfiDmaRemapProtocol",
		efi.GUID{0x73, 0x3c, 0xf5, 0xb5, 0x8b, 0x3a, 0xe3, 0x49, 0xa4, 0x28, 0xb7, 0xd1, 0x5a, 0x2f, 0xd9, 0x94}: "CbsBaseDxeRMB",
		efi.GUID{0x73, 0x46, 0x16, 0x10, 0x65, 0xd3, 0xe2, 0x4b, 0x85, 0x13, 0x14, 0x97, 0xcc, 0x07, 0x61, 0x1d}: "ScPolicyPpiGuid",
		efi.GUID{0x73, 0x46, 0x34, 0x15, 0x65, 0xd3, 0xe2, 0x4b, 0x85, 0x13, 0x14, 0x97, 0xcc, 0x07, 0x61, 0x1d}: "PchPlatformPolicyPpiGuid",
		efi.GUID{0x73, 0x49, 0xbf, 0x82, 0x4d, 0x73, 0x24, 0x43, 0xa3, 0xd3, 0xfc, 0xc0, 0xee, 0x3a, 0xd5, 0x1e}: "DellEarlyLogoPei",
		efi.GUID{0x73, 0x62, 0xba, 0x86, 0x62, 0x05, 0xd6, 0x4c, 0x89, 0x71, 0x87, 0x32, 0x94, 0x9a, 0x11, 0x91}: "BiosInitToFactorySupportSmm",
		efi.GUID{0x73, 0x62, 0xc6, 0x3a, 0x97, 0x9f, 0xb7, 0x41, 0x9a, 0xad, 0x5d, 0x78, 0x1d, 0xa0, 0xb8, 0xa7}: "DellVideoDxe",
		efi.GUID{0x73, 0x6a, 0x03, 0x16, 0xef, 0xe8, 0xd0, 0x46, 0x95, 0x3c, 0x9b, 0x8e, 0x96, 0x52, 0x7d, 0x13}: "Reset",
		efi.GUID{0x73, 0x6d, 0x6b, 0xd5, 0x7b, 0x1a, 0x15, 0x40, 0x9b, 0xb4, 0x7b, 0x07, 0x17, 0x29, 0xed, 0x24}: "EdkiiSmmPerformanceMeasurementProtocol",
		efi.GUID{0x73, 0x74, 0x78, 0xdd, 0xce, 0x07, 0x63, 0x4c, 0x82, 0xce, 0x93, 0x0b, 0x33, 0xf3, 0x9c, 0x09}: "SmmControl",
		efi.GUID{0x73, 0x7a, 0xef, 0x67, 0x94, 0x25, 0x5e, 0x4a, 0x93, 0x0a, 0xe1, 0x66, 0xfa, 0xbc, 0xd2, 0xc8}: "EfiDmiFormatFru",
		efi.GUID{0x73, 0x7e, 0x4a, 0x31, 0xf2, 0xea, 0xf3, 0x40, 0x81, 0xb5, 0x61, 0xfc, 0x83, 0xc4, 0x68, 0xcf}: "EcdBoardId",
		efi.GUID{0x73, 0x8a, 0x7d, 0xa0, 0xf9, 0xd4, 0xa0, 0x4a, 0xbc, 0x25, 0x39, 0x1c, 0xcf, 0xc4, 0x7e, 0x98}: "I2cControllerTemplate",
		efi.GUID{0x73, 0x8e, 0x96, 0x18, 0x45, 0x3c, 0x33, 0x43, 0xb9, 0x7f, 0x87, 0x64, 0xc2, 0x39, 0x23, 0xac}: "FjAutoBiosUpdateInterfaceProtocol",
		efi.GUID{0x73, 0x8e, 0xf3, 0x12, 0x4d, 0xb3, 0x59, 0x45, 0x99, 0xe5, 0xae, 0x2d, 0xcd, 0x00, 0x21, 0x56}: "BaseFspWrapperPlatformLibSample",
		efi.GUID{0x73, 0x93, 0x27, 0x7d, 0xcc, 0xee, 0x4f, 0x4d, 0xae, 0x2f, 0xce, 0xc4, 0xb7, 0x06, 0xb0, 0x6a}: "Tpm2AcpiTableStorage",
		efi.GUID{0x73, 0x93, 0xe1, 0xce, 0x2a, 0xfb, 0x8e, 0x4b, 0xbe, 0xf5, 0xb6, 0xd7, 0x73, 0x1f, 0x49, 0x39}: "I2cBus",
		efi.GUID{0x73, 0x99, 0x33, 0xc8, 0x63, 0xa5, 0x61, 0x45, 0xb8, 0x58, 0xd8, 0x47, 0x6f, 0x9d, 0xef, 0xc4}: "Metronome",
		efi.GUID{0x73, 0x9a, 0xf1, 0x68, 0x47, 0xc4, 0xdd, 0x4f, 0xb4, 0xb7, 0xf3, 0x80, 0xf7, 0xdd, 0x29, 0x0f}: "FprGoodixDriver",
		efi.GUID{0x73, 0xa2, 0xec, 0xe2, 0xc0, 0xa1, 0x7e, 0x40, 0x9a, 0x5c, 0xf1, 0x0c, 0x55, 0x14, 0x21, 0x96}: "BaseSmbusLibNull",
		efi.GUID{0x73, 0xab, 0x22, 0xa6, 0x7f, 0x1e, 0xc8, 0x43, 0xa4, 0x65, 0x0d, 0x5b, 0x26, 0x7f, 0x1a, 0x37}: "MicrowindowsDxe",
		efi.GUID{0x73, 0xb2, 0x20, 0x1a, 0xbf, 0x2c, 0x64, 0x4e, 0xa4, 0xa0, 0x16, 0xa2, 0xaf, 0x25, 0x2c, 0x27}: "AmdFchWheaSmm",
		efi.GUID{0x73, 0xb3, 0x4f, 0x0a, 0x9f, 0x35, 0x34, 0x4a, 0xb3, 0x54, 0xab, 0x7b, 0x2e, 0xb7, 0x25, 0x52}: "AmdSocAm4SmPei",
		efi.GUID{0x73, 0xb7, 0x41, 0xe5, 0x11, 0xdd, 0x0c, 0x42, 0xb0, 0x26, 0xdf, 0x99, 0x36, 0x53, 0xf8, 0xbf}: "EfiSmmSwDispatchProtocolGuid",
		efi.GUID{0x73, 0xb7, 0xd7, 0xc7, 0xe6, 0x68, 0x26, 0x46, 0x80, 0xf9, 0x60, 0x9c, 0x44, 0x51, 0xeb, 0x0c}: "FjDmiWakeCause",
		efi.GUID{0x73, 0xc4, 0xf5, 0x53, 0xb5, 0x46, 0xf3, 0x45, 0x82, 0x61, 0xe4, 0xa5, 0x9a, 0x9e, 0x75, 0x5d}: "AmdPspPeiV2Stp",
		efi.GUID{0x73, 0xca, 0x8a, 0x58, 0xd8, 0x2e, 0x76, 0x4f, 0x93, 0x10, 0x6f, 0x4d, 0x0b, 0x44, 0x92, 0x42}: "AsusHeader",
		efi.GUID{0x73, 0xcd, 0x28, 0xcf, 0xde, 0xf3, 0x25, 0x41, 0x86, 0x51, 0x61, 0xcc, 0x4d, 0x78, 0x6f, 0xb2}: "OEMWMIDxe",
		efi.GUID{0x73, 0xcd, 0xde, 0x43, 0xcb, 0x77, 0x4d, 0x47, 0xbd, 0x6f, 0x1a, 0x98, 0xe7, 0xe2, 0xb6, 0xc6}: "LenovoErrorManagerDxe",
		efi.GUID{0x73, 0xda, 0x1d, 0x84, 0x8d, 0x0a, 0x49, 0x4d, 0xaf, 0x60, 0x2a, 0x14, 0x5d, 0x21, 0x76, 0xce}: "EfiNgnAcpiSmmInterfaceProtocol",
		efi.GUID{0x73, 0xde, 0x2a, 0x4d, 0x51, 0xb7, 0x68, 0x4c, 0x9f, 0xa2, 0x61, 0x90, 0x9e, 0xbc, 0x59, 0xea}: "KEMhMarsDxe",
		efi.GUID{0x73, 0xe9, 0x69, 0x9b, 0xdc, 0xcb, 0x35, 0x40, 0x9a, 0xe8, 0xec, 0x9c, 0x76, 0x17, 0xfa, 0x28}: "LEMPostFlagProtocol",
		efi.GUID{0x73, 0xee, 0xea, 0x1f, 0xdc, 0xf8, 0x9f, 0x43, 0x9f, 0xd3, 0xa0, 0xed, 0x92, 0xb5, 0xeb, 0xda}: "SmbiosMFG",
		efi.GUID{0x73, 0xf5, 0x53, 0xfc, 0xdd, 0x17, 0x4c, 0x45, 0xb0, 0x67, 0xec, 0xb1, 0x0b, 0x7d, 0x7f, 0xc7}: "EfiHeciSmmProtocolGuid",
		efi.GUID{0x73, 0xf9, 0x10, 0xa2, 0x9d, 0x22, 0x4d, 0x4f, 0xaa, 0x37, 0x98, 0x95, 0xe6, 0xc9, 0xea, 0xba}: "DpcDxe",
		efi.GUID{0x73, 0xfe, 0x0d, 0x65, 0xc8, 0x6a, 0xe6, 0x45, 0x92, 0x15, 0x98, 0x72, 0xbe, 0xc8, 0xb2, 0x76}: "ICCDXE",
		efi.GUID{0x73, 0xfe, 0xa9, 0x74, 0x72, 0x8e, 0xad, 0x4f, 0x80, 0x43, 0xed, 0x4a, 0xf8, 0x2c, 0x08, 0xae}: "SwSmi534D0B40",
		efi.GUID{0x74, 0x00, 0x76, 0xa2, 0x4c, 0xed, 0x19, 0x47, 0x83, 0x82, 0xc9, 0x42, 0xcb, 0xf1, 0x6d, 0x85}: "DisplayTypeDxe",
		efi.GUID{0x74, 0x07, 0x59, 0x0b, 0x67, 0xbc, 0xf4, 0x49, 0xa7, 0xdb, 0xe8, 0x2e, 0x89, 0xe6, 0xb5, 0xd6}: "EfiPeiMpInitLibUpDepPpi",
		efi.GUID{0x74, 0x0d, 0x11, 0x1c, 0x9b, 0x15, 0xb3, 0x46, 0xb4, 0x7e, 0x7b, 0x7a, 0xd2, 0x2f, 0xa6, 0xd6}: "DellResetReduction",
		efi.GUID{0x74, 0x15, 0xe3, 0xdd, 0x89, 0x35, 0xa9, 0x4f, 0xbc, 0x69, 0x17, 0x29, 0xaf, 0x6f, 0xda, 0x4e}: "AmiNvramUpdateProtocolGuid",
		efi.GUID{0x74, 0x18, 0x23, 0x18, 0x33, 0x29, 0x4c, 0x4a, 0xaa, 0xf1, 0x65, 0xb4, 0xa7, 0x52, 0xa4, 0x09}: "FwHealthReporterDxe",
		efi.GUID{0x74, 0x1a, 0xc8, 0x93, 0x48, 0xb6, 0x7f, 0x4f, 0x92, 0x5e, 0xe4, 0xa0, 0xcd, 0xcc, 0x77, 0x6d}: "VlvInitDxe",
		efi.GUID{0x74, 0x2b, 0x70, 0xc2, 0x0c, 0x80, 0x31, 0x41, 0x87, 0x46, 0x8f, 0xb5, 0xb8, 0x9c, 0xe4, 0xac}: "EfiSmmAccess2ProtocolGuid",
		efi.GUID{0x74, 0x2c, 0x7b, 0x17, 0x74, 0x96, 0xf4, 0x45, 0xaa, 0xeb, 0x43, 0xf5, 0x50, 0x6a, 0xe0, 0xfe}: "ASUSPOSTMessage",
		efi.GUID{0x74, 0x3b, 0x76, 0x1a, 0x00, 0x14, 0x45, 0x42, 0xbf, 0x89, 0x56, 0x91, 0x0f, 0xa7, 0xbe, 0x48}: "FjSystemInfo",
		efi.GUID{0x74, 0x55, 0x2f, 0xcf, 0x73, 0x3c, 0x2f, 0x4d, 0x97, 0x6d, 0x66, 0x5c, 0xad, 0x2e, 0x53, 0x81}: "ASUSDirectKeyDXE",
		efi.GUID{0x74, 0x67, 0x1a, 0x2a, 0x8d, 0x32, 0x58, 0x4c, 0x9f, 0x30, 0x01, 0x9e, 0xff, 0x54, 0xf9, 0xb2}: "MSIInBIOSFlash",
		efi.GUID{0x74, 0x69, 0xd9, 0x0f, 0xaa, 0x23, 0xdc, 0x4c, 0xb9, 0xcb, 0x98, 0xd1, 0x77, 0x50, 0x32, 0x2a}: "EfiHiiStringProtocolGuid",
		efi.GUID{0x74, 0x6a, 0x5c, 0x4c, 0xb7, 0xba, 0xd6, 0x46, 0x86, 0x88, 0x3b, 0x2e, 0x7f, 0x24, 0x6e, 0x3f}: "SataController",
		efi.GUID{0x74, 0x6f, 0x34, 0x87, 0x49, 0xb2, 0xb8, 0x49, 0x82, 0x87, 0x27, 0x02, 0xce, 0x61, 0x10, 0x9c}: "BiosGuardServices",
		efi.GUID{0x74, 0x77, 0x0c, 0x66, 0x3b, 0x31, 0x4a, 0x43, 0x86, 0x33, 0x5d, 0x14, 0x88, 0xcc, 0xd1, 0x72}: "I2CTPResetPei",
		efi.GUID{0x74, 0x7a, 0x24, 0x25, 0x40, 0x94, 0xd5, 0x47, 0xbf, 0x0a, 0xed, 0x92, 0xa4, 0xd6, 0xeb, 0xa4}: "DellComputraceBinary",
		efi.GUID{0x74, 0x85, 0x19, 0x71, 0x9a, 0xfe, 0xb5, 0x45, 0xa2, 0xf8, 0x4d, 0x29, 0x87, 0x06, 0x6d, 0x20}: "AsusWMIMethod",
		efi.GUID{0x74, 0x88, 0x0a, 0x70, 0x15, 0xd2, 0xbb, 0x4a, 0x9e, 0xf2, 0x7a, 0x80, 0x12, 0x85, 0x60, 0xe0}: "EmmcSoftwareTuningStorage",
		efi.GUID{0x74, 0x88, 0x0a, 0x70, 0x15, 0xd2, 0xcc, 0x4a, 0x9e, 0xf2, 0x7a, 0x80, 0x12, 0x85, 0x60, 0xe0}: "UfsPlatform",
		efi.GUID{0x74, 0x8a, 0x77, 0x8b, 0x75, 0xc2, 0xd5, 0x49, 0x93, 0xed, 0x4d, 0x70, 0x9a, 0x12, 0x9c, 0xb1}: "AbtDxe",
		efi.GUID{0x74, 0xa5, 0x78, 0x42, 0x69, 0x47, 0x60, 0x4d, 0xb0, 0x90, 0xdd, 0x49, 0x16, 0x69, 0x15, 0x90}: "RecoveryModuleLoadPei",
		efi.GUID{0x74, 0xa9, 0x3a, 0x78, 0xb0, 0xdf, 0x7b, 0x48, 0x90, 0x6f, 0x12, 0x0f, 0xb9, 0x48, 0x6e, 0x88}: "SetupConfigUpdateDxeLightningRidgeEXECB4",
		efi.GUID{0x74, 0xb0, 0x73, 0x2b, 0x67, 0x2e, 0x8b, 0x49, 0x82, 0xac, 0xce, 0x38, 0xfb, 0x77, 0x0f, 0xfc}: "DxeSalLibEsal",
		efi.GUID{0x74, 0xc9, 0xeb, 0xc0, 0xb2, 0xb5, 0x25, 0x47, 0x90, 0x91, 0x9f, 0x45, 0x57, 0x8f, 0x21, 0x3c}: "AddressTranslationDsmMemRas",
		efi.GUID{0x74, 0xcc, 0x47, 0x68, 0xec, 0xe9, 0x8f, 0x4f, 0xa2, 0x9d, 0xab, 0x44, 0xe7, 0x54, 0xa8, 0xfc}: "ArmMpCoreInfoPpiGuid",
		efi.GUID{0x74, 0xd2, 0xc6, 0xb1, 0x4f, 0x06, 0xc7, 0x46, 0xa9, 0x24, 0xdc, 0xf8, 0x5f, 0x3d, 0x74, 0x7e}: "AmiRedfishIScsi",
		efi.GUID{0x74, 0xd3, 0xcc, 0x24, 0xf6, 0x3d, 0x81, 0x41, 0x86, 0xf6, 0xe3, 0xc6, 0x69, 0x20, 0xa1, 0x45}: "UpdateMemoryRecord",
		efi.GUID{0x74, 0xe7, 0xad, 0x9e, 0x36, 0xc7, 0x3e, 0x49, 0xb2, 0xa1, 0x9c, 0xe0, 0x41, 0x58, 0x61, 0xfa}: "AmdXgbeWorkaroundPei",
		efi.GUID{0x74, 0xf1, 0xa3, 0xb9, 0x36, 0x1b, 0xec, 0x4a, 0x99, 0xe2, 0xf2, 0x85, 0x5e, 0xb4, 0xc3, 0xde}: "BoardInfoDxe",
		efi.GUID{0x74, 0xfc, 0x58, 0xe4, 0x13, 0x9f, 0x0e, 0x4e, 0xa8, 0x1e, 0xe3, 0x26, 0x05, 0xfa, 0x72, 0x47}: "FlashUtilitySmmProtocol",
		efi.GUID{0x75, 0x02, 0xbe, 0x2e, 0x58, 0x64, 0xf9, 0x4a, 0x91, 0xed, 0xd3, 0xf4, 0xed, 0xb1, 0x00, 0xaa}: "SignOn",
		efi.GUID{0x75, 0x05, 0x83, 0x44, 0x1a, 0x0a, 0x0b, 0x45, 0x9f, 0xef, 0xbc, 0x88, 0xa1, 0x86, 0x6a, 0x13}: "FjGabiBootOrderHandlerSmm",
		efi.GUID{0x75, 0x06, 0x4b, 0xea, 0x36, 0x1f, 0xbe, 0x4a, 0xbb, 0x3a, 0x6d, 0x60, 0x76, 0x0a, 0x02, 0xa2}: "AmiPciPortCompatibilityProtocolGuid",
		efi.GUID{0x75, 0x11, 0xa9, 0xcc, 0xe3, 0x03, 0x2a, 0x44, 0xb3, 0xb8, 0x2e, 0x4a, 0x33, 0x5c, 0x1d, 0xea}: "AmiHsti",
		efi.GUID{0x75, 0x19, 0xe2, 0xf8, 0x99, 0x08, 0x58, 0x4f, 0xa4, 0xbe, 0x55, 0x25, 0xa9, 0xc6, 0xd7, 0x7a}: "EfiHobMemoryAllocModuleGuid",
		efi.GUID{0x75, 0x1d, 0xc2, 0x3d, 0x0e, 0xde, 0x00, 0x43, 0xa0, 0xaa, 0x19, 0xc4, 0x1c, 0x0c, 0xf3, 0xdf}: "SaGlobalNvsAreaProtocol",
		efi.GUID{0x75, 0x22, 0x3f, 0x2e, 0xcd, 0x89, 0xe4, 0x4d, 0xbd, 0x84, 0xbe, 0xbf, 0xd9, 0x4b, 0xcd, 0xcc}: "DellSmBiosDaCiSmm",
		efi.GUID{0x75, 0x27, 0xe6, 0xb8, 0x0a, 0xbb, 0xf0, 0x43, 0xa8, 0x43, 0x5b, 0xe8, 0xb1, 0x4f, 0x8c, 0xcd}: "BootGraphicsResourceTableDxe",
		efi.GUID{0x75, 0x28, 0xa7, 0xa6, 0x62, 0x29, 0x18, 0x4c, 0x9f, 0x46, 0x8d, 0xa6, 0x44, 0xcc, 0xfe, 0x00}: "EfiIScsiInitiatorNameProtocolGuid",
		efi.GUID{0x75, 0x2d, 0x41, 0xbc, 0x29, 0x27, 0x3a, 0x4c, 0xb1, 0x93, 0x5b, 0x9a, 0x58, 0x8f, 0xf6, 0x6f}: "FirmwarePerformanceProtocol",
		efi.GUID{0x75, 0x2e, 0x3d, 0x2e, 0x2e, 0x9b, 0x2d, 0x41, 0xb4, 0xb1, 0x70, 0x41, 0x6b, 0x87, 0x00, 0xff}: "RecoveryOnFatFloppyDiskGuid",
		efi.GUID{0x75, 0x33, 0xa0, 0x97, 0x0d, 0x25, 0x59, 0x4c, 0x93, 0xa8, 0xf7, 0x67, 0x96, 0x72, 0x5e, 0x18}: "AmdApcbRvSmm",
		efi.GUID{0x75, 0x37, 0xe6, 0xb8, 0x0a, 0xbb, 0xf0, 0x43, 0xa8, 0x43, 0x5b, 0xe8, 0xb1, 0x4f, 0x8c, 0xcd}: "SystemAcpiBgrtDxe",
		efi.GUID{0x75, 0x3a, 0x4a, 0x7f, 0x8c, 0x53, 0x59, 0x42, 0xb4, 0x20, 0xc4, 0x48, 0x18, 0xcb, 0xc5, 0x53}: "ATIPwrXDXE",
		efi.GUID{0x75, 0x3b, 0x1a, 0x29, 0x85, 0xc6, 0x5e, 0x47, 0x87, 0x6b, 0x2e, 0x40, 0xa6, 0xa7, 0xe1, 0x8a}: "SetTimerPeriodDxe",
		efi.GUID{0x75, 0x45, 0xc6, 0xdc, 0x7d, 0xfa, 0x7b, 0x4b, 0xb1, 0xad, 0x48, 0x42, 0x7c, 0x97, 0xc7, 0x4d}: "LibCtype",
		efi.GUID{0x75, 0x47, 0xca, 0xe9, 0x57, 0x86, 0xfc, 0x47, 0x97, 0xe7, 0x7e, 0xd6, 0x5a, 0x08, 0x43, 0x24}: "EfiHiiFontProtocolGuid",
		efi.GUID{0x75, 0x47, 0xd8, 0x3d, 0x79, 0xec, 0xcb, 0x4e, 0x84, 0x04, 0x74, 0xde, 0x03, 0x0c, 0x3f, 0x77}: "FmpDxe",
		efi.GUID{0x75, 0x4a, 0x6e, 0x6e, 0x14, 0xef, 0xfb, 0x47, 0xb4, 0x3a, 0x67, 0xec, 0x43, 0xb8, 0x7d, 0x22}: "SpiFlashProSmm",
		efi.GUID{0x75, 0x4a, 0xec, 0x81, 0xae, 0xa7, 0x7e, 0x48, 0x99, 0x3f, 0x21, 0x90, 0xbd, 0x47, 0x42, 0x3a}: "LEMEventLogProtocolDxe",
		efi.GUID{0x75, 0x51, 0x03, 0xd9, 0xe2, 0x8c, 0xde, 0x47, 0xa8, 0xb8, 0xcc, 0x98, 0xe5, 0xe2, 0xa8, 0x85}: "EfiPlatformInfoProtocol",
		efi.GUID{0x75, 0x5a, 0x1d, 0x54, 0xee, 0x95, 0xc7, 0x43, 0x9e, 0x5d, 0x23, 0x94, 0xdc, 0x48, 0x62, 0x49}: "AmiTseAdminPasswordValidGuid",
		efi.GUID{0x75, 0x61, 0x65, 0xa8, 0x10, 0x92, 0xb5, 0x4a, 0x8e, 0xd4, 0xa7, 0x50, 0x3b, 0xd9, 0x2f, 0x0c}: "BoardSmbiosDxe",
		efi.GUID{0x75, 0x68, 0xd5, 0x9b, 0xe9, 0x85, 0x10, 0x45, 0x9d, 0xc0, 0x1f, 0x84, 0x26, 0x08, 0x59, 0x1f}: "FjGpioGeminilakeDxe",
		efi.GUID{0x75, 0x69, 0x54, 0x56, 0x50, 0xc4, 0xb2, 0x44, 0x9d, 0x25, 0xce, 0x83, 0xc5, 0x82, 0x01, 0x61}: "LegacyBridgeProtocol",
		efi.GUID{0x75, 0x6e, 0x88, 0x0f, 0x29, 0x30, 0xcf, 0x4e, 0xb6, 0x94, 0x22, 0x89, 0x4d, 0x3f, 0x21, 0x43}: "PLEDDXE",
		efi.GUID{0x75, 0x72, 0x2c, 0x36, 0x8f, 0x4d, 0x07, 0x46, 0x8d, 0x8f, 0x28, 0x89, 0x3a, 0x8a, 0xcd, 0x60}: "EpuHwModePei",
		efi.GUID{0x75, 0x73, 0xad, 0x91, 0x8e, 0x8e, 0xd2, 0x49, 0xa3, 0x43, 0x68, 0xbc, 0x78, 0x27, 0x39, 0x55}: "HddPasswordPei",
		efi.GUID{0x75, 0x76, 0xfc, 0x1d, 0x00, 0xcb, 0xf8, 0x4b, 0xb8, 0xf0, 0xe1, 0xc9, 0x93, 0x81, 0x4d, 0x2e}: "FjWirelessLanDxe",
		efi.GUID{0x75, 0x7d, 0x75, 0xc0, 0x84, 0x3f, 0x92, 0x25, 0xae, 0xb9, 0x33, 0xd1, 0x9b, 0xab, 0xcc, 0xf7}: "TmpDecFileHolderDxe",
		efi.GUID{0x75, 0x7e, 0x49, 0x08, 0xf6, 0x0b, 0xe2, 0x40, 0x8a, 0xbf, 0xb9, 0x8d, 0xfb, 0x46, 0x4c, 0x93}: "SpiFlashPeiLibNull",
		efi.GUID{0x75, 0x86, 0x47, 0x4d, 0x19, 0x9d, 0xb2, 0x4e, 0x99, 0x60, 0xcb, 0xc8, 0x8d, 0x6c, 0x39, 0x35}: "PlatformHmacShaSmm",
		efi.GUID{0x75, 0x8e, 0x57, 0x18, 0x73, 0xd0, 0x03, 0x42, 0x90, 0xd2, 0x87, 0x88, 0xa8, 0x71, 0xe4, 0x4d}: "LenovoComputraceSmiServices",
		efi.GUID{0x75, 0xa4, 0x2a, 0xdc, 0x36, 0xf6, 0xbb, 0x48, 0x6d, 0x74, 0x7f, 0x2d, 0x92, 0x6c, 0x11, 0x11}: "LEMElockerSet",
		efi.GUID{0x75, 0xa4, 0x2a, 0xdc, 0x39, 0xf9, 0xbb, 0x48, 0x9d, 0x74, 0x7f, 0x2d, 0x62, 0x9c, 0x11, 0x11}: "LoadComputraceImage",
		efi.GUID{0x75, 0xa4, 0x3a, 0xdc, 0x39, 0xf9, 0xbb, 0x48, 0x9d, 0x74, 0x7f, 0x2d, 0x62, 0x9c, 0x11, 0x11}: "LoadCptImage",
		efi.GUID{0x75, 0xa7, 0xbe, 0x49, 0x94, 0xfb, 0x5d, 0x45, 0x98, 0x26, 0x8d, 0xb4, 0xa0, 0x4d, 0xbd, 0x02}: "POSTCODE0A_BASEFWUPDATE_DXE",
		efi.GUID{0x75, 0xa8, 0x0a, 0x26, 0xed, 0x0e, 0xe1, 0x4e, 0x8a, 0x14, 0x04, 0x6b, 0x4f, 0xb1, 0x7e, 0xf5}: "DetectRecoveryModePei",
		efi.GUID{0x75, 0xab, 0x1a, 0xf7, 0xbe, 0x41, 0x09, 0xc2, 0xa3, 0x24, 0x9b, 0x96, 0x3b, 0xbd, 0xcb, 0x26}: "AmdRasSspDxe",
		efi.GUID{0x75, 0xad, 0x33, 0xb6, 0x8c, 0x11, 0x7c, 0x4e, 0xbe, 0xdf, 0xa3, 0x1d, 0x32, 0x34, 0x22, 0x1e}: "SmmStatus",
		efi.GUID{0x75, 0xae, 0x57, 0x2a, 0x7a, 0x8b, 0x64, 0x4c, 0x86, 0x56, 0xdb, 0x51, 0xdd, 0xc3, 0x6f, 0x7b}: "EfiHiiExtProtocol",
		efi.GUID{0x75, 0xba, 0x2d, 0x3d, 0xbc, 0x5e, 0xea, 0x4e, 0xa4, 0x87, 0x06, 0xad, 0x9e, 0x1c, 0xac, 0xb3}: "DellI2cPlatformDxe",
		efi.GUID{0x75, 0xba, 0x65, 0x74, 0xa7, 0x88, 0x61, 0x4b, 0x9a, 0x7e, 0x6d, 0x4e, 0xdf, 0x68, 0x04, 0xdc}: "AmiUdfMediaGuid",
		efi.GUID{0x75, 0xbc, 0x5d, 0x7a, 0x2b, 0x5b, 0x67, 0x4e, 0xbd, 0xe1, 0xd4, 0x8e, 0xee, 0x76, 0x15, 0x62}: "EfiSmmSpiReadyProtocolGuid",
		efi.GUID{0x75, 0xbe, 0x42, 0xf3, 0x4c, 0x27, 0x3c, 0x43, 0xa2, 0x4d, 0x28, 0x16, 0xf5, 0x43, 0x3d, 0x50}: "VmwSmbios",
		efi.GUID{0x75, 0xc2, 0xce, 0x5b, 0x68, 0x69, 0xbf, 0x4f, 0x83, 0x39, 0x90, 0x68, 0x5d, 0xe8, 0xad, 0x81}: "TouchDriver",
		efi.GUID{0x75, 0xd6, 0x84, 0x66, 0x06, 0xee, 0xb2, 0x49, 0x87, 0x6f, 0x79, 0xc5, 0x8f, 0xdd, 0xa5, 0xb7}: "IrmtAcpiTableStorageGuid",
		efi.GUID{0x75, 0xf0, 0x2e, 0x83, 0x39, 0x7d, 0x4c, 0x4e, 0x83, 0xb9, 0xb1, 0xeb, 0xf3, 0x4d, 0xa2, 0xd6}: "PcdInitDxe",
		efi.GUID{0x75, 0xf2, 0x59, 0x5c, 0x0a, 0x63, 0x55, 0x48, 0x89, 0x8c, 0x9a, 0xd0, 0xc2, 0x52, 0xf8, 0x23}: "BrightnessHardwareEcSmm",
		efi.GUID{0x76, 0x06, 0xa9, 0xc7, 0xcc, 0x51, 0xfa, 0x4f, 0xb5, 0xca, 0x69, 0xea, 0x88, 0xd2, 0xf7, 0x8d}: "EfiPlatformTypeOpalCityFpgaProtocol",
		efi.GUID{0x76, 0x0a, 0x48, 0xfd, 0x34, 0xb1, 0xf7, 0x4e, 0xad, 0xfe, 0xb0, 0xe0, 0x54, 0x63, 0x98, 0x07}: "UsraProtocol",
		efi.GUID{0x76, 0x0f, 0xed, 0xf7, 0x41, 0x1f, 0x27, 0x45, 0xaf, 0x2a, 0xee, 0xcc, 0x76, 0xb8, 0xf0, 0x78}: "ArmaniDxe",
		efi.GUID{0x76, 0x23, 0xc8, 0x3d, 0x7b, 0x63, 0xa6, 0x40, 0xa8, 0xfc, 0xa5, 0x65, 0x41, 0x7f, 0x2c, 0x38}: "Ps2KeyboardDxe",
		efi.GUID{0x76, 0x25, 0x3e, 0x07, 0xc1, 0xf6, 0x91, 0x4b, 0x92, 0xa9, 0xd4, 0x67, 0x5d, 0xda, 0x34, 0xb1}: "PttPassThruProtocolGuid",
		efi.GUID{0x76, 0x28, 0xe4, 0x1a, 0x8f, 0x00, 0x61, 0x41, 0xb2, 0xb7, 0x1c, 0x0d, 0x15, 0xc5, 0xef, 0x43}: "DefaultDataFile",
		efi.GUID{0x76, 0x2c, 0xc3, 0x6b, 0xdb, 0x91, 0x48, 0x45, 0xa4, 0x19, 0x0b, 0x88, 0x9e, 0xb8, 0x19, 0x6f}: "EventLogApplication",
		efi.GUID{0x76, 0x43, 0x4e, 0x3a, 0x71, 0x48, 0x0e, 0x4b, 0xa0, 0x2f, 0xed, 0x36, 0xf2, 0xae, 0xcd, 0x00}: "AmiCsmVideoPolicyProtocolGuid",
		efi.GUID{0x76, 0x44, 0x0b, 0x40, 0x81, 0x30, 0xd6, 0x11, 0x87, 0xed, 0x00, 0x06, 0x29, 0x45, 0xc3, 0xb9}: "SystemSpeakerDxe",
		efi.GUID{0x76, 0x53, 0xdf, 0xa2, 0xed, 0xc2, 0xc0, 0x49, 0x90, 0xff, 0x8b, 0x17, 0x3b, 0x0f, 0xd0, 0x66}: "EsaFull",
		efi.GUID{0x76, 0x56, 0xdd, 0x15, 0x79, 0x26, 0x24, 0x4e, 0x9c, 0xaa, 0x85, 0xb2, 0x2d, 0xd8, 0x93, 0xeb}: "LenovoSecureFlashVerifySmm",
		efi.GUID{0x76, 0x6c, 0x19, 0x64, 0xe3, 0x58, 0x4d, 0x0b, 0x94, 0x84, 0xb5, 0x4f, 0x7c, 0x43, 0x49, 0xca}: "BootModePei",
		efi.GUID{0x76, 0x76, 0x47, 0x8e, 0xfd, 0x55, 0xcf, 0x48, 0x92, 0x10, 0x15, 0xa9, 0x9b, 0x27, 0xd7, 0x40}: "Slp10",
		efi.GUID{0x76, 0x78, 0x92, 0x8c, 0x71, 0xec, 0xe4, 0x4d, 0xa9, 0x1d, 0x8a, 0xd4, 0x78, 0xca, 0x95, 0x39}: "CpuRas",
		efi.GUID{0x76, 0x80, 0x2f, 0x94, 0x35, 0x33, 0xf9, 0x4e, 0x93, 0xcc, 0x74, 0xa4, 0x70, 0x26, 0x3d, 0xda}: "SetAutoUmaModeSmm",
		efi.GUID{0x76, 0x82, 0x4a, 0x8d, 0x94, 0x19, 0x82, 0x4e, 0x98, 0x3a, 0xa7, 0x17, 0x53, 0x61, 0x77, 0x97}: "menu_checked_selected",
		efi.GUID{0x76, 0x82, 0xd8, 0x4e, 0xdf, 0xd4, 0x03, 0x4d, 0x86, 0x61, 0x29, 0x58, 0x01, 0xb2, 0xda, 0x58}: "FastBootExceptionInfoHob",
		efi.GUID{0x76, 0x85, 0x9c, 0x82, 0xf7, 0x8c, 0xdb, 0x43, 0x81, 0xe6, 0xd9, 0x55, 0x32, 0x4b, 0xf9, 0x31}: "OememDxeGNVS",
		efi.GUID{0x76, 0x87, 0xb3, 0x3a, 0xbb, 0x01, 0x17, 0x4a, 0xbc, 0x40, 0x82, 0x9b, 0xff, 0x8f, 0x8d, 0xa5}: "FjLanFlexIo",
		efi.GUID{0x76, 0x9a, 0x30, 0xf8, 0x8f, 0xa4, 0x8c, 0x44, 0xb7, 0xb3, 0x0d, 0x83, 0x24, 0x33, 0xce, 0x5f}: "EcIoSmm",
		efi.GUID{0x76, 0x9a, 0xaa, 0x63, 0x5f, 0xd8, 0x38, 0x4a, 0xb8, 0x51, 0xa0, 0x9d, 0x4d, 0xc1, 0xfc, 0x1d}: "EcRegionAccessDxe",
		efi.GUID{0x76, 0xa9, 0x5e, 0x37, 0xcd, 0x3c, 0x74, 0x4e, 0xa8, 0x45, 0x26, 0xb9, 0xb3, 0x24, 0xb1, 0x3c}: "EfiUxixSystemConfig",
		efi.GUID{0x76, 0xaf, 0x7c, 0xda, 0x17, 0xcb, 0x80, 0x4d, 0xae, 0x21, 0x2b, 0xd3, 0xae, 0x42, 0x1c, 0x76}: "RuntimeAmiFlashLibCompat",
		efi.GUID{0x76, 0xb1, 0x3f, 0x0d, 0x69, 0x95, 0x51, 0x4d, 0xa3, 0xef, 0x7d, 0x61, 0xc6, 0x4f, 0xea, 0xba}: "EfiSecurityPkgTokenSpaceGuid",
		efi.GUID{0x76, 0xbc, 0xb8, 0xa2, 0x5b, 0xc4, 0xb0, 0x40, 0xa2, 0x3e, 0xd6, 0x82, 0x7c, 0x83, 0x5d, 0x1e}: "TouchPad_Elan",
		efi.GUID{0x76, 0xc2, 0xf8, 0x9e, 0xe6, 0xb3, 0xd9, 0x4a, 0x8f, 0xe7, 0xc7, 0x4f, 0x71, 0xc4, 0x72, 0x48}: "AAFTblSMI",
		efi.GUID{0x76, 0xc4, 0x71, 0xa0, 0x8c, 0xf7, 0xc2, 0x41, 0xa1, 0x73, 0xb4, 0x3d, 0x69, 0x9a, 0x2c, 0x80}: "AppleEfiSocShutdown",
		efi.GUID{0x76, 0xc7, 0x32, 0xea, 0x14, 0x6c, 0xf4, 0x41, 0x80, 0xc6, 0x03, 0x49, 0xe9, 0xe4, 0x8a, 0xf8}: "FvbVariableStorageSmm",
		efi.GUID{0x76, 0xc7, 0xb5, 0x5c, 0xd5, 0x60, 0xee, 0x45, 0x88, 0x3c, 0x45, 0x27, 0x08, 0xcd, 0x74, 0x3f}: "EfiLoadPeImageProtocolGuid",
		efi.GUID{0x76, 0xc8, 0x8f, 0xd3, 0x17, 0x0b, 0x95, 0x4d, 0xa7, 0xf8, 0xa0, 0x22, 0xec, 0xa1, 0xca, 0x42}: "MeExtMeasurement",
		efi.GUID{0x76, 0xcb, 0x59, 0x58, 0xef, 0x6b, 0x8a, 0x46, 0xbe, 0x2d, 0xb3, 0xdd, 0x1a, 0x27, 0xf0, 0x12}: "EfiUsbPolicyProtocolGuid",
		efi.GUID{0x76, 0xcc, 0x91, 0xe3, 0xf7, 0x41, 0x95, 0x49, 0x81, 0x45, 0xd4, 0x16, 0xd0, 0x3a, 0x2a, 0xd3}: "IntelGraphicsPeiDriver",
		efi.GUID{0x76, 0xce, 0xbf, 0x75, 0xf4, 0x56, 0xe1, 0x4f, 0xb2, 0x57, 0x8b, 0x07, 0x5e, 0x8f, 0x98, 0xa8}: "OemIp3SMI",
		efi.GUID{0x76, 0xd2, 0x60, 0xe1, 0xf9, 0xf2, 0xa2, 0x44, 0x8e, 0xa6, 0x8b, 0xb5, 0xc4, 0xc3, 0x03, 0x07}: "FjThermalDxe",
		efi.GUID{0x76, 0xd3, 0x5e, 0xab, 0x38, 0xdd, 0x22, 0x4d, 0xae, 0x89, 0xb6, 0x45, 0xa4, 0xa3, 0x23, 0x6e}: "SynQuacerI2cDxe",
		efi.GUID{0x76, 0xd4, 0xd1, 0x73, 0xc9, 0xa7, 0xfd, 0x4e, 0x8f, 0x8b, 0xd5, 0x32, 0xef, 0x38, 0x17, 0x08}: "EfiPlatformTxtDeviceMemory",
		efi.GUID{0x76, 0xd5, 0xb1, 0x8a, 0x77, 0x59, 0x89, 0x4a, 0x94, 0x14, 0x09, 0x9d, 0x90, 0xb5, 0x3e, 0x79}: "TpvSmm",
		efi.GUID{0x76, 0xd7, 0xe7, 0xe0, 0xeb, 0xe7, 0x5f, 0x4e, 0x9a, 0xa8, 0x54, 0xcf, 0x3a, 0xa6, 0x4a, 0x43}: "PeiServicesTablePointerLibKr7",
		efi.GUID{0x76, 0xd9, 0xa1, 0x9b, 0x24, 0x06, 0xa3, 0x41, 0x86, 0x50, 0x28, 0x16, 0x5e, 0x8d, 0x9a, 0xe8}: "BaseDebugLibNull",
		efi.GUID{0x76, 0xea, 0x19, 0x26, 0x99, 0x45, 0x78, 0x49, 0x86, 0x49, 0xe7, 0x37, 0x11, 0x70, 0xc2, 0x56}: "OpticalDiskIdm",
		efi.GUID{0x76, 0xea, 0x5c, 0xfe, 0x72, 0x4f, 0xe8, 0x49, 0x98, 0x6f, 0x2c, 0xd8, 0x99, 0xdf, 0xfe, 0x5d}: "FaultTolerantWriteDxe",
		efi.GUID{0x76, 0xf1, 0x94, 0xc6, 0x0e, 0x57, 0xc7, 0x48, 0x84, 0x0e, 0x1b, 0x30, 0x92, 0x0c, 0xba, 0x76}: "FjIbvBiosPasswordAbstractionSmmProtocol",
		efi.GUID{0x76, 0xf9, 0x40, 0x14, 0x32, 0x23, 0xf3, 0x4d, 0xb7, 0x7f, 0x62, 0xf8, 0xc6, 0xc1, 0xef, 0xfa}: "AmdNbioBaseRmbDxe",
		efi.GUID{0x77, 0x02, 0x71, 0x94, 0x96, 0x93, 0xba, 0x45, 0x8a, 0x47, 0x53, 0x4a, 0x5b, 0x46, 0xf3, 0x91}: "ClearPassword",
		efi.GUID{0x77, 0x0b, 0x1a, 0x05, 0x66, 0xc0, 0x10, 0x46, 0x99, 0x04, 0xbf, 0x25, 0xc2, 0x96, 0xd6, 0xe6}: "LenovoEn25Qh32FlashPartDxe",
		efi.GUID{0x77, 0x0b, 0xf7, 0x73, 0x3b, 0x94, 0x90, 0x40, 0x99, 0xe8, 0x4f, 0x8e, 0x4d, 0x82, 0x4a, 0x43}: "wifi_none",
		efi.GUID{0x77, 0x0d, 0xb5, 0x8c, 0x24, 0x45, 0x78, 0x4f, 0xa9, 0xad, 0x62, 0x8d, 0xf3, 0x11, 0x20, 0x3e}: "FjCypressConfigDriver",
		efi.GUID{0x77, 0x1c, 0xed, 0xac, 0xa5, 0x4e, 0x10, 0x47, 0x94, 0x12, 0xee, 0xd3, 0x13, 0x5f, 0x9c, 0x7d}: "SaveTraceHubConfig",
		efi.GUID{0x77, 0x1d, 0x54, 0xcd, 0x99, 0x66, 0x36, 0x4b, 0xa3, 0x1e, 0x1a, 0xa4, 0xc5, 0xd5, 0xb9, 0x46}: "AmiStatusCodeCpuBistData",
		efi.GUID{0x77, 0x21, 0x04, 0xf5, 0x29, 0x1d, 0xc5, 0x45, 0xba, 0x4d, 0x4d, 0x0e, 0xb2, 0xe8, 0x85, 0x75}: "IT8728SioAcBack",
		efi.GUID{0x77, 0x23, 0xd6, 0xb8, 0x70, 0x79, 0xe1, 0x4c, 0x87, 0xf4, 0x9d, 0xde, 0x56, 0xae, 0x89, 0x82}: "BiosGuardVerifyRomImage",
		efi.GUID{0x77, 0x28, 0xdc, 0x45, 0xf1, 0x0d, 0xd4, 0x4b, 0x81, 0x0f, 0x0c, 0x75, 0x11, 0x18, 0x19, 0xcc}: "EcDxeRestorePei",
		efi.GUID{0x77, 0x2b, 0xfd, 0x6a, 0xc1, 0x98, 0xcd, 0x4a, 0xa6, 0xf9, 0x8a, 0x94, 0x39, 0xde, 0x0f, 0xb1}: "EfiSmmStatusCodeProtocolGuid",
		efi.GUID{0x77, 0x2e, 0x15, 0x49, 0xda, 0x1a, 0x64, 0x47, 0xb7, 0xa2, 0x7a, 0xfe, 0xfe, 0xd9, 0x5e, 0x8b}: "EfiDebugImageInfoTableGuid",
		efi.GUID{0x77, 0x2f, 0x9d, 0xbb, 0xfd, 0xe1, 0x51, 0x44, 0xa9, 0x46, 0x6e, 0x86, 0x8d, 0x21, 0x6e, 0x4d}: "PlatformNotifyDispatchPei",
		efi.GUID{0x77, 0x38, 0x36, 0x42, 0x13, 0x55, 0x19, 0x40, 0xbd, 0xfe, 0xcc, 0x07, 0x5b, 0x64, 0x67, 0x11}: "GnbSocRenoirDxe",
		efi.GUID{0x77, 0x38, 0x36, 0x42, 0x13, 0x55, 0x19, 0x40, 0xbd, 0xfe, 0xcc, 0x07, 0x5b, 0x64, 0x67, 0xfd}: "GnbSocRavenDxe",
		efi.GUID{0x77, 0x3f, 0x29, 0x31, 0xbc, 0x96, 0x80, 0x47, 0x8f, 0xcb, 0x1e, 0xd1, 0xf9, 0xe4, 0x25, 0xe3}: "UEFIH19SmmEnableCrashDump",
		efi.GUID{0x77, 0x43, 0x80, 0x08, 0x7a, 0xaf, 0x96, 0x44, 0x8a, 0x7b, 0x17, 0x59, 0x00, 0xe9, 0xab, 0x46}: "EdkIIRedfishCredentialProtocol",
		efi.GUID{0x77, 0x5b, 0x71, 0x52, 0xa5, 0x04, 0x7a, 0x48, 0xb9, 0x80, 0xcd, 0xc3, 0x71, 0xb5, 0xbe, 0xc8}: "AsusPostErrPei",
		efi.GUID{0x77, 0x66, 0xd8, 0xcb, 0x2f, 0x36, 0x04, 0x4c, 0x94, 0x59, 0xa7, 0x41, 0x32, 0x6e, 0x05, 0xcf}: "SeCUmaPpiGuid",
		efi.GUID{0x77, 0x68, 0xb8, 0xb0, 0x21, 0xc9, 0x8d, 0x4d, 0x99, 0x57, 0xb7, 0x3d, 0x6b, 0xa2, 0x0b, 0xad}: "EcCapsuleDXE",
		efi.GUID{0x77, 0x70, 0xd6, 0x2f, 0xf5, 0x63, 0x43, 0x4b, 0xb1, 0x80, 0x19, 0x74, 0xe5, 0xc7, 0x0b, 0xeb}: "MTKSUPP",
		efi.GUID{0x77, 0x75, 0xae, 0x1c, 0x62, 0xd6, 0x27, 0x47, 0xba, 0xec, 0x77, 0x76, 0x31, 0xd3, 0xa9, 0x58}: "SystemVspCmosPei",
		efi.GUID{0x77, 0x8b, 0x1d, 0x82, 0x6d, 0x24, 0x96, 0x4e, 0x8e, 0x10, 0x34, 0x67, 0xd5, 0x6a, 0xb1, 0xba}: "SetupAdvanced",
		efi.GUID{0x77, 0x8b, 0x1d, 0x82, 0x6d, 0x24, 0x96, 0x4e, 0x8e, 0x10, 0x34, 0x67, 0xd5, 0x6a, 0xb1, 0xbb}: "SetupMain",
		efi.GUID{0x77, 0x8b, 0x24, 0xce, 0x79, 0x11, 0xc6, 0x4b, 0xb3, 0x24, 0x9d, 0x2e, 0xdc, 0x4b, 0x97, 0x6e}: "AhciControllerPei",
		efi.GUID{0x77, 0x8b, 0xc9, 0xa0, 0xa5, 0xcb, 0xb8, 0x4b, 0x99, 0x3b, 0x4a, 0xf6, 0xce, 0x33, 0xec, 0xe4}: "Tcg2Pei",
		efi.GUID{0x77, 0x9a, 0x5f, 0x9c, 0x16, 0xdb, 0x74, 0x41, 0x8e, 0x30, 0xaa, 0x0b, 0xe1, 0x9b, 0xc1, 0xfe}: "H19EmmcSecureErase",
		efi.GUID{0x77, 0x9e, 0x7b, 0x94, 0x31, 0x92, 0x9c, 0x44, 0xbe, 0xd5, 0xfd, 0x40, 0x51, 0xbd, 0x4e, 0x39}: "AmdSocAm4CznDxe",
		efi.GUID{0x77, 0xa4, 0xe9, 0x1b, 0xe6, 0x92, 0xa4, 0x4b, 0x94, 0x96, 0xc9, 0xde, 0x8e, 0x15, 0x25, 0x34}: "SbSocStarshipSp3Dxe",
		efi.GUID{0x77, 0xac, 0xf2, 0xb9, 0xc7, 0x54, 0x75, 0x40, 0xb4, 0x2e, 0xc3, 0x63, 0x25, 0xa9, 0x46, 0x8d}: "LenovoVerifiedBootPei",
		efi.GUID{0x77, 0xad, 0xec, 0xbc, 0x99, 0x62, 0x5d, 0x41, 0xae, 0x48, 0x73, 0x3c, 0x45, 0x47, 0x68, 0x91}: "DxeWifiManager",
		efi.GUID{0x77, 0xbd, 0x39, 0xf1, 0xf7, 0x7f, 0xd6, 0x49, 0x90, 0x86, 0xd5, 0x0a, 0xb2, 0x6f, 0x6d, 0xd7}: "EfiSvSmmProtocol",
		efi.GUID{0x77, 0xbe, 0x44, 0x5d, 0x69, 0x56, 0xd0, 0x41, 0xb6, 0x85, 0x1b, 0xf3, 0xf8, 0x3e, 0xfb, 0x98}: "DellPasswordUi",
		efi.GUID{0x77, 0xe0, 0x89, 0x05, 0xc8, 0x93, 0x0e, 0x47, 0x9b, 0x90, 0x95, 0x8b, 0x4e, 0x2f, 0xe6, 0x86}: "DevUpdateProgress",
		efi.GUID{0x77, 0xf2, 0xec, 0xf7, 0x66, 0xcd, 0xe8, 0x4d, 0xa4, 0x25, 0x1d, 0x9f, 0x89, 0x94, 0x92, 0xa7}: "ASUSFTM",
		efi.GUID{0x77, 0xf3, 0x59, 0x40, 0xd5, 0x27, 0x39, 0x41, 0xb7, 0xe7, 0xf9, 0x95, 0x91, 0xf7, 0xc4, 0x6d}: "FchSmmDispatcher",
		efi.GUID{0x77, 0xf7, 0x3d, 0x64, 0x12, 0xf3, 0xed, 0x42, 0x81, 0xcc, 0x1b, 0x1f, 0x57, 0xe1, 0x8a, 0xd6}: "PchSmbusArpDisabled",
		efi.GUID{0x78, 0x03, 0x07, 0x53, 0x9a, 0x11, 0x36, 0x48, 0x77, 0xbd, 0x89, 0x3c, 0x82, 0x4a, 0xce, 0xb2}: "FchPromontoryXhciPei",
		efi.GUID{0x78, 0x03, 0x07, 0x53, 0x9a, 0x11, 0x36, 0x48, 0x82, 0xbd, 0x89, 0x3c, 0x82, 0x4a, 0xce, 0xb2}: "FchPei",
		efi.GUID{0x78, 0x08, 0xc5, 0x0f, 0x33, 0x16, 0x2a, 0x43, 0xbd, 0xe4, 0x84, 0x13, 0x57, 0xfc, 0x15, 0xe9}: "AmiScsiPassThruInitProtocolGuid",
		efi.GUID{0x78, 0x1b, 0x33, 0x62, 0xd0, 0xd8, 0x8c, 0x4c, 0x8c, 0xcb, 0xd2, 0x7d, 0xfe, 0x32, 0xdb, 0x9b}: "EfiLegacySpiSmmControllerProtocolGuid",
		efi.GUID{0x78, 0x1d, 0x3b, 0x2f, 0x0e, 0x06, 0x5b, 0x4d, 0xac, 0x7e, 0x1e, 0x1d, 0xb2, 0x12, 0x85, 0x59}: "OemDevInit",
		efi.GUID{0x78, 0x1e, 0xf9, 0x97, 0x12, 0xea, 0xa6, 0x4e, 0xb7, 0xb3, 0x7b, 0x06, 0x78, 0xc2, 0x86, 0x73}: "AmiPeiPciTableInitPpiGuid",
		efi.GUID{0x78, 0x28, 0x8f, 0xde, 0xd5, 0x36, 0x8e, 0x49, 0xba, 0x59, 0x16, 0x8c, 0x26, 0x47, 0xb3, 0x35}: "PeiIffsTransitionStartPpi",
		efi.GUID{0x78, 0x2c, 0xf3, 0xaa, 0x7b, 0x94, 0x9a, 0x43, 0xa1, 0x80, 0x2e, 0x14, 0x4e, 0xc3, 0x77, 0x92}: "EfiAuthenticatedVariableGuid",
		efi.GUID{0x78, 0x2e, 0x32, 0x42, 0x59, 0x46, 0x04, 0x47, 0xa0, 0x5e, 0xf2, 0xd7, 0x5d, 0x37, 0x26, 0xac}: "GpioPolicyPei",
		efi.GUID{0x78, 0x2e, 0xbf, 0x28, 0x2d, 0xad, 0x16, 0x46, 0xab, 0xad, 0x76, 0x44, 0xcd, 0x7e, 0x47, 0xc8}: "FvBb1Pei",
		efi.GUID{0x78, 0x2f, 0x5d, 0x93, 0x1f, 0x3a, 0xe6, 0x4d, 0xb2, 0x8d, 0x12, 0x3a, 0x40, 0xdd, 0x2d, 0xec}: "SmmGenericElog",
		efi.GUID{0x78, 0x33, 0x85, 0xec, 0x8d, 0x00, 0x10, 0x4e, 0xbd, 0xdf, 0xe1, 0x3f, 0xec, 0x49, 0x1b, 0x23}: "PowerReportSmm",
		efi.GUID{0x78, 0x33, 0x95, 0xec, 0x8d, 0x00, 0x10, 0x4e, 0xbd, 0xdf, 0xe1, 0x3f, 0xec, 0x49, 0x1b, 0x23}: "LGPowerReportSmm",
		efi.GUID{0x78, 0x33, 0x95, 0xec, 0x8d, 0x00, 0x10, 0x4e, 0xbd, 0xdf, 0xe1, 0x3f, 0xec, 0x49, 0x2c, 0x54}: "LGEcCommunicationSmm",
		efi.GUID{0x78, 0x33, 0xdb, 0xa6, 0xd7, 0xcf, 0xfd, 0x4b, 0xa1, 0xc4, 0x27, 0x09, 0xfe, 0xc5, 0x2f, 0x8b}: "AmiTseOemPortingVar10",
		efi.GUID{0x78, 0x41, 0x6f, 0x8f, 0x5f, 0xe2, 0x2c, 0x44, 0xb5, 0x4f, 0xd8, 0x05, 0x20, 0x5e, 0xa3, 0xff}: "DellXhciSmm",
		efi.GUID{0x78, 0x44, 0x0f, 0xfd, 0xfd, 0x0e, 0x1d, 0x46, 0xba, 0x2d, 0xe5, 0x8c, 0x45, 0xfd, 0x5f, 0x5e}: "EfiGetPcdInfoProtocolGuid",
		efi.GUID{0x78, 0x47, 0x40, 0xe1, 0x48, 0xb8, 0xff, 0x4f, 0x83, 0x51, 0x9f, 0x78, 0x79, 0x14, 0x17, 0xd9}: "TurboSmm",
		efi.GUID{0x78, 0x56, 0x34, 0x12, 0x0a, 0x93, 0x95, 0x4a, 0xab, 0x04, 0x2e, 0x6c, 0xfd, 0xff, 0x66, 0x31}: "TcgPeiAftermem",
		efi.GUID{0x78, 0x56, 0x34, 0x12, 0xbb, 0xaa, 0xdd, 0xcc, 0xee, 0xff, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66}: "My",
		efi.GUID{0x78, 0x59, 0xda, 0x1d, 0x9a, 0xb2, 0xa7, 0x4e, 0xae, 0xfb, 0x8b, 0x0b, 0xaa, 0x98, 0x2e, 0x22}: "ExReportStatusCodeRouterPei",
		efi.GUID{0x78, 0x5a, 0x7e, 0x6f, 0x5e, 0x6f, 0xf4, 0x42, 0x9c, 0x30, 0x8e, 0x14, 0x41, 0x82, 0xd5, 0xf9}: "CompalCommonHookPei",
		efi.GUID{0x78, 0x62, 0xcf, 0xa8, 0x58, 0x87, 0x8d, 0x45, 0xad, 0xfb, 0x34, 0x71, 0xf5, 0xad, 0x50, 0xb1}: "SystemHddPwdPei",
		efi.GUID{0x78, 0x6c, 0xb3, 0xdf, 0x34, 0xe5, 0x05, 0x4e, 0x9d, 0x5d, 0x18, 0x03, 0xf3, 0x6e, 0x88, 0xf2}: "ReportFvRecoveryPei",
		efi.GUID{0x78, 0x71, 0x28, 0x59, 0xb2, 0x59, 0xca, 0x49, 0xbc, 0x63, 0x53, 0x2b, 0x12, 0xea, 0x2c, 0x53}: "PchSmbusSmm",
		efi.GUID{0x78, 0x79, 0x51, 0x9b, 0xa1, 0xeb, 0xe7, 0x44, 0xba, 0x65, 0x7c, 0x2c, 0xd0, 0x8b, 0xf8, 0xe9}: "EdkiiPlatformLogoProtocol",
		efi.GUID{0x78, 0x7e, 0xc9, 0xd6, 0xd7, 0xfc, 0xf5, 0x47, 0xb5, 0x75, 0x6e, 0x19, 0x40, 0x24, 0x6c, 0x7c}: "DellCountryCodeDxeSync",
		efi.GUID{0x78, 0x7f, 0x8b, 0x1c, 0x99, 0x16, 0xe6, 0x40, 0xaf, 0x33, 0x9b, 0x99, 0x5d, 0x16, 0xb0, 0x43}: "PiSmmCommunicationPei",
		efi.GUID{0x78, 0x85, 0xa6, 0x7d, 0xe9, 0xc0, 0x42, 0x47, 0x8d, 0xe5, 0xc9, 0x1a, 0xca, 0x88, 0xd5, 0xa7}: "DellBoardPolicySmm",
		efi.GUID{0x78, 0x8c, 0x81, 0x06, 0x8a, 0x1c, 0x91, 0x45, 0x98, 0x33, 0xdc, 0x0e, 0x4b, 0x95, 0x66, 0xe4}: "TdtAm",
		efi.GUID{0x78, 0x9b, 0x7f, 0x8d, 0x02, 0xfe, 0xf7, 0x41, 0xb5, 0x15, 0x08, 0x41, 0xc4, 0x29, 0x65, 0x4b}: "WiFiSupplicant",
		efi.GUID{0x78, 0xa0, 0xf5, 0xc9, 0x2d, 0x1f, 0x86, 0x40, 0xa1, 0xbe, 0x16, 0x38, 0x77, 0x4f, 0xef, 0x44}: "SsdtRtd3ATables",
		efi.GUID{0x78, 0xa4, 0x87, 0xa4, 0xef, 0x51, 0xaa, 0x48, 0x87, 0x94, 0x7b, 0xee, 0x2a, 0x05, 0x62, 0xf1}: "tftpDynamicCommand",
		efi.GUID{0x78, 0xaa, 0xd6, 0xae, 0xbf, 0xd5, 0xc5, 0x4b, 0x8c, 0xc5, 0xf9, 0xee, 0x47, 0xcf, 0x92, 0x99}: "CapsuleRuntimeDxe",
		efi.GUID{0x78, 0xab, 0x51, 0xdd, 0x5d, 0xe5, 0x13, 0x44, 0xaf, 0xae, 0xe5, 0x92, 0xf6, 0xb5, 0x32, 0x1b}: "AmiEventLogsDynamic",
		efi.GUID{0x78, 0xb2, 0xa1, 0x89, 0xa1, 0xa1, 0xf7, 0x4d, 0xb1, 0x37, 0xde, 0x5a, 0xd7, 0xc4, 0x79, 0x13}: "EfiPchTokenSpaceGuid",
		efi.GUID{0x78, 0xc2, 0x98, 0x6e, 0x75, 0x4b, 0x0f, 0x4e, 0x81, 0xa8, 0xf3, 0xe1, 0x45, 0x9f, 0x05, 0x24}: "FjCmosAccessSmm",
		efi.GUID{0x78, 0xcb, 0x6d, 0x2d, 0xe2, 0xca, 0x59, 0x44, 0x92, 0x7c, 0x64, 0xa6, 0xb7, 0xe6, 0x4a, 0x75}: "DellEdiagsSmm",
		efi.GUID{0x78, 0xe1, 0x43, 0xaf, 0xe9, 0xc2, 0x12, 0x47, 0xa7, 0xcd, 0x08, 0xbf, 0xda, 0xc7, 0x48, 0x2c}: "UfsPciHcDxe",
		efi.GUID{0x78, 0xe3, 0x2a, 0xbf, 0xe0, 0x01, 0x05, 0x46, 0x9e, 0x3b, 0x2e, 0xe2, 0xfc, 0x73, 0x39, 0xde}: "FmpDxe",
		efi.GUID{0x78, 0xe5, 0x8c, 0x8c, 0x3d, 0x8a, 0x1c, 0x4f, 0x99, 0x35, 0x89, 0x61, 0x85, 0xc3, 0x2d, 0xd3}: "EfiFirmwareFileSystem2Guid",
		efi.GUID{0x78, 0xe6, 0x46, 0x60, 0xef, 0x24, 0x05, 0x40, 0xba, 0x39, 0xbd, 0xa1, 0x1f, 0x6d, 0x55, 0x5d}: "AmtInt16_csm",
		efi.GUID{0x78, 0xec, 0x13, 0xc6, 0xed, 0x63, 0x93, 0x4b, 0xac, 0xd4, 0x54, 0xb3, 0xd4, 0xcc, 0xc2, 0x68}: "NetworkLockerDxe",
		efi.GUID{0x78, 0xfd, 0x14, 0xef, 0x93, 0x07, 0x2b, 0x4e, 0xac, 0x6d, 0x06, 0x28, 0x47, 0xe0, 0x17, 0x91}: "MfgModeVariableGuid",
		efi.GUID{0x79, 0x08, 0x08, 0xba, 0xf4, 0x3a, 0x39, 0x46, 0x96, 0x13, 0xd1, 0xfc, 0x8e, 0xd8, 0xa6, 0x69}: "EfiJedecNvDimmSmm",
		efi.GUID{0x79, 0x11, 0x97, 0xab, 0xcf, 0x52, 0x7a, 0x4d, 0xa9, 0x1e, 0x3b, 0x14, 0xdb, 0x19, 0xbb, 0x74}: "SmartCoverPei",
		efi.GUID{0x79, 0x15, 0x2e, 0x9e, 0xd3, 0x77, 0x05, 0x49, 0xad, 0x14, 0x44, 0x79, 0xbe, 0xc0, 0x3d, 0xa2}: "IrqBoardInfoRvpM",
		efi.GUID{0x79, 0x1d, 0x73, 0xf4, 0x7e, 0x53, 0x05, 0x45, 0xbd, 0x52, 0xc0, 0x3f, 0x9b, 0x1f, 0x6b, 0x89}: "BaseTimerLibNullTemplate",
		efi.GUID{0x79, 0x20, 0x8e, 0x15, 0xf3, 0x23, 0x83, 0x4e, 0x8a, 0x35, 0x65, 0x7a, 0x76, 0x40, 0x8c, 0x0a}: "ApobSspPei",
		efi.GUID{0x79, 0x26, 0x13, 0x1c, 0x95, 0xbb, 0x9c, 0x47, 0x8a, 0x82, 0x6d, 0xe7, 0x2a, 0x52, 0xd6, 0xfd}: "AaeonPowerButtonSmi",
		efi.GUID{0x79, 0x29, 0xeb, 0x30, 0xf7, 0xb0, 0x60, 0x4d, 0xb2, 0xdc, 0x1a, 0x2c, 0x96, 0xce, 0xb1, 0xf4}: "PeiPlatformMemoryRangePpi",
		efi.GUID{0x79, 0x2d, 0x4b, 0xda, 0xe1, 0xfe, 0xc6, 0x42, 0x9b, 0x56, 0x92, 0x36, 0x33, 0x39, 0x8a, 0xeb}: "BiosCapsule",
		efi.GUID{0x79, 0x30, 0x9b, 0x72, 0x13, 0x89, 0x12, 0x4e, 0xaf, 0xef, 0x2c, 0xa2, 0x64, 0x79, 0x94, 0x69}: "AmdAcpiDxe",
		efi.GUID{0x79, 0x3f, 0x86, 0x13, 0x4b, 0xd9, 0x05, 0x42, 0xbb, 0x0f, 0xe4, 0xe0, 0x6a, 0xaa, 0x5a, 0x4e}: "DelayUefiRaidOprom",
		efi.GUID{0x79, 0x45, 0x81, 0x14, 0x05, 0xd9, 0x3b, 0x4a, 0x88, 0x74, 0x41, 0x0b, 0x51, 0x86, 0x74, 0xe7}: "RstNvmExpressSmm",
		efi.GUID{0x79, 0x45, 0xe1, 0x1b, 0x05, 0xd8, 0x3b, 0x4c, 0x88, 0x74, 0x41, 0x0b, 0x81, 0x86, 0x74, 0xe9}: "RealtekPxe",
		efi.GUID{0x79, 0x4a, 0x4b, 0x25, 0x2c, 0x77, 0xcc, 0x45, 0x05, 0xc9, 0x17, 0xf8, 0x4c, 0x2e, 0xa1, 0x97}: "HpAmdXhciDxe",
		efi.GUID{0x79, 0x50, 0x52, 0x07, 0x16, 0x26, 0x99, 0x45, 0x93, 0xfa, 0x5e, 0xe9, 0xe3, 0xf0, 0x29, 0x5c}: "CsmPolicy",
		efi.GUID{0x79, 0x52, 0x10, 0x05, 0xe6, 0xdc, 0x27, 0x4d, 0xba, 0x3c, 0x0c, 0x6f, 0x3e, 0x8d, 0xe6, 0x6d}: "SetBoardIdVar",
		efi.GUID{0x79, 0x52, 0xe6, 0xaa, 0x61, 0x07, 0xd1, 0x41, 0xba, 0x13, 0x4a, 0x3c, 0x13, 0x83, 0x60, 0x3f}: "Ozmosis",
		efi.GUID{0x79, 0x55, 0xef, 0x0a, 0x00, 0x37, 0xd2, 0x41, 0xa5, 0x3e, 0xda, 0xbd, 0x55, 0xe2, 0x24, 0x32}: "DellUsbBusSmm",
		efi.GUID{0x79, 0x56, 0xbf, 0x03, 0x49, 0x57, 0xc5, 0x4b, 0xa5, 0x3f, 0x47, 0x47, 0x1d, 0xa7, 0x67, 0xc8}: "IsscSmm",
		efi.GUID{0x79, 0x58, 0xe2, 0x1d, 0x2a, 0x6e, 0x72, 0x4d, 0xa7, 0x68, 0x28, 0x8c, 0xcb, 0x9f, 0xa7, 0x19}: "EfiMemoryConfigDataHob",
		efi.GUID{0x79, 0x59, 0x32, 0x8e, 0xe1, 0x3f, 0x27, 0x49, 0xaa, 0xe2, 0x8f, 0x5c, 0x4b, 0xd2, 0xaf, 0x0d}: "SdMmcPciHcDxe",
		efi.GUID{0x79, 0x5a, 0x05, 0x45, 0x85, 0xb3, 0x05, 0x47, 0xa3, 0xac, 0x11, 0xce, 0x99, 0xa1, 0xcb, 0x47}: "StaticSkuDataDxeNeonCityEPRP",
		efi.GUID{0x79, 0x5d, 0x44, 0xbd, 0xad, 0xb7, 0x04, 0x4f, 0x9a, 0xd8, 0x29, 0xbd, 0x20, 0x40, 0xeb, 0x3c}: "EfiLockBoxProtocolGuid",
		efi.GUID{0x79, 0x61, 0xf8, 0x30, 0xeb, 0xa9, 0x56, 0x44, 0x9d, 0x3a, 0x15, 0x7d, 0xbb, 0x62, 0xbe, 0x3b}: "Int15CallbackSmm",
		efi.GUID{0x79, 0x66, 0x0f, 0x23, 0x03, 0xf7, 0xc2, 0x4d, 0xb2, 0xb7, 0x41, 0xc6, 0x70, 0xbc, 0xc0, 0xd1}: "BiosInfoRecovery",
		efi.GUID{0x79, 0x6f, 0xfc, 0xad, 0x9f, 0xaa, 0x2b, 0x46, 0xab, 0xdb, 0xc4, 0x8e, 0x0f, 0x63, 0x56, 0xbf}: "AmdFabricRnDxe",
		efi.GUID{0x79, 0x76, 0xeb, 0x09, 0x52, 0x21, 0xf3, 0x47, 0xb8, 0x32, 0xee, 0x9b, 0x94, 0x7b, 0x29, 0xf5}: "SmartUsbProtection",
		efi.GUID{0x79, 0x7a, 0xb8, 0xf7, 0x40, 0xa6, 0xa5, 0x4a, 0x8c, 0x1e, 0x45, 0x3f, 0xb2, 0x6e, 0xf3, 0x76}: "EfiPeiPlatformTypeBuchananPassPpi",
		efi.GUID{0x79, 0x91, 0x08, 0xfc, 0x84, 0xd5, 0xcd, 0x4e, 0xa8, 0x86, 0x96, 0xa1, 0x85, 0x62, 0xd9, 0x07}: "HpThermalDiagsDxe",
		efi.GUID{0x79, 0x9b, 0x18, 0xff, 0x58, 0xf5, 0x6a, 0x4b, 0x8a, 0x78, 0x6f, 0xcd, 0x2b, 0x4b, 0x0e, 0x3c}: "FrontPageDxe",
		efi.GUID{0x79, 0xa8, 0x49, 0x9f, 0x71, 0x3d, 0xb3, 0x42, 0xa0, 0xad, 0xdd, 0xb1, 0xf3, 0x30, 0x10, 0xa3}: "EfiSpiAcpiProtocolGuid",
		efi.GUID{0x79, 0xaf, 0xe1, 0x78, 0xc1, 0xa9, 0xf6, 0x44, 0xad, 0x49, 0x86, 0x22, 0xc1, 0x77, 0x6f, 0xae}: "OemDxeDetectBlueTooth",
		efi.GUID{0x79, 0xb5, 0x4d, 0xe9, 0x1b, 0x06, 0x7b, 0x43, 0x83, 0xc2, 0x65, 0xc0, 0xae, 0x7c, 0x14, 0xe2}: "LenovoAt24Rf08EepromDxe",
		efi.GUID{0x79, 0xbe, 0xe9, 0x57, 0x6e, 0xfa, 0x83, 0x4a, 0xa3, 0xea, 0xab, 0x2b, 0x66, 0x78, 0xe4, 0xca}: "ACPISxSMICore",
		efi.GUID{0x79, 0xc7, 0xcd, 0x58, 0x8c, 0xdc, 0x1b, 0x49, 0xba, 0xc3, 0xf8, 0x6e, 0x06, 0xd1, 0x86, 0x5f}: "DellGpeOrom",
		efi.GUID{0x79, 0xcd, 0x95, 0x30, 0x45, 0x5b, 0xdf, 0x49, 0xb2, 0x7f, 0xef, 0x43, 0x84, 0x3b, 0x84, 0x80}: "IrqBoardInfoSct",
		efi.GUID{0x79, 0xe4, 0x87, 0xd6, 0x37, 0xdb, 0xce, 0x4b, 0x86, 0x4a, 0x02, 0xee, 0xf6, 0x81, 0x9d, 0xf1}: "SystemFormBrowserSimpleTextViewDxe",
		efi.GUID{0x79, 0xe4, 0xba, 0x97, 0x73, 0xc4, 0x24, 0x44, 0x90, 0x40, 0x69, 0xf5, 0xbf, 0x9f, 0x74, 0xf8}: "OcrEntryCall",
		efi.GUID{0x79, 0xe9, 0xe8, 0xa9, 0x94, 0x4b, 0x50, 0x41, 0xb9, 0x49, 0x51, 0xd4, 0x5f, 0xe5, 0xea, 0x18}: "LEMDisableSecSMIFlashProtocol",
		efi.GUID{0x79, 0xeb, 0x20, 0xec, 0x1a, 0x6c, 0x64, 0x46, 0x9a, 0x0d, 0xd2, 0xe4, 0xcc, 0x16, 0xd6, 0x64}: "EfiTcp6ServiceBindingProtocolGuid",
		efi.GUID{0x79, 0xf9, 0xb7, 0x10, 0x1c, 0x74, 0x7e, 0x46, 0x87, 0x64, 0x8d, 0xd5, 0x0d, 0x8a, 0xd6, 0xc5}: "SdioInt13",
		efi.GUID{0x7a, 0x09, 0x97, 0x1e, 0x84, 0xc8, 0xe4, 0x4b, 0xa5, 0x30, 0x29, 0x9f, 0x85, 0xbd, 0xc8, 0x94}: "MediaSanitize",
		efi.GUID{0x7a, 0x09, 0xce, 0x79, 0xaa, 0x91, 0xff, 0x41, 0xb3, 0xa8, 0x53, 0x45, 0x59, 0xb3, 0x0d, 0xb1}: "PasswordHob",
		efi.GUID{0x7a, 0x1d, 0xaf, 0xb5, 0xcf, 0xb8, 0xb3, 0x4e, 0x89, 0x25, 0xa8, 0x20, 0xe1, 0x6b, 0x68, 0x7d}: "BootScriptDataBootTimeGuid",
		efi.GUID{0x7a, 0x20, 0xfa, 0xcf, 0xfd, 0xb1, 0x65, 0x42, 0xb0, 0xa1, 0x9a, 0xcd, 0x47, 0x75, 0x45, 0xc4}: "AcerGnvsDxe",
		efi.GUID{0x7a, 0x21, 0xf9, 0xe8, 0xad, 0x73, 0x23, 0x49, 0xff, 0xff, 0xff, 0xff, 0x1d, 0x27, 0x0e, 0x05}: "XnotePlatformPolicySmm",
		efi.GUID{0x7a, 0x24, 0x07, 0x55, 0x6b, 0x84, 0x22, 0x4f, 0xb5, 0x5f, 0x72, 0xb4, 0x04, 0x94, 0x35, 0xef}: "AmtLockKbd",
		efi.GUID{0x7a, 0x2e, 0x4a, 0x12, 0x49, 0x19, 0x3e, 0x48, 0x89, 0x9f, 0x60, 0x32, 0x90, 0x4c, 0xa0, 0xa7}: "SystemSmmAhciAspiLegacyRt",
		efi.GUID{0x7a, 0x33, 0x38, 0x23, 0xb0, 0x47, 0x41, 0x4c, 0x9c, 0xa7, 0x01, 0x60, 0xfb, 0x94, 0xdf, 0xf4}: "PlatformFlashDxe",
		efi.GUID{0x7a, 0x35, 0x72, 0x63, 0xd7, 0x06, 0xef, 0x43, 0xb5, 0x5c, 0x19, 0x64, 0xf3, 0xdd, 0x69, 0x16}: "DxeIpmiInitialize",
		efi.GUID{0x7a, 0x37, 0x5d, 0x74, 0x88, 0xb9, 0xb2, 0x47, 0xb1, 0x8f, 0xbb, 0xc8, 0x0d, 0xc5, 0x66, 0x98}: "EfiVirtualMemoryAccessProtocol",
		efi.GUID{0x7a, 0x3e, 0x6c, 0xbd, 0xa5, 0xec, 0x3a, 0x4c, 0xbd, 0x11, 0xc7, 0x05, 0xf9, 0xac, 0xef, 0x16}: "FileExplorer",
		efi.GUID{0x7a, 0x41, 0xe4, 0xee, 0x4e, 0xd3, 0xb1, 0x40, 0x94, 0x83, 0x1b, 0xf6, 0x2b, 0xd1, 0x13, 0xcc}: "SystemFirmwareDeviceDxeSmm",
		efi.GUID{0x7a, 0x45, 0xe9, 0x73, 0xa1, 0xce, 0x17, 0x49, 0x9a, 0x9c, 0x9f, 0x1f, 0x0f, 0x0f, 0xd3, 0x22}: "DebugPortDxe",
		efi.GUID{0x7a, 0x47, 0x82, 0x79, 0x85, 0xb2, 0xe8, 0x42, 0xb2, 0x2d, 0xa3, 0x0e, 0x7e, 0x3c, 0xfe, 0x26}: "Dispatcher",
		efi.GUID{0x7a, 0x47, 0xaf, 0x03, 0x36, 0x83, 0x42, 0x01, 0x8a, 0x65, 0xb4, 0xbd, 0x93, 0xb1, 0xa1, 0xa9}: "FirmwareExtension",
		efi.GUID{0x7a, 0x48, 0x1c, 0xda, 0x75, 0xc3, 0x18, 0x4d, 0xbd, 0x71, 0xe0, 0xfa, 0x9f, 0x89, 0x39, 0x98}: "EpsaReconnectUsbDriver",
		efi.GUID{0x7a, 0x48, 0x1f, 0xad, 0x56, 0xba, 0xdc, 0x48, 0x8e, 0xaa, 0xe8, 0xfb, 0xea, 0x74, 0xb8, 0xf2}: "ASM104X_SMI",
		efi.GUID{0x7a, 0x54, 0x7b, 0x03, 0xe8, 0x97, 0xf2, 0x4f, 0x8c, 0xd1, 0xdc, 0xb7, 0xa1, 0xb4, 0x91, 0x5a}: "SetupConfigUpdateDxeArcherCityModular",
		efi.GUID{0x7a, 0x54, 0xb6, 0xd6, 0x0e, 0x75, 0x3d, 0x4a, 0xb6, 0x1b, 0x87, 0x03, 0xd8, 0xfa, 0x32, 0x87}: "DellAuxMac",
		efi.GUID{0x7a, 0x55, 0x72, 0x36, 0xa7, 0x06, 0xef, 0x43, 0x60, 0xc3, 0x19, 0x64, 0xf3, 0xdd, 0x11, 0x98}: "SmcOutBand",
		efi.GUID{0x7a, 0x5c, 0x8a, 0x01, 0xeb, 0x12, 0x9d, 0x42, 0x9d, 0xef, 0x6f, 0xcc, 0x41, 0x0b, 0x04, 0xe8}: "IioCfgUpdateDxeLightningRidgeEXECB4",
		efi.GUID{0x7a, 0x63, 0x13, 0x7e, 0xf8, 0xc3, 0xd1, 0x43, 0xb0, 0x51, 0xed, 0x19, 0xd7, 0x08, 0xec, 0x7a}: "PeiIdeRecoveryNativeModePpi",
		efi.GUID{0x7a, 0x68, 0xc0, 0xa7, 0xb9, 0xe8, 0xec, 0x42, 0xb8, 0xa5, 0xa9, 0x50, 0xdf, 0x6e, 0xf9, 0x4a}: "AlternativeDefaultMemoryQuota",
		efi.GUID{0x7a, 0x6c, 0x1b, 0xd6, 0x3a, 0x65, 0xa9, 0x45, 0x8a, 0xf3, 0x63, 0xa8, 0xa5, 0x07, 0x66, 0x39}: "DellHddSmart",
		efi.GUID{0x7a, 0x6f, 0xa3, 0x2b, 0xe7, 0xf5, 0x35, 0x4d, 0x91, 0x49, 0x60, 0x89, 0x4c, 0xb3, 0x74, 0x31}: "Nfa765Launcher",
		efi.GUID{0x7a, 0x75, 0xba, 0xd0, 0x67, 0x6b, 0xa3, 0x4b, 0xb1, 0x38, 0x7a, 0x15, 0xdd, 0x8c, 0xb9, 0x4f}: "FjGabiSystemDataHandlerSmm",
		efi.GUID{0x7a, 0x78, 0x74, 0xbc, 0x99, 0xbe, 0x2f, 0x4a, 0x8c, 0x9c, 0xc6, 0xd7, 0xe5, 0xc7, 0x7a, 0xd3}: "BoardUpdatePolicySmm",
		efi.GUID{0x7a, 0x7a, 0x49, 0x6d, 0xda, 0xd7, 0x7c, 0x46, 0xb4, 0x85, 0xb7, 0xfb, 0x34, 0x93, 0xc4, 0x1f}: "DxePciSegementLibEsal",
		efi.GUID{0x7a, 0x7d, 0x96, 0x4f, 0x5f, 0xd5, 0x53, 0x4b, 0xbd, 0xd9, 0x26, 0x9a, 0x80, 0x78, 0x5d, 0x16}: "AdlSemaMiscellaneousDxe",
		efi.GUID{0x7a, 0x86, 0x39, 0x56, 0x8e, 0x8c, 0x8d, 0x40, 0xac, 0x2f, 0x4b, 0x61, 0xbd, 0xc0, 0xbb, 0xbb}: "EfiBluetoothAttributeServiceBindingProtocolGuid",
		efi.GUID{0x7a, 0x88, 0x51, 0xba, 0xb9, 0xbe, 0xda, 0x45, 0x8e, 0x37, 0x98, 0xa6, 0xb4, 0x6e, 0x7c, 0x58}: "IeHeciInit",
		efi.GUID{0x7a, 0x96, 0xce, 0x02, 0x7e, 0xdd, 0xfc, 0x4f, 0x9e, 0xe7, 0x81, 0x0c, 0xf0, 0x47, 0x08, 0x80}: "EfiEndOfDxeEventGroupGuid",
		efi.GUID{0x7a, 0x97, 0xd4, 0x5b, 0x0f, 0x58, 0x1a, 0x4f, 0xb3, 0xc2, 0x51, 0x98, 0xe6, 0xdc, 0xbe, 0xea}: "AmiCspGlobalNvsDxe",
		efi.GUID{0x7a, 0x9d, 0xef, 0xf4, 0xc5, 0x98, 0x1a, 0x4c, 0xb4, 0xd9, 0xd8, 0xd8, 0x72, 0x65, 0xbe, 0x0c}: "PeiSdhcPpiGuid",
		efi.GUID{0x7a, 0xaa, 0xae, 0xac, 0x39, 0xc0, 0x24, 0x44, 0x88, 0xda, 0xf4, 0x22, 0x12, 0xea, 0x0e, 0x55}: "PchPcieSmm",
		efi.GUID{0x7a, 0xb1, 0xd7, 0x36, 0x4c, 0x9d, 0x62, 0x4b, 0x8d, 0x3b, 0xd4, 0xb6, 0x57, 0xf7, 0xc1, 0xa6}: "OemInitBrightness",
		efi.GUID{0x7a, 0xb3, 0x4b, 0xb7, 0xa2, 0xec, 0x79, 0x4f, 0xa5, 0x44, 0x90, 0x56, 0x9a, 0xbe, 0x6b, 0x99}: "LenovoSystemSmmCommunicationSmm",
		efi.GUID{0x7a, 0xc0, 0x73, 0x54, 0xcb, 0x3d, 0xca, 0x4d, 0xbd, 0x6f, 0x1e, 0x96, 0x89, 0xe7, 0x34, 0x9a}: "EfiFirmwareFileSystem3Guid",
		efi.GUID{0x7a, 0xc7, 0x7e, 0x0f, 0xe1, 0x1e, 0x0f, 0x40, 0xa9, 0x9d, 0x7c, 0xbd, 0x1f, 0xeb, 0x18, 0x1e}: "PcatPciRootBridge",
		efi.GUID{0x7a, 0xde, 0x88, 0xf7, 0x18, 0xab, 0x86, 0x48, 0xbd, 0x3e, 0x79, 0xed, 0x97, 0x86, 0xf1, 0xa5}: "AmdMemPprSmmDriverSsp",
		efi.GUID{0x7a, 0xe0, 0x25, 0xba, 0x53, 0xe2, 0x2c, 0x44, 0x90, 0xff, 0xb4, 0xc9, 0x2f, 0xad, 0x69, 0x90}: "UsbMassStoragePei",
		efi.GUID{0x7a, 0xe2, 0xb2, 0x02, 0xb5, 0xe8, 0x42, 0x4a, 0x82, 0xc3, 0x55, 0xb4, 0x32, 0x22, 0xeb, 0x9b}: "HpGFIStrsSubComp",
		efi.GUID{0x7a, 0xeb, 0x90, 0xfc, 0x0a, 0x3e, 0x3c, 0x48, 0xa2, 0x6c, 0x48, 0x4d, 0x36, 0x59, 0x3f, 0xf4}: "AcpiPlatform",
		efi.GUID{0x7a, 0xee, 0xf7, 0xc1, 0x23, 0x4d, 0x87, 0x42, 0x97, 0xbb, 0xc0, 0xfd, 0x26, 0x5d, 0x09, 0xbf}: "OpromUpdateDxeEldorado",
		efi.GUID{0x7a, 0xf3, 0xb4, 0x2c, 0x26, 0x00, 0xaf, 0x43, 0xa9, 0x48, 0xd7, 0x19, 0x76, 0xa9, 0x68, 0x60}: "CpuIoDxe",
		efi.GUID{0x7a, 0xfc, 0x23, 0xe5, 0xf9, 0x3d, 0x46, 0x48, 0xa8, 0x01, 0xd8, 0xcc, 0x1b, 0xe2, 0x91, 0x48}: "PxeDriver",
		efi.GUID{0x7a, 0xfc, 0xfb, 0xde, 0x02, 0xcc, 0x25, 0x42, 0x88, 0xad, 0x3c, 0x41, 0xe6, 0x21, 0x78, 0x5b}: "DellIdeDxe",
		efi.GUID{0x7a, 0xff, 0xdd, 0xb7, 0x26, 0x17, 0xe6, 0x11, 0xb1, 0x2f, 0xb8, 0xe8, 0x56, 0x2c, 0xba, 0xfa}: "WiFiPlatformDxe",
		efi.GUID{0x7b, 0x01, 0x8c, 0x82, 0x8e, 0xba, 0xe6, 0x40, 0xbd, 0xa4, 0x45, 0xb6, 0xf9, 0xf6, 0xa8, 0xcd}: "AmdNbioIOMMUDxe",
		efi.GUID{0x7b, 0x07, 0x0a, 0x91, 0x23, 0x4b, 0xff, 0x40, 0x8d, 0xcd, 0x64, 0x68, 0x53, 0x49, 0x31, 0x0c}: "SoftSkuStatus",
		efi.GUID{0x7b, 0x12, 0x4f, 0xed, 0xb0, 0x45, 0x44, 0x4b, 0x88, 0xe9, 0x0d, 0x7e, 0xf1, 0xbe, 0x98, 0xa0}: "FjSysmanYggdrasilSmmPowerOnTime",
		efi.GUID{0x7b, 0x16, 0x67, 0x19, 0x3d, 0xa1, 0x45, 0x4e, 0x80, 0x1b, 0xa6, 0x05, 0xd1, 0x19, 0x46, 0xd5}: "AmiTseOemPortingVar15",
		efi.GUID{0x7b, 0x1c, 0x34, 0x2b, 0x32, 0x0b, 0x65, 0x4a, 0x9d, 0x46, 0xe1, 0xb3, 0xab, 0xd4, 0xc2, 0x5c}: "Smbios131",
		efi.GUID{0x7b, 0x1f, 0xaf, 0xe6, 0x3f, 0xfc, 0xda, 0x46, 0xa8, 0x28, 0xa3, 0xb4, 0x57, 0xa4, 0x42, 0x82}: "EfiPeiCpuIoPpiInstalledGuid",
		efi.GUID{0x7b, 0x27, 0x69, 0x60, 0x6b, 0x24, 0xd5, 0x45, 0xbd, 0x6d, 0x81, 0x82, 0x0e, 0x10, 0xc1, 0x1f}: "CommonSmiCallBackSmm",
		efi.GUID{0x7b, 0x3c, 0x4b, 0x1d, 0x01, 0x7d, 0xff, 0x4c, 0xaf, 0x3a, 0x0d, 0xaf, 0xb5, 0x3f, 0x63, 0x21}: "FjGabiSystemDataLogoAbstraction",
		efi.GUID{0x7b, 0x3c, 0x4b, 0x1d, 0x01, 0x7d, 0xff, 0x4c, 0xaf, 0x3a, 0x0d, 0xaf, 0xb5, 0x3f, 0x63, 0x22}: "FjGabiSystemDataLogoAbstractionFTS",
		efi.GUID{0x7b, 0x3c, 0x73, 0xbe, 0xd9, 0x07, 0x01, 0x44, 0xa0, 0x8e, 0xf4, 0x75, 0xb0, 0xfa, 0x11, 0xed}: "SystemPowerOnEvent",
		efi.GUID{0x7b, 0x3f, 0x2e, 0x7c, 0x7a, 0xa1, 0x70, 0x40, 0xae, 0x83, 0x13, 0xff, 0x41, 0x6f, 0x62, 0xb2}: "MsiBoardNvs",
		efi.GUID{0x7b, 0x46, 0x17, 0xd6, 0xf7, 0x1f, 0x3f, 0x40, 0xa8, 0x7d, 0x29, 0xf6, 0x1c, 0x80, 0xee, 0x7c}: "AmdCpmOemInitPeim",
		efi.GUID{0x7b, 0x66, 0xc9, 0xf3, 0x0c, 0xc5, 0x9c, 0x4e, 0xa1, 0xf1, 0x78, 0xc3, 0xb1, 0xdd, 0xf2, 0xc2}: "LibNetUtil",
		efi.GUID{0x7b, 0x69, 0x6e, 0xf5, 0xf8, 0x3e, 0x1d, 0x47, 0x3e, 0xf8, 0x6b, 0x66, 0x36, 0xa6, 0xf2, 0xf8}: "InstallWsmtDxe",
		efi.GUID{0x7b, 0x6a, 0xf4, 0x1e, 0x4d, 0x5f, 0x67, 0x49, 0xb3, 0xc4, 0xa3, 0x08, 0xd8, 0x98, 0xea, 0xdd}: "AsusCalibrationDxeEntry",
		efi.GUID{0x7b, 0x72, 0x97, 0x3f, 0x18, 0x5e, 0x4f, 0x4c, 0xbc, 0x65, 0x9c, 0xb8, 0xdf, 0xe1, 0x80, 0x2f}: "FjGabiSystemDataCmosAbstraction",
		efi.GUID{0x7b, 0x7a, 0xbf, 0xda, 0xfe, 0xb5, 0x18, 0x4a, 0x84, 0x5d, 0xf2, 0x41, 0xd8, 0x58, 0x27, 0x94}: "UndiFirmwareVersionDxe",
		efi.GUID{0x7b, 0x85, 0xd3, 0x6c, 0x86, 0x1a, 0x34, 0x47, 0x81, 0x4d, 0x83, 0x02, 0xe5, 0x14, 0xae, 0x79}: "AthQCA6174Undi",
		efi.GUID{0x7b, 0x90, 0x00, 0x52, 0xff, 0x59, 0xe7, 0x49, 0x9a, 0xf9, 0xee, 0x2d, 0xfa, 0x83, 0x62, 0x4f}: "DellStatusServicePeiInit",
		efi.GUID{0x7b, 0x91, 0xa8, 0x71, 0x91, 0x08, 0x27, 0x4e, 0x8a, 0x73, 0xa9, 0xb3, 0x34, 0x84, 0x03, 0x93}: "AmiPeiBeforeMrcGuid",
		efi.GUID{0x7b, 0x91, 0xf4, 0x27, 0x07, 0xa7, 0xad, 0x4a, 0x96, 0x76, 0x26, 0xdf, 0x16, 0x8c, 0xbf, 0x0d}: "PchSpiSmm",
		efi.GUID{0x7b, 0x97, 0xec, 0x6c, 0x2e, 0x14, 0xba, 0x4e, 0xac, 0xbb, 0x74, 0xd8, 0x82, 0xb1, 0x66, 0xca}: "OemCustomDefaults",
		efi.GUID{0x7b, 0x99, 0x17, 0x27, 0xac, 0xab, 0x33, 0x47, 0xad, 0xaf, 0x9c, 0x19, 0xd8, 0xfb, 0xb7, 0xa1}: "CbmrDriver",
		efi.GUID{0x7b, 0x9c, 0x10, 0x0e, 0x90, 0x87, 0x9d, 0x4b, 0x98, 0x1c, 0x9d, 0x4b, 0x07, 0x9e, 0x98, 0xd4}: "MsiSGSmm",
		efi.GUID{0x7b, 0x9d, 0xe2, 0xba, 0xbb, 0x89, 0x23, 0x42, 0xaf, 0x76, 0x96, 0xd0, 0xb3, 0x24, 0x9b, 0x36}: "SsaBiosServicesPpi",
		efi.GUID{0x7b, 0xa3, 0x92, 0xdc, 0xc5, 0x4a, 0x17, 0x41, 0xaa, 0xbb, 0x01, 0x9f, 0xfc, 0x0f, 0xd0, 0x6a}: "FpkSetup",
		efi.GUID{0x7b, 0xa7, 0x73, 0xed, 0xb0, 0x8a, 0x72, 0x42, 0xb7, 0xb8, 0xe2, 0x53, 0x11, 0x36, 0x6f, 0xbf}: "AddrDecode",
		efi.GUID{0x7b, 0xa8, 0xd7, 0x3d, 0xbd, 0xd5, 0xaf, 0x44, 0x98, 0x6f, 0x2e, 0x13, 0xdb, 0x5d, 0x27, 0x4c}: "SnpDxe",
		efi.GUID{0x7b, 0xab, 0xbc, 0xcf, 0x0d, 0x05, 0x4f, 0x49, 0xa8, 0x41, 0x51, 0xbe, 0xeb, 0x73, 0x40, 0x6e}: "USBControllerDxe",
		efi.GUID{0x7b, 0xba, 0x04, 0x15, 0xf8, 0x58, 0x12, 0x4d, 0x96, 0x38, 0xb4, 0x94, 0xa7, 0x04, 0x43, 0x76}: "LenovoSystemSmmServicesSmm",
		efi.GUID{0x7b, 0xba, 0x8d, 0xe1, 0x76, 0xab, 0xff, 0x43, 0x8c, 0x27, 0x50, 0xee, 0x33, 0x73, 0x48, 0x1d}: "CxlEndpointDriver",
		efi.GUID{0x7b, 0xca, 0x40, 0x91, 0xbd, 0xca, 0x09, 0x4a, 0x88, 0xf7, 0x08, 0x62, 0x04, 0x3c, 0xc2, 0x86}: "DellSmstTransfer",
		efi.GUID{0x7b, 0xca, 0x55, 0x77, 0x8f, 0xca, 0xc5, 0x43, 0x88, 0x9b, 0xe1, 0xf5, 0x9a, 0x93, 0xd5, 0x75}: "IntelGopDriver",
		efi.GUID{0x7b, 0xd1, 0xb3, 0xaf, 0x30, 0xa3, 0x60, 0x48, 0x9b, 0xeb, 0xe3, 0xc7, 0xd1, 0xd4, 0x9c, 0x50}: "FjSecureServicesSmm",
		efi.GUID{0x7b, 0xd3, 0x01, 0x51, 0x13, 0xcd, 0x3c, 0x49, 0xbd, 0x7c, 0x40, 0xa3, 0xe4, 0x5f, 0xc1, 0x9b}: "UfsPciHcDxe",
		efi.GUID{0x7b, 0xe0, 0x8c, 0x64, 0x5d, 0xae, 0x73, 0x49, 0xbd, 0x3c, 0x8c, 0x91, 0x53, 0xc0, 0x5d, 0xc5}: "SgInfoHob",
		efi.GUID{0x7b, 0xe6, 0xf3, 0xba, 0x75, 0xb1, 0xf6, 0x49, 0x84, 0xff, 0x75, 0xc3, 0x54, 0x43, 0x9c, 0xfd}: "FirmwareUpdate",
		efi.GUID{0x7b, 0xea, 0xe2, 0xaa, 0x52, 0xe0, 0x71, 0x43, 0x8e, 0x4b, 0xff, 0x0e, 0x52, 0xd8, 0x0f, 0x66}: "AdlinkSetupItemMod",
		efi.GUID{0x7b, 0xec, 0x77, 0xd1, 0x53, 0x53, 0x18, 0x4e, 0xa0, 0x44, 0x63, 0x60, 0xac, 0x6d, 0x46, 0x7d}: "AmdPlatformCustomizeSmm",
		efi.GUID{0x7b, 0xee, 0x31, 0xee, 0xb8, 0x07, 0xc5, 0x48, 0x8f, 0x3f, 0xc4, 0x2a, 0x70, 0x0e, 0x04, 0x32}: "AAEONCH7511Pei",
		efi.GUID{0x7b, 0xef, 0x07, 0x61, 0x84, 0xd3, 0x24, 0x4a, 0xbc, 0x9b, 0x5f, 0xef, 0x73, 0x1f, 0x6a, 0x5b}: "IsaUartDxe",
		efi.GUID{0x7b, 0xfa, 0x22, 0x51, 0xa3, 0x17, 0x8b, 0x4a, 0x89, 0xae, 0xa9, 0x3a, 0xde, 0x92, 0xea, 0xdf}: "DigitalThermalSensor",
		efi.GUID{0x7c, 0x03, 0xd6, 0x99, 0x17, 0xd3, 0xf0, 0x4a, 0xb0, 0xd2, 0x39, 0x59, 0x53, 0x0e, 0x6b, 0x16}: "CollectPOSTFlag",
		efi.GUID{0x7c, 0x04, 0x67, 0x2e, 0x47, 0x76, 0xf8, 0x40, 0x88, 0x6c, 0x5c, 0x33, 0x3c, 0x73, 0x27, 0x2f}: "InitSerialPortPei",
		efi.GUID{0x7c, 0x16, 0xfc, 0x45, 0x1b, 0x8b, 0xf8, 0x49, 0xa3, 0xff, 0x9f, 0xe5, 0x42, 0x41, 0xc9, 0x69}: "RfIScsiBoot",
		efi.GUID{0x7c, 0x1c, 0x82, 0x4f, 0x33, 0x8e, 0x2a, 0x41, 0xae, 0x63, 0xd1, 0x49, 0xf3, 0x76, 0xcd, 0x1b}: "SmmWheaDxe",
		efi.GUID{0x7c, 0x1d, 0x7a, 0xe5, 0x6a, 0xd1, 0x75, 0x49, 0xaf, 0x5b, 0x00, 0xeb, 0xac, 0x08, 0x9f, 0xc6}: "StartupMenuTimeout",
		efi.GUID{0x7c, 0x1d, 0xe8, 0x58, 0x7f, 0x4d, 0x6f, 0x4c, 0xaa, 0xe6, 0x32, 0xa9, 0x9f, 0x25, 0xfd, 0x17}: "DellPsidDxe",
		efi.GUID{0x7c, 0x1e, 0x9f, 0xae, 0xc9, 0x80, 0x23, 0x4a, 0x91, 0x7f, 0x74, 0x50, 0xba, 0x57, 0x8e, 0x0f}: "TheftRecoverySmm",
		efi.GUID{0x7c, 0x1f, 0x37, 0xde, 0xc4, 0xde, 0x21, 0x4d, 0xad, 0xf1, 0x59, 0x3a, 0xbc, 0xc1, 0x58, 0x82}: "ArmGicDxe",
		efi.GUID{0x7c, 0x29, 0x75, 0xb6, 0x03, 0x42, 0xe5, 0x48, 0xaf, 0x9f, 0xb5, 0x00, 0xc7, 0xc4, 0x7b, 0xac}: "UsbTypeCChargingSmm",
		efi.GUID{0x7c, 0x2e, 0xe7, 0x2e, 0x9e, 0xfb, 0x18, 0x43, 0xb8, 0x88, 0x33, 0xa3, 0x15, 0xc7, 0xa9, 0x1d}: "PpmPolicy",
		efi.GUID{0x7c, 0x34, 0xb9, 0xca, 0xe9, 0x8c, 0xe1, 0x4d, 0x9c, 0x6f, 0x64, 0x57, 0xac, 0x69, 0x33, 0x2b}: "PrepareForScheckEvent",
		efi.GUID{0x7c, 0x3d, 0x85, 0x15, 0xdf, 0x3d, 0xe0, 0x43, 0xa1, 0xcb, 0xeb, 0xf8, 0x5b, 0x8f, 0x87, 0x2c}: "EfiDeferredImageLoadProtocolGuid",
		efi.GUID{0x7c, 0x4b, 0x1e, 0x3b, 0xd8, 0x09, 0x4f, 0x94, 0xa4, 0x08, 0x13, 0x09, 0xeb, 0x8b, 0x44, 0x27}: "EmuThreadThunkProtocolGuid",
		efi.GUID{0x7c, 0x4f, 0xb0, 0xd2, 0x9b, 0x69, 0x9a, 0x4f, 0x91, 0xf3, 0x04, 0x07, 0x8b, 0x95, 0x63, 0xcb}: "BootOrderData",
		efi.GUID{0x7c, 0x51, 0x4f, 0x4b, 0x45, 0x01, 0x83, 0x47, 0xa1, 0xd7, 0x01, 0x8d, 0x20, 0x79, 0x75, 0x55}: "PciHsUartDxe",
		efi.GUID{0x7c, 0x53, 0x9d, 0xca, 0x20, 0x0b, 0x94, 0x4f, 0x92, 0x83, 0x45, 0xf4, 0xd5, 0x1a, 0x74, 0x8d}: "DellAsfBypassAbstraction",
		efi.GUID{0x7c, 0x54, 0x49, 0xd0, 0x27, 0x82, 0xd2, 0x44, 0x8a, 0x5e, 0x02, 0x88, 0x8d, 0xe9, 0x30, 0xd1}: "ClearPasswordReq",
		efi.GUID{0x7c, 0x56, 0xc1, 0x7c, 0xb8, 0xcc, 0x50, 0x4c, 0x80, 0xba, 0xd4, 0x4a, 0x3b, 0x66, 0x74, 0x15}: "AmdSb800_PeiInterfacePei",
		efi.GUID{0x7c, 0x61, 0x63, 0x86, 0x3a, 0xca, 0x25, 0x4b, 0xb6, 0x3e, 0x6f, 0xfb, 0x38, 0x94, 0xd6, 0x5a}: "SioSmiSwDispatcher",
		efi.GUID{0x7c, 0x65, 0xb8, 0xae, 0xbf, 0xae, 0xa1, 0x40, 0x98, 0x66, 0xbb, 0x22, 0xc7, 0x22, 0x3f, 0xf0}: "Sha1AndRsaDxe",
		efi.GUID{0x7c, 0x66, 0xbe, 0x75, 0xe1, 0x48, 0x2d, 0x45, 0xb0, 0xfc, 0x36, 0x31, 0x38, 0xed, 0x87, 0xff}: "PStateControl",
		efi.GUID{0x7c, 0x66, 0xc1, 0x7c, 0xb8, 0xcc, 0x50, 0x4c, 0x80, 0xba, 0xd4, 0x4a, 0x3b, 0x66, 0x74, 0x15}: "SbInterfacePei",
		efi.GUID{0x7c, 0x70, 0x1a, 0xa1, 0x9a, 0xeb, 0x0f, 0x45, 0x8c, 0xb6, 0x92, 0x84, 0xb5, 0x6a, 0x9f, 0x80}: "FjGabiEntrySmiDispatcherSmm",
		efi.GUID{0x7c, 0x74, 0x38, 0xd0, 0x0c, 0xd0, 0x80, 0x49, 0xb3, 0x19, 0x49, 0x01, 0x99, 0xa4, 0x7d, 0x55}: "FspReservedMemoryResourceHobTsegGuid",
		efi.GUID{0x7c, 0x75, 0xd5, 0x99, 0x06, 0xd9, 0xe0, 0x11, 0x8d, 0x78, 0x8d, 0xe4, 0x48, 0x24, 0x01, 0x9b}: "PchEfiRaidDriverExecution",
		efi.GUID{0x7c, 0x78, 0xb5, 0x67, 0x6a, 0x0e, 0x96, 0x47, 0x94, 0x3e, 0xa0, 0x93, 0xb7, 0x3a, 0x02, 0x67}: "HiiUtilitiesProtocol",
		efi.GUID{0x7c, 0x7a, 0x4d, 0x3a, 0x8a, 0x01, 0x42, 0x4b, 0x81, 0xb3, 0xdc, 0x10, 0xe3, 0xb5, 0x91, 0xbd}: "UsbKeyboardLayoutKeyGuid",
		efi.GUID{0x7c, 0x84, 0xfa, 0xeb, 0x3b, 0x52, 0xf4, 0x46, 0xbb, 0x7d, 0xc5, 0x1e, 0xff, 0xd1, 0x99, 0x4c}: "FjMrcOutputInterfaceGeminilake",
		efi.GUID{0x7c, 0x8c, 0xbd, 0x3e, 0x3b, 0x73, 0x67, 0x46, 0x8f, 0xd1, 0x4a, 0xbe, 0xa3, 0x66, 0xc9, 0x5b}: "ASUSDirectKeyPEI",
		efi.GUID{0x7c, 0x8d, 0x58, 0x6b, 0x2e, 0xc7, 0x78, 0x4a, 0x88, 0x58, 0x77, 0xe1, 0xda, 0x8f, 0xc7, 0xf7}: "ProjectOwnProtocol",
		efi.GUID{0x7c, 0x8f, 0xd2, 0x1f, 0xfe, 0x8c, 0xc4, 0x46, 0xae, 0x0f, 0x0c, 0xeb, 0xa3, 0x7f, 0xf2, 0x8b}: "SystemSignaturesDxe",
		efi.GUID{0x7c, 0x98, 0x71, 0x2e, 0x27, 0x42, 0x51, 0x1e, 0x40, 0xe3, 0x8a, 0x82, 0x4d, 0xe9, 0x51, 0x1b}: "PlatformSioHwSmi",
		efi.GUID{0x7c, 0x98, 0xe6, 0xfe, 0xf3, 0x9f, 0x71, 0x49, 0xab, 0xc1, 0x23, 0x69, 0x7c, 0xb6, 0xac, 0xed}: "A01ModifyBootInfoDxe",
		efi.GUID{0x7c, 0x9a, 0xc9, 0x4a, 0xcf, 0x1d, 0x51, 0x4a, 0x8f, 0x06, 0x5e, 0xed, 0xfe, 0x8a, 0x88, 0x64}: "CryptoServiceRuntimeDxe",
		efi.GUID{0x7c, 0x9b, 0x0d, 0xa3, 0xd3, 0xde, 0xd6, 0x48, 0x83, 0xa6, 0x3f, 0xf4, 0x34, 0x44, 0xc3, 0x7a}: "AppleDxeManufacturingFixture",
		efi.GUID{0x7c, 0xad, 0xec, 0x25, 0x93, 0x2c, 0xb8, 0x35, 0x2e, 0x54, 0xc7, 0x1a, 0x4c, 0x02, 0xd3, 0xd1}: "QualCommSupplicantDxe",
		efi.GUID{0x7c, 0xad, 0xec, 0x45, 0x93, 0x8c, 0xb8, 0x25, 0x5e, 0x53, 0x17, 0x1a, 0x4c, 0x02, 0xd3, 0xab}: "WCN6855",
		efi.GUID{0x7c, 0xb8, 0x9c, 0xb0, 0xd8, 0x67, 0x2b, 0x41, 0xbb, 0x9d, 0x9f, 0x4b, 0x21, 0x4d, 0x72, 0x0a}: "VTd",
		efi.GUID{0x7c, 0xb9, 0x05, 0xba, 0xbf, 0x8e, 0xb7, 0x48, 0x85, 0x8d, 0x4b, 0x0a, 0xfb, 0xf0, 0xd7, 0xda}: "BiosGuardRecoveryWorker",
		efi.GUID{0x7c, 0xc1, 0x4f, 0xb9, 0x9c, 0x57, 0xb3, 0x4a, 0xba, 0x28, 0x67, 0x8d, 0x18, 0x13, 0xd1, 0xd6}: "DellBiosConnectNetwork",
		efi.GUID{0x7c, 0xc5, 0x53, 0xd7, 0xd0, 0x87, 0x36, 0x46, 0x87, 0x6a, 0x5e, 0xe0, 0xe7, 0x3a, 0x66, 0x89}: "PlatformMilestoneHookDxe",
		efi.GUID{0x7c, 0xc5, 0x53, 0xd7, 0xd0, 0x87, 0x36, 0x46, 0x87, 0x6a, 0x5e, 0xe0, 0xe7, 0x3a, 0x66, 0x8a}: "BoardMilestoneHookDxe",
		efi.GUID{0x7c, 0xcf, 0xa6, 0xd3, 0x13, 0x2a, 0xcd, 0x4d, 0x96, 0x1f, 0xb8, 0x8c, 0x85, 0xac, 0xeb, 0x34}: "AmdCcxZenRvPei",
		efi.GUID{0x7c, 0xd3, 0x43, 0xbf, 0x71, 0x70, 0x4e, 0x41, 0xb3, 0xeb, 0x3c, 0x98, 0xd0, 0x8a, 0xa3, 0x2e}: "EcInit",
		efi.GUID{0x7c, 0xd3, 0x43, 0xbf, 0x78, 0x70, 0x4e, 0x41, 0xb3, 0xeb, 0x3c, 0x98, 0xd0, 0x8a, 0xa3, 0x2e}: "FjSysmanSmcsUpdater",
		efi.GUID{0x7c, 0xd3, 0xdc, 0xd4, 0xa3, 0x90, 0x6e, 0x40, 0xb1, 0x93, 0x32, 0x3c, 0x6a, 0xac, 0x24, 0x28}: "ASUSBackup",
		efi.GUID{0x7c, 0xd4, 0x13, 0xbf, 0x71, 0x76, 0x4e, 0x41, 0xb3, 0xeb, 0x17, 0x84, 0x07, 0x3e, 0xc5, 0xfe}: "EcInit",
		efi.GUID{0x7c, 0xd5, 0xa3, 0xb2, 0x71, 0x70, 0x4e, 0x01, 0xb3, 0xeb, 0x3c, 0x98, 0xd0, 0x9c, 0xb3, 0x2e}: "IntrusionDetect",
		efi.GUID{0x7c, 0xde, 0x7b, 0x0f, 0xf3, 0xaa, 0xd0, 0x48, 0x93, 0x1f, 0x47, 0x57, 0x50, 0xdd, 0xe2, 0x09}: "OemPei",
		efi.GUID{0x7c, 0xde, 0x7b, 0x0f, 0xf3, 0xaa, 0xd0, 0x48, 0x93, 0x1f, 0x47, 0x57, 0x50, 0xdd, 0xe2, 0x10}: "OemWwanPei",
		efi.GUID{0x7c, 0xe0, 0x46, 0x95, 0xbb, 0x2c, 0x88, 0x4c, 0x98, 0x6c, 0xcd, 0x34, 0x10, 0x86, 0xf0, 0x44}: "EfiDebugSupportPeriodicCallbackProtocolGuid",
		efi.GUID{0x7c, 0xe4, 0x06, 0x7d, 0x2c, 0xb3, 0x6f, 0x49, 0x94, 0x0e, 0xf3, 0x0c, 0xde, 0x0b, 0x7c, 0xe5}: "SystemFirmwareDeviceBlockSmm",
		efi.GUID{0x7c, 0xe5, 0x33, 0xe6, 0xb1, 0xbb, 0x6a, 0x4c, 0x9f, 0x45, 0x22, 0xc4, 0x93, 0x78, 0xad, 0xd0}: "BootScriptThunkHelper",
		efi.GUID{0x7c, 0xea, 0x45, 0x32, 0x09, 0x92, 0xe7, 0x41, 0xbe, 0x2c, 0xeb, 0x66, 0x2b, 0x8c, 0x06, 0x22}: "FspFirmwareVersionPeim",
		efi.GUID{0x7c, 0xed, 0xf8, 0xeb, 0xd1, 0x0d, 0x87, 0x47, 0x84, 0xf1, 0xf4, 0x8d, 0x53, 0x7d, 0xca, 0xcf}: "DriverHealthManagerDxe",
		efi.GUID{0x7c, 0xf1, 0xcf, 0x1d, 0x53, 0xaa, 0x78, 0x4b, 0xb2, 0x34, 0x86, 0x40, 0x27, 0x55, 0x50, 0x35}: "LibUefi",
		efi.GUID{0x7c, 0xf4, 0x38, 0xf2, 0xe9, 0x1d, 0x8b, 0x4e, 0x81, 0xb9, 0xcc, 0x92, 0x4e, 0x6b, 0x5b, 0xe5}: "EfiPcmciaRequestProtocol",
		efi.GUID{0x7c, 0xfa, 0x90, 0x5e, 0x13, 0x9f, 0x4a, 0x4c, 0x96, 0xa7, 0xc1, 0x15, 0xff, 0x56, 0x87, 0x98}: "LenovoVariableStorePei",
		efi.GUID{0x7c, 0xfd, 0x26, 0xb3, 0x82, 0xf9, 0x0a, 0x41, 0x96, 0xc6, 0x1c, 0x1e, 0x49, 0x9e, 0x15, 0x59}: "WyseThinClientDxe",
		efi.GUID{0x7d, 0x14, 0x34, 0xa0, 0x0c, 0x69, 0x54, 0x41, 0x8d, 0xe6, 0xc0, 0x44, 0x64, 0x1d, 0xe9, 0x42}: "FspVariableNvDataHobGuid",
		efi.GUID{0x7d, 0x1c, 0x65, 0xad, 0x22, 0x3c, 0xbf, 0x4d, 0x92, 0xe8, 0x38, 0xa7, 0xcd, 0xae, 0x87, 0xb2}: "VirtualUncachedPagesProtocolGuid",
		efi.GUID{0x7d, 0x1e, 0xc3, 0x84, 0x03, 0x37, 0xd3, 0x42, 0xb4, 0x3b, 0x1f, 0xee, 0x41, 0x66, 0x6d, 0x9a}: "SystemFormBrowserMetroViewLayoutDxe",
		efi.GUID{0x7d, 0x26, 0x3d, 0xad, 0xe1, 0x50, 0x94, 0x4b, 0x95, 0xd3, 0x10, 0x25, 0xef, 0x5b, 0x83, 0x91}: "SecFlashUpdDXE",
		efi.GUID{0x7d, 0x40, 0xfb, 0x84, 0x76, 0xd0, 0xdd, 0x4d, 0x87, 0x1f, 0x33, 0x37, 0x3a, 0x26, 0xba, 0xbb}: "FchPromontorySsdt",
		efi.GUID{0x7d, 0x40, 0xfb, 0x84, 0x86, 0xd0, 0xdd, 0x4d, 0x82, 0x2f, 0x33, 0x37, 0x3a, 0x26, 0xba, 0xcc}: "FchTaishanSsdt",
		efi.GUID{0x7d, 0x49, 0x8a, 0x62, 0xf6, 0x2b, 0x64, 0x42, 0x87, 0x41, 0x06, 0x9d, 0xbd, 0x33, 0x99, 0xd6}: "ConSplitter",
		efi.GUID{0x7d, 0x4e, 0xea, 0x1a, 0xf8, 0xd6, 0x1e, 0x49, 0xbb, 0x5c, 0x4b, 0xec, 0x10, 0xc9, 0x8c, 0x99}: "FchSmmDispatcher",
		efi.GUID{0x7d, 0x56, 0x14, 0x86, 0xbe, 0x35, 0x15, 0x44, 0x8d, 0x88, 0xbd, 0x7d, 0x0c, 0x9c, 0x70, 0xc0}: "PlatformOverridesManagerGuid",
		efi.GUID{0x7d, 0x5d, 0xc5, 0x9c, 0xff, 0xfb, 0x1c, 0x43, 0xbc, 0x14, 0x33, 0x4e, 0xae, 0xa6, 0x05, 0x2b}: "SmmCoreDispatcherDxe",
		efi.GUID{0x7d, 0x64, 0xf9, 0x3a, 0x6b, 0xc4, 0xe4, 0x11, 0xaa, 0x1d, 0xb8, 0xe8, 0x56, 0x2c, 0xba, 0xfa}: "ChunkManager",
		efi.GUID{0x7d, 0x72, 0x3a, 0x6d, 0xc8, 0x66, 0x19, 0x4d, 0x87, 0xe6, 0x02, 0x15, 0x86, 0x14, 0x90, 0xf3}: "EfiUnixSerialPort",
		efi.GUID{0x7d, 0x76, 0xcb, 0x43, 0x2c, 0x32, 0x85, 0x42, 0xb2, 0xfa, 0xe9, 0x52, 0xbf, 0x2d, 0xd9, 0x4c}: "AmdCpmSoundWireDxe",
		efi.GUID{0x7d, 0x98, 0x5c, 0x3c, 0x96, 0x79, 0x15, 0x44, 0x8b, 0x16, 0x9f, 0x4a, 0x8a, 0xd3, 0x6f, 0xdd}: "Int10ToSmiDxe",
		efi.GUID{0x7d, 0xa4, 0xad, 0x6d, 0x5a, 0x64, 0x28, 0x41, 0xb2, 0x92, 0x57, 0xa4, 0x75, 0xe1, 0x45, 0x6a}: "AppleSecureBootDxe",
		efi.GUID{0x7d, 0xa6, 0x6b, 0xa4, 0x69, 0xb1, 0x04, 0x4e, 0x9a, 0xac, 0x18, 0x45, 0xcb, 0xde, 0xe0, 0xaa}: "AcpiMetronomeDxe",
		efi.GUID{0x7d, 0xc1, 0x43, 0x41, 0xbc, 0x54, 0x03, 0x49, 0x99, 0x58, 0x24, 0x54, 0x21, 0x6b, 0xb2, 0x1e}: "LpcPlatform",
		efi.GUID{0x7d, 0xca, 0x2c, 0x16, 0x17, 0xdb, 0xd4, 0x4c, 0x99, 0xc4, 0x15, 0xf1, 0x62, 0x82, 0x20, 0x6e}: "GoodixTouchpadUpdate",
		efi.GUID{0x7d, 0xd0, 0xc4, 0x11, 0x4f, 0xb4, 0x30, 0x46, 0xbc, 0xd8, 0xef, 0xf7, 0x86, 0xe2, 0x4a, 0x74}: "CypressCCGxSmm",
		efi.GUID{0x7d, 0xd8, 0xe2, 0xca, 0xbc, 0x5c, 0xe7, 0x47, 0x8c, 0xad, 0x50, 0x37, 0x7a, 0x5d, 0x0e, 0x90}: "PlatformErrorStrings",
		efi.GUID{0x7d, 0xdd, 0x9e, 0x24, 0x6d, 0x34, 0x90, 0x4c, 0xb9, 0x4f, 0x16, 0x07, 0x9e, 0xf0, 0x61, 0xd5}: "AmdCpuPolicy",
		efi.GUID{0x7d, 0xdf, 0xa1, 0x76, 0x4c, 0x75, 0xe1, 0x40, 0xbc, 0x72, 0x3f, 0xca, 0xd8, 0x42, 0xde, 0xf6}: "DellDaEppid",
		efi.GUID{0x7d, 0xe1, 0x60, 0x99, 0x1c, 0xfd, 0x9a, 0x41, 0x9a, 0x90, 0x39, 0x44, 0x54, 0x2c, 0x67, 0xae}: "PowerButtonSetupDxe",
		efi.GUID{0x7d, 0xe7, 0x4a, 0xe3, 0x14, 0x33, 0xf6, 0x43, 0xb4, 0x1c, 0x6f, 0x19, 0xf3, 0xf1, 0xd6, 0xa8}: "AmdPspPeiV2Rmb",
		efi.GUID{0x7e, 0x01, 0x03, 0x55, 0x17, 0x3b, 0x1a, 0x41, 0xa6, 0x70, 0x09, 0xbb, 0x03, 0x9f, 0x1b, 0x6f}: "CrashLogDxe",
		efi.GUID{0x7e, 0x01, 0x84, 0xdd, 0x52, 0x7f, 0xf9, 0x48, 0xb1, 0x6e, 0x50, 0xed, 0x9e, 0x0d, 0xbe, 0x27}: "EfiSocketIioVariable",
		efi.GUID{0x7e, 0x0b, 0xfe, 0x9e, 0xe8, 0x27, 0xd5, 0x46, 0x83, 0x87, 0xcd, 0xda, 0xfd, 0x2c, 0x3a, 0x67}: "ASRockNetDnsBin",
		efi.GUID{0x7e, 0x12, 0x2c, 0x8f, 0x7d, 0x11, 0x4b, 0x48, 0x8a, 0x44, 0xfb, 0xd9, 0x11, 0xbe, 0x12, 0x5e}: "IpmiRedirFru",
		efi.GUID{0x7e, 0x15, 0x62, 0xbc, 0x33, 0x3e, 0xec, 0x4f, 0x99, 0x20, 0x2d, 0x3b, 0x36, 0xd7, 0x50, 0xdf}: "EfiLoadedImageDevicePathProtocolGuid",
		efi.GUID{0x7e, 0x21, 0x07, 0x68, 0xde, 0xe8, 0xd0, 0x42, 0x91, 0xd9, 0x60, 0xae, 0xce, 0xd7, 0x42, 0x0d}: "Stall",
		efi.GUID{0x7e, 0x2d, 0xcb, 0x7c, 0x15, 0xcd, 0x7e, 0x41, 0xa5, 0xc8, 0x00, 0x3d, 0xa6, 0x32, 0x5b, 0x9f}: "PowerStateManager",
		efi.GUID{0x7e, 0x3c, 0x0d, 0x0b, 0x3a, 0x47, 0xe2, 0x22, 0x84, 0x28, 0x3d, 0xae, 0x5c, 0xce, 0xac, 0x64}: "CableDetectDxe",
		efi.GUID{0x7e, 0x3e, 0x7b, 0x83, 0x59, 0x42, 0x35, 0x4e, 0x87, 0xed, 0x39, 0x7a, 0x24, 0xca, 0x15, 0x93}: "MpmSensorInfoDxe",
		efi.GUID{0x7e, 0x4c, 0xe3, 0x93, 0x0e, 0xb5, 0xdf, 0x11, 0x92, 0x23, 0x24, 0x43, 0xdf, 0xd7, 0x20, 0x85}: "ArmVeNorFlashDxe",
		efi.GUID{0x7e, 0x4e, 0xd0, 0xaa, 0xe6, 0xf6, 0x94, 0x46, 0xb1, 0x4f, 0xe2, 0xd6, 0x08, 0x74, 0x0e, 0x29}: "SmbiosType3",
		efi.GUID{0x7e, 0x4f, 0xea, 0x7c, 0x52, 0x20, 0xed, 0x46, 0xbe, 0xfd, 0xe2, 0x2a, 0x44, 0xdc, 0x65, 0xe7}: "Tpm20HobGuid",
		efi.GUID{0x7e, 0x52, 0x36, 0x1f, 0x7c, 0xa9, 0xf8, 0x45, 0xb2, 0x4a, 0x9d, 0x95, 0xb0, 0xa9, 0x40, 0xfe}: "AppleBrightnessControl",
		efi.GUID{0x7e, 0x58, 0x21, 0x27, 0xe8, 0x2a, 0xa0, 0x43, 0xaa, 0xeb, 0x19, 0xdd, 0xa1, 0x6c, 0x77, 0x64}: "FlexIoPortConfigSmm",
		efi.GUID{0x7e, 0x5b, 0x9f, 0xcc, 0x4b, 0x25, 0x8a, 0x4f, 0xa6, 0x48, 0x03, 0x4a, 0x40, 0xae, 0xda, 0x35}: "PlatformCustomizePei",
		efi.GUID{0x7e, 0x68, 0xc2, 0x77, 0x5a, 0x97, 0x9c, 0x67, 0xbe, 0x44, 0x2e, 0xf6, 0x78, 0x68, 0xce, 0xac}: "IhisiRegister",
		efi.GUID{0x7e, 0x69, 0x53, 0x50, 0xbc, 0x2c, 0x19, 0x48, 0x90, 0xd9, 0x05, 0x80, 0xde, 0xee, 0x57, 0x54}: "EfiCapsuleArchProtocolGuid",
		efi.GUID{0x7e, 0x69, 0xca, 0x4a, 0x83, 0xf8, 0x6f, 0x44, 0x98, 0xf7, 0x09, 0x64, 0x16, 0xff, 0xff, 0xff}: "OhciDxe",
		efi.GUID{0x7e, 0x6a, 0x9f, 0xcc, 0x5b, 0x24, 0x99, 0x4f, 0xb5, 0x48, 0x03, 0x4b, 0x30, 0xbd, 0xda, 0x44}: "FlexIoCard",
		efi.GUID{0x7e, 0x6e, 0x5c, 0x1c, 0x2a, 0x55, 0x3e, 0x44, 0x9a, 0x04, 0x74, 0x08, 0xad, 0xee, 0x99, 0xd3}: "FirmwareConfigDrv",
		efi.GUID{0x7e, 0x73, 0x1d, 0x5c, 0xd6, 0x36, 0xb1, 0x45, 0x86, 0x2c, 0x6b, 0x9c, 0x24, 0x4f, 0x4c, 0x07}: "PlatformStatusCodeHandlerDxe",
		efi.GUID{0x7e, 0x75, 0x1f, 0x16, 0x55, 0xed, 0x75, 0x4a, 0xa6, 0xf0, 0xed, 0x2d, 0xf1, 0x6e, 0x08, 0x42}: "LanguageDefaultsAndWmi",
		efi.GUID{0x7e, 0x77, 0xd9, 0xb8, 0x2a, 0xd7, 0x1f, 0x45, 0x9b, 0xdb, 0xba, 0xfb, 0x52, 0xa6, 0x84, 0x15}: "ArmCpuDxe",
		efi.GUID{0x7e, 0x7b, 0xdb, 0x71, 0x65, 0x41, 0xfa, 0x48, 0xac, 0x9d, 0xf9, 0xaf, 0x4c, 0xef, 0xc5, 0x34}: "DellPropertyDxeProtocol",
		efi.GUID{0x7e, 0x80, 0x1c, 0xdd, 0xb9, 0xbd, 0xa4, 0x49, 0xad, 0x50, 0xe5, 0x10, 0xdc, 0x94, 0x84, 0x76}: "FujNotInSmm",
		efi.GUID{0x7e, 0x80, 0x1d, 0xed, 0x5f, 0x9a, 0x6a, 0x43, 0xb8, 0xaa, 0xd7, 0x8e, 0xd9, 0xe7, 0xd9, 0x2c}: "DellNumberOfPStateProtocol",
		efi.GUID{0x7e, 0x8f, 0x7d, 0x28, 0x76, 0x61, 0xdb, 0x47, 0x90, 0xef, 0xf1, 0xd6, 0xd2, 0xa3, 0xde, 0x9e}: "BoardSmm",
		efi.GUID{0x7e, 0x90, 0x3d, 0xd9, 0x7d, 0xee, 0x77, 0x45, 0x83, 0x3c, 0x5a, 0xd3, 0xad, 0xbb, 0xb8, 0xc4}: "DeepS3ConfigDxe",
		efi.GUID{0x7e, 0x94, 0xb5, 0x06, 0x53, 0xff, 0x7d, 0x45, 0x98, 0xbc, 0xc5, 0xab, 0xc7, 0x77, 0xfd, 0x5a}: "SetupMouseDxe",
		efi.GUID{0x7e, 0xa9, 0xed, 0x60, 0x31, 0x36, 0xa4, 0x40, 0x85, 0xd4, 0x4a, 0x28, 0x06, 0x50, 0x86, 0xb8}: "AcerWMI",
		efi.GUID{0x7e, 0xb5, 0xad, 0xe0, 0xb6, 0xe1, 0xec, 0x44, 0xbf, 0x2e, 0x84, 0x28, 0x74, 0xa2, 0x6c, 0x83}: "LenovoWmaUsbDxe",
		efi.GUID{0x7e, 0xc8, 0x22, 0xa2, 0xec, 0x68, 0x45, 0x45, 0xa8, 0x6b, 0xa8, 0x90, 0x31, 0xa4, 0x5e, 0x82}: "OemCleanFlag",
		efi.GUID{0x7e, 0xcd, 0x47, 0xb1, 0xd3, 0x17, 0x66, 0x4d, 0xab, 0x39, 0x47, 0x2b, 0x1d, 0xa6, 0x59, 0xc1}: "UefiTableDxe",
		efi.GUID{0x7e, 0xce, 0x78, 0xeb, 0x07, 0x41, 0xf5, 0x4e, 0x86, 0xcb, 0x22, 0xe8, 0xd8, 0xac, 0x49, 0x50}: "DellSmmAsfInit",
		efi.GUID{0x7e, 0xd3, 0x39, 0xf6, 0xa1, 0x02, 0xa8, 0x4b, 0xad, 0x17, 0x5c, 0x6c, 0x6e, 0x5e, 0x93, 0x22}: "CbsSetupDxe",
		efi.GUID{0x7e, 0xd4, 0x99, 0xdc, 0x08, 0x68, 0x3a, 0x4f, 0xa1, 0xe4, 0xbe, 0x7a, 0x9a, 0xdc, 0x59, 0xff}: "FjIbvSfuControlAbstractionDxeProtocol",
		efi.GUID{0x7e, 0xe2, 0x3e, 0x3b, 0xef, 0x9b, 0x3f, 0x46, 0xb0, 0x3a, 0xa5, 0xc9, 0xa0, 0x98, 0xb7, 0xb5}: "CpuOverclockingConfigGuid",
		efi.GUID{0x7e, 0xe4, 0x95, 0x44, 0xa9, 0x42, 0x07, 0x40, 0x8c, 0x17, 0xb6, 0x66, 0x4f, 0x90, 0x9d, 0x04}: "BlockIoDxe",
		efi.GUID{0x7e, 0xeb, 0xfd, 0x26, 0xaf, 0xb8, 0xcf, 0x4c, 0xaa, 0x97, 0x02, 0x63, 0x3c, 0xe4, 0x8c, 0xa7}: "EfiProcessorSubClassGuid",
		efi.GUID{0x7e, 0xf3, 0xe3, 0x5a, 0xae, 0x4e, 0xae, 0x41, 0x82, 0x40, 0x35, 0x46, 0x5b, 0x5e, 0x81, 0xeb}: "CORE_DXE",
		efi.GUID{0x7e, 0xfc, 0xd6, 0x18, 0x62, 0xd8, 0xde, 0x48, 0xb5, 0x6d, 0xfa, 0x31, 0x14, 0x21, 0xbf, 0x29}: "EfiTpmCallBackProtocol",
		efi.GUID{0x7e, 0xfc, 0xdb, 0x56, 0x04, 0x4d, 0x3d, 0xc7, 0x8a, 0x5e, 0x73, 0x81, 0x9b, 0xd2, 0x3c, 0xa6}: "AmdSocSp3r3CpDxe",
		efi.GUID{0x7f, 0x00, 0x19, 0x92, 0x94, 0xd0, 0x61, 0x47, 0x9e, 0xb5, 0xc1, 0x4c, 0xf9, 0xd7, 0x16, 0xc0}: "FlashInfoPei",
		efi.GUID{0x7f, 0x07, 0xf3, 0x69, 0x4e, 0x4d, 0xde, 0x4f, 0xbb, 0xe3, 0x9d, 0xcd, 0xb1, 0x20, 0xf3, 0x9b}: "UsbOcUpdateDxeFischerLakeRP",
		efi.GUID{0x7f, 0x0f, 0x1b, 0x14, 0x41, 0xe2, 0x59, 0x46, 0x91, 0xbf, 0x45, 0x05, 0xd7, 0x9a, 0x77, 0x14}: "FjCpuInfo",
		efi.GUID{0x7f, 0x12, 0x46, 0xcd, 0x45, 0x92, 0x21, 0x45, 0xbb, 0x89, 0xa6, 0xd8, 0x5d, 0x68, 0xfc, 0x13}: "LegacyTableCompatibly",
		efi.GUID{0x7f, 0x15, 0x54, 0x6d, 0xef, 0x94, 0xaf, 0x41, 0xb3, 0x4c, 0xdc, 0x76, 0x11, 0xe6, 0xd4, 0x83}: "Common_SxApp",
		efi.GUID{0x7f, 0x1a, 0xad, 0xc2, 0xdf, 0xd9, 0x38, 0x46, 0x8d, 0xac, 0x01, 0x59, 0x96, 0xc8, 0x88, 0x57}: "ScPolicyHobGuid",
		efi.GUID{0x7f, 0x37, 0x45, 0xbe, 0x62, 0xf8, 0xbd, 0x42, 0x88, 0x86, 0x31, 0x4c, 0x67, 0xbc, 0x16, 0xe4}: "LfcWmiServiceSmm",
		efi.GUID{0x7f, 0x3d, 0x47, 0xda, 0x31, 0x4b, 0x63, 0x4d, 0x92, 0xb7, 0x3d, 0x90, 0x5e, 0xf8, 0x4b, 0x84}: "AmiSmmBufferValidationProtocol",
		efi.GUID{0x7f, 0x43, 0xf1, 0xbe, 0xeb, 0x8a, 0x6c, 0x43, 0x8d, 0x7c, 0x08, 0xba, 0x5f, 0xe4, 0x49, 0xaf}: "FjDtSetupServicesDxe",
		efi.GUID{0x7f, 0x49, 0x40, 0x56, 0x5e, 0x64, 0x11, 0x46, 0xb9, 0x15, 0xe6, 0x82, 0xc8, 0xbd, 0x47, 0x83}: "AsrockClockGenDxe",
		efi.GUID{0x7f, 0x4a, 0x32, 0xaa, 0x76, 0xa6, 0xdc, 0x46, 0xa3, 0x5d, 0xa4, 0x04, 0x22, 0x6a, 0x7a, 0x04}: "ReprotErrorCodeStatus",
		efi.GUID{0x7f, 0x4a, 0x36, 0xe4, 0x25, 0xf8, 0x0e, 0x43, 0x9d, 0x3a, 0x9c, 0x9b, 0xe6, 0x81, 0x7c, 0xa5}: "EdkiiLinuxTerm",
		efi.GUID{0x7f, 0x56, 0x03, 0x7c, 0x40, 0xc8, 0x9c, 0x4e, 0xbf, 0xcc, 0x65, 0x27, 0x93, 0xc2, 0xfb, 0xfb}: "DpfServicesDxe",
		efi.GUID{0x7f, 0x5c, 0x17, 0x51, 0x60, 0x03, 0x42, 0x40, 0xa3, 0xf2, 0xf1, 0x72, 0x22, 0xb4, 0x00, 0xac}: "SbFlashControllerSmm",
		efi.GUID{0x7f, 0x5e, 0x9d, 0x2a, 0x3a, 0xa4, 0xc7, 0x4f, 0xa2, 0x5e, 0x6e, 0x28, 0xd4, 0x12, 0xfa, 0x6f}: "efi_pop_RT",
		efi.GUID{0x7f, 0x71, 0xe7, 0x44, 0x5e, 0x07, 0x0d, 0x45, 0x98, 0xd5, 0x54, 0xeb, 0xbb, 0x40, 0x70, 0x1e}: "EfiPlatformTypeLightningRidgeExecB3Protocol",
		efi.GUID{0x7f, 0x7f, 0x3a, 0xee, 0x81, 0x38, 0xa2, 0x4e, 0xb3, 0x8f, 0x5d, 0x9c, 0x98, 0xdb, 0x4a, 0xf1}: "FjSsdtDxe",
		efi.GUID{0x7f, 0x80, 0x6e, 0xaa, 0xc8, 0x88, 0x37, 0x42, 0xee, 0x25, 0xaa, 0xc4, 0x5b, 0xf1, 0x88, 0x04}: "EfiIntelLanDriver",
		efi.GUID{0x7f, 0x80, 0x6e, 0xce, 0xc8, 0x77, 0x37, 0x42, 0xbf, 0x25, 0xf9, 0xc4, 0x5f, 0xd1, 0x88, 0x04}: "EfiLanDriver",
		efi.GUID{0x7f, 0x82, 0xec, 0x88, 0xde, 0x6c, 0xdd, 0x41, 0x8b, 0x55, 0xbd, 0x62, 0x44, 0x9c, 0x4f, 0x1b}: "VbtMipiPanel2Guid",
		efi.GUID{0x7f, 0x86, 0xaa, 0xe2, 0xde, 0x70, 0x2a, 0x49, 0xb2, 0x5a, 0x77, 0xb3, 0x05, 0x50, 0x24, 0xcb}: "CbsBaseDxePHX",
		efi.GUID{0x7f, 0x87, 0x6c, 0x10, 0xba, 0xc2, 0x46, 0x4c, 0x87, 0x6c, 0xbd, 0xfe, 0x61, 0x71, 0xcd, 0x7e}: "DebugCommunicationLibUsb3Pei",
		efi.GUID{0x7f, 0x92, 0x7e, 0xe6, 0x40, 0x61, 0x7f, 0x40, 0x9a, 0x3e, 0x4d, 0xbd, 0x13, 0x19, 0x0f, 0x2c}: "IdeDeviceDetect",
		efi.GUID{0x7f, 0xa0, 0x58, 0x2d, 0xa7, 0x38, 0x0b, 0x49, 0x86, 0xa0, 0xd3, 0x9f, 0x60, 0xed, 0x79, 0x39}: "FjGabiEntryDxeBin",
		efi.GUID{0x7f, 0xa2, 0x70, 0xc7, 0x6a, 0x95, 0x7a, 0x49, 0x85, 0x48, 0xe0, 0x61, 0x97, 0x58, 0x8b, 0xf6}: "RecoveryOnFatNvmeDisk",
		efi.GUID{0x7f, 0xa6, 0x32, 0xd4, 0xdc, 0x14, 0x4b, 0x48, 0xb3, 0xbb, 0x3f, 0x02, 0x91, 0x84, 0x93, 0x27}: "EfiDiskInfoProtocolGuid",
		efi.GUID{0x7f, 0xa9, 0xe5, 0x12, 0xd1, 0x98, 0x1f, 0x4c, 0x87, 0xda, 0xfb, 0x67, 0xcf, 0xfb, 0xd9, 0xda}: "EfiLanDriverDxe",
		efi.GUID{0x7f, 0xbf, 0x67, 0xe7, 0xb6, 0x4d, 0x34, 0x5b, 0x10, 0x11, 0x4f, 0xbe, 0x4c, 0xa7, 0xaf, 0xd2}: "VlvMmioPolicyPpiGuid",
		efi.GUID{0x7f, 0xcb, 0xa2, 0xd6, 0x18, 0x6a, 0x2f, 0x4e, 0xb4, 0x3b, 0x99, 0x20, 0xa7, 0x33, 0x70, 0x0a}: "DxeCore",
		efi.GUID{0x7f, 0xcd, 0x85, 0x1d, 0x3d, 0xf4, 0xd2, 0x11, 0x9a, 0x0c, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d}: "EfiUnicodeCollationProtocolGuid",
		efi.GUID{0x7f, 0xd3, 0x46, 0xf7, 0xc6, 0xf6, 0xc0, 0x43, 0x94, 0xdb, 0x46, 0x6f, 0x5f, 0x10, 0xe0, 0x30}: "LenovoFingerprintSmm",
		efi.GUID{0x7f, 0xd6, 0x99, 0xf0, 0xae, 0x71, 0x36, 0x4c, 0xb2, 0xa3, 0xdc, 0xeb, 0x0e, 0xb2, 0xb7, 0xd8}: "WatchdogTimer",
		efi.GUID{0x7f, 0xd8, 0x9f, 0x09, 0x39, 0x4b, 0xf6, 0x43, 0xab, 0x47, 0xf8, 0x01, 0xf9, 0x92, 0x09, 0xf7}: "DellDcpRegister",
		efi.GUID{0x7f, 0xe7, 0x75, 0x1e, 0x15, 0x8a, 0x53, 0x46, 0x96, 0x4d, 0x54, 0x2c, 0x15, 0x7e, 0xf4, 0x0a}: "SgPeiPolicyInit",
		efi.GUID{0x7f, 0xeb, 0xcf, 0xc7, 0xfd, 0xae, 0x1d, 0x42, 0xbc, 0xdf, 0x03, 0x33, 0x29, 0xab, 0x8b, 0x4c}: "GetVariableHookPei",
		efi.GUID{0x7f, 0xf1, 0x8b, 0x42, 0x16, 0x61, 0x59, 0x4d, 0x84, 0x3a, 0x40, 0x04, 0x70, 0xd1, 0x78, 0x64}: "DellSpdSmbusAccessSmm",
		efi.GUID{0x7f, 0xf9, 0x58, 0x33, 0xbe, 0x63, 0xa8, 0x47, 0x89, 0xbb, 0xed, 0x63, 0x61, 0x2e, 0x6c, 0x9f}: "LinUptpPure",
		efi.GUID{0x7f, 0xfb, 0x29, 0xaf, 0xb7, 0xea, 0x11, 0x42, 0x96, 0x84, 0xce, 0x8d, 0x4a, 0x47, 0xa0, 0xc7}: "StaticSkuDataDxeExpertWorkStationRP",
		efi.GUID{0x80, 0x00, 0x83, 0x20, 0x28, 0xcc, 0x69, 0x41, 0x98, 0x36, 0x7f, 0x42, 0xb8, 0xd0, 0xc8, 0xc9}: "GraphicsOutputDxe",
		efi.GUID{0x80, 0x05, 0x00, 0xf8, 0xab, 0x44, 0x1f, 0x44, 0x86, 0xb4, 0xda, 0x3c, 0xa0, 0x99, 0xee, 0xbb}: "H19RecordLogSmm",
		efi.GUID{0x80, 0x10, 0x63, 0x61, 0x73, 0x55, 0x10, 0x43, 0x9a, 0xc5, 0x0b, 0xaf, 0xc9, 0x5e, 0x1c, 0x1b}: "AmdCcxZen3Smm",
		efi.GUID{0x80, 0x10, 0xa0, 0x37, 0x46, 0x23, 0x54, 0x4a, 0x99, 0x00, 0xd2, 0x2b, 0x7b, 0x68, 0x7c, 0x22}: "SmmPciRbIo",
		efi.GUID{0x80, 0x10, 0xd1, 0x92, 0x6f, 0x49, 0x95, 0x4d, 0xbe, 0x7e, 0x03, 0x74, 0x88, 0x38, 0x2b, 0x0a}: "EfiStatusCodeDataTypeStringGuid",
		efi.GUID{0x80, 0x1c, 0x77, 0xca, 0xd9, 0x02, 0xe4, 0x11, 0xa1, 0x95, 0x78, 0xe7, 0xd1, 0xaf, 0x36, 0xd1}: "HpNetworkBiosUpdateWmiSmm",
		efi.GUID{0x80, 0x20, 0x75, 0xdd, 0x6c, 0xdf, 0x33, 0x45, 0xad, 0x66, 0x62, 0x13, 0xee, 0x68, 0x1f, 0x84}: "ThermalDxe",
		efi.GUID{0x80, 0x22, 0xf7, 0x91, 0xcc, 0x36, 0xf3, 0x4b, 0xac, 0x40, 0xbc, 0x02, 0x9e, 0x4b, 0x31, 0x77}: "inf",
		efi.GUID{0x80, 0x29, 0x01, 0xfc, 0xf9, 0xd6, 0x41, 0x47, 0xb6, 0x60, 0x32, 0xd0, 0x4e, 0x26, 0x9b, 0xd8}: "DellFmpPm",
		efi.GUID{0x80, 0x2e, 0x32, 0xcc, 0x08, 0x6a, 0x80, 0x4e, 0x8b, 0xca, 0x01, 0xa8, 0x4b, 0xa6, 0xcf, 0xe4}: "PciHostBridge2",
		efi.GUID{0x80, 0x30, 0x99, 0xee, 0x97, 0x51, 0x4e, 0x4d, 0xb6, 0x3c, 0xf1, 0xf7, 0x41, 0x3e, 0x33, 0xce}: "CpuDxe",
		efi.GUID{0x80, 0x38, 0xcf, 0x41, 0x60, 0x05, 0x01, 0x4d, 0x86, 0x24, 0x3a, 0x0a, 0x47, 0x89, 0x45, 0x74}: "DetectDevice",
		efi.GUID{0x80, 0x3c, 0x1c, 0x8a, 0x91, 0xa8, 0xea, 0x4e, 0x91, 0x97, 0x66, 0x35, 0xe2, 0x77, 0xc4, 0xdb}: "HpVrocDxe",
		efi.GUID{0x80, 0x46, 0xb1, 0x3a, 0x3f, 0x5d, 0x4d, 0x4a, 0xbc, 0xdc, 0xcc, 0x38, 0x00, 0x18, 0xc7, 0xf7}: "EfiDiskInfoNvmeInterfaceGuid",
		efi.GUID{0x80, 0x49, 0x4b, 0x95, 0x90, 0xff, 0x02, 0x4b, 0x97, 0x7f, 0x91, 0x29, 0x22, 0x51, 0xa3, 0xe3}: "DellAutoBifurcateBoardCfgDxe",
		efi.GUID{0x80, 0x52, 0xd7, 0x07, 0xd4, 0x27, 0x69, 0x4d, 0x90, 0xd0, 0x56, 0x43, 0xe2, 0x38, 0xb3, 0x41}: "EfiPciPlatformProtocolGuid",
		efi.GUID{0x80, 0x5f, 0x98, 0xf5, 0x55, 0xcf, 0xad, 0x46, 0x8c, 0xcb, 0xd4, 0x9b, 0xf9, 0x16, 0x8a, 0xc4}: "AmiRedfishVlan",
		efi.GUID{0x80, 0x61, 0xbe, 0x21, 0x3a, 0x73, 0x3b, 0x44, 0xdf, 0x46, 0x41, 0xc0, 0x08, 0x04, 0x76, 0x87}: "AmdNbioPciePei",
		efi.GUID{0x80, 0x65, 0x1f, 0x0c, 0x57, 0x9c, 0x32, 0x4a, 0x84, 0x99, 0x22, 0x7c, 0x2e, 0xa2, 0x7e, 0x7d}: "DellSmmServicesProtocol",
		efi.GUID{0x80, 0x6b, 0x0b, 0xd4, 0xd5, 0x97, 0x82, 0x42, 0xbb, 0x1d, 0x22, 0x3a, 0x16, 0x91, 0x80, 0x58}: "EfiNvdimmLabelProtocolGuid",
		efi.GUID{0x80, 0x6c, 0xa7, 0x04, 0xb9, 0x06, 0x5e, 0x44, 0xb7, 0x3e, 0xcb, 0x8c, 0x61, 0xa6, 0xa9, 0x64}: "SIO791",
		efi.GUID{0x80, 0x6d, 0x91, 0x7d, 0xb1, 0x5b, 0x8c, 0x45, 0xa4, 0x8f, 0xe2, 0x5f, 0xdd, 0x51, 0xef, 0x94}: "EfiTtyTermGuid",
		efi.GUID{0x80, 0x7d, 0x4b, 0xd7, 0x7f, 0x4b, 0x73, 0x4a, 0x8a, 0x55, 0x4b, 0x59, 0xd7, 0xde, 0x74, 0x7a}: "AmdResetManager",
		efi.GUID{0x80, 0x81, 0x8a, 0xe8, 0xda, 0x16, 0x1b, 0x4a, 0x90, 0x8c, 0x3e, 0x51, 0x76, 0x86, 0xf1, 0xfa}: "WifiProvisioningSmm",
		efi.GUID{0x80, 0xa1, 0xe9, 0x4d, 0x40, 0xfa, 0x99, 0x48, 0xab, 0x66, 0x4e, 0x63, 0x25, 0xb0, 0x31, 0x5d}: "GpioExpanderDxe",
		efi.GUID{0x80, 0xaa, 0xb7, 0x30, 0xb5, 0x44, 0x7e, 0x47, 0x8a, 0xc3, 0x21, 0x49, 0x3f, 0x5b, 0x9d, 0x43}: "FjClearRtcDayLight",
		efi.GUID{0x80, 0xad, 0x3e, 0x13, 0x48, 0xfb, 0xe5, 0x11, 0x93, 0x9d, 0x64, 0x31, 0x50, 0x3b, 0x93, 0x9a}: "TransparentUnlockDrv",
		efi.GUID{0x80, 0xae, 0x6c, 0x16, 0xde, 0x98, 0xb9, 0x45, 0xbb, 0x47, 0x85, 0x30, 0x71, 0x45, 0xd8, 0x74}: "AmdNbioGfxRMBPei",
		efi.GUID{0x80, 0xb0, 0xf9, 0x43, 0x02, 0xc9, 0x37, 0x47, 0xb3, 0x06, 0x48, 0x70, 0x50, 0xf7, 0xca, 0xa5}: "fjHddEraseApp64",
		efi.GUID{0x80, 0xc0, 0x9f, 0x46, 0xc1, 0xae, 0xdf, 0x11, 0x92, 0x7c, 0x00, 0x02, 0xa5, 0xd5, 0xc5, 0x1b}: "ArmPlatformPrePeiCore",
		efi.GUID{0x80, 0xc7, 0x01, 0x99, 0x33, 0x3e, 0x18, 0x4d, 0xb5, 0x4a, 0xcf, 0x72, 0x34, 0xaf, 0xdb, 0x50}: "DellPolicySmm",
		efi.GUID{0x80, 0xc8, 0x7b, 0x3c, 0xf8, 0x41, 0x69, 0x48, 0xae, 0xfc, 0x87, 0x0a, 0x3e, 0xd2, 0x82, 0x99}: "EfiHeciProtocolGuid",
		efi.GUID{0x80, 0xca, 0x1c, 0x08, 0x21, 0xae, 0xc8, 0xaf, 0x1a, 0xc8, 0x30, 0x91, 0xa8, 0xf1, 0xcb, 0xc5}: "SmcOobPlatformPolicySmm",
		efi.GUID{0x80, 0xd3, 0x6f, 0x6b, 0x55, 0x2c, 0xc6, 0x42, 0x98, 0xbf, 0xcb, 0xbc, 0x5a, 0x9a, 0xa6, 0x66}: "SocketSetup",
		efi.GUID{0x80, 0xd3, 0xf4, 0x8f, 0x91, 0x88, 0x95, 0x44, 0xaf, 0x40, 0x71, 0x6c, 0xd5, 0x5c, 0x07, 0xe8}: "LEMPostLogoDIYDxe",
		efi.GUID{0x80, 0xdd, 0x5d, 0x08, 0x41, 0xce, 0xa8, 0x4f, 0xb2, 0x98, 0x60, 0x71, 0xe8, 0xf6, 0x2b, 0xc5}: "SmcOobPlatformPolicyDxe",
		efi.GUID{0x80, 0xe3, 0x9f, 0x7c, 0xd2, 0xcf, 0xf0, 0x4b, 0x9b, 0x96, 0xe5, 0xdf, 0x40, 0x63, 0x5e, 0xcb}: "RealtekGopDriver",
		efi.GUID{0x80, 0xe8, 0x42, 0x51, 0xac, 0x97, 0xb3, 0x4a, 0x8f, 0x06, 0xf3, 0x67, 0x65, 0xdf, 0x70, 0x66}: "OemACRecoveryDxe",
		efi.GUID{0x80, 0xeb, 0x2c, 0xc6, 0x40, 0xfb, 0x46, 0x4a, 0xa5, 0xe5, 0xc1, 0xd9, 0x97, 0xc3, 0x6d, 0xfc}: "CapsuleLoaderTriggerDxe",
		efi.GUID{0x80, 0xed, 0xc7, 0x7c, 0x68, 0x9a, 0x81, 0x47, 0x80, 0xe4, 0xda, 0x16, 0x99, 0x10, 0x5a, 0xfe}: "EfiLightIsaIoProtocol",
		efi.GUID{0x80, 0xf0, 0xda, 0xbc, 0xde, 0x1b, 0x22, 0x4e, 0xae, 0x6a, 0x43, 0x54, 0x1e, 0x12, 0x8e, 0xc4}: "EfiIsaHcProtocolGuid",
		efi.GUID{0x80, 0xf5, 0x4f, 0x4f, 0xa0, 0xb8, 0x32, 0x43, 0xa6, 0xb0, 0xe2, 0xe5, 0x68, 0xe3, 0x6c, 0x9c}: "ASFVerbosity",
		efi.GUID{0x80, 0xf9, 0x74, 0x0b, 0x25, 0x23, 0xf3, 0x4a, 0x96, 0x64, 0x0c, 0x3a, 0xbe, 0x23, 0x7d, 0x52}: "BootPerformanceLogSmm",
		efi.GUID{0x80, 0xff, 0x0b, 0xee, 0x33, 0x2b, 0x05, 0x40, 0x8e, 0xf1, 0x3f, 0x9b, 0x23, 0xc2, 0x51, 0x36}: "GetCpuInfo",
		efi.GUID{0x81, 0x00, 0x13, 0x43, 0xd6, 0x60, 0x29, 0x4c, 0xbb, 0xc0, 0xab, 0x0b, 0x5b, 0xb9, 0x04, 0x83}: "DellMfgAuthenticationSmm",
		efi.GUID{0x81, 0x14, 0x23, 0xd5, 0x4e, 0x17, 0x6f, 0x43, 0x8d, 0xf7, 0x9a, 0x6d, 0x8a, 0x27, 0x23, 0x2a}: "NbSspRouting",
		efi.GUID{0x81, 0x15, 0xb3, 0xbb, 0x5a, 0x85, 0xd7, 0x44, 0xa5, 0x50, 0x8a, 0x58, 0x5d, 0x9b, 0x2d, 0xe9}: "BaseCryptLibRuntimeCryptProtocol",
		efi.GUID{0x81, 0x23, 0x7e, 0x06, 0x34, 0x72, 0x98, 0x47, 0xb4, 0x9c, 0xd5, 0xfe, 0xcb, 0xff, 0x6d, 0x07}: "VariableAuthSmmRuntimeDxe",
		efi.GUID{0x81, 0x26, 0x52, 0xba, 0x67, 0xcf, 0xe2, 0x49, 0x92, 0x5f, 0xf6, 0x0b, 0x32, 0x81, 0x90, 0x39}: "FspInitNotify",
		efi.GUID{0x81, 0x2f, 0x65, 0xe5, 0x09, 0xec, 0x9c, 0x47, 0xba, 0xff, 0xe7, 0x56, 0xf1, 0x82, 0x90, 0x16}: "DirtyShutdownPei",
		efi.GUID{0x81, 0x30, 0x66, 0xf6, 0xd1, 0x02, 0x52, 0x4f, 0xb5, 0x7c, 0xfd, 0xad, 0x22, 0x49, 0x41, 0xd4}: "AmdMemSmbiosV2RvPei",
		efi.GUID{0x81, 0x32, 0x04, 0xcc, 0x2f, 0x11, 0x1c, 0x44, 0x80, 0x5d, 0x6d, 0x8d, 0xb3, 0x65, 0x96, 0x18}: "BbstableHook",
		efi.GUID{0x81, 0x35, 0x24, 0xcc, 0x2f, 0x11, 0x1c, 0x44, 0x81, 0x5d, 0x6d, 0x8d, 0xb3, 0x65, 0x96, 0x19}: "A01D2DRecoveryDriver",
		efi.GUID{0x81, 0x36, 0x05, 0x58, 0xf3, 0x13, 0xf6, 0x47, 0xb1, 0x37, 0xcd, 0xb3, 0xe8, 0x88, 0xd9, 0xa4}: "ExtendedDataGuid",
		efi.GUID{0x81, 0x3b, 0x6a, 0x55, 0x9d, 0x39, 0x51, 0x49, 0x82, 0xc5, 0xbc, 0x72, 0xfe, 0x5e, 0xfb, 0xcb}: "FjMfgFeaturesDxe",
		efi.GUID{0x81, 0x3e, 0xae, 0xb0, 0xb0, 0xc6, 0x35, 0x4d, 0xad, 0x51, 0x91, 0x17, 0xe0, 0x65, 0x1e, 0xa3}: "PlatformEmmcHs400TuningInfoGuid",
		efi.GUID{0x81, 0x3f, 0xb4, 0x91, 0xca, 0xdf, 0xba, 0x4e, 0x93, 0xe1, 0xfa, 0xd5, 0x01, 0xe8, 0xf6, 0xd2}: "AmiScceMMCEnabledPpiGuid",
		efi.GUID{0x81, 0x42, 0xd5, 0xee, 0x11, 0x1c, 0x58, 0x43, 0xbf, 0x5a, 0xf6, 0x49, 0x95, 0xfb, 0xf1, 0x1b}: "FmpDxe",
		efi.GUID{0x81, 0x43, 0x9c, 0xad, 0xde, 0x1e, 0x0c, 0x43, 0x8d, 0x42, 0x23, 0x76, 0x7c, 0x46, 0x5d, 0x52}: "EfiUsbKeyboardConnectGuid",
		efi.GUID{0x81, 0x4b, 0x74, 0xe0, 0x13, 0x95, 0xcd, 0x49, 0x8c, 0xea, 0xe9, 0x24, 0x5e, 0x70, 0x39, 0xda}: "EfiSmmGpiDispatchProtocolGuid",
		efi.GUID{0x81, 0x4c, 0x28, 0x5c, 0xae, 0xb0, 0x87, 0x4e, 0xa3, 0x22, 0xb0, 0x4c, 0x85, 0x62, 0x43, 0x23}: "EfiEventNotificationTypeSei",
		efi.GUID{0x81, 0x4d, 0x5d, 0xcc, 0xf5, 0xe9, 0x87, 0x43, 0x92, 0x07, 0xd0, 0xa3, 0x5d, 0x3e, 0x75, 0x75}: "AsusBiosDxeCrashFree",
		efi.GUID{0x81, 0x56, 0x70, 0xed, 0x49, 0x16, 0xbb, 0x4b, 0x80, 0x91, 0xe3, 0x6f, 0x52, 0x52, 0x37, 0x61}: "StandbyImmediate",
		efi.GUID{0x81, 0x71, 0x6e, 0x20, 0x35, 0xa9, 0xaf, 0x4b, 0x94, 0x9f, 0xa8, 0x75, 0x13, 0x6c, 0xd4, 0x6f}: "PldmBcc",
		efi.GUID{0x81, 0x75, 0x77, 0x11, 0x67, 0x2b, 0x75, 0x40, 0x8e, 0xb4, 0xf6, 0x91, 0xa4, 0x7e, 0xce, 0xc7}: "ProcMemInit",
		efi.GUID{0x81, 0x88, 0x36, 0x01, 0xad, 0xc4, 0x1d, 0x4b, 0xb6, 0x31, 0xd5, 0x7a, 0x8e, 0xc8, 0xdb, 0x6b}: "AmiGlobalVariableGuid",
		efi.GUID{0x81, 0x8c, 0x92, 0xa4, 0x03, 0x07, 0xd7, 0x4a, 0xa3, 0x2b, 0x75, 0x25, 0xbc, 0x3f, 0xe1, 0xf5}: "LenovoSecureUpdateDxe",
		efi.GUID{0x81, 0x9c, 0x06, 0xc3, 0x17, 0x67, 0xb6, 0x4f, 0xb6, 0x46, 0x04, 0x21, 0x48, 0x94, 0xba, 0xb4}: "SmcSwSmiFlashDxe",
		efi.GUID{0x81, 0x9f, 0x75, 0x0d, 0xb0, 0x43, 0x0a, 0x4e, 0xb6, 0x13, 0x61, 0x55, 0x0c, 0x61, 0x57, 0xc2}: "SystemGraphicsOutputBltPipeDxe",
		efi.GUID{0x81, 0xab, 0x1e, 0x1c, 0x29, 0x92, 0xac, 0x42, 0xb9, 0x40, 0x75, 0x7c, 0x49, 0x8a, 0x09, 0xed}: "AmiTseOemPortingVar22",
		efi.GUID{0x81, 0xad, 0x18, 0x07, 0x6a, 0xf2, 0x50, 0x48, 0xa6, 0xec, 0xf2, 0x68, 0xe3, 0x09, 0xd7, 0x07}: "Tpm20PlatformDxe",
		efi.GUID{0x81, 0xb8, 0x7d, 0x8c, 0x76, 0xda, 0x86, 0x44, 0x86, 0x54, 0x81, 0x52, 0xee, 0x34, 0x70, 0xa3}: "MuVarPolicyFoundationDxe",
		efi.GUID{0x81, 0xbe, 0x19, 0x6f, 0x81, 0x73, 0xf3, 0x4a, 0xbb, 0x26, 0x55, 0x33, 0x11, 0x72, 0x6e, 0x34}: "AsusAmlBuffSmi",
		efi.GUID{0x81, 0xc1, 0x44, 0x76, 0x6e, 0xfa, 0xda, 0x46, 0x80, 0xcb, 0x04, 0xb9, 0x90, 0x40, 0x62, 0xe8}: "EfiPathFileName",
		efi.GUID{0x81, 0xda, 0x5e, 0xd3, 0xd0, 0x07, 0x42, 0x41, 0x94, 0x09, 0xb0, 0x72, 0x33, 0xed, 0x2d, 0x07}: "CseSpiSelectPpiGuid",
		efi.GUID{0x81, 0xef, 0x17, 0x7d, 0xc8, 0x57, 0x10, 0x42, 0x95, 0x7c, 0x6f, 0xda, 0xa8, 0xea, 0x1d, 0xd6}: "PciHotPlugDxe",
		efi.GUID{0x81, 0xf4, 0xa1, 0xb7, 0x98, 0x12, 0x3a, 0x47, 0xa8, 0x32, 0x4d, 0x8a, 0xb8, 0x33, 0x31, 0xcd}: "OemSetup",
		efi.GUID{0x81, 0xf6, 0xe5, 0x79, 0xf4, 0x59, 0x15, 0x44, 0x8e, 0x46, 0x8c, 0x22, 0x3c, 0xf5, 0x17, 0xe6}: "EfiBootMediaHobGuid",
		efi.GUID{0x82, 0x0a, 0x2e, 0xd2, 0x56, 0xc2, 0x2b, 0x47, 0x98, 0x20, 0xf7, 0xba, 0x71, 0x27, 0xfb, 0xe7}: "OtaDxeDriver",
		efi.GUID{0x82, 0x0c, 0x9b, 0xd9, 0xb0, 0x9b, 0x8d, 0x4b, 0x95, 0x45, 0xa2, 0x67, 0x03, 0x75, 0xa9, 0x31}: "AfuCapsuleOnDiskSmm",
		efi.GUID{0x82, 0x0f, 0x2a, 0x3c, 0xdf, 0x36, 0x02, 0x47, 0xb0, 0xa3, 0x5a, 0x5b, 0x0a, 0x0f, 0x89, 0xc1}: "OemSmm",
		efi.GUID{0x82, 0x14, 0xce, 0x53, 0x8d, 0x8b, 0x24, 0x4b, 0x88, 0x8a, 0xc2, 0xbd, 0xa1, 0x9c, 0xf4, 0xa1}: "UefiToPublicWmiRouter",
		efi.GUID{0x82, 0x15, 0xd7, 0x77, 0x74, 0x42, 0xc5, 0x0e, 0x36, 0xcd, 0x65, 0xa2, 0xcc, 0x4f, 0xd6, 0x63}: "DellWsmtEnforceSmm",
		efi.GUID{0x82, 0x16, 0xad, 0xa0, 0x5c, 0xae, 0x9c, 0x4a, 0x91, 0x95, 0xf2, 0x71, 0x58, 0x5c, 0xe0, 0x7e}: "RSTeRaidDriver",
		efi.GUID{0x82, 0x1e, 0xbc, 0x81, 0xb2, 0xd8, 0x44, 0x44, 0xa3, 0x36, 0xe8, 0x3d, 0x80, 0x65, 0x4a, 0x6c}: "DynamicPowerSwitch",
		efi.GUID{0x82, 0x29, 0x62, 0xc0, 0x0a, 0xa3, 0xa5, 0x48, 0x81, 0x50, 0x5a, 0xbf, 0x41, 0x91, 0x05, 0x6f}: "LEMBootModeDxeSmm",
		efi.GUID{0x82, 0x2d, 0xc0, 0x3c, 0x0f, 0xd4, 0x97, 0x48, 0x96, 0xef, 0x2f, 0x35, 0xb3, 0xaa, 0xa0, 0x96}: "I2cMaster",
		efi.GUID{0x82, 0x41, 0x7c, 0x2b, 0xb0, 0x81, 0xaa, 0x4a, 0x9e, 0x70, 0xb8, 0x8a, 0xec, 0x29, 0xb8, 0x53}: "PeimBoardInit",
		efi.GUID{0x82, 0x56, 0xab, 0xaf, 0xca, 0xf6, 0x04, 0x4e, 0x88, 0xbf, 0x66, 0x63, 0x8c, 0x23, 0xef, 0xa1}: "WifiProvisioningDxe",
		efi.GUID{0x82, 0x5d, 0xa8, 0x54, 0x54, 0x3a, 0x06, 0x40, 0x9c, 0x0e, 0xe5, 0x27, 0x29, 0x5c, 0x4f, 0xa8}: "SetupLangService",
		efi.GUID{0x82, 0x62, 0x63, 0xdf, 0xed, 0x5e, 0xdf, 0x11, 0xa9, 0xd6, 0xb3, 0x34, 0xfb, 0xa2, 0x4b, 0xb0}: "IntelHdAudioDxe",
		efi.GUID{0x82, 0x62, 0xfc, 0x0e, 0xe5, 0xf1, 0x9a, 0x46, 0x8a, 0x70, 0x19, 0x4a, 0x87, 0x61, 0xf9, 0xaa}: "XenAcpiPlatformDxe",
		efi.GUID{0x82, 0x67, 0x0b, 0xf6, 0x47, 0x32, 0xdc, 0x4c, 0xbd, 0xb7, 0x5c, 0xeb, 0x18, 0x46, 0x86, 0xad}: "SystemUsbHidParserSmm",
		efi.GUID{0x82, 0x68, 0x19, 0xd5, 0x70, 0xa9, 0x10, 0x45, 0x8f, 0xb9, 0xd7, 0x58, 0x3b, 0x69, 0x06, 0xe7}: "LenovoVariableSmm",
		efi.GUID{0x82, 0x69, 0x1c, 0xc6, 0x04, 0xb9, 0xef, 0x4c, 0xbf, 0x1b, 0xc6, 0x3b, 0xf7, 0xca, 0x03, 0x52}: "SataPeim",
		efi.GUID{0x82, 0x69, 0x1c, 0xc6, 0x04, 0xb9, 0xef, 0x4c, 0xbf, 0x1b, 0xc6, 0x3b, 0xf7, 0xca, 0x03, 0x99}: "UsbPeim",
		efi.GUID{0x82, 0x6a, 0xb2, 0x79, 0x07, 0x5c, 0xaa, 0x4a, 0xa8, 0xf3, 0x8a, 0xd1, 0x95, 0xd2, 0x71, 0xa2}: "SetupConfigUpdateDxeFischerLakeRP",
		efi.GUID{0x82, 0x6f, 0xfa, 0x52, 0x55, 0x52, 0xe1, 0x45, 0x8a, 0xbf, 0xc6, 0x2e, 0xda, 0x2c, 0x89, 0xba}: "SmbiosType133",
		efi.GUID{0x82, 0x70, 0x82, 0x43, 0x0b, 0x11, 0x8f, 0x42, 0xb6, 0xbb, 0x41, 0xf6, 0x5e, 0x67, 0xb2, 0x02}: "AsusUsbDxe",
		efi.GUID{0x82, 0x77, 0x2f, 0xf4, 0x2e, 0x01, 0x12, 0x4c, 0x99, 0x56, 0x49, 0xf9, 0x43, 0x04, 0xf7, 0x21}: "EfiConsoleControlProtocolGuid",
		efi.GUID{0x82, 0x81, 0x46, 0xbc, 0x0b, 0x0c, 0x45, 0xd6, 0xa8, 0xac, 0xfb, 0x5d, 0x81, 0x07, 0x6a, 0xe8}: "UserInterfaceThemeDriver",
		efi.GUID{0x82, 0x82, 0xb3, 0xf3, 0x51, 0xb9, 0x2a, 0x4e, 0x8d, 0xf5, 0xde, 0x01, 0xfc, 0x52, 0x7a, 0xe4}: "RtcWakeup",
		efi.GUID{0x82, 0x8c, 0x1f, 0xc4, 0xe6, 0xb3, 0xe0, 0x47, 0xa6, 0x1d, 0x0f, 0x9e, 0x42, 0x9e, 0x69, 0x96}: "DebugCommunicationLibUsb3Dxe",
		efi.GUID{0x82, 0x8d, 0xa6, 0x7f, 0xa4, 0x10, 0x71, 0x4e, 0x95, 0x24, 0xd3, 0xd9, 0x50, 0x0d, 0x3c, 0xdf}: "PlatformSecureLibNull",
		efi.GUID{0x82, 0x8f, 0x4b, 0x8f, 0x91, 0x9b, 0x28, 0x40, 0x86, 0xe6, 0xf4, 0xdb, 0x7d, 0x4c, 0x1d, 0xff}: "Bds",
		efi.GUID{0x82, 0x96, 0xdd, 0xdb, 0xfa, 0x70, 0xce, 0x46, 0xb8, 0x9c, 0xd6, 0xaf, 0x71, 0x4e, 0x51, 0xb9}: "LpssSmm",
		efi.GUID{0x82, 0x99, 0x4d, 0x04, 0x57, 0xaa, 0xd7, 0x45, 0xbb, 0x7d, 0x62, 0x96, 0x6a, 0xf7, 0x35, 0x6b}: "DellStatusCodeHandlerPei",
		efi.GUID{0x82, 0x9e, 0xbd, 0x3e, 0x78, 0x2c, 0xe6, 0x4d, 0x97, 0x86, 0x8d, 0x4b, 0xfc, 0xb7, 0xc8, 0x81}: "EfiFaultTolerantWriteProtocolGuid",
		efi.GUID{0x82, 0xab, 0xb2, 0xb0, 0x9b, 0x2e, 0x89, 0x4f, 0xa3, 0xd8, 0xf5, 0xa9, 0x99, 0x68, 0x95, 0x0c}: "EfiPlatformTypeOpalCitySthiProtocol",
		efi.GUID{0x82, 0xad, 0x8a, 0x22, 0x50, 0xe1, 0x88, 0x42, 0xb1, 0x76, 0xa1, 0xaa, 0xd7, 0x7d, 0x78, 0x3e}: "FjIbvTraceAbstractionDxeProtocol",
		efi.GUID{0x82, 0xb3, 0x68, 0xc4, 0x50, 0x45, 0x09, 0x49, 0xad, 0x57, 0x24, 0x96, 0x14, 0x1b, 0x3f, 0x4a}: "AsrockRaidX64",
		efi.GUID{0x82, 0xb4, 0x95, 0xf8, 0x70, 0x19, 0xa7, 0x49, 0x84, 0xf5, 0x72, 0x39, 0x78, 0x08, 0x66, 0x42}: "DellFlashUpdate2Dxe",
		efi.GUID{0x82, 0xbb, 0x8b, 0x3d, 0x53, 0xb1, 0xaf, 0x4b, 0xab, 0x64, 0x09, 0xe7, 0xf9, 0x78, 0x58, 0x77}: "FjNuvotonNct5581Smm",
		efi.GUID{0x82, 0xbf, 0xde, 0xad, 0x60, 0xa5, 0xb9, 0x46, 0xa2, 0x80, 0x78, 0xc6, 0xab, 0x61, 0xae, 0xda}: "ErrorManager",
		efi.GUID{0x82, 0xc4, 0x26, 0xba, 0xde, 0xc1, 0x97, 0x4b, 0xa8, 0xbd, 0x16, 0x0d, 0xfd, 0xb9, 0x84, 0xac}: "FchPromontoryGpioDxe",
		efi.GUID{0x82, 0xcc, 0x2a, 0x06, 0x1e, 0x1d, 0x61, 0x4f, 0xaa, 0x94, 0x8b, 0x0c, 0x47, 0x23, 0x6a, 0x3d}: "BootScriptSaveOnS3SaveStateThunk",
		efi.GUID{0x82, 0xe4, 0xea, 0x2d, 0x96, 0x57, 0xf2, 0x40, 0x8d, 0xf5, 0xd8, 0x74, 0x19, 0xd6, 0xf3, 0x62}: "ASUSHDDPW",
		efi.GUID{0x82, 0xf0, 0x4c, 0xa3, 0x50, 0x0f, 0x0d, 0x4f, 0x89, 0x8a, 0x3d, 0x39, 0x30, 0x2b, 0xc5, 0x1e}: "IntelFsp2WrapperTokenSpaceGuid",
		efi.GUID{0x82, 0xf1, 0x6c, 0x41, 0x5f, 0x4a, 0x21, 0x4f, 0x91, 0x9a, 0x01, 0x61, 0xd8, 0x37, 0x18, 0x1e}: "POSTCODE0A_DUALACCELEROMETERWMI_SMM",
		efi.GUID{0x82, 0xf5, 0x19, 0x04, 0x25, 0x06, 0x31, 0x45, 0x8a, 0x33, 0x85, 0xa9, 0x96, 0x5c, 0x95, 0xbc}: "WinNtBusDriverGuid",
		efi.GUID{0x82, 0xf5, 0xcb, 0xec, 0xe1, 0xee, 0xb8, 0x45, 0x89, 0x26, 0x06, 0x7f, 0x40, 0xb3, 0xe5, 0x5e}: "LenovoIsscPei",
		efi.GUID{0x82, 0xfa, 0xc9, 0xb6, 0x26, 0x9b, 0xe9, 0x4b, 0x8c, 0x40, 0x87, 0xa3, 0x70, 0xe4, 0x83, 0x65}: "AmiPlatformWrapperPei",
		efi.GUID{0x82, 0xfc, 0xc3, 0x35, 0x67, 0x17, 0xe9, 0x40, 0x89, 0xa7, 0x9a, 0x1c, 0xf2, 0x3a, 0x8e, 0xf9}: "AaeonPowerModeSmm",
		efi.GUID{0x82, 0xff, 0x5d, 0x75, 0xbe, 0x93, 0x9f, 0x4e, 0x89, 0x1f, 0x95, 0x59, 0x09, 0xd1, 0xea, 0x19}: "RtkUndiDxeDriver",
		efi.GUID{0x83, 0x0d, 0xaf, 0x11, 0x84, 0x07, 0x1e, 0x4c, 0x9a, 0x1b, 0x9c, 0xf4, 0x31, 0x27, 0x55, 0x5e}: "CrbModernStandby",
		efi.GUID{0x83, 0x15, 0x16, 0x05, 0xb3, 0x2a, 0xd1, 0x43, 0x80, 0x87, 0xe8, 0x90, 0x99, 0x7b, 0x0f, 0x80}: "DellPlatformFlexBay",
		efi.GUID{0x83, 0x22, 0x51, 0xec, 0xe2, 0xda, 0xd7, 0x48, 0xab, 0xb3, 0x95, 0xc1, 0xad, 0x78, 0xb5, 0x96}: "NvdimmSmbusCommon",
		efi.GUID{0x83, 0x29, 0xd5, 0xc2, 0x1b, 0x0b, 0x98, 0x4c, 0x97, 0xf7, 0xf7, 0x56, 0xc5, 0x37, 0x07, 0x63}: "TimeAlarmDevDxe",
		efi.GUID{0x83, 0x2a, 0xfd, 0x80, 0xaf, 0xb5, 0x67, 0x4a, 0x88, 0xbd, 0x08, 0x38, 0x8b, 0xdf, 0x1a, 0xdf}: "DellTcg2ServicesDxe",
		efi.GUID{0x83, 0x2b, 0xad, 0x30, 0xd0, 0xad, 0x4b, 0x41, 0xb1, 0x1c, 0xf9, 0x3c, 0xc1, 0xd0, 0xb7, 0x9b}: "AmiProcessTcgPpiRequestGuid",
		efi.GUID{0x83, 0x30, 0x63, 0x66, 0x16, 0x3f, 0xb2, 0x43, 0x8e, 0xd2, 0x80, 0x1a, 0x2e, 0xdc, 0x38, 0x24}: "DashBiosManagerDxe",
		efi.GUID{0x83, 0x30, 0xad, 0x61, 0xad, 0xdc, 0x50, 0x48, 0xa5, 0x0c, 0x73, 0xb2, 0x3b, 0x3b, 0x14, 0xf9}: "IsaIoDxe",
		efi.GUID{0x83, 0x38, 0xa7, 0x2c, 0x65, 0x7b, 0x20, 0x41, 0x87, 0xd1, 0x59, 0xf6, 0x89, 0xc3, 0xca, 0x3d}: "AsusEcSmmCallback",
		efi.GUID{0x83, 0x38, 0xbc, 0x67, 0x79, 0x7e, 0xc1, 0x4b, 0xa3, 0x3e, 0x3a, 0xf7, 0xd1, 0x75, 0x89, 0xba}: "AmiHddPowerMgmtProtocolGuid",
		efi.GUID{0x83, 0x3f, 0x97, 0x8e, 0xca, 0xab, 0xe4, 0x49, 0xa9, 0x40, 0x4e, 0xad, 0x5a, 0x6d, 0x8a, 0x1e}: "LenovoNationalLpcPc87393",
		efi.GUID{0x83, 0x4a, 0x6b, 0x8a, 0xfe, 0x42, 0xd2, 0x45, 0xa2, 0xef, 0x46, 0xf0, 0x6c, 0x7d, 0x98, 0x52}: "EfiUserCredentialClassSecureCardGuid",
		efi.GUID{0x83, 0x4e, 0x71, 0xc8, 0x5e, 0x89, 0x92, 0x41, 0xff, 0xff, 0xff, 0xff, 0x29, 0x36, 0x30, 0xb3}: "XnoteRecoveryLauncher",
		efi.GUID{0x83, 0x5b, 0xa4, 0x99, 0xfb, 0x0b, 0x38, 0x4c, 0x88, 0x35, 0xd5, 0x95, 0x71, 0x01, 0x01, 0x03}: "MAPS_DiagLEDDxe",
		efi.GUID{0x83, 0x99, 0x5d, 0xda, 0x3c, 0x03, 0x23, 0x48, 0x93, 0x49, 0x8b, 0x1b, 0x6a, 0x79, 0x80, 0x30}: "LenovoSystemStatusCodeGenericSmm",
		efi.GUID{0x83, 0x9a, 0xe3, 0x79, 0x13, 0xd0, 0x2e, 0x4b, 0x83, 0x6a, 0xa9, 0x9a, 0x71, 0x47, 0x35, 0x1c}: "DellPbaScardDxe",
		efi.GUID{0x83, 0xa1, 0xca, 0xb1, 0x67, 0xfa, 0xf5, 0x44, 0x8d, 0x77, 0xb5, 0x28, 0xc3, 0x09, 0x20, 0x7e}: "DxeDbgModuleLocator",
		efi.GUID{0x83, 0xa5, 0x04, 0x7c, 0x3e, 0x9e, 0x1c, 0x4f, 0xad, 0x65, 0xe0, 0x52, 0x68, 0xd0, 0xb4, 0xd1}: "FullShell",
		efi.GUID{0x83, 0xb0, 0x4c, 0xa7, 0x30, 0xc6, 0x9f, 0x47, 0x9e, 0xcf, 0xad, 0xba, 0xfd, 0x2f, 0x17, 0x04}: "BlueToothPei",
		efi.GUID{0x83, 0xb2, 0x54, 0xdc, 0x77, 0x1a, 0xd6, 0x4c, 0x83, 0xbb, 0xfd, 0xda, 0x46, 0x9a, 0x2e, 0xc6}: "EdkiiPeiUfsHostControllerPpiGuid",
		efi.GUID{0x83, 0xb4, 0x59, 0x5f, 0xa4, 0x73, 0x07, 0x45, 0xac, 0x11, 0xa1, 0xd2, 0x6e, 0xfa, 0x18, 0x7b}: "SmbiosProcessorDxe",
		efi.GUID{0x83, 0xb4, 0xe1, 0x6e, 0xb8, 0xa9, 0xaf, 0x4e, 0x9a, 0xe1, 0x3b, 0x28, 0xc5, 0xcf, 0xf3, 0x6b}: "SkipTpmStartupGuid",
		efi.GUID{0x83, 0xc4, 0xad, 0x21, 0x1f, 0x02, 0x3b, 0x4f, 0x8d, 0xce, 0x61, 0x3c, 0xc9, 0x81, 0xa2, 0x69}: "menu_dots_selected",
		efi.GUID{0x83, 0xca, 0x95, 0x65, 0x11, 0x8d, 0xa5, 0x4b, 0xbd, 0xd1, 0x92, 0x87, 0x98, 0x64, 0xd3, 0x20}: "PiSmmCpuDxeSmm",
		efi.GUID{0x83, 0xca, 0xf7, 0x71, 0xc5, 0x96, 0x42, 0x47, 0xba, 0xa2, 0x76, 0xb8, 0x07, 0xa0, 0x6b, 0x95}: "SctGopVbeBltBin",
		efi.GUID{0x83, 0xd7, 0x1c, 0x92, 0x22, 0x3e, 0x79, 0x45, 0xa7, 0x1f, 0x00, 0xd7, 0x41, 0x97, 0xfc, 0xc8}: "HeciSmm",
		efi.GUID{0x83, 0xd7, 0x1c, 0x92, 0x22, 0x3e, 0x79, 0x45, 0xa7, 0x1f, 0x00, 0xd7, 0x41, 0x97, 0xfc, 0xc9}: "SpsSmm",
		efi.GUID{0x83, 0xde, 0x8b, 0x7c, 0x3e, 0x9e, 0x1c, 0x4f, 0xad, 0x65, 0xe0, 0x52, 0x68, 0xd0, 0xb4, 0xd1}: "RealtekUndi",
		efi.GUID{0x83, 0xf0, 0xb3, 0xfb, 0x87, 0x57, 0xaf, 0x45, 0xba, 0xdc, 0x66, 0x48, 0x54, 0x10, 0x0f, 0x20}: "FitDiagnostics",
		efi.GUID{0x83, 0xf5, 0x54, 0xcc, 0x9e, 0x3f, 0xb0, 0x4a, 0x9f, 0x7c, 0xd2, 0xc7, 0xed, 0x1c, 0x87, 0xa5}: "AppleRtcRam",
		efi.GUID{0x83, 0xfa, 0xdf, 0x6a, 0xae, 0x55, 0x9f, 0x4c, 0x94, 0xa4, 0x80, 0x0c, 0x46, 0x9b, 0xda, 0xbc}: "StaticSkuDataDxeLightningRidgeEXECB2",
		efi.GUID{0x84, 0x0d, 0xd2, 0x06, 0x32, 0xa0, 0x25, 0x4e, 0x96, 0x9a, 0x34, 0x6d, 0x25, 0x5e, 0x46, 0xd1}: "CpuCsrAccess",
		efi.GUID{0x84, 0x1d, 0xc0, 0x6f, 0xc5, 0x46, 0x83, 0x4e, 0x91, 0xb7, 0xfd, 0x8f, 0xba, 0xbd, 0x7b, 0x12}: "BiosInfo",
		efi.GUID{0x84, 0x39, 0x1a, 0xbb, 0x71, 0xd1, 0x03, 0x40, 0x90, 0x94, 0x46, 0xaf, 0x86, 0x6b, 0x45, 0xa2}: "IconPasswordLock",
		efi.GUID{0x84, 0x43, 0x4b, 0x52, 0x32, 0xd6, 0x62, 0x48, 0x9d, 0x3a, 0x6d, 0x82, 0xc9, 0xe8, 0x58, 0x25}: "SystemInventoryInfo",
		efi.GUID{0x84, 0x46, 0x2b, 0xa4, 0xea, 0x26, 0xd0, 0x40, 0xaa, 0x38, 0x94, 0xc2, 0x1c, 0x3c, 0x4e, 0x59}: "ATIPwrXPEI",
		efi.GUID{0x84, 0x4b, 0x30, 0xf6, 0x97, 0x79, 0xe8, 0x45, 0x90, 0x1d, 0x54, 0xd0, 0xd4, 0x95, 0x73, 0x7f}: "FjIbvRestoreConfigurationDataDxe",
		efi.GUID{0x84, 0x62, 0xd5, 0xce, 0xac, 0xcd, 0x9c, 0x49, 0x9f, 0xed, 0x69, 0xa9, 0x44, 0xce, 0x26, 0xcd}: "EcIoPeim",
		efi.GUID{0x84, 0x72, 0x64, 0xe9, 0xd5, 0x02, 0x86, 0x44, 0xa3, 0x4c, 0x90, 0x7f, 0x3d, 0x04, 0xbc, 0xa4}: "UsbS5Wakeup",
		efi.GUID{0x84, 0x7b, 0x22, 0x0b, 0x66, 0x94, 0xbd, 0x46, 0x8a, 0xba, 0x8e, 0xea, 0x99, 0xfa, 0xd2, 0x2c}: "AsusEcNvramDxe",
		efi.GUID{0x84, 0x7b, 0x3d, 0x61, 0x74, 0xf7, 0x7f, 0x49, 0x9a, 0x18, 0x6c, 0x0e, 0xd7, 0x8d, 0x13, 0x9d}: "SystemDefaultVariableProviderPei",
		efi.GUID{0x84, 0x7f, 0x8b, 0xc5, 0xa7, 0xff, 0x12, 0x41, 0x80, 0x97, 0xc7, 0x65, 0xcf, 0x75, 0x15, 0xc8}: "OemGetEdid",
		efi.GUID{0x84, 0x82, 0xbd, 0x0a, 0xa3, 0x6d, 0x16, 0x46, 0x97, 0x1a, 0x83, 0xa5, 0x14, 0x80, 0x67, 0xba}: "IsaFloppyDxe",
		efi.GUID{0x84, 0x85, 0xde, 0x66, 0x01, 0xde, 0xab, 0x4b, 0xb5, 0xd0, 0x8b, 0x99, 0x59, 0x43, 0x72, 0xfc}: "IchUhciPei",
		efi.GUID{0x84, 0x90, 0xa3, 0xbe, 0x4a, 0x04, 0x88, 0x4c, 0x87, 0x63, 0x2b, 0xfa, 0xff, 0xa8, 0x95, 0x0c}: "LTEB",
		efi.GUID{0x84, 0x90, 0xd0, 0xb5, 0xad, 0x80, 0x59, 0x47, 0xb5, 0x1c, 0x27, 0x54, 0x8a, 0xfb, 0x8b, 0x8d}: "EfiGpioProtocol",
		efi.GUID{0x84, 0x98, 0xb7, 0x44, 0xf6, 0x59, 0x5f, 0x4d, 0x86, 0x9a, 0x8c, 0x54, 0x36, 0xe0, 0x9e, 0xb9}: "ADLINK_PsuAtAtxModeSwitch",
		efi.GUID{0x84, 0x9f, 0x49, 0x67, 0xe5, 0xf2, 0xd2, 0x4d, 0x9e, 0x56, 0xc6, 0xe3, 0x89, 0xdd, 0x61, 0x73}: "DellRtcAutoOnSmm",
		efi.GUID{0x84, 0xa5, 0x5a, 0x49, 0xd4, 0x63, 0xf0, 0x45, 0xa4, 0xef, 0x36, 0x04, 0x2b, 0x19, 0xa2, 0x01}: "AppleVariablePolicy",
		efi.GUID{0x84, 0xb0, 0x00, 0x0e, 0x16, 0x2d, 0x27, 0x4a, 0xb1, 0x72, 0xb1, 0xf6, 0x8c, 0x2c, 0xc5, 0x5d}: "MicrocodeUpdates",
		efi.GUID{0x84, 0xb1, 0x46, 0xc1, 0x91, 0x88, 0xd3, 0x49, 0xb7, 0x34, 0xca, 0xcd, 0xd8, 0x4f, 0xc9, 0x42}: "ATH9K_UndiLayer",
		efi.GUID{0x84, 0xb4, 0xa4, 0xf3, 0x26, 0x9b, 0xea, 0x4e, 0x90, 0xe5, 0xa2, 0x06, 0x54, 0x0c, 0xa5, 0x25}: "EfiPciIovPlatformProtocol",
		efi.GUID{0x84, 0xba, 0xb8, 0x09, 0xd3, 0x3d, 0xa6, 0x49, 0xa0, 0x5a, 0x31, 0x34, 0xa5, 0xf0, 0x7b, 0xad}: "ArmScmiPerformanceProtocol",
		efi.GUID{0x84, 0xce, 0x44, 0x7b, 0xf2, 0x91, 0x19, 0x4c, 0xa1, 0xd3, 0x33, 0x18, 0x5a, 0x65, 0x8d, 0xaf}: "FjS5WakeDxe",
		efi.GUID{0x84, 0xd1, 0x07, 0x7b, 0xd0, 0x02, 0xfd, 0x4b, 0xad, 0x6e, 0x55, 0x4c, 0x39, 0x35, 0x3a, 0x13}: "LenovoSysConfigReqDxe",
		efi.GUID{0x84, 0xd1, 0xcd, 0x67, 0xd9, 0xc0, 0x58, 0x43, 0xb3, 0x76, 0x33, 0x0b, 0xf6, 0x7d, 0x01, 0xad}: "HpCommonFlashInfoSmm",
		efi.GUID{0x84, 0xd5, 0x90, 0xb5, 0x47, 0xa9, 0x88, 0x48, 0xb4, 0x68, 0x0a, 0x44, 0x93, 0x09, 0xa1, 0x0f}: "FchS3SaveDxe",
		efi.GUID{0x84, 0xdc, 0x4f, 0x46, 0x3f, 0xd5, 0x7b, 0x4a, 0xb4, 0x91, 0x87, 0x99, 0x12, 0x28, 0xf0, 0x8b}: "FjUsbDeviceDxe",
		efi.GUID{0x84, 0xde, 0x5f, 0x46, 0xb0, 0xe8, 0x4b, 0xb0, 0xa8, 0x43, 0xa0, 0x3f, 0x68, 0xf6, 0x17, 0xa9}: "ThunkPpiList",
		efi.GUID{0x84, 0xe5, 0x5b, 0xf7, 0x2d, 0x34, 0xd2, 0x44, 0x98, 0x19, 0x36, 0x64, 0x1e, 0x8d, 0x01, 0x07}: "GetFmpInfo",
		efi.GUID{0x84, 0xe9, 0xbe, 0x0f, 0xbf, 0x33, 0xc0, 0x4a, 0xa8, 0x71, 0xb3, 0x52, 0xad, 0x59, 0xe3, 0x37}: "DisableLTEB",
		efi.GUID{0x84, 0xed, 0x53, 0xb0, 0x0c, 0x88, 0x7e, 0x4f, 0xa5, 0x7e, 0x2c, 0x82, 0xc6, 0xe9, 0xbc, 0xbf}: "OemWlanBT",
		efi.GUID{0x84, 0xee, 0xbd, 0x22, 0x07, 0xc8, 0x2e, 0x45, 0xb5, 0x6e, 0xf6, 0x83, 0xfd, 0x76, 0xc9, 0x89}: "BuslogicDxe",
		efi.GUID{0x84, 0xf0, 0x7e, 0x66, 0xef, 0x74, 0x07, 0x47, 0x90, 0xb3, 0x75, 0x14, 0x59, 0x20, 0xb3, 0x9c}: "EfiPeiBootInNonS3ModePpi",
		efi.GUID{0x84, 0xf3, 0x64, 0x3d, 0x32, 0xca, 0xc6, 0x42, 0xa6, 0x29, 0x42, 0xa4, 0x94, 0xb2, 0xcb, 0x4a}: "TpmCapsuleDxe",
		efi.GUID{0x84, 0xf4, 0xac, 0x3d, 0xdc, 0x53, 0xd6, 0x4b, 0x84, 0xc9, 0xaa, 0x17, 0xbc, 0xf2, 0xff, 0xdc}: "PowerFailureRecoveryPei",
		efi.GUID{0x85, 0x09, 0x95, 0xd5, 0xe3, 0x8b, 0x1c, 0x4b, 0xb6, 0x3f, 0x95, 0xd1, 0x5a, 0xb3, 0xb6, 0x5f}: "SmmCpuSyncProtocol",
		efi.GUID{0x85, 0x0a, 0x6e, 0xd7, 0x08, 0x49, 0x32, 0x47, 0xbe, 0x0f, 0xbe, 0x70, 0x7e, 0xf7, 0xcb, 0x37}: "SmbiosTpmDeviceInfo",
		efi.GUID{0x85, 0x0b, 0xbf, 0x22, 0xb3, 0x4e, 0x9b, 0x47, 0xa9, 0xe9, 0xa5, 0xf7, 0xcf, 0xcc, 0xa7, 0x87}: "LenovoSmartCardDetectDxe",
		efi.GUID{0x85, 0x0d, 0x1f, 0x7e, 0xff, 0x04, 0xb2, 0x4b, 0x86, 0x6a, 0x31, 0xa2, 0x99, 0x6a, 0x48, 0xa8}: "EfiPeiFvFileLoaderPpiGuid",
		efi.GUID{0x85, 0x0d, 0xa1, 0x68, 0x58, 0x68, 0x02, 0x44, 0xb0, 0x70, 0x02, 0x8b, 0x3e, 0xa2, 0x17, 0x47}: "SpiFvbServiceSmm",
		efi.GUID{0x85, 0x2a, 0x44, 0xa6, 0x2a, 0x7e, 0x4f, 0x4a, 0xb2, 0x6b, 0x98, 0xe1, 0xe6, 0x4c, 0x22, 0x1f}: "AmdMpmSensor",
		efi.GUID{0x85, 0x38, 0xd8, 0x5a, 0x55, 0x89, 0x9b, 0x49, 0x8e, 0x9a, 0xeb, 0xc2, 0x4b, 0x6e, 0x76, 0xb1}: "AmdNbioSmuV9Dxe",
		efi.GUID{0x85, 0x38, 0xdc, 0x60, 0xcf, 0x9d, 0x8c, 0x49, 0x9a, 0x32, 0xda, 0xdb, 0x6a, 0xfa, 0x99, 0xa0}: "ErrorCodeHandlerDxe",
		efi.GUID{0x85, 0x38, 0xee, 0x67, 0xd7, 0x80, 0x94, 0x44, 0xa5, 0xfd, 0x44, 0x55, 0x27, 0xe2, 0x3f, 0x0e}: "FirmwareRollbackProtectionDynamicUpdate",
		efi.GUID{0x85, 0x46, 0x5e, 0xeb, 0x66, 0xca, 0x69, 0x47, 0xb6, 0xa2, 0x26, 0x06, 0x8b, 0x00, 0x13, 0x26}: "EfiPciDevErrorSectionGuid",
		efi.GUID{0x85, 0x48, 0x7d, 0xbf, 0xe7, 0xbe, 0xa4, 0x48, 0xbe, 0xc3, 0x2e, 0x71, 0x60, 0xa4, 0x8a, 0x0d}: "FjGabiFlashCommonEcRegionCtrlDxe",
		efi.GUID{0x85, 0x50, 0xc8, 0xa1, 0x53, 0x30, 0x4b, 0x4c, 0xa9, 0xf6, 0x72, 0x4d, 0x22, 0xa7, 0x6e, 0xf9}: "AmiLegacyTpmguid",
		efi.GUID{0x85, 0x50, 0xd6, 0xcf, 0xe1, 0xdb, 0x91, 0x46, 0x95, 0xd1, 0x85, 0x5b, 0x2c, 0xa0, 0x0c, 0x69}: "FjIbvSfuOverrideAbstractionSmmProtocol",
		efi.GUID{0x85, 0x5c, 0xb0, 0xa2, 0x5b, 0x8d, 0xf3, 0x4f, 0xb7, 0xd1, 0x8f, 0xbe, 0x92, 0xb4, 0xaa, 0x32}: "PchEvaInt15HandlerFile",
		efi.GUID{0x85, 0x5f, 0xd5, 0x57, 0x77, 0xc1, 0x84, 0x4a, 0xa2, 0xdd, 0x86, 0x68, 0xe6, 0xf0, 0x82, 0xe1}: "DellCipherSmm",
		efi.GUID{0x85, 0x62, 0x7c, 0xd4, 0x5e, 0x33, 0x14, 0x4f, 0x9c, 0xb9, 0xda, 0xb5, 0x65, 0xb7, 0xb4, 0x4b}: "SmbusDebugSmm",
		efi.GUID{0x85, 0x6f, 0xcb, 0xbb, 0x3c, 0x30, 0xb9, 0x4e, 0x81, 0x82, 0xaf, 0x98, 0xd4, 0xb3, 0x02, 0x0c}: "Tpm2DeviceLibTrEE",
		efi.GUID{0x85, 0x70, 0x3f, 0x2d, 0x63, 0xba, 0x39, 0x47, 0xa1, 0x5f, 0xc8, 0x80, 0x2b, 0x6b, 0x80, 0x7b}: "NCT3933Pei",
		efi.GUID{0x85, 0x7a, 0x82, 0x50, 0x39, 0x76, 0xe0, 0x42, 0x99, 0xe7, 0x15, 0x64, 0x05, 0xe1, 0x79, 0x0d}: "HpPlatformErrorHandler",
		efi.GUID{0x85, 0x87, 0x6e, 0xaa, 0x6e, 0x72, 0x1d, 0x44, 0xac, 0xb8, 0xf7, 0x5f, 0xb0, 0xb2, 0xb9, 0xf2}: "CoreEG2",
		efi.GUID{0x85, 0x88, 0x68, 0x51, 0x4c, 0x02, 0x9b, 0x43, 0xb3, 0xde, 0x9c, 0x08, 0xe8, 0xf5, 0x91, 0xdb}: "SmmEventLog",
		efi.GUID{0x85, 0x9d, 0x0e, 0x49, 0xef, 0x8a, 0x93, 0x41, 0x8e, 0x56, 0xf7, 0x34, 0xa9, 0xff, 0xac, 0x8b}: "PeiSerialPortPpiGuid",
		efi.GUID{0x85, 0x9f, 0xb1, 0xcc, 0x26, 0xc0, 0x85, 0x42, 0x81, 0xe9, 0x50, 0x5b, 0xf5, 0x2d, 0x27, 0x91}: "Cf9Reset",
		efi.GUID{0x85, 0xae, 0x72, 0xf6, 0x69, 0x37, 0xb8, 0x4f, 0xa5, 0xa0, 0x70, 0xb3, 0x8f, 0xb0, 0xa7, 0xc4}: "DxeTimerLibEsal",
		efi.GUID{0x85, 0xaf, 0x68, 0x76, 0xef, 0xdf, 0x57, 0x4c, 0xbc, 0xc4, 0x88, 0x07, 0xfa, 0xfe, 0x7b, 0xe9}: "TouchPadDriver",
		efi.GUID{0x85, 0xb2, 0xc1, 0x3b, 0x15, 0x8a, 0x82, 0x4a, 0xaa, 0xbf, 0x4d, 0x7d, 0x13, 0xfb, 0x32, 0x65}: "EfiBusSpecificDriverOverrideProtocolGuid",
		efi.GUID{0x85, 0xbf, 0x0b, 0x74, 0xeb, 0x47, 0xd7, 0x45, 0x90, 0x5b, 0x24, 0x44, 0x51, 0xa0, 0xfd, 0x77}: "FirebirdCheckDxe",
		efi.GUID{0x85, 0xca, 0x4a, 0xe6, 0xcf, 0xf2, 0x46, 0x22, 0x87, 0xf4, 0x92, 0xb8, 0x39, 0xcc, 0xbb, 0x78}: "SingleFile",
		efi.GUID{0x85, 0xcc, 0x77, 0x04, 0x10, 0xf6, 0xb9, 0x47, 0xb3, 0x22, 0x42, 0xe1, 0xa9, 0x3d, 0x9e, 0xe7}: "FjGpioAbstractionReferenceSmm",
		efi.GUID{0x85, 0xd2, 0x03, 0x0f, 0x14, 0x66, 0xdc, 0x4d, 0x86, 0xdc, 0xda, 0xe5, 0xe3, 0x75, 0x44, 0x3a}: "EndOfFirstPowerOn",
		efi.GUID{0x85, 0xd6, 0xbe, 0x2b, 0x33, 0x66, 0x5f, 0x45, 0xa8, 0x40, 0x43, 0xa2, 0x2b, 0x79, 0x1f, 0xff}: "AcpiFPDTSupport",
		efi.GUID{0x85, 0xd6, 0xdc, 0x5b, 0x0a, 0xd8, 0xe6, 0x42, 0x98, 0x67, 0xa8, 0x4c, 0xce, 0x7f, 0x82, 0x8e}: "TbtSmm",
		efi.GUID{0x85, 0xd6, 0xde, 0x2b, 0x33, 0xf7, 0x5f, 0x45, 0xa8, 0x40, 0x43, 0xa2, 0x2b, 0x79, 0x1f, 0xb3}: "AcpiS3SaveDxe",
		efi.GUID{0x85, 0xd8, 0x4c, 0xee, 0x04, 0xd1, 0x56, 0x40, 0x84, 0xba, 0x46, 0x18, 0x82, 0xa7, 0x2a, 0x18}: "PrmHii",
		efi.GUID{0x85, 0xe0, 0x5c, 0x90, 0xb7, 0xe8, 0x6f, 0x47, 0xb1, 0xe0, 0x63, 0xc6, 0xa4, 0x58, 0x3b, 0x5b}: "HPOA3Dxe",
		efi.GUID{0x85, 0xe9, 0x84, 0x4f, 0x3b, 0x4c, 0x25, 0x48, 0x9f, 0x42, 0x88, 0x91, 0x09, 0x01, 0x94, 0x22}: "GopConfigPei",
		efi.GUID{0x85, 0xea, 0x60, 0xe6, 0x8e, 0x05, 0x55, 0x4b, 0xa5, 0x4b, 0xf0, 0x2f, 0x83, 0xa2, 0x47, 0x07}: "DisplayEngine",
		efi.GUID{0x85, 0xf1, 0x99, 0x3c, 0x3e, 0x76, 0x34, 0x4c, 0xb4, 0x0e, 0x55, 0x80, 0xef, 0xf8, 0x65, 0xd4}: "SecureEraseLog",
		efi.GUID{0x85, 0xf5, 0xac, 0x3d, 0xdc, 0x53, 0xd6, 0x4b, 0x84, 0xc9, 0xbb, 0x37, 0xbc, 0xf2, 0xfa, 0x23}: "SerialPortSettingPei",
		efi.GUID{0x85, 0xf9, 0x63, 0x8b, 0xed, 0x5d, 0x8a, 0x44, 0x89, 0x96, 0xa0, 0x08, 0xbe, 0xd4, 0x5a, 0xa8}: "SystemDeleteSignaturesDxe",
		efi.GUID{0x86, 0x00, 0x45, 0xe9, 0xa9, 0x16, 0xd0, 0x4f, 0x91, 0x36, 0xbf, 0xd2, 0xff, 0x47, 0x82, 0x85}: "FjPcieWirelessWanSmm",
		efi.GUID{0x86, 0x05, 0xdd, 0xd3, 0x6d, 0x97, 0x9f, 0x44, 0x98, 0x37, 0x03, 0x92, 0xe9, 0x3b, 0x7d, 0x52}: "DellOsProtocolAccess",
		efi.GUID{0x86, 0x06, 0x9c, 0xdf, 0x2e, 0x2b, 0xd9, 0x49, 0x94, 0xf4, 0xa4, 0x1c, 0x47, 0xab, 0x96, 0x33}: "Hob",
		efi.GUID{0x86, 0x07, 0xea, 0xfa, 0x3e, 0xff, 0x91, 0x40, 0xa8, 0x95, 0x98, 0xe4, 0xe9, 0x11, 0x48, 0x92}: "LegacyRegionDxe",
		efi.GUID{0x86, 0x1c, 0x79, 0x16, 0xba, 0x47, 0xc7, 0xbf, 0x46, 0x8f, 0xd9, 0xb5, 0x0d, 0x50, 0x94, 0x87}: "AmdPsppControlPei",
		efi.GUID{0x86, 0x1c, 0x7b, 0x6a, 0x0e, 0x59, 0xa7, 0x47, 0x97, 0x1a, 0xc4, 0x9b, 0x40, 0x8d, 0x5e, 0xd7}: "LenovoSetupSecurityDxe",
		efi.GUID{0x86, 0x20, 0x23, 0x5b, 0x0a, 0x35, 0xc7, 0x42, 0xa7, 0x0e, 0x34, 0x97, 0xb5, 0x76, 0x5d, 0x85}: "OEMSSDT",
		efi.GUID{0x86, 0x20, 0xe1, 0xdf, 0x23, 0x53, 0xbb, 0x44, 0xbb, 0x3d, 0x70, 0x21, 0x65, 0xfc, 0xfb, 0x61}: "DellHardwareSignature",
		efi.GUID{0x86, 0x25, 0x34, 0x39, 0x0e, 0x4e, 0x33, 0x48, 0xb4, 0xba, 0x12, 0x56, 0xb0, 0xff, 0xb4, 0x71}: "FmpDxe",
		efi.GUID{0x86, 0x27, 0xbf, 0xcc, 0x6c, 0xcd, 0x08, 0x43, 0xbd, 0xfa, 0x62, 0x58, 0x70, 0xce, 0xbf, 0x81}: "AmiCmosAccessPpiGuid",
		efi.GUID{0x86, 0x30, 0x3d, 0x27, 0xa3, 0x65, 0x3d, 0x46, 0xb5, 0xd6, 0xaa, 0xc7, 0xcc, 0xc1, 0x84, 0x45}: "PlatformTcg2Dxe",
		efi.GUID{0x86, 0x35, 0x2b, 0x33, 0xb4, 0xf0, 0xee, 0x46, 0xa3, 0x9c, 0x78, 0x63, 0x30, 0xe2, 0xd3, 0x28}: "EfiFpgaHssiConfigDataProtocol",
		efi.GUID{0x86, 0x44, 0x0c, 0x39, 0x26, 0xc0, 0x83, 0x40, 0x88, 0x69, 0xd8, 0xf2, 0x60, 0xa4, 0x97, 0x60}: "OemSyncSetupRN",
		efi.GUID{0x86, 0x48, 0x1e, 0x1a, 0x17, 0x95, 0x0e, 0x44, 0x9f, 0xde, 0x3b, 0xe4, 0x4c, 0xee, 0x21, 0x36}: "CpuDxe",
		efi.GUID{0x86, 0x49, 0x01, 0x66, 0x5d, 0xa4, 0x22, 0x4c, 0x9f, 0x6b, 0x7d, 0x4e, 0xf2, 0x03, 0x8c, 0xab}: "OemHddHeadParkSmm",
		efi.GUID{0x86, 0x53, 0x37, 0x74, 0x3c, 0xda, 0xa2, 0x4f, 0xbb, 0xa2, 0xf5, 0x3e, 0x37, 0x35, 0x34, 0x22}: "AmdAcpConfigurationDxe",
		efi.GUID{0x86, 0x56, 0x02, 0x12, 0x84, 0x39, 0x6c, 0x46, 0x98, 0x0b, 0x8b, 0x5e, 0x89, 0xda, 0x03, 0x19}: "AmiReadyToLoadDxeCorePpiGuid",
		efi.GUID{0x86, 0x57, 0x3f, 0xff, 0x26, 0x70, 0x3f, 0x40, 0x9a, 0x95, 0x47, 0xf9, 0x89, 0x39, 0x12, 0x94}: "FchSmbusPei",
		efi.GUID{0x86, 0x57, 0x67, 0x65, 0xca, 0xac, 0x11, 0x4b, 0x8a, 0xb7, 0xf8, 0x43, 0xaa, 0x2a, 0x8b, 0xea}: "WdtHob",
		efi.GUID{0x86, 0x60, 0x4a, 0x29, 0x5a, 0x13, 0xd9, 0x4a, 0xa8, 0x9a, 0x56, 0xd5, 0xa3, 0x27, 0xf0, 0xe2}: "NbWrapperPei",
		efi.GUID{0x86, 0x60, 0xaa, 0x79, 0x5a, 0x03, 0xd9, 0x4a, 0xa8, 0x9a, 0xa6, 0xd5, 0xaa, 0x27, 0xf0, 0xe2}: "NbPei",
		efi.GUID{0x86, 0x63, 0x44, 0xbd, 0x8a, 0x7f, 0xe1, 0x4e, 0xa0, 0x14, 0x8d, 0x3b, 0xab, 0x92, 0xb4, 0xe9}: "EmulationPlatformInit",
		efi.GUID{0x86, 0x65, 0xc7, 0xba, 0x15, 0x35, 0x0b, 0x42, 0xa1, 0xb7, 0x23, 0x5a, 0x71, 0x6e, 0xca, 0xad}: "OutOfBand",
		efi.GUID{0x86, 0x7a, 0xc2, 0x33, 0x39, 0x0a, 0xda, 0x48, 0x94, 0x24, 0x68, 0x13, 0xe5, 0xc3, 0x93, 0x9d}: "A31CMFCDxe",
		efi.GUID{0x86, 0x7b, 0xc2, 0x33, 0x39, 0x0a, 0xda, 0x48, 0x94, 0x97, 0x68, 0xa3, 0xe5, 0xc3, 0x92, 0x8d}: "CompalPlatformHookDxe",
		efi.GUID{0x86, 0x87, 0x3b, 0x64, 0x17, 0xb4, 0xd2, 0x48, 0x8f, 0x5e, 0x78, 0x19, 0x93, 0x1c, 0xae, 0xd8}: "PeiInMemory",
		efi.GUID{0x86, 0x88, 0x6d, 0x73, 0x2b, 0x6d, 0x84, 0x46, 0xad, 0xde, 0x84, 0xbf, 0xab, 0x0f, 0x27, 0x37}: "SmiFlashLibs",
		efi.GUID{0x86, 0x8a, 0xc2, 0x39, 0x97, 0x90, 0xda, 0x48, 0xb4, 0x24, 0x6c, 0x13, 0xe3, 0xd3, 0x91, 0xfa}: "CompalEcDxe",
		efi.GUID{0x86, 0x8a, 0xc2, 0x39, 0x97, 0x91, 0x1a, 0x48, 0xb4, 0x24, 0x6c, 0x13, 0xe3, 0xd3, 0x91, 0xfa}: "CompalEcSmm",
		efi.GUID{0x86, 0x92, 0xc2, 0x23, 0x7d, 0x94, 0x70, 0x42, 0xb0, 0x61, 0x7f, 0xe5, 0xd0, 0x75, 0x8b, 0x63}: "Legacy2Region",
		efi.GUID{0x86, 0x93, 0xd8, 0x8c, 0x97, 0xc8, 0x98, 0x30, 0x96, 0x87, 0xc4, 0x6a, 0x5b, 0x7d, 0xec, 0x05}: "AmdCpmManageabilityDxe",
		efi.GUID{0x86, 0x9e, 0x79, 0x1b, 0xcc, 0x28, 0xbf, 0x4d, 0xa7, 0x63, 0xf7, 0xf3, 0x3f, 0xfd, 0x27, 0x72}: "SmuV13Dxe",
		efi.GUID{0x86, 0xa9, 0x34, 0xe2, 0x46, 0x89, 0x5d, 0x48, 0xa6, 0x45, 0xc8, 0x06, 0x22, 0x5f, 0x02, 0x13}: "BiosDiags_2_0",
		efi.GUID{0x86, 0xac, 0x69, 0xe2, 0x49, 0x60, 0x09, 0x45, 0x8d, 0x16, 0x88, 0x99, 0xda, 0x52, 0x9b, 0xbb}: "PeiCmosInit",
		efi.GUID{0x86, 0xb0, 0x26, 0xc8, 0x21, 0xae, 0x6c, 0x41, 0x99, 0x77, 0x0d, 0x55, 0xaa, 0xe7, 0x42, 0xb4}: "EcAuditLogPei",
		efi.GUID{0x86, 0xb1, 0x25, 0xb6, 0x63, 0xe0, 0xf7, 0x44, 0x89, 0x05, 0x6a, 0x74, 0xdc, 0x6f, 0x52, 0xb4}: "EfiDns4ServiceBindingProtocolGuid",
		efi.GUID{0x86, 0xb4, 0xc9, 0xde, 0x16, 0x1f, 0xc7, 0x47, 0x8f, 0x68, 0xdf, 0x1a, 0x41, 0x88, 0x8b, 0xa5}: "UefiOvmfPkgPlatformInfo",
		efi.GUID{0x86, 0xb8, 0x71, 0x14, 0x1f, 0xa0, 0x35, 0x48, 0x90, 0x3c, 0x5c, 0x7e, 0x79, 0x20, 0x75, 0xc2}: "OememPei",
		efi.GUID{0x86, 0xbe, 0xaf, 0x15, 0xf9, 0xe7, 0xf9, 0x42, 0xa0, 0x2d, 0xe9, 0x50, 0x43, 0xe6, 0x2f, 0x98}: "AdlSmbios",
		efi.GUID{0x86, 0xc9, 0x52, 0x9d, 0x16, 0x0b, 0x0a, 0x42, 0x8d, 0x4d, 0xd2, 0xea, 0xeb, 0x59, 0x3d, 0xbf}: "AssetIDDxeProtocol",
		efi.GUID{0x86, 0xc9, 0x6c, 0xab, 0x03, 0x8d, 0x0c, 0x40, 0x9f, 0xa3, 0x96, 0x60, 0x9c, 0x3b, 0x7b, 0xd3}: "AmiUsbInterface",
		efi.GUID{0x86, 0xd4, 0x8d, 0x58, 0x41, 0x66, 0x8e, 0x45, 0x82, 0xa7, 0x5c, 0xbe, 0xb8, 0x60, 0x21, 0x11}: "AmdCpmOemInitPeim",
		efi.GUID{0x86, 0xd4, 0x8d, 0x58, 0x41, 0x66, 0x8e, 0x45, 0x82, 0xa7, 0x5c, 0xbe, 0xb8, 0x60, 0x2f, 0x30}: "AmdCpmOemInitPeim",
		efi.GUID{0x86, 0xd9, 0x1f, 0x04, 0x16, 0xb0, 0xce, 0x47, 0xaf, 0xc5, 0x22, 0x69, 0xed, 0xd4, 0xad, 0x64}: "ACPIS4Dxe",
		efi.GUID{0x86, 0xde, 0x59, 0xd3, 0x1b, 0x0a, 0xbc, 0x47, 0x95, 0xd2, 0x1d, 0x1f, 0x8f, 0xff, 0x0a, 0xd8}: "ChipsetSvcSmm",
		efi.GUID{0x86, 0xe4, 0x41, 0x61, 0x43, 0x75, 0x1a, 0x4f, 0xa5, 0x79, 0xff, 0x53, 0x2e, 0xd7, 0x8e, 0x75}: "ResetSystemPei",
		efi.GUID{0x86, 0xe5, 0xb2, 0x08, 0xa8, 0x35, 0x3f, 0x4a, 0xa9, 0xed, 0xe4, 0x81, 0x34, 0x89, 0x16, 0x01}: "SmcInBandSmm",
		efi.GUID{0x86, 0xe8, 0x59, 0x05, 0x78, 0xac, 0xcc, 0x4b, 0x89, 0x9a, 0xe7, 0x83, 0x0b, 0x5d, 0x64, 0x62}: "SystemSmbiosBcpSmm",
		efi.GUID{0x86, 0xf2, 0x7f, 0x26, 0x86, 0xb2, 0xb5, 0x41, 0xae, 0x00, 0x95, 0x1e, 0xe5, 0xd3, 0x9d, 0x09}: "BctBaseSmmRMB",
		efi.GUID{0x86, 0xf7, 0x5e, 0x0f, 0xa0, 0x17, 0xc6, 0x40, 0xbc, 0x18, 0x1b, 0x32, 0x72, 0xa0, 0x09, 0x87}: "IccInit",
		efi.GUID{0x86, 0xf7, 0x95, 0x61, 0xb1, 0xd7, 0xf1, 0x45, 0x9a, 0xc7, 0x82, 0xef, 0x97, 0x6a, 0xdf, 0x4c}: "SmcNVDIMMSmmDriver",
		efi.GUID{0x86, 0xfb, 0x0f, 0xa8, 0xac, 0x4c, 0x76, 0x4d, 0x80, 0xed, 0x25, 0xf6, 0x20, 0x54, 0xad, 0x87}: "WifiConnectionManagerDxe",
		efi.GUID{0x86, 0xff, 0x40, 0x08, 0x90, 0xf6, 0xd8, 0x4f, 0xa8, 0x91, 0x8b, 0xf9, 0x44, 0xb0, 0xf3, 0x24}: "DellSmmKeyboardBacklightProtocol",
		efi.GUID{0x87, 0x0d, 0x11, 0x69, 0xb3, 0x9b, 0xfc, 0x47, 0xb4, 0x12, 0x22, 0xe4, 0xf1, 0x35, 0xae, 0x38}: "AmdCpmMemEyeToolDxe",
		efi.GUID{0x87, 0x0d, 0x1d, 0x97, 0xd1, 0x78, 0x65, 0x4c, 0xa8, 0x36, 0xa4, 0x20, 0xdc, 0xac, 0x20, 0x28}: "DellAmdArchDepexDxe",
		efi.GUID{0x87, 0x12, 0x99, 0x84, 0xf0, 0x3f, 0xcc, 0x4f, 0x9c, 0x11, 0xc7, 0xe0, 0x41, 0x86, 0x2c, 0x76}: "DellPowerManagementDxe",
		efi.GUID{0x87, 0x16, 0x85, 0x6e, 0xa9, 0xa7, 0xa2, 0x4a, 0x8d, 0xd0, 0x67, 0x3e, 0x03, 0xe5, 0x14, 0x33}: "SetSockOpt",
		efi.GUID{0x87, 0x1a, 0x35, 0xa6, 0x65, 0x29, 0x18, 0x47, 0x88, 0xc7, 0x0b, 0x5b, 0x5a, 0xc0, 0xb5, 0xe4}: "AmiMrcInfoHob",
		efi.GUID{0x87, 0x24, 0x66, 0x5a, 0x49, 0x07, 0x63, 0x41, 0xa9, 0xa0, 0xc2, 0x9c, 0x39, 0x5f, 0x65, 0x03}: "OemDMIUpdate",
		efi.GUID{0x87, 0x27, 0x70, 0x9e, 0x60, 0xc7, 0xed, 0x4c, 0xbf, 0x46, 0xed, 0xc4, 0x28, 0xf1, 0x82, 0xee}: "GopOverrideDriver",
		efi.GUID{0x87, 0x34, 0xf0, 0xa3, 0xc5, 0x9f, 0xdc, 0x4d, 0x9a, 0x44, 0x4b, 0x61, 0xb4, 0xd2, 0x76, 0xd8}: "FjCapsuleUpdateDxe",
		efi.GUID{0x87, 0x3b, 0xa1, 0x57, 0x3d, 0x13, 0xf3, 0x4b, 0xbf, 0xf1, 0x1b, 0xca, 0xc7, 0x17, 0x6c, 0xf1}: "EdkiiTcgPpi",
		efi.GUID{0x87, 0x48, 0x02, 0x0d, 0x89, 0xb4, 0x9f, 0x4e, 0x88, 0x4b, 0xa4, 0xb6, 0xbb, 0x8a, 0x57, 0x6b}: "ODMCompuTraceDxe",
		efi.GUID{0x87, 0x4e, 0x87, 0xdf, 0xc5, 0xff, 0x5d, 0x4c, 0x8b, 0x1e, 0x81, 0xee, 0x01, 0xa6, 0xd4, 0x35}: "SetupLoadDefaultPei",
		efi.GUID{0x87, 0x4f, 0x82, 0x2c, 0x2c, 0x0f, 0xd7, 0x45, 0x81, 0xa6, 0x4f, 0x39, 0xe0, 0x42, 0xbd, 0xdf}: "EfiPlatformTypeHedtCrbProtocol",
		efi.GUID{0x87, 0x5b, 0x1c, 0x50, 0x81, 0x81, 0xe5, 0x4a, 0xa6, 0xb2, 0xd0, 0x5a, 0xce, 0x0d, 0x83, 0xde}: "SmcOobPlatformPolicyCallback",
		efi.GUID{0x87, 0x5b, 0x46, 0xda, 0x6f, 0xa2, 0x12, 0x4c, 0xb7, 0x8a, 0x03, 0x61, 0x42, 0x8f, 0xa0, 0x26}: "AssetQrCode",
		efi.GUID{0x87, 0x63, 0xf7, 0x17, 0x12, 0xde, 0x59, 0x4e, 0xa1, 0x07, 0x48, 0x5b, 0xb1, 0x33, 0xb4, 0xd6}: "SecureBioDxe",
		efi.GUID{0x87, 0x65, 0xf7, 0xd6, 0xca, 0x98, 0xde, 0x43, 0x9e, 0x1a, 0x59, 0xe6, 0x0d, 0x0a, 0xbe, 0x73}: "AplFakeCapsulePei",
		efi.GUID{0x87, 0x66, 0x0e, 0x72, 0xc4, 0x43, 0xea, 0x84, 0xe1, 0xb5, 0x23, 0xaa, 0xed, 0x35, 0x98, 0x40}: "IntelGbeUndi",
		efi.GUID{0x87, 0x78, 0x17, 0x51, 0x97, 0xa6, 0x6f, 0x43, 0x93, 0x7f, 0x1c, 0xdc, 0x42, 0x1a, 0x3d, 0xcb}: "AmdRasRsServiceDxe",
		efi.GUID{0x87, 0x7b, 0x35, 0xe9, 0x78, 0x38, 0x4a, 0x44, 0xa1, 0x0d, 0x67, 0x56, 0xb5, 0x42, 0xeb, 0xe7}: "JpegDecoder",
		efi.GUID{0x87, 0x7d, 0xba, 0x44, 0x96, 0xfd, 0xb8, 0x45, 0x93, 0xd3, 0xa8, 0xa0, 0xa9, 0x4d, 0x09, 0x85}: "AmtConfig",
		efi.GUID{0x87, 0x7f, 0x36, 0x87, 0x19, 0x11, 0xce, 0x41, 0xaa, 0xec, 0x8b, 0xe0, 0x11, 0x1f, 0x55, 0x8a}: "EfiJsonConfigDataTable",
		efi.GUID{0x87, 0x80, 0x9a, 0x6c, 0x8e, 0xb6, 0x3d, 0x4f, 0xb8, 0x7d, 0xa7, 0x6c, 0x82, 0x9c, 0x7d, 0x3e}: "CcgxDiscoverySmm",
		efi.GUID{0x87, 0x82, 0xe4, 0xf1, 0xe1, 0x3f, 0x35, 0x45, 0x89, 0xab, 0x48, 0xd6, 0xc3, 0xda, 0x27, 0x59}: "EfiHotKeysProtocol",
		efi.GUID{0x87, 0x86, 0x4f, 0x3a, 0xf0, 0x0a, 0x39, 0x4f, 0x87, 0xcf, 0x8a, 0x2d, 0xe9, 0x7a, 0xb3, 0xdb}: "PasswordMgrSmm",
		efi.GUID{0x87, 0x87, 0xe2, 0x20, 0x32, 0xdf, 0xda, 0x4b, 0xb7, 0xe7, 0xcb, 0xbd, 0xa3, 0x37, 0x1e, 0xf8}: "IdeControllerProtocol",
		efi.GUID{0x87, 0x8c, 0x87, 0x31, 0x75, 0x0b, 0xd5, 0x11, 0x9a, 0x4f, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d}: "EfiSimplePointerProtocolGuid",
		efi.GUID{0x87, 0x90, 0xc5, 0xb5, 0xac, 0xfe, 0x41, 0x4b, 0x9d, 0x80, 0x79, 0x0b, 0xa5, 0xaa, 0x07, 0x0f}: "FwVersion",
		efi.GUID{0x87, 0x95, 0x1a, 0xb8, 0xd1, 0xd1, 0x8e, 0x41, 0xcc, 0xcf, 0x50, 0x8d, 0xaf, 0xce, 0x4d, 0x8c}: "GraphicsConfigurationDefaultsSmm",
		efi.GUID{0x87, 0x97, 0xea, 0xc7, 0x0a, 0xca, 0xb4, 0x43, 0xb1, 0xe5, 0x25, 0xef, 0x87, 0x39, 0x1f, 0x8d}: "PchS3Support",
		efi.GUID{0x87, 0x9c, 0xe0, 0x9f, 0xd8, 0x6f, 0x63, 0x40, 0x8e, 0xbe, 0x68, 0x09, 0xef, 0x5e, 0xab, 0xc5}: "HpCompressDecompress",
		efi.GUID{0x87, 0x9d, 0xd5, 0x57, 0xa9, 0xa2, 0x2c, 0x48, 0x8e, 0xc7, 0xd9, 0xf9, 0xfa, 0x3e, 0x20, 0xf4}: "PlatformWmiAslSupport",
		efi.GUID{0x87, 0x9d, 0xd6, 0xc3, 0x00, 0x52, 0xab, 0x4a, 0xa6, 0xdb, 0x25, 0x69, 0xba, 0x1a, 0x92, 0xfc}: "Tpm2DeviceLibRouterDxe",
		efi.GUID{0x87, 0xa8, 0xcc, 0xad, 0x30, 0x53, 0x4a, 0x41, 0x81, 0xa1, 0x5b, 0x57, 0x81, 0x46, 0xa3, 0x97}: "TgaDecoderDxe",
		efi.GUID{0x87, 0xab, 0xee, 0xa1, 0x59, 0xc8, 0x9d, 0x47, 0x89, 0xb5, 0x14, 0x61, 0xf4, 0x06, 0x1a, 0x3e}: "FspInApiModePpi",
		efi.GUID{0x87, 0xac, 0xcf, 0x27, 0xcc, 0x46, 0xd4, 0x11, 0x9a, 0x38, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d}: "EfiRealTimeClockArchProtocolGuid",
		efi.GUID{0x87, 0xc5, 0xb4, 0xf1, 0x35, 0x6e, 0xab, 0x4f, 0xb9, 0x46, 0xfa, 0xe2, 0x59, 0x63, 0x86, 0x60}: "FjGabiFlashBiosRegionCtrlDxe",
		efi.GUID{0x87, 0xcd, 0x7f, 0x2d, 0x54, 0x45, 0x64, 0x45, 0xb8, 0x11, 0x0f, 0x91, 0x67, 0xf7, 0x82, 0xb3}: "CrbAcpiPlatform",
		efi.GUID{0x87, 0xd4, 0x39, 0x63, 0xba, 0x26, 0x4b, 0x42, 0x9a, 0x5d, 0x68, 0x7e, 0x25, 0xd7, 0x40, 0xbc}: "Tcg2ConfigFormSetGuid",
		efi.GUID{0x87, 0xd7, 0x72, 0x78, 0xad, 0x4d, 0x96, 0x44, 0xbe, 0x61, 0xed, 0xb5, 0xb5, 0xf0, 0x12, 0xe7}: "SpdDataReadPei",
		efi.GUID{0x87, 0xdd, 0xff, 0x55, 0xc2, 0xf6, 0xdd, 0x49, 0xa7, 0x24, 0xf1, 0x97, 0xe6, 0x0a, 0xb0, 0x20}: "LemKeyboardLayoutProtocol",
		efi.GUID{0x87, 0xdf, 0x41, 0xb4, 0x94, 0x8d, 0x11, 0x48, 0x85, 0xf7, 0x0f, 0x9a, 0x7b, 0xf8, 0x9d, 0x2a}: "MeAlertAtHandler",
		efi.GUID{0x87, 0xe2, 0x8c, 0x03, 0x06, 0xb8, 0xb6, 0x45, 0xa8, 0x19, 0x51, 0x4d, 0xaf, 0x4b, 0x91, 0xb9}: "DellErrorLogConfig",
		efi.GUID{0x87, 0xe3, 0x59, 0xd9, 0x91, 0x7b, 0x2c, 0x45, 0x90, 0xe0, 0xa1, 0xdb, 0xac, 0x90, 0xdd, 0xb8}: "ArmPlatformPrePiUniCore",
		efi.GUID{0x87, 0xe8, 0x15, 0xba, 0xf5, 0xab, 0x8f, 0x43, 0xb8, 0x7a, 0x31, 0x10, 0xf1, 0xc8, 0xac, 0xe2}: "XhciPdoResetWA",
		efi.GUID{0x87, 0xed, 0xf7, 0xe4, 0xd5, 0x1e, 0x20, 0x47, 0xa5, 0x7d, 0x5b, 0xa0, 0x0a, 0x72, 0x75, 0x87}: "DdrtErrorHandler",
		efi.GUID{0x87, 0xfb, 0x3c, 0x8c, 0xae, 0xf7, 0x36, 0x4a, 0xaa, 0xff, 0x93, 0x1f, 0xdc, 0x5f, 0x43, 0x6e}: "AzaliaInitPei",
		efi.GUID{0x88, 0x08, 0xdc, 0xe1, 0xac, 0xc5, 0x2c, 0x4a, 0x83, 0xa5, 0x91, 0xad, 0x26, 0x96, 0x0f, 0x31}: "DellTpmPpiSmm",
		efi.GUID{0x88, 0x11, 0x57, 0xe8, 0xc1, 0x00, 0xd4, 0x4e, 0xb1, 0x4e, 0xe3, 0x84, 0x51, 0x35, 0x1e, 0xc4}: "HddPassword",
		efi.GUID{0x88, 0x11, 0xa1, 0x64, 0x86, 0x5b, 0x59, 0x4f, 0xa7, 0x02, 0x73, 0x36, 0x58, 0x96, 0xe6, 0x5e}: "AcpiVTD",
		efi.GUID{0x88, 0x16, 0x40, 0x41, 0x62, 0x28, 0x1b, 0x43, 0xba, 0xac, 0x6e, 0xca, 0xda, 0xc3, 0x84, 0xab}: "PciCfg2OnPciCfgThunk",
		efi.GUID{0x88, 0x1b, 0x91, 0xee, 0xe3, 0x39, 0x56, 0x4f, 0xb9, 0x4c, 0x64, 0xff, 0xf5, 0xb5, 0x3a, 0x3b}: "AmdCpmABRecoveryPeim",
		efi.GUID{0x88, 0x1f, 0xd4, 0xa7, 0xb8, 0x1c, 0xfb, 0x4b, 0x90, 0x1c, 0xf6, 0x8b, 0xd2, 0xa4, 0x7e, 0x9d}: "EcMeDisableDxe",
		efi.GUID{0x88, 0x35, 0x01, 0x07, 0x89, 0xc7, 0x12, 0x4e, 0xa7, 0xc3, 0x88, 0xfa, 0xfa, 0xe7, 0x9f, 0x7c}: "EfiSocketProcessorCoreVar",
		efi.GUID{0x88, 0x38, 0xc8, 0x40, 0x77, 0xa4, 0x0e, 0x49, 0xa0, 0xad, 0x7b, 0x96, 0x8c, 0xa2, 0xd7, 0x3f}: "DellVRHeatsinkDxe",
		efi.GUID{0x88, 0x3a, 0x16, 0x8f, 0x76, 0x23, 0xb3, 0x40, 0x89, 0xf7, 0xaa, 0xc7, 0x3e, 0x29, 0xe9, 0x41}: "HpRemoteDiagnosticsDriver",
		efi.GUID{0x88, 0x3d, 0xca, 0xcb, 0x1e, 0xcb, 0xc3, 0x49, 0xb4, 0x48, 0x5f, 0xf2, 0x87, 0xc5, 0x8d, 0x40}: "LenovoEn25Qh32FlashPartSmm",
		efi.GUID{0x88, 0x42, 0xce, 0x75, 0x5d, 0xde, 0x24, 0x4e, 0x90, 0xb5, 0xf7, 0x5b, 0xd7, 0x8e, 0x6b, 0xa1}: "SecureFirmwareVolumeDxe",
		efi.GUID{0x88, 0x5a, 0x4c, 0x99, 0xe2, 0xfc, 0xe5, 0x43, 0x9e, 0xa4, 0x2f, 0xab, 0xcb, 0x15, 0x30, 0x1d}: "SmmStatusCode",
		efi.GUID{0x88, 0x63, 0xb8, 0x9a, 0xf2, 0x95, 0x69, 0x4f, 0xac, 0xdc, 0xe1, 0x74, 0x9e, 0x54, 0x09, 0xf0}: "VariableCheckerSmm",
		efi.GUID{0x88, 0x6f, 0xe9, 0xe7, 0x7b, 0x01, 0x7c, 0x41, 0x8d, 0xc8, 0xb8, 0x4c, 0x2b, 0x87, 0x70, 0x20}: "BaseFspWrapperApiTestLibNull",
		efi.GUID{0x88, 0x71, 0xcc, 0x97, 0xc9, 0x79, 0x9f, 0x44, 0xb9, 0x69, 0x06, 0x5b, 0x64, 0xbf, 0x9c, 0x69}: "BiosExtensionLoader",
		efi.GUID{0x88, 0x71, 0xf1, 0x4d, 0x20, 0xf3, 0x15, 0x47, 0x82, 0xda, 0xa0, 0x5d, 0xef, 0x51, 0xf1, 0x11}: "AmdCpmOemInitPeim",
		efi.GUID{0x88, 0x71, 0xf1, 0x4d, 0x20, 0xf3, 0x15, 0x47, 0x82, 0xda, 0xa0, 0x5d, 0xef, 0x51, 0xf1, 0xd8}: "AmdCpmOemRvInitPeim",
		efi.GUID{0x88, 0x73, 0x41, 0x1b, 0xb7, 0xb6, 0x26, 0x40, 0xb8, 0x49, 0x30, 0x06, 0x04, 0x77, 0xa2, 0xad}: "BootDeviceOptionsWmi",
		efi.GUID{0x88, 0x77, 0xdf, 0xfc, 0x78, 0x78, 0xff, 0x11, 0xcc, 0x77, 0x88, 0xcc, 0xcc, 0x77, 0x88, 0xcc}: "EfiSmmRcToAptioBridge",
		efi.GUID{0x88, 0x7b, 0x4c, 0x90, 0xcf, 0x70, 0x57, 0x45, 0x90, 0x23, 0x85, 0xaa, 0x21, 0x53, 0xaa, 0xf0}: "AsusControlCenterBios",
		efi.GUID{0x88, 0x81, 0x01, 0x08, 0xcd, 0x42, 0x48, 0xbb, 0x10, 0x0f, 0x53, 0x87, 0xd5, 0x3d, 0xed, 0x3d}: "EfiPersistentVirtualCdGuid",
		efi.GUID{0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88}: "WholeFv",
		efi.GUID{0x88, 0x8f, 0x11, 0xba, 0x65, 0x5b, 0x84, 0x45, 0x9c, 0x5a, 0xc2, 0xd0, 0x87, 0xf6, 0xed, 0x1e}: "IrsiRuntimeDxe",
		efi.GUID{0x88, 0x8f, 0x7e, 0xce, 0x27, 0x9d, 0xc9, 0x46, 0xb6, 0x33, 0x21, 0xf8, 0xb8, 0x71, 0x20, 0x71}: "BaseBoardPei",
		efi.GUID{0x88, 0x91, 0x1e, 0x17, 0xd3, 0x31, 0xf5, 0x40, 0xb1, 0x0c, 0x53, 0x9b, 0x2d, 0xb9, 0x40, 0xcd}: "EfiShellPkgTokenSpaceGuid",
		efi.GUID{0x88, 0x92, 0x00, 0x2c, 0x14, 0x9c, 0xd9, 0x4a, 0x88, 0x77, 0xf0, 0xc2, 0xcb, 0xaa, 0x98, 0x93}: "HpKeyboardLayout",
		efi.GUID{0x88, 0xa0, 0x23, 0x08, 0x48, 0x12, 0x85, 0x42, 0x96, 0x16, 0x01, 0x11, 0xcc, 0x76, 0xd3, 0xc5}: "SmbusRecovery",
		efi.GUID{0x88, 0xac, 0xcf, 0x27, 0xcc, 0x46, 0xd4, 0x11, 0x9a, 0x38, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d}: "EfiResetArchProtocolGuid",
		efi.GUID{0x88, 0xc8, 0xab, 0xd2, 0x13, 0xae, 0x3b, 0x4e, 0xbc, 0xee, 0x5d, 0xe3, 0x68, 0xfa, 0x4e, 0x72}: "MsegSmramPeim",
		efi.GUID{0x88, 0xca, 0xbf, 0x12, 0x2f, 0x7a, 0xb5, 0x4a, 0x9a, 0x5d, 0xc4, 0x0c, 0xa6, 0x8b, 0xf7, 0x5f}: "BootOrderSection",
		efi.GUID{0x88, 0xcc, 0xd0, 0xf3, 0xd3, 0x1b, 0xfe, 0x4e, 0x92, 0x94, 0x42, 0x3b, 0xb4, 0x95, 0xf6, 0xc6}: "DellDaCallingInterfaceSmm",
		efi.GUID{0x88, 0xdb, 0x67, 0x64, 0x72, 0x3e, 0x88, 0x44, 0x91, 0xe8, 0x7e, 0x02, 0x8a, 0xd0, 0x8c, 0xf8}: "DellIntrusionDetectPei",
		efi.GUID{0x88, 0xf2, 0x23, 0xc7, 0xf9, 0x52, 0x80, 0x4d, 0xb6, 0x33, 0xe1, 0x52, 0xf9, 0x30, 0xa0, 0xdc}: "EfiSimpleAudioOutProtocol",
		efi.GUID{0x88, 0xf2, 0x85, 0x08, 0x8c, 0x41, 0xe1, 0x4b, 0xa6, 0xaf, 0x8b, 0xad, 0x61, 0xda, 0x08, 0xfe}: "AmiTseDriverHealthEnb",
		efi.GUID{0x88, 0xf8, 0xf8, 0xa5, 0x91, 0x71, 0x9b, 0x42, 0x81, 0xae, 0x26, 0x88, 0xf4, 0x15, 0xbd, 0x2b}: "DellSmmGpioLookupPolicy",
		efi.GUID{0x88, 0xfb, 0x83, 0x06, 0x4c, 0x66, 0xa6, 0x4b, 0x9e, 0xd4, 0x1c, 0x09, 0x16, 0xee, 0x43, 0xa4}: "UserAuthenticationDxe",
		efi.GUID{0x88, 0xfe, 0x82, 0x48, 0xc6, 0x7a, 0x8f, 0x41, 0xbe, 0xc4, 0x3a, 0xf4, 0x37, 0x3a, 0x33, 0x74}: "FjBootVariableCheck",
		efi.GUID{0x89, 0x03, 0x8f, 0xae, 0xa2, 0x6b, 0xd3, 0x47, 0x9e, 0x55, 0x80, 0xb3, 0xdd, 0x9b, 0x8a, 0x98}: "DfciMenu",
		efi.GUID{0x89, 0x04, 0xd6, 0xde, 0x9c, 0x97, 0x5a, 0x4b, 0x8e, 0xe4, 0x40, 0x68, 0xb0, 0xcc, 0x38, 0xdc}: "OpalPasswordPei",
		efi.GUID{0x89, 0x13, 0x41, 0x3d, 0x06, 0xf6, 0x5e, 0x48, 0xb7, 0xbb, 0xcb, 0x6e, 0xab, 0x46, 0x72, 0xcd}: "FjBIOSMasterPasswordBin",
		efi.GUID{0x89, 0x23, 0xad, 0x5f, 0xc7, 0x2b, 0xd2, 0x4b, 0x83, 0xd3, 0x42, 0x9f, 0xb6, 0xae, 0xa3, 0x3f}: "EfiSerialPortTokenSpaceGuid",
		efi.GUID{0x89, 0x2c, 0xb2, 0x71, 0x49, 0xb8, 0x83, 0x4d, 0x81, 0x15, 0x45, 0x63, 0xa6, 0x26, 0xac, 0x8d}: "KEMhGpioAccPei",
		efi.GUID{0x89, 0x31, 0x93, 0x9d, 0xe7, 0xee, 0x7c, 0x45, 0x98, 0x1e, 0x58, 0x1c, 0x1a, 0x63, 0x9f, 0xc3}: "AbtExtendedMessageProtocol",
		efi.GUID{0x89, 0x37, 0xde, 0x50, 0x33, 0xbd, 0xef, 0x4a, 0xb1, 0x82, 0x7f, 0xe9, 0x18, 0x3e, 0x88, 0xda}: "DellErrorHandlerSmmProtocolGuidVer2",
		efi.GUID{0x89, 0x3b, 0x6f, 0xfe, 0x17, 0x64, 0x00, 0x4f, 0xa2, 0x06, 0xea, 0x52, 0xe7, 0xd4, 0x4d, 0x3d}: "LenovoSmmAmtConfig",
		efi.GUID{0x89, 0x3f, 0xf5, 0x4d, 0x21, 0xd4, 0x9d, 0x4f, 0x83, 0x92, 0xbe, 0x3b, 0xec, 0xc6, 0x28, 0x8e}: "AhciInt13Dxe",
		efi.GUID{0x89, 0x44, 0x50, 0x6a, 0x4e, 0x88, 0x65, 0x44, 0xa0, 0x2f, 0x03, 0xb2, 0x48, 0xcd, 0xef, 0x13}: "UserInterfaceTheme",
		efi.GUID{0x89, 0x4a, 0x7f, 0xa1, 0x19, 0x5f, 0x4f, 0x44, 0xb7, 0xbe, 0x48, 0x19, 0x5e, 0x05, 0x75, 0xdb}: "SmbiosGenDxe",
		efi.GUID{0x89, 0x52, 0xb5, 0x78, 0x93, 0x53, 0x3a, 0x4a, 0x83, 0x4a, 0x11, 0x1a, 0xd7, 0x72, 0x69, 0x70}: "DellIoExpanderPca9555Smm",
		efi.GUID{0x89, 0x55, 0xd7, 0xa5, 0x9e, 0x58, 0xfb, 0x49, 0x8f, 0x93, 0xf4, 0x94, 0x28, 0x0e, 0xa1, 0xbd}: "SmbiosType140",
		efi.GUID{0x89, 0x60, 0x26, 0x5c, 0x03, 0xe1, 0x43, 0x4d, 0x9a, 0xb5, 0x12, 0xd7, 0x09, 0x5b, 0xe2, 0xaf}: "IntelSaGopDriver",
		efi.GUID{0x89, 0x60, 0x82, 0x12, 0xec, 0xd1, 0x05, 0x45, 0xb3, 0xae, 0x8e, 0x4c, 0xf3, 0xa4, 0xa7, 0x8b}: "SetBoardId",
		efi.GUID{0x89, 0x61, 0x1a, 0xc3, 0x9a, 0x63, 0x8b, 0x45, 0xb0, 0x40, 0xd7, 0xd5, 0x06, 0xca, 0x8f, 0x4f}: "GetHostByAddr",
		efi.GUID{0x89, 0x61, 0xd1, 0x57, 0x07, 0x7a, 0xfd, 0x4e, 0x97, 0x01, 0x5a, 0x19, 0xfe, 0x12, 0x0e, 0x73}: "PermanentlyRemoval",
		efi.GUID{0x89, 0x65, 0x38, 0xec, 0x9f, 0x99, 0x2d, 0x47, 0x89, 0x05, 0xca, 0xa5, 0x33, 0x2f, 0x64, 0x2a}: "H19TextColorsHook",
		efi.GUID{0x89, 0x6a, 0xf3, 0x36, 0xc3, 0x7a, 0x09, 0x4a, 0x99, 0x21, 0x89, 0x0e, 0x2c, 0x9d, 0x80, 0xa8}: "FjGabiNvramSmm",
		efi.GUID{0x89, 0x71, 0x55, 0x3f, 0xae, 0x8d, 0xae, 0x45, 0xa0, 0xb3, 0x2b, 0x99, 0xca, 0x7a, 0xa7, 0xa0}: "EfiFtwLiteProtocol",
		efi.GUID{0x89, 0x76, 0xb9, 0x08, 0xaf, 0x86, 0x36, 0x4a, 0x9e, 0x35, 0x11, 0x7b, 0x4d, 0x2e, 0xf2, 0x6a}: "AfscDxe",
		efi.GUID{0x89, 0x7a, 0x33, 0x5c, 0x08, 0xc7, 0x03, 0x4b, 0x94, 0x85, 0xc0, 0x8b, 0xca, 0x6f, 0xa8, 0xfa}: "SmmEntry64",
		efi.GUID{0x89, 0x97, 0xe6, 0xd7, 0x68, 0x1f, 0xe8, 0x45, 0x96, 0xef, 0x3b, 0x64, 0x07, 0xa5, 0xb2, 0xdc}: "EfiKmsFormatAescbc256Guid",
		efi.GUID{0x89, 0xa4, 0xe0, 0xc0, 0x6c, 0xfb, 0x09, 0x45, 0xb1, 0xb3, 0xc7, 0x11, 0x9d, 0x48, 0x95, 0x02}: "XnoteAcpiNvsSmm",
		efi.GUID{0x89, 0xaf, 0x86, 0x00, 0x1a, 0xae, 0x35, 0x44, 0xa6, 0x98, 0x08, 0x15, 0xe8, 0x50, 0xa0, 0x04}: "AsusSetupReserveVariableItem",
		efi.GUID{0x89, 0xb3, 0x74, 0x9a, 0x07, 0x96, 0x99, 0x4c, 0xbd, 0x57, 0xa2, 0xe7, 0xd2, 0x72, 0xda, 0xe1}: "DellBootMenuFlashDxe",
		efi.GUID{0x89, 0xbf, 0x6d, 0x4f, 0x7b, 0xc9, 0x60, 0x4f, 0x81, 0x78, 0x22, 0xa8, 0x2f, 0x96, 0xd0, 0x62}: "MeLockStatusDxe",
		efi.GUID{0x89, 0xbf, 0xf4, 0xda, 0x71, 0xce, 0x17, 0x49, 0xb5, 0x22, 0xc8, 0x9d, 0x32, 0xfb, 0xc5, 0x9f}: "SMBiosStaticData",
		efi.GUID{0x89, 0xc0, 0x08, 0x2f, 0x73, 0x20, 0xd9, 0x4b, 0x9e, 0x7e, 0x30, 0x8a, 0x18, 0x32, 0x7b, 0x53}: "IconWirelessSmall",
		efi.GUID{0x89, 0xcc, 0x76, 0x75, 0xa3, 0x8f, 0xad, 0x4c, 0xba, 0x02, 0x61, 0x19, 0xb4, 0x6e, 0xd4, 0x4a}: "AmiSioSmmHandoffProtocolGuid",
		efi.GUID{0x89, 0xd6, 0x72, 0x4d, 0x91, 0xcb, 0x48, 0x42, 0xa6, 0x0e, 0x33, 0x3c, 0x98, 0x27, 0x6d, 0xde}: "FjDeviceFwUpdateDxe",
		efi.GUID{0x89, 0xdc, 0xec, 0xaa, 0x49, 0x2a, 0xf1, 0x46, 0xa1, 0x63, 0xf7, 0x97, 0x9c, 0x03, 0x99, 0x98}: "IdeBusSrc",
		efi.GUID{0x89, 0xdd, 0xd4, 0x28, 0x9e, 0x16, 0xdd, 0x49, 0x84, 0x86, 0xa2, 0x00, 0xa2, 0xfd, 0x3c, 0x21}: "AmiPerformanceProfiling",
		efi.GUID{0x89, 0xe0, 0x77, 0x0a, 0x90, 0x15, 0x42, 0x44, 0xbb, 0xea, 0x11, 0x5e, 0x19, 0xe6, 0x35, 0x8a}: "EfiOsWdtPolicyProtocol",
		efi.GUID{0x89, 0xe2, 0xfa, 0x88, 0x6a, 0x0a, 0x97, 0x40, 0x9c, 0xca, 0x2b, 0xed, 0x64, 0x5b, 0x09, 0x4d}: "AplDxeIpl",
		efi.GUID{0x89, 0xe7, 0xe1, 0x2b, 0x48, 0x35, 0xb3, 0x43, 0x9e, 0xea, 0xb4, 0xc8, 0x87, 0x5e, 0x03, 0x21}: "A01ServiceBodyPei",
		efi.GUID{0x89, 0xe8, 0x37, 0x75, 0x63, 0xfc, 0xd2, 0x42, 0xb4, 0x00, 0xf7, 0x64, 0x6c, 0x45, 0xce, 0xe3}: "CastroCovePmicNvm",
		efi.GUID{0x89, 0xe8, 0x68, 0x3f, 0x77, 0xcb, 0xfc, 0x4e, 0xbc, 0x84, 0xaf, 0xa0, 0xa6, 0x4a, 0xd2, 0x6e}: "LsConnectorDxe",
		efi.GUID{0x89, 0xf4, 0x60, 0xa9, 0x73, 0x97, 0xcd, 0x40, 0x85, 0x2c, 0x55, 0x82, 0x2d, 0x53, 0x3f, 0x19}: "H19ComputraceRuntimeDxe",
		efi.GUID{0x8a, 0x07, 0x98, 0xb7, 0x0d, 0xf0, 0x90, 0x4f, 0x9d, 0xca, 0xd4, 0x32, 0x6e, 0xf8, 0x4b, 0xbf}: "HPReadBackCreateHpCleanNvram",
		efi.GUID{0x8a, 0x08, 0x40, 0xf1, 0xb0, 0x05, 0xe3, 0x46, 0x83, 0xff, 0xd5, 0xa6, 0x9b, 0x7c, 0x71, 0x85}: "SioIt8669eDxe",
		efi.GUID{0x8a, 0x11, 0x07, 0x9a, 0x8d, 0x76, 0x9b, 0x44, 0x97, 0xd0, 0x6a, 0xdc, 0x8f, 0x2b, 0x02, 0x44}: "CpuMpPei",
		efi.GUID{0x8a, 0x1e, 0x80, 0x8c, 0x95, 0x1a, 0x0f, 0x45, 0xbc, 0x59, 0xae, 0x49, 0x0d, 0xf2, 0x30, 0x29}: "FjShutdownLogSmm",
		efi.GUID{0x8a, 0x2e, 0xab, 0x7c, 0x99, 0xb7, 0x40, 0x45, 0x85, 0x17, 0x58, 0x64, 0x4d, 0x03, 0xcc, 0x9f}: "LenovoAtpSmiServices",
		efi.GUID{0x8a, 0x34, 0x9a, 0x35, 0xab, 0xca, 0xd0, 0x43, 0x8e, 0x30, 0xff, 0x87, 0x59, 0x29, 0xd5, 0x31}: "PchIoExpanderPreMem",
		efi.GUID{0x8a, 0x35, 0x88, 0xd9, 0x7f, 0x15, 0xb7, 0x43, 0x9a, 0x7a, 0x27, 0x57, 0xd6, 0x63, 0xdc, 0xeb}: "DellStorageAgentConfigPolicy",
		efi.GUID{0x8a, 0x38, 0x91, 0x50, 0xb6, 0x4b, 0xa5, 0x4d, 0xa4, 0x93, 0x5e, 0xe7, 0xa9, 0x0c, 0xea, 0x5e}: "OemBoardID",
		efi.GUID{0x8a, 0x40, 0x84, 0xca, 0x29, 0x09, 0x11, 0x4f, 0xbf, 0xed, 0x18, 0xc7, 0xd9, 0x57, 0x6c, 0x6b}: "PlatformInitDxe",
		efi.GUID{0x8a, 0x41, 0x37, 0x32, 0x8c, 0x47, 0x00, 0x47, 0xb5, 0x9f, 0x76, 0x8e, 0x2c, 0xcb, 0xc7, 0x26}: "CmosDxe",
		efi.GUID{0x8a, 0x45, 0xac, 0x25, 0x60, 0xcf, 0x6e, 0x47, 0x86, 0x1a, 0x21, 0x1c, 0x75, 0x76, 0x57, 0xa6}: "SnpDxePort",
		efi.GUID{0x8a, 0x55, 0x9a, 0x53, 0xc7, 0xc4, 0x78, 0x49, 0xb5, 0x2d, 0x14, 0x92, 0x41, 0x5e, 0xf6, 0x4d}: "RomDataMigration",
		efi.GUID{0x8a, 0x5a, 0x39, 0x79, 0xbb, 0x53, 0xbe, 0x41, 0xa6, 0xe6, 0xf6, 0x5e, 0x9a, 0xe4, 0xe0, 0xea}: "KEMhAcpi",
		efi.GUID{0x8a, 0x60, 0x6c, 0x31, 0x29, 0x44, 0xfc, 0x49, 0x9e, 0x2c, 0x0b, 0x81, 0x4d, 0x5e, 0xe4, 0xf3}: "PlatformPolicyManagerDxe",
		efi.GUID{0x8a, 0x61, 0x6c, 0x31, 0x29, 0x44, 0x3c, 0x49, 0x9e, 0x2c, 0x0b, 0xa1, 0x4d, 0x5e, 0xe4, 0xf3}: "SstSpiChipDxe",
		efi.GUID{0x8a, 0x6b, 0x2e, 0xc2, 0x59, 0x81, 0xa3, 0x49, 0xb3, 0x53, 0xe8, 0x4b, 0x79, 0xdf, 0x19, 0xc0}: "VARIABLE",
		efi.GUID{0x8a, 0x78, 0x78, 0x9a, 0xe8, 0xbb, 0xe4, 0x11, 0x80, 0x9e, 0x67, 0x61, 0x1e, 0x5d, 0x46, 0xb0}: "EfiEventNotificationTypeSea",
		efi.GUID{0x8a, 0x79, 0x10, 0x58, 0x30, 0xed, 0x80, 0x40, 0x8d, 0xd7, 0xb9, 0x66, 0x7a, 0x74, 0x8c, 0x02}: "HashInstanceLibSha256",
		efi.GUID{0x8a, 0x8b, 0xe7, 0x45, 0x68, 0xbd, 0x3a, 0x45, 0x8e, 0x9e, 0xc3, 0x77, 0x31, 0x08, 0xb2, 0x13}: "SiInitPreMemPch",
		efi.GUID{0x8a, 0x8c, 0x3c, 0x24, 0xd0, 0xbb, 0xa9, 0x4a, 0xbe, 0x17, 0xcf, 0x9b, 0x58, 0x31, 0x30, 0xec}: "SmmOEMInt15",
		efi.GUID{0x8a, 0x8f, 0x4a, 0x17, 0x53, 0x7b, 0xb4, 0x48, 0xac, 0xa9, 0xd9, 0x55, 0xab, 0x1b, 0x5e, 0x90}: "SrSetupPure",
		efi.GUID{0x8a, 0x90, 0x82, 0xf2, 0xf9, 0xa6, 0x50, 0x4e, 0x9d, 0x6c, 0x21, 0x04, 0x78, 0xf1, 0xed, 0x46}: "FtBbUpdate",
		efi.GUID{0x8a, 0x91, 0x66, 0xeb, 0xef, 0x7e, 0x2a, 0x40, 0x84, 0x2e, 0x93, 0x1d, 0x21, 0xc3, 0x8a, 0xe9}: "EfiRtPropertiesTable",
		efi.GUID{0x8a, 0x91, 0x81, 0xcc, 0x55, 0xac, 0xcd, 0x4f, 0x83, 0xe6, 0x0c, 0x1c, 0xc2, 0x29, 0x37, 0xea}: "WakeSourcePei",
		efi.GUID{0x8a, 0x9b, 0x0d, 0x9e, 0x50, 0x1d, 0x8f, 0x44, 0x8f, 0xc6, 0x12, 0xf3, 0x22, 0x18, 0xa3, 0x46}: "IT889XPei",
		efi.GUID{0x8a, 0xa8, 0x38, 0x8e, 0x67, 0xc2, 0x31, 0x41, 0xa8, 0xcd, 0xc0, 0xbc, 0x80, 0xa2, 0x4c, 0xb5}: "CbsSetupDxeSSP",
		efi.GUID{0x8a, 0xbc, 0xc4, 0xcc, 0x71, 0x0d, 0x97, 0x41, 0x86, 0xd5, 0xdd, 0x12, 0xe1, 0x0a, 0x97, 0xe6}: "InstantOn",
		efi.GUID{0x8a, 0xc7, 0x7b, 0x86, 0xac, 0x10, 0xa2, 0xb6, 0x88, 0xb5, 0xc4, 0x12, 0xab, 0xc4, 0x2a, 0x62}: "DellPlatformErrorHandlerSmm",
		efi.GUID{0x8a, 0xd8, 0x81, 0x75, 0x66, 0xf8, 0xc1, 0x42, 0x86, 0x83, 0x26, 0x28, 0x19, 0x38, 0xe5, 0xbf}: "RtkWifiSupDriver",
		efi.GUID{0x8a, 0xdf, 0x85, 0x0c, 0x12, 0x42, 0xc1, 0x4c, 0xa4, 0xaa, 0x1a, 0x7a, 0x36, 0xe8, 0xda, 0x97}: "FpgaPlatformEarlyInit",
		efi.GUID{0x8a, 0xe7, 0xc1, 0x40, 0xc5, 0xd6, 0x41, 0x4a, 0x80, 0x5a, 0x85, 0xd6, 0x80, 0xf8, 0xfd, 0xb1}: "FmpDxe",
		efi.GUID{0x8a, 0xe8, 0xf2, 0x4f, 0x04, 0xa4, 0xf7, 0x46, 0x9a, 0x2a, 0x35, 0xe0, 0x08, 0x44, 0xf6, 0xe6}: "SpiDeviceDxe",
		efi.GUID{0x8a, 0xed, 0x85, 0x27, 0x5f, 0x79, 0xa1, 0x43, 0xae, 0x2d, 0x6b, 0xff, 0xec, 0xcb, 0xa6, 0x46}: "AcpiUpdateCpuInfo",
		efi.GUID{0x8a, 0xee, 0x9a, 0x67, 0x51, 0xce, 0xcb, 0x4c, 0x9a, 0xf8, 0x90, 0xe0, 0x55, 0xb3, 0x93, 0x3e}: "NvmeRecoveryPei",
		efi.GUID{0x8a, 0xf3, 0x3f, 0x34, 0xe2, 0x32, 0xb3, 0x48, 0x91, 0x0f, 0x37, 0xe7, 0xfe, 0x9e, 0xf7, 0x2e}: "MeCapsuleDxe",
		efi.GUID{0x8a, 0xf3, 0xbd, 0x62, 0xd5, 0xe3, 0x2c, 0x49, 0x95, 0x0c, 0x23, 0xa7, 0xf6, 0x6e, 0x67, 0x2e}: "EfiPrimaryConsoleOutDevice",
		efi.GUID{0x8a, 0xf5, 0x0b, 0x56, 0x0d, 0x1e, 0x7e, 0x4d, 0x95, 0x3f, 0x29, 0x80, 0xa2, 0x61, 0xe0, 0x31}: "EfiSioVariableGuid",
		efi.GUID{0x8b, 0x04, 0x4a, 0xf9, 0xc4, 0x7f, 0xbc, 0x4a, 0x85, 0xa6, 0x86, 0x16, 0xa6, 0xd3, 0xcd, 0xce}: "LenovoTcgSmm",
		efi.GUID{0x8b, 0x06, 0x88, 0x4e, 0xb2, 0x41, 0x05, 0x4e, 0x89, 0x3c, 0xdb, 0x0b, 0x43, 0xf7, 0xd3, 0x48}: "FmpDxe",
		efi.GUID{0x8b, 0x0e, 0xa5, 0xd7, 0x3a, 0xfd, 0x3a, 0x44, 0x81, 0xa9, 0xc9, 0x51, 0xda, 0xc8, 0xb3, 0xff}: "LenovoLoggingDxe",
		efi.GUID{0x8b, 0x1d, 0xf8, 0x81, 0x46, 0xb7, 0x24, 0x4b, 0xb6, 0x49, 0x26, 0x54, 0xf7, 0x28, 0x1e, 0x4a}: "EcMemoryIntrusionTestModeSmm",
		efi.GUID{0x8b, 0x25, 0xd5, 0xc1, 0x1a, 0xf6, 0x02, 0x4c, 0x92, 0x93, 0xa0, 0x05, 0xbe, 0xb3, 0xea, 0xa1}: "PngDecoderDxe",
		efi.GUID{0x8b, 0x29, 0x2c, 0x98, 0xfa, 0xf4, 0xcb, 0x41, 0xb8, 0x38, 0x77, 0xaa, 0x68, 0x8f, 0xb8, 0x39}: "EfiUgaDrawProtocolGuid",
		efi.GUID{0x8b, 0x2b, 0xef, 0x38, 0x3d, 0xcf, 0xe2, 0x47, 0x97, 0xe3, 0x55, 0x71, 0x15, 0xe4, 0x39, 0x85}: "DellDiagsSbControlDxe",
		efi.GUID{0x8b, 0x2d, 0x05, 0x11, 0xac, 0xc1, 0x44, 0x42, 0xa5, 0x64, 0xb5, 0xa7, 0x1f, 0xf7, 0x82, 0x2a}: "BiosGuardStoreStatusDxe",
		efi.GUID{0x8b, 0x31, 0xf5, 0xf9, 0xed, 0xd0, 0xa8, 0x4c, 0xbe, 0x91, 0x18, 0x81, 0xce, 0xb5, 0x7f, 0x1b}: "ACPIRAM",
		efi.GUID{0x8b, 0x3d, 0x38, 0x4f, 0x0e, 0xa4, 0xb6, 0x44, 0x85, 0xe8, 0xf0, 0x94, 0xbe, 0x74, 0x6f, 0x88}: "FjIbvSfuControlAbstractionSmmProtocol",
		efi.GUID{0x8b, 0x3f, 0x72, 0x27, 0xa8, 0x25, 0xa1, 0x4d, 0xa3, 0xfc, 0x7b, 0x30, 0xe9, 0x87, 0x1d, 0xc7}: "SmcOobPlatformPolicy",
		efi.GUID{0x8b, 0x40, 0x39, 0x06, 0xa6, 0x19, 0x5d, 0x4b, 0xba, 0xfb, 0x12, 0xa2, 0xf5, 0x11, 0x40, 0x32}: "Acoustic",
		efi.GUID{0x8b, 0x4d, 0x80, 0x41, 0xf4, 0x2c, 0xca, 0x43, 0x90, 0x34, 0x18, 0xe5, 0xdd, 0x22, 0x7c, 0x93}: "HpNetworkTransferDriverWmiSmm",
		efi.GUID{0x8b, 0x4d, 0xa1, 0xfb, 0x6f, 0xbe, 0x61, 0x03, 0x93, 0xe8, 0x4c, 0xdf, 0x18, 0xe1, 0x9e, 0xde}: "ICCPolicy",
		efi.GUID{0x8b, 0x55, 0x87, 0xa2, 0xdd, 0xd9, 0x1b, 0x46, 0xa9, 0x29, 0xec, 0x2a, 0xd2, 0xfe, 0xf5, 0x91}: "DellSpiPartSst",
		efi.GUID{0x8b, 0x56, 0x20, 0xfa, 0x8b, 0x54, 0x2b, 0x4b, 0x81, 0xef, 0x1b, 0xa0, 0x8d, 0x4a, 0x3c, 0xec}: "BootScriptExecutorDxe",
		efi.GUID{0x8b, 0x67, 0xfa, 0x65, 0xd8, 0xa1, 0xfd, 0x40, 0xb9, 0x13, 0xdf, 0xfa, 0x9a, 0xda, 0x28, 0x16}: "DellHddSecurityDxe",
		efi.GUID{0x8b, 0x6b, 0x3d, 0x94, 0xd0, 0xd4, 0x05, 0x40, 0x81, 0xa0, 0xaf, 0x26, 0xe5, 0xe0, 0x7f, 0x03}: "MeFwLayout",
		efi.GUID{0x8b, 0x6f, 0x9d, 0x29, 0xc9, 0x2e, 0x40, 0x4e, 0x9e, 0xc6, 0xdd, 0xaa, 0x7e, 0xbf, 0x5f, 0xd9}: "SiInit",
		efi.GUID{0x8b, 0x73, 0x5f, 0x02, 0xbd, 0x4e, 0x55, 0x4d, 0xb7, 0x28, 0x5f, 0x42, 0x1b, 0x60, 0x1f, 0x1f}: "PlatformInfoDxe",
		efi.GUID{0x8b, 0x73, 0x5f, 0x02, 0xbd, 0x4e, 0x55, 0x4d, 0xb7, 0x28, 0x5f, 0x42, 0x1b, 0x60, 0x1f, 0x20}: "PlatformCpuInfoDxe",
		efi.GUID{0x8b, 0x7b, 0x8d, 0xc8, 0x7b, 0x2a, 0x3d, 0x40, 0xa8, 0xa2, 0xef, 0x0a, 0x5a, 0xee, 0x66, 0x2f}: "OemEcRTCBackup",
		efi.GUID{0x8b, 0x7c, 0x28, 0x37, 0x93, 0xdc, 0xd5, 0x45, 0x9a, 0xaf, 0x3c, 0xd2, 0xe9, 0x06, 0xb1, 0x2b}: "DellErrorHandlerSmm",
		efi.GUID{0x8b, 0x7c, 0x28, 0x37, 0x93, 0xdc, 0xd5, 0x45, 0x9a, 0xaf, 0x3c, 0xd2, 0xe9, 0x06, 0xff, 0xff}: "DellDefaultBootListSmm",
		efi.GUID{0x8b, 0x7d, 0x9a, 0xd8, 0x16, 0xd0, 0x26, 0x4d, 0x93, 0xe3, 0xea, 0xb6, 0xb4, 0xd3, 0xb0, 0xa2}: "Enter_Setup",
		efi.GUID{0x8b, 0x82, 0xea, 0x32, 0x3b, 0x52, 0xcb, 0x44, 0xb7, 0xa4, 0x7e, 0x0a, 0x2a, 0x49, 0x95, 0x6c}: "FmacDriver",
		efi.GUID{0x8b, 0x9d, 0x43, 0x8f, 0xb2, 0x07, 0x21, 0x41, 0xaa, 0x95, 0x8a, 0xc9, 0x15, 0x71, 0xaa, 0x75}: "DellErrorHandlerDxe",
		efi.GUID{0x8b, 0x9d, 0x43, 0x8f, 0xb2, 0x07, 0x21, 0x41, 0xaa, 0x95, 0x8a, 0xc9, 0x15, 0x71, 0xff, 0xff}: "DellDefaultBootListDxe",
		efi.GUID{0x8b, 0xa3, 0xe0, 0x03, 0xbe, 0x3f, 0xcb, 0x49, 0xb3, 0x11, 0x72, 0x66, 0x11, 0x21, 0x31, 0x82}: "EgsFhfPolicyOverrideDxe",
		efi.GUID{0x8b, 0xa6, 0x3c, 0x4a, 0x23, 0x77, 0xfb, 0x48, 0x80, 0x3d, 0x57, 0x8c, 0xc1, 0xfe, 0xc4, 0x4d}: "AptioFwCapsule",
		efi.GUID{0x8b, 0xb0, 0x3c, 0x77, 0x1a, 0x51, 0xd5, 0x4b, 0x85, 0xad, 0x41, 0xd4, 0xf4, 0xb6, 0x4a, 0x52}: "AmtSetupDxe",
		efi.GUID{0x8b, 0xb2, 0xda, 0xd6, 0x2a, 0xe5, 0x76, 0x4c, 0xb9, 0xd1, 0x98, 0x2b, 0x11, 0x2c, 0x91, 0x30}: "EcDashControllerSmm",
		efi.GUID{0x8b, 0xc2, 0x62, 0x89, 0xfe, 0x0d, 0x39, 0x47, 0xa7, 0x3f, 0x09, 0x2d, 0x37, 0x4a, 0x7a, 0x13}: "efi_pop_RT_pressed",
		efi.GUID{0x8b, 0xd6, 0xc6, 0xa5, 0x8a, 0xe7, 0x26, 0x44, 0x92, 0x78, 0xa8, 0xf0, 0xd9, 0xeb, 0x4d, 0x8f}: "UsbMassStorageDxe",
		efi.GUID{0x8b, 0xd6, 0xdd, 0x82, 0x63, 0x91, 0x87, 0x41, 0x9b, 0x27, 0x20, 0xa8, 0xfd, 0x60, 0xa7, 0x1d}: "EdkiiIfrBitVarstore",
		efi.GUID{0x8b, 0xe1, 0x25, 0x9c, 0xba, 0x76, 0xda, 0x43, 0xa1, 0x32, 0xdb, 0xb0, 0x99, 0x7c, 0xef, 0xef}: "WinNtSimpleFileSystemDxe",
		efi.GUID{0x8b, 0xe1, 0x2b, 0x44, 0x6e, 0xca, 0x23, 0x4a, 0x9a, 0x99, 0x9a, 0xfe, 0x8a, 0x21, 0x3a, 0x32}: "PlatformPeiSystemInformation",
		efi.GUID{0x8b, 0xe3, 0x0d, 0xe8, 0x52, 0x6d, 0xd5, 0x48, 0x8b, 0xa2, 0x52, 0x82, 0x8a, 0xee, 0x62, 0x21}: "OhciDxe",
		efi.GUID{0x8b, 0xeb, 0xcf, 0xc0, 0xe1, 0x6e, 0x3b, 0x44, 0xbc, 0xc9, 0x85, 0x4e, 0x7c, 0x9b, 0x41, 0x6d}: "LenovoSystemStatusCodePort80Smm",
		efi.GUID{0x8b, 0xeb, 0xdd, 0xe8, 0xd7, 0x82, 0x6e, 0x4b, 0xa2, 0xb4, 0xd5, 0xea, 0xec, 0x2b, 0x89, 0x76}: "IrsiRegistrationRuntimeDxe",
		efi.GUID{0x8b, 0xec, 0xb9, 0x78, 0x00, 0xc0, 0xc5, 0x46, 0xac, 0x93, 0x24, 0xa0, 0xc1, 0xbb, 0x00, 0xce}: "PwdCredentialProviderGuid",
		efi.GUID{0x8b, 0xf0, 0xdb, 0x6d, 0xc9, 0xcf, 0xcc, 0x43, 0x9e, 0x81, 0x07, 0x84, 0xba, 0x31, 0x2c, 0xa0}: "BeagleBoardTimerDxe",
		efi.GUID{0x8b, 0xf2, 0x9b, 0xc6, 0xc3, 0x16, 0x4f, 0x43, 0xa4, 0xa4, 0x29, 0x2b, 0xdb, 0x0f, 0x4d, 0x12}: "LenovoVariableDefault",
		efi.GUID{0x8b, 0xf3, 0x41, 0x80, 0x34, 0x0a, 0xd7, 0x49, 0xa9, 0x05, 0x03, 0xae, 0xef, 0x48, 0x26, 0xf7}: "PlatformSsdtImageGuid",
		efi.GUID{0x8b, 0xf8, 0x23, 0x07, 0x0f, 0x81, 0x44, 0x4e, 0x92, 0xa0, 0xa5, 0xc8, 0x3b, 0x43, 0x36, 0x98}: "PchFlashControllerDxe",
		efi.GUID{0x8b, 0xfb, 0x77, 0x7b, 0x0d, 0x1e, 0x7e, 0x4d, 0x95, 0x3f, 0x39, 0x80, 0xa2, 0x61, 0xe0, 0x76}: "TdtVolatileSetupData",
		efi.GUID{0x8b, 0xfb, 0x77, 0x7b, 0x0d, 0x1e, 0x7e, 0x4d, 0x95, 0x3f, 0x39, 0x80, 0xa2, 0x61, 0xe0, 0x77}: "IccVolatileSetupData",
		efi.GUID{0x8b, 0xfc, 0xf5, 0x39, 0x4d, 0xf3, 0x56, 0x42, 0x86, 0x89, 0xda, 0x3a, 0x44, 0x58, 0x05, 0x44}: "DellNbEcSmm",
		efi.GUID{0x8c, 0x05, 0xe5, 0xf8, 0xb6, 0xcc, 0x14, 0x47, 0xb2, 0x20, 0x3f, 0x7e, 0x3a, 0x64, 0x0b, 0xd1}: "EfiUserCredentialClassPasswordGuid",
		efi.GUID{0x8c, 0x19, 0xbd, 0x18, 0xf5, 0xec, 0xf2, 0x40, 0x98, 0xed, 0xc3, 0x88, 0xc3, 0xfd, 0x91, 0x36}: "DRAMPei",
		efi.GUID{0x8c, 0x1a, 0xe4, 0x9e, 0x12, 0xc1, 0x4f, 0x4e, 0xb2, 0xf0, 0x65, 0xd0, 0xf9, 0xb1, 0x33, 0xdb}: "DellPasswordPolicyExtSmmProtocol",
		efi.GUID{0x8c, 0x1e, 0xf2, 0x7e, 0xc1, 0x2f, 0xc3, 0x4b, 0xa8, 0x4a, 0x73, 0x02, 0x5e, 0xaa, 0xb8, 0x96}: "ProgressBarFullMiddle",
		efi.GUID{0x8c, 0x29, 0xe5, 0xdc, 0x89, 0x1d, 0x25, 0x41, 0x94, 0x4a, 0xcd, 0x04, 0xd3, 0xca, 0x0a, 0xaa}: "FjSysmanTeutatesBin",
		efi.GUID{0x8c, 0x2d, 0x5c, 0xa2, 0x92, 0x2f, 0x26, 0x46, 0x8d, 0x63, 0x84, 0x3b, 0xa9, 0x43, 0x96, 0x30}: "TxtDxeProtocol",
		efi.GUID{0x8c, 0x2e, 0x81, 0x60, 0x5b, 0x50, 0x3e, 0x4d, 0xa5, 0xb7, 0x17, 0x15, 0x65, 0x6c, 0xe3, 0x62}: "ProjectDxeDriver",
		efi.GUID{0x8c, 0x2f, 0x02, 0x93, 0x09, 0x1f, 0xef, 0x47, 0xbb, 0xb2, 0x58, 0x14, 0xff, 0x60, 0x9d, 0xf5}: "FileSystem",
		efi.GUID{0x8c, 0x37, 0xa7, 0x20, 0x83, 0xaa, 0xe1, 0x4c, 0x82, 0x1f, 0x47, 0x40, 0xee, 0x1b, 0x3f, 0x9f}: "PeiOperatorPresencePpi",
		efi.GUID{0x8c, 0x3b, 0x4b, 0xfc, 0x0b, 0x2a, 0xa2, 0x47, 0x8a, 0x95, 0xaf, 0xfa, 0x51, 0xa0, 0x15, 0x93}: "OsInstallerMenuDxe",
		efi.GUID{0x8c, 0x40, 0x44, 0xde, 0xa3, 0xea, 0xa0, 0x4c, 0xa0, 0x5a, 0x27, 0x38, 0x0f, 0xc4, 0x86, 0x1f}: "FjGabiFlashCommonDeRegionCtrlSmm",
		efi.GUID{0x8c, 0x43, 0xb5, 0xaa, 0x5b, 0xf1, 0xef, 0x4d, 0xb6, 0x1a, 0x52, 0x80, 0xb6, 0x2b, 0xfb, 0x58}: "FchSongshanMultiFchPei",
		efi.GUID{0x8c, 0x45, 0x01, 0xe7, 0x00, 0x49, 0xa5, 0x4c, 0xb7, 0x72, 0x3d, 0x37, 0x94, 0x9f, 0x79, 0x27}: "StatusCodeCallbackGuid",
		efi.GUID{0x8c, 0x49, 0x1e, 0xa0, 0xe8, 0x96, 0x4c, 0x2a, 0x95, 0xf4, 0x85, 0x24, 0x8f, 0x98, 0x97, 0x53}: "FwBlockService",
		efi.GUID{0x8c, 0x49, 0x35, 0x36, 0x69, 0x40, 0x48, 0x4d, 0xa2, 0x6d, 0x16, 0x09, 0x41, 0xc0, 0x02, 0x6d}: "DeviceFwUpdate",
		efi.GUID{0x8c, 0x4d, 0x2d, 0x50, 0x07, 0xe6, 0x13, 0x46, 0xb1, 0x87, 0x3a, 0xca, 0xb0, 0x16, 0x9a, 0xd7}: "DellDualBootBlockDxe",
		efi.GUID{0x8c, 0x52, 0x81, 0x9f, 0x31, 0x3e, 0x0d, 0x42, 0xa9, 0xe8, 0x07, 0x4f, 0xd1, 0xc2, 0xc2, 0x2a}: "HpKeyPressTrigger",
		efi.GUID{0x8c, 0x52, 0x98, 0x8f, 0x36, 0xf7, 0x84, 0x4a, 0xaa, 0xa3, 0x37, 0x6a, 0x8e, 0x43, 0xbf, 0x51}: "ImagePasswordEmpty",
		efi.GUID{0x8c, 0x58, 0xc8, 0x98, 0x0a, 0x64, 0xb4, 0x4b, 0xae, 0xa0, 0x3f, 0x81, 0xcd, 0xe1, 0x75, 0x24}: "FspDxeIpl",
		efi.GUID{0x8c, 0x5c, 0x74, 0x60, 0x6b, 0xfe, 0x6b, 0x4c, 0xb7, 0x70, 0x3f, 0x7c, 0x35, 0xef, 0xf6, 0x96}: "TamperEventS3Check",
		efi.GUID{0x8c, 0x5e, 0xd8, 0xc8, 0x1c, 0xdc, 0x8c, 0x4f, 0xad, 0xa7, 0x58, 0xc1, 0xd1, 0x07, 0xa3, 0x04}: "EfiPeiSystemBoardPpi",
		efi.GUID{0x8c, 0x60, 0x15, 0x7d, 0x1a, 0xee, 0xcc, 0x43, 0xa2, 0x7a, 0xbe, 0x9d, 0x8b, 0xa0, 0xf5, 0xf8}: "DellTcgServicesPei",
		efi.GUID{0x8c, 0x66, 0xe2, 0xbb, 0xfc, 0x0e, 0xfb, 0x46, 0x91, 0x37, 0x4f, 0x2d, 0xa8, 0xf4, 0x19, 0xf3}: "ConsolePrefDxe",
		efi.GUID{0x8c, 0x7a, 0x96, 0x69, 0x59, 0x11, 0x22, 0x45, 0xaa, 0x89, 0x74, 0xcd, 0xc6, 0xe5, 0x99, 0xa0}: "IdeSecurityPwnv",
		efi.GUID{0x8c, 0x81, 0x79, 0x30, 0xd4, 0x46, 0x73, 0x4a, 0xae, 0xf3, 0xe3, 0xe4, 0x6c, 0xf1, 0xee, 0xdb}: "EfiBootScriptExecutorVariableGuid",
		efi.GUID{0x8c, 0x8d, 0x3e, 0xff, 0xd2, 0xf7, 0x2f, 0x47, 0xbe, 0x89, 0x71, 0x92, 0x81, 0x23, 0x19, 0x3c}: "PeiSmartPowerOn",
		efi.GUID{0x8c, 0x92, 0xa9, 0xd6, 0x97, 0x33, 0xd1, 0x4d, 0x81, 0x8f, 0xc6, 0x64, 0xba, 0x6d, 0xca, 0xaf}: "DevUtility",
		efi.GUID{0x8c, 0x99, 0x83, 0x64, 0x38, 0x96, 0x72, 0x4c, 0xbd, 0x1a, 0x77, 0xc5, 0x5c, 0x5c, 0xee, 0x8c}: "OSDSMIfunctionSmm",
		efi.GUID{0x8c, 0x9b, 0x0e, 0x31, 0x90, 0xcf, 0x1e, 0x42, 0x8e, 0x9b, 0x9e, 0xef, 0xb6, 0x17, 0xc8, 0xef}: "S3StorageDeviceInitList",
		efi.GUID{0x8c, 0xa4, 0x3f, 0x7a, 0xf2, 0x12, 0x0e, 0x4b, 0x9e, 0x74, 0x29, 0x77, 0x71, 0x1f, 0x59, 0x8b}: "AmdCcxZen3RmbPei",
		efi.GUID{0x8c, 0xa6, 0xdd, 0x84, 0x5a, 0xca, 0x30, 0x4c, 0x92, 0x61, 0xdd, 0x6d, 0xe7, 0xe4, 0x5a, 0x95}: "EzSetupPortingDxe",
		efi.GUID{0x8c, 0xac, 0x79, 0x7c, 0x6c, 0x5e, 0x3d, 0x4e, 0xba, 0x6f, 0xc2, 0x60, 0xee, 0x7c, 0x17, 0x2e}: "SmmRuntime",
		efi.GUID{0x8c, 0xb2, 0xf5, 0xd9, 0xf1, 0x9f, 0xd6, 0x47, 0xb5, 0x03, 0x3d, 0xc2, 0x3b, 0xd3, 0x45, 0xff}: "PchEarlyInitPeim",
		efi.GUID{0x8c, 0xb5, 0xb5, 0x98, 0xe8, 0xe2, 0x06, 0x4a, 0xaa, 0xcb, 0xe4, 0xce, 0x31, 0x6c, 0x2b, 0x68}: "DustFilterReminderDxe",
		efi.GUID{0x8c, 0xb7, 0x58, 0xb9, 0x3e, 0x1d, 0x40, 0xee, 0x8b, 0xf4, 0xf0, 0x63, 0x2d, 0x06, 0x39, 0x16}: "EmuThunkPpi",
		efi.GUID{0x8c, 0xbf, 0x64, 0xa4, 0xab, 0x77, 0xd8, 0x4b, 0xae, 0xf1, 0x82, 0xda, 0xe1, 0xa0, 0x6a, 0xf6}: "FjGabiFlashDescriptorDxeProtocol",
		efi.GUID{0x8c, 0xc1, 0x56, 0x82, 0xfe, 0x27, 0x99, 0x41, 0xb3, 0x69, 0xc6, 0xc9, 0x5c, 0x55, 0x5f, 0x06}: "H19AmdFTpmUpdate",
		efi.GUID{0x8c, 0xd3, 0x3d, 0xe1, 0x41, 0x1b, 0xf5, 0x49, 0x8d, 0x92, 0x08, 0x39, 0xd4, 0x23, 0x4a, 0xa2}: "AmdCpmAdaptiveS4Smm",
		efi.GUID{0x8c, 0xdb, 0xe3, 0x29, 0x30, 0x3b, 0xd7, 0x49, 0x92, 0x62, 0x53, 0xfb, 0x91, 0x7b, 0x9a, 0x6b}: "BochsVga",
		efi.GUID{0x8c, 0xdd, 0x17, 0x6f, 0x0a, 0x77, 0x7c, 0x42, 0xb2, 0x91, 0xc8, 0xeb, 0x64, 0x4f, 0x97, 0x9a}: "DellHwManagerSmm",
		efi.GUID{0x8c, 0xde, 0xb4, 0x70, 0x01, 0x3b, 0x0a, 0x4f, 0xa2, 0xf3, 0x93, 0xce, 0xe9, 0x77, 0x31, 0x3e}: "EfiJedecNvDimm",
		efi.GUID{0x8c, 0xdf, 0xd9, 0xbc, 0x89, 0xbe, 0x07, 0x40, 0x98, 0x6f, 0xfa, 0x40, 0x1a, 0x4a, 0xf9, 0x4e}: "Int15PanelColor",
		efi.GUID{0x8c, 0xe1, 0x48, 0x71, 0x3e, 0x70, 0x59, 0x4f, 0xac, 0x3d, 0x3a, 0x92, 0x3a, 0x0d, 0xaa, 0x50}: "OemDxeEcVer",
		efi.GUID{0x8c, 0xee, 0x4f, 0xa2, 0x1d, 0xab, 0x84, 0x4b, 0x8e, 0x74, 0x5d, 0xb4, 0x74, 0xd8, 0xfe, 0xa8}: "UefiDiagnostic",
		efi.GUID{0x8c, 0xfa, 0xb7, 0x47, 0xbd, 0xf4, 0xf6, 0x4a, 0x82, 0x00, 0x33, 0x30, 0x86, 0xf0, 0xd2, 0xc8}: "EfiSmmReadyToLockProtocolGuid",
		efi.GUID{0x8d, 0x04, 0xe4, 0xe3, 0x0c, 0x6c, 0xe4, 0x43, 0xae, 0x1c, 0xff, 0xb5, 0x79, 0xd8, 0xef, 0x41}: "OpalPasswordDxe",
		efi.GUID{0x8d, 0x05, 0xa3, 0x54, 0x37, 0x85, 0x32, 0x4a, 0xbd, 0xb0, 0x40, 0x27, 0xbb, 0x68, 0x87, 0x27}: "ITEAcPowerLossPei",
		efi.GUID{0x8d, 0x0f, 0x16, 0x00, 0x35, 0x2b, 0xf2, 0x4d, 0xbb, 0xe0, 0xb2, 0x72, 0xa8, 0xd6, 0x31, 0xf0}: "FirmwarePerformanceDxe",
		efi.GUID{0x8d, 0x1d, 0xbf, 0x2e, 0x63, 0xd3, 0x8f, 0x44, 0x8d, 0x39, 0x90, 0x2f, 0x3f, 0xb8, 0x1f, 0x75}: "SuperRTC",
		efi.GUID{0x8d, 0x23, 0x48, 0x4d, 0x23, 0x6a, 0xeb, 0x4b, 0xad, 0xa2, 0xd2, 0x4f, 0xd8, 0x33, 0xcc, 0x2c}: "HashService",
		efi.GUID{0x8d, 0x2b, 0xf1, 0xff, 0x96, 0x76, 0x8b, 0x4c, 0xa9, 0x85, 0x27, 0x47, 0x07, 0x5b, 0x4f, 0x50}: "EfiSystemNvDataFvGuid",
		efi.GUID{0x8d, 0x30, 0xbb, 0x08, 0xd8, 0xc7, 0x7b, 0x4d, 0xb4, 0xd4, 0xbc, 0x4b, 0xb5, 0x37, 0x68, 0xa6}: "OemVariableInit",
		efi.GUID{0x8d, 0x35, 0x51, 0xcd, 0x7e, 0x6e, 0xca, 0x45, 0xb4, 0x50, 0x57, 0xc0, 0x46, 0xbd, 0xfd, 0xdc}: "BmpConvert",
		efi.GUID{0x8d, 0x36, 0xdc, 0x58, 0xfa, 0x7b, 0x77, 0x4e, 0xab, 0xbc, 0x0e, 0x29, 0x41, 0x8d, 0xf9, 0x30}: "EfiSmmIoTrapDispatch2ProtocolGuid",
		efi.GUID{0x8d, 0x37, 0x13, 0x51, 0xa5, 0xc3, 0x6c, 0x4b, 0x8f, 0x5c, 0x9f, 0xa8, 0x2c, 0xbe, 0x4f, 0x6b}: "BiosRecoveryPei",
		efi.GUID{0x8d, 0x41, 0xd4, 0xcb, 0x39, 0x42, 0x9a, 0x49, 0x97, 0xc8, 0xc1, 0x06, 0x22, 0xf9, 0x9d, 0x0d}: "H19MPMDxe",
		efi.GUID{0x8d, 0x42, 0x63, 0xec, 0xca, 0x66, 0xf9, 0x4b, 0x82, 0xae, 0x84, 0x0f, 0x6d, 0x5c, 0x23, 0x05}: "AmiBoardPciInitProtocolGuid",
		efi.GUID{0x8d, 0x45, 0x0e, 0x9c, 0xe7, 0xea, 0x34, 0x12, 0xa3, 0xba, 0x3c, 0xe1, 0xcc, 0x33, 0x51, 0x68}: "AmiHidServiceDriver",
		efi.GUID{0x8d, 0x45, 0x0e, 0x9c, 0xe7, 0xea, 0x91, 0x41, 0xa3, 0xba, 0x3c, 0xe1, 0xcc, 0x31, 0x51, 0x68}: "HidKeyboardDxe",
		efi.GUID{0x8d, 0x4b, 0x71, 0x0e, 0xaa, 0xee, 0xba, 0x4f, 0x83, 0xab, 0x2b, 0x80, 0x05, 0xd4, 0x17, 0xc3}: "EnableM2PCIeCardDxe",
		efi.GUID{0x8d, 0x4c, 0x86, 0x5f, 0xae, 0xf2, 0x21, 0x42, 0xb8, 0xca, 0xf6, 0x4e, 0xcf, 0xb0, 0xac, 0xa7}: "OemDebug",
		efi.GUID{0x8d, 0x4f, 0x72, 0xae, 0xc6, 0x62, 0x38, 0x46, 0xa0, 0x65, 0x01, 0x38, 0xf4, 0x7b, 0x6d, 0x23}: "UefiPxeBcDxe",
		efi.GUID{0x8d, 0x55, 0x44, 0x43, 0xf9, 0x4e, 0x25, 0x47, 0xb1, 0xe4, 0x33, 0x76, 0xe8, 0xd6, 0x97, 0x4f}: "ShellLevel3HiiGuid",
		efi.GUID{0x8d, 0x6f, 0x83, 0xda, 0x7f, 0x21, 0xa0, 0x4c, 0x99, 0xc2, 0x1c, 0xa4, 0xe1, 0x60, 0x77, 0xea}: "EfiHash2ServiceBindingProtocolGuid",
		efi.GUID{0x8d, 0x82, 0x60, 0x46, 0x2a, 0x84, 0x69, 0x4f, 0xb3, 0x1b, 0xd3, 0x93, 0x66, 0x2b, 0x52, 0x40}: "LenovoDeviceGuardDxe",
		efi.GUID{0x8d, 0x88, 0xdc, 0x8f, 0x62, 0x21, 0x71, 0x49, 0x81, 0xc2, 0x35, 0xd3, 0xa1, 0xaa, 0x50, 0x47}: "EfiRasMpLinkProtocol",
		efi.GUID{0x8d, 0x89, 0xb2, 0xeb, 0x68, 0x21, 0xc1, 0x48, 0x93, 0x6c, 0x64, 0xc8, 0x6e, 0xb6, 0x42, 0x4b}: "UsbPxeUndiDriver2",
		efi.GUID{0x8d, 0x8e, 0x24, 0xab, 0xe1, 0xab, 0xd4, 0x11, 0xbd, 0x0d, 0x00, 0x80, 0xc7, 0x3c, 0x88, 0x81}: "WinNtUgaDxe",
		efi.GUID{0x8d, 0x95, 0x38, 0x07, 0x5a, 0xa3, 0x75, 0x41, 0xac, 0xe9, 0xd3, 0x24, 0x45, 0x50, 0x1d, 0x34}: "FjTpmPhysicalPresenceLockSkip",
		efi.GUID{0x8d, 0x97, 0x3a, 0xec, 0x4e, 0x7c, 0xfa, 0x48, 0x9a, 0xbe, 0x6a, 0xd9, 0x1c, 0xc8, 0xf8, 0x11}: "EfiKmsProtocolGuid",
		efi.GUID{0x8d, 0x97, 0x58, 0xae, 0xb0, 0x8e, 0xcc, 0x42, 0xff, 0xff, 0xff, 0xff, 0xa4, 0x19, 0xf0, 0x39}: "XnoteSetupMainDxe",
		efi.GUID{0x8d, 0x9b, 0xe4, 0xe3, 0x87, 0x19, 0xd0, 0x48, 0x9a, 0x01, 0xed, 0xa1, 0x79, 0xca, 0x0b, 0xd6}: "XmlCliProtocol",
		efi.GUID{0x8d, 0xaf, 0x9c, 0x38, 0x8f, 0x99, 0xd8, 0x4a, 0xbf, 0xac, 0x20, 0xbe, 0x4a, 0xd9, 0x80, 0x4a}: "DellAuxMac",
		efi.GUID{0x8d, 0xb0, 0xe9, 0x1c, 0x49, 0x76, 0xe6, 0x4e, 0xae, 0xf5, 0x72, 0x9a, 0x4d, 0xa7, 0xe4, 0x69}: "EcIoDxe",
		efi.GUID{0x8d, 0xb1, 0x73, 0x1f, 0x30, 0x46, 0xc1, 0x43, 0xa1, 0xde, 0x6f, 0x80, 0x85, 0x5d, 0x7d, 0xa4}: "EfiFormBrowserExProtocolGuid",
		efi.GUID{0x8d, 0xb8, 0xf8, 0x22, 0x9e, 0x4e, 0xa3, 0x4d, 0x8c, 0xd5, 0x74, 0x46, 0x35, 0x93, 0xef, 0x13}: "DellPeiDiagLeds",
		efi.GUID{0x8d, 0xbf, 0xeb, 0x80, 0xde, 0x82, 0xc9, 0x42, 0x94, 0x5a, 0xe7, 0xad, 0x7e, 0xb0, 0xc2, 0x84}: "CaRemoval",
		efi.GUID{0x8d, 0xc7, 0xfe, 0x6f, 0xbf, 0x7d, 0x8b, 0x4f, 0x96, 0x8d, 0x2f, 0x43, 0xa0, 0x80, 0xc1, 0x3f}: "PhoenixDesktopWindowProtocolGuid",
		efi.GUID{0x8d, 0xcb, 0x78, 0x3f, 0xee, 0x72, 0x4e, 0x41, 0xb0, 0x23, 0xda, 0xca, 0x00, 0x3b, 0xdd, 0xf5}: "ProjectSxSMI",
		efi.GUID{0x8d, 0xcb, 0x78, 0x3f, 0xee, 0x72, 0x4e, 0x41, 0xb0, 0x23, 0xda, 0xca, 0x00, 0x3e, 0xfc, 0xde}: "APM",
		efi.GUID{0x8d, 0xd1, 0x5a, 0xab, 0x1a, 0x33, 0x7f, 0x4b, 0x9b, 0x7f, 0x64, 0xef, 0xba, 0xf1, 0xad, 0x31}: "PTInterfacePei",
		efi.GUID{0x8d, 0xd1, 0xad, 0x30, 0x43, 0xe1, 0x29, 0x43, 0xa9, 0x77, 0xb4, 0x9a, 0x65, 0x95, 0x73, 0xad}: "SpiAccessSmm",
		efi.GUID{0x8d, 0xed, 0xf6, 0x88, 0x6e, 0x7d, 0xeb, 0x40, 0x84, 0xb4, 0xd6, 0x6f, 0xbd, 0xdc, 0xe5, 0xc0}: "AmdMemSmbiosV2PhxPei",
		efi.GUID{0x8d, 0xf3, 0xb0, 0x99, 0x27, 0x1f, 0x46, 0x4f, 0x9f, 0x44, 0x42, 0xd6, 0x94, 0x72, 0x28, 0x82}: "AmdCpmMemEyeToolSmm",
		efi.GUID{0x8d, 0xf3, 0xb0, 0xb9, 0x27, 0x1f, 0x46, 0x4f, 0x9f, 0x44, 0x42, 0xd6, 0x94, 0x72, 0x98, 0x82}: "AmdCpmOemSmm",
		efi.GUID{0x8e, 0x05, 0x58, 0x9d, 0xdd, 0xc8, 0x9f, 0x4a, 0xb1, 0x76, 0xdf, 0xcb, 0x92, 0x35, 0x48, 0x15}: "LenovoEn25Qh128FlashPartDxe",
		efi.GUID{0x8e, 0x05, 0xcb, 0xef, 0xdc, 0x8b, 0x62, 0x40, 0x8d, 0xae, 0x82, 0x62, 0x88, 0x6c, 0x51, 0x2b}: "Tcg2Dxe_",
		efi.GUID{0x8e, 0x08, 0x97, 0xeb, 0xdf, 0xcf, 0xc6, 0x49, 0xbe, 0x4b, 0xd9, 0x06, 0xa5, 0xb2, 0x0e, 0x86}: "EfiAcpiSdtProtocolGuid",
		efi.GUID{0x8e, 0x0c, 0xfc, 0x05, 0x6a, 0x27, 0x2d, 0x42, 0xba, 0xe1, 0x64, 0x5c, 0xfd, 0x7b, 0x78, 0x6b}: "Cf9Reset",
		efi.GUID{0x8e, 0x19, 0x44, 0x9a, 0xa2, 0xa4, 0xe6, 0x44, 0x8a, 0x1f, 0x39, 0xbe, 0xfd, 0xac, 0x89, 0x6f}: "EfiCustomizedDecompressProtocol",
		efi.GUID{0x8e, 0x1e, 0x48, 0x1a, 0x2f, 0x34, 0xaa, 0x40, 0xaf, 0x31, 0xf4, 0xfb, 0x7c, 0x99, 0xd4, 0x28}: "AmtInt16",
		efi.GUID{0x8e, 0x20, 0xa1, 0xb4, 0x9a, 0x4d, 0xa2, 0x4e, 0x9d, 0x6b, 0xe4, 0x1a, 0x61, 0xe6, 0xc5, 0xac}: "PeiAmtPlatformPolicyPpi",
		efi.GUID{0x8e, 0x36, 0xec, 0x4c, 0x8e, 0x8e, 0x71, 0x4d, 0x8b, 0xe1, 0x95, 0x8c, 0x45, 0xfc, 0x8a, 0x53}: "EfiSmmPeriodicTimerDispatch2ProtocolGuid",
		efi.GUID{0x8e, 0x3a, 0xa0, 0x11, 0xc5, 0xa9, 0xb9, 0x4d, 0x90, 0xcf, 0x44, 0x34, 0xb0, 0x15, 0x86, 0xc4}: "BootPerformanceLog",
		efi.GUID{0x8e, 0x40, 0xfb, 0x67, 0x19, 0xa5, 0xe9, 0x40, 0x83, 0x21, 0x79, 0xf1, 0x3f, 0xfd, 0xf9, 0xaf}: "RstResourcePei",
		efi.GUID{0x8e, 0x4b, 0xe6, 0x1d, 0x8b, 0x13, 0x58, 0x42, 0xb7, 0xdd, 0xf2, 0xd8, 0xec, 0x14, 0x2a, 0x9e}: "AmiFwUpdateBmc",
		efi.GUID{0x8e, 0x58, 0xf1, 0xf0, 0x28, 0x90, 0xb8, 0x4e, 0x80, 0x31, 0xf2, 0x33, 0xb4, 0x8e, 0xa0, 0xb7}: "PxeDummyDxe",
		efi.GUID{0x8e, 0x5b, 0xb0, 0xa4, 0x0d, 0xb3, 0x26, 0x44, 0x50, 0xb6, 0x6d, 0x05, 0xdd, 0xea, 0x84, 0xa9}: "HpHoneywellLcn",
		efi.GUID{0x8e, 0x60, 0x83, 0x23, 0xd0, 0xc6, 0x3e, 0x4e, 0x85, 0x8d, 0x45, 0xdf, 0xac, 0x35, 0x43, 0xd5}: "PciHostBridge",
		efi.GUID{0x8e, 0x60, 0xdf, 0xa1, 0x27, 0x80, 0x3f, 0x41, 0xa2, 0xf2, 0x1d, 0xf7, 0x86, 0x3f, 0x90, 0x6b}: "OhciDxe",
		efi.GUID{0x8e, 0x6b, 0x19, 0xf7, 0x2b, 0x47, 0x1d, 0x4c, 0x9a, 0xb9, 0xa6, 0x9a, 0x89, 0x92, 0xf4, 0x6c}: "LenovoVariableStoreSmmRuntimeDxe",
		efi.GUID{0x8e, 0x70, 0x5c, 0x95, 0x6a, 0xb4, 0x8b, 0x48, 0x9d, 0x5b, 0xd7, 0xe6, 0x1d, 0x0f, 0x96, 0x09}: "SmbiosDataUpdateDxeEVB",
		efi.GUID{0x8e, 0x79, 0xe5, 0x34, 0x4f, 0xf4, 0x26, 0x45, 0xa0, 0x8c, 0x39, 0xbc, 0xa6, 0xe8, 0xd7, 0xd5}: "EarlyProgramGpioPei",
		efi.GUID{0x8e, 0x7c, 0x10, 0x96, 0x90, 0x94, 0x67, 0x47, 0x9d, 0x0d, 0x55, 0x90, 0xf1, 0xf6, 0xe1, 0xfc}: "PhysicalPresenceDxe",
		efi.GUID{0x8e, 0x80, 0xdd, 0xa1, 0x95, 0x1e, 0x99, 0x43, 0xab, 0xc0, 0x65, 0x3c, 0x82, 0xe8, 0x53, 0x0c}: "JunoAcpiTableFile",
		efi.GUID{0x8e, 0x83, 0x86, 0xfd, 0x34, 0x51, 0x66, 0x41, 0x8c, 0x73, 0xcc, 0x05, 0xb3, 0x90, 0x73, 0xcd}: "IntegratedVideoOptionPei",
		efi.GUID{0x8e, 0x84, 0x90, 0xe7, 0xab, 0xb6, 0xab, 0x44, 0x84, 0x91, 0xdc, 0xa5, 0x0c, 0x39, 0x07, 0xc6}: "EfiIpmiSolStatusProtocol",
		efi.GUID{0x8e, 0x86, 0x2d, 0xdf, 0xfc, 0x32, 0xf0, 0x4c, 0x8e, 0x6b, 0xff, 0xd9, 0x5d, 0x13, 0x43, 0xd0}: "EfiPrintProtocolGuid",
		efi.GUID{0x8e, 0x90, 0x8e, 0x84, 0x11, 0xbd, 0x8e, 0x42, 0x94, 0xf9, 0x7a, 0x0e, 0xef, 0xcd, 0x37, 0xa6}: "BaseCsrToPcieLibNull",
		efi.GUID{0x8e, 0x9b, 0xd1, 0x5a, 0xda, 0x71, 0xe6, 0x40, 0xb3, 0x0e, 0xff, 0x2b, 0x81, 0x68, 0xc1, 0x0c}: "DellThermalDebugDxeDriver",
		efi.GUID{0x8e, 0x9c, 0x1b, 0x0d, 0x7b, 0xf7, 0x32, 0x46, 0x83, 0x43, 0x91, 0xf4, 0x3d, 0x9a, 0x85, 0x60}: "EfiCpuHtCapable",
		efi.GUID{0x8e, 0x9d, 0x98, 0x34, 0x0a, 0x93, 0x95, 0x4a, 0xab, 0x04, 0x2e, 0x6c, 0xfd, 0xff, 0x66, 0x31}: "TcgPei",
		efi.GUID{0x8e, 0xb0, 0x7c, 0xf7, 0x82, 0x66, 0xf7, 0x4d, 0x82, 0xa3, 0xbb, 0xbb, 0x52, 0x70, 0x4c, 0x1f}: "AppleNetLoadFileDxe",
		efi.GUID{0x8e, 0xb1, 0x48, 0x51, 0xec, 0xf1, 0xa8, 0x41, 0x92, 0x92, 0xe2, 0x59, 0x2e, 0x6f, 0x75, 0x47}: "FlabLoadPvUadmDxe",
		efi.GUID{0x8e, 0xb3, 0xbb, 0xa7, 0xb4, 0x3a, 0x9d, 0x40, 0xb1, 0x1b, 0xee, 0x31, 0xa2, 0x68, 0x8b, 0x0e}: "OemHooksPei",
		efi.GUID{0x8e, 0xd6, 0x1d, 0xa8, 0x78, 0xf8, 0xff, 0x49, 0x83, 0x09, 0x79, 0x84, 0x44, 0xa9, 0xc0, 0x35}: "AbtSmm",
		efi.GUID{0x8e, 0xd9, 0xbc, 0x45, 0xad, 0x59, 0x74, 0x41, 0x95, 0x46, 0x34, 0x4a, 0x07, 0x48, 0x58, 0x98}: "EfiSupplicantServiceBindingProtocolGuid",
		efi.GUID{0x8e, 0xe2, 0x10, 0x73, 0xea, 0x96, 0x60, 0x43, 0x94, 0x6e, 0x5a, 0xdc, 0x6b, 0xe8, 0xf5, 0x31}: "DellSmmEcIoProtocol",
		efi.GUID{0x8e, 0xea, 0xf4, 0x13, 0xf1, 0xbf, 0xbf, 0x43, 0x8f, 0x44, 0x80, 0xbc, 0xc9, 0x60, 0x40, 0xf1}: "FpgaDxe",
		efi.GUID{0x8e, 0xf1, 0xf0, 0x9c, 0x7d, 0x7c, 0xde, 0x49, 0xb5, 0xaa, 0xbb, 0xba, 0xd6, 0xb2, 0x10, 0x07}: "AmiCallback",
		efi.GUID{0x8e, 0xf4, 0xa1, 0xf7, 0x6a, 0x0f, 0x12, 0x4f, 0xa7, 0x4d, 0xed, 0x6f, 0x5b, 0x6b, 0x00, 0xf2}: "OpromUpdateDxeLightningRidgeEXECB4",
		efi.GUID{0x8e, 0xff, 0x76, 0xfd, 0x5f, 0x66, 0xfc, 0x4a, 0xaf, 0x75, 0x72, 0x4e, 0xf5, 0xa5, 0x69, 0xe5}: "UcOnUc2Thunk",
		efi.GUID{0x8f, 0x0c, 0x4f, 0x27, 0x57, 0x9e, 0xd8, 0x41, 0x99, 0x66, 0x29, 0xcc, 0xd4, 0x8d, 0x31, 0xc2}: "SmmAccess",
		efi.GUID{0x8f, 0x13, 0xb2, 0x47, 0x6b, 0x5a, 0x65, 0x4c, 0x91, 0x67, 0x87, 0x40, 0x59, 0x5d, 0x16, 0xad}: "DellPasswordMgrSmm",
		efi.GUID{0x8f, 0x1c, 0x26, 0x07, 0x27, 0x9f, 0x09, 0x44, 0xbd, 0x78, 0x2b, 0xb0, 0xb6, 0x91, 0xf3, 0x31}: "DetectWlan",
		efi.GUID{0x8f, 0x22, 0x09, 0x32, 0xe2, 0x94, 0xa4, 0x4a, 0x8e, 0x18, 0x07, 0x91, 0xb7, 0x25, 0x4c, 0x2f}: "DellAbsoluteSmm",
		efi.GUID{0x8f, 0x24, 0xcd, 0x73, 0x0b, 0x42, 0x18, 0x46, 0x8f, 0x74, 0xe1, 0x5f, 0xf4, 0x82, 0x58, 0xb5}: "AmdCpmAdaptiveS4Dxe",
		efi.GUID{0x8f, 0x26, 0x9f, 0x22, 0xb0, 0x23, 0x36, 0x44, 0x83, 0xe3, 0x8b, 0x7a, 0xe0, 0x8a, 0x6b, 0xd8}: "EfiMfgUuidHob",
		efi.GUID{0x8f, 0x26, 0xbd, 0x14, 0xfc, 0x76, 0xdb, 0x4e, 0x87, 0xf0, 0xf0, 0xd4, 0xeb, 0xb2, 0x56, 0xb4}: "VfsFingerPrintDevice",
		efi.GUID{0x8f, 0x29, 0x43, 0x1e, 0x78, 0x34, 0xa7, 0x41, 0xb5, 0x77, 0x86, 0x06, 0x46, 0x35, 0xc7, 0x28}: "OptionRomPkgTokenSpaceGuid",
		efi.GUID{0x8f, 0x2d, 0xd1, 0xd0, 0x3c, 0x80, 0x84, 0x40, 0x8c, 0xa8, 0x36, 0x58, 0xd9, 0x34, 0xf5, 0xf2}: "Ax88179UefiDriver",
		efi.GUID{0x8f, 0x31, 0xdc, 0x1e, 0x05, 0x40, 0x8d, 0x48, 0xaf, 0x3a, 0x9b, 0xb5, 0x17, 0x9b, 0xc6, 0xf1}: "GmchMbiDxe",
		efi.GUID{0x8f, 0x3a, 0xac, 0x60, 0x66, 0x4d, 0xd4, 0x4c, 0x89, 0x5a, 0xc3, 0xf0, 0x6e, 0x66, 0x65, 0xee}: "iFfsAcpiTables",
		efi.GUID{0x8f, 0x41, 0xbf, 0x78, 0x9b, 0x55, 0xd5, 0x43, 0x94, 0x0a, 0xef, 0xfa, 0x17, 0x42, 0x17, 0xf7}: "DrySMI",
		efi.GUID{0x8f, 0x50, 0x0e, 0xe7, 0x66, 0x44, 0xf3, 0x49, 0xbb, 0xfb, 0xfd, 0xf2, 0x4e, 0x95, 0x0d, 0xbc}: "LockDownConfigGuid",
		efi.GUID{0x8f, 0x52, 0xc1, 0xb9, 0xd6, 0xb5, 0x9e, 0x48, 0xb5, 0x68, 0xc4, 0xf0, 0xa9, 0x76, 0x4d, 0x1c}: "FjGpioCoffeeLakeSmm",
		efi.GUID{0x8f, 0x54, 0x45, 0x80, 0x94, 0xfd, 0x8a, 0x45, 0x9b, 0xc8, 0xbe, 0xad, 0xb5, 0x73, 0x3d, 0x46}: "AbtDisk",
		efi.GUID{0x8f, 0x67, 0x19, 0xce, 0x08, 0x3f, 0x81, 0x4e, 0xa1, 0xf3, 0x18, 0x86, 0xca, 0x13, 0xad, 0xa7}: "SiliconPolicyPeiPostMem",
		efi.GUID{0x8f, 0x71, 0x36, 0xda, 0x22, 0xe0, 0xd8, 0x4f, 0xba, 0xd8, 0xef, 0x27, 0xf9, 0xe4, 0x92, 0x8f}: "HeciInitSmm",
		efi.GUID{0x8f, 0x72, 0x97, 0xd3, 0x9b, 0x4c, 0x18, 0x9c, 0x98, 0x16, 0xf9, 0xb8, 0x69, 0xb0, 0x00, 0x85}: "SataPortConfigSmm",
		efi.GUID{0x8f, 0x76, 0xfc, 0x56, 0x03, 0xb6, 0x54, 0x44, 0x80, 0x83, 0xbf, 0xe9, 0x8d, 0x60, 0x84, 0xf9}: "GnbPei",
		efi.GUID{0x8f, 0x78, 0x66, 0x48, 0xa8, 0x6b, 0xd8, 0x47, 0x83, 0x06, 0xac, 0xf7, 0x7f, 0x55, 0x10, 0x46}: "FspNonVolatileStorageHob2",
		efi.GUID{0x8f, 0x7f, 0x25, 0xee, 0x10, 0xe7, 0x81, 0x41, 0x9b, 0x01, 0xc0, 0x66, 0x98, 0x45, 0x4a, 0x16}: "AmiPlatformInfoCompressedFfsSection",
		efi.GUID{0x8f, 0x80, 0xc1, 0xa2, 0x4f, 0x0d, 0xc9, 0x4c, 0xa6, 0x19, 0xd1, 0xe6, 0x41, 0xd3, 0x9d, 0x49}: "LenovoSecurityConfigVariable",
		efi.GUID{0x8f, 0x83, 0xf3, 0x27, 0x27, 0xba, 0xfa, 0x4f, 0xb3, 0x74, 0x35, 0xbe, 0xa2, 0x8a, 0x43, 0x1b}: "DellSmsc5544Dxe",
		efi.GUID{0x8f, 0x85, 0x49, 0x00, 0xa7, 0x8c, 0xcd, 0x4c, 0x91, 0x8b, 0xd9, 0x52, 0xcb, 0xf3, 0x29, 0x75}: "VirtioFdtDxe",
		efi.GUID{0x8f, 0x87, 0xa4, 0x31, 0x0d, 0x23, 0xc2, 0x4f, 0x90, 0xbb, 0xda, 0x5f, 0x41, 0xa4, 0x4b, 0x1b}: "DxeDebugportExtProtocolGuid",
		efi.GUID{0x8f, 0x87, 0xd2, 0x54, 0xcd, 0x25, 0x2b, 0x4a, 0x84, 0x20, 0xeb, 0xd1, 0x8e, 0x60, 0x9c, 0x76}: "OemHookStatusCodeLibNull",
		efi.GUID{0x8f, 0x88, 0xe9, 0xa9, 0x84, 0xca, 0x6b, 0x43, 0xb0, 0xd8, 0xa0, 0x3d, 0xeb, 0x35, 0x1c, 0xae}: "AppAdapterMkTme3v0",
		efi.GUID{0x8f, 0x8c, 0xa1, 0x58, 0xd8, 0xd9, 0x9d, 0x4e, 0xbc, 0x43, 0x34, 0x49, 0xb6, 0xbb, 0xce, 0x01}: "ComputraceDxe",
		efi.GUID{0x8f, 0x8d, 0x35, 0xa3, 0xaf, 0xb7, 0xb7, 0x47, 0xa3, 0x24, 0x90, 0x36, 0xfb, 0xd7, 0x3d, 0xdc}: "FjMfgErrorCheckDxe",
		efi.GUID{0x8f, 0x90, 0x2b, 0xc0, 0x92, 0xe8, 0x02, 0x45, 0xac, 0xb7, 0x54, 0x53, 0x19, 0x98, 0x9f, 0x6f}: "RealTimeClock",
		efi.GUID{0x8f, 0x92, 0x76, 0x4e, 0xad, 0x50, 0x34, 0x43, 0xb0, 0x6b, 0xa8, 0x42, 0x13, 0x10, 0x8a, 0x57}: "NtFwhPpiGuid",
		efi.GUID{0x8f, 0x94, 0x4b, 0x62, 0xba, 0x6e, 0xfd, 0x4d, 0x9d, 0xda, 0x10, 0xb0, 0x07, 0x3a, 0x37, 0x35}: "SocketPkgFpga",
		efi.GUID{0x8f, 0xaa, 0x01, 0x77, 0xeb, 0x27, 0x62, 0x45, 0x8c, 0x59, 0x47, 0x31, 0xca, 0xa2, 0x4e, 0x7c}: "ScPmcFunctionDisableResetHobGuid",
		efi.GUID{0x8f, 0xaf, 0x2e, 0xb0, 0xa1, 0x28, 0xa8, 0x44, 0x99, 0x47, 0x72, 0xdf, 0x3a, 0x8a, 0x4d, 0xdd}: "UefiDMBMEDUSmi",
		efi.GUID{0x8f, 0xc2, 0xc8, 0x34, 0x1c, 0xb6, 0xa2, 0x45, 0x8f, 0x2e, 0x89, 0xe4, 0x6b, 0xec, 0xc6, 0x3b}: "PeiVariable",
		efi.GUID{0x8f, 0xe2, 0x00, 0x89, 0x99, 0xde, 0xc4, 0x4f, 0x89, 0x4b, 0x6f, 0x41, 0xcd, 0x13, 0x9a, 0x48}: "InfineonTpmUpdateDxe",
		efi.GUID{0x8f, 0xe6, 0x8a, 0xc9, 0xb9, 0x82, 0xbc, 0x47, 0xbe, 0x87, 0x33, 0x24, 0x0e, 0x11, 0x0d, 0x68}: "DellUefiBootInfoSmm",
		efi.GUID{0x8f, 0xeb, 0xb6, 0x30, 0xa3, 0x08, 0x66, 0x4e, 0x82, 0x79, 0xd8, 0x68, 0x1d, 0x12, 0x7f, 0x59}: "LenovoTpmFwWufuDxe",
		efi.GUID{0x8f, 0xed, 0x81, 0xc6, 0x2e, 0xfc, 0xa4, 0x41, 0x8f, 0x3f, 0x2c, 0x2a, 0x19, 0x61, 0xa8, 0x1b}: "FchProm21Pei",
		efi.GUID{0x8f, 0xef, 0xcb, 0x7e, 0x6e, 0x2c, 0xc0, 0x4c, 0xb8, 0xb8, 0xbf, 0x53, 0x63, 0x96, 0xcc, 0x9d}: "HpQX448Pei",
		efi.GUID{0x8f, 0xf3, 0x3d, 0x04, 0xe1, 0x32, 0x93, 0x48, 0x91, 0x1f, 0x37, 0xa7, 0xfe, 0x91, 0xf7, 0x23}: "CapsuleProcessorDxe",
		efi.GUID{0x8f, 0xfe, 0xdd, 0x38, 0x91, 0x89, 0xaa, 0x44, 0x98, 0x89, 0x83, 0xf4, 0x91, 0x84, 0x65, 0xb0}: "EfiGpioOperationProtocolGuid",
		efi.GUID{0x90, 0x01, 0x06, 0xaf, 0x3a, 0x5e, 0x25, 0x40, 0xaf, 0xbd, 0xe1, 0xf9, 0x05, 0xbf, 0xaa, 0x4c}: "EfiHiiImageDecoderNamePngGuid",
		efi.GUID{0x90, 0x2a, 0xf5, 0xed, 0x4c, 0xa3, 0xa2, 0x47, 0x83, 0x2a, 0x93, 0x08, 0x11, 0x2c, 0xae, 0x38}: "AmdDynamicLid",
		efi.GUID{0x90, 0x2c, 0x63, 0xd0, 0xd7, 0xaf, 0x92, 0x44, 0xb1, 0x86, 0x25, 0x7c, 0x63, 0x14, 0x3c, 0x61}: "SmmBase",
		efi.GUID{0x90, 0x2f, 0x89, 0xd1, 0x84, 0x37, 0x0f, 0x41, 0x98, 0x4b, 0x9b, 0xec, 0x59, 0xd8, 0xd4, 0x94}: "AmdNbioPciePei",
		efi.GUID{0x90, 0x33, 0x3b, 0xfd, 0x9a, 0x9e, 0x43, 0x43, 0x8e, 0x03, 0x90, 0xf0, 0x80, 0xde, 0x90, 0x21}: "EcdPeiNbSbCustom",
		efi.GUID{0x90, 0x35, 0xf2, 0x44, 0x88, 0xdc, 0xdd, 0x11, 0xad, 0x8b, 0x08, 0x00, 0x20, 0x0c, 0x9a, 0x66}: "SystemAhciAtaAtapiPassThruDxe",
		efi.GUID{0x90, 0x3a, 0xe1, 0xbf, 0x43, 0xc1, 0xc2, 0x43, 0x97, 0x04, 0x71, 0xe3, 0x9e, 0x6d, 0x43, 0xae}: "IntelVtdSmm",
		efi.GUID{0x90, 0x3c, 0x25, 0xc3, 0x4f, 0xa2, 0x99, 0x45, 0xa6, 0x64, 0x1f, 0x88, 0x13, 0x77, 0x8f, 0xc9}: "ArmGlobalVariableGuid",
		efi.GUID{0x90, 0x4c, 0x9b, 0xc3, 0x56, 0xcb, 0xbc, 0x49, 0x95, 0x34, 0x01, 0x2f, 0x69, 0xa1, 0xc2, 0xcc}: "UuidPeiInit",
		efi.GUID{0x90, 0x53, 0x91, 0xdd, 0x7f, 0x3b, 0x8b, 0x42, 0x8d, 0xd4, 0xc4, 0xc2, 0xfa, 0x89, 0x7c, 0x63}: "AmdPlatformRasRsSmm",
		efi.GUID{0x90, 0x55, 0x43, 0xf6, 0x02, 0x24, 0x02, 0x4e, 0x99, 0xfd, 0xab, 0xdd, 0x9d, 0xd4, 0x0a, 0x6a}: "SaPolicyPpiGuid",
		efi.GUID{0x90, 0x55, 0x4e, 0x16, 0x7a, 0xfb, 0xb9, 0x47, 0x86, 0x87, 0x3e, 0x91, 0xda, 0x49, 0x9d, 0x97}: "AmiAmdUefiRaid",
		efi.GUID{0x90, 0x5a, 0x37, 0x0c, 0x4c, 0x4c, 0x28, 0x44, 0x8e, 0xa0, 0x53, 0x1b, 0xe8, 0x95, 0x9b, 0xf7}: "FlashDriverSmm",
		efi.GUID{0x90, 0x5c, 0xdc, 0x50, 0x33, 0x1d, 0xd6, 0x4f, 0x87, 0xe5, 0x06, 0x3b, 0x1d, 0xfa, 0x21, 0x70}: "AmiSerialProtocolGuid",
		efi.GUID{0x90, 0x61, 0x4f, 0xdf, 0xb8, 0x42, 0xa9, 0x4c, 0xba, 0x51, 0x7a, 0x80, 0x1b, 0x56, 0x5f, 0x08}: "b57undix64",
		efi.GUID{0x90, 0x61, 0xb3, 0xe2, 0x9b, 0x87, 0x3d, 0x4a, 0xad, 0x8d, 0xf2, 0xe7, 0xbb, 0xa3, 0x27, 0x84}: "EfiCertRsa2048Sha256Guid",
		efi.GUID{0x90, 0x62, 0x1d, 0xe1, 0xfd, 0xcc, 0x01, 0x45, 0xb5, 0x9a, 0xce, 0xcb, 0xa0, 0xe7, 0x91, 0x33}: "OdometerMetrics",
		efi.GUID{0x90, 0x66, 0x96, 0x56, 0xe8, 0x24, 0xfa, 0x4d, 0xbe, 0xa8, 0xbf, 0xcd, 0x83, 0xda, 0x44, 0xb8}: "MultiPdtDxe",
		efi.GUID{0x90, 0x6f, 0x4c, 0x1f, 0x6b, 0xb0, 0xd8, 0x48, 0xa2, 0x01, 0xba, 0xe5, 0xf1, 0xcd, 0x7d, 0x56}: "EfiPeiStallPpiGuid",
		efi.GUID{0x90, 0x78, 0x5f, 0x76, 0x55, 0x57, 0x6d, 0x40, 0x9b, 0x02, 0xc4, 0x4e, 0x71, 0x82, 0x68, 0x0c}: "LEMBoardId",
		efi.GUID{0x90, 0x7e, 0x65, 0xf0, 0x6a, 0x21, 0x30, 0x4c, 0xb6, 0x9b, 0xde, 0xd9, 0x62, 0x67, 0xbc, 0x29}: "OemThermalPolicyPEI",
		efi.GUID{0x90, 0x7f, 0x98, 0x6e, 0xa5, 0x95, 0x1b, 0x41, 0xbe, 0xd3, 0xa5, 0x27, 0x7f, 0x17, 0xb1, 0x32}: "UdiDxeDriver",
		efi.GUID{0x90, 0x81, 0x83, 0x1b, 0x25, 0x46, 0xad, 0x4e, 0xab, 0xc9, 0xcd, 0x5e, 0x6a, 0xf1, 0x8f, 0xe0}: "EfiHiiExportDatabase",
		efi.GUID{0x90, 0x86, 0x14, 0x77, 0x43, 0x7e, 0x73, 0x46, 0xaf, 0xae, 0x34, 0x53, 0x2c, 0xdd, 0x42, 0x48}: "SmmControlDxe",
		efi.GUID{0x90, 0x88, 0x4a, 0xfe, 0xd6, 0x2b, 0xf8, 0x4d, 0xa5, 0x9e, 0x30, 0x1d, 0x39, 0x8b, 0x54, 0x33}: "HeciTransportDxe",
		efi.GUID{0x90, 0x88, 0x68, 0xa6, 0xf0, 0xbf, 0x03, 0x4f, 0x9b, 0x1e, 0x76, 0xae, 0x86, 0xee, 0xc5, 0xab}: "LenovoSystemAcpiTablesDxe",
		efi.GUID{0x90, 0x8d, 0x9b, 0xee, 0xa6, 0xc5, 0xa2, 0x40, 0xbd, 0xe2, 0x52, 0x55, 0x8d, 0x33, 0xcc, 0xa1}: "EfiSmmUsbDispatch2ProtocolGuid",
		efi.GUID{0x90, 0x92, 0xa5, 0xe8, 0xaf, 0xa2, 0x99, 0x40, 0xb0, 0xaf, 0x32, 0x3f, 0xf9, 0xb7, 0xab, 0x41}: "BeginBootButton",
		efi.GUID{0x90, 0x99, 0x01, 0x7d, 0xe1, 0x8c, 0xf5, 0x46, 0xa7, 0x76, 0x3c, 0x51, 0x98, 0x67, 0x6a, 0xa0}: "EfiExtendedSalResetServicesProtocolGuid",
		efi.GUID{0x90, 0x9b, 0x42, 0x21, 0x67, 0x5f, 0x93, 0x4e, 0xaf, 0x55, 0x1d, 0x31, 0x4d, 0x64, 0x6e, 0x12}: "MemoryProfileInfo",
		efi.GUID{0x90, 0x9c, 0xb5, 0xbc, 0x86, 0xdc, 0xdd, 0x11, 0xad, 0x8b, 0x08, 0x00, 0x20, 0x0c, 0x9a, 0x66}: "SystemAhciAtaAtapiPassThruSmm",
		efi.GUID{0x90, 0xa2, 0x3c, 0x3d, 0xa5, 0xb9, 0xe3, 0x11, 0xb7, 0x5d, 0xb8, 0xac, 0x6f, 0x7d, 0x65, 0xe6}: "XenBusProtocolGuid",
		efi.GUID{0x90, 0xa6, 0x74, 0xfb, 0x1a, 0xde, 0xf4, 0x4b, 0x97, 0xc0, 0x17, 0x0b, 0x35, 0x35, 0xfc, 0x98}: "PciThunderbolt",
		efi.GUID{0x90, 0xc1, 0xef, 0x91, 0x79, 0xde, 0x1f, 0x44, 0xb5, 0x7f, 0xbb, 0x0f, 0x7d, 0x8a, 0x8b, 0x4d}: "FjM2WlanEnableDisablePei",
		efi.GUID{0x90, 0xc3, 0x09, 0x8e, 0x30, 0x1b, 0x5e, 0x41, 0xaf, 0x5c, 0xd4, 0x2a, 0xb0, 0x16, 0x0f, 0x8c}: "AmiCbsDxe",
		efi.GUID{0x90, 0xc6, 0xc7, 0xa6, 0xd8, 0xad, 0x78, 0x41, 0xbc, 0x97, 0xf6, 0xa4, 0xc1, 0x20, 0x62, 0x85}: "c_pg4306",
		efi.GUID{0x90, 0xce, 0x5f, 0x0c, 0x03, 0x1c, 0xd2, 0x4e, 0x9e, 0xfe, 0xb1, 0xd0, 0x2e, 0x72, 0xb3, 0xb0}: "menu_bottom_mid",
		efi.GUID{0x90, 0xd5, 0x2c, 0x64, 0x59, 0x80, 0x0a, 0x4c, 0xa9, 0x58, 0xc5, 0xec, 0x07, 0xd2, 0x3c, 0x4b}: "EfiPlatformToDriverConfigurationProtocolGuid",
		efi.GUID{0x90, 0xe9, 0xaa, 0x4a, 0x1c, 0x5f, 0xa3, 0x4b, 0xb0, 0xce, 0x66, 0x75, 0x4d, 0x38, 0x35, 0x21}: "NvmExpressLegacySmm",
		efi.GUID{0x90, 0xf5, 0x76, 0x38, 0xc6, 0x7a, 0x0c, 0x4e, 0x82, 0xef, 0x7b, 0x9a, 0x8a, 0x7b, 0x8d, 0xc9}: "GpioPolicyPei",
		efi.GUID{0x90, 0xf5, 0x89, 0xee, 0x16, 0xa8, 0xc5, 0x4a, 0xb3, 0xa9, 0x1b, 0xc7, 0x59, 0xb1, 0x24, 0x39}: "VerifyFwBootGuard",
		efi.GUID{0x91, 0x00, 0x74, 0xeb, 0x94, 0xa4, 0xd7, 0x44, 0x8d, 0x96, 0xc1, 0x92, 0xf9, 0x5a, 0x63, 0x94}: "OobTx",
		efi.GUID{0x91, 0x01, 0x08, 0x51, 0x06, 0xed, 0xa0, 0x4a, 0xbf, 0xd7, 0xf0, 0x48, 0x37, 0xcf, 0x70, 0xdb}: "SbRomArmorSmm",
		efi.GUID{0x91, 0x0e, 0xf5, 0xb7, 0x59, 0xa7, 0x2c, 0x41, 0xad, 0xe4, 0xdc, 0xd0, 0x3e, 0x7f, 0x7c, 0x28}: "XhciDxe",
		efi.GUID{0x91, 0x17, 0x63, 0x01, 0x4e, 0xf3, 0x0a, 0x4c, 0xb1, 0x5d, 0x0b, 0x6c, 0xe2, 0x2b, 0x27, 0xa8}: "TcgPeiAfterMem",
		efi.GUID{0x91, 0x18, 0xa2, 0x9b, 0x7d, 0x7e, 0x94, 0x4e, 0xb8, 0xdf, 0xf4, 0xd2, 0xd3, 0x20, 0x80, 0x1c}: "ROMss",
		efi.GUID{0x91, 0x26, 0xa9, 0x08, 0x6c, 0x92, 0x4f, 0x41, 0xa0, 0xb5, 0xe7, 0x85, 0xd9, 0x0b, 0x98, 0x53}: "Memory_OK_DXE",
		efi.GUID{0x91, 0x30, 0xec, 0x56, 0x4c, 0x95, 0xd2, 0x11, 0x8e, 0x3f, 0x00, 0xa0, 0xc9, 0x69, 0x72, 0x3b}: "EfiLoadFileProtocolGuid",
		efi.GUID{0x91, 0x31, 0x6d, 0xf2, 0x3c, 0x66, 0x95, 0x41, 0x92, 0x85, 0x14, 0x9b, 0x43, 0xbb, 0xda, 0x6e}: "SynServerSetupSmm",
		efi.GUID{0x91, 0x3a, 0xb3, 0x7a, 0xe5, 0xac, 0x26, 0x43, 0xb5, 0x72, 0xe7, 0xee, 0x33, 0xd3, 0x9f, 0x16}: "EfiManagedNetworkProtocolGuid",
		efi.GUID{0x91, 0x40, 0x0a, 0xf3, 0xdf, 0xd9, 0x8b, 0x47, 0x89, 0xf2, 0xa2, 0x66, 0xc1, 0x91, 0x79, 0x85}: "OCMR_Setup",
		efi.GUID{0x91, 0x40, 0x3a, 0xd1, 0x6d, 0x7c, 0x0e, 0x4d, 0xbd, 0xe8, 0x5d, 0xe6, 0xf7, 0x13, 0x5f, 0x35}: "BcmCvAPISmall",
		efi.GUID{0x91, 0x43, 0xd6, 0x86, 0x99, 0x96, 0x7c, 0x41, 0x95, 0x06, 0x14, 0xfe, 0xe0, 0x6b, 0x8e, 0x54}: "RfBootOptions",
		efi.GUID{0x91, 0x4f, 0xe2, 0x24, 0x6d, 0x2e, 0x25, 0x45, 0xba, 0xe9, 0xb9, 0x77, 0xde, 0x20, 0x05, 0xd6}: "AepLogDrv",
		efi.GUID{0x91, 0x51, 0x21, 0x4b, 0x25, 0x9a, 0xfd, 0x43, 0x86, 0xb5, 0x74, 0xe7, 0xaf, 0x72, 0x33, 0x15}: "AmiNvmePassThruProtocolGuid",
		efi.GUID{0x91, 0x5a, 0x68, 0xb3, 0x6f, 0xf9, 0x59, 0x49, 0xa5, 0x39, 0xa6, 0x3c, 0x3b, 0x9a, 0xce, 0xd3}: "UsbLanDriver",
		efi.GUID{0x91, 0x63, 0xa9, 0xea, 0xe3, 0x9b, 0x88, 0x44, 0x8a, 0xf3, 0xb3, 0xe6, 0xef, 0xd1, 0x57, 0xd5}: "EmuSecPei",
		efi.GUID{0x91, 0x6e, 0x57, 0x09, 0x3f, 0x6d, 0xd2, 0x11, 0x8e, 0x39, 0x00, 0xa0, 0xc9, 0x69, 0x72, 0x3b}: "EfiDevicePathProtocolGuid",
		efi.GUID{0x91, 0x72, 0x6a, 0x46, 0xdf, 0x50, 0x40, 0x4b, 0xa2, 0xeb, 0xce, 0xe6, 0x7d, 0x54, 0x28, 0xc9}: "AmiTseOemPortingVar16",
		efi.GUID{0x91, 0x7e, 0x50, 0xed, 0xeb, 0xaa, 0x20, 0x42, 0xa2, 0xb2, 0x1c, 0xfb, 0x4d, 0xc7, 0x22, 0x3a}: "OemMS",
		efi.GUID{0x91, 0x8b, 0x64, 0x55, 0x7d, 0x0e, 0xa3, 0x40, 0xa9, 0xb3, 0xa8, 0x15, 0xd7, 0xea, 0xdf, 0x97}: "EfiRestExProtocol",
		efi.GUID{0x91, 0x93, 0xb0, 0x68, 0x1f, 0x75, 0xff, 0x46, 0xa4, 0xd6, 0x71, 0xb8, 0x50, 0x2f, 0x52, 0xab}: "KeyboardLayoutDxe",
		efi.GUID{0x91, 0x94, 0xd1, 0xb7, 0x5a, 0xe5, 0x0d, 0x47, 0x85, 0x08, 0x85, 0xa5, 0xdf, 0xa4, 0x19, 0x74}: "SbDxe",
		efi.GUID{0x91, 0x94, 0xd1, 0xf7, 0x53, 0xea, 0x0d, 0x97, 0x55, 0x08, 0x75, 0xac, 0xdf, 0xa4, 0x19, 0x74}: "SbSocBristolDxe",
		efi.GUID{0x91, 0x95, 0x9a, 0xdf, 0x46, 0xb6, 0x21, 0x46, 0xaf, 0x0d, 0x18, 0x14, 0x3a, 0x73, 0x28, 0x9f}: "AppleLegacyBootFS",
		efi.GUID{0x91, 0xa7, 0xce, 0x5f, 0x6e, 0x51, 0x61, 0x4b, 0x89, 0x2c, 0x72, 0x29, 0xd4, 0xff, 0x23, 0xd4}: "Int15ActiveLFP",
		efi.GUID{0x91, 0xac, 0xd7, 0x24, 0x1a, 0x3a, 0xb7, 0x44, 0x8c, 0xd5, 0x08, 0x00, 0xa6, 0x6b, 0xcf, 0xe5}: "OemBadgingSupport",
		efi.GUID{0x91, 0xaf, 0x0c, 0x87, 0x9b, 0xb7, 0xba, 0x4e, 0x92, 0x0f, 0x71, 0xe3, 0xdd, 0x47, 0x89, 0xf4}: "HeciRuntimeDxe",
		efi.GUID{0x91, 0xbb, 0xa1, 0x80, 0x36, 0x20, 0xdd, 0x46, 0x9c, 0xc8, 0x97, 0xa1, 0xf2, 0xf7, 0xe5, 0xbc}: "HpSmmCoreServices",
		efi.GUID{0x91, 0xc5, 0x84, 0x06, 0xe8, 0x19, 0x9d, 0x49, 0x97, 0x8a, 0xd7, 0x15, 0x63, 0x6f, 0x1d, 0xab}: "AmdRasRvDxe",
		efi.GUID{0x91, 0xcd, 0x88, 0xf0, 0x46, 0xa0, 0xd2, 0x11, 0x8e, 0x42, 0x00, 0xa0, 0xc9, 0x69, 0x72, 0x3b}: "EfiVariableStoreProtocol",
		efi.GUID{0x91, 0xcf, 0xd5, 0x76, 0x55, 0x0c, 0x4e, 0x43, 0x97, 0xc2, 0xd2, 0x82, 0x5c, 0x82, 0xe6, 0x10}: "OemActivation3",
		efi.GUID{0x91, 0xd7, 0x7d, 0x66, 0xb3, 0xc6, 0x27, 0x4c, 0x8a, 0x6b, 0x0f, 0x8e, 0x72, 0x2d, 0xeb, 0x41}: "EfiEventNotificationTypeDmarGuid",
		efi.GUID{0x91, 0xdc, 0xde, 0xb2, 0x9f, 0xd5, 0xd2, 0x48, 0x89, 0x8a, 0x12, 0x49, 0x0c, 0x74, 0xa4, 0xe0}: "EfiIfrBootMaintenanceGuid",
		efi.GUID{0x91, 0xe3, 0x53, 0x6e, 0xfc, 0x40, 0x39, 0x45, 0x90, 0x55, 0x06, 0x46, 0x9c, 0x50, 0xaf, 0xbc}: "AmiPciAccessCspBaseLibOverride",
		efi.GUID{0x91, 0xec, 0xe5, 0xcf, 0xed, 0x31, 0xe9, 0x47, 0xbe, 0x7d, 0x9c, 0xcb, 0x59, 0x13, 0x4b, 0x71}: "SiSaPreMemPolicyPpiGuid",
		efi.GUID{0x91, 0xed, 0x1f, 0x2d, 0x7d, 0x67, 0x18, 0x49, 0xb5, 0x8b, 0xab, 0x4b, 0xce, 0x20, 0xe6, 0x72}: "AbtChk",
		efi.GUID{0x91, 0xee, 0x5e, 0x98, 0xac, 0xbc, 0x38, 0x42, 0x87, 0x78, 0x57, 0xef, 0xdc, 0x93, 0xf2, 0x4e}: "MainFormSet",
		efi.GUID{0x91, 0xf0, 0x35, 0x5a, 0xe4, 0xb3, 0xa7, 0x4d, 0xba, 0x74, 0xc9, 0x30, 0x3d, 0x35, 0x77, 0xf9}: "FjPowerButtonDxe",
		efi.GUID{0x91, 0xf0, 0xfa, 0xc9, 0xf8, 0x57, 0x4c, 0xa6, 0xa0, 0x7a, 0x44, 0x5b, 0x12, 0x4f, 0x0d, 0x93}: "FlashMapPei",
		efi.GUID{0x91, 0xf1, 0x61, 0xad, 0x5f, 0xae, 0x0e, 0x4c, 0xb9, 0xfa, 0xe8, 0x69, 0xd2, 0x88, 0xc6, 0x4f}: "EfiCpuIo2ProtocolGuid",
		efi.GUID{0x91, 0xf4, 0xa3, 0xb8, 0x43, 0x02, 0xc4, 0x45, 0xb6, 0x70, 0xc1, 0xbf, 0x61, 0x98, 0x02, 0xae}: "HpRuntimeBiosUpdateCheckDxe",
		efi.GUID{0x91, 0xf8, 0x7d, 0xf5, 0xd1, 0x1d, 0x67, 0x4c, 0x99, 0xa1, 0x4a, 0xb2, 0xda, 0xd9, 0xff, 0xbc}: "OdmDebugSmmProtocol",
		efi.GUID{0x92, 0x15, 0x01, 0xfb, 0x97, 0x2a, 0x82, 0x49, 0x8a, 0x54, 0x3b, 0x3f, 0x59, 0x5c, 0xd5, 0x9f}: "FchKeithPei",
		efi.GUID{0x92, 0x1c, 0x1e, 0x2a, 0xba, 0xaa, 0x62, 0x4d, 0xac, 0x40, 0xf3, 0xa4, 0xc3, 0x38, 0x73, 0x56}: "PeiSmbusLibSmbus2Ppi",
		efi.GUID{0x92, 0x21, 0x54, 0xb7, 0x4b, 0x9e, 0x7f, 0x42, 0x88, 0xfb, 0x18, 0xa0, 0x19, 0x82, 0x36, 0xe3}: "PdHostInterfaceTiDxe",
		efi.GUID{0x92, 0x23, 0xd7, 0x5f, 0x96, 0x61, 0x84, 0x46, 0xaf, 0x2f, 0x79, 0x99, 0x81, 0x5b, 0x5d, 0x45}: "Smbus2Arp",
		efi.GUID{0x92, 0x25, 0x3c, 0x23, 0xec, 0x1c, 0x4a, 0x49, 0xa0, 0x97, 0x15, 0xdc, 0x96, 0x37, 0x97, 0x77}: "FwVolDxe",
		efi.GUID{0x92, 0x2c, 0x51, 0x62, 0xc4, 0x63, 0x80, 0x4d, 0x82, 0xb1, 0xc1, 0xa4, 0xdc, 0x44, 0x80, 0xe5}: "EfiMiscProducer",
		efi.GUID{0x92, 0x2f, 0x4e, 0xe7, 0x3b, 0xed, 0x5d, 0x43, 0x8a, 0x7d, 0xbb, 0x29, 0x40, 0x8e, 0x9b, 0x22}: "AfuCapsuleOnDiskPei",
		efi.GUID{0x92, 0x30, 0xbc, 0xd2, 0xbb, 0x92, 0x21, 0x4b, 0xa2, 0x6b, 0xce, 0x6f, 0x7c, 0x3e, 0x98, 0x57}: "AtAmUi",
		efi.GUID{0x92, 0x36, 0x17, 0x89, 0xc2, 0x9a, 0x86, 0x4c, 0x9e, 0xcc, 0xf3, 0x77, 0x82, 0xdd, 0xeb, 0xaa}: "LenovoHdpManagerSmm",
		efi.GUID{0x92, 0x45, 0xba, 0xa8, 0x57, 0x4d, 0xc9, 0x41, 0xad, 0x6c, 0x07, 0x91, 0xbd, 0x23, 0xa9, 0x9b}: "OemUsbPorting",
		efi.GUID{0x92, 0x46, 0xa8, 0x19, 0xad, 0x4a, 0x4b, 0xc0, 0x90, 0xe9, 0xe0, 0x17, 0x36, 0x0a, 0x98, 0x60}: "DiskImage",
		efi.GUID{0x92, 0x46, 0xdd, 0xdc, 0xd3, 0x88, 0xe6, 0x4c, 0x8c, 0xef, 0x15, 0xe0, 0xe4, 0xda, 0x14, 0x94}: "Npce388nFlashDxe",
		efi.GUID{0x92, 0x4a, 0x29, 0xab, 0xf5, 0xea, 0xf3, 0x4c, 0xab, 0x2b, 0x2d, 0x4b, 0xed, 0x4d, 0xb6, 0x3d}: "PeiMfgMemoryTestPpiGuid",
		efi.GUID{0x92, 0x4d, 0x53, 0xa0, 0x76, 0x97, 0x4e, 0x4e, 0x92, 0x34, 0xc9, 0xdc, 0x18, 0x49, 0xdb, 0xb5}: "PlatformFlashAccessLibNull",
		efi.GUID{0x92, 0x4e, 0x6b, 0x99, 0xeb, 0xd1, 0x35, 0x4e, 0xb1, 0x94, 0xbf, 0x9e, 0x0c, 0x52, 0x4a, 0xcc}: "AssetIDOnRecoveryModeDxe",
		efi.GUID{0x92, 0x52, 0x66, 0xdf, 0xd7, 0x79, 0xe2, 0x40, 0xba, 0x51, 0xf7, 0xd4, 0x94, 0x62, 0x81, 0x85}: "CpuWakeUpBufferVariable",
		efi.GUID{0x92, 0x56, 0xd6, 0xcd, 0x98, 0x2e, 0xad, 0x45, 0xb7, 0xee, 0xcb, 0xed, 0x41, 0x55, 0xdc, 0xe8}: "FjSystemDataPei",
		efi.GUID{0x92, 0x5d, 0x58, 0x69, 0x0a, 0xb5, 0xd7, 0x4a, 0xb2, 0x65, 0x2e, 0xb1, 0xae, 0x06, 0x65, 0x74}: "FmpDxe",
		efi.GUID{0x92, 0x62, 0x6b, 0x03, 0x93, 0x27, 0xc0, 0x4d, 0x9a, 0x7f, 0xd6, 0xb5, 0xf0, 0x34, 0x55, 0x8c}: "FjSystemHooks",
		efi.GUID{0x92, 0x66, 0xf4, 0x41, 0x13, 0x95, 0x1c, 0x4d, 0x8b, 0xb3, 0xb6, 0xa1, 0x68, 0x18, 0x2d, 0xe4}: "DellMePciPlatformConfigDxe",
		efi.GUID{0x92, 0x6d, 0x29, 0xea, 0x69, 0x0b, 0x3c, 0x42, 0x8c, 0x28, 0x33, 0xb4, 0xe0, 0xa9, 0x12, 0x68}: "PcdDataBaseHobGuid",
		efi.GUID{0x92, 0x6e, 0x57, 0x09, 0x3f, 0x6d, 0xd2, 0x11, 0x8e, 0x39, 0x00, 0xa0, 0xc9, 0x69, 0x72, 0x3b}: "EfiFileInfoGuid",
		efi.GUID{0x92, 0x75, 0xa8, 0xf4, 0xad, 0xd3, 0x36, 0x43, 0xba, 0x00, 0x80, 0x85, 0x9f, 0xee, 0x44, 0xaf}: "SmBiosOverRide",
		efi.GUID{0x92, 0x7e, 0xb8, 0xa0, 0x92, 0x63, 0xfe, 0x47, 0x9a, 0xa0, 0x90, 0x20, 0x31, 0x47, 0xec, 0x04}: "DellHddPwSmm",
		efi.GUID{0x92, 0x8e, 0xa3, 0x0b, 0x4a, 0x15, 0xe2, 0x4b, 0xa5, 0xe0, 0xbe, 0x80, 0x57, 0x1c, 0xdb, 0x71}: "DellDtwlanSmm",
		efi.GUID{0x92, 0x9c, 0x49, 0xbe, 0x4b, 0x7d, 0xd4, 0x11, 0xbc, 0xee, 0x00, 0x80, 0xc7, 0x3c, 0x88, 0x81}: "EfiDebugAssertProtocol",
		efi.GUID{0x92, 0xa4, 0xd2, 0x3b, 0xc0, 0x96, 0x79, 0x40, 0xb4, 0x20, 0xfc, 0xf9, 0x8e, 0xf1, 0x03, 0xed}: "EfiCertX509Sha256Guid",
		efi.GUID{0x92, 0xa7, 0x3b, 0x16, 0x11, 0xf8, 0xba, 0x4f, 0xae, 0x8c, 0x10, 0x17, 0x32, 0xf0, 0x32, 0x8f}: "AdlSemaThermalControl",
		efi.GUID{0x92, 0xaa, 0x91, 0x43, 0x44, 0x66, 0x8a, 0x4d, 0x9a, 0x84, 0xdd, 0xd4, 0x05, 0xc3, 0x12, 0xf3}: "AppleBootPolicy",
		efi.GUID{0x92, 0xbc, 0xdc, 0x37, 0x9c, 0x17, 0x86, 0x47, 0xa2, 0xc7, 0x73, 0x2e, 0x0f, 0x3f, 0x24, 0xdb}: "SystemSecureFlashFvHobPei",
		efi.GUID{0x92, 0xbd, 0x28, 0xa1, 0xd3, 0xe5, 0x8c, 0x4a, 0xa9, 0x02, 0x55, 0x99, 0x89, 0xbd, 0xca, 0x05}: "DellPermanentDeviceDisablePei",
		efi.GUID{0x92, 0xc0, 0xfc, 0xbd, 0xa4, 0x36, 0x68, 0x46, 0xba, 0xfe, 0xec, 0x8f, 0x1b, 0x02, 0xa2, 0x8a}: "DellMultiFuncDevConfig",
		efi.GUID{0x92, 0xc9, 0xee, 0x8d, 0x9c, 0xd3, 0x5c, 0x4a, 0xab, 0x6b, 0x98, 0x6e, 0x14, 0x24, 0x2b, 0x9d}: "EfiDiskInfoSdMmcInterfaceGuid",
		efi.GUID{0x92, 0xcb, 0x62, 0x10, 0xa9, 0x72, 0xdc, 0x4f, 0x96, 0x94, 0xb1, 0xfe, 0x81, 0x7e, 0xfa, 0xaf}: "DustFilterAlertDxe",
		efi.GUID{0x92, 0xce, 0xae, 0xa6, 0x12, 0x00, 0x10, 0x4e, 0x88, 0xef, 0x58, 0x8d, 0x8d, 0xcc, 0xa8, 0xe4}: "DellSioIt8669eSmm",
		efi.GUID{0x92, 0xf7, 0xd1, 0x63, 0x31, 0x77, 0x44, 0x4a, 0xbc, 0x8e, 0x91, 0x80, 0xa3, 0x6f, 0xd0, 0xa8}: "IccOverClocking",
		efi.GUID{0x93, 0x00, 0xa1, 0x0a, 0x7a, 0xe9, 0x28, 0x4e, 0x8e, 0x77, 0x7c, 0xb3, 0x70, 0x41, 0xb2, 0x91}: "DeviceBlacklistWmi",
		efi.GUID{0x93, 0x0d, 0x73, 0x64, 0x5b, 0xe4, 0xf1, 0x4a, 0x91, 0xb3, 0x75, 0xb5, 0x2e, 0xcb, 0xfa, 0xe9}: "MrdMultiBoardSupport",
		efi.GUID{0x93, 0x0d, 0xf4, 0x48, 0x30, 0xaf, 0x10, 0x44, 0x9f, 0x4a, 0xff, 0x61, 0x94, 0x7e, 0x3f, 0x62}: "MAPS_WatchDogTimerPEI",
		efi.GUID{0x93, 0x0f, 0xee, 0xff, 0xca, 0x34, 0x3a, 0x43, 0xb4, 0x4a, 0x18, 0xc2, 0x5c, 0x1e, 0x61, 0x5e}: "RecoveryControl",
		efi.GUID{0x93, 0x11, 0x57, 0xb4, 0x1a, 0x96, 0x20, 0x4d, 0xa1, 0x11, 0x91, 0xc8, 0xb0, 0x24, 0xed, 0x79}: "SwSmi534D0640",
		efi.GUID{0x93, 0x17, 0x7c, 0x5c, 0x9b, 0xaa, 0x4e, 0x43, 0xb3, 0x07, 0xb7, 0xff, 0xca, 0xb4, 0x9f, 0xad}: "RTCWakeup",
		efi.GUID{0x93, 0x23, 0x6a, 0xd9, 0x90, 0x87, 0xaa, 0x4b, 0x9c, 0xeb, 0x42, 0x53, 0x3f, 0x01, 0x6e, 0xe9}: "RegAccessSMM",
		efi.GUID{0x93, 0x24, 0x39, 0xb0, 0x68, 0x4e, 0xc7, 0xce, 0x99, 0x2c, 0xf6, 0xb5, 0xe0, 0x29, 0xba, 0xd2}: "AmdSocAm4VmrPei",
		efi.GUID{0x93, 0x30, 0x29, 0x42, 0xb9, 0x76, 0x82, 0x44, 0x8c, 0x02, 0x3b, 0xef, 0xde, 0xa9, 0xb3, 0x5d}: "TcgSmm",
		efi.GUID{0x93, 0x34, 0x8d, 0xb1, 0x62, 0x7e, 0xdb, 0x48, 0xa4, 0xda, 0x81, 0x20, 0xbf, 0xb1, 0x43, 0x94}: "FdiskOemSmmProtocol",
		efi.GUID{0x93, 0x38, 0x94, 0x41, 0xd0, 0xcd, 0x3f, 0x4a, 0xba, 0x63, 0xd1, 0x32, 0x5e, 0x72, 0x06, 0x1a}: "LenovoHdpManagerPei",
		efi.GUID{0x93, 0x3d, 0xce, 0x62, 0xd8, 0x25, 0xe0, 0x48, 0xba, 0xb3, 0x1a, 0xbe, 0x7c, 0x25, 0xdc, 0x49}: "MctpSmbusDxe",
		efi.GUID{0x93, 0x3f, 0x9d, 0x52, 0xe9, 0xe8, 0x73, 0x4e, 0xb1, 0xe1, 0xbd, 0xf6, 0xa9, 0xd5, 0x01, 0x13}: "ArpDxe",
		efi.GUID{0x93, 0x47, 0xf6, 0x70, 0x23, 0xc3, 0x61, 0x42, 0xac, 0x2c, 0xd8, 0x76, 0xf2, 0x7c, 0x53, 0x45}: "EfiKmsFormatGeneric256Guid",
		efi.GUID{0x93, 0x53, 0xcb, 0xb5, 0xda, 0x7f, 0x83, 0x43, 0xb6, 0x60, 0x05, 0x5c, 0x7e, 0x8a, 0xd9, 0x91}: "KeyboardBacklightBin",
		efi.GUID{0x93, 0x56, 0x44, 0xa1, 0x59, 0x56, 0x0e, 0x03, 0xc2, 0x56, 0x42, 0xa1, 0x86, 0x8a, 0x6d, 0x9b}: "MktmeCoreInitPeim",
		efi.GUID{0x93, 0x5e, 0x15, 0xef, 0xb4, 0x2c, 0x72, 0x4a, 0x87, 0x20, 0x8b, 0x44, 0x7a, 0x91, 0xf5, 0x40}: "AmdSocFp6CznDxe",
		efi.GUID{0x93, 0x6e, 0x0a, 0xf7, 0xe1, 0x82, 0x6a, 0x4e, 0x9a, 0x26, 0xe7, 0xde, 0x6a, 0xce, 0x5b, 0xbb}: "PostScreenInfo",
		efi.GUID{0x93, 0x6e, 0x57, 0x09, 0x3f, 0x6d, 0xd2, 0x11, 0x8e, 0x39, 0x00, 0xa0, 0xc9, 0x69, 0x72, 0x3b}: "EfiFileSystemInfoGuid",
		efi.GUID{0x93, 0x79, 0xca, 0xa9, 0x8f, 0xfb, 0xe4, 0x4b, 0x8c, 0xe1, 0xe2, 0xab, 0x9f, 0x2e, 0xcd, 0x04}: "SGXSetupSmm",
		efi.GUID{0x93, 0x87, 0x44, 0x6e, 0xdf, 0x9c, 0x87, 0x47, 0x93, 0x92, 0x4b, 0x6a, 0x6d, 0x5f, 0xfc, 0xa8}: "DellHwManagerDxe",
		efi.GUID{0x93, 0x8a, 0x0c, 0xdb, 0xee, 0x57, 0x4e, 0x4e, 0xaa, 0x7d, 0x11, 0x79, 0x23, 0x4a, 0x7d, 0x63}: "DellRamDisk",
		efi.GUID{0x93, 0x8c, 0x04, 0x9b, 0xb1, 0x3f, 0x6d, 0x4f, 0x85, 0x92, 0x13, 0x3e, 0x26, 0xf9, 0x4f, 0xfd}: "DellStealthMode2Policy",
		efi.GUID{0x93, 0x90, 0xf8, 0x0b, 0x5e, 0x3e, 0x7a, 0x45, 0x8c, 0xa6, 0x62, 0x35, 0x29, 0x15, 0xa3, 0xb4}: "PHashDPei",
		efi.GUID{0x93, 0xaa, 0x7b, 0x77, 0x60, 0x92, 0x1b, 0x42, 0x91, 0x73, 0xfa, 0x62, 0x61, 0x1b, 0x61, 0x88}: "HciPei",
		efi.GUID{0x93, 0xac, 0xc9, 0xc6, 0xc8, 0xcf, 0x4c, 0x41, 0x87, 0x2b, 0xd0, 0x11, 0x6f, 0x07, 0x6b, 0xf9}: "HpThermalDiagsSioSmi",
		efi.GUID{0x93, 0xb8, 0x30, 0xd3, 0xfa, 0xc7, 0xcd, 0x4b, 0xb0, 0xbe, 0x64, 0xdf, 0xe9, 0x84, 0x15, 0xc2}: "FjRiserPowerDelivery",
		efi.GUID{0x93, 0xb9, 0x8b, 0xf8, 0x30, 0x92, 0xdf, 0x4c, 0x91, 0x6a, 0x7a, 0x2d, 0x3b, 0xde, 0xe6, 0x90}: "AppleStartupManagerPolicyDxe",
		efi.GUID{0x93, 0xc2, 0x46, 0x54, 0x9b, 0x33, 0xcd, 0x47, 0xb7, 0x19, 0x58, 0x5d, 0xe3, 0x94, 0x08, 0xcc}: "PostReport",
		efi.GUID{0x93, 0xc4, 0x14, 0x79, 0x39, 0xf4, 0x6c, 0x4c, 0xab, 0x23, 0x7f, 0x72, 0x15, 0x0e, 0x72, 0xd4}: "ImageAppleLogo",
		efi.GUID{0x93, 0xc9, 0xbe, 0x7a, 0xd6, 0x53, 0x4f, 0x46, 0x83, 0x71, 0xff, 0xaf, 0xd9, 0x7f, 0x39, 0x28}: "AmiCryptoPkgTokenSpace",
		efi.GUID{0x93, 0xd0, 0xb3, 0xa3, 0x04, 0x1b, 0xbf, 0x45, 0x8d, 0x23, 0x23, 0x34, 0x60, 0x7c, 0x7b, 0x40}: "PlatformDeepS5",
		efi.GUID{0x93, 0xd0, 0xef, 0xef, 0x9b, 0x0d, 0xeb, 0x46, 0xa8, 0x56, 0x48, 0x35, 0x07, 0x00, 0xc9, 0x08}: "EfiHiiImageDecoderNameJpegGuid",
		efi.GUID{0x93, 0xd6, 0x3a, 0xfa, 0x8a, 0xd5, 0x19, 0x46, 0x96, 0x0b, 0x8e, 0xe8, 0x5c, 0x91, 0x48, 0x70}: "PeiPciLibPciCfg2",
		efi.GUID{0x93, 0xdf, 0xcd, 0x86, 0x72, 0x48, 0x97, 0x45, 0x8a, 0xf9, 0xa3, 0x5a, 0xe4, 0xd3, 0x72, 0x5f}: "IScsiDxe",
		efi.GUID{0x93, 0xe0, 0x67, 0xa7, 0x8d, 0x45, 0xe4, 0x4d, 0xa2, 0xa2, 0x08, 0xc7, 0xcb, 0x5f, 0xb8, 0x44}: "DellFreeFallSensorPei",
		efi.GUID{0x93, 0xe3, 0x92, 0x6f, 0xc0, 0x03, 0x7b, 0x42, 0xbb, 0xeb, 0x4e, 0xf8, 0x07, 0xb5, 0x5b, 0xd8}: "IconNetworkRecovery",
		efi.GUID{0x93, 0xe9, 0x1c, 0x04, 0x77, 0x66, 0x20, 0x47, 0xa6, 0x65, 0x37, 0x5b, 0x80, 0xff, 0xe0, 0x12}: "DellFpThunk",
		efi.GUID{0x93, 0xe9, 0xc3, 0x87, 0x8d, 0xb2, 0x26, 0x42, 0x89, 0xc9, 0x12, 0x0d, 0xbc, 0x92, 0xac, 0xbf}: "SmBusSmm",
		efi.GUID{0x93, 0xec, 0x5b, 0x69, 0xae, 0x82, 0x17, 0x4c, 0xbd, 0xad, 0x7f, 0x18, 0x4f, 0x4e, 0x65, 0x1d}: "LibC",
		efi.GUID{0x93, 0xf3, 0x70, 0xa5, 0xf5, 0xb0, 0xa4, 0x44, 0x85, 0x50, 0x61, 0x60, 0x05, 0x97, 0xb4, 0x09}: "BootScriptHideDxe",
		efi.GUID{0x93, 0xfc, 0xad, 0xdd, 0xc5, 0xfb, 0x89, 0x43, 0xb2, 0x0f, 0xec, 0x99, 0xe4, 0xa6, 0xae, 0x52}: "SmmLibNull",
		efi.GUID{0x93, 0xfd, 0x65, 0x42, 0xa5, 0x28, 0x8d, 0x48, 0xa5, 0x72, 0x2a, 0x47, 0xb1, 0x05, 0x61, 0xc0}: "D01PeiCallback",
		efi.GUID{0x94, 0x00, 0xe4, 0x72, 0xe1, 0x2e, 0x7a, 0x49, 0x8f, 0x33, 0x4c, 0x93, 0x4a, 0x9e, 0x9c, 0x0c}: "EfiSmmSmbusProtocolGuid",
		efi.GUID{0x94, 0x0f, 0xa6, 0xe9, 0x8b, 0x7a, 0xba, 0x45, 0x9c, 0x32, 0x34, 0x85, 0x52, 0x6b, 0x57, 0x16}: "DellAcLossPei",
		efi.GUID{0x94, 0x0f, 0xb6, 0xe9, 0x0b, 0x7a, 0xcd, 0x48, 0x9c, 0x88, 0x84, 0x84, 0x52, 0x6c, 0x57, 0x19}: "DellSbConfigPei",
		efi.GUID{0x94, 0x12, 0x6e, 0x4b, 0xd2, 0x08, 0x31, 0x41, 0x83, 0xe4, 0x14, 0xbe, 0x9f, 0xcd, 0x42, 0xc1}: "AmdMemRestorePei",
		efi.GUID{0x94, 0x18, 0x85, 0x61, 0x92, 0x6b, 0xc8, 0x48, 0xa5, 0xeb, 0x4e, 0x2a, 0x5b, 0xcf, 0x3d, 0x5f}: "SmartCoverPortingDxe",
		efi.GUID{0x94, 0x1b, 0x19, 0xf2, 0xab, 0xdc, 0xff, 0x49, 0x8c, 0x8f, 0xa4, 0x1f, 0xa9, 0x90, 0x8d, 0x11}: "DeviceLayoutLoadDxe",
		efi.GUID{0x94, 0x1c, 0xc6, 0x54, 0x7d, 0x28, 0xc5, 0x4d, 0x99, 0xd5, 0xd3, 0x8d, 0x1a, 0x53, 0xae, 0x6b}: "PlatformInfoHob",
		efi.GUID{0x94, 0x1d, 0xa2, 0xe1, 0x20, 0x4a, 0x0e, 0x4e, 0xae, 0x09, 0xa9, 0xa2, 0x1f, 0x24, 0xbb, 0x9e}: "EfiMeFwSkuVariable",
		efi.GUID{0x94, 0x2a, 0x56, 0x84, 0xff, 0x1c, 0xdf, 0x11, 0xab, 0x3f, 0xfb, 0x61, 0xaa, 0x51, 0xc4, 0x1c}: "PmRuntimeDxe",
		efi.GUID{0x94, 0x2b, 0x05, 0x6f, 0xf5, 0x59, 0x06, 0x46, 0xa0, 0x17, 0x06, 0xcb, 0xdc, 0x5c, 0x20, 0xba}: "MctpSmbusSmm",
		efi.GUID{0x94, 0x2b, 0x9c, 0x61, 0x5a, 0xfe, 0xc3, 0x45, 0xb4, 0x45, 0xc6, 0xaf, 0x9b, 0xdd, 0x7c, 0xe0}: "BiosGuardSecSMIFlash",
		efi.GUID{0x94, 0x35, 0xcf, 0x0d, 0x8c, 0x31, 0x96, 0x45, 0xb0, 0x0f, 0xbe, 0x61, 0x84, 0x2d, 0xe3, 0xe2}: "SystemBootTypePeiPei",
		efi.GUID{0x94, 0x3d, 0xed, 0x61, 0xd8, 0x30, 0x8c, 0x40, 0x97, 0xdf, 0xde, 0xdf, 0x27, 0x40, 0xf6, 0x30}: "AmtLockPbtn",
		efi.GUID{0x94, 0x40, 0x6a, 0xd5, 0x0f, 0x57, 0x3d, 0x4d, 0x8f, 0x5f, 0x8d, 0x8a, 0xa0, 0xb3, 0x96, 0xcb}: "EhciPei",
		efi.GUID{0x94, 0x46, 0xf0, 0x02, 0x0a, 0x2c, 0x1e, 0x4f, 0xb0, 0xce, 0x64, 0xbe, 0x25, 0x89, 0x0b, 0x03}: "DebugAgentTimerLibNull",
		efi.GUID{0x94, 0x5d, 0xda, 0x0c, 0x1a, 0x95, 0x61, 0x4c, 0x8d, 0xd5, 0xe5, 0xbf, 0x34, 0xba, 0x69, 0xec}: "SlotDataUpdateDxeLightningRidgeEXECB1",
		efi.GUID{0x94, 0x5e, 0xee, 0x71, 0xb9, 0x65, 0xd5, 0x45, 0x82, 0x1a, 0x3a, 0x4d, 0x86, 0xcf, 0xe6, 0xbe}: "EfiUserCredentialProtocolGuid",
		efi.GUID{0x94, 0x5f, 0xe6, 0x53, 0x18, 0xb4, 0x41, 0x45, 0x9a, 0x12, 0x18, 0x83, 0x9a, 0x56, 0xb4, 0x27}: "Thc",
		efi.GUID{0x94, 0x61, 0x4f, 0x5b, 0xdb, 0x44, 0x79, 0x41, 0xb6, 0xf2, 0x7b, 0x94, 0xad, 0xad, 0x31, 0x2b}: "AsfDxe",
		efi.GUID{0x94, 0x65, 0xe5, 0x57, 0x95, 0xce, 0xad, 0x46, 0x95, 0x31, 0x3c, 0x49, 0x31, 0x0c, 0xa7, 0xce}: "Ofbd",
		efi.GUID{0x94, 0x76, 0xd2, 0x2d, 0x5c, 0xad, 0xc7, 0x4e, 0x98, 0x70, 0xbc, 0x58, 0xf9, 0xe1, 0x79, 0x31}: "FjBiosSetupOptionControlBin",
		efi.GUID{0x94, 0x7b, 0x08, 0x37, 0x41, 0xef, 0x77, 0x49, 0x93, 0xe2, 0x3f, 0x6a, 0xdf, 0xdd, 0x06, 0xe1}: "LenovoSplashDxe",
		efi.GUID{0x94, 0x7e, 0x89, 0x3b, 0x64, 0x48, 0x6b, 0x41, 0x83, 0x53, 0x94, 0x79, 0x32, 0x54, 0x97, 0xac}: "OemDxe",
		efi.GUID{0x94, 0x7f, 0xf7, 0x7a, 0x38, 0x4c, 0xf1, 0x4f, 0x8c, 0xcd, 0x3e, 0x08, 0x4f, 0x2f, 0xfe, 0xc0}: "SkylakeGraphics",
		efi.GUID{0x94, 0x8b, 0xff, 0x6b, 0x8e, 0xd9, 0x7e, 0x4c, 0x83, 0x00, 0xe5, 0xb6, 0x47, 0x01, 0xc1, 0x18}: "ApobZpRvDxe",
		efi.GUID{0x94, 0x8e, 0x29, 0xaa, 0x5d, 0xa4, 0xb5, 0x45, 0x8c, 0xe5, 0x4f, 0xb7, 0x1f, 0xba, 0x4c, 0xe0}: "RpmcSmm",
		efi.GUID{0x94, 0x93, 0x10, 0xf9, 0xa3, 0xe5, 0x61, 0x4e, 0xb1, 0x68, 0xdc, 0x34, 0xd5, 0x34, 0x45, 0x1e}: "DellBbsmanagerSmm",
		efi.GUID{0x94, 0x94, 0xa1, 0x71, 0xb6, 0x2a, 0x96, 0x4e, 0x85, 0x81, 0xcf, 0x34, 0x25, 0x42, 0x73, 0xfe}: "MeBiosPayloadDataProtocol",
		efi.GUID{0x94, 0x94, 0xdc, 0x0e, 0x43, 0x27, 0xa5, 0x4b, 0x88, 0x18, 0x0a, 0xef, 0x52, 0x13, 0xf1, 0x88}: "EfiExtendedSalCacheServicesProtocolGuid",
		efi.GUID{0x94, 0x99, 0xc6, 0x3f, 0x00, 0x19, 0x8b, 0x46, 0xb2, 0xd9, 0xe6, 0x16, 0x30, 0x56, 0xc3, 0xe7}: "Ast2500Pei",
		efi.GUID{0x94, 0x9b, 0x09, 0xd6, 0x97, 0xcd, 0xc5, 0x4c, 0x87, 0x14, 0x7f, 0x63, 0x12, 0x70, 0x1a, 0x8a}: "VirtioGpuDxe",
		efi.GUID{0x94, 0x9e, 0x43, 0x67, 0x37, 0xfd, 0x32, 0x4a, 0xbd, 0x53, 0x3b, 0x97, 0x38, 0x64, 0x32, 0xe4}: "Ahci",
		efi.GUID{0x94, 0x9f, 0xea, 0xc7, 0x47, 0x15, 0xf0, 0x44, 0x86, 0x3f, 0x56, 0x3e, 0xae, 0x79, 0xe1, 0xc0}: "TianoCompressSmm",
		efi.GUID{0x94, 0xa3, 0x99, 0x9d, 0x78, 0x18, 0x2c, 0x4d, 0x98, 0xe9, 0xc1, 0x6b, 0x8e, 0xc4, 0x79, 0x33}: "DramSharedMailBox",
		efi.GUID{0x94, 0xa7, 0x66, 0xc6, 0x6d, 0x40, 0x51, 0x4a, 0xb3, 0x03, 0xac, 0xfb, 0x59, 0x13, 0x7a, 0x05}: "UsbOcUpdateDxeEldorado",
		efi.GUID{0x94, 0xb5, 0x80, 0x37, 0xa4, 0x32, 0x93, 0x45, 0xb8, 0xce, 0x8a, 0x3f, 0x40, 0x4f, 0x61, 0xf4}: "PlatformToDriver",
		efi.GUID{0x94, 0xbe, 0x29, 0x8b, 0x8b, 0x5b, 0x04, 0x4e, 0xb7, 0x71, 0x57, 0x61, 0xff, 0x97, 0xb1, 0x13}: "FjFpCredentialProviderDxe",
		efi.GUID{0x94, 0xbf, 0x12, 0xc1, 0xd0, 0x5c, 0xec, 0x45, 0xaa, 0x7f, 0xd3, 0xde, 0xda, 0xab, 0x76, 0x5f}: "OemWSsdtDriver",
		efi.GUID{0x94, 0xc3, 0xe2, 0xe8, 0xb7, 0xa4, 0x83, 0x45, 0x8c, 0x43, 0xca, 0xec, 0x15, 0xc3, 0x49, 0x66}: "EmulatedEepromPei",
		efi.GUID{0x94, 0xd3, 0x65, 0x00, 0x51, 0x99, 0x44, 0x41, 0x82, 0xa3, 0x0a, 0xfc, 0x85, 0x79, 0xc2, 0x51}: "EfiPeiRscHandlerPpiGuid",
		efi.GUID{0x94, 0xd3, 0xc8, 0x90, 0x04, 0x4e, 0x9c, 0x43, 0xba, 0x55, 0x2d, 0x8c, 0xfc, 0xb4, 0x14, 0xed}: "SataDriver",
		efi.GUID{0x94, 0xd6, 0x83, 0x05, 0x8b, 0xaf, 0xaa, 0x4b, 0x95, 0x83, 0x81, 0x3c, 0xed, 0xf4, 0x08, 0x43}: "CsmInt10Block",
		efi.GUID{0x94, 0xe4, 0x23, 0xd4, 0xb6, 0x2d, 0x2e, 0x4d, 0xae, 0x23, 0x0a, 0x3d, 0x8d, 0x9d, 0x6e, 0x22}: "FjEPrivacyFilterSmm",
		efi.GUID{0x94, 0xf3, 0x3e, 0x63, 0x50, 0x89, 0x44, 0x45, 0x8a, 0xa3, 0xe6, 0xb0, 0xb7, 0x20, 0x14, 0xd8}: "AmdMemSmbiosV2RmbPei",
		efi.GUID{0x94, 0xf9, 0x69, 0x6f, 0x17, 0x7e, 0xfb, 0x45, 0xb6, 0x2a, 0xd7, 0x82, 0x31, 0x95, 0xbe, 0xab}: "AtaFreezeLockDxe",
		efi.GUID{0x94, 0xff, 0x92, 0x37, 0x14, 0x86, 0xed, 0x45, 0x90, 0x2b, 0x12, 0x07, 0xbf, 0x14, 0x90, 0xa8}: "PrintThunk",
		efi.GUID{0x95, 0x08, 0xf9, 0xd4, 0x0b, 0xa6, 0x97, 0x4e, 0xb4, 0x46, 0x28, 0x55, 0x24, 0x6f, 0x89, 0x30}: "AmdNbioBaseRVDxe",
		efi.GUID{0x95, 0x10, 0xc0, 0x6d, 0x01, 0x90, 0x4d, 0x4e, 0xb8, 0x52, 0xaf, 0x42, 0x9e, 0xad, 0xff, 0x57}: "OemPowerMgmtDxe",
		efi.GUID{0x95, 0x15, 0x57, 0xda, 0x99, 0x4d, 0x7c, 0x48, 0x82, 0x7c, 0x26, 0x22, 0x67, 0x7d, 0x33, 0x07}: "EfiStatusCodeDataTypeAssert",
		efi.GUID{0x95, 0x1d, 0xaf, 0x97, 0x3c, 0x20, 0xde, 0x42, 0x8d, 0x6b, 0xd1, 0x3e, 0xb7, 0xe5, 0xa5, 0x5a}: "PEFirmwareUpdateDxe",
		efi.GUID{0x95, 0x22, 0x12, 0xc9, 0xed, 0x56, 0x4e, 0x4d, 0x06, 0xa6, 0x50, 0x8d, 0x89, 0x4d, 0x3e, 0x40}: "FspApiPerformanceGuid",
		efi.GUID{0x95, 0x28, 0xa6, 0x71, 0xd4, 0x1c, 0x9a, 0x4b, 0xa7, 0x7b, 0x57, 0x1f, 0xd7, 0x1b, 0xef, 0xc9}: "OemAcpiDriver",
		efi.GUID{0x95, 0x28, 0xd4, 0xab, 0xcf, 0x78, 0x72, 0x48, 0x84, 0x44, 0x1b, 0x5c, 0x18, 0x0b, 0xfb, 0xda}: "EfiPeiSmbusPpiGuid",
		efi.GUID{0x95, 0x28, 0xd4, 0xab, 0xcf, 0x78, 0x72, 0x48, 0x84, 0x44, 0x1b, 0x5c, 0x18, 0x0b, 0xfb, 0xff}: "EfiPeiBootScriptExecuterPpiGuid",
		efi.GUID{0x95, 0x30, 0xbc, 0x68, 0x39, 0x88, 0x97, 0x4a, 0x8f, 0xea, 0xbe, 0xe0, 0x6e, 0xca, 0x7b, 0xbb}: "LenovoW25Q32FlashPartDxe",
		efi.GUID{0x95, 0x31, 0x8c, 0x57, 0xc1, 0xd8, 0xf1, 0x44, 0x8a, 0x06, 0x2b, 0x59, 0x2f, 0xbe, 0x6a, 0xf3}: "TouchInputFilterDriver",
		efi.GUID{0x95, 0x34, 0xa1, 0xa0, 0xbf, 0xa2, 0xe1, 0x44, 0x98, 0xf8, 0xcc, 0x08, 0xd1, 0xae, 0x60, 0x4a}: "OemPeiSetGpio",
		efi.GUID{0x95, 0x3a, 0xb3, 0x80, 0x78, 0xb9, 0x4a, 0x43, 0x91, 0x95, 0x3c, 0x11, 0x8e, 0x9f, 0x35, 0xcb}: "MsiBoardSmm",
		efi.GUID{0x95, 0x43, 0xd0, 0x21, 0xa0, 0x96, 0xd5, 0x4f, 0xb4, 0x77, 0xa9, 0x22, 0x64, 0x8e, 0xda, 0xf3}: "AsusSampleDxeWrapperPkg",
		efi.GUID{0x95, 0x46, 0x7b, 0xaa, 0xb4, 0x00, 0x68, 0x44, 0xad, 0x92, 0x99, 0x37, 0x0a, 0xc0, 0x31, 0xc5}: "LegacyRegion2",
		efi.GUID{0x95, 0x4f, 0x1c, 0x4e, 0xea, 0x90, 0xde, 0x47, 0x9a, 0xcc, 0xb8, 0x92, 0x01, 0x89, 0xa1, 0xf5}: "SecPeiFspPlatformSecLibSample",
		efi.GUID{0x95, 0x51, 0xac, 0x8d, 0xd5, 0x3f, 0x32, 0x4e, 0x9c, 0x2a, 0x1a, 0x65, 0xbd, 0x69, 0x99, 0x32}: "AmiTseOemPortingVar9",
		efi.GUID{0x95, 0x68, 0x80, 0x3d, 0x1e, 0xfb, 0x67, 0x4f, 0xa7, 0x0d, 0x5c, 0xc1, 0xa7, 0xd7, 0x18, 0x57}: "EcdHctm",
		efi.GUID{0x95, 0x74, 0x93, 0xf6, 0x44, 0x1f, 0x8a, 0x4a, 0x8a, 0x1b, 0x5a, 0x66, 0x9f, 0x93, 0x96, 0xf6}: "DevConsole",
		efi.GUID{0x95, 0x74, 0xfc, 0xdf, 0xad, 0x75, 0x54, 0x43, 0xab, 0x0a, 0xbd, 0xfd, 0x90, 0x46, 0x06, 0x7c}: "AbtErasePei",
		efi.GUID{0x95, 0x77, 0x7f, 0x98, 0x48, 0xe9, 0xac, 0x49, 0x83, 0x66, 0xfc, 0xc5, 0x1a, 0x95, 0xd6, 0xe1}: "AsusABMSetupItem",
		efi.GUID{0x95, 0x77, 0xe6, 0x81, 0xa3, 0xd8, 0xb2, 0x43, 0x8b, 0x5f, 0xe0, 0x32, 0x6f, 0x76, 0xab, 0x91}: "wifi_4bars",
		efi.GUID{0x95, 0x90, 0x46, 0x1e, 0xc8, 0xef, 0x47, 0x41, 0x97, 0xdb, 0x4d, 0x68, 0xb7, 0x27, 0xe2, 0xe0}: "FwBlockService",
		efi.GUID{0x95, 0x91, 0x56, 0xd9, 0x94, 0xed, 0xd2, 0x47, 0x95, 0x23, 0x38, 0xbf, 0x2d, 0x20, 0x13, 0x71}: "IntelPciDeviceSecurityDxe",
		efi.GUID{0x95, 0x95, 0xa5, 0xf6, 0x9f, 0xbb, 0x5b, 0x41, 0xa7, 0xf3, 0xdc, 0x7c, 0x09, 0x38, 0x7b, 0xe6}: "SmBusMemoryDown",
		efi.GUID{0x95, 0x9b, 0x1d, 0x62, 0x6a, 0x16, 0x2b, 0x43, 0x98, 0x2d, 0x2d, 0x4e, 0xec, 0x78, 0x75, 0xa6}: "UncoreMiscDxe",
		efi.GUID{0x95, 0xa6, 0x4e, 0x70, 0x73, 0xf3, 0xd4, 0x42, 0xbf, 0x1b, 0x44, 0xbb, 0x7f, 0x60, 0xc2, 0x95}: "menu_bottom_left",
		efi.GUID{0x95, 0xae, 0xfc, 0x3f, 0xcf, 0x23, 0x67, 0x49, 0x94, 0xf5, 0x16, 0x35, 0x2f, 0x68, 0xe4, 0x3b}: "PpmInitialize",
		efi.GUID{0x95, 0xb0, 0xf8, 0xbd, 0xe5, 0xed, 0x50, 0x42, 0xb5, 0x77, 0xc5, 0xcb, 0x55, 0x15, 0xb7, 0xae}: "AmdCpmABRecoveryDxe",
		efi.GUID{0x95, 0xb7, 0x2c, 0x95, 0x36, 0xff, 0xcf, 0x48, 0xa2, 0x49, 0x4d, 0xf4, 0x86, 0xd6, 0xab, 0x8d}: "EfiTlsServiceBindingProtocolGuid",
		efi.GUID{0x95, 0xc2, 0x26, 0xc4, 0x29, 0x98, 0x1e, 0x44, 0x93, 0x1e, 0x9c, 0xe3, 0x5e, 0x3f, 0x9f, 0xe6}: "UiThirdPartyApp",
		efi.GUID{0x95, 0xd2, 0x6a, 0x54, 0x64, 0x0c, 0xe6, 0x4c, 0xa0, 0x6f, 0xfb, 0x9c, 0xd0, 0x4b, 0x41, 0xcd}: "SystemFlashCommunicationDxe",
		efi.GUID{0x95, 0xe6, 0x22, 0xc5, 0xff, 0x93, 0xc7, 0x4a, 0x82, 0x20, 0xf8, 0x49, 0xc6, 0x8c, 0x53, 0x8f}: "APMDXE",
		efi.GUID{0x95, 0xee, 0x2e, 0x95, 0xaf, 0xa6, 0xda, 0x43, 0xa5, 0x59, 0xf3, 0x49, 0xa4, 0x6d, 0x71, 0x0a}: "SimpleBootFlag",
		efi.GUID{0x95, 0xee, 0x3f, 0x76, 0xa1, 0x85, 0x2e, 0x41, 0x92, 0x76, 0x01, 0xbe, 0x8f, 0xae, 0x6c, 0xe1}: "DellSetupASPMDxe",
		efi.GUID{0x95, 0xef, 0x4a, 0xe8, 0xa6, 0x7c, 0x2f, 0x4b, 0xa3, 0x98, 0xb1, 0x4d, 0x1c, 0x67, 0xa0, 0xb1}: "PchFlashControllerSmm",
		efi.GUID{0x95, 0xf0, 0x6f, 0x2c, 0x5c, 0x52, 0x28, 0x41, 0xbd, 0x00, 0xb8, 0xda, 0x5e, 0x52, 0xa7, 0x6e}: "AmdCpmSocAm4SmbRDxe",
		efi.GUID{0x95, 0xf4, 0x60, 0x9d, 0xf2, 0xdb, 0x06, 0x4b, 0xaf, 0xca, 0xf6, 0x2c, 0x1c, 0x89, 0x64, 0x7f}: "PasswordLockWhite",
		efi.GUID{0x95, 0xfa, 0x7c, 0x69, 0xf2, 0xb1, 0xd7, 0x4e, 0xa0, 0xd2, 0x7a, 0xc6, 0xe4, 0x7b, 0x3c, 0x99}: "HybridGraphicsDxe",
		efi.GUID{0x95, 0xfb, 0xc3, 0xca, 0xf5, 0x33, 0x96, 0x45, 0x81, 0x8b, 0x68, 0xe0, 0x24, 0xdd, 0xb6, 0x7b}: "IsSecRecoveryPEI",
		efi.GUID{0x95, 0xfd, 0xec, 0x3f, 0xb2, 0x7c, 0x6e, 0x4a, 0x8f, 0xac, 0xde, 0xfd, 0x99, 0x47, 0xe3, 0x5e}: "ReportFvPei",
		efi.GUID{0x95, 0xff, 0x98, 0xec, 0x2c, 0x24, 0x13, 0x45, 0xb1, 0xbc, 0x69, 0xfa, 0x24, 0x11, 0x1c, 0x58}: "AcpiDebugDxe",
		efi.GUID{0x96, 0x04, 0x6c, 0x4d, 0xe4, 0x8d, 0xf2, 0x4a, 0x9a, 0x2e, 0x9b, 0xe5, 0xb9, 0x15, 0x6a, 0xc5}: "AmiPerfTuneDataHob",
		efi.GUID{0x96, 0x0e, 0xbc, 0xb7, 0xd2, 0x57, 0x10, 0x43, 0xae, 0xef, 0x74, 0xac, 0x77, 0xdf, 0x0d, 0xaf}: "SetupXpBoot",
		efi.GUID{0x96, 0x1a, 0x35, 0xc7, 0x15, 0x92, 0x26, 0x40, 0xbc, 0xbd, 0x12, 0xd6, 0xe7, 0xdb, 0x36, 0xe9}: "SystemFormBrowserMetroViewDxe",
		efi.GUID{0x96, 0x21, 0xc0, 0x0d, 0xc8, 0xce, 0x0e, 0x4a, 0x9d, 0xcd, 0xb0, 0xde, 0x59, 0xd8, 0x62, 0x04}: "Wcn685xLauncher",
		efi.GUID{0x96, 0x28, 0xd1, 0x81, 0x5e, 0x97, 0x7f, 0x48, 0xae, 0x40, 0x1c, 0x37, 0xb4, 0xd7, 0xa8, 0x20}: "DeviceWufuEsrtDxe",
		efi.GUID{0x96, 0x2a, 0x21, 0x81, 0xed, 0x09, 0x96, 0x49, 0x94, 0x71, 0x8d, 0x72, 0x9c, 0x8e, 0x69, 0xed}: "EfiFirmwareErrorSectionGuid",
		efi.GUID{0x96, 0x2f, 0x29, 0x4e, 0x43, 0xd8, 0x55, 0x4a, 0xa8, 0xc2, 0xd4, 0x81, 0xf2, 0x7e, 0xbe, 0xee}: "EfiEventNotificationTypeCpeGuid",
		efi.GUID{0x96, 0x35, 0x1b, 0xe7, 0x9e, 0x10, 0x42, 0x46, 0xa4, 0x32, 0xfc, 0xf4, 0x97, 0xf8, 0xda, 0xe7}: "FchKeithSmmInit",
		efi.GUID{0x96, 0x39, 0x06, 0xce, 0x4e, 0x6c, 0x31, 0x45, 0xa1, 0x8e, 0x63, 0x5e, 0xdd, 0x44, 0x7a, 0x36}: "ShmInitPei",
		efi.GUID{0x96, 0x57, 0x39, 0xd4, 0x4c, 0x6f, 0x6b, 0x4c, 0xb9, 0xd1, 0x92, 0xda, 0xa7, 0x19, 0x9a, 0x84}: "AmiRedFishApi",
		efi.GUID{0x96, 0x5c, 0x83, 0x62, 0xb8, 0x19, 0x6d, 0x4d, 0xbe, 0x13, 0x3a, 0xa1, 0x84, 0x78, 0x43, 0x44}: "SbSocStarshipSp3Pei",
		efi.GUID{0x96, 0x65, 0x5b, 0x75, 0x96, 0x68, 0xa3, 0x4b, 0xb3, 0xdd, 0x1c, 0x62, 0x9f, 0xd1, 0xea, 0x88}: "AmiFlashProtocolGuid",
		efi.GUID{0x96, 0x65, 0x68, 0xd9, 0xc4, 0x5b, 0x61, 0x48, 0x82, 0xb3, 0x17, 0x62, 0x60, 0xcb, 0x19, 0x65}: "AMDNavi",
		efi.GUID{0x96, 0x66, 0x5b, 0x6d, 0xee, 0xf2, 0x29, 0x47, 0x97, 0xd3, 0xa7, 0xb8, 0xee, 0xf3, 0xdb, 0xbe}: "LegacySioDxe",
		efi.GUID{0x96, 0x69, 0xc3, 0x66, 0x2e, 0xc6, 0x13, 0x4d, 0xbf, 0x9a, 0x75, 0x6e, 0x66, 0xb0, 0x1a, 0x3d}: "StoreRestoreMbrDefaultsAndWmi",
		efi.GUID{0x96, 0x70, 0x06, 0x12, 0xaf, 0x18, 0xdd, 0x41, 0xb4, 0xf1, 0xd2, 0x95, 0x92, 0x28, 0x30, 0x62}: "SystemDeviceModePrivateWmiSmm",
		efi.GUID{0x96, 0x79, 0x3d, 0x42, 0xc3, 0xe4, 0x88, 0x4d, 0xbe, 0xfb, 0x0a, 0x60, 0x25, 0x76, 0xca, 0xcd}: "PlatformSpdReadPei",
		efi.GUID{0x96, 0x8a, 0x53, 0x98, 0x16, 0x61, 0xe1, 0x4b, 0xa6, 0x09, 0xbb, 0xcc, 0xcc, 0x2e, 0x0d, 0x15}: "VariableProviderSmm",
		efi.GUID{0x96, 0x8d, 0x68, 0x04, 0x68, 0x34, 0x52, 0x4d, 0x97, 0x27, 0x35, 0x7b, 0x9a, 0xed, 0x67, 0x27}: "FchPromontoryPlusCbsPei",
		efi.GUID{0x96, 0x96, 0x50, 0x4e, 0x3f, 0xe3, 0x8e, 0x40, 0x9a, 0xf5, 0xcc, 0x8c, 0x20, 0x06, 0x53, 0x85}: "SoftwareGuardConfigGuid",
		efi.GUID{0x96, 0x97, 0x89, 0x9f, 0x84, 0x1a, 0x1e, 0x46, 0x95, 0x23, 0xf1, 0xb8, 0x5c, 0xe8, 0x95, 0xb5}: "RTL8111D",
		efi.GUID{0x96, 0x9d, 0x8e, 0x1a, 0xe6, 0x66, 0x1b, 0x46, 0x95, 0xd6, 0x88, 0x2c, 0x98, 0x4d, 0x0b, 0x00}: "TbtPei",
		efi.GUID{0x96, 0xa6, 0x02, 0x77, 0x21, 0x65, 0xe8, 0x4f, 0xa7, 0x86, 0x52, 0x8b, 0x4d, 0x86, 0xf5, 0xf1}: "DfciDevSettingsMgr",
		efi.GUID{0x96, 0xab, 0x6d, 0x5b, 0x5d, 0x19, 0x24, 0x4d, 0x97, 0x27, 0xa7, 0xd0, 0xe9, 0x36, 0x65, 0xc6}: "IconSD",
		efi.GUID{0x96, 0xab, 0xa6, 0x24, 0x00, 0x8a, 0xc6, 0x4c, 0xba, 0xe7, 0x63, 0xa9, 0xd3, 0xdd, 0x3b, 0x42}: "SuperIoExDxe",
		efi.GUID{0x96, 0xac, 0x49, 0x37, 0xb8, 0x24, 0xe2, 0x44, 0xb8, 0x95, 0x4f, 0xab, 0xec, 0x4c, 0xf4, 0x0f}: "ErrorLogWmi",
		efi.GUID{0x96, 0xb4, 0xc0, 0xfc, 0x2a, 0x19, 0xb4, 0x48, 0xbe, 0x7e, 0x7f, 0x87, 0x63, 0xdd, 0x2f, 0xb1}: "FjFextDxe",
		efi.GUID{0x96, 0xc0, 0x7d, 0x51, 0xfc, 0xef, 0x37, 0x49, 0x80, 0x02, 0x87, 0xf8, 0xb1, 0xbf, 0x94, 0xbf}: "ResetHandler",
		efi.GUID{0x96, 0xc2, 0x33, 0xef, 0x4c, 0xf6, 0x46, 0x41, 0xad, 0x04, 0x34, 0x78, 0x99, 0x70, 0x2c, 0x84}: "SystemSmmUsbLegacySmm",
		efi.GUID{0x96, 0xcc, 0xbd, 0xf2, 0x85, 0x89, 0xdb, 0x11, 0x87, 0x19, 0x00, 0x40, 0xd0, 0x2b, 0x18, 0x35}: "EmuPhysicalDisksGuid",
		efi.GUID{0x96, 0xd0, 0x2e, 0x1e, 0xe2, 0x30, 0x54, 0x42, 0xbd, 0x89, 0x86, 0x3b, 0xbe, 0xf8, 0x23, 0x25}: "EfiTcg2FinalEventsTableGuid",
		efi.GUID{0x96, 0xe4, 0xe0, 0x1e, 0xb4, 0x28, 0x0b, 0x44, 0xa4, 0x5a, 0x74, 0x64, 0xbf, 0x4b, 0x32, 0xa2}: "FjUsbSecurityV",
		efi.GUID{0x96, 0xf7, 0x1e, 0xc6, 0x0d, 0xb5, 0x98, 0x4f, 0x9f, 0x78, 0x4f, 0x6f, 0x79, 0xd8, 0x00, 0xd5}: "MemoryInit",
		efi.GUID{0x96, 0xf8, 0x13, 0xe1, 0xcf, 0x75, 0x40, 0xf6, 0x81, 0x7f, 0xc8, 0x5a, 0x79, 0xe8, 0xae, 0x67}: "EmuThunkPpiGuid",
		efi.GUID{0x96, 0xfb, 0xcd, 0xab, 0x90, 0xed, 0x7e, 0x4c, 0xa8, 0x2b, 0xec, 0x98, 0xf9, 0x93, 0x05, 0xed}: "CbsBasePeiSSP",
		efi.GUID{0x96, 0xfe, 0x05, 0xe4, 0x56, 0x5a, 0xba, 0x40, 0xbc, 0x24, 0x61, 0x9c, 0x89, 0xe2, 0xd2, 0xee}: "EfiBmcSmbiosProtocol",
		efi.GUID{0x96, 0xff, 0x4b, 0x75, 0x34, 0x12, 0x41, 0x4b, 0xb4, 0x37, 0xef, 0x1b, 0x0c, 0x8c, 0xa1, 0x55}: "KEMrPegConfigPei",
		efi.GUID{0x97, 0x0c, 0x5a, 0x94, 0x82, 0x48, 0x0a, 0x41, 0x9f, 0x30, 0xe3, 0x1c, 0x99, 0x39, 0x8f, 0x7b}: "DxeIchSpiDxe",
		efi.GUID{0x97, 0x15, 0xdd, 0xa9, 0xc5, 0xf2, 0xb6, 0x4c, 0xaa, 0x7b, 0xee, 0x01, 0xae, 0x80, 0x61, 0x85}: "AmiSmmNvmeControllerProtocolGuid",
		efi.GUID{0x97, 0x21, 0x79, 0xb0, 0xc3, 0xab, 0xb1, 0x4b, 0x9f, 0xd3, 0xcb, 0xea, 0x8f, 0xd4, 0x13, 0x73}: "BaseAmiBeepLibNull",
		efi.GUID{0x97, 0x23, 0xdd, 0xcb, 0xc5, 0xd2, 0x5b, 0x41, 0xbd, 0x77, 0x96, 0x30, 0xa1, 0xb7, 0x85, 0x3d}: "EfiPeiIpmiUsbTransportPpi",
		efi.GUID{0x97, 0x39, 0xfb, 0xf6, 0xef, 0xf4, 0x54, 0x43, 0xb9, 0xc2, 0x47, 0x37, 0xaf, 0xed, 0x4f, 0x2f}: "AsusWifiRealtek",
		efi.GUID{0x97, 0x40, 0x56, 0xb7, 0x9b, 0x95, 0x0e, 0x47, 0x95, 0x4d, 0x92, 0x0e, 0xc4, 0x9d, 0xe1, 0x9c}: "AmdLegacyInterrupt",
		efi.GUID{0x97, 0x41, 0x5f, 0x87, 0xfc, 0x2a, 0xf5, 0x42, 0xb0, 0x90, 0x4d, 0xf0, 0x3b, 0x1d, 0xa6, 0x13}: "SpanishDxe",
		efi.GUID{0x97, 0x42, 0xae, 0x78, 0x0f, 0xc1, 0x77, 0x4d, 0xb6, 0xec, 0x52, 0x1f, 0x34, 0xbf, 0x06, 0xf8}: "SmbiosDataUpdateDxeEldorado",
		efi.GUID{0x97, 0x44, 0x91, 0x36, 0x9c, 0x3e, 0x45, 0x47, 0xa7, 0xe0, 0x44, 0x05, 0x8e, 0x0a, 0x91, 0x21}: "IncreaseIdleFanSpeedSmm",
		efi.GUID{0x97, 0x68, 0x34, 0x74, 0x0c, 0x9e, 0x41, 0x4b, 0xbf, 0x1f, 0xba, 0xa1, 0xec, 0xb8, 0x5d, 0xa6}: "IioCfgUpdateDxeLightningRidgeEXRP",
		efi.GUID{0x97, 0x69, 0x78, 0xc8, 0xd7, 0x70, 0x45, 0x44, 0xa5, 0xa8, 0xe5, 0xc9, 0xc8, 0xdd, 0x56, 0xc6}: "MasterPswd",
		efi.GUID{0x97, 0x6b, 0x34, 0xeb, 0x5f, 0x97, 0x9f, 0x4a, 0x8b, 0x22, 0xf8, 0xe9, 0x2b, 0xb3, 0xd5, 0x69}: "EfiSmmCpuProtocolGuid",
		efi.GUID{0x97, 0x72, 0x72, 0x72, 0x14, 0xbc, 0x86, 0x48, 0xa6, 0x42, 0x61, 0x7b, 0xc5, 0x0a, 0x52, 0x65}: "IccInitDxe",
		efi.GUID{0x97, 0x7a, 0x9c, 0xe5, 0xe9, 0x7f, 0x32, 0x4e, 0x95, 0xb0, 0x70, 0x8e, 0xb5, 0x8a, 0xf5, 0x07}: "DellSmmPaidSupDevPolicyProtocol",
		efi.GUID{0x97, 0x7c, 0xde, 0xaa, 0xe7, 0x98, 0xfa, 0x4c, 0xb4, 0xef, 0xbb, 0xe2, 0x05, 0x06, 0xa3, 0x1d}: "EcIoSmmProtocol",
		efi.GUID{0x97, 0x7f, 0xb1, 0x8a, 0x8f, 0x75, 0xaa, 0x47, 0xba, 0x64, 0xdd, 0xc6, 0x3c, 0x3a, 0x1d, 0x86}: "H19DbxService",
		efi.GUID{0x97, 0x82, 0x06, 0x03, 0xa5, 0xdd, 0xcd, 0x4c, 0xbb, 0xfa, 0x7e, 0x09, 0xae, 0x02, 0x51, 0x77}: "I2cTouchPanelDxe",
		efi.GUID{0x97, 0x87, 0x7e, 0x58, 0xfb, 0xc2, 0xb7, 0x41, 0xae, 0x9b, 0xf5, 0x3a, 0x6c, 0x56, 0x2d, 0xf5}: "DellCsmConfig",
		efi.GUID{0x97, 0x91, 0x69, 0x3c, 0x3c, 0x09, 0x69, 0x4c, 0xb0, 0x6b, 0x12, 0x8a, 0xe3, 0x48, 0x1d, 0xc9}: "EfiAcpiDescriptionGuid",
		efi.GUID{0x97, 0x9c, 0x63, 0xdf, 0xdd, 0x21, 0xaf, 0x48, 0xa0, 0xde, 0x78, 0xcc, 0x2d, 0x95, 0xdc, 0x55}: "DefaultsManagerDxe",
		efi.GUID{0x97, 0xa4, 0x87, 0x76, 0x4e, 0xff, 0xff, 0x48, 0xbc, 0xaa, 0x67, 0xdb, 0xf6, 0x5c, 0x42, 0xd1}: "AsrockBfgdxe",
		efi.GUID{0x97, 0xa6, 0xe1, 0xcd, 0xeb, 0x5b, 0x4a, 0x7e, 0x95, 0xd8, 0x40, 0x78, 0xe5, 0x64, 0xe7, 0x0c}: "PngConvert",
		efi.GUID{0x97, 0xb0, 0x66, 0xe5, 0x78, 0x43, 0x5f, 0x48, 0x91, 0xd0, 0x1c, 0x09, 0x7c, 0x19, 0x0c, 0xe2}: "PowerButton",
		efi.GUID{0x97, 0xc6, 0x3e, 0x7b, 0xac, 0x49, 0x66, 0x49, 0x95, 0x8d, 0x97, 0x03, 0xf7, 0xf8, 0x36, 0xb2}: "PlatformHardwareHarden",
		efi.GUID{0x97, 0xd6, 0x3e, 0x4a, 0xbc, 0xe9, 0xfe, 0x40, 0xbd, 0xd5, 0x6f, 0x99, 0xfc, 0xdc, 0xe9, 0xf4}: "AmdNbioAlibZpDxe",
		efi.GUID{0x97, 0xe4, 0x3f, 0xb7, 0x2e, 0xb9, 0x6e, 0x41, 0x83, 0x26, 0x45, 0xad, 0x0d, 0x27, 0x00, 0x92}: "IbbrFirmwareFileSystemFvGuid",
		efi.GUID{0x97, 0xe5, 0x1b, 0x16, 0xc5, 0xe9, 0xdb, 0x49, 0xae, 0x50, 0xc4, 0x62, 0xab, 0x54, 0xee, 0xda}: "PowerManagementAcpiTables2",
		efi.GUID{0x97, 0xe6, 0x14, 0xdc, 0x5a, 0x77, 0x3b, 0x4c, 0xa1, 0x1a, 0xed, 0xc3, 0x8e, 0x1b, 0xe3, 0xe6}: "AmiCsmOpromPolicyProtocolGuid",
		efi.GUID{0x97, 0xed, 0x9e, 0xa7, 0x98, 0x4b, 0x74, 0x49, 0x96, 0x90, 0x37, 0xb3, 0x2d, 0x6a, 0x5b, 0x56}: "RTSMArmVExpressLibSec",
		efi.GUID{0x97, 0xf0, 0x3d, 0x23, 0x18, 0x32, 0xb2, 0x47, 0x9e, 0x09, 0xfe, 0x58, 0xc2, 0xb2, 0x0d, 0x22}: "LenovoPlatformStage2Pei",
		efi.GUID{0x97, 0xf2, 0x6b, 0xad, 0x16, 0x4e, 0x91, 0x4a, 0x84, 0x3c, 0xff, 0xcf, 0xbf, 0x98, 0x6e, 0x51}: "SecureBIOCamera",
		efi.GUID{0x98, 0x03, 0x43, 0xaa, 0x8a, 0x3c, 0x17, 0x48, 0x8e, 0xd0, 0x62, 0x91, 0xb5, 0xc7, 0x7d, 0x6a}: "RTL8111HN",
		efi.GUID{0x98, 0x0d, 0x51, 0x81, 0x10, 0x21, 0x9f, 0x48, 0x8e, 0x26, 0x7f, 0xe8, 0x25, 0xcd, 0x83, 0x7e}: "LenovoVariableCommandSmiDispatch",
		efi.GUID{0x98, 0x16, 0x45, 0x67, 0x25, 0x18, 0xc5, 0x4a, 0x99, 0x9d, 0xf3, 0x50, 0xcc, 0x7d, 0x5d, 0x72}: "CryptoPPI",
		efi.GUID{0x98, 0x17, 0xd9, 0x8d, 0x87, 0xee, 0x0e, 0x4f, 0x8a, 0x84, 0x3f, 0x99, 0x83, 0x11, 0xf9, 0x30}: "ArpDxe",
		efi.GUID{0x98, 0x18, 0xca, 0x0c, 0x36, 0xd9, 0x86, 0x43, 0x87, 0x2b, 0x73, 0x4f, 0xe8, 0x50, 0xdc, 0x49}: "FjIbvSfuOverrideAbstractionDxeProtocol",
		efi.GUID{0x98, 0x19, 0x4a, 0xaf, 0x49, 0x49, 0x45, 0x45, 0x9c, 0x4c, 0xc1, 0xe7, 0xc0, 0x42, 0xe0, 0x56}: "ScPcieDeviceTablePpiGuid",
		efi.GUID{0x98, 0x1c, 0x88, 0x42, 0xf3, 0xa4, 0xb0, 0x44, 0xa3, 0x9d, 0xdf, 0xa1, 0x86, 0x67, 0xd8, 0xcd}: "EfiHashServiceBindingProtocolGuid",
		efi.GUID{0x98, 0x29, 0xff, 0x12, 0x9f, 0x42, 0x0b, 0x40, 0xb9, 0xee, 0xfe, 0xa8, 0x28, 0x7a, 0x1d, 0xfe}: "FjAbtDxe",
		efi.GUID{0x98, 0x2d, 0xdf, 0x3a, 0x5a, 0x69, 0x7d, 0x4e, 0xbe, 0x98, 0x58, 0x31, 0x45, 0x36, 0xd2, 0xe8}: "SimplifiedChineseDxe",
		efi.GUID{0x98, 0x37, 0xb1, 0xb9, 0x09, 0xd4, 0x58, 0x4d, 0x86, 0xe5, 0xb1, 0x83, 0x6c, 0xbe, 0xf3, 0x87}: "DxeOverClock",
		efi.GUID{0x98, 0x39, 0xb9, 0xbc, 0x48, 0x00, 0x9e, 0x4e, 0x94, 0x94, 0x46, 0xbe, 0xdf, 0x8d, 0x8a, 0x06}: "PchSmiDispatcher",
		efi.GUID{0x98, 0x4f, 0x08, 0xff, 0xd2, 0xb1, 0xf8, 0x49, 0xaa, 0x57, 0xe7, 0xee, 0xe7, 0xc4, 0x8a, 0x12}: "VbtMipiPanel3Guid",
		efi.GUID{0x98, 0x57, 0xd3, 0xc7, 0xd2, 0xe4, 0x93, 0x4a, 0xb1, 0x45, 0x54, 0x88, 0x9f, 0x02, 0x58, 0x4b}: "EdkiiNonDiscoverableAhciDeviceGuid",
		efi.GUID{0x98, 0x58, 0x4e, 0xee, 0x14, 0x39, 0x59, 0x42, 0x9d, 0x6e, 0xdc, 0x7b, 0xd7, 0x94, 0x03, 0xcf}: "LzmaCustomDecompressGuid",
		efi.GUID{0x98, 0x5b, 0x96, 0x78, 0xbf, 0xb0, 0x9e, 0x44, 0x8b, 0x22, 0xd2, 0x91, 0x4e, 0x49, 0x8a, 0x98}: "EfiSmmStandbyButtonDispatchProtocolGuid",
		efi.GUID{0x98, 0x60, 0x23, 0xaa, 0xc3, 0x86, 0x56, 0x4a, 0x8b, 0x89, 0xb7, 0x15, 0xe0, 0x4a, 0xb5, 0xce}: "SsidPei",
		efi.GUID{0x98, 0x60, 0x34, 0x1b, 0x0b, 0xab, 0xe7, 0x4a, 0xdd, 0xbe, 0x88, 0xab, 0x3c, 0xd6, 0x22, 0x0d}: "BatteryIdm",
		efi.GUID{0x98, 0x60, 0x34, 0x2b, 0x0b, 0xaa, 0xe7, 0x4a, 0xbd, 0xbe, 0x88, 0xeb, 0x3c, 0xd6, 0x22, 0x0f}: "BiosDiags20",
		efi.GUID{0x98, 0x68, 0x8c, 0xa3, 0x5c, 0x2b, 0xf6, 0x4f, 0x93, 0x26, 0x2e, 0x63, 0x21, 0x2e, 0x56, 0xc2}: "PeiSpiPpiGuid",
		efi.GUID{0x98, 0x74, 0x23, 0x01, 0x20, 0x4e, 0xe5, 0x42, 0xbf, 0x75, 0x1c, 0xd3, 0xb2, 0x0f, 0x7c, 0xe3}: "PlatformStatusCodeHandlerPei",
		efi.GUID{0x98, 0x76, 0xfa, 0x13, 0x31, 0xc8, 0xc7, 0x49, 0x87, 0xea, 0x8f, 0x43, 0xfc, 0xc2, 0x51, 0x96}: "EfiEventVirtualAddressChangeGuid",
		efi.GUID{0x98, 0x80, 0xe6, 0x81, 0x95, 0x6f, 0xe8, 0x4c, 0xaa, 0x8f, 0xa7, 0xff, 0xc8, 0x9e, 0x0b, 0x9d}: "AmdGopConfigDrvDxe",
		efi.GUID{0x98, 0x8c, 0xbf, 0x3b, 0xe5, 0x7f, 0x28, 0x47, 0xad, 0x52, 0x1e, 0x07, 0xe5, 0x71, 0xd6, 0x10}: "PlatformWrapperPei",
		efi.GUID{0x98, 0x8e, 0x9e, 0x07, 0x93, 0xae, 0x9a, 0x4b, 0x8a, 0x71, 0x1d, 0xc8, 0x69, 0xf2, 0x3e, 0x09}: "ShellSortTestApp",
		efi.GUID{0x98, 0x93, 0x1e, 0x17, 0x9c, 0x26, 0x81, 0x40, 0x90, 0x99, 0x38, 0x44, 0xe2, 0x60, 0x46, 0x6c}: "EfiPlatformTypeProtocol",
		efi.GUID{0x98, 0x9c, 0x70, 0x07, 0x4a, 0x41, 0x39, 0x40, 0xb7, 0xd0, 0x29, 0xc2, 0x1f, 0x10, 0x5e, 0x92}: "AcpiPlatformFeatures",
		efi.GUID{0x98, 0xad, 0x8d, 0x7b, 0x25, 0x4b, 0x8a, 0x43, 0xbc, 0x31, 0xf6, 0xcc, 0x93, 0x1d, 0x5b, 0xb4}: "PlatformInitRecoveryPei",
		efi.GUID{0x98, 0xad, 0xdb, 0x7a, 0xe1, 0x7f, 0x74, 0x47, 0x92, 0x60, 0x74, 0x73, 0x27, 0x43, 0x5e, 0x6d}: "SpsAcpiHooks",
		efi.GUID{0x98, 0xb6, 0x58, 0x46, 0xb5, 0xea, 0x7a, 0x64, 0x98, 0x7a, 0x5a, 0x16, 0x65, 0x47, 0x8f, 0xf6}: "A01SysPasswordSmm",
		efi.GUID{0x98, 0xb6, 0xee, 0x42, 0x81, 0xb8, 0x7a, 0x64, 0x32, 0x4a, 0x5a, 0x16, 0xee, 0xaa, 0x9f, 0x3e}: "A01SysPassword",
		efi.GUID{0x98, 0xba, 0xc5, 0xe4, 0x85, 0xb6, 0x68, 0x43, 0x8d, 0x40, 0xb8, 0x00, 0x95, 0xfc, 0x05, 0x64}: "HpIcicleDxe",
		efi.GUID{0x98, 0xbc, 0xad, 0x7d, 0x89, 0x64, 0x1c, 0x4d, 0x90, 0x7a, 0x8e, 0xe2, 0x43, 0xaf, 0x80, 0x5b}: "ASUS_EUPPEI",
		efi.GUID{0x98, 0xc5, 0x87, 0x07, 0xc6, 0xf9, 0x7f, 0x4b, 0x8c, 0x85, 0x0c, 0x96, 0xc4, 0xe1, 0xe5, 0x31}: "FjHookFormBrowserDxe",
		efi.GUID{0x98, 0xc7, 0x37, 0x22, 0xe7, 0x93, 0x19, 0x41, 0xb1, 0x0c, 0xcf, 0x75, 0xcd, 0x22, 0xbf, 0xe0}: "AmdApcbZpDxe",
		efi.GUID{0x98, 0xca, 0x03, 0xe5, 0x3e, 0xb6, 0x92, 0x45, 0x9b, 0xcd, 0x5a, 0x44, 0x52, 0x35, 0x51, 0x34}: "SmmResourceCheckDxe",
		efi.GUID{0x98, 0xcb, 0x08, 0x7a, 0xbc, 0xe9, 0xc3, 0x41, 0xbe, 0x19, 0xb3, 0x02, 0xf3, 0xf1, 0xf5, 0x23}: "DellSolPostMessage",
		efi.GUID{0x98, 0xcb, 0x08, 0x7a, 0xbc, 0xe9, 0xc3, 0x41, 0xbe, 0x19, 0xb3, 0x02, 0xf3, 0xf1, 0xf5, 0x95}: "Terminal",
		efi.GUID{0x98, 0xcb, 0xc3, 0xda, 0x95, 0x22, 0x2e, 0x41, 0x82, 0x6d, 0xfd, 0xee, 0xa3, 0x20, 0xcf, 0x31}: "AmiRecoveryImageHobGuid",
		efi.GUID{0x98, 0xd8, 0x94, 0xfb, 0xd5, 0x57, 0x24, 0x46, 0xae, 0xe5, 0x05, 0x51, 0xae, 0x69, 0x2e, 0x9f}: "KEMhTstMode",
		efi.GUID{0x98, 0xde, 0x20, 0x58, 0x8e, 0xfc, 0x0b, 0x4b, 0xa4, 0xb9, 0x0a, 0x94, 0x0d, 0x16, 0x2a, 0x7e}: "SioDevStatusVar",
		efi.GUID{0x98, 0xde, 0xef, 0x52, 0x81, 0x4c, 0x23, 0x44, 0x8c, 0x6d, 0x4e, 0xca, 0xe6, 0x1d, 0xdd, 0xd9}: "UsbOcUpdateDxeGlacier",
		efi.GUID{0x98, 0xe7, 0xaf, 0xa6, 0x26, 0xa4, 0x51, 0x46, 0xaa, 0x19, 0xbb, 0x0a, 0x44, 0x8d, 0x81, 0x34}: "FrameworkHiiAlias",
		efi.GUID{0x98, 0xef, 0xee, 0x7b, 0x28, 0x30, 0x60, 0x42, 0x96, 0xf1, 0xbe, 0xeb, 0xa3, 0x1a, 0x78, 0x7c}: "OemSioResChangePei",
		efi.GUID{0x98, 0xf1, 0x12, 0xa9, 0x0e, 0x7f, 0x03, 0x48, 0xb9, 0x08, 0xb7, 0x57, 0xb8, 0x06, 0xec, 0x83}: "Hello",
		efi.GUID{0x98, 0xf1, 0x12, 0xb9, 0x0e, 0x7f, 0x03, 0x48, 0xb9, 0x08, 0xb7, 0x57, 0xb8, 0x06, 0xec, 0x83}: "AppleImg4VerificationDxe",
		efi.GUID{0x98, 0xf5, 0x3b, 0x89, 0x5d, 0xfa, 0x6c, 0x4b, 0x88, 0x29, 0x60, 0x16, 0xec, 0xc4, 0x43, 0xe7}: "MainErrorHandler",
		efi.GUID{0x98, 0xf9, 0x28, 0xcc, 0x90, 0xeb, 0xfb, 0x47, 0x97, 0xcd, 0x03, 0x21, 0x51, 0xf6, 0xfc, 0xb9}: "OemSetCbsVariable",
		efi.GUID{0x98, 0xfd, 0x8e, 0x2b, 0x63, 0xff, 0xb8, 0x42, 0xbc, 0xf3, 0xf5, 0x36, 0x15, 0xd1, 0x55, 0x36}: "AbtSetup",
		efi.GUID{0x99, 0x00, 0xac, 0x5c, 0xc9, 0x0d, 0xe5, 0x48, 0x80, 0x68, 0xbb, 0x95, 0xf5, 0x40, 0x0a, 0x9f}: "RecoveryOnDataCdGuid",
		efi.GUID{0x99, 0x01, 0xc2, 0x7d, 0x28, 0xde, 0x91, 0x4a, 0xa8, 0x9c, 0xff, 0x06, 0xf2, 0x37, 0x35, 0x2c}: "PrePostHotkey",
		efi.GUID{0x99, 0x05, 0xdc, 0x6e, 0x35, 0x39, 0x3d, 0x4f, 0xa1, 0xaf, 0x3c, 0xcc, 0x1f, 0xbc, 0x86, 0x55}: "FastbootWmi",
		efi.GUID{0x99, 0x0e, 0xb4, 0x7c, 0x86, 0x31, 0x5d, 0x4a, 0x82, 0x9d, 0x80, 0x2c, 0x57, 0x93, 0xf1, 0x32}: "DellAcpiSharedMemSmm",
		efi.GUID{0x99, 0x10, 0x46, 0x55, 0xde, 0x28, 0x16, 0x4a, 0xb5, 0x1e, 0xd0, 0xd1, 0x8a, 0x07, 0x93, 0xf9}: "CmosButtonLoadDefaultsDxe",
		efi.GUID{0x99, 0x12, 0x76, 0xff, 0x1f, 0xd4, 0x73, 0x4c, 0x83, 0x80, 0xa2, 0x40, 0x55, 0xad, 0xf4, 0xb9}: "EDUDxe",
		efi.GUID{0x99, 0x1d, 0x3f, 0x1c, 0x35, 0x4d, 0xbe, 0x4b, 0xb7, 0x5e, 0xa2, 0xc9, 0x2c, 0x72, 0x28, 0xda}: "OemWwanSmBiosType133",
		efi.GUID{0x99, 0x21, 0x1b, 0xe4, 0xef, 0x40, 0xd4, 0x40, 0xa4, 0x3b, 0xc6, 0x0b, 0x98, 0x1a, 0xcc, 0xdb}: "VariableCmosSmm",
		efi.GUID{0x99, 0x25, 0x99, 0xc5, 0x6a, 0xd9, 0xcc, 0x47, 0x9f, 0xba, 0x13, 0xe1, 0x9f, 0x00, 0xf6, 0xfc}: "BBLSupportDockingDxe",
		efi.GUID{0x99, 0x25, 0xf9, 0x4a, 0x76, 0x8e, 0xb4, 0x4b, 0xbf, 0xd2, 0xf5, 0xa6, 0x6e, 0x30, 0x41, 0xd4}: "EfiOcData",
		efi.GUID{0x99, 0x2b, 0x14, 0xfb, 0x57, 0xdf, 0xcb, 0x46, 0xbc, 0x69, 0x0b, 0xf8, 0x58, 0xa7, 0x34, 0xf9}: "SerialOverLan",
		efi.GUID{0x99, 0x2d, 0x34, 0x19, 0x4e, 0xff, 0x98, 0x47, 0xa3, 0xe0, 0xfa, 0x36, 0xc9, 0x61, 0xcc, 0xfe}: "PdtCapsuleDxe",
		efi.GUID{0x99, 0x30, 0xf9, 0x81, 0x7f, 0x0a, 0x1a, 0x4f, 0x94, 0xd4, 0xb3, 0xbe, 0x3f, 0xac, 0xea, 0x6a}: "SmcIpmiOemCommandSetProtocol",
		efi.GUID{0x99, 0x3b, 0xf0, 0x99, 0xd8, 0x98, 0xdd, 0x49, 0xa8, 0xd3, 0x32, 0x19, 0xd0, 0xff, 0xe4, 0x1e}: "Mtftp6Dxe",
		efi.GUID{0x99, 0x40, 0xc0, 0xaf, 0x39, 0x0d, 0x5d, 0x40, 0xbe, 0x46, 0x84, 0x6f, 0x08, 0xc5, 0x1a, 0x31}: "AcpiPlatform",
		efi.GUID{0x99, 0x4e, 0x88, 0xb3, 0xbc, 0x9c, 0xe8, 0x4c, 0x85, 0x5e, 0x53, 0xa1, 0x2e, 0xd0, 0xb8, 0xf4}: "AsusIpmiPei",
		efi.GUID{0x99, 0x64, 0x94, 0xf1, 0x1b, 0x57, 0xc3, 0x44, 0x9b, 0x9c, 0xcc, 0x55, 0x21, 0x0b, 0x0c, 0x02}: "H19WMIHandlerSmm",
		efi.GUID{0x99, 0x67, 0x35, 0x04, 0xb7, 0x81, 0x08, 0x4e, 0xa3, 0x8d, 0xd9, 0x78, 0xfa, 0x47, 0xba, 0x42}: "EfiExtendedSalSmComLayerServicesProtocol",
		efi.GUID{0x99, 0x6a, 0x76, 0x90, 0xa5, 0x9c, 0xde, 0x44, 0x94, 0xda, 0xdc, 0xc1, 0xd2, 0xd6, 0xda, 0x1f}: "UsraPpi",
		efi.GUID{0x99, 0x74, 0xb1, 0xea, 0x0c, 0x7b, 0x9c, 0x45, 0xbd, 0x4a, 0x77, 0x2c, 0xff, 0x1b, 0x80, 0xa8}: "FchPromontoryPlusPei",
		efi.GUID{0x99, 0x77, 0x8b, 0x43, 0xd5, 0xf4, 0xa6, 0x47, 0xa7, 0x5c, 0x30, 0x5c, 0x44, 0x49, 0xf5, 0x12}: "SwSmiDxe",
		efi.GUID{0x99, 0x80, 0xbc, 0x2d, 0x2c, 0x1a, 0x61, 0x03, 0xbb, 0x80, 0xb9, 0xcc, 0x4f, 0x7f, 0x50, 0xd2}: "FlashPatchTableDxe",
		efi.GUID{0x99, 0x81, 0x90, 0x89, 0x26, 0x91, 0xa2, 0x4e, 0x84, 0x9b, 0x06, 0xa7, 0x5c, 0x24, 0x5d, 0x0b}: "MeResiliencyDxe",
		efi.GUID{0x99, 0x84, 0x59, 0xef, 0x5e, 0xb2, 0x3a, 0x47, 0xbf, 0xaf, 0xe7, 0xe5, 0x7d, 0xce, 0x82, 0xc4}: "TpmErrorHobGuid",
		efi.GUID{0x99, 0x8b, 0xb2, 0x7b, 0xbb, 0x61, 0xd5, 0x11, 0x9a, 0x5d, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d}: "Logo",
		efi.GUID{0x99, 0x8c, 0xf4, 0x47, 0x23, 0xcb, 0xf8, 0x4c, 0x9d, 0x7d, 0xce, 0x7c, 0x86, 0xef, 0x22, 0xa3}: "UsbTouchPanelDxe",
		efi.GUID{0x99, 0x8e, 0x24, 0xab, 0xe1, 0xab, 0xd4, 0x11, 0xbd, 0x0d, 0x00, 0x80, 0xc7, 0x3c, 0x88, 0x81}: "EfiWinNtUgaGuid",
		efi.GUID{0x99, 0x91, 0x93, 0x61, 0x08, 0x29, 0x7c, 0x4a, 0xbc, 0x76, 0xf4, 0x28, 0xaa, 0x4b, 0x1e, 0xa1}: "KEMrCPLDPei",
		efi.GUID{0x99, 0x96, 0x9b, 0x91, 0xd0, 0x8d, 0x76, 0x43, 0xaa, 0x0b, 0x0e, 0x54, 0xcc, 0xa4, 0x7d, 0x8f}: "FPVARIABLE",
		efi.GUID{0x99, 0x99, 0x23, 0x01, 0x0e, 0xfc, 0x6e, 0x4b, 0x9e, 0x79, 0xd5, 0x4d, 0x5d, 0xb6, 0xcd, 0x20}: "EfiServerMgmtSetupVariable",
		efi.GUID{0x99, 0x9d, 0x35, 0x01, 0x46, 0x94, 0x6d, 0x45, 0xad, 0xa4, 0x50, 0xa7, 0x11, 0xc0, 0x3a, 0xda}: "CpuPei",
		efi.GUID{0x99, 0x9d, 0x35, 0x01, 0x46, 0x94, 0x6d, 0x45, 0xad, 0xa4, 0x50, 0xa7, 0x11, 0xc0, 0x3a, 0xdb}: "CpuPeim",
		efi.GUID{0x99, 0xa2, 0x4f, 0x6f, 0x46, 0x8f, 0xb2, 0x4b, 0x80, 0x39, 0x9b, 0x0a, 0x82, 0x28, 0x9d, 0x07}: "DellSimulationDetection",
		efi.GUID{0x99, 0xbf, 0x60, 0xa1, 0xa4, 0x2a, 0x7d, 0x4d, 0x99, 0x93, 0x89, 0x9c, 0xb1, 0x2d, 0xf3, 0x76}: "MmCoreDataHob",
		efi.GUID{0x99, 0xc0, 0x14, 0x3c, 0x43, 0x31, 0xef, 0x46, 0xaf, 0x18, 0xde, 0x4a, 0xd2, 0xc3, 0xa7, 0x99}: "SystemHiiImageDisplayDxe",
		efi.GUID{0x99, 0xe2, 0x56, 0x89, 0xd9, 0xd5, 0x53, 0x44, 0x8b, 0x3f, 0xbb, 0xc8, 0x13, 0x13, 0x36, 0xab}: "OemSmi",
		efi.GUID{0x99, 0xed, 0x05, 0x43, 0x86, 0x9d, 0x2d, 0x49, 0x83, 0xae, 0x4d, 0x73, 0x59, 0xe9, 0x90, 0x89}: "SioIt8669ePei",
		efi.GUID{0x99, 0xed, 0x35, 0x43, 0x86, 0x9d, 0x2d, 0x49, 0x83, 0xae, 0x4d, 0x73, 0x59, 0xe9, 0x90, 0x89}: "SioPlatformHook",
		efi.GUID{0x99, 0xf3, 0xcc, 0x51, 0xdf, 0x4f, 0x55, 0x4e, 0xa4, 0x5b, 0xe1, 0x23, 0xf8, 0x4d, 0x45, 0x6a}: "ConPlatformDxe",
		efi.GUID{0x9a, 0x00, 0xde, 0x20, 0xb3, 0xb0, 0xda, 0x43, 0x80, 0x47, 0xb5, 0xe2, 0xb1, 0x9d, 0x6c, 0xc0}: "FlashOemHooKDxe",
		efi.GUID{0x9a, 0x13, 0x33, 0x81, 0x04, 0x2b, 0x37, 0x4c, 0xac, 0xf2, 0x69, 0x56, 0xde, 0xd1, 0x3a, 0x77}: "OemThermalPolicy",
		efi.GUID{0x9a, 0x1b, 0xfc, 0x62, 0x51, 0x88, 0x54, 0x46, 0x90, 0xad, 0xce, 0xa8, 0xc0, 0x7f, 0xe2, 0x59}: "IchSpi",
		efi.GUID{0x9a, 0x22, 0x35, 0x01, 0xb5, 0xeb, 0x21, 0x4a, 0x95, 0x7d, 0x1d, 0x20, 0x05, 0x7c, 0xf7, 0x51}: "TCMPEI",
		efi.GUID{0x9a, 0x22, 0x35, 0x01, 0xb5, 0xeb, 0x21, 0x4a, 0x95, 0x7d, 0x1d, 0x20, 0x05, 0x7c, 0xf7, 0x52}: "TCMDXE",
		efi.GUID{0x9a, 0x3f, 0x26, 0x79, 0x01, 0x17, 0x82, 0x43, 0x98, 0xc2, 0x57, 0x3f, 0x35, 0x58, 0xe6, 0xc8}: "PlatformFvbLibNull",
		efi.GUID{0x9a, 0x44, 0x7a, 0x05, 0xdc, 0x1f, 0x06, 0x4c, 0xbf, 0xc9, 0xf5, 0x3f, 0x6a, 0x99, 0xbb, 0x92}: "EfiPciCfg2PpiGuid",
		efi.GUID{0x9a, 0x44, 0xc9, 0xfb, 0x1c, 0x68, 0x17, 0x45, 0xab, 0x91, 0x90, 0x72, 0xac, 0xde, 0xbb, 0x77}: "GcExt",
		efi.GUID{0x9a, 0x60, 0xdb, 0xe1, 0x13, 0xd4, 0x91, 0x47, 0xc6, 0xee, 0x09, 0x3d, 0x8b, 0xc0, 0x47, 0xa4}: "AmdNbioPcieDxe",
		efi.GUID{0x9a, 0x66, 0xf1, 0xd9, 0x05, 0xf5, 0xbd, 0x48, 0xa8, 0x92, 0x94, 0xb7, 0xca, 0x90, 0x30, 0x31}: "SignalBeforeEnterSetup",
		efi.GUID{0x9a, 0x6f, 0x13, 0xe1, 0xcf, 0xa0, 0x7a, 0x47, 0xa8, 0x6f, 0xdc, 0xe8, 0xef, 0xec, 0x3c, 0x63}: "AmdSocFt6MdnDxe",
		efi.GUID{0x9a, 0x7f, 0xd8, 0x78, 0x1e, 0x32, 0x07, 0x4a, 0x87, 0x5f, 0x8d, 0x83, 0xa3, 0xd0, 0x6e, 0x59}: "FpgaSocketN4Pe",
		efi.GUID{0x9a, 0x8f, 0x2f, 0xd4, 0x96, 0x9b, 0x47, 0x4f, 0xb0, 0x45, 0xa8, 0xf3, 0xcd, 0x1f, 0xd9, 0xd3}: "SecureVariable",
		efi.GUID{0x9a, 0x8f, 0xf9, 0xf5, 0x21, 0x7f, 0x90, 0x41, 0x96, 0xde, 0x4c, 0x27, 0x13, 0x75, 0x4b, 0xe5}: "DecompressFvAbtDxe",
		efi.GUID{0x9a, 0x91, 0x79, 0x79, 0x8d, 0x3d, 0xb5, 0x4b, 0xb8, 0x32, 0x45, 0xcc, 0x4f, 0xc7, 0xde, 0x57}: "DellDptfPolicyProtocol",
		efi.GUID{0x9a, 0x92, 0x21, 0x77, 0x6a, 0xd5, 0x0d, 0x45, 0x25, 0x01, 0x8e, 0xa5, 0x1f, 0xa6, 0x19, 0x74}: "SbCmos",
		efi.GUID{0x9a, 0x99, 0x61, 0xad, 0x7e, 0x50, 0xe6, 0x47, 0xba, 0x28, 0x79, 0xcc, 0x60, 0x9f, 0xa1, 0xa4}: "FspWrapperNotifyDxe",
		efi.GUID{0x9a, 0x9d, 0xf7, 0xb3, 0x6c, 0x43, 0x11, 0xdc, 0xb0, 0x52, 0xcd, 0x85, 0xdf, 0x52, 0x4c, 0xe6}: "EfiRegularExpressionProtocolGuid",
		efi.GUID{0x9a, 0xa1, 0x96, 0x34, 0x99, 0x2e, 0xba, 0x41, 0x83, 0x3e, 0x0f, 0xde, 0x2e, 0xbf, 0x2a, 0x55}: "AmiFastBootProtocol",
		efi.GUID{0x9a, 0xa1, 0xcc, 0xfe, 0xd3, 0xd1, 0xdd, 0x4c, 0xb4, 0x77, 0x56, 0x57, 0x3f, 0x58, 0xb1, 0xa3}: "AmdNbioAlibRNDxe",
		efi.GUID{0x9a, 0xa7, 0xee, 0xf7, 0x54, 0xd8, 0x99, 0x40, 0x9a, 0xe7, 0xd0, 0xa3, 0x28, 0xe4, 0x4f, 0x72}: "AssetIDSmmProtocol",
		efi.GUID{0x9a, 0xb4, 0x6f, 0xdb, 0x8c, 0x91, 0x11, 0x4c, 0xff, 0xff, 0xff, 0xff, 0x63, 0x65, 0x03, 0xa5}: "XnoteSystemPolicyDxe",
		efi.GUID{0x9a, 0xbc, 0xc9, 0xee, 0x07, 0x29, 0x59, 0x4d, 0x8b, 0x86, 0xd1, 0xec, 0x67, 0xde, 0x62, 0xe1}: "GenericMemoryTestDxe",
		efi.GUID{0x9a, 0xbd, 0x31, 0x36, 0xe4, 0x25, 0x67, 0x4b, 0x8d, 0x22, 0xef, 0xbb, 0x00, 0xac, 0xe8, 0x12}: "MAPS_SIO_InterfaceSmm",
		efi.GUID{0x9a, 0xe2, 0xb6, 0x9b, 0x72, 0x22, 0x6a, 0x42, 0xab, 0x77, 0x9b, 0x7f, 0xe5, 0xef, 0xea, 0x84}: "EfiPeiPlatformTypeHedtCrbPpi",
		efi.GUID{0x9a, 0xe4, 0xcb, 0x2d, 0x5b, 0x1e, 0x6e, 0x48, 0xbc, 0x23, 0x48, 0x15, 0x6b, 0x82, 0x82, 0xc9}: "X11DxeDriver",
		efi.GUID{0x9a, 0xf0, 0x8a, 0xdb, 0xe3, 0x34, 0x7b, 0x4a, 0x82, 0x25, 0x8c, 0x5b, 0x0c, 0x05, 0x9e, 0xb8}: "AppleSmc",
		efi.GUID{0x9a, 0xfa, 0x03, 0x88, 0x33, 0x0d, 0x22, 0x40, 0x85, 0x6b, 0xab, 0x59, 0x32, 0xa0, 0xf8, 0xbf}: "AmdInitPostPeim",
		efi.GUID{0x9b, 0x16, 0x59, 0xb7, 0xe2, 0x61, 0x92, 0x4f, 0x94, 0x47, 0x23, 0xe3, 0xdc, 0xd3, 0x3c, 0xec}: "AmdCcxZenRvSmm",
		efi.GUID{0x9b, 0x17, 0x23, 0xb3, 0xfb, 0x97, 0x7e, 0x47, 0xb0, 0xfe, 0xd8, 0x85, 0x91, 0xfa, 0x11, 0xab}: "PeCoffLoaderProtocolGuid",
		efi.GUID{0x9b, 0x1c, 0xd5, 0x2b, 0x2e, 0xeb, 0xfb, 0x4c, 0x95, 0xb7, 0x0c, 0x57, 0x65, 0xfd, 0xcb, 0xc3}: "AtaDeviceService",
		efi.GUID{0x9b, 0x1c, 0xfa, 0xd8, 0x9e, 0x04, 0x92, 0x42, 0xa5, 0x17, 0x45, 0x0a, 0x8d, 0x22, 0x42, 0xef}: "FjGabiFlashCommonFdRegionCtrlDxe",
		efi.GUID{0x9b, 0x1f, 0xca, 0xd7, 0x78, 0xe4, 0x57, 0x42, 0x9d, 0x8e, 0x2f, 0xe2, 0xde, 0xe9, 0x78, 0xbe}: "OemAcpiModePei",
		efi.GUID{0x9b, 0x25, 0x44, 0xb3, 0x57, 0x99, 0x48, 0x45, 0x8b, 0xd1, 0xb3, 0x14, 0x64, 0xbb, 0x83, 0x70}: "DataStorageDxe",
		efi.GUID{0x9b, 0x27, 0x9a, 0xd6, 0xeb, 0x58, 0xd1, 0x45, 0xa1, 0x48, 0x77, 0x1b, 0xb9, 0xeb, 0x52, 0x51}: "EpcOsDataGuid",
		efi.GUID{0x9b, 0x35, 0x87, 0x51, 0x0d, 0x79, 0x5b, 0x42, 0xa5, 0x93, 0xca, 0x1c, 0xdb, 0x3c, 0xeb, 0xad}: "EfiTcpSockProtocol",
		efi.GUID{0x9b, 0x39, 0x0a, 0x78, 0xdf, 0xca, 0x2b, 0x40, 0x85, 0xc7, 0xf7, 0x34, 0xd7, 0x0a, 0xfe, 0x81}: "SmartCoverPortingSmm",
		efi.GUID{0x9b, 0x4c, 0x29, 0xd6, 0x66, 0x08, 0x53, 0x47, 0xaa, 0xad, 0x76, 0x99, 0xaf, 0xc4, 0xbe, 0xe4}: "DefaultFixedBootOrder",
		efi.GUID{0x9b, 0x51, 0x3b, 0x86, 0xf0, 0x57, 0xf4, 0x4f, 0xbe, 0xc8, 0x14, 0x0a, 0xf9, 0x4f, 0xe1, 0x06}: "DellChassisPei",
		efi.GUID{0x9b, 0x5a, 0x5a, 0x86, 0x5d, 0xb8, 0x4c, 0x47, 0x84, 0x55, 0x65, 0xd1, 0xbe, 0x84, 0x4b, 0xe2}: "EfiDebugAgentGuid",
		efi.GUID{0x9b, 0x5d, 0x1e, 0x53, 0x9b, 0x41, 0x3c, 0x4c, 0x95, 0x61, 0xb8, 0x94, 0xf6, 0x95, 0xdd, 0xe4}: "FvbVariableStoragePei",
		efi.GUID{0x9b, 0x67, 0xc5, 0x59, 0xcb, 0x08, 0x53, 0x4a, 0xb2, 0xad, 0x8c, 0xfd, 0x83, 0x59, 0xee, 0xc5}: "OemACPIDriverDxe",
		efi.GUID{0x9b, 0x6a, 0xaf, 0x1a, 0x1b, 0xcb, 0x9e, 0x46, 0x94, 0x20, 0x0d, 0x39, 0x12, 0xb8, 0xe3, 0x76}: "MrcHooksChipServicesPpi",
		efi.GUID{0x9b, 0x74, 0x48, 0xe0, 0xa4, 0x68, 0xc2, 0x40, 0x9a, 0x83, 0xdc, 0x2a, 0xb3, 0x48, 0x19, 0xa8}: "FchSmmDispatcher",
		efi.GUID{0x9b, 0x7b, 0x62, 0x04, 0x5e, 0x38, 0x44, 0x47, 0x90, 0x21, 0xe6, 0x63, 0x19, 0xf2, 0x03, 0x94}: "AmiPbKeyRsa2048",
		efi.GUID{0x9b, 0x7f, 0x34, 0x7c, 0xae, 0x6f, 0xa5, 0x45, 0x90, 0x6e, 0xf8, 0xdf, 0xeb, 0xee, 0x64, 0xff}: "DellWmiSecurityMgr",
		efi.GUID{0x9b, 0x82, 0x86, 0x24, 0xf3, 0xd3, 0xec, 0x47, 0x82, 0x7a, 0xfc, 0x10, 0x49, 0x07, 0xfc, 0x5c}: "SmmGenericSio",
		efi.GUID{0x9b, 0x90, 0x89, 0x9a, 0xd8, 0x71, 0x48, 0x4e, 0xbd, 0x52, 0x6b, 0xf2, 0xe6, 0x5c, 0x08, 0x57}: "PlatformHiiAMDDxe",
		efi.GUID{0x9b, 0x92, 0x85, 0x97, 0xf4, 0x3d, 0xd8, 0x47, 0xbc, 0x0f, 0x1a, 0x1f, 0x35, 0xb0, 0xf1, 0x70}: "HhmPei",
		efi.GUID{0x9b, 0x96, 0xae, 0x33, 0xca, 0xe7, 0xcd, 0x4b, 0x9c, 0x4d, 0x45, 0x31, 0xc1, 0x8a, 0x5d, 0xfa}: "TouchDriver",
		efi.GUID{0x9b, 0xab, 0x20, 0x42, 0x30, 0x17, 0xc5, 0x49, 0xa8, 0x9f, 0xb4, 0x71, 0xcf, 0x43, 0xb2, 0x21}: "FchPromontorySmmInit",
		efi.GUID{0x9b, 0xab, 0x20, 0x42, 0x30, 0x17, 0xc5, 0x49, 0xa8, 0x9f, 0xb4, 0x7f, 0xcf, 0x43, 0xa2, 0x21}: "FchSmmInit",
		efi.GUID{0x9b, 0xab, 0xbf, 0xb3, 0x9c, 0x9f, 0x8b, 0x4e, 0xad, 0x37, 0x7f, 0x8c, 0x51, 0xfc, 0x62, 0x80}: "EfiPeiI2cMasterPpiGuid",
		efi.GUID{0x9b, 0xb2, 0x17, 0xf3, 0xc9, 0x7d, 0x14, 0x41, 0x90, 0x86, 0xd7, 0x13, 0x7e, 0xf4, 0xf1, 0x18}: "DellTpmSmm",
		efi.GUID{0x9b, 0xb2, 0x59, 0x7a, 0x0b, 0x91, 0x71, 0x41, 0x82, 0x42, 0xa8, 0x5a, 0x0d, 0xf2, 0x5b, 0x5b}: "EfiHttpProtocolGuid",
		efi.GUID{0x9b, 0xba, 0x79, 0x6c, 0x26, 0x59, 0x95, 0x42, 0xa4, 0x50, 0x46, 0xb3, 0x40, 0x1d, 0x95, 0xa5}: "AcpiPlatform1",
		efi.GUID{0x9b, 0xba, 0xca, 0xb9, 0xc5, 0xe5, 0xdc, 0x41, 0x86, 0xe2, 0xe7, 0xce, 0xf8, 0x7b, 0x81, 0xcb}: "SystemFlashCommunicationSmm",
		efi.GUID{0x9b, 0xc3, 0x73, 0x91, 0xda, 0x08, 0x9a, 0x42, 0xbe, 0x15, 0x0f, 0x74, 0x81, 0xcf, 0x72, 0xce}: "AMTLockUsbKBD",
		efi.GUID{0x9b, 0xc4, 0xd3, 0xcf, 0xdc, 0x56, 0x5c, 0x46, 0xb3, 0xa0, 0x41, 0x9a, 0x8b, 0x42, 0xcb, 0x60}: "EfiAcpiParameter",
		efi.GUID{0x9b, 0xc8, 0x87, 0x4b, 0xa9, 0x39, 0x8f, 0x47, 0xa4, 0xb6, 0x81, 0x6a, 0x9e, 0xdc, 0x50, 0x87}: "DellVariable2Dxe",
		efi.GUID{0x9b, 0xd5, 0x00, 0x94, 0x9c, 0x0e, 0x6c, 0x4f, 0xb5, 0x9a, 0xfc, 0x20, 0x00, 0x9d, 0xb9, 0xec}: "AmiPciIrqProgramGuid",
		efi.GUID{0x9b, 0xd5, 0xb8, 0x98, 0xba, 0xe8, 0xee, 0x48, 0x98, 0xdd, 0xc2, 0x95, 0x39, 0x2f, 0x1e, 0xdb}: "EfiConfigFileNameGuid",
		efi.GUID{0x9b, 0xd6, 0xce, 0x2e, 0x93, 0x27, 0x88, 0x43, 0xba, 0x3c, 0x82, 0x30, 0x40, 0xeb, 0xcc, 0xd2}: "EfiOSInfo",
		efi.GUID{0x9b, 0xd8, 0x37, 0xc9, 0x9c, 0x5f, 0x1e, 0x4a, 0xb1, 0x0d, 0x8f, 0x53, 0xd7, 0x47, 0x42, 0x20}: "AmiPspRecovery",
		efi.GUID{0x9b, 0xd8, 0x70, 0xb9, 0xf8, 0x6a, 0x8b, 0x4b, 0x90, 0x45, 0xb0, 0x6d, 0x8d, 0xc2, 0xc8, 0xb6}: "PdSolutionDxe",
		efi.GUID{0x9b, 0xdd, 0x67, 0x19, 0x2c, 0xb7, 0x28, 0x43, 0x8c, 0x80, 0xd4, 0xac, 0xfc, 0x83, 0xfd, 0xf8}: "PciHotPlugDxe",
		efi.GUID{0x9b, 0xe0, 0x8c, 0xfb, 0xde, 0xa0, 0x7e, 0x46, 0x9d, 0xc6, 0x44, 0x65, 0xf5, 0x98, 0x76, 0x76}: "AmdFabricSspSmm",
		efi.GUID{0x9b, 0xf2, 0x17, 0xd3, 0x25, 0xa3, 0x12, 0x47, 0x9b, 0xf1, 0xc6, 0x19, 0x54, 0xdc, 0x19, 0x8c}: "EfiSmartCardEdgeProtocolGuid",
		efi.GUID{0x9b, 0xf2, 0x24, 0xb3, 0x97, 0x5e, 0xf9, 0x4b, 0xb4, 0xe0, 0x51, 0x25, 0xc1, 0xf6, 0x05, 0xd5}: "AsrockRtlansmi",
		efi.GUID{0x9b, 0xf2, 0x93, 0x1e, 0xb2, 0xa3, 0x40, 0xf3, 0xa6, 0x05, 0xde, 0x31, 0xee, 0x3d, 0xa0, 0x31}: "EdkTerminal",
		efi.GUID{0x9b, 0xf3, 0x10, 0xa4, 0xbb, 0x76, 0x5c, 0x42, 0xad, 0xd3, 0x86, 0x78, 0xa4, 0x1c, 0x89, 0xdc}: "SystemVspEvaRuntimeDxe",
		efi.GUID{0x9b, 0xf6, 0x37, 0x67, 0xcc, 0xb8, 0xbc, 0x45, 0x93, 0x27, 0xcc, 0xf5, 0xee, 0xf7, 0x0c, 0xde}: "AmiPlatformIdeProtocolGuid",
		efi.GUID{0x9b, 0xfb, 0x0c, 0x1d, 0x00, 0xeb, 0xa6, 0x43, 0x81, 0x9c, 0xd2, 0x18, 0xdf, 0x8d, 0xc4, 0xb4}: "BootMode",
		efi.GUID{0x9c, 0x04, 0x3e, 0xde, 0x18, 0xa2, 0x91, 0x48, 0x74, 0x69, 0x4f, 0xc0, 0xae, 0x85, 0x32, 0x98}: "AmdCpmGpioInitPeim",
		efi.GUID{0x9c, 0x04, 0x3e, 0xde, 0x18, 0xa2, 0x91, 0x48, 0x86, 0x58, 0x4f, 0xc0, 0xae, 0x85, 0x32, 0x98}: "AmdCpmDisplayFeaturePeim",
		efi.GUID{0x9c, 0x04, 0x3e, 0xde, 0x18, 0xa2, 0x91, 0x48, 0x86, 0x58, 0x5f, 0xc0, 0x6a, 0x84, 0xc7, 0x83}: "SBCbsPEIEntryPei",
		efi.GUID{0x9c, 0x04, 0x3e, 0xde, 0x18, 0xa2, 0x91, 0x48, 0x86, 0x58, 0x5f, 0xc0, 0xfa, 0x84, 0xc7, 0x88}: "AmdProcessorInitPeim",
		efi.GUID{0x9c, 0x10, 0x4a, 0x2b, 0xd7, 0x9e, 0xfe, 0x47, 0x80, 0xaa, 0x20, 0x87, 0xe4, 0xe0, 0x30, 0x1e}: "EcRotLockEcDxe",
		efi.GUID{0x9c, 0x15, 0x29, 0x6d, 0x7a, 0xcc, 0x57, 0x47, 0x81, 0x85, 0x42, 0xdd, 0xb2, 0xbe, 0xcb, 0x89}: "CompalWSMTSmm",
		efi.GUID{0x9c, 0x1f, 0x89, 0x34, 0xda, 0x54, 0xea, 0x44, 0x83, 0x13, 0xca, 0xb8, 0xaa, 0xb1, 0xbd, 0x0c}: "FchProm21SsdtDxe",
		efi.GUID{0x9c, 0x29, 0x65, 0xb2, 0x4e, 0x65, 0xd7, 0x4d, 0x86, 0x16, 0x35, 0x85, 0x61, 0xc0, 0x08, 0xa3}: "SystemVariableStoreManagerSmm",
		efi.GUID{0x9c, 0x2d, 0xac, 0x79, 0x16, 0x92, 0xc5, 0x43, 0xa0, 0x74, 0x0b, 0x45, 0xc7, 0x64, 0x22, 0xc1}: "SmmRedirElogProtocol",
		efi.GUID{0x9c, 0x2e, 0xd9, 0xff, 0xb0, 0x26, 0xe3, 0x44, 0x99, 0x60, 0x87, 0x2f, 0x6c, 0x41, 0x62, 0xb6}: "FjCmos",
		efi.GUID{0x9c, 0x2f, 0x54, 0x37, 0xe8, 0x24, 0x34, 0x48, 0x8b, 0x1d, 0x7c, 0x3e, 0x06, 0x45, 0x24, 0x5d}: "EcMpmSmm",
		efi.GUID{0x9c, 0x2f, 0xe0, 0x9f, 0xda, 0x5b, 0x71, 0x49, 0xa9, 0x18, 0xb7, 0x94, 0x51, 0xb4, 0x3e, 0x43}: "FmpDxe",
		efi.GUID{0x9c, 0x38, 0x92, 0x28, 0xe9, 0xfb, 0xd7, 0x43, 0xb9, 0xfc, 0x6c, 0x5d, 0x90, 0xd1, 0x84, 0x56}: "TisDxe",
		efi.GUID{0x9c, 0x44, 0x8e, 0x63, 0x59, 0x86, 0x87, 0x48, 0x82, 0x81, 0x27, 0x5f, 0xae, 0xd2, 0xa7, 0x43}: "HpTxtTpm2Provision",
		efi.GUID{0x9c, 0x4a, 0x52, 0xa4, 0x5e, 0x0b, 0x2d, 0x49, 0xae, 0xc9, 0x30, 0x86, 0x31, 0xb1, 0x89, 0xb4}: "AmiSetTcgReadytobootGuid",
		efi.GUID{0x9c, 0x52, 0x02, 0xef, 0x83, 0xa2, 0xcd, 0x48, 0x8d, 0x08, 0x6a, 0x1e, 0x9c, 0x3c, 0x03, 0xd3}: "AmiTseOemPortingVar18",
		efi.GUID{0x9c, 0x57, 0x65, 0xd9, 0xf4, 0x7d, 0x8d, 0x45, 0xa8, 0x03, 0x94, 0xd0, 0x80, 0x8b, 0xc4, 0x22}: "NCT7802YDxeInit",
		efi.GUID{0x9c, 0x59, 0xc9, 0xea, 0x94, 0x2d, 0x86, 0x48, 0x8f, 0x6c, 0xd7, 0xa8, 0x8b, 0x5b, 0x48, 0x3a}: "N17MQ3Gop",
		efi.GUID{0x9c, 0x66, 0x4a, 0xa4, 0xe0, 0xac, 0x96, 0x46, 0x81, 0x79, 0xf5, 0xea, 0x87, 0x93, 0x0c, 0x4f}: "HpErrorLoggingDxe",
		efi.GUID{0x9c, 0x68, 0x15, 0x42, 0x29, 0xf5, 0xff, 0x4a, 0x9b, 0xfe, 0xfe, 0xf3, 0x5a, 0xc5, 0x51, 0x8c}: "ProjectPeiPriori",
		efi.GUID{0x9c, 0x69, 0x9e, 0x99, 0x13, 0xb0, 0x5e, 0x47, 0xb1, 0x7b, 0xf3, 0xa8, 0xae, 0x5c, 0x48, 0x75}: "EdkiiDebugPpi",
		efi.GUID{0x9c, 0x6b, 0x45, 0xff, 0xc7, 0x0d, 0x82, 0x46, 0x9e, 0x92, 0x0d, 0xe8, 0x4b, 0x6e, 0x40, 0x67}: "PeiSmmControl",
		efi.GUID{0x9c, 0x6b, 0xe2, 0x41, 0xa6, 0xad, 0xb3, 0x45, 0x80, 0x8e, 0x23, 0x57, 0xa3, 0x5b, 0x60, 0xd6}: "ArmBootMonFsFileInfoGuid",
		efi.GUID{0x9c, 0x76, 0xab, 0x79, 0x59, 0xe9, 0x09, 0x4b, 0x97, 0x18, 0x80, 0xa8, 0x96, 0x01, 0x2c, 0x28}: "DellNetworkTransferDriver",
		efi.GUID{0x9c, 0x7a, 0x3d, 0xde, 0x18, 0xa2, 0x91, 0x48, 0x74, 0x69, 0x4f, 0xc0, 0xae, 0x85, 0x32, 0x98}: "AmdCpmPcieInitPeim",
		efi.GUID{0x9c, 0x7c, 0x0d, 0x5f, 0xf5, 0xa3, 0x84, 0x41, 0x83, 0x6d, 0xdc, 0xef, 0x65, 0x0a, 0x49, 0x3d}: "FjUCMPei",
		efi.GUID{0x9c, 0x7e, 0x19, 0x3e, 0xdc, 0xd8, 0xd3, 0x42, 0x89, 0xce, 0xb0, 0x4f, 0xa9, 0x83, 0x37, 0x56}: "RegularExpressionDxe",
		efi.GUID{0x9c, 0x81, 0xb4, 0x0e, 0x78, 0xd8, 0x8d, 0x4c, 0x91, 0x3b, 0x40, 0x49, 0x47, 0xae, 0xb8, 0x9f}: "PlatformStorageInformationDxe",
		efi.GUID{0x9c, 0x83, 0xf2, 0x99, 0xc3, 0x57, 0x1e, 0x41, 0xab, 0xc3, 0xad, 0xe5, 0x26, 0x7d, 0x96, 0x0d}: "OzmosisDefaults",
		efi.GUID{0x9c, 0x8c, 0xe1, 0x6b, 0x61, 0xbf, 0x9e, 0x49, 0x88, 0xec, 0x5c, 0xd5, 0x74, 0x30, 0x46, 0x0c}: "ScSmiDispatcher",
		efi.GUID{0x9c, 0x90, 0xf2, 0xa4, 0x2a, 0x5e, 0x8a, 0x43, 0x91, 0xba, 0x27, 0x2b, 0x09, 0x23, 0x04, 0x9a}: "PlatformSetup",
		efi.GUID{0x9c, 0x92, 0x47, 0x8e, 0x0e, 0xc8, 0xce, 0x40, 0xb0, 0x13, 0x80, 0x7f, 0xef, 0xc9, 0x41, 0x10}: "IntelGigabitLanDxe",
		efi.GUID{0x9c, 0x92, 0x54, 0xe9, 0xac, 0x5b, 0x94, 0x44, 0xb9, 0x63, 0x3b, 0x23, 0xd4, 0xa1, 0x3a, 0xd2}: "QuiesceSupport",
		efi.GUID{0x9c, 0x95, 0x7d, 0x57, 0x67, 0xe9, 0x46, 0x45, 0x86, 0x20, 0xc7, 0x78, 0xfa, 0xe5, 0xda, 0x05}: "EfiDebuggerConfigurationProtocolGuid",
		efi.GUID{0x9c, 0xaf, 0x54, 0x6a, 0xfe, 0x00, 0xee, 0x46, 0x9a, 0xa1, 0x35, 0x9c, 0x98, 0x22, 0xc8, 0xfc}: "SlotDataUpdateDxeEldorado",
		efi.GUID{0x9c, 0xb0, 0xfa, 0x38, 0x51, 0x28, 0x4c, 0x44, 0x9a, 0x43, 0xf8, 0x27, 0x25, 0xe4, 0x67, 0x1f}: "AcpiDsdtDynamicCpu",
		efi.GUID{0x9c, 0xbf, 0x61, 0x21, 0x38, 0x80, 0x12, 0x4f, 0xa7, 0x58, 0x30, 0x14, 0x06, 0x60, 0xf2, 0x2f}: "StaticSkuDataDxeFischerLakeRP",
		efi.GUID{0x9c, 0xc1, 0xce, 0x4e, 0x5f, 0x6e, 0x15, 0x48, 0x83, 0x42, 0xb5, 0x5f, 0x2c, 0xc5, 0xdf, 0xc1}: "LenovoVproHiiDxe",
		efi.GUID{0x9c, 0xc6, 0x1a, 0x67, 0x3a, 0xaf, 0xf1, 0x47, 0x88, 0x4f, 0xa4, 0xb0, 0x4b, 0x25, 0x70, 0x57}: "AmdPspPeiV2Phx",
		efi.GUID{0x9c, 0xc6, 0xa6, 0xa5, 0x0f, 0xb5, 0x57, 0x41, 0x80, 0x1c, 0x4e, 0xd7, 0x86, 0xa5, 0x53, 0x70}: "AmdCcxZen4Dxe",
		efi.GUID{0x9c, 0xc7, 0xf7, 0x0a, 0xb5, 0x65, 0x19, 0x43, 0xb0, 0xae, 0x44, 0xec, 0x48, 0x4e, 0x4a, 0xd7}: "EfiHashAlgorithmMD5Guid",
		efi.GUID{0x9c, 0xd3, 0x28, 0x29, 0x7d, 0x91, 0x2f, 0x4f, 0x95, 0x10, 0x16, 0xab, 0x73, 0xf2, 0x04, 0xb2}: "BiosAcm_Field",
		efi.GUID{0x9c, 0xd4, 0x00, 0xbf, 0x84, 0x77, 0x06, 0x4a, 0x9f, 0x5c, 0x12, 0xfb, 0x9e, 0x68, 0xc7, 0x2b}: "FjGabiFlashCoreSmm",
		efi.GUID{0x9c, 0xe0, 0x79, 0x54, 0x74, 0x2e, 0x1b, 0x48, 0x89, 0xf8, 0xb0, 0x17, 0x2e, 0x38, 0x8d, 0x1f}: "StartWatchDog",
		efi.GUID{0x9c, 0xe0, 0xb6, 0x4e, 0x56, 0xd2, 0x1e, 0x4e, 0xb5, 0x0a, 0x87, 0x4b, 0xd2, 0x84, 0xb3, 0xde}: "FspSiliconInitDonePpiGuid",
		efi.GUID{0x9c, 0xe0, 0xd7, 0x5b, 0xf7, 0xa2, 0x73, 0x48, 0x8d, 0xce, 0x28, 0xd3, 0x95, 0xda, 0x98, 0xf7}: "DellRmt3Smm",
		efi.GUID{0x9c, 0xe2, 0xe5, 0xc2, 0x9b, 0xe3, 0x8d, 0x4e, 0x99, 0x09, 0xe0, 0x0a, 0x14, 0x53, 0x59, 0xfd}: "HpFlashMe",
		efi.GUID{0x9c, 0xe7, 0x7b, 0x61, 0x33, 0x31, 0x4e, 0x47, 0x80, 0x17, 0xa7, 0x33, 0x59, 0x5b, 0x49, 0x30}: "ECSMI",
		efi.GUID{0x9c, 0xe9, 0x8c, 0x6b, 0x68, 0x9c, 0xec, 0x41, 0xb5, 0x07, 0xe0, 0x3a, 0x14, 0x3c, 0x7e, 0xd4}: "WirelessUndiLauncher",
		efi.GUID{0x9c, 0xe9, 0xbd, 0x28, 0xa7, 0xe8, 0x3e, 0x4e, 0x9a, 0x8a, 0xe6, 0x6c, 0xd6, 0x4f, 0x31, 0xc6}: "BasePciLibCf8",
		efi.GUID{0x9c, 0xea, 0x62, 0x23, 0xe5, 0x84, 0xff, 0x4d, 0x83, 0xbc, 0xb5, 0xac, 0xec, 0xb5, 0x7c, 0xbb}: "AmiCsmThunkDriverGuid",
		efi.GUID{0x9c, 0xf2, 0x4c, 0xe8, 0x1f, 0x19, 0xae, 0x4e, 0x96, 0xe1, 0xf4, 0x6a, 0xec, 0xea, 0xea, 0x0b}: "EfiTianoDecompressProtocol",
		efi.GUID{0x9c, 0xf6, 0xca, 0x2c, 0x61, 0x62, 0xbd, 0x47, 0xac, 0x46, 0xe6, 0xf4, 0x71, 0xd6, 0x54, 0xd9}: "StorageInfoProtocolDxe",
		efi.GUID{0x9c, 0xff, 0xa4, 0xce, 0xbc, 0xd7, 0x07, 0x4f, 0x96, 0xf1, 0x03, 0xf4, 0x1f, 0x2b, 0x17, 0xae}: "BaseFspDebugLibSerialPort",
		efi.GUID{0x9d, 0x00, 0x2a, 0xf4, 0x7f, 0x97, 0x08, 0x4f, 0x94, 0x40, 0xbc, 0xa5, 0xa3, 0xbe, 0xd9, 0xaf}: "AmiExtPciBusProtocolGuid",
		efi.GUID{0x9d, 0x01, 0xc2, 0x0e, 0x70, 0xbc, 0x4e, 0x4a, 0xa2, 0x39, 0x50, 0x1e, 0xf5, 0xd6, 0xf7, 0x42}: "InstallPlatformSsdt",
		efi.GUID{0x9d, 0x05, 0xd1, 0x76, 0x22, 0x2e, 0xef, 0x40, 0xa3, 0x1f, 0xc4, 0x9d, 0xbb, 0xc0, 0xdb, 0xce}: "SetupCheckSumPei",
		efi.GUID{0x9d, 0x07, 0x89, 0xcf, 0x55, 0xde, 0x18, 0x46, 0x86, 0x83, 0xbc, 0xfb, 0x0d, 0x5c, 0x90, 0xbc}: "AsusSlp2Encrypt",
		efi.GUID{0x9d, 0x0b, 0xc2, 0xe6, 0x4b, 0x0a, 0xf1, 0x45, 0x8e, 0x39, 0xa9, 0x67, 0xe2, 0x8f, 0x99, 0xc4}: "DustFilterReminderSmm",
		efi.GUID{0x9d, 0x13, 0xee, 0x3a, 0xc8, 0xed, 0x99, 0x45, 0xba, 0xbc, 0x50, 0x83, 0x23, 0xb5, 0xd4, 0xa3}: "TpmEsrtFmpUpd",
		efi.GUID{0x9d, 0x15, 0xa5, 0x27, 0x61, 0x5e, 0x09, 0x48, 0x91, 0x9a, 0x42, 0x2e, 0x88, 0x71, 0x01, 0xef}: "PcatSingleSegmentPciCfgPei",
		efi.GUID{0x9d, 0x15, 0xc4, 0xae, 0xfc, 0xf2, 0x90, 0x40, 0x95, 0xce, 0x38, 0x31, 0x7a, 0x8e, 0xd6, 0x4c}: "FirmwarePerformanceTable",
		efi.GUID{0x9d, 0x1f, 0x51, 0x0e, 0x86, 0x5b, 0x89, 0x43, 0x93, 0x25, 0x9f, 0x82, 0x17, 0x22, 0x0f, 0xbb}: "CpuInstallEfiMemoryPei",
		efi.GUID{0x9d, 0x22, 0x9a, 0x39, 0x54, 0xf6, 0xef, 0x4c, 0x9e, 0xd3, 0x6f, 0xc3, 0xc9, 0x92, 0xe3, 0x11}: "PciDxeInit",
		efi.GUID{0x9d, 0x22, 0x9a, 0x39, 0x54, 0xf6, 0xef, 0x4c, 0x9e, 0xd3, 0x6f, 0xc3, 0xc9, 0x92, 0xe3, 0x9c}: "PciDxeInit",
		efi.GUID{0x9d, 0x26, 0x02, 0x07, 0x0c, 0x38, 0x73, 0x48, 0xbf, 0xeb, 0x32, 0xf5, 0xbc, 0x44, 0xdd, 0x16}: "AmtLockI2cConInDxe",
		efi.GUID{0x9d, 0x29, 0xe6, 0xb2, 0x6a, 0x68, 0x14, 0x42, 0xb0, 0x70, 0x08, 0x03, 0x67, 0xfc, 0x53, 0x40}: "DellInstallHiiPidListHobPei",
		efi.GUID{0x9d, 0x34, 0x78, 0x1f, 0xba, 0x7f, 0x86, 0x46, 0x80, 0x98, 0xfa, 0x01, 0x7e, 0xda, 0x35, 0xfb}: "ArmShellCmdRunAxf",
		efi.GUID{0x9d, 0x34, 0xcf, 0xa3, 0x9c, 0x63, 0x08, 0x4d, 0xac, 0x4a, 0xc9, 0x53, 0x41, 0xfb, 0x4f, 0x94}: "AppleIrRemoteDxe",
		efi.GUID{0x9d, 0x36, 0x18, 0xbd, 0x42, 0xc2, 0xca, 0x45, 0x82, 0xad, 0x13, 0x8a, 0xc2, 0xe2, 0x9b, 0xab}: "EfiSmmIoTrapDispatchProtocol",
		efi.GUID{0x9d, 0x37, 0x99, 0x39, 0xcb, 0xf9, 0xf2, 0x4e, 0xbd, 0x0e, 0xf2, 0x41, 0xff, 0x80, 0x46, 0x28}: "RTS52xx",
		efi.GUID{0x9d, 0x5e, 0x02, 0x55, 0xe9, 0x32, 0x3b, 0x40, 0x81, 0xc1, 0xf9, 0xe3, 0xd9, 0xd7, 0x06, 0x40}: "AmdHsti",
		efi.GUID{0x9d, 0x64, 0xd9, 0x5c, 0x74, 0x28, 0x34, 0x48, 0x80, 0x2b, 0xc5, 0x59, 0xc9, 0x47, 0x03, 0xae}: "Usb4CmDxe",
		efi.GUID{0x9d, 0x66, 0xe3, 0x95, 0xbe, 0x34, 0x75, 0x47, 0xa6, 0x51, 0x7e, 0xa4, 0x1b, 0x69, 0xd8, 0x9e}: "Dhcp6Dxe",
		efi.GUID{0x9d, 0x7c, 0xca, 0x75, 0x2e, 0x50, 0x8a, 0x46, 0x9a, 0xaf, 0x7f, 0x2a, 0x29, 0xe6, 0xdb, 0xcf}: "AmiSbHddPolicyProtocolGuid",
		efi.GUID{0x9d, 0x81, 0xc1, 0xf2, 0xf5, 0x10, 0x23, 0x42, 0x92, 0x36, 0x9b, 0x4e, 0xbf, 0x1b, 0x9a, 0xe7}: "Logo1394",
		efi.GUID{0x9d, 0x83, 0x7c, 0xcd, 0x21, 0x05, 0x26, 0x4b, 0x94, 0x76, 0x9f, 0xf2, 0xcb, 0x70, 0x64, 0x9a}: "OpromUpdateDxeNeonCityEPECB",
		efi.GUID{0x9d, 0x85, 0xd7, 0xc1, 0x19, 0x57, 0xc3, 0x46, 0xa2, 0x98, 0xd0, 0x71, 0xe3, 0x02, 0x64, 0xd1}: "AcousticSetupProtocol",
		efi.GUID{0x9d, 0x91, 0xde, 0xb7, 0xf1, 0xe2, 0xea, 0x45, 0xb6, 0x6c, 0xd1, 0xe0, 0x35, 0x08, 0x18, 0x94}: "AmdCpmThunderboltSmm",
		efi.GUID{0x9d, 0x95, 0x79, 0xbc, 0xe5, 0x47, 0xde, 0x47, 0x8e, 0x8c, 0x49, 0xde, 0x89, 0xb1, 0xfd, 0x9d}: "FjDeviceFirmwareUpdateProtocol",
		efi.GUID{0x9d, 0x9a, 0x49, 0x37, 0x2f, 0x54, 0x89, 0x4c, 0xa0, 0x26, 0x35, 0xda, 0x14, 0x20, 0x94, 0xe4}: "EfiUartDevicePathGuid",
		efi.GUID{0x9d, 0xa5, 0xa6, 0x5a, 0x84, 0x57, 0x0b, 0x42, 0xa6, 0xe5, 0xd8, 0xf6, 0x41, 0xbd, 0x97, 0x32}: "EfiRasfSupportProtocol",
		efi.GUID{0x9d, 0xa6, 0x50, 0xd4, 0xe4, 0xd8, 0x48, 0xc0, 0x8e, 0x7e, 0x00, 0x24, 0xeb, 0x54, 0x1c, 0x79}: "NetworkInterfacePolicyDriver",
		efi.GUID{0x9d, 0xa6, 0x82, 0x29, 0x52, 0xa9, 0x2a, 0x4a, 0xa1, 0x9b, 0x0b, 0xe6, 0x1b, 0x29, 0x61, 0x99}: "PldmSmbios",
		efi.GUID{0x9d, 0xa7, 0xa0, 0xe8, 0x3f, 0x04, 0x36, 0x4a, 0x93, 0xf2, 0x6f, 0xa5, 0xc5, 0x06, 0xe9, 0xff}: "AmdPspKvm",
		efi.GUID{0x9d, 0xa7, 0xea, 0x72, 0x46, 0xd3, 0xc1, 0x43, 0xb6, 0xa2, 0xb8, 0x5e, 0xee, 0x72, 0x91, 0x33}: "NoBootDeviceOptionSmm",
		efi.GUID{0x9d, 0xb4, 0xc4, 0x19, 0xda, 0x28, 0x32, 0x42, 0x99, 0x6a, 0xd1, 0x75, 0xbb, 0xf6, 0xaf, 0xf7}: "SystemBiosSelfHealingPremiumDxe",
		efi.GUID{0x9d, 0xb9, 0x35, 0x3c, 0xb7, 0xd4, 0x85, 0x48, 0xab, 0xd9, 0x2b, 0xea, 0x4b, 0x9f, 0x3a, 0x01}: "ASUSFTMDXE",
		efi.GUID{0x9d, 0xbf, 0xf4, 0xdf, 0x27, 0xd0, 0x7e, 0x4f, 0x93, 0x85, 0xc1, 0xad, 0xb0, 0xce, 0xf7, 0x53}: "FjSmmAzaliaVerbTable",
		efi.GUID{0x9d, 0xc0, 0x17, 0xb0, 0xc1, 0xed, 0x40, 0x49, 0xb1, 0x3e, 0x57, 0xe9, 0x56, 0x60, 0xc9, 0x0f}: "AhciRom",
		efi.GUID{0x9d, 0xd2, 0xaf, 0x4a, 0xdf, 0x68, 0xee, 0x49, 0x8a, 0xa9, 0x34, 0x7d, 0x37, 0x56, 0x65, 0xa7}: "EfiCertPkcs7Guid",
		efi.GUID{0x9d, 0xeb, 0xad, 0xed, 0xba, 0xdd, 0xbd, 0x48, 0x9d, 0x22, 0xc1, 0xc1, 0x69, 0xc8, 0xc5, 0xc6}: "CpuMpPei",
		efi.GUID{0x9d, 0xeb, 0xe9, 0x65, 0x2d, 0x81, 0x61, 0x41, 0x99, 0xc5, 0x05, 0xac, 0x4b, 0xcc, 0xa4, 0x94}: "DellSmmGpe",
		efi.GUID{0x9d, 0xec, 0x43, 0x35, 0x27, 0x4b, 0xa9, 0x4f, 0xad, 0xbd, 0x1d, 0xe1, 0x18, 0x07, 0x8f, 0xa7}: "AmdSb900Pei",
		efi.GUID{0x9d, 0xec, 0x43, 0x35, 0x27, 0x4b, 0xa9, 0x4f, 0xad, 0xbd, 0x1d, 0xf1, 0x18, 0x07, 0x8f, 0xa7}: "AmdSb800_PeiPei",
		efi.GUID{0x9d, 0xf7, 0x24, 0x3b, 0xa0, 0x91, 0xff, 0x46, 0xbe, 0x29, 0x45, 0x8a, 0xe2, 0x11, 0xfa, 0xc5}: "KbcEmul",
		efi.GUID{0x9d, 0xff, 0x3a, 0xb1, 0x6d, 0xc6, 0xad, 0x46, 0x8c, 0x23, 0x72, 0x34, 0x82, 0xef, 0xc8, 0x41}: "PlatformEmmcDxe",
		efi.GUID{0x9e, 0x00, 0xa6, 0x77, 0x6e, 0x11, 0x4d, 0x46, 0x8e, 0xf8, 0xb3, 0x52, 0x01, 0xa0, 0x22, 0xdd}: "DigitalThermalSensorSmm",
		efi.GUID{0x9e, 0x01, 0x80, 0xb1, 0x20, 0x98, 0xc0, 0x4d, 0x8b, 0x40, 0xa7, 0x73, 0xe2, 0x3d, 0x4f, 0x35}: "RamDisk",
		efi.GUID{0x9e, 0x04, 0x0f, 0x1f, 0x68, 0x3a, 0x97, 0x4c, 0x86, 0x5a, 0xbc, 0x5e, 0xed, 0x79, 0x20, 0xe7}: "AmiPeiNbCpuOnlyResetPpi",
		efi.GUID{0x9e, 0x10, 0xb6, 0x16, 0x4c, 0x19, 0x0f, 0x44, 0x94, 0xf8, 0xc7, 0xcc, 0xcc, 0xc3, 0x2d, 0xeb}: "EfiCseEndofPostProtocolGuid",
		efi.GUID{0x9e, 0x12, 0xee, 0xb1, 0x36, 0xda, 0x81, 0x41, 0x91, 0xf8, 0x04, 0xa4, 0x92, 0x37, 0x66, 0xa7}: "EfiDriverFamilyOverrideProtocolGuid",
		efi.GUID{0x9e, 0x1a, 0x89, 0x21, 0x3e, 0x76, 0x77, 0x43, 0x88, 0x41, 0x8d, 0x5c, 0x90, 0xd8, 0x8c, 0x51}: "NetworkStackSetupScreen",
		efi.GUID{0x9e, 0x1a, 0x89, 0x54, 0x3e, 0x76, 0x77, 0x43, 0x88, 0x41, 0x8d, 0x5c, 0x90, 0xd8, 0x8c, 0xde}: "TerminalSrc",
		efi.GUID{0x9e, 0x1f, 0x62, 0x94, 0xca, 0xb5, 0xfd, 0x4c, 0x82, 0xbe, 0x0c, 0x54, 0x2e, 0xb0, 0xd9, 0xbe}: "TftpServer",
		efi.GUID{0x9e, 0x30, 0x72, 0x2f, 0xb0, 0xd5, 0x9d, 0x4a, 0x84, 0xa9, 0x1a, 0xb3, 0x8c, 0x69, 0x8f, 0x78}: "EcPs2Kbd",
		efi.GUID{0x9e, 0x37, 0x7a, 0xcf, 0x88, 0xf7, 0xd4, 0x44, 0xaf, 0x65, 0x16, 0x5c, 0xe1, 0xe0, 0xed, 0x68}: "SmcOptimizeDxe",
		efi.GUID{0x9e, 0x3c, 0xf9, 0x32, 0xa0, 0x83, 0xe4, 0x4e, 0xb6, 0x6b, 0xc7, 0x04, 0x61, 0x5d, 0x98, 0x95}: "ApobDummyDxe",
		efi.GUID{0x9e, 0x3e, 0x84, 0x7f, 0x26, 0xba, 0x3c, 0x4d, 0x82, 0xf7, 0xc7, 0x03, 0xd8, 0x7d, 0x33, 0x4d}: "PhI2cPlatformSupport",
		efi.GUID{0x9e, 0x3f, 0x1f, 0x5d, 0xee, 0x8c, 0x99, 0x42, 0x93, 0xc2, 0x4c, 0x64, 0xeb, 0xb5, 0x89, 0x77}: "GetServByName",
		efi.GUID{0x9e, 0x48, 0x20, 0xc0, 0xb2, 0x6d, 0xf2, 0x4e, 0x9a, 0xa5, 0xca, 0x06, 0xfc, 0x11, 0xd3, 0x6a}: "EfiAcpiVariableCompatiblityGuid",
		efi.GUID{0x9e, 0x52, 0xb6, 0x3a, 0x90, 0x6f, 0x63, 0x48, 0xaf, 0xfa, 0xf5, 0xba, 0x08, 0xde, 0xa9, 0xaa}: "SbBeepLibPcAt",
		efi.GUID{0x9e, 0x5a, 0x3f, 0xa4, 0x9e, 0xb2, 0x1b, 0x45, 0x85, 0x26, 0x44, 0xc3, 0xe4, 0x3d, 0x50, 0x67}: "SioInit",
		efi.GUID{0x9e, 0x60, 0xe5, 0xa2, 0x2d, 0x8c, 0xe6, 0x42, 0xa2, 0xfc, 0x12, 0xbc, 0x74, 0xbd, 0x43, 0x7f}: "EfiPeiPlatformTypeNeonCityEprpPpi",
		efi.GUID{0x9e, 0x6b, 0xc1, 0xf2, 0x85, 0x89, 0xdb, 0x11, 0x92, 0xc8, 0x00, 0x40, 0xd0, 0x2b, 0x18, 0x35}: "EfiUnixFileSystem",
		efi.GUID{0x9e, 0x6d, 0x18, 0xe6, 0x97, 0x27, 0x3d, 0x42, 0xb0, 0x75, 0x97, 0x0a, 0x2c, 0x5f, 0xc3, 0x38}: "DmiArrayVarProtect",
		efi.GUID{0x9e, 0x8a, 0xa7, 0xc1, 0xe8, 0x11, 0x10, 0x49, 0x91, 0xa5, 0xfe, 0x48, 0xf5, 0xf4, 0xc2, 0x0d}: "DellEpsaDxe",
		efi.GUID{0x9e, 0x8f, 0x3f, 0xda, 0x46, 0x8d, 0x66, 0x4b, 0xa0, 0x09, 0x42, 0xc8, 0xbc, 0xad, 0x85, 0x30}: "FjVgaDxe",
		efi.GUID{0x9e, 0x92, 0x29, 0x2c, 0xcf, 0x27, 0xd5, 0x4d, 0xbb, 0x97, 0xe5, 0x52, 0x57, 0x91, 0xf5, 0xba}: "DRYDXE",
		efi.GUID{0x9e, 0x93, 0x9b, 0xcb, 0x6d, 0xfb, 0xb7, 0x48, 0x9e, 0x58, 0x90, 0x18, 0x8d, 0x77, 0x18, 0x9d}: "SgTpvAcpiS3Save",
		efi.GUID{0x9e, 0x9c, 0x8e, 0xe9, 0xbe, 0xda, 0x3f, 0x4d, 0xb0, 0x2a, 0xb3, 0x70, 0x8b, 0xd7, 0x84, 0xeb}: "FiopCcgFwUpdate",
		efi.GUID{0x9e, 0xa7, 0xa4, 0xf2, 0xef, 0x89, 0x25, 0x4b, 0xa4, 0x8d, 0xa5, 0xf0, 0x5c, 0x8d, 0x52, 0x2c}: "FchKeithDxe",
		efi.GUID{0x9e, 0xa7, 0xbc, 0x97, 0x22, 0x24, 0xad, 0x4e, 0xa1, 0x01, 0xba, 0xce, 0x64, 0x4a, 0x5a, 0xc8}: "OemBadgingSupportDxe",
		efi.GUID{0x9e, 0xae, 0xa2, 0xec, 0x94, 0x75, 0x01, 0x49, 0x87, 0x1c, 0x44, 0x9d, 0xa1, 0xa1, 0x16, 0x60}: "I2cDxe",
		efi.GUID{0x9e, 0xbc, 0x99, 0x7e, 0xe9, 0xed, 0xc1, 0x48, 0x85, 0xb9, 0x68, 0x94, 0x32, 0x81, 0x7f, 0x8f}: "SystemEsrtDxe",
		efi.GUID{0x9e, 0xbe, 0x77, 0x24, 0x1a, 0x8e, 0x1e, 0x43, 0xb7, 0x05, 0x14, 0xe6, 0x63, 0x71, 0x73, 0x77}: "PsmiComboBufferGuid",
		efi.GUID{0x9e, 0xc3, 0xaf, 0xd3, 0x47, 0xbc, 0xd3, 0x49, 0xaf, 0xed, 0x60, 0x4c, 0x46, 0x75, 0x2d, 0x0a}: "DellPsidPei",
		efi.GUID{0x9e, 0xc9, 0x89, 0xe8, 0xe9, 0xeb, 0xd7, 0x4b, 0x2f, 0xcc, 0x32, 0x16, 0x10, 0x06, 0x1e, 0x80}: "CypressCCG4Pei",
		efi.GUID{0x9e, 0xca, 0x7d, 0x83, 0x74, 0xe8, 0x82, 0x4d, 0xb2, 0x9a, 0x23, 0xfe, 0x0e, 0x23, 0xd1, 0xe2}: "VirtioMmioTransportGuid",
		efi.GUID{0x9e, 0xd4, 0xa4, 0x61, 0x68, 0x6f, 0x1b, 0x4f, 0xb9, 0x22, 0xa8, 0x6e, 0xed, 0x0b, 0x07, 0xa2}: "EfiUgaIoProtocolGuid",
		efi.GUID{0x9e, 0xd8, 0x16, 0x95, 0x6d, 0x0a, 0xf6, 0x4a, 0x8c, 0x26, 0x55, 0x26, 0xf1, 0x1e, 0xe8, 0x2e}: "BrightnessControlSmm",
		efi.GUID{0x9e, 0xec, 0xe9, 0x17, 0x36, 0x40, 0x37, 0x42, 0xb0, 0x74, 0xd1, 0xf2, 0x94, 0x64, 0x59, 0x9c}: "OemDataRegionFlashSmm",
		efi.GUID{0x9e, 0xf3, 0xa1, 0x1f, 0xff, 0xfe, 0xae, 0x4a, 0xbd, 0x7b, 0x38, 0xa0, 0x70, 0xa3, 0xb6, 0x09}: "PartitionDxe",
		efi.GUID{0x9f, 0x04, 0x19, 0x4c, 0x37, 0x41, 0xd3, 0x4d, 0x9c, 0x10, 0x8b, 0x97, 0xa8, 0x3f, 0xfd, 0xfa}: "EfiMemoryTypeInformationGuid",
		efi.GUID{0x9f, 0x07, 0xbf, 0x66, 0x14, 0x2a, 0xed, 0x47, 0xa0, 0xf2, 0x90, 0xca, 0xf3, 0x56, 0xe0, 0x88}: "ASM108XPEI",
		efi.GUID{0x9f, 0x0e, 0x6b, 0xb8, 0xaf, 0x9f, 0x68, 0x43, 0xa1, 0x31, 0x62, 0x41, 0x6f, 0x3d, 0xd2, 0x1b}: "AmdMemFp7Dxe",
		efi.GUID{0x9f, 0x0f, 0x82, 0x82, 0x97, 0x41, 0xd0, 0x46, 0xa9, 0x6c, 0xb1, 0xd1, 0x5b, 0xad, 0x98, 0x8e}: "AmiUsbVideoProtocol",
		efi.GUID{0x9f, 0x14, 0x0d, 0xad, 0x67, 0xba, 0x0b, 0x4e, 0xa6, 0xa2, 0x4e, 0x88, 0x53, 0x67, 0x3e, 0xa5}: "ErrorGlobeTile",
		efi.GUID{0x9f, 0x19, 0x96, 0x09, 0xe2, 0x2c, 0x97, 0x4d, 0x83, 0x0b, 0x07, 0x7a, 0x7b, 0x28, 0x58, 0x8a}: "WpbtDxe",
		efi.GUID{0x9f, 0x1c, 0xfa, 0x4d, 0x8d, 0xd9, 0xb9, 0x43, 0x88, 0x32, 0x05, 0x9c, 0xad, 0xeb, 0xe4, 0x36}: "PeiPortingSample",
		efi.GUID{0x9f, 0x1d, 0x8c, 0x96, 0xc4, 0x80, 0xb7, 0x43, 0x8c, 0xae, 0x66, 0x8a, 0xa5, 0x6c, 0x4e, 0x71}: "SmbiosPeim",
		efi.GUID{0x9f, 0x1d, 0x8e, 0x78, 0xab, 0x1e, 0xd2, 0x47, 0xa2, 0xf3, 0x78, 0xca, 0xe8, 0x7d, 0x60, 0x12}: "IdccDataHubGuid",
		efi.GUID{0x9f, 0x21, 0x82, 0x1d, 0x6f, 0x38, 0x26, 0x4f, 0xaf, 0xac, 0x61, 0x3f, 0x24, 0x2c, 0x07, 0x60}: "DellSmmStatusCode",
		efi.GUID{0x9f, 0x29, 0xcd, 0x53, 0xc1, 0x2b, 0xc0, 0x40, 0x8c, 0x07, 0x23, 0xf6, 0x4f, 0xdb, 0x30, 0xe0}: "EdkiiPlatformLogoProtocolGuid",
		efi.GUID{0x9f, 0x37, 0x1f, 0x4f, 0x62, 0x2a, 0xbb, 0x48, 0xac, 0x34, 0xd3, 0xf1, 0x35, 0xc6, 0xe2, 0xb7}: "PcatSingleSegmentPciCfg2Pei",
		efi.GUID{0x9f, 0x42, 0xa0, 0x97, 0x45, 0x39, 0x5b, 0x48, 0x83, 0x36, 0x1c, 0x52, 0x74, 0x71, 0x3f, 0x03}: "AmiPspPei",
		efi.GUID{0x9f, 0x59, 0x2e, 0x25, 0x04, 0xd6, 0xea, 0x4b, 0x8f, 0xeb, 0x34, 0x76, 0x68, 0xe9, 0x3b, 0x8f}: "FjRTS54xx",
		efi.GUID{0x9f, 0x59, 0xe7, 0xba, 0x6b, 0x3c, 0xb7, 0x43, 0xbd, 0xf0, 0x9c, 0xe0, 0x7a, 0xa9, 0x1a, 0xa6}: "CpuIoDxe",
		efi.GUID{0x9f, 0x5a, 0x78, 0x4a, 0x09, 0xfe, 0x5d, 0x40, 0xff, 0xff, 0xff, 0xff, 0xd7, 0xbd, 0x26, 0x94}: "XnoteGopVbiosDxe",
		efi.GUID{0x9f, 0x60, 0xd6, 0xf4, 0xb3, 0x2f, 0x1a, 0x40, 0xa4, 0xe7, 0xbd, 0xb5, 0x67, 0x12, 0x56, 0x29}: "SbFlashControllerDxe",
		efi.GUID{0x9f, 0x67, 0xdf, 0x2c, 0xa0, 0x7a, 0x0f, 0x4d, 0xaf, 0xe1, 0x1a, 0xda, 0xe2, 0x70, 0x61, 0xc9}: "FjMfgFirstPowerOnDxe",
		efi.GUID{0x9f, 0x6e, 0xfd, 0x6d, 0x78, 0x92, 0xd8, 0x48, 0x8f, 0x45, 0xb6, 0xcf, 0xf2, 0xc2, 0xb6, 0x9c}: "TpmMeasurementLibNull",
		efi.GUID{0x9f, 0x76, 0x06, 0xf9, 0xed, 0x4a, 0x0d, 0x4a, 0x8c, 0x7c, 0xff, 0x21, 0xb9, 0xd1, 0x05, 0x1a}: "IntelVTdPmrPei",
		efi.GUID{0x9f, 0x86, 0xc8, 0xf4, 0xb4, 0xa6, 0x6f, 0x4f, 0xa3, 0xc7, 0x2d, 0xef, 0x22, 0xbd, 0x82, 0x25}: "M24Lc128Pei",
		efi.GUID{0x9f, 0x8f, 0x1d, 0xa1, 0x52, 0x2a, 0xbc, 0x40, 0x9b, 0x82, 0xbc, 0xcd, 0x7d, 0x28, 0x1e, 0xea}: "PchGpioUnlockSmm",
		efi.GUID{0x9f, 0x90, 0x43, 0x24, 0x2d, 0x89, 0xd7, 0x46, 0x79, 0x77, 0x49, 0x02, 0x25, 0x94, 0x19, 0xaa}: "HpRtxXhciSmm",
		efi.GUID{0x9f, 0x94, 0xe7, 0xa4, 0x18, 0xf8, 0xde, 0x49, 0xae, 0xc0, 0x08, 0xb0, 0xdb, 0x6e, 0x25, 0x0c}: "T23SmbiosOverride",
		efi.GUID{0x9f, 0x95, 0xca, 0x00, 0xfa, 0x6c, 0xb1, 0x4d, 0x95, 0xbc, 0xe4, 0x6c, 0x47, 0x51, 0x43, 0x90}: "EfiTlsProtocolGuid",
		efi.GUID{0x9f, 0x9d, 0x94, 0x3f, 0x66, 0xcc, 0x9a, 0x47, 0x9a, 0xd3, 0xf6, 0xc1, 0xc3, 0xff, 0x43, 0x78}: "AmiSgxDxe",
		efi.GUID{0x9f, 0x9e, 0xf7, 0xfa, 0x40, 0x4d, 0x02, 0x4f, 0x8a, 0xc9, 0x4b, 0x55, 0x12, 0x70, 0x8f, 0x7f}: "BiosGuardPolicyOverride",
		efi.GUID{0x9f, 0xa1, 0xe1, 0x69, 0x8c, 0xbc, 0x21, 0x40, 0xb3, 0xd9, 0xe0, 0xb2, 0x54, 0x50, 0x92, 0xc6}: "OC_Tuner",
		efi.GUID{0x9f, 0xab, 0x64, 0xda, 0x7f, 0xec, 0xe5, 0x4b, 0xac, 0x79, 0x53, 0x52, 0xdc, 0xd1, 0x61, 0x4d}: "AmdCpmOemSmm",
		efi.GUID{0x9f, 0xab, 0xd7, 0x7b, 0x9f, 0xdb, 0x5d, 0x45, 0x85, 0x66, 0x38, 0x7b, 0x2f, 0x13, 0xd4, 0x04}: "UsbPwrCtrlPei",
		efi.GUID{0x9f, 0xae, 0x3e, 0xff, 0x18, 0xab, 0xaf, 0x4c, 0xb2, 0xa1, 0x6b, 0xf3, 0xfd, 0xca, 0x3c, 0x4d}: "LenovoSmbiosProtocol",
		efi.GUID{0x9f, 0xba, 0xdd, 0x26, 0x0d, 0x5b, 0x80, 0x4e, 0x86, 0xb2, 0x80, 0xda, 0xe4, 0xd0, 0x1b, 0x0e}: "FdiskOemDxe",
		efi.GUID{0x9f, 0xc9, 0x4c, 0x58, 0xe8, 0x4b, 0xd1, 0x43, 0xa4, 0x5a, 0x93, 0x3d, 0xc3, 0x94, 0x79, 0xfc}: "AmiPeiNbCustomPpiGuid",
		efi.GUID{0x9f, 0xda, 0x2e, 0x0e, 0xb6, 0x4b, 0x40, 0x41, 0xae, 0xd6, 0x7d, 0xbc, 0xeb, 0x63, 0xc8, 0x29}: "MtkWifiSupDriver",
		efi.GUID{0x9f, 0xe3, 0x1d, 0x3c, 0x07, 0xd2, 0x8a, 0x40, 0xaa, 0xcc, 0x73, 0x1c, 0xfb, 0x7f, 0x1d, 0xd7}: "PciBus",
		efi.GUID{0x9f, 0xed, 0x60, 0xac, 0x3e, 0x52, 0x5b, 0x4f, 0x94, 0xca, 0x39, 0x61, 0x34, 0x6a, 0x00, 0xba}: "LenovoVariableInitDxe",
		efi.GUID{0x9f, 0xf2, 0x12, 0x8b, 0x35, 0x71, 0xab, 0x4e, 0xaf, 0xda, 0x05, 0x12, 0xf7, 0x4b, 0x65, 0xea}: "AmdSb900Dxe",
		efi.GUID{0x9f, 0xf8, 0x10, 0x52, 0x9e, 0x89, 0x75, 0x40, 0x81, 0xf9, 0x35, 0x59, 0x4e, 0x77, 0xcb, 0x9d}: "CcgOnlyPei",
		efi.GUID{0x9f, 0xf8, 0x30, 0xb4, 0x33, 0xeb, 0x14, 0x45, 0xb4, 0x90, 0x18, 0x85, 0xad, 0xdb, 0xf8, 0x40}: "TypeAEh",
		efi.GUID{0xa0, 0x08, 0x37, 0x4d, 0x9b, 0x6d, 0xd3, 0x47, 0xad, 0x87, 0xe8, 0x0c, 0x78, 0x1b, 0xc0, 0xa7}: "AmdApcbDxeV3",
		efi.GUID{0xa0, 0x0a, 0xcd, 0xd9, 0x0f, 0xc2, 0x10, 0x48, 0x99, 0x9e, 0xd9, 0x91, 0xfd, 0x04, 0x84, 0xd9}: "DellSmBiosStrucD9",
		efi.GUID{0xa0, 0x14, 0x26, 0x1a, 0xe7, 0x89, 0xe3, 0x11, 0x29, 0x90, 0x31, 0xd2, 0x81, 0xfe, 0xb1, 0xdc}: "NgnRasProtocol",
		efi.GUID{0xa0, 0x1c, 0x14, 0x61, 0x44, 0x14, 0x4e, 0x4c, 0xa1, 0x6d, 0xb6, 0x01, 0xe0, 0xa0, 0x94, 0x66}: "LenovoSystemKbcInitDxe",
		efi.GUID{0xa0, 0x21, 0x9d, 0x2b, 0x48, 0xe0, 0x33, 0x43, 0x9f, 0x02, 0xd3, 0x2f, 0xd5, 0x57, 0x67, 0x52}: "ProductIdentify",
		efi.GUID{0xa0, 0x29, 0xf0, 0xba, 0xf3, 0xb2, 0xee, 0x45, 0x8b, 0x52, 0xd4, 0x02, 0x17, 0x7b, 0xe6, 0xb8}: "LenovoOsOptDefaultSmm",
		efi.GUID{0xa0, 0x2f, 0x4c, 0xf3, 0x88, 0xde, 0x70, 0x42, 0x84, 0x14, 0x96, 0x12, 0x22, 0xf4, 0x52, 0x1c}: "PeiFlashMapPpi",
		efi.GUID{0xa0, 0x31, 0xd8, 0xc8, 0x76, 0x35, 0xc8, 0x41, 0xb0, 0xa7, 0xd9, 0x40, 0x24, 0x35, 0x63, 0x95}: "OemDisplayModeDxe",
		efi.GUID{0xa0, 0x49, 0xff, 0xe6, 0xdf, 0x15, 0xfd, 0x48, 0x9a, 0xcf, 0xd7, 0xdc, 0x27, 0x1b, 0x39, 0xd5}: "UefiCorebootModulePkgTokenSpaceGuid",
		efi.GUID{0xa0, 0x70, 0x79, 0x35, 0x5d, 0xff, 0x36, 0x4c, 0xaf, 0x68, 0x0a, 0x29, 0xa4, 0x6f, 0xf2, 0xd5}: "OemAfterMemDxe",
		efi.GUID{0xa0, 0x70, 0x8f, 0x57, 0x6d, 0x06, 0xed, 0x11, 0xb9, 0x39, 0x02, 0x42, 0xac, 0x12, 0x00, 0x02}: "AmdMemStpSp6Dxe",
		efi.GUID{0xa0, 0x77, 0x83, 0x84, 0x8d, 0xa7, 0x9d, 0x46, 0xb7, 0x66, 0x87, 0x18, 0x6a, 0xa6, 0x77, 0x0d}: "EpuHwModeDxe",
		efi.GUID{0xa0, 0x7c, 0x9a, 0x3f, 0x0e, 0xa3, 0xe8, 0x45, 0x9c, 0xbb, 0xb6, 0x28, 0xd5, 0x4a, 0x35, 0x88}: "OemPei",
		efi.GUID{0xa0, 0x85, 0x34, 0xe5, 0xf3, 0x3b, 0xd2, 0x40, 0x93, 0x4b, 0x3d, 0xb0, 0xff, 0x40, 0x57, 0x37}: "ComputraceBds",
		efi.GUID{0xa0, 0x85, 0x46, 0x52, 0xa0, 0x89, 0xe3, 0x11, 0x9d, 0x4d, 0xbf, 0xa9, 0xf6, 0xa4, 0x03, 0x08}: "AndroidFastbootPlatformProtocolGuid",
		efi.GUID{0xa0, 0x8d, 0xf1, 0x1d, 0x8b, 0xa1, 0xdf, 0x11, 0x8c, 0x3a, 0x00, 0x02, 0xa5, 0xd5, 0xc5, 0x1b}: "SataSiI3132",
		efi.GUID{0xa0, 0x92, 0x8c, 0x47, 0x22, 0x26, 0xb7, 0x42, 0xa6, 0x5d, 0x58, 0x94, 0x16, 0x9e, 0x4d, 0x24}: "ELabel",
		efi.GUID{0xa0, 0xa2, 0x9a, 0x13, 0x1f, 0x31, 0xcc, 0x42, 0x91, 0x1a, 0x57, 0x9a, 0x24, 0x47, 0xb3, 0x7d}: "XhciDxe",
		efi.GUID{0xa0, 0xac, 0x1f, 0xe1, 0x10, 0x47, 0x8e, 0x4c, 0xa7, 0xa2, 0x01, 0xba, 0xa2, 0x59, 0x1b, 0x4c}: "FdtClientProtocolGuid",
		efi.GUID{0xa0, 0xbe, 0x10, 0x60, 0x51, 0xa0, 0x8d, 0x40, 0x9a, 0x6e, 0xb7, 0x44, 0xd4, 0x68, 0xa0, 0x5d}: "WinCapsuleUpdate",
		efi.GUID{0xa0, 0xbe, 0x3c, 0x79, 0x56, 0xda, 0xf2, 0x47, 0x82, 0x64, 0x24, 0x31, 0x0c, 0xb7, 0x51, 0x96}: "LenovoSystemVariableDxe",
		efi.GUID{0xa0, 0xbf, 0x3f, 0xce, 0xa2, 0xc4, 0xf6, 0x46, 0xaf, 0x38, 0xfd, 0xd6, 0xbf, 0x40, 0x9b, 0x0a}: "SmmSioHwmIo",
		efi.GUID{0xa0, 0xc6, 0x2d, 0xb1, 0x22, 0x10, 0xb6, 0x46, 0xb9, 0x95, 0x86, 0x46, 0xad, 0x5e, 0x5e, 0xeb}: "AcpiPcatProtocol",
		efi.GUID{0xa0, 0xce, 0x30, 0xd5, 0x63, 0xdd, 0xde, 0x11, 0x8a, 0x39, 0x08, 0x00, 0x20, 0x0c, 0x9a, 0x66}: "MemSpd",
		efi.GUID{0xa0, 0xdc, 0x1a, 0x80, 0x5e, 0x81, 0xa4, 0x46, 0x84, 0xf7, 0x65, 0x7f, 0x53, 0x62, 0x1a, 0x57}: "SectionExtractionDxe",
		efi.GUID{0xa0, 0xe0, 0x87, 0x8c, 0x90, 0xb3, 0xe3, 0x4b, 0x81, 0x9c, 0x7c, 0x6c, 0x83, 0xca, 0xe4, 0xeb}: "SmmBaseHelper",
		efi.GUID{0xa0, 0xe7, 0x70, 0x07, 0x3a, 0x9c, 0x9c, 0x49, 0xa3, 0x11, 0x2f, 0x83, 0x85, 0x08, 0x05, 0x56}: "BoardInfoSmm",
		efi.GUID{0xa0, 0xeb, 0xf2, 0xe1, 0xb9, 0xf7, 0x26, 0x4a, 0x86, 0x20, 0x13, 0x12, 0x21, 0x64, 0x2a, 0x90}: "EfiPciCfgPpiInServiceTableGuid",
		efi.GUID{0xa0, 0xef, 0x09, 0xb7, 0xa6, 0x47, 0x41, 0x4b, 0xb9, 0x31, 0x12, 0xec, 0xe7, 0xa8, 0xee, 0x56}: "EfiSmmPowerButtonDispatchProtocolGuid",
		efi.GUID{0xa0, 0xf7, 0x21, 0xad, 0x5b, 0x7f, 0xfe, 0x47, 0x8c, 0xc0, 0x24, 0x1f, 0x31, 0x8c, 0xab, 0xf5}: "AppleLegacyStartup",
		efi.GUID{0xa0, 0xfc, 0xbb, 0xf0, 0x4e, 0x68, 0xb3, 0x48, 0xba, 0xe2, 0x6c, 0x84, 0xb8, 0x9e, 0x53, 0x39}: "EfiPchExtendedResetProtocolGuid",
		efi.GUID{0xa0, 0xfd, 0x3a, 0xb2, 0xd3, 0xd1, 0x5a, 0x4f, 0xb0, 0x1f, 0x62, 0xed, 0x16, 0xa9, 0x78, 0x63}: "HpAudioPei",
		efi.GUID{0xa1, 0x04, 0x57, 0xe1, 0xf5, 0xa2, 0x68, 0x76, 0x28, 0xc0, 0xf8, 0xc8, 0x66, 0x31, 0x70, 0xa6}: "EcFlashDxe",
		efi.GUID{0xa1, 0x07, 0xe6, 0x2f, 0xd3, 0xb7, 0xd6, 0x41, 0xbe, 0x4a, 0xda, 0x60, 0xbd, 0x1c, 0xaa, 0xac}: "FchSmmDispatcher",
		efi.GUID{0xa1, 0x0e, 0x7f, 0x69, 0x30, 0xb6, 0x93, 0x4b, 0x9b, 0x08, 0xea, 0xff, 0xc5, 0xd5, 0xfc, 0x45}: "FmpDxe",
		efi.GUID{0xa1, 0x15, 0x84, 0x89, 0xf1, 0x06, 0x21, 0x4c, 0xb8, 0x3a, 0xc5, 0x55, 0xcf, 0x2f, 0x23, 0x64}: "DellMemoryThrottleProtocol",
		efi.GUID{0xa1, 0x1b, 0xe3, 0x88, 0x56, 0x18, 0x8b, 0x4b, 0xbb, 0xdf, 0xf8, 0x16, 0xdd, 0x94, 0x0a, 0xef}: "S3Communication",
		efi.GUID{0xa1, 0x1c, 0x78, 0x00, 0xe3, 0x5d, 0x5f, 0x40, 0xab, 0xb8, 0x37, 0x9c, 0x3c, 0x07, 0x69, 0x84}: "AmiRomLayoutGuid",
		efi.GUID{0xa1, 0x21, 0x6b, 0x4b, 0x6b, 0xf2, 0x4f, 0x40, 0x86, 0x94, 0xdb, 0x1c, 0x63, 0xa1, 0xd9, 0x2a}: "LenovoAt24Rf08EepromSmm",
		efi.GUID{0xa1, 0x23, 0x74, 0x55, 0xab, 0x63, 0x6c, 0x40, 0xbe, 0x7e, 0x91, 0xcd, 0xbc, 0x08, 0xc4, 0x57}: "QemuRamfb",
		efi.GUID{0xa1, 0x24, 0x42, 0x2a, 0x09, 0x26, 0xa7, 0x40, 0x88, 0xe2, 0xa6, 0x8d, 0xc0, 0xf1, 0xd1, 0x80}: "SpiFlashProDxe",
		efi.GUID{0xa1, 0x25, 0x44, 0xbe, 0xdb, 0x18, 0xef, 0x47, 0x92, 0x73, 0x27, 0x3e, 0x95, 0x00, 0x70, 0x14}: "EfiPlatformTypeNeonCityEpecbProtocol",
		efi.GUID{0xa1, 0x28, 0x11, 0x2e, 0xec, 0x18, 0x9d, 0x41, 0xa0, 0x58, 0x10, 0x76, 0xe2, 0x43, 0xe3, 0x23}: "HpSioSecuritySmmProtocol",
		efi.GUID{0xa1, 0x29, 0x7f, 0x59, 0x54, 0xf3, 0xbb, 0x4f, 0xaf, 0xf4, 0xbc, 0xbd, 0xa6, 0xa8, 0x7c, 0x2c}: "LpcFlashPeiLibNull",
		efi.GUID{0xa1, 0x2a, 0x42, 0x97, 0x5e, 0x85, 0xb2, 0x44, 0xae, 0xfd, 0x90, 0x5e, 0x0c, 0x8f, 0x41, 0x69}: "FjDtSmbiosDxe",
		efi.GUID{0xa1, 0x2b, 0xdf, 0x6f, 0x52, 0xf9, 0x48, 0x47, 0xbb, 0x6d, 0x31, 0xa7, 0x6d, 0x37, 0x7a, 0x82}: "OdmDebugSmm",
		efi.GUID{0xa1, 0x2c, 0x2f, 0xee, 0x1d, 0x91, 0xae, 0x44, 0x97, 0xd8, 0xab, 0x31, 0x37, 0x58, 0xb0, 0x25}: "DellMfgDefaultsDxe",
		efi.GUID{0xa1, 0x31, 0x1b, 0x5b, 0x62, 0x95, 0xd2, 0x11, 0x8e, 0x3f, 0x00, 0xa0, 0xc9, 0x69, 0x72, 0x3b}: "EfiLoadedImageProtocolGuid",
		efi.GUID{0xa1, 0x34, 0xad, 0xbc, 0xb7, 0xde, 0xfc, 0x4f, 0x90, 0xd8, 0xb0, 0x64, 0x3b, 0xd8, 0x27, 0x1a}: "AmtMacPassThrough",
		efi.GUID{0xa1, 0x36, 0x8e, 0x21, 0xa4, 0xc2, 0x42, 0x4d, 0x80, 0x24, 0xc9, 0xb8, 0x0e, 0x3d, 0xaf, 0x47}: "FjFvFlashRt",
		efi.GUID{0xa1, 0x3a, 0xe2, 0xdb, 0x42, 0xa3, 0x97, 0x4b, 0x85, 0xb6, 0xb2, 0x26, 0xf1, 0x61, 0x73, 0x89}: "EfiPayLoadHobBasePpi",
		efi.GUID{0xa1, 0x3b, 0x96, 0xb7, 0xa8, 0xd5, 0xbd, 0x4a, 0xb5, 0xce, 0x41, 0x94, 0x0b, 0x00, 0x69, 0x01}: "WakeUpInDxe",
		efi.GUID{0xa1, 0x43, 0xbf, 0x08, 0x5f, 0xcd, 0xe4, 0x44, 0x82, 0x75, 0x7d, 0x3b, 0x79, 0x22, 0x8f, 0xa3}: "Lpit",
		efi.GUID{0xa1, 0x43, 0xda, 0x37, 0x9a, 0xbb, 0x05, 0x48, 0x9b, 0x92, 0x0b, 0xde, 0x11, 0x19, 0x11, 0x49}: "ACPIRAM",
		efi.GUID{0xa1, 0x4d, 0xb8, 0x0e, 0x7a, 0x26, 0xb4, 0x40, 0x83, 0x47, 0x1f, 0x48, 0x69, 0x4c, 0x8b, 0x47}: "PeCoffExtraActionLibNull",
		efi.GUID{0xa1, 0x4f, 0x7f, 0xec, 0x17, 0xb2, 0xfc, 0x42, 0xa7, 0xf7, 0x02, 0x0c, 0x43, 0x05, 0xd5, 0xba}: "EfiSmramNvsHeader",
		efi.GUID{0xa1, 0x59, 0xc0, 0xa5, 0xe4, 0x94, 0xa7, 0x4a, 0x87, 0xb5, 0xab, 0x15, 0x5c, 0x2b, 0xf0, 0x72}: "EfiCertX509Guid",
		efi.GUID{0xa1, 0x62, 0xc0, 0x99, 0xdf, 0xa4, 0x99, 0x4e, 0x81, 0x3b, 0xc2, 0x83, 0xe1, 0xef, 0xe7, 0x61}: "SbSocRenoirDxe",
		efi.GUID{0xa1, 0x65, 0x11, 0x92, 0x72, 0x8d, 0x51, 0x44, 0x9f, 0xf6, 0xea, 0xb5, 0x08, 0xc3, 0x19, 0xab}: "OemSmbios",
		efi.GUID{0xa1, 0x65, 0xac, 0x92, 0x72, 0x8d, 0x51, 0x44, 0x9f, 0xf6, 0xea, 0xb5, 0x08, 0xc3, 0x19, 0xab}: "OemDxe",
		efi.GUID{0xa1, 0x6c, 0xe0, 0x99, 0x79, 0x37, 0xb4, 0x48, 0x8d, 0x0a, 0x8a, 0x49, 0x62, 0x30, 0xe1, 0x0f}: "NetworkOfflineLockerSmi",
		efi.GUID{0xa1, 0x77, 0x20, 0xc2, 0x9b, 0x5f, 0x91, 0x48, 0x9d, 0x1c, 0xde, 0xaa, 0x36, 0x32, 0xe9, 0x21}: "DellUefiBootInfoDxe",
		efi.GUID{0xa1, 0x79, 0xd2, 0x07, 0xe4, 0x34, 0x68, 0x41, 0x99, 0x3b, 0x17, 0x8b, 0x3a, 0xcc, 0x68, 0xef}: "AodSetupDxe",
		efi.GUID{0xa1, 0x7a, 0xc1, 0xd1, 0xc5, 0xca, 0x0f, 0x40, 0xbe, 0x17, 0xe2, 0xa2, 0xae, 0x06, 0x67, 0x7c}: "EfiKmsFormatMd4128Guid",
		efi.GUID{0xa1, 0x7d, 0x90, 0xea, 0x74, 0x4a, 0xb8, 0x80, 0xa6, 0x6e, 0xba, 0xa3, 0x84, 0x22, 0x3e, 0x12}: "DellBiosAttributes",
		efi.GUID{0xa1, 0x80, 0x2b, 0x4a, 0x73, 0x65, 0x91, 0x46, 0xad, 0x18, 0x56, 0x70, 0x4d, 0xb7, 0x4a, 0x59}: "HpSmbiosDoneSmm",
		efi.GUID{0xa1, 0x8a, 0x5d, 0x69, 0xee, 0x42, 0x46, 0x4c, 0x80, 0x5c, 0x6e, 0xa6, 0xbc, 0xe7, 0x99, 0xe3}: "EfiPeiVirtualBlockIoPpiGuid",
		efi.GUID{0xa1, 0x8b, 0xc0, 0x3f, 0xc6, 0xed, 0x5f, 0x4e, 0xbd, 0xc8, 0x0e, 0x46, 0xb6, 0x5c, 0x92, 0xf6}: "SmmGpiDispatch2OnSmmGpiDispatchThunk",
		efi.GUID{0xa1, 0x95, 0x8e, 0x59, 0x74, 0x96, 0x10, 0x4c, 0x93, 0x42, 0x3f, 0x06, 0x31, 0x70, 0x33, 0xf7}: "SmbiosType13",
		efi.GUID{0xa1, 0x97, 0x68, 0xa5, 0x7f, 0xa7, 0x00, 0x46, 0x84, 0xdb, 0x22, 0xb0, 0xa8, 0x01, 0xfa, 0x9a}: "SmmRuntime",
		efi.GUID{0xa1, 0xa7, 0x12, 0x04, 0x50, 0xc0, 0xc2, 0x42, 0x87, 0x7a, 0x77, 0xc3, 0x79, 0xf9, 0xf5, 0xf1}: "FirewireOhciDxe",
		efi.GUID{0xa1, 0xa8, 0xb9, 0x9f, 0x4a, 0x2f, 0xa6, 0x43, 0x88, 0x9c, 0xd0, 0xf7, 0xb6, 0xc4, 0x7a, 0xd5}: "EfiDhcp6ServiceBindingProtocolGuid",
		efi.GUID{0xa1, 0xaa, 0xea, 0x04, 0xa1, 0x29, 0xd7, 0x11, 0x88, 0x38, 0x00, 0x50, 0x04, 0x73, 0xd4, 0xeb}: "UsbRtSmm",
		efi.GUID{0xa1, 0xb0, 0x35, 0x39, 0x82, 0xa1, 0x87, 0x48, 0xbc, 0x56, 0x67, 0x55, 0x28, 0xe7, 0x88, 0x77}: "SetupUtilityApp",
		efi.GUID{0xa1, 0xb5, 0x25, 0x03, 0x37, 0x09, 0x4f, 0x4a, 0xb8, 0xaf, 0xec, 0x3f, 0x80, 0xee, 0x6b, 0x35}: "SataControllerLite",
		efi.GUID{0xa1, 0xc1, 0x8a, 0x9b, 0x26, 0xf3, 0x05, 0x49, 0xa4, 0x3d, 0xe1, 0xcc, 0xc6, 0xde, 0x6b, 0xc1}: "KEMrBootCnt",
		efi.GUID{0xa1, 0xc4, 0x00, 0x73, 0xf2, 0x43, 0x17, 0x40, 0xa5, 0x1b, 0xc8, 0x1a, 0x7f, 0x40, 0x58, 0x5b}: "EfiSmmStandbyButtonDispatch2ProtocolGuid",
		efi.GUID{0xa1, 0xc7, 0x3e, 0xda, 0xd3, 0xf6, 0x29, 0x41, 0x98, 0xb0, 0x94, 0x94, 0xf8, 0x58, 0x50, 0x06}: "DellLegUsbBusProtocol",
		efi.GUID{0xa1, 0xc8, 0x98, 0x46, 0x34, 0x49, 0x96, 0x4a, 0xbb, 0x90, 0xf7, 0xa5, 0x50, 0x89, 0xca, 0xfd}: "OemDxe",
		efi.GUID{0xa1, 0xca, 0x1b, 0xdf, 0x52, 0x91, 0x57, 0x43, 0xa6, 0xb6, 0xe5, 0xfb, 0xcf, 0xbb, 0x6b, 0x81}: "FchSmbusPei",
		efi.GUID{0xa1, 0xcd, 0xe8, 0x39, 0x35, 0x6a, 0xdd, 0x4c, 0xa9, 0x02, 0xd1, 0xa7, 0x95, 0xf7, 0x03, 0x80}: "AmiResetTypeHob",
		efi.GUID{0xa1, 0xd0, 0xd0, 0x29, 0x6b, 0x44, 0xf4, 0x4a, 0xae, 0x36, 0x52, 0x60, 0x69, 0xe2, 0xd5, 0x43}: "BBVersionHob",
		efi.GUID{0xa1, 0xd2, 0xd9, 0xc9, 0x86, 0xe5, 0x2f, 0x4f, 0xbf, 0x6e, 0x99, 0x24, 0x0c, 0x06, 0x9e, 0xb1}: "RealtekWsTbt3Pxe",
		efi.GUID{0xa1, 0xd4, 0x23, 0xa0, 0xa1, 0x05, 0x97, 0x47, 0xb8, 0x4f, 0x03, 0xb8, 0x54, 0xfd, 0x05, 0xf1}: "EneDXE",
		efi.GUID{0xa1, 0xd5, 0xcb, 0x6e, 0xf8, 0xc0, 0x02, 0x47, 0x83, 0x01, 0x4f, 0xc2, 0xc5, 0x47, 0x0a, 0x51}: "EfiArmTfCpuDriverEpDescriptor",
		efi.GUID{0xa1, 0xd6, 0x8d, 0x78, 0xee, 0xf1, 0xba, 0x4b, 0xa9, 0x25, 0xc0, 0xe7, 0xd6, 0x62, 0x71, 0xbd}: "SystemBoardDxe",
		efi.GUID{0xa1, 0xdb, 0xe7, 0x6d, 0x8a, 0xc2, 0xf7, 0x47, 0xaf, 0x06, 0x18, 0x10, 0xe1, 0x49, 0x5c, 0x56}: "FjJapanFeatureSupport",
		efi.GUID{0xa1, 0xdf, 0x0a, 0xb1, 0x43, 0x9e, 0x7f, 0x48, 0xaa, 0xf3, 0xa7, 0xa9, 0xbd, 0xea, 0xf4, 0xac}: "ProgressBarFullRightEndcap",
		efi.GUID{0xa1, 0xe3, 0x95, 0x84, 0xd9, 0x43, 0xe8, 0x11, 0x92, 0x7f, 0xa4, 0xc4, 0x94, 0x3f, 0x0c, 0x96}: "NvdimmInitializer",
		efi.GUID{0xa1, 0xe7, 0x8e, 0x7b, 0x35, 0x4e, 0x56, 0x45, 0xbb, 0x56, 0x67, 0x97, 0xe2, 0x44, 0x45, 0xc2}: "PeiCpuPlatformPolicyPpi",
		efi.GUID{0xa1, 0xeb, 0xbf, 0x25, 0xba, 0xa3, 0xe2, 0x4b, 0x92, 0x48, 0x88, 0x63, 0x92, 0xf7, 0xb0, 0x08}: "AmdNbioPciePei",
		efi.GUID{0xa1, 0xf1, 0x11, 0x6a, 0x8b, 0x31, 0x12, 0x47, 0x89, 0xc9, 0x2d, 0xbf, 0x00, 0x99, 0x5b, 0xe0}: "Cf9Reset",
		efi.GUID{0xa1, 0xf6, 0x0d, 0x51, 0xc1, 0xb6, 0x48, 0x49, 0xae, 0xe7, 0x59, 0xf2, 0x20, 0xf8, 0x98, 0xbd}: "SataController",
		efi.GUID{0xa1, 0xf6, 0xe1, 0xe0, 0x4b, 0x9d, 0xe3, 0x11, 0x83, 0xc4, 0x78, 0xe7, 0xd1, 0xaf, 0x36, 0xd1}: "HpNetworkBiosUpdateDriver",
		efi.GUID{0xa1, 0xfc, 0x86, 0xb6, 0x62, 0x94, 0x91, 0x4e, 0xa7, 0x04, 0xa6, 0x8c, 0x83, 0x41, 0x00, 0xa4}: "SetupConfigUpdateDxeBlizzard",
		efi.GUID{0xa1, 0xfc, 0xa3, 0xf3, 0x6f, 0x46, 0x78, 0x49, 0xac, 0x84, 0x2e, 0xa7, 0x0f, 0xae, 0x2b, 0xa2}: "AsfSecureBootSmm",
		efi.GUID{0xa1, 0xfe, 0xe7, 0x99, 0x6f, 0x9a, 0x68, 0x4d, 0xa7, 0x54, 0x30, 0x79, 0x3b, 0x78, 0xa7, 0x38}: "RasInit",
		efi.GUID{0xa2, 0x03, 0x93, 0x0b, 0xf6, 0x5b, 0x25, 0x47, 0x84, 0x14, 0x7e, 0xdc, 0xd3, 0x43, 0xd2, 0x7d}: "RZ616_MtkWiFiDex",
		efi.GUID{0xa2, 0x0d, 0xea, 0x29, 0xa0, 0x84, 0xc1, 0x4f, 0x80, 0xe4, 0x05, 0x31, 0xc7, 0x46, 0x6e, 0xf6}: "DellSupportAssistUi",
		efi.GUID{0xa2, 0x16, 0x02, 0x95, 0x21, 0xa6, 0x9c, 0x47, 0xa1, 0x3d, 0x29, 0x90, 0x61, 0x7b, 0xdf, 0xe7}: "ReadOnlyVariable2OnReadOnlyVariableThunk",
		efi.GUID{0xa2, 0x1f, 0x1b, 0x6f, 0x1d, 0x56, 0xc3, 0x47, 0xa2, 0x2d, 0xdb, 0xdc, 0x21, 0x24, 0x6d, 0x8f}: "TrustedChannelSmm",
		efi.GUID{0xa2, 0x23, 0x16, 0x6c, 0x45, 0x32, 0x42, 0x4f, 0xa8, 0xce, 0xf7, 0x3b, 0x05, 0x4f, 0xaa, 0xfc}: "MpmDxe",
		efi.GUID{0xa2, 0x24, 0x97, 0x60, 0xfe, 0xdb, 0x3e, 0x4e, 0xa1, 0x29, 0x9e, 0x01, 0xa7, 0x4e, 0x49, 0xbb}: "HpPlatformErrorLoggingDxe",
		efi.GUID{0xa2, 0x2d, 0x68, 0x1a, 0xe3, 0x3e, 0x93, 0x47, 0x85, 0x21, 0x4d, 0xb8, 0xa6, 0x99, 0x39, 0xfc}: "AmdNbioAlibMDNDxe",
		efi.GUID{0xa2, 0x2e, 0xb3, 0xeb, 0x82, 0x63, 0xf3, 0x43, 0x95, 0x5a, 0x39, 0x47, 0x5a, 0xe6, 0xe1, 0xab}: "UefiRaidPei",
		efi.GUID{0xa2, 0x2f, 0x76, 0xb3, 0xd6, 0x54, 0xbc, 0x4e, 0x84, 0xde, 0x4c, 0xfa, 0x93, 0x40, 0xfc, 0xb3}: "AcpiAMLDxe",
		efi.GUID{0xa2, 0x36, 0x6d, 0xfb, 0x7d, 0xef, 0x74, 0x4b, 0x99, 0xac, 0x80, 0xb3, 0x1f, 0x6b, 0xe9, 0xb1}: "WheaErrorInj",
		efi.GUID{0xa2, 0x41, 0xbb, 0xf8, 0x5e, 0x48, 0x9d, 0x4b, 0x88, 0xcf, 0x15, 0x1e, 0x62, 0xf8, 0x4d, 0xde}: "DellSmbRunRom",
		efi.GUID{0xa2, 0x50, 0x2a, 0x53, 0xe6, 0xbc, 0x75, 0x46, 0x80, 0xec, 0x53, 0xee, 0x57, 0xa6, 0x8f, 0xa2}: "FchBixbySmmInit",
		efi.GUID{0xa2, 0x56, 0x01, 0xf8, 0x2c, 0x1a, 0x35, 0x33, 0x98, 0x2c, 0x06, 0x6c, 0x1f, 0xc3, 0x76, 0x26}: "TbtInfo",
		efi.GUID{0xa2, 0x58, 0x1d, 0xea, 0x3d, 0xea, 0x14, 0x4c, 0x92, 0x8a, 0x80, 0xa1, 0x45, 0x45, 0xe6, 0x81}: "WheaPlatformBoot",
		efi.GUID{0xa2, 0x59, 0xd1, 0x14, 0xed, 0x52, 0x5d, 0x46, 0x93, 0x53, 0xf2, 0x39, 0xc5, 0x46, 0x4b, 0xf5}: "DellSmmLomProtocol",
		efi.GUID{0xa2, 0x5d, 0xb4, 0x16, 0x70, 0x7d, 0xea, 0x4a, 0xa5, 0x8d, 0x76, 0x0e, 0x9e, 0xcb, 0x84, 0x1d}: "FD_Drv_X86",
		efi.GUID{0xa2, 0x61, 0x1a, 0xbb, 0xb5, 0x6d, 0xd7, 0x4b, 0x8a, 0x98, 0x78, 0x23, 0xc9, 0x2b, 0x0a, 0x2a}: "FvbServicesSmm",
		efi.GUID{0xa2, 0x66, 0x0e, 0xf8, 0x2c, 0x1a, 0x5b, 0x41, 0x9b, 0x9c, 0x06, 0x6c, 0x1f, 0x04, 0xb6, 0x26}: "TbtDxe",
		efi.GUID{0xa2, 0x6b, 0xec, 0x80, 0xb4, 0xc4, 0xcc, 0x4a, 0xb8, 0x9c, 0xf6, 0x1d, 0x8b, 0xac, 0xd6, 0x75}: "OCUR",
		efi.GUID{0xa2, 0x6e, 0xf6, 0xe2, 0x13, 0x03, 0x7e, 0x4b, 0xa7, 0x4f, 0x8e, 0x23, 0xa6, 0xfe, 0xb4, 0x49}: "UfsPhyOverrideHobGuid",
		efi.GUID{0xa2, 0x71, 0x51, 0xc8, 0xbd, 0x9c, 0x74, 0x4e, 0x8c, 0x9b, 0xd3, 0x33, 0x84, 0xa2, 0x36, 0xa3}: "I2cGlkToMde",
		efi.GUID{0xa2, 0x72, 0x74, 0x2e, 0xbf, 0xd7, 0x5e, 0x4f, 0x8f, 0xe4, 0xbf, 0x19, 0x24, 0x78, 0x56, 0xd0}: "SecCore",
		efi.GUID{0xa2, 0x7a, 0x53, 0xcb, 0x27, 0xf7, 0x0b, 0x44, 0x97, 0x02, 0xad, 0xe9, 0xd0, 0xa2, 0x93, 0xf1}: "PlatformStage2Pei",
		efi.GUID{0xa2, 0x7a, 0x83, 0x87, 0xb7, 0xee, 0x4e, 0x43, 0x9e, 0xac, 0x9d, 0x49, 0x63, 0x9e, 0x72, 0xa2}: "OtaShellCommands",
		efi.GUID{0xa2, 0x81, 0x7d, 0x69, 0x18, 0xcf, 0xc0, 0x4d, 0x9e, 0x0d, 0x06, 0x11, 0x3b, 0x61, 0x8a, 0x3f}: "EfiExtendedSalMpServicesProtocolGuid",
		efi.GUID{0xa2, 0x8a, 0x74, 0x72, 0x49, 0xb1, 0x14, 0x4d, 0x8f, 0xf1, 0x10, 0xf5, 0x83, 0x6c, 0x89, 0x33}: "AmdSmmDriver",
		efi.GUID{0xa2, 0x9a, 0x79, 0x11, 0x5d, 0x1c, 0x5b, 0x4e, 0x8a, 0x5d, 0x32, 0xd2, 0x0c, 0x39, 0xb9, 0xd3}: "AfuCapsuleOnDiskPostFlag",
		efi.GUID{0xa2, 0xa0, 0xcd, 0xa8, 0x37, 0x4f, 0x1b, 0x4a, 0x8e, 0x10, 0x8e, 0xf3, 0xcc, 0x3b, 0xf3, 0xa8}: "EdkiiNonDiscoverableUhciDeviceGuid",
		efi.GUID{0xa2, 0xa2, 0x55, 0x25, 0x1b, 0x10, 0x75, 0x47, 0xb1, 0x1e, 0x47, 0x67, 0x4f, 0x44, 0x66, 0x28}: "FjPostManagerProtocolAbstractionReference",
		efi.GUID{0xa2, 0xa2, 0x75, 0x2c, 0x1b, 0x10, 0x75, 0x47, 0xb1, 0x1e, 0x47, 0x67, 0x4e, 0xef, 0x66, 0x28}: "FjPowerButtonAbstractionReference",
		efi.GUID{0xa2, 0xae, 0x76, 0xc7, 0x27, 0xaa, 0x6e, 0x44, 0x97, 0x5b, 0xe0, 0xbe, 0xa9, 0x07, 0x8b, 0xd9}: "BiosGuardPeiApRecoveryCapsule",
		efi.GUID{0xa2, 0xb0, 0xe0, 0x62, 0x9e, 0x9d, 0x5d, 0x4d, 0x85, 0xb3, 0x4f, 0x50, 0x92, 0x70, 0x2f, 0xd1}: "HpClockBufferPei",
		efi.GUID{0xa2, 0xbd, 0x49, 0x18, 0x52, 0x69, 0x86, 0x4e, 0xa1, 0xdb, 0x55, 0x9a, 0x3c, 0x47, 0x9d, 0xf1}: "EdkiiFirmwareManagementProgressProtocol",
		efi.GUID{0xa2, 0xbe, 0x4e, 0x70, 0xe6, 0x5e, 0x98, 0x48, 0x96, 0x59, 0x01, 0x8b, 0x74, 0xb4, 0x47, 0x89}: "EfiSeCOperationProtocolGuid",
		efi.GUID{0xa2, 0xd3, 0xd1, 0x12, 0xf7, 0x99, 0x0b, 0x42, 0xbc, 0x69, 0x8b, 0xb1, 0xd4, 0x92, 0xa3, 0x55}: "Logoid",
		efi.GUID{0xa2, 0xd3, 0xd1, 0x3f, 0xf7, 0x99, 0x0b, 0x42, 0xbc, 0x69, 0x8b, 0xb1, 0xd4, 0x92, 0xa3, 0x32}: "Fid",
		efi.GUID{0xa2, 0xe6, 0xb2, 0xcb, 0xf2, 0xc6, 0x68, 0x4d, 0xa7, 0x5f, 0xae, 0x62, 0x15, 0x65, 0xc7, 0x36}: "FchSmmDiagDispatcher",
		efi.GUID{0xa2, 0xf0, 0x02, 0x54, 0x18, 0x78, 0x8b, 0x47, 0x87, 0x44, 0x04, 0x8a, 0xae, 0x94, 0xbe, 0x0d}: "DellTpm20Dxe",
		efi.GUID{0xa2, 0xfd, 0x09, 0x4d, 0x1c, 0xae, 0x47, 0x4d, 0x9c, 0xd1, 0x6b, 0x54, 0x8a, 0x15, 0xca, 0xca}: "EfiPlatformTypeWolfPassProtocol",
		efi.GUID{0xa3, 0x00, 0x47, 0xf9, 0x9f, 0xf4, 0xd2, 0x4c, 0xbf, 0x25, 0x19, 0xe2, 0x80, 0xb7, 0x2e, 0x3b}: "SystemUsbDatabaseDxe",
		efi.GUID{0xa3, 0x0b, 0xe9, 0x84, 0x79, 0xcb, 0x67, 0x42, 0xae, 0x2f, 0x43, 0x7b, 0x86, 0xda, 0xa6, 0xf4}: "DellTrustChainingPei",
		efi.GUID{0xa3, 0x1a, 0xcc, 0x9f, 0xec, 0x8b, 0x5c, 0x48, 0xff, 0xff, 0xff, 0xff, 0x20, 0x68, 0x6c, 0xdb}: "XnoteAcpiNvsDxe",
		efi.GUID{0xa3, 0x1f, 0xb8, 0x5f, 0x65, 0xbf, 0xad, 0x43, 0xa4, 0x7b, 0xdf, 0x70, 0xc3, 0x11, 0x2b, 0x5a}: "SvSmmHandler",
		efi.GUID{0xa3, 0x20, 0xdc, 0x00, 0xa2, 0x66, 0x14, 0x4d, 0xbb, 0xd7, 0x5b, 0xa9, 0x38, 0xe5, 0x56, 0xde}: "LenovoSmbios",
		efi.GUID{0xa3, 0x24, 0x68, 0x22, 0x89, 0x19, 0x6c, 0x4d, 0xbd, 0x17, 0xc8, 0x63, 0x84, 0x5f, 0x7e, 0x99}: "DellSmiCpuDecodeProtocol",
		efi.GUID{0xa3, 0x26, 0x9a, 0xd1, 0xf1, 0x17, 0xc3, 0x48, 0x8a, 0x1e, 0x11, 0xeb, 0x0a, 0x7f, 0x6e, 0x4e}: "EfiPchRcVariable",
		efi.GUID{0xa3, 0x28, 0xd0, 0xd0, 0x17, 0x8b, 0x0d, 0x49, 0x9d, 0x86, 0xc3, 0xd0, 0x0f, 0x0d, 0x76, 0x95}: "PrivateWmi",
		efi.GUID{0xa3, 0x34, 0x37, 0xe5, 0x94, 0xe5, 0x25, 0x4c, 0xb1, 0xa2, 0x08, 0x14, 0x45, 0x65, 0x0f, 0x7f}: "SmmChildDispatcher2",
		efi.GUID{0xa3, 0x3e, 0x3d, 0xb7, 0x99, 0x8c, 0x82, 0x46, 0x88, 0xd5, 0xa0, 0x8e, 0xb6, 0xbf, 0xd5, 0x61}: "IT889XSmm",
		efi.GUID{0xa3, 0x3e, 0x57, 0x43, 0x6b, 0x8f, 0xca, 0x4b, 0x97, 0x0b, 0xef, 0xfa, 0xb1, 0x5a, 0xc0, 0xe8}: "SanitizationModeSsdt",
		efi.GUID{0xa3, 0x3e, 0x8e, 0xd9, 0x39, 0x6f, 0xe4, 0x4b, 0x82, 0xce, 0x5a, 0x89, 0x0c, 0xcb, 0x2c, 0x95}: "EfiStatusCodeArchProtocol",
		efi.GUID{0xa3, 0x4d, 0x93, 0xdf, 0x31, 0xcd, 0xfe, 0x49, 0xaf, 0x50, 0xb3, 0xc8, 0x7c, 0x79, 0x32, 0x5f}: "PlatformDebugLibIoPort",
		efi.GUID{0xa3, 0x4f, 0xa1, 0xfd, 0xfc, 0xaf, 0x9a, 0x46, 0xb7, 0xbb, 0x34, 0xbc, 0xdd, 0x4a, 0xc0, 0x96}: "PlatformIde",
		efi.GUID{0xa3, 0x53, 0xa3, 0x1d, 0x00, 0x64, 0x41, 0x42, 0x9a, 0xb0, 0xe3, 0xe6, 0x5c, 0x69, 0x0e, 0xf7}: "IchSmbusArpDisabled",
		efi.GUID{0xa3, 0x58, 0x36, 0x78, 0x72, 0x41, 0x21, 0x44, 0xa2, 0x99, 0xe0, 0x09, 0x07, 0x9c, 0x0c, 0xb4}: "EfiLegacyBiosPlatformProtocolGuid",
		efi.GUID{0xa3, 0x5b, 0xeb, 0xec, 0x4d, 0xf4, 0xa3, 0x40, 0xa2, 0x1d, 0x6c, 0xbf, 0x14, 0x7f, 0xa9, 0x2f}: "N19M_GOP",
		efi.GUID{0xa3, 0x66, 0x6e, 0xcc, 0x2a, 0x47, 0x02, 0x48, 0x9b, 0x97, 0x21, 0x42, 0x0c, 0x02, 0x63, 0x91}: "AmdCpmZeroPowerOddDxe",
		efi.GUID{0xa3, 0x66, 0x77, 0x37, 0xd6, 0xa6, 0x4b, 0x44, 0xb9, 0x8f, 0x01, 0x26, 0x94, 0xc2, 0x86, 0x53}: "SerialPortTypePei",
		efi.GUID{0xa3, 0x66, 0x7c, 0x37, 0xe7, 0x8f, 0xe8, 0x4e, 0x85, 0xb8, 0xf1, 0xa2, 0x82, 0x56, 0x9e, 0x3b}: "EfiPlatformIdeInitProtocolGuid",
		efi.GUID{0xa3, 0x69, 0x32, 0x38, 0x18, 0x47, 0x5a, 0x42, 0xa1, 0x30, 0xb3, 0x5e, 0x80, 0x4b, 0x86, 0x5c}: "PlatformSioGpioInitPei",
		efi.GUID{0xa3, 0x73, 0x06, 0x3b, 0x97, 0x51, 0x4c, 0x45, 0xba, 0x76, 0xe2, 0xd0, 0xc8, 0xc4, 0x8e, 0xfd}: "GenericElog",
		efi.GUID{0xa3, 0x77, 0x2b, 0xbd, 0x0f, 0x50, 0xb4, 0x41, 0x93, 0xf9, 0x63, 0x7e, 0xc6, 0xc2, 0x3d, 0xb7}: "SmuV11PeiVMR",
		efi.GUID{0xa3, 0x82, 0x30, 0x4b, 0xc6, 0x80, 0x7e, 0x4d, 0x9c, 0xd0, 0x58, 0x39, 0x17, 0x26, 0x5d, 0xf1}: "AmiSmbiosNvramGuid",
		efi.GUID{0xa3, 0xa8, 0xe2, 0x3f, 0x00, 0xc4, 0xf8, 0x48, 0x83, 0x2f, 0x78, 0x81, 0xa3, 0x94, 0xc2, 0x50}: "IohInitDxe",
		efi.GUID{0xa3, 0xab, 0x9c, 0x5e, 0xb1, 0xf2, 0x7a, 0x49, 0xad, 0xac, 0x24, 0xf5, 0x75, 0xe9, 0xcd, 0xe9}: "TcgDxe",
		efi.GUID{0xa3, 0xac, 0x0a, 0x88, 0xdc, 0x4a, 0x04, 0x4a, 0x90, 0x79, 0xb7, 0x47, 0x34, 0x08, 0x25, 0xe5}: "EfiPropertiesTableGuid",
		efi.GUID{0xa3, 0xac, 0xbb, 0x42, 0x61, 0x71, 0x91, 0x48, 0xac, 0x10, 0xc7, 0x5e, 0x2e, 0x4d, 0xf6, 0x14}: "IffsPlatformPolicyProtocol",
		efi.GUID{0xa3, 0xae, 0x1a, 0x09, 0xa9, 0x09, 0xf6, 0x40, 0x98, 0x64, 0x01, 0x39, 0x38, 0x8a, 0x9f, 0x8c}: "XhciPei",
		efi.GUID{0xa3, 0xb2, 0x3b, 0x33, 0x20, 0x4f, 0x8b, 0x4c, 0xac, 0x38, 0x06, 0x72, 0xd7, 0x43, 0x15, 0xf8}: "AcpiPlatformPei",
		efi.GUID{0xa3, 0xb2, 0x3b, 0x33, 0x20, 0x4f, 0xcc, 0x4c, 0xac, 0x38, 0x06, 0x72, 0xd7, 0x41, 0x23, 0x45}: "FastBootPei",
		efi.GUID{0xa3, 0xb9, 0xf5, 0xce, 0x6d, 0x47, 0x7f, 0x49, 0x9f, 0xdc, 0xe9, 0x81, 0x43, 0xe0, 0x42, 0x2c}: "NVRAM",
		efi.GUID{0xa3, 0xd3, 0xea, 0x59, 0x20, 0xa9, 0x80, 0x4a, 0x92, 0x98, 0xaa, 0x7b, 0x23, 0x56, 0x47, 0xaf}: "PeiMeConfig",
		efi.GUID{0xa3, 0xd4, 0xed, 0x3f, 0x12, 0x81, 0x34, 0x45, 0x8d, 0xb2, 0xe8, 0x86, 0xeb, 0x35, 0x07, 0x5e}: "ErrorMessage",
		efi.GUID{0xa3, 0xfe, 0x33, 0x3c, 0xd2, 0xea, 0xf1, 0x47, 0x98, 0xb3, 0x4f, 0x10, 0x25, 0x49, 0x66, 0xf5}: "SystemVariableHookProtocol",
		efi.GUID{0xa4, 0x05, 0xc9, 0x80, 0x0c, 0x1e, 0xf2, 0x47, 0x84, 0x17, 0x97, 0x7f, 0xb5, 0x39, 0xc0, 0x6f}: "PowerButton",
		efi.GUID{0xa4, 0x1a, 0x45, 0x28, 0xc4, 0xb4, 0xa9, 0x4a, 0xbe, 0x3a, 0x1b, 0xbc, 0xc2, 0xe5, 0x55, 0x3a}: "GptRecovery",
		efi.GUID{0xa4, 0x1b, 0x30, 0xfd, 0x62, 0x5e, 0x79, 0x46, 0xa0, 0x6f, 0xe0, 0x9a, 0xab, 0xdd, 0x2a, 0x91}: "EfiTdtOperationProtocolGuid",
		efi.GUID{0xa4, 0x1b, 0x49, 0xf4, 0x72, 0x76, 0x6f, 0x48, 0xb4, 0xd7, 0x99, 0x89, 0x9d, 0x22, 0xda, 0x57}: "AmiPeimHob",
		efi.GUID{0xa4, 0x2d, 0xb8, 0x8f, 0xbe, 0xc3, 0xa6, 0x42, 0x8a, 0x70, 0x7b, 0x94, 0xd6, 0x09, 0x72, 0xa6}: "DellSbAccessSmm",
		efi.GUID{0xa4, 0x35, 0x68, 0x1f, 0x5d, 0x4a, 0x02, 0x4b, 0x86, 0xc5, 0xb3, 0xfc, 0x87, 0x84, 0x0e, 0x92}: "AsusOA3Bin",
		efi.GUID{0xa4, 0x3b, 0x8e, 0x40, 0x10, 0x84, 0x44, 0x4c, 0xa5, 0x1e, 0xdf, 0x8b, 0xdb, 0x36, 0x05, 0x6c}: "HpPlatformSmbiosDxe",
		efi.GUID{0xa4, 0x45, 0x7e, 0x82, 0x85, 0xc2, 0x45, 0x4e, 0x8b, 0xc7, 0xcd, 0x8e, 0x58, 0xd9, 0xee, 0x84}: "AmdPspRomArmorSmm",
		efi.GUID{0xa4, 0x51, 0x82, 0x19, 0x06, 0xde, 0x2a, 0x44, 0xaa, 0xb7, 0xb0, 0xee, 0x1e, 0x6d, 0xb8, 0xff}: "GenericVar",
		efi.GUID{0xa4, 0x54, 0x7e, 0xf7, 0xed, 0x09, 0x2f, 0x4c, 0xa9, 0x66, 0xbe, 0x1e, 0xdc, 0x72, 0x38, 0x56}: "FjTpmPhysicalPresenceQuerySkip",
		efi.GUID{0xa4, 0x5a, 0x95, 0x3c, 0xdc, 0x41, 0xd2, 0x4f, 0xb0, 0xe8, 0x27, 0xfb, 0x3c, 0x10, 0xe5, 0xff}: "MiscFunctionPortingProtocol",
		efi.GUID{0xa4, 0x5d, 0x8f, 0x44, 0xd7, 0x6d, 0xe1, 0x4f, 0x93, 0x07, 0x69, 0x22, 0x41, 0x92, 0x21, 0x5d}: "EfiSectionExtractionProtocolGuid",
		efi.GUID{0xa4, 0x5e, 0x48, 0x3c, 0x9a, 0x44, 0xce, 0x46, 0xbb, 0x08, 0x2a, 0x33, 0x6e, 0xa9, 0x6b, 0x4e}: "EfiCk505ClockPlatformInfoGuid",
		efi.GUID{0xa4, 0x5f, 0x49, 0xcd, 0x75, 0x84, 0xcf, 0x4e, 0x92, 0x03, 0x49, 0x3c, 0x9c, 0xd5, 0x40, 0x5d}: "EcDxeRestoreSmm",
		efi.GUID{0xa4, 0x6b, 0xb1, 0xcc, 0xd5, 0xb0, 0x1a, 0x40, 0xb0, 0x47, 0xe0, 0x91, 0xb1, 0xc6, 0x46, 0x7b}: "LEMDeviceInfoProtocol",
		efi.GUID{0xa4, 0x6e, 0xb3, 0x6a, 0xf2, 0xcb, 0xdc, 0x48, 0xb6, 0x10, 0x9e, 0xbf, 0x19, 0x3a, 0x5d, 0xef}: "OemDisplayModePei",
		efi.GUID{0xa4, 0x7b, 0x28, 0x16, 0x9d, 0x5b, 0x98, 0x4d, 0x91, 0x9f, 0x7b, 0x7b, 0x78, 0xcb, 0x2b, 0xe0}: "AmiLoadCsm",
		efi.GUID{0xa4, 0x8b, 0x1c, 0xd7, 0xf2, 0x4a, 0x0d, 0x4d, 0xb1, 0xba, 0xf2, 0x40, 0x9f, 0x0c, 0x20, 0xd3}: "UncoreInitPeim",
		efi.GUID{0xa4, 0x93, 0x49, 0x07, 0xa1, 0x19, 0x0d, 0x4e, 0xb8, 0x92, 0x8f, 0xbc, 0xc6, 0xd7, 0x9f, 0x35}: "SaveMemoryConfig",
		efi.GUID{0xa4, 0x99, 0x89, 0xb9, 0x6f, 0xe9, 0x5a, 0x47, 0x99, 0xfc, 0x76, 0x21, 0x26, 0xf5, 0x0f, 0x5a}: "SmbiosUpdateData",
		efi.GUID{0xa4, 0xad, 0xa0, 0x1b, 0x6b, 0x52, 0x11, 0x4f, 0xa9, 0xbd, 0x3f, 0x83, 0xee, 0x17, 0xea, 0x30}: "CopyRight",
		efi.GUID{0xa4, 0xc3, 0x05, 0x62, 0x49, 0x11, 0x1a, 0x49, 0xa6, 0xd6, 0x1e, 0x72, 0x3b, 0x87, 0x83, 0xb1}: "MainPkgList",
		efi.GUID{0xa4, 0xc4, 0xa0, 0xc7, 0x5f, 0xb0, 0xc1, 0x41, 0xb1, 0x37, 0xf1, 0x96, 0x86, 0xb3, 0x02, 0xaf}: "SetupConfigUpdateDxeSierra",
		efi.GUID{0xa4, 0xc6, 0x46, 0x7c, 0x2f, 0x36, 0x64, 0x49, 0xaf, 0x20, 0x93, 0x33, 0xe5, 0x52, 0xdc, 0xc3}: "PciHotPlug",
		efi.GUID{0xa4, 0xcd, 0xbb, 0x98, 0xb4, 0x18, 0xd3, 0x46, 0xbd, 0x1f, 0x6a, 0x3a, 0x52, 0xd4, 0x4c, 0xf8}: "SmmAccess2OnSmmAccessThunk",
		efi.GUID{0xa4, 0xda, 0xc5, 0xde, 0x81, 0x67, 0x20, 0x48, 0x9c, 0x63, 0xa7, 0xb0, 0xe4, 0xf1, 0xdb, 0x31}: "ShellLevel1HiiGuid",
		efi.GUID{0xa4, 0xda, 0xeb, 0x60, 0x65, 0x15, 0x9a, 0x4d, 0x99, 0xc8, 0x88, 0xdf, 0xa6, 0x55, 0x49, 0xa5}: "DellFlashScreenDxe",
		efi.GUID{0xa4, 0xde, 0x8d, 0x1b, 0xb2, 0xde, 0x52, 0x41, 0x91, 0xc2, 0xb7, 0x3c, 0xb1, 0x6c, 0xe4, 0x64}: "PeiAtaPolicyPpi",
		efi.GUID{0xa4, 0xe1, 0x27, 0x37, 0x8c, 0xa2, 0x92, 0x47, 0xa1, 0x02, 0xab, 0xb2, 0x75, 0x2c, 0xf0, 0x45}: "AaeonGpnvDxe",
		efi.GUID{0xa4, 0xe9, 0x0e, 0xde, 0x7a, 0x3c, 0xf2, 0x44, 0xb7, 0x8b, 0xe3, 0xcc, 0xd6, 0x9c, 0x3a, 0xf7}: "EfiExtendedSalBootServiceProtocolGuid",
		efi.GUID{0xa4, 0xf3, 0x2d, 0xf1, 0x2e, 0x6a, 0xbd, 0x44, 0xa3, 0xf9, 0x21, 0x35, 0xa0, 0x4e, 0x19, 0xe2}: "AsusEcPeiBiosReady",
		efi.GUID{0xa5, 0x0b, 0x07, 0x0c, 0x07, 0x3f, 0x9d, 0x4e, 0x88, 0x3f, 0x05, 0x7c, 0x50, 0x5f, 0xe3, 0xb8}: "BiosAuditLogWmiReporter",
		efi.GUID{0xa5, 0x0d, 0x82, 0xde, 0xcc, 0x69, 0x50, 0x4e, 0xb6, 0xc3, 0xf0, 0x7b, 0x27, 0xb1, 0x0b, 0xc2}: "CNVISetupDxe",
		efi.GUID{0xa5, 0x1a, 0x63, 0x7e, 0xce, 0xaf, 0x7b, 0x43, 0x81, 0xfa, 0xfa, 0x34, 0xea, 0x14, 0xb3, 0xc3}: "ExFatRecovery",
		efi.GUID{0xa5, 0x2b, 0x39, 0x4d, 0xaa, 0x2b, 0xf9, 0x44, 0x96, 0xc4, 0xda, 0x44, 0x3a, 0x6f, 0x34, 0x83}: "PhMicrocodeCheckPei",
		efi.GUID{0xa5, 0x33, 0x49, 0x47, 0x6e, 0xe2, 0x22, 0x47, 0x8b, 0xa8, 0x85, 0x1d, 0x01, 0x54, 0x22, 0x8f}: "FjHddErase",
		efi.GUID{0xa5, 0x34, 0xf6, 0xa8, 0xf1, 0x28, 0x56, 0x44, 0xa9, 0xd5, 0x7e, 0x24, 0xb9, 0x9b, 0xdb, 0x65}: "PcxDecoderDxe",
		efi.GUID{0xa5, 0x34, 0xf6, 0xa9, 0xf1, 0x29, 0x56, 0x44, 0xa9, 0xd5, 0x6e, 0x24, 0xb8, 0x8b, 0xdb, 0x65}: "BmpDecoderDxe",
		efi.GUID{0xa5, 0x36, 0x06, 0x18, 0x1b, 0x87, 0x6d, 0x49, 0xb8, 0xf3, 0xe8, 0x3e, 0xf1, 0x96, 0xd1, 0x00}: "menu_top_right",
		efi.GUID{0xa5, 0x41, 0x02, 0x96, 0xe6, 0x5c, 0xbf, 0x4e, 0xb9, 0xc4, 0xe3, 0x7d, 0x29, 0x4b, 0xeb, 0xa9}: "FspWrapperPeim",
		efi.GUID{0xa5, 0x48, 0x7d, 0xbf, 0xe7, 0xbd, 0xa4, 0x48, 0xbe, 0xc3, 0x2e, 0x61, 0x60, 0xa4, 0x8a, 0x0d}: "FjGabiFlashCommonGbeRegionCtrlDxe",
		efi.GUID{0xa5, 0x4e, 0x07, 0xf2, 0xc9, 0xb8, 0xbc, 0x4e, 0x88, 0x1e, 0x30, 0x10, 0x22, 0x60, 0x70, 0x3e}: "ACPI_FACS_MODIFY",
		efi.GUID{0xa5, 0x50, 0xaf, 0x5d, 0x81, 0xea, 0xe2, 0x4d, 0x8f, 0x9b, 0xca, 0xbd, 0xa9, 0xcf, 0x5c, 0x14}: "SecureBootConfigFormSetGuid",
		efi.GUID{0xa5, 0x53, 0x7e, 0xe7, 0xb8, 0xa5, 0xdc, 0x45, 0xba, 0xeb, 0x66, 0xc8, 0x6f, 0x1a, 0xc8, 0x11}: "RuntimeAcpiSmm",
		efi.GUID{0xa5, 0x53, 0xa5, 0x7a, 0x0a, 0xfe, 0x53, 0x44, 0x87, 0x0d, 0x42, 0xa6, 0x55, 0x5d, 0xc2, 0x6c}: "PchInitDxeEbg",
		efi.GUID{0xa5, 0x56, 0xb8, 0x3f, 0xb0, 0xc8, 0x60, 0x47, 0xb4, 0x9a, 0x2e, 0xdd, 0x4f, 0xa3, 0x5b, 0xfa}: "LenovoIbexPeakGlobalSmiControl",
		efi.GUID{0xa5, 0x5e, 0x9b, 0xf1, 0xdf, 0x7c, 0xb2, 0x4c, 0x9c, 0x37, 0xf1, 0xbe, 0x08, 0xac, 0x58, 0x8b}: "BroadcomGigabitEthernetDxe",
		efi.GUID{0xa5, 0x65, 0x15, 0x27, 0x05, 0x6e, 0x48, 0x49, 0xba, 0xe7, 0x39, 0xaf, 0x38, 0x9f, 0xfb, 0x97}: "DMBMPEI",
		efi.GUID{0xa5, 0x69, 0x32, 0xfc, 0x14, 0x55, 0x79, 0x42, 0x8c, 0x56, 0x5d, 0x23, 0x71, 0x8d, 0x87, 0x9f}: "AsusSampleSmmWrapperPkg",
		efi.GUID{0xa5, 0x6d, 0xbb, 0x14, 0x47, 0x0c, 0x2c, 0x4f, 0x93, 0x48, 0x8d, 0xc2, 0x72, 0x61, 0x99, 0x98}: "VmwSvgaDxe",
		efi.GUID{0xa5, 0x74, 0x63, 0xd2, 0x16, 0x77, 0x08, 0x47, 0xad, 0x9f, 0x9c, 0x4f, 0x2c, 0x02, 0x54, 0x7e}: "IchS3Save",
		efi.GUID{0xa5, 0x7b, 0x6c, 0xfa, 0x80, 0x4e, 0xfb, 0x46, 0x95, 0xb7, 0x35, 0x91, 0xca, 0x0a, 0xd4, 0x1b}: "SmmSioEmi",
		efi.GUID{0xa5, 0x81, 0xa9, 0x55, 0x71, 0xf3, 0xa3, 0x4b, 0x93, 0xa5, 0x37, 0xfa, 0x0c, 0xa9, 0x50, 0x89}: "SynQuacerGpioPei",
		efi.GUID{0xa5, 0x82, 0x2e, 0xc9, 0x25, 0xad, 0x00, 0x48, 0x94, 0x22, 0xcb, 0xe8, 0xe7, 0xa3, 0x04, 0x77}: "OemDgpuBoardIDDxe",
		efi.GUID{0xa5, 0x8b, 0x0b, 0x13, 0x3e, 0xe6, 0xa0, 0x44, 0x85, 0xdb, 0x4d, 0x4e, 0x57, 0x1c, 0x52, 0x6a}: "IioCfgUpdateDxeNeonCityEPECB",
		efi.GUID{0xa5, 0x9a, 0xc2, 0x86, 0xb0, 0x0d, 0x43, 0x43, 0xbd, 0x52, 0x7a, 0x72, 0x9f, 0x37, 0xc9, 0x6d}: "AmiDigitalSignaturePPIGuid",
		efi.GUID{0xa5, 0xa5, 0x03, 0xf1, 0x45, 0x93, 0x3f, 0x4c, 0xb4, 0x96, 0xda, 0x14, 0xf4, 0x1b, 0x62, 0x69}: "PlatformStage1",
		efi.GUID{0xa5, 0xa5, 0x64, 0x19, 0xdf, 0x91, 0x2a, 0x4b, 0xb3, 0xc4, 0x8b, 0x4b, 0xf2, 0x38, 0xd0, 0xbf}: "SystemVirtualKeyboardDxe",
		efi.GUID{0xa5, 0xab, 0x66, 0x7e, 0x80, 0x57, 0xcb, 0x4a, 0xa5, 0x0f, 0x81, 0x98, 0x98, 0x9c, 0x69, 0xc3}: "FjGabiSettingsDxe",
		efi.GUID{0xa5, 0xb4, 0xec, 0x0e, 0x9f, 0x7b, 0x07, 0x47, 0x81, 0xd7, 0x9c, 0x04, 0x5e, 0x98, 0xca, 0x95}: "AmiPlatformInfoUncompressedFfsSection",
		efi.GUID{0xa5, 0xb8, 0x8a, 0x28, 0xcf, 0xf2, 0xce, 0x4f, 0x9c, 0x80, 0x10, 0xa4, 0x36, 0xc7, 0x72, 0x76}: "ChineseDxe",
		efi.GUID{0xa5, 0xba, 0x93, 0x06, 0xd0, 0x35, 0x60, 0x43, 0x83, 0xf6, 0x1d, 0xf2, 0x6d, 0x3c, 0x53, 0xce}: "SiCpuInitPei",
		efi.GUID{0xa5, 0xbc, 0x52, 0x31, 0xde, 0xea, 0x3d, 0x43, 0x86, 0x2e, 0xc0, 0x1c, 0xdc, 0x29, 0x1f, 0x44}: "EfiRngProtocolGuid",
		efi.GUID{0xa5, 0xc4, 0x32, 0xd4, 0x73, 0xd4, 0x67, 0x40, 0x9c, 0xf7, 0x02, 0xce, 0x92, 0xa3, 0xcb, 0xfd}: "FchProm21Dxe",
		efi.GUID{0xa5, 0xc7, 0x5f, 0xeb, 0x47, 0x37, 0x25, 0x4a, 0x90, 0xdb, 0x63, 0x12, 0x97, 0xa0, 0xa0, 0xaf}: "BoardInfoPeim",
		efi.GUID{0xa5, 0xd6, 0x78, 0xab, 0x2a, 0x7e, 0xaa, 0x47, 0x9f, 0x32, 0x78, 0x07, 0x93, 0xc0, 0xda, 0xdb}: "RfInventory",
		efi.GUID{0xa5, 0xda, 0xa9, 0xfb, 0x58, 0xee, 0x01, 0x4e, 0x9e, 0x94, 0x5b, 0x0e, 0xb6, 0x3f, 0x85, 0x1b}: "SpiProtectionDxe",
		efi.GUID{0xa5, 0xe0, 0x72, 0x08, 0x38, 0x6d, 0x67, 0x45, 0x96, 0x4c, 0x7a, 0x3b, 0x48, 0x05, 0x3a, 0x4f}: "FdmInitDxe",
		efi.GUID{0xa5, 0xe2, 0x1c, 0x38, 0x03, 0xc6, 0xd2, 0x48, 0x95, 0x15, 0x9b, 0x41, 0x41, 0xf4, 0xfd, 0xe7}: "AbtDebugDriver",
		efi.GUID{0xa5, 0xe4, 0x6f, 0x1d, 0x70, 0x8e, 0x10, 0x4d, 0x84, 0xcd, 0xb1, 0xd3, 0x32, 0x14, 0xf9, 0xb5}: "HpPopupsSupport",
		efi.GUID{0xa6, 0x04, 0x1c, 0x84, 0xb5, 0xa8, 0xd8, 0x49, 0xb6, 0x5d, 0x86, 0xcd, 0xb3, 0x6d, 0x44, 0x16}: "SmuV11Pei",
		efi.GUID{0xa6, 0x07, 0x9b, 0x83, 0x4d, 0x05, 0x1c, 0x49, 0x9b, 0x15, 0x3a, 0x39, 0x06, 0x44, 0x99, 0x90}: "ThunderboltSmm",
		efi.GUID{0xa6, 0x0a, 0x4f, 0xed, 0x2b, 0xb0, 0x39, 0x45, 0xbf, 0x51, 0xc9, 0xe1, 0x14, 0xe0, 0xfe, 0x7f}: "DeviceFwServicePei",
		efi.GUID{0xa6, 0x0b, 0x64, 0x39, 0xb1, 0x7a, 0x97, 0x4d, 0x9f, 0xe2, 0x1a, 0xb6, 0x09, 0xc1, 0x70, 0xff}: "FjFlexIoPei",
		efi.GUID{0xa6, 0x0b, 0x7e, 0x63, 0xbb, 0xc5, 0xb7, 0x41, 0xa2, 0x3b, 0x3a, 0x65, 0xcf, 0xc3, 0xe9, 0xdb}: "BatteryState5",
		efi.GUID{0xa6, 0x12, 0xb4, 0xdd, 0xf3, 0xe3, 0x9e, 0x4e, 0x90, 0xa3, 0x2a, 0x99, 0x12, 0x70, 0x21, 0x9c}: "iFfsDxePolicyInit",
		efi.GUID{0xa6, 0x13, 0x34, 0x56, 0xd1, 0x9d, 0x7f, 0x4b, 0x9e, 0x7c, 0x55, 0x36, 0xe9, 0x2a, 0xa5, 0x5a}: "UefiDriverAsix",
		efi.GUID{0xa6, 0x19, 0xbc, 0xa3, 0x72, 0x35, 0xf4, 0x4a, 0xbc, 0xe4, 0xcd, 0x43, 0xa8, 0xd1, 0xf6, 0xaf}: "ASUSITEBS",
		efi.GUID{0xa6, 0x1d, 0x6f, 0x7b, 0x4f, 0xea, 0x38, 0x49, 0xa7, 0x9f, 0x0c, 0x58, 0xe1, 0x44, 0x2a, 0xa1}: "LenovoPopManagerDxe",
		efi.GUID{0xa6, 0x33, 0x65, 0x50, 0x26, 0xe6, 0x00, 0x45, 0xb1, 0x4f, 0x17, 0x93, 0x9c, 0x0e, 0x5b, 0x60}: "AcpiSupportDxe",
		efi.GUID{0xa6, 0x39, 0xd0, 0xea, 0x90, 0x73, 0x1d, 0x41, 0xa9, 0xde, 0xe5, 0x29, 0x4b, 0x25, 0xb8, 0x97}: "ASUSEZFlash",
		efi.GUID{0xa6, 0x3d, 0xe8, 0x8a, 0x1f, 0x88, 0xa6, 0x4b, 0x99, 0x7d, 0x7b, 0xf1, 0x6e, 0xd5, 0x53, 0xb4}: "OemSmi",
		efi.GUID{0xa6, 0x3f, 0xb7, 0xb2, 0x24, 0x72, 0xd1, 0x49, 0x82, 0xb5, 0x1d, 0xbb, 0x11, 0x5f, 0x1c, 0x50}: "OdmAudioLib",
		efi.GUID{0xa6, 0x46, 0x0f, 0xfb, 0x73, 0x40, 0x3d, 0x41, 0x99, 0x1a, 0x81, 0x2a, 0xbe, 0xbc, 0x31, 0x38}: "PlatformStatusCodeHandlerSmm",
		efi.GUID{0xa6, 0x47, 0xe1, 0x31, 0x9a, 0xd3, 0x47, 0x41, 0x9d, 0xa3, 0xbe, 0xfd, 0x4d, 0x52, 0x32, 0x43}: "SystemCdExpressPei",
		efi.GUID{0xa6, 0x60, 0x7d, 0xea, 0x50, 0x10, 0xe4, 0x45, 0xbe, 0xdf, 0xbf, 0x17, 0x72, 0x90, 0xd4, 0xb2}: "EfiEmmcBootPartitionProtocolGuid",
		efi.GUID{0xa6, 0x77, 0x58, 0x75, 0x10, 0x4f, 0x5c, 0x4a, 0x9b, 0x2e, 0x85, 0x21, 0x23, 0xb9, 0x68, 0x2c}: "FlashSmiDxe",
		efi.GUID{0xa6, 0x8e, 0x6d, 0xf4, 0x67, 0x4a, 0x72, 0x48, 0xb0, 0xd1, 0xd4, 0xfd, 0xea, 0x0b, 0x69, 0x2f}: "LenovoSvpManagerSmm",
		efi.GUID{0xa6, 0x8e, 0xd7, 0x72, 0xee, 0x4d, 0xe3, 0x11, 0x81, 0x00, 0xf3, 0x84, 0x2a, 0x48, 0xd0, 0xa0}: "Isp1761PeriphDxe",
		efi.GUID{0xa6, 0x8e, 0xf6, 0xa2, 0xd6, 0x61, 0x84, 0x4b, 0xa9, 0xc3, 0x49, 0x7d, 0x8a, 0x5e, 0x38, 0x04}: "RtcWakeUp",
		efi.GUID{0xa6, 0x8f, 0x48, 0x15, 0x91, 0x23, 0x9b, 0x4c, 0x6f, 0xb7, 0x6f, 0xe0, 0xe0, 0xf4, 0x10, 0xbc}: "DellPeiPolicyInit",
		efi.GUID{0xa6, 0x90, 0x08, 0x75, 0xcf, 0x7a, 0x4f, 0x4f, 0x81, 0xbd, 0xb4, 0x00, 0xc2, 0xbe, 0xa9, 0x5a}: "AcpiModeEnable",
		efi.GUID{0xa6, 0x9b, 0x93, 0x9c, 0xcc, 0x1f, 0xf6, 0x46, 0xb4, 0xe1, 0x10, 0x2d, 0xbe, 0x18, 0x65, 0x67}: "EfiAcpiDisDispatchProtocolGuid",
		efi.GUID{0xa6, 0x9f, 0x18, 0x75, 0xcf, 0x7b, 0x4f, 0x4f, 0x81, 0xbd, 0xa4, 0xf1, 0xc3, 0xbe, 0xa9, 0x5a}: "CptSwSmi",
		efi.GUID{0xa6, 0xa7, 0xaa, 0xfe, 0x95, 0xcb, 0x70, 0x46, 0xb4, 0x99, 0x87, 0x7f, 0xa6, 0xca, 0x6b, 0xae}: "MeudFile",
		efi.GUID{0xa6, 0xab, 0xdb, 0x42, 0x6a, 0x84, 0xe6, 0x44, 0xbd, 0x76, 0x40, 0x28, 0x04, 0x84, 0xd9, 0x07}: "H19MpmShellInterface",
		efi.GUID{0xa6, 0xb1, 0xea, 0x49, 0x2f, 0xaf, 0x64, 0x40, 0x9b, 0x29, 0xd9, 0x65, 0x5b, 0x3b, 0x8d, 0xed}: "DellAmtConfigPei",
		efi.GUID{0xa6, 0xb3, 0x2b, 0xe1, 0xa1, 0x1e, 0x4f, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe2, 0x90, 0xc5}: "RecoveryPartitionDxe",
		efi.GUID{0xa6, 0xd8, 0x52, 0xe0, 0x4a, 0x22, 0x32, 0x4c, 0x8d, 0x37, 0x2e, 0x0a, 0xe1, 0x62, 0x36, 0x4d}: "PchSmbusDxe",
		efi.GUID{0xa6, 0xd9, 0xd8, 0xa7, 0xb0, 0x6a, 0xeb, 0x4a, 0xad, 0x9d, 0x16, 0x3e, 0x59, 0xa7, 0xa3, 0x80}: "SystemDiagnosticSplashScreenApp",
		efi.GUID{0xa6, 0xe4, 0xe1, 0x2b, 0x05, 0x65, 0xb3, 0x43, 0x9f, 0xfc, 0xa3, 0xc8, 0x33, 0x0e, 0x04, 0x32}: "TcgPei",
		efi.GUID{0xa6, 0xe4, 0xfd, 0xf7, 0x4c, 0x29, 0x3c, 0x49, 0xb5, 0x0f, 0x97, 0x34, 0x55, 0x3b, 0xb7, 0x57}: "CapsuleX64",
		efi.GUID{0xa6, 0xef, 0xe1, 0xe7, 0x07, 0x76, 0x78, 0x4a, 0xa7, 0xdd, 0x43, 0xe4, 0xbd, 0x72, 0xc0, 0x99}: "AppPkgTokenSpaceGuid",
		efi.GUID{0xa6, 0xf4, 0xa6, 0xd8, 0x97, 0x0e, 0x8b, 0x4a, 0xa4, 0x75, 0x39, 0xf1, 0xb2, 0x8b, 0x5a, 0xec}: "Fv2OnFvThunk",
		efi.GUID{0xa6, 0xfb, 0xd2, 0xd6, 0x60, 0xef, 0x38, 0x4c, 0xa8, 0x3e, 0x67, 0x69, 0x81, 0x4d, 0x23, 0xb0}: "CryptoPei",
		efi.GUID{0xa6, 0xfe, 0x25, 0x06, 0x5f, 0xf9, 0x8d, 0x49, 0x87, 0x89, 0x3e, 0xa0, 0x53, 0xa0, 0x6d, 0x7e}: "Cf9Reset",
		efi.GUID{0xa7, 0x0b, 0xb0, 0x88, 0x61, 0x75, 0xee, 0x43, 0x97, 0x33, 0xe4, 0x1b, 0xda, 0x84, 0x98, 0xe0}: "AmdCpmEcInitPeim",
		efi.GUID{0xa7, 0x13, 0x00, 0x7f, 0x79, 0xdc, 0x22, 0x4b, 0x80, 0x99, 0x11, 0xf7, 0x5f, 0xdc, 0x82, 0x9d}: "EfiCacheSubClassGuid",
		efi.GUID{0xa7, 0x19, 0x71, 0xc0, 0xaa, 0x98, 0xce, 0x4d, 0xb3, 0x47, 0x96, 0x08, 0x63, 0x4a, 0xa0, 0x6a}: "DiagnosticsConnection",
		efi.GUID{0xa7, 0x23, 0xcc, 0xf8, 0x10, 0x0f, 0xaf, 0x45, 0xaa, 0x1c, 0x0d, 0x9d, 0xd8, 0xbb, 0x3c, 0x20}: "DellHttpsBootManager",
		efi.GUID{0xa7, 0x38, 0x94, 0x59, 0x92, 0x42, 0x77, 0x49, 0x8c, 0x06, 0xff, 0xc1, 0x6c, 0x44, 0x5e, 0x83}: "AmdApcbZpSmm",
		efi.GUID{0xa7, 0x3a, 0x7c, 0x9c, 0x32, 0x53, 0x17, 0x49, 0x82, 0xb9, 0x56, 0xa5, 0xf3, 0xe6, 0x2a, 0x07}: "FspReservedMemoryResourceHobGfxGuid",
		efi.GUID{0xa7, 0x4e, 0x25, 0x85, 0x59, 0x47, 0xc4, 0x4f, 0x82, 0xd4, 0x5e, 0xed, 0x5f, 0xb0, 0xa4, 0xa0}: "DefaultPKFile",
		efi.GUID{0xa7, 0x51, 0xae, 0xb0, 0x11, 0xe7, 0x1e, 0x4f, 0xba, 0x16, 0x10, 0x12, 0x26, 0x1a, 0x6d, 0x71}: "WifiFmacDriver",
		efi.GUID{0xa7, 0x5c, 0x6f, 0x0b, 0x53, 0x4f, 0x5a, 0x44, 0xb7, 0x6e, 0x2e, 0x36, 0x5b, 0x80, 0x63, 0x66}: "ArmVirtTokenSpaceGuid",
		efi.GUID{0xa7, 0x61, 0x3f, 0x76, 0xfd, 0xbc, 0x57, 0x46, 0x87, 0xb2, 0x8d, 0xbc, 0xad, 0x64, 0x25, 0xf9}: "DellOpalHddSecurityDxe",
		efi.GUID{0xa7, 0x69, 0xfb, 0x84, 0x58, 0xc8, 0x3a, 0x48, 0xbb, 0x90, 0xd3, 0xbc, 0xaf, 0xbc, 0xc6, 0xed}: "DatabaseManagerDxe",
		efi.GUID{0xa7, 0x6a, 0x9f, 0x12, 0x69, 0xab, 0xb8, 0x4c, 0xae, 0xd1, 0x40, 0x98, 0x50, 0x01, 0x11, 0x5e}: "SerialMuxControl",
		efi.GUID{0xa7, 0x72, 0xb1, 0x2e, 0xe5, 0x68, 0x80, 0x4a, 0x9f, 0xf9, 0x19, 0xdf, 0x37, 0xa6, 0x93, 0xca}: "DellBfaSmmProtocol",
		efi.GUID{0xa7, 0x72, 0xbf, 0x17, 0x65, 0xba, 0x37, 0x48, 0x86, 0x6d, 0x97, 0x9b, 0x2f, 0x2c, 0x07, 0x5e}: "RasClvPatrolScrubProtocol",
		efi.GUID{0xa7, 0x78, 0xa2, 0x8e, 0xb8, 0x90, 0x5f, 0x45, 0xbe, 0x18, 0x23, 0x17, 0x2e, 0xac, 0x60, 0x68}: "HpDigitalSignatureVerificationNotInSmm",
		efi.GUID{0xa7, 0x78, 0xa2, 0x8e, 0xb8, 0x90, 0x5f, 0x45, 0xbe, 0x18, 0x23, 0x17, 0x2e, 0xac, 0x60, 0x69}: "HpDigitalSignatureVerificationInSmm",
		efi.GUID{0xa7, 0x85, 0x42, 0xfc, 0xb5, 0xeb, 0xd2, 0x45, 0x85, 0x41, 0xeb, 0xa3, 0x31, 0x8f, 0xc2, 0xc2}: "UsbOcUpdateDxeLightningRidgeEXECB1",
		efi.GUID{0xa7, 0x90, 0x7d, 0x6e, 0x36, 0x93, 0x1c, 0x46, 0x8a, 0xe9, 0x85, 0x9c, 0x51, 0xa9, 0xa7, 0x16}: "ReadyToBootNotifyDxe",
		efi.GUID{0xa7, 0x92, 0x3f, 0xcd, 0xe4, 0x9a, 0xf9, 0x42, 0xb2, 0xcc, 0xb4, 0x7a, 0x86, 0x15, 0xb8, 0x5b}: "PcieInitPei",
		efi.GUID{0xa7, 0x9b, 0x5c, 0x23, 0xa4, 0x2d, 0xf4, 0x4d, 0x92, 0xdd, 0x55, 0x55, 0xfc, 0x7d, 0xb2, 0xac}: "OemACRecoveryPei",
		efi.GUID{0xa7, 0x9f, 0xf2, 0x2f, 0x80, 0x5e, 0xd9, 0x4e, 0xb3, 0x80, 0x01, 0x7d, 0x3c, 0x55, 0x4f, 0xf4}: "EfiSmmRscHandlerProtocolGuid",
		efi.GUID{0xa7, 0xa5, 0x35, 0x4d, 0x2e, 0x62, 0x55, 0x49, 0xa5, 0xd2, 0xcd, 0xa8, 0x12, 0x94, 0x0d, 0x74}: "FwBlockService",
		efi.GUID{0xa7, 0xb4, 0xb4, 0x9f, 0xc0, 0x42, 0xcd, 0x4b, 0x85, 0x40, 0x9b, 0xcc, 0x67, 0x11, 0xf8, 0x3e}: "SystemUsbMassStorageDxe",
		efi.GUID{0xa7, 0xb7, 0x7d, 0x2e, 0x8e, 0x60, 0x41, 0x40, 0xb4, 0x5f, 0x00, 0x35, 0x9e, 0x07, 0x66, 0xc6}: "FvbServicesSmm",
		efi.GUID{0xa7, 0xb9, 0xb3, 0xfd, 0x82, 0x1e, 0x77, 0x4c, 0x9c, 0x6c, 0x43, 0x05, 0xc8, 0x51, 0xf2, 0x53}: "ProgClkGenPeim",
		efi.GUID{0xa7, 0xc2, 0x27, 0x8f, 0xfb, 0xa8, 0x45, 0x46, 0xac, 0xc7, 0xda, 0xf4, 0xc8, 0x0c, 0x4f, 0x95}: "DellODMDxe",
		efi.GUID{0xa7, 0xc5, 0xad, 0xf0, 0x6a, 0xf8, 0xa5, 0x45, 0x9d, 0x16, 0x37, 0x32, 0x3f, 0xcd, 0x77, 0xee}: "SmcPostMsgHotKey_SMM",
		efi.GUID{0xa7, 0xc8, 0x97, 0x71, 0x59, 0x65, 0x93, 0x4c, 0x93, 0xd5, 0x8a, 0x84, 0xf9, 0x88, 0x79, 0x8b}: "PlatformBootManagerProtocol",
		efi.GUID{0xa7, 0xcc, 0x6b, 0xb2, 0x44, 0xd0, 0xe1, 0x49, 0xb1, 0xb5, 0xe2, 0xa9, 0x6b, 0xb7, 0xc2, 0x25}: "MitigationDxe",
		efi.GUID{0xa7, 0xd0, 0xaa, 0x8f, 0xb4, 0x02, 0x2f, 0x43, 0x8f, 0x5c, 0xb8, 0x80, 0x96, 0x5d, 0x8b, 0x41}: "SmmCommunicationBufferDxe",
		efi.GUID{0xa7, 0xd7, 0x9b, 0xaa, 0xfb, 0xca, 0x99, 0x44, 0xa4, 0xa9, 0x0b, 0x34, 0x6b, 0x40, 0xa6, 0x22}: "SmmRegisterInfo",
		efi.GUID{0xa7, 0xdb, 0xb3, 0x52, 0x65, 0x95, 0xe8, 0x48, 0x8e, 0x13, 0xec, 0x71, 0x96, 0x72, 0x1b, 0x3c}: "PlatformInfoPei",
		efi.GUID{0xa7, 0xdf, 0x24, 0xd1, 0x84, 0xd7, 0x4e, 0xc6, 0x81, 0x06, 0x29, 0x41, 0x1a, 0x7f, 0x59, 0xdb}: "MnpDxe",
		efi.GUID{0xa7, 0xe2, 0x1b, 0x33, 0x90, 0xbd, 0x81, 0x4a, 0xa1, 0x28, 0x36, 0xb0, 0xb2, 0x05, 0x79, 0x97}: "EfiPlatformTypeBuchananPassProtocol",
		efi.GUID{0xa7, 0xe6, 0xab, 0xfc, 0x53, 0x79, 0x84, 0x4a, 0xb7, 0xec, 0xd2, 0x9e, 0x89, 0xb6, 0x2e, 0x87}: "EmbeddedMonotonicCounter",
		efi.GUID{0xa7, 0xe8, 0x92, 0xb0, 0x70, 0x5b, 0xbc, 0x4a, 0x94, 0x4f, 0x6a, 0x63, 0x19, 0x5b, 0x0d, 0xa7}: "HpRpsuDetectSmm",
		efi.GUID{0xa7, 0xf3, 0x9c, 0x39, 0xc7, 0x82, 0x9b, 0x4d, 0x91, 0x23, 0xdb, 0x11, 0x84, 0x29, 0x86, 0xd3}: "DpcDxe",
		efi.GUID{0xa7, 0xf8, 0x8a, 0x75, 0x04, 0x2a, 0x37, 0x49, 0x99, 0xe0, 0x83, 0x7d, 0x1f, 0x97, 0xc7, 0x6f}: "LenovoSystemAcpiNumaDxe",
		efi.GUID{0xa8, 0x00, 0xb4, 0x43, 0x80, 0x99, 0x71, 0x48, 0x8d, 0x8e, 0x9d, 0xa7, 0xcb, 0xd2, 0x46, 0xde}: "OemAmt",
		efi.GUID{0xa8, 0x03, 0xda, 0x18, 0xe4, 0xfa, 0x0a, 0x41, 0xa8, 0xc2, 0x34, 0xc9, 0x19, 0x13, 0xf5, 0x15}: "AmdPspIntrusionDetectionSmm",
		efi.GUID{0xa8, 0x06, 0x2c, 0x6f, 0xb4, 0xd4, 0x93, 0x4a, 0x9f, 0x78, 0x2b, 0x48, 0x0b, 0xe8, 0x0e, 0x0f}: "EfiSmiFlashProtocolGuid",
		efi.GUID{0xa8, 0x11, 0x31, 0xc1, 0xc9, 0x6b, 0xe5, 0x11, 0x87, 0x97, 0x00, 0x1a, 0xca, 0x00, 0xbf, 0xc4}: "BlueFieldDxe",
		efi.GUID{0xa8, 0x15, 0x6c, 0xe8, 0x17, 0x4d, 0x6e, 0x4e, 0xac, 0x7c, 0x90, 0x90, 0x5b, 0xa5, 0xeb, 0xe3}: "TransparentUnlockDXE",
		efi.GUID{0xa8, 0x1c, 0x4e, 0x86, 0xeb, 0x85, 0x63, 0x4d, 0x9d, 0xcc, 0x6e, 0x0f, 0xc9, 0x0f, 0xfd, 0x55}: "SioBusDxe",
		efi.GUID{0xa8, 0x2d, 0x73, 0xa7, 0xaa, 0x11, 0x66, 0x43, 0x97, 0x15, 0xcd, 0x92, 0xcf, 0xb7, 0xd3, 0x62}: "SataController",
		efi.GUID{0xa8, 0x30, 0x6b, 0xb2, 0x72, 0x21, 0x46, 0x4a, 0x9b, 0x4f, 0x4d, 0x5b, 0x08, 0xdd, 0x6e, 0x40}: "T23OwnerStringService",
		efi.GUID{0xa8, 0x35, 0x1f, 0xe2, 0xff, 0x42, 0x50, 0x40, 0x82, 0xd6, 0x93, 0xf7, 0xcd, 0xfa, 0x70, 0x73}: "PiSmmCommunicationSmm",
		efi.GUID{0xa8, 0x35, 0xf4, 0x57, 0x37, 0x1c, 0x34, 0x48, 0xad, 0x61, 0xb0, 0x3d, 0x94, 0xdd, 0xce, 0xf3}: "DellPasswordMgrDxe",
		efi.GUID{0xa8, 0x38, 0xff, 0x14, 0xba, 0xac, 0x28, 0x42, 0xa7, 0xd7, 0xa7, 0x32, 0x60, 0xc7, 0x55, 0x9b}: "PiSmmStatusCodeOnFrameworkSmmStatusCodeThunk",
		efi.GUID{0xa8, 0x3e, 0x61, 0x4e, 0x1c, 0xc0, 0xa7, 0x4b, 0xba, 0x09, 0x38, 0xbd, 0x86, 0x81, 0x5f, 0x85}: "FjPasswordServiceSmm",
		efi.GUID{0xa8, 0x5d, 0x73, 0xfa, 0xbd, 0xec, 0x48, 0x44, 0x81, 0x54, 0x91, 0xe7, 0x71, 0x20, 0xd4, 0x27}: "FjPowerButtonState",
		efi.GUID{0xa8, 0x5d, 0xc9, 0x2f, 0xed, 0x6d, 0x19, 0x4e, 0xba, 0x0f, 0xa2, 0x53, 0x03, 0x2e, 0x14, 0x4a}: "DellHotSosSmm",
		efi.GUID{0xa8, 0x67, 0xce, 0x91, 0xaa, 0xe0, 0x12, 0x40, 0xb9, 0x9f, 0xb6, 0xfc, 0xf3, 0x04, 0x8e, 0xaa}: "ArmScmiClockProtocol",
		efi.GUID{0xa8, 0x6b, 0x21, 0xbe, 0xc4, 0x38, 0x35, 0x45, 0xa6, 0xca, 0x5d, 0xca, 0x5b, 0x43, 0xad, 0xdf}: "SmiVariable",
		efi.GUID{0xa8, 0x73, 0x2a, 0xd8, 0xb5, 0x7c, 0xc1, 0x4b, 0x8f, 0xa5, 0x60, 0xf0, 0xee, 0x24, 0x70, 0xa7}: "BiosUpdatePlatformPolicySmm",
		efi.GUID{0xa8, 0x7d, 0xe0, 0x72, 0xa9, 0x63, 0xd4, 0x42, 0x83, 0xd5, 0x0b, 0xb5, 0x18, 0x38, 0x44, 0x75}: "EfiLegacyBootMarker",
		efi.GUID{0xa8, 0x7d, 0xf2, 0x45, 0x9d, 0xdb, 0xe1, 0x48, 0xbf, 0x5e, 0x45, 0x8d, 0xee, 0xd9, 0xde, 0x84}: "PchFlashControllerSmmProtocol",
		efi.GUID{0xa8, 0x92, 0x5b, 0xf1, 0x4c, 0x6b, 0xa3, 0x4e, 0xa3, 0x80, 0x2f, 0x35, 0x2a, 0xd1, 0x54, 0x17}: "RealTekLanDriver",
		efi.GUID{0xa8, 0x95, 0x2f, 0x74, 0x4a, 0x71, 0x43, 0x5c, 0x88, 0xba, 0xb3, 0x36, 0x1f, 0x12, 0xee, 0xe6}: "BootRomFlash",
		efi.GUID{0xa8, 0x96, 0x0c, 0xd2, 0xcf, 0xb9, 0x15, 0x4c, 0x9f, 0xbb, 0x1c, 0x05, 0x55, 0x17, 0xf4, 0x49}: "CxlCedt",
		efi.GUID{0xa8, 0x96, 0x5d, 0x25, 0x79, 0x15, 0xdf, 0x4a, 0x85, 0x75, 0x56, 0xd4, 0xb0, 0x46, 0x71, 0x17}: "DellTcg2EarlyPlatformPei",
		efi.GUID{0xa8, 0xa5, 0x6a, 0x59, 0x89, 0x12, 0x30, 0x4e, 0xb3, 0x11, 0xf7, 0x4e, 0x64, 0xf3, 0x09, 0x91}: "SmmSecureBios",
		efi.GUID{0xa8, 0xac, 0xa1, 0xa6, 0x99, 0x74, 0x70, 0x43, 0xa3, 0x31, 0x5e, 0x8f, 0x92, 0xec, 0x30, 0xd5}: "OemPeiSetAcLossControl",
		efi.GUID{0xa8, 0xaf, 0xf1, 0xaf, 0xf5, 0x07, 0xfa, 0x46, 0xa7, 0xab, 0x60, 0xf4, 0xc9, 0x93, 0xb9, 0xbf}: "MpmKvm",
		efi.GUID{0xa8, 0xb5, 0x77, 0x11, 0xa6, 0x7b, 0x20, 0x4c, 0xa3, 0xb4, 0x7d, 0x65, 0x19, 0xd8, 0x67, 0x0a}: "ECHeartbeatPei",
		efi.GUID{0xa8, 0xc3, 0x00, 0x86, 0x13, 0x42, 0x6e, 0x45, 0x83, 0x2a, 0xd5, 0x1e, 0x8e, 0x5f, 0x4a, 0xb1}: "AppleHeciDxe",
		efi.GUID{0xa8, 0xc3, 0x46, 0xe6, 0xe2, 0xc7, 0xc2, 0x4d, 0xa7, 0xf2, 0xe3, 0x2a, 0x27, 0x0b, 0x0b, 0x26}: "LogoThunderbolt",
		efi.GUID{0xa8, 0xd1, 0x14, 0xed, 0xcb, 0x9d, 0x0f, 0x4c, 0x91, 0x7c, 0xdb, 0x0b, 0xfb, 0x56, 0xbd, 0x24}: "KEMrCPLDDxe",
		efi.GUID{0xa8, 0xeb, 0x33, 0x57, 0x2d, 0x49, 0xfa, 0x46, 0xaa, 0x6a, 0x37, 0x97, 0x79, 0xe1, 0x0b, 0x77}: "EfiMpstSupportProtocol",
		efi.GUID{0xa8, 0xf0, 0x9c, 0xac, 0x51, 0xe5, 0xe2, 0x4b, 0xad, 0x0a, 0xe1, 0xb5, 0x64, 0xee, 0xa2, 0x73}: "AmiCpuInfo_2Protocol",
		efi.GUID{0xa8, 0xf8, 0x31, 0xcd, 0xa6, 0x28, 0x49, 0x4e, 0x8b, 0x3e, 0x41, 0x42, 0xbd, 0x00, 0x6c, 0x41}: "MeUlvCheckDxe",
		efi.GUID{0xa8, 0xfc, 0xfa, 0x32, 0x74, 0x03, 0xbd, 0x49, 0xa0, 0x90, 0xb4, 0xb4, 0x60, 0x3a, 0x50, 0xd6}: "PpmInitializePei",
		efi.GUID{0xa8, 0xfd, 0xa1, 0xb7, 0x3e, 0xcb, 0x69, 0x4e, 0x87, 0xaf, 0xb6, 0x7f, 0xec, 0x56, 0x35, 0x48}: "GnbIoApicUpdate",
		efi.GUID{0xa9, 0x01, 0xd1, 0x15, 0xc5, 0x60, 0x77, 0x45, 0x96, 0x72, 0xde, 0x91, 0x84, 0x2d, 0x01, 0xd5}: "FjRTS52500S",
		efi.GUID{0xa9, 0x0d, 0xed, 0x17, 0xc5, 0xea, 0x13, 0x46, 0xbd, 0xe7, 0xc3, 0xa5, 0x06, 0x91, 0x76, 0x76}: "LoadPartialDefault",
		efi.GUID{0xa9, 0x0e, 0x30, 0xc8, 0x9e, 0x86, 0xdf, 0x42, 0xae, 0xf2, 0x5d, 0x93, 0x94, 0x52, 0xa3, 0x53}: "SetupDefaults",
		efi.GUID{0xa9, 0x17, 0xe4, 0x35, 0x0b, 0xee, 0xdc, 0x48, 0xa9, 0x48, 0x75, 0xf8, 0xab, 0x93, 0xc9, 0x33}: "RuntimeAcpiPei",
		efi.GUID{0xa9, 0x24, 0xcf, 0x15, 0xab, 0xf9, 0xd0, 0x46, 0x8d, 0xcf, 0x83, 0x66, 0x4c, 0x63, 0x2f, 0xd8}: "MemDetect",
		efi.GUID{0xa9, 0x2a, 0x16, 0x70, 0x5e, 0x87, 0xc9, 0x4f, 0x86, 0x08, 0x27, 0xce, 0x6f, 0xa4, 0xf3, 0x3c}: "FjSecureUpdateDxe",
		efi.GUID{0xa9, 0x33, 0x8f, 0x26, 0xcd, 0xcc, 0xbe, 0x48, 0x88, 0x17, 0x86, 0x05, 0x3a, 0xc3, 0x2e, 0xd6}: "PeiSmmAccessPpiGuid",
		efi.GUID{0xa9, 0x38, 0x2b, 0x65, 0xf4, 0x77, 0x3f, 0x45, 0x89, 0xd5, 0xe7, 0xbd, 0xc3, 0x52, 0xfc, 0x53}: "PeiUsbHostControllerPpiGuid",
		efi.GUID{0xa9, 0x3a, 0x11, 0x7d, 0x80, 0x62, 0xc6, 0x48, 0xba, 0xce, 0xdf, 0xe7, 0x66, 0x8e, 0x83, 0x07}: "AmiMpTpmBin",
		efi.GUID{0xa9, 0x3a, 0x3b, 0x02, 0x8f, 0x09, 0x27, 0x40, 0xb8, 0x3f, 0xb6, 0x40, 0x7d, 0xa0, 0x65, 0x69}: "AmdPspFtpmDxe",
		efi.GUID{0xa9, 0x3a, 0xe2, 0xdb, 0x45, 0xa3, 0x97, 0x4b, 0x85, 0xb6, 0xb2, 0x26, 0xf1, 0x61, 0x73, 0x89}: "EfiTemporaryRamSupportPpiGuid",
		efi.GUID{0xa9, 0x43, 0xb8, 0xea, 0x14, 0xd4, 0xbb, 0x41, 0x87, 0xa2, 0x6c, 0x29, 0x52, 0xdf, 0xa2, 0xec}: "GpioCfgPei",
		efi.GUID{0xa9, 0x4f, 0x64, 0x8f, 0x50, 0xe8, 0xb1, 0x4d, 0x9c, 0xe2, 0x0b, 0x44, 0x69, 0x8e, 0x8d, 0xa4}: "EfiFirmwareVolumeBlock2ProtocolGuid",
		efi.GUID{0xa9, 0x4f, 0xf1, 0xa8, 0x88, 0xfc, 0xf4, 0x45, 0xa6, 0x22, 0xf0, 0x6e, 0x6c, 0x56, 0xe6, 0x32}: "FirmwareBootMediaInfoPei",
		efi.GUID{0xa9, 0x54, 0x2f, 0xfe, 0x7d, 0x01, 0xc2, 0x45, 0xa8, 0x2d, 0x98, 0x22, 0xbc, 0xf1, 0x4c, 0xa6}: "FanPolicyDxe",
		efi.GUID{0xa9, 0x56, 0xc8, 0x24, 0xe7, 0x46, 0x35, 0x46, 0x80, 0x17, 0x0f, 0xdc, 0xca, 0x1f, 0xf9, 0xc9}: "AmdFabricMdnSmm",
		efi.GUID{0xa9, 0x58, 0x9b, 0xa6, 0x05, 0x6c, 0xc1, 0x4d, 0x85, 0xbf, 0xaf, 0x80, 0xdc, 0xe6, 0xd9, 0x7d}: "EfiTraceHubTokenSpace",
		efi.GUID{0xa9, 0x5a, 0x20, 0x2a, 0xea, 0xf7, 0xbe, 0x47, 0xb3, 0xbd, 0x76, 0x31, 0xe9, 0x9b, 0x43, 0x51}: "G3WakeupPei",
		efi.GUID{0xa9, 0x5a, 0xa4, 0x7d, 0xbf, 0x6d, 0x1b, 0x4f, 0xa4, 0x3e, 0x32, 0x87, 0xcb, 0xe5, 0x13, 0x51}: "TpmPkgList",
		efi.GUID{0xa9, 0x63, 0xab, 0x28, 0xb0, 0x5f, 0x93, 0x4c, 0x9c, 0x44, 0x0d, 0xd8, 0xa1, 0xe9, 0x10, 0x1d}: "AmdNbioAlibRVDxe",
		efi.GUID{0xa9, 0x65, 0x01, 0x4b, 0xd6, 0x61, 0x23, 0x4e, 0xa0, 0xb5, 0x3e, 0xc7, 0x9c, 0x2e, 0x30, 0xd5}: "DxePchPlatformPolicyProtocolGuid",
		efi.GUID{0xa9, 0x6d, 0x62, 0xff, 0xee, 0x17, 0x49, 0x49, 0xa8, 0xb8, 0xb1, 0x0f, 0xa0, 0x04, 0x4e, 0x9f}: "EsrtFmpDxe",
		efi.GUID{0xa9, 0x72, 0x7a, 0x79, 0xe3, 0xea, 0x5e, 0x49, 0x99, 0x5d, 0xa2, 0x0d, 0x85, 0xf5, 0x09, 0xab}: "PreserveHobVariablesToNvram",
		efi.GUID{0xa9, 0x74, 0x09, 0x2c, 0xa3, 0xe7, 0x45, 0x4c, 0xb8, 0xb7, 0x3a, 0x04, 0x6e, 0x35, 0x0a, 0x50}: "EnhancedMcaErrorLog",
		efi.GUID{0xa9, 0x7f, 0x34, 0xe2, 0x73, 0xfd, 0x65, 0x41, 0xb1, 0x5c, 0xc4, 0x66, 0x5a, 0x25, 0x9e, 0x53}: "AmtGbeChecksum",
		efi.GUID{0xa9, 0x82, 0xd0, 0x7f, 0x6b, 0x3d, 0xe3, 0x44, 0x9c, 0x31, 0x74, 0xd6, 0xb8, 0x0f, 0x96, 0x5c}: "SetupConfigUpdateDxeLightningRidgeEXECB1",
		efi.GUID{0xa9, 0x8c, 0xff, 0xfa, 0x15, 0xe5, 0xed, 0x44, 0xb5, 0xf9, 0xe2, 0xf6, 0xe5, 0xd9, 0x02, 0xe3}: "ServerHotplugDxe",
		efi.GUID{0xa9, 0x8f, 0x5f, 0x86, 0x72, 0xbd, 0x38, 0x4d, 0xa1, 0xc6, 0x60, 0x41, 0xf4, 0x26, 0xe9, 0x2f}: "DellSbDxe",
		efi.GUID{0xa9, 0x90, 0xec, 0x83, 0x91, 0xd7, 0x13, 0x46, 0x9c, 0x57, 0x68, 0xc3, 0xde, 0x92, 0x3c, 0x3b}: "MeSmbiosUpdateConfig",
		efi.GUID{0xa9, 0x91, 0xa1, 0xb2, 0xac, 0x9b, 0x83, 0x4c, 0xa2, 0xf3, 0xd5, 0xf6, 0xe7, 0x1e, 0xfd, 0x03}: "ArmPlatformSysConfigLibNull",
		efi.GUID{0xa9, 0x94, 0x4e, 0x7d, 0x9a, 0x26, 0xa1, 0x47, 0x80, 0xf0, 0x2b, 0x0e, 0xb4, 0x2f, 0x7b, 0x4b}: "Int15ServiceSmm",
		efi.GUID{0xa9, 0x96, 0x5a, 0xf4, 0xdf, 0x35, 0xcb, 0x40, 0xa0, 0xda, 0xc5, 0xf5, 0x51, 0xcd, 0x6b, 0x21}: "SetupMenuSmm",
		efi.GUID{0xa9, 0x9d, 0x92, 0xbb, 0xf7, 0x68, 0x35, 0x40, 0xb2, 0x2c, 0xa3, 0xbb, 0x3f, 0x23, 0xda, 0x55}: "SataControllerDriverGuid",
		efi.GUID{0xa9, 0x9e, 0x76, 0xe5, 0x06, 0xe7, 0x4b, 0x45, 0x95, 0x7f, 0xaf, 0xc6, 0xdb, 0x4b, 0x8a, 0x0d}: "QncS3ContextInLockBoxGuid",
		efi.GUID{0xa9, 0xa1, 0xc7, 0xc4, 0x39, 0xd6, 0x2d, 0x44, 0xb3, 0x58, 0x09, 0xd0, 0x6a, 0xe1, 0x8b, 0xfc}: "DellDaAssetTag",
		efi.GUID{0xa9, 0xa8, 0xfa, 0xe9, 0xb8, 0x40, 0x6f, 0x4c, 0x8c, 0x62, 0xcb, 0xc4, 0xd5, 0x32, 0x05, 0x5c}: "PcdRecoveryRestoreData",
		efi.GUID{0xa9, 0xac, 0xae, 0x49, 0xbb, 0x69, 0xb2, 0x4e, 0xb5, 0xf9, 0x1b, 0xf9, 0xe2, 0x50, 0x87, 0x79}: "FchTacomaPei",
		efi.GUID{0xa9, 0xaf, 0xb5, 0x2b, 0x33, 0xff, 0x7b, 0x41, 0x84, 0x97, 0xcb, 0x77, 0x3c, 0x2b, 0x93, 0xbf}: "CpuPei",
		efi.GUID{0xa9, 0xbd, 0x5f, 0x35, 0x72, 0x45, 0xbc, 0x49, 0x95, 0xb9, 0x54, 0x5e, 0x71, 0xde, 0xf9, 0xf9}: "FpgaSmm",
		efi.GUID{0xa9, 0xbf, 0x00, 0x62, 0x29, 0x85, 0xf0, 0x4d, 0xad, 0x67, 0x7d, 0xa8, 0xdf, 0x6b, 0x0a, 0x4a}: "FjSystemIdentifierDxe",
		efi.GUID{0xa9, 0xcb, 0x5a, 0xd0, 0x18, 0x3e, 0x80, 0x4c, 0xaa, 0x97, 0x02, 0x3a, 0x22, 0xf8, 0xa9, 0x46}: "FjAudioSpeaker",
		efi.GUID{0xa9, 0xd0, 0xc1, 0xe1, 0xb1, 0x40, 0x32, 0x46, 0xbd, 0xcc, 0xd9, 0xd6, 0xe5, 0x29, 0x56, 0x31}: "EfiPaddingRsaesPkcs1V1P5Guid",
		efi.GUID{0xa9, 0xd4, 0x77, 0xb1, 0xe3, 0xd6, 0xa3, 0x48, 0x92, 0xf7, 0xb5, 0x48, 0xde, 0x87, 0x9d, 0x94}: "SraDxe",
		efi.GUID{0xa9, 0xdc, 0x9f, 0x82, 0x17, 0x69, 0x13, 0x47, 0xa3, 0xad, 0xf0, 0x4c, 0xf3, 0xe1, 0xb2, 0x5f}: "S4SlpDelayDxe",
		efi.GUID{0xa9, 0xdd, 0xbd, 0x25, 0xf5, 0xcc, 0x13, 0x4d, 0x99, 0x54, 0xec, 0x69, 0xd3, 0x0b, 0xab, 0xc4}: "AmdCpmZeroPowerOddPeim",
		efi.GUID{0xa9, 0xde, 0x99, 0xb1, 0x5c, 0xfd, 0x84, 0x4a, 0x80, 0x82, 0x2f, 0x41, 0x70, 0x78, 0x03, 0x05}: "EarlyPL011BaseAddressGuid",
		efi.GUID{0xa9, 0xe6, 0x7a, 0x8d, 0x90, 0xb4, 0xe1, 0x45, 0x87, 0x95, 0xc2, 0xbe, 0xaa, 0xdc, 0x38, 0x14}: "RawIp4Rx",
		efi.GUID{0xa9, 0xf8, 0x22, 0xef, 0x7e, 0x26, 0x40, 0x48, 0xbc, 0x32, 0xf0, 0xcf, 0xdf, 0xdf, 0xa4, 0x26}: "PeiSmmControlPei",
		efi.GUID{0xa9, 0xf9, 0x8e, 0x03, 0x69, 0x59, 0x93, 0x47, 0x96, 0x4f, 0xff, 0x12, 0xfa, 0x18, 0x39, 0x3e}: "AmdCpmOemInitPeim",
		efi.GUID{0xaa, 0x00, 0xf2, 0x25, 0xcb, 0xd3, 0x0a, 0x47, 0xbf, 0x51, 0xe7, 0xd1, 0x62, 0xd2, 0x2e, 0x6f}: "ShellDebug1HiiGuid",
		efi.GUID{0xaa, 0x04, 0xaa, 0x2e, 0xed, 0x5e, 0x27, 0x4c, 0xb9, 0xee, 0x26, 0x91, 0x6e, 0xc2, 0x5a, 0x8f}: "RtkUndiDxeX64_011",
		efi.GUID{0xaa, 0x05, 0xff, 0xd4, 0x7d, 0x3c, 0x8a, 0x4b, 0xa1, 0xee, 0xaa, 0x5e, 0xfa, 0x0b, 0x17, 0x42}: "TrustedDeviceSetup",
		efi.GUID{0xaa, 0x0e, 0x7a, 0x71, 0x18, 0x9b, 0x1a, 0x46, 0xb6, 0xec, 0xac, 0x09, 0x79, 0x4c, 0xa6, 0x31}: "LenovoSystemAcpiSupportDxe",
		efi.GUID{0xaa, 0x1b, 0xad, 0x36, 0x1a, 0x24, 0x16, 0x43, 0x81, 0x1f, 0x22, 0x0c, 0xed, 0xcf, 0x15, 0xea}: "AutoTpm",
		efi.GUID{0xaa, 0x1d, 0xa3, 0xb8, 0xfd, 0x33, 0xf4, 0x48, 0xb8, 0x4a, 0x4d, 0x39, 0x1f, 0xfa, 0x1f, 0x45}: "EventLogPei",
		efi.GUID{0xaa, 0x21, 0x28, 0x95, 0xcd, 0xea, 0x5b, 0x46, 0xb4, 0x78, 0x54, 0x29, 0xdf, 0xc9, 0xa7, 0x47}: "OA2",
		efi.GUID{0xaa, 0x28, 0x0d, 0x12, 0x30, 0x66, 0xf0, 0x46, 0x81, 0x57, 0xc0, 0xad, 0xc2, 0x38, 0x3b, 0xf5}: "AmiLegacyBootProtocolGuid",
		efi.GUID{0xaa, 0x35, 0xb1, 0xc1, 0xcb, 0x7a, 0xd0, 0x45, 0x80, 0xb7, 0x86, 0x2b, 0x8d, 0x5f, 0x0c, 0xd5}: "AmdFabricRvSmm",
		efi.GUID{0xaa, 0x3e, 0xd9, 0x23, 0x23, 0x07, 0x59, 0x45, 0xb7, 0x68, 0x5e, 0x22, 0xdf, 0x76, 0x2d, 0xe4}: "LenovoTpmEnablerDxe",
		efi.GUID{0xaa, 0x4b, 0xf7, 0x08, 0x36, 0xea, 0xd9, 0x41, 0x95, 0x21, 0x21, 0xa7, 0x0f, 0x87, 0x80, 0xbc}: "EfiDiskInfoScsiInterfaceGuid",
		efi.GUID{0xaa, 0x59, 0x47, 0xbd, 0x04, 0x51, 0xa3, 0x42, 0xbc, 0x64, 0x78, 0x59, 0x20, 0xe8, 0x6c, 0x99}: "FchProm21GpioSmm",
		efi.GUID{0xaa, 0x5f, 0xfe, 0xbd, 0x35, 0x2a, 0xbb, 0x44, 0xb1, 0x7a, 0x80, 0x84, 0xd4, 0xe2, 0xb9, 0xe9}: "FvbServicesRuntimeDxe",
		efi.GUID{0xaa, 0x62, 0x2e, 0x2d, 0xcf, 0x9e, 0xb7, 0x43, 0x82, 0x19, 0x94, 0xe7, 0xfc, 0x71, 0x3d, 0xfe}: "SystemUsbMouseDxe",
		efi.GUID{0xaa, 0x6f, 0x90, 0xbb, 0x47, 0x2a, 0x67, 0x5c, 0xdd, 0x9f, 0x68, 0x67, 0xfe, 0x12, 0x5d, 0x4f}: "DGPU_GOP_2",
		efi.GUID{0xaa, 0x73, 0x63, 0xb7, 0x59, 0x02, 0x6c, 0x41, 0x81, 0x70, 0xde, 0x9a, 0x0b, 0x6f, 0x95, 0x5e}: "BzmDxe",
		efi.GUID{0xaa, 0x77, 0x41, 0xfe, 0x8b, 0x16, 0x1c, 0x4c, 0xbc, 0x5d, 0x20, 0x5c, 0x93, 0x23, 0x07, 0xcb}: "OemKbLightSupportDxe",
		efi.GUID{0xaa, 0x81, 0x71, 0x6e, 0x35, 0xa8, 0xbe, 0x47, 0x9c, 0x49, 0x07, 0x43, 0x35, 0x4d, 0x2f, 0x5d}: "RecoveryPcdDataBase",
		efi.GUID{0xaa, 0x93, 0x27, 0x16, 0xe7, 0x0f, 0x10, 0x40, 0x98, 0x18, 0x45, 0xf5, 0x5c, 0x5c, 0xcc, 0x3e}: "AmdCpmInitDxe",
		efi.GUID{0xaa, 0x98, 0x01, 0x6f, 0x1d, 0x1f, 0x6d, 0x42, 0xae, 0x3e, 0x39, 0xab, 0x63, 0x3f, 0xcc, 0x28}: "Cf9ResetDxe",
		efi.GUID{0xaa, 0x98, 0x37, 0x0c, 0x2e, 0xd2, 0xd6, 0x4d, 0x8c, 0xb4, 0x3c, 0x9c, 0xfb, 0x1d, 0x86, 0xd3}: "NCT6126DSmm",
		efi.GUID{0xaa, 0x9b, 0xdf, 0x6c, 0x34, 0x09, 0xc2, 0x43, 0xa8, 0x5f, 0x28, 0x63, 0x86, 0x09, 0x76, 0x04}: "SystemHddPwdSmm",
		efi.GUID{0xaa, 0x9f, 0x19, 0x34, 0xfc, 0x81, 0xa2, 0x44, 0x9e, 0x66, 0x56, 0xe2, 0xb1, 0x8a, 0x13, 0x38}: "DashIoCfgPolicy",
		efi.GUID{0xaa, 0xa2, 0x12, 0x51, 0x75, 0xe1, 0x7e, 0x47, 0xa4, 0xe4, 0xd0, 0xb7, 0xe6, 0x89, 0xba, 0x9f}: "SystemEventLogDxe",
		efi.GUID{0xaa, 0xa2, 0x62, 0xe8, 0x9a, 0x29, 0x4b, 0x4a, 0xb0, 0x0a, 0xaa, 0x73, 0x50, 0xfd, 0x68, 0x42}: "DellSecurityAuditDisplayDxe",
		efi.GUID{0xaa, 0xa4, 0xfe, 0xe6, 0x5c, 0x57, 0xfc, 0x48, 0x99, 0xce, 0x17, 0x24, 0xdb, 0xdc, 0x1f, 0xf2}: "ActDxe",
		efi.GUID{0xaa, 0xaa, 0xc6, 0x8f, 0x61, 0x45, 0x15, 0x48, 0x8c, 0xf7, 0xb8, 0x73, 0x12, 0x99, 0x2d, 0xce}: "UserAuthenticationSmm",
		efi.GUID{0xaa, 0xad, 0xe9, 0xa7, 0xc3, 0x35, 0x6b, 0x4a, 0xa3, 0xb7, 0x6c, 0x38, 0xba, 0xa2, 0x4f, 0x1f}: "BootBlockVisibleUpdateDxe",
		efi.GUID{0xaa, 0xb2, 0xff, 0x3f, 0x92, 0x46, 0xe8, 0x42, 0x86, 0x5e, 0x7e, 0x11, 0x19, 0x86, 0xfa, 0xbe}: "wifi_2bars",
		efi.GUID{0xaa, 0xb8, 0x0c, 0x10, 0xfc, 0x7b, 0x2b, 0x4d, 0x90, 0xbe, 0x0a, 0x48, 0xc9, 0xed, 0x53, 0x16}: "BoardMilestoneHookDxe",
		efi.GUID{0xaa, 0xb9, 0x66, 0x54, 0x2f, 0xee, 0xdb, 0x4f, 0x84, 0xa3, 0xa3, 0x30, 0xbe, 0x13, 0x01, 0xff}: "AmdHstiV2",
		efi.GUID{0xaa, 0xd7, 0xe9, 0x45, 0x85, 0x6d, 0xec, 0x4d, 0x8b, 0x88, 0x8c, 0x4b, 0xe5, 0xa1, 0xa0, 0x8d}: "NvmeSmmProtocol",
		efi.GUID{0xaa, 0xdd, 0xc0, 0x9d, 0xbd, 0x56, 0x7a, 0x44, 0x95, 0xcc, 0x51, 0x80, 0x43, 0x31, 0x10, 0xf9}: "menu_top_left",
		efi.GUID{0xaa, 0xde, 0xd8, 0xf0, 0x95, 0xc4, 0x39, 0x41, 0xb1, 0xfc, 0x78, 0xb7, 0x01, 0x68, 0x26, 0x0a}: "DellDxeDiagLeds",
		efi.GUID{0xaa, 0xe3, 0xaf, 0x4a, 0xee, 0xde, 0x81, 0x4d, 0x80, 0xf3, 0x82, 0xd2, 0x26, 0xc7, 0x1c, 0x4b}: "PvScsiPassThruDxe",
		efi.GUID{0xaa, 0xe5, 0x78, 0xb1, 0x76, 0x08, 0x0a, 0x42, 0xb4, 0x0f, 0xe3, 0x9b, 0x4e, 0x6e, 0xe0, 0x5b}: "WarmBootPei",
		efi.GUID{0xaa, 0xf6, 0x9a, 0xfe, 0xf9, 0x17, 0x67, 0x4a, 0xb0, 0x09, 0xe3, 0x75, 0x79, 0x38, 0x5d, 0xe5}: "SiliconDataInitDxe",
		efi.GUID{0xab, 0x00, 0x33, 0x3a, 0x29, 0xc9, 0x7d, 0x48, 0xab, 0x34, 0x15, 0x9b, 0xc1, 0x35, 0x62, 0xc0}: "PchResetCallbackProtocolGuid",
		efi.GUID{0xab, 0x00, 0x73, 0xae, 0x4a, 0x0e, 0xf0, 0x43, 0xb0, 0x77, 0x42, 0xb9, 0xdf, 0xc4, 0x60, 0x33}: "FjGpnvSmm",
		efi.GUID{0xab, 0x07, 0xef, 0xf9, 0xd0, 0xab, 0xe0, 0x4f, 0xab, 0xa7, 0xbb, 0xa2, 0x95, 0x02, 0x47, 0x12}: "DellTagDxe",
		efi.GUID{0xab, 0x0d, 0x70, 0xc4, 0xb6, 0x41, 0xdf, 0x4f, 0xcc, 0xaa, 0xe3, 0x97, 0x36, 0xff, 0xf2, 0xba}: "I2cPlatformSpecificDxe",
		efi.GUID{0xab, 0x0f, 0xfe, 0x3d, 0xc7, 0x70, 0x53, 0x4b, 0x98, 0x55, 0x98, 0x5f, 0x14, 0xdb, 0x2d, 0xda}: "RawIp4Tx",
		efi.GUID{0xab, 0x10, 0x43, 0x04, 0xfd, 0x77, 0x2a, 0x40, 0xaf, 0x1a, 0x87, 0xd4, 0x12, 0x0e, 0x73, 0x29}: "FirmwarePerformanceSmm",
		efi.GUID{0xab, 0x14, 0xf0, 0xe6, 0x0e, 0xcb, 0x6e, 0x45, 0x8a, 0xf7, 0x72, 0x21, 0xed, 0xb7, 0x02, 0xf7}: "ThinkpadAcpiNvsDataProtocol",
		efi.GUID{0xab, 0x1b, 0x21, 0x2d, 0x45, 0x08, 0x24, 0x4d, 0x8b, 0xe6, 0xa6, 0xec, 0x7a, 0xb7, 0x65, 0x72}: "AmdCpmOemSmm",
		efi.GUID{0xab, 0x23, 0x9e, 0x48, 0x46, 0xf1, 0xd2, 0x40, 0x93, 0x1d, 0x90, 0x27, 0x5f, 0x15, 0x1d, 0xf1}: "EzTpmUpdNtcTpmFwUpdDrv",
		efi.GUID{0xab, 0x2c, 0x20, 0x1d, 0xab, 0xc8, 0x5c, 0x4d, 0x94, 0xf7, 0x3c, 0xfc, 0xc0, 0xd3, 0xd3, 0x35}: "EfiSmmCpuServiceProtocolGuid",
		efi.GUID{0xab, 0x2d, 0xae, 0x50, 0x4c, 0x3a, 0x77, 0x4f, 0x85, 0xea, 0xfc, 0x42, 0x71, 0xfc, 0x37, 0x6a}: "Ps2WakeupSmm",
		efi.GUID{0xab, 0x2f, 0x8b, 0xfa, 0x32, 0x00, 0xda, 0x43, 0x91, 0x65, 0x21, 0x3b, 0xea, 0xa2, 0xd9, 0x67}: "StoreRestoreMBR",
		efi.GUID{0xab, 0x31, 0xa0, 0x18, 0x43, 0xb4, 0x1a, 0x4d, 0xa5, 0xc0, 0x0c, 0x09, 0x26, 0x1e, 0x9f, 0x71}: "EfiDriverBindingProtocolGuid",
		efi.GUID{0xab, 0x31, 0xa5, 0xd5, 0x0b, 0x30, 0xa1, 0x4a, 0x9b, 0x8a, 0x9c, 0x6c, 0x8f, 0x01, 0x10, 0xf4}: "CrServiceSmm",
		efi.GUID{0xab, 0x35, 0x58, 0x9c, 0x6d, 0xe8, 0xa9, 0x48, 0x95, 0xd0, 0x37, 0x35, 0xb7, 0x5f, 0x82, 0xf6}: "LnvAMDArmor3",
		efi.GUID{0xab, 0x36, 0x7d, 0x92, 0x78, 0xc2, 0xc5, 0x4e, 0xb2, 0xf3, 0x8b, 0xaa, 0x4b, 0x8e, 0x1f, 0x34}: "FjGabiSystemDataEventLogAbstraction",
		efi.GUID{0xab, 0x37, 0xd3, 0xfc, 0xd3, 0xb1, 0xf8, 0x4e, 0x95, 0x7c, 0x80, 0x48, 0x60, 0x6f, 0xf6, 0x70}: "HiiDatabaseDxe",
		efi.GUID{0xab, 0x4a, 0x7a, 0x1f, 0xab, 0xe6, 0x6c, 0x41, 0x98, 0xb8, 0x31, 0xf6, 0x14, 0xff, 0xf1, 0x98}: "DellSmmComputracePreInit",
		efi.GUID{0xab, 0x5a, 0x5a, 0x86, 0x5d, 0xb8, 0x4c, 0x47, 0x84, 0x55, 0x65, 0xd1, 0xbe, 0x84, 0x4b, 0xe2}: "EfiSourceLevelDebugPkgTokenSpaceGuid",
		efi.GUID{0xab, 0x63, 0x69, 0x6d, 0x6d, 0x90, 0x65, 0x4a, 0xa7, 0xca, 0xbd, 0x40, 0xe5, 0xd6, 0xaf, 0x2b}: "Udp4Dxe",
		efi.GUID{0xab, 0x63, 0x69, 0x6d, 0x6d, 0x90, 0x65, 0x4a, 0xa7, 0xca, 0xbd, 0x40, 0xe5, 0xd6, 0xaf, 0x4d}: "Tcp4Dxe",
		efi.GUID{0xab, 0x67, 0xb8, 0xec, 0xf4, 0x8d, 0x2d, 0x49, 0x81, 0x50, 0xa7, 0xfd, 0x1b, 0x9b, 0x5a, 0x75}: "AmiSmmFlashProtocolGuid",
		efi.GUID{0xab, 0x6c, 0xbc, 0x0b, 0x28, 0xf2, 0x20, 0x4f, 0x8c, 0x6a, 0x84, 0x7c, 0xde, 0xe3, 0xff, 0x24}: "OFCDxe",
		efi.GUID{0xab, 0x75, 0x48, 0xf4, 0xfc, 0xb9, 0x78, 0x45, 0xa2, 0x80, 0xaa, 0x33, 0x5b, 0x49, 0x96, 0x7c}: "CmosSmm",
		efi.GUID{0xab, 0x80, 0x88, 0x75, 0xa2, 0x4c, 0xaa, 0x4d, 0xa8, 0x3e, 0xd1, 0xf9, 0xad, 0xf2, 0xc2, 0xf1}: "DellSmmSioEmi",
		efi.GUID{0xab, 0x86, 0x78, 0x71, 0x0a, 0xc4, 0xcf, 0x44, 0x91, 0x14, 0x41, 0x19, 0xe8, 0x4b, 0x0d, 0xc7}: "PciCfgOnPciCfg2Thunk",
		efi.GUID{0xab, 0x87, 0xcb, 0x19, 0xb9, 0x2c, 0x65, 0x46, 0x83, 0x60, 0xdd, 0xcf, 0x60, 0x54, 0xf7, 0x9d}: "EfiPciHotPlugRequestProtocolGuid",
		efi.GUID{0xab, 0x8a, 0x7f, 0xa1, 0xf9, 0x42, 0x94, 0x4d, 0x82, 0xcd, 0xa0, 0x99, 0xe1, 0xdd, 0x52, 0xdf}: "BootTimeDxe",
		efi.GUID{0xab, 0x95, 0x32, 0x01, 0x80, 0x66, 0x41, 0x4c, 0x9c, 0x98, 0xc4, 0x1a, 0xa6, 0xf5, 0x18, 0x8b}: "FlabLoadUadmDxe",
		efi.GUID{0xab, 0x96, 0x6e, 0x27, 0x01, 0x61, 0x79, 0x49, 0x99, 0x80, 0xe8, 0x5b, 0xfd, 0x69, 0x10, 0x2b}: "Common_AcpiDriverSupport",
		efi.GUID{0xab, 0x98, 0x94, 0x5d, 0x9e, 0x95, 0x6f, 0x4e, 0x8c, 0x0b, 0x86, 0x91, 0xc0, 0x29, 0xb7, 0x1c}: "OobMsmDxeDriver",
		efi.GUID{0xab, 0x9e, 0xbb, 0x43, 0x57, 0x7d, 0xef, 0x4d, 0xb0, 0xa2, 0xa3, 0xa9, 0xf9, 0xc6, 0xea, 0xe3}: "LenovoMailBoxDxe",
		efi.GUID{0xab, 0xad, 0x2f, 0x0f, 0x01, 0xe4, 0xed, 0x63, 0x7e, 0x29, 0x69, 0xf2, 0x15, 0xc6, 0x05, 0x11}: "OemUSBGetSetupData",
		efi.GUID{0xab, 0xb1, 0x5d, 0xe6, 0x3f, 0xa9, 0x7d, 0x41, 0x9a, 0x46, 0xce, 0x24, 0x19, 0xba, 0x72, 0xc4}: "StaticSkuDataDxeCLX64L",
		efi.GUID{0xab, 0xbf, 0xfb, 0xfd, 0x61, 0xbc, 0x61, 0x49, 0xb9, 0x17, 0x77, 0x44, 0x56, 0x41, 0x50, 0x7b}: "TseAfterPostInvPwdPrompt",
		efi.GUID{0xab, 0xc0, 0x1c, 0xe8, 0x85, 0x05, 0x1d, 0x8e, 0x5b, 0xd9, 0x59, 0x70, 0x2f, 0xda, 0x1f, 0xc4}: "OemBoardSmbios",
		efi.GUID{0xab, 0xd0, 0xca, 0xf7, 0xa4, 0xdf, 0xd2, 0x40, 0x8a, 0xfa, 0xb7, 0xa8, 0xbe, 0x01, 0x70, 0x31}: "MsiBoardEC",
		efi.GUID{0xab, 0xd5, 0x0c, 0xa2, 0xac, 0x83, 0x82, 0x4f, 0xb9, 0xe3, 0x98, 0x7b, 0x8b, 0xaf, 0x9a, 0xfe}: "UsbXhcAcpiTablePatchDxe",
		efi.GUID{0xab, 0xe8, 0x16, 0xa2, 0xa4, 0x19, 0xff, 0x43, 0x86, 0xa3, 0xc5, 0x79, 0x38, 0xf0, 0x3b, 0x06}: "FireWireDevice",
		efi.GUID{0xab, 0xe9, 0x42, 0x0d, 0xde, 0x5d, 0xac, 0x4c, 0xa4, 0x85, 0x02, 0x15, 0xc2, 0x52, 0x71, 0x7f}: "AmdSmmControl",
		efi.GUID{0xab, 0xea, 0xfe, 0x88, 0xba, 0xbf, 0xb9, 0x4c, 0x89, 0x07, 0x31, 0xbc, 0x6e, 0x54, 0x6d, 0xbe}: "SXApp",
		efi.GUID{0xac, 0x05, 0x6f, 0x6e, 0x4b, 0x23, 0x5b, 0x46, 0x94, 0x50, 0xc3, 0x6e, 0x6d, 0x75, 0x66, 0xc5}: "LenovoSystemIsaKbcDxe",
		efi.GUID{0xac, 0x08, 0xb2, 0x3f, 0x85, 0x21, 0x8c, 0x49, 0xbf, 0x46, 0xdc, 0x23, 0xda, 0x58, 0x7b, 0x55}: "EmuRedfishService",
		efi.GUID{0xac, 0x08, 0xdc, 0x62, 0x51, 0xa6, 0xe9, 0x4e, 0xaf, 0x81, 0xea, 0xa9, 0x26, 0x1e, 0x97, 0x80}: "S3NvramSave",
		efi.GUID{0xac, 0x0a, 0x68, 0x89, 0x2b, 0x45, 0x44, 0x4b, 0xae, 0xf7, 0x80, 0x0b, 0x6b, 0xfa, 0xf1, 0x95}: "EfiIchTokenSpace",
		efi.GUID{0xac, 0x0e, 0xfa, 0xf9, 0xb5, 0xa5, 0xdd, 0x40, 0xbd, 0xfd, 0xf5, 0x40, 0xdf, 0xee, 0x30, 0x7d}: "SbRecoveryDevice",
		efi.GUID{0xac, 0x14, 0xc9, 0x71, 0x48, 0xec, 0xd5, 0x43, 0xa9, 0xba, 0x64, 0xbf, 0xc6, 0x9c, 0x73, 0xda}: "BiosConnectLoader",
		efi.GUID{0xac, 0x22, 0x9f, 0x2b, 0xe0, 0x2b, 0x86, 0x48, 0x9d, 0x12, 0x66, 0xb1, 0x35, 0x9f, 0xd0, 0xae}: "DellAmdThunderboltSmm",
		efi.GUID{0xac, 0x2c, 0xb1, 0x0b, 0xa9, 0xcf, 0x39, 0x48, 0xa4, 0xc2, 0x17, 0x97, 0x24, 0x81, 0x09, 0xd0}: "DellLegacy16Rom",
		efi.GUID{0xac, 0x36, 0x67, 0xbd, 0x26, 0xb1, 0xea, 0x4f, 0x9d, 0x1d, 0x17, 0x4d, 0x4a, 0x89, 0x9f, 0x22}: "SystemErrorMenuDxe",
		efi.GUID{0xac, 0x36, 0xf4, 0xb2, 0x27, 0xa1, 0xe8, 0x4e, 0x95, 0x7a, 0x50, 0x48, 0x60, 0x6d, 0xd6, 0x81}: "MarvellNicSerialDriver",
		efi.GUID{0xac, 0x44, 0x30, 0x2e, 0x9f, 0x87, 0x0f, 0x49, 0x97, 0x60, 0xbb, 0xdf, 0xaf, 0x69, 0x5f, 0x50}: "EfiLegacyBiosGuid",
		efi.GUID{0xac, 0x52, 0x12, 0x15, 0x7d, 0xf7, 0x44, 0x4c, 0x99, 0x77, 0xa4, 0x8c, 0xbe, 0xec, 0x9c, 0xca}: "SmmHooks",
		efi.GUID{0xac, 0x57, 0x2d, 0xd8, 0xf9, 0x99, 0x7a, 0x4c, 0xb5, 0x91, 0xbb, 0xcf, 0x8a, 0x0e, 0x7f, 0xbe}: "PchSmbusArpDisabled",
		efi.GUID{0xac, 0x5a, 0x73, 0xe4, 0x27, 0x9c, 0x3f, 0x49, 0x86, 0xea, 0x9e, 0xff, 0x43, 0xd7, 0xad, 0xcd}: "VirtualKeyboardDxe",
		efi.GUID{0xac, 0x5b, 0x3b, 0x49, 0x9e, 0xbb, 0xf5, 0x4b, 0x83, 0x79, 0x20, 0xe2, 0xac, 0xa9, 0x85, 0x41}: "EfiSaInfoProtocol",
		efi.GUID{0xac, 0x5d, 0x40, 0xd6, 0xd7, 0x92, 0xb2, 0x4b, 0xa9, 0xc9, 0xcb, 0x7c, 0x74, 0x90, 0x23, 0xf5}: "BIOSLD",
		efi.GUID{0xac, 0x65, 0x3a, 0x01, 0x4e, 0xdb, 0x19, 0x41, 0xce, 0xa6, 0x9a, 0x31, 0x98, 0x2c, 0xae, 0x96}: "ABCTDxe",
		efi.GUID{0xac, 0x65, 0x3a, 0x01, 0x4e, 0xdb, 0x23, 0x31, 0xce, 0xa6, 0x9a, 0x31, 0x98, 0x2c, 0xae, 0x96}: "HddDiagnostic",
		efi.GUID{0xac, 0x65, 0x3a, 0x01, 0xac, 0xde, 0x23, 0x31, 0xce, 0xa6, 0x9a, 0x31, 0x98, 0x22, 0x3e, 0x96}: "MemTest",
		efi.GUID{0xac, 0x6a, 0x49, 0x0a, 0x56, 0x8c, 0xa0, 0x4d, 0xa9, 0x60, 0xe4, 0x17, 0x24, 0x7a, 0x61, 0x83}: "BroadcomLomSmm",
		efi.GUID{0xac, 0x6a, 0xc3, 0xab, 0x31, 0x20, 0x22, 0x44, 0x89, 0x6e, 0x0a, 0x3b, 0x89, 0x9a, 0xd0, 0xb4}: "Microcode",
		efi.GUID{0xac, 0x6c, 0xc3, 0x25, 0xa6, 0x80, 0x0f, 0x40, 0xb0, 0xb1, 0x8a, 0xef, 0x82, 0x34, 0x18, 0x01}: "OemReadyBoot",
		efi.GUID{0xac, 0x70, 0xae, 0x1f, 0x03, 0x82, 0xf0, 0x48, 0xb9, 0xef, 0xe8, 0x73, 0xff, 0xec, 0xc1, 0xf2}: "PeiLegacyRegionPpi",
		efi.GUID{0xac, 0x7e, 0x54, 0x62, 0x78, 0x28, 0x42, 0x43, 0xbb, 0x6e, 0xb6, 0x0f, 0x1e, 0x0d, 0xd3, 0xf1}: "NCT7802YPeiInit",
		efi.GUID{0xac, 0x81, 0x26, 0x94, 0x3d, 0x4f, 0xac, 0x46, 0x9a, 0xea, 0xd4, 0xf2, 0x5f, 0x21, 0x24, 0x8a}: "FjMeFwUpdateOdm",
		efi.GUID{0xac, 0x87, 0xe2, 0x8d, 0x60, 0x94, 0x5c, 0x46, 0xb8, 0xfa, 0xf6, 0xe9, 0x86, 0x6a, 0xe5, 0x6d}: "xgbe_atl",
		efi.GUID{0xac, 0x89, 0x81, 0x85, 0xca, 0x0e, 0x66, 0x46, 0xba, 0xb8, 0x99, 0x72, 0x40, 0x99, 0x53, 0xc8}: "AcRecoverySmm",
		efi.GUID{0xac, 0x8a, 0x40, 0xc4, 0x1f, 0x28, 0x4a, 0x4c, 0xbe, 0x99, 0x2e, 0x5c, 0x56, 0xbc, 0xc1, 0x6d}: "OdometerInitDxe",
		efi.GUID{0xac, 0x8b, 0x06, 0xc5, 0xdc, 0xa7, 0xf1, 0x42, 0xae, 0x80, 0xca, 0xa2, 0x4b, 0xb4, 0x90, 0x4b}: "PttPassThruPpiGuid",
		efi.GUID{0xac, 0x8b, 0x20, 0xf4, 0x29, 0xae, 0x60, 0x4c, 0x9d, 0xc8, 0x9b, 0x33, 0x14, 0x7b, 0x06, 0x2b}: "DefaultSettingsSupportEfiVariable",
		efi.GUID{0xac, 0x8e, 0xcd, 0xa3, 0xe6, 0xb4, 0x68, 0x4b, 0x96, 0x41, 0x0d, 0x37, 0x63, 0x79, 0x98, 0x90}: "Int15Backlight",
		efi.GUID{0xac, 0x91, 0xf6, 0xa6, 0xc8, 0x31, 0x44, 0x44, 0x85, 0x4c, 0xe2, 0xc1, 0xa6, 0x95, 0x0f, 0x92}: "DuetBds",
		efi.GUID{0xac, 0x96, 0x85, 0xa1, 0xc5, 0x1f, 0x8d, 0x47, 0xbf, 0x14, 0x0b, 0x41, 0x58, 0x13, 0xd7, 0x1f}: "Ohci",
		efi.GUID{0xac, 0x9a, 0x83, 0x05, 0x1d, 0x36, 0xd8, 0x47, 0xb2, 0xba, 0x50, 0xd5, 0xf4, 0xb0, 0x9a, 0xd8}: "AsusRecoveryFailedPei",
		efi.GUID{0xac, 0xa1, 0xdf, 0xaa, 0x23, 0xe9, 0x73, 0x46, 0xb1, 0xb8, 0x71, 0x4a, 0xd8, 0x49, 0xf7, 0x90}: "SystemFormBrowserSimpleTextViewLayoutDxe",
		efi.GUID{0xac, 0xb2, 0x29, 0x66, 0x5d, 0x29, 0x66, 0x45, 0x8c, 0xcb, 0xec, 0x41, 0x82, 0x45, 0x3f, 0xe0}: "AmdLegacyInterrupt",
		efi.GUID{0xac, 0xbd, 0xf9, 0x72, 0xcc, 0x8e, 0xea, 0x4d, 0x8a, 0xb1, 0x5b, 0x59, 0x33, 0x33, 0x14, 0x8f}: "LenovoSecureSuiteApp",
		efi.GUID{0xac, 0xc0, 0x6e, 0x78, 0xae, 0x65, 0x1b, 0x4d, 0xb1, 0x37, 0x0d, 0x11, 0x0a, 0x48, 0x37, 0x97}: "IScsiCHAPAuthInfoGuid",
		efi.GUID{0xac, 0xc1, 0x6d, 0x9a, 0xc0, 0x94, 0xb1, 0x43, 0x87, 0x14, 0x4c, 0x70, 0xfd, 0x58, 0xa8, 0x15}: "BaseS3BootScriptLibNull",
		efi.GUID{0xac, 0xc2, 0x15, 0x31, 0xe1, 0x27, 0xa9, 0x14, 0x53, 0xcd, 0xac, 0x47, 0x34, 0x80, 0x2a, 0xd7}: "AmiPspSetPcdForRecovery",
		efi.GUID{0xac, 0xc2, 0x45, 0x51, 0xe1, 0x17, 0xa9, 0x44, 0x83, 0xcd, 0xac, 0x87, 0x24, 0x80, 0x5a, 0xd2}: "AmiPspPlatform",
		efi.GUID{0xac, 0xc6, 0x10, 0x14, 0x4b, 0x9f, 0x5b, 0x49, 0x9c, 0x23, 0x8a, 0x5a, 0xeb, 0x01, 0x65, 0xe9}: "SmmSwDispatch2OnSmmSwDispatchThunk",
		efi.GUID{0xac, 0xce, 0x63, 0xc4, 0x57, 0xfc, 0x36, 0x4f, 0x88, 0xb7, 0x35, 0x6c, 0x75, 0x0c, 0x3b, 0xca}: "UhciPei",
		efi.GUID{0xac, 0xce, 0xb0, 0xa7, 0x0a, 0x48, 0x8b, 0x4f, 0xac, 0xe3, 0x76, 0x79, 0xbe, 0x16, 0xea, 0xf9}: "PdHostInterfaceTiPei",
		efi.GUID{0xac, 0xd0, 0xb8, 0x71, 0xa1, 0xab, 0xb4, 0x46, 0x8d, 0x28, 0x09, 0xc9, 0xfc, 0xa0, 0x15, 0x8d}: "IwlMei",
		efi.GUID{0xac, 0xd5, 0xa9, 0x09, 0x04, 0x52, 0x14, 0x42, 0x96, 0xe5, 0x94, 0x99, 0x2e, 0x75, 0x2b, 0xcd}: "EfiEventNotificationTypePei",
		efi.GUID{0xac, 0xd8, 0x73, 0x30, 0xab, 0xef, 0x55, 0x40, 0x9b, 0x37, 0xf6, 0x2c, 0xd9, 0x3a, 0x20, 0x0a}: "IrqAllocatorDxe",
		efi.GUID{0xac, 0xe1, 0xcf, 0x9c, 0x4c, 0x78, 0x3d, 0x46, 0xb1, 0x45, 0x39, 0x6d, 0x70, 0x14, 0xd5, 0x59}: "VideoInitPeim",
		efi.GUID{0xac, 0xe4, 0x68, 0x3b, 0xdc, 0x78, 0x98, 0x41, 0xb5, 0xb0, 0x9f, 0x34, 0x1e, 0x50, 0x3b, 0x7d}: "ProjectSMI",
		efi.GUID{0xac, 0xfe, 0xab, 0xdd, 0x63, 0xef, 0x2c, 0x45, 0x8f, 0x39, 0xed, 0x7f, 0xae, 0xd8, 0x26, 0x5e}: "PpmPlatformPolicyProtocolGuid",
		efi.GUID{0xad, 0x00, 0x21, 0x70, 0x64, 0x39, 0xcb, 0x49, 0x85, 0x11, 0xe8, 0x62, 0x7b, 0x38, 0x4a, 0xd0}: "RASMiscDriver",
		efi.GUID{0xad, 0x00, 0x3e, 0x4a, 0x67, 0xb6, 0x54, 0x40, 0x95, 0xb3, 0x2e, 0x8f, 0x30, 0x5b, 0xd6, 0xdd}: "PostMessagePei",
		efi.GUID{0xad, 0x01, 0x49, 0x25, 0xb7, 0x7d, 0xf8, 0x45, 0x93, 0xc8, 0x93, 0xd5, 0x79, 0x39, 0x8d, 0x9f}: "PeiPciSegmentLibPciCfg2",
		efi.GUID{0xad, 0x02, 0xf3, 0x21, 0x94, 0x6e, 0x1b, 0x47, 0x84, 0xbc, 0xb1, 0x48, 0x00, 0x40, 0x3a, 0x1d}: "EfiSmmCpuSaveStateProtocolGuid",
		efi.GUID{0xad, 0x0c, 0xe4, 0x48, 0xd2, 0xa6, 0x56, 0x47, 0x8a, 0xeb, 0x81, 0xf4, 0x68, 0xd4, 0xa8, 0x56}: "Tpm20ShutdownOverrideguid",
		efi.GUID{0xad, 0x0f, 0xcc, 0x26, 0xb3, 0xbe, 0x8a, 0x47, 0x91, 0xb2, 0x0c, 0x18, 0x8f, 0x72, 0x61, 0x98}: "EfiPeiVirtualBlockIo2PpiGuid",
		efi.GUID{0xad, 0x28, 0x59, 0x41, 0xd9, 0x31, 0xbf, 0x4c, 0x9e, 0x92, 0x6d, 0x1f, 0x67, 0xec, 0x57, 0x11}: "EfiNgnCfgOut",
		efi.GUID{0xad, 0x2e, 0x10, 0xba, 0x08, 0x53, 0x9b, 0x4f, 0x9e, 0x22, 0xc1, 0xce, 0x4d, 0xc4, 0x4f, 0x49}: "RSAKey",
		efi.GUID{0xad, 0x2e, 0x19, 0xb8, 0x81, 0xcb, 0x12, 0x47, 0xac, 0x86, 0xca, 0x44, 0xd1, 0xb1, 0x92, 0x65}: "DisableUsbSmiMode",
		efi.GUID{0xad, 0x30, 0xa5, 0xd6, 0xf3, 0x14, 0xdd, 0x45, 0xa0, 0x97, 0xfb, 0x2a, 0x7c, 0x92, 0xb7, 0x26}: "FjSystemResetDxe",
		efi.GUID{0xad, 0x33, 0x42, 0xca, 0x7e, 0x84, 0x5d, 0x4e, 0xad, 0x3f, 0x21, 0xca, 0xbf, 0xe5, 0xe2, 0x3c}: "WinNtOemHookStatusCodeHandlerDxe",
		efi.GUID{0xad, 0x38, 0x23, 0xfa, 0xdf, 0x80, 0xd0, 0x49, 0x93, 0x96, 0xcf, 0x71, 0x45, 0xd0, 0x3a, 0x76}: "TxtOneTouchOpProtocol",
		efi.GUID{0xad, 0x3b, 0x35, 0xea, 0xd2, 0x99, 0xe6, 0x4b, 0x9b, 0x28, 0x53, 0xa8, 0xe8, 0x59, 0x69, 0x34}: "Armani_BatteryHealthControlSmm",
		efi.GUID{0xad, 0x3c, 0xb9, 0x63, 0x6d, 0xeb, 0x18, 0x44, 0x9c, 0x6d, 0x98, 0x70, 0x2f, 0x3d, 0x52, 0x62}: "Win7BootModeFeatureByte",
		efi.GUID{0xad, 0x3e, 0x24, 0x9b, 0xd0, 0x77, 0x54, 0x43, 0xb7, 0x8f, 0x70, 0xb3, 0x9a, 0xa4, 0x8f, 0x0d}: "SystemVspBcpSmm",
		efi.GUID{0xad, 0x49, 0xa3, 0x39, 0xfa, 0x0a, 0xe8, 0x54, 0xca, 0x0d, 0x7d, 0x6e, 0xa1, 0xe2, 0x95, 0x67}: "TpmSmm",
		efi.GUID{0xad, 0x4b, 0x49, 0xcb, 0xff, 0x23, 0x7e, 0x42, 0x86, 0x08, 0xd7, 0xe1, 0x38, 0xd3, 0x36, 0x3b}: "ArmPlatformLibNull",
		efi.GUID{0xad, 0x54, 0xb9, 0x8d, 0x7a, 0x04, 0x9a, 0x45, 0xac, 0x0f, 0xf3, 0x75, 0x87, 0x79, 0xf6, 0x1a}: "DellMfgModePei",
		efi.GUID{0xad, 0x54, 0xef, 0x41, 0xca, 0xe2, 0x33, 0x44, 0xfd, 0x27, 0xd9, 0xca, 0xca, 0x62, 0x1e, 0xae}: "AmdNbioIOMMUDxe",
		efi.GUID{0xad, 0x56, 0xf9, 0xad, 0x8c, 0xe9, 0x4c, 0x48, 0xae, 0x11, 0xb5, 0x1c, 0x7d, 0x33, 0x64, 0x47}: "ConfidentialComputingSecret",
		efi.GUID{0xad, 0x64, 0xa4, 0x23, 0x83, 0xcb, 0xb8, 0x48, 0x94, 0xab, 0x1a, 0x6f, 0xef, 0xcf, 0xe5, 0x22}: "EfiSioPpiGuid",
		efi.GUID{0xad, 0x64, 0xc3, 0x5f, 0x63, 0x4d, 0x80, 0x4b, 0xb1, 0x0c, 0x0c, 0x87, 0x80, 0xad, 0xa9, 0x17}: "XhciSmiDispatcher",
		efi.GUID{0xad, 0x80, 0x12, 0xa3, 0x1e, 0x48, 0xb6, 0x41, 0x95, 0xe8, 0x12, 0x7f, 0x4c, 0x98, 0x47, 0x79}: "TianoCustomDecompressGuid",
		efi.GUID{0xad, 0x86, 0xbf, 0x95, 0xe0, 0xa1, 0x43, 0x41, 0xb4, 0x87, 0x00, 0x4b, 0x1c, 0x2e, 0x05, 0xfa}: "DxeCmosInit",
		efi.GUID{0xad, 0x88, 0x7e, 0x6f, 0x34, 0xc6, 0x8a, 0x49, 0x84, 0xaf, 0xca, 0xec, 0x52, 0x6a, 0x3a, 0x51}: "AaeonModuleDxe",
		efi.GUID{0xad, 0x8a, 0x9d, 0x53, 0xac, 0xc6, 0x6c, 0x42, 0xb6, 0x1f, 0x22, 0x8e, 0x6d, 0x15, 0x01, 0xb6}: "LenovoHpmDxe",
		efi.GUID{0xad, 0x90, 0x06, 0x7f, 0x25, 0x17, 0x30, 0x49, 0x81, 0x37, 0x94, 0xd0, 0xfc, 0xf5, 0xf6, 0x3a}: "AmdXgbeAndDisplayConfigurePei",
		efi.GUID{0xad, 0x94, 0x4d, 0x41, 0x8d, 0x99, 0xd2, 0x47, 0xbf, 0xcd, 0x4e, 0x88, 0x22, 0x41, 0xde, 0x32}: "FwCapsuleHdr",
		efi.GUID{0xad, 0x99, 0x42, 0xb5, 0x21, 0xb5, 0xb8, 0x4b, 0xa3, 0x61, 0x68, 0x92, 0x49, 0xfe, 0x72, 0xb9}: "AodSmm",
		efi.GUID{0xad, 0xa8, 0x3a, 0xae, 0x81, 0xb5, 0xa0, 0x4a, 0x89, 0x8e, 0x14, 0xef, 0x42, 0xd2, 0x5f, 0x30}: "XnoteSecurityMenuSetup",
		efi.GUID{0xad, 0xae, 0xc3, 0xeb, 0x13, 0xcc, 0xb0, 0x49, 0xa6, 0x78, 0x5b, 0xed, 0x93, 0x95, 0x69, 0x55}: "BasePlatformHookLibNull",
		efi.GUID{0xad, 0xb7, 0xd8, 0x2f, 0xfa, 0xf8, 0x21, 0x40, 0x9f, 0xc0, 0x0a, 0xa5, 0x72, 0x14, 0x7c, 0xdc}: "CpuPei",
		efi.GUID{0xad, 0xc0, 0x63, 0x88, 0x24, 0x77, 0x4b, 0xc8, 0x88, 0xe5, 0xa3, 0x3b, 0x11, 0x6d, 0x14, 0x85}: "Host",
		efi.GUID{0xad, 0xc0, 0xe5, 0x5c, 0xeb, 0x34, 0x2b, 0x4b, 0x8e, 0x15, 0xee, 0xae, 0x35, 0x3a, 0xc5, 0x15}: "OemSVN_ID_Smi",
		efi.GUID{0xad, 0xc1, 0x5d, 0x90, 0x4d, 0xc4, 0x65, 0x49, 0x98, 0xac, 0xb6, 0xb4, 0x44, 0x4b, 0xfd, 0x65}: "UfsPciHcPei",
		efi.GUID{0xad, 0xc6, 0x10, 0x14, 0x4b, 0x9f, 0x5b, 0x49, 0x9c, 0x23, 0x8a, 0x5a, 0xeb, 0x01, 0x65, 0xe9}: "SmmUsbDispatch2OnSmmUsbDispatchThunk",
		efi.GUID{0xad, 0xcc, 0x76, 0x98, 0xb4, 0x47, 0xdb, 0x4b, 0xb6, 0x5e, 0x16, 0xf1, 0x93, 0xc4, 0xf3, 0xdb}: "EfiProcessorGenericErrorSectionGuid",
		efi.GUID{0xad, 0xcd, 0x8f, 0x47, 0x0e, 0x76, 0x6c, 0x42, 0x86, 0x9b, 0x2f, 0x33, 0x45, 0x05, 0x17, 0x50}: "DellHddSmartDxe",
		efi.GUID{0xad, 0xcf, 0x57, 0xa4, 0xea, 0x64, 0xee, 0x49, 0xa5, 0x32, 0x56, 0x6a, 0xc2, 0xb6, 0xd6, 0xc4}: "PolyFuseWarningsDxe",
		efi.GUID{0xad, 0xd1, 0x62, 0x32, 0xa8, 0xa8, 0x97, 0x45, 0x82, 0x5e, 0xde, 0x6f, 0x16, 0x7c, 0x34, 0x07}: "PlatformErrorHandler",
		efi.GUID{0xad, 0xe4, 0x90, 0x51, 0x02, 0xe9, 0x2e, 0x46, 0x95, 0x09, 0xa7, 0xab, 0x1f, 0x51, 0xb2, 0x7c}: "KEMhSpiMux",
		efi.GUID{0xad, 0xef, 0xc2, 0xfa, 0x11, 0x85, 0x34, 0x4e, 0x9c, 0xae, 0x16, 0xa2, 0x57, 0xba, 0x94, 0x88}: "Capsule",
		efi.GUID{0xad, 0xfc, 0x53, 0xeb, 0x71, 0x30, 0xab, 0x4b, 0x98, 0x0c, 0x6e, 0x4a, 0x37, 0x92, 0x55, 0xf3}: "RealtekUefiDriver",
		efi.GUID{0xad, 0xfe, 0x3f, 0xeb, 0xf6, 0x45, 0x18, 0x4a, 0xac, 0x71, 0xc4, 0xee, 0x97, 0xb2, 0x61, 0x19}: "KbcPeim",
		efi.GUID{0xae, 0x0a, 0xb0, 0x13, 0xd2, 0x4f, 0x4e, 0x96, 0xb3, 0x0f, 0x94, 0x62, 0x70, 0x17, 0x37, 0x0a}: "BmpConvert",
		efi.GUID{0xae, 0x0f, 0x3e, 0x09, 0xc4, 0xa6, 0x50, 0x4f, 0x9f, 0x1b, 0xd4, 0x1e, 0x2b, 0x89, 0xc1, 0x9a}: "EfiCertSha512Guid",
		efi.GUID{0xae, 0x14, 0xcf, 0x75, 0x41, 0x34, 0xdc, 0x49, 0xaa, 0x10, 0xbb, 0x35, 0xa7, 0xba, 0x8b, 0xab}: "EdkiiPlatformSpecificResetHandlerPpi",
		efi.GUID{0xae, 0x21, 0x15, 0x22, 0x35, 0x0a, 0xcd, 0x44, 0xb5, 0x80, 0x5a, 0xed, 0xbb, 0x77, 0x0b, 0x1d}: "glyphs",
		efi.GUID{0xae, 0x28, 0x38, 0x4b, 0xce, 0x0a, 0xb6, 0x45, 0x8c, 0xdb, 0xda, 0xfc, 0x28, 0xbb, 0xf8, 0xc5}: "VAROEM",
		efi.GUID{0xae, 0x34, 0x40, 0x2b, 0x66, 0x85, 0x2f, 0x41, 0x9c, 0xa5, 0x67, 0xfd, 0x69, 0x8f, 0xc2, 0x61}: "TcoSmi",
		efi.GUID{0xae, 0x36, 0x48, 0x3c, 0x4b, 0xb2, 0xe3, 0x40, 0xb2, 0x4b, 0x94, 0x48, 0xed, 0x09, 0x5b, 0xfe}: "SpiDxe",
		efi.GUID{0xae, 0x37, 0x88, 0x7b, 0x1e, 0x08, 0x3f, 0x4d, 0x8a, 0xad, 0x87, 0xbb, 0x93, 0x95, 0x2f, 0x38}: "WlanControllerDxe",
		efi.GUID{0xae, 0x37, 0x99, 0x7b, 0x2e, 0x09, 0x5f, 0x4d, 0x8b, 0xbd, 0x87, 0xbb, 0x14, 0x16, 0x2f, 0x38}: "SerialPortSettingDxe",
		efi.GUID{0xae, 0x3a, 0xd4, 0x12, 0xc1, 0xdd, 0x15, 0x46, 0xb0, 0xbc, 0xe1, 0x15, 0xf9, 0xd1, 0x7f, 0xc1}: "FjPowerButtonSmm",
		efi.GUID{0xae, 0x3c, 0xcd, 0xcc, 0x0d, 0x17, 0x34, 0x4e, 0x87, 0x66, 0x57, 0xb9, 0x04, 0x2b, 0xeb, 0xb9}: "EcEkKey",
		efi.GUID{0xae, 0x3f, 0xe9, 0x38, 0xf4, 0xc5, 0x00, 0x47, 0x94, 0x0d, 0xdc, 0x10, 0xe2, 0xfd, 0xb6, 0xc0}: "OemPeiRuntime",
		efi.GUID{0xae, 0x43, 0x13, 0xea, 0x6c, 0xba, 0x59, 0x40, 0xbe, 0x74, 0x02, 0x4d, 0x36, 0xd7, 0xaa, 0x3f}: "LEMBootModeFlagPei",
		efi.GUID{0xae, 0x47, 0x99, 0x8b, 0x9e, 0x0a, 0x5f, 0x4d, 0x8a, 0x8d, 0x87, 0xc9, 0x14, 0x13, 0x6f, 0x38}: "FlexIoCardDxe",
		efi.GUID{0xae, 0x47, 0xaa, 0x8b, 0x9e, 0x0a, 0x5f, 0x4d, 0x89, 0x8d, 0x87, 0xc9, 0x14, 0x68, 0x2f, 0x38}: "RTS545XDxe",
		efi.GUID{0xae, 0x47, 0xea, 0xdb, 0x4b, 0xe6, 0xd9, 0x4d, 0x95, 0x86, 0x15, 0x1a, 0xec, 0x8d, 0x5c, 0x18}: "HpPlatformSmmServices",
		efi.GUID{0xae, 0x4d, 0x2d, 0x39, 0xbd, 0xd3, 0xaf, 0x4c, 0xb1, 0xef, 0x57, 0xa7, 0x8b, 0x6e, 0x39, 0xbc}: "NVMeInfoDxe",
		efi.GUID{0xae, 0x54, 0xee, 0x10, 0x07, 0xb2, 0x4f, 0x4a, 0xab, 0xd8, 0xcb, 0x52, 0x2e, 0xca, 0xa3, 0xa4}: "Udp6Dxe",
		efi.GUID{0xae, 0x5a, 0x88, 0x3a, 0x30, 0x3e, 0xb9, 0x42, 0xa9, 0x76, 0x2f, 0x1f, 0x13, 0xbd, 0x70, 0x15}: "SecurityPkgList",
		efi.GUID{0xae, 0x5c, 0x7c, 0x54, 0x40, 0x26, 0xcf, 0x4a, 0x95, 0x32, 0x0e, 0x25, 0xb3, 0xf0, 0x3f, 0x05}: "WheaDxe",
		efi.GUID{0xae, 0x61, 0x82, 0xa4, 0xc1, 0xb7, 0x3b, 0x46, 0xbf, 0x32, 0x86, 0x25, 0xb6, 0x77, 0x9a, 0x0e}: "UsbIoExt",
		efi.GUID{0xae, 0x6c, 0x9c, 0x60, 0x5e, 0xc5, 0xba, 0x4d, 0xba, 0xae, 0xff, 0xf0, 0x21, 0xea, 0xe1, 0x96}: "MediaSanitizationDynamicSetup",
		efi.GUID{0xae, 0x84, 0xb1, 0x1d, 0xf5, 0x81, 0x72, 0x4e, 0x85, 0x44, 0x2b, 0xab, 0x0c, 0x2c, 0xac, 0x5c}: "AmiBbsDevicePath",
		efi.GUID{0xae, 0x8b, 0xc4, 0xf5, 0x0d, 0xc1, 0x76, 0x4a, 0xb8, 0x55, 0x5d, 0x5b, 0x06, 0x2a, 0xfe, 0x04}: "LOMDriver",
		efi.GUID{0xae, 0x8e, 0x1c, 0x15, 0x2c, 0x7f, 0x2c, 0x47, 0x9e, 0x54, 0x98, 0x28, 0x19, 0x4f, 0x6a, 0x88}: "EfiDiskIo2ProtocolGuid",
		efi.GUID{0xae, 0x8e, 0x4d, 0xe8, 0x51, 0x01, 0xf0, 0x41, 0x98, 0x74, 0x2f, 0x83, 0x8d, 0xb4, 0x71, 0x06}: "PMBUSPEI",
		efi.GUID{0xae, 0x8e, 0x88, 0x52, 0x10, 0x5b, 0xd0, 0x47, 0xa8, 0x7f, 0xb8, 0x22, 0xab, 0xa0, 0xca, 0xf4}: "EfiPeiCoreFvLocationPpi",
		efi.GUID{0xae, 0x8f, 0xc8, 0xa7, 0xec, 0xeb, 0xed, 0x45, 0xa7, 0xc5, 0x5f, 0xa7, 0x55, 0x17, 0x73, 0x06}: "PerfTuneWdtPpi",
		efi.GUID{0xae, 0x9d, 0xe7, 0xd4, 0xfc, 0xaa, 0x82, 0x43, 0x95, 0x40, 0x3e, 0x3f, 0xa4, 0x2d, 0x42, 0x55}: "AmiNvmeLegacyProtocolGuid",
		efi.GUID{0xae, 0xa4, 0x88, 0x68, 0xce, 0xaf, 0x4b, 0xe8, 0x91, 0x02, 0xf7, 0xb9, 0xda, 0xe6, 0xa0, 0x30}: "EmuBlockIoProtocolGuid",
		efi.GUID{0xae, 0xb3, 0x2c, 0x49, 0xdb, 0x66, 0x1e, 0x4f, 0x91, 0xae, 0x53, 0x4c, 0x48, 0xf2, 0xf8, 0x3d}: "WheaSupport",
		efi.GUID{0xae, 0xba, 0xf0, 0x56, 0x87, 0xf8, 0xd3, 0x45, 0x81, 0x4e, 0xb6, 0xd5, 0xc4, 0x89, 0xe0, 0xf9}: "AmiAgesaChipsetPei",
		efi.GUID{0xae, 0xbe, 0xb4, 0x19, 0xda, 0x54, 0xa9, 0x4a, 0x98, 0xb0, 0x41, 0xed, 0x75, 0xd8, 0x05, 0xba}: "EcRotTpmRecoveryDxe",
		efi.GUID{0xae, 0xbe, 0xdb, 0xdf, 0x4b, 0x7d, 0x3f, 0x4d, 0xba, 0x01, 0xfb, 0xf3, 0xda, 0x70, 0x85, 0x99}: "ThunderboltPei",
		efi.GUID{0xae, 0xbf, 0xb8, 0x7d, 0xbc, 0xb3, 0x3a, 0x48, 0x82, 0x52, 0xe0, 0xf2, 0x13, 0x15, 0x1a, 0xa7}: "ODMWlanTpowerOnOverride",
		efi.GUID{0xae, 0xc1, 0xfd, 0x76, 0x2a, 0xa4, 0x6a, 0x41, 0x98, 0xe3, 0xa2, 0xf2, 0x91, 0x46, 0xda, 0xc3}: "AppleDhcpProtocolDxe",
		efi.GUID{0xae, 0xd4, 0xb5, 0x9c, 0x86, 0xde, 0x22, 0x46, 0xa1, 0xd1, 0x3b, 0xca, 0xab, 0x41, 0x8f, 0xe9}: "IAxTblDxe",
		efi.GUID{0xae, 0xd6, 0xe3, 0x0b, 0x2c, 0x6d, 0xad, 0x41, 0x98, 0x69, 0xa9, 0x73, 0x64, 0xe7, 0xc1, 0xf1}: "FjIbvSfuSecFlashAbstractionSmmProtocol",
		efi.GUID{0xae, 0xd7, 0xe9, 0x4c, 0xb2, 0x61, 0x61, 0x44, 0x94, 0x46, 0xab, 0x03, 0x76, 0xb4, 0xa7, 0xf7}: "FboSce",
		efi.GUID{0xae, 0xe4, 0x85, 0x28, 0xa5, 0x09, 0xc8, 0x4e, 0xa9, 0x08, 0x60, 0xc4, 0xe4, 0xa9, 0x2b, 0x90}: "FchBixbyGpioPei",
		efi.GUID{0xae, 0xe4, 0x85, 0x28, 0xa5, 0x09, 0xc8, 0x4e, 0xa9, 0x08, 0x60, 0xc4, 0xe4, 0xa9, 0x2b, 0xac}: "FchPromontoryGpioPei",
		efi.GUID{0xae, 0xe8, 0x9b, 0xbe, 0xbb, 0xeb, 0x0f, 0x45, 0x96, 0x2c, 0xbe, 0x19, 0x38, 0xe3, 0xfe, 0xf9}: "F2HotKeyAndCorrectPassClr0199",
		efi.GUID{0xae, 0xe8, 0xb9, 0x94, 0x77, 0x88, 0x9a, 0x47, 0x98, 0x42, 0xf5, 0x97, 0x4b, 0x82, 0xce, 0xd3}: "EfiBoardFeaturesGuid",
		efi.GUID{0xae, 0xed, 0x57, 0xea, 0x94, 0x52, 0xff, 0x40, 0x97, 0xe8, 0x46, 0x52, 0xe8, 0x3d, 0x9f, 0x5c}: "FjGraphicsDxe",
		efi.GUID{0xae, 0xf6, 0x4e, 0x9d, 0x41, 0x79, 0xc3, 0x4b, 0xb5, 0xea, 0xff, 0x61, 0xec, 0xc2, 0xfc, 0x17}: "HpetTimer",
		efi.GUID{0xaf, 0x1c, 0x79, 0x81, 0xad, 0x44, 0x1f, 0x44, 0xb0, 0xa2, 0x32, 0x2b, 0xa8, 0xfc, 0x95, 0xed}: "FchImcControl",
		efi.GUID{0xaf, 0x1d, 0x76, 0xec, 0x86, 0x6b, 0xd0, 0x41, 0x82, 0x94, 0x35, 0x0b, 0x90, 0xfc, 0x94, 0x78}: "SystemCapsulePolicyDxe",
		efi.GUID{0xaf, 0x1d, 0xa5, 0x11, 0x34, 0x68, 0xa1, 0x4b, 0xad, 0x5e, 0x4a, 0x58, 0x63, 0x3b, 0x34, 0x3e}: "AmdPspDxeV2Rmb",
		efi.GUID{0xaf, 0x1e, 0x10, 0x70, 0x85, 0x00, 0x0c, 0x44, 0xb3, 0x56, 0x8e, 0xe3, 0x6f, 0xef, 0x24, 0xf0}: "EfiLegacyRegion2ProtocolGuid",
		efi.GUID{0xaf, 0x21, 0xb2, 0x70, 0xff, 0xfd, 0xde, 0x4f, 0x99, 0x68, 0x1a, 0xf6, 0x23, 0xa9, 0x56, 0xd9}: "EfiI2cHostProtocolGuid",
		efi.GUID{0xaf, 0x2f, 0x6b, 0x1c, 0xbd, 0xd8, 0xd1, 0x44, 0xa9, 0x1e, 0x73, 0x21, 0xb4, 0xc2, 0xf3, 0xd1}: "ScriptSaveDxe",
		efi.GUID{0xaf, 0x3c, 0xa9, 0x5e, 0xdd, 0xa8, 0x00, 0x44, 0x9f, 0xf6, 0xfe, 0x34, 0x3b, 0xca, 0xf3, 0x08}: "AodSmmSsp",
		efi.GUID{0xaf, 0x46, 0x25, 0x84, 0xea, 0x5a, 0xdb, 0x40, 0x86, 0x95, 0x42, 0xe5, 0x25, 0x75, 0xca, 0x45}: "A01DataServiceBodySmm",
		efi.GUID{0xaf, 0x47, 0xb0, 0x9a, 0x6e, 0xc2, 0xbf, 0x4d, 0xb4, 0x68, 0x27, 0xac, 0x65, 0x36, 0x48, 0x2e}: "TraceHubStatusCodeHandlerPei",
		efi.GUID{0xaf, 0x4a, 0x01, 0x58, 0x4a, 0x1c, 0x68, 0x48, 0x90, 0x42, 0x58, 0xbc, 0xd1, 0x63, 0x70, 0x54}: "FchProm21CbsPei",
		efi.GUID{0xaf, 0x4c, 0xa4, 0x24, 0xf2, 0x0b, 0x14, 0x45, 0x90, 0xc4, 0xc7, 0x94, 0xb3, 0xe7, 0x78, 0xf5}: "MePolicyInitDxe",
		efi.GUID{0xaf, 0x63, 0x2f, 0xb0, 0xd2, 0x96, 0x40, 0x40, 0xa1, 0x5b, 0xcb, 0xb8, 0xad, 0xf8, 0x19, 0x33}: "AmdMemSmbiosDxe",
		efi.GUID{0xaf, 0x65, 0xfa, 0x84, 0xbc, 0x21, 0xbe, 0x43, 0x85, 0xff, 0x8a, 0xa7, 0xe7, 0x83, 0x2a, 0x1d}: "AmiPciExpressLibNull",
		efi.GUID{0xaf, 0x75, 0x1f, 0xfe, 0x47, 0x36, 0x22, 0x44, 0xa7, 0xe1, 0xab, 0xd6, 0x45, 0x20, 0xd9, 0x04}: "PsrSetup",
		efi.GUID{0xaf, 0x7b, 0xcc, 0xc7, 0xb8, 0x73, 0xd5, 0x42, 0x9b, 0xe9, 0x6c, 0x8d, 0x03, 0x13, 0x7e, 0xd8}: "AsusSecureControl",
		efi.GUID{0xaf, 0x7b, 0xdd, 0x4e, 0x98, 0xba, 0xd8, 0x47, 0x85, 0xbf, 0x83, 0x1d, 0x98, 0xe7, 0x86, 0xcd}: "Sdev",
		efi.GUID{0xaf, 0x7e, 0xfd, 0x31, 0xa7, 0x80, 0x5e, 0x43, 0x8e, 0x0a, 0x3f, 0x18, 0x5f, 0x86, 0x67, 0xdd}: "UsbCoreDxe",
		efi.GUID{0xaf, 0x7f, 0x07, 0x6c, 0x58, 0x82, 0x08, 0x4c, 0xb8, 0x6d, 0xb8, 0xdc, 0x63, 0x26, 0x32, 0xb4}: "SmmPlatform",
		efi.GUID{0xaf, 0x8b, 0x72, 0x1c, 0xb6, 0x96, 0xe6, 0x46, 0xb5, 0x49, 0xe5, 0x0c, 0x45, 0x89, 0x8e, 0x3a}: "TamperEventProtection",
		efi.GUID{0xaf, 0x8f, 0x39, 0x04, 0xd6, 0xb8, 0x35, 0x4c, 0x99, 0xc9, 0x03, 0x79, 0x11, 0x23, 0x3d, 0xd9}: "H19QRCodeCreater",
		efi.GUID{0xaf, 0x94, 0xac, 0xd7, 0x98, 0xa4, 0xec, 0x45, 0xbf, 0xa2, 0xa5, 0x6e, 0x95, 0x34, 0x61, 0x8b}: "AmtForcePushPetVariable",
		efi.GUID{0xaf, 0x96, 0xbb, 0x93, 0xf2, 0xb9, 0xb8, 0x4e, 0x94, 0x62, 0xe0, 0xba, 0x74, 0x56, 0x42, 0x36}: "UefiOvmfPkgTokenSpaceGuid",
		efi.GUID{0xaf, 0x97, 0x90, 0x20, 0xcf, 0x5a, 0x2d, 0x4e, 0xa3, 0x1b, 0x72, 0x25, 0x7e, 0x05, 0xdc, 0x40}: "ODMMemoryOverride",
		efi.GUID{0xaf, 0x97, 0xcb, 0x33, 0x33, 0x6c, 0x42, 0x4c, 0x98, 0x6b, 0x07, 0x58, 0x1f, 0xa3, 0x66, 0xd4}: "BlockMmioToBlockIoDxe",
		efi.GUID{0xaf, 0x9e, 0x29, 0x92, 0x92, 0x66, 0x5d, 0x48, 0xae, 0x2c, 0xcd, 0x07, 0x78, 0x97, 0x40, 0x8b}: "LenovoMailboxSmmProtocol",
		efi.GUID{0xaf, 0xa5, 0x18, 0x3a, 0x5b, 0xf2, 0xee, 0x42, 0x86, 0x06, 0x8d, 0x30, 0xa9, 0x74, 0x91, 0x6b}: "PasswordEncodeSmmProtocol",
		efi.GUID{0xaf, 0xad, 0x9d, 0x29, 0xa6, 0x11, 0x1b, 0x47, 0x9e, 0x65, 0xcf, 0xe4, 0x08, 0xf5, 0x3d, 0xce}: "FjSpeakerDxe",
		efi.GUID{0xaf, 0xb0, 0xc9, 0xaa, 0x6a, 0xa4, 0xd8, 0x49, 0x80, 0x16, 0x9b, 0x9d, 0xad, 0x2c, 0x7f, 0x5e}: "DxeBoardConfigInit",
		efi.GUID{0xaf, 0xb1, 0x2b, 0x58, 0x33, 0x0a, 0x44, 0x46, 0x89, 0x8d, 0x94, 0xfc, 0x89, 0xc8, 0x38, 0xf3}: "HwmThermalDxe",
		efi.GUID{0xaf, 0xc7, 0xe7, 0xb5, 0xe7, 0xa3, 0x3c, 0x4d, 0xb2, 0x17, 0x04, 0x59, 0x6e, 0x4c, 0x36, 0x8f}: "AmiRedFishSecBootApiGuid",
		efi.GUID{0xaf, 0xce, 0x55, 0x04, 0x5c, 0xfe, 0x2f, 0x44, 0xba, 0x23, 0x34, 0xdf, 0xdc, 0x77, 0x50, 0x5a}: "NewRsmSampleDriver",
		efi.GUID{0xaf, 0xce, 0xd0, 0xb2, 0x8e, 0x84, 0x07, 0x4b, 0xbf, 0xea, 0x6f, 0xe6, 0xc7, 0x40, 0xb3, 0xd2}: "EcMpmPei",
		efi.GUID{0xaf, 0xd2, 0x87, 0x94, 0x94, 0xb3, 0x19, 0x41, 0xa9, 0x81, 0xce, 0x13, 0x3b, 0x11, 0xdb, 0x7a}: "BoardModernStandbyDxe",
		efi.GUID{0xaf, 0xd2, 0x87, 0x94, 0x94, 0xb3, 0x19, 0x41, 0xa9, 0x81, 0xce, 0x13, 0x3b, 0x11, 0xdb, 0x7b}: "BoardModernStandbySmm",
		efi.GUID{0xaf, 0xd3, 0xee, 0xa4, 0x37, 0x98, 0xb3, 0x46, 0x92, 0x75, 0xc7, 0x1c, 0xb4, 0x70, 0x71, 0xf9}: "NetsecDxe",
		efi.GUID{0xaf, 0xd6, 0x58, 0xd2, 0xc0, 0x2f, 0x19, 0x40, 0x9c, 0x1f, 0x11, 0x01, 0xc3, 0xdd, 0x19, 0xb5}: "DxeCoreEntryPoint",
		efi.GUID{0xaf, 0xe6, 0xc8, 0xbd, 0xbc, 0xd9, 0x79, 0x43, 0xa7, 0x2a, 0xe0, 0xc4, 0xe7, 0x5d, 0xae, 0x1c}: "EfiHttpServiceBindingProtocolGuid",
		efi.GUID{0xb0, 0x01, 0x7c, 0x4d, 0x5c, 0x49, 0x70, 0x40, 0xb0, 0xaa, 0x87, 0x5a, 0x64, 0xe6, 0x1c, 0x67}: "FjHddSmm",
		efi.GUID{0xb0, 0x03, 0xae, 0x55, 0x1d, 0x68, 0x0e, 0x45, 0x8a, 0xa5, 0x81, 0xb9, 0x4d, 0xba, 0x53, 0x62}: "SystemVspEvaPei",
		efi.GUID{0xb0, 0x04, 0xa1, 0x37, 0xd1, 0x2f, 0x88, 0x42, 0x83, 0xbf, 0xce, 0xb1, 0x77, 0x68, 0xf4, 0x0a}: "LenovoSmmKbdConfig",
		efi.GUID{0xb0, 0x05, 0x00, 0xb2, 0x2d, 0xbb, 0x6f, 0x49, 0x86, 0x9c, 0x23, 0x0b, 0x44, 0x79, 0xe7, 0xd1}: "EdkiiNonDiscoverableOhciDeviceGuid",
		efi.GUID{0xb0, 0x07, 0x07, 0xf5, 0xa0, 0x7d, 0x2d, 0x48, 0xb4, 0x58, 0xd2, 0x3a, 0x72, 0x93, 0x99, 0x59}: "EfiSecRev",
		efi.GUID{0xb0, 0x13, 0x5f, 0x90, 0x91, 0x8f, 0x0a, 0x4b, 0xbd, 0x76, 0xe1, 0xe7, 0x8f, 0x94, 0x22, 0xe4}: "UdfDxe",
		efi.GUID{0xb0, 0x14, 0xed, 0x4f, 0x0c, 0x2b, 0x20, 0x4e, 0x90, 0x71, 0x61, 0x09, 0x4b, 0x1c, 0x4b, 0x55}: "EzFlashInterfaceWrapper",
		efi.GUID{0xb0, 0x16, 0xaf, 0x59, 0x1d, 0x66, 0x65, 0x48, 0xa3, 0x81, 0x38, 0xde, 0x68, 0x38, 0x5d, 0x8d}: "OpalSecurity",
		efi.GUID{0xb0, 0x1c, 0xd6, 0xc1, 0xb0, 0x78, 0xf0, 0x42, 0xbc, 0x3f, 0xf5, 0x4d, 0xfe, 0xc6, 0x5d, 0xb2}: "PartialMirrorHandler",
		efi.GUID{0xb0, 0x23, 0xe1, 0xb8, 0x3b, 0xf2, 0xa7, 0x49, 0xae, 0x74, 0x7e, 0x16, 0x36, 0xeb, 0x8f, 0x16}: "FjPasswordCtrl",
		efi.GUID{0xb0, 0x2e, 0x9d, 0xd4, 0xd5, 0x44, 0x21, 0x46, 0x9f, 0xd6, 0x1a, 0x92, 0xc9, 0x10, 0x9b, 0x99}: "HiiResourcesSample",
		efi.GUID{0xb0, 0x36, 0x04, 0x34, 0xfa, 0xeb, 0x8a, 0x40, 0x9b, 0x8b, 0x56, 0x5b, 0x1f, 0x77, 0xcf, 0x2c}: "Lpc47N20x",
		efi.GUID{0xb0, 0x38, 0xb0, 0xb9, 0xb6, 0xe2, 0xab, 0x4a, 0x94, 0x35, 0x41, 0x65, 0xec, 0xfe, 0xd0, 0x32}: "AmiTsePasswordPromptExitGuid",
		efi.GUID{0xb0, 0x49, 0xe5, 0x89, 0xa9, 0x21, 0x76, 0x4f, 0x9d, 0xfa, 0x1b, 0x71, 0xe2, 0xa7, 0xc3, 0xf2}: "S3Resume2Pei",
		efi.GUID{0xb0, 0x49, 0xe5, 0x89, 0xfe, 0x7c, 0x9d, 0x44, 0x9b, 0xa3, 0x10, 0xd8, 0xb2, 0x31, 0x2d, 0x71}: "S3Resume2Pei",
		efi.GUID{0xb0, 0x4c, 0x07, 0xef, 0x1a, 0x70, 0x75, 0x49, 0x81, 0xc1, 0x38, 0xf9, 0x21, 0x2b, 0xd0, 0x89}: "AmdMiniRasServiceDxe",
		efi.GUID{0xb0, 0x52, 0xa6, 0xde, 0x87, 0xd5, 0x54, 0x4c, 0xb5, 0xb4, 0xc6, 0x82, 0xe7, 0xa0, 0xaa, 0x3d}: "AcpiS3IdtrProfileGuid",
		efi.GUID{0xb0, 0x52, 0xbd, 0xd7, 0xdc, 0xb2, 0x08, 0x4f, 0xb4, 0x67, 0xde, 0x50, 0xd7, 0x28, 0xf6, 0xbd}: "EfiNbMrcInfo",
		efi.GUID{0xb0, 0x53, 0xd3, 0x42, 0x1e, 0x8c, 0xca, 0x4a, 0xbe, 0xac, 0x28, 0xfb, 0x24, 0xf2, 0x0c, 0x42}: "EfiDxeIpmiUsbTransportProtocol",
		efi.GUID{0xb0, 0x58, 0xde, 0x2a, 0xbd, 0xd2, 0xe7, 0x4a, 0xb9, 0x18, 0xe9, 0xaa, 0xa1, 0xa4, 0x59, 0x85}: "DellThrottlingControlProtocol",
		efi.GUID{0xb0, 0x5b, 0x5a, 0x17, 0x08, 0x15, 0x14, 0x47, 0xa1, 0xcf, 0x34, 0xbd, 0x56, 0xc8, 0x25, 0xdf}: "FjHobFlexIOSave",
		efi.GUID{0xb0, 0x6e, 0x2e, 0x05, 0x40, 0xf2, 0xc5, 0x42, 0x83, 0x09, 0x45, 0x87, 0x45, 0x45, 0xc6, 0xb4}: "BootNowCount",
		efi.GUID{0xb0, 0x7b, 0xd7, 0xe6, 0xd5, 0x34, 0x26, 0x47, 0xbd, 0x29, 0xff, 0xfe, 0x09, 0xe2, 0x6f, 0xb4}: "SwitchableRsteRaidDriver",
		efi.GUID{0xb0, 0x7e, 0x5d, 0xca, 0x67, 0x1b, 0x0b, 0x4b, 0x96, 0x4a, 0xf2, 0xa8, 0x61, 0xf0, 0xd6, 0x40}: "IccOverclockingDxe",
		efi.GUID{0xb0, 0x85, 0xe0, 0xfc, 0x4c, 0x9e, 0x58, 0x40, 0xbb, 0x55, 0x16, 0x76, 0xc7, 0x7c, 0x51, 0xa1}: "DellPolyFuseStringPolicyDxe",
		efi.GUID{0xb0, 0x88, 0x60, 0x29, 0xd7, 0x5a, 0xb7, 0x46, 0xa4, 0x2b, 0x00, 0x4c, 0x2a, 0x0f, 0x00, 0xbb}: "AmdMemSmbiosV2SspPei",
		efi.GUID{0xb0, 0x8a, 0x5f, 0xc9, 0xc2, 0x1b, 0x7c, 0x41, 0x83, 0x77, 0x98, 0x15, 0xf5, 0x78, 0xa9, 0xee}: "UsbOcUpdateDxeExpertWorkStationRP",
		efi.GUID{0xb0, 0x90, 0x9c, 0x07, 0x9c, 0x1b, 0x3c, 0x4c, 0x93, 0x16, 0xef, 0xc7, 0xf6, 0x80, 0xa6, 0x7b}: "PlatformSmbiosDxe",
		efi.GUID{0xb0, 0x9a, 0xe8, 0x41, 0x3d, 0xbd, 0xb6, 0x44, 0xa4, 0x31, 0xe4, 0x83, 0x6e, 0xfb, 0xf2, 0xcb}: "PowerManagement2",
		efi.GUID{0xb0, 0xa0, 0x3e, 0xdc, 0x44, 0xa1, 0x97, 0x47, 0xb5, 0x5b, 0x53, 0xfa, 0x24, 0x2b, 0x6e, 0x1d}: "EfiWheaProcessorSpecificErrorSection",
		efi.GUID{0xb0, 0xa0, 0x3e, 0xdc, 0x44, 0xa1, 0x97, 0x47, 0xb9, 0x5b, 0x53, 0xfa, 0x24, 0x2b, 0x6e, 0x1d}: "EfiProcessorSpecificErrorSectionGuid",
		efi.GUID{0xb0, 0xa6, 0x9e, 0xe5, 0x5b, 0xb0, 0x22, 0x4b, 0x8f, 0x3a, 0x24, 0x2d, 0xcb, 0xe9, 0x04, 0xa2}: "AmdCcxVhRnDxe",
		efi.GUID{0xb0, 0xaa, 0x64, 0x0b, 0x29, 0x54, 0xd4, 0x11, 0x98, 0x16, 0x00, 0xa0, 0xc9, 0x1f, 0xad, 0xcf}: "EfiBisProtocolGuid",
		efi.GUID{0xb0, 0xaf, 0x9e, 0x0a, 0xf9, 0xfa, 0xaa, 0x48, 0x91, 0xf9, 0x6c, 0xca, 0x33, 0x06, 0x12, 0x76}: "BctBaseSmmMDN",
		efi.GUID{0xb0, 0xbe, 0xbf, 0x11, 0x77, 0xfe, 0x62, 0x43, 0x84, 0xfb, 0x4f, 0x96, 0x1e, 0x7b, 0xb2, 0xed}: "H2OFormDialogDxe",
		efi.GUID{0xb0, 0xc2, 0x41, 0x69, 0x44, 0xce, 0x99, 0x40, 0x98, 0x3a, 0x03, 0x91, 0x3b, 0x3d, 0x76, 0x5f}: "EncryptDriver",
		efi.GUID{0xb0, 0xcb, 0xfa, 0x7c, 0x15, 0xb5, 0x70, 0x49, 0xae, 0x98, 0x38, 0xf5, 0x40, 0xe7, 0x34, 0x82}: "H2OVerifyRegionDxe",
		efi.GUID{0xb0, 0xcc, 0x75, 0x4e, 0x53, 0xa6, 0x76, 0x4c, 0xa2, 0x13, 0x5b, 0x2d, 0xbc, 0xd2, 0xa9, 0xef}: "TouchDriver",
		efi.GUID{0xb0, 0xcd, 0x1b, 0xfc, 0x31, 0x7d, 0xaa, 0x49, 0x93, 0x6a, 0xa4, 0x60, 0x0d, 0x9d, 0xd0, 0x83}: "EfiCrc32GuidedSectionExtractionGuid",
		efi.GUID{0xb0, 0xd2, 0x98, 0x36, 0x27, 0xe7, 0x37, 0x45, 0xa6, 0x36, 0xa8, 0x77, 0x07, 0x36, 0xab, 0xfb}: "GetHostByDns",
		efi.GUID{0xb0, 0xd4, 0x27, 0x78, 0x6e, 0x92, 0xf9, 0x48, 0x8a, 0xbd, 0x69, 0x81, 0x6e, 0xf8, 0x6d, 0x16}: "AppleDmgBootDxe",
		efi.GUID{0xb0, 0xd4, 0x9d, 0x0f, 0x9e, 0x59, 0x66, 0x4d, 0x85, 0x65, 0x22, 0xfb, 0xea, 0x1e, 0x02, 0x8c}: "AmdFabricPhxPei",
		efi.GUID{0xb0, 0xd6, 0x2e, 0xfa, 0x06, 0xf6, 0x50, 0x44, 0xb4, 0xf1, 0x4e, 0xd3, 0x4a, 0x17, 0xe0, 0x76}: "MsiBoardDxe",
		efi.GUID{0xb0, 0xdf, 0x46, 0xad, 0xd8, 0x01, 0x84, 0x4d, 0xbb, 0xab, 0x13, 0x59, 0xa9, 0x83, 0xab, 0x9f}: "OemPeim",
		efi.GUID{0xb0, 0xdf, 0x55, 0x52, 0x7c, 0x0e, 0xdc, 0x47, 0x95, 0xa7, 0x0b, 0x83, 0x8d, 0xa0, 0x9b, 0xb0}: "UpiPlatformHooksPeim",
		efi.GUID{0xb0, 0xe4, 0x54, 0xa9, 0x80, 0x03, 0xf6, 0x41, 0x95, 0xc1, 0xb8, 0xad, 0xe5, 0x6c, 0x23, 0x19}: "OemHookPei",
		efi.GUID{0xb0, 0xf6, 0x9d, 0xd7, 0x44, 0xef, 0xbd, 0x43, 0x97, 0x97, 0x43, 0xe9, 0x3b, 0xcf, 0x5f, 0xa8}: "VlanConfigFormSetGuid",
		efi.GUID{0xb0, 0xfa, 0x1b, 0xb8, 0xb3, 0x0e, 0xf9, 0x4c, 0x84, 0x65, 0x7f, 0xa9, 0x86, 0x36, 0x16, 0x64}: "EfiUfsDeviceConfigProtocolGuid",
		efi.GUID{0xb1, 0x0e, 0xcc, 0x97, 0x3b, 0xcd, 0x7a, 0x44, 0x93, 0x19, 0xe3, 0x27, 0x9e, 0xd0, 0x2d, 0x51}: "ShowInSetup",
		efi.GUID{0xb1, 0x14, 0x08, 0xbc, 0xf4, 0xcc, 0x6a, 0x4c, 0xa9, 0x06, 0x9e, 0x08, 0xd5, 0xe1, 0x45, 0x29}: "ODMServiceSmm",
		efi.GUID{0xb1, 0x18, 0xc5, 0x58, 0xf3, 0x76, 0xd4, 0x11, 0xbc, 0xea, 0x00, 0x80, 0xc7, 0x3c, 0x88, 0x81}: "EfiWinNtThunkProtocolGuid",
		efi.GUID{0xb1, 0x20, 0x48, 0x98, 0x76, 0x6d, 0xc2, 0x46, 0x81, 0x46, 0x25, 0xf2, 0x45, 0x66, 0x3d, 0x17}: "EmuPciPei",
		efi.GUID{0xb1, 0x21, 0x0b, 0xa6, 0x00, 0xa2, 0x85, 0x47, 0xa8, 0x6e, 0x51, 0x06, 0xe7, 0x6a, 0x36, 0x04}: "DellDynamicBacklightControlSmm",
		efi.GUID{0xb1, 0x32, 0xca, 0xd4, 0xf2, 0xb1, 0xf3, 0x4f, 0xb4, 0x75, 0x66, 0xe7, 0xb8, 0x19, 0x2a, 0x3b}: "AmiCpuidCksumHob",
		efi.GUID{0xb1, 0x43, 0x83, 0x10, 0x5b, 0x3f, 0x08, 0x49, 0x95, 0x25, 0xe2, 0x5e, 0x62, 0xd5, 0x72, 0x9a}: "LegacyPciUcrDxe",
		efi.GUID{0xb1, 0x4a, 0x8b, 0x78, 0x4f, 0x29, 0xd4, 0x4f, 0xbe, 0xb7, 0x4f, 0x5e, 0x07, 0x09, 0xe9, 0xac}: "DnAPartitionDxe",
		efi.GUID{0xb1, 0x5c, 0xbd, 0xe4, 0x52, 0x94, 0xca, 0x4b, 0xad, 0x8a, 0xc3, 0xed, 0xd7, 0x70, 0xc4, 0x0d}: "HpDimmSpdAccess",
		efi.GUID{0xb1, 0x5c, 0xbd, 0xe4, 0x52, 0x94, 0xca, 0x4b, 0xad, 0x8a, 0xc3, 0xed, 0xd7, 0x70, 0xc4, 0x0e}: "HpThermalDiagnostic",
		efi.GUID{0xb1, 0x5c, 0xbd, 0xe4, 0x52, 0x94, 0xca, 0x4b, 0xad, 0x8a, 0xc3, 0xed, 0xd7, 0x70, 0xc4, 0x0f}: "HpSysDiagsLaunch",
		efi.GUID{0xb1, 0x5c, 0xbd, 0xe4, 0x52, 0x94, 0xca, 0x4b, 0xad, 0x8a, 0xc3, 0xed, 0xd7, 0x70, 0xc4, 0x10}: "HpSmartAdapterStatus",
		efi.GUID{0xb1, 0x5c, 0xbd, 0xe4, 0x52, 0x94, 0xca, 0x4b, 0xad, 0x8a, 0xc3, 0xed, 0xd7, 0x70, 0xc4, 0x11}: "HpDimmId",
		efi.GUID{0xb1, 0x5f, 0x92, 0x94, 0xf4, 0xee, 0xed, 0x41, 0xbd, 0x7a, 0xcd, 0xb0, 0x4a, 0xaa, 0x81, 0xc7}: "DellSbAcpiConfig",
		efi.GUID{0xb1, 0x6b, 0x2d, 0x0e, 0x24, 0xc6, 0x6d, 0x44, 0x99, 0x82, 0x69, 0x3c, 0xd1, 0x81, 0xa6, 0x07}: "EfiSmmTcoDispatchProtocol",
		efi.GUID{0xb1, 0x71, 0x64, 0x35, 0x83, 0xb4, 0xae, 0x42, 0xb6, 0xe7, 0x3b, 0x2e, 0xba, 0xb1, 0x4e, 0x15}: "ServerCommonTokenSpace",
		efi.GUID{0xb1, 0x7a, 0xd3, 0xc6, 0xbb, 0xac, 0x28, 0x49, 0xa9, 0x56, 0x57, 0x7b, 0xb3, 0xdb, 0xb7, 0x51}: "DellDimmLocation",
		efi.GUID{0xb1, 0x7c, 0xee, 0xb1, 0x00, 0x5d, 0x7f, 0x46, 0x9e, 0x60, 0x24, 0xcd, 0x83, 0x41, 0x93, 0x7a}: "SetupLoadDefaultDxe",
		efi.GUID{0xb1, 0x83, 0x73, 0x0e, 0xee, 0x83, 0xa4, 0x41, 0x93, 0x9e, 0x24, 0xc8, 0x86, 0xf0, 0x3a, 0xd6}: "DellVirtRtcSmm",
		efi.GUID{0xb1, 0x88, 0x51, 0x99, 0x96, 0x9f, 0xd4, 0x11, 0x87, 0xae, 0x00, 0x06, 0x29, 0x2e, 0x8a, 0x3b}: "EfiAuthorizationProtocol",
		efi.GUID{0xb1, 0x8b, 0xce, 0x2d, 0xd7, 0xbd, 0x0e, 0x45, 0xb9, 0xad, 0x9c, 0xf4, 0xeb, 0xd4, 0xf8, 0x90}: "EfiEventNotificationTypeCmcGuid",
		efi.GUID{0xb1, 0x8f, 0x86, 0x35, 0x8f, 0x4e, 0x4e, 0x4c, 0x93, 0xb4, 0xf2, 0x29, 0xcd, 0x89, 0xa9, 0x27}: "PxeDriverRt",
		efi.GUID{0xb1, 0x90, 0xee, 0xa7, 0x4a, 0xfb, 0x78, 0x44, 0xb8, 0x68, 0x36, 0x7e, 0xe9, 0xec, 0x97, 0xe2}: "FmpDxe",
		efi.GUID{0xb1, 0x93, 0x60, 0x8a, 0xb8, 0x02, 0x85, 0x46, 0xb2, 0x50, 0x48, 0xca, 0xb3, 0x64, 0xbc, 0xf8}: "FjPeiSetPlatformHardwareSwitch",
		efi.GUID{0xb1, 0x99, 0x64, 0x0f, 0xad, 0xe9, 0x3d, 0x49, 0xb9, 0xc2, 0x2f, 0x90, 0x81, 0x5c, 0x6c, 0xbc}: "EfiPhysicalPresenceGuid",
		efi.GUID{0xb1, 0xa3, 0xf8, 0x0e, 0x8a, 0x38, 0x62, 0x4b, 0x8b, 0xe6, 0xc7, 0x87, 0x7d, 0x50, 0xae, 0xdf}: "UefiPxeBcDxe",
		efi.GUID{0xb1, 0xaa, 0x4e, 0x1e, 0x37, 0xe6, 0x3e, 0x44, 0xa5, 0xd6, 0x56, 0xe6, 0x0d, 0x97, 0xc6, 0x19}: "UsbComboPeimPei",
		efi.GUID{0xb1, 0xb7, 0x8e, 0x2a, 0x13, 0x49, 0x5c, 0x4b, 0xa0, 0xc7, 0xe7, 0x07, 0x91, 0xa7, 0x15, 0xbc}: "SystemMemoryManagerRt",
		efi.GUID{0xb1, 0xcc, 0xba, 0x26, 0x42, 0x6f, 0xd4, 0x11, 0xbc, 0xe7, 0x00, 0x80, 0xc7, 0x3c, 0x88, 0x81}: "EfiCpuArchProtocolGuid",
		efi.GUID{0xb1, 0xd2, 0xf4, 0xbe, 0x3b, 0xc5, 0x33, 0x49, 0xa3, 0xba, 0x2a, 0x42, 0x2c, 0x89, 0xa4, 0x39}: "AmiFriProtocol",
		efi.GUID{0xb1, 0xdd, 0x29, 0x36, 0x8c, 0x22, 0x2e, 0x45, 0xb6, 0x16, 0x09, 0xed, 0x31, 0x6a, 0x97, 0x00}: "EfiPaddingNoneGuid",
		efi.GUID{0xb1, 0xec, 0xaa, 0x0f, 0x6e, 0x22, 0x82, 0x47, 0xaa, 0xce, 0x7d, 0xb9, 0xbc, 0xbf, 0x4d, 0xaf}: "EfiFtp4ServiceBindingProtocolGuid",
		efi.GUID{0xb1, 0xf2, 0xc7, 0x28, 0x0b, 0xb8, 0xeb, 0x4e, 0x8d, 0xc7, 0x0e, 0xa3, 0x49, 0x54, 0x92, 0x6e}: "FjEventLog",
		efi.GUID{0xb1, 0xf6, 0xeb, 0xd7, 0x2c, 0xcb, 0xf6, 0x4e, 0x8e, 0xd5, 0xfb, 0x67, 0x3c, 0x91, 0xdb, 0xe4}: "IntegratedDeviceDxe",
		efi.GUID{0xb2, 0x04, 0xc6, 0xe3, 0x43, 0x5d, 0xad, 0x46, 0xa1, 0xe4, 0xbf, 0x7d, 0x11, 0xb6, 0xaa, 0xc5}: "AmdCcxVhMdnSmm",
		efi.GUID{0xb2, 0x06, 0x87, 0x66, 0xfc, 0xbc, 0xd4, 0x4a, 0xa1, 0x85, 0x75, 0xe7, 0x9f, 0x3f, 0xe1, 0x69}: "NvmeDynamicSetup",
		efi.GUID{0xb2, 0x0c, 0xa0, 0x85, 0x24, 0x29, 0x49, 0x48, 0x95, 0xc4, 0x78, 0x78, 0x52, 0xf0, 0x3f, 0xc7}: "PlatformSmm",
		efi.GUID{0xb2, 0x0e, 0xb5, 0xc4, 0x16, 0xed, 0x83, 0x42, 0xa5, 0xb0, 0xa7, 0x34, 0x1c, 0x3f, 0x99, 0x7b}: "ArmTrustedMonitorLibNull",
		efi.GUID{0xb2, 0x12, 0x06, 0xb4, 0x63, 0xa0, 0xd4, 0x11, 0x9a, 0x3a, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d}: "UsbCbi1Dxe",
		efi.GUID{0xb2, 0x22, 0x70, 0x5d, 0xcf, 0xd3, 0x10, 0x43, 0xac, 0x0a, 0x47, 0x08, 0xdc, 0x4e, 0x54, 0x69}: "IioCxl2SsdtInstallDxe",
		efi.GUID{0xb2, 0x25, 0xe7, 0x7b, 0x6c, 0xf5, 0xc7, 0x41, 0x9f, 0x03, 0x1e, 0x7b, 0x56, 0xb6, 0x59, 0x71}: "SystemUsbMemoryManagerDxe",
		efi.GUID{0xb2, 0x2e, 0x6b, 0xf4, 0xd7, 0xe0, 0x96, 0x4c, 0xa3, 0xb1, 0x0c, 0x61, 0xbb, 0x24, 0x5c, 0x42}: "EdkiiSmmCryptoProtocol",
		efi.GUID{0xb2, 0x2f, 0x14, 0x29, 0xd9, 0x26, 0x3a, 0x4c, 0xa4, 0xba, 0x7b, 0xbd, 0x03, 0x64, 0xee, 0xae}: "BaseSmbusLibNull",
		efi.GUID{0xb2, 0x39, 0x89, 0x92, 0x35, 0x42, 0x2f, 0x46, 0x95, 0x80, 0xf6, 0xa2, 0xb2, 0xc2, 0x1a, 0x4f}: "QemuAcpiTableNotifyProtocol",
		efi.GUID{0xb2, 0x42, 0x73, 0x11, 0x24, 0x98, 0x70, 0x41, 0x8a, 0xfb, 0xe5, 0x68, 0xe6, 0x2c, 0x06, 0x94}: "AmdSsdtPpcvOverride",
		efi.GUID{0xb2, 0x57, 0x79, 0x54, 0x91, 0xd7, 0xff, 0x4c, 0x88, 0x08, 0x80, 0x24, 0x89, 0x7b, 0x4d, 0x98}: "PLX8605PEI",
		efi.GUID{0xb2, 0x58, 0x6f, 0x9a, 0x44, 0x74, 0xba, 0x4e, 0x8f, 0xad, 0xa0, 0x33, 0xef, 0x79, 0xac, 0xdf}: "SecureBIOCamera_Sunplus",
		efi.GUID{0xb2, 0x5d, 0x04, 0xfb, 0x8e, 0x59, 0x5a, 0x48, 0xba, 0x30, 0x5d, 0x7b, 0x1b, 0x1b, 0xd5, 0x4d}: "AOAC",
		efi.GUID{0xb2, 0x5d, 0x22, 0xfd, 0x26, 0x5a, 0x63, 0x42, 0x83, 0x98, 0x71, 0xc3, 0x59, 0x40, 0x4b, 0x85}: "AcerTPM",
		efi.GUID{0xb2, 0x5d, 0x4e, 0xc7, 0x96, 0xfa, 0xe2, 0x4a, 0xb3, 0x99, 0x15, 0x97, 0x7f, 0xe3, 0x00, 0x2d}: "EfiSpiHcProtocolGuid",
		efi.GUID{0xb2, 0x60, 0x17, 0x51, 0x7d, 0xe4, 0xb4, 0x44, 0x83, 0x66, 0x0f, 0x2c, 0xd3, 0xbc, 0x1d, 0x38}: "DellSmmRadioDeviceProtocol",
		efi.GUID{0xb2, 0x62, 0x39, 0x2f, 0xc5, 0x57, 0xec, 0x44, 0x9e, 0xfc, 0xa6, 0x9f, 0xd3, 0x02, 0x03, 0x2b}: "TopOfTemporaryRamPpiGuid",
		efi.GUID{0xb2, 0x64, 0xe0, 0x40, 0xe0, 0x0a, 0xb1, 0x48, 0xa0, 0x7d, 0xf8, 0xcf, 0x1e, 0x1a, 0x23, 0x10}: "EfiNetworkPkgTokenSpaceGuid",
		efi.GUID{0xb2, 0x74, 0x5a, 0x3f, 0x80, 0xbf, 0x50, 0x48, 0x85, 0x91, 0x4f, 0x2d, 0xf5, 0xf9, 0xcb, 0x2b}: "PhoenixGdiProtocolGuid",
		efi.GUID{0xb2, 0x74, 0x60, 0x33, 0x13, 0x2a, 0xcd, 0x46, 0xb4, 0x58, 0xfd, 0x4a, 0xeb, 0xba, 0x28, 0xa9}: "AmiGlkCpuPkgTokenSpaceGuid",
		efi.GUID{0xb2, 0x76, 0x5c, 0x6d, 0x6d, 0x3b, 0xce, 0x43, 0x94, 0xe2, 0x0d, 0x6f, 0xd2, 0xa6, 0x3b, 0xc8}: "RtkUsbUndiDxe",
		efi.GUID{0xb2, 0x79, 0x7c, 0x37, 0x40, 0x1a, 0x1e, 0x44, 0xb6, 0xf5, 0xa1, 0x70, 0xe3, 0x75, 0x37, 0x25}: "LenovoTpmMeasureDxe",
		efi.GUID{0xb2, 0x7f, 0xac, 0xb8, 0x11, 0x42, 0x2b, 0x4c, 0xb6, 0x2f, 0x50, 0x44, 0x21, 0x66, 0x6c, 0x87}: "RngTest",
		efi.GUID{0xb2, 0x84, 0x24, 0x77, 0x82, 0x74, 0x91, 0x4b, 0x9f, 0x9a, 0xad, 0x43, 0xf8, 0x1c, 0x58, 0x81}: "EfiMiscSubClassGuid",
		efi.GUID{0xb2, 0x92, 0x4a, 0x08, 0x6a, 0x03, 0x4c, 0x41, 0xad, 0xea, 0x62, 0x0a, 0xcf, 0x54, 0x76, 0x64}: "RasMiscDxe",
		efi.GUID{0xb2, 0x9e, 0xde, 0x27, 0xb4, 0x73, 0xb2, 0x43, 0xab, 0xd0, 0xe8, 0x7a, 0x59, 0x65, 0x42, 0x4e}: "HddStandBySmm",
		efi.GUID{0xb2, 0x9e, 0xe6, 0xc3, 0x29, 0x04, 0xd6, 0x4b, 0xae, 0x4a, 0x8c, 0xa0, 0x2f, 0xba, 0xcc, 0x2e}: "AdvancedAcpiDxe",
		efi.GUID{0xb2, 0x9f, 0x88, 0x47, 0x71, 0xd6, 0xab, 0x4f, 0xa0, 0xca, 0xdf, 0x0e, 0x44, 0xdf, 0x70, 0xd6}: "EfiPkcs7VerifyProtocolGuid",
		efi.GUID{0xb2, 0xa0, 0xec, 0xc4, 0x77, 0x52, 0x2b, 0x4f, 0x3e, 0xcb, 0xe4, 0x17, 0x5c, 0x94, 0x81, 0x2e}: "ExtraS3Memory",
		efi.GUID{0xb2, 0xad, 0x08, 0x97, 0xb1, 0x28, 0xf7, 0x46, 0x9a, 0x6c, 0xe7, 0x44, 0x97, 0xfa, 0x66, 0x79}: "EfiSdioProtocol",
		efi.GUID{0xb2, 0xae, 0x3a, 0x29, 0xb4, 0x73, 0xb2, 0x43, 0xab, 0xd0, 0xe8, 0x7a, 0x59, 0x65, 0x42, 0x4e}: "AltModeSxSmi",
		efi.GUID{0xb2, 0xb1, 0x6f, 0xc5, 0x7b, 0x01, 0x84, 0x49, 0xa3, 0xf6, 0x3f, 0x73, 0x4f, 0xfa, 0x9e, 0x33}: "EfiUdpProtocol",
		efi.GUID{0xb2, 0xcc, 0x26, 0x44, 0x84, 0xe6, 0x8a, 0x4a, 0xae, 0x40, 0x20, 0xd4, 0xb0, 0x25, 0xb7, 0x10}: "EfiPeiS3ResumePpiGuid",
		efi.GUID{0xb2, 0xcc, 0xba, 0x26, 0x42, 0x6f, 0xd4, 0x11, 0xbc, 0xe7, 0x00, 0x80, 0xc7, 0x3c, 0x88, 0x81}: "EfiMetronomeArchProtocolGuid",
		efi.GUID{0xb2, 0xd0, 0x66, 0xe6, 0x77, 0xe2, 0x2b, 0x7f, 0xbe, 0xcb, 0xe7, 0xd7, 0x5c, 0x9a, 0x81, 0x2e}: "SvrNbDxe",
		efi.GUID{0xb2, 0xd0, 0xec, 0xe4, 0x77, 0xe2, 0x2b, 0x4f, 0xbe, 0xcb, 0xe4, 0xd7, 0x5c, 0x9a, 0x81, 0x2e}: "NbDxe",
		efi.GUID{0xb2, 0xd3, 0x8b, 0xb9, 0x40, 0xec, 0x26, 0x48, 0x95, 0x47, 0x16, 0xdc, 0xb6, 0xbf, 0xa6, 0x0a}: "DellBcRcvExtractor",
		efi.GUID{0xb2, 0xd3, 0xb1, 0xe5, 0x64, 0x5e, 0x72, 0x49, 0x86, 0xe1, 0x7d, 0x38, 0xfb, 0x9d, 0x61, 0xeb}: "OemSmi",
		efi.GUID{0xb2, 0xd9, 0x05, 0x73, 0xae, 0x95, 0x50, 0x42, 0xbd, 0x78, 0x39, 0x6c, 0x3b, 0x6a, 0xc2, 0xee}: "RecoveryImageReadWriteV2",
		efi.GUID{0xb2, 0xef, 0x83, 0x86, 0xe1, 0xfd, 0xff, 0x4a, 0xb2, 0xdb, 0xe9, 0x64, 0x49, 0xfd, 0xd4, 0xe9}: "S3Pei",
		efi.GUID{0xb2, 0xfb, 0x48, 0xaa, 0x87, 0x9f, 0xfd, 0x4d, 0xb4, 0x16, 0x57, 0x59, 0x38, 0xf0, 0xc8, 0xf4}: "PropertiesTableAttributesDxe",
		efi.GUID{0xb3, 0x03, 0x3b, 0x37, 0x22, 0xd3, 0x3d, 0x42, 0x94, 0xe6, 0x26, 0x74, 0xa7, 0x21, 0x5b, 0xe3}: "FjGabiFlashCommonDeRegionCtrlDxe",
		efi.GUID{0xb3, 0x0c, 0x79, 0xd3, 0x90, 0xa8, 0x5a, 0x4a, 0xa4, 0x2e, 0xec, 0xb6, 0xb1, 0x40, 0xd8, 0x14}: "UHESerial",
		efi.GUID{0xb3, 0x0c, 0x9b, 0x79, 0xfd, 0xf2, 0x71, 0x45, 0x85, 0x22, 0x29, 0x53, 0x6e, 0xfe, 0x30, 0xbf}: "SystemEventLogSmm",
		efi.GUID{0xb3, 0x0f, 0xc4, 0x8e, 0x05, 0x42, 0x57, 0x4d, 0x90, 0x39, 0xa1, 0x92, 0x83, 0x2c, 0x7c, 0xed}: "DellEcConfigDxe",
		efi.GUID{0xb3, 0x13, 0x1d, 0x6d, 0x74, 0x88, 0x92, 0x4e, 0xae, 0xd5, 0x22, 0xfc, 0x7c, 0x4f, 0x73, 0x91}: "BiosGuardDxe",
		efi.GUID{0xb3, 0x17, 0x8c, 0x66, 0x21, 0x7e, 0x29, 0x42, 0xa0, 0x72, 0x29, 0x36, 0xf4, 0x14, 0xd7, 0x3d}: "LEMRomLayoutDxe",
		efi.GUID{0xb3, 0x17, 0x9d, 0x4b, 0xc9, 0x4d, 0xd9, 0x45, 0x8f, 0x06, 0xbd, 0xd3, 0xf9, 0xa4, 0x5e, 0x5c}: "AmdI2c3MasterDxe",
		efi.GUID{0xb3, 0x22, 0x21, 0xda, 0x4c, 0x45, 0x21, 0x43, 0x8f, 0x43, 0x8a, 0x61, 0x0a, 0xff, 0xeb, 0x80}: "PspResumeServicesSmm",
		efi.GUID{0xb3, 0x2a, 0xc1, 0x0a, 0x33, 0xdd, 0x60, 0x44, 0x87, 0xf5, 0x82, 0x69, 0x4d, 0x3d, 0x74, 0x02}: "SmcOFBDNull",
		efi.GUID{0xb3, 0x32, 0xca, 0xd4, 0xfe, 0xb1, 0xf7, 0x4f, 0xb0, 0x73, 0x60, 0xed, 0xbb, 0x16, 0x22, 0x33}: "AmiDimmSpdDataHob",
		efi.GUID{0xb3, 0x37, 0x06, 0xb4, 0x70, 0x42, 0x2f, 0x4d, 0xb2, 0xb5, 0xd4, 0x1c, 0xfc, 0x4e, 0x0a, 0x56}: "CapsuleSmi",
		efi.GUID{0xb3, 0x44, 0x4e, 0xab, 0x86, 0x17, 0xcb, 0x4b, 0xbb, 0x8f, 0x98, 0xc3, 0x49, 0x14, 0x0d, 0x69}: "FchHuashanSsdt",
		efi.GUID{0xb3, 0x58, 0x97, 0x60, 0x0c, 0xda, 0xab, 0x4c, 0x84, 0xf0, 0x79, 0x3e, 0x84, 0x34, 0xc5, 0x7c}: "AcerProductInfoDxe",
		efi.GUID{0xb3, 0x60, 0xc9, 0x09, 0x83, 0xda, 0xbe, 0x47, 0xbb, 0xc4, 0x81, 0x26, 0x7b, 0xa9, 0xb0, 0x02}: "FlashBootFlag",
		efi.GUID{0xb3, 0x67, 0xb6, 0x1e, 0xd6, 0x3d, 0x19, 0x4f, 0xba, 0x60, 0x7c, 0x46, 0x38, 0xac, 0x40, 0x62}: "AcerPortingDxe",
		efi.GUID{0xb3, 0x68, 0xb4, 0x88, 0x8b, 0xa4, 0x87, 0x4b, 0xab, 0xe2, 0x8e, 0x56, 0xdf, 0xfd, 0xaf, 0x8d}: "DualBiosSMM",
		efi.GUID{0xb3, 0x6e, 0x2b, 0xcd, 0x11, 0xea, 0x48, 0x48, 0xb6, 0x87, 0xaf, 0xe5, 0x7d, 0x3d, 0x1c, 0x0f}: "ApplePpiPlatformInfoDB",
		efi.GUID{0xb3, 0x84, 0x0f, 0x39, 0x1c, 0x22, 0x9e, 0x4d, 0xb5, 0x06, 0x6d, 0xb9, 0x42, 0x3e, 0x0a, 0x7e}: "ShellHttpHii",
		efi.GUID{0xb3, 0x86, 0x0b, 0xf5, 0x2f, 0x13, 0x98, 0x49, 0xb3, 0x86, 0x2d, 0x49, 0xdc, 0xb7, 0x92, 0x50}: "AsusTCG2DxeSetupItem",
		efi.GUID{0xb3, 0x86, 0xfd, 0x79, 0x4f, 0xd7, 0x6f, 0x4d, 0x95, 0x77, 0xfb, 0xe0, 0x62, 0x97, 0x70, 0x86}: "SerialDebugInitDxe",
		efi.GUID{0xb3, 0x89, 0xa0, 0x23, 0xd5, 0xee, 0xc5, 0x4a, 0xb2, 0xab, 0x43, 0xe3, 0x29, 0x8c, 0x23, 0x43}: "VariableSmm",
		efi.GUID{0xb3, 0x8f, 0xe8, 0x7c, 0xd7, 0x4b, 0x79, 0x46, 0x87, 0xa8, 0xa8, 0xd8, 0xde, 0xe5, 0x0d, 0x2b}: "EfiEventReadyToBootGuid",
		efi.GUID{0xb3, 0x93, 0xc0, 0x5f, 0x00, 0x94, 0x36, 0x4d, 0xb3, 0x4f, 0x4e, 0xeb, 0x07, 0xaa, 0x65, 0xd4}: "PciDxeInit",
		efi.GUID{0xb3, 0x99, 0xda, 0x03, 0xf4, 0xdd, 0x7e, 0x4c, 0x8c, 0xca, 0x21, 0x6f, 0xc3, 0xf1, 0xf3, 0x11}: "BaseFspSecPlatformLibNull",
		efi.GUID{0xb3, 0xaf, 0x25, 0x43, 0x11, 0x9f, 0xc7, 0x42, 0xa2, 0x93, 0x94, 0xaa, 0xe3, 0x80, 0x49, 0x42}: "FjUpdateSystemInfoDxe",
		efi.GUID{0xb3, 0xb2, 0xde, 0xe9, 0xe4, 0x88, 0xd2, 0x46, 0xb9, 0xa4, 0xf6, 0x0c, 0xac, 0xb9, 0x18, 0xdc}: "SmcRiserCardPei",
		efi.GUID{0xb3, 0xc5, 0x18, 0x1f, 0xed, 0x29, 0x9e, 0x4d, 0xa5, 0x04, 0x6d, 0x97, 0x8e, 0x7e, 0xd5, 0x69}: "QncS3CodeInLockBoxGuid",
		efi.GUID{0xb3, 0xc5, 0x69, 0x68, 0x8d, 0xac, 0x73, 0x49, 0x8b, 0x37, 0xe3, 0x54, 0xdb, 0xf3, 0x4a, 0xdd}: "CmosManagerSmm",
		efi.GUID{0xb3, 0xcc, 0xba, 0x26, 0x42, 0x6f, 0xd4, 0x11, 0xbc, 0xe7, 0x00, 0x80, 0xc7, 0x3c, 0x88, 0x81}: "EfiTimerArchProtocolGuid",
		efi.GUID{0xb3, 0xd0, 0x55, 0xf6, 0x5d, 0x61, 0x22, 0x40, 0x96, 0x45, 0x0d, 0x1f, 0x2e, 0x9d, 0xf7, 0x8a}: "CompalCMFCOEMSwSmi",
		efi.GUID{0xb3, 0xd6, 0xd5, 0xcf, 0x21, 0x3c, 0x15, 0x4f, 0xb0, 0xe8, 0x08, 0x8f, 0x01, 0x28, 0x89, 0x0d}: "OemInt15CallbackSmm",
		efi.GUID{0xb3, 0xdc, 0xae, 0xa2, 0x80, 0x80, 0x3f, 0x4c, 0xb4, 0x14, 0x7a, 0x05, 0xd2, 0x5e, 0x06, 0x99}: "DellNtfsDxe",
		efi.GUID{0xb3, 0xdd, 0x65, 0xe0, 0xfa, 0x8d, 0xe0, 0x4c, 0xa1, 0x59, 0x11, 0xd7, 0xb6, 0xfe, 0xa5, 0x89}: "DellHwmIoSmm",
		efi.GUID{0xb3, 0xe0, 0x46, 0x02, 0xea, 0xe8, 0x03, 0x4e, 0xb2, 0xa5, 0x39, 0xfa, 0x93, 0x7f, 0xd1, 0x22}: "SsidPei",
		efi.GUID{0xb3, 0xf0, 0xde, 0x0e, 0x91, 0xef, 0x35, 0x49, 0x85, 0x9e, 0x23, 0x38, 0xdf, 0xfa, 0xc0, 0x99}: "MpdtUpdateDxe",
		efi.GUID{0xb3, 0xf1, 0x5c, 0x90, 0xf8, 0x32, 0x9c, 0x48, 0xa6, 0x41, 0x46, 0xa7, 0x14, 0x58, 0x32, 0x62}: "PcieErrorEnable",
		efi.GUID{0xb3, 0xf2, 0x8c, 0xb8, 0xce, 0x5c, 0x2c, 0x48, 0x8d, 0xb4, 0x6f, 0x32, 0x9a, 0x73, 0xbd, 0x6d}: "Rtk8156UsbUndiDxe",
		efi.GUID{0xb3, 0xf8, 0xf3, 0x1c, 0xb1, 0xc5, 0xa2, 0x49, 0xaa, 0x59, 0x5e, 0xef, 0x92, 0xff, 0xa6, 0x3c}: "EfiIa32X64ErrorTypeBusCheckGuid",
		efi.GUID{0xb3, 0xfa, 0x2a, 0x19, 0xf8, 0x55, 0xb8, 0x44, 0xb4, 0x9e, 0x27, 0x5a, 0x9d, 0xfd, 0xd0, 0x3f}: "SetupFunction",
		efi.GUID{0xb4, 0x03, 0x16, 0x08, 0x1d, 0x0f, 0x22, 0x40, 0xb6, 0xfd, 0x4c, 0xe3, 0x5e, 0x09, 0xa1, 0xa6}: "EfiUnixNetwork",
		efi.GUID{0xb4, 0x05, 0x62, 0x72, 0x4d, 0x2e, 0x06, 0x46, 0x99, 0x8b, 0x6b, 0x2a, 0x3e, 0x88, 0x58, 0xe4}: "DellWBootCapsuleProtocol",
		efi.GUID{0xb4, 0x0d, 0xc6, 0xf8, 0x27, 0xd4, 0x6e, 0x43, 0xaf, 0x93, 0x5f, 0xcc, 0xda, 0x0d, 0xa3, 0x7b}: "DellThermInfoConfigSmm",
		efi.GUID{0xb4, 0x2f, 0x15, 0xef, 0x2f, 0x7b, 0x7d, 0x42, 0xbd, 0xb4, 0x7e, 0x0a, 0x05, 0x82, 0x6e, 0x64}: "BootFlowVariable",
		efi.GUID{0xb4, 0x2f, 0x23, 0x70, 0xf4, 0x81, 0xf6, 0x49, 0xaa, 0x05, 0x51, 0xd9, 0x9e, 0xbd, 0xc3, 0x52}: "PciPlatform",
		efi.GUID{0xb4, 0x37, 0x30, 0x36, 0x19, 0x1e, 0xf1, 0x4a, 0xaa, 0x61, 0x6f, 0xc8, 0xc0, 0x1a, 0x42, 0x7e}: "BoardUpdateAcpiDxe",
		efi.GUID{0xb4, 0x3c, 0x52, 0x5e, 0x97, 0xd3, 0x86, 0x49, 0x87, 0xbd, 0xa6, 0xdd, 0x8b, 0x22, 0xf4, 0x55}: "AtaAtapiPassThruDxe",
		efi.GUID{0xb4, 0x4c, 0xb1, 0x24, 0x4a, 0xa1, 0x9a, 0x4e, 0xaa, 0xd2, 0x85, 0x33, 0x35, 0xfa, 0x32, 0x97}: "AmdCpmModernStandbyFeatureDxe",
		efi.GUID{0xb4, 0x4e, 0x72, 0x8e, 0x14, 0xf3, 0x7a, 0x49, 0x84, 0xf3, 0x36, 0x7a, 0x47, 0xe6, 0x09, 0x10}: "DellIoExpanderDxe",
		efi.GUID{0xb4, 0x52, 0xd6, 0x3c, 0x33, 0x6d, 0xce, 0x4d, 0x89, 0xdb, 0x83, 0xdf, 0x97, 0x66, 0xfc, 0xca}: "EfiVectorHandoffInfoPpiGuid",
		efi.GUID{0xb4, 0x56, 0x71, 0xb0, 0x47, 0x59, 0x85, 0x48, 0xa3, 0xed, 0xfb, 0x1d, 0xfa, 0x94, 0x9a, 0xe4}: "PdHostInterfaceItePei",
		efi.GUID{0xb4, 0x58, 0x23, 0x2d, 0x6c, 0xe9, 0x4d, 0x48, 0xb2, 0xdd, 0x7c, 0x2e, 0xdf, 0xc7, 0xd5, 0x6f}: "ConsolePrefFormSet",
		efi.GUID{0xb4, 0x61, 0x93, 0x6d, 0x34, 0xb5, 0x25, 0x4c, 0x99, 0xd3, 0x1f, 0x12, 0xc6, 0x79, 0x4e, 0x8e}: "IioRasInit",
		efi.GUID{0xb4, 0x63, 0x3c, 0xc5, 0xc1, 0x39, 0x85, 0x41, 0xbc, 0x9b, 0x0f, 0xe9, 0x72, 0x2a, 0x0c, 0x60}: "SmrrEnableHobGuid",
		efi.GUID{0xb4, 0x6a, 0x7a, 0x9a, 0xa6, 0x9d, 0xa4, 0x4a, 0x90, 0xcb, 0x6d, 0x4b, 0x79, 0xed, 0xa7, 0xb9}: "HashInstanceLibSha1",
		efi.GUID{0xb4, 0x70, 0xca, 0xf8, 0x85, 0x6a, 0x16, 0x46, 0x8b, 0xde, 0x3e, 0xc5, 0x69, 0x64, 0x4a, 0xc3}: "LenovoW25Q32FlashPartSmm",
		efi.GUID{0xb4, 0x75, 0x0e, 0x6c, 0xb9, 0xb0, 0xd1, 0x44, 0x82, 0x10, 0x33, 0x77, 0xd7, 0xb4, 0xe0, 0x66}: "SmmAccessPei",
		efi.GUID{0xb4, 0x87, 0x22, 0x10, 0x12, 0x6b, 0x41, 0x4d, 0x91, 0xe1, 0xeb, 0xee, 0x1f, 0x3a, 0xa6, 0x14}: "UefiDebugLibDebugPortProtocol",
		efi.GUID{0xb4, 0x94, 0xb1, 0x22, 0x0e, 0xcc, 0xc7, 0x46, 0x9f, 0xce, 0xda, 0x10, 0xd6, 0xed, 0x17, 0x31}: "PchSmbusArpEnabled",
		efi.GUID{0xb4, 0x94, 0xc8, 0x95, 0xec, 0xda, 0xe1, 0x46, 0x86, 0x00, 0x3c, 0x4c, 0x7f, 0xc9, 0x85, 0xd6}: "BiosGuardRecovery",
		efi.GUID{0xb4, 0x96, 0x1d, 0xd2, 0xc6, 0x20, 0x30, 0x4f, 0x8e, 0x82, 0x67, 0x01, 0x48, 0x5b, 0x10, 0x49}: "DellLomPolicy",
		efi.GUID{0xb4, 0x96, 0xeb, 0x4b, 0x69, 0xc0, 0x49, 0x4c, 0x84, 0x5f, 0x1c, 0x1c, 0xc6, 0x8c, 0xd8, 0xd6}: "FchShastaSsdt",
		efi.GUID{0xb4, 0x97, 0x1e, 0x26, 0xb5, 0xfb, 0xb1, 0x4d, 0xb2, 0x5c, 0x13, 0x27, 0x0b, 0xa7, 0xbb, 0x60}: "EmulatedEepromDxe",
		efi.GUID{0xb4, 0x9b, 0x70, 0xd3, 0x94, 0xb1, 0x71, 0x4b, 0xb9, 0xc0, 0xdb, 0xd8, 0xd2, 0xda, 0x97, 0xad}: "IntelIchLegacyInterruptDxe",
		efi.GUID{0xb4, 0xa8, 0x65, 0xae, 0xa3, 0x05, 0xfc, 0x4c, 0xa4, 0x86, 0xf3, 0x14, 0x9a, 0xa3, 0x4b, 0xc0}: "DellMfgModeDxe",
		efi.GUID{0xb4, 0xa8, 0xaa, 0xf9, 0xa4, 0xb4, 0xdc, 0x4a, 0x9e, 0x28, 0x29, 0xca, 0xd2, 0x22, 0xe1, 0x5a}: "FjSysmanAmphion",
		efi.GUID{0xb4, 0xae, 0x5d, 0x9e, 0x91, 0x4b, 0x66, 0x44, 0x9e, 0xbe, 0x81, 0xc7, 0xe4, 0x40, 0x1e, 0x6d}: "H2OFormBrowserDxe",
		efi.GUID{0xb4, 0xb0, 0xda, 0x69, 0xd9, 0x5f, 0xec, 0x4f, 0xaa, 0x30, 0x29, 0x8d, 0x2b, 0x5a, 0x34, 0x2e}: "DellFormBrowser3",
		efi.GUID{0xb4, 0xc4, 0x63, 0x38, 0x58, 0xad, 0x83, 0x43, 0xab, 0x89, 0x0e, 0x0b, 0x76, 0x8d, 0xdb, 0x70}: "AplLayoutParsing",
		efi.GUID{0xb4, 0xc5, 0x92, 0xce, 0xb3, 0x14, 0xe1, 0x4a, 0xa2, 0x74, 0x3f, 0xfe, 0x74, 0xa5, 0xad, 0xc1}: "KEMoSetup",
		efi.GUID{0xb4, 0xcd, 0xb4, 0x72, 0x97, 0xb2, 0x47, 0x47, 0xb1, 0xba, 0x5a, 0x48, 0x39, 0xd3, 0x32, 0xae}: "AmdFabricRnSmm",
		efi.GUID{0xb4, 0xd0, 0xb9, 0xb9, 0x5c, 0xe6, 0x0f, 0x40, 0x90, 0xd5, 0x07, 0x29, 0x01, 0x2f, 0x32, 0xe2}: "DefaultsAndWmi",
		efi.GUID{0xb4, 0xd8, 0x62, 0xac, 0x8f, 0x3e, 0xd2, 0x4e, 0x9a, 0xd6, 0xdc, 0xea, 0xa1, 0xcb, 0x96, 0xa3}: "DataAccessSupport",
		efi.GUID{0xb4, 0xdd, 0x87, 0xd4, 0x8b, 0x00, 0xd9, 0x11, 0xaf, 0xdc, 0x00, 0x10, 0x83, 0xff, 0xca, 0x4d}: "EfiSasDevicePathGuid",
		efi.GUID{0xb4, 0xe6, 0x1d, 0x80, 0x36, 0x20, 0xb7, 0x46, 0xb8, 0xf7, 0x79, 0x20, 0x5c, 0xbd, 0x17, 0x72}: "SmartCoverPortingPei",
		efi.GUID{0xb4, 0xee, 0x20, 0x58, 0x35, 0xc1, 0x54, 0x48, 0x9d, 0x2a, 0xaa, 0x9e, 0xfc, 0x44, 0x75, 0xe9}: "MeFwDowngrade",
		efi.GUID{0xb4, 0xf6, 0x08, 0x4f, 0x0b, 0x64, 0x54, 0x4f, 0x84, 0x0f, 0xf2, 0x25, 0xbd, 0x00, 0xb9, 0xf3}: "SpiFvbServiceDxe",
		efi.GUID{0xb4, 0xf6, 0xe6, 0x73, 0x29, 0xd0, 0x87, 0x4e, 0x84, 0x05, 0x60, 0x67, 0xc8, 0xbd, 0x02, 0xa6}: "UsbPei",
		efi.GUID{0xb4, 0xf7, 0x38, 0x6b, 0x98, 0xad, 0xe9, 0x40, 0x90, 0x93, 0xac, 0xa2, 0xb5, 0xa2, 0x53, 0xc4}: "DiskIoDxe",
		efi.GUID{0xb4, 0xfd, 0xc9, 0x81, 0x6f, 0x4d, 0x98, 0x4d, 0xb7, 0xb8, 0x6a, 0x9d, 0xaf, 0x67, 0x7e, 0x73}: "D01HddPassword",
		efi.GUID{0xb5, 0x00, 0xd7, 0x3e, 0x13, 0x3a, 0xbe, 0x43, 0x94, 0x50, 0x00, 0x12, 0x2e, 0x8b, 0x83, 0xd7}: "DataHubRecordPolicy",
		efi.GUID{0xb5, 0x08, 0xf3, 0x5c, 0x23, 0xfa, 0x00, 0x41, 0x8a, 0x76, 0xf3, 0x26, 0xc2, 0x81, 0x48, 0x80}: "AmiMeasureCPUMicrocodeGuid",
		efi.GUID{0xb5, 0x12, 0x06, 0x24, 0x63, 0xa0, 0xd4, 0x11, 0x9a, 0x3a, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d}: "IsaBusDxe",
		efi.GUID{0xb5, 0x12, 0x06, 0x24, 0x63, 0xa0, 0xd4, 0x11, 0x9a, 0x3a, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x8e}: "SmmCoreDispatcher",
		efi.GUID{0xb5, 0x19, 0x33, 0xa3, 0xe1, 0x8e, 0xe0, 0x45, 0x8c, 0x9f, 0x80, 0x9f, 0x5b, 0x09, 0x02, 0xcc}: "RsdpPlusProtocol",
		efi.GUID{0xb5, 0x1e, 0x7a, 0xc0, 0x04, 0x5c, 0x00, 0x41, 0x81, 0x7b, 0x0a, 0x11, 0xbb, 0x5f, 0x15, 0xdc}: "CppcDxe",
		efi.GUID{0xb5, 0x1f, 0xb7, 0x55, 0xc6, 0x17, 0x0e, 0x41, 0xb5, 0xbd, 0x5f, 0xa2, 0xe3, 0xd4, 0x46, 0x6b}: "EfiI2cBusConfigurationManagementProtocolGuid",
		efi.GUID{0xb5, 0x2b, 0xd3, 0x29, 0x1b, 0x1d, 0xe0, 0x4d, 0x8a, 0xa9, 0x02, 0xd7, 0x90, 0xca, 0x64, 0x3b}: "PmemResetNotify",
		efi.GUID{0xb5, 0x32, 0x37, 0x68, 0x38, 0x2a, 0xa8, 0x43, 0x9c, 0xe2, 0x02, 0xcd, 0x72, 0x50, 0xdc, 0xd9}: "A01BootDeviceServiceDxe",
		efi.GUID{0xb5, 0x3c, 0x73, 0x1c, 0x8f, 0x4c, 0xd9, 0x44, 0xbb, 0xf0, 0x95, 0x47, 0x70, 0x89, 0xeb, 0x08}: "DellSmBiosStrucDa",
		efi.GUID{0xb5, 0x3f, 0xf3, 0xb5, 0xd5, 0x66, 0x01, 0x49, 0xba, 0xf1, 0xf0, 0xc7, 0x74, 0xfc, 0x65, 0x88}: "VgaDriverPolicyDxe",
		efi.GUID{0xb5, 0x42, 0xea, 0x5a, 0xe1, 0x31, 0x15, 0x45, 0xbc, 0x31, 0xb8, 0xd5, 0x25, 0x75, 0x65, 0xa6}: "EfiExtendedSalBaseIoServicesProtocolGuid",
		efi.GUID{0xb5, 0x49, 0xf1, 0xec, 0x4e, 0xbf, 0xc8, 0x4a, 0x8a, 0x8c, 0xce, 0x87, 0xcb, 0xac, 0x93, 0xd3}: "EfiSiliconRcHobsReadyPpi",
		efi.GUID{0xb5, 0x4b, 0x42, 0xa2, 0x41, 0x54, 0xfe, 0x4e, 0xa6, 0x08, 0x2c, 0xcd, 0x60, 0x82, 0x4c, 0x06}: "NvVariableFailDetectPei",
		efi.GUID{0xb5, 0x4d, 0xd1, 0xf5, 0x0c, 0x2f, 0x11, 0x46, 0x9d, 0xdc, 0x7c, 0x18, 0x2b, 0x17, 0x3a, 0x71}: "ProgressBarEmptyRightEndcap",
		efi.GUID{0xb5, 0x53, 0xf2, 0x9b, 0x62, 0xb5, 0xfc, 0x4e, 0x98, 0x91, 0x50, 0xb3, 0x22, 0xbe, 0x76, 0x6c}: "AddSmbiosForNFA765",
		efi.GUID{0xb5, 0x59, 0xe1, 0x0f, 0x6f, 0x07, 0x36, 0x4c, 0xbf, 0x26, 0xd7, 0x24, 0xf2, 0x83, 0x12, 0x52}: "BdsCtrl",
		efi.GUID{0xb5, 0x5b, 0x4b, 0xcb, 0xa6, 0x59, 0xba, 0x48, 0xa7, 0x7b, 0xb4, 0xe4, 0xb3, 0xd4, 0x91, 0xeb}: "OemDxeWwan",
		efi.GUID{0xb5, 0x5b, 0x96, 0x38, 0x97, 0x80, 0xf5, 0x40, 0xb7, 0x42, 0x8c, 0xc1, 0x4a, 0x64, 0x9b, 0x64}: "AmiPeiSbCustomPpiGuid",
		efi.GUID{0xb5, 0x69, 0xdc, 0x2f, 0xec, 0x45, 0x84, 0x42, 0xae, 0xe2, 0x0f, 0x9d, 0xe8, 0x5a, 0xe9, 0xa5}: "AmiQrCode",
		efi.GUID{0xb5, 0x6f, 0x53, 0xb4, 0x51, 0xe2, 0xda, 0x4e, 0x8b, 0xcf, 0xd4, 0x38, 0x75, 0xbd, 0x1a, 0x11}: "GnbRenoirRouting",
		efi.GUID{0xb5, 0x6f, 0x53, 0xb4, 0x51, 0xe2, 0xda, 0x4e, 0x8b, 0xcf, 0xd4, 0x38, 0x75, 0xbd, 0x1a, 0x37}: "GnbRavenRouting",
		efi.GUID{0xb5, 0x71, 0x90, 0xf1, 0xf6, 0xb2, 0x9c, 0x4a, 0xb2, 0xe2, 0xfb, 0xf5, 0x6d, 0xa5, 0xb2, 0x29}: "AmdMemChanXLatZpPei",
		efi.GUID{0xb5, 0x72, 0x0f, 0x3c, 0x1e, 0xd5, 0xc8, 0x40, 0x90, 0xf1, 0x5a, 0x92, 0x3e, 0x0d, 0x1f, 0x24}: "TpmResiliencyDxe",
		efi.GUID{0xb5, 0x72, 0x2f, 0xc9, 0xd0, 0x7d, 0x15, 0x4e, 0x9d, 0x2c, 0xa5, 0x2c, 0xbd, 0x30, 0xca, 0x1e}: "LenovoSmpManagerDxe",
		efi.GUID{0xb5, 0x81, 0xce, 0x57, 0x95, 0xb9, 0x03, 0x47, 0xa4, 0x2a, 0x87, 0x74, 0xa3, 0x53, 0xe5, 0xaa}: "AsusRunTimePaysBios",
		efi.GUID{0xb5, 0x8d, 0x4e, 0x63, 0x32, 0xc4, 0xbe, 0x43, 0xa6, 0x53, 0x9c, 0xa2, 0x92, 0x2c, 0xc4, 0x58}: "Nvme",
		efi.GUID{0xb5, 0x95, 0xf1, 0x80, 0xb6, 0xd7, 0x64, 0x4c, 0x84, 0xec, 0x1f, 0x3b, 0xe7, 0x95, 0x75, 0x1d}: "FjPasswordSkipPei",
		efi.GUID{0xb5, 0xa5, 0x29, 0x80, 0x88, 0x40, 0xd2, 0x48, 0x96, 0xe0, 0xf7, 0x05, 0x2b, 0xc0, 0xa8, 0x42}: "PttHciSmm",
		efi.GUID{0xb5, 0xa6, 0x67, 0x6e, 0xef, 0x84, 0x26, 0x4f, 0x90, 0x2f, 0xe5, 0x08, 0xd8, 0xf3, 0xf1, 0xaf}: "AmdMemCzPei",
		efi.GUID{0xb5, 0xad, 0x21, 0x8e, 0x93, 0x0b, 0x5b, 0x46, 0xbe, 0x61, 0x17, 0x25, 0xde, 0x06, 0xc2, 0xac}: "EXT",
		efi.GUID{0xb5, 0xb1, 0x72, 0xfd, 0x91, 0x53, 0x6a, 0x4c, 0xbd, 0xfd, 0x9f, 0x59, 0xa7, 0x88, 0x0a, 0x21}: "PlatformRelatedInfoGuid",
		efi.GUID{0xb5, 0xb2, 0x74, 0x01, 0x05, 0xf5, 0x12, 0x4b, 0xaa, 0x60, 0x59, 0xdf, 0xf8, 0xd6, 0xea, 0x37}: "ShellNetwork2HiiGuid",
		efi.GUID{0xb5, 0xb3, 0x88, 0x0c, 0x1d, 0x6a, 0x57, 0x46, 0xaa, 0x88, 0x1b, 0x7d, 0x92, 0xff, 0x36, 0x99}: "CompalCMFCCommonSwSmi",
		efi.GUID{0xb5, 0xcb, 0x38, 0xa8, 0xef, 0x59, 0x93, 0x44, 0x89, 0xd0, 0x13, 0x3c, 0x89, 0x68, 0x90, 0x5d}: "CrbSmbios",
		efi.GUID{0xb5, 0xd5, 0x23, 0x4e, 0x03, 0xbf, 0xe1, 0x4c, 0xb2, 0x95, 0x13, 0xe6, 0x15, 0xd1, 0x3a, 0x61}: "MpmPldmBase",
		efi.GUID{0xb5, 0xde, 0x62, 0x39, 0xf6, 0xfd, 0x29, 0x48, 0x88, 0x9c, 0xd5, 0x44, 0x91, 0x8e, 0x84, 0xd9}: "SmmLegacyRegion",
		efi.GUID{0xb5, 0xe0, 0x47, 0x4c, 0x69, 0xe3, 0x9f, 0x46, 0xb3, 0x59, 0x28, 0xdb, 0xd7, 0x36, 0xa1, 0x31}: "PspSmm",
		efi.GUID{0xb5, 0xe6, 0xb8, 0x00, 0xce, 0x83, 0x8a, 0x44, 0x8a, 0xc6, 0xcc, 0xbc, 0x9d, 0x5f, 0x3b, 0xe3}: "FchTaishanSmmInit",
		efi.GUID{0xb5, 0xea, 0x1d, 0x3b, 0x5d, 0xc7, 0x2e, 0x44, 0x92, 0x38, 0x8e, 0x2f, 0xfb, 0x62, 0xb0, 0xbb}: "UefiPxe4BcDxe",
		efi.GUID{0xb5, 0xf4, 0x72, 0x00, 0xd5, 0x74, 0xc8, 0x4c, 0xaf, 0xf6, 0xcc, 0x94, 0x69, 0xd3, 0x3f, 0x7b}: "UsbMediaCardReaderConfigDxe",
		efi.GUID{0xb6, 0x03, 0x59, 0xc8, 0xb5, 0x84, 0x78, 0x4d, 0xb5, 0x9d, 0xd2, 0xd6, 0xb9, 0x75, 0x80, 0xf3}: "PngConvertDxe",
		efi.GUID{0xb6, 0x0d, 0xfa, 0x4e, 0xdc, 0x26, 0xb1, 0x4b, 0xa7, 0x6f, 0x14, 0xbc, 0x63, 0x0c, 0x7b, 0x3c}: "AmtForcePushPetHob",
		efi.GUID{0xb6, 0x14, 0xfe, 0x17, 0xba, 0x9a, 0xc3, 0x43, 0xbe, 0xb0, 0xd1, 0x2f, 0x81, 0xaa, 0xa8, 0x83}: "AmdCpmDiscreteUSB4Smm",
		efi.GUID{0xb6, 0x19, 0x71, 0xbb, 0x1f, 0xef, 0x56, 0x40, 0x93, 0x21, 0xcf, 0x29, 0xcc, 0x7a, 0x2f, 0xbc}: "I2cPlatformDxe",
		efi.GUID{0xb6, 0x21, 0xed, 0x56, 0x23, 0xba, 0x9e, 0x42, 0x89, 0x32, 0x37, 0x6d, 0x8e, 0x18, 0x2e, 0xe3}: "FspPerformanceDataGuid",
		efi.GUID{0xb6, 0x24, 0x68, 0x82, 0x9b, 0xcc, 0x62, 0x4d, 0x8e, 0x7a, 0x0f, 0xfb, 0xf6, 0x01, 0x3c, 0xbe}: "SmmHeciProtocol",
		efi.GUID{0xb6, 0x2d, 0x09, 0xdc, 0x93, 0x6f, 0x85, 0x4c, 0x96, 0x15, 0x7c, 0x8b, 0x23, 0xd4, 0x8d, 0xb9}: "HpNetworkConfigDriver",
		efi.GUID{0xb6, 0x56, 0x26, 0x15, 0x4b, 0x56, 0x8c, 0x4c, 0x87, 0x7e, 0xb6, 0x7f, 0xb7, 0x0d, 0xfd, 0xdc}: "FjHobFlexIOPresence",
		efi.GUID{0xb6, 0x64, 0x34, 0x01, 0x20, 0xac, 0x86, 0x4e, 0xa2, 0xf9, 0x23, 0xcc, 0x46, 0x50, 0xdd, 0xc2}: "MemoryDiagnostic",
		efi.GUID{0xb6, 0x65, 0x7b, 0x7b, 0x50, 0xe3, 0x39, 0x41, 0x8f, 0xe4, 0x66, 0x57, 0x72, 0xd3, 0x2a, 0x45}: "IhisiSmm",
		efi.GUID{0xb6, 0x65, 0x7b, 0x7b, 0x50, 0xe3, 0x39, 0x41, 0x8f, 0xe4, 0x66, 0x57, 0x72, 0xd3, 0x2a, 0x47}: "IhisiSmm",
		efi.GUID{0xb6, 0x73, 0x0e, 0x22, 0xdb, 0x6b, 0x13, 0x44, 0x84, 0x05, 0xb9, 0x74, 0xb1, 0x08, 0x61, 0x9a}: "EfiFirmwareVolume2ProtocolGuid",
		efi.GUID{0xb6, 0x73, 0x85, 0xb3, 0x00, 0x62, 0xc5, 0x4a, 0xb5, 0x1d, 0x82, 0xe6, 0x59, 0x38, 0xd7, 0x83}: "RecoveryOnFatIdeDiskGuid",
		efi.GUID{0xb6, 0x74, 0x4e, 0xc2, 0x55, 0x41, 0x64, 0x4e, 0x9a, 0x91, 0xc1, 0xe4, 0x4f, 0x5d, 0x0b, 0xbe}: "OemGlobalNvsSmm",
		efi.GUID{0xb6, 0x7b, 0x09, 0x78, 0xcf, 0x48, 0x9b, 0x44, 0x9b, 0xdb, 0xf6, 0x38, 0x49, 0x85, 0x64, 0x60}: "mAmiPpiInternalVarGuid",
		efi.GUID{0xb6, 0x7d, 0x76, 0x09, 0x2a, 0x41, 0xba, 0x45, 0x80, 0x26, 0xf0, 0x87, 0xca, 0xe2, 0x10, 0xe3}: "DTSPolicy",
		efi.GUID{0xb6, 0x8d, 0x9e, 0x0d, 0x5a, 0x5a, 0x5b, 0x4a, 0x86, 0x21, 0x85, 0xff, 0xc9, 0xae, 0x45, 0x83}: "DellStealthModePolicy",
		efi.GUID{0xb6, 0x95, 0x22, 0x2f, 0xb6, 0x1b, 0xb7, 0x4c, 0xbb, 0x9e, 0x15, 0xc2, 0xc3, 0x42, 0x42, 0x77}: "PcieSataController",
		efi.GUID{0xb6, 0x97, 0x4e, 0x32, 0xfa, 0x55, 0x25, 0x4f, 0xb4, 0x0e, 0xee, 0x41, 0x25, 0xfb, 0x12, 0x15}: "IT889XDxe",
		efi.GUID{0xb6, 0x99, 0x0c, 0xef, 0xd3, 0xb1, 0x25, 0x40, 0x94, 0x05, 0xbf, 0x6a, 0x56, 0x0f, 0xe0, 0xe0}: "SmbiosMiscDxe",
		efi.GUID{0xb6, 0x9a, 0xa5, 0x3c, 0xcb, 0x67, 0x85, 0x43, 0x9e, 0xdd, 0x40, 0x7c, 0x49, 0xf0, 0xd9, 0xbc}: "OemBootOsb",
		efi.GUID{0xb6, 0xa9, 0x0f, 0x0c, 0xaf, 0xf3, 0xbd, 0x49, 0x89, 0xc5, 0x6c, 0x2d, 0x43, 0x96, 0x90, 0x72}: "MmioSerialUart",
		efi.GUID{0xb6, 0xab, 0xd5, 0xa3, 0xa4, 0x9d, 0xee, 0x43, 0xbe, 0x3b, 0xbd, 0xc4, 0x7d, 0x70, 0xf8, 0xfa}: "CPULowSpeed",
		efi.GUID{0xb6, 0xaf, 0x3b, 0xcd, 0xfb, 0x50, 0xe8, 0x4f, 0x8e, 0x4e, 0xab, 0x74, 0xd2, 0xc1, 0xa6, 0x00}: "EnglishDxe",
		efi.GUID{0xb6, 0xaf, 0xa4, 0x61, 0xe8, 0x69, 0xdb, 0x4e, 0xa6, 0x06, 0x20, 0xfb, 0x31, 0xc1, 0x3f, 0x82}: "lBoot",
		efi.GUID{0xb6, 0xb1, 0x57, 0x92, 0xdf, 0x82, 0x69, 0x4b, 0xa8, 0x3b, 0xc1, 0x6d, 0x67, 0x1b, 0x9a, 0x9f}: "ScreenCap",
		efi.GUID{0xb6, 0xb3, 0x19, 0xa9, 0x4e, 0xd4, 0xf0, 0x41, 0x91, 0x79, 0x8a, 0xa2, 0x4f, 0xf2, 0x26, 0x0e}: "PCIeSataDynamicSetup",
		efi.GUID{0xb6, 0xb8, 0x3a, 0x2e, 0x9d, 0xac, 0x70, 0x4d, 0xa6, 0x75, 0x54, 0xf5, 0x2f, 0xb2, 0x2d, 0x66}: "AtaPassThru",
		efi.GUID{0xb6, 0xbb, 0xad, 0xec, 0xae, 0xb0, 0x71, 0x45, 0x94, 0xe3, 0x31, 0x3c, 0x3d, 0x27, 0xa6, 0x11}: "AmdNbioGfxRNDxe",
		efi.GUID{0xb6, 0xc7, 0x0a, 0x00, 0x4d, 0xf4, 0x20, 0x42, 0xbd, 0x8b, 0x52, 0x1d, 0x30, 0xde, 0xa8, 0x0f}: "HpGraphicsDetectDxe",
		efi.GUID{0xb6, 0xc7, 0x3a, 0x12, 0x4d, 0xf4, 0x20, 0x42, 0xbd, 0x8b, 0x52, 0x1d, 0x30, 0xde, 0xa8, 0x0f}: "M2CarrierSupportDxe",
		efi.GUID{0xb6, 0xc9, 0xbf, 0x1c, 0x1e, 0x7f, 0x9e, 0x4e, 0x80, 0x1f, 0xfb, 0xce, 0x4d, 0x92, 0xa7, 0x6d}: "AmiTseBeforeTimeOutGuid",
		efi.GUID{0xb6, 0xdc, 0x69, 0x7b, 0x4c, 0x42, 0x44, 0x48, 0xa5, 0x3d, 0x08, 0x70, 0x56, 0x38, 0x28, 0x70}: "S3NotifyDispatchPei",
		efi.GUID{0xb6, 0xdc, 0xc0, 0xb6, 0x4e, 0x43, 0xec, 0x4b, 0xbd, 0xac, 0x8e, 0xe7, 0xed, 0x8a, 0x4e, 0xc8}: "ArithChk",
		efi.GUID{0xb6, 0xe5, 0x01, 0x8b, 0x19, 0x4f, 0xe8, 0x46, 0xab, 0x93, 0x1c, 0x53, 0x67, 0x1b, 0x90, 0xcc}: "EfiTpmDeviceInstanceTpm12Guid",
		efi.GUID{0xb6, 0xf6, 0xc2, 0x42, 0x6f, 0x97, 0xbd, 0x4e, 0xb6, 0xa9, 0xfb, 0x41, 0x78, 0xf9, 0x70, 0xfe}: "FchKernSmmInit",
		efi.GUID{0xb7, 0x01, 0xe2, 0xc7, 0x1e, 0x61, 0xca, 0x4f, 0x83, 0x0e, 0x74, 0x69, 0xc3, 0xb3, 0x92, 0x18}: "FjMfgTestBatteryDxe",
		efi.GUID{0xb7, 0x10, 0x06, 0xa4, 0x88, 0x49, 0xcd, 0x43, 0x9d, 0x95, 0x9b, 0xe9, 0xe0, 0xe7, 0xa3, 0x11}: "IntelGigabitLan_I210",
		efi.GUID{0xb7, 0x11, 0xd4, 0x94, 0x69, 0x76, 0xc3, 0x45, 0xba, 0x3b, 0xf3, 0xa5, 0x8a, 0x71, 0x56, 0x81}: "EfiHiiFrontPageClass",
		efi.GUID{0xb7, 0x12, 0x06, 0x24, 0x63, 0xa0, 0xd4, 0x11, 0x9a, 0x3a, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4c}: "SystemUsbSupportPolicySmm",
		efi.GUID{0xb7, 0x12, 0x06, 0x24, 0x63, 0xa0, 0xd4, 0x11, 0x9a, 0x3a, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d}: "SystemUsbBusDxe",
		efi.GUID{0xb7, 0x12, 0x06, 0x24, 0x63, 0xa0, 0xd4, 0x11, 0x9a, 0x3a, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4e}: "SystemUsbSupportPolicyDxe",
		efi.GUID{0xb7, 0x14, 0x24, 0x34, 0xda, 0x0c, 0xcd, 0x4b, 0x96, 0x81, 0x31, 0x4f, 0xb8, 0x65, 0x65, 0x7d}: "MsiMeUpdateControl",
		efi.GUID{0xb7, 0x15, 0x84, 0xfb, 0x7e, 0xea, 0x6d, 0x4e, 0x93, 0x81, 0x00, 0x5c, 0x3b, 0xd1, 0xda, 0xd7}: "DellEcConfigPei",
		efi.GUID{0xb7, 0x22, 0xe3, 0xd6, 0xed, 0x77, 0x94, 0x43, 0x86, 0xfd, 0xfc, 0xed, 0x3c, 0x05, 0x27, 0x80}: "LEMRomLayoutSmm",
		efi.GUID{0xb7, 0x2c, 0x46, 0x49, 0xff, 0x0c, 0xac, 0x41, 0xb1, 0x39, 0x51, 0xdf, 0xf9, 0x3d, 0x81, 0x40}: "TrackPointElan",
		efi.GUID{0xb7, 0x31, 0x96, 0x5d, 0x8b, 0x57, 0xe0, 0x43, 0x9e, 0xfc, 0xeb, 0x2c, 0x20, 0x12, 0x48, 0x01}: "SkipPlatformAuth",
		efi.GUID{0xb7, 0x38, 0x0c, 0x44, 0x16, 0xed, 0xea, 0x49, 0x96, 0x69, 0x31, 0x7e, 0xf9, 0x06, 0x63, 0x5d}: "I2cMasterDxe",
		efi.GUID{0xb7, 0x38, 0x0d, 0x44, 0x16, 0xe0, 0xea, 0x49, 0x97, 0x69, 0x31, 0x7e, 0xf9, 0x08, 0x83, 0x5d}: "I2cHcOperation",
		efi.GUID{0xb7, 0x50, 0x80, 0x0c, 0xf0, 0xd2, 0xf8, 0x42, 0x85, 0x2b, 0xd1, 0xde, 0xb2, 0xf2, 0xe9, 0xb0}: "SetupIoDetect",
		efi.GUID{0xb7, 0x5d, 0x15, 0x40, 0xf6, 0xf2, 0x7e, 0x4f, 0x8b, 0xa8, 0xa3, 0x46, 0x6d, 0x4e, 0xf5, 0xfe}: "RngDxe",
		efi.GUID{0xb7, 0x6c, 0x24, 0xb3, 0xd4, 0xe9, 0x9c, 0x41, 0x9e, 0x0c, 0x84, 0xe1, 0x0a, 0x3c, 0xd2, 0xfd}: "HstiIhvProviderDxeFHF",
		efi.GUID{0xb7, 0x78, 0xc0, 0x99, 0xd1, 0xd7, 0xe2, 0x4e, 0xb5, 0x85, 0xcc, 0x64, 0xa3, 0x09, 0x64, 0x0a}: "FjEvte",
		efi.GUID{0xb7, 0x7a, 0x9c, 0xbb, 0xd9, 0xb8, 0xf3, 0x4b, 0x9c, 0x29, 0x9b, 0xf3, 0x41, 0xe2, 0x17, 0xbc}: "EfiPlatformCpuInfoGuid",
		efi.GUID{0xb7, 0x7f, 0x62, 0x56, 0x7e, 0x0d, 0xfb, 0x45, 0x9a, 0x18, 0x95, 0x8d, 0x92, 0xe2, 0x78, 0x0a}: "FjPostScreenDxe",
		efi.GUID{0xb7, 0x82, 0x40, 0xd9, 0xe0, 0x04, 0x86, 0x45, 0x80, 0x72, 0x8f, 0xc5, 0x62, 0xab, 0xbb, 0xfa}: "IncompatiblePciDeviceSupport",
		efi.GUID{0xb7, 0x85, 0x15, 0xa1, 0xa2, 0x8f, 0x1c, 0x4f, 0xaa, 0x6f, 0xdd, 0x63, 0x09, 0x46, 0x96, 0x13}: "MeFwUpdLcl",
		efi.GUID{0xb7, 0x86, 0xf4, 0xcb, 0x96, 0xd1, 0x03, 0x4c, 0xaf, 0xe2, 0x33, 0xf3, 0x8e, 0x64, 0xda, 0x16}: "IntegratedTouch",
		efi.GUID{0xb7, 0x8a, 0xcd, 0xa1, 0x6f, 0xb8, 0xad, 0x43, 0x87, 0x7f, 0xb3, 0x43, 0x8d, 0xff, 0x79, 0x2e}: "HPLnx",
		efi.GUID{0xb7, 0x9c, 0x6b, 0x2c, 0x3b, 0xa1, 0xee, 0x4e, 0x80, 0xc0, 0x1a, 0x24, 0x0c, 0x8a, 0x69, 0xee}: "IccOverClocking",
		efi.GUID{0xb7, 0xac, 0x76, 0x24, 0xc7, 0xd4, 0xd3, 0x48, 0xab, 0x73, 0x75, 0x13, 0xb0, 0x3b, 0xb5, 0xdf}: "AmdOemRasRsSmm",
		efi.GUID{0xb7, 0xb0, 0xb8, 0xc9, 0x85, 0x9c, 0xe8, 0x46, 0xb3, 0x43, 0x36, 0x2f, 0xbd, 0x26, 0xe8, 0xf3}: "MuCryptoDxe",
		efi.GUID{0xb7, 0xb4, 0x7c, 0x01, 0x0c, 0xb8, 0x40, 0x40, 0xb6, 0xc8, 0xea, 0x98, 0x2b, 0xbb, 0x25, 0xb7}: "AmiSmbusHob",
		efi.GUID{0xb7, 0xbf, 0xcc, 0xf4, 0xe0, 0xf6, 0xfd, 0x47, 0x9d, 0xd4, 0x10, 0xa8, 0xf1, 0x50, 0xc1, 0x91}: "EfiSmmBase2ProtocolGuid",
		efi.GUID{0xb7, 0xc4, 0x69, 0xee, 0x9b, 0x7c, 0xbb, 0x41, 0xb4, 0x4b, 0x74, 0x81, 0x37, 0xe7, 0xb5, 0xbc}: "FjKbcSmm",
		efi.GUID{0xb7, 0xc6, 0x4d, 0x2a, 0xf5, 0x41, 0xdd, 0x45, 0xb4, 0x6f, 0x2d, 0xd3, 0x34, 0xc1, 0xcf, 0x65}: "LenovoConfigVariable",
		efi.GUID{0xb7, 0xc7, 0xc5, 0x79, 0x83, 0x10, 0xa6, 0x42, 0xad, 0x15, 0x2a, 0x4e, 0x7c, 0x42, 0x74, 0xd7}: "DxeSmmDriverEntryPoint",
		efi.GUID{0xb7, 0xc8, 0x05, 0x26, 0x64, 0xef, 0x5d, 0x47, 0x90, 0xf5, 0xe7, 0x67, 0x33, 0x9f, 0x4d, 0x3e}: "OemUsbLightBarDxe",
		efi.GUID{0xb7, 0xcc, 0xdb, 0x4f, 0x29, 0xe8, 0x4c, 0x4b, 0x88, 0x87, 0xb2, 0x3f, 0xd7, 0x25, 0x4b, 0x85}: "EfiRedfishPkgTokenSpace",
		efi.GUID{0xb7, 0xce, 0xe3, 0x7a, 0xe2, 0x2e, 0xfa, 0x48, 0xaa, 0x49, 0x35, 0x10, 0xbc, 0x83, 0xca, 0xbf}: "PeiSeCPlatformPolicyPpiGuid",
		efi.GUID{0xb7, 0xd2, 0x8c, 0x6e, 0x36, 0xb6, 0x59, 0x48, 0x85, 0xed, 0xc6, 0x37, 0xbd, 0xca, 0x59, 0x19}: "DellDaServiceTag",
		efi.GUID{0xb7, 0xd6, 0x7a, 0xc5, 0x15, 0x05, 0xa8, 0x40, 0x9d, 0x21, 0x55, 0x16, 0x52, 0x85, 0x4e, 0x37}: "EdkShell",
		efi.GUID{0xb7, 0xdc, 0x02, 0x03, 0xa3, 0xa6, 0x7c, 0x46, 0xb8, 0x5e, 0xf2, 0x1d, 0xb7, 0xe8, 0x53, 0x3b}: "SmmDispatchEngine",
		efi.GUID{0xb7, 0xeb, 0xc7, 0xe6, 0x04, 0x16, 0xcb, 0x4f, 0x8f, 0x87, 0xb3, 0xa6, 0xf4, 0x87, 0x30, 0xae}: "OrderedCollectionTest",
		efi.GUID{0xb7, 0xf0, 0xcc, 0x21, 0x6b, 0x24, 0x2c, 0x41, 0xa3, 0x34, 0x0b, 0x65, 0xa0, 0x7b, 0x28, 0xdf}: "SmmBaseOnSmmBase2Thunk",
		efi.GUID{0xb7, 0xf1, 0x88, 0x0c, 0x08, 0xdd, 0x29, 0x4e, 0xbe, 0x2d, 0xd0, 0x46, 0x88, 0xa4, 0x2c, 0x74}: "OemKbLightDxe",
		efi.GUID{0xb7, 0xf9, 0xf7, 0x04, 0x48, 0x12, 0x7c, 0x49, 0xb0, 0xeb, 0x8f, 0x74, 0x8a, 0xbf, 0xca, 0xf0}: "DellVideoProtocol",
		efi.GUID{0xb7, 0xfd, 0xd7, 0x3f, 0x4e, 0x1c, 0xba, 0x43, 0xa8, 0x57, 0x35, 0x85, 0x7f, 0x9e, 0xd3, 0xf5}: "SystemVariableStoreManagerRuntimeDxe",
		efi.GUID{0xb8, 0x0b, 0xca, 0xc8, 0xda, 0x67, 0x83, 0x48, 0x8c, 0xfc, 0x91, 0x80, 0xcb, 0x9e, 0xec, 0x68}: "OemActivation",
		efi.GUID{0xb8, 0x18, 0x22, 0x02, 0x5e, 0xfe, 0xbc, 0x4e, 0xbc, 0x96, 0x74, 0x05, 0x8a, 0x4e, 0x7e, 0x83}: "ErrorGlobeBorder",
		efi.GUID{0xb8, 0x1f, 0x93, 0x1a, 0x66, 0xc4, 0x4a, 0x45, 0xb6, 0x84, 0x73, 0xad, 0xa2, 0xcb, 0x05, 0x0b}: "AsusPostMessagePei",
		efi.GUID{0xb8, 0x21, 0xd6, 0x5a, 0x8a, 0xc2, 0x17, 0x44, 0xb6, 0x7a, 0xf7, 0x7f, 0xd1, 0x4b, 0xfb, 0xe4}: "AmiHeciDeliverSmmRuntimeDxe",
		efi.GUID{0xb8, 0x39, 0x05, 0xe1, 0x35, 0x1c, 0x84, 0x4b, 0x85, 0x93, 0x81, 0x55, 0x5d, 0x06, 0x5d, 0xd5}: "DellDaPasswords",
		efi.GUID{0xb8, 0x41, 0x36, 0xdc, 0xa8, 0x2f, 0xd3, 0x4e, 0xbc, 0x1f, 0xf9, 0x96, 0x2a, 0x03, 0x45, 0x4b}: "Mtftp4Dxe",
		efi.GUID{0xb8, 0x41, 0x5e, 0x60, 0x23, 0xe9, 0xcc, 0x47, 0x87, 0xb1, 0xa6, 0xe3, 0x85, 0x26, 0xe7, 0x8d}: "SmbiosCompatiInfo",
		efi.GUID{0xb8, 0x43, 0xb6, 0xb6, 0x41, 0x2b, 0x61, 0x4a, 0xa2, 0x24, 0xd4, 0xf4, 0x76, 0xef, 0x58, 0x0c}: "AmdCpmOemInitDxe",
		efi.GUID{0xb8, 0x43, 0xba, 0x0f, 0xdb, 0xac, 0xe2, 0x4e, 0xab, 0x31, 0x0f, 0xa4, 0xd5, 0xb6, 0xc3, 0xc5}: "FastBootTseProtocol",
		efi.GUID{0xb8, 0x46, 0xaa, 0xab, 0xa3, 0x84, 0x74, 0x4e, 0x88, 0x2f, 0x63, 0x68, 0xf6, 0xed, 0xc9, 0xb8}: "SystemUserMasterHddPwdDxe",
		efi.GUID{0xb8, 0x49, 0x13, 0x87, 0xe6, 0xc7, 0x3a, 0x44