/* SPDX-License-Identifier: GPL-2.0+ */
/*
 * Copyright 2020 Hitachi Power Grids. All rights reserved.
 */

#ifndef __CONFIG_PG_WCOM_LS102XA_H
#define __CONFIG_PG_WCOM_LS102XA_H

#define CFG_SYS_INIT_RAM_ADDR	OCRAM_BASE_ADDR
#define CFG_SYS_INIT_RAM_SIZE	OCRAM_SIZE

#define CFG_PRAM			((CONFIG_KM_PNVRAM + \
					  CONFIG_KM_PHRAM) >> 10)

#define PHYS_SDRAM			0x80000000
#define PHYS_SDRAM_SIZE			(1u * 1024 * 1024 * 1024)

#define CFG_SYS_DDR_SDRAM_BASE	0x80000000UL
#define CFG_SYS_SDRAM_BASE		CFG_SYS_DDR_SDRAM_BASE

#define SPD_EEPROM_ADDRESS		0x54

/* POST memory regions test */
#define CFG_POST			(CFG_SYS_POST_MEM_REGIONS)
#define CFG_POST_EXTERNAL_WORD_FUNCS

/*
 * IFC Definitions
 */
/* NOR Flash Definitions */
#define CFG_SYS_FLASH_BASE		0x60000000
#define CFG_SYS_FLASH_BASE_PHYS	CFG_SYS_FLASH_BASE

#define CFG_SYS_NOR0_CSPR_EXT	(0x0)
#define CFG_SYS_NOR0_CSPR	(CSPR_PHYS_ADDR(CFG_SYS_FLASH_BASE_PHYS) | \
				CSPR_PORT_SIZE_16 | \
				CSPR_TE | \
				CSPR_MSEL_NOR | \
				CSPR_V)
#define CFG_SYS_NOR_AMASK		IFC_AMASK(64 * 1024 * 1024)

#define CFG_SYS_NOR_CSOR		(CSOR_NOR_AVD_TGL_PGM_EN | \
					CSOR_NOR_ADM_SHIFT(0x4) | \
					CSOR_NOR_NOR_MODE_ASYNC_NOR | \
					CSOR_NOR_TRHZ_20 | \
					CSOR_NOR_BCTLD)
#define CFG_SYS_NOR_FTIM0		(FTIM0_NOR_TACSE(0x1) | \
					FTIM0_NOR_TEADC(0x7) | \
					FTIM0_NOR_TAVDS(0x0) | \
					FTIM0_NOR_TEAHC(0x1))
#define CFG_SYS_NOR_FTIM1		(FTIM1_NOR_TACO(0x1) | \
					FTIM1_NOR_TRAD_NOR(0x21) | \
					FTIM1_NOR_TSEQRAD_NOR(0x21))
#define CFG_SYS_NOR_FTIM2		(FTIM2_NOR_TCS(0x1) | \
					FTIM2_NOR_TCH(0x1) | \
					FTIM2_NOR_TWPH(0x6) | \
					FTIM2_NOR_TWP(0xb))
#define CFG_SYS_NOR_FTIM3		0

#define CFG_SYS_FLASH_BANKS_LIST	{ CFG_SYS_FLASH_BASE_PHYS }

#define CFG_SYS_WRITE_SWAPPED_DATA

#define CFG_SYS_CSPR0_EXT		CFG_SYS_NOR0_CSPR_EXT
#define CFG_SYS_CSPR0		CFG_SYS_NOR0_CSPR
#define CFG_SYS_AMASK0		CFG_SYS_NOR_AMASK
#define CFG_SYS_CSOR0		CFG_SYS_NOR_CSOR
#define CFG_SYS_CS0_FTIM0		CFG_SYS_NOR_FTIM0
#define CFG_SYS_CS0_FTIM1		CFG_SYS_NOR_FTIM1
#define CFG_SYS_CS0_FTIM2		CFG_SYS_NOR_FTIM2
#define CFG_SYS_CS0_FTIM3		CFG_SYS_NOR_FTIM3

/* NAND Flash Definitions */
#define CFG_SYS_NAND_BASE		0x68000000
#define CFG_SYS_NAND_BASE_PHYS	CFG_SYS_NAND_BASE

#define CFG_SYS_NAND_CSPR_EXT	(0x0)
#define CFG_SYS_NAND_CSPR	(CSPR_PHYS_ADDR(CFG_SYS_NAND_BASE) | \
				CSPR_PORT_SIZE_8 | \
				CSPR_TE | \
				CSPR_MSEL_NAND | \
				CSPR_V)
#define CFG_SYS_NAND_AMASK		IFC_AMASK(64 * 1024)
#define CFG_SYS_NAND_CSOR		(CSOR_NAND_ECC_ENC_EN \
					| CSOR_NAND_ECC_DEC_EN \
					| CSOR_NAND_ECC_MODE_4 \
					| CSOR_NAND_RAL_3 \
					| CSOR_NAND_PGS_2K \
					| CSOR_NAND_SPRZ_64 \
					| CSOR_NAND_PB(64) \
					| CSOR_NAND_TRHZ_40 \
					| CSOR_NAND_BCTLD)

#define CFG_SYS_NAND_FTIM0		(FTIM0_NAND_TCCST(0x3) | \
					FTIM0_NAND_TWP(0x8) | \
					FTIM0_NAND_TWCHT(0x3) | \
					FTIM0_NAND_TWH(0x5))
#define CFG_SYS_NAND_FTIM1		(FTIM1_NAND_TADLE(0x1e) | \
					FTIM1_NAND_TWBE(0x1e) | \
					FTIM1_NAND_TRR(0x6) | \
					FTIM1_NAND_TRP(0x8))
#define CFG_SYS_NAND_FTIM2		(FTIM2_NAND_TRAD(0x9) | \
					FTIM2_NAND_TREH(0x5) | \
					FTIM2_NAND_TWHRE(0x3c))
#define CFG_SYS_NAND_FTIM3		(FTIM3_NAND_TWW(0x1e))

#define CFG_SYS_CSPR1_EXT		CFG_SYS_NAND_CSPR_EXT
#define CFG_SYS_CSPR1		CFG_SYS_NAND_CSPR
#define CFG_SYS_AMASK1		CFG_SYS_NAND_AMASK
#define CFG_SYS_CSOR1		CFG_SYS_NAND_CSOR
#define CFG_SYS_CS1_FTIM0		CFG_SYS_NAND_FTIM0
#define CFG_SYS_CS1_FTIM1		CFG_SYS_NAND_FTIM1
#define CFG_SYS_CS1_FTIM2		CFG_SYS_NAND_FTIM2
#define CFG_SYS_CS1_FTIM3		CFG_SYS_NAND_FTIM3

#define CFG_SYS_NAND_BASE_LIST	{ CFG_SYS_NAND_BASE }

/* QRIO FPGA Definitions */
#define CFG_SYS_QRIO_BASE		0x70000000
#define CFG_SYS_QRIO_BASE_PHYS	CFG_SYS_QRIO_BASE

#define CFG_SYS_CSPR2_EXT		(0x00)
#define CFG_SYS_CSPR2	(CSPR_PHYS_ADDR(CFG_SYS_QRIO_BASE) | \
					CSPR_PORT_SIZE_8 | \
					CSPR_TE | \
					CSPR_MSEL_GPCM | \
					CSPR_V)
#define CFG_SYS_AMASK2		IFC_AMASK(64 * 1024)
#define CFG_SYS_CSOR2		(CSOR_GPCM_ADM_SHIFT(0x4) | \
					CSOR_GPCM_TRHZ_20 | \
					CSOR_GPCM_BCTLD)
#define CFG_SYS_CS2_FTIM0		(FTIM0_GPCM_TACSE(0x2) | \
					FTIM0_GPCM_TEADC(0x8) | \
					FTIM0_GPCM_TEAHC(0x2))
#define CFG_SYS_CS2_FTIM1		(FTIM1_GPCM_TACO(0x2) | \
					FTIM1_GPCM_TRAD(0x6))
#define CFG_SYS_CS2_FTIM2		(FTIM2_GPCM_TCS(0x1) | \
					FTIM2_GPCM_TCH(0x1) | \
					FTIM2_GPCM_TWP(0x7))
#define CFG_SYS_CS2_FTIM3		0x04000000

/*
 * Serial Port
 */
#define CFG_SYS_NS16550_CLK		get_serial_clock()

#define CFG_SMP_PEN_ADDR		0x01ee0200

#define HWCONFIG_BUFFER_SIZE		256

#define CFG_SYS_BOOTMAPSZ	(256 << 20) /* Increase map for Linux */

#endif
