#!/usr/bin/env bats
# Test to check if the available ciphers change when a new policy is set.

update-crypto-policies --set LEGACY > /dev/null
legacy_ciphers="$(openssl ciphers)"
update-crypto-policies --set DEFAULT > /dev/null
default_ciphers="$(openssl ciphers)"
update-crypto-policies --set FUTURE > /dev/null
future_ciphers="$(openssl ciphers)"

@test "LEGACY ciphers differ from DEFAULT" {
    run diff <(printf '%s\n' "$legacy_ciphers") <(printf '%s\n' "$default_ciphers")
    [ "$status" -eq 1 ]
}

@test "LEGACY ciphers differ from FUTURE" {
    run diff <(printf '%s\n' "$legacy_ciphers") <(printf '%s\n' "$future_ciphers")
    [ "$status" -eq 1 ]
}

@test "DEFAULT ciphers differ from FUTURE" {
    run diff <(printf '%s\n' "$default_ciphers") <(printf '%s\n' "$future_ciphers")
    [ "$status" -eq 1 ]
}

@test "Idempotency: setting same policy twice does not change ciphers" {
    update-crypto-policies --set FUTURE > /dev/null
    first_ciphers="$(openssl ciphers)"
    update-crypto-policies --set FUTURE > /dev/null
    other_ciphers="$(openssl ciphers)"
    run diff <(printf '%s\n' "$first_ciphers") <(printf '%s\n' "$other_ciphers")
    [ "$status" -eq 0 ]
}
