.\"
.\" $Id$
.\"
.TH fimrc 5 "(c) 2011\-2024 Michele Martone"
.SH NAME
fimrc \- \fB fim \fP configuration file and language reference

.SH SYNOPSIS
.B ~/.fimrc
.fi
.B /usr/local/etc/fimrc
.fi
.B fim
\-\-script\-from\-stdin [ \fR\fI{options}\fR ] < \fR\fI{scriptfile}\fR
.br
.B fim
\-\-execute\-script \fR\fI{scriptfile}\fR [ \fR\fI{options}\fR ]
.br
.B fim
\-\-execute\-commands \fR\fI{commands}\fR [ \fR\fI{options}\fR ]
.br
.B fim
\-\-final\-commands \fR\fI{commands}\fR [ \fR\fI{options}\fR ]
.br
.B fim
\-\-write\-scriptout \fR\fI{scriptfile}\fR [ \fR\fI{options}\fR ]
.br
.B fim
\-\-write\-scriptout /dev/stdout [ \fR\fI{options}\fR ]
.br
.B fim
\-\-chars\-press :\fR\fI{commands}\fR [ \fR\fI{options}\fR ]
.br
.B fim
\-\-chars\-press :\fR\fI{commands}\fR \-\-chars\-press '' [ \fR\fI{options}\fR ]
.br
.B fim
\-\-keysym\-press \fR\fI{keysym}\fR [ \fR\fI{options}\fR ]
.br

.SH DESCRIPTION
This page explains the 
.B fim
scripting language, which is used for the 
.B fimrc
configuration files, \fR\fI{scriptfile}\fRs, or \fR\fI{commands}\fR passed via command line \fR\fI{options}\fR.
This language can be used to issue commands (or programs) from the internal program command line accessed interactively by default through the ":" key (which can be customized via the "\fB_console_key\fP" variable).
One may exit from command line mode by pressing the Enter key on an empty line (a non empty command line would be submitted for execution), or the Esc key  (only in SDL mode).
The general form of a fim command/program is shown in the next section.


.SH FIM LANGUAGE GRAMMAR
This section specifies the grammar of the 
.B fim
language.

Language elements surrounded by a single quote ("'") are literals.

Warning: at the present state, this grammar has conflicts. A future release shall fix them.

  program: %empty
         | statement_list

  statement_list: statement
                | statement ';' statement_list
                | non_atomic_statements_block statement_list
                | statements_block

  non_atomic_statements_block: '{' statement_list '}'
                             | INTEGER '{' statement_list '}'
                             | conditional_statement

  statements_block: atomic_statements_block
                  | non_atomic_statements_block

  conditional_statement: if_statement
                       | loop_statement

  if_statement: 'if' '(' expression ')' statements_block
              | 'if' '(' expression ')' statements_block 'else' statements_block

  loop_statement: 'while' '(' expression ')' statements_block
                | 'do' statements_block 'while' '(' expression ')'

  atomic_statements_block: statement ';'
                         | statement ';' ';'
                         | statement ';' ';' ';'

  statement: '!' arguments
           | INTEGER ',' INTEGER IDENTIFIER
           | INTEGER ',' INTEGER IDENTIFIER arguments
           | INTEGER IDENTIFIER
           | SLASH_AND_REGEXP
           | '+' UNQUOTED_FLOAT '%'
           | '+' QUOTED_FLOAT '%'
           | '+' INTEGER '%'
           | '*' UNQUOTED_FLOAT
           | '*' QUOTED_FLOAT
           | '*' INTEGER
           | UNQUOTED_FLOAT '%'
           | QUOTED_FLOAT '%'
           | INTEGER '%'
           | '\-' UNQUOTED_FLOAT '%'
           | '\-' QUOTED_FLOAT '%'
           | '\-' INTEGER '%'
           | INTEGER
           | '\-' INTEGER
           | IDENTIFIER
           | IDENTIFIER FILE_PATH
           | IDENTIFIER arguments
           | INTEGER IDENTIFIER arguments
           | IDENTIFIER '=' expression

  arguments: expression
           | expression arguments

  expression: '(' expression ')'
            | expression '.' expression
            | '!' expression
            | expression '%' expression
            | expression '+' expression
            | expression '\-' expression
            | expression '*' expression
            | expression '/' expression
            | expression '<' expression
            | expression '>' expression
            | expression '||' expression
            | expression BOR expression
            | expression '&&' expression
            | expression BAND expression
            | expression '>=' expression
            | expression '<=' expression
            | expression '!=' expression
            | expression '==' expression
            | expression '=~' expression
            | '\-' expression
            | IDENTIFIER
            | INTEGER
            | QUOTED_FLOAT
            | UNQUOTED_FLOAT
            | STRING

A STRING can be either a single quoted string or a double quoted string.
A floating point number can be either unquoted (UNQUOTED_FLOAT) or quoted (QUOTED_FLOAT).
A QUOTED_FLOAT is a floating point number, either single ("'") or double (""") quoted.
An INTEGER shall be an unsigned integer number.
An IDENTIFIER shall be one of the valid fim commands (see 
.B COMMANDS REFERENCE
) or a valid alias.
A VARIABLE shall be an already declared or undeclared variable identifier (see 
.B VARIABLES REFERENCE
) or a valid alias, created using the 
.B alias
command.
The "=~" operator treats the right expression as a STRING, and uses it as a regular expression for matching purposes.
The SLASH_AND_REGEXP is a slash ("/") followed by a STRING, interpreted as a regular expression.
If 'INTEGER , INTEGER IDENTIFIER arguments' is encountered, command IDENTIFIER will be repeated on each file in the interval between the two INTEGERs, and substituting the given file name to any '{}' found in the commands arguments (which must be quoted in order to be treated as strings).
See \fR\fIregex\fR(1) for regular expression syntax.

The way some one\-line statements are evaluated:

.nf
:       enter command line mode (here one can use readline bindings as C\-r, C\-s, M\-b, M\-f, ...)
:\fR\fI{number}\fR       jump to \fR\fI{number}\fR^th image in the list
:^	        jump to first image in the list
:$	        jump to last image in the list
:*\fR\fI{factor}\fR      scale the image by \fR\fI{factor}\fR
:\fR\fI{scale}\fR%       scale the image to the desired \fR\fI{scale}\fR
:+\fR\fI{scale}\fR%       scale the image up to the desired percentage \fR\fI{scale}\fR (relatively to the original)
:\-\fR\fI{scale}\fR%       scale the image down to the desired percentage \fR\fI{scale}\fR (relatively to the original)

/\fR\fI{regexp}\fR		 entering the pattern \fR\fI{regexp}\fR (with '/') makes fim jump to the next image whose filename matches \fR\fI{regexp}\fR
/*.png$		 entering this pattern (with '/') makes fim jump to the next image whose filename ends with 'png'
/png		 a shortcut for '/.*png.*'

2,4 stdout '{}'	print three filenames to standard output.


!\fR\fI{syscmd}\fR		executes the \fR\fI{syscmd}\fR quoted string as an argument to the  "system" fim command.


.SH COMMANDS REFERENCE

.na
.B
alias
.fi
alias [\fR\fI{identifier}\fR [\fR\fI{commands}\fR [\fR\fI{description}\fR]]]
.fi
Without arguments, lists the current aliases.
.fi
With one, shows an identifier's assigned command.
.fi
With two, assigns to an identifier a user defined command or sequence of commands.
.fi
With three, also assigns a help string.
.fi

.na
.B
align
.fi
align ['bottom'|'top'|'left'|right']: if image larger than drawing area, align one side of the image to the border.
.fi
align 'center': align equally far from all sides.
.fi
align 'info': print internal alignment information.
.fi

.na
.B
autocmd
.fi
autocmd \fR\fI{event}\fR \fR\fI{pattern}\fR \fR\fI{commands}\fR: manipulate autocommands (inspired from Vim autocmd's).
.fi
Without arguments, list autocommands.
.fi
With arguments, specifies for which type of event and which current file open, which commands to execute.
.fi
See the default built\-in configuration files for examples.
.fi

.na
.B
autocmd_del
.fi
autocmd_del: specify autocommands to delete.
.fi
Usage: autocmd_del \fR\fI{event}\fR \fR\fI{pattern}\fR \fR\fI{commands}\fR.
.fi

.na
.B
basename
.fi
basename \fR\fI{filename}\fR: returns the basename of \fR\fI{filename}\fR in the '_last_cmd_output' variable.
.fi

.na
.B
bind
.fi
bind [\fR\fI{keysym}\fR [\fR\fI{commands}\fR [\fR\fI{description}\fR]]]: bind a key \fR\fI{keysym}\fR to \fR\fI{commands}\fR.
.fi
Optional \fR\fI{description}\fR specifies a documentation string.
.fi
If \fR\fI{keysym}\fR is at least two characters long and begins with 0 (zero), the integer number after the 0 will be treated as a raw keycode to bind the specified \fR\fI{keysym}\fR to.
.fi
Use the '_verbose_keys' variable to discover (display device dependent) raw keys.
.fi
Key binding is dynamical, so you can bind keys even during program's execution.
.fi
You can get a list of valid symbols (keysyms) by invoking dump_key_codes or in the man page.
.fi

.na
.B
cd
.fi
cd \fR\fI{path}\fR: change the current directory to \fR\fI{path}\fR.
.fi
If \fR\fI{path}\fR is a file, use its base directory name.
.fi
cd '\-' changes to the previous current directory (before the last ':cd \fR\fI{path}\fR' command).
.fi

.na
.B
clear
.fi
clear: clear the virtual console.
.fi

.na
.B
commands
.fi
commands: display the existing commands.
.fi

.na
.B
color
.fi
color ['desaturate']: desaturate the displayed image colors.
.fi
color ['negate']: negate the displayed image colors.
.fi
color ['colorblind'|'c'|'deuteranopia'|'d']: simulate a form of the deuteranopia color vision deficiency (cvd).
.fi
color ['protanopia'|'p']: simulate a form of the protanopia cvd.
.fi
color ['tritanopia'|'t']: simulate a form of the tritanopia cvd.
.fi
color ['daltonize'|'D']: if following a cvd specification, attempts correcting it.
.fi
color ['identity']: populate the image with 'RGB identity' pixels.
.fi
To get back the original, you have to reload the image.
.fi

.na
.B
crop
.fi
crop: crop image to a centered rectangle, half the width and half the height.
.fi
crop \fR\fI{p}\fR: crop image to the middle \fR\fI{p}\fR horizontal percent and \fR\fI{p}\fR vertical percent of the image.
.fi
crop \fR\fI{w}\fR \fR\fI{h}\fR: crop image to the middle \fR\fI{w}\fR horizontal percent and \fR\fI{h}\fR vertical percent of the image.
.fi
crop \fR\fI{x1}\fR \fR\fI{y1}\fR \fR\fI{x2}\fR \fR\fI{y2}\fR: crop image to the area between the upper left (\fR\fI{x1}\fR,\fR\fI{y1}\fR) and lower right (\fR\fI{x2}\fR,\fR\fI{y2}\fR) corner.
.fi
Units are intended as percentage (0 to 100).
.fi
Note: still experimental functionality.
.fi

.na
.B
desc
.fi
desc 'load' \fR\fI{filename}\fR [\fR\fI{sepchar}\fR]: load description file \fR\fI{filename}\fR, using the optional \fR\fI{sepchar}\fR character as separator.
.fi
desc 'reload': load once again description files specified at the command line with \-\-load\-image\-descriptions\-file, with respective separators.
.fi
desc ['\-all'] ['\-append'] ['\-nooverw'] 'save' \fR\fI{filename}\fR [\fR\fI{sepchar}\fR]: save current list descriptions to file \fR\fI{filename}\fR, using the optional \fR\fI{sepchar}\fR character as separator, and if '\-all' is present then save the variables, and if '\-append' is present then only append, and if '\-nooverw' is present then do not overwrite existing files.
.fi
See documentation of \-\-load\-image\-descriptions\-file for the format of \fR\fI{filename}\fR.
.fi

.na
.B
display
.fi
display ['reinit' \fR\fI{string}\fR | 'resize' \fR\fI{w}\fR \fR\fI{h}\fR | ['menuadd' \fR\fI{menuspec}\fR|'menudel'|'v'|'V'] ]: display the current file contents or change display settings.
.fi
If 'reinit' switch is supplied, the \fR\fI{string}\fR specifier is used to reinitialize the display device parameters like e.g. resolution, window system options; see the \-\-output\-device command line switch for allowed values.
.fi
If 'resize' and no argument, ask the window manager to resize the window like the image.
.fi
If 'resize' and two arguments, these are used to reset width and height of the current window.
.fi
In the 'menuadd' case, use \fR\fI{menuspec}\fR as GTK window menu specification. This specification string argument can be repeated. Each argument has form M/S. M is a slash\-separated submenu location, with optional '_' (underscore) before a GTK accelerator character (e.g. "File", "_File", "View/Scale", "_View/Scale"). M cannot be empty and must be followed by a '/'. S can specify a simple entry, a toggle entry, or radio buttons. If a simple entry, it consists of one to three sections separated by "  " (two spaces). If M begins with two non\-alphanumeric symbols, these will be used as separators, instead of the two spaces. The first section is the name of the menu entry (a label), the second is a command specification, the third is a shortcut character. The following labels are special and if followed by '/', they create custom menus: FimMenuLimit (pre\-categorized "limit"\-based commands based on actual "desc" command data), FimMenuCommands (with commands), FimMenuAliases (with aliases), FimMenuKeyBindings (with bindings), FimMenuVariables (with variables' values), FimMenuCommandsHelp (commands help), FimMenuAliasesHelp (aliases help), FimMenuKeyBindingsHelp (bindings help), FimMenuVariablesHelp (variables' help). A toggle button specification can take the form 'toggle__'\fR\fI{identifier}\fR'__'\fR\fI{value}\fR'__'\fR\fI{value}\fR and starts the toggle button with the second \fR\fI{value}\fR (which has to be different). Actually, between 'toggle' and the second value, instead of '__' you can use any two same punctuation signs or Tab characters consistently. E.g. "menu/label  toggle___v__1__2  " or "menu/label  toggle::_v::1::2  " are ok, but  "menu/label  toggle___v__1__1  " or "menu/label  toggle___v::1::2  " are not. A radio buttons specification has as many sections as radio buttons, separated internally by double spaces, and consisting each by a string, two spaces, an assignment \fR\fI{identifier}\fR=\fR\fI{value}\fR (notice no quotes are necessary around \fR\fI{value}\fR, and repetitions are illegal), two spaces, and an optional accelerator character (e.g. "m/first:  v=1  a  second:  v=2  b  third:  v=3  c" is ok, but "m/first:  v=1  a  second:  v=2  b  third:  v=2  c" is not).
.fi
Option 'menudel' removes all menus.
.fi
Note: 'menuadd' and 'menudel' are only valid for the \fBgtk\fP mode and are experimental. In particular, currently there are limitations on which characters are allowed in menu command specifications; the recommended workaround is to use aliases. 
.fi
Experimental option 'v' increases internal verbosity for some graphical outputs; experimental option 'V' decreases it. 
.fi
See also the '_debug_commands' variable. 
.fi

.fi

.na
.B
dump_key_codes
.fi
dump_key_codes: dump the active key codes (unescaped, for inspection purposes).
.fi

.na
.B
echo
.fi
echo \fR\fI{args}\fR: print the \fR\fI{args}\fR on console.
.fi

.na
.B
else
.fi
if(\fR\fIexpression\fR){\fR\fIaction\fR;}['else'{\fR\fIaction\fR;}]: see if.
.fi

.na
.B
eval
.fi
eval \fR\fI{args}\fR: evaluate \fR\fI{args}\fR as commands, executing them.
.fi

.na
.B
exec
.fi
exec \fR\fI{filename(s)}\fR: execute script \fR\fI{filename(s)}\fR.
.fi

.na
.B
font
.fi
font 'scan' [\fR\fI{dirname}\fR]: scan \fR\fI{dirname}\fR or /usr/share/consolefonts looking for fonts in the internal fonts list.
.fi
font 'load' \fR\fI{filename}\fR: load font \fR\fI{filename}\fR.
.fi
font {'next'|'prev'}: load next or previous font from the internal fonts list.
.fi
font 'info': print current font filename.
.fi

.na
.B
getenv
.fi
getenv \fR\fI{identifier}\fR: create a variable with the same value as the '\fR\fI{identifier}\fR' environment variable, but with an identifier prefixed by 'ENV_'. So e.g. getenv 'DISPLAY' creates 'ENV_DISPLAY'. Nothing is being printed; no variable is created if \fR\fI{identifier}\fR is empty.
.fi

.na
.B
goto
.fi
goto {['+'|'\-']\fR\fI{number}\fR['%']['f'|'p'|'F'|'P']}+ | {/\fR\fI{regexp}\fR/} | {?\fR\fI{filename}\fR} | {'+//'} | {'+/'|'\-/'}[\fR\fIC\fR] | {{'+'|'\-'}\fR\fI{identifier}\fR['+']}: jump to an image.
.fi
If \fR\fI{number}\fR is given, and not surrounded by any specifier, go to image at index \fR\fI{number}\fR.
.fi
If followed by '%', the effective index is computed as a percentage to the current available images.
.fi
If prepended by '\-' or '+', the jump is relative to the current index.
.fi
The 'f' specifier asks for the jump to occur within the files (same for 'F', but accelerates if keep pressing).
.fi
The 'p' specifier asks for the jump to occur in terms of pages, within the current file (same for 'P', but accelerates if keep pressing).
.fi
If there's only one file in the list and no 'f' specified, a 'p' will be implied, for a page jump.
.fi
The above form can be concatenated several times, but only the last occurrence of either file or page goto will be effective.
.fi
If /\fR\fI{regexp}\fR/ is given, jump to the first image matching the given /\fR\fI{regexp}\fR/ regular expression pattern.
.fi
If the argument starts with ?, jump to the filename following ?.
.fi
If given '+//', jump to the first different image matching the last given regular expression pattern.
.fi
With '+/'\fR\fIC\fR or '\-/'\fR\fIC\fR, jump to the next or the previous file according to \fR\fIC\fR: if 's' if same directory, if 'd' if down the directory hierarchy, if 'u' if down the directory hierarchy, if 'b' if same basename, if upper case match is negative, if missing defaults to 'S' (jump to file in different dir).
.fi
If \fR\fI{identifier|identifier2...}]\fR is encountered after a '+' or '\-' sign, jump to the next or the previous image having a different value for any corresponding i:\fR\fI{identifier}\fR (a trailing '+' requires a non empty value).
.fi
Matching can occur on both file name and description, possibly loaded via desc or \-\-load\-image\-descriptions\-file; see also '_lastgotodirection' and '_re_search_opts'.
.fi
 You can specify multiple arguments to goto: those after the first one triggering a jump are ignored.
.fi
Executes autocommands for events PreGoto and PostGoto. Keeping pressed shall accelerate images browsing.
.fi

.na
.B
help
.fi
help [\fR\fI{identifier}\fR]: provide online help, assuming \fR\fI{identifier}\fR is a variable, alias, or command identifier.
.fi
If \fR\fI{identifier}\fR begins with '/', search on the help contents, and show a list of matching items.
.fi
A list of commands can be obtained simply invoking 'commands'; a list of aliases with 'alias'; a list of bindings with 'bind'; a list of variables with 'variables'.
.fi

.na
.B
if
.fi
if(\fR\fIexpression\fR){\fR\fIaction\fR;}['else'{\fR\fIaction\fR;}]: see 'else'.
.fi

.na
.B
info
.fi
info: display information about the current file.
.fi

.na
.B
limit
.fi
limit  {'\-list'|'\-listall'} 'variable'|['\-further'|'\-merge'|'\-subtract'] [{\fR\fIexpression\fR} |{\fR\fIvariable\fR} \fR\fI{value}\fR]: A browsable file list filtering function (like limiting in the 'mutt' program). Uses information loaded via \-\-load\-image\-descriptions\-file.
.fi
 If invoked with '\-list'/'\-listall' only, will list the current description variable ids.
.fi
 If invoked with '\-list'/'\-listall' 'id', will list set values for the variable 'id'.
.fi
 If '\-further' is present, will start with the current list; if not, with the full list.
.fi
 If '\-merge' is present, new matches will be merged in the existing list and sorted.
.fi
 If '\-subtract' is present, sort and filter out matches.
.fi
 If {\fR\fIvariable\fR} and {value} are provided, limit to files having property {\fR\fIvariable\fR} set to \fR\fI{value}\fR.
.fi
 If {\fR\fIexpression\fR} is one exclamation point ('!'), will limit to the currently marked files only.
.fi
 If {\fR\fIexpression\fR} is '~!' will limit to files with unique basename.
.fi
 if '~=', to files with duplicate basename.
.fi
 if '~^', to the first of the files with duplicate basename.
.fi
 if '~$\:', to the last of the files with duplicate basename.
.fi
 On '~i' [\fR\fIMINIDX\fR][\-][\fR\fIMAXIDX\fR], (each a number possibly followed by a multiplier 'K') will limit on filenames in position \fR\fIMINIDX\fR to \fR\fIMAXIDX\fR.
.fi
 On '~z' will limit to files having the current file's size.
.fi
 on '~z' [\fR\fIMINSIZE\fR][\-][\fR\fIMAXSIZE\fR], (each a number possibly followed by a multiplier among 'k','K','m','M') will limit on filesize within these limits.
.fi
 on '~d' will limit to files having the current file's date +\- one day.
.fi
 on '~d' [\fR\fIMINTIME\fR][\-][\fR\fIMAXTIME\fR], (each the count of seconds since the Epoch (First of Jan. of 1970) or a date as \fR\fIDD\fR/\fR\fIMM\fR/\fR\fIYYYY\fR) will limit on file time (struct stat's 'st_mtime', in seconds) within this interval.
.fi
 For other values of {\fR\fIexpression\fR}, limit to files whose description string matches {\fR\fIexpression\fR}.
.fi
 Invoked with no arguments, the original browsable files list is restored.
.fi

.na
.B
list
.fi
list: display the files list.
.fi
list 'random_shuffle': randomly shuffle the file list.
.fi
list 'reverse': reverse the file list.
.fi
list 'clear': clear the file list.
.fi
list 'sort': sort the file list.
.fi
list 'sort_basename': sort the file list according to base name.
.fi
list 'sort_comment': sort the file list according to the value of the _comment variable.
.fi
list 'sort_var' \fR\fI{var}\fR: sort the file list according to the value of the i:\fR\fI{var}\fR variable.
.fi
list 'vars'|'variables': list variables in all i:* read from description file.
.fi
list 'sort_fsize': sort the file list according to file size.
.fi
list 'sort_mtime': sort the file list according to modification date. 
.fi
list 'pop': remove the current file from the files list, and step back.
.fi
list 'remove' [\fR\fI{filename(s)}\fR]: remove the current file, or the \fR\fI{filename(s)}\fR, if specified.
.fi
list 'push' \fR\fI{filename(s)}\fR: push \fR\fI{filename(s)}\fR to the back of the files list.
.fi
list 'filesnum': display the number of files in the files list.
.fi
list 'mark' [\fR\fI{args}\fR]: mark image file names for stdout printing at exit, with \fR\fI{args}\fR mark the ones matching according to the rules of the 'limit' command, otherwise the current file.
.fi
list 'unmark' [\fR\fI{args}\fR]: unmark marked image file names, with \fR\fI{args}\fR unmark the ones matching according to the rules of the 'limit' command, otherwise the current file.
.fi
list 'marked': show which files have been marked so far.
.fi
list 'dumpmarked': dump to stdout the marked files (you usually want to 'unmarkall' afterwards).
.fi
list 'markall': mark all the current list files.
.fi
list 'unmarkall': unmark all the marked files.
.fi
list 'pushdir' \fR\fI{dirname}\fR: push all the files in \fR\fI{dirname}\fR, when matching the regular expression in variable _pushdir_re or, if empty, from constant regular expression '\.(JPG|PNG|GIF|BMP|TIFF|TIF|JPEG|JFIF|PPM|PGM|PBM|PCX|QOI|AVIF|WEBP)$\:'.
.fi
list 'pushdirr' \fR\fI{dirname}\fR: like pushdir, but also push encountered directory entries recursively.
.fi
list 'swap': move the current image filename to the first in the list (you'll have to invoke reload to see the effect).
.fi
Of the above commands, several are temporarily not available for the duration of a background load (enabled by \-\-background\-recursive), which lasts until _loading_in_background is 0.
.fi

.na
.B
load
.fi
load: load the image, if not yet loaded (see also 'reload').
.fi
Executes autocommands for events PreLoad and PostLoad.
.fi

.na
.B
pan
.fi
pan \fR\fI{vsteps}\fR% \fR\fI{hsteps}\fR%: pan the image to \fR\fI{vsteps}\fR percentage steps from the top and \fR\fI{hsteps}\fR percentage steps from left. 
.fi
pan \fR\fI{vsteps}\fR \fR\fI{hsteps}\fR: pan the image to \fR\fI{vsteps}\fR pixels from the top and \fR\fI{hsteps}\fR pixels from left. 
.fi
pan {'down'|'up'|'left'|'right'|'ne'|'nw'|'se'|'sw'}[+\-] [\fR\fI{steps}\fR['%']]: pan the image \fR\fI{steps}\fR pixels in the desired direction.
.fi
If the '%' specifier is present, \fR\fI{steps}\fR is treated as a percentage of current screen dimensions.
.fi
If \fR\fI{steps}\fR is not specified, the '_steps' variable is used.
.fi
If present, the '_hsteps' variable is considered for horizontal panning.
.fi
A '+' (or '\-') sign at the end of the first argument jumps to next (or previous) if border is reached.
.fi
If present, the '_vsteps' variable is considered for vertical panning.
.fi
The variables may be terminated by the '%' specifier.
.fi
Executes autocommands for events PrePan and PostPan.
.fi

.na
.B
popen
.fi
popen \fR\fI{syscmd}\fR: pipe a command, invoking popen(): spawns a shell, invoking '\fR\fI{syscmd}\fR' and executing as fim commands the output of '\fR\fI{syscmd}\fR'. Can be disabled at configure time with \-\-disable\-system.
.fi

.na
.B
pread
.fi
pread \fR\fI{args}\fR: execute \fR\fI{args}\fR as a shell command and read the output as an image file (using 'popen'). Can be disabled at configure time with \-\-disable\-system.
.fi

.na
.B
prefetch
.fi
prefetch: prefetch (read into the cache) the two nearby image files (next and previous), for a faster subsequent opening.
.fi
Executes autocommands for events PrePrefetch and PostPrefetch.
.fi
See also the '_want_prefetch' variable.
.fi

.na
.B
pwd
.fi
pwd: print the current directory name, and updates the '_pwd' variable.
.fi

.na
.B
quit
.fi
quit [\fR\fI{number}\fR]: terminate the program.
.fi
If \fR\fI{number}\fR is specified, use it as the program return status.
.fi
Note that autocommand 'PostInteractiveCommand' does not trigger after this command.
.fi

.na
.B
recording
.fi
recording 'start': start recording the executed commands. 
.fi
recording 'stop': stop  recording the executed commands.
.fi
recording 'dump': dump in the console the record buffer.
.fi
recording 'execute': execute the record buffer.
.fi
recording 'repeat_last': repeat the last performed action.
.fi

.na
.B
redisplay
.fi
redisplay: re\-display the current file contents.
.fi

.na
.B
reload
.fi
reload [\fR\fI{arg}\fR]: load the image into memory.
.fi
If \fR\fI{arg}\fR is present, force reloading, bypassing the cache (see also 'load').
.fi
Executes autocommands for events PreReload and PostReload.
.fi

.na
.B
rotate
.fi
rotate \fR\fI{number}\fR: rotate the image the specified amount of degrees. If unspecified, by one. If you are interested in orthogonal rotations, see '_orientation' and related aliases.
.fi
Executes autocommands for events PreScale and PostScale.
.fi

.na
.B
scale
.fi
scale {['+'|'\-']\fR\fI{value}\fR['%']|'*'\fR\fI{value}\fR|'w'|'h'|'a'|'b'|'+[+\-*/]'|['<'|'>']|'shadow'}: scale the image according to a scale \fR\fI{value}\fR (e.g.: 0.5,40%,'w','h','a','b').
.fi
If given '*' and a value, multiply the current scale by that value.
.fi
If given 'w', scale according to the screen width.
.fi
If given 'h', scale to the screen height.
.fi
If given 'a', to the minimum of 'w' and 'h'.
.fi
If given 'b', like 'a', provided that the image width exceeds 'w' or 'h'.
.fi
If \fR\fI{value}\fR is a number, scale relatively to the original image width.
.fi
If the number is followed by '%', the relative scale is treated as a percentage.
.fi
If given '++'('+\-'), increment (decrement) the '_magnify_factor', '_reduce_factor' variables by '_scale_factor_delta'.
.fi
If given '+*'('+/'), multiply (divide) the '_magnify_factor', '_reduce_factor' variables by '_scale_factor_multiplier'.
.fi
If given '<' (or '>'), shrink (or magnify) image using nearest mipmap (cached pre\-scaled version). If given 'shadow' as a parameter, search a same\-named file in one of the directories specified to \-\-load\-shadow\-dir.
.fi
Executes autocommands for events PreScale and PostScale.
.fi

.na
.B
scroll
.fi
scroll: scroll down the image, going next when hitting the bottom.
.fi
scroll 'forward': scroll the image as we were reading left to right (see '_scroll_skip_page_fraction' variable).
.fi
Executes autocommands for events PrePan and PostPan.
.fi

.na
.B
set
.fi
set: returns a list of variables which are set.
.fi
set \fR\fI{identifier}\fR: returns the value of variable \fR\fI{identifier}\fR.
.fi
set \fR\fI{identifier}\fR \fR\fI{value}\fR: sets variable \fR\fI{identifier}\fR to value \fR\fI{value}\fR.
.fi

.na
.B
set_commandline_mode
.fi
set_commandline_mode: set console mode. Note that the mode will change only after the current block of commands is evaluated.
.fi

.na
.B
set_interactive_mode
.fi
set_interactive_mode: set interactive mode. Note that the mode will change only after the current block of commands is evaluated.
.fi

.na
.B
sleep
.fi
sleep [\fR\fI{number}\fR]: sleep for the specified number of seconds (or 1, if unspecified).
.fi

.na
.B
status
.fi
status: set the status line to the collation of the given arguments.
.fi

.na
.B
stderr
.fi
stderr \fR\fI{args}\fR: writes to stderr its arguments \fR\fI{args}\fR.
.fi

.na
.B
stdout
.fi
stdout \fR\fI{args}\fR: writes to stdout its arguments \fR\fI{args}\fR.
.fi

.na
.B
system
.fi
system \fR\fI{syscmd}\fR: get the output of executing the \fR\fI{syscmd}\fR system command. Uses the popen() system call. Usually popen invokes "/bin/sh \-c \fR\fI{syscmd}\fR". This might not handle a multi\-word command; in that case you have to put it into a script. See 'man popen' for more. Can be disabled at configure time with \-\-disable\-system.
.fi

.na
.B
variables
.fi
variables: display the existing variables.
.fi

.na
.B
unalias
.fi
unalias \fR\fI{identifier}\fR | '\-a': delete the alias \fR\fI{identifier}\fR or all aliases (use '\-a', not \-a).
.fi

.na
.B
unbind
.fi
unbind \fR\fI{keysym}\fR: unbind the action associated to a specified \fR\fI{keysym}\fR
.fi
If \fR\fI{keysym}\fR is at least two characters long and begins with 0 (zero), the integer number after the 0 will be treated as a raw keycode to bind the specified \fR\fI{keysym}\fR to.
.fi
Use the '_verbose_keys' variable to discover (display device dependent) raw keys.
.fi

.na
.B
while
.fi
while(\fR\fIexpression\fR){\fR\fIaction\fR;}: A conditional cycle construct.
.fi
May be interrupted by hitting the 'Esc' or the ':' key.
.fi

.na
.B
window
.fi
window \fR\fI{args}\fR: this command is disabled.
.fi

.SH KEYSYMS REFERENCE

" "  "!"  '"'  "#"  "$"  "%"  "&"  "'"  "("  ")"  "*"  "+"  ","  "\-"  "."  "/"  "0"  "1"  "2"  "3"  "4"  "5"  "6"  "7"  "8"  "9"  ":"  ";"  "<"  "="  ">"  "?"  "@"  "A"  "Any"  "B"  "Backspace"  "C"  "C\-a"  "C\-b"  "C\-c"  "C\-d"  "C\-e"  "C\-f"  "C\-g"  "C\-h"  "C\-i"  "C\-j"  "C\-k"  "C\-l"  "C\-m"  "C\-n"  "C\-o"  "C\-p"  "C\-q"  "C\-r"  "C\-s"  "C\-t"  "C\-u"  "C\-v"  "C\-w"  "C\-x"  "C\-y"  "C\-z"  "D"  "Del"  "Down"  "E"  "End"  "Enter"  "Esc"  "F"  "F1"  "F10"  "F11"  "F12"  "F2"  "F3"  "F4"  "F5"  "F6"  "F7"  "F8"  "F9"  "G"  "H"  "Home"  "I"  "Ins"  "J"  "K"  "L"  "Left"  "M"  "N"  "O"  "P"  "PageDown"  "PageUp"  "Q"  "R"  "Right"  "S"  "T"  "Tab"  "U"  "Up"  "V"  "W"  "X"  "Y"  "Z"  "["  "\\"  "]"  "^"  "_"  "`"  "a"  "b"  "c"  "d"  "e"  "f"  "g"  "h"  "i"  "j"  "k"  "l"  "m"  "n"  "o"  "p"  "q"  "r"  "s"  "t"  "u"  "v"  "w"  "x"  "y"  "z"  "{"  "|"  "}"  "~"  

.SH AUTOCOMMANDS REFERENCE
Available autocommands are: PreScale, PostScale, PrePan, PostPan, PreRedisplay, PostRedisplay, PreDisplay, PostDisplay, PrePrefetch, PostPrefetch, PreReload, PostReload, PreLoad, PostLoad, PreGoto, PostGoto, PreConfigLoading, PostConfigLoading, PreHardcodedConfigLoading, PostHardcodedConfigLoading, PreUserConfigLoading, PostUserConfigLoading, PreGlobalConfigLoading, PostGlobalConfigLoading, PreInteractiveCommand, PostInteractiveCommand, PreExecutionCycle, PostExecutionCycle, PreExecutionCycleArgs, PreWindow, PostWindow,  and they are triggered on actions as suggested by their name.
 Those associated to actual commands are mentioned in the associated commands reference.
.SH VARIABLES REFERENCE
If undeclared, a variable will evaluate to 0.

When assigning a variable to a string, use single or double quoting, otherwise it will be treated as a number.

The namespaces in which variables may exist are: current image, global. A namespace is specified by a prefix, which can be: 'i:', be prepended to the variable name. The global namespace is equivalent to the empty one:''. The special variable i:* expands to the collation of all the name\-value pairs for the current image.

In the following, the [internal] variables are the ones referenced in the source code (not including the hardcoded configuration, which may be inspected and/or invalidated by the user at runtime).

.na
.B
_TERM
[out,g:] the environment TERM variable.
.fi
.na
.B
__exif_flipped
[out,i:] flipping information, read from the EXIF tags of a given image.
.fi
.na
.B
__exif_mirrored
[out,i:] mirroring information, read from the EXIF tags of a given image.
.fi
.na
.B
_all_file_loaders
[out,g:] space\-separated list of hardcoded file loaders usable with _file_loader.
.fi
.na
.B
_archive_files
[in,g:] If non\-empty, a regular expression matching the filenames to be treated as archives (multipage files). If empty, "\.(RAR|ZIP|TAR|TAR.GZ|TGZ|TAR.BZ2|TBZ|TBZ2|CBR|CBZ|LHA|7Z|XAR|ISO)$\:" is used. Within each archive, only filenames matching the regular expression in the _pushdir_re variable are considered for loading.
.fi
.na
.B
_autocmd_trace_stack
[in,g:] dump to stdout autocommands (autocmd) stack trace during their execution (for debugging purposes).
.fi
.na
.B
_autodesaturate
[in,g:] if 1, desaturate all images.
.fi
.na
.B
_autoflip
[in,g:] if 1, flip all images.
.fi
.na
.B
_automirror
[in,g:] if 1, mirror all images.
.fi
.na
.B
_autonegate
[in,g:] if 1, negate all images.
.fi
.na
.B
_autotop
[in,g:] if 1, align to the top freshly loaded images.
.fi
.na
.B
_buffered_in_tmpfile
[out,i:] if an image has been temporarily converted and decoded from a temporary file, its name is here.
.fi
.na
.B
_cache_control
[in,g:] string for cache control. If it starts with 'm', cache mipmaps; if it starts with 'M' then do not not cache them. Otherwise defaults apply.
.fi
.na
.B
_cache_status
[out,g:] string with current information on cache status.
.fi
.na
.B
_cached_images
[out,g:] the number of images currently cached.
.fi
.na
.B
_caption_over_image
[in,g:] if set to a value different than 0, display a custom comment string specified according to the value of _caption_over_image_fmt; if larger than 1, with black background; if 3, draw above the image, with no overlap. Occupies at most half of the screen.
.fi
.na
.B
_caption_over_image_fmt
[in,g:] custom info format string, displayed in a caption over the image; if unset: i:_comment; otherwise a custom format string specified just as _info_fmt_str.
.fi
.na
.B
_command_expansion
[in,g:] if 1, enable autocompletion (on execution) of alias and command strings.
.fi
.na
.B
_comment
[i:,out] the image comment, extracted from the image file (if any).
.fi
.na
.B
_console_buffer_free
[out,g:] amount of unused memory in the output console buffer.
.fi
.na
.B
_console_buffer_total
[out,g:] amount of memory allocated for the output console buffer.
.fi
.na
.B
_console_buffer_used
[out,g:] amount of used memory in the output console buffer.
.fi
.na
.B
_console_key
[in,g:] the key bound (an integer variable) to spawn the command line; overrides any other binding. It's set \-1 if command line disabled.
.fi
.na
.B
_console_lines
[out,g:] the number of buffered output console text lines.
.fi
.na
.B
_console_offset
[in,out,g:] position of the text beginning in the output console, expressed in lines.
.fi
.na
.B
_debug_commands
[in,g:] debugging option string for printing out . if containing 'a', print out autocmd info; if containing 'c', print out each command; if containing 'k', print out each pressed key in command line mode; if containing 'i', print interpreter internal steps; if containing 'B', clear screen and print background loading files; if containing 'C', print cache activity; if containing 'm', gtk mode menus tooltips will contain also specification strings; if containing 'mm', gtk mode menu building will also be very verbose.
.fi
.na
.B
_device_string
[out,g:] the current display device string, in the form [fb|sdl|gtk|ca|aa|dumb][=\fR\fI{gfxopts}\fR]. See option \-\-output\-device for a description.
.fi
.na
.B
_display_as_binary
[in,g:] force loading files as pixelmaps (no image decoding is performed); if 1, using one bit per pixel; if 24, using 24 bits per pixel. If empty, load and decode the files as usual.
.fi
.na
.B
_display_as_rendered_text
[in,g:] if 1, force loading specified files as text files (no image decoding is performed); otherwise load and decode the files as usual.
.fi
.na
.B
_display_busy
[in,g:] if 1, display a message on the status bar when processing.
.fi
.na
.B
_display_console
[in,g:] if 1, display the output console.
.fi
.na
.B
_display_status
[in,g:] if 1, display the status bar.
.fi
.na
.B
_display_status_bar
[in,g:] if 1, display the status bar.
.fi
.na
.B
_display_status_fmt
[in,g:] custom info format string, displayed in the lower left corner of the status bar; if unset: full pathname; otherwise a custom format string specified just as _info_fmt_str.
.fi
.na
.B
_do_sanity_check
[in,experimental,g:] if 1, execute a sanity check on startup.
.fi
.na
.B
_downscale_huge_at_load
[in,g:] if 1, downscale at load time huge images (that is, ones exceeding by 1.5 times the screen size).
.fi
.na
.B
_exif_orientation
[out,i:] orientation information in the same format of _orientation, read from the orientation EXIF tags (i:EXIF_Orientation).
.fi
.na
.B
_exiftool_comment
[out,g:] comment extracted via the exiftool interface; see _use_exiftool.
.fi
.na
.B
_external_decoder_program
[out,i:] if an image has been decoded via an external program, its name is here.
.fi
.na
.B
_fbfont
[out,g:] The current console font file string. If the internal hardcoded font has been used, then its value is "fim://".
.fi
.na
.B
_fbfont_as_screen_fraction
[in,g:] Scale the rendered text to at least this (integer) fraction of the screen. Disable font autoscaling with \-1. (Only enabled if configured with \-\-with\-font\-magnifying\-factor=FACTOR, with FACTOR<1).
.fi
.na
.B
_fbfont_magnify_factor
[in,g:] For the rendered text use a font magnified by this (integer) factor. Maximal value is "16". (Only enabled if configured with \-\-with\-font\-magnifying\-factor=FACTOR, with FACTOR<1).
.fi
.na
.B
_fbfont_verbosity
[in,g:] if > 0, verbose font loading
.fi
.na
.B
_file_load_time
[out,i:] time taken to load the file and decode the image, in seconds.
.fi
.na
.B
_file_loader
[in,i:,g:] specify a file loader to use (among the ones listed in the \-V switch output); [out] i:_file_loader stores the loader of the current image.
.fi
.na
.B
_fileindex
[out,g:] the current image numeric index.
.fi
.na
.B
_filelistlen
[out,g:] current image list length (number of visible images).
.fi
.na
.B
_filename
[out,i:] the current file name string.
.fi
.na
.B
_fim_bpp
[out,g:] the bits per pixel count.
.fi
.na
.B
_fim_default_config_file_contents
[out,g:] the contents of the default (hardcoded) configuration file (executed after the minimal hardcoded config).
.fi
.na
.B
_fim_default_grammar_file_contents
[out,g:] the contents of the default (hardcoded) grammar file.
.fi
.na
.B
_fim_scriptout_file
[in,g:] the name of the file to write to when recording sessions.
.fi
.na
.B
_fim_version
[out,g:] fim version number; may be used for keeping compatibility of fim scripts across evolving versions.
.fi
.na
.B
_hide_gtk_menus
[out,g:] internal
.fi
.na
.B
_hsteps
[in,g:] the default steps, in pixels, when panning images horizontally (overrides steps).
.fi
.na
.B
_ignorecase
[in,g:] if 1, allow for case\-insensitive regexp\-based match in autocommands (autocmd).
.fi
.na
.B
_info_fmt_str
[in,g:] custom info format string, displayed in the lower right corner of the status bar; may contain ordinary text and special 'expando' sequences. These are: %p for current scale, in percentage; %w for width; %h for height; %i for image index in list; %k for the value of i:_comment (comment description) variable in square brackets (if non empty); %l for current image list length; %L for flip/mirror/orientation information; %P for page information; %F for file size; %M for screen image memory size; %m for memory used by mipmap; %C for memory used by cache; %T for total memory used (approximation); %R for total max memory used (as detected by getrusage()); %n for the current file path name; %N for the current file path name basename; ; %c for centering information; %v for the fim program/version identifier string; %% for an ordinary %. A sequence like %?VAR?EXP? expands to EXP if i:VAR is set (or, otherwise, if VAR); EXP is copied verbatim except for contained sequences of the form %:VAR:, which expand to the value of variable i:VAR (or, if unset, VAR); this is meant to be used like in e.g. '%?EXIF_DateTimeOriginal?[%:EXIF_DateTimeOriginal:]?', where the EXIF\-set variable EXIF_DateTimeOriginal (make sure you have libexif for this) are used only if present.
.fi
.na
.B
_inhibit_display
[internal,g:] if 1, inhibit display.
.fi
.na
.B
_last_cmd_output
[out,experimental,g:] the last command output.
.fi
.na
.B
_last_file_loader
[out,g:] set to the name of the last file loader used.
.fi
.na
.B
_last_system_output
[out,experimental,g:] the standard output of the last call to the system command.
.fi
.na
.B
_lastfileindex
[out,g:] the last visited image numeric index (different than _fileindex). Useful for jumping back and forth easily between two images with 'goto _lastfileindex'.
.fi
.na
.B
_lastgotodirection
[out,g:] the last file goto direction (either string '+1' or string '\-1').
.fi
.na
.B
_lastpageindex
[out,g:] the last visited file page index.
.fi
.na
.B
_load_default_etc_fimrc
[in,g:] if 1 at startup, load the system wide initialization file.
.fi
.na
.B
_load_fim_history
[in,g:] if 1 on startup, load the ~/.fim_history file on startup.
.fi
.na
.B
_load_hidden_dirs
[in,g:] if not 1, when pushing directories/files, those with name beginning with a dot (.) are skipped.
.fi
.na
.B
_loading_in_background
[out,g:] 1 if program has been invoked with \-\-background\-recursive and still loading in background. 
.fi
.na
.B
_loop_only_once
[internal,g:] if 1 and doing a \-\-slideshow, do it once.
.fi
.na
.B
_lwidth
[in,g:] if>0, force the output console text width.
.fi
.na
.B
_magnify_factor
[in,g:] the image scale multiplier used when magnifying images size.
.fi
.na
.B
_max_cached_images
[in,g:] the maximum number of images after which forcing evictions. Setting this to 0 (no limits) is ok provided _max_cached_memory is set meaningfully.
.fi
.na
.B
_max_cached_memory
[in,g:] the maximum amount of memory (in KiB) at which images continue being added to the cache. Setting this to 0 (no limit) leads to a crash (there is no protection currently).
.fi
.na
.B
_max_iterated_commands
[g:] the iteration limit for N in "N[commandname]" iterated command invocations.
.fi
.na
.B
_min_cached_images
[in,g:] the minimum number of images to keep from eviction; if less than four can lead to inefficiencies: e.g. when jumping between two images, each time an erase and a prefetch of neighboring images would trigger. default value is 4.
.fi
.na
.B
_no_default_configuration
[in,g:] if 0, a default, hardcoded configuration is loaded at startup, after the minimal hardcoded one.
.fi
.na
.B
_no_external_loader_programs
[in,g:] if 1, do not attempt using external programs to decode a file of an unknown format.
.fi
.na
.B
_no_rc_file
[in,g:] if 1, do not load the ~/.fimrc configuration file at startup.
.fi
.na
.B
_open_offset
[in,optional,g:,i:] offset (specified in bytes) used when opening a file; [out] i:_open_offset is assigned to images opened at a nonzero offset.
.fi
.na
.B
_open_offset_retry
[in,optional,g:] number of adjacent bytes to probe in opening the file.
.fi
.na
.B
_orientation
[internal,i:] Orthogonal clockwise rotation (orientation) is controlled by: 'i:_orientation', 'g:_orientation' and applied on a per\-image basis. In particular, the values of the three variables are summed up and the sum is interpreted as the image orientation.  If the sum is 0, no rotation applies; if it is 1, a single ( 90') rotation applies; if it is 2, a double (180') rotation applies; if it is 3, a triple (270') rotation applies.  If the sum is not one of 0,1,2,3, the value of the sum modulo 4 is considered.  Therefore, ":i:_orientation=1" and ":i:_orientation=5" are equivalent: they rotate the image one time by 90'.
.fi
.na
.B
_pread_cmd
[in,g:] a user\-specified shell command emitting an image on stdout, in a format readable by the convert utility. If the current filename matches "^[/A\-Za\-z0\-9_.][/A\-Za\-z0\-9_.\-]*$\:", substitute it to any occurrence of '{}'.
.fi
.na
.B
_preferred_rendering_dpi
[in,optional,g:] if >0, rendering of pdf, ps, djvu use this value for a default document dpi; if unset, use an internal default value.
.fi
.na
.B
_preferred_rendering_width
[in,optional,g:] if >0, bit\-based (see _display_as_binary) rendering uses this value for a default document width (instead of a default value).
.fi
.na
.B
_push_checks
[in,experimental,g:] if 1 (default), check with stat() the existence of input files before push'ing them (set this to 0 to speed up loading very long file lists; in these cases a trailing slash (/) must be used to tell fim a pathname is a directory). This only works after initialization (thus, after command line files have been push'ed); use \-\-no\-stat\-push if you wish to set this to 0 at command line files specification.
.fi
.na
.B
_push_pushes_dirs
[in,g:] if 1, the push command also accepts and pushes directories (using pushdir). if 2, also push hidden files/directories, that is, ones whose names begin with a dot (.).
.fi
.na
.B
_pushdir_re
[in] regular expression to match against when pushing files from a directory or an archive. By default this is "\.(JPG|PNG|GIF|BMP|TIFF|TIF|JPEG|JFIF|PPM|PGM|PBM|PCX|QOI|AVIF|WEBP)$\:".
.fi
.na
.B
_pwd
[out,g:] the current working directory; variable updated at startup and whenever the working directory changes.
.fi
.na
.B
_re_search_opts
[in,g:] affects regexp\-based searches; if an empty string, defaults apply; if it contains 'i' ('I'), case insensitive (sensitive) searches occur; if it contains 'b', match on basename, if contains 'f' on full pathname; if it contains 'D', match on description.
.fi
.na
.B
_reduce_factor
[in,g:] the image scale multiplier used when reducing images size.
.fi
.na
.B
_retry_loader_probe
[in,g:] if set to 1 and a user\-specified file loader fails, probe for a different loader.
.fi
.na
.B
_rows
[in,g:] if >0, set the number of text lines in the console to be displayed .
.fi
.na
.B
_save_fim_history
[in,g:] if 1 on exit, save the ~/.fim_history file on exit.
.fi
.na
.B
_scale_factor_delta
[in,g:] value used for incrementing/decrementing the scaling factors.
.fi
.na
.B
_scale_factor_multiplier
[in,g:] value used for scaling up/down the scaling factors.
.fi
.na
.B
_scale_style
[in,g:] if non empty, pass it to the scale command; see its documentation for possible values.
.fi
.na
.B
_screen_height
[out] the screen height.
.fi
.na
.B
_screen_width
[out,g:] the screen width.
.fi
.na
.B
_scroll_skip_page_fraction
[int,g:] if >1, fraction of page to skip when scrolling (e.g. 'scrollforward'); if 1, auto chosen; if <1, disabled.
.fi
.na
.B
_seek_magic
[optional,g:] seek a 'magic' signature in the file after opening it, and try decoding it starting within the range of that signature (use like this: fim \-C '_seek_magic=MAGIC_STRING;push filename').
.fi
.na
.B
_slideshow_sleep_time
[in,g:] number of seconds of sleep during slideshow mode.
.fi
.na
.B
_status_line
[in,g:] if 1, display the status bar.
.fi
.na
.B
_steps
[in,g:] the default steps, in pixels, when panning images.
.fi
.na
.B
_stop_slideshow
[internal,g:] if it becomes 1 during a slideshow, stop it; gets unset before each 'while'.
.fi
.na
.B
_sys_rc_file
[in,g:] string with the global configuration file name.
.fi
.na
.B
_use_exiftool
[in,g:] if >0 and supported, use exiftool to get additional information. If 1, append this information to _comment; if 2, to _exiftool_comment.
.fi
.na
.B
_use_mipmaps
[in,g:] if >0, use mipmaps to speed up downscaling of images (this has a memory overhead equivalent to one image copy); mipmaps are not cached. If 2, use every fourth source pixel instead of averaging (good for photos, not for graphs).
.fi
.na
.B
_verbose_errors
[in,g:] if 1, display on stdout internal errors, while parsing commands.
.fi
.na
.B
_verbose_keys
[in,g:] if 1, display on the console the raw keycode of each key hit interactively.
.fi
.na
.B
_verbosity
[in,experimental,g:] program verbosity.
.fi
.na
.B
_vsteps
[in,g:] the default steps, in pixels, when panning images vertically (overrides steps).
.fi
.na
.B
_want_autocenter
[in,g:] if 1, center the image when displayed.
.fi
.na
.B
_want_exif_orientation
[in,g:] if 1, reorient images using information from EXIF metadata (and stored in in _exif_orientation, __exif_mirrored, __exif_flipped ).
.fi
.na
.B
_want_prefetch
[in,g:] if 1, prefetch further files just after displaying the first file; if 2 (and configured with \-\-enable\-cxx11) load in the background.
.fi
.na
.B
_want_wm_caption_status
[in,g:] this works only if supported by the display device. If set to a number that is not 0, show the status (or command) line in the window manager caption; if set to a non\-empty string, interpret it just as a file info format string (see _info_fmt_str); if empty, show the program version.
.fi
.na
.B
_want_wm_mouse_ctrl
[in,g:] if at least 9 chars long, enable mouse click/movement behaviour when in GTK, SDL or libcaca mode; the 9 chars correspond to a 3x3 screen clickable grid and the equivalent command keys; clicking middle or right button toggle on\-screen usage info.
.fi
.na
.B
angle
[in,out,i:] a floating point number specifying the rotation angle, in degrees.
.fi
.na
.B
ascale
[in,out,i:] the asymmetric scaling of the current image.
.fi
.na
.B
desaturated
[out,i:] 1, if the image is desaturated.
.fi
.na
.B
flipped
[out,i:] 1, if the image is flipped.
.fi
.na
.B
fresh
[in,out,i:,experimental] 1 if the image was loaded, before all autocommands (autocmd) execution.
.fi
.na
.B
height
[out,i:] the current image original height.
.fi
.na
.B
mirrored
[out,i:] 1, if the image is mirrored.
.fi
.na
.B
negated
[out,i:] 1, if the image is negated.
.fi
.na
.B
page
[out,experimental,g:] the current page.
.fi
.na
.B
pages
[out,experimental,i:] the current number of pages of an image.
.fi
.na
.B
random
[out] a pseudorandom number.
.fi
.na
.B
scale
[in,i:] the scale of the current image.
.fi
.na
.B
sheight
[out,i:] the current image scaled height.
.fi
.na
.B
swidth
[out,i:] the current image scaled width.
.fi
.na
.B
width
[out,i:] the current image original width.
.fi
.SH DEFAULT ALIASES REFERENCE
Hardcoded aliases are: 

.fi
alias
.B
"A"
"_autotop=1\-_autotop;"
.fi
alias
.B
"magnify"
"scale '+'" # magnify the displayed image by the _magnify_factor variable or \fR\fI{args}\fR
.fi
alias
.B
"next"
"goto '+1'" # go to the next page or file
.fi
alias
.B
"next_file"
"goto '+1f'" # go to the next file in the list
.fi
alias
.B
"next_page"
"goto '+1p'" # go to the next page in the file
.fi
alias
.B
"prev"
"goto '\-1'" # go to the previous page or file
.fi
alias
.B
"prev_file"
"goto '\-1f'" # go to the previous file in the list
.fi
alias
.B
"prev_page"
"goto '\-1p'" # go to the previous page in the file
.fi
alias
.B
"reduce"
"scale '\-'" # reduce the displayed image by _reduce_factor or \fR\fI{args}\fR
.fi
alias
.B
"scale_factor_decrease"
"scale '+\-'" # subtract _scale_factor_delta to the scale factors _reduce_factor and _magnify_factor
.fi
alias
.B
"scale_factor_grow"
"scale '+*'" # multiply the scale factors _reduce_factor and _magnify_factor by _scale_factor_multiplier
.fi
alias
.B
"scale_factor_increase"
"scale '++'" # add _scale_factor_delta to the scale factors _reduce_factor and _magnify_factor
.fi
alias
.B
"scale_factor_shrink"
"scale '+/'" # divide the scale factors _reduce_factor and _magnify_factor by _scale_factor_multiplier
.fi

.fi
They can be redefined with 
.B alias
or deleted with the 
.B unalias
command.
.fi
Further default aliases are usually loaded at startup \-\- see the CONFIGURATION FILE EXAMPLE section below.
.SH COMMAND LINE USAGE EXAMPLES
.nf
# jump to the third image:
3;
# jump to first image:
^;
# jump to last image:
$;
# magnify the image two times:
*2;
# scale the image to the 30% of the original:
30%;
# scale the image up by 30%:
+30%;
# scale the image down by 30%:
\-30%;
# jump to the next image whose filename matches the ".*jpg" regular expression:
/.*jpg;
# execute the "date" system command
!"date";

.SH CONFIGURATION FILE EXAMPLE
Part of the default configuration comes from the \fB_fim_default_config_file_contents\fP variable, shown here.
.nf
One can skip its loading by using the \fB_no_default_configuration\fP variable.

.nf
# $LastChangedDate: 2024\-05\-15 01:34:42 +0200 (Wed, 15 May 2024) $
# Contents of the default 'fimrc' file, hardcoded in the fim executable.
# Read the documentation (man fimrc) to discover how to change this default hardcoded file and how to make your own.
# Note that usually a ~/.fimrc file is read after these options take effect, so you could reset all of this with ease.
# Lines beginning with a pound (#) are ignored by fim (they are treated as comments).
#
# Internal variables.
# Some of these variables influence fim's behaviour (input variables), some are set by fim (output variables).
# It is wise the input variables are set at the beginning of the file, so the bottom may issue commands correctly affected by them.
if(_cache_control==''){_cache_control='m';}
if(_debug_commands==''){_debug_commands='';}
if(_command_expansion==''){_command_expansion=1;}
if(_display_status==''){_display_status=0;}
if(_max_cached_images==''){_max_cached_images=5;}
if(_min_cached_images==''){_min_cached_images=4;}
if(_max_cached_memory==''){_max_cached_memory=81920;}
if(_max_iterated_commands==''){_max_iterated_commands=100;}
if(_want_prefetch==''){_want_prefetch=1;}
if(_no_external_loader_programs==''){_no_external_loader_programs=0;}
if(_scale_style==''){_scale_style='b';}
if(_save_fim_history==''){_save_fim_history=1;}
if(_load_fim_history==''){_load_fim_history=1;}
if(_verbose_keys==''){_verbose_keys=0;}
if(_display_busy==''){_display_busy=1;}
if(_ignorecase==''){_ignorecase=1;}
if(_re_search_opts==''){_re_search_opts='biD';}
if(_console_offset==''){_console_offset=0;}
if(_console_key==''){_console_key=58;}
if(_display_as_binary==''){_display_as_binary=0;}
if(_push_checks==''){_push_checks=1;}
#if(_want_wm_caption_status==''){_want_wm_caption_status=0;}
if(_want_exif_orientation==''){_want_exif_orientation=1;}
if(ascale==''){ascale="1.0";}
if(_use_mipmaps==''){_use_mipmaps=1;}
if(_downscale_huge_at_load==''){_downscale_huge_at_load=1;}
if(_scroll_skip_page_fraction==''){_scroll_skip_page_fraction=0;}
if(_want_wm_mouse_ctrl==''){_want_wm_mouse_ctrl="'pP+a\-=nN";}
if(_slideshow_sleep_time==''){_slideshow_sleep_time=1;}
#
# External variables (not used internally).
if(allow_round_scroll==''){allow_round_scroll=0;}
if(console_scroll_n==''){console_scroll_n=3;}
#
alias "toggleautoflip" "_autoflip=1\-_autoflip" "";
alias "toggleautonegate" "_autonegate=1\-_autonegate" "";
alias "toggleflip" "i:flipped=1\-i:flipped" "toggles flipped property on the current image";
alias "flip" "toggleflip;redisplay"        "flip the current image along the horizontal axis";
alias "fliponce" "flip;toggleflip"         "flip, but just for one display";
alias "toggleautomirror" "_automirror=1\-_automirror" "";
alias "togglemirror" "i:mirrored=1\-i:mirrored" "toggles mirrored property on the current image";
alias "mirror" "togglemirror;redisplay"         "mirror the image along the vertical axis" "";
alias "mirroronce" "mirror;togglemirror"        "mirror, but just for one display";
alias 'toggleLimitMarked' '__pre_limit_fileindex=_fileindex;_limit_mode=1\-_limit_mode; if(_limit_mode==1){limit "!";} else { limit; } if(_filelistlen<1){_limit_mode=0;limit;goto __pre_limit_fileindex;} i:fresh=1;redisplay; ' "toggle between limiting file list to the marked files and the full list";
alias "unlimit" "limit;i:fresh=1;reload;redisplay" "calling limit with no arguments restores the original list";
#alias 'mark_current_file' '_markedfile=i:_filename';
#alias 'goto_marked_file' 'goto "?"._markedfile';
alias 'mark_current_file' '_markedfile=_fileindex'; # Note: temporary; _markedfile undocumented.
alias 'goto_marked_file'  'goto _markedfile'; # Note: temporary.
# Warning : binding to C\-s, C\-z and C\-c won't make effect, as these
# codes are get caught by the console driver and will have no effect in fim.
# Moreover, C\-z will crash fim and C\-c will terminate it.
# Some other combinations (e.g.:C\-l) may have similar problems in your console.
bind 'f' "flip";
bind 'F' "fliponce";
bind 'm' "mirror";
bind 'M' "mirroronce";
bind 'q'   "quit";
bind 'Esc' "quit";
#bind 'n' "next_file";
#bind 'n' "next";
bind 'C\-h' "help";
#bind '?' "help"; # assigned to back\-search
#bind '/' "help"; # assigned to forward\-search
bind '=' "scale '100%'";
#bind 'p' "prev_file";
#alias 'list_remove_and_reload' "list 'remove';reload"; # once menus commands can support ;, remove this
bind 'Del' "list 'remove';reload"; # no quit on last file
#bind 'Del' "list_remove_and_reload"; # no quit on last file
#bind 'Del' "if(_filelistlen<2)quit;list 'remove';reload;"; # quit if no files left
#bind 's' "list 'sort'";
bind ' ' "scroll 'forward'";
bind 'S' "toggleDisplayStatus";
bind 'I' "toggleautonegate";
bind 'i' "color 'negate';redisplay";
bind 'g' "color 'desaturate';redisplay";
bind '[' 'font_reduce;redisplay';
bind ']' 'font_magnify;redisplay';
bind '|' 'toggle_font_auto_scale;redisplay';
bind '{' 'font "prev";redisplay';                                                                                                         
bind '}' 'font "next";redisplay';                                                                                                         
bind 'G' "toggleDesaturate";
bind 'r' "rotate90";
bind 'R' "rotate270";
bind '+' "magnify";
bind 'a' "scale 'a'";
bind 'H' "scale 'H'";
bind 'Tab'  "toggleVerbosity";
bind 'Menu' "toggleVerbosity";
bind 'v' "toggleDisplayStatus";
bind 'A' "A";
#bind 'C\-m' "list 'mark'";
bind 'C\-m' "mark_current_file";
bind 'C\-j' "goto_marked_file";
bind 'u'   "list 'unmark'";
bind 'Enter' "list 'mark';goto _lastgotodirection";
bind '\-' "reduce";
bind "Up" "pan_up";
bind 'k' "pan_up";
bind "Right" "pan_right";
bind 'l' "pan_right";
bind "Down" "pan_down";
bind 'j' "pan_down";
bind "Left" "pan_left";
bind 'h' "pan_left";
bind 't' "align 'top'";
bind 'C\-g' "system 'fbgrab' 'fim_'._device_string.'.png'"; # grab a screenshot
#bind 'C\-r' "recording 'start'";
bind 'C\-r' "reload ''";
bind 'Q' "recording 'stop'";
bind 'D' "recording 'dump'";
bind 'E' "recording 'execute'";
bind 'C\-e' "recording 'execute'";
bind 'C\-x' "recording 'execute'";
bind '.' "recording 'repeat_last'";
bind '`' "toggleLimitMarked";
alias "toggleVerbosity" "_display_console=1\-_display_console;i:fresh=1;redisplay" "";
alias "toggleKeyVerbosity" "_verbose_keys=1\-_verbose_keys;redisplay" "";
alias "toggleDesaturate" "_autodesaturate=1\-_autodesaturate;redisplay" "";
alias "idempotent_cmd" "goto ''";
#
# Autocommands examples:
#autocmd "PostInteractiveCommand" "fim.png" "echo '\\nmatched an interactive command on fim.png\\n'";
#autocmd "PostDisplay" ".*png" "echo 'this is a png file'";
#autocmd "PostDisplay" ".*jpg" "echo 'this is a jpg file'";
#autocmd "PostDisplay" "" "echo '\\nthis is a file\\n'";
#autocmd "PostGoto"   "" "set_interactive_mode";
autocmd "PostGoto"      "" "reload";
autocmd "PostWindow" ""   "i:fresh=1;redisplay;";
autocmd "PreRedisplay"  "" "i:_will_display=1";
autocmd "PreRedisplay"  "" "if(_scale_style!='' && i:fresh){i:fresh=0;scale _scale_style ;i:fresh=0;}";
autocmd "PostRedisplay" ""   "i:_will_display=0";
# Display device specific config
alias "aalib_fix_do" "{if(aascale==''){ascale='2.0';}else{ascale=aascale;} i:fresh=1;display;if(_TERM=~'screen'){echo 'Detected screen+aalib: key bindings may not work as intended.'}}" "See aalib_fix.";
alias "aalib_fix" "if(_device_string=~'^aa'){aalib_fix_do;scale 'a';}" "When using the aalib (ASCII art) library we face a problem: glyph proportions are seldom square (as pixels are), and are tricky to detect; for this reason, we need to reshape the image with respect to the font ratio, but we have to make a guess in the scaling factor to compensate. If at runtime a better value is known for the terminal font height/with ratio, it may be fed in the 'aascale' variable for an accurate scaling.";
alias "cacalib_fix_do" "{if(cacascale==''){ascale='1.18';}else{scale=cacascale;} i:fresh=1;display;if(_TERM=~'screen'){echo 'Detected screen+cacalib: key bindings may not work as intended.'}}" "See cacalib_fix.";
alias "cacalib_fix" "getenv 'DISPLAY';if(_device_string=~'^ca' && ENV_DISPLAY==''){cacalib_fix_do;scale 'a';}" "When using the libcaca (Coloured ASCII art) library we face a problem: glyph proportions are seldom square (as pixels are), and are tricky to detect; for this reason, we need to reshape the image with respect to the font ratio, but we have to make a guess in the scaling factor to compensate. If at runtime a better value is known for the terminal font height/with ratio, it may be fed in the 'cacascale' variable for an accurate scaling.";
autocmd "PostReload"  "" "aalib_fix";
autocmd "PostLoad"    "" "aalib_fix";
autocmd "PostReload"  "" "cacalib_fix";
autocmd "PostLoad"    "" "cacalib_fix";
alias "refresh" "desc 'reload';redisplay;" "reloads and displays image description";
bind "F5" "refresh";
alias "toggle_fullscreen" "if( (_device_string=~'^sdl' || _device_string=~'^gtk' ) && !_fullscreen){_old_sw=_screen_width;_old_sh=_screen_height;display 'reinit' 'mW0:0';_fullscreen=1;}else if( (_device_string=~'^sdl' || _device_string=~'^gtk' ) && _old_sw*_old_sh*_fullscreen){display 'reinit' 'rwm'._old_sw.':'._old_sh;_fullscreen=0;}_gtk_fullscreen=_fullscreen;" "Toggles full screen. Will show mouse cursor in full screen.";
alias "_gtk_check_for_toggle_fullscreen" "if( _device_string=~'^gtk' && _gtk_fullscreen != _fullscreen){toggle_fullscreen;}";
alias "_gtk_check_for_toggle_gtk_menus" "if(_device_string=~'^gtk'){if(_hide_gtk_menus){display 'reinit' 'b';}else{display 'reinit' 'B';}}";
bind "F11" "toggle_fullscreen";

autocmd "PostReload"  "" "i:fresh=1" ;
autocmd "PostScale"   "" "if(0==i:_will_display){i:fresh=1;display;}" ;
autocmd "PostPan"     "" "{i:fresh=1;display;}" ;
#autocmd "PostReload"   "pdf|ps|djvu|dvi" "scale 'w';align 'top'";
autocmd "PostReload"   "" "if(i:fresh){redisplay;}";
autocmd "PostInteractiveCommand"   "" "if(i:fresh){display;i:fresh=0;}";
autocmd "PostInteractiveCommand"   "" "if(_want_prefetch>0){prefetch;}";
autocmd "PostInteractiveCommand"   "" "if(_display_console==0 && i:fresh){redisplay;i:fresh=0;}";
autocmd "PostInteractiveCommand"   "" "idempotent_cmd"; # Bug workaround: without it console scroll is broken.
autocmd "PostInteractiveCommand"   "" "_gtk_check_for_toggle_gtk_menus;_gtk_check_for_toggle_fullscreen";

#alias "next10" "i=0;while(i<10){i=i+1;next;display;sleep '1';}" "goes forward 10 images";
#alias "prev10" "i=0;while(i<10){i=i+1;prev;display;sleep '1';}" "goes backward 10 images";
bind 'N' "goto '+1p' '+museum|series|city|category|artist+' '+/S' '+10';" "goto by jump or category or directory or just ahead";
bind 'P' "goto '\-1p' '\-museum|series|city|category|artist+' '\-/S' '\-10';" "goto by jump or category or directory or just back ";
bind 'C\-n' "goto '+//'";
bind 'C\-p' "goto '\-//'";
bind 'C\-b' "goto '\-//'"; # Warning: many configurations cannot detect C\-b.
bind 'W' "display 'resize'" "if supported, resizes the window to match the current image pixels size";
#bind 'C\-w' "scale '100%';display 'resize'" "if supported, scales the image to 100% and resizes the window to match its size (if fits)";
bind 'C\-w' "if(_scale_style!='w'){_scale_style='w';scale 'w';}else{_scale_style='';scale '100%';}" "scale to width";
alias "endless_slideshow" "while(1){display;sleep _slideshow_sleep_time;next;}" "performs an automated slideshow, endlessly";
alias "bookview"          "while(1){display;sleep '2';scroll 'down';}" "";
alias "comicview"         "while(1){display;sleep '2';scroll 'down';}" "";
alias "read"              "while(1){display;sleep '2';scroll 'forward';}" "";
alias "slowread"          "while(_fileindex<=_filelistlen\-1){display;sleep '2';scroll 'forward';}" "loop once slowly";
alias "fastread"          "while(_fileindex<=_filelistlen\-1){display;sleep '0.1';scroll 'forward';}" "proceeds like in a book but very fast, once";
alias "pornview"          "echo 'press any key repeatedly to terminate' ;endless_slideshow" "enters an endless slideshow (alias name from an actual image viewer)";
autocmd "PreExecutionCycle" "/fbps\-" "_display_busy=0;_display_status=0" ;
autocmd "PreExecutionCycle" "" "i:fresh=1;reload";
autocmd "PreExecutionCycle" "/fbps\-.*ps001.png" "i:fresh=1;redisplay";
## Example in imposing a file loader to an extension:
#autocmd "PreReload"    ".*mtx.gz" "_file_loader='MatrixMarket'";
#autocmd "PostReload"   ".*mtx.gz" "_file_loader=''";
bind '*' "_display_console=0;toggleVerbosity;echo i:*";
bind 'w' "scale 'w'";
bind '<' "rotate10_ccw;display";
bind '>' "rotate10;display";
bind '_' "_scale_style='';scale '100%'";
bind ',' "_display_console=1;echo _last_system_output";
bind 'C\-a' "if(_scale_style!='a'){_scale_style='a';scale 'a';}else{_scale_style='';scale '100%';}" "scale to height";
#
alias "pan_nw" "pan 'nw'" "pans the image to the upper left";
alias "pan_ne" "pan 'ne'" "pans the image to the upper right";
alias "pan_se" "pan 'se'" "pans the image to the lower left";
alias "pan_sw" "pan 'sw'" "pans the image to the lower right";
alias "pan_down" "if(_display_console==0){pan 'down';}else{scd;}" "pans the image down / scrolls console down";
alias "pan_up"   "if(_display_console==0){pan 'up'  ;}else{scu;}"   "pans the image up / scrolls console up";
alias "pan_left" "pan 'left'" "pans the image left";
alias "pan_right" "pan 'right'" "pans the image right";
alias "diagonal_nw" "pan_nw" "pans the image to the upper left";
alias "diagonal_ne" "pan_ne" "pans the image to the upper right";
alias "diagonal_se" "pan_se" "pans the image to the lower left";
alias "diagonal_sw" "pan_sw" "pans the image to the lower right";
bind 'd' "diagonal_nw";
bind 'D' "diagonal_se";
bind 'x' "diagonal_ne";
bind 'X' "diagonal_sw";
alias "toggleDisplayStatus" "_display_status=1\-_display_status;redisplay" "";
alias "toggleDisplayBusy"   "_display_busy=1\-_display_busy" "";
alias "sort" "list 'sort'"  "sorts the files list ordered";
bind 'o' "sort";
bind 'b' "prev";
bind 'B' "toggleDisplayBusy";
alias "random_slideshow" "while(1){display;sleep _slideshow_sleep_time; eval 'r=random';goto r;}" "performs a shuffled slideshow, endlessly";
alias "rotate90_ccw" "i:_orientation=i:_orientation+3;i:fresh=1;redisplay" "rotate 90 degrees counter clockwise";
alias "rotate90_cw"  "i:_orientation=i:_orientation+1;i:fresh=1;redisplay" "rotate 90 degrees clockwise";
alias "rotate180"  "i:_orientation=i:_orientation+2;i:fresh=1;redisplay" "rotate 180 degrees";
alias "rotate90" "rotate90_cw;display" "rotate 90 degrees clockwise";
alias "rotate270" "rotate90_ccw;display" "rotate 90 degrees counter clockwise";
alias "rotate10"     "rotate  '10';display" "rotate 10 degrees counter clockwise";
alias "rotate10_ccw" "rotate \-10  ;display" "rotate 10 degrees clockwise";

bind 'K' 'if(_display_console==0){echo i:_filename.": ".i:_comment;toggleVerbosity}else{toggleVerbosity;}';
bind 'C\-k' 'crop' # still experimental

alias 'cache' 'echo _cache_status' "displays cached images status";
bind 'c' 'align "center"';
alias 'widen'  'i:ascale=i:ascale*"1.1";*1.0' "widen the current image";
alias 'narrow' 'i:ascale=i:ascale/"1.1";*1.0' "narrow the current image";
bind  'y' "widen" "widen horizontally the image";
bind  'Y' "narrow" "shrink horizontally the image";
alias 'console_scroll_up' 'if(_console_offset<_console_lines+console_scroll_n\-_rows){_console_offset=_console_offset+console_scroll_n;}' "scrolls up the virtual console";
alias 'console_scroll_down' 'if(allow_round_scroll || (_console_offset>=console_scroll_n)){_console_offset=_console_offset\-console_scroll_n;}' "scrolls down the virtual console";
alias 'console_scroll_reset' '{_console_offset=0;}';
alias 'scu'    'console_scroll_up'   "";
alias 'scd'    'console_scroll_down' "";
alias 'scz'    'console_scroll_reset' "";
alias 'center' 'align "center"';
alias 'left'   'align "left"';
alias 'right'  'align "right"';
alias 'top'    'align "top"';
alias 'bottom' 'align "bottom"';
alias "font_magnify_auto" "if(_fbfont_as_screen_fraction>1){_fbfont_as_screen_fraction=_fbfont_as_screen_fraction\-1;}else{_fbfont_as_screen_fraction=_screen_width/100+_screen_height/100;}" "";
alias "font_magnify_manual"      "_fbfont_magnify_factor=_fbfont_magnify_factor+1" "";
alias "font_reduce_auto"  "if(_fbfont_as_screen_fraction>1){_fbfont_as_screen_fraction=_fbfont_as_screen_fraction+1;}" "";
alias "font_reduce_manual"       "_fbfont_magnify_factor=_fbfont_magnify_factor\-1" "";
alias "toggle_font_auto_scale" "if(_fbfont_as_screen_fraction<0){_fbfont_as_screen_fraction=0;echo 'Auto font scaling on.';}else{_fbfont_as_screen_fraction=\-1;echo 'Auto font scaling off.';}" "toggles between manual and auto font scaling control";
alias 'next_file_same_search'      "goto '+//';" "go to next file with same search criteria";
alias 'next_file_dir_same'      "goto '+/s';" "go to next file in same dir";
alias 'next_file_dir_other'     "goto '+/S';" "go to next file in other dir";
alias 'next_file_dir_up'        "goto '+/u';" "go to next file up the dir hierarchy";
alias 'next_file_dir_down'      "goto '+/d';" "go to next file down the dir hierarchy";
alias 'next_file_same_basename' "goto '+/b';" "go to next file with same basename";
alias 'prev_file_dir_same'      "goto '\-/s';" "go to prev file in same dir";
alias 'prev_file_dir_other'     "goto '\-/S';" "go to prev file in other dir";
alias 'prev_file_dir_up'        "goto '\-/u';" "go to prev file up the dir hierarchy";
alias 'prev_file_dir_down'      "goto '\-/d';" "go to prev file down the dir hierarchy";
alias 'prev_file_same_basename' "goto '\-/b';" "go to prev file with same basename";
#alias "font_magnify" "if(_fbfont_as_screen_fraction<0) {font_magnify_manual;}else{font_magnify_auto;}" "increase font size (either relative or absolute)";
#alias "font_reduce"  "if(_fbfont_as_screen_fraction<0) {font_reduce_manual;} else{font_reduce_auto;}"  "increase font size (either relative or absolute)";
alias "font_magnify" "_fbfont_as_screen_fraction=\-1;font_magnify_manual" "increase absolute font size and set manual font control";
alias "font_reduce"  "_fbfont_as_screen_fraction=\-1;font_reduce_manual"  "decrease absolute font size and set manual font control";
bind "PageUp" "if(_display_console==0){prev;}else{scu;}";
bind "PageDown" "if(_display_console==0){next;}else{scd;}";
bind "Home" "0;";
bind "End" "$;";
bind "^" "0;";
bind "$" "$;";
#bind "Backspace" "prev"; # console code for C\-h and Backspace is the same :\-)
bind "'" "goto _lastfileindex.'f'.(_lastpageindex+1).'p'";
bind '"' "scale 'shadow';i:fresh=1;redisplay;"; 
bind '(' "goto '^p'";
bind ')' "goto '$p'";
bind 'Z' "sleep 1";
_display_status=1; # lower status line
_want_wm_caption_status="fim:%N@%p%%%L[%i/%l]";
_caption_over_image_fmt="%?_comment?%:_comment:?";
_info_fmt_str="%p%% %wx%h%L %i/%l%P %F %T %c"; # lower right line part
#_display_status_fmt="%N:%k"; #
_display_status_fmt="%N%?EXIF_DateTimeOriginal?[%:EXIF_DateTimeOriginal:]?%?EXIF_ExposureTime?[%:EXIF_ExposureTime:]?%?EXIF_FNumber?[%:EXIF_FNumber:]?%?EXIF_ApertureValue?[%:EXIF_ApertureValue:]?%?EXIF_ISOSpeedRatings?[ISO%:EXIF_ISOSpeedRatings:]?%?_markedfile?[mark on %:_markedfile:]?:%k"; # lower left line part
# funny aliases:
alias "webcam" "pread 'vgrabbj \-d /dev/video0';$" "say cheese";
alias 'espeak' 'system \e'espeak\e' i:_filename." ".i:_comment' 'say something';
#_fbfont_as_screen_fraction=\-1; # disable auto font scaling
if( _device_string=~'^gtk[^e]*$' ) {
	alias "man_fim"   "system 'man' 'fim';  _display_console=0;toggleVerbosity;";
	alias "man_fimrc" "system 'man' 'fimrc';_display_console=0;toggleVerbosity;";
	alias '_rebuild_menus' 'display "reinit" "f";';
	alias '_rebuild_quieter_menus' '_debug_commands=_debug_commands\-"m";display "reinit" "fV";'; # remove "m" occurrences from _debug_commands and rebuild
	alias '_rebuild_verboser_menus' '_debug_commands=_debug_commands."m";_rebuild_menus;';
	alias '_rebuild_verbosest_menus' '_debug_commands=_debug_commands."mm";_rebuild_menus;';
	alias 'toggle_gtk_menus' 'if(!_hide_gtk_menus){_hide_gtk_menus=1;}else{_hide_gtk_menus=0;}';
	autocmd "PreInteractiveCommand"  "" "if(__internal_state_changed){_rebuild_menus;__internal_state_changed=0;}";
	autocmd "PostInteractiveCommand" "" "if(__internal_state_changed){_rebuild_menus;__internal_state_changed=0;}";
	autocmd "PreExecutionCycle"      "" "if(__internal_state_changed){_rebuild_menus;__internal_state_changed=0;}";
	display "menuadd" 
		"_File/"
		"_File/_Open file  open  C\-o"
		"_File/Open _directory  open_dir  "
		"_File/_Next file or page  next  "
		"_File/_Next file  next_file  "
		"_File/_Next in other directory  next_file_dir_other"
		"_File/_Next in this directory  next_file_dir_same"
#		"_File/_Next as last search  goto +\/\/  " # Note that slashes are not supported currently.
		"_File/_Next as last search  next_file_same_search  "
		"_File/_Go back to last file  goto _lastfileindex  "
		"_File/_Previous in list  prev  p"
#		"_File/Remove from list  list 'pop'"
#		"_File/Remove from list  list_remove_and_reload  "
		"_File/Remove from list  list 'remove';reload  "
		"_File/Mark  list 'mark'"
		"_File/Unmark  list 'unmark'"
		"_File/_Quit  quit  q"
		"_List/Show  list"
		"_List/_Limit  FimMenuLimit/"
		"_List/Limit to.../files sized as current one  limit '~z'" # 
		"_List/Limit to.../files dated as current one  limit '~d'"
		"_List/Limit to.../files with duplicate basename  limit '~='"
		"_List/_Unlimit list (reset)  unlimit  u"
		"_List/Reverse  list 'reverse'  "
		"_List/Sort by name  list 'sort'  "
		"_List/Sort by size  list 'sort_fsize'  "
		"_List/Sort by time  list 'sort_mtime'  "
		"_List/Shuffle randomly  list 'random_shuffle'  "
		"_List/Mark all  list 'markall'  "
		"_List/Slideshow/Random  random_slideshow  "
		"_List/Slideshow/Endless  endless_slideshow  "
		"_List/Slideshow/Slideshow time: 0 s  _slideshow_sleep_time=0    0.5 s  _slideshow_sleep_time=0.5    1 s  _slideshow_sleep_time=1    2 s  _slideshow_sleep_time=2    3 s  _slideshow_sleep_time=3    "
		"_List/Slideshow/Stop  _stop_slideshow=1  "
		"_List/Slideshow/Slow read  slowread  "
		"_List/Slideshow/Fast read  fastread  "
		"_View/  Automirror  toggle||_automirror||1||0  " # '  ' as external separator, || as internal separator
		"_View/||Autoflip||toggle.._autoflip..1..0||" # || as external separator, .. as internal separator
#		"_View/Scale: _auto  _scale_style=a  a  Scale: by _hand (manual)  _scale_style=m  m  Scale: by _width  _scale_style=w  w  Scale: by _height  _scale_style=h  h"
		"_View/**Scale: 1x**_scale_style= ** **Scale: _auto**_scale_style=a**a**Scale: _auto (till 100%)**_scale_style=b**b**Scale: by _hand (manual)**_scale_style=m**m**Scale: by window _width**_scale_style=w**w**Scale: by window _height**_scale_style=h**h"
		"_View/Orientation: normal  _orientation=0    Orientation: 90'right  _orientation=1    Orientation: upside down  _orientation=2    Orientation: 90' left  _orientation=3  "
		"_View/Desaturate  toggle___autodesaturate__1__0  "
		"_View/Autonegate  toggle___autonegate__1__0  "
		"_View/Vertical scroll/** Default steps: auto**_vsteps=****10%**_vsteps=10%****20%**_vsteps=20%****50%**_vsteps=50%****100%**_vsteps=100%**"
		"_View/Vertical scroll/** Skip page fraction if smaller than ...auto**_scroll_skip_page_fraction=****disabled**_scroll_skip_page_fraction=\-1****1/8**_scroll_skip_page_fraction=8****1/16**_scroll_skip_page_fraction=16**"
		"_View/Refresh description & co  refresh  "
		"_View/||Apply EXIF Orientation||toggle.._want_exif_orientation..1..0||"
		"_Image/_Mirror  toggle__i:mirrored__1__0  m"
		"_Image/_Flip  toggle&&i:flipped&&1&&0  f" # && as internal separator
#		"_Image Extras/_Let's Flip again  toggle&&i:flipped&&1&&0  f" # && as internal separator 
		"_Image/Orientation: normal  i:_orientation=0    Orientation: 90'right  i:_orientation=1    Orientation: upside down  i:_orientation=2    Orientation: 90' left  i:_orientation=3  "
		"_Image/EXIF Orientation: normal  i:_exif_orientation=0    EXIF Orientation: 90'right  i:_exif_orientation=1    EXIF Orientation: upside down  i:_exif_orientation=2    EXIF Orientation: 90' left  i:_exif_orientation=3  " # previously __exif_orientation but renamed for the double\-symbol\-separator convention
		"_Window/_Fullscreen  toggle**_gtk_fullscreen**1**0  F11"
		"_Window/Hide the menu bar (press mouse button to restore)  toggle_gtk_menus"
#		"_Window/Hide menu bar (press mouse button to restore)  toggle||_hide_gtk_menus||0||1" # not yet ready to replace toggle_gtk_menus
		"_Window/Resize window to image size  display 'resize'"
		"_Window/Text size reduce  font_reduce"
		"_Window/Text size magnify  font_magnify"
		"_Window/Text font: next  font 'next'"
		"_Window/Text font: prev  font 'prev'"
		"_Window/Show status line  toggle||_display_status||1||0  "
		"_Window/Caption over image: None  _caption_over_image=0    Caption over image: No background  _caption_over_image=1    Caption over image: Black background  _caption_over_image=2    Caption over image: Above image, no overlap  _caption_over_image=3  "
		"_Window/Window caption: minimal  _want_wm_caption_status=FIM    Window caption: reasonable  _want_wm_caption_status=fim:[%i/%l]    Window caption: rich  _want_wm_caption_status=fim:%N@%p%%%L[%i/%l]%?EXIF_DateTimeOriginal?[%:EXIF_DateTimeOriginal:]?  "
		"_Window/Mouse click help grid: default  _want_wm_mouse_ctrl='pP+a\-=nN    Mouse click help grid: simplified  _want_wm_mouse_ctrl=ppp+a\-nnn  "
		"_Advanced/Show output console (then hide with Tab)  toggleVerbosity  v"
		"_Advanced/Verbose keys  toggle___verbose_keys__1__0  "
		"_Advanced/Low execution verbosity  _debug_commands=0    Intermediate execution verbosity  _debug_commands=ackCm    High execution verbosity  _debug_commands=ackCmmi  "
		"_Advanced/Rebuild menus with no verbosity  _rebuild_quieter_menus"
		"_Advanced/Rebuild menus with tooltips  _rebuild_verboser_menus"
		"_Advanced/Rebuild menus very verbosely  _rebuild_verbosest_menus"
		"_Advanced/Verbose menu  toggle||_display_busy||1||0"
		"_Advanced/Downscale huge images on load  toggle||_downscale_huge_at_load||1||0"
		"_Advanced/Background prefetch  _want_prefetch=2    Foreground prefetch  _want_prefetch=1    No prefetch  _want_prefetch=0    "
		"_Custom actions/_Mark current file  mark_current_file"
		"_Custom actions/_Go to marked file  goto_marked_file"
		"_Custom actions/Webcam shot (needs vgrabbj)  webcam"
		"_Custom actions/Say something (needs espeak)  espeak"
		"_Custom actions/Max cached memory: 256MiB  _max_cached_memory=262144    unlimited  _max_cached_memory=0    very little  _max_cached_memory=1    80MiB  _max_cached_memory=81920  "
		"_Custom actions/Max cached images: unlimited  _max_cached_images=0    5  _max_cached_images=5    10  _max_cached_images=10    100  _max_cached_images=100  "
		"_All actions/_Commands  FimMenuCommands/"
		"_All actions/_Aliases  FimMenuAliases/"
		"_All actions/_Key Bindings  FimMenuKeyBindings/"
		"_All actions/_Variables  FimMenuVariables/"
		"_Help/_Commands  FimMenuCommandsHelp/"
		"_Help/_Aliases  FimMenuAliasesHelp/"
		"_Help/_Key Bindings  FimMenuKeyBindingsHelp/"
		"_Help/_Variables  FimMenuVariablesHelp/"
		"_Help/_man FIM  man_fim"
		"_Help/_man fimrc  man_fimrc";
		#"_Custom actions/scaling: _auto  _scale_style=a  a  scaling: _auto to original  _scale_style=b  b  scaling: manual  _scale_style=m  m  scaling: by _width  _scale_style=w  w" # copy for demo purposes
		#"_Custom actions/_Toggle flipped flag  toggle__i:flipped__1__0  f"
		#"_Custom actions/_Submenu/_Frobnicate  unmapped_cmd  /"
		#"_Custom actions/_Submenu/_Defrobnicate  unmapped_cmd  u"
		#"_Custom actions/_Submenu/FimMenuLimit  FimMenuLimit/"
		#"_Custom actions/_Submenu/_Do\-frobnicate  unmapped_cmd *" # bad specification
		#"_Custom actions/_Submenu/_Fribnikate  frobnicate  unmapped_cmd *" # bad specification
		#"_Custom actions/_Submenu/_Next  next *" # bad specification
		#"_Custom actions/_Add menu...  menu_dialog"
		#"_Custom actions/_Toggle full screen view  toggle		_gtk_fullscreen		1		0"
		if (_last_cmd_output!="") quit \-1;
}
help ''; # WELCOME...
# More examples:
#alias "plisten" 'popen "nc \-l \-p 9999 "' "executes fim commands coming from port 9999 on this computer";
#alias "wlisten" "while(1){sleep;plisten;}" "listen to a pipe, endlessly";
#alias "musicplay"  "system 'mpc' 'play'" "";
#alias "musicpause" "system 'mpc' 'pause'" "";
#alias "rdjpgcom" 'system "rdjpgcom" i:_filename';
# offsetscan usage : need a mechanism for popping all images before.
#alias "offsetscan" "while(i:width<1){list 'push' 'blob.jpg';stdout _open_offset ;_open_offset=_open_offset+1;reload;}";
#alias "webcam_cycle" "while(1){webcam;reload;sleep 1;}";
# This is a FIM initialization file. 
# Without it FIM cannot work like it should.
# Feel free to modify it, but with caution!

.SH NOTES
This manual page could be improved.
Certain side effects of commands are not documented.
Neither a formal description of the various commands.
Interaction of commands and variables is also not completely documented.
.SH BUGS
The
.B fim
language shall be more liberal with quoting.
.SH SEE ALSO
\fR\fIfim\fR(1), \fR\fIfimgs\fR(1), \fR\fIregex\fR(1).
.SH AUTHOR
Michele Martone <dezperado _CUT_ autistici _CUT_ org>
.SH COPYRIGHT
See copyright notice in \fR\fIfim\fR(1).


