// DO NOT EDIT!  This file is generated by sdlgenblit.pl
/*
  Simple DirectMedia Layer
  Copyright (C) 1997-2025 Sam Lantinga <slouken@libsdl.org>

  This software is provided 'as-is', without any express or implied
  warranty.  In no event will the authors be held liable for any damages
  arising from the use of this software.

  Permission is granted to anyone to use this software for any purpose,
  including commercial applications, and to alter it and redistribute it
  freely, subject to the following restrictions:

  1. The origin of this software must not be misrepresented; you must not
     claim that you wrote the original software. If you use this software
     in a product, an acknowledgment in the product documentation would be
     appreciated but is not required.
  2. Altered source versions must be plainly marked as such, and must not be
     misrepresented as being the original software.
  3. This notice may not be removed or altered from any source distribution.
*/
#include "SDL_internal.h"

#ifdef SDL_HAVE_BLIT_AUTO

/* *INDENT-OFF* */ // clang-format off

#include "SDL_blit.h"
#include "SDL_blit_auto.h"

static void SDL_Blit_XRGB8888_XRGB8888_Scale(SDL_BlitInfo *info)
{
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            *dst = *src;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_XRGB8888_XRGB8888_Blend(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            srcpixel = *src;
            srcR = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcB = (Uint8)srcpixel;
            dstpixel = *dst;
            dstR = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstB = (Uint8)dstpixel;
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                dstR = srcR;
                dstG = srcG;
                dstB = srcB;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                dstR = srcR;
                dstG = srcG;
                dstB = srcB;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            }
            dstpixel = (dstR << 16) | (dstG << 8) | dstB;
            *dst = dstpixel;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_XRGB8888_XRGB8888_Blend_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            srcpixel = *src;
            srcR = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcB = (Uint8)srcpixel;
            dstpixel = *dst;
            dstR = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstB = (Uint8)dstpixel;
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                dstR = srcR;
                dstG = srcG;
                dstB = srcB;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                dstR = srcR;
                dstG = srcG;
                dstB = srcB;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            }
            dstpixel = (dstR << 16) | (dstG << 8) | dstB;
            *dst = dstpixel;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_XRGB8888_XRGB8888_Modulate(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    Uint32 pixelvalue;
    Uint32 R, G, B;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            pixelvalue = *src;
            R = (Uint8)(pixelvalue >> 16); G = (Uint8)(pixelvalue >> 8); B = (Uint8)pixelvalue;
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(R, modulateR, R);
                MULT_DIV_255(G, modulateG, G);
                MULT_DIV_255(B, modulateB, B);
            }
            pixelvalue = (R << 16) | (G << 8) | B;
            *dst = pixelvalue;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_XRGB8888_XRGB8888_Modulate_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    Uint32 pixelvalue;
    Uint32 R, G, B;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            pixelvalue = *src;
            R = (Uint8)(pixelvalue >> 16); G = (Uint8)(pixelvalue >> 8); B = (Uint8)pixelvalue;
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(R, modulateR, R);
                MULT_DIV_255(G, modulateG, G);
                MULT_DIV_255(B, modulateB, B);
            }
            pixelvalue = (R << 16) | (G << 8) | B;
            *dst = pixelvalue;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_XRGB8888_XRGB8888_Modulate_Blend(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 srcpixel;
    const Uint32 srcA = (flags & SDL_COPY_MODULATE_ALPHA) ? modulateA : 0xFF;
    Uint32 srcR, srcG, srcB;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            srcpixel = *src;
            srcR = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcB = (Uint8)srcpixel;
            dstpixel = *dst;
            dstR = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstB = (Uint8)dstpixel;
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(srcR, modulateR, srcR);
                MULT_DIV_255(srcG, modulateG, srcG);
                MULT_DIV_255(srcB, modulateB, srcB);
            }
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstR << 16) | (dstG << 8) | dstB;
            *dst = dstpixel;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_XRGB8888_XRGB8888_Modulate_Blend_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 srcpixel;
    const Uint32 srcA = (flags & SDL_COPY_MODULATE_ALPHA) ? modulateA : 0xFF;
    Uint32 srcR, srcG, srcB;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            srcpixel = *src;
            srcR = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcB = (Uint8)srcpixel;
            dstpixel = *dst;
            dstR = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstB = (Uint8)dstpixel;
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(srcR, modulateR, srcR);
                MULT_DIV_255(srcG, modulateG, srcG);
                MULT_DIV_255(srcB, modulateB, srcB);
            }
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstR << 16) | (dstG << 8) | dstB;
            *dst = dstpixel;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_XRGB8888_XBGR8888_Scale(SDL_BlitInfo *info)
{
    Uint32 pixelvalue;
    Uint32 R, G, B;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            pixelvalue = *src;
            R = (Uint8)(pixelvalue >> 16); G = (Uint8)(pixelvalue >> 8); B = (Uint8)pixelvalue;
            pixelvalue = (B << 16) | (G << 8) | R;
            *dst = pixelvalue;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_XRGB8888_XBGR8888_Blend(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            srcpixel = *src;
            srcR = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcB = (Uint8)srcpixel;
            dstpixel = *dst;
            dstB = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstR = (Uint8)dstpixel;
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                dstR = srcR;
                dstG = srcG;
                dstB = srcB;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                dstR = srcR;
                dstG = srcG;
                dstB = srcB;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            }
            dstpixel = (dstB << 16) | (dstG << 8) | dstR;
            *dst = dstpixel;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_XRGB8888_XBGR8888_Blend_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            srcpixel = *src;
            srcR = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcB = (Uint8)srcpixel;
            dstpixel = *dst;
            dstB = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstR = (Uint8)dstpixel;
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                dstR = srcR;
                dstG = srcG;
                dstB = srcB;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                dstR = srcR;
                dstG = srcG;
                dstB = srcB;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            }
            dstpixel = (dstB << 16) | (dstG << 8) | dstR;
            *dst = dstpixel;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_XRGB8888_XBGR8888_Modulate(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    Uint32 pixelvalue;
    Uint32 R, G, B;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            pixelvalue = *src;
            R = (Uint8)(pixelvalue >> 16); G = (Uint8)(pixelvalue >> 8); B = (Uint8)pixelvalue;
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(R, modulateR, R);
                MULT_DIV_255(G, modulateG, G);
                MULT_DIV_255(B, modulateB, B);
            }
            pixelvalue = (B << 16) | (G << 8) | R;
            *dst = pixelvalue;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_XRGB8888_XBGR8888_Modulate_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    Uint32 pixelvalue;
    Uint32 R, G, B;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            pixelvalue = *src;
            R = (Uint8)(pixelvalue >> 16); G = (Uint8)(pixelvalue >> 8); B = (Uint8)pixelvalue;
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(R, modulateR, R);
                MULT_DIV_255(G, modulateG, G);
                MULT_DIV_255(B, modulateB, B);
            }
            pixelvalue = (B << 16) | (G << 8) | R;
            *dst = pixelvalue;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_XRGB8888_XBGR8888_Modulate_Blend(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 srcpixel;
    const Uint32 srcA = (flags & SDL_COPY_MODULATE_ALPHA) ? modulateA : 0xFF;
    Uint32 srcR, srcG, srcB;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            srcpixel = *src;
            srcR = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcB = (Uint8)srcpixel;
            dstpixel = *dst;
            dstB = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstR = (Uint8)dstpixel;
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(srcR, modulateR, srcR);
                MULT_DIV_255(srcG, modulateG, srcG);
                MULT_DIV_255(srcB, modulateB, srcB);
            }
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstB << 16) | (dstG << 8) | dstR;
            *dst = dstpixel;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_XRGB8888_XBGR8888_Modulate_Blend_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 srcpixel;
    const Uint32 srcA = (flags & SDL_COPY_MODULATE_ALPHA) ? modulateA : 0xFF;
    Uint32 srcR, srcG, srcB;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            srcpixel = *src;
            srcR = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcB = (Uint8)srcpixel;
            dstpixel = *dst;
            dstB = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstR = (Uint8)dstpixel;
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(srcR, modulateR, srcR);
                MULT_DIV_255(srcG, modulateG, srcG);
                MULT_DIV_255(srcB, modulateB, srcB);
            }
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstB << 16) | (dstG << 8) | dstR;
            *dst = dstpixel;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_XRGB8888_ARGB8888_Scale(SDL_BlitInfo *info)
{
    Uint32 pixelvalue;
    const Uint32 A = 0xFF;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            pixelvalue = *src;
            pixelvalue |= (A << 24);
            *dst = pixelvalue;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_XRGB8888_ARGB8888_Blend(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB, dstA;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            srcpixel = *src;
            srcR = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcB = (Uint8)srcpixel;
            dstpixel = *dst;
            dstR = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstB = (Uint8)dstpixel; dstA = (Uint8)(dstpixel >> 24);
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                dstR = srcR;
                dstG = srcG;
                dstB = srcB;
                dstA = 0xFF;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                dstR = srcR;
                dstG = srcG;
                dstB = srcB;
                dstA = 0xFF;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            }
            dstpixel = (dstA << 24) | (dstR << 16) | (dstG << 8) | dstB;
            *dst = dstpixel;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_XRGB8888_ARGB8888_Blend_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB, dstA;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            srcpixel = *src;
            srcR = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcB = (Uint8)srcpixel;
            dstpixel = *dst;
            dstR = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstB = (Uint8)dstpixel; dstA = (Uint8)(dstpixel >> 24);
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                dstR = srcR;
                dstG = srcG;
                dstB = srcB;
                dstA = 0xFF;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                dstR = srcR;
                dstG = srcG;
                dstB = srcB;
                dstA = 0xFF;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            }
            dstpixel = (dstA << 24) | (dstR << 16) | (dstG << 8) | dstB;
            *dst = dstpixel;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_XRGB8888_ARGB8888_Modulate(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 pixelvalue;
    const Uint32 A = (flags & SDL_COPY_MODULATE_ALPHA) ? modulateA : 0xFF;
    Uint32 R, G, B;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            pixelvalue = *src;
            R = (Uint8)(pixelvalue >> 16); G = (Uint8)(pixelvalue >> 8); B = (Uint8)pixelvalue;
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(R, modulateR, R);
                MULT_DIV_255(G, modulateG, G);
                MULT_DIV_255(B, modulateB, B);
            }
            pixelvalue = (A << 24) | (R << 16) | (G << 8) | B;
            *dst = pixelvalue;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_XRGB8888_ARGB8888_Modulate_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 pixelvalue;
    const Uint32 A = (flags & SDL_COPY_MODULATE_ALPHA) ? modulateA : 0xFF;
    Uint32 R, G, B;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            pixelvalue = *src;
            R = (Uint8)(pixelvalue >> 16); G = (Uint8)(pixelvalue >> 8); B = (Uint8)pixelvalue;
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(R, modulateR, R);
                MULT_DIV_255(G, modulateG, G);
                MULT_DIV_255(B, modulateB, B);
            }
            pixelvalue = (A << 24) | (R << 16) | (G << 8) | B;
            *dst = pixelvalue;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_XRGB8888_ARGB8888_Modulate_Blend(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 srcpixel;
    const Uint32 srcA = (flags & SDL_COPY_MODULATE_ALPHA) ? modulateA : 0xFF;
    Uint32 srcR, srcG, srcB;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB, dstA;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            srcpixel = *src;
            srcR = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcB = (Uint8)srcpixel;
            dstpixel = *dst;
            dstR = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstB = (Uint8)dstpixel; dstA = (Uint8)(dstpixel >> 24);
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(srcR, modulateR, srcR);
                MULT_DIV_255(srcG, modulateG, srcG);
                MULT_DIV_255(srcB, modulateB, srcB);
            }
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                if (dstA > 255) dstA = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstA << 24) | (dstR << 16) | (dstG << 8) | dstB;
            *dst = dstpixel;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_XRGB8888_ARGB8888_Modulate_Blend_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 srcpixel;
    const Uint32 srcA = (flags & SDL_COPY_MODULATE_ALPHA) ? modulateA : 0xFF;
    Uint32 srcR, srcG, srcB;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB, dstA;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            srcpixel = *src;
            srcR = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcB = (Uint8)srcpixel;
            dstpixel = *dst;
            dstR = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstB = (Uint8)dstpixel; dstA = (Uint8)(dstpixel >> 24);
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(srcR, modulateR, srcR);
                MULT_DIV_255(srcG, modulateG, srcG);
                MULT_DIV_255(srcB, modulateB, srcB);
            }
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                if (dstA > 255) dstA = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstA << 24) | (dstR << 16) | (dstG << 8) | dstB;
            *dst = dstpixel;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_XRGB8888_ABGR8888_Scale(SDL_BlitInfo *info)
{
    Uint32 pixelvalue;
    const Uint32 A = 0xFF;
    Uint32 R, G, B;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            pixelvalue = *src;
            R = (Uint8)(pixelvalue >> 16); G = (Uint8)(pixelvalue >> 8); B = (Uint8)pixelvalue;
            pixelvalue = (A << 24) | (B << 16) | (G << 8) | R;
            *dst = pixelvalue;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_XRGB8888_ABGR8888_Blend(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB, dstA;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            srcpixel = *src;
            srcR = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcB = (Uint8)srcpixel;
            dstpixel = *dst;
            dstB = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstR = (Uint8)dstpixel; dstA = (Uint8)(dstpixel >> 24);
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                dstR = srcR;
                dstG = srcG;
                dstB = srcB;
                dstA = 0xFF;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                dstR = srcR;
                dstG = srcG;
                dstB = srcB;
                dstA = 0xFF;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            }
            dstpixel = (dstA << 24) | (dstB << 16) | (dstG << 8) | dstR;
            *dst = dstpixel;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_XRGB8888_ABGR8888_Blend_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB, dstA;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            srcpixel = *src;
            srcR = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcB = (Uint8)srcpixel;
            dstpixel = *dst;
            dstB = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstR = (Uint8)dstpixel; dstA = (Uint8)(dstpixel >> 24);
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                dstR = srcR;
                dstG = srcG;
                dstB = srcB;
                dstA = 0xFF;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                dstR = srcR;
                dstG = srcG;
                dstB = srcB;
                dstA = 0xFF;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            }
            dstpixel = (dstA << 24) | (dstB << 16) | (dstG << 8) | dstR;
            *dst = dstpixel;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_XRGB8888_ABGR8888_Modulate(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 pixelvalue;
    const Uint32 A = (flags & SDL_COPY_MODULATE_ALPHA) ? modulateA : 0xFF;
    Uint32 R, G, B;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            pixelvalue = *src;
            R = (Uint8)(pixelvalue >> 16); G = (Uint8)(pixelvalue >> 8); B = (Uint8)pixelvalue;
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(R, modulateR, R);
                MULT_DIV_255(G, modulateG, G);
                MULT_DIV_255(B, modulateB, B);
            }
            pixelvalue = (A << 24) | (B << 16) | (G << 8) | R;
            *dst = pixelvalue;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_XRGB8888_ABGR8888_Modulate_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 pixelvalue;
    const Uint32 A = (flags & SDL_COPY_MODULATE_ALPHA) ? modulateA : 0xFF;
    Uint32 R, G, B;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            pixelvalue = *src;
            R = (Uint8)(pixelvalue >> 16); G = (Uint8)(pixelvalue >> 8); B = (Uint8)pixelvalue;
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(R, modulateR, R);
                MULT_DIV_255(G, modulateG, G);
                MULT_DIV_255(B, modulateB, B);
            }
            pixelvalue = (A << 24) | (B << 16) | (G << 8) | R;
            *dst = pixelvalue;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_XRGB8888_ABGR8888_Modulate_Blend(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 srcpixel;
    const Uint32 srcA = (flags & SDL_COPY_MODULATE_ALPHA) ? modulateA : 0xFF;
    Uint32 srcR, srcG, srcB;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB, dstA;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            srcpixel = *src;
            srcR = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcB = (Uint8)srcpixel;
            dstpixel = *dst;
            dstB = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstR = (Uint8)dstpixel; dstA = (Uint8)(dstpixel >> 24);
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(srcR, modulateR, srcR);
                MULT_DIV_255(srcG, modulateG, srcG);
                MULT_DIV_255(srcB, modulateB, srcB);
            }
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                if (dstA > 255) dstA = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstA << 24) | (dstB << 16) | (dstG << 8) | dstR;
            *dst = dstpixel;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_XRGB8888_ABGR8888_Modulate_Blend_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 srcpixel;
    const Uint32 srcA = (flags & SDL_COPY_MODULATE_ALPHA) ? modulateA : 0xFF;
    Uint32 srcR, srcG, srcB;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB, dstA;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            srcpixel = *src;
            srcR = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcB = (Uint8)srcpixel;
            dstpixel = *dst;
            dstB = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstR = (Uint8)dstpixel; dstA = (Uint8)(dstpixel >> 24);
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(srcR, modulateR, srcR);
                MULT_DIV_255(srcG, modulateG, srcG);
                MULT_DIV_255(srcB, modulateB, srcB);
            }
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                if (dstA > 255) dstA = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstA << 24) | (dstB << 16) | (dstG << 8) | dstR;
            *dst = dstpixel;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_XBGR8888_XRGB8888_Scale(SDL_BlitInfo *info)
{
    Uint32 pixelvalue;
    Uint32 R, G, B;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            pixelvalue = *src;
            B = (Uint8)(pixelvalue >> 16); G = (Uint8)(pixelvalue >> 8); R = (Uint8)pixelvalue;
            pixelvalue = (R << 16) | (G << 8) | B;
            *dst = pixelvalue;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_XBGR8888_XRGB8888_Blend(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            srcpixel = *src;
            srcB = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcR = (Uint8)srcpixel;
            dstpixel = *dst;
            dstR = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstB = (Uint8)dstpixel;
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                dstR = srcR;
                dstG = srcG;
                dstB = srcB;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                dstR = srcR;
                dstG = srcG;
                dstB = srcB;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            }
            dstpixel = (dstR << 16) | (dstG << 8) | dstB;
            *dst = dstpixel;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_XBGR8888_XRGB8888_Blend_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            srcpixel = *src;
            srcB = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcR = (Uint8)srcpixel;
            dstpixel = *dst;
            dstR = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstB = (Uint8)dstpixel;
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                dstR = srcR;
                dstG = srcG;
                dstB = srcB;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                dstR = srcR;
                dstG = srcG;
                dstB = srcB;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            }
            dstpixel = (dstR << 16) | (dstG << 8) | dstB;
            *dst = dstpixel;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_XBGR8888_XRGB8888_Modulate(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    Uint32 pixelvalue;
    Uint32 R, G, B;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            pixelvalue = *src;
            B = (Uint8)(pixelvalue >> 16); G = (Uint8)(pixelvalue >> 8); R = (Uint8)pixelvalue;
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(R, modulateR, R);
                MULT_DIV_255(G, modulateG, G);
                MULT_DIV_255(B, modulateB, B);
            }
            pixelvalue = (R << 16) | (G << 8) | B;
            *dst = pixelvalue;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_XBGR8888_XRGB8888_Modulate_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    Uint32 pixelvalue;
    Uint32 R, G, B;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            pixelvalue = *src;
            B = (Uint8)(pixelvalue >> 16); G = (Uint8)(pixelvalue >> 8); R = (Uint8)pixelvalue;
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(R, modulateR, R);
                MULT_DIV_255(G, modulateG, G);
                MULT_DIV_255(B, modulateB, B);
            }
            pixelvalue = (R << 16) | (G << 8) | B;
            *dst = pixelvalue;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_XBGR8888_XRGB8888_Modulate_Blend(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 srcpixel;
    const Uint32 srcA = (flags & SDL_COPY_MODULATE_ALPHA) ? modulateA : 0xFF;
    Uint32 srcR, srcG, srcB;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            srcpixel = *src;
            srcB = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcR = (Uint8)srcpixel;
            dstpixel = *dst;
            dstR = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstB = (Uint8)dstpixel;
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(srcR, modulateR, srcR);
                MULT_DIV_255(srcG, modulateG, srcG);
                MULT_DIV_255(srcB, modulateB, srcB);
            }
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstR << 16) | (dstG << 8) | dstB;
            *dst = dstpixel;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_XBGR8888_XRGB8888_Modulate_Blend_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 srcpixel;
    const Uint32 srcA = (flags & SDL_COPY_MODULATE_ALPHA) ? modulateA : 0xFF;
    Uint32 srcR, srcG, srcB;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            srcpixel = *src;
            srcB = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcR = (Uint8)srcpixel;
            dstpixel = *dst;
            dstR = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstB = (Uint8)dstpixel;
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(srcR, modulateR, srcR);
                MULT_DIV_255(srcG, modulateG, srcG);
                MULT_DIV_255(srcB, modulateB, srcB);
            }
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstR << 16) | (dstG << 8) | dstB;
            *dst = dstpixel;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_XBGR8888_XBGR8888_Scale(SDL_BlitInfo *info)
{
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            *dst = *src;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_XBGR8888_XBGR8888_Blend(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            srcpixel = *src;
            srcB = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcR = (Uint8)srcpixel;
            dstpixel = *dst;
            dstB = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstR = (Uint8)dstpixel;
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                dstR = srcR;
                dstG = srcG;
                dstB = srcB;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                dstR = srcR;
                dstG = srcG;
                dstB = srcB;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            }
            dstpixel = (dstB << 16) | (dstG << 8) | dstR;
            *dst = dstpixel;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_XBGR8888_XBGR8888_Blend_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            srcpixel = *src;
            srcB = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcR = (Uint8)srcpixel;
            dstpixel = *dst;
            dstB = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstR = (Uint8)dstpixel;
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                dstR = srcR;
                dstG = srcG;
                dstB = srcB;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                dstR = srcR;
                dstG = srcG;
                dstB = srcB;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            }
            dstpixel = (dstB << 16) | (dstG << 8) | dstR;
            *dst = dstpixel;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_XBGR8888_XBGR8888_Modulate(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    Uint32 pixelvalue;
    Uint32 R, G, B;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            pixelvalue = *src;
            B = (Uint8)(pixelvalue >> 16); G = (Uint8)(pixelvalue >> 8); R = (Uint8)pixelvalue;
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(R, modulateR, R);
                MULT_DIV_255(G, modulateG, G);
                MULT_DIV_255(B, modulateB, B);
            }
            pixelvalue = (B << 16) | (G << 8) | R;
            *dst = pixelvalue;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_XBGR8888_XBGR8888_Modulate_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    Uint32 pixelvalue;
    Uint32 R, G, B;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            pixelvalue = *src;
            B = (Uint8)(pixelvalue >> 16); G = (Uint8)(pixelvalue >> 8); R = (Uint8)pixelvalue;
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(R, modulateR, R);
                MULT_DIV_255(G, modulateG, G);
                MULT_DIV_255(B, modulateB, B);
            }
            pixelvalue = (B << 16) | (G << 8) | R;
            *dst = pixelvalue;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_XBGR8888_XBGR8888_Modulate_Blend(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 srcpixel;
    const Uint32 srcA = (flags & SDL_COPY_MODULATE_ALPHA) ? modulateA : 0xFF;
    Uint32 srcR, srcG, srcB;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            srcpixel = *src;
            srcB = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcR = (Uint8)srcpixel;
            dstpixel = *dst;
            dstB = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstR = (Uint8)dstpixel;
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(srcR, modulateR, srcR);
                MULT_DIV_255(srcG, modulateG, srcG);
                MULT_DIV_255(srcB, modulateB, srcB);
            }
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstB << 16) | (dstG << 8) | dstR;
            *dst = dstpixel;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_XBGR8888_XBGR8888_Modulate_Blend_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 srcpixel;
    const Uint32 srcA = (flags & SDL_COPY_MODULATE_ALPHA) ? modulateA : 0xFF;
    Uint32 srcR, srcG, srcB;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            srcpixel = *src;
            srcB = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcR = (Uint8)srcpixel;
            dstpixel = *dst;
            dstB = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstR = (Uint8)dstpixel;
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(srcR, modulateR, srcR);
                MULT_DIV_255(srcG, modulateG, srcG);
                MULT_DIV_255(srcB, modulateB, srcB);
            }
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstB << 16) | (dstG << 8) | dstR;
            *dst = dstpixel;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_XBGR8888_ARGB8888_Scale(SDL_BlitInfo *info)
{
    Uint32 pixelvalue;
    const Uint32 A = 0xFF;
    Uint32 R, G, B;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            pixelvalue = *src;
            B = (Uint8)(pixelvalue >> 16); G = (Uint8)(pixelvalue >> 8); R = (Uint8)pixelvalue;
            pixelvalue = (A << 24) | (R << 16) | (G << 8) | B;
            *dst = pixelvalue;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_XBGR8888_ARGB8888_Blend(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB, dstA;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            srcpixel = *src;
            srcB = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcR = (Uint8)srcpixel;
            dstpixel = *dst;
            dstR = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstB = (Uint8)dstpixel; dstA = (Uint8)(dstpixel >> 24);
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                dstR = srcR;
                dstG = srcG;
                dstB = srcB;
                dstA = 0xFF;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                dstR = srcR;
                dstG = srcG;
                dstB = srcB;
                dstA = 0xFF;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            }
            dstpixel = (dstA << 24) | (dstR << 16) | (dstG << 8) | dstB;
            *dst = dstpixel;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_XBGR8888_ARGB8888_Blend_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB, dstA;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            srcpixel = *src;
            srcB = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcR = (Uint8)srcpixel;
            dstpixel = *dst;
            dstR = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstB = (Uint8)dstpixel; dstA = (Uint8)(dstpixel >> 24);
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                dstR = srcR;
                dstG = srcG;
                dstB = srcB;
                dstA = 0xFF;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                dstR = srcR;
                dstG = srcG;
                dstB = srcB;
                dstA = 0xFF;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            }
            dstpixel = (dstA << 24) | (dstR << 16) | (dstG << 8) | dstB;
            *dst = dstpixel;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_XBGR8888_ARGB8888_Modulate(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 pixelvalue;
    const Uint32 A = (flags & SDL_COPY_MODULATE_ALPHA) ? modulateA : 0xFF;
    Uint32 R, G, B;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            pixelvalue = *src;
            B = (Uint8)(pixelvalue >> 16); G = (Uint8)(pixelvalue >> 8); R = (Uint8)pixelvalue;
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(R, modulateR, R);
                MULT_DIV_255(G, modulateG, G);
                MULT_DIV_255(B, modulateB, B);
            }
            pixelvalue = (A << 24) | (R << 16) | (G << 8) | B;
            *dst = pixelvalue;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_XBGR8888_ARGB8888_Modulate_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 pixelvalue;
    const Uint32 A = (flags & SDL_COPY_MODULATE_ALPHA) ? modulateA : 0xFF;
    Uint32 R, G, B;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            pixelvalue = *src;
            B = (Uint8)(pixelvalue >> 16); G = (Uint8)(pixelvalue >> 8); R = (Uint8)pixelvalue;
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(R, modulateR, R);
                MULT_DIV_255(G, modulateG, G);
                MULT_DIV_255(B, modulateB, B);
            }
            pixelvalue = (A << 24) | (R << 16) | (G << 8) | B;
            *dst = pixelvalue;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_XBGR8888_ARGB8888_Modulate_Blend(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 srcpixel;
    const Uint32 srcA = (flags & SDL_COPY_MODULATE_ALPHA) ? modulateA : 0xFF;
    Uint32 srcR, srcG, srcB;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB, dstA;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            srcpixel = *src;
            srcB = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcR = (Uint8)srcpixel;
            dstpixel = *dst;
            dstR = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstB = (Uint8)dstpixel; dstA = (Uint8)(dstpixel >> 24);
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(srcR, modulateR, srcR);
                MULT_DIV_255(srcG, modulateG, srcG);
                MULT_DIV_255(srcB, modulateB, srcB);
            }
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                if (dstA > 255) dstA = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstA << 24) | (dstR << 16) | (dstG << 8) | dstB;
            *dst = dstpixel;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_XBGR8888_ARGB8888_Modulate_Blend_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 srcpixel;
    const Uint32 srcA = (flags & SDL_COPY_MODULATE_ALPHA) ? modulateA : 0xFF;
    Uint32 srcR, srcG, srcB;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB, dstA;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            srcpixel = *src;
            srcB = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcR = (Uint8)srcpixel;
            dstpixel = *dst;
            dstR = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstB = (Uint8)dstpixel; dstA = (Uint8)(dstpixel >> 24);
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(srcR, modulateR, srcR);
                MULT_DIV_255(srcG, modulateG, srcG);
                MULT_DIV_255(srcB, modulateB, srcB);
            }
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                if (dstA > 255) dstA = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstA << 24) | (dstR << 16) | (dstG << 8) | dstB;
            *dst = dstpixel;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_XBGR8888_ABGR8888_Scale(SDL_BlitInfo *info)
{
    Uint32 pixelvalue;
    const Uint32 A = 0xFF;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            pixelvalue = *src;
            pixelvalue |= (A << 24);
            *dst = pixelvalue;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_XBGR8888_ABGR8888_Blend(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB, dstA;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            srcpixel = *src;
            srcB = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcR = (Uint8)srcpixel;
            dstpixel = *dst;
            dstB = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstR = (Uint8)dstpixel; dstA = (Uint8)(dstpixel >> 24);
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                dstR = srcR;
                dstG = srcG;
                dstB = srcB;
                dstA = 0xFF;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                dstR = srcR;
                dstG = srcG;
                dstB = srcB;
                dstA = 0xFF;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            }
            dstpixel = (dstA << 24) | (dstB << 16) | (dstG << 8) | dstR;
            *dst = dstpixel;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_XBGR8888_ABGR8888_Blend_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB, dstA;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            srcpixel = *src;
            srcB = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcR = (Uint8)srcpixel;
            dstpixel = *dst;
            dstB = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstR = (Uint8)dstpixel; dstA = (Uint8)(dstpixel >> 24);
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                dstR = srcR;
                dstG = srcG;
                dstB = srcB;
                dstA = 0xFF;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                dstR = srcR;
                dstG = srcG;
                dstB = srcB;
                dstA = 0xFF;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            }
            dstpixel = (dstA << 24) | (dstB << 16) | (dstG << 8) | dstR;
            *dst = dstpixel;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_XBGR8888_ABGR8888_Modulate(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 pixelvalue;
    const Uint32 A = (flags & SDL_COPY_MODULATE_ALPHA) ? modulateA : 0xFF;
    Uint32 R, G, B;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            pixelvalue = *src;
            B = (Uint8)(pixelvalue >> 16); G = (Uint8)(pixelvalue >> 8); R = (Uint8)pixelvalue;
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(R, modulateR, R);
                MULT_DIV_255(G, modulateG, G);
                MULT_DIV_255(B, modulateB, B);
            }
            pixelvalue = (A << 24) | (B << 16) | (G << 8) | R;
            *dst = pixelvalue;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_XBGR8888_ABGR8888_Modulate_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 pixelvalue;
    const Uint32 A = (flags & SDL_COPY_MODULATE_ALPHA) ? modulateA : 0xFF;
    Uint32 R, G, B;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            pixelvalue = *src;
            B = (Uint8)(pixelvalue >> 16); G = (Uint8)(pixelvalue >> 8); R = (Uint8)pixelvalue;
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(R, modulateR, R);
                MULT_DIV_255(G, modulateG, G);
                MULT_DIV_255(B, modulateB, B);
            }
            pixelvalue = (A << 24) | (B << 16) | (G << 8) | R;
            *dst = pixelvalue;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_XBGR8888_ABGR8888_Modulate_Blend(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 srcpixel;
    const Uint32 srcA = (flags & SDL_COPY_MODULATE_ALPHA) ? modulateA : 0xFF;
    Uint32 srcR, srcG, srcB;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB, dstA;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            srcpixel = *src;
            srcB = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcR = (Uint8)srcpixel;
            dstpixel = *dst;
            dstB = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstR = (Uint8)dstpixel; dstA = (Uint8)(dstpixel >> 24);
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(srcR, modulateR, srcR);
                MULT_DIV_255(srcG, modulateG, srcG);
                MULT_DIV_255(srcB, modulateB, srcB);
            }
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                if (dstA > 255) dstA = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstA << 24) | (dstB << 16) | (dstG << 8) | dstR;
            *dst = dstpixel;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_XBGR8888_ABGR8888_Modulate_Blend_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 srcpixel;
    const Uint32 srcA = (flags & SDL_COPY_MODULATE_ALPHA) ? modulateA : 0xFF;
    Uint32 srcR, srcG, srcB;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB, dstA;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            srcpixel = *src;
            srcB = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcR = (Uint8)srcpixel;
            dstpixel = *dst;
            dstB = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstR = (Uint8)dstpixel; dstA = (Uint8)(dstpixel >> 24);
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(srcR, modulateR, srcR);
                MULT_DIV_255(srcG, modulateG, srcG);
                MULT_DIV_255(srcB, modulateB, srcB);
            }
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                if (dstA > 255) dstA = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstA << 24) | (dstB << 16) | (dstG << 8) | dstR;
            *dst = dstpixel;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_ARGB8888_XRGB8888_Scale(SDL_BlitInfo *info)
{
    Uint32 pixelvalue;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            pixelvalue = *src;
            pixelvalue &= 0xFFFFFF;
            *dst = pixelvalue;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_ARGB8888_XRGB8888_Blend(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            srcpixel = *src;
            srcR = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcB = (Uint8)srcpixel; srcA = (Uint8)(srcpixel >> 24);
            dstpixel = *dst;
            dstR = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstB = (Uint8)dstpixel;
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstR << 16) | (dstG << 8) | dstB;
            *dst = dstpixel;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_ARGB8888_XRGB8888_Blend_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            srcpixel = *src;
            srcR = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcB = (Uint8)srcpixel; srcA = (Uint8)(srcpixel >> 24);
            dstpixel = *dst;
            dstR = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstB = (Uint8)dstpixel;
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstR << 16) | (dstG << 8) | dstB;
            *dst = dstpixel;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_ARGB8888_XRGB8888_Modulate(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    Uint32 pixelvalue;
    Uint32 R, G, B;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            pixelvalue = *src;
            R = (Uint8)(pixelvalue >> 16); G = (Uint8)(pixelvalue >> 8); B = (Uint8)pixelvalue;
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(R, modulateR, R);
                MULT_DIV_255(G, modulateG, G);
                MULT_DIV_255(B, modulateB, B);
            }
            pixelvalue = (R << 16) | (G << 8) | B;
            *dst = pixelvalue;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_ARGB8888_XRGB8888_Modulate_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    Uint32 pixelvalue;
    Uint32 R, G, B;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            pixelvalue = *src;
            R = (Uint8)(pixelvalue >> 16); G = (Uint8)(pixelvalue >> 8); B = (Uint8)pixelvalue;
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(R, modulateR, R);
                MULT_DIV_255(G, modulateG, G);
                MULT_DIV_255(B, modulateB, B);
            }
            pixelvalue = (R << 16) | (G << 8) | B;
            *dst = pixelvalue;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_ARGB8888_XRGB8888_Modulate_Blend(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            srcpixel = *src;
            srcR = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcB = (Uint8)srcpixel; srcA = (Uint8)(srcpixel >> 24);
            dstpixel = *dst;
            dstR = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstB = (Uint8)dstpixel;
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(srcR, modulateR, srcR);
                MULT_DIV_255(srcG, modulateG, srcG);
                MULT_DIV_255(srcB, modulateB, srcB);
            }
            if (flags & SDL_COPY_MODULATE_ALPHA) {
                MULT_DIV_255(srcA, modulateA, srcA);
            }
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstR << 16) | (dstG << 8) | dstB;
            *dst = dstpixel;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_ARGB8888_XRGB8888_Modulate_Blend_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            srcpixel = *src;
            srcR = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcB = (Uint8)srcpixel; srcA = (Uint8)(srcpixel >> 24);
            dstpixel = *dst;
            dstR = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstB = (Uint8)dstpixel;
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(srcR, modulateR, srcR);
                MULT_DIV_255(srcG, modulateG, srcG);
                MULT_DIV_255(srcB, modulateB, srcB);
            }
            if (flags & SDL_COPY_MODULATE_ALPHA) {
                MULT_DIV_255(srcA, modulateA, srcA);
            }
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstR << 16) | (dstG << 8) | dstB;
            *dst = dstpixel;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_ARGB8888_XBGR8888_Scale(SDL_BlitInfo *info)
{
    Uint32 pixelvalue;
    Uint32 R, G, B;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            pixelvalue = *src;
            R = (Uint8)(pixelvalue >> 16); G = (Uint8)(pixelvalue >> 8); B = (Uint8)pixelvalue;
            pixelvalue = (B << 16) | (G << 8) | R;
            *dst = pixelvalue;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_ARGB8888_XBGR8888_Blend(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            srcpixel = *src;
            srcR = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcB = (Uint8)srcpixel; srcA = (Uint8)(srcpixel >> 24);
            dstpixel = *dst;
            dstB = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstR = (Uint8)dstpixel;
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstB << 16) | (dstG << 8) | dstR;
            *dst = dstpixel;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_ARGB8888_XBGR8888_Blend_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            srcpixel = *src;
            srcR = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcB = (Uint8)srcpixel; srcA = (Uint8)(srcpixel >> 24);
            dstpixel = *dst;
            dstB = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstR = (Uint8)dstpixel;
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstB << 16) | (dstG << 8) | dstR;
            *dst = dstpixel;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_ARGB8888_XBGR8888_Modulate(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    Uint32 pixelvalue;
    Uint32 R, G, B;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            pixelvalue = *src;
            R = (Uint8)(pixelvalue >> 16); G = (Uint8)(pixelvalue >> 8); B = (Uint8)pixelvalue;
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(R, modulateR, R);
                MULT_DIV_255(G, modulateG, G);
                MULT_DIV_255(B, modulateB, B);
            }
            pixelvalue = (B << 16) | (G << 8) | R;
            *dst = pixelvalue;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_ARGB8888_XBGR8888_Modulate_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    Uint32 pixelvalue;
    Uint32 R, G, B;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            pixelvalue = *src;
            R = (Uint8)(pixelvalue >> 16); G = (Uint8)(pixelvalue >> 8); B = (Uint8)pixelvalue;
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(R, modulateR, R);
                MULT_DIV_255(G, modulateG, G);
                MULT_DIV_255(B, modulateB, B);
            }
            pixelvalue = (B << 16) | (G << 8) | R;
            *dst = pixelvalue;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_ARGB8888_XBGR8888_Modulate_Blend(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            srcpixel = *src;
            srcR = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcB = (Uint8)srcpixel; srcA = (Uint8)(srcpixel >> 24);
            dstpixel = *dst;
            dstB = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstR = (Uint8)dstpixel;
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(srcR, modulateR, srcR);
                MULT_DIV_255(srcG, modulateG, srcG);
                MULT_DIV_255(srcB, modulateB, srcB);
            }
            if (flags & SDL_COPY_MODULATE_ALPHA) {
                MULT_DIV_255(srcA, modulateA, srcA);
            }
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstB << 16) | (dstG << 8) | dstR;
            *dst = dstpixel;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_ARGB8888_XBGR8888_Modulate_Blend_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            srcpixel = *src;
            srcR = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcB = (Uint8)srcpixel; srcA = (Uint8)(srcpixel >> 24);
            dstpixel = *dst;
            dstB = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstR = (Uint8)dstpixel;
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(srcR, modulateR, srcR);
                MULT_DIV_255(srcG, modulateG, srcG);
                MULT_DIV_255(srcB, modulateB, srcB);
            }
            if (flags & SDL_COPY_MODULATE_ALPHA) {
                MULT_DIV_255(srcA, modulateA, srcA);
            }
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstB << 16) | (dstG << 8) | dstR;
            *dst = dstpixel;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_ARGB8888_ARGB8888_Scale(SDL_BlitInfo *info)
{
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            *dst = *src;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_ARGB8888_ARGB8888_Blend(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB, dstA;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            srcpixel = *src;
            srcR = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcB = (Uint8)srcpixel; srcA = (Uint8)(srcpixel >> 24);
            dstpixel = *dst;
            dstR = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstB = (Uint8)dstpixel; dstA = (Uint8)(dstpixel >> 24);
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                if (dstA > 255) dstA = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstA << 24) | (dstR << 16) | (dstG << 8) | dstB;
            *dst = dstpixel;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_ARGB8888_ARGB8888_Blend_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB, dstA;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            srcpixel = *src;
            srcR = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcB = (Uint8)srcpixel; srcA = (Uint8)(srcpixel >> 24);
            dstpixel = *dst;
            dstR = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstB = (Uint8)dstpixel; dstA = (Uint8)(dstpixel >> 24);
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                if (dstA > 255) dstA = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstA << 24) | (dstR << 16) | (dstG << 8) | dstB;
            *dst = dstpixel;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_ARGB8888_ARGB8888_Modulate(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 pixelvalue;
    Uint32 R, G, B, A;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            pixelvalue = *src;
            R = (Uint8)(pixelvalue >> 16); G = (Uint8)(pixelvalue >> 8); B = (Uint8)pixelvalue; A = (Uint8)(pixelvalue >> 24);
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(R, modulateR, R);
                MULT_DIV_255(G, modulateG, G);
                MULT_DIV_255(B, modulateB, B);
            }
            if (flags & SDL_COPY_MODULATE_ALPHA) {
                MULT_DIV_255(A, modulateA, A);
            }
            pixelvalue = (A << 24) | (R << 16) | (G << 8) | B;
            *dst = pixelvalue;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_ARGB8888_ARGB8888_Modulate_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 pixelvalue;
    Uint32 R, G, B, A;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            pixelvalue = *src;
            R = (Uint8)(pixelvalue >> 16); G = (Uint8)(pixelvalue >> 8); B = (Uint8)pixelvalue; A = (Uint8)(pixelvalue >> 24);
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(R, modulateR, R);
                MULT_DIV_255(G, modulateG, G);
                MULT_DIV_255(B, modulateB, B);
            }
            if (flags & SDL_COPY_MODULATE_ALPHA) {
                MULT_DIV_255(A, modulateA, A);
            }
            pixelvalue = (A << 24) | (R << 16) | (G << 8) | B;
            *dst = pixelvalue;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_ARGB8888_ARGB8888_Modulate_Blend(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB, dstA;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            srcpixel = *src;
            srcR = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcB = (Uint8)srcpixel; srcA = (Uint8)(srcpixel >> 24);
            dstpixel = *dst;
            dstR = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstB = (Uint8)dstpixel; dstA = (Uint8)(dstpixel >> 24);
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(srcR, modulateR, srcR);
                MULT_DIV_255(srcG, modulateG, srcG);
                MULT_DIV_255(srcB, modulateB, srcB);
            }
            if (flags & SDL_COPY_MODULATE_ALPHA) {
                MULT_DIV_255(srcA, modulateA, srcA);
            }
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                if (dstA > 255) dstA = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstA << 24) | (dstR << 16) | (dstG << 8) | dstB;
            *dst = dstpixel;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_ARGB8888_ARGB8888_Modulate_Blend_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB, dstA;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            srcpixel = *src;
            srcR = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcB = (Uint8)srcpixel; srcA = (Uint8)(srcpixel >> 24);
            dstpixel = *dst;
            dstR = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstB = (Uint8)dstpixel; dstA = (Uint8)(dstpixel >> 24);
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(srcR, modulateR, srcR);
                MULT_DIV_255(srcG, modulateG, srcG);
                MULT_DIV_255(srcB, modulateB, srcB);
            }
            if (flags & SDL_COPY_MODULATE_ALPHA) {
                MULT_DIV_255(srcA, modulateA, srcA);
            }
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                if (dstA > 255) dstA = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstA << 24) | (dstR << 16) | (dstG << 8) | dstB;
            *dst = dstpixel;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_ARGB8888_ABGR8888_Scale(SDL_BlitInfo *info)
{
    Uint32 pixelvalue;
    Uint32 R, G, B, A;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            pixelvalue = *src;
            R = (Uint8)(pixelvalue >> 16); G = (Uint8)(pixelvalue >> 8); B = (Uint8)pixelvalue; A = (Uint8)(pixelvalue >> 24);
            pixelvalue = (A << 24) | (B << 16) | (G << 8) | R;
            *dst = pixelvalue;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_ARGB8888_ABGR8888_Blend(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB, dstA;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            srcpixel = *src;
            srcR = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcB = (Uint8)srcpixel; srcA = (Uint8)(srcpixel >> 24);
            dstpixel = *dst;
            dstB = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstR = (Uint8)dstpixel; dstA = (Uint8)(dstpixel >> 24);
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                if (dstA > 255) dstA = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstA << 24) | (dstB << 16) | (dstG << 8) | dstR;
            *dst = dstpixel;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_ARGB8888_ABGR8888_Blend_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB, dstA;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            srcpixel = *src;
            srcR = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcB = (Uint8)srcpixel; srcA = (Uint8)(srcpixel >> 24);
            dstpixel = *dst;
            dstB = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstR = (Uint8)dstpixel; dstA = (Uint8)(dstpixel >> 24);
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                if (dstA > 255) dstA = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstA << 24) | (dstB << 16) | (dstG << 8) | dstR;
            *dst = dstpixel;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_ARGB8888_ABGR8888_Modulate(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 pixelvalue;
    Uint32 R, G, B, A;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            pixelvalue = *src;
            R = (Uint8)(pixelvalue >> 16); G = (Uint8)(pixelvalue >> 8); B = (Uint8)pixelvalue; A = (Uint8)(pixelvalue >> 24);
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(R, modulateR, R);
                MULT_DIV_255(G, modulateG, G);
                MULT_DIV_255(B, modulateB, B);
            }
            if (flags & SDL_COPY_MODULATE_ALPHA) {
                MULT_DIV_255(A, modulateA, A);
            }
            pixelvalue = (A << 24) | (B << 16) | (G << 8) | R;
            *dst = pixelvalue;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_ARGB8888_ABGR8888_Modulate_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 pixelvalue;
    Uint32 R, G, B, A;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            pixelvalue = *src;
            R = (Uint8)(pixelvalue >> 16); G = (Uint8)(pixelvalue >> 8); B = (Uint8)pixelvalue; A = (Uint8)(pixelvalue >> 24);
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(R, modulateR, R);
                MULT_DIV_255(G, modulateG, G);
                MULT_DIV_255(B, modulateB, B);
            }
            if (flags & SDL_COPY_MODULATE_ALPHA) {
                MULT_DIV_255(A, modulateA, A);
            }
            pixelvalue = (A << 24) | (B << 16) | (G << 8) | R;
            *dst = pixelvalue;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_ARGB8888_ABGR8888_Modulate_Blend(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB, dstA;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            srcpixel = *src;
            srcR = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcB = (Uint8)srcpixel; srcA = (Uint8)(srcpixel >> 24);
            dstpixel = *dst;
            dstB = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstR = (Uint8)dstpixel; dstA = (Uint8)(dstpixel >> 24);
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(srcR, modulateR, srcR);
                MULT_DIV_255(srcG, modulateG, srcG);
                MULT_DIV_255(srcB, modulateB, srcB);
            }
            if (flags & SDL_COPY_MODULATE_ALPHA) {
                MULT_DIV_255(srcA, modulateA, srcA);
            }
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                if (dstA > 255) dstA = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstA << 24) | (dstB << 16) | (dstG << 8) | dstR;
            *dst = dstpixel;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_ARGB8888_ABGR8888_Modulate_Blend_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB, dstA;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            srcpixel = *src;
            srcR = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcB = (Uint8)srcpixel; srcA = (Uint8)(srcpixel >> 24);
            dstpixel = *dst;
            dstB = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstR = (Uint8)dstpixel; dstA = (Uint8)(dstpixel >> 24);
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(srcR, modulateR, srcR);
                MULT_DIV_255(srcG, modulateG, srcG);
                MULT_DIV_255(srcB, modulateB, srcB);
            }
            if (flags & SDL_COPY_MODULATE_ALPHA) {
                MULT_DIV_255(srcA, modulateA, srcA);
            }
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                if (dstA > 255) dstA = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstA << 24) | (dstB << 16) | (dstG << 8) | dstR;
            *dst = dstpixel;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_RGBA8888_XRGB8888_Scale(SDL_BlitInfo *info)
{
    Uint32 pixelvalue;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            pixelvalue = *src;
            pixelvalue >>= 8;
            *dst = pixelvalue;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_RGBA8888_XRGB8888_Blend(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            srcpixel = *src;
            srcR = (Uint8)(srcpixel >> 24); srcG = (Uint8)(srcpixel >> 16); srcB = (Uint8)(srcpixel >> 8); srcA = (Uint8)srcpixel;
            dstpixel = *dst;
            dstR = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstB = (Uint8)dstpixel;
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstR << 16) | (dstG << 8) | dstB;
            *dst = dstpixel;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_RGBA8888_XRGB8888_Blend_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            srcpixel = *src;
            srcR = (Uint8)(srcpixel >> 24); srcG = (Uint8)(srcpixel >> 16); srcB = (Uint8)(srcpixel >> 8); srcA = (Uint8)srcpixel;
            dstpixel = *dst;
            dstR = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstB = (Uint8)dstpixel;
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstR << 16) | (dstG << 8) | dstB;
            *dst = dstpixel;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_RGBA8888_XRGB8888_Modulate(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    Uint32 pixelvalue;
    Uint32 R, G, B;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            pixelvalue = *src;
            R = (Uint8)(pixelvalue >> 24); G = (Uint8)(pixelvalue >> 16); B = (Uint8)(pixelvalue >> 8);
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(R, modulateR, R);
                MULT_DIV_255(G, modulateG, G);
                MULT_DIV_255(B, modulateB, B);
            }
            pixelvalue = (R << 16) | (G << 8) | B;
            *dst = pixelvalue;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_RGBA8888_XRGB8888_Modulate_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    Uint32 pixelvalue;
    Uint32 R, G, B;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            pixelvalue = *src;
            R = (Uint8)(pixelvalue >> 24); G = (Uint8)(pixelvalue >> 16); B = (Uint8)(pixelvalue >> 8);
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(R, modulateR, R);
                MULT_DIV_255(G, modulateG, G);
                MULT_DIV_255(B, modulateB, B);
            }
            pixelvalue = (R << 16) | (G << 8) | B;
            *dst = pixelvalue;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_RGBA8888_XRGB8888_Modulate_Blend(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            srcpixel = *src;
            srcR = (Uint8)(srcpixel >> 24); srcG = (Uint8)(srcpixel >> 16); srcB = (Uint8)(srcpixel >> 8); srcA = (Uint8)srcpixel;
            dstpixel = *dst;
            dstR = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstB = (Uint8)dstpixel;
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(srcR, modulateR, srcR);
                MULT_DIV_255(srcG, modulateG, srcG);
                MULT_DIV_255(srcB, modulateB, srcB);
            }
            if (flags & SDL_COPY_MODULATE_ALPHA) {
                MULT_DIV_255(srcA, modulateA, srcA);
            }
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstR << 16) | (dstG << 8) | dstB;
            *dst = dstpixel;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_RGBA8888_XRGB8888_Modulate_Blend_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            srcpixel = *src;
            srcR = (Uint8)(srcpixel >> 24); srcG = (Uint8)(srcpixel >> 16); srcB = (Uint8)(srcpixel >> 8); srcA = (Uint8)srcpixel;
            dstpixel = *dst;
            dstR = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstB = (Uint8)dstpixel;
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(srcR, modulateR, srcR);
                MULT_DIV_255(srcG, modulateG, srcG);
                MULT_DIV_255(srcB, modulateB, srcB);
            }
            if (flags & SDL_COPY_MODULATE_ALPHA) {
                MULT_DIV_255(srcA, modulateA, srcA);
            }
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstR << 16) | (dstG << 8) | dstB;
            *dst = dstpixel;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_RGBA8888_XBGR8888_Scale(SDL_BlitInfo *info)
{
    Uint32 pixelvalue;
    Uint32 R, G, B;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            pixelvalue = *src;
            R = (Uint8)(pixelvalue >> 24); G = (Uint8)(pixelvalue >> 16); B = (Uint8)(pixelvalue >> 8);
            pixelvalue = (B << 16) | (G << 8) | R;
            *dst = pixelvalue;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_RGBA8888_XBGR8888_Blend(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            srcpixel = *src;
            srcR = (Uint8)(srcpixel >> 24); srcG = (Uint8)(srcpixel >> 16); srcB = (Uint8)(srcpixel >> 8); srcA = (Uint8)srcpixel;
            dstpixel = *dst;
            dstB = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstR = (Uint8)dstpixel;
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstB << 16) | (dstG << 8) | dstR;
            *dst = dstpixel;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_RGBA8888_XBGR8888_Blend_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            srcpixel = *src;
            srcR = (Uint8)(srcpixel >> 24); srcG = (Uint8)(srcpixel >> 16); srcB = (Uint8)(srcpixel >> 8); srcA = (Uint8)srcpixel;
            dstpixel = *dst;
            dstB = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstR = (Uint8)dstpixel;
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstB << 16) | (dstG << 8) | dstR;
            *dst = dstpixel;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_RGBA8888_XBGR8888_Modulate(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    Uint32 pixelvalue;
    Uint32 R, G, B;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            pixelvalue = *src;
            R = (Uint8)(pixelvalue >> 24); G = (Uint8)(pixelvalue >> 16); B = (Uint8)(pixelvalue >> 8);
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(R, modulateR, R);
                MULT_DIV_255(G, modulateG, G);
                MULT_DIV_255(B, modulateB, B);
            }
            pixelvalue = (B << 16) | (G << 8) | R;
            *dst = pixelvalue;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_RGBA8888_XBGR8888_Modulate_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    Uint32 pixelvalue;
    Uint32 R, G, B;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            pixelvalue = *src;
            R = (Uint8)(pixelvalue >> 24); G = (Uint8)(pixelvalue >> 16); B = (Uint8)(pixelvalue >> 8);
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(R, modulateR, R);
                MULT_DIV_255(G, modulateG, G);
                MULT_DIV_255(B, modulateB, B);
            }
            pixelvalue = (B << 16) | (G << 8) | R;
            *dst = pixelvalue;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_RGBA8888_XBGR8888_Modulate_Blend(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            srcpixel = *src;
            srcR = (Uint8)(srcpixel >> 24); srcG = (Uint8)(srcpixel >> 16); srcB = (Uint8)(srcpixel >> 8); srcA = (Uint8)srcpixel;
            dstpixel = *dst;
            dstB = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstR = (Uint8)dstpixel;
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(srcR, modulateR, srcR);
                MULT_DIV_255(srcG, modulateG, srcG);
                MULT_DIV_255(srcB, modulateB, srcB);
            }
            if (flags & SDL_COPY_MODULATE_ALPHA) {
                MULT_DIV_255(srcA, modulateA, srcA);
            }
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstB << 16) | (dstG << 8) | dstR;
            *dst = dstpixel;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_RGBA8888_XBGR8888_Modulate_Blend_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            srcpixel = *src;
            srcR = (Uint8)(srcpixel >> 24); srcG = (Uint8)(srcpixel >> 16); srcB = (Uint8)(srcpixel >> 8); srcA = (Uint8)srcpixel;
            dstpixel = *dst;
            dstB = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstR = (Uint8)dstpixel;
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(srcR, modulateR, srcR);
                MULT_DIV_255(srcG, modulateG, srcG);
                MULT_DIV_255(srcB, modulateB, srcB);
            }
            if (flags & SDL_COPY_MODULATE_ALPHA) {
                MULT_DIV_255(srcA, modulateA, srcA);
            }
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstB << 16) | (dstG << 8) | dstR;
            *dst = dstpixel;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_RGBA8888_ARGB8888_Scale(SDL_BlitInfo *info)
{
    Uint32 pixelvalue;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            pixelvalue = *src;
            pixelvalue = (pixelvalue >> 8) | (pixelvalue << 24);
            *dst = pixelvalue;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_RGBA8888_ARGB8888_Blend(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB, dstA;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            srcpixel = *src;
            srcR = (Uint8)(srcpixel >> 24); srcG = (Uint8)(srcpixel >> 16); srcB = (Uint8)(srcpixel >> 8); srcA = (Uint8)srcpixel;
            dstpixel = *dst;
            dstR = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstB = (Uint8)dstpixel; dstA = (Uint8)(dstpixel >> 24);
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                if (dstA > 255) dstA = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstA << 24) | (dstR << 16) | (dstG << 8) | dstB;
            *dst = dstpixel;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_RGBA8888_ARGB8888_Blend_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB, dstA;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            srcpixel = *src;
            srcR = (Uint8)(srcpixel >> 24); srcG = (Uint8)(srcpixel >> 16); srcB = (Uint8)(srcpixel >> 8); srcA = (Uint8)srcpixel;
            dstpixel = *dst;
            dstR = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstB = (Uint8)dstpixel; dstA = (Uint8)(dstpixel >> 24);
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                if (dstA > 255) dstA = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstA << 24) | (dstR << 16) | (dstG << 8) | dstB;
            *dst = dstpixel;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_RGBA8888_ARGB8888_Modulate(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 pixelvalue;
    Uint32 R, G, B, A;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            pixelvalue = *src;
            R = (Uint8)(pixelvalue >> 24); G = (Uint8)(pixelvalue >> 16); B = (Uint8)(pixelvalue >> 8); A = (Uint8)pixelvalue;
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(R, modulateR, R);
                MULT_DIV_255(G, modulateG, G);
                MULT_DIV_255(B, modulateB, B);
            }
            if (flags & SDL_COPY_MODULATE_ALPHA) {
                MULT_DIV_255(A, modulateA, A);
            }
            pixelvalue = (A << 24) | (R << 16) | (G << 8) | B;
            *dst = pixelvalue;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_RGBA8888_ARGB8888_Modulate_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 pixelvalue;
    Uint32 R, G, B, A;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            pixelvalue = *src;
            R = (Uint8)(pixelvalue >> 24); G = (Uint8)(pixelvalue >> 16); B = (Uint8)(pixelvalue >> 8); A = (Uint8)pixelvalue;
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(R, modulateR, R);
                MULT_DIV_255(G, modulateG, G);
                MULT_DIV_255(B, modulateB, B);
            }
            if (flags & SDL_COPY_MODULATE_ALPHA) {
                MULT_DIV_255(A, modulateA, A);
            }
            pixelvalue = (A << 24) | (R << 16) | (G << 8) | B;
            *dst = pixelvalue;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_RGBA8888_ARGB8888_Modulate_Blend(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB, dstA;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            srcpixel = *src;
            srcR = (Uint8)(srcpixel >> 24); srcG = (Uint8)(srcpixel >> 16); srcB = (Uint8)(srcpixel >> 8); srcA = (Uint8)srcpixel;
            dstpixel = *dst;
            dstR = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstB = (Uint8)dstpixel; dstA = (Uint8)(dstpixel >> 24);
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(srcR, modulateR, srcR);
                MULT_DIV_255(srcG, modulateG, srcG);
                MULT_DIV_255(srcB, modulateB, srcB);
            }
            if (flags & SDL_COPY_MODULATE_ALPHA) {
                MULT_DIV_255(srcA, modulateA, srcA);
            }
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                if (dstA > 255) dstA = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstA << 24) | (dstR << 16) | (dstG << 8) | dstB;
            *dst = dstpixel;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_RGBA8888_ARGB8888_Modulate_Blend_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB, dstA;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            srcpixel = *src;
            srcR = (Uint8)(srcpixel >> 24); srcG = (Uint8)(srcpixel >> 16); srcB = (Uint8)(srcpixel >> 8); srcA = (Uint8)srcpixel;
            dstpixel = *dst;
            dstR = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstB = (Uint8)dstpixel; dstA = (Uint8)(dstpixel >> 24);
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(srcR, modulateR, srcR);
                MULT_DIV_255(srcG, modulateG, srcG);
                MULT_DIV_255(srcB, modulateB, srcB);
            }
            if (flags & SDL_COPY_MODULATE_ALPHA) {
                MULT_DIV_255(srcA, modulateA, srcA);
            }
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                if (dstA > 255) dstA = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstA << 24) | (dstR << 16) | (dstG << 8) | dstB;
            *dst = dstpixel;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_RGBA8888_ABGR8888_Scale(SDL_BlitInfo *info)
{
    Uint32 pixelvalue;
    Uint32 R, G, B, A;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            pixelvalue = *src;
            R = (Uint8)(pixelvalue >> 24); G = (Uint8)(pixelvalue >> 16); B = (Uint8)(pixelvalue >> 8); A = (Uint8)pixelvalue;
            pixelvalue = (A << 24) | (B << 16) | (G << 8) | R;
            *dst = pixelvalue;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_RGBA8888_ABGR8888_Blend(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB, dstA;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            srcpixel = *src;
            srcR = (Uint8)(srcpixel >> 24); srcG = (Uint8)(srcpixel >> 16); srcB = (Uint8)(srcpixel >> 8); srcA = (Uint8)srcpixel;
            dstpixel = *dst;
            dstB = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstR = (Uint8)dstpixel; dstA = (Uint8)(dstpixel >> 24);
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                if (dstA > 255) dstA = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstA << 24) | (dstB << 16) | (dstG << 8) | dstR;
            *dst = dstpixel;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_RGBA8888_ABGR8888_Blend_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB, dstA;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            srcpixel = *src;
            srcR = (Uint8)(srcpixel >> 24); srcG = (Uint8)(srcpixel >> 16); srcB = (Uint8)(srcpixel >> 8); srcA = (Uint8)srcpixel;
            dstpixel = *dst;
            dstB = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstR = (Uint8)dstpixel; dstA = (Uint8)(dstpixel >> 24);
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                if (dstA > 255) dstA = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstA << 24) | (dstB << 16) | (dstG << 8) | dstR;
            *dst = dstpixel;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_RGBA8888_ABGR8888_Modulate(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 pixelvalue;
    Uint32 R, G, B, A;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            pixelvalue = *src;
            R = (Uint8)(pixelvalue >> 24); G = (Uint8)(pixelvalue >> 16); B = (Uint8)(pixelvalue >> 8); A = (Uint8)pixelvalue;
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(R, modulateR, R);
                MULT_DIV_255(G, modulateG, G);
                MULT_DIV_255(B, modulateB, B);
            }
            if (flags & SDL_COPY_MODULATE_ALPHA) {
                MULT_DIV_255(A, modulateA, A);
            }
            pixelvalue = (A << 24) | (B << 16) | (G << 8) | R;
            *dst = pixelvalue;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_RGBA8888_ABGR8888_Modulate_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 pixelvalue;
    Uint32 R, G, B, A;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            pixelvalue = *src;
            R = (Uint8)(pixelvalue >> 24); G = (Uint8)(pixelvalue >> 16); B = (Uint8)(pixelvalue >> 8); A = (Uint8)pixelvalue;
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(R, modulateR, R);
                MULT_DIV_255(G, modulateG, G);
                MULT_DIV_255(B, modulateB, B);
            }
            if (flags & SDL_COPY_MODULATE_ALPHA) {
                MULT_DIV_255(A, modulateA, A);
            }
            pixelvalue = (A << 24) | (B << 16) | (G << 8) | R;
            *dst = pixelvalue;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_RGBA8888_ABGR8888_Modulate_Blend(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB, dstA;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            srcpixel = *src;
            srcR = (Uint8)(srcpixel >> 24); srcG = (Uint8)(srcpixel >> 16); srcB = (Uint8)(srcpixel >> 8); srcA = (Uint8)srcpixel;
            dstpixel = *dst;
            dstB = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstR = (Uint8)dstpixel; dstA = (Uint8)(dstpixel >> 24);
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(srcR, modulateR, srcR);
                MULT_DIV_255(srcG, modulateG, srcG);
                MULT_DIV_255(srcB, modulateB, srcB);
            }
            if (flags & SDL_COPY_MODULATE_ALPHA) {
                MULT_DIV_255(srcA, modulateA, srcA);
            }
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                if (dstA > 255) dstA = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstA << 24) | (dstB << 16) | (dstG << 8) | dstR;
            *dst = dstpixel;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_RGBA8888_ABGR8888_Modulate_Blend_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB, dstA;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            srcpixel = *src;
            srcR = (Uint8)(srcpixel >> 24); srcG = (Uint8)(srcpixel >> 16); srcB = (Uint8)(srcpixel >> 8); srcA = (Uint8)srcpixel;
            dstpixel = *dst;
            dstB = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstR = (Uint8)dstpixel; dstA = (Uint8)(dstpixel >> 24);
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(srcR, modulateR, srcR);
                MULT_DIV_255(srcG, modulateG, srcG);
                MULT_DIV_255(srcB, modulateB, srcB);
            }
            if (flags & SDL_COPY_MODULATE_ALPHA) {
                MULT_DIV_255(srcA, modulateA, srcA);
            }
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                if (dstA > 255) dstA = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstA << 24) | (dstB << 16) | (dstG << 8) | dstR;
            *dst = dstpixel;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_ABGR8888_XRGB8888_Scale(SDL_BlitInfo *info)
{
    Uint32 pixelvalue;
    Uint32 R, G, B;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            pixelvalue = *src;
            B = (Uint8)(pixelvalue >> 16); G = (Uint8)(pixelvalue >> 8); R = (Uint8)pixelvalue;
            pixelvalue = (R << 16) | (G << 8) | B;
            *dst = pixelvalue;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_ABGR8888_XRGB8888_Blend(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            srcpixel = *src;
            srcB = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcR = (Uint8)srcpixel; srcA = (Uint8)(srcpixel >> 24);
            dstpixel = *dst;
            dstR = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstB = (Uint8)dstpixel;
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstR << 16) | (dstG << 8) | dstB;
            *dst = dstpixel;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_ABGR8888_XRGB8888_Blend_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            srcpixel = *src;
            srcB = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcR = (Uint8)srcpixel; srcA = (Uint8)(srcpixel >> 24);
            dstpixel = *dst;
            dstR = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstB = (Uint8)dstpixel;
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstR << 16) | (dstG << 8) | dstB;
            *dst = dstpixel;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_ABGR8888_XRGB8888_Modulate(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    Uint32 pixelvalue;
    Uint32 R, G, B;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            pixelvalue = *src;
            B = (Uint8)(pixelvalue >> 16); G = (Uint8)(pixelvalue >> 8); R = (Uint8)pixelvalue;
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(R, modulateR, R);
                MULT_DIV_255(G, modulateG, G);
                MULT_DIV_255(B, modulateB, B);
            }
            pixelvalue = (R << 16) | (G << 8) | B;
            *dst = pixelvalue;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_ABGR8888_XRGB8888_Modulate_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    Uint32 pixelvalue;
    Uint32 R, G, B;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            pixelvalue = *src;
            B = (Uint8)(pixelvalue >> 16); G = (Uint8)(pixelvalue >> 8); R = (Uint8)pixelvalue;
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(R, modulateR, R);
                MULT_DIV_255(G, modulateG, G);
                MULT_DIV_255(B, modulateB, B);
            }
            pixelvalue = (R << 16) | (G << 8) | B;
            *dst = pixelvalue;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_ABGR8888_XRGB8888_Modulate_Blend(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            srcpixel = *src;
            srcB = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcR = (Uint8)srcpixel; srcA = (Uint8)(srcpixel >> 24);
            dstpixel = *dst;
            dstR = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstB = (Uint8)dstpixel;
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(srcR, modulateR, srcR);
                MULT_DIV_255(srcG, modulateG, srcG);
                MULT_DIV_255(srcB, modulateB, srcB);
            }
            if (flags & SDL_COPY_MODULATE_ALPHA) {
                MULT_DIV_255(srcA, modulateA, srcA);
            }
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstR << 16) | (dstG << 8) | dstB;
            *dst = dstpixel;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_ABGR8888_XRGB8888_Modulate_Blend_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            srcpixel = *src;
            srcB = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcR = (Uint8)srcpixel; srcA = (Uint8)(srcpixel >> 24);
            dstpixel = *dst;
            dstR = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstB = (Uint8)dstpixel;
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(srcR, modulateR, srcR);
                MULT_DIV_255(srcG, modulateG, srcG);
                MULT_DIV_255(srcB, modulateB, srcB);
            }
            if (flags & SDL_COPY_MODULATE_ALPHA) {
                MULT_DIV_255(srcA, modulateA, srcA);
            }
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstR << 16) | (dstG << 8) | dstB;
            *dst = dstpixel;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_ABGR8888_XBGR8888_Scale(SDL_BlitInfo *info)
{
    Uint32 pixelvalue;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            pixelvalue = *src;
            pixelvalue &= 0xFFFFFF;
            *dst = pixelvalue;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_ABGR8888_XBGR8888_Blend(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            srcpixel = *src;
            srcB = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcR = (Uint8)srcpixel; srcA = (Uint8)(srcpixel >> 24);
            dstpixel = *dst;
            dstB = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstR = (Uint8)dstpixel;
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstB << 16) | (dstG << 8) | dstR;
            *dst = dstpixel;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_ABGR8888_XBGR8888_Blend_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            srcpixel = *src;
            srcB = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcR = (Uint8)srcpixel; srcA = (Uint8)(srcpixel >> 24);
            dstpixel = *dst;
            dstB = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstR = (Uint8)dstpixel;
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstB << 16) | (dstG << 8) | dstR;
            *dst = dstpixel;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_ABGR8888_XBGR8888_Modulate(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    Uint32 pixelvalue;
    Uint32 R, G, B;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            pixelvalue = *src;
            B = (Uint8)(pixelvalue >> 16); G = (Uint8)(pixelvalue >> 8); R = (Uint8)pixelvalue;
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(R, modulateR, R);
                MULT_DIV_255(G, modulateG, G);
                MULT_DIV_255(B, modulateB, B);
            }
            pixelvalue = (B << 16) | (G << 8) | R;
            *dst = pixelvalue;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_ABGR8888_XBGR8888_Modulate_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    Uint32 pixelvalue;
    Uint32 R, G, B;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            pixelvalue = *src;
            B = (Uint8)(pixelvalue >> 16); G = (Uint8)(pixelvalue >> 8); R = (Uint8)pixelvalue;
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(R, modulateR, R);
                MULT_DIV_255(G, modulateG, G);
                MULT_DIV_255(B, modulateB, B);
            }
            pixelvalue = (B << 16) | (G << 8) | R;
            *dst = pixelvalue;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_ABGR8888_XBGR8888_Modulate_Blend(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            srcpixel = *src;
            srcB = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcR = (Uint8)srcpixel; srcA = (Uint8)(srcpixel >> 24);
            dstpixel = *dst;
            dstB = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstR = (Uint8)dstpixel;
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(srcR, modulateR, srcR);
                MULT_DIV_255(srcG, modulateG, srcG);
                MULT_DIV_255(srcB, modulateB, srcB);
            }
            if (flags & SDL_COPY_MODULATE_ALPHA) {
                MULT_DIV_255(srcA, modulateA, srcA);
            }
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstB << 16) | (dstG << 8) | dstR;
            *dst = dstpixel;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_ABGR8888_XBGR8888_Modulate_Blend_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            srcpixel = *src;
            srcB = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcR = (Uint8)srcpixel; srcA = (Uint8)(srcpixel >> 24);
            dstpixel = *dst;
            dstB = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstR = (Uint8)dstpixel;
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(srcR, modulateR, srcR);
                MULT_DIV_255(srcG, modulateG, srcG);
                MULT_DIV_255(srcB, modulateB, srcB);
            }
            if (flags & SDL_COPY_MODULATE_ALPHA) {
                MULT_DIV_255(srcA, modulateA, srcA);
            }
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstB << 16) | (dstG << 8) | dstR;
            *dst = dstpixel;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_ABGR8888_ARGB8888_Scale(SDL_BlitInfo *info)
{
    Uint32 pixelvalue;
    Uint32 R, G, B, A;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            pixelvalue = *src;
            B = (Uint8)(pixelvalue >> 16); G = (Uint8)(pixelvalue >> 8); R = (Uint8)pixelvalue; A = (Uint8)(pixelvalue >> 24);
            pixelvalue = (A << 24) | (R << 16) | (G << 8) | B;
            *dst = pixelvalue;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_ABGR8888_ARGB8888_Blend(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB, dstA;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            srcpixel = *src;
            srcB = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcR = (Uint8)srcpixel; srcA = (Uint8)(srcpixel >> 24);
            dstpixel = *dst;
            dstR = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstB = (Uint8)dstpixel; dstA = (Uint8)(dstpixel >> 24);
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                if (dstA > 255) dstA = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstA << 24) | (dstR << 16) | (dstG << 8) | dstB;
            *dst = dstpixel;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_ABGR8888_ARGB8888_Blend_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB, dstA;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            srcpixel = *src;
            srcB = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcR = (Uint8)srcpixel; srcA = (Uint8)(srcpixel >> 24);
            dstpixel = *dst;
            dstR = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstB = (Uint8)dstpixel; dstA = (Uint8)(dstpixel >> 24);
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                if (dstA > 255) dstA = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstA << 24) | (dstR << 16) | (dstG << 8) | dstB;
            *dst = dstpixel;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_ABGR8888_ARGB8888_Modulate(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 pixelvalue;
    Uint32 R, G, B, A;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            pixelvalue = *src;
            B = (Uint8)(pixelvalue >> 16); G = (Uint8)(pixelvalue >> 8); R = (Uint8)pixelvalue; A = (Uint8)(pixelvalue >> 24);
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(R, modulateR, R);
                MULT_DIV_255(G, modulateG, G);
                MULT_DIV_255(B, modulateB, B);
            }
            if (flags & SDL_COPY_MODULATE_ALPHA) {
                MULT_DIV_255(A, modulateA, A);
            }
            pixelvalue = (A << 24) | (R << 16) | (G << 8) | B;
            *dst = pixelvalue;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_ABGR8888_ARGB8888_Modulate_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 pixelvalue;
    Uint32 R, G, B, A;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            pixelvalue = *src;
            B = (Uint8)(pixelvalue >> 16); G = (Uint8)(pixelvalue >> 8); R = (Uint8)pixelvalue; A = (Uint8)(pixelvalue >> 24);
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(R, modulateR, R);
                MULT_DIV_255(G, modulateG, G);
                MULT_DIV_255(B, modulateB, B);
            }
            if (flags & SDL_COPY_MODULATE_ALPHA) {
                MULT_DIV_255(A, modulateA, A);
            }
            pixelvalue = (A << 24) | (R << 16) | (G << 8) | B;
            *dst = pixelvalue;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_ABGR8888_ARGB8888_Modulate_Blend(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB, dstA;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            srcpixel = *src;
            srcB = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcR = (Uint8)srcpixel; srcA = (Uint8)(srcpixel >> 24);
            dstpixel = *dst;
            dstR = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstB = (Uint8)dstpixel; dstA = (Uint8)(dstpixel >> 24);
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(srcR, modulateR, srcR);
                MULT_DIV_255(srcG, modulateG, srcG);
                MULT_DIV_255(srcB, modulateB, srcB);
            }
            if (flags & SDL_COPY_MODULATE_ALPHA) {
                MULT_DIV_255(srcA, modulateA, srcA);
            }
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                if (dstA > 255) dstA = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstA << 24) | (dstR << 16) | (dstG << 8) | dstB;
            *dst = dstpixel;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_ABGR8888_ARGB8888_Modulate_Blend_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB, dstA;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            srcpixel = *src;
            srcB = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcR = (Uint8)srcpixel; srcA = (Uint8)(srcpixel >> 24);
            dstpixel = *dst;
            dstR = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstB = (Uint8)dstpixel; dstA = (Uint8)(dstpixel >> 24);
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(srcR, modulateR, srcR);
                MULT_DIV_255(srcG, modulateG, srcG);
                MULT_DIV_255(srcB, modulateB, srcB);
            }
            if (flags & SDL_COPY_MODULATE_ALPHA) {
                MULT_DIV_255(srcA, modulateA, srcA);
            }
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                if (dstA > 255) dstA = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstA << 24) | (dstR << 16) | (dstG << 8) | dstB;
            *dst = dstpixel;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_ABGR8888_ABGR8888_Scale(SDL_BlitInfo *info)
{
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            *dst = *src;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_ABGR8888_ABGR8888_Blend(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB, dstA;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            srcpixel = *src;
            srcB = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcR = (Uint8)srcpixel; srcA = (Uint8)(srcpixel >> 24);
            dstpixel = *dst;
            dstB = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstR = (Uint8)dstpixel; dstA = (Uint8)(dstpixel >> 24);
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                if (dstA > 255) dstA = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstA << 24) | (dstB << 16) | (dstG << 8) | dstR;
            *dst = dstpixel;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_ABGR8888_ABGR8888_Blend_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB, dstA;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            srcpixel = *src;
            srcB = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcR = (Uint8)srcpixel; srcA = (Uint8)(srcpixel >> 24);
            dstpixel = *dst;
            dstB = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstR = (Uint8)dstpixel; dstA = (Uint8)(dstpixel >> 24);
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                if (dstA > 255) dstA = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstA << 24) | (dstB << 16) | (dstG << 8) | dstR;
            *dst = dstpixel;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_ABGR8888_ABGR8888_Modulate(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 pixelvalue;
    Uint32 R, G, B, A;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            pixelvalue = *src;
            B = (Uint8)(pixelvalue >> 16); G = (Uint8)(pixelvalue >> 8); R = (Uint8)pixelvalue; A = (Uint8)(pixelvalue >> 24);
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(R, modulateR, R);
                MULT_DIV_255(G, modulateG, G);
                MULT_DIV_255(B, modulateB, B);
            }
            if (flags & SDL_COPY_MODULATE_ALPHA) {
                MULT_DIV_255(A, modulateA, A);
            }
            pixelvalue = (A << 24) | (B << 16) | (G << 8) | R;
            *dst = pixelvalue;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_ABGR8888_ABGR8888_Modulate_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 pixelvalue;
    Uint32 R, G, B, A;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            pixelvalue = *src;
            B = (Uint8)(pixelvalue >> 16); G = (Uint8)(pixelvalue >> 8); R = (Uint8)pixelvalue; A = (Uint8)(pixelvalue >> 24);
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(R, modulateR, R);
                MULT_DIV_255(G, modulateG, G);
                MULT_DIV_255(B, modulateB, B);
            }
            if (flags & SDL_COPY_MODULATE_ALPHA) {
                MULT_DIV_255(A, modulateA, A);
            }
            pixelvalue = (A << 24) | (B << 16) | (G << 8) | R;
            *dst = pixelvalue;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_ABGR8888_ABGR8888_Modulate_Blend(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB, dstA;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            srcpixel = *src;
            srcB = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcR = (Uint8)srcpixel; srcA = (Uint8)(srcpixel >> 24);
            dstpixel = *dst;
            dstB = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstR = (Uint8)dstpixel; dstA = (Uint8)(dstpixel >> 24);
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(srcR, modulateR, srcR);
                MULT_DIV_255(srcG, modulateG, srcG);
                MULT_DIV_255(srcB, modulateB, srcB);
            }
            if (flags & SDL_COPY_MODULATE_ALPHA) {
                MULT_DIV_255(srcA, modulateA, srcA);
            }
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                if (dstA > 255) dstA = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstA << 24) | (dstB << 16) | (dstG << 8) | dstR;
            *dst = dstpixel;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_ABGR8888_ABGR8888_Modulate_Blend_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB, dstA;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            srcpixel = *src;
            srcB = (Uint8)(srcpixel >> 16); srcG = (Uint8)(srcpixel >> 8); srcR = (Uint8)srcpixel; srcA = (Uint8)(srcpixel >> 24);
            dstpixel = *dst;
            dstB = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstR = (Uint8)dstpixel; dstA = (Uint8)(dstpixel >> 24);
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(srcR, modulateR, srcR);
                MULT_DIV_255(srcG, modulateG, srcG);
                MULT_DIV_255(srcB, modulateB, srcB);
            }
            if (flags & SDL_COPY_MODULATE_ALPHA) {
                MULT_DIV_255(srcA, modulateA, srcA);
            }
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                if (dstA > 255) dstA = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstA << 24) | (dstB << 16) | (dstG << 8) | dstR;
            *dst = dstpixel;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_BGRA8888_XRGB8888_Scale(SDL_BlitInfo *info)
{
    Uint32 pixelvalue;
    Uint32 R, G, B;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            pixelvalue = *src;
            B = (Uint8)(pixelvalue >> 24); G = (Uint8)(pixelvalue >> 16); R = (Uint8)(pixelvalue >> 8);
            pixelvalue = (R << 16) | (G << 8) | B;
            *dst = pixelvalue;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_BGRA8888_XRGB8888_Blend(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            srcpixel = *src;
            srcB = (Uint8)(srcpixel >> 24); srcG = (Uint8)(srcpixel >> 16); srcR = (Uint8)(srcpixel >> 8); srcA = (Uint8)srcpixel;
            dstpixel = *dst;
            dstR = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstB = (Uint8)dstpixel;
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstR << 16) | (dstG << 8) | dstB;
            *dst = dstpixel;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_BGRA8888_XRGB8888_Blend_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            srcpixel = *src;
            srcB = (Uint8)(srcpixel >> 24); srcG = (Uint8)(srcpixel >> 16); srcR = (Uint8)(srcpixel >> 8); srcA = (Uint8)srcpixel;
            dstpixel = *dst;
            dstR = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstB = (Uint8)dstpixel;
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstR << 16) | (dstG << 8) | dstB;
            *dst = dstpixel;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_BGRA8888_XRGB8888_Modulate(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    Uint32 pixelvalue;
    Uint32 R, G, B;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            pixelvalue = *src;
            B = (Uint8)(pixelvalue >> 24); G = (Uint8)(pixelvalue >> 16); R = (Uint8)(pixelvalue >> 8);
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(R, modulateR, R);
                MULT_DIV_255(G, modulateG, G);
                MULT_DIV_255(B, modulateB, B);
            }
            pixelvalue = (R << 16) | (G << 8) | B;
            *dst = pixelvalue;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_BGRA8888_XRGB8888_Modulate_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    Uint32 pixelvalue;
    Uint32 R, G, B;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            pixelvalue = *src;
            B = (Uint8)(pixelvalue >> 24); G = (Uint8)(pixelvalue >> 16); R = (Uint8)(pixelvalue >> 8);
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(R, modulateR, R);
                MULT_DIV_255(G, modulateG, G);
                MULT_DIV_255(B, modulateB, B);
            }
            pixelvalue = (R << 16) | (G << 8) | B;
            *dst = pixelvalue;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_BGRA8888_XRGB8888_Modulate_Blend(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            srcpixel = *src;
            srcB = (Uint8)(srcpixel >> 24); srcG = (Uint8)(srcpixel >> 16); srcR = (Uint8)(srcpixel >> 8); srcA = (Uint8)srcpixel;
            dstpixel = *dst;
            dstR = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstB = (Uint8)dstpixel;
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(srcR, modulateR, srcR);
                MULT_DIV_255(srcG, modulateG, srcG);
                MULT_DIV_255(srcB, modulateB, srcB);
            }
            if (flags & SDL_COPY_MODULATE_ALPHA) {
                MULT_DIV_255(srcA, modulateA, srcA);
            }
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstR << 16) | (dstG << 8) | dstB;
            *dst = dstpixel;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_BGRA8888_XRGB8888_Modulate_Blend_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            srcpixel = *src;
            srcB = (Uint8)(srcpixel >> 24); srcG = (Uint8)(srcpixel >> 16); srcR = (Uint8)(srcpixel >> 8); srcA = (Uint8)srcpixel;
            dstpixel = *dst;
            dstR = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstB = (Uint8)dstpixel;
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(srcR, modulateR, srcR);
                MULT_DIV_255(srcG, modulateG, srcG);
                MULT_DIV_255(srcB, modulateB, srcB);
            }
            if (flags & SDL_COPY_MODULATE_ALPHA) {
                MULT_DIV_255(srcA, modulateA, srcA);
            }
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstR << 16) | (dstG << 8) | dstB;
            *dst = dstpixel;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_BGRA8888_XBGR8888_Scale(SDL_BlitInfo *info)
{
    Uint32 pixelvalue;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            pixelvalue = *src;
            pixelvalue >>= 8;
            *dst = pixelvalue;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_BGRA8888_XBGR8888_Blend(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            srcpixel = *src;
            srcB = (Uint8)(srcpixel >> 24); srcG = (Uint8)(srcpixel >> 16); srcR = (Uint8)(srcpixel >> 8); srcA = (Uint8)srcpixel;
            dstpixel = *dst;
            dstB = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstR = (Uint8)dstpixel;
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstB << 16) | (dstG << 8) | dstR;
            *dst = dstpixel;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_BGRA8888_XBGR8888_Blend_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            srcpixel = *src;
            srcB = (Uint8)(srcpixel >> 24); srcG = (Uint8)(srcpixel >> 16); srcR = (Uint8)(srcpixel >> 8); srcA = (Uint8)srcpixel;
            dstpixel = *dst;
            dstB = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstR = (Uint8)dstpixel;
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstB << 16) | (dstG << 8) | dstR;
            *dst = dstpixel;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_BGRA8888_XBGR8888_Modulate(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    Uint32 pixelvalue;
    Uint32 R, G, B;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            pixelvalue = *src;
            B = (Uint8)(pixelvalue >> 24); G = (Uint8)(pixelvalue >> 16); R = (Uint8)(pixelvalue >> 8);
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(R, modulateR, R);
                MULT_DIV_255(G, modulateG, G);
                MULT_DIV_255(B, modulateB, B);
            }
            pixelvalue = (B << 16) | (G << 8) | R;
            *dst = pixelvalue;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_BGRA8888_XBGR8888_Modulate_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    Uint32 pixelvalue;
    Uint32 R, G, B;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            pixelvalue = *src;
            B = (Uint8)(pixelvalue >> 24); G = (Uint8)(pixelvalue >> 16); R = (Uint8)(pixelvalue >> 8);
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(R, modulateR, R);
                MULT_DIV_255(G, modulateG, G);
                MULT_DIV_255(B, modulateB, B);
            }
            pixelvalue = (B << 16) | (G << 8) | R;
            *dst = pixelvalue;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_BGRA8888_XBGR8888_Modulate_Blend(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            srcpixel = *src;
            srcB = (Uint8)(srcpixel >> 24); srcG = (Uint8)(srcpixel >> 16); srcR = (Uint8)(srcpixel >> 8); srcA = (Uint8)srcpixel;
            dstpixel = *dst;
            dstB = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstR = (Uint8)dstpixel;
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(srcR, modulateR, srcR);
                MULT_DIV_255(srcG, modulateG, srcG);
                MULT_DIV_255(srcB, modulateB, srcB);
            }
            if (flags & SDL_COPY_MODULATE_ALPHA) {
                MULT_DIV_255(srcA, modulateA, srcA);
            }
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstB << 16) | (dstG << 8) | dstR;
            *dst = dstpixel;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_BGRA8888_XBGR8888_Modulate_Blend_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            srcpixel = *src;
            srcB = (Uint8)(srcpixel >> 24); srcG = (Uint8)(srcpixel >> 16); srcR = (Uint8)(srcpixel >> 8); srcA = (Uint8)srcpixel;
            dstpixel = *dst;
            dstB = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstR = (Uint8)dstpixel;
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(srcR, modulateR, srcR);
                MULT_DIV_255(srcG, modulateG, srcG);
                MULT_DIV_255(srcB, modulateB, srcB);
            }
            if (flags & SDL_COPY_MODULATE_ALPHA) {
                MULT_DIV_255(srcA, modulateA, srcA);
            }
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstB << 16) | (dstG << 8) | dstR;
            *dst = dstpixel;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_BGRA8888_ARGB8888_Scale(SDL_BlitInfo *info)
{
    Uint32 pixelvalue;
    Uint32 R, G, B, A;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            pixelvalue = *src;
            B = (Uint8)(pixelvalue >> 24); G = (Uint8)(pixelvalue >> 16); R = (Uint8)(pixelvalue >> 8); A = (Uint8)pixelvalue;
            pixelvalue = (A << 24) | (R << 16) | (G << 8) | B;
            *dst = pixelvalue;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_BGRA8888_ARGB8888_Blend(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB, dstA;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            srcpixel = *src;
            srcB = (Uint8)(srcpixel >> 24); srcG = (Uint8)(srcpixel >> 16); srcR = (Uint8)(srcpixel >> 8); srcA = (Uint8)srcpixel;
            dstpixel = *dst;
            dstR = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstB = (Uint8)dstpixel; dstA = (Uint8)(dstpixel >> 24);
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                if (dstA > 255) dstA = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstA << 24) | (dstR << 16) | (dstG << 8) | dstB;
            *dst = dstpixel;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_BGRA8888_ARGB8888_Blend_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB, dstA;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            srcpixel = *src;
            srcB = (Uint8)(srcpixel >> 24); srcG = (Uint8)(srcpixel >> 16); srcR = (Uint8)(srcpixel >> 8); srcA = (Uint8)srcpixel;
            dstpixel = *dst;
            dstR = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstB = (Uint8)dstpixel; dstA = (Uint8)(dstpixel >> 24);
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                if (dstA > 255) dstA = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstA << 24) | (dstR << 16) | (dstG << 8) | dstB;
            *dst = dstpixel;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_BGRA8888_ARGB8888_Modulate(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 pixelvalue;
    Uint32 R, G, B, A;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            pixelvalue = *src;
            B = (Uint8)(pixelvalue >> 24); G = (Uint8)(pixelvalue >> 16); R = (Uint8)(pixelvalue >> 8); A = (Uint8)pixelvalue;
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(R, modulateR, R);
                MULT_DIV_255(G, modulateG, G);
                MULT_DIV_255(B, modulateB, B);
            }
            if (flags & SDL_COPY_MODULATE_ALPHA) {
                MULT_DIV_255(A, modulateA, A);
            }
            pixelvalue = (A << 24) | (R << 16) | (G << 8) | B;
            *dst = pixelvalue;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_BGRA8888_ARGB8888_Modulate_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 pixelvalue;
    Uint32 R, G, B, A;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            pixelvalue = *src;
            B = (Uint8)(pixelvalue >> 24); G = (Uint8)(pixelvalue >> 16); R = (Uint8)(pixelvalue >> 8); A = (Uint8)pixelvalue;
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(R, modulateR, R);
                MULT_DIV_255(G, modulateG, G);
                MULT_DIV_255(B, modulateB, B);
            }
            if (flags & SDL_COPY_MODULATE_ALPHA) {
                MULT_DIV_255(A, modulateA, A);
            }
            pixelvalue = (A << 24) | (R << 16) | (G << 8) | B;
            *dst = pixelvalue;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_BGRA8888_ARGB8888_Modulate_Blend(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB, dstA;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            srcpixel = *src;
            srcB = (Uint8)(srcpixel >> 24); srcG = (Uint8)(srcpixel >> 16); srcR = (Uint8)(srcpixel >> 8); srcA = (Uint8)srcpixel;
            dstpixel = *dst;
            dstR = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstB = (Uint8)dstpixel; dstA = (Uint8)(dstpixel >> 24);
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(srcR, modulateR, srcR);
                MULT_DIV_255(srcG, modulateG, srcG);
                MULT_DIV_255(srcB, modulateB, srcB);
            }
            if (flags & SDL_COPY_MODULATE_ALPHA) {
                MULT_DIV_255(srcA, modulateA, srcA);
            }
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                if (dstA > 255) dstA = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstA << 24) | (dstR << 16) | (dstG << 8) | dstB;
            *dst = dstpixel;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_BGRA8888_ARGB8888_Modulate_Blend_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB, dstA;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            srcpixel = *src;
            srcB = (Uint8)(srcpixel >> 24); srcG = (Uint8)(srcpixel >> 16); srcR = (Uint8)(srcpixel >> 8); srcA = (Uint8)srcpixel;
            dstpixel = *dst;
            dstR = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstB = (Uint8)dstpixel; dstA = (Uint8)(dstpixel >> 24);
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(srcR, modulateR, srcR);
                MULT_DIV_255(srcG, modulateG, srcG);
                MULT_DIV_255(srcB, modulateB, srcB);
            }
            if (flags & SDL_COPY_MODULATE_ALPHA) {
                MULT_DIV_255(srcA, modulateA, srcA);
            }
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                if (dstA > 255) dstA = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstA << 24) | (dstR << 16) | (dstG << 8) | dstB;
            *dst = dstpixel;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_BGRA8888_ABGR8888_Scale(SDL_BlitInfo *info)
{
    Uint32 pixelvalue;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            pixelvalue = *src;
            pixelvalue = (pixelvalue >> 8) | (pixelvalue << 24);
            *dst = pixelvalue;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_BGRA8888_ABGR8888_Blend(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB, dstA;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            srcpixel = *src;
            srcB = (Uint8)(srcpixel >> 24); srcG = (Uint8)(srcpixel >> 16); srcR = (Uint8)(srcpixel >> 8); srcA = (Uint8)srcpixel;
            dstpixel = *dst;
            dstB = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstR = (Uint8)dstpixel; dstA = (Uint8)(dstpixel >> 24);
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                if (dstA > 255) dstA = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstA << 24) | (dstB << 16) | (dstG << 8) | dstR;
            *dst = dstpixel;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_BGRA8888_ABGR8888_Blend_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB, dstA;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            srcpixel = *src;
            srcB = (Uint8)(srcpixel >> 24); srcG = (Uint8)(srcpixel >> 16); srcR = (Uint8)(srcpixel >> 8); srcA = (Uint8)srcpixel;
            dstpixel = *dst;
            dstB = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstR = (Uint8)dstpixel; dstA = (Uint8)(dstpixel >> 24);
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                if (dstA > 255) dstA = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstA << 24) | (dstB << 16) | (dstG << 8) | dstR;
            *dst = dstpixel;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_BGRA8888_ABGR8888_Modulate(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 pixelvalue;
    Uint32 R, G, B, A;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            pixelvalue = *src;
            B = (Uint8)(pixelvalue >> 24); G = (Uint8)(pixelvalue >> 16); R = (Uint8)(pixelvalue >> 8); A = (Uint8)pixelvalue;
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(R, modulateR, R);
                MULT_DIV_255(G, modulateG, G);
                MULT_DIV_255(B, modulateB, B);
            }
            if (flags & SDL_COPY_MODULATE_ALPHA) {
                MULT_DIV_255(A, modulateA, A);
            }
            pixelvalue = (A << 24) | (B << 16) | (G << 8) | R;
            *dst = pixelvalue;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_BGRA8888_ABGR8888_Modulate_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 pixelvalue;
    Uint32 R, G, B, A;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            pixelvalue = *src;
            B = (Uint8)(pixelvalue >> 24); G = (Uint8)(pixelvalue >> 16); R = (Uint8)(pixelvalue >> 8); A = (Uint8)pixelvalue;
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(R, modulateR, R);
                MULT_DIV_255(G, modulateG, G);
                MULT_DIV_255(B, modulateB, B);
            }
            if (flags & SDL_COPY_MODULATE_ALPHA) {
                MULT_DIV_255(A, modulateA, A);
            }
            pixelvalue = (A << 24) | (B << 16) | (G << 8) | R;
            *dst = pixelvalue;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_BGRA8888_ABGR8888_Modulate_Blend(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB, dstA;

    while (info->dst_h--) {
        Uint32 *src = (Uint32 *)info->src;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        while (n--) {
            srcpixel = *src;
            srcB = (Uint8)(srcpixel >> 24); srcG = (Uint8)(srcpixel >> 16); srcR = (Uint8)(srcpixel >> 8); srcA = (Uint8)srcpixel;
            dstpixel = *dst;
            dstB = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstR = (Uint8)dstpixel; dstA = (Uint8)(dstpixel >> 24);
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(srcR, modulateR, srcR);
                MULT_DIV_255(srcG, modulateG, srcG);
                MULT_DIV_255(srcB, modulateB, srcB);
            }
            if (flags & SDL_COPY_MODULATE_ALPHA) {
                MULT_DIV_255(srcA, modulateA, srcA);
            }
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                if (dstA > 255) dstA = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstA << 24) | (dstB << 16) | (dstG << 8) | dstR;
            *dst = dstpixel;
            ++src;
            ++dst;
        }
        info->src += info->src_pitch;
        info->dst += info->dst_pitch;
    }
}

static void SDL_Blit_BGRA8888_ABGR8888_Modulate_Blend_Scale(SDL_BlitInfo *info)
{
    const int flags = info->flags;
    const Uint32 modulateR = info->r;
    const Uint32 modulateG = info->g;
    const Uint32 modulateB = info->b;
    const Uint32 modulateA = info->a;
    Uint32 srcpixel;
    Uint32 srcR, srcG, srcB, srcA;
    Uint32 dstpixel;
    Uint32 dstR, dstG, dstB, dstA;
    Uint64 srcy, srcx;
    Uint64 posy, posx;
    Uint64 incy, incx;

    incy = ((Uint64)info->src_h << 16) / info->dst_h;
    incx = ((Uint64)info->src_w << 16) / info->dst_w;
    posy = incy / 2;

    while (info->dst_h--) {
        Uint32 *src = NULL;
        Uint32 *dst = (Uint32 *)info->dst;
        int n = info->dst_w;
        posx = incx / 2;

        srcy = posy >> 16;
        while (n--) {
            srcx = posx >> 16;
            src = (Uint32 *)(info->src + (srcy * info->src_pitch) + (srcx * 4));
            srcpixel = *src;
            srcB = (Uint8)(srcpixel >> 24); srcG = (Uint8)(srcpixel >> 16); srcR = (Uint8)(srcpixel >> 8); srcA = (Uint8)srcpixel;
            dstpixel = *dst;
            dstB = (Uint8)(dstpixel >> 16); dstG = (Uint8)(dstpixel >> 8); dstR = (Uint8)dstpixel; dstA = (Uint8)(dstpixel >> 24);
            if (flags & SDL_COPY_MODULATE_COLOR) {
                MULT_DIV_255(srcR, modulateR, srcR);
                MULT_DIV_255(srcG, modulateG, srcG);
                MULT_DIV_255(srcB, modulateB, srcB);
            }
            if (flags & SDL_COPY_MODULATE_ALPHA) {
                MULT_DIV_255(srcA, modulateA, srcA);
            }
            if (flags & (SDL_COPY_BLEND|SDL_COPY_ADD)) {
                if (srcA < 255) {
                    MULT_DIV_255(srcR, srcA, srcR);
                    MULT_DIV_255(srcG, srcA, srcG);
                    MULT_DIV_255(srcB, srcA, srcB);
                }
            }
            switch (flags & SDL_COPY_BLEND_MASK) {
            case SDL_COPY_BLEND:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                break;
            case SDL_COPY_BLEND_PREMULTIPLIED:
                MULT_DIV_255((255 - srcA), dstR, dstR);
                dstR += srcR;
                if (dstR > 255) dstR = 255;
                MULT_DIV_255((255 - srcA), dstG, dstG);
                dstG += srcG;
                if (dstG > 255) dstG = 255;
                MULT_DIV_255((255 - srcA), dstB, dstB);
                dstB += srcB;
                if (dstB > 255) dstB = 255;
                MULT_DIV_255((255 - srcA), dstA, dstA);
                dstA += srcA;
                if (dstA > 255) dstA = 255;
                break;
            case SDL_COPY_ADD:
            case SDL_COPY_ADD_PREMULTIPLIED:
                dstR = srcR + dstR; if (dstR > 255) dstR = 255;
                dstG = srcG + dstG; if (dstG > 255) dstG = 255;
                dstB = srcB + dstB; if (dstB > 255) dstB = 255;
                break;
            case SDL_COPY_MOD:
                MULT_DIV_255(srcR, dstR, dstR);
                MULT_DIV_255(srcG, dstG, dstG);
                MULT_DIV_255(srcB, dstB, dstB);
                break;
            case SDL_COPY_MUL:
                {
                    Uint32 tmp1, tmp2;

                    MULT_DIV_255(srcR, dstR, tmp1);
                    MULT_DIV_255(dstR, (255 - srcA), tmp2);
                    dstR = tmp1 + tmp2; if (dstR > 255) dstR = 255;
                    MULT_DIV_255(srcG, dstG, tmp1);
                    MULT_DIV_255(dstG, (255 - srcA), tmp2);
                    dstG = tmp1 + tmp2; if (dstG > 255) dstG = 255;
                    MULT_DIV_255(srcB, dstB, tmp1);
                    MULT_DIV_255(dstB, (255 - srcA), tmp2);
                    dstB = tmp1 + tmp2; if (dstB > 255) dstB = 255;
                }
                break;
            }
            dstpixel = (dstA << 24) | (dstB << 16) | (dstG << 8) | dstR;
            *dst = dstpixel;
            posx += incx;
            ++dst;
        }
        posy += incy;
        info->dst += info->dst_pitch;
    }
}

SDL_BlitFuncEntry SDL_GeneratedBlitFuncTable[] = {
    { SDL_PIXELFORMAT_XRGB8888, SDL_PIXELFORMAT_XRGB8888, (SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_XRGB8888_XRGB8888_Scale },
    { SDL_PIXELFORMAT_XRGB8888, SDL_PIXELFORMAT_XRGB8888, (SDL_COPY_BLEND_MASK), SDL_CPU_ANY, SDL_Blit_XRGB8888_XRGB8888_Blend },
    { SDL_PIXELFORMAT_XRGB8888, SDL_PIXELFORMAT_XRGB8888, (SDL_COPY_BLEND_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_XRGB8888_XRGB8888_Blend_Scale },
    { SDL_PIXELFORMAT_XRGB8888, SDL_PIXELFORMAT_XRGB8888, (SDL_COPY_MODULATE_MASK), SDL_CPU_ANY, SDL_Blit_XRGB8888_XRGB8888_Modulate },
    { SDL_PIXELFORMAT_XRGB8888, SDL_PIXELFORMAT_XRGB8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_XRGB8888_XRGB8888_Modulate_Scale },
    { SDL_PIXELFORMAT_XRGB8888, SDL_PIXELFORMAT_XRGB8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_BLEND_MASK), SDL_CPU_ANY, SDL_Blit_XRGB8888_XRGB8888_Modulate_Blend },
    { SDL_PIXELFORMAT_XRGB8888, SDL_PIXELFORMAT_XRGB8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_BLEND_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_XRGB8888_XRGB8888_Modulate_Blend_Scale },
    { SDL_PIXELFORMAT_XRGB8888, SDL_PIXELFORMAT_XBGR8888, (SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_XRGB8888_XBGR8888_Scale },
    { SDL_PIXELFORMAT_XRGB8888, SDL_PIXELFORMAT_XBGR8888, (SDL_COPY_BLEND_MASK), SDL_CPU_ANY, SDL_Blit_XRGB8888_XBGR8888_Blend },
    { SDL_PIXELFORMAT_XRGB8888, SDL_PIXELFORMAT_XBGR8888, (SDL_COPY_BLEND_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_XRGB8888_XBGR8888_Blend_Scale },
    { SDL_PIXELFORMAT_XRGB8888, SDL_PIXELFORMAT_XBGR8888, (SDL_COPY_MODULATE_MASK), SDL_CPU_ANY, SDL_Blit_XRGB8888_XBGR8888_Modulate },
    { SDL_PIXELFORMAT_XRGB8888, SDL_PIXELFORMAT_XBGR8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_XRGB8888_XBGR8888_Modulate_Scale },
    { SDL_PIXELFORMAT_XRGB8888, SDL_PIXELFORMAT_XBGR8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_BLEND_MASK), SDL_CPU_ANY, SDL_Blit_XRGB8888_XBGR8888_Modulate_Blend },
    { SDL_PIXELFORMAT_XRGB8888, SDL_PIXELFORMAT_XBGR8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_BLEND_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_XRGB8888_XBGR8888_Modulate_Blend_Scale },
    { SDL_PIXELFORMAT_XRGB8888, SDL_PIXELFORMAT_ARGB8888, (SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_XRGB8888_ARGB8888_Scale },
    { SDL_PIXELFORMAT_XRGB8888, SDL_PIXELFORMAT_ARGB8888, (SDL_COPY_BLEND_MASK), SDL_CPU_ANY, SDL_Blit_XRGB8888_ARGB8888_Blend },
    { SDL_PIXELFORMAT_XRGB8888, SDL_PIXELFORMAT_ARGB8888, (SDL_COPY_BLEND_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_XRGB8888_ARGB8888_Blend_Scale },
    { SDL_PIXELFORMAT_XRGB8888, SDL_PIXELFORMAT_ARGB8888, (SDL_COPY_MODULATE_MASK), SDL_CPU_ANY, SDL_Blit_XRGB8888_ARGB8888_Modulate },
    { SDL_PIXELFORMAT_XRGB8888, SDL_PIXELFORMAT_ARGB8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_XRGB8888_ARGB8888_Modulate_Scale },
    { SDL_PIXELFORMAT_XRGB8888, SDL_PIXELFORMAT_ARGB8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_BLEND_MASK), SDL_CPU_ANY, SDL_Blit_XRGB8888_ARGB8888_Modulate_Blend },
    { SDL_PIXELFORMAT_XRGB8888, SDL_PIXELFORMAT_ARGB8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_BLEND_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_XRGB8888_ARGB8888_Modulate_Blend_Scale },
    { SDL_PIXELFORMAT_XRGB8888, SDL_PIXELFORMAT_ABGR8888, (SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_XRGB8888_ABGR8888_Scale },
    { SDL_PIXELFORMAT_XRGB8888, SDL_PIXELFORMAT_ABGR8888, (SDL_COPY_BLEND_MASK), SDL_CPU_ANY, SDL_Blit_XRGB8888_ABGR8888_Blend },
    { SDL_PIXELFORMAT_XRGB8888, SDL_PIXELFORMAT_ABGR8888, (SDL_COPY_BLEND_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_XRGB8888_ABGR8888_Blend_Scale },
    { SDL_PIXELFORMAT_XRGB8888, SDL_PIXELFORMAT_ABGR8888, (SDL_COPY_MODULATE_MASK), SDL_CPU_ANY, SDL_Blit_XRGB8888_ABGR8888_Modulate },
    { SDL_PIXELFORMAT_XRGB8888, SDL_PIXELFORMAT_ABGR8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_XRGB8888_ABGR8888_Modulate_Scale },
    { SDL_PIXELFORMAT_XRGB8888, SDL_PIXELFORMAT_ABGR8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_BLEND_MASK), SDL_CPU_ANY, SDL_Blit_XRGB8888_ABGR8888_Modulate_Blend },
    { SDL_PIXELFORMAT_XRGB8888, SDL_PIXELFORMAT_ABGR8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_BLEND_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_XRGB8888_ABGR8888_Modulate_Blend_Scale },
    { SDL_PIXELFORMAT_XBGR8888, SDL_PIXELFORMAT_XRGB8888, (SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_XBGR8888_XRGB8888_Scale },
    { SDL_PIXELFORMAT_XBGR8888, SDL_PIXELFORMAT_XRGB8888, (SDL_COPY_BLEND_MASK), SDL_CPU_ANY, SDL_Blit_XBGR8888_XRGB8888_Blend },
    { SDL_PIXELFORMAT_XBGR8888, SDL_PIXELFORMAT_XRGB8888, (SDL_COPY_BLEND_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_XBGR8888_XRGB8888_Blend_Scale },
    { SDL_PIXELFORMAT_XBGR8888, SDL_PIXELFORMAT_XRGB8888, (SDL_COPY_MODULATE_MASK), SDL_CPU_ANY, SDL_Blit_XBGR8888_XRGB8888_Modulate },
    { SDL_PIXELFORMAT_XBGR8888, SDL_PIXELFORMAT_XRGB8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_XBGR8888_XRGB8888_Modulate_Scale },
    { SDL_PIXELFORMAT_XBGR8888, SDL_PIXELFORMAT_XRGB8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_BLEND_MASK), SDL_CPU_ANY, SDL_Blit_XBGR8888_XRGB8888_Modulate_Blend },
    { SDL_PIXELFORMAT_XBGR8888, SDL_PIXELFORMAT_XRGB8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_BLEND_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_XBGR8888_XRGB8888_Modulate_Blend_Scale },
    { SDL_PIXELFORMAT_XBGR8888, SDL_PIXELFORMAT_XBGR8888, (SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_XBGR8888_XBGR8888_Scale },
    { SDL_PIXELFORMAT_XBGR8888, SDL_PIXELFORMAT_XBGR8888, (SDL_COPY_BLEND_MASK), SDL_CPU_ANY, SDL_Blit_XBGR8888_XBGR8888_Blend },
    { SDL_PIXELFORMAT_XBGR8888, SDL_PIXELFORMAT_XBGR8888, (SDL_COPY_BLEND_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_XBGR8888_XBGR8888_Blend_Scale },
    { SDL_PIXELFORMAT_XBGR8888, SDL_PIXELFORMAT_XBGR8888, (SDL_COPY_MODULATE_MASK), SDL_CPU_ANY, SDL_Blit_XBGR8888_XBGR8888_Modulate },
    { SDL_PIXELFORMAT_XBGR8888, SDL_PIXELFORMAT_XBGR8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_XBGR8888_XBGR8888_Modulate_Scale },
    { SDL_PIXELFORMAT_XBGR8888, SDL_PIXELFORMAT_XBGR8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_BLEND_MASK), SDL_CPU_ANY, SDL_Blit_XBGR8888_XBGR8888_Modulate_Blend },
    { SDL_PIXELFORMAT_XBGR8888, SDL_PIXELFORMAT_XBGR8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_BLEND_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_XBGR8888_XBGR8888_Modulate_Blend_Scale },
    { SDL_PIXELFORMAT_XBGR8888, SDL_PIXELFORMAT_ARGB8888, (SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_XBGR8888_ARGB8888_Scale },
    { SDL_PIXELFORMAT_XBGR8888, SDL_PIXELFORMAT_ARGB8888, (SDL_COPY_BLEND_MASK), SDL_CPU_ANY, SDL_Blit_XBGR8888_ARGB8888_Blend },
    { SDL_PIXELFORMAT_XBGR8888, SDL_PIXELFORMAT_ARGB8888, (SDL_COPY_BLEND_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_XBGR8888_ARGB8888_Blend_Scale },
    { SDL_PIXELFORMAT_XBGR8888, SDL_PIXELFORMAT_ARGB8888, (SDL_COPY_MODULATE_MASK), SDL_CPU_ANY, SDL_Blit_XBGR8888_ARGB8888_Modulate },
    { SDL_PIXELFORMAT_XBGR8888, SDL_PIXELFORMAT_ARGB8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_XBGR8888_ARGB8888_Modulate_Scale },
    { SDL_PIXELFORMAT_XBGR8888, SDL_PIXELFORMAT_ARGB8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_BLEND_MASK), SDL_CPU_ANY, SDL_Blit_XBGR8888_ARGB8888_Modulate_Blend },
    { SDL_PIXELFORMAT_XBGR8888, SDL_PIXELFORMAT_ARGB8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_BLEND_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_XBGR8888_ARGB8888_Modulate_Blend_Scale },
    { SDL_PIXELFORMAT_XBGR8888, SDL_PIXELFORMAT_ABGR8888, (SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_XBGR8888_ABGR8888_Scale },
    { SDL_PIXELFORMAT_XBGR8888, SDL_PIXELFORMAT_ABGR8888, (SDL_COPY_BLEND_MASK), SDL_CPU_ANY, SDL_Blit_XBGR8888_ABGR8888_Blend },
    { SDL_PIXELFORMAT_XBGR8888, SDL_PIXELFORMAT_ABGR8888, (SDL_COPY_BLEND_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_XBGR8888_ABGR8888_Blend_Scale },
    { SDL_PIXELFORMAT_XBGR8888, SDL_PIXELFORMAT_ABGR8888, (SDL_COPY_MODULATE_MASK), SDL_CPU_ANY, SDL_Blit_XBGR8888_ABGR8888_Modulate },
    { SDL_PIXELFORMAT_XBGR8888, SDL_PIXELFORMAT_ABGR8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_XBGR8888_ABGR8888_Modulate_Scale },
    { SDL_PIXELFORMAT_XBGR8888, SDL_PIXELFORMAT_ABGR8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_BLEND_MASK), SDL_CPU_ANY, SDL_Blit_XBGR8888_ABGR8888_Modulate_Blend },
    { SDL_PIXELFORMAT_XBGR8888, SDL_PIXELFORMAT_ABGR8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_BLEND_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_XBGR8888_ABGR8888_Modulate_Blend_Scale },
    { SDL_PIXELFORMAT_ARGB8888, SDL_PIXELFORMAT_XRGB8888, (SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_ARGB8888_XRGB8888_Scale },
    { SDL_PIXELFORMAT_ARGB8888, SDL_PIXELFORMAT_XRGB8888, (SDL_COPY_BLEND_MASK), SDL_CPU_ANY, SDL_Blit_ARGB8888_XRGB8888_Blend },
    { SDL_PIXELFORMAT_ARGB8888, SDL_PIXELFORMAT_XRGB8888, (SDL_COPY_BLEND_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_ARGB8888_XRGB8888_Blend_Scale },
    { SDL_PIXELFORMAT_ARGB8888, SDL_PIXELFORMAT_XRGB8888, (SDL_COPY_MODULATE_MASK), SDL_CPU_ANY, SDL_Blit_ARGB8888_XRGB8888_Modulate },
    { SDL_PIXELFORMAT_ARGB8888, SDL_PIXELFORMAT_XRGB8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_ARGB8888_XRGB8888_Modulate_Scale },
    { SDL_PIXELFORMAT_ARGB8888, SDL_PIXELFORMAT_XRGB8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_BLEND_MASK), SDL_CPU_ANY, SDL_Blit_ARGB8888_XRGB8888_Modulate_Blend },
    { SDL_PIXELFORMAT_ARGB8888, SDL_PIXELFORMAT_XRGB8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_BLEND_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_ARGB8888_XRGB8888_Modulate_Blend_Scale },
    { SDL_PIXELFORMAT_ARGB8888, SDL_PIXELFORMAT_XBGR8888, (SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_ARGB8888_XBGR8888_Scale },
    { SDL_PIXELFORMAT_ARGB8888, SDL_PIXELFORMAT_XBGR8888, (SDL_COPY_BLEND_MASK), SDL_CPU_ANY, SDL_Blit_ARGB8888_XBGR8888_Blend },
    { SDL_PIXELFORMAT_ARGB8888, SDL_PIXELFORMAT_XBGR8888, (SDL_COPY_BLEND_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_ARGB8888_XBGR8888_Blend_Scale },
    { SDL_PIXELFORMAT_ARGB8888, SDL_PIXELFORMAT_XBGR8888, (SDL_COPY_MODULATE_MASK), SDL_CPU_ANY, SDL_Blit_ARGB8888_XBGR8888_Modulate },
    { SDL_PIXELFORMAT_ARGB8888, SDL_PIXELFORMAT_XBGR8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_ARGB8888_XBGR8888_Modulate_Scale },
    { SDL_PIXELFORMAT_ARGB8888, SDL_PIXELFORMAT_XBGR8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_BLEND_MASK), SDL_CPU_ANY, SDL_Blit_ARGB8888_XBGR8888_Modulate_Blend },
    { SDL_PIXELFORMAT_ARGB8888, SDL_PIXELFORMAT_XBGR8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_BLEND_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_ARGB8888_XBGR8888_Modulate_Blend_Scale },
    { SDL_PIXELFORMAT_ARGB8888, SDL_PIXELFORMAT_ARGB8888, (SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_ARGB8888_ARGB8888_Scale },
    { SDL_PIXELFORMAT_ARGB8888, SDL_PIXELFORMAT_ARGB8888, (SDL_COPY_BLEND_MASK), SDL_CPU_ANY, SDL_Blit_ARGB8888_ARGB8888_Blend },
    { SDL_PIXELFORMAT_ARGB8888, SDL_PIXELFORMAT_ARGB8888, (SDL_COPY_BLEND_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_ARGB8888_ARGB8888_Blend_Scale },
    { SDL_PIXELFORMAT_ARGB8888, SDL_PIXELFORMAT_ARGB8888, (SDL_COPY_MODULATE_MASK), SDL_CPU_ANY, SDL_Blit_ARGB8888_ARGB8888_Modulate },
    { SDL_PIXELFORMAT_ARGB8888, SDL_PIXELFORMAT_ARGB8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_ARGB8888_ARGB8888_Modulate_Scale },
    { SDL_PIXELFORMAT_ARGB8888, SDL_PIXELFORMAT_ARGB8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_BLEND_MASK), SDL_CPU_ANY, SDL_Blit_ARGB8888_ARGB8888_Modulate_Blend },
    { SDL_PIXELFORMAT_ARGB8888, SDL_PIXELFORMAT_ARGB8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_BLEND_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_ARGB8888_ARGB8888_Modulate_Blend_Scale },
    { SDL_PIXELFORMAT_ARGB8888, SDL_PIXELFORMAT_ABGR8888, (SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_ARGB8888_ABGR8888_Scale },
    { SDL_PIXELFORMAT_ARGB8888, SDL_PIXELFORMAT_ABGR8888, (SDL_COPY_BLEND_MASK), SDL_CPU_ANY, SDL_Blit_ARGB8888_ABGR8888_Blend },
    { SDL_PIXELFORMAT_ARGB8888, SDL_PIXELFORMAT_ABGR8888, (SDL_COPY_BLEND_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_ARGB8888_ABGR8888_Blend_Scale },
    { SDL_PIXELFORMAT_ARGB8888, SDL_PIXELFORMAT_ABGR8888, (SDL_COPY_MODULATE_MASK), SDL_CPU_ANY, SDL_Blit_ARGB8888_ABGR8888_Modulate },
    { SDL_PIXELFORMAT_ARGB8888, SDL_PIXELFORMAT_ABGR8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_ARGB8888_ABGR8888_Modulate_Scale },
    { SDL_PIXELFORMAT_ARGB8888, SDL_PIXELFORMAT_ABGR8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_BLEND_MASK), SDL_CPU_ANY, SDL_Blit_ARGB8888_ABGR8888_Modulate_Blend },
    { SDL_PIXELFORMAT_ARGB8888, SDL_PIXELFORMAT_ABGR8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_BLEND_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_ARGB8888_ABGR8888_Modulate_Blend_Scale },
    { SDL_PIXELFORMAT_RGBA8888, SDL_PIXELFORMAT_XRGB8888, (SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_RGBA8888_XRGB8888_Scale },
    { SDL_PIXELFORMAT_RGBA8888, SDL_PIXELFORMAT_XRGB8888, (SDL_COPY_BLEND_MASK), SDL_CPU_ANY, SDL_Blit_RGBA8888_XRGB8888_Blend },
    { SDL_PIXELFORMAT_RGBA8888, SDL_PIXELFORMAT_XRGB8888, (SDL_COPY_BLEND_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_RGBA8888_XRGB8888_Blend_Scale },
    { SDL_PIXELFORMAT_RGBA8888, SDL_PIXELFORMAT_XRGB8888, (SDL_COPY_MODULATE_MASK), SDL_CPU_ANY, SDL_Blit_RGBA8888_XRGB8888_Modulate },
    { SDL_PIXELFORMAT_RGBA8888, SDL_PIXELFORMAT_XRGB8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_RGBA8888_XRGB8888_Modulate_Scale },
    { SDL_PIXELFORMAT_RGBA8888, SDL_PIXELFORMAT_XRGB8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_BLEND_MASK), SDL_CPU_ANY, SDL_Blit_RGBA8888_XRGB8888_Modulate_Blend },
    { SDL_PIXELFORMAT_RGBA8888, SDL_PIXELFORMAT_XRGB8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_BLEND_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_RGBA8888_XRGB8888_Modulate_Blend_Scale },
    { SDL_PIXELFORMAT_RGBA8888, SDL_PIXELFORMAT_XBGR8888, (SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_RGBA8888_XBGR8888_Scale },
    { SDL_PIXELFORMAT_RGBA8888, SDL_PIXELFORMAT_XBGR8888, (SDL_COPY_BLEND_MASK), SDL_CPU_ANY, SDL_Blit_RGBA8888_XBGR8888_Blend },
    { SDL_PIXELFORMAT_RGBA8888, SDL_PIXELFORMAT_XBGR8888, (SDL_COPY_BLEND_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_RGBA8888_XBGR8888_Blend_Scale },
    { SDL_PIXELFORMAT_RGBA8888, SDL_PIXELFORMAT_XBGR8888, (SDL_COPY_MODULATE_MASK), SDL_CPU_ANY, SDL_Blit_RGBA8888_XBGR8888_Modulate },
    { SDL_PIXELFORMAT_RGBA8888, SDL_PIXELFORMAT_XBGR8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_RGBA8888_XBGR8888_Modulate_Scale },
    { SDL_PIXELFORMAT_RGBA8888, SDL_PIXELFORMAT_XBGR8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_BLEND_MASK), SDL_CPU_ANY, SDL_Blit_RGBA8888_XBGR8888_Modulate_Blend },
    { SDL_PIXELFORMAT_RGBA8888, SDL_PIXELFORMAT_XBGR8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_BLEND_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_RGBA8888_XBGR8888_Modulate_Blend_Scale },
    { SDL_PIXELFORMAT_RGBA8888, SDL_PIXELFORMAT_ARGB8888, (SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_RGBA8888_ARGB8888_Scale },
    { SDL_PIXELFORMAT_RGBA8888, SDL_PIXELFORMAT_ARGB8888, (SDL_COPY_BLEND_MASK), SDL_CPU_ANY, SDL_Blit_RGBA8888_ARGB8888_Blend },
    { SDL_PIXELFORMAT_RGBA8888, SDL_PIXELFORMAT_ARGB8888, (SDL_COPY_BLEND_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_RGBA8888_ARGB8888_Blend_Scale },
    { SDL_PIXELFORMAT_RGBA8888, SDL_PIXELFORMAT_ARGB8888, (SDL_COPY_MODULATE_MASK), SDL_CPU_ANY, SDL_Blit_RGBA8888_ARGB8888_Modulate },
    { SDL_PIXELFORMAT_RGBA8888, SDL_PIXELFORMAT_ARGB8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_RGBA8888_ARGB8888_Modulate_Scale },
    { SDL_PIXELFORMAT_RGBA8888, SDL_PIXELFORMAT_ARGB8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_BLEND_MASK), SDL_CPU_ANY, SDL_Blit_RGBA8888_ARGB8888_Modulate_Blend },
    { SDL_PIXELFORMAT_RGBA8888, SDL_PIXELFORMAT_ARGB8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_BLEND_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_RGBA8888_ARGB8888_Modulate_Blend_Scale },
    { SDL_PIXELFORMAT_RGBA8888, SDL_PIXELFORMAT_ABGR8888, (SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_RGBA8888_ABGR8888_Scale },
    { SDL_PIXELFORMAT_RGBA8888, SDL_PIXELFORMAT_ABGR8888, (SDL_COPY_BLEND_MASK), SDL_CPU_ANY, SDL_Blit_RGBA8888_ABGR8888_Blend },
    { SDL_PIXELFORMAT_RGBA8888, SDL_PIXELFORMAT_ABGR8888, (SDL_COPY_BLEND_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_RGBA8888_ABGR8888_Blend_Scale },
    { SDL_PIXELFORMAT_RGBA8888, SDL_PIXELFORMAT_ABGR8888, (SDL_COPY_MODULATE_MASK), SDL_CPU_ANY, SDL_Blit_RGBA8888_ABGR8888_Modulate },
    { SDL_PIXELFORMAT_RGBA8888, SDL_PIXELFORMAT_ABGR8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_RGBA8888_ABGR8888_Modulate_Scale },
    { SDL_PIXELFORMAT_RGBA8888, SDL_PIXELFORMAT_ABGR8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_BLEND_MASK), SDL_CPU_ANY, SDL_Blit_RGBA8888_ABGR8888_Modulate_Blend },
    { SDL_PIXELFORMAT_RGBA8888, SDL_PIXELFORMAT_ABGR8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_BLEND_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_RGBA8888_ABGR8888_Modulate_Blend_Scale },
    { SDL_PIXELFORMAT_ABGR8888, SDL_PIXELFORMAT_XRGB8888, (SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_ABGR8888_XRGB8888_Scale },
    { SDL_PIXELFORMAT_ABGR8888, SDL_PIXELFORMAT_XRGB8888, (SDL_COPY_BLEND_MASK), SDL_CPU_ANY, SDL_Blit_ABGR8888_XRGB8888_Blend },
    { SDL_PIXELFORMAT_ABGR8888, SDL_PIXELFORMAT_XRGB8888, (SDL_COPY_BLEND_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_ABGR8888_XRGB8888_Blend_Scale },
    { SDL_PIXELFORMAT_ABGR8888, SDL_PIXELFORMAT_XRGB8888, (SDL_COPY_MODULATE_MASK), SDL_CPU_ANY, SDL_Blit_ABGR8888_XRGB8888_Modulate },
    { SDL_PIXELFORMAT_ABGR8888, SDL_PIXELFORMAT_XRGB8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_ABGR8888_XRGB8888_Modulate_Scale },
    { SDL_PIXELFORMAT_ABGR8888, SDL_PIXELFORMAT_XRGB8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_BLEND_MASK), SDL_CPU_ANY, SDL_Blit_ABGR8888_XRGB8888_Modulate_Blend },
    { SDL_PIXELFORMAT_ABGR8888, SDL_PIXELFORMAT_XRGB8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_BLEND_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_ABGR8888_XRGB8888_Modulate_Blend_Scale },
    { SDL_PIXELFORMAT_ABGR8888, SDL_PIXELFORMAT_XBGR8888, (SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_ABGR8888_XBGR8888_Scale },
    { SDL_PIXELFORMAT_ABGR8888, SDL_PIXELFORMAT_XBGR8888, (SDL_COPY_BLEND_MASK), SDL_CPU_ANY, SDL_Blit_ABGR8888_XBGR8888_Blend },
    { SDL_PIXELFORMAT_ABGR8888, SDL_PIXELFORMAT_XBGR8888, (SDL_COPY_BLEND_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_ABGR8888_XBGR8888_Blend_Scale },
    { SDL_PIXELFORMAT_ABGR8888, SDL_PIXELFORMAT_XBGR8888, (SDL_COPY_MODULATE_MASK), SDL_CPU_ANY, SDL_Blit_ABGR8888_XBGR8888_Modulate },
    { SDL_PIXELFORMAT_ABGR8888, SDL_PIXELFORMAT_XBGR8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_ABGR8888_XBGR8888_Modulate_Scale },
    { SDL_PIXELFORMAT_ABGR8888, SDL_PIXELFORMAT_XBGR8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_BLEND_MASK), SDL_CPU_ANY, SDL_Blit_ABGR8888_XBGR8888_Modulate_Blend },
    { SDL_PIXELFORMAT_ABGR8888, SDL_PIXELFORMAT_XBGR8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_BLEND_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_ABGR8888_XBGR8888_Modulate_Blend_Scale },
    { SDL_PIXELFORMAT_ABGR8888, SDL_PIXELFORMAT_ARGB8888, (SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_ABGR8888_ARGB8888_Scale },
    { SDL_PIXELFORMAT_ABGR8888, SDL_PIXELFORMAT_ARGB8888, (SDL_COPY_BLEND_MASK), SDL_CPU_ANY, SDL_Blit_ABGR8888_ARGB8888_Blend },
    { SDL_PIXELFORMAT_ABGR8888, SDL_PIXELFORMAT_ARGB8888, (SDL_COPY_BLEND_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_ABGR8888_ARGB8888_Blend_Scale },
    { SDL_PIXELFORMAT_ABGR8888, SDL_PIXELFORMAT_ARGB8888, (SDL_COPY_MODULATE_MASK), SDL_CPU_ANY, SDL_Blit_ABGR8888_ARGB8888_Modulate },
    { SDL_PIXELFORMAT_ABGR8888, SDL_PIXELFORMAT_ARGB8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_ABGR8888_ARGB8888_Modulate_Scale },
    { SDL_PIXELFORMAT_ABGR8888, SDL_PIXELFORMAT_ARGB8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_BLEND_MASK), SDL_CPU_ANY, SDL_Blit_ABGR8888_ARGB8888_Modulate_Blend },
    { SDL_PIXELFORMAT_ABGR8888, SDL_PIXELFORMAT_ARGB8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_BLEND_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_ABGR8888_ARGB8888_Modulate_Blend_Scale },
    { SDL_PIXELFORMAT_ABGR8888, SDL_PIXELFORMAT_ABGR8888, (SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_ABGR8888_ABGR8888_Scale },
    { SDL_PIXELFORMAT_ABGR8888, SDL_PIXELFORMAT_ABGR8888, (SDL_COPY_BLEND_MASK), SDL_CPU_ANY, SDL_Blit_ABGR8888_ABGR8888_Blend },
    { SDL_PIXELFORMAT_ABGR8888, SDL_PIXELFORMAT_ABGR8888, (SDL_COPY_BLEND_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_ABGR8888_ABGR8888_Blend_Scale },
    { SDL_PIXELFORMAT_ABGR8888, SDL_PIXELFORMAT_ABGR8888, (SDL_COPY_MODULATE_MASK), SDL_CPU_ANY, SDL_Blit_ABGR8888_ABGR8888_Modulate },
    { SDL_PIXELFORMAT_ABGR8888, SDL_PIXELFORMAT_ABGR8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_ABGR8888_ABGR8888_Modulate_Scale },
    { SDL_PIXELFORMAT_ABGR8888, SDL_PIXELFORMAT_ABGR8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_BLEND_MASK), SDL_CPU_ANY, SDL_Blit_ABGR8888_ABGR8888_Modulate_Blend },
    { SDL_PIXELFORMAT_ABGR8888, SDL_PIXELFORMAT_ABGR8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_BLEND_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_ABGR8888_ABGR8888_Modulate_Blend_Scale },
    { SDL_PIXELFORMAT_BGRA8888, SDL_PIXELFORMAT_XRGB8888, (SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_BGRA8888_XRGB8888_Scale },
    { SDL_PIXELFORMAT_BGRA8888, SDL_PIXELFORMAT_XRGB8888, (SDL_COPY_BLEND_MASK), SDL_CPU_ANY, SDL_Blit_BGRA8888_XRGB8888_Blend },
    { SDL_PIXELFORMAT_BGRA8888, SDL_PIXELFORMAT_XRGB8888, (SDL_COPY_BLEND_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_BGRA8888_XRGB8888_Blend_Scale },
    { SDL_PIXELFORMAT_BGRA8888, SDL_PIXELFORMAT_XRGB8888, (SDL_COPY_MODULATE_MASK), SDL_CPU_ANY, SDL_Blit_BGRA8888_XRGB8888_Modulate },
    { SDL_PIXELFORMAT_BGRA8888, SDL_PIXELFORMAT_XRGB8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_BGRA8888_XRGB8888_Modulate_Scale },
    { SDL_PIXELFORMAT_BGRA8888, SDL_PIXELFORMAT_XRGB8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_BLEND_MASK), SDL_CPU_ANY, SDL_Blit_BGRA8888_XRGB8888_Modulate_Blend },
    { SDL_PIXELFORMAT_BGRA8888, SDL_PIXELFORMAT_XRGB8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_BLEND_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_BGRA8888_XRGB8888_Modulate_Blend_Scale },
    { SDL_PIXELFORMAT_BGRA8888, SDL_PIXELFORMAT_XBGR8888, (SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_BGRA8888_XBGR8888_Scale },
    { SDL_PIXELFORMAT_BGRA8888, SDL_PIXELFORMAT_XBGR8888, (SDL_COPY_BLEND_MASK), SDL_CPU_ANY, SDL_Blit_BGRA8888_XBGR8888_Blend },
    { SDL_PIXELFORMAT_BGRA8888, SDL_PIXELFORMAT_XBGR8888, (SDL_COPY_BLEND_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_BGRA8888_XBGR8888_Blend_Scale },
    { SDL_PIXELFORMAT_BGRA8888, SDL_PIXELFORMAT_XBGR8888, (SDL_COPY_MODULATE_MASK), SDL_CPU_ANY, SDL_Blit_BGRA8888_XBGR8888_Modulate },
    { SDL_PIXELFORMAT_BGRA8888, SDL_PIXELFORMAT_XBGR8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_BGRA8888_XBGR8888_Modulate_Scale },
    { SDL_PIXELFORMAT_BGRA8888, SDL_PIXELFORMAT_XBGR8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_BLEND_MASK), SDL_CPU_ANY, SDL_Blit_BGRA8888_XBGR8888_Modulate_Blend },
    { SDL_PIXELFORMAT_BGRA8888, SDL_PIXELFORMAT_XBGR8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_BLEND_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_BGRA8888_XBGR8888_Modulate_Blend_Scale },
    { SDL_PIXELFORMAT_BGRA8888, SDL_PIXELFORMAT_ARGB8888, (SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_BGRA8888_ARGB8888_Scale },
    { SDL_PIXELFORMAT_BGRA8888, SDL_PIXELFORMAT_ARGB8888, (SDL_COPY_BLEND_MASK), SDL_CPU_ANY, SDL_Blit_BGRA8888_ARGB8888_Blend },
    { SDL_PIXELFORMAT_BGRA8888, SDL_PIXELFORMAT_ARGB8888, (SDL_COPY_BLEND_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_BGRA8888_ARGB8888_Blend_Scale },
    { SDL_PIXELFORMAT_BGRA8888, SDL_PIXELFORMAT_ARGB8888, (SDL_COPY_MODULATE_MASK), SDL_CPU_ANY, SDL_Blit_BGRA8888_ARGB8888_Modulate },
    { SDL_PIXELFORMAT_BGRA8888, SDL_PIXELFORMAT_ARGB8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_BGRA8888_ARGB8888_Modulate_Scale },
    { SDL_PIXELFORMAT_BGRA8888, SDL_PIXELFORMAT_ARGB8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_BLEND_MASK), SDL_CPU_ANY, SDL_Blit_BGRA8888_ARGB8888_Modulate_Blend },
    { SDL_PIXELFORMAT_BGRA8888, SDL_PIXELFORMAT_ARGB8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_BLEND_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_BGRA8888_ARGB8888_Modulate_Blend_Scale },
    { SDL_PIXELFORMAT_BGRA8888, SDL_PIXELFORMAT_ABGR8888, (SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_BGRA8888_ABGR8888_Scale },
    { SDL_PIXELFORMAT_BGRA8888, SDL_PIXELFORMAT_ABGR8888, (SDL_COPY_BLEND_MASK), SDL_CPU_ANY, SDL_Blit_BGRA8888_ABGR8888_Blend },
    { SDL_PIXELFORMAT_BGRA8888, SDL_PIXELFORMAT_ABGR8888, (SDL_COPY_BLEND_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_BGRA8888_ABGR8888_Blend_Scale },
    { SDL_PIXELFORMAT_BGRA8888, SDL_PIXELFORMAT_ABGR8888, (SDL_COPY_MODULATE_MASK), SDL_CPU_ANY, SDL_Blit_BGRA8888_ABGR8888_Modulate },
    { SDL_PIXELFORMAT_BGRA8888, SDL_PIXELFORMAT_ABGR8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_BGRA8888_ABGR8888_Modulate_Scale },
    { SDL_PIXELFORMAT_BGRA8888, SDL_PIXELFORMAT_ABGR8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_BLEND_MASK), SDL_CPU_ANY, SDL_Blit_BGRA8888_ABGR8888_Modulate_Blend },
    { SDL_PIXELFORMAT_BGRA8888, SDL_PIXELFORMAT_ABGR8888, (SDL_COPY_MODULATE_MASK | SDL_COPY_BLEND_MASK | SDL_COPY_NEAREST), SDL_CPU_ANY, SDL_Blit_BGRA8888_ABGR8888_Modulate_Blend_Scale },
    { SDL_PIXELFORMAT_UNKNOWN, SDL_PIXELFORMAT_UNKNOWN, 0, 0, NULL }
};

/* *INDENT-ON* */ // clang-format on

#endif // SDL_HAVE_BLIT_AUTO

