#!/usr/bin/perl -w
#
# Theme data file
# This file contains details of themes. This is used by the scripts to generate
# theme documentaion files.
#
# Licensed under the GPL 
# © 2002 - 2009 Mark Howard <mh@tildemh.com>
#

package debian::themedata;

@themedata::installed = (
	\%Urbicande, 
	\%OutlineHot,
	\%OutlineAsh,
	\%OutlineBeach,
	\%OutlineCoal,
	\%OutlineCold,
	\%OutlineFruity,
	\%OutlineWinter,
	\%keramikgyellow,
	);

@themedata::rejectedlicense = (
);

@themedata::rejected = (
	{'source' => 'themes.freshmeat.net', 'name' => 'Amadeus', 'reason' => 'doesn\'t work with latest metacity.'},
	{'source' => 'sunshineinabag.co.uk', 'name' => 'MetalXP', 'reason' => 'doesn\'t work with latest metacity.'},
	{'source' => 'sunshineinabag.co.uk', 'name' => 'LunaXP', 'reason' => 'doesn\'t work with latest metacity.'},
	{'source' => 'sunshineinabag.co.uk', 'name' => 'keramic-metacity', 'reason' => 'doesn\'t work with latest metacity.'},
	{'source' => 'sunshineinabag.co.uk', 'name' => 'Amadeus', 'reason' => 'doesn\'t work with latest metacity.'},
	{'source' => 'sunshineinabag.co.uk', 'name' => 'metamile-marker', 'reason' => 'doesn\'t work with latest metacity.'},
	{'source' => 'http://www.themedepot.org/itemdetail.php4?id=51', 'name' => 'fishing the sky', 'reason' => 'border-only window not implemented'},
	{'source' => 'http://www.themedepot.org/itemdetail.php4?id=12', 'name' => 'adept', 'reason' => 'Not designed for latest metacity'},
);
	
%Urbicande = (
    'name' => "Urbicande",
    "source"	=> "http://themes.freshmeat.net/projects/urbicande-metacity/",
    "version"	=> "1.1",
    "description"	=> 'A theme inspired by "Les Cités Obscures" (The '
    .'Obscure Cities), graphic novels by François Schuiten and Benoît '
    .'Peeters. It uses some ideas from the novels\' official Web site. '
    .'It is a port of the IceWM version. ',
    "license"	=> "GPL",
    'date' => '2002',
    "author" => "Oleastre",
    'filename' => 'urbicande-metacity-default-1.1.tar.gz',
    'tweak' => 0,
    );

%Outline = (
    'source' => "http://themes.freshmeat.net/projects/outline/",
    'description' => 'A simple theme that uses alpha composition for rendering '
    .'buttons and a 1-pixel wide rectangle for window borders. The branches of '
    .'this project include several versions of the same theme.',
    'license' => 'GPL',
    'date' => '2002',
    'author' => 'ueluei <ueluei@telefonica.net>',
    'filename' => 'Outline.tar.gz',
    'tweak' => 0,
    );
%OutlineHot = (%Outline,	'name' => 'OutlineHot', 	'version' => '1.0');
%OutlineAsh = (%Outline,	'name' => 'OutlineAsh', 	'version' => '1.0');
%OutlineBeach = (%Outline,	'name' => 'OutlineBeach', 	'version' => '1.0');
%OutlineCoal = (%Outline,	'name' => 'OutlineCoal', 	'version' => '1.0');
%OutlineCold = (%Outline,	'name' => 'OutlineCold', 	'version' => '1.0');
%OutlineFruity = (%Outline,	'name' => 'OutlineFruity', 	'version' => '1.0');
%OutlineWinter = (%Outline,	'name' => 'OutlineWinter', 	'version' => '1.0');


%keramikgyellow = (
    'name' => 'keramik-Gyellow',
    'version' => 'not versioned - downloaded 2002/10 ',
    'source' =>'http://www.lucidus.uklinux.net/index.php?author=Giovanni%20A.%20Derks',
    'license' => 'GPL',
    'date' => '2002',
    'author' => 'Giovanni A. Derks <virtualdk@inwind.it>',
    'description' => 'This is keramik-Gyellow, a theme for the Metacity window '
    .'manager.  It is basically a  edited version of the port realized by '
    .'Shane Butler <shane_b@users.sourceforge.net> of the kermik theme by '
    .'Malte Starostik <malte@kde.org> and Fredrik Hoglund <fredrik@kde.org>. '
    .'See http://www.kde-look.org/content/show.php?content=1961 for details.',
    'filename' => 'keramik-Gyellow.tar.gz',
    'tweak' => 0,
    );

%mcblue = (
    'name' => 'mcblue',
    'version' => '1.0',
    'source' =>'http://themes.freshmeat.net/projects/mcblue/',
    'license' => 'GPL',
    'date' => '2002',
    'author' => 'Tiger_66_Y2k <kyled@blueriver.net>',
    'description' => 'mcblue is a clean theme based on keramik. It was made to go with the gnububble theme for GTK2.',
    'filename' => 'mcblue-default-1.0.tar.gz',
    'tweak' => 0,
    );
push @themedata::installed, \%mcblue;

%quietpurple = (
    'name' => 'quiet-purple',
    'version' => '20020909',
    'source' =>'http://www.themedepot.org/itemdetail.php4?id=197',
    'license' => 'GPL',
    'date' => '2002',
    'author' => 'Giovanni A. Derks <virtualdk@inwind.it>',
    'description' => 'Thought to be relaxing and intuitive... My target was to have a smooth and "eye-relaxing" theme that was intuitive to use and also a bit original. So I\'ve used prelight for unfocused buttons (try to move the mouse over buttons of a unfocused window), I\'ve designed the restore (from maximized state) button as a toggle button and I\'ve not put the maximize, minimize and close symbols over the unfocused buttons.',
    'filename' => '197-quiet-purple.tar.gz',
    'tweak' => 0,
    );
push @themedata::installed, \%quietpurple;


%brushedmetal = (
    'name' => 'BrushedMetal',
    'version' => '20021105',
    'source' =>'http://art.gnome.org/show_theme.php?themeID=206&category=metacity',
    'license' => 'GPL',
    'date' => '2002',
    'author' => 'Andrew Bradford <ajbradford@comcast.net>',
    'description' => 'This is a port of the Sawfish theme Brushed Metal. ',
    'filename' => 'MCity-BrushedMetal.tar.gz',
    'tweak' => 0,
    );
push @themedata::installed, \%brushedmetal;

%alloy = (
    'name' => 'Alloy',
    'version' => '1.0',
    'source' =>'http://themes.freshmeat.net/projects/alloy/',
    'license' => 'GPL',
    'date' => '2002',
    'author' => 'Ueluei <ueluei@telefonica.net>',
    'description' => 'Alloy is a metallic theme slightly based on the unreleased KDE style shown in Everaldo\'s screenshot of the Crystal icons.',
    'filename' => 'alloy-default-1.0.tar.gz',
    'tweak' => 0,
    );
push @themedata::installed, \%alloy;

%crowberry = (
    'name' => 'HeliX-Sweetpill-Crowberry',
    'version' => '2002-11-05',
    'source' =>'http://themes.freshmeat.net/projects/mcityhelixsweetpillcrowberry/',
    'license' => 'GPL',
    'date' => '2002',
    'author' => 'Andrew Bradford <ajbradford@comcast.net>',
    'description' => 'MCity Helix Sweetpill Crowberry is a port of the Sawfish
     theme HeliX-Sweetpill Crowberry to Metacity.',
    'filename' => 'mcityhelixsweetpillcrowberry-default.tar.gz',
    'tweak' => 0,
    );
push @themedata::installed, \%crowberry;

%watercolor = (
    'name' => 'Watercolor',
    'version' => '1.2.1',
    'source' =>'http://www.themedepot.org',
    'license' => 'GPL',
    'author' => 'Norman Jonas <normanjonas@web.de>',
    'date' => '2003',
    'description' => 'This theme is a port of the Sawfish "Watercolor" theme ( done by Stefan
    Zeiger <szeiger@szeiger.de> ), that itself was inspired by the Windows
    XP build 2410 "Watercolor" look, to metacity..',
    'filename' => 'watercolor-1.2.1.tar.bz2',
    'tweak' => 0,
    );
push @themedata::installed, \%watercolor;

%Redmond = (
    'name' => 'Redmond',
    'version' => '1.0',
    'source' =>'http://www.bitdrift.org/redmond/',
    'license' => 'GPL',
    'date' => '2005',
    'author' => 'Ryan Probasco <ryan.probasco@gmail.com>',
    'description' => 'Designed to match the Redmond GTK theme. Borrowed icon drawing operations from SmoothGNOME by Link Dupont <link@subpop.net>',
    'filename' => 'MCity-Redmond.tar.gz',
    'tweak' => 0,
    );
push @themedata::installed, \%Redmond;

%Nodoka = (
    'name' => 'Nodoka',
    'version' => '0.4 beta',
    'source' =>'https://fedorahosted.org/nodoka/wiki',
    'license' => 'GPL 2',
    'date' => '2007',
    'author' => 'Martin Sourada <martin.sourada@seznam.cz> and Daniel Geiger <dgeiger_343@yahoo.com> ',
    'description' => 'This theme is designed and created by Martin Sourada <martin.sourada@seznam.cz> and Daniel Geiger <dgeiger_343@yahoo.com> with support and help from the Fedoracommunity <http://fedoraproject.org> and <http://fedoraforum.org>.',
    'filename' => 'nodoka-theme-gnome-0.3.90.tar.gz',
    'tweak' => 1,
    );
push @themedata::installed, \%Nodoka;
