// Copyright 2010-2023 The Mumble Developers. All rights reserved.
// Use of this source code is governed by a BSD-style license
// that can be found in the LICENSE file at the root of the
// Mumble source tree or at <https://www.mumble.info/LICENSE>.

#define MUMBLE_ALLOW_DEPRECATED_LEGACY_PLUGIN_API
#include "mumble_legacy_plugin.h"

#include "mumble_positional_audio_main.h"

using namespace std;

procptr_t pos0ptr, pos1ptr, pos2ptr, faceptr, topptr;
// BYTE *stateptr;

static int fetch(float *avatar_pos, float *avatar_front, float *avatar_top, float *camera_pos, float *camera_front,
				 float *camera_top, std::string &, std::wstring &) {
	char state;
	// char ccontext[128];
	bool ok;

	float face_corrector[3];
	float top_corrector[3];

	for (int i = 0; i < 3; i++)
		avatar_pos[i] = avatar_front[i] = avatar_top[i] = camera_pos[i] = camera_front[i] = camera_top[i] = 0.0f;

	ok = peekProc(0x01DEAFD9, &state, 1);
	if (!ok)
		return false;

	if (state == 1)
		return true;

	/*
	   Z-Value is increasing when heading north
				  decreasing when heading south
	   X-Value is increasing when heading east
				  decreasing when heading west
	   Y-Value is increasing when going up
				  decreasing when going down
	*/

	// Convert to left-handed coordinate system

	ok = peekProc(pos2ptr, avatar_pos, 4) &&     // X
		 peekProc(pos1ptr, avatar_pos + 1, 4) && // Y
		 peekProc(pos0ptr, avatar_pos + 2, 4) && // Z
		 peekProc(faceptr, &face_corrector, 12) && peekProc(topptr, &top_corrector, 12);

	// peekProc((BYTE *) 0x0122E0B8, ccontext, 128);

	if (!ok)
		return false;

	if (face_corrector[1] <= -0.98) {
		top_corrector[1] = -top_corrector[1];
	}
	if (face_corrector[1] >= 0.98) {
		top_corrector[1] = -top_corrector[1];
	}

	// Find north by playing on a Warfare game type - center view on the up arrow on the mini map
	avatar_front[0] = face_corrector[2];
	avatar_front[1] = face_corrector[1];
	avatar_front[2] = face_corrector[0];

	avatar_top[0] = top_corrector[2];
	avatar_top[1] = top_corrector[1];
	avatar_top[2] = top_corrector[0];

	// avatar_top[0] = top_corrector[2];
	// avatar_top[1] = top_corrector[1];

	// ccontext[127] = 0;
	// context = std::string(ccontext);

	// if (context.find(':')==string::npos)
	//	context.append(":UT3PORT");

	for (int i = 0; i < 3; i++) {
		camera_pos[i]   = avatar_pos[i];
		camera_front[i] = avatar_front[i];
		camera_top[i]   = avatar_top[i];
	}

	return true;
}

static int trylock(const std::multimap< std::wstring, unsigned long long int > &pids) {
	pos0ptr = pos1ptr = pos2ptr = faceptr = 0;

	if (!initialize(pids, L"UT3.exe", L"wrap_oal.dll"))
		return false;

	procptr_t ptraddress = pModule + 0x8A740;
	procptr_t baseptr    = peekProcPtr(ptraddress);

	pos0ptr = baseptr;
	pos1ptr = baseptr + 0x4;
	pos2ptr = baseptr + 0x8;
	faceptr = baseptr + 0x18;
	topptr  = baseptr + 0x24;

	// stateptr = pModule + 0xC4;

	float apos[3], afront[3], atop[3], cpos[3], cfront[3], ctop[3];
	std::string context;
	std::wstring identity;

	if (fetch(apos, afront, atop, cpos, cfront, ctop, context, identity)) {
		return true;
	} else {
		generic_unlock();
		return false;
	}
}

static const std::wstring longdesc() {
	return std::wstring(L"Supports Unreal Tournament 3 (v2.1). No context or identity support yet.");
}

static std::wstring description(L"Unreal Tournament 3 (v2.1)");
static std::wstring shortname(L"Unreal Tournament 3");

static int trylock1() {
	return trylock(std::multimap< std::wstring, unsigned long long int >());
}

static MumblePlugin ut3plug = { MUMBLE_PLUGIN_MAGIC, description, shortname, nullptr, nullptr, trylock1,
								generic_unlock,      longdesc,    fetch };

static MumblePlugin2 ut3plug2 = { MUMBLE_PLUGIN_MAGIC_2, MUMBLE_PLUGIN_VERSION, trylock };

extern "C" MUMBLE_PLUGIN_EXPORT MumblePlugin *getMumblePlugin() {
	return &ut3plug;
}

extern "C" MUMBLE_PLUGIN_EXPORT MumblePlugin2 *getMumblePlugin2() {
	return &ut3plug2;
}
