// Copyright (C) 2025 Rivos Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Autogenerated by the ProtoZero Rust compiler plugin.
// Invoked by contrib/rust-sdk/tools/gen_rust_protos
// DO NOT EDIT.

use crate::pb_enum;
use crate::pb_msg;
use crate::protos::common::builtin_clock::*;
use crate::protos::config::data_source_config::*;
use crate::protos::config::priority_boost::priority_boost_config::*;

pb_enum!(TraceConfigLockdownModeOperation {
    LOCKDOWN_UNCHANGED: 0,
    LOCKDOWN_CLEAR: 1,
    LOCKDOWN_SET: 2,
});

pb_enum!(TraceConfigCompressionType {
    COMPRESSION_TYPE_UNSPECIFIED: 0,
    COMPRESSION_TYPE_DEFLATE: 1,
});

pb_enum!(TraceConfigStatsdLogging {
    STATSD_LOGGING_UNSPECIFIED: 0,
    STATSD_LOGGING_ENABLED: 1,
    STATSD_LOGGING_DISABLED: 2,
});

pb_enum!(TraceFilterStringFilterPolicy {
    SFP_UNSPECIFIED: 0,
    SFP_MATCH_REDACT_GROUPS: 1,
    SFP_ATRACE_MATCH_REDACT_GROUPS: 2,
    SFP_MATCH_BREAK: 3,
    SFP_ATRACE_MATCH_BREAK: 4,
    SFP_ATRACE_REPEATED_SEARCH_REDACT_GROUPS: 5,
});

pb_enum!(TriggerConfigTriggerMode {
    UNSPECIFIED: 0,
    START_TRACING: 1,
    STOP_TRACING: 2,
    CLONE_SNAPSHOT: 4,
});

pb_enum!(BufferConfigFillPolicy {
    UNSPECIFIED: 0,
    RING_BUFFER: 1,
    DISCARD: 2,
});

pb_msg!(TraceConfig {
    buffers: BufferConfig, msg, 1,
    data_sources: DataSource, msg, 2,
    builtin_data_sources: BuiltinDataSource, msg, 20,
    duration_ms: u32, primitive, 3,
    prefer_suspend_clock_for_duration: bool, primitive, 36,
    enable_extra_guardrails: bool, primitive, 4,
    lockdown_mode: TraceConfigLockdownModeOperation, enum, 5,
    producers: ProducerConfig, msg, 6,
    statsd_metadata: StatsdMetadata, msg, 7,
    write_into_file: bool, primitive, 8,
    output_path: String, primitive, 29,
    file_write_period_ms: u32, primitive, 9,
    max_file_size_bytes: u64, primitive, 10,
    guardrail_overrides: GuardrailOverrides, msg, 11,
    deferred_start: bool, primitive, 12,
    flush_period_ms: u32, primitive, 13,
    flush_timeout_ms: u32, primitive, 14,
    data_source_stop_timeout_ms: u32, primitive, 23,
    notify_traceur: bool, primitive, 16,
    bugreport_score: i32, primitive, 30,
    bugreport_filename: String, primitive, 38,
    trigger_config: TriggerConfig, msg, 17,
    activate_triggers: String, primitive, 18,
    incremental_state_config: IncrementalStateConfig, msg, 21,
    allow_user_build_tracing: bool, primitive, 19,
    unique_session_name: String, primitive, 22,
    compression_type: TraceConfigCompressionType, enum, 24,
    incident_report_config: IncidentReportConfig, msg, 25,
    statsd_logging: TraceConfigStatsdLogging, enum, 31,
    trace_uuid_msb: i64, primitive, 27,
    trace_uuid_lsb: i64, primitive, 28,
    trace_filter: TraceFilter, msg, 33,
    android_report_config: AndroidReportConfig, msg, 34,
    cmd_trace_start_delay: CmdTraceStartDelay, msg, 35,
    session_semaphores: SessionSemaphore, msg, 39,
    priority_boost: PriorityBoostConfig, msg, 40,
    exclusive_prio: u32, primitive, 41,
    no_flush_before_write_into_file: bool, primitive, 42,
});

pb_msg!(SessionSemaphore {
    name: String, primitive, 1,
    max_other_session_count: u64, primitive, 2,
});

pb_msg!(CmdTraceStartDelay {
    min_delay_ms: u32, primitive, 1,
    max_delay_ms: u32, primitive, 2,
});

pb_msg!(AndroidReportConfig {
    reporter_service_package: String, primitive, 1,
    reporter_service_class: String, primitive, 2,
    skip_report: bool, primitive, 3,
    use_pipe_in_framework_for_testing: bool, primitive, 4,
});

pb_msg!(TraceFilter {
    bytecode: String, primitive, 1,
    bytecode_v2: String, primitive, 2,
    string_filter_chain: StringFilterChain, msg, 3,
});

pb_msg!(StringFilterChain {
    rules: StringFilterRule, msg, 1,
});

pb_msg!(StringFilterRule {
    policy: TraceFilterStringFilterPolicy, enum, 1,
    regex_pattern: String, primitive, 2,
    atrace_payload_starts_with: String, primitive, 3,
});

pb_msg!(IncidentReportConfig {
    destination_package: String, primitive, 1,
    destination_class: String, primitive, 2,
    privacy_level: i32, primitive, 3,
    skip_incidentd: bool, primitive, 5,
    skip_dropbox: bool, primitive, 4,
});

pb_msg!(IncrementalStateConfig {
    clear_period_ms: u32, primitive, 1,
});

pb_msg!(TriggerConfig {
    trigger_mode: TriggerConfigTriggerMode, enum, 1,
    use_clone_snapshot_if_available: bool, primitive, 5,
    triggers: Trigger, msg, 2,
    trigger_timeout_ms: u32, primitive, 3,
});

pb_msg!(Trigger {
    name: String, primitive, 1,
    producer_name_regex: String, primitive, 2,
    stop_delay_ms: u32, primitive, 3,
    max_per_24_h: u32, primitive, 4,
    skip_probability: f64, primitive, 5,
});

pb_msg!(GuardrailOverrides {
    max_upload_per_day_bytes: u64, primitive, 1,
    max_tracing_buffer_size_kb: u32, primitive, 2,
});

pb_msg!(StatsdMetadata {
    triggering_alert_id: i64, primitive, 1,
    triggering_config_uid: i32, primitive, 2,
    triggering_config_id: i64, primitive, 3,
    triggering_subscription_id: i64, primitive, 4,
});

pb_msg!(ProducerConfig {
    producer_name: String, primitive, 1,
    shm_size_kb: u32, primitive, 2,
    page_size_kb: u32, primitive, 3,
});

pb_msg!(BuiltinDataSource {
    disable_clock_snapshotting: bool, primitive, 1,
    disable_trace_config: bool, primitive, 2,
    disable_system_info: bool, primitive, 3,
    disable_service_events: bool, primitive, 4,
    primary_trace_clock: BuiltinClock, enum, 5,
    snapshot_interval_ms: u32, primitive, 6,
    prefer_suspend_clock_for_snapshot: bool, primitive, 7,
    disable_chunk_usage_histograms: bool, primitive, 8,
});

pb_msg!(DataSource {
    config: DataSourceConfig, msg, 1,
    producer_name_filter: String, primitive, 2,
    producer_name_regex_filter: String, primitive, 3,
    machine_name_filter: String, primitive, 4,
});

pb_msg!(BufferConfig {
    size_kb: u32, primitive, 1,
    fill_policy: BufferConfigFillPolicy, enum, 4,
    transfer_on_clone: bool, primitive, 5,
    clear_before_clone: bool, primitive, 6,
});
