% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/styles.R
\name{align}
\alias{align}
\alias{align_text_col}
\alias{align_nottext_col}
\title{Set text alignment}
\usage{
align(
  x,
  i = NULL,
  j = NULL,
  align = "left",
  part = c("body", "header", "footer", "all")
)

align_text_col(x, align = "left", header = TRUE, footer = TRUE)

align_nottext_col(x, align = "right", header = TRUE, footer = TRUE)
}
\arguments{
\item{x}{a 'flextable' object, see \link{flextable-package} to learn how to create
'flextable' object.}

\item{i}{row selector, see section \emph{Row selection with the \code{i} parameter}
in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.}

\item{j}{column selector, see section \emph{Column selection with the \code{j} parameter}
in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.}

\item{align}{text alignment - a single character value, or a vector of
character values equal in length to the number of columns selected by \code{j}.
Expected values must be from the set ('left', 'right', 'center', or 'justify').

If the number of columns is a multiple of the length of the \code{align} parameter,
then the values in \code{align} will be recycled across the remaining columns.}

\item{part}{part selector, see section \emph{Part selection with the \code{part}
parameter} in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.
Value 'all' can be used.}

\item{header}{should the header be aligned with the body}

\item{footer}{should the footer be aligned with the body}
}
\description{
Change the text alignment of selected rows and columns of a flextable.
}
\examples{
# Table of 6 columns
ft_car <- flextable(head(mtcars)[, 2:7])

# All 6 columns right aligned
align(ft_car, align = "right", part = "all")

# Manually specify alignment of each column
align(
  ft_car,
  align = c("left", "right", "left", "center", "center", "right"),
  part = "all"
)

# Center-align column 2 and left-align column 5
align(ft_car, j = c(2, 5), align = c("center", "left"), part = "all")

# Alternate left and center alignment across columns 1-4 for header only
align(ft_car, j = 1:4, align = c("left", "center"), part = "header")
ftab <- flextable(mtcars)
ftab <- align_text_col(ftab, align = "left")
ftab <- align_nottext_col(ftab, align = "right")
ftab
}
\seealso{
Other sugar functions for table style: 
\code{\link{bg}()},
\code{\link{bold}()},
\code{\link{color}()},
\code{\link{empty_blanks}()},
\code{\link{font}()},
\code{\link{fontsize}()},
\code{\link{highlight}()},
\code{\link{italic}()},
\code{\link{keep_with_next}()},
\code{\link{line_spacing}()},
\code{\link{padding}()},
\code{\link{rotate}()},
\code{\link{style}()},
\code{\link{tab_settings}()},
\code{\link{valign}()}
}
\concept{sugar functions for table style}
