% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flextable_sizes.R
\name{hrule}
\alias{hrule}
\title{Set how row heights are determined}
\usage{
hrule(x, i = NULL, rule = "auto", part = "body")
}
\arguments{
\item{x}{a 'flextable' object, see \link{flextable-package} to learn how to create
'flextable' object.}

\item{i}{row selector, see section \emph{Row selection with the \code{i} parameter}
in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.}

\item{rule}{specify the meaning of the height. Possible values
are "atleast" (height should be at least the value specified), "exact"
(height should be exactly the value specified), or the default value "auto"
(height is determined based on the height of the contents, so the value is ignored).}

\item{part}{part selector, see section \emph{Part selection with the \code{part}
parameter} in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.
Value 'all' can be used.}
}
\description{
\code{hrule()} controls whether row heights are automatic,
minimum or fixed. This only affects Word and PowerPoint
outputs; it has no effect on HTML or PDF.
\itemize{
\item \code{"auto"} (default): the row height adjusts to fit the
content; any value set by \code{\link[=height]{height()}} is ignored.
\item \code{"atleast"}: the row is at least as tall as the value
set by \code{\link[=height]{height()}}, but can grow if the content is taller.
\item \code{"exact"}: the row is exactly the height set by
\code{\link[=height]{height()}}; content that overflows is clipped.
}

For PDF see the \code{ft.arraystretch} chunk option.
}
\examples{

ft_1 <- flextable(head(iris))
ft_1 <- width(ft_1, width = 1.5)
ft_1 <- height(ft_1, height = 0.75, part = "header")
ft_1 <- hrule(ft_1, rule = "exact", part = "header")
ft_1

ft_2 <- hrule(ft_1, rule = "auto", part = "header")
ft_2
}
\seealso{
Other functions for flextable size management: 
\code{\link{autofit}()},
\code{\link{dim.flextable}()},
\code{\link{dim_pretty}()},
\code{\link{fit_to_width}()},
\code{\link{flextable_dim}()},
\code{\link{height}()},
\code{\link{ncol_keys}()},
\code{\link{nrow_part}()},
\code{\link{width}()}
}
\concept{functions for flextable size management}
