% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{ci2ms}
\alias{ci2ms}
\title{Effect size and standard error from confidence interval}
\usage{
ci2ms(ci, logscale = TRUE, alpha = 0.05)
}
\arguments{
\item{ci}{confidence interval (CI). The delimiter between lower and upper limit is either a hyphen (-) or en dash (\enc{–}{-}).}

\item{logscale}{a flag indicating the confidence interval is based on a log-scale.}

\item{alpha}{Type 1 error.}
}
\value{
Based on CI, the function provides a list containing estimates
\itemize{
\item m effect size (log(OR))
\item s standard error
\item direction a decrease/increase (-/+) sign such that \code{sign(m)}=-1, 0, 1, is labelled "-", "0", "+", respectively as in PhenoScanner.
}
}
\description{
Effect size and standard error from confidence interval
}
\details{
Effect size is a measure of strength of the relationship between two variables in a population or parameter estimate of that population.
Without loss of generality, denote \code{m} and \code{s} to be the mean and standard deviation of a sample from \eqn{N(\mu,\sigma^2)}{N(mu,sigma^2}).
Let \eqn{z \sim N(0,1)}{z ~ N(0,1)} with cutoff point \eqn{z_\alpha}{z_alpha}, confidence limits \code{L}, \code{U} in a CI are defined as follows,
\deqn{
\begin{aligned}
L & = m - z_\alpha s \cr
U & = m + z_\alpha s
\end{aligned}
}{L = m - z_alpha s, U = m + z_alpha s}
\eqn{\Rightarrow}{==>} \eqn{U + L = 2 m}, \eqn{U - L=2 z_\alpha s}{U - L = 2 z_alpha s}. Consequently,
\deqn{
\begin{aligned}
m & = \frac{U + L}{2} \cr
s & = \frac{U - L}{2 z_\alpha}
\end{aligned}
}{m = (U + L)/2, s = (U - L)/(2 z_alpha)}
Effect size in epidemiological studies on a binary outcome is typically reported as odds ratio from a logistic regression
or hazard ratio from a Cox regression, \eqn{L\equiv\log(L)}{L ==> log(L)}, \eqn{U\equiv\log(U)}{U ==> log(U)}.
}
\examples{
# rs3784099 and breast cancer recurrence/mortality
ms <- ci2ms("1.28-1.72")
print(ms)
# Vector input
ci2 <- c("1.28-1.72","1.25-1.64")
ms2 <- ci2ms(ci2)
print(ms2)
}
