% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validation.R
\name{validate_no_formula_duplication}
\alias{validate_no_formula_duplication}
\alias{check_no_formula_duplication}
\title{Ensure no duplicate terms appear in \code{formula}}
\usage{
validate_no_formula_duplication(formula, original = FALSE)

check_no_formula_duplication(formula, original = FALSE)
}
\arguments{
\item{formula}{A formula to check.}

\item{original}{A logical. Should the original names be checked, or should
the names after processing be used? If \code{FALSE}, \code{y ~ log(y)} is allowed
because the names are \code{"y"} and \code{"log(y)"}, if \code{TRUE}, \code{y ~ log(y)} is not
allowed because the original names are both \code{"y"}.}
}
\value{
\code{validate_no_formula_duplication()} returns \code{formula} invisibly.

\code{check_no_formula_duplication()} returns a named list of two components,
\code{ok} and \code{duplicates}.
}
\description{
validate - asserts the following:
\itemize{
\item \code{formula} must not have duplicates terms on the left and right hand
side of the formula.
}

check - returns the following:
\itemize{
\item \code{ok} A logical. Does the check pass?
\item \code{duplicates} A character vector. The duplicate terms.
}
}
\section{Validation}{


hardhat provides validation functions at two levels.
\itemize{
\item \verb{check_*()}:  \emph{check a condition, and return a list}. The list
always contains at least one element, \code{ok}, a logical that specifies if the
check passed. Each check also has check specific elements in the returned
list that can be used to construct meaningful error messages.
\item \verb{validate_*()}: \emph{check a condition, and error if it does not pass}. These
functions call their corresponding check function, and
then provide a default error message. If you, as a developer, want a
different error message, then call the \verb{check_*()} function yourself,
and provide your own validation function.
}
}

\examples{
# All good
check_no_formula_duplication(y ~ x)

# Not good!
check_no_formula_duplication(y ~ y)

# This is generally okay
check_no_formula_duplication(y ~ log(y))

# But you can be more strict
check_no_formula_duplication(y ~ log(y), original = TRUE)

# This would throw an error
try(validate_no_formula_duplication(log(y) ~ log(y)))
}
\seealso{
Other validation functions: 
\code{\link{validate_column_names}()},
\code{\link{validate_outcomes_are_binary}()},
\code{\link{validate_outcomes_are_factors}()},
\code{\link{validate_outcomes_are_numeric}()},
\code{\link{validate_outcomes_are_univariate}()},
\code{\link{validate_prediction_size}()},
\code{\link{validate_predictors_are_numeric}()}
}
\concept{validation functions}
