% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install_DevelopmentVersion.R
\name{install_DevelopmentVersion}
\alias{install_DevelopmentVersion}
\title{Attempts to install the development version of the 'Luminescence' package}
\usage{
install_DevelopmentVersion(force_install = FALSE, branch = "master")
}
\arguments{
\item{force_install}{\link{logical} (\emph{optional}):
If \code{FALSE} (the default) the function produces and prints the required
code to the console for the user to run manually afterwards. When \code{TRUE}
and all requirements are fulfilled (see details) this function attempts to install
the package itself.}

\item{branch}{\link{character} (\emph{with default}):
Name of the branch to install. The default value ("master") corresponds to
the main development branch.}
}
\value{
This function requires user input at the command prompt to choose the
desired development branch to be installed. The required R code to install
the package is then printed to the console.
}
\description{
This function provides a convenient method for installing the development
version of the R package 'Luminescence' directly from GitHub.
}
\details{
This function checks whether the 'devtools' package is currently installed
on the system. If \code{force_install = TRUE} the functions attempts to install
the chosen development branch via \link[devtools:remote-reexports]{devtools::install_github}.
}
\examples{
\dontrun{
install_DevelopmentVersion()
}

}
