% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/sketching.R
\name{LeverageScore}
\alias{LeverageScore}
\alias{LeverageScore.default}
\alias{LeverageScore.StdAssay}
\alias{LeverageScore.Assay}
\alias{LeverageScore.Seurat}
\title{Leverage Score Calculation}
\usage{
LeverageScore(object, ...)

\method{LeverageScore}{default}(
  object,
  nsketch = 5000L,
  ndims = NULL,
  method = CountSketch,
  eps = 0.5,
  seed = 123L,
  verbose = TRUE,
  ...
)

\method{LeverageScore}{StdAssay}(
  object,
  nsketch = 5000L,
  ndims = NULL,
  method = CountSketch,
  vf.method = NULL,
  layer = "data",
  eps = 0.5,
  seed = 123L,
  verbose = TRUE,
  features = NULL,
  ...
)

\method{LeverageScore}{Assay}(
  object,
  nsketch = 5000L,
  ndims = NULL,
  method = CountSketch,
  vf.method = NULL,
  layer = "data",
  eps = 0.5,
  seed = 123L,
  verbose = TRUE,
  features = NULL,
  ...
)

\method{LeverageScore}{Seurat}(
  object,
  assay = NULL,
  nsketch = 5000L,
  ndims = NULL,
  var.name = "leverage.score",
  over.write = FALSE,
  method = CountSketch,
  vf.method = NULL,
  layer = "data",
  eps = 0.5,
  seed = 123L,
  verbose = TRUE,
  features = NULL,
  ...
)
}
\arguments{
\item{object}{A matrix-like object}

\item{...}{Arguments passed to other methods}

\item{nsketch}{A positive integer. The number of sketches to be used in the approximation.
Default is 5000.}

\item{ndims}{A positive integer or NULL. The number of dimensions to use. If NULL, the number
of dimensions will default to the number of columns in the object.}

\item{method}{The sketching method to use, defaults to CountSketch.}

\item{eps}{A numeric. The error tolerance for the approximation in Johnson–Lindenstrauss embeddings,
defaults to 0.5.}

\item{seed}{A positive integer. The seed for the random number generator, defaults to 123.}

\item{verbose}{Print progress and diagnostic messages}

\item{vf.method}{VariableFeatures method}

\item{layer}{layer to use}

\item{features}{A vector of feature names to use for calculating leverage score.}

\item{assay}{assay to use}

\item{var.name}{name of slot to store leverage scores}

\item{over.write}{whether to overwrite slot that currently stores leverage scores. Defaults
to FALSE, in which case the 'var.name' is modified if it already exists in the object}
}
\description{
This function computes the leverage scores for a given object
It uses the concept of sketching and random projections. The function provides an approximation 
to the leverage scores using a scalable method suitable for large matrices.
}
\references{
Clarkson, K. L. & Woodruff, D. P.
Low-rank approximation and regression in input sparsity time.
JACM 63, 1–45 (2017). \doi{10.1145/3019134};
}
\concept{sketching}
