## ROCm known issues

ROCm known issues are noted on {fab}`github` [GitHub](https://github.com/ROCm/ROCm/labels/Verified%20Issue). For known
issues related to individual components, review the [Detailed component changes](detailed-component-changes).

### Default processor affinity behavior for helper threads 

Processor affinity is a critical setting to ensure that ROCm helper threads run on the correct cores. By default, ROCm
helper threads are spawned on all available cores, ignoring the parent thread’s processor affinity. This can lead to
threads competing for available cores, which may result in suboptimal performance. This behavior occurs by default if
the environment variable `HSA_OVERRIDE_CPU_AFFINITY_DEBUG` is not set or is set to `1`. If
`HSA_OVERRIDE_CPU_AFFINITY_DEBUG` is set to `0`, the ROCr runtime uses the parent process's core affinity mask when
creating helper threads. The parent’s affinity mask should then be set to account for the presence of additional threads
by ensuring the affinity mask contains enough cores. Depending on the affinity settings of the software environment,
batch system, launch commands like `numactl`/`taskset`, or explicit mask manipulation by the application itself, changing
the setting may be advantageous to performance.

To ensure the parent's core affinity mask is honored by the ROCm helper threads, set the
`HSA_OVERRIDE_CPU_AFFINITY_DEBUG` environment variable as follows:

```{code} shell
export HSA_OVERRIDE_CPU_AFFINITY_DEBUG=0
```

To ensure ROCm helper threads run on all available cores, set the `HSA_OVERRIDE_CPU_AFFINITY_DEBUG` environment variable
as follows:

``` shell
export HSA_OVERRIDE_CPU_AFFINITY_DEBUG=1
```

Or the default:

``` shell

unset HSA_OVERRIDE_CPU_AFFINITY_DEBUG
```

If unsure of the default processor affinity settings for your environment, run the following command from the shell:

``` shell

bash -c "echo taskset -p \$\$" 
```

See [issue #3493](https://github.com/ROCm/ROCm/issues/3493) on GitHub.

### Display issues on servers with Instinct MI300-Series GPUs when loading AMDGPU driver

AMD Instinct MI300-Series GPUs and third-party GPUs such as the Matrox G200 have an issue impacting video
output. The issue was reproduced on a Dell server model PowerEdge XE9680. Servers from other vendors utilizing Matrox
G200 cards may be impacted as well. This issue was found with ROCm 6.2.0 but is present in older ROCm versions.

The AMDGPU driver shipped with ROCm interferes with the operation of the display card video output. On Dell systems,
this includes both the local video output and remote access via iDRAC. The display appears blank (black) after loading
the `amdgpu` driver modules. Video output impacts both terminal access when running in `runlevel 3` and GUI access when
running in `runlevel 5`. Server functionality can still be accessed via SSH or other remote connection methods.

See [issue #3494](https://github.com/ROCm/ROCm/issues/3494) on GitHub.

### KFDTest failure on Instinct MI300X with Oracle Linux 8.9

The `KFDEvictTest.QueueTest` is failing on the MI300X platform during KFD (Kernel Fusion Driver) tests, causing the full
suite to not execute properly. This issue is suspected to be hardware-related.

See [issue #3495](https://github.com/ROCm/ROCm/issues/3495) on GitHub.

### Bandwidth limitation in gang and non-gang modes on Instinct MI300A

Expected target peak non-gang performance (~60GB/s) and target peak gang performance (~90GB/s) are not achieved. Both gang
and non-gang performance are observed to be limited at 45GB/s.

This issue will be addressed in a future ROCm release.

See [issue #3496](https://github.com/ROCm/ROCm/issues/3496) on GitHub.

### rocm-llvm-alt

ROCm provides an optional package -- `rocm-llvm-alt` -- that provides a closed-source compiler for
users interested in additional closed-source CPU optimizations. This feature is not functional in
the ROCm 6.2.0 release. Users who attempt to invoke the closed-source compiler will experience an
LLVM consumer-producer mismatch and the compilation will fail. There is no workaround that allows
use of the closed-source compiler. It is recommended to compile using the default open-source
compiler, which generates high-quality AMD CPU and AMD GPU code.

See [issue #3492](https://github.com/ROCm/ROCm/issues/3492) on GitHub.
